/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSmartCastExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecatedSmartCastChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecatedSmartCastChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker\n+ 2 FirReferenceUtils.kt\norg/jetbrains/kotlin/fir/references/FirReferenceUtilsKt\n*L\n1#1,34:1\n29#2,7:35\n*S KotlinDebug\n*F\n+ 1 FirDeprecatedSmartCastChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecatedSmartCastChecker\n*L\n28#1:35,7\n*E\n"})
public final class FirDeprecatedSmartCastChecker
extends FirExpressionChecker<FirSmartCastExpression> {
    @NotNull
    public static final FirDeprecatedSmartCastChecker INSTANCE = new FirDeprecatedSmartCastChecker();

    private FirDeprecatedSmartCastChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirSmartCastExpression expression2) {
        Object object;
        KtSourceElement source;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.UnstableSmartcastOnDelegatedProperties)) {
                    return;
                }
                if (!expression2.isStable()) {
                    return;
                }
                KtSourceElement ktSourceElement = expression2.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                object = ReferenceUtilsKt.toReference(expression2.getOriginalExpression(), context2.getSession());
                if (object == null) break block8;
                FirReference $this$toResolvedSymbol_u24default$iv = object;
                boolean discardErrorReference$iv = false;
                boolean $i$f$toResolvedSymbol = false;
                FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
                FirBasedSymbol<Object> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
                if (!(firBasedSymbol instanceof FirPropertySymbol)) {
                    firBasedSymbol = null;
                }
                if ((object = (FirPropertySymbol)((FirBasedSymbol)((FirPropertySymbol)firBasedSymbol))) != null) break block9;
            }
            return;
        }
        Object symbol = object;
        if (ClassMembersKt.isDelegated((FirCallableSymbol)symbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATED_SMARTCAST_ON_DELEGATED_PROPERTY(), (Object)FirTypeUtilsKt.getResolvedType(expression2), symbol, null, 32, null);
        }
    }
}

