/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardChecker;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.execution.dashboard.RunDashboardCheckerActivityKt;
import com.intellij.ui.UIBundle;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/dashboard/RunDashboardCheckerActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "migrateNotificationProperty", "", "RunDashboardListener", "intellij.platform.execution.dashboard"})
public final class RunDashboardCheckerActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || project.isDisposed()) {
            return Unit.INSTANCE;
        }
        if (this.migrateNotificationProperty(project)) {
            return Unit.INSTANCE;
        }
        RunDashboardListener listener = new RunDashboardListener(project);
        if (!listener.isEnabled()) {
            return Unit.INSTANCE;
        }
        listener.checkAvailability();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener);
        return Unit.INSTANCE;
    }

    private final boolean migrateNotificationProperty(Project project) {
        boolean isEnabled = PropertiesComponent.getInstance((Project)project).getBoolean("show.run.dashboard.notification", true);
        if (isEnabled) {
            return false;
        }
        PropertiesComponent.getInstance((Project)project).setValue("show.run.dashboard.notification", true, true);
        PropertiesComponent.getInstance((Project)project).setValue("run.configurations.included.in.services", true, false);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/execution/dashboard/RunDashboardCheckerActivity$RunDashboardListener;", "Lcom/intellij/execution/RunManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isEnabled", "", "checkAvailability", "getTypeDisplayName", "", "typeId", "showInServices", "", "types", "", "removeFromServices", "createNotification", "Lcom/intellij/notification/Notification;", "typeDisplayNames", "intellij.platform.execution.dashboard"})
    @SourceDebugExtension(value={"SMAP\nRunDashboardCheckerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDashboardCheckerActivity.kt\ncom/intellij/platform/execution/dashboard/RunDashboardCheckerActivity$RunDashboardListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1563#2:134\n1634#2,3:135\n1563#2:138\n1634#2,3:139\n1#3:142\n*S KotlinDebug\n*F\n+ 1 RunDashboardCheckerActivity.kt\ncom/intellij/platform/execution/dashboard/RunDashboardCheckerActivity$RunDashboardListener\n*L\n84#1:134\n84#1:135,3\n88#1:138\n88#1:139,3\n*E\n"})
    private static final class RunDashboardListener
    implements RunManagerListener {
        @NotNull
        private final Project project;

        public RunDashboardListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (!this.isEnabled()) {
                return;
            }
            this.checkAvailability();
        }

        public final boolean isEnabled() {
            boolean included = PropertiesComponent.getInstance((Project)this.project).getBoolean("run.configurations.included.in.services", false);
            if (included) {
                return false;
            }
            return this.createNotification(SetsKt.emptySet(), "").canShowFor(this.project);
        }

        /*
         * WARNING - void declaration
         */
        public final void checkAvailability() {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Object t2;
            HashSet<String> typesToDisplay = new HashSet<String>();
            Iterable iterable = RunDashboardCheckerActivityKt.access$getCHECKER_EP_NAME$p().getExtensionList();
            int n = 0;
            for (Object t2 : iterable) {
                void it;
                RunDashboardChecker runDashboardChecker = (RunDashboardChecker)t2;
                int n2 = n;
                boolean bl = false;
                int count = it.countUniqueConfigurations(this.project);
                if (count > 0) {
                    typesToDisplay.add(it.getTypeId());
                }
                int n3 = count;
                n = n2 + n3;
            }
            int count = n;
            if (count < RunDashboardCheckerActivityKt.access$getSwitchLimit()) {
                return;
            }
            PropertiesComponent.getInstance((Project)this.project).setValue("run.configurations.included.in.services", true, false);
            Iterable iterable2 = RunDashboardCheckerActivityKt.access$getCHECKER_EP_NAME$p().getExtensionList();
            Object object = this;
            boolean $i$f$map = false;
            t2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                RunDashboardChecker runDashboardChecker = (RunDashboardChecker)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTypeId());
            }
            Collection<String> types = ((RunDashboardListener)object).showInServices((List)destination$iv$iv);
            typesToDisplay.retainAll(types);
            if (typesToDisplay.isEmpty()) {
                return;
            }
            Iterable $this$map$iv2 = typesToDisplay;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(this.getTypeDisplayName((String)it));
            }
            String string = StringUtil.join((Collection)((List)destination$iv$iv2), (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String typeDisplayNames = string;
            this.createNotification(types, typeDisplayNames).notify(this.project);
        }

        private final String getTypeDisplayName(String typeId) {
            boolean bl;
            Object v0;
            Object object;
            block2: {
                object = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    ConfigurationType it = (ConfigurationType)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)typeId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ConfigurationType configurationType = v0;
            boolean bl3 = bl = configurationType != null;
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            ConfigurationType configurationType2 = configurationType;
            Intrinsics.checkNotNull((Object)configurationType2);
            String string = configurationType2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }

        private final Collection<String> showInServices(List<String> types) {
            HashSet<String> result = new HashSet<String>();
            RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.project);
            HashSet<String> newTypes = new HashSet<String>(dashboardManager.getTypes());
            for (String type : types) {
                if (!newTypes.add(type)) continue;
                result.add(type);
            }
            dashboardManager.setTypes((Set)newTypes);
            return result;
        }

        private final void removeFromServices(Collection<String> types) {
            RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.project);
            HashSet newTypes = new HashSet(dashboardManager.getTypes());
            newTypes.removeAll(types);
            dashboardManager.setTypes((Set)newTypes);
        }

        private final Notification createNotification(Collection<String> types, String typeDisplayNames) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Services Tool Window");
            Object[] objectArray = new Object[]{typeDisplayNames, UIBundle.message((String)"tool.window.name.services", (Object[])new Object[0])};
            String string = ExecutionBundle.message((String)"run.dashboard.multiple.run.config.notification", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = ExecutionBundle.message((String)"run.dashboard.do.not.use.services.action", (Object[])new Object[0]);
            Notification notification = notificationGroup.createNotification(string, NotificationType.INFORMATION).setDisplayId("run.dashboard.multiple.run.configurations").setIcon(AllIcons.Nodes.Services).addAction((AnAction)new NotificationAction(this, types, string2){
                final /* synthetic */ RunDashboardListener this$0;
                final /* synthetic */ Collection<String> $types;
                {
                    this.this$0 = $receiver;
                    this.$types = $types;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    RunDashboardListener.access$removeFromServices(this.this$0, this.$types);
                    notification.expire();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
            return notification;
        }

        public static final /* synthetic */ void access$removeFromServices(RunDashboardListener $this, Collection types) {
            $this.removeFromServices(types);
        }
    }
}

