/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.SuspendCallArgumentKind;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.InlineStatus;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J4\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0002H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010 \u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u001d*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,H\u0002J8\u0010-\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0006\u0012\u0004\u0018\u00010%0.*\u00020\u00022\u0006\u0010&\u001a\u00020'2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J,\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "BUILTIN_SUSPEND_NAME", "Lorg/jetbrains/kotlin/name/Name;", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers", "()Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuspendModifierForm", "reference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "formOfSuspendModifierForLambdaOrFun", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/SuspendCallArgumentKind;", "findEnclosingSuspendFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isInScopeForDefaultParameterValues", "", "enclosingSuspendFunction", "checkNonLocalReturnUsage", "checkRestrictsSuspension", "calledDeclarationSymbol", "isCaseMissedByK1", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "isRestrictSuspensionReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwnerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "computeReceiversInfo", "Lkotlin/Triple;", "checkCallableReference", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,341:1\n31#2:342\n1761#3,3:343\n543#3,4:349\n548#3:355\n774#3:357\n865#3,2:358\n1761#3,3:361\n1761#3,3:364\n43#4:346\n43#4:348\n43#4:360\n1#5:347\n53#6:353\n53#6:354\n40#6:356\n*S KotlinDebug\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n*L\n56#1:342\n119#1:343,3\n143#1:349,4\n143#1:355\n263#1:357\n263#1:358,2\n277#1:361,3\n280#1:364,3\n120#1:346\n130#1:348\n267#1:360\n146#1:353\n148#1:354\n161#1:356\n*E\n"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();
    @NotNull
    private static final Name BUILTIN_SUSPEND_NAME = StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName();
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID = new CallableId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), BUILTIN_SUSPEND_NAME);

    private FirSuspendCallChecker() {
        super(MppCheckerKind.Common);
    }

    @NotNull
    public final CallableId getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers() {
        return KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirFunction enclosingSuspendFunction;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirCallableSymbol firCallableSymbol = reference2.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol : null;
        if (firCallableSymbol2 == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol2;
        if (Intrinsics.areEqual(reference2.getName(), BUILTIN_SUSPEND_NAME) || symbol instanceof FirNamedFunctionSymbol && Intrinsics.areEqual(((FirNamedFunctionSymbol)symbol).getName(), BUILTIN_SUSPEND_NAME)) {
            this.checkSuspendModifierForm(expression2, reference2, symbol, context, reporter);
        }
        if (reference2 instanceof FirResolvedCallableReference) {
            this.checkCallableReference(expression2, symbol, reporter, context);
            return;
        }
        FirCallableSymbol firCallableSymbol3 = symbol;
        if (firCallableSymbol3 instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isSuspend$iv = symbol;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
                return;
            }
        } else if (firCallableSymbol3 instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual(((FirPropertySymbol)symbol).getCallableId(), StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context)) == null) {
            firCallableSymbol = symbol;
            if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), (Object)symbol, (DiagnosticContext)context, null, 16, null);
            } else if (firCallableSymbol instanceof FirPropertySymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), (Object)symbol, (DiagnosticContext)context, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(enclosingSuspendFunction, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), (DiagnosticContext)context, null, 8, null);
            }
            if (this.isInScopeForDefaultParameterValues(enclosingSuspendFunction, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"suspend function calls in a context of default parameter value", (DiagnosticContext)context, null, 16, null);
            }
            if (!this.checkRestrictsSuspension(expression2, enclosingSuspendFunction, symbol, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference2, FirCallableSymbol<?> symbol, CheckerContext context, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual(symbol.getCallableId(), KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID)) {
            if (!Intrinsics.areEqual(reference2.getName(), BUILTIN_SUSPEND_NAME) || expression2.getExplicitReceiver() != null || this.formOfSuspendModifierForLambdaOrFun(expression2) == null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (Intrinsics.areEqual(reference2.getName(), BUILTIN_SUSPEND_NAME)) {
            SuspendCallArgumentKind suspendCallArgumentKind = this.formOfSuspendModifierForLambdaOrFun(expression2);
            switch (suspendCallArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suspendCallArgumentKind.ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SuspendCallArgumentKind formOfSuspendModifierForLambdaOrFun(FirQualifiedAccessExpression $this$formOfSuspendModifierForLambdaOrFun) {
        boolean bl;
        block19: {
            if (!($this$formOfSuspendModifierForLambdaOrFun instanceof FirFunctionCall)) {
                return null;
            }
            FirNamedReference reference2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getCalleeReference();
            if (reference2 instanceof FirResolvedCallableReference) {
                return null;
            }
            Iterable $this$any$iv = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!FirHelpersKt.isExplicit(it)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
        boolean $i$f$getArguments = false;
        FirStatement it = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        boolean bl3 = false;
        boolean bl4 = it instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)it).isTrailingLambda();
        if (bl4) {
            KtSourceElement ktSourceElement;
            KtSourceElement callExpressionSource;
            KtSourceElement ktSourceElement2;
            if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getExplicitReceiver() == null) {
                ktSourceElement2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
            } else {
                KtSourceElement ktSourceElement3 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement3 != null) {
                    IElementType iElementType = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "CALL_EXPRESSION");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, iElementType, 1, 1, false, 8, null);
                } else {
                    ktSourceElement2 = null;
                }
            }
            KtSourceElement ktSourceElement4 = callExpressionSource = ktSourceElement2;
            if (ktSourceElement4 != null) {
                IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue(iElementType, "VALUE_ARGUMENT_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement4, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement == null) {
                return SuspendCallArgumentKind.LAMBDA;
            }
        }
        if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getOrigin() == FirFunctionCallOrigin.Infix) {
            void $this$arguments$iv2;
            it = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
            boolean $i$f$getArguments2 = false;
            FirExpression lastArgument = CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                KtSourceElement ktSourceElement;
                KtSourceElement ktSourceElement5 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement5 != null) {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "PARENTHESIZED");
                    ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement5, iElementType, 0, 1, false, 10, null);
                } else {
                    ktSourceElement = null;
                }
                if (ktSourceElement == null) {
                    Object object = ((FirAnonymousFunctionExpression)lastArgument).getSource();
                    return Intrinsics.areEqual(object != null && (object = ((KtSourceElement)object).getLighterASTNode()) != null ? object.getTokenType() : null, KtStubElementTypes.FUNCTION) ? SuspendCallArgumentKind.FUN : SuspendCallArgumentKind.LAMBDA;
                }
            }
        }
        return null;
    }

    private final FirFunction findEnclosingSuspendFunction(CheckerContext context) {
        FirDeclaration firDeclaration;
        block7: {
            List<FirDeclaration> $this$lastOrNull$iv = context.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean $i$f$isSuspend;
                FirMemberDeclaration $this$isSuspend$iv;
                boolean bl;
                FirDeclaration element$iv;
                FirDeclaration it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                FirDeclaration firDeclaration2 = it;
                if (firDeclaration2 instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)it).isLambda()) {
                        bl = FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getConeType(((FirAnonymousFunction)it).getTypeRef()), context.getSession());
                    } else {
                        $this$isSuspend$iv = (FirMemberDeclaration)it;
                        $i$f$isSuspend = false;
                        bl = $this$isSuspend$iv.getStatus().isSuspend();
                    }
                } else if (firDeclaration2 instanceof FirSimpleFunction) {
                    $this$isSuspend$iv = (FirMemberDeclaration)it;
                    $i$f$isSuspend = false;
                    bl = $this$isSuspend$iv.getStatus().isSuspend();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                firDeclaration = element$iv;
                break block7;
            }
            firDeclaration = null;
        }
        FirDeclaration firDeclaration3 = firDeclaration;
        return firDeclaration3 instanceof FirFunction ? (FirFunction)firDeclaration3 : null;
    }

    private final boolean isInScopeForDefaultParameterValues(FirFunction enclosingSuspendFunction, CheckerContext context) {
        List<FirValueParameter> valueParameters = enclosingSuspendFunction.getValueParameters();
        for (FirDeclaration declaration : CollectionsKt.asReversed(context.getContainingDeclarations())) {
            if (declaration instanceof FirValueParameter && valueParameters.contains(declaration) && ((FirValueParameter)declaration).getDefaultValue() != null) {
                return true;
            }
            if (declaration instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration).getInlineStatus() == InlineStatus.Inline || !(declaration instanceof FirFunction)) continue;
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) continue;
            return false;
        }
        return false;
    }

    private final boolean checkNonLocalReturnUsage(FirFunction enclosingSuspendFunction, CheckerContext context) {
        for (FirDeclaration declaration : CollectionsKt.asReversed(context.getContainingDeclarations())) {
            if (Intrinsics.areEqual(declaration, enclosingSuspendFunction)) {
                return true;
            }
            if (declaration instanceof FirProperty && ((FirProperty)declaration).isLocal() || declaration instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration).getInlineStatus().getReturnAllowed() || declaration instanceof FirValueParameter) continue;
            return false;
        }
        return false;
    }

    private final boolean checkRestrictsSuspension(FirQualifiedAccessExpression expression2, FirFunction enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol, CheckerContext context) {
        if (expression2 instanceof FirFunctionCall && this.isCaseMissedByK1((FirFunctionCall)expression2)) {
            return true;
        }
        FirSession session2 = context.getSession();
        Object object = enclosingSuspendFunction.getDispatchReceiverType();
        FirRegularClassSymbol enclosingSuspendFunctionDispatchReceiverOwnerSymbol = object != null && (object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny((ConeKotlinType)object)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, session2) : null;
        FirReceiverParameter firReceiverParameter = enclosingSuspendFunction.getReceiverParameter();
        FirReceiverParameterSymbol enclosingSuspendFunctionExtensionReceiverSymbol = firReceiverParameter != null ? firReceiverParameter.getSymbol() : null;
        Triple<FirExpression, FirExpression, ConeKotlinType> triple = this.computeReceiversInfo(expression2, session2, calledDeclarationSymbol);
        FirExpression dispatchReceiverExpression = triple.component1();
        FirExpression extensionReceiverExpression = triple.component2();
        ConeKotlinType extensionReceiverParameterType = triple.component3();
        FirExpression[] firExpressionArray = new FirExpression[]{dispatchReceiverExpression, extensionReceiverExpression};
        for (FirExpression receiverExpression : CollectionsKt.listOfNotNull(firExpressionArray)) {
            if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getResolvedType(receiverExpression), session2) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionDispatchReceiverOwnerSymbol) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) continue;
            return false;
        }
        Object object2 = enclosingSuspendFunctionExtensionReceiverSymbol;
        if (!(object2 != null && (object2 = ((FirReceiverParameterSymbol)object2).getResolvedType()) != null ? this.isRestrictSuspensionReceiver((ConeKotlinType)object2, session2) : false)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(dispatchReceiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(extensionReceiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) {
            ConeKotlinType coneKotlinType = extensionReceiverParameterType;
            boolean bl = coneKotlinType != null ? this.isRestrictSuspensionReceiver(coneKotlinType, session2) : false;
            if (bl) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCaseMissedByK1(FirFunctionCall expression2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!(expression2 instanceof FirImplicitInvokeCall)) return false;
        FirExpression firExpression = ((FirImplicitInvokeCall)expression2).getExplicitReceiver();
        Object object = firExpression;
        if (firExpression == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!CompilerConeAttributesKt.isExtensionFunctionType((ConeKotlinType)object)) return false;
        boolean bl = true;
        if (!bl) return false;
        boolean bl2 = true;
        boolean isInvokeFromExtensionFunctionType = bl2;
        if (!isInvokeFromExtensionFunctionType) {
            return false;
        }
        KtSourceElement ktSourceElement = ((FirImplicitInvokeCall)expression2).getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
        Intrinsics.checkNotNullExpressionValue(iElementType, "VALUE_ARGUMENT_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 == null) return false;
        LighterASTNode lighterASTNode = ktSourceElement2.getLighterASTNode();
        if (lighterASTNode == null) return false;
        List<LighterASTNode> list = LightTreeUtilsKt.getChildren(lighterASTNode, source.getTreeStructure());
        if (list == null) return false;
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.VALUE_ARGUMENT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int visualValueArgumentsCount = ((List)destination$iv$iv).size();
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        if (visualValueArgumentsCount == ((Collection)$this$arguments$iv.getArgumentList().getArguments()).size() - 1) return false;
        return true;
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session2) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl;
            block10: {
                FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session2, null, 2, null).getLookupTag(), session2);
                if (firRegularClassSymbol == null) {
                    return false;
                }
                FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
                if (FirAnnotationUtilsKt.getAnnotationByClassId(regularClassSymbol, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension(), session2) != null) {
                    return true;
                }
                Iterable $this$any$iv = regularClassSymbol.getResolvedSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it, session2)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it.getConeType(), session2)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirBasedSymbol<?> declarationSiteReceiverOwnerSymbol) {
        if (declarationSiteReceiverOwnerSymbol == null || useSiteReceiverExpression == null) {
            return false;
        }
        if (useSiteReceiverExpression instanceof FirThisReceiverExpression) {
            return Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwnerSymbol);
        }
        return false;
    }

    private final Triple<FirExpression, FirExpression, ConeKotlinType> computeReceiversInfo(FirQualifiedAccessExpression $this$computeReceiversInfo, FirSession session2, FirCallableSymbol<?> calledDeclarationSymbol) {
        FirExpression dispatchReceiver = $this$computeReceiversInfo.getDispatchReceiver();
        if ($this$computeReceiversInfo instanceof FirImplicitInvokeCall && dispatchReceiver != null && FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getResolvedType(dispatchReceiver), session2)) {
            ConeTypeProjection coneTypeProjection;
            FirExpression variableForInvoke = dispatchReceiver;
            ConeKotlinType variableForInvokeType = FirTypeUtilsKt.getResolvedType(variableForInvoke);
            if (!CompilerConeAttributesKt.isExtensionFunctionType(variableForInvokeType)) {
                return new Triple<Object, Object, Object>(null, null, null);
            }
            return new Triple<Object, FirExpression, ConeKotlinType>(null, CollectionsKt.getOrNull(((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), 0), (coneTypeProjection = ArraysKt.getOrNull(variableForInvokeType.getTypeArguments(), 0)) instanceof ConeKotlinType ? (ConeKotlinType)coneTypeProjection : null);
        }
        FirResolvedTypeRef firResolvedTypeRef = calledDeclarationSymbol.getResolvedReceiverTypeRef();
        return new Triple<FirExpression, FirExpression, ConeKotlinType>(dispatchReceiver, $this$computeReceiversInfo.getExtensionReceiver(), firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null);
    }

    private final void checkCallableReference(FirQualifiedAccessExpression expression2, FirCallableSymbol<?> symbol, DiagnosticReporter reporter, CheckerContext context) {
        if (Intrinsics.areEqual(symbol.getCallableId(), StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Callable reference to suspend property", (DiagnosticContext)context, null, 16, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendCallArgumentKind.values().length];
            try {
                nArray[SuspendCallArgumentKind.FUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendCallArgumentKind.LAMBDA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

