/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.Collections;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.collections.Sets;

public class DataProviderHolder {
    private final Collection<IDataProviderListener> listeners = Sets.newHashSet();
    private final Collection<IDataProviderInterceptor> interceptors = Sets.newHashSet();

    public Collection<IDataProviderListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public Collection<IDataProviderInterceptor> getInterceptors() {
        return Collections.unmodifiableCollection(this.interceptors);
    }

    public void addListeners(Collection<IDataProviderListener> listeners) {
        listeners.forEach(this::addListener);
    }

    public void addListener(IDataProviderListener listener) {
        this.listeners.add(listener);
    }

    public void addInterceptors(Collection<IDataProviderInterceptor> interceptors) {
        interceptors.forEach(this::addInterceptor);
    }

    public void addInterceptor(IDataProviderInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void merge(DataProviderHolder other) {
        this.listeners.addAll(other.getListeners());
        this.interceptors.addAll(other.getInterceptors());
    }
}

