/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.platform.recentFiles.frontend.FrontendSwitcherItemsCollectorKt;
import com.intellij.platform.recentFiles.frontend.SwitcherListItem;
import com.intellij.platform.recentFiles.frontend.SwitcherMnemonicsRegistry;
import com.intellij.platform.recentFiles.frontend.SwitcherToolWindow;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a6\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a0\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00130#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a*\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020\u00132\u0016\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00130#H\u0002\u001a2\u0010'\u001a\u0004\u0018\u00010\u00132\u0016\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00130#2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u001dH\u0002\u001a\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"?\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\u0005\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "mnemonicAndMainTextComparator", "Ljava/util/Comparator;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherListItem;", "kotlin.jvm.PlatformType", "getMnemonicAndMainTextComparator", "()Ljava/util/Comparator;", "mnemonicAndMainTextComparator$delegate", "collectFilesFromFrontendEditorSelectionHistory", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "collectToolWindows", "Lcom/intellij/platform/recentFiles/frontend/SwitcherToolWindow;", "onlyEditedFilesShown", "", "pinned", "isSpeedSearchInstalled", "mnemonicsRegistry", "Lcom/intellij/platform/recentFiles/frontend/SwitcherMnemonicsRegistry;", "updateMnemonics", "windows", "getIndexShortcut", "", "index", "", "addForbiddenMnemonics", "", "keymap", "", "actionId", "addSmartShortcut", "window", "addShortcut", "shortcut", "shouldDisplayToolWindowsInSwitcher", "intellij.platform.recentFiles.frontend"})
@SourceDebugExtension(value={"SMAP\nfrontendSwitcherItemsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 frontendSwitcherItemsCollector.kt\ncom/intellij/platform/recentFiles/frontend/FrontendSwitcherItemsCollectorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n774#2:169\n865#2,2:170\n1563#2:172\n1634#2,3:173\n774#2:176\n865#2,2:177\n58#3:179\n36#3,2:180\n*S KotlinDebug\n*F\n+ 1 frontendSwitcherItemsCollector.kt\ncom/intellij/platform/recentFiles/frontend/FrontendSwitcherItemsCollectorKt\n*L\n43#1:169\n43#1:170,2\n44#1:172\n44#1:173,3\n117#1:176\n117#1:177,2\n20#1:179\n20#1:180,2\n*E\n"})
public final class FrontendSwitcherItemsCollectorKt {
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy(FrontendSwitcherItemsCollectorKt::LOG_delegate$lambda$0);
    @NotNull
    private static final Lazy mnemonicAndMainTextComparator$delegate = LazyKt.lazy(FrontendSwitcherItemsCollectorKt::mnemonicAndMainTextComparator_delegate$lambda$5);

    private static final Logger getLOG() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    private static final Comparator<SwitcherListItem> getMnemonicAndMainTextComparator() {
        Lazy lazy = mnemonicAndMainTextComparator$delegate;
        return (Comparator)lazy.getValue();
    }

    @NotNull
    public static final List<VirtualFile> collectFilesFromFrontendEditorSelectionHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerImpl fileEditorManagerImpl = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
        Collection collection = fileEditorManagerImpl != null ? fileEditorManagerImpl.getSelectionHistoryList() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)collection), (int)30), FrontendSwitcherItemsCollectorKt::collectFilesFromFrontendEditorSelectionHistory$lambda$6));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SwitcherToolWindow> collectToolWindows(boolean onlyEditedFilesShown, boolean pinned, boolean isSpeedSearchInstalled, @NotNull SwitcherMnemonicsRegistry mnemonicsRegistry, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ToolWindow it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)mnemonicsRegistry, (String)"mnemonicsRegistry");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FrontendSwitcherItemsCollectorKt.shouldDisplayToolWindowsInSwitcher(onlyEditedFilesShown)) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = ToolWindowManagerEx.Companion.getInstanceEx(project).getToolWindows();
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ToolWindow)element$iv$iv;
            boolean bl = false;
            if (!(it.isAvailable() && it.isShowStripeButton())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void window;
            it = (ToolWindow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = window.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            collection.add(new SwitcherToolWindow((ToolWindow)window, string, pinned, null));
        }
        List windows = (List)destination$iv$iv;
        boolean showMnemonics = !isSpeedSearchInstalled || Registry.Companion.is("ide.recent.files.tool.window.mnemonics");
        List maybeWindowsWithMnemonics = showMnemonics || Registry.Companion.is("ide.recent.files.tool.window.sort.by.mnemonics") ? FrontendSwitcherItemsCollectorKt.updateMnemonics(windows, mnemonicsRegistry) : windows;
        Iterable iterable2 = maybeWindowsWithMnemonics;
        Comparator<SwitcherListItem> comparator = FrontendSwitcherItemsCollectorKt.getMnemonicAndMainTextComparator();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"<get-mnemonicAndMainTextComparator>(...)");
        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SwitcherToolWindow> updateMnemonics(List<SwitcherToolWindow> windows, SwitcherMnemonicsRegistry mnemonicsRegistry) {
        SwitcherToolWindow maybeToolWindowWithAssignedMnemonics;
        Object maybeToolWindowWithAssignedSmartMnemonics;
        Map keymap = new HashMap(windows.size());
        keymap.put(mnemonicsRegistry.getForbiddenMnemonic(), null);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "SwitcherForward", mnemonicsRegistry);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "SwitcherBackward", mnemonicsRegistry);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "EditorUp", mnemonicsRegistry);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "EditorDown", mnemonicsRegistry);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "EditorLeft", mnemonicsRegistry);
        FrontendSwitcherItemsCollectorKt.addForbiddenMnemonics(keymap, "EditorRight", mnemonicsRegistry);
        List toolWindowsToAssignMnemonicsTo = new ArrayList();
        List toolWindowsWithAlreadyAssignedMnemonics = new ArrayList();
        for (SwitcherToolWindow switcherToolWindow : windows) {
            SwitcherToolWindow toolWindowWithShortcut;
            boolean bl;
            String string = switcherToolWindow.getWindow().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            int index = ActivateToolWindowAction.Manager.getMnemonicForToolWindow((String)string);
            String indexShortcut = FrontendSwitcherItemsCollectorKt.getIndexShortcut(index - 48);
            if (index < 48 || index > 57 || indexShortcut == null) {
                SwitcherToolWindow maybeToolWindowWithAssignedMnemonics2;
                SwitcherToolWindow switcherToolWindow2 = maybeToolWindowWithAssignedMnemonics2 = indexShortcut != null ? FrontendSwitcherItemsCollectorKt.addShortcut(keymap, switcherToolWindow, indexShortcut) : null;
                if (maybeToolWindowWithAssignedMnemonics2 != null) {
                    bl = toolWindowsWithAlreadyAssignedMnemonics.add(maybeToolWindowWithAssignedMnemonics2);
                    continue;
                }
                bl = toolWindowsToAssignMnemonicsTo.add(switcherToolWindow);
                continue;
            }
            if (FrontendSwitcherItemsCollectorKt.addShortcut(keymap, switcherToolWindow, indexShortcut) == null) continue;
            bl = toolWindowsWithAlreadyAssignedMnemonics.add(toolWindowWithShortcut);
        }
        int i = 0;
        block1: for (SwitcherToolWindow window : toolWindowsToAssignMnemonicsTo) {
            String indexShortcut;
            maybeToolWindowWithAssignedSmartMnemonics = FrontendSwitcherItemsCollectorKt.addSmartShortcut(window, keymap);
            if (maybeToolWindowWithAssignedSmartMnemonics != null) {
                toolWindowsWithAlreadyAssignedMnemonics.add(maybeToolWindowWithAssignedSmartMnemonics);
                continue;
            }
            while ((indexShortcut = FrontendSwitcherItemsCollectorKt.getIndexShortcut(i)) != null) {
                maybeToolWindowWithAssignedMnemonics = FrontendSwitcherItemsCollectorKt.addShortcut(keymap, window, indexShortcut);
                if (maybeToolWindowWithAssignedMnemonics != null) {
                    toolWindowsWithAlreadyAssignedMnemonics.add(maybeToolWindowWithAssignedMnemonics);
                    ++i;
                    continue block1;
                }
                ++i;
            }
        }
        if (windows.size() != toolWindowsWithAlreadyAssignedMnemonics.size()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String string = CollectionsKt.joinToString$default((Iterable)toolWindowsWithAlreadyAssignedMnemonics, (CharSequence)", ", null, (CharSequence)"\n", (int)0, null, FrontendSwitcherItemsCollectorKt::updateMnemonics$lambda$9, (int)26, null);
            maybeToolWindowWithAssignedSmartMnemonics = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)windows), (Iterable)toolWindowsWithAlreadyAssignedMnemonics);
            boolean $i$f$filter = false;
            maybeToolWindowWithAssignedMnemonics = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SwitcherToolWindow it = (SwitcherToolWindow)element$iv$iv;
                boolean bl = false;
                if (!(!toolWindowsWithAlreadyAssignedMnemonics.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String skippedToolWindows = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, (CharSequence)"\n", (int)0, null, FrontendSwitcherItemsCollectorKt::updateMnemonics$lambda$11, (int)26, null);
            FrontendSwitcherItemsCollectorKt.getLOG().warn("There are " + (windows.size() - toolWindowsWithAlreadyAssignedMnemonics.size()) + " excluded from the resulting toolwindows list. The following toolwindows were processed: " + string + "The following toolwindows were skipped: " + skippedToolWindows);
        }
        return toolWindowsWithAlreadyAssignedMnemonics;
    }

    private static final String getIndexShortcut(int index) {
        if (!(0 <= index ? index < 36 : false)) {
            return null;
        }
        String string = Integer.toString(index, CharsKt.checkRadix((int)RangesKt.coerceIn((int)(index + 1), (ClosedRange)((ClosedRange)new IntRange(2, 36)))));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Strings.toUpperCase((String)string);
    }

    private static final void addForbiddenMnemonics(Map<String, SwitcherToolWindow> keymap, String actionId, SwitcherMnemonicsRegistry mnemonicsRegistry) {
        for (Shortcut shortcut : ActionUtil.getShortcutSet((String)actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            Map<String, SwitcherToolWindow> map = keymap;
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
            String string = mnemonicsRegistry.getForbiddenMnemonic(keyStroke);
            Object v = null;
            map.put(string, (SwitcherToolWindow)v);
        }
    }

    private static final SwitcherToolWindow addSmartShortcut(SwitcherToolWindow window, Map<String, SwitcherToolWindow> keymap) {
        String title = window.getMainText();
        if (StringUtil.isEmpty((String)title)) {
            return null;
        }
        int n = title.length();
        for (int i = 0; i < n; ++i) {
            SwitcherToolWindow maybeToolWindowWithAssignedMnemonics;
            char c = title.charAt(i);
            if (!Character.isUpperCase(c) || (maybeToolWindowWithAssignedMnemonics = FrontendSwitcherItemsCollectorKt.addShortcut(keymap, window, String.valueOf(c))) == null) continue;
            return maybeToolWindowWithAssignedMnemonics;
        }
        return null;
    }

    private static final SwitcherToolWindow addShortcut(Map<String, SwitcherToolWindow> keymap, SwitcherToolWindow window, String shortcut) {
        SwitcherToolWindow maybeTheSameToolWindow = keymap.get(shortcut);
        if (Intrinsics.areEqual((Object)maybeTheSameToolWindow, (Object)window)) {
            return window;
        }
        if (maybeTheSameToolWindow != null) {
            return null;
        }
        keymap.put(shortcut, window);
        return SwitcherToolWindow.copy$default(window, null, null, false, shortcut, 7, null);
    }

    private static final boolean shouldDisplayToolWindowsInSwitcher(boolean onlyEditedFilesShown) {
        return onlyEditedFilesShown ? Registry.Companion.is("ide.recent.files.tool.window.list") : Registry.Companion.is("ide.switcher.tool.window.list");
    }

    private static final Logger LOG_delegate$lambda$0() {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final String mnemonicAndMainTextComparator_delegate$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final int mnemonicAndMainTextComparator_delegate$lambda$5$lambda$2(String m1, String m2) {
        int n;
        if (m1 == null) {
            n = m2 == null ? 0 : 1;
        } else {
            String string = m2;
            n = string == null ? -1 : m1.compareTo(string);
        }
        return n;
    }

    private static final int mnemonicAndMainTextComparator_delegate$lambda$5$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final String mnemonicAndMainTextComparator_delegate$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Comparator mnemonicAndMainTextComparator_delegate$lambda$5() {
        return Comparator.comparing(arg_0 -> FrontendSwitcherItemsCollectorKt.mnemonicAndMainTextComparator_delegate$lambda$5$lambda$1((Function1)mnemonicAndMainTextComparator.2.1.INSTANCE, arg_0), (arg_0, arg_1) -> FrontendSwitcherItemsCollectorKt.mnemonicAndMainTextComparator_delegate$lambda$5$lambda$3(FrontendSwitcherItemsCollectorKt::mnemonicAndMainTextComparator_delegate$lambda$5$lambda$2, arg_0, arg_1)).thenComparing(arg_0 -> FrontendSwitcherItemsCollectorKt.mnemonicAndMainTextComparator_delegate$lambda$5$lambda$4((Function1)mnemonicAndMainTextComparator.2.3.INSTANCE, arg_0), NaturalComparator.INSTANCE);
    }

    private static final VirtualFile collectFilesFromFrontendEditorSelectionHistory$lambda$6(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (VirtualFile)it.getFirst();
    }

    private static final CharSequence updateMnemonics$lambda$9(SwitcherToolWindow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getWindow().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    private static final CharSequence updateMnemonics$lambda$11(SwitcherToolWindow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getWindow().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }
}

