/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.data.Unit;
import tim.prune.function.search.SearchResult;

public class TrackListModel
extends AbstractTableModel {
    private final Unit _distanceUnit;
    private ArrayList<SearchResult> _trackList = null;
    private final String _nameColLabel;
    private String _lengthColLabel = null;
    private final int _numColumns;
    private boolean _showPointTypes = false;
    private final NumberFormat _distanceFormatter = NumberFormat.getInstance();

    public TrackListModel(String string, String string2, Unit unit) {
        this._distanceUnit = unit;
        this._nameColLabel = I18nManager.getText(string);
        if (string2 != null) {
            this._lengthColLabel = I18nManager.getText(string2);
        }
        this._numColumns = this._lengthColLabel != null ? 2 : 1;
        this._distanceFormatter.setMaximumFractionDigits(1);
    }

    @Override
    public int getColumnCount() {
        return this._numColumns;
    }

    @Override
    public int getRowCount() {
        if (this._trackList == null) {
            return 0;
        }
        return this._trackList.size();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this._nameColLabel;
        }
        return this._lengthColLabel;
    }

    public void setShowPointTypes(boolean bl) {
        this._showPointTypes = bl;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SearchResult searchResult = this._trackList.get(n);
        if (n2 == 0) {
            return searchResult.getTrackName();
        }
        if (this._showPointTypes) {
            return searchResult.getPointType();
        }
        double d = searchResult.getLength();
        double d2 = d * this._distanceUnit.getMultFactorFromStd();
        return String.valueOf(this._distanceFormatter.format(d2)) + " " + I18nManager.getText(this._distanceUnit.getShortnameKey());
    }

    public void addTracks(ArrayList<SearchResult> arrayList) {
        this.addTracks(arrayList, false);
    }

    public void addTracks(ArrayList<SearchResult> arrayList, boolean bl) {
        if (this._trackList == null) {
            this._trackList = new ArrayList();
        }
        int n = this._trackList.size();
        if (arrayList != null && arrayList.size() > 0) {
            this._trackList.addAll(arrayList);
            if (bl) {
                Collections.sort(this._trackList);
            }
        }
        int n2 = this._trackList.size();
        if (n <= 0) {
            this.fireTableDataChanged();
        } else {
            this.fireTableRowsInserted(n, n2 - 1);
        }
    }

    public SearchResult getTrack(int n) {
        return this._trackList.get(n);
    }

    public void clear() {
        this._trackList = null;
    }
}

