---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Postman API token'
---

## Description

The response body contains content that matches the pattern of a Postman API token was identified. An API key provides access to any Postman data the account has permissions to. A malicious actor with access to this token can access all data stored in the Postman service that the user who created the API key has access to.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate an API token:

- Sign in to your Postman account at <https://www.postman.com/>
- Select the profile picture in the top right-hand side, and select "Settings"
- Select "API keys" in the left-hand menu
- Find the key that was identified, and select the ellipsis next to the status column in the "API keys" section
- Select "Regenerate"
- When prompted, select "Regenerate API Key" in the "Regenerate API key" dialog

For more information, please see [Postman's documentation on API keys](https://learning.postman.com/docs/developer/postman-api/authentication/).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.93 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
