/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;

class StringToNumberConverter
implements StringToObjectConverter {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

    StringToNumberConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return CONVERTERS.containsKey(targetType);
    }

    @Override
    public Object convert(String source, Class<?> targetType) {
        return CONVERTERS.get(targetType).apply(source.replace("_", ""));
    }

    static {
        HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
        converters.put(Byte.class, Byte::decode);
        converters.put(Short.class, Short::decode);
        converters.put(Integer.class, Integer::decode);
        converters.put(Long.class, Long::decode);
        converters.put(Float.class, Float::valueOf);
        converters.put(Double.class, Double::valueOf);
        converters.put(BigInteger.class, BigInteger::new);
        converters.put(BigDecimal.class, BigDecimal::new);
        CONVERTERS = Collections.unmodifiableMap(converters);
    }
}

