#include <cstdint>

extern const int MIN_ZH_HAN_PAGE = 0x2E;
extern const int MAX_ZH_HAN_PAGE = 0x2CE;

uint16_t zh_han_p02E[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 

  /* Primary weight 1 for each character. */
  0x03B6,   /* U+2E00 */
  0x03B7,   /* U+2E01 */
  0x035B,   /* U+2E02 */
  0x035C,   /* U+2E03 */
  0x035D,   /* U+2E04 */
  0x035E,   /* U+2E05 */
  0x03B8,   /* U+2E06 */
  0x03B9,   /* U+2E07 */
  0x03BA,   /* U+2E08 */
  0x035F,   /* U+2E09 */
  0x0360,   /* U+2E0A */
  0x03BB,   /* U+2E0B */
  0x0361,   /* U+2E0C */
  0x0362,   /* U+2E0D */
  0x03BC,   /* U+2E0E */
  0x03BD,   /* U+2E0F */
  0x03BE,   /* U+2E10 */
  0x03BF,   /* U+2E11 */
  0x03C0,   /* U+2E12 */
  0x03C1,   /* U+2E13 */
  0x03C2,   /* U+2E14 */
  0x03C3,   /* U+2E15 */
  0x03C4,   /* U+2E16 */
  0x021C,   /* U+2E17 */
  0x0276,   /* U+2E18 */
  0x02F8,   /* U+2E19 */
  0x03C5,   /* U+2E1A */
  0x03C6,   /* U+2E1B */
  0x0363,   /* U+2E1C */
  0x0364,   /* U+2E1D */
  0x03C7,   /* U+2E1E */
  0x03C8,   /* U+2E1F */
  0x0365,   /* U+2E20 */
  0x0366,   /* U+2E21 */
  0x0367,   /* U+2E22 */
  0x0368,   /* U+2E23 */
  0x0369,   /* U+2E24 */
  0x036A,   /* U+2E25 */
  0x036B,   /* U+2E26 */
  0x036C,   /* U+2E27 */
  0x036D,   /* U+2E28 */
  0x036E,   /* U+2E29 */
  0x02F1,   /* U+2E2A */
  0x02F2,   /* U+2E2B */
  0x02F3,   /* U+2E2C */
  0x02F4,   /* U+2E2D */
  0x0268,   /* U+2E2E */
  0xC30A,   /* U+2E2F */
  0x0283,   /* U+2E30 */
  0x028C,   /* U+2E31 */
  0x0224,   /* U+2E32 */
  0x028D,   /* U+2E33 */
  0x0223,   /* U+2E34 */
  0x0237,   /* U+2E35 */
  0x03A1,   /* U+2E36 */
  0x03A2,   /* U+2E37 */
  0x03A3,   /* U+2E38 */
  0x038A,   /* U+2E39 */
  0x0218,   /* U+2E3A */
  0x0219,   /* U+2E3B */
  0x0284,   /* U+2E3C */
  0x02F5,   /* U+2E3D */
  0x0384,   /* U+2E3E */
  0x038D,   /* U+2E3F */
  0x021D,   /* U+2E40 */
  0x0225,   /* U+2E41 */
  0x0311,   /* U+2E42 */
  0x021B,   /* U+2E43 */
  0x03C9,   /* U+2E44 */
  0xF622,   /* U+2E45 */
  0xF622,   /* U+2E46 */
  0xF622,   /* U+2E47 */
  0xF622,   /* U+2E48 */
  0xF622,   /* U+2E49 */
  0xF622,   /* U+2E4A */
  0xF622,   /* U+2E4B */
  0xF622,   /* U+2E4C */
  0xF622,   /* U+2E4D */
  0xF622,   /* U+2E4E */
  0xF622,   /* U+2E4F */
  0xF622,   /* U+2E50 */
  0xF622,   /* U+2E51 */
  0xF622,   /* U+2E52 */
  0xF622,   /* U+2E53 */
  0xF622,   /* U+2E54 */
  0xF622,   /* U+2E55 */
  0xF622,   /* U+2E56 */
  0xF622,   /* U+2E57 */
  0xF622,   /* U+2E58 */
  0xF622,   /* U+2E59 */
  0xF622,   /* U+2E5A */
  0xF622,   /* U+2E5B */
  0xF622,   /* U+2E5C */
  0xF622,   /* U+2E5D */
  0xF622,   /* U+2E5E */
  0xF622,   /* U+2E5F */
  0xF622,   /* U+2E60 */
  0xF622,   /* U+2E61 */
  0xF622,   /* U+2E62 */
  0xF622,   /* U+2E63 */
  0xF622,   /* U+2E64 */
  0xF622,   /* U+2E65 */
  0xF622,   /* U+2E66 */
  0xF622,   /* U+2E67 */
  0xF622,   /* U+2E68 */
  0xF622,   /* U+2E69 */
  0xF622,   /* U+2E6A */
  0xF622,   /* U+2E6B */
  0xF622,   /* U+2E6C */
  0xF622,   /* U+2E6D */
  0xF622,   /* U+2E6E */
  0xF622,   /* U+2E6F */
  0xF622,   /* U+2E70 */
  0xF622,   /* U+2E71 */
  0xF622,   /* U+2E72 */
  0xF622,   /* U+2E73 */
  0xF622,   /* U+2E74 */
  0xF622,   /* U+2E75 */
  0xF622,   /* U+2E76 */
  0xF622,   /* U+2E77 */
  0xF622,   /* U+2E78 */
  0xF622,   /* U+2E79 */
  0xF622,   /* U+2E7A */
  0xF622,   /* U+2E7B */
  0xF622,   /* U+2E7C */
  0xF622,   /* U+2E7D */
  0xF622,   /* U+2E7E */
  0xF622,   /* U+2E7F */
  0xAC63,   /* U+2E80 */
  0x27CE,   /* U+2E81 */
  0xA24C,   /* U+2E82 */
  0xA9FD,   /* U+2E83 */
  0xA249,   /* U+2E84 */
  0x7F24,   /* U+2E85 */
  0x53BC,   /* U+2E86 */
  0x4CDF,   /* U+2E87 */
  0x312C,   /* U+2E88 */
  0x3139,   /* U+2E89 */
  0x244D,   /* U+2E8A */
  0x5220,   /* U+2E8B */
  0x9C30,   /* U+2E8C */
  0x9C31,   /* U+2E8D */
  0x970E,   /* U+2E8E */
  0x934D,   /* U+2E8F */
  0x934E,   /* U+2E90 */
  0x970F,   /* U+2E91 */
  0x88E7,   /* U+2E92 */
  0xA4BF,   /* U+2E93 */
  0x4DDD,   /* U+2E94 */
  0x4D0C,   /* U+2E95 */
  0x9E12,   /* U+2E96 */
  0x9E13,   /* U+2E97 */
  0x86B2,   /* U+2E98 */
  0x7671,   /* U+2E99 */
  0xF622,   /* U+2E9A */
  0x7F89,   /* U+2E9B */
  0x7F7D,   /* U+2E9C */
  0xAF95,   /* U+2E9D */
  0x2FE1,   /* U+2E9E */
  0x6D6B,   /* U+2E9F */
  0x6C1E,   /* U+2EA0 */
  0x8809,   /* U+2EA1 */
  0x87F0,   /* U+2EA2 */
  0x227F,   /* U+2EA3 */
  0xB42C,   /* U+2EA4 */
  0xB421,   /* U+2EA5 */
  0x7A01,   /* U+2EA6 */
  0x710F,   /* U+2EA7 */
  0x7E1E,   /* U+2EA8 */
  0x9352,   /* U+2EA9 */
  0x7482,   /* U+2EAA */
  0x6DBD,   /* U+2EAB */
  0x85E8,   /* U+2EAC */
  0x8675,   /* U+2EAD */
  0x85EF,   /* U+2EAE */
  0x889E,   /* U+2EAF */
  0x889F,   /* U+2EB0 */
  0x3D9C,   /* U+2EB1 */
  0x9387,   /* U+2EB2 */
  0x3D78,   /* U+2EB3 */
  0x9386,   /* U+2EB4 */
  0x935D,   /* U+2EB5 */
  0x7F43,   /* U+2EB6 */
  0x7F6A,   /* U+2EB7 */
  0x6AC7,   /* U+2EB8 */
  0x5D42,   /* U+2EB9 */
  0xAEC1,   /* U+2EBA */
  0xAEC2,   /* U+2EBB */
  0x8023,   /* U+2EBC */
  0x5523,   /* U+2EBD */
  0x25A9,   /* U+2EBE */
  0x25AB,   /* U+2EBF */
  0x25AC,   /* U+2EC0 */
  0x4770,   /* U+2EC1 */
  0xA68A,   /* U+2EC2 */
  0x981F,   /* U+2EC3 */
  0x981E,   /* U+2EC4 */
  0x4FEF,   /* U+2EC5 */
  0x50B2,   /* U+2EC6 */
  0x50B2,   /* U+2EC7 */
  0xA2F9,   /* U+2EC8 */
  0x2002,   /* U+2EC9 */
  0xBCB4,   /* U+2ECA */
  0x283E,   /* U+2ECB */
  0x2D21,   /* U+2ECC */
  0x2D23,   /* U+2ECD */
  0x2D48,   /* U+2ECE */
  0x3C24,   /* U+2ECF */
  0x5297,   /* U+2ED0 */
  0x27BC,   /* U+2ED1 */
  0x27BD,   /* U+2ED2 */
  0xB3EC,   /* U+2ED3 */
  0x69CE,   /* U+2ED4 */
  0x3C35,   /* U+2ED5 */
  0x3C25,   /* U+2ED6 */
  0xAD71,   /* U+2ED7 */
  0x7B99,   /* U+2ED8 */
  0x9425,   /* U+2ED9 */
  0xA63C,   /* U+2EDA */
  0x3AA0,   /* U+2EDB */
  0x396B,   /* U+2EDC */
  0x85BB,   /* U+2EDD */
  0x858F,   /* U+2EDE */
  0x85BC,   /* U+2EDF */
  0x85BD,   /* U+2EE0 */
  0x8689,   /* U+2EE1 */
  0x67B1,   /* U+2EE2 */
  0x400C,   /* U+2EE3 */
  0x41E5,   /* U+2EE4 */
  0xAD68,   /* U+2EE5 */
  0x7042,   /* U+2EE6 */
  0x655F,   /* U+2EE7 */
  0x6804,   /* U+2EE8 */
  0x4973,   /* U+2EE9 */
  0x6B7C,   /* U+2EEA */
  0x77C5,   /* U+2EEB */
  0x77C6,   /* U+2EEC */
  0x2A3A,   /* U+2EED */
  0x2A3B,   /* U+2EEE */
  0x646C,   /* U+2EEF */
  0x646D,   /* U+2EF0 */
  0x41AE,   /* U+2EF1 */
  0x41AD,   /* U+2EF2 */
  0x416F,   /* U+2EF3 */
  0xF622,   /* U+2EF4 */
  0xF622,   /* U+2EF5 */
  0xF622,   /* U+2EF6 */
  0xF622,   /* U+2EF7 */
  0xF622,   /* U+2EF8 */
  0xF622,   /* U+2EF9 */
  0xF622,   /* U+2EFA */
  0xF622,   /* U+2EFB */
  0xF622,   /* U+2EFC */
  0xF622,   /* U+2EFD */
  0xF622,   /* U+2EFE */
  0xF622,   /* U+2EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+2E00 */
  0x0020,   /* U+2E01 */
  0x0020,   /* U+2E02 */
  0x0020,   /* U+2E03 */
  0x0020,   /* U+2E04 */
  0x0020,   /* U+2E05 */
  0x0020,   /* U+2E06 */
  0x0020,   /* U+2E07 */
  0x0020,   /* U+2E08 */
  0x0020,   /* U+2E09 */
  0x0020,   /* U+2E0A */
  0x0020,   /* U+2E0B */
  0x0020,   /* U+2E0C */
  0x0020,   /* U+2E0D */
  0x0020,   /* U+2E0E */
  0x0020,   /* U+2E0F */
  0x0020,   /* U+2E10 */
  0x0020,   /* U+2E11 */
  0x0020,   /* U+2E12 */
  0x0020,   /* U+2E13 */
  0x0020,   /* U+2E14 */
  0x0020,   /* U+2E15 */
  0x0020,   /* U+2E16 */
  0x0020,   /* U+2E17 */
  0x0020,   /* U+2E18 */
  0x0020,   /* U+2E19 */
  0x0020,   /* U+2E1A */
  0x0020,   /* U+2E1B */
  0x0020,   /* U+2E1C */
  0x0020,   /* U+2E1D */
  0x0020,   /* U+2E1E */
  0x0020,   /* U+2E1F */
  0x0020,   /* U+2E20 */
  0x0020,   /* U+2E21 */
  0x0020,   /* U+2E22 */
  0x0020,   /* U+2E23 */
  0x0020,   /* U+2E24 */
  0x0020,   /* U+2E25 */
  0x0020,   /* U+2E26 */
  0x0020,   /* U+2E27 */
  0x0020,   /* U+2E28 */
  0x0020,   /* U+2E29 */
  0x0020,   /* U+2E2A */
  0x0020,   /* U+2E2B */
  0x0020,   /* U+2E2C */
  0x0020,   /* U+2E2D */
  0x0020,   /* U+2E2E */
  0x0020,   /* U+2E2F */
  0x0020,   /* U+2E30 */
  0x0020,   /* U+2E31 */
  0x0020,   /* U+2E32 */
  0x0020,   /* U+2E33 */
  0x0020,   /* U+2E34 */
  0x0020,   /* U+2E35 */
  0x0020,   /* U+2E36 */
  0x0020,   /* U+2E37 */
  0x0020,   /* U+2E38 */
  0x0020,   /* U+2E39 */
  0x0020,   /* U+2E3A */
  0x0020,   /* U+2E3B */
  0x0020,   /* U+2E3C */
  0x0020,   /* U+2E3D */
  0x0020,   /* U+2E3E */
  0x0020,   /* U+2E3F */
  0x0020,   /* U+2E40 */
  0x0020,   /* U+2E41 */
  0x0020,   /* U+2E42 */
  0x0020,   /* U+2E43 */
  0x0020,   /* U+2E44 */
  0x0020,   /* U+2E45 */
  0x0020,   /* U+2E46 */
  0x0020,   /* U+2E47 */
  0x0020,   /* U+2E48 */
  0x0020,   /* U+2E49 */
  0x0020,   /* U+2E4A */
  0x0020,   /* U+2E4B */
  0x0020,   /* U+2E4C */
  0x0020,   /* U+2E4D */
  0x0020,   /* U+2E4E */
  0x0020,   /* U+2E4F */
  0x0020,   /* U+2E50 */
  0x0020,   /* U+2E51 */
  0x0020,   /* U+2E52 */
  0x0020,   /* U+2E53 */
  0x0020,   /* U+2E54 */
  0x0020,   /* U+2E55 */
  0x0020,   /* U+2E56 */
  0x0020,   /* U+2E57 */
  0x0020,   /* U+2E58 */
  0x0020,   /* U+2E59 */
  0x0020,   /* U+2E5A */
  0x0020,   /* U+2E5B */
  0x0020,   /* U+2E5C */
  0x0020,   /* U+2E5D */
  0x0020,   /* U+2E5E */
  0x0020,   /* U+2E5F */
  0x0020,   /* U+2E60 */
  0x0020,   /* U+2E61 */
  0x0020,   /* U+2E62 */
  0x0020,   /* U+2E63 */
  0x0020,   /* U+2E64 */
  0x0020,   /* U+2E65 */
  0x0020,   /* U+2E66 */
  0x0020,   /* U+2E67 */
  0x0020,   /* U+2E68 */
  0x0020,   /* U+2E69 */
  0x0020,   /* U+2E6A */
  0x0020,   /* U+2E6B */
  0x0020,   /* U+2E6C */
  0x0020,   /* U+2E6D */
  0x0020,   /* U+2E6E */
  0x0020,   /* U+2E6F */
  0x0020,   /* U+2E70 */
  0x0020,   /* U+2E71 */
  0x0020,   /* U+2E72 */
  0x0020,   /* U+2E73 */
  0x0020,   /* U+2E74 */
  0x0020,   /* U+2E75 */
  0x0020,   /* U+2E76 */
  0x0020,   /* U+2E77 */
  0x0020,   /* U+2E78 */
  0x0020,   /* U+2E79 */
  0x0020,   /* U+2E7A */
  0x0020,   /* U+2E7B */
  0x0020,   /* U+2E7C */
  0x0020,   /* U+2E7D */
  0x0020,   /* U+2E7E */
  0x0020,   /* U+2E7F */
  0x0020,   /* U+2E80 */
  0x0020,   /* U+2E81 */
  0x0020,   /* U+2E82 */
  0x0020,   /* U+2E83 */
  0x0020,   /* U+2E84 */
  0x0020,   /* U+2E85 */
  0x0020,   /* U+2E86 */
  0x0020,   /* U+2E87 */
  0x0020,   /* U+2E88 */
  0x0020,   /* U+2E89 */
  0x0020,   /* U+2E8A */
  0x0020,   /* U+2E8B */
  0x0020,   /* U+2E8C */
  0x0020,   /* U+2E8D */
  0x0020,   /* U+2E8E */
  0x0020,   /* U+2E8F */
  0x0020,   /* U+2E90 */
  0x0020,   /* U+2E91 */
  0x0020,   /* U+2E92 */
  0x0020,   /* U+2E93 */
  0x0020,   /* U+2E94 */
  0x0020,   /* U+2E95 */
  0x0020,   /* U+2E96 */
  0x0020,   /* U+2E97 */
  0x0020,   /* U+2E98 */
  0x0020,   /* U+2E99 */
  0x0020,   /* U+2E9A */
  0x0020,   /* U+2E9B */
  0x0020,   /* U+2E9C */
  0x0020,   /* U+2E9D */
  0x0020,   /* U+2E9E */
  0x0020,   /* U+2E9F */
  0x0020,   /* U+2EA0 */
  0x0020,   /* U+2EA1 */
  0x0020,   /* U+2EA2 */
  0x0020,   /* U+2EA3 */
  0x0020,   /* U+2EA4 */
  0x0020,   /* U+2EA5 */
  0x0020,   /* U+2EA6 */
  0x0020,   /* U+2EA7 */
  0x0020,   /* U+2EA8 */
  0x0020,   /* U+2EA9 */
  0x0020,   /* U+2EAA */
  0x0020,   /* U+2EAB */
  0x0020,   /* U+2EAC */
  0x0020,   /* U+2EAD */
  0x0020,   /* U+2EAE */
  0x0020,   /* U+2EAF */
  0x0020,   /* U+2EB0 */
  0x0020,   /* U+2EB1 */
  0x0020,   /* U+2EB2 */
  0x0020,   /* U+2EB3 */
  0x0020,   /* U+2EB4 */
  0x0020,   /* U+2EB5 */
  0x0020,   /* U+2EB6 */
  0x0020,   /* U+2EB7 */
  0x0020,   /* U+2EB8 */
  0x0020,   /* U+2EB9 */
  0x0020,   /* U+2EBA */
  0x0020,   /* U+2EBB */
  0x0020,   /* U+2EBC */
  0x0020,   /* U+2EBD */
  0x0020,   /* U+2EBE */
  0x0020,   /* U+2EBF */
  0x0020,   /* U+2EC0 */
  0x0020,   /* U+2EC1 */
  0x0020,   /* U+2EC2 */
  0x0020,   /* U+2EC3 */
  0x0020,   /* U+2EC4 */
  0x0020,   /* U+2EC5 */
  0x0020,   /* U+2EC6 */
  0x0020,   /* U+2EC7 */
  0x0020,   /* U+2EC8 */
  0x0020,   /* U+2EC9 */
  0x0020,   /* U+2ECA */
  0x0020,   /* U+2ECB */
  0x0020,   /* U+2ECC */
  0x0020,   /* U+2ECD */
  0x0020,   /* U+2ECE */
  0x0020,   /* U+2ECF */
  0x0020,   /* U+2ED0 */
  0x0020,   /* U+2ED1 */
  0x0020,   /* U+2ED2 */
  0x0020,   /* U+2ED3 */
  0x0020,   /* U+2ED4 */
  0x0020,   /* U+2ED5 */
  0x0020,   /* U+2ED6 */
  0x0020,   /* U+2ED7 */
  0x0020,   /* U+2ED8 */
  0x0020,   /* U+2ED9 */
  0x0020,   /* U+2EDA */
  0x0020,   /* U+2EDB */
  0x0020,   /* U+2EDC */
  0x0020,   /* U+2EDD */
  0x0020,   /* U+2EDE */
  0x0020,   /* U+2EDF */
  0x0020,   /* U+2EE0 */
  0x0020,   /* U+2EE1 */
  0x0020,   /* U+2EE2 */
  0x0020,   /* U+2EE3 */
  0x0020,   /* U+2EE4 */
  0x0020,   /* U+2EE5 */
  0x0020,   /* U+2EE6 */
  0x0020,   /* U+2EE7 */
  0x0020,   /* U+2EE8 */
  0x0020,   /* U+2EE9 */
  0x0020,   /* U+2EEA */
  0x0020,   /* U+2EEB */
  0x0020,   /* U+2EEC */
  0x0020,   /* U+2EED */
  0x0020,   /* U+2EEE */
  0x0020,   /* U+2EEF */
  0x0020,   /* U+2EF0 */
  0x0020,   /* U+2EF1 */
  0x0020,   /* U+2EF2 */
  0x0020,   /* U+2EF3 */
  0x0020,   /* U+2EF4 */
  0x0020,   /* U+2EF5 */
  0x0020,   /* U+2EF6 */
  0x0020,   /* U+2EF7 */
  0x0020,   /* U+2EF8 */
  0x0020,   /* U+2EF9 */
  0x0020,   /* U+2EFA */
  0x0020,   /* U+2EFB */
  0x0020,   /* U+2EFC */
  0x0020,   /* U+2EFD */
  0x0020,   /* U+2EFE */
  0x0020,   /* U+2EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+2E00 */
  0x0002,   /* U+2E01 */
  0x0002,   /* U+2E02 */
  0x0002,   /* U+2E03 */
  0x0002,   /* U+2E04 */
  0x0002,   /* U+2E05 */
  0x0002,   /* U+2E06 */
  0x0002,   /* U+2E07 */
  0x0002,   /* U+2E08 */
  0x0002,   /* U+2E09 */
  0x0002,   /* U+2E0A */
  0x0002,   /* U+2E0B */
  0x0002,   /* U+2E0C */
  0x0002,   /* U+2E0D */
  0x0002,   /* U+2E0E */
  0x0002,   /* U+2E0F */
  0x0002,   /* U+2E10 */
  0x0002,   /* U+2E11 */
  0x0002,   /* U+2E12 */
  0x0002,   /* U+2E13 */
  0x0002,   /* U+2E14 */
  0x0002,   /* U+2E15 */
  0x0002,   /* U+2E16 */
  0x0002,   /* U+2E17 */
  0x0002,   /* U+2E18 */
  0x0002,   /* U+2E19 */
  0x0002,   /* U+2E1A */
  0x0002,   /* U+2E1B */
  0x0002,   /* U+2E1C */
  0x0002,   /* U+2E1D */
  0x0002,   /* U+2E1E */
  0x0002,   /* U+2E1F */
  0x0002,   /* U+2E20 */
  0x0002,   /* U+2E21 */
  0x0002,   /* U+2E22 */
  0x0002,   /* U+2E23 */
  0x0002,   /* U+2E24 */
  0x0002,   /* U+2E25 */
  0x0002,   /* U+2E26 */
  0x0002,   /* U+2E27 */
  0x0002,   /* U+2E28 */
  0x0002,   /* U+2E29 */
  0x0002,   /* U+2E2A */
  0x0002,   /* U+2E2B */
  0x0002,   /* U+2E2C */
  0x0002,   /* U+2E2D */
  0x0002,   /* U+2E2E */
  0x0002,   /* U+2E2F */
  0x0002,   /* U+2E30 */
  0x0002,   /* U+2E31 */
  0x0002,   /* U+2E32 */
  0x0002,   /* U+2E33 */
  0x0002,   /* U+2E34 */
  0x0002,   /* U+2E35 */
  0x0002,   /* U+2E36 */
  0x0002,   /* U+2E37 */
  0x0002,   /* U+2E38 */
  0x0002,   /* U+2E39 */
  0x0002,   /* U+2E3A */
  0x0002,   /* U+2E3B */
  0x0002,   /* U+2E3C */
  0x0002,   /* U+2E3D */
  0x0002,   /* U+2E3E */
  0x0002,   /* U+2E3F */
  0x0002,   /* U+2E40 */
  0x0002,   /* U+2E41 */
  0x0002,   /* U+2E42 */
  0x0002,   /* U+2E43 */
  0x0002,   /* U+2E44 */
  0x0002,   /* U+2E45 */
  0x0002,   /* U+2E46 */
  0x0002,   /* U+2E47 */
  0x0002,   /* U+2E48 */
  0x0002,   /* U+2E49 */
  0x0002,   /* U+2E4A */
  0x0002,   /* U+2E4B */
  0x0002,   /* U+2E4C */
  0x0002,   /* U+2E4D */
  0x0002,   /* U+2E4E */
  0x0002,   /* U+2E4F */
  0x0002,   /* U+2E50 */
  0x0002,   /* U+2E51 */
  0x0002,   /* U+2E52 */
  0x0002,   /* U+2E53 */
  0x0002,   /* U+2E54 */
  0x0002,   /* U+2E55 */
  0x0002,   /* U+2E56 */
  0x0002,   /* U+2E57 */
  0x0002,   /* U+2E58 */
  0x0002,   /* U+2E59 */
  0x0002,   /* U+2E5A */
  0x0002,   /* U+2E5B */
  0x0002,   /* U+2E5C */
  0x0002,   /* U+2E5D */
  0x0002,   /* U+2E5E */
  0x0002,   /* U+2E5F */
  0x0002,   /* U+2E60 */
  0x0002,   /* U+2E61 */
  0x0002,   /* U+2E62 */
  0x0002,   /* U+2E63 */
  0x0002,   /* U+2E64 */
  0x0002,   /* U+2E65 */
  0x0002,   /* U+2E66 */
  0x0002,   /* U+2E67 */
  0x0002,   /* U+2E68 */
  0x0002,   /* U+2E69 */
  0x0002,   /* U+2E6A */
  0x0002,   /* U+2E6B */
  0x0002,   /* U+2E6C */
  0x0002,   /* U+2E6D */
  0x0002,   /* U+2E6E */
  0x0002,   /* U+2E6F */
  0x0002,   /* U+2E70 */
  0x0002,   /* U+2E71 */
  0x0002,   /* U+2E72 */
  0x0002,   /* U+2E73 */
  0x0002,   /* U+2E74 */
  0x0002,   /* U+2E75 */
  0x0002,   /* U+2E76 */
  0x0002,   /* U+2E77 */
  0x0002,   /* U+2E78 */
  0x0002,   /* U+2E79 */
  0x0002,   /* U+2E7A */
  0x0002,   /* U+2E7B */
  0x0002,   /* U+2E7C */
  0x0002,   /* U+2E7D */
  0x0002,   /* U+2E7E */
  0x0002,   /* U+2E7F */
  0x0002,   /* U+2E80 */
  0x0002,   /* U+2E81 */
  0x0002,   /* U+2E82 */
  0x0002,   /* U+2E83 */
  0x0002,   /* U+2E84 */
  0x0002,   /* U+2E85 */
  0x0002,   /* U+2E86 */
  0x0004,   /* U+2E87 */
  0x0002,   /* U+2E88 */
  0x0002,   /* U+2E89 */
  0x0002,   /* U+2E8A */
  0x0002,   /* U+2E8B */
  0x0002,   /* U+2E8C */
  0x0002,   /* U+2E8D */
  0x0002,   /* U+2E8E */
  0x0002,   /* U+2E8F */
  0x0002,   /* U+2E90 */
  0x0002,   /* U+2E91 */
  0x0002,   /* U+2E92 */
  0x0002,   /* U+2E93 */
  0x0002,   /* U+2E94 */
  0x0002,   /* U+2E95 */
  0x0002,   /* U+2E96 */
  0x0002,   /* U+2E97 */
  0x0002,   /* U+2E98 */
  0x0002,   /* U+2E99 */
  0x0002,   /* U+2E9A */
  0x0002,   /* U+2E9B */
  0x0002,   /* U+2E9C */
  0x0002,   /* U+2E9D */
  0x0002,   /* U+2E9E */
  0x0004,   /* U+2E9F */
  0x0002,   /* U+2EA0 */
  0x0002,   /* U+2EA1 */
  0x0002,   /* U+2EA2 */
  0x0002,   /* U+2EA3 */
  0x0002,   /* U+2EA4 */
  0x0002,   /* U+2EA5 */
  0x0002,   /* U+2EA6 */
  0x0002,   /* U+2EA7 */
  0x0002,   /* U+2EA8 */
  0x0004,   /* U+2EA9 */
  0x0004,   /* U+2EAA */
  0x0002,   /* U+2EAB */
  0x0002,   /* U+2EAC */
  0x0002,   /* U+2EAD */
  0x0002,   /* U+2EAE */
  0x0002,   /* U+2EAF */
  0x0002,   /* U+2EB0 */
  0x0002,   /* U+2EB1 */
  0x0002,   /* U+2EB2 */
  0x0004,   /* U+2EB3 */
  0x0002,   /* U+2EB4 */
  0x0004,   /* U+2EB5 */
  0x0002,   /* U+2EB6 */
  0x0002,   /* U+2EB7 */
  0x0004,   /* U+2EB8 */
  0x0002,   /* U+2EB9 */
  0x0002,   /* U+2EBA */
  0x0002,   /* U+2EBB */
  0x0002,   /* U+2EBC */
  0x0002,   /* U+2EBD */
  0x0002,   /* U+2EBE */
  0x0002,   /* U+2EBF */
  0x0002,   /* U+2EC0 */
  0x0002,   /* U+2EC1 */
  0x0002,   /* U+2EC2 */
  0x0002,   /* U+2EC3 */
  0x0002,   /* U+2EC4 */
  0x0002,   /* U+2EC5 */
  0x0004,   /* U+2EC6 */
  0x0004,   /* U+2EC7 */
  0x0002,   /* U+2EC8 */
  0x0002,   /* U+2EC9 */
  0x0004,   /* U+2ECA */
  0x0002,   /* U+2ECB */
  0x0002,   /* U+2ECC */
  0x0002,   /* U+2ECD */
  0x0002,   /* U+2ECE */
  0x0002,   /* U+2ECF */
  0x0002,   /* U+2ED0 */
  0x0002,   /* U+2ED1 */
  0x0002,   /* U+2ED2 */
  0x0002,   /* U+2ED3 */
  0x0002,   /* U+2ED4 */
  0x0004,   /* U+2ED5 */
  0x0002,   /* U+2ED6 */
  0x0002,   /* U+2ED7 */
  0x0002,   /* U+2ED8 */
  0x0002,   /* U+2ED9 */
  0x0002,   /* U+2EDA */
  0x0002,   /* U+2EDB */
  0x0002,   /* U+2EDC */
  0x0002,   /* U+2EDD */
  0x0004,   /* U+2EDE */
  0x0002,   /* U+2EDF */
  0x0002,   /* U+2EE0 */
  0x0004,   /* U+2EE1 */
  0x0002,   /* U+2EE2 */
  0x0002,   /* U+2EE3 */
  0x0002,   /* U+2EE4 */
  0x0002,   /* U+2EE5 */
  0x0002,   /* U+2EE6 */
  0x0002,   /* U+2EE7 */
  0x0002,   /* U+2EE8 */
  0x0002,   /* U+2EE9 */
  0x0002,   /* U+2EEA */
  0x0002,   /* U+2EEB */
  0x0002,   /* U+2EEC */
  0x0002,   /* U+2EED */
  0x0002,   /* U+2EEE */
  0x0002,   /* U+2EEF */
  0x0002,   /* U+2EF0 */
  0x0002,   /* U+2EF1 */
  0x0002,   /* U+2EF2 */
  0x0004,   /* U+2EF3 */
  0x0002,   /* U+2EF4 */
  0x0002,   /* U+2EF5 */
  0x0002,   /* U+2EF6 */
  0x0002,   /* U+2EF7 */
  0x0002,   /* U+2EF8 */
  0x0002,   /* U+2EF9 */
  0x0002,   /* U+2EFA */
  0x0002,   /* U+2EFB */
  0x0002,   /* U+2EFC */
  0x0002,   /* U+2EFD */
  0x0002,   /* U+2EFE */
  0x0002,   /* U+2EFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0xAE45,   /* U+2E45 */
  0xAE46,   /* U+2E46 */
  0xAE47,   /* U+2E47 */
  0xAE48,   /* U+2E48 */
  0xAE49,   /* U+2E49 */
  0xAE4A,   /* U+2E4A */
  0xAE4B,   /* U+2E4B */
  0xAE4C,   /* U+2E4C */
  0xAE4D,   /* U+2E4D */
  0xAE4E,   /* U+2E4E */
  0xAE4F,   /* U+2E4F */
  0xAE50,   /* U+2E50 */
  0xAE51,   /* U+2E51 */
  0xAE52,   /* U+2E52 */
  0xAE53,   /* U+2E53 */
  0xAE54,   /* U+2E54 */
  0xAE55,   /* U+2E55 */
  0xAE56,   /* U+2E56 */
  0xAE57,   /* U+2E57 */
  0xAE58,   /* U+2E58 */
  0xAE59,   /* U+2E59 */
  0xAE5A,   /* U+2E5A */
  0xAE5B,   /* U+2E5B */
  0xAE5C,   /* U+2E5C */
  0xAE5D,   /* U+2E5D */
  0xAE5E,   /* U+2E5E */
  0xAE5F,   /* U+2E5F */
  0xAE60,   /* U+2E60 */
  0xAE61,   /* U+2E61 */
  0xAE62,   /* U+2E62 */
  0xAE63,   /* U+2E63 */
  0xAE64,   /* U+2E64 */
  0xAE65,   /* U+2E65 */
  0xAE66,   /* U+2E66 */
  0xAE67,   /* U+2E67 */
  0xAE68,   /* U+2E68 */
  0xAE69,   /* U+2E69 */
  0xAE6A,   /* U+2E6A */
  0xAE6B,   /* U+2E6B */
  0xAE6C,   /* U+2E6C */
  0xAE6D,   /* U+2E6D */
  0xAE6E,   /* U+2E6E */
  0xAE6F,   /* U+2E6F */
  0xAE70,   /* U+2E70 */
  0xAE71,   /* U+2E71 */
  0xAE72,   /* U+2E72 */
  0xAE73,   /* U+2E73 */
  0xAE74,   /* U+2E74 */
  0xAE75,   /* U+2E75 */
  0xAE76,   /* U+2E76 */
  0xAE77,   /* U+2E77 */
  0xAE78,   /* U+2E78 */
  0xAE79,   /* U+2E79 */
  0xAE7A,   /* U+2E7A */
  0xAE7B,   /* U+2E7B */
  0xAE7C,   /* U+2E7C */
  0xAE7D,   /* U+2E7D */
  0xAE7E,   /* U+2E7E */
  0xAE7F,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0xAE9A,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0xAEF4,   /* U+2EF4 */
  0xAEF5,   /* U+2EF5 */
  0xAEF6,   /* U+2EF6 */
  0xAEF7,   /* U+2EF7 */
  0xAEF8,   /* U+2EF8 */
  0xAEF9,   /* U+2EF9 */
  0xAEFA,   /* U+2EFA */
  0xAEFB,   /* U+2EFB */
  0xAEFC,   /* U+2EFC */
  0xAEFD,   /* U+2EFD */
  0xAEFE,   /* U+2EFE */
  0xAEFF,   /* U+2EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Primary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0000,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0000,   /* U+2EA9 */
  0x0000,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0000,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0000,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0000,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0000,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0000,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0000,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0000,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Secondary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0110,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0110,   /* U+2EA9 */
  0x0110,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0110,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0110,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0110,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0110,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0110,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0110,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0110,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */

  /* Tertiary weight 3 for each character. */
  0x0000,   /* U+2E00 */
  0x0000,   /* U+2E01 */
  0x0000,   /* U+2E02 */
  0x0000,   /* U+2E03 */
  0x0000,   /* U+2E04 */
  0x0000,   /* U+2E05 */
  0x0000,   /* U+2E06 */
  0x0000,   /* U+2E07 */
  0x0000,   /* U+2E08 */
  0x0000,   /* U+2E09 */
  0x0000,   /* U+2E0A */
  0x0000,   /* U+2E0B */
  0x0000,   /* U+2E0C */
  0x0000,   /* U+2E0D */
  0x0000,   /* U+2E0E */
  0x0000,   /* U+2E0F */
  0x0000,   /* U+2E10 */
  0x0000,   /* U+2E11 */
  0x0000,   /* U+2E12 */
  0x0000,   /* U+2E13 */
  0x0000,   /* U+2E14 */
  0x0000,   /* U+2E15 */
  0x0000,   /* U+2E16 */
  0x0000,   /* U+2E17 */
  0x0000,   /* U+2E18 */
  0x0000,   /* U+2E19 */
  0x0000,   /* U+2E1A */
  0x0000,   /* U+2E1B */
  0x0000,   /* U+2E1C */
  0x0000,   /* U+2E1D */
  0x0000,   /* U+2E1E */
  0x0000,   /* U+2E1F */
  0x0000,   /* U+2E20 */
  0x0000,   /* U+2E21 */
  0x0000,   /* U+2E22 */
  0x0000,   /* U+2E23 */
  0x0000,   /* U+2E24 */
  0x0000,   /* U+2E25 */
  0x0000,   /* U+2E26 */
  0x0000,   /* U+2E27 */
  0x0000,   /* U+2E28 */
  0x0000,   /* U+2E29 */
  0x0000,   /* U+2E2A */
  0x0000,   /* U+2E2B */
  0x0000,   /* U+2E2C */
  0x0000,   /* U+2E2D */
  0x0000,   /* U+2E2E */
  0x0000,   /* U+2E2F */
  0x0000,   /* U+2E30 */
  0x0000,   /* U+2E31 */
  0x0000,   /* U+2E32 */
  0x0000,   /* U+2E33 */
  0x0000,   /* U+2E34 */
  0x0000,   /* U+2E35 */
  0x0000,   /* U+2E36 */
  0x0000,   /* U+2E37 */
  0x0000,   /* U+2E38 */
  0x0000,   /* U+2E39 */
  0x0000,   /* U+2E3A */
  0x0000,   /* U+2E3B */
  0x0000,   /* U+2E3C */
  0x0000,   /* U+2E3D */
  0x0000,   /* U+2E3E */
  0x0000,   /* U+2E3F */
  0x0000,   /* U+2E40 */
  0x0000,   /* U+2E41 */
  0x0000,   /* U+2E42 */
  0x0000,   /* U+2E43 */
  0x0000,   /* U+2E44 */
  0x0000,   /* U+2E45 */
  0x0000,   /* U+2E46 */
  0x0000,   /* U+2E47 */
  0x0000,   /* U+2E48 */
  0x0000,   /* U+2E49 */
  0x0000,   /* U+2E4A */
  0x0000,   /* U+2E4B */
  0x0000,   /* U+2E4C */
  0x0000,   /* U+2E4D */
  0x0000,   /* U+2E4E */
  0x0000,   /* U+2E4F */
  0x0000,   /* U+2E50 */
  0x0000,   /* U+2E51 */
  0x0000,   /* U+2E52 */
  0x0000,   /* U+2E53 */
  0x0000,   /* U+2E54 */
  0x0000,   /* U+2E55 */
  0x0000,   /* U+2E56 */
  0x0000,   /* U+2E57 */
  0x0000,   /* U+2E58 */
  0x0000,   /* U+2E59 */
  0x0000,   /* U+2E5A */
  0x0000,   /* U+2E5B */
  0x0000,   /* U+2E5C */
  0x0000,   /* U+2E5D */
  0x0000,   /* U+2E5E */
  0x0000,   /* U+2E5F */
  0x0000,   /* U+2E60 */
  0x0000,   /* U+2E61 */
  0x0000,   /* U+2E62 */
  0x0000,   /* U+2E63 */
  0x0000,   /* U+2E64 */
  0x0000,   /* U+2E65 */
  0x0000,   /* U+2E66 */
  0x0000,   /* U+2E67 */
  0x0000,   /* U+2E68 */
  0x0000,   /* U+2E69 */
  0x0000,   /* U+2E6A */
  0x0000,   /* U+2E6B */
  0x0000,   /* U+2E6C */
  0x0000,   /* U+2E6D */
  0x0000,   /* U+2E6E */
  0x0000,   /* U+2E6F */
  0x0000,   /* U+2E70 */
  0x0000,   /* U+2E71 */
  0x0000,   /* U+2E72 */
  0x0000,   /* U+2E73 */
  0x0000,   /* U+2E74 */
  0x0000,   /* U+2E75 */
  0x0000,   /* U+2E76 */
  0x0000,   /* U+2E77 */
  0x0000,   /* U+2E78 */
  0x0000,   /* U+2E79 */
  0x0000,   /* U+2E7A */
  0x0000,   /* U+2E7B */
  0x0000,   /* U+2E7C */
  0x0000,   /* U+2E7D */
  0x0000,   /* U+2E7E */
  0x0000,   /* U+2E7F */
  0x0000,   /* U+2E80 */
  0x0000,   /* U+2E81 */
  0x0000,   /* U+2E82 */
  0x0000,   /* U+2E83 */
  0x0000,   /* U+2E84 */
  0x0000,   /* U+2E85 */
  0x0000,   /* U+2E86 */
  0x0004,   /* U+2E87 */
  0x0000,   /* U+2E88 */
  0x0000,   /* U+2E89 */
  0x0000,   /* U+2E8A */
  0x0000,   /* U+2E8B */
  0x0000,   /* U+2E8C */
  0x0000,   /* U+2E8D */
  0x0000,   /* U+2E8E */
  0x0000,   /* U+2E8F */
  0x0000,   /* U+2E90 */
  0x0000,   /* U+2E91 */
  0x0000,   /* U+2E92 */
  0x0000,   /* U+2E93 */
  0x0000,   /* U+2E94 */
  0x0000,   /* U+2E95 */
  0x0000,   /* U+2E96 */
  0x0000,   /* U+2E97 */
  0x0000,   /* U+2E98 */
  0x0000,   /* U+2E99 */
  0x0000,   /* U+2E9A */
  0x0000,   /* U+2E9B */
  0x0000,   /* U+2E9C */
  0x0000,   /* U+2E9D */
  0x0000,   /* U+2E9E */
  0x0000,   /* U+2E9F */
  0x0000,   /* U+2EA0 */
  0x0000,   /* U+2EA1 */
  0x0000,   /* U+2EA2 */
  0x0000,   /* U+2EA3 */
  0x0000,   /* U+2EA4 */
  0x0000,   /* U+2EA5 */
  0x0000,   /* U+2EA6 */
  0x0000,   /* U+2EA7 */
  0x0000,   /* U+2EA8 */
  0x0004,   /* U+2EA9 */
  0x0004,   /* U+2EAA */
  0x0000,   /* U+2EAB */
  0x0000,   /* U+2EAC */
  0x0000,   /* U+2EAD */
  0x0000,   /* U+2EAE */
  0x0000,   /* U+2EAF */
  0x0000,   /* U+2EB0 */
  0x0000,   /* U+2EB1 */
  0x0000,   /* U+2EB2 */
  0x0004,   /* U+2EB3 */
  0x0000,   /* U+2EB4 */
  0x0004,   /* U+2EB5 */
  0x0000,   /* U+2EB6 */
  0x0000,   /* U+2EB7 */
  0x0000,   /* U+2EB8 */
  0x0000,   /* U+2EB9 */
  0x0000,   /* U+2EBA */
  0x0000,   /* U+2EBB */
  0x0000,   /* U+2EBC */
  0x0000,   /* U+2EBD */
  0x0000,   /* U+2EBE */
  0x0000,   /* U+2EBF */
  0x0000,   /* U+2EC0 */
  0x0000,   /* U+2EC1 */
  0x0000,   /* U+2EC2 */
  0x0000,   /* U+2EC3 */
  0x0000,   /* U+2EC4 */
  0x0000,   /* U+2EC5 */
  0x0000,   /* U+2EC6 */
  0x0004,   /* U+2EC7 */
  0x0000,   /* U+2EC8 */
  0x0000,   /* U+2EC9 */
  0x0004,   /* U+2ECA */
  0x0000,   /* U+2ECB */
  0x0000,   /* U+2ECC */
  0x0000,   /* U+2ECD */
  0x0000,   /* U+2ECE */
  0x0000,   /* U+2ECF */
  0x0000,   /* U+2ED0 */
  0x0000,   /* U+2ED1 */
  0x0000,   /* U+2ED2 */
  0x0000,   /* U+2ED3 */
  0x0000,   /* U+2ED4 */
  0x0004,   /* U+2ED5 */
  0x0000,   /* U+2ED6 */
  0x0000,   /* U+2ED7 */
  0x0000,   /* U+2ED8 */
  0x0000,   /* U+2ED9 */
  0x0000,   /* U+2EDA */
  0x0000,   /* U+2EDB */
  0x0000,   /* U+2EDC */
  0x0000,   /* U+2EDD */
  0x0004,   /* U+2EDE */
  0x0000,   /* U+2EDF */
  0x0000,   /* U+2EE0 */
  0x0004,   /* U+2EE1 */
  0x0000,   /* U+2EE2 */
  0x0000,   /* U+2EE3 */
  0x0000,   /* U+2EE4 */
  0x0000,   /* U+2EE5 */
  0x0000,   /* U+2EE6 */
  0x0000,   /* U+2EE7 */
  0x0000,   /* U+2EE8 */
  0x0000,   /* U+2EE9 */
  0x0000,   /* U+2EEA */
  0x0000,   /* U+2EEB */
  0x0000,   /* U+2EEC */
  0x0000,   /* U+2EED */
  0x0000,   /* U+2EEE */
  0x0000,   /* U+2EEF */
  0x0000,   /* U+2EF0 */
  0x0000,   /* U+2EF1 */
  0x0000,   /* U+2EF2 */
  0x0000,   /* U+2EF3 */
  0x0000,   /* U+2EF4 */
  0x0000,   /* U+2EF5 */
  0x0000,   /* U+2EF6 */
  0x0000,   /* U+2EF7 */
  0x0000,   /* U+2EF8 */
  0x0000,   /* U+2EF9 */
  0x0000,   /* U+2EFA */
  0x0000,   /* U+2EFB */
  0x0000,   /* U+2EFC */
  0x0000,   /* U+2EFD */
  0x0000,   /* U+2EFE */
  0x0000,   /* U+2EFF */
};

uint16_t zh_han_p030[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 

  /* Primary weight 1 for each character. */
  0x0209,   /* U+3000 */
  0x0231,   /* U+3001 */
  0x028A,   /* U+3002 */
  0x03AC,   /* U+3003 */
  0x1A8B,   /* U+3004 */
  0x1C07,   /* U+3005 */
  0xDEE3,   /* U+3006 */
  0x62A1,   /* U+3007 */
  0x036F,   /* U+3008 */
  0x0370,   /* U+3009 */
  0x0371,   /* U+300A */
  0x0372,   /* U+300B */
  0x0373,   /* U+300C */
  0x0374,   /* U+300D */
  0x0375,   /* U+300E */
  0x0376,   /* U+300F */
  0x0377,   /* U+3010 */
  0x0378,   /* U+3011 */
  0x1A8C,   /* U+3012 */
  0x1A8D,   /* U+3013 */
  0x0379,   /* U+3014 */
  0x037A,   /* U+3015 */
  0x037B,   /* U+3016 */
  0x037C,   /* U+3017 */
  0x037D,   /* U+3018 */
  0x037E,   /* U+3019 */
  0x037F,   /* U+301A */
  0x0380,   /* U+301B */
  0x021E,   /* U+301C */
  0x0312,   /* U+301D */
  0x0313,   /* U+301E */
  0x0314,   /* U+301F */
  0x1A8E,   /* U+3020 */
  0x1C3E,   /* U+3021 */
  0x1C3F,   /* U+3022 */
  0x1C40,   /* U+3023 */
  0x1C41,   /* U+3024 */
  0x1C42,   /* U+3025 */
  0x1C43,   /* U+3026 */
  0x1C44,   /* U+3027 */
  0x1C45,   /* U+3028 */
  0x1C46,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x021F,   /* U+3030 */
  0x1C0A,   /* U+3031 */
  0x1C0A,   /* U+3032 */
  0x1C0B,   /* U+3033 */
  0x1C0B,   /* U+3034 */
  0x1C0C,   /* U+3035 */
  0x1A8C,   /* U+3036 */
  0x1A8F,   /* U+3037 */
  0x857A,   /* U+3038 */
  0x7008,   /* U+3039 */
  0x8114,   /* U+303A */
  0x1C08,   /* U+303B */
  0xDEF6,   /* U+303C */
  0x03AD,   /* U+303D */
  0x1A90,   /* U+303E */
  0x1A91,   /* U+303F */
  0xF622,   /* U+3040 */
  0xDED7,   /* U+3041 */
  0xDED7,   /* U+3042 */
  0xDED8,   /* U+3043 */
  0xDED8,   /* U+3044 */
  0xDED9,   /* U+3045 */
  0xDED9,   /* U+3046 */
  0xDEDB,   /* U+3047 */
  0xDEDB,   /* U+3048 */
  0xDEDC,   /* U+3049 */
  0xDEDC,   /* U+304A */
  0xDEDD,   /* U+304B */
  0xDEDD,   /* U+304C */
  0xDEDE,   /* U+304D */
  0xDEDE,   /* U+304E */
  0xDEDF,   /* U+304F */
  0xDEDF,   /* U+3050 */
  0xDEE0,   /* U+3051 */
  0xDEE0,   /* U+3052 */
  0xDEE1,   /* U+3053 */
  0xDEE1,   /* U+3054 */
  0xDEE2,   /* U+3055 */
  0xDEE2,   /* U+3056 */
  0xDEE3,   /* U+3057 */
  0xDEE3,   /* U+3058 */
  0xDEE4,   /* U+3059 */
  0xDEE4,   /* U+305A */
  0xDEE5,   /* U+305B */
  0xDEE5,   /* U+305C */
  0xDEE6,   /* U+305D */
  0xDEE6,   /* U+305E */
  0xDEE7,   /* U+305F */
  0xDEE7,   /* U+3060 */
  0xDEE8,   /* U+3061 */
  0xDEE8,   /* U+3062 */
  0xDEE9,   /* U+3063 */
  0xDEE9,   /* U+3064 */
  0xDEE9,   /* U+3065 */
  0xDEEA,   /* U+3066 */
  0xDEEA,   /* U+3067 */
  0xDEEB,   /* U+3068 */
  0xDEEB,   /* U+3069 */
  0xDEEC,   /* U+306A */
  0xDEED,   /* U+306B */
  0xDEEE,   /* U+306C */
  0xDEEF,   /* U+306D */
  0xDEF0,   /* U+306E */
  0xDEF1,   /* U+306F */
  0xDEF1,   /* U+3070 */
  0xDEF1,   /* U+3071 */
  0xDEF2,   /* U+3072 */
  0xDEF2,   /* U+3073 */
  0xDEF2,   /* U+3074 */
  0xDEF3,   /* U+3075 */
  0xDEF3,   /* U+3076 */
  0xDEF3,   /* U+3077 */
  0xDEF4,   /* U+3078 */
  0xDEF4,   /* U+3079 */
  0xDEF4,   /* U+307A */
  0xDEF5,   /* U+307B */
  0xDEF5,   /* U+307C */
  0xDEF5,   /* U+307D */
  0xDEF6,   /* U+307E */
  0xDEF7,   /* U+307F */
  0xDEF8,   /* U+3080 */
  0xDEF9,   /* U+3081 */
  0xDEFA,   /* U+3082 */
  0xDEFB,   /* U+3083 */
  0xDEFB,   /* U+3084 */
  0xDEFC,   /* U+3085 */
  0xDEFC,   /* U+3086 */
  0xDEFE,   /* U+3087 */
  0xDEFE,   /* U+3088 */
  0xDEFF,   /* U+3089 */
  0xDF00,   /* U+308A */
  0xDF01,   /* U+308B */
  0xDF02,   /* U+308C */
  0xDF03,   /* U+308D */
  0xDF04,   /* U+308E */
  0xDF04,   /* U+308F */
  0xDF05,   /* U+3090 */
  0xDF06,   /* U+3091 */
  0xDF07,   /* U+3092 */
  0xDF08,   /* U+3093 */
  0xDED9,   /* U+3094 */
  0xDEDD,   /* U+3095 */
  0xDEE0,   /* U+3096 */
  0xF622,   /* U+3097 */
  0xF622,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0491,   /* U+309B */
  0x0492,   /* U+309C */
  0x1C0D,   /* U+309D */
  0x1C0D,   /* U+309E */
  0xDEFE,   /* U+309F */
  0x0220,   /* U+30A0 */
  0xDED7,   /* U+30A1 */
  0xDED7,   /* U+30A2 */
  0xDED8,   /* U+30A3 */
  0xDED8,   /* U+30A4 */
  0xDED9,   /* U+30A5 */
  0xDED9,   /* U+30A6 */
  0xDEDB,   /* U+30A7 */
  0xDEDB,   /* U+30A8 */
  0xDEDC,   /* U+30A9 */
  0xDEDC,   /* U+30AA */
  0xDEDD,   /* U+30AB */
  0xDEDD,   /* U+30AC */
  0xDEDE,   /* U+30AD */
  0xDEDE,   /* U+30AE */
  0xDEDF,   /* U+30AF */
  0xDEDF,   /* U+30B0 */
  0xDEE0,   /* U+30B1 */
  0xDEE0,   /* U+30B2 */
  0xDEE1,   /* U+30B3 */
  0xDEE1,   /* U+30B4 */
  0xDEE2,   /* U+30B5 */
  0xDEE2,   /* U+30B6 */
  0xDEE3,   /* U+30B7 */
  0xDEE3,   /* U+30B8 */
  0xDEE4,   /* U+30B9 */
  0xDEE4,   /* U+30BA */
  0xDEE5,   /* U+30BB */
  0xDEE5,   /* U+30BC */
  0xDEE6,   /* U+30BD */
  0xDEE6,   /* U+30BE */
  0xDEE7,   /* U+30BF */
  0xDEE7,   /* U+30C0 */
  0xDEE8,   /* U+30C1 */
  0xDEE8,   /* U+30C2 */
  0xDEE9,   /* U+30C3 */
  0xDEE9,   /* U+30C4 */
  0xDEE9,   /* U+30C5 */
  0xDEEA,   /* U+30C6 */
  0xDEEA,   /* U+30C7 */
  0xDEEB,   /* U+30C8 */
  0xDEEB,   /* U+30C9 */
  0xDEEC,   /* U+30CA */
  0xDEED,   /* U+30CB */
  0xDEEE,   /* U+30CC */
  0xDEEF,   /* U+30CD */
  0xDEF0,   /* U+30CE */
  0xDEF1,   /* U+30CF */
  0xDEF1,   /* U+30D0 */
  0xDEF1,   /* U+30D1 */
  0xDEF2,   /* U+30D2 */
  0xDEF2,   /* U+30D3 */
  0xDEF2,   /* U+30D4 */
  0xDEF3,   /* U+30D5 */
  0xDEF3,   /* U+30D6 */
  0xDEF3,   /* U+30D7 */
  0xDEF4,   /* U+30D8 */
  0xDEF4,   /* U+30D9 */
  0xDEF4,   /* U+30DA */
  0xDEF5,   /* U+30DB */
  0xDEF5,   /* U+30DC */
  0xDEF5,   /* U+30DD */
  0xDEF6,   /* U+30DE */
  0xDEF7,   /* U+30DF */
  0xDEF8,   /* U+30E0 */
  0xDEF9,   /* U+30E1 */
  0xDEFA,   /* U+30E2 */
  0xDEFB,   /* U+30E3 */
  0xDEFB,   /* U+30E4 */
  0xDEFC,   /* U+30E5 */
  0xDEFC,   /* U+30E6 */
  0xDEFE,   /* U+30E7 */
  0xDEFE,   /* U+30E8 */
  0xDEFF,   /* U+30E9 */
  0xDF00,   /* U+30EA */
  0xDF01,   /* U+30EB */
  0xDF02,   /* U+30EC */
  0xDF03,   /* U+30ED */
  0xDF04,   /* U+30EE */
  0xDF04,   /* U+30EF */
  0xDF05,   /* U+30F0 */
  0xDF06,   /* U+30F1 */
  0xDF07,   /* U+30F2 */
  0xDF08,   /* U+30F3 */
  0xDED9,   /* U+30F4 */
  0xDEDD,   /* U+30F5 */
  0xDEE0,   /* U+30F6 */
  0xDF04,   /* U+30F7 */
  0xDF05,   /* U+30F8 */
  0xDF06,   /* U+30F9 */
  0xDF07,   /* U+30FA */
  0x0221,   /* U+30FB */
  0x1C0E,   /* U+30FC */
  0x1C0F,   /* U+30FD */
  0x1C0F,   /* U+30FE */
  0xDEE1,   /* U+30FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3000 */
  0x0020,   /* U+3001 */
  0x0020,   /* U+3002 */
  0x0020,   /* U+3003 */
  0x0020,   /* U+3004 */
  0x0020,   /* U+3005 */
  0x0020,   /* U+3006 */
  0x0020,   /* U+3007 */
  0x0020,   /* U+3008 */
  0x0020,   /* U+3009 */
  0x0020,   /* U+300A */
  0x0020,   /* U+300B */
  0x0020,   /* U+300C */
  0x0020,   /* U+300D */
  0x0020,   /* U+300E */
  0x0020,   /* U+300F */
  0x0020,   /* U+3010 */
  0x0020,   /* U+3011 */
  0x0020,   /* U+3012 */
  0x0020,   /* U+3013 */
  0x0020,   /* U+3014 */
  0x0020,   /* U+3015 */
  0x0020,   /* U+3016 */
  0x0020,   /* U+3017 */
  0x0020,   /* U+3018 */
  0x0020,   /* U+3019 */
  0x0020,   /* U+301A */
  0x0020,   /* U+301B */
  0x0020,   /* U+301C */
  0x0020,   /* U+301D */
  0x0020,   /* U+301E */
  0x0020,   /* U+301F */
  0x0020,   /* U+3020 */
  0x0020,   /* U+3021 */
  0x0020,   /* U+3022 */
  0x0020,   /* U+3023 */
  0x0020,   /* U+3024 */
  0x0020,   /* U+3025 */
  0x0020,   /* U+3026 */
  0x0020,   /* U+3027 */
  0x0020,   /* U+3028 */
  0x0020,   /* U+3029 */
  0x00FB,   /* U+302A */
  0x00FC,   /* U+302B */
  0x00FD,   /* U+302C */
  0x00FE,   /* U+302D */
  0x00FF,   /* U+302E */
  0x0100,   /* U+302F */
  0x0020,   /* U+3030 */
  0x0020,   /* U+3031 */
  0x0020,   /* U+3032 */
  0x0020,   /* U+3033 */
  0x0020,   /* U+3034 */
  0x0020,   /* U+3035 */
  0x0020,   /* U+3036 */
  0x0020,   /* U+3037 */
  0x0020,   /* U+3038 */
  0x0020,   /* U+3039 */
  0x0020,   /* U+303A */
  0x0020,   /* U+303B */
  0x0020,   /* U+303C */
  0x0020,   /* U+303D */
  0x0020,   /* U+303E */
  0x0020,   /* U+303F */
  0x0020,   /* U+3040 */
  0x0020,   /* U+3041 */
  0x0020,   /* U+3042 */
  0x0020,   /* U+3043 */
  0x0020,   /* U+3044 */
  0x0020,   /* U+3045 */
  0x0020,   /* U+3046 */
  0x0020,   /* U+3047 */
  0x0020,   /* U+3048 */
  0x0020,   /* U+3049 */
  0x0020,   /* U+304A */
  0x0020,   /* U+304B */
  0x0020,   /* U+304C */
  0x0020,   /* U+304D */
  0x0020,   /* U+304E */
  0x0020,   /* U+304F */
  0x0020,   /* U+3050 */
  0x0020,   /* U+3051 */
  0x0020,   /* U+3052 */
  0x0020,   /* U+3053 */
  0x0020,   /* U+3054 */
  0x0020,   /* U+3055 */
  0x0020,   /* U+3056 */
  0x0020,   /* U+3057 */
  0x0020,   /* U+3058 */
  0x0020,   /* U+3059 */
  0x0020,   /* U+305A */
  0x0020,   /* U+305B */
  0x0020,   /* U+305C */
  0x0020,   /* U+305D */
  0x0020,   /* U+305E */
  0x0020,   /* U+305F */
  0x0020,   /* U+3060 */
  0x0020,   /* U+3061 */
  0x0020,   /* U+3062 */
  0x0020,   /* U+3063 */
  0x0020,   /* U+3064 */
  0x0020,   /* U+3065 */
  0x0020,   /* U+3066 */
  0x0020,   /* U+3067 */
  0x0020,   /* U+3068 */
  0x0020,   /* U+3069 */
  0x0020,   /* U+306A */
  0x0020,   /* U+306B */
  0x0020,   /* U+306C */
  0x0020,   /* U+306D */
  0x0020,   /* U+306E */
  0x0020,   /* U+306F */
  0x0020,   /* U+3070 */
  0x0020,   /* U+3071 */
  0x0020,   /* U+3072 */
  0x0020,   /* U+3073 */
  0x0020,   /* U+3074 */
  0x0020,   /* U+3075 */
  0x0020,   /* U+3076 */
  0x0020,   /* U+3077 */
  0x0020,   /* U+3078 */
  0x0020,   /* U+3079 */
  0x0020,   /* U+307A */
  0x0020,   /* U+307B */
  0x0020,   /* U+307C */
  0x0020,   /* U+307D */
  0x0020,   /* U+307E */
  0x0020,   /* U+307F */
  0x0020,   /* U+3080 */
  0x0020,   /* U+3081 */
  0x0020,   /* U+3082 */
  0x0020,   /* U+3083 */
  0x0020,   /* U+3084 */
  0x0020,   /* U+3085 */
  0x0020,   /* U+3086 */
  0x0020,   /* U+3087 */
  0x0020,   /* U+3088 */
  0x0020,   /* U+3089 */
  0x0020,   /* U+308A */
  0x0020,   /* U+308B */
  0x0020,   /* U+308C */
  0x0020,   /* U+308D */
  0x0020,   /* U+308E */
  0x0020,   /* U+308F */
  0x0020,   /* U+3090 */
  0x0020,   /* U+3091 */
  0x0020,   /* U+3092 */
  0x0020,   /* U+3093 */
  0x0020,   /* U+3094 */
  0x0020,   /* U+3095 */
  0x0020,   /* U+3096 */
  0x0020,   /* U+3097 */
  0x0020,   /* U+3098 */
  0x0037,   /* U+3099 */
  0x0038,   /* U+309A */
  0x0020,   /* U+309B */
  0x0020,   /* U+309C */
  0x0020,   /* U+309D */
  0x0020,   /* U+309E */
  0x0020,   /* U+309F */
  0x0020,   /* U+30A0 */
  0x0020,   /* U+30A1 */
  0x0020,   /* U+30A2 */
  0x0020,   /* U+30A3 */
  0x0020,   /* U+30A4 */
  0x0020,   /* U+30A5 */
  0x0020,   /* U+30A6 */
  0x0020,   /* U+30A7 */
  0x0020,   /* U+30A8 */
  0x0020,   /* U+30A9 */
  0x0020,   /* U+30AA */
  0x0020,   /* U+30AB */
  0x0020,   /* U+30AC */
  0x0020,   /* U+30AD */
  0x0020,   /* U+30AE */
  0x0020,   /* U+30AF */
  0x0020,   /* U+30B0 */
  0x0020,   /* U+30B1 */
  0x0020,   /* U+30B2 */
  0x0020,   /* U+30B3 */
  0x0020,   /* U+30B4 */
  0x0020,   /* U+30B5 */
  0x0020,   /* U+30B6 */
  0x0020,   /* U+30B7 */
  0x0020,   /* U+30B8 */
  0x0020,   /* U+30B9 */
  0x0020,   /* U+30BA */
  0x0020,   /* U+30BB */
  0x0020,   /* U+30BC */
  0x0020,   /* U+30BD */
  0x0020,   /* U+30BE */
  0x0020,   /* U+30BF */
  0x0020,   /* U+30C0 */
  0x0020,   /* U+30C1 */
  0x0020,   /* U+30C2 */
  0x0020,   /* U+30C3 */
  0x0020,   /* U+30C4 */
  0x0020,   /* U+30C5 */
  0x0020,   /* U+30C6 */
  0x0020,   /* U+30C7 */
  0x0020,   /* U+30C8 */
  0x0020,   /* U+30C9 */
  0x0020,   /* U+30CA */
  0x0020,   /* U+30CB */
  0x0020,   /* U+30CC */
  0x0020,   /* U+30CD */
  0x0020,   /* U+30CE */
  0x0020,   /* U+30CF */
  0x0020,   /* U+30D0 */
  0x0020,   /* U+30D1 */
  0x0020,   /* U+30D2 */
  0x0020,   /* U+30D3 */
  0x0020,   /* U+30D4 */
  0x0020,   /* U+30D5 */
  0x0020,   /* U+30D6 */
  0x0020,   /* U+30D7 */
  0x0020,   /* U+30D8 */
  0x0020,   /* U+30D9 */
  0x0020,   /* U+30DA */
  0x0020,   /* U+30DB */
  0x0020,   /* U+30DC */
  0x0020,   /* U+30DD */
  0x0020,   /* U+30DE */
  0x0020,   /* U+30DF */
  0x0020,   /* U+30E0 */
  0x0020,   /* U+30E1 */
  0x0020,   /* U+30E2 */
  0x0020,   /* U+30E3 */
  0x0020,   /* U+30E4 */
  0x0020,   /* U+30E5 */
  0x0020,   /* U+30E6 */
  0x0020,   /* U+30E7 */
  0x0020,   /* U+30E8 */
  0x0020,   /* U+30E9 */
  0x0020,   /* U+30EA */
  0x0020,   /* U+30EB */
  0x0020,   /* U+30EC */
  0x0020,   /* U+30ED */
  0x0020,   /* U+30EE */
  0x0020,   /* U+30EF */
  0x0020,   /* U+30F0 */
  0x0020,   /* U+30F1 */
  0x0020,   /* U+30F2 */
  0x0020,   /* U+30F3 */
  0x0020,   /* U+30F4 */
  0x0020,   /* U+30F5 */
  0x0020,   /* U+30F6 */
  0x0020,   /* U+30F7 */
  0x0020,   /* U+30F8 */
  0x0020,   /* U+30F9 */
  0x0020,   /* U+30FA */
  0x0020,   /* U+30FB */
  0x0020,   /* U+30FC */
  0x0020,   /* U+30FD */
  0x0020,   /* U+30FE */
  0x0020,   /* U+30FF */

  /* Tertiary weight 1 for each character. */
  0x0003,   /* U+3000 */
  0x0002,   /* U+3001 */
  0x0002,   /* U+3002 */
  0x0002,   /* U+3003 */
  0x0002,   /* U+3004 */
  0x0002,   /* U+3005 */
  0x0004,   /* U+3006 */
  0x0002,   /* U+3007 */
  0x0002,   /* U+3008 */
  0x0002,   /* U+3009 */
  0x0002,   /* U+300A */
  0x0002,   /* U+300B */
  0x0002,   /* U+300C */
  0x0002,   /* U+300D */
  0x0002,   /* U+300E */
  0x0002,   /* U+300F */
  0x0002,   /* U+3010 */
  0x0002,   /* U+3011 */
  0x0002,   /* U+3012 */
  0x0002,   /* U+3013 */
  0x0002,   /* U+3014 */
  0x0002,   /* U+3015 */
  0x0002,   /* U+3016 */
  0x0002,   /* U+3017 */
  0x0002,   /* U+3018 */
  0x0002,   /* U+3019 */
  0x0002,   /* U+301A */
  0x0002,   /* U+301B */
  0x0002,   /* U+301C */
  0x0002,   /* U+301D */
  0x0002,   /* U+301E */
  0x0002,   /* U+301F */
  0x0002,   /* U+3020 */
  0x0002,   /* U+3021 */
  0x0002,   /* U+3022 */
  0x0002,   /* U+3023 */
  0x0002,   /* U+3024 */
  0x0002,   /* U+3025 */
  0x0002,   /* U+3026 */
  0x0002,   /* U+3027 */
  0x0002,   /* U+3028 */
  0x0002,   /* U+3029 */
  0x0002,   /* U+302A */
  0x0002,   /* U+302B */
  0x0002,   /* U+302C */
  0x0002,   /* U+302D */
  0x0002,   /* U+302E */
  0x0002,   /* U+302F */
  0x0002,   /* U+3030 */
  0x0002,   /* U+3031 */
  0x0002,   /* U+3032 */
  0x0002,   /* U+3033 */
  0x0002,   /* U+3034 */
  0x0002,   /* U+3035 */
  0x0004,   /* U+3036 */
  0x0002,   /* U+3037 */
  0x0004,   /* U+3038 */
  0x0004,   /* U+3039 */
  0x0004,   /* U+303A */
  0x0002,   /* U+303B */
  0x0004,   /* U+303C */
  0x0002,   /* U+303D */
  0x0002,   /* U+303E */
  0x0002,   /* U+303F */
  0x0002,   /* U+3040 */
  0x000D,   /* U+3041 */
  0x000E,   /* U+3042 */
  0x000D,   /* U+3043 */
  0x000E,   /* U+3044 */
  0x000D,   /* U+3045 */
  0x000E,   /* U+3046 */
  0x000D,   /* U+3047 */
  0x000E,   /* U+3048 */
  0x000D,   /* U+3049 */
  0x000E,   /* U+304A */
  0x000E,   /* U+304B */
  0x000E,   /* U+304C */
  0x000E,   /* U+304D */
  0x000E,   /* U+304E */
  0x000E,   /* U+304F */
  0x000E,   /* U+3050 */
  0x000E,   /* U+3051 */
  0x000E,   /* U+3052 */
  0x000E,   /* U+3053 */
  0x000E,   /* U+3054 */
  0x000E,   /* U+3055 */
  0x000E,   /* U+3056 */
  0x000E,   /* U+3057 */
  0x000E,   /* U+3058 */
  0x000E,   /* U+3059 */
  0x000E,   /* U+305A */
  0x000E,   /* U+305B */
  0x000E,   /* U+305C */
  0x000E,   /* U+305D */
  0x000E,   /* U+305E */
  0x000E,   /* U+305F */
  0x000E,   /* U+3060 */
  0x000E,   /* U+3061 */
  0x000E,   /* U+3062 */
  0x000D,   /* U+3063 */
  0x000E,   /* U+3064 */
  0x000E,   /* U+3065 */
  0x000E,   /* U+3066 */
  0x000E,   /* U+3067 */
  0x000E,   /* U+3068 */
  0x000E,   /* U+3069 */
  0x000E,   /* U+306A */
  0x000E,   /* U+306B */
  0x000E,   /* U+306C */
  0x000E,   /* U+306D */
  0x000E,   /* U+306E */
  0x000E,   /* U+306F */
  0x000E,   /* U+3070 */
  0x000E,   /* U+3071 */
  0x000E,   /* U+3072 */
  0x000E,   /* U+3073 */
  0x000E,   /* U+3074 */
  0x000E,   /* U+3075 */
  0x000E,   /* U+3076 */
  0x000E,   /* U+3077 */
  0x000E,   /* U+3078 */
  0x000E,   /* U+3079 */
  0x000E,   /* U+307A */
  0x000E,   /* U+307B */
  0x000E,   /* U+307C */
  0x000E,   /* U+307D */
  0x000E,   /* U+307E */
  0x000E,   /* U+307F */
  0x000E,   /* U+3080 */
  0x000E,   /* U+3081 */
  0x000E,   /* U+3082 */
  0x000D,   /* U+3083 */
  0x000E,   /* U+3084 */
  0x000D,   /* U+3085 */
  0x000E,   /* U+3086 */
  0x000D,   /* U+3087 */
  0x000E,   /* U+3088 */
  0x000E,   /* U+3089 */
  0x000E,   /* U+308A */
  0x000E,   /* U+308B */
  0x000E,   /* U+308C */
  0x000E,   /* U+308D */
  0x000D,   /* U+308E */
  0x000E,   /* U+308F */
  0x000E,   /* U+3090 */
  0x000E,   /* U+3091 */
  0x000E,   /* U+3092 */
  0x000E,   /* U+3093 */
  0x000E,   /* U+3094 */
  0x000D,   /* U+3095 */
  0x000D,   /* U+3096 */
  0x0002,   /* U+3097 */
  0x0002,   /* U+3098 */
  0x0002,   /* U+3099 */
  0x0002,   /* U+309A */
  0x0002,   /* U+309B */
  0x0002,   /* U+309C */
  0x0002,   /* U+309D */
  0x0002,   /* U+309E */
  0x0016,   /* U+309F */
  0x0002,   /* U+30A0 */
  0x000F,   /* U+30A1 */
  0x0011,   /* U+30A2 */
  0x000F,   /* U+30A3 */
  0x0011,   /* U+30A4 */
  0x000F,   /* U+30A5 */
  0x0011,   /* U+30A6 */
  0x000F,   /* U+30A7 */
  0x0011,   /* U+30A8 */
  0x000F,   /* U+30A9 */
  0x0011,   /* U+30AA */
  0x0011,   /* U+30AB */
  0x0011,   /* U+30AC */
  0x0011,   /* U+30AD */
  0x0011,   /* U+30AE */
  0x0011,   /* U+30AF */
  0x0011,   /* U+30B0 */
  0x0011,   /* U+30B1 */
  0x0011,   /* U+30B2 */
  0x0011,   /* U+30B3 */
  0x0011,   /* U+30B4 */
  0x0011,   /* U+30B5 */
  0x0011,   /* U+30B6 */
  0x0011,   /* U+30B7 */
  0x0011,   /* U+30B8 */
  0x0011,   /* U+30B9 */
  0x0011,   /* U+30BA */
  0x0011,   /* U+30BB */
  0x0011,   /* U+30BC */
  0x0011,   /* U+30BD */
  0x0011,   /* U+30BE */
  0x0011,   /* U+30BF */
  0x0011,   /* U+30C0 */
  0x0011,   /* U+30C1 */
  0x0011,   /* U+30C2 */
  0x000F,   /* U+30C3 */
  0x0011,   /* U+30C4 */
  0x0011,   /* U+30C5 */
  0x0011,   /* U+30C6 */
  0x0011,   /* U+30C7 */
  0x0011,   /* U+30C8 */
  0x0011,   /* U+30C9 */
  0x0011,   /* U+30CA */
  0x0011,   /* U+30CB */
  0x0011,   /* U+30CC */
  0x0011,   /* U+30CD */
  0x0011,   /* U+30CE */
  0x0011,   /* U+30CF */
  0x0011,   /* U+30D0 */
  0x0011,   /* U+30D1 */
  0x0011,   /* U+30D2 */
  0x0011,   /* U+30D3 */
  0x0011,   /* U+30D4 */
  0x0011,   /* U+30D5 */
  0x0011,   /* U+30D6 */
  0x0011,   /* U+30D7 */
  0x0011,   /* U+30D8 */
  0x0011,   /* U+30D9 */
  0x0011,   /* U+30DA */
  0x0011,   /* U+30DB */
  0x0011,   /* U+30DC */
  0x0011,   /* U+30DD */
  0x0011,   /* U+30DE */
  0x0011,   /* U+30DF */
  0x0011,   /* U+30E0 */
  0x0011,   /* U+30E1 */
  0x0011,   /* U+30E2 */
  0x000F,   /* U+30E3 */
  0x0011,   /* U+30E4 */
  0x000F,   /* U+30E5 */
  0x0011,   /* U+30E6 */
  0x000F,   /* U+30E7 */
  0x0011,   /* U+30E8 */
  0x0011,   /* U+30E9 */
  0x0011,   /* U+30EA */
  0x0011,   /* U+30EB */
  0x0011,   /* U+30EC */
  0x0011,   /* U+30ED */
  0x000F,   /* U+30EE */
  0x0011,   /* U+30EF */
  0x0011,   /* U+30F0 */
  0x0011,   /* U+30F1 */
  0x0011,   /* U+30F2 */
  0x0011,   /* U+30F3 */
  0x0011,   /* U+30F4 */
  0x000F,   /* U+30F5 */
  0x000F,   /* U+30F6 */
  0x0011,   /* U+30F7 */
  0x0011,   /* U+30F8 */
  0x0011,   /* U+30F9 */
  0x0011,   /* U+30FA */
  0x0002,   /* U+30FB */
  0x0002,   /* U+30FC */
  0x0002,   /* U+30FD */
  0x0002,   /* U+30FE */
  0x0016,   /* U+30FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x0000,   /* U+3005 */
  0xDEF9,   /* U+3006 */
  0x0000,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x0000,   /* U+3021 */
  0x0000,   /* U+3022 */
  0x0000,   /* U+3023 */
  0x0000,   /* U+3024 */
  0x0000,   /* U+3025 */
  0x0000,   /* U+3026 */
  0x0000,   /* U+3027 */
  0x0000,   /* U+3028 */
  0x0000,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0000,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0000,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x0000,   /* U+3038 */
  0x0000,   /* U+3039 */
  0x0000,   /* U+303A */
  0x0000,   /* U+303B */
  0xDEE4,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0xB040,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0000,   /* U+304C */
  0x0000,   /* U+304D */
  0x0000,   /* U+304E */
  0x0000,   /* U+304F */
  0x0000,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0000,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0000,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0000,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0000,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0000,   /* U+305A */
  0x0000,   /* U+305B */
  0x0000,   /* U+305C */
  0x0000,   /* U+305D */
  0x0000,   /* U+305E */
  0x0000,   /* U+305F */
  0x0000,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0000,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0000,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0000,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0000,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0000,   /* U+3070 */
  0x0000,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0000,   /* U+3073 */
  0x0000,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0000,   /* U+3076 */
  0x0000,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0000,   /* U+3079 */
  0x0000,   /* U+307A */
  0x0000,   /* U+307B */
  0x0000,   /* U+307C */
  0x0000,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0000,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0xB097,   /* U+3097 */
  0xB098,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0000,   /* U+309E */
  0xDF00,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0000,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0000,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0000,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0000,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0000,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0000,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0000,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0000,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0000,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0000,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0000,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0000,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0000,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0000,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0000,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0000,   /* U+30D0 */
  0x0000,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0000,   /* U+30D3 */
  0x0000,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0000,   /* U+30D6 */
  0x0000,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0000,   /* U+30D9 */
  0x0000,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0000,   /* U+30DC */
  0x0000,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0000,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0000,   /* U+30F7 */
  0x0000,   /* U+30F8 */
  0x0000,   /* U+30F9 */
  0x0000,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0000,   /* U+30FE */
  0xDEEB,   /* U+30FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x0000,   /* U+3005 */
  0x0020,   /* U+3006 */
  0x0000,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x0000,   /* U+3021 */
  0x0000,   /* U+3022 */
  0x0000,   /* U+3023 */
  0x0000,   /* U+3024 */
  0x0000,   /* U+3025 */
  0x0000,   /* U+3026 */
  0x0000,   /* U+3027 */
  0x0000,   /* U+3028 */
  0x0000,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0037,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0037,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x0000,   /* U+3038 */
  0x0000,   /* U+3039 */
  0x0000,   /* U+303A */
  0x0000,   /* U+303B */
  0x0020,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0x0000,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0037,   /* U+304C */
  0x0000,   /* U+304D */
  0x0037,   /* U+304E */
  0x0000,   /* U+304F */
  0x0037,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0037,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0037,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0037,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0037,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0037,   /* U+305A */
  0x0000,   /* U+305B */
  0x0037,   /* U+305C */
  0x0000,   /* U+305D */
  0x0037,   /* U+305E */
  0x0000,   /* U+305F */
  0x0037,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0037,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0037,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0037,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0037,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0037,   /* U+3070 */
  0x0038,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0037,   /* U+3073 */
  0x0038,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0037,   /* U+3076 */
  0x0038,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0037,   /* U+3079 */
  0x0038,   /* U+307A */
  0x0000,   /* U+307B */
  0x0037,   /* U+307C */
  0x0038,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0037,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0x0000,   /* U+3097 */
  0x0000,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0037,   /* U+309E */
  0x0020,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0037,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0037,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0037,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0037,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0037,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0037,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0037,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0037,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0037,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0037,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0037,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0037,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0037,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0037,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0037,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0037,   /* U+30D0 */
  0x0038,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0037,   /* U+30D3 */
  0x0038,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0037,   /* U+30D6 */
  0x0038,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0037,   /* U+30D9 */
  0x0038,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0037,   /* U+30DC */
  0x0038,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0037,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0037,   /* U+30F7 */
  0x0037,   /* U+30F8 */
  0x0037,   /* U+30F9 */
  0x0037,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0037,   /* U+30FE */
  0x0020,   /* U+30FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3000 */
  0x0000,   /* U+3001 */
  0x0000,   /* U+3002 */
  0x0000,   /* U+3003 */
  0x0000,   /* U+3004 */
  0x0000,   /* U+3005 */
  0x0004,   /* U+3006 */
  0x0000,   /* U+3007 */
  0x0000,   /* U+3008 */
  0x0000,   /* U+3009 */
  0x0000,   /* U+300A */
  0x0000,   /* U+300B */
  0x0000,   /* U+300C */
  0x0000,   /* U+300D */
  0x0000,   /* U+300E */
  0x0000,   /* U+300F */
  0x0000,   /* U+3010 */
  0x0000,   /* U+3011 */
  0x0000,   /* U+3012 */
  0x0000,   /* U+3013 */
  0x0000,   /* U+3014 */
  0x0000,   /* U+3015 */
  0x0000,   /* U+3016 */
  0x0000,   /* U+3017 */
  0x0000,   /* U+3018 */
  0x0000,   /* U+3019 */
  0x0000,   /* U+301A */
  0x0000,   /* U+301B */
  0x0000,   /* U+301C */
  0x0000,   /* U+301D */
  0x0000,   /* U+301E */
  0x0000,   /* U+301F */
  0x0000,   /* U+3020 */
  0x0000,   /* U+3021 */
  0x0000,   /* U+3022 */
  0x0000,   /* U+3023 */
  0x0000,   /* U+3024 */
  0x0000,   /* U+3025 */
  0x0000,   /* U+3026 */
  0x0000,   /* U+3027 */
  0x0000,   /* U+3028 */
  0x0000,   /* U+3029 */
  0x0000,   /* U+302A */
  0x0000,   /* U+302B */
  0x0000,   /* U+302C */
  0x0000,   /* U+302D */
  0x0000,   /* U+302E */
  0x0000,   /* U+302F */
  0x0000,   /* U+3030 */
  0x0000,   /* U+3031 */
  0x0002,   /* U+3032 */
  0x0000,   /* U+3033 */
  0x0002,   /* U+3034 */
  0x0000,   /* U+3035 */
  0x0000,   /* U+3036 */
  0x0000,   /* U+3037 */
  0x0000,   /* U+3038 */
  0x0000,   /* U+3039 */
  0x0000,   /* U+303A */
  0x0000,   /* U+303B */
  0x0004,   /* U+303C */
  0x0000,   /* U+303D */
  0x0000,   /* U+303E */
  0x0000,   /* U+303F */
  0x0000,   /* U+3040 */
  0x0000,   /* U+3041 */
  0x0000,   /* U+3042 */
  0x0000,   /* U+3043 */
  0x0000,   /* U+3044 */
  0x0000,   /* U+3045 */
  0x0000,   /* U+3046 */
  0x0000,   /* U+3047 */
  0x0000,   /* U+3048 */
  0x0000,   /* U+3049 */
  0x0000,   /* U+304A */
  0x0000,   /* U+304B */
  0x0002,   /* U+304C */
  0x0000,   /* U+304D */
  0x0002,   /* U+304E */
  0x0000,   /* U+304F */
  0x0002,   /* U+3050 */
  0x0000,   /* U+3051 */
  0x0002,   /* U+3052 */
  0x0000,   /* U+3053 */
  0x0002,   /* U+3054 */
  0x0000,   /* U+3055 */
  0x0002,   /* U+3056 */
  0x0000,   /* U+3057 */
  0x0002,   /* U+3058 */
  0x0000,   /* U+3059 */
  0x0002,   /* U+305A */
  0x0000,   /* U+305B */
  0x0002,   /* U+305C */
  0x0000,   /* U+305D */
  0x0002,   /* U+305E */
  0x0000,   /* U+305F */
  0x0002,   /* U+3060 */
  0x0000,   /* U+3061 */
  0x0002,   /* U+3062 */
  0x0000,   /* U+3063 */
  0x0000,   /* U+3064 */
  0x0002,   /* U+3065 */
  0x0000,   /* U+3066 */
  0x0002,   /* U+3067 */
  0x0000,   /* U+3068 */
  0x0002,   /* U+3069 */
  0x0000,   /* U+306A */
  0x0000,   /* U+306B */
  0x0000,   /* U+306C */
  0x0000,   /* U+306D */
  0x0000,   /* U+306E */
  0x0000,   /* U+306F */
  0x0002,   /* U+3070 */
  0x0002,   /* U+3071 */
  0x0000,   /* U+3072 */
  0x0002,   /* U+3073 */
  0x0002,   /* U+3074 */
  0x0000,   /* U+3075 */
  0x0002,   /* U+3076 */
  0x0002,   /* U+3077 */
  0x0000,   /* U+3078 */
  0x0002,   /* U+3079 */
  0x0002,   /* U+307A */
  0x0000,   /* U+307B */
  0x0002,   /* U+307C */
  0x0002,   /* U+307D */
  0x0000,   /* U+307E */
  0x0000,   /* U+307F */
  0x0000,   /* U+3080 */
  0x0000,   /* U+3081 */
  0x0000,   /* U+3082 */
  0x0000,   /* U+3083 */
  0x0000,   /* U+3084 */
  0x0000,   /* U+3085 */
  0x0000,   /* U+3086 */
  0x0000,   /* U+3087 */
  0x0000,   /* U+3088 */
  0x0000,   /* U+3089 */
  0x0000,   /* U+308A */
  0x0000,   /* U+308B */
  0x0000,   /* U+308C */
  0x0000,   /* U+308D */
  0x0000,   /* U+308E */
  0x0000,   /* U+308F */
  0x0000,   /* U+3090 */
  0x0000,   /* U+3091 */
  0x0000,   /* U+3092 */
  0x0000,   /* U+3093 */
  0x0002,   /* U+3094 */
  0x0000,   /* U+3095 */
  0x0000,   /* U+3096 */
  0x0000,   /* U+3097 */
  0x0000,   /* U+3098 */
  0x0000,   /* U+3099 */
  0x0000,   /* U+309A */
  0x0000,   /* U+309B */
  0x0000,   /* U+309C */
  0x0000,   /* U+309D */
  0x0002,   /* U+309E */
  0x0016,   /* U+309F */
  0x0000,   /* U+30A0 */
  0x0000,   /* U+30A1 */
  0x0000,   /* U+30A2 */
  0x0000,   /* U+30A3 */
  0x0000,   /* U+30A4 */
  0x0000,   /* U+30A5 */
  0x0000,   /* U+30A6 */
  0x0000,   /* U+30A7 */
  0x0000,   /* U+30A8 */
  0x0000,   /* U+30A9 */
  0x0000,   /* U+30AA */
  0x0000,   /* U+30AB */
  0x0002,   /* U+30AC */
  0x0000,   /* U+30AD */
  0x0002,   /* U+30AE */
  0x0000,   /* U+30AF */
  0x0002,   /* U+30B0 */
  0x0000,   /* U+30B1 */
  0x0002,   /* U+30B2 */
  0x0000,   /* U+30B3 */
  0x0002,   /* U+30B4 */
  0x0000,   /* U+30B5 */
  0x0002,   /* U+30B6 */
  0x0000,   /* U+30B7 */
  0x0002,   /* U+30B8 */
  0x0000,   /* U+30B9 */
  0x0002,   /* U+30BA */
  0x0000,   /* U+30BB */
  0x0002,   /* U+30BC */
  0x0000,   /* U+30BD */
  0x0002,   /* U+30BE */
  0x0000,   /* U+30BF */
  0x0002,   /* U+30C0 */
  0x0000,   /* U+30C1 */
  0x0002,   /* U+30C2 */
  0x0000,   /* U+30C3 */
  0x0000,   /* U+30C4 */
  0x0002,   /* U+30C5 */
  0x0000,   /* U+30C6 */
  0x0002,   /* U+30C7 */
  0x0000,   /* U+30C8 */
  0x0002,   /* U+30C9 */
  0x0000,   /* U+30CA */
  0x0000,   /* U+30CB */
  0x0000,   /* U+30CC */
  0x0000,   /* U+30CD */
  0x0000,   /* U+30CE */
  0x0000,   /* U+30CF */
  0x0002,   /* U+30D0 */
  0x0002,   /* U+30D1 */
  0x0000,   /* U+30D2 */
  0x0002,   /* U+30D3 */
  0x0002,   /* U+30D4 */
  0x0000,   /* U+30D5 */
  0x0002,   /* U+30D6 */
  0x0002,   /* U+30D7 */
  0x0000,   /* U+30D8 */
  0x0002,   /* U+30D9 */
  0x0002,   /* U+30DA */
  0x0000,   /* U+30DB */
  0x0002,   /* U+30DC */
  0x0002,   /* U+30DD */
  0x0000,   /* U+30DE */
  0x0000,   /* U+30DF */
  0x0000,   /* U+30E0 */
  0x0000,   /* U+30E1 */
  0x0000,   /* U+30E2 */
  0x0000,   /* U+30E3 */
  0x0000,   /* U+30E4 */
  0x0000,   /* U+30E5 */
  0x0000,   /* U+30E6 */
  0x0000,   /* U+30E7 */
  0x0000,   /* U+30E8 */
  0x0000,   /* U+30E9 */
  0x0000,   /* U+30EA */
  0x0000,   /* U+30EB */
  0x0000,   /* U+30EC */
  0x0000,   /* U+30ED */
  0x0000,   /* U+30EE */
  0x0000,   /* U+30EF */
  0x0000,   /* U+30F0 */
  0x0000,   /* U+30F1 */
  0x0000,   /* U+30F2 */
  0x0000,   /* U+30F3 */
  0x0002,   /* U+30F4 */
  0x0000,   /* U+30F5 */
  0x0000,   /* U+30F6 */
  0x0002,   /* U+30F7 */
  0x0002,   /* U+30F8 */
  0x0002,   /* U+30F9 */
  0x0002,   /* U+30FA */
  0x0000,   /* U+30FB */
  0x0000,   /* U+30FC */
  0x0000,   /* U+30FD */
  0x0002,   /* U+30FE */
  0x0016,   /* U+30FF */
};

uint16_t zh_han_p034[] = {
  /* Number of CEs for each character. */
  1, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 
  2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 
  1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 
  1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 

  /* Primary weight 1 for each character. */
  0x7C2E,   /* U+3400 */
  0x8EF9,   /* U+3401 */
  0xBDC1,   /* U+3402 */
  0xBDC1,   /* U+3403 */
  0x59C5,   /* U+3404 */
  0x966D,   /* U+3405 */
  0xA9C6,   /* U+3406 */
  0xBDC1,   /* U+3407 */
  0xBDC1,   /* U+3408 */
  0xBDC1,   /* U+3409 */
  0xBDC1,   /* U+340A */
  0xBDC1,   /* U+340B */
  0xA68C,   /* U+340C */
  0xBDC1,   /* U+340D */
  0xBDC1,   /* U+340E */
  0xBDC1,   /* U+340F */
  0xBDC1,   /* U+3410 */
  0xBDC1,   /* U+3411 */
  0xBDC1,   /* U+3412 */
  0xBDC1,   /* U+3413 */
  0xBDC1,   /* U+3414 */
  0xBDC1,   /* U+3415 */
  0x9C96,   /* U+3416 */
  0xBDC1,   /* U+3417 */
  0xBDC1,   /* U+3418 */
  0xBDC1,   /* U+3419 */
  0xBDC1,   /* U+341A */
  0xBDC1,   /* U+341B */
  0x2B19,   /* U+341C */
  0xBDC1,   /* U+341D */
  0xBDC1,   /* U+341E */
  0xBDC1,   /* U+341F */
  0xBDC1,   /* U+3420 */
  0x71D2,   /* U+3421 */
  0xBDC1,   /* U+3422 */
  0xBDC1,   /* U+3423 */
  0x3041,   /* U+3424 */
  0xBDC1,   /* U+3425 */
  0xBDC1,   /* U+3426 */
  0xBDC1,   /* U+3427 */
  0x9F9C,   /* U+3428 */
  0x9E41,   /* U+3429 */
  0xBDC1,   /* U+342A */
  0x9E85,   /* U+342B */
  0x6376,   /* U+342C */
  0x6262,   /* U+342D */
  0x9B22,   /* U+342E */
  0xAB40,   /* U+342F */
  0x9DE8,   /* U+3430 */
  0xB536,   /* U+3431 */
  0x2FE3,   /* U+3432 */
  0x96AF,   /* U+3433 */
  0x727B,   /* U+3434 */
  0x8027,   /* U+3435 */
  0xBDC1,   /* U+3436 */
  0x67A0,   /* U+3437 */
  0x7983,   /* U+3438 */
  0xA797,   /* U+3439 */
  0xA973,   /* U+343A */
  0x6F1E,   /* U+343B */
  0x298E,   /* U+343C */
  0x3A5B,   /* U+343D */
  0xBDC1,   /* U+343E */
  0xBDC1,   /* U+343F */
  0xBDC1,   /* U+3440 */
  0xBAD4,   /* U+3441 */
  0x3930,   /* U+3442 */
  0x1D93,   /* U+3443 */
  0x9673,   /* U+3444 */
  0xBD9B,   /* U+3445 */
  0xBDC1,   /* U+3446 */
  0xB8DD,   /* U+3447 */
  0x3481,   /* U+3448 */
  0x89A8,   /* U+3449 */
  0xA7BD,   /* U+344A */
  0x7BE2,   /* U+344B */
  0x5A15,   /* U+344C */
  0x5DE9,   /* U+344D */
  0x6ECC,   /* U+344E */
  0xB9B3,   /* U+344F */
  0x86BA,   /* U+3450 */
  0xBDC1,   /* U+3451 */
  0xBDC1,   /* U+3452 */
  0xBDC1,   /* U+3453 */
  0x9F74,   /* U+3454 */
  0xBDC1,   /* U+3455 */
  0xBDC1,   /* U+3456 */
  0x8441,   /* U+3457 */
  0x523C,   /* U+3458 */
  0x338B,   /* U+3459 */
  0x71B9,   /* U+345A */
  0x89AB,   /* U+345B */
  0xA7D9,   /* U+345C */
  0x6480,   /* U+345D */
  0xAB03,   /* U+345E */
  0x2050,   /* U+345F */
  0xBDC1,   /* U+3460 */
  0xBDC1,   /* U+3461 */
  0xBDC1,   /* U+3462 */
  0x5C1E,   /* U+3463 */
  0x6B92,   /* U+3464 */
  0xA7F7,   /* U+3465 */
  0x5F3C,   /* U+3466 */
  0x4D38,   /* U+3467 */
  0xAD7C,   /* U+3468 */
  0x66F7,   /* U+3469 */
  0x2686,   /* U+346A */
  0xBDC1,   /* U+346B */
  0xBDC1,   /* U+346C */
  0xBDC1,   /* U+346D */
  0x4AC8,   /* U+346E */
  0x9F7D,   /* U+346F */
  0x4A30,   /* U+3470 */
  0x7F00,   /* U+3471 */
  0xBDC1,   /* U+3472 */
  0xB8F4,   /* U+3473 */
  0xBDC1,   /* U+3474 */
  0x43B0,   /* U+3475 */
  0x98B0,   /* U+3476 */
  0x8C1D,   /* U+3477 */
  0xA4D6,   /* U+3478 */
  0x4A34,   /* U+3479 */
  0x5732,   /* U+347A */
  0x67BA,   /* U+347B */
  0x66AF,   /* U+347C */
  0x8CE0,   /* U+347D */
  0xA4DE,   /* U+347E */
  0xB440,   /* U+347F */
  0xB2DD,   /* U+3480 */
  0xAD95,   /* U+3481 */
  0xBB1A,   /* U+3482 */
  0x383A,   /* U+3483 */
  0x7ECA,   /* U+3484 */
  0x77EB,   /* U+3485 */
  0x2A71,   /* U+3486 */
  0x9690,   /* U+3487 */
  0x43BE,   /* U+3488 */
  0x8D1F,   /* U+3489 */
  0x81FE,   /* U+348A */
  0xBDC1,   /* U+348B */
  0x7C09,   /* U+348C */
  0x5D77,   /* U+348D */
  0x8123,   /* U+348E */
  0xBDC1,   /* U+348F */
  0xBDC1,   /* U+3490 */
  0x5AC3,   /* U+3491 */
  0x7682,   /* U+3492 */
  0x8BA8,   /* U+3493 */
  0x8703,   /* U+3494 */
  0xA412,   /* U+3495 */
  0x7224,   /* U+3496 */
  0x8BFD,   /* U+3497 */
  0xBDC1,   /* U+3498 */
  0x6B42,   /* U+3499 */
  0xAA1F,   /* U+349A */
  0x3375,   /* U+349B */
  0xADA6,   /* U+349C */
  0x6BD0,   /* U+349D */
  0x574D,   /* U+349E */
  0x7037,   /* U+349F */
  0x9D7E,   /* U+34A0 */
  0xAC24,   /* U+34A1 */
  0xBDC1,   /* U+34A2 */
  0xBDC1,   /* U+34A3 */
  0x2877,   /* U+34A4 */
  0x3A8F,   /* U+34A5 */
  0x5DD5,   /* U+34A6 */
  0x5FFF,   /* U+34A7 */
  0xBDC1,   /* U+34A8 */
  0x6743,   /* U+34A9 */
  0xBDC1,   /* U+34AA */
  0x4D12,   /* U+34AB */
  0xBDC1,   /* U+34AC */
  0xBDC1,   /* U+34AD */
  0xBDC1,   /* U+34AE */
  0xBDC1,   /* U+34AF */
  0x7DBD,   /* U+34B0 */
  0xBDC1,   /* U+34B1 */
  0x24CF,   /* U+34B2 */
  0x6117,   /* U+34B3 */
  0x4001,   /* U+34B4 */
  0x68F9,   /* U+34B5 */
  0xBDC1,   /* U+34B6 */
  0x409B,   /* U+34B7 */
  0x8A79,   /* U+34B8 */
  0xBDC1,   /* U+34B9 */
  0xBDC1,   /* U+34BA */
  0x690E,   /* U+34BB */
  0x680A,   /* U+34BC */
  0x7DB1,   /* U+34BD */
  0x8639,   /* U+34BE */
  0x5EB5,   /* U+34BF */
  0xBDC1,   /* U+34C0 */
  0x935C,   /* U+34C1 */
  0x5941,   /* U+34C2 */
  0x3580,   /* U+34C3 */
  0xB58E,   /* U+34C4 */
  0x8F71,   /* U+34C5 */
  0xBDC1,   /* U+34C6 */
  0xBDC1,   /* U+34C7 */
  0x234E,   /* U+34C8 */
  0x4B24,   /* U+34C9 */
  0x3484,   /* U+34CA */
  0x3F5A,   /* U+34CB */
  0x28F5,   /* U+34CC */
  0xBDC1,   /* U+34CD */
  0x7AF4,   /* U+34CE */
  0x53D5,   /* U+34CF */
  0x656D,   /* U+34D0 */
  0x9E6F,   /* U+34D1 */
  0xBDC1,   /* U+34D2 */
  0x6E5A,   /* U+34D3 */
  0x9D33,   /* U+34D4 */
  0xBDC1,   /* U+34D5 */
  0x212A,   /* U+34D6 */
  0x51D6,   /* U+34D7 */
  0x89B7,   /* U+34D8 */
  0xBDC1,   /* U+34D9 */
  0x3EFC,   /* U+34DA */
  0xBDC1,   /* U+34DB */
  0xAC65,   /* U+34DC */
  0x9E3B,   /* U+34DD */
  0x7881,   /* U+34DE */
  0x7436,   /* U+34DF */
  0x32F0,   /* U+34E0 */
  0x3BF4,   /* U+34E1 */
  0x6748,   /* U+34E2 */
  0x7884,   /* U+34E3 */
  0x7885,   /* U+34E4 */
  0x8CC0,   /* U+34E5 */
  0x1E46,   /* U+34E6 */
  0x3D13,   /* U+34E7 */
  0x2D61,   /* U+34E8 */
  0xA01F,   /* U+34E9 */
  0x5CD1,   /* U+34EA */
  0xBDC1,   /* U+34EB */
  0xBDC1,   /* U+34EC */
  0x83EA,   /* U+34ED */
  0xBDC1,   /* U+34EE */
  0x5E2E,   /* U+34EF */
  0x481F,   /* U+34F0 */
  0x9056,   /* U+34F1 */
  0x74D6,   /* U+34F2 */
  0x31E7,   /* U+34F3 */
  0x8092,   /* U+34F4 */
  0x3756,   /* U+34F5 */
  0x7ABF,   /* U+34F6 */
  0xA831,   /* U+34F7 */
  0xBADE,   /* U+34F8 */
  0x80C9,   /* U+34F9 */
  0x4E9A,   /* U+34FA */
  0xBDC1,   /* U+34FB */
  0x2A69,   /* U+34FC */
  0x2ADD,   /* U+34FD */
  0x9799,   /* U+34FE */
  0xBDC1,   /* U+34FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3400 */
  0x0020,   /* U+3401 */
  0x0020,   /* U+3402 */
  0x0020,   /* U+3403 */
  0x0020,   /* U+3404 */
  0x0020,   /* U+3405 */
  0x0020,   /* U+3406 */
  0x0020,   /* U+3407 */
  0x0020,   /* U+3408 */
  0x0020,   /* U+3409 */
  0x0020,   /* U+340A */
  0x0020,   /* U+340B */
  0x0020,   /* U+340C */
  0x0020,   /* U+340D */
  0x0020,   /* U+340E */
  0x0020,   /* U+340F */
  0x0020,   /* U+3410 */
  0x0020,   /* U+3411 */
  0x0020,   /* U+3412 */
  0x0020,   /* U+3413 */
  0x0020,   /* U+3414 */
  0x0020,   /* U+3415 */
  0x0020,   /* U+3416 */
  0x0020,   /* U+3417 */
  0x0020,   /* U+3418 */
  0x0020,   /* U+3419 */
  0x0020,   /* U+341A */
  0x0020,   /* U+341B */
  0x0020,   /* U+341C */
  0x0020,   /* U+341D */
  0x0020,   /* U+341E */
  0x0020,   /* U+341F */
  0x0020,   /* U+3420 */
  0x0020,   /* U+3421 */
  0x0020,   /* U+3422 */
  0x0020,   /* U+3423 */
  0x0020,   /* U+3424 */
  0x0020,   /* U+3425 */
  0x0020,   /* U+3426 */
  0x0020,   /* U+3427 */
  0x0020,   /* U+3428 */
  0x0020,   /* U+3429 */
  0x0020,   /* U+342A */
  0x0020,   /* U+342B */
  0x0020,   /* U+342C */
  0x0020,   /* U+342D */
  0x0020,   /* U+342E */
  0x0020,   /* U+342F */
  0x0020,   /* U+3430 */
  0x0020,   /* U+3431 */
  0x0020,   /* U+3432 */
  0x0020,   /* U+3433 */
  0x0020,   /* U+3434 */
  0x0020,   /* U+3435 */
  0x0020,   /* U+3436 */
  0x0020,   /* U+3437 */
  0x0020,   /* U+3438 */
  0x0020,   /* U+3439 */
  0x0020,   /* U+343A */
  0x0020,   /* U+343B */
  0x0020,   /* U+343C */
  0x0020,   /* U+343D */
  0x0020,   /* U+343E */
  0x0020,   /* U+343F */
  0x0020,   /* U+3440 */
  0x0020,   /* U+3441 */
  0x0020,   /* U+3442 */
  0x0020,   /* U+3443 */
  0x0020,   /* U+3444 */
  0x0020,   /* U+3445 */
  0x0020,   /* U+3446 */
  0x0020,   /* U+3447 */
  0x0020,   /* U+3448 */
  0x0020,   /* U+3449 */
  0x0020,   /* U+344A */
  0x0020,   /* U+344B */
  0x0020,   /* U+344C */
  0x0020,   /* U+344D */
  0x0020,   /* U+344E */
  0x0020,   /* U+344F */
  0x0020,   /* U+3450 */
  0x0020,   /* U+3451 */
  0x0020,   /* U+3452 */
  0x0020,   /* U+3453 */
  0x0020,   /* U+3454 */
  0x0020,   /* U+3455 */
  0x0020,   /* U+3456 */
  0x0020,   /* U+3457 */
  0x0020,   /* U+3458 */
  0x0020,   /* U+3459 */
  0x0020,   /* U+345A */
  0x0020,   /* U+345B */
  0x0020,   /* U+345C */
  0x0020,   /* U+345D */
  0x0020,   /* U+345E */
  0x0020,   /* U+345F */
  0x0020,   /* U+3460 */
  0x0020,   /* U+3461 */
  0x0020,   /* U+3462 */
  0x0020,   /* U+3463 */
  0x0020,   /* U+3464 */
  0x0020,   /* U+3465 */
  0x0020,   /* U+3466 */
  0x0020,   /* U+3467 */
  0x0020,   /* U+3468 */
  0x0020,   /* U+3469 */
  0x0020,   /* U+346A */
  0x0020,   /* U+346B */
  0x0020,   /* U+346C */
  0x0020,   /* U+346D */
  0x0020,   /* U+346E */
  0x0020,   /* U+346F */
  0x0020,   /* U+3470 */
  0x0020,   /* U+3471 */
  0x0020,   /* U+3472 */
  0x0020,   /* U+3473 */
  0x0020,   /* U+3474 */
  0x0020,   /* U+3475 */
  0x0020,   /* U+3476 */
  0x0020,   /* U+3477 */
  0x0020,   /* U+3478 */
  0x0020,   /* U+3479 */
  0x0020,   /* U+347A */
  0x0020,   /* U+347B */
  0x0020,   /* U+347C */
  0x0020,   /* U+347D */
  0x0020,   /* U+347E */
  0x0020,   /* U+347F */
  0x0020,   /* U+3480 */
  0x0020,   /* U+3481 */
  0x0020,   /* U+3482 */
  0x0020,   /* U+3483 */
  0x0020,   /* U+3484 */
  0x0020,   /* U+3485 */
  0x0020,   /* U+3486 */
  0x0020,   /* U+3487 */
  0x0020,   /* U+3488 */
  0x0020,   /* U+3489 */
  0x0020,   /* U+348A */
  0x0020,   /* U+348B */
  0x0020,   /* U+348C */
  0x0020,   /* U+348D */
  0x0020,   /* U+348E */
  0x0020,   /* U+348F */
  0x0020,   /* U+3490 */
  0x0020,   /* U+3491 */
  0x0020,   /* U+3492 */
  0x0020,   /* U+3493 */
  0x0020,   /* U+3494 */
  0x0020,   /* U+3495 */
  0x0020,   /* U+3496 */
  0x0020,   /* U+3497 */
  0x0020,   /* U+3498 */
  0x0020,   /* U+3499 */
  0x0020,   /* U+349A */
  0x0020,   /* U+349B */
  0x0020,   /* U+349C */
  0x0020,   /* U+349D */
  0x0020,   /* U+349E */
  0x0020,   /* U+349F */
  0x0020,   /* U+34A0 */
  0x0020,   /* U+34A1 */
  0x0020,   /* U+34A2 */
  0x0020,   /* U+34A3 */
  0x0020,   /* U+34A4 */
  0x0020,   /* U+34A5 */
  0x0020,   /* U+34A6 */
  0x0020,   /* U+34A7 */
  0x0020,   /* U+34A8 */
  0x0020,   /* U+34A9 */
  0x0020,   /* U+34AA */
  0x0020,   /* U+34AB */
  0x0020,   /* U+34AC */
  0x0020,   /* U+34AD */
  0x0020,   /* U+34AE */
  0x0020,   /* U+34AF */
  0x0020,   /* U+34B0 */
  0x0020,   /* U+34B1 */
  0x0020,   /* U+34B2 */
  0x0020,   /* U+34B3 */
  0x0020,   /* U+34B4 */
  0x0020,   /* U+34B5 */
  0x0020,   /* U+34B6 */
  0x0020,   /* U+34B7 */
  0x0020,   /* U+34B8 */
  0x0020,   /* U+34B9 */
  0x0020,   /* U+34BA */
  0x0020,   /* U+34BB */
  0x0020,   /* U+34BC */
  0x0020,   /* U+34BD */
  0x0020,   /* U+34BE */
  0x0020,   /* U+34BF */
  0x0020,   /* U+34C0 */
  0x0020,   /* U+34C1 */
  0x0020,   /* U+34C2 */
  0x0020,   /* U+34C3 */
  0x0020,   /* U+34C4 */
  0x0020,   /* U+34C5 */
  0x0020,   /* U+34C6 */
  0x0020,   /* U+34C7 */
  0x0020,   /* U+34C8 */
  0x0020,   /* U+34C9 */
  0x0020,   /* U+34CA */
  0x0020,   /* U+34CB */
  0x0020,   /* U+34CC */
  0x0020,   /* U+34CD */
  0x0020,   /* U+34CE */
  0x0020,   /* U+34CF */
  0x0020,   /* U+34D0 */
  0x0020,   /* U+34D1 */
  0x0020,   /* U+34D2 */
  0x0020,   /* U+34D3 */
  0x0020,   /* U+34D4 */
  0x0020,   /* U+34D5 */
  0x0020,   /* U+34D6 */
  0x0020,   /* U+34D7 */
  0x0020,   /* U+34D8 */
  0x0020,   /* U+34D9 */
  0x0020,   /* U+34DA */
  0x0020,   /* U+34DB */
  0x0020,   /* U+34DC */
  0x0020,   /* U+34DD */
  0x0020,   /* U+34DE */
  0x0020,   /* U+34DF */
  0x0020,   /* U+34E0 */
  0x0020,   /* U+34E1 */
  0x0020,   /* U+34E2 */
  0x0020,   /* U+34E3 */
  0x0020,   /* U+34E4 */
  0x0020,   /* U+34E5 */
  0x0020,   /* U+34E6 */
  0x0020,   /* U+34E7 */
  0x0020,   /* U+34E8 */
  0x0020,   /* U+34E9 */
  0x0020,   /* U+34EA */
  0x0020,   /* U+34EB */
  0x0020,   /* U+34EC */
  0x0020,   /* U+34ED */
  0x0020,   /* U+34EE */
  0x0020,   /* U+34EF */
  0x0020,   /* U+34F0 */
  0x0020,   /* U+34F1 */
  0x0020,   /* U+34F2 */
  0x0020,   /* U+34F3 */
  0x0020,   /* U+34F4 */
  0x0020,   /* U+34F5 */
  0x0020,   /* U+34F6 */
  0x0020,   /* U+34F7 */
  0x0020,   /* U+34F8 */
  0x0020,   /* U+34F9 */
  0x0020,   /* U+34FA */
  0x0020,   /* U+34FB */
  0x0020,   /* U+34FC */
  0x0020,   /* U+34FD */
  0x0020,   /* U+34FE */
  0x0020,   /* U+34FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3400 */
  0x0002,   /* U+3401 */
  0x0002,   /* U+3402 */
  0x0002,   /* U+3403 */
  0x0002,   /* U+3404 */
  0x0002,   /* U+3405 */
  0x0002,   /* U+3406 */
  0x0002,   /* U+3407 */
  0x0002,   /* U+3408 */
  0x0002,   /* U+3409 */
  0x0002,   /* U+340A */
  0x0002,   /* U+340B */
  0x0002,   /* U+340C */
  0x0002,   /* U+340D */
  0x0002,   /* U+340E */
  0x0002,   /* U+340F */
  0x0002,   /* U+3410 */
  0x0002,   /* U+3411 */
  0x0002,   /* U+3412 */
  0x0002,   /* U+3413 */
  0x0002,   /* U+3414 */
  0x0002,   /* U+3415 */
  0x0002,   /* U+3416 */
  0x0002,   /* U+3417 */
  0x0002,   /* U+3418 */
  0x0002,   /* U+3419 */
  0x0002,   /* U+341A */
  0x0002,   /* U+341B */
  0x0002,   /* U+341C */
  0x0002,   /* U+341D */
  0x0002,   /* U+341E */
  0x0002,   /* U+341F */
  0x0002,   /* U+3420 */
  0x0002,   /* U+3421 */
  0x0002,   /* U+3422 */
  0x0002,   /* U+3423 */
  0x0002,   /* U+3424 */
  0x0002,   /* U+3425 */
  0x0002,   /* U+3426 */
  0x0002,   /* U+3427 */
  0x0002,   /* U+3428 */
  0x0002,   /* U+3429 */
  0x0002,   /* U+342A */
  0x0002,   /* U+342B */
  0x0002,   /* U+342C */
  0x0002,   /* U+342D */
  0x0002,   /* U+342E */
  0x0002,   /* U+342F */
  0x0002,   /* U+3430 */
  0x0002,   /* U+3431 */
  0x0002,   /* U+3432 */
  0x0002,   /* U+3433 */
  0x0002,   /* U+3434 */
  0x0002,   /* U+3435 */
  0x0002,   /* U+3436 */
  0x0002,   /* U+3437 */
  0x0002,   /* U+3438 */
  0x0002,   /* U+3439 */
  0x0002,   /* U+343A */
  0x0002,   /* U+343B */
  0x0002,   /* U+343C */
  0x0002,   /* U+343D */
  0x0002,   /* U+343E */
  0x0002,   /* U+343F */
  0x0002,   /* U+3440 */
  0x0002,   /* U+3441 */
  0x0002,   /* U+3442 */
  0x0002,   /* U+3443 */
  0x0002,   /* U+3444 */
  0x0002,   /* U+3445 */
  0x0002,   /* U+3446 */
  0x0002,   /* U+3447 */
  0x0002,   /* U+3448 */
  0x0002,   /* U+3449 */
  0x0002,   /* U+344A */
  0x0002,   /* U+344B */
  0x0002,   /* U+344C */
  0x0002,   /* U+344D */
  0x0002,   /* U+344E */
  0x0002,   /* U+344F */
  0x0002,   /* U+3450 */
  0x0002,   /* U+3451 */
  0x0002,   /* U+3452 */
  0x0002,   /* U+3453 */
  0x0002,   /* U+3454 */
  0x0002,   /* U+3455 */
  0x0002,   /* U+3456 */
  0x0002,   /* U+3457 */
  0x0002,   /* U+3458 */
  0x0002,   /* U+3459 */
  0x0002,   /* U+345A */
  0x0002,   /* U+345B */
  0x0002,   /* U+345C */
  0x0002,   /* U+345D */
  0x0002,   /* U+345E */
  0x0002,   /* U+345F */
  0x0002,   /* U+3460 */
  0x0002,   /* U+3461 */
  0x0002,   /* U+3462 */
  0x0002,   /* U+3463 */
  0x0002,   /* U+3464 */
  0x0002,   /* U+3465 */
  0x0002,   /* U+3466 */
  0x0002,   /* U+3467 */
  0x0002,   /* U+3468 */
  0x0002,   /* U+3469 */
  0x0002,   /* U+346A */
  0x0002,   /* U+346B */
  0x0002,   /* U+346C */
  0x0002,   /* U+346D */
  0x0002,   /* U+346E */
  0x0002,   /* U+346F */
  0x0002,   /* U+3470 */
  0x0002,   /* U+3471 */
  0x0002,   /* U+3472 */
  0x0002,   /* U+3473 */
  0x0002,   /* U+3474 */
  0x0002,   /* U+3475 */
  0x0002,   /* U+3476 */
  0x0002,   /* U+3477 */
  0x0002,   /* U+3478 */
  0x0002,   /* U+3479 */
  0x0002,   /* U+347A */
  0x0002,   /* U+347B */
  0x0002,   /* U+347C */
  0x0002,   /* U+347D */
  0x0002,   /* U+347E */
  0x0002,   /* U+347F */
  0x0002,   /* U+3480 */
  0x0002,   /* U+3481 */
  0x0002,   /* U+3482 */
  0x0002,   /* U+3483 */
  0x0002,   /* U+3484 */
  0x0002,   /* U+3485 */
  0x0002,   /* U+3486 */
  0x0002,   /* U+3487 */
  0x0002,   /* U+3488 */
  0x0002,   /* U+3489 */
  0x0002,   /* U+348A */
  0x0002,   /* U+348B */
  0x0002,   /* U+348C */
  0x0002,   /* U+348D */
  0x0002,   /* U+348E */
  0x0002,   /* U+348F */
  0x0002,   /* U+3490 */
  0x0002,   /* U+3491 */
  0x0002,   /* U+3492 */
  0x0002,   /* U+3493 */
  0x0002,   /* U+3494 */
  0x0002,   /* U+3495 */
  0x0002,   /* U+3496 */
  0x0002,   /* U+3497 */
  0x0002,   /* U+3498 */
  0x0002,   /* U+3499 */
  0x0002,   /* U+349A */
  0x0002,   /* U+349B */
  0x0002,   /* U+349C */
  0x0002,   /* U+349D */
  0x0002,   /* U+349E */
  0x0002,   /* U+349F */
  0x0002,   /* U+34A0 */
  0x0002,   /* U+34A1 */
  0x0002,   /* U+34A2 */
  0x0002,   /* U+34A3 */
  0x0002,   /* U+34A4 */
  0x0002,   /* U+34A5 */
  0x0002,   /* U+34A6 */
  0x0002,   /* U+34A7 */
  0x0002,   /* U+34A8 */
  0x0002,   /* U+34A9 */
  0x0002,   /* U+34AA */
  0x0002,   /* U+34AB */
  0x0002,   /* U+34AC */
  0x0002,   /* U+34AD */
  0x0002,   /* U+34AE */
  0x0002,   /* U+34AF */
  0x0002,   /* U+34B0 */
  0x0002,   /* U+34B1 */
  0x0002,   /* U+34B2 */
  0x0002,   /* U+34B3 */
  0x0002,   /* U+34B4 */
  0x0002,   /* U+34B5 */
  0x0002,   /* U+34B6 */
  0x0002,   /* U+34B7 */
  0x0002,   /* U+34B8 */
  0x0002,   /* U+34B9 */
  0x0002,   /* U+34BA */
  0x0002,   /* U+34BB */
  0x0002,   /* U+34BC */
  0x0002,   /* U+34BD */
  0x0002,   /* U+34BE */
  0x0002,   /* U+34BF */
  0x0002,   /* U+34C0 */
  0x0002,   /* U+34C1 */
  0x0002,   /* U+34C2 */
  0x0002,   /* U+34C3 */
  0x0002,   /* U+34C4 */
  0x0002,   /* U+34C5 */
  0x0002,   /* U+34C6 */
  0x0002,   /* U+34C7 */
  0x0002,   /* U+34C8 */
  0x0002,   /* U+34C9 */
  0x0002,   /* U+34CA */
  0x0002,   /* U+34CB */
  0x0002,   /* U+34CC */
  0x0002,   /* U+34CD */
  0x0002,   /* U+34CE */
  0x0002,   /* U+34CF */
  0x0002,   /* U+34D0 */
  0x0002,   /* U+34D1 */
  0x0002,   /* U+34D2 */
  0x0002,   /* U+34D3 */
  0x0002,   /* U+34D4 */
  0x0002,   /* U+34D5 */
  0x0002,   /* U+34D6 */
  0x0002,   /* U+34D7 */
  0x0002,   /* U+34D8 */
  0x0002,   /* U+34D9 */
  0x0002,   /* U+34DA */
  0x0002,   /* U+34DB */
  0x0002,   /* U+34DC */
  0x0002,   /* U+34DD */
  0x0002,   /* U+34DE */
  0x0002,   /* U+34DF */
  0x0002,   /* U+34E0 */
  0x0002,   /* U+34E1 */
  0x0002,   /* U+34E2 */
  0x0002,   /* U+34E3 */
  0x0002,   /* U+34E4 */
  0x0002,   /* U+34E5 */
  0x0002,   /* U+34E6 */
  0x0002,   /* U+34E7 */
  0x0002,   /* U+34E8 */
  0x0002,   /* U+34E9 */
  0x0002,   /* U+34EA */
  0x0002,   /* U+34EB */
  0x0002,   /* U+34EC */
  0x0002,   /* U+34ED */
  0x0002,   /* U+34EE */
  0x0002,   /* U+34EF */
  0x0002,   /* U+34F0 */
  0x0002,   /* U+34F1 */
  0x0002,   /* U+34F2 */
  0x0002,   /* U+34F3 */
  0x0002,   /* U+34F4 */
  0x0002,   /* U+34F5 */
  0x0002,   /* U+34F6 */
  0x0002,   /* U+34F7 */
  0x0002,   /* U+34F8 */
  0x0002,   /* U+34F9 */
  0x0002,   /* U+34FA */
  0x0002,   /* U+34FB */
  0x0002,   /* U+34FC */
  0x0002,   /* U+34FD */
  0x0002,   /* U+34FE */
  0x0002,   /* U+34FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0xB402,   /* U+3402 */
  0xB403,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0xB407,   /* U+3407 */
  0xB408,   /* U+3408 */
  0xB409,   /* U+3409 */
  0xB40A,   /* U+340A */
  0xB40B,   /* U+340B */
  0x0000,   /* U+340C */
  0xB40D,   /* U+340D */
  0xB40E,   /* U+340E */
  0xB40F,   /* U+340F */
  0xB410,   /* U+3410 */
  0xB411,   /* U+3411 */
  0xB412,   /* U+3412 */
  0xB413,   /* U+3413 */
  0xB414,   /* U+3414 */
  0xB415,   /* U+3415 */
  0x0000,   /* U+3416 */
  0xB417,   /* U+3417 */
  0xB418,   /* U+3418 */
  0xB419,   /* U+3419 */
  0xB41A,   /* U+341A */
  0xB41B,   /* U+341B */
  0x0000,   /* U+341C */
  0xB41D,   /* U+341D */
  0xB41E,   /* U+341E */
  0xB41F,   /* U+341F */
  0xB420,   /* U+3420 */
  0x0000,   /* U+3421 */
  0xB422,   /* U+3422 */
  0xB423,   /* U+3423 */
  0x0000,   /* U+3424 */
  0xB425,   /* U+3425 */
  0xB426,   /* U+3426 */
  0xB427,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0xB42A,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0xB436,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0xB43E,   /* U+343E */
  0xB43F,   /* U+343F */
  0xB440,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0xB446,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0xB451,   /* U+3451 */
  0xB452,   /* U+3452 */
  0xB453,   /* U+3453 */
  0x0000,   /* U+3454 */
  0xB455,   /* U+3455 */
  0xB456,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0xB460,   /* U+3460 */
  0xB461,   /* U+3461 */
  0xB462,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0xB46B,   /* U+346B */
  0xB46C,   /* U+346C */
  0xB46D,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0xB472,   /* U+3472 */
  0x0000,   /* U+3473 */
  0xB474,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0xB48B,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0xB48F,   /* U+348F */
  0xB490,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0xB498,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0xB4A2,   /* U+34A2 */
  0xB4A3,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0xB4A8,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0xB4AA,   /* U+34AA */
  0x0000,   /* U+34AB */
  0xB4AC,   /* U+34AC */
  0xB4AD,   /* U+34AD */
  0xB4AE,   /* U+34AE */
  0xB4AF,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0xB4B1,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0xB4B6,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0xB4B9,   /* U+34B9 */
  0xB4BA,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0xB4C0,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0xB4C6,   /* U+34C6 */
  0xB4C7,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0xB4CD,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0xB4D2,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0xB4D5,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0xB4D9,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0xB4DB,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0xB4EB,   /* U+34EB */
  0xB4EC,   /* U+34EC */
  0x0000,   /* U+34ED */
  0xB4EE,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0xB4FB,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0xB4FF,   /* U+34FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */
};

uint16_t zh_han_p035[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 
  1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 
  2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x66B3,   /* U+3500 */
  0x31A5,   /* U+3501 */
  0x6235,   /* U+3502 */
  0x568E,   /* U+3503 */
  0x89DA,   /* U+3504 */
  0x9C5E,   /* U+3505 */
  0xB128,   /* U+3506 */
  0xBDC1,   /* U+3507 */
  0xBDC1,   /* U+3508 */
  0xB99A,   /* U+3509 */
  0xB368,   /* U+350A */
  0x4EC8,   /* U+350B */
  0xBCA8,   /* U+350C */
  0x2C21,   /* U+350D */
  0x9D77,   /* U+350E */
  0x5FAA,   /* U+350F */
  0xBDC1,   /* U+3510 */
  0x2A99,   /* U+3511 */
  0x9849,   /* U+3512 */
  0x4F01,   /* U+3513 */
  0xBDC1,   /* U+3514 */
  0x4C39,   /* U+3515 */
  0xBDC1,   /* U+3516 */
  0x3992,   /* U+3517 */
  0x2BD7,   /* U+3518 */
  0x2031,   /* U+3519 */
  0x518F,   /* U+351A */
  0xBDC1,   /* U+351B */
  0x1E03,   /* U+351C */
  0x611A,   /* U+351D */
  0x59E4,   /* U+351E */
  0xBDC1,   /* U+351F */
  0x9914,   /* U+3520 */
  0x229A,   /* U+3521 */
  0x5690,   /* U+3522 */
  0x5D85,   /* U+3523 */
  0x9E08,   /* U+3524 */
  0x1E76,   /* U+3525 */
  0xA477,   /* U+3526 */
  0x665D,   /* U+3527 */
  0x1FCB,   /* U+3528 */
  0x3762,   /* U+3529 */
  0x653A,   /* U+352A */
  0xBDC1,   /* U+352B */
  0xBDC1,   /* U+352C */
  0x2856,   /* U+352D */
  0x71C6,   /* U+352E */
  0xA060,   /* U+352F */
  0x457B,   /* U+3530 */
  0xAD85,   /* U+3531 */
  0xBDC1,   /* U+3532 */
  0x41D6,   /* U+3533 */
  0xA859,   /* U+3534 */
  0xA089,   /* U+3535 */
  0x3F69,   /* U+3536 */
  0x64D7,   /* U+3537 */
  0x8DDA,   /* U+3538 */
  0x5D59,   /* U+3539 */
  0x85EB,   /* U+353A */
  0xBDC1,   /* U+353B */
  0x8ADB,   /* U+353C */
  0xA555,   /* U+353D */
  0x9997,   /* U+353E */
  0xBCA4,   /* U+353F */
  0xBDC1,   /* U+3540 */
  0x7E36,   /* U+3541 */
  0xA974,   /* U+3542 */
  0x9717,   /* U+3543 */
  0xB6C7,   /* U+3544 */
  0x4E1F,   /* U+3545 */
  0x4780,   /* U+3546 */
  0x5B70,   /* U+3547 */
  0xA74D,   /* U+3548 */
  0x5896,   /* U+3549 */
  0x3AF5,   /* U+354A */
  0x7B14,   /* U+354B */
  0x1C90,   /* U+354C */
  0xBDC1,   /* U+354D */
  0x58AC,   /* U+354E */
  0x2B95,   /* U+354F */
  0x9D04,   /* U+3550 */
  0x2B9E,   /* U+3551 */
  0x93BA,   /* U+3552 */
  0xBDC1,   /* U+3553 */
  0xBDC1,   /* U+3554 */
  0x48CB,   /* U+3555 */
  0x89AE,   /* U+3556 */
  0xAC80,   /* U+3557 */
  0xBDC1,   /* U+3558 */
  0x5746,   /* U+3559 */
  0xB41F,   /* U+355A */
  0x9F93,   /* U+355B */
  0x85C3,   /* U+355C */
  0xBDC1,   /* U+355D */
  0x8789,   /* U+355E */
  0x5ACB,   /* U+355F */
  0x87B9,   /* U+3560 */
  0x44FA,   /* U+3561 */
  0x3CF8,   /* U+3562 */
  0xA2FA,   /* U+3563 */
  0x7C5C,   /* U+3564 */
  0x8431,   /* U+3565 */
  0x4818,   /* U+3566 */
  0x9719,   /* U+3567 */
  0x38DE,   /* U+3568 */
  0x72F0,   /* U+3569 */
  0x3064,   /* U+356A */
  0x3931,   /* U+356B */
  0x3F01,   /* U+356C */
  0x1D5A,   /* U+356D */
  0x3BEE,   /* U+356E */
  0x6F01,   /* U+356F */
  0xA102,   /* U+3570 */
  0xABD2,   /* U+3571 */
  0x47EE,   /* U+3572 */
  0xBDC1,   /* U+3573 */
  0x2899,   /* U+3574 */
  0x427D,   /* U+3575 */
  0x6DBF,   /* U+3576 */
  0x481A,   /* U+3577 */
  0x5F20,   /* U+3578 */
  0x384A,   /* U+3579 */
  0x9BA3,   /* U+357A */
  0x7652,   /* U+357B */
  0xBDC1,   /* U+357C */
  0x88AE,   /* U+357D */
  0xBDC1,   /* U+357E */
  0xBDC1,   /* U+357F */
  0x5D65,   /* U+3580 */
  0x627A,   /* U+3581 */
  0xA7DA,   /* U+3582 */
  0x467A,   /* U+3583 */
  0xBDC1,   /* U+3584 */
  0x9FA6,   /* U+3585 */
  0x7D1F,   /* U+3586 */
  0x37EC,   /* U+3587 */
  0xBDC1,   /* U+3588 */
  0xBDC1,   /* U+3589 */
  0xA153,   /* U+358A */
  0xBDC1,   /* U+358B */
  0xBDC1,   /* U+358C */
  0xBDC1,   /* U+358D */
  0xBDC1,   /* U+358E */
  0x705B,   /* U+358F */
  0x9433,   /* U+3590 */
  0x9D1E,   /* U+3591 */
  0x8DEC,   /* U+3592 */
  0x45E7,   /* U+3593 */
  0x919F,   /* U+3594 */
  0x705C,   /* U+3595 */
  0x705D,   /* U+3596 */
  0xA983,   /* U+3597 */
  0xB4FA,   /* U+3598 */
  0xBDC1,   /* U+3599 */
  0xBDC1,   /* U+359A */
  0xBDC1,   /* U+359B */
  0xBDC1,   /* U+359C */
  0xBDC1,   /* U+359D */
  0x928C,   /* U+359E */
  0x8696,   /* U+359F */
  0x71D3,   /* U+35A0 */
  0xA5D7,   /* U+35A1 */
  0x773C,   /* U+35A2 */
  0x9074,   /* U+35A3 */
  0x434F,   /* U+35A4 */
  0x572C,   /* U+35A5 */
  0x3470,   /* U+35A6 */
  0x4AB3,   /* U+35A7 */
  0x6573,   /* U+35A8 */
  0x5491,   /* U+35A9 */
  0x4B31,   /* U+35AA */
  0x62C5,   /* U+35AB */
  0xBDC1,   /* U+35AC */
  0x8ED6,   /* U+35AD */
  0x66CD,   /* U+35AE */
  0xBDC1,   /* U+35AF */
  0xBDC1,   /* U+35B0 */
  0xBDC1,   /* U+35B1 */
  0xBDC1,   /* U+35B2 */
  0xBDC1,   /* U+35B3 */
  0xBDC1,   /* U+35B4 */
  0x3E46,   /* U+35B5 */
  0xA260,   /* U+35B6 */
  0x859C,   /* U+35B7 */
  0xA0E6,   /* U+35B8 */
  0x7376,   /* U+35B9 */
  0x2D0E,   /* U+35BA */
  0x7114,   /* U+35BB */
  0x369B,   /* U+35BC */
  0xB1C5,   /* U+35BD */
  0x3764,   /* U+35BE */
  0x9CB5,   /* U+35BF */
  0xABB0,   /* U+35C0 */
  0x3765,   /* U+35C1 */
  0x8505,   /* U+35C2 */
  0x9554,   /* U+35C3 */
  0x5973,   /* U+35C4 */
  0x46FE,   /* U+35C5 */
  0x3E48,   /* U+35C6 */
  0x9944,   /* U+35C7 */
  0x6848,   /* U+35C8 */
  0x66AD,   /* U+35C9 */
  0x4C6E,   /* U+35CA */
  0x4650,   /* U+35CB */
  0xB76B,   /* U+35CC */
  0xBDC1,   /* U+35CD */
  0xBDC1,   /* U+35CE */
  0x928E,   /* U+35CF */
  0xBDC1,   /* U+35D0 */
  0x1E7D,   /* U+35D1 */
  0x1C98,   /* U+35D2 */
  0xBA90,   /* U+35D3 */
  0x78D9,   /* U+35D4 */
  0x3FA9,   /* U+35D5 */
  0x309F,   /* U+35D6 */
  0x1F9B,   /* U+35D7 */
  0x23D2,   /* U+35D8 */
  0x2B81,   /* U+35D9 */
  0x5F72,   /* U+35DA */
  0x9C5C,   /* U+35DB */
  0x9F02,   /* U+35DC */
  0xBDC1,   /* U+35DD */
  0xBDC1,   /* U+35DE */
  0xBDC1,   /* U+35DF */
  0xBDC1,   /* U+35E0 */
  0xBDC1,   /* U+35E1 */
  0x460B,   /* U+35E2 */
  0x8E66,   /* U+35E3 */
  0x2E6F,   /* U+35E4 */
  0x5B5A,   /* U+35E5 */
  0x5D06,   /* U+35E6 */
  0xB79C,   /* U+35E7 */
  0x9C87,   /* U+35E8 */
  0x979B,   /* U+35E9 */
  0xBDC1,   /* U+35EA */
  0x7ACE,   /* U+35EB */
  0xB255,   /* U+35EC */
  0x979C,   /* U+35ED */
  0xBDC1,   /* U+35EE */
  0xBDC1,   /* U+35EF */
  0x2E1F,   /* U+35F0 */
  0x4C96,   /* U+35F1 */
  0x4B4B,   /* U+35F2 */
  0x8B6E,   /* U+35F3 */
  0xA2C0,   /* U+35F4 */
  0x9FF4,   /* U+35F5 */
  0x75EA,   /* U+35F6 */
  0x8153,   /* U+35F7 */
  0xBDC1,   /* U+35F8 */
  0xBDC1,   /* U+35F9 */
  0xBDC1,   /* U+35FA */
  0x4270,   /* U+35FB */
  0xA600,   /* U+35FC */
  0x9B65,   /* U+35FD */
  0xA0D3,   /* U+35FE */
  0x4506,   /* U+35FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3500 */
  0x0020,   /* U+3501 */
  0x0020,   /* U+3502 */
  0x0020,   /* U+3503 */
  0x0020,   /* U+3504 */
  0x0020,   /* U+3505 */
  0x0020,   /* U+3506 */
  0x0020,   /* U+3507 */
  0x0020,   /* U+3508 */
  0x0020,   /* U+3509 */
  0x0020,   /* U+350A */
  0x0020,   /* U+350B */
  0x0020,   /* U+350C */
  0x0020,   /* U+350D */
  0x0020,   /* U+350E */
  0x0020,   /* U+350F */
  0x0020,   /* U+3510 */
  0x0020,   /* U+3511 */
  0x0020,   /* U+3512 */
  0x0020,   /* U+3513 */
  0x0020,   /* U+3514 */
  0x0020,   /* U+3515 */
  0x0020,   /* U+3516 */
  0x0020,   /* U+3517 */
  0x0020,   /* U+3518 */
  0x0020,   /* U+3519 */
  0x0020,   /* U+351A */
  0x0020,   /* U+351B */
  0x0020,   /* U+351C */
  0x0020,   /* U+351D */
  0x0020,   /* U+351E */
  0x0020,   /* U+351F */
  0x0020,   /* U+3520 */
  0x0020,   /* U+3521 */
  0x0020,   /* U+3522 */
  0x0020,   /* U+3523 */
  0x0020,   /* U+3524 */
  0x0020,   /* U+3525 */
  0x0020,   /* U+3526 */
  0x0020,   /* U+3527 */
  0x0020,   /* U+3528 */
  0x0020,   /* U+3529 */
  0x0020,   /* U+352A */
  0x0020,   /* U+352B */
  0x0020,   /* U+352C */
  0x0020,   /* U+352D */
  0x0020,   /* U+352E */
  0x0020,   /* U+352F */
  0x0020,   /* U+3530 */
  0x0020,   /* U+3531 */
  0x0020,   /* U+3532 */
  0x0020,   /* U+3533 */
  0x0020,   /* U+3534 */
  0x0020,   /* U+3535 */
  0x0020,   /* U+3536 */
  0x0020,   /* U+3537 */
  0x0020,   /* U+3538 */
  0x0020,   /* U+3539 */
  0x0020,   /* U+353A */
  0x0020,   /* U+353B */
  0x0020,   /* U+353C */
  0x0020,   /* U+353D */
  0x0020,   /* U+353E */
  0x0020,   /* U+353F */
  0x0020,   /* U+3540 */
  0x0020,   /* U+3541 */
  0x0020,   /* U+3542 */
  0x0020,   /* U+3543 */
  0x0020,   /* U+3544 */
  0x0020,   /* U+3545 */
  0x0020,   /* U+3546 */
  0x0020,   /* U+3547 */
  0x0020,   /* U+3548 */
  0x0020,   /* U+3549 */
  0x0020,   /* U+354A */
  0x0020,   /* U+354B */
  0x0020,   /* U+354C */
  0x0020,   /* U+354D */
  0x0020,   /* U+354E */
  0x0020,   /* U+354F */
  0x0020,   /* U+3550 */
  0x0020,   /* U+3551 */
  0x0020,   /* U+3552 */
  0x0020,   /* U+3553 */
  0x0020,   /* U+3554 */
  0x0020,   /* U+3555 */
  0x0020,   /* U+3556 */
  0x0020,   /* U+3557 */
  0x0020,   /* U+3558 */
  0x0020,   /* U+3559 */
  0x0020,   /* U+355A */
  0x0020,   /* U+355B */
  0x0020,   /* U+355C */
  0x0020,   /* U+355D */
  0x0020,   /* U+355E */
  0x0020,   /* U+355F */
  0x0020,   /* U+3560 */
  0x0020,   /* U+3561 */
  0x0020,   /* U+3562 */
  0x0020,   /* U+3563 */
  0x0020,   /* U+3564 */
  0x0020,   /* U+3565 */
  0x0020,   /* U+3566 */
  0x0020,   /* U+3567 */
  0x0020,   /* U+3568 */
  0x0020,   /* U+3569 */
  0x0020,   /* U+356A */
  0x0020,   /* U+356B */
  0x0020,   /* U+356C */
  0x0020,   /* U+356D */
  0x0020,   /* U+356E */
  0x0020,   /* U+356F */
  0x0020,   /* U+3570 */
  0x0020,   /* U+3571 */
  0x0020,   /* U+3572 */
  0x0020,   /* U+3573 */
  0x0020,   /* U+3574 */
  0x0020,   /* U+3575 */
  0x0020,   /* U+3576 */
  0x0020,   /* U+3577 */
  0x0020,   /* U+3578 */
  0x0020,   /* U+3579 */
  0x0020,   /* U+357A */
  0x0020,   /* U+357B */
  0x0020,   /* U+357C */
  0x0020,   /* U+357D */
  0x0020,   /* U+357E */
  0x0020,   /* U+357F */
  0x0020,   /* U+3580 */
  0x0020,   /* U+3581 */
  0x0020,   /* U+3582 */
  0x0020,   /* U+3583 */
  0x0020,   /* U+3584 */
  0x0020,   /* U+3585 */
  0x0020,   /* U+3586 */
  0x0020,   /* U+3587 */
  0x0020,   /* U+3588 */
  0x0020,   /* U+3589 */
  0x0020,   /* U+358A */
  0x0020,   /* U+358B */
  0x0020,   /* U+358C */
  0x0020,   /* U+358D */
  0x0020,   /* U+358E */
  0x0020,   /* U+358F */
  0x0020,   /* U+3590 */
  0x0020,   /* U+3591 */
  0x0020,   /* U+3592 */
  0x0020,   /* U+3593 */
  0x0020,   /* U+3594 */
  0x0020,   /* U+3595 */
  0x0020,   /* U+3596 */
  0x0020,   /* U+3597 */
  0x0020,   /* U+3598 */
  0x0020,   /* U+3599 */
  0x0020,   /* U+359A */
  0x0020,   /* U+359B */
  0x0020,   /* U+359C */
  0x0020,   /* U+359D */
  0x0020,   /* U+359E */
  0x0020,   /* U+359F */
  0x0020,   /* U+35A0 */
  0x0020,   /* U+35A1 */
  0x0020,   /* U+35A2 */
  0x0020,   /* U+35A3 */
  0x0020,   /* U+35A4 */
  0x0020,   /* U+35A5 */
  0x0020,   /* U+35A6 */
  0x0020,   /* U+35A7 */
  0x0020,   /* U+35A8 */
  0x0020,   /* U+35A9 */
  0x0020,   /* U+35AA */
  0x0020,   /* U+35AB */
  0x0020,   /* U+35AC */
  0x0020,   /* U+35AD */
  0x0020,   /* U+35AE */
  0x0020,   /* U+35AF */
  0x0020,   /* U+35B0 */
  0x0020,   /* U+35B1 */
  0x0020,   /* U+35B2 */
  0x0020,   /* U+35B3 */
  0x0020,   /* U+35B4 */
  0x0020,   /* U+35B5 */
  0x0020,   /* U+35B6 */
  0x0020,   /* U+35B7 */
  0x0020,   /* U+35B8 */
  0x0020,   /* U+35B9 */
  0x0020,   /* U+35BA */
  0x0020,   /* U+35BB */
  0x0020,   /* U+35BC */
  0x0020,   /* U+35BD */
  0x0020,   /* U+35BE */
  0x0020,   /* U+35BF */
  0x0020,   /* U+35C0 */
  0x0020,   /* U+35C1 */
  0x0020,   /* U+35C2 */
  0x0020,   /* U+35C3 */
  0x0020,   /* U+35C4 */
  0x0020,   /* U+35C5 */
  0x0020,   /* U+35C6 */
  0x0020,   /* U+35C7 */
  0x0020,   /* U+35C8 */
  0x0020,   /* U+35C9 */
  0x0020,   /* U+35CA */
  0x0020,   /* U+35CB */
  0x0020,   /* U+35CC */
  0x0020,   /* U+35CD */
  0x0020,   /* U+35CE */
  0x0020,   /* U+35CF */
  0x0020,   /* U+35D0 */
  0x0020,   /* U+35D1 */
  0x0020,   /* U+35D2 */
  0x0020,   /* U+35D3 */
  0x0020,   /* U+35D4 */
  0x0020,   /* U+35D5 */
  0x0020,   /* U+35D6 */
  0x0020,   /* U+35D7 */
  0x0020,   /* U+35D8 */
  0x0020,   /* U+35D9 */
  0x0020,   /* U+35DA */
  0x0020,   /* U+35DB */
  0x0020,   /* U+35DC */
  0x0020,   /* U+35DD */
  0x0020,   /* U+35DE */
  0x0020,   /* U+35DF */
  0x0020,   /* U+35E0 */
  0x0020,   /* U+35E1 */
  0x0020,   /* U+35E2 */
  0x0020,   /* U+35E3 */
  0x0020,   /* U+35E4 */
  0x0020,   /* U+35E5 */
  0x0020,   /* U+35E6 */
  0x0020,   /* U+35E7 */
  0x0020,   /* U+35E8 */
  0x0020,   /* U+35E9 */
  0x0020,   /* U+35EA */
  0x0020,   /* U+35EB */
  0x0020,   /* U+35EC */
  0x0020,   /* U+35ED */
  0x0020,   /* U+35EE */
  0x0020,   /* U+35EF */
  0x0020,   /* U+35F0 */
  0x0020,   /* U+35F1 */
  0x0020,   /* U+35F2 */
  0x0020,   /* U+35F3 */
  0x0020,   /* U+35F4 */
  0x0020,   /* U+35F5 */
  0x0020,   /* U+35F6 */
  0x0020,   /* U+35F7 */
  0x0020,   /* U+35F8 */
  0x0020,   /* U+35F9 */
  0x0020,   /* U+35FA */
  0x0020,   /* U+35FB */
  0x0020,   /* U+35FC */
  0x0020,   /* U+35FD */
  0x0020,   /* U+35FE */
  0x0020,   /* U+35FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3500 */
  0x0002,   /* U+3501 */
  0x0002,   /* U+3502 */
  0x0002,   /* U+3503 */
  0x0002,   /* U+3504 */
  0x0002,   /* U+3505 */
  0x0002,   /* U+3506 */
  0x0002,   /* U+3507 */
  0x0002,   /* U+3508 */
  0x0002,   /* U+3509 */
  0x0002,   /* U+350A */
  0x0002,   /* U+350B */
  0x0002,   /* U+350C */
  0x0002,   /* U+350D */
  0x0002,   /* U+350E */
  0x0002,   /* U+350F */
  0x0002,   /* U+3510 */
  0x0002,   /* U+3511 */
  0x0002,   /* U+3512 */
  0x0002,   /* U+3513 */
  0x0002,   /* U+3514 */
  0x0002,   /* U+3515 */
  0x0002,   /* U+3516 */
  0x0002,   /* U+3517 */
  0x0002,   /* U+3518 */
  0x0002,   /* U+3519 */
  0x0002,   /* U+351A */
  0x0002,   /* U+351B */
  0x0002,   /* U+351C */
  0x0002,   /* U+351D */
  0x0002,   /* U+351E */
  0x0002,   /* U+351F */
  0x0002,   /* U+3520 */
  0x0002,   /* U+3521 */
  0x0002,   /* U+3522 */
  0x0002,   /* U+3523 */
  0x0002,   /* U+3524 */
  0x0002,   /* U+3525 */
  0x0002,   /* U+3526 */
  0x0002,   /* U+3527 */
  0x0002,   /* U+3528 */
  0x0002,   /* U+3529 */
  0x0002,   /* U+352A */
  0x0002,   /* U+352B */
  0x0002,   /* U+352C */
  0x0002,   /* U+352D */
  0x0002,   /* U+352E */
  0x0002,   /* U+352F */
  0x0002,   /* U+3530 */
  0x0002,   /* U+3531 */
  0x0002,   /* U+3532 */
  0x0002,   /* U+3533 */
  0x0002,   /* U+3534 */
  0x0002,   /* U+3535 */
  0x0002,   /* U+3536 */
  0x0002,   /* U+3537 */
  0x0002,   /* U+3538 */
  0x0002,   /* U+3539 */
  0x0002,   /* U+353A */
  0x0002,   /* U+353B */
  0x0002,   /* U+353C */
  0x0002,   /* U+353D */
  0x0002,   /* U+353E */
  0x0002,   /* U+353F */
  0x0002,   /* U+3540 */
  0x0002,   /* U+3541 */
  0x0002,   /* U+3542 */
  0x0002,   /* U+3543 */
  0x0002,   /* U+3544 */
  0x0002,   /* U+3545 */
  0x0002,   /* U+3546 */
  0x0002,   /* U+3547 */
  0x0002,   /* U+3548 */
  0x0002,   /* U+3549 */
  0x0002,   /* U+354A */
  0x0002,   /* U+354B */
  0x0002,   /* U+354C */
  0x0002,   /* U+354D */
  0x0002,   /* U+354E */
  0x0002,   /* U+354F */
  0x0002,   /* U+3550 */
  0x0002,   /* U+3551 */
  0x0002,   /* U+3552 */
  0x0002,   /* U+3553 */
  0x0002,   /* U+3554 */
  0x0002,   /* U+3555 */
  0x0002,   /* U+3556 */
  0x0002,   /* U+3557 */
  0x0002,   /* U+3558 */
  0x0002,   /* U+3559 */
  0x0002,   /* U+355A */
  0x0002,   /* U+355B */
  0x0002,   /* U+355C */
  0x0002,   /* U+355D */
  0x0002,   /* U+355E */
  0x0002,   /* U+355F */
  0x0002,   /* U+3560 */
  0x0002,   /* U+3561 */
  0x0002,   /* U+3562 */
  0x0002,   /* U+3563 */
  0x0002,   /* U+3564 */
  0x0002,   /* U+3565 */
  0x0002,   /* U+3566 */
  0x0002,   /* U+3567 */
  0x0002,   /* U+3568 */
  0x0002,   /* U+3569 */
  0x0002,   /* U+356A */
  0x0002,   /* U+356B */
  0x0002,   /* U+356C */
  0x0002,   /* U+356D */
  0x0002,   /* U+356E */
  0x0002,   /* U+356F */
  0x0002,   /* U+3570 */
  0x0002,   /* U+3571 */
  0x0002,   /* U+3572 */
  0x0002,   /* U+3573 */
  0x0002,   /* U+3574 */
  0x0002,   /* U+3575 */
  0x0002,   /* U+3576 */
  0x0002,   /* U+3577 */
  0x0002,   /* U+3578 */
  0x0002,   /* U+3579 */
  0x0002,   /* U+357A */
  0x0002,   /* U+357B */
  0x0002,   /* U+357C */
  0x0002,   /* U+357D */
  0x0002,   /* U+357E */
  0x0002,   /* U+357F */
  0x0002,   /* U+3580 */
  0x0002,   /* U+3581 */
  0x0002,   /* U+3582 */
  0x0002,   /* U+3583 */
  0x0002,   /* U+3584 */
  0x0002,   /* U+3585 */
  0x0002,   /* U+3586 */
  0x0002,   /* U+3587 */
  0x0002,   /* U+3588 */
  0x0002,   /* U+3589 */
  0x0002,   /* U+358A */
  0x0002,   /* U+358B */
  0x0002,   /* U+358C */
  0x0002,   /* U+358D */
  0x0002,   /* U+358E */
  0x0002,   /* U+358F */
  0x0002,   /* U+3590 */
  0x0002,   /* U+3591 */
  0x0002,   /* U+3592 */
  0x0002,   /* U+3593 */
  0x0002,   /* U+3594 */
  0x0002,   /* U+3595 */
  0x0002,   /* U+3596 */
  0x0002,   /* U+3597 */
  0x0002,   /* U+3598 */
  0x0002,   /* U+3599 */
  0x0002,   /* U+359A */
  0x0002,   /* U+359B */
  0x0002,   /* U+359C */
  0x0002,   /* U+359D */
  0x0002,   /* U+359E */
  0x0002,   /* U+359F */
  0x0002,   /* U+35A0 */
  0x0002,   /* U+35A1 */
  0x0002,   /* U+35A2 */
  0x0002,   /* U+35A3 */
  0x0002,   /* U+35A4 */
  0x0002,   /* U+35A5 */
  0x0002,   /* U+35A6 */
  0x0002,   /* U+35A7 */
  0x0002,   /* U+35A8 */
  0x0002,   /* U+35A9 */
  0x0002,   /* U+35AA */
  0x0002,   /* U+35AB */
  0x0002,   /* U+35AC */
  0x0002,   /* U+35AD */
  0x0002,   /* U+35AE */
  0x0002,   /* U+35AF */
  0x0002,   /* U+35B0 */
  0x0002,   /* U+35B1 */
  0x0002,   /* U+35B2 */
  0x0002,   /* U+35B3 */
  0x0002,   /* U+35B4 */
  0x0002,   /* U+35B5 */
  0x0002,   /* U+35B6 */
  0x0002,   /* U+35B7 */
  0x0002,   /* U+35B8 */
  0x0002,   /* U+35B9 */
  0x0002,   /* U+35BA */
  0x0002,   /* U+35BB */
  0x0002,   /* U+35BC */
  0x0002,   /* U+35BD */
  0x0002,   /* U+35BE */
  0x0002,   /* U+35BF */
  0x0002,   /* U+35C0 */
  0x0002,   /* U+35C1 */
  0x0002,   /* U+35C2 */
  0x0002,   /* U+35C3 */
  0x0002,   /* U+35C4 */
  0x0002,   /* U+35C5 */
  0x0002,   /* U+35C6 */
  0x0002,   /* U+35C7 */
  0x0002,   /* U+35C8 */
  0x0002,   /* U+35C9 */
  0x0002,   /* U+35CA */
  0x0002,   /* U+35CB */
  0x0002,   /* U+35CC */
  0x0002,   /* U+35CD */
  0x0002,   /* U+35CE */
  0x0002,   /* U+35CF */
  0x0002,   /* U+35D0 */
  0x0002,   /* U+35D1 */
  0x0002,   /* U+35D2 */
  0x0002,   /* U+35D3 */
  0x0002,   /* U+35D4 */
  0x0002,   /* U+35D5 */
  0x0002,   /* U+35D6 */
  0x0002,   /* U+35D7 */
  0x0002,   /* U+35D8 */
  0x0002,   /* U+35D9 */
  0x0002,   /* U+35DA */
  0x0002,   /* U+35DB */
  0x0002,   /* U+35DC */
  0x0002,   /* U+35DD */
  0x0002,   /* U+35DE */
  0x0002,   /* U+35DF */
  0x0002,   /* U+35E0 */
  0x0002,   /* U+35E1 */
  0x0002,   /* U+35E2 */
  0x0002,   /* U+35E3 */
  0x0002,   /* U+35E4 */
  0x0002,   /* U+35E5 */
  0x0002,   /* U+35E6 */
  0x0002,   /* U+35E7 */
  0x0002,   /* U+35E8 */
  0x0002,   /* U+35E9 */
  0x0002,   /* U+35EA */
  0x0002,   /* U+35EB */
  0x0002,   /* U+35EC */
  0x0002,   /* U+35ED */
  0x0002,   /* U+35EE */
  0x0002,   /* U+35EF */
  0x0002,   /* U+35F0 */
  0x0002,   /* U+35F1 */
  0x0002,   /* U+35F2 */
  0x0002,   /* U+35F3 */
  0x0002,   /* U+35F4 */
  0x0002,   /* U+35F5 */
  0x0002,   /* U+35F6 */
  0x0002,   /* U+35F7 */
  0x0002,   /* U+35F8 */
  0x0002,   /* U+35F9 */
  0x0002,   /* U+35FA */
  0x0002,   /* U+35FB */
  0x0002,   /* U+35FC */
  0x0002,   /* U+35FD */
  0x0002,   /* U+35FE */
  0x0002,   /* U+35FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0xB507,   /* U+3507 */
  0xB508,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0xB510,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0xB514,   /* U+3514 */
  0x0000,   /* U+3515 */
  0xB516,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0xB51B,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0xB51F,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0xB52B,   /* U+352B */
  0xB52C,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0xB532,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0xB53B,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0xB540,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0xB54D,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0xB553,   /* U+3553 */
  0xB554,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0xB558,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0xB55D,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0xB573,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0xB57C,   /* U+357C */
  0x0000,   /* U+357D */
  0xB57E,   /* U+357E */
  0xB57F,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0xB584,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0xB588,   /* U+3588 */
  0xB589,   /* U+3589 */
  0x0000,   /* U+358A */
  0xB58B,   /* U+358B */
  0xB58C,   /* U+358C */
  0xB58D,   /* U+358D */
  0xB58E,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0xB599,   /* U+3599 */
  0xB59A,   /* U+359A */
  0xB59B,   /* U+359B */
  0xB59C,   /* U+359C */
  0xB59D,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0xB5AC,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0xB5AF,   /* U+35AF */
  0xB5B0,   /* U+35B0 */
  0xB5B1,   /* U+35B1 */
  0xB5B2,   /* U+35B2 */
  0xB5B3,   /* U+35B3 */
  0xB5B4,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0xB5CD,   /* U+35CD */
  0xB5CE,   /* U+35CE */
  0x0000,   /* U+35CF */
  0xB5D0,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0xB5DD,   /* U+35DD */
  0xB5DE,   /* U+35DE */
  0xB5DF,   /* U+35DF */
  0xB5E0,   /* U+35E0 */
  0xB5E1,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0xB5EA,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0xB5EE,   /* U+35EE */
  0xB5EF,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0xB5F8,   /* U+35F8 */
  0xB5F9,   /* U+35F9 */
  0xB5FA,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */
};

uint16_t zh_han_p036[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 
  1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 

  /* Primary weight 1 for each character. */
  0xBDB7,   /* U+3600 */
  0xA8AB,   /* U+3601 */
  0x2D82,   /* U+3602 */
  0xBDC1,   /* U+3603 */
  0x5E10,   /* U+3604 */
  0x9A39,   /* U+3605 */
  0x8C0D,   /* U+3606 */
  0x7FC2,   /* U+3607 */
  0xA8CA,   /* U+3608 */
  0xB7F3,   /* U+3609 */
  0x97E9,   /* U+360A */
  0x9A40,   /* U+360B */
  0x55AC,   /* U+360C */
  0x4CC3,   /* U+360D */
  0x4387,   /* U+360E */
  0xBDC1,   /* U+360F */
  0x732F,   /* U+3610 */
  0x5FD3,   /* U+3611 */
  0xBDC1,   /* U+3612 */
  0x5C45,   /* U+3613 */
  0x8155,   /* U+3614 */
  0x438B,   /* U+3615 */
  0xA2E0,   /* U+3616 */
  0x7D14,   /* U+3617 */
  0xBDC1,   /* U+3618 */
  0xA2EC,   /* U+3619 */
  0x438D,   /* U+361A */
  0x57B4,   /* U+361B */
  0x2A39,   /* U+361C */
  0x704F,   /* U+361D */
  0x4B20,   /* U+361E */
  0xBDC1,   /* U+361F */
  0x20DC,   /* U+3620 */
  0x9929,   /* U+3621 */
  0x9588,   /* U+3622 */
  0xA063,   /* U+3623 */
  0x92AE,   /* U+3624 */
  0xAC25,   /* U+3625 */
  0x7B0A,   /* U+3626 */
  0x9F96,   /* U+3627 */
  0x7054,   /* U+3628 */
  0x20D4,   /* U+3629 */
  0x4459,   /* U+362A */
  0x535D,   /* U+362B */
  0x1DA6,   /* U+362C */
  0x1DA7,   /* U+362D */
  0xBDC1,   /* U+362E */
  0xBDC1,   /* U+362F */
  0xB4EF,   /* U+3630 */
  0x8C28,   /* U+3631 */
  0x54CD,   /* U+3632 */
  0xBDC1,   /* U+3633 */
  0xBD9E,   /* U+3634 */
  0x247E,   /* U+3635 */
  0x5197,   /* U+3636 */
  0x1C8F,   /* U+3637 */
  0xB15E,   /* U+3638 */
  0x2D63,   /* U+3639 */
  0x384C,   /* U+363A */
  0xBDC1,   /* U+363B */
  0xBDC1,   /* U+363C */
  0xBDC1,   /* U+363D */
  0xBDC1,   /* U+363E */
  0x705E,   /* U+363F */
  0x63ED,   /* U+3640 */
  0x694A,   /* U+3641 */
  0x35F6,   /* U+3642 */
  0x1ED8,   /* U+3643 */
  0x20F6,   /* U+3644 */
  0x1F40,   /* U+3645 */
  0xBDC1,   /* U+3646 */
  0x2BEB,   /* U+3647 */
  0x9980,   /* U+3648 */
  0x8ED7,   /* U+3649 */
  0x279F,   /* U+364A */
  0xBDC1,   /* U+364B */
  0xBDC1,   /* U+364C */
  0x3668,   /* U+364D */
  0x93A3,   /* U+364E */
  0x3C4E,   /* U+364F */
  0x369C,   /* U+3650 */
  0xAD8C,   /* U+3651 */
  0xA5B8,   /* U+3652 */
  0x5A91,   /* U+3653 */
  0x9442,   /* U+3654 */
  0x59E6,   /* U+3655 */
  0xBDC1,   /* U+3656 */
  0x93A4,   /* U+3657 */
  0xA4AF,   /* U+3658 */
  0x6472,   /* U+3659 */
  0x9E1C,   /* U+365A */
  0x246B,   /* U+365B */
  0x29EA,   /* U+365C */
  0x9CBB,   /* U+365D */
  0x7078,   /* U+365E */
  0x5CD7,   /* U+365F */
  0xA666,   /* U+3660 */
  0xBC2F,   /* U+3661 */
  0x680E,   /* U+3662 */
  0xB3FF,   /* U+3663 */
  0x9987,   /* U+3664 */
  0x4251,   /* U+3665 */
  0x9CC5,   /* U+3666 */
  0xBDC1,   /* U+3667 */
  0x4D86,   /* U+3668 */
  0x6156,   /* U+3669 */
  0xA88F,   /* U+366A */
  0x4C97,   /* U+366B */
  0xA9AA,   /* U+366C */
  0xBDC1,   /* U+366D */
  0x2F7D,   /* U+366E */
  0xA890,   /* U+366F */
  0x9D67,   /* U+3670 */
  0x4481,   /* U+3671 */
  0xAB8F,   /* U+3672 */
  0x57CC,   /* U+3673 */
  0x2766,   /* U+3674 */
  0x8C01,   /* U+3675 */
  0x8CFB,   /* U+3676 */
  0xB6AD,   /* U+3677 */
  0x1F82,   /* U+3678 */
  0x6A03,   /* U+3679 */
  0x5AA7,   /* U+367A */
  0x26E7,   /* U+367B */
  0x5DC9,   /* U+367C */
  0xBDC1,   /* U+367D */
  0x98F6,   /* U+367E */
  0xBDC1,   /* U+367F */
  0x97FF,   /* U+3680 */
  0x7AA0,   /* U+3681 */
  0x6E9E,   /* U+3682 */
  0xB009,   /* U+3683 */
  0xBDC1,   /* U+3684 */
  0x640F,   /* U+3685 */
  0x3C38,   /* U+3686 */
  0xBC19,   /* U+3687 */
  0xBDC1,   /* U+3688 */
  0x4005,   /* U+3689 */
  0x576B,   /* U+368A */
  0x3340,   /* U+368B */
  0x4830,   /* U+368C */
  0x5AC6,   /* U+368D */
  0xBDC1,   /* U+368E */
  0x3DD2,   /* U+368F */
  0x8D93,   /* U+3690 */
  0xBDC1,   /* U+3691 */
  0x82FB,   /* U+3692 */
  0x5BF2,   /* U+3693 */
  0x7055,   /* U+3694 */
  0x3B43,   /* U+3695 */
  0x3DD3,   /* U+3696 */
  0x7AA8,   /* U+3697 */
  0x1EBB,   /* U+3698 */
  0x4DE6,   /* U+3699 */
  0x590A,   /* U+369A */
  0x989A,   /* U+369B */
  0xADE6,   /* U+369C */
  0xBA8C,   /* U+369D */
  0x8496,   /* U+369E */
  0x2D2D,   /* U+369F */
  0x9BCC,   /* U+36A0 */
  0x4D01,   /* U+36A1 */
  0x717A,   /* U+36A2 */
  0x9C17,   /* U+36A3 */
  0xA799,   /* U+36A4 */
  0xACB4,   /* U+36A5 */
  0xA692,   /* U+36A6 */
  0xA2FD,   /* U+36A7 */
  0x848A,   /* U+36A8 */
  0x7EB8,   /* U+36A9 */
  0x445A,   /* U+36AA */
  0x8116,   /* U+36AB */
  0x5702,   /* U+36AC */
  0xABD4,   /* U+36AD */
  0xBDC1,   /* U+36AE */
  0x9DDF,   /* U+36AF */
  0x7335,   /* U+36B0 */
  0x7C34,   /* U+36B1 */
  0x26A8,   /* U+36B2 */
  0xBDC1,   /* U+36B3 */
  0x247F,   /* U+36B4 */
  0x3446,   /* U+36B5 */
  0x88AF,   /* U+36B6 */
  0x3812,   /* U+36B7 */
  0xBDC1,   /* U+36B8 */
  0x68ED,   /* U+36B9 */
  0xB06D,   /* U+36BA */
  0x4B9A,   /* U+36BB */
  0xBDC1,   /* U+36BC */
  0x7A75,   /* U+36BD */
  0x9E8B,   /* U+36BE */
  0x7304,   /* U+36BF */
  0x2B8B,   /* U+36C0 */
  0x7386,   /* U+36C1 */
  0x71C9,   /* U+36C2 */
  0x5198,   /* U+36C3 */
  0xA64F,   /* U+36C4 */
  0x3830,   /* U+36C5 */
  0x36BF,   /* U+36C6 */
  0xBDC1,   /* U+36C7 */
  0xBDC1,   /* U+36C8 */
  0xBDC1,   /* U+36C9 */
  0x3694,   /* U+36CA */
  0xBDC1,   /* U+36CB */
  0xBDC1,   /* U+36CC */
  0x7AB9,   /* U+36CD */
  0x6618,   /* U+36CE */
  0x7C78,   /* U+36CF */
  0x8970,   /* U+36D0 */
  0x2544,   /* U+36D1 */
  0x34D8,   /* U+36D2 */
  0x9742,   /* U+36D3 */
  0x3A69,   /* U+36D4 */
  0xA7FC,   /* U+36D5 */
  0x8AEC,   /* U+36D6 */
  0x7AA3,   /* U+36D7 */
  0x7618,   /* U+36D8 */
  0x9DC0,   /* U+36D9 */
  0x9039,   /* U+36DA */
  0x9DF5,   /* U+36DB */
  0xABE9,   /* U+36DC */
  0x1FC5,   /* U+36DD */
  0x6484,   /* U+36DE */
  0xBDC1,   /* U+36DF */
  0xBDC1,   /* U+36E0 */
  0xBDC1,   /* U+36E1 */
  0xBDC1,   /* U+36E2 */
  0xB02E,   /* U+36E3 */
  0x5E2F,   /* U+36E4 */
  0x8B86,   /* U+36E5 */
  0x5C69,   /* U+36E6 */
  0x6836,   /* U+36E7 */
  0x7A03,   /* U+36E8 */
  0xB8C9,   /* U+36E9 */
  0xA38D,   /* U+36EA */
  0x9756,   /* U+36EB */
  0x6575,   /* U+36EC */
  0x9757,   /* U+36ED */
  0x81D6,   /* U+36EE */
  0x38FB,   /* U+36EF */
  0xBDC1,   /* U+36F0 */
  0x9443,   /* U+36F1 */
  0x386D,   /* U+36F2 */
  0xA833,   /* U+36F3 */
  0x6EDA,   /* U+36F4 */
  0x2902,   /* U+36F5 */
  0x8CAF,   /* U+36F6 */
  0x4BB8,   /* U+36F7 */
  0x8755,   /* U+36F8 */
  0x74E6,   /* U+36F9 */
  0x1CDE,   /* U+36FA */
  0x59B6,   /* U+36FB */
  0x2617,   /* U+36FC */
  0xBDC1,   /* U+36FD */
  0x9A13,   /* U+36FE */
  0xB76E,   /* U+36FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3600 */
  0x0020,   /* U+3601 */
  0x0020,   /* U+3602 */
  0x0020,   /* U+3603 */
  0x0020,   /* U+3604 */
  0x0020,   /* U+3605 */
  0x0020,   /* U+3606 */
  0x0020,   /* U+3607 */
  0x0020,   /* U+3608 */
  0x0020,   /* U+3609 */
  0x0020,   /* U+360A */
  0x0020,   /* U+360B */
  0x0020,   /* U+360C */
  0x0020,   /* U+360D */
  0x0020,   /* U+360E */
  0x0020,   /* U+360F */
  0x0020,   /* U+3610 */
  0x0020,   /* U+3611 */
  0x0020,   /* U+3612 */
  0x0020,   /* U+3613 */
  0x0020,   /* U+3614 */
  0x0020,   /* U+3615 */
  0x0020,   /* U+3616 */
  0x0020,   /* U+3617 */
  0x0020,   /* U+3618 */
  0x0020,   /* U+3619 */
  0x0020,   /* U+361A */
  0x0020,   /* U+361B */
  0x0020,   /* U+361C */
  0x0020,   /* U+361D */
  0x0020,   /* U+361E */
  0x0020,   /* U+361F */
  0x0020,   /* U+3620 */
  0x0020,   /* U+3621 */
  0x0020,   /* U+3622 */
  0x0020,   /* U+3623 */
  0x0020,   /* U+3624 */
  0x0020,   /* U+3625 */
  0x0020,   /* U+3626 */
  0x0020,   /* U+3627 */
  0x0020,   /* U+3628 */
  0x0020,   /* U+3629 */
  0x0020,   /* U+362A */
  0x0020,   /* U+362B */
  0x0020,   /* U+362C */
  0x0020,   /* U+362D */
  0x0020,   /* U+362E */
  0x0020,   /* U+362F */
  0x0020,   /* U+3630 */
  0x0020,   /* U+3631 */
  0x0020,   /* U+3632 */
  0x0020,   /* U+3633 */
  0x0020,   /* U+3634 */
  0x0020,   /* U+3635 */
  0x0020,   /* U+3636 */
  0x0020,   /* U+3637 */
  0x0020,   /* U+3638 */
  0x0020,   /* U+3639 */
  0x0020,   /* U+363A */
  0x0020,   /* U+363B */
  0x0020,   /* U+363C */
  0x0020,   /* U+363D */
  0x0020,   /* U+363E */
  0x0020,   /* U+363F */
  0x0020,   /* U+3640 */
  0x0020,   /* U+3641 */
  0x0020,   /* U+3642 */
  0x0020,   /* U+3643 */
  0x0020,   /* U+3644 */
  0x0020,   /* U+3645 */
  0x0020,   /* U+3646 */
  0x0020,   /* U+3647 */
  0x0020,   /* U+3648 */
  0x0020,   /* U+3649 */
  0x0020,   /* U+364A */
  0x0020,   /* U+364B */
  0x0020,   /* U+364C */
  0x0020,   /* U+364D */
  0x0020,   /* U+364E */
  0x0020,   /* U+364F */
  0x0020,   /* U+3650 */
  0x0020,   /* U+3651 */
  0x0020,   /* U+3652 */
  0x0020,   /* U+3653 */
  0x0020,   /* U+3654 */
  0x0020,   /* U+3655 */
  0x0020,   /* U+3656 */
  0x0020,   /* U+3657 */
  0x0020,   /* U+3658 */
  0x0020,   /* U+3659 */
  0x0020,   /* U+365A */
  0x0020,   /* U+365B */
  0x0020,   /* U+365C */
  0x0020,   /* U+365D */
  0x0020,   /* U+365E */
  0x0020,   /* U+365F */
  0x0020,   /* U+3660 */
  0x0020,   /* U+3661 */
  0x0020,   /* U+3662 */
  0x0020,   /* U+3663 */
  0x0020,   /* U+3664 */
  0x0020,   /* U+3665 */
  0x0020,   /* U+3666 */
  0x0020,   /* U+3667 */
  0x0020,   /* U+3668 */
  0x0020,   /* U+3669 */
  0x0020,   /* U+366A */
  0x0020,   /* U+366B */
  0x0020,   /* U+366C */
  0x0020,   /* U+366D */
  0x0020,   /* U+366E */
  0x0020,   /* U+366F */
  0x0020,   /* U+3670 */
  0x0020,   /* U+3671 */
  0x0020,   /* U+3672 */
  0x0020,   /* U+3673 */
  0x0020,   /* U+3674 */
  0x0020,   /* U+3675 */
  0x0020,   /* U+3676 */
  0x0020,   /* U+3677 */
  0x0020,   /* U+3678 */
  0x0020,   /* U+3679 */
  0x0020,   /* U+367A */
  0x0020,   /* U+367B */
  0x0020,   /* U+367C */
  0x0020,   /* U+367D */
  0x0020,   /* U+367E */
  0x0020,   /* U+367F */
  0x0020,   /* U+3680 */
  0x0020,   /* U+3681 */
  0x0020,   /* U+3682 */
  0x0020,   /* U+3683 */
  0x0020,   /* U+3684 */
  0x0020,   /* U+3685 */
  0x0020,   /* U+3686 */
  0x0020,   /* U+3687 */
  0x0020,   /* U+3688 */
  0x0020,   /* U+3689 */
  0x0020,   /* U+368A */
  0x0020,   /* U+368B */
  0x0020,   /* U+368C */
  0x0020,   /* U+368D */
  0x0020,   /* U+368E */
  0x0020,   /* U+368F */
  0x0020,   /* U+3690 */
  0x0020,   /* U+3691 */
  0x0020,   /* U+3692 */
  0x0020,   /* U+3693 */
  0x0020,   /* U+3694 */
  0x0020,   /* U+3695 */
  0x0020,   /* U+3696 */
  0x0020,   /* U+3697 */
  0x0020,   /* U+3698 */
  0x0020,   /* U+3699 */
  0x0020,   /* U+369A */
  0x0020,   /* U+369B */
  0x0020,   /* U+369C */
  0x0020,   /* U+369D */
  0x0020,   /* U+369E */
  0x0020,   /* U+369F */
  0x0020,   /* U+36A0 */
  0x0020,   /* U+36A1 */
  0x0020,   /* U+36A2 */
  0x0020,   /* U+36A3 */
  0x0020,   /* U+36A4 */
  0x0020,   /* U+36A5 */
  0x0020,   /* U+36A6 */
  0x0020,   /* U+36A7 */
  0x0020,   /* U+36A8 */
  0x0020,   /* U+36A9 */
  0x0020,   /* U+36AA */
  0x0020,   /* U+36AB */
  0x0020,   /* U+36AC */
  0x0020,   /* U+36AD */
  0x0020,   /* U+36AE */
  0x0020,   /* U+36AF */
  0x0020,   /* U+36B0 */
  0x0020,   /* U+36B1 */
  0x0020,   /* U+36B2 */
  0x0020,   /* U+36B3 */
  0x0020,   /* U+36B4 */
  0x0020,   /* U+36B5 */
  0x0020,   /* U+36B6 */
  0x0020,   /* U+36B7 */
  0x0020,   /* U+36B8 */
  0x0020,   /* U+36B9 */
  0x0020,   /* U+36BA */
  0x0020,   /* U+36BB */
  0x0020,   /* U+36BC */
  0x0020,   /* U+36BD */
  0x0020,   /* U+36BE */
  0x0020,   /* U+36BF */
  0x0020,   /* U+36C0 */
  0x0020,   /* U+36C1 */
  0x0020,   /* U+36C2 */
  0x0020,   /* U+36C3 */
  0x0020,   /* U+36C4 */
  0x0020,   /* U+36C5 */
  0x0020,   /* U+36C6 */
  0x0020,   /* U+36C7 */
  0x0020,   /* U+36C8 */
  0x0020,   /* U+36C9 */
  0x0020,   /* U+36CA */
  0x0020,   /* U+36CB */
  0x0020,   /* U+36CC */
  0x0020,   /* U+36CD */
  0x0020,   /* U+36CE */
  0x0020,   /* U+36CF */
  0x0020,   /* U+36D0 */
  0x0020,   /* U+36D1 */
  0x0020,   /* U+36D2 */
  0x0020,   /* U+36D3 */
  0x0020,   /* U+36D4 */
  0x0020,   /* U+36D5 */
  0x0020,   /* U+36D6 */
  0x0020,   /* U+36D7 */
  0x0020,   /* U+36D8 */
  0x0020,   /* U+36D9 */
  0x0020,   /* U+36DA */
  0x0020,   /* U+36DB */
  0x0020,   /* U+36DC */
  0x0020,   /* U+36DD */
  0x0020,   /* U+36DE */
  0x0020,   /* U+36DF */
  0x0020,   /* U+36E0 */
  0x0020,   /* U+36E1 */
  0x0020,   /* U+36E2 */
  0x0020,   /* U+36E3 */
  0x0020,   /* U+36E4 */
  0x0020,   /* U+36E5 */
  0x0020,   /* U+36E6 */
  0x0020,   /* U+36E7 */
  0x0020,   /* U+36E8 */
  0x0020,   /* U+36E9 */
  0x0020,   /* U+36EA */
  0x0020,   /* U+36EB */
  0x0020,   /* U+36EC */
  0x0020,   /* U+36ED */
  0x0020,   /* U+36EE */
  0x0020,   /* U+36EF */
  0x0020,   /* U+36F0 */
  0x0020,   /* U+36F1 */
  0x0020,   /* U+36F2 */
  0x0020,   /* U+36F3 */
  0x0020,   /* U+36F4 */
  0x0020,   /* U+36F5 */
  0x0020,   /* U+36F6 */
  0x0020,   /* U+36F7 */
  0x0020,   /* U+36F8 */
  0x0020,   /* U+36F9 */
  0x0020,   /* U+36FA */
  0x0020,   /* U+36FB */
  0x0020,   /* U+36FC */
  0x0020,   /* U+36FD */
  0x0020,   /* U+36FE */
  0x0020,   /* U+36FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3600 */
  0x0002,   /* U+3601 */
  0x0002,   /* U+3602 */
  0x0002,   /* U+3603 */
  0x0002,   /* U+3604 */
  0x0002,   /* U+3605 */
  0x0002,   /* U+3606 */
  0x0002,   /* U+3607 */
  0x0002,   /* U+3608 */
  0x0002,   /* U+3609 */
  0x0002,   /* U+360A */
  0x0002,   /* U+360B */
  0x0002,   /* U+360C */
  0x0002,   /* U+360D */
  0x0002,   /* U+360E */
  0x0002,   /* U+360F */
  0x0002,   /* U+3610 */
  0x0002,   /* U+3611 */
  0x0002,   /* U+3612 */
  0x0002,   /* U+3613 */
  0x0002,   /* U+3614 */
  0x0002,   /* U+3615 */
  0x0002,   /* U+3616 */
  0x0002,   /* U+3617 */
  0x0002,   /* U+3618 */
  0x0002,   /* U+3619 */
  0x0002,   /* U+361A */
  0x0002,   /* U+361B */
  0x0002,   /* U+361C */
  0x0002,   /* U+361D */
  0x0002,   /* U+361E */
  0x0002,   /* U+361F */
  0x0002,   /* U+3620 */
  0x0002,   /* U+3621 */
  0x0002,   /* U+3622 */
  0x0002,   /* U+3623 */
  0x0002,   /* U+3624 */
  0x0002,   /* U+3625 */
  0x0002,   /* U+3626 */
  0x0002,   /* U+3627 */
  0x0002,   /* U+3628 */
  0x0002,   /* U+3629 */
  0x0002,   /* U+362A */
  0x0002,   /* U+362B */
  0x0002,   /* U+362C */
  0x0002,   /* U+362D */
  0x0002,   /* U+362E */
  0x0002,   /* U+362F */
  0x0002,   /* U+3630 */
  0x0002,   /* U+3631 */
  0x0002,   /* U+3632 */
  0x0002,   /* U+3633 */
  0x0002,   /* U+3634 */
  0x0002,   /* U+3635 */
  0x0002,   /* U+3636 */
  0x0002,   /* U+3637 */
  0x0002,   /* U+3638 */
  0x0002,   /* U+3639 */
  0x0002,   /* U+363A */
  0x0002,   /* U+363B */
  0x0002,   /* U+363C */
  0x0002,   /* U+363D */
  0x0002,   /* U+363E */
  0x0002,   /* U+363F */
  0x0002,   /* U+3640 */
  0x0002,   /* U+3641 */
  0x0002,   /* U+3642 */
  0x0002,   /* U+3643 */
  0x0002,   /* U+3644 */
  0x0002,   /* U+3645 */
  0x0002,   /* U+3646 */
  0x0002,   /* U+3647 */
  0x0002,   /* U+3648 */
  0x0002,   /* U+3649 */
  0x0002,   /* U+364A */
  0x0002,   /* U+364B */
  0x0002,   /* U+364C */
  0x0002,   /* U+364D */
  0x0002,   /* U+364E */
  0x0002,   /* U+364F */
  0x0002,   /* U+3650 */
  0x0002,   /* U+3651 */
  0x0002,   /* U+3652 */
  0x0002,   /* U+3653 */
  0x0002,   /* U+3654 */
  0x0002,   /* U+3655 */
  0x0002,   /* U+3656 */
  0x0002,   /* U+3657 */
  0x0002,   /* U+3658 */
  0x0002,   /* U+3659 */
  0x0002,   /* U+365A */
  0x0002,   /* U+365B */
  0x0002,   /* U+365C */
  0x0002,   /* U+365D */
  0x0002,   /* U+365E */
  0x0002,   /* U+365F */
  0x0002,   /* U+3660 */
  0x0002,   /* U+3661 */
  0x0002,   /* U+3662 */
  0x0002,   /* U+3663 */
  0x0002,   /* U+3664 */
  0x0002,   /* U+3665 */
  0x0002,   /* U+3666 */
  0x0002,   /* U+3667 */
  0x0002,   /* U+3668 */
  0x0002,   /* U+3669 */
  0x0002,   /* U+366A */
  0x0002,   /* U+366B */
  0x0002,   /* U+366C */
  0x0002,   /* U+366D */
  0x0002,   /* U+366E */
  0x0002,   /* U+366F */
  0x0002,   /* U+3670 */
  0x0002,   /* U+3671 */
  0x0002,   /* U+3672 */
  0x0002,   /* U+3673 */
  0x0002,   /* U+3674 */
  0x0002,   /* U+3675 */
  0x0002,   /* U+3676 */
  0x0002,   /* U+3677 */
  0x0002,   /* U+3678 */
  0x0002,   /* U+3679 */
  0x0002,   /* U+367A */
  0x0002,   /* U+367B */
  0x0002,   /* U+367C */
  0x0002,   /* U+367D */
  0x0002,   /* U+367E */
  0x0002,   /* U+367F */
  0x0002,   /* U+3680 */
  0x0002,   /* U+3681 */
  0x0002,   /* U+3682 */
  0x0002,   /* U+3683 */
  0x0002,   /* U+3684 */
  0x0002,   /* U+3685 */
  0x0002,   /* U+3686 */
  0x0002,   /* U+3687 */
  0x0002,   /* U+3688 */
  0x0002,   /* U+3689 */
  0x0002,   /* U+368A */
  0x0002,   /* U+368B */
  0x0002,   /* U+368C */
  0x0002,   /* U+368D */
  0x0002,   /* U+368E */
  0x0002,   /* U+368F */
  0x0002,   /* U+3690 */
  0x0002,   /* U+3691 */
  0x0002,   /* U+3692 */
  0x0002,   /* U+3693 */
  0x0002,   /* U+3694 */
  0x0002,   /* U+3695 */
  0x0002,   /* U+3696 */
  0x0002,   /* U+3697 */
  0x0002,   /* U+3698 */
  0x0002,   /* U+3699 */
  0x0002,   /* U+369A */
  0x0002,   /* U+369B */
  0x0002,   /* U+369C */
  0x0002,   /* U+369D */
  0x0002,   /* U+369E */
  0x0002,   /* U+369F */
  0x0002,   /* U+36A0 */
  0x0002,   /* U+36A1 */
  0x0002,   /* U+36A2 */
  0x0002,   /* U+36A3 */
  0x0002,   /* U+36A4 */
  0x0002,   /* U+36A5 */
  0x0002,   /* U+36A6 */
  0x0002,   /* U+36A7 */
  0x0002,   /* U+36A8 */
  0x0002,   /* U+36A9 */
  0x0002,   /* U+36AA */
  0x0002,   /* U+36AB */
  0x0002,   /* U+36AC */
  0x0002,   /* U+36AD */
  0x0002,   /* U+36AE */
  0x0002,   /* U+36AF */
  0x0002,   /* U+36B0 */
  0x0002,   /* U+36B1 */
  0x0002,   /* U+36B2 */
  0x0002,   /* U+36B3 */
  0x0002,   /* U+36B4 */
  0x0002,   /* U+36B5 */
  0x0002,   /* U+36B6 */
  0x0002,   /* U+36B7 */
  0x0002,   /* U+36B8 */
  0x0002,   /* U+36B9 */
  0x0002,   /* U+36BA */
  0x0002,   /* U+36BB */
  0x0002,   /* U+36BC */
  0x0002,   /* U+36BD */
  0x0002,   /* U+36BE */
  0x0002,   /* U+36BF */
  0x0002,   /* U+36C0 */
  0x0002,   /* U+36C1 */
  0x0002,   /* U+36C2 */
  0x0002,   /* U+36C3 */
  0x0002,   /* U+36C4 */
  0x0002,   /* U+36C5 */
  0x0002,   /* U+36C6 */
  0x0002,   /* U+36C7 */
  0x0002,   /* U+36C8 */
  0x0002,   /* U+36C9 */
  0x0002,   /* U+36CA */
  0x0002,   /* U+36CB */
  0x0002,   /* U+36CC */
  0x0002,   /* U+36CD */
  0x0002,   /* U+36CE */
  0x0002,   /* U+36CF */
  0x0002,   /* U+36D0 */
  0x0002,   /* U+36D1 */
  0x0002,   /* U+36D2 */
  0x0002,   /* U+36D3 */
  0x0002,   /* U+36D4 */
  0x0002,   /* U+36D5 */
  0x0002,   /* U+36D6 */
  0x0002,   /* U+36D7 */
  0x0002,   /* U+36D8 */
  0x0002,   /* U+36D9 */
  0x0002,   /* U+36DA */
  0x0002,   /* U+36DB */
  0x0002,   /* U+36DC */
  0x0002,   /* U+36DD */
  0x0002,   /* U+36DE */
  0x0002,   /* U+36DF */
  0x0002,   /* U+36E0 */
  0x0002,   /* U+36E1 */
  0x0002,   /* U+36E2 */
  0x0002,   /* U+36E3 */
  0x0002,   /* U+36E4 */
  0x0002,   /* U+36E5 */
  0x0002,   /* U+36E6 */
  0x0002,   /* U+36E7 */
  0x0002,   /* U+36E8 */
  0x0002,   /* U+36E9 */
  0x0002,   /* U+36EA */
  0x0002,   /* U+36EB */
  0x0002,   /* U+36EC */
  0x0002,   /* U+36ED */
  0x0002,   /* U+36EE */
  0x0002,   /* U+36EF */
  0x0002,   /* U+36F0 */
  0x0002,   /* U+36F1 */
  0x0002,   /* U+36F2 */
  0x0002,   /* U+36F3 */
  0x0002,   /* U+36F4 */
  0x0002,   /* U+36F5 */
  0x0002,   /* U+36F6 */
  0x0002,   /* U+36F7 */
  0x0002,   /* U+36F8 */
  0x0002,   /* U+36F9 */
  0x0002,   /* U+36FA */
  0x0002,   /* U+36FB */
  0x0002,   /* U+36FC */
  0x0002,   /* U+36FD */
  0x0002,   /* U+36FE */
  0x0002,   /* U+36FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0xB603,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0xB60F,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0xB612,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0xB618,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0xB61F,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0xB62E,   /* U+362E */
  0xB62F,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0xB633,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0xB63B,   /* U+363B */
  0xB63C,   /* U+363C */
  0xB63D,   /* U+363D */
  0xB63E,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0xB646,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0xB64B,   /* U+364B */
  0xB64C,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0xB656,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0xB667,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0xB66D,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0xB67D,   /* U+367D */
  0x0000,   /* U+367E */
  0xB67F,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0xB684,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0xB688,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0xB68E,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0xB691,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0xB6AE,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0xB6B3,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0xB6B8,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0xB6BC,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0xB6C7,   /* U+36C7 */
  0xB6C8,   /* U+36C8 */
  0xB6C9,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0xB6CB,   /* U+36CB */
  0xB6CC,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0xB6DF,   /* U+36DF */
  0xB6E0,   /* U+36E0 */
  0xB6E1,   /* U+36E1 */
  0xB6E2,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0xB6F0,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0xB6FD,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */
};

uint16_t zh_han_p037[] = {
  /* Number of CEs for each character. */
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+3700 */
  0xBDC1,   /* U+3701 */
  0x3A77,   /* U+3702 */
  0x60D2,   /* U+3703 */
  0xA167,   /* U+3704 */
  0x9FD8,   /* U+3705 */
  0x6B00,   /* U+3706 */
  0x4A42,   /* U+3707 */
  0x6DA6,   /* U+3708 */
  0xAB26,   /* U+3709 */
  0xB35B,   /* U+370A */
  0xA85A,   /* U+370B */
  0x716C,   /* U+370C */
  0x8CE3,   /* U+370D */
  0x9787,   /* U+370E */
  0xB038,   /* U+370F */
  0x875E,   /* U+3710 */
  0x3B9D,   /* U+3711 */
  0xA85B,   /* U+3712 */
  0x2FA8,   /* U+3713 */
  0xBDC1,   /* U+3714 */
  0x6064,   /* U+3715 */
  0x2587,   /* U+3716 */
  0x2503,   /* U+3717 */
  0x5586,   /* U+3718 */
  0x6597,   /* U+3719 */
  0x89DB,   /* U+371A */
  0x6F2C,   /* U+371B */
  0x1DB6,   /* U+371C */
  0x1D0C,   /* U+371D */
  0x7997,   /* U+371E */
  0xBDC1,   /* U+371F */
  0x2EB8,   /* U+3720 */
  0x2DE1,   /* U+3721 */
  0xBDC1,   /* U+3722 */
  0x7EA4,   /* U+3723 */
  0x6FF7,   /* U+3724 */
  0x67D7,   /* U+3725 */
  0x9DE2,   /* U+3726 */
  0xAFD2,   /* U+3727 */
  0x6E1E,   /* U+3728 */
  0x1DBF,   /* U+3729 */
  0x8472,   /* U+372A */
  0x67C8,   /* U+372B */
  0xBDC1,   /* U+372C */
  0xBDC1,   /* U+372D */
  0x5C94,   /* U+372E */
  0x97DB,   /* U+372F */
  0xAFDE,   /* U+3730 */
  0xB7F5,   /* U+3731 */
  0x9596,   /* U+3732 */
  0x4850,   /* U+3733 */
  0x6A65,   /* U+3734 */
  0x7039,   /* U+3735 */
  0x9319,   /* U+3736 */
  0x6AA6,   /* U+3737 */
  0x70AB,   /* U+3738 */
  0x7D61,   /* U+3739 */
  0xB13C,   /* U+373A */
  0x60F5,   /* U+373B */
  0xB6BF,   /* U+373C */
  0xBBCD,   /* U+373D */
  0x42DF,   /* U+373E */
  0x9F97,   /* U+373F */
  0x445D,   /* U+3740 */
  0xA020,   /* U+3741 */
  0xB737,   /* U+3742 */
  0x6B62,   /* U+3743 */
  0x2CF4,   /* U+3744 */
  0x3FAB,   /* U+3745 */
  0xBDC1,   /* U+3746 */
  0x2D01,   /* U+3747 */
  0x668C,   /* U+3748 */
  0xB9AB,   /* U+3749 */
  0x8684,   /* U+374A */
  0x6186,   /* U+374B */
  0x543E,   /* U+374C */
  0x9D01,   /* U+374D */
  0x3421,   /* U+374E */
  0x522F,   /* U+374F */
  0x7F8C,   /* U+3750 */
  0x6871,   /* U+3751 */
  0xBDC1,   /* U+3752 */
  0x589C,   /* U+3753 */
  0xA52B,   /* U+3754 */
  0x70DA,   /* U+3755 */
  0xA6B0,   /* U+3756 */
  0x5CA8,   /* U+3757 */
  0xAB59,   /* U+3758 */
  0xA985,   /* U+3759 */
  0xA29F,   /* U+375A */
  0x89B9,   /* U+375B */
  0xBDC1,   /* U+375C */
  0x622B,   /* U+375D */
  0xA1D4,   /* U+375E */
  0x68C6,   /* U+375F */
  0x6C55,   /* U+3760 */
  0xBD37,   /* U+3761 */
  0xAD8D,   /* U+3762 */
  0xA834,   /* U+3763 */
  0x3FAC,   /* U+3764 */
  0x6AD6,   /* U+3765 */
  0x573A,   /* U+3766 */
  0x9558,   /* U+3767 */
  0xBDC1,   /* U+3768 */
  0x57F4,   /* U+3769 */
  0x330D,   /* U+376A */
  0x6422,   /* U+376B */
  0xBDC1,   /* U+376C */
  0x9E62,   /* U+376D */
  0x2EF8,   /* U+376E */
  0x7A5B,   /* U+376F */
  0x6B48,   /* U+3770 */
  0x6A67,   /* U+3771 */
  0x7B5F,   /* U+3772 */
  0xBDC1,   /* U+3773 */
  0x92C5,   /* U+3774 */
  0x3183,   /* U+3775 */
  0x1C91,   /* U+3776 */
  0xBDC1,   /* U+3777 */
  0x220F,   /* U+3778 */
  0x715C,   /* U+3779 */
  0x6065,   /* U+377A */
  0x52AE,   /* U+377B */
  0xAC99,   /* U+377C */
  0x2CAF,   /* U+377D */
  0xBD94,   /* U+377E */
  0x243C,   /* U+377F */
  0x499D,   /* U+3780 */
  0xA557,   /* U+3781 */
  0x9153,   /* U+3782 */
  0x4D49,   /* U+3783 */
  0x1CD8,   /* U+3784 */
  0x6756,   /* U+3785 */
  0x4CF2,   /* U+3786 */
  0x9444,   /* U+3787 */
  0x2383,   /* U+3788 */
  0xB0AA,   /* U+3789 */
  0x9FD9,   /* U+378A */
  0x6FE7,   /* U+378B */
  0xB06B,   /* U+378C */
  0xBDC1,   /* U+378D */
  0x1E19,   /* U+378E */
  0xB46D,   /* U+378F */
  0x547F,   /* U+3790 */
  0x942E,   /* U+3791 */
  0x9D18,   /* U+3792 */
  0x7811,   /* U+3793 */
  0xA6B1,   /* U+3794 */
  0x9D19,   /* U+3795 */
  0x2D64,   /* U+3796 */
  0x7C79,   /* U+3797 */
  0x350B,   /* U+3798 */
  0x7045,   /* U+3799 */
  0x782C,   /* U+379A */
  0x4CF7,   /* U+379B */
  0x912B,   /* U+379C */
  0xBDC1,   /* U+379D */
  0x890E,   /* U+379E */
  0x330F,   /* U+379F */
  0x5D0A,   /* U+37A0 */
  0xB377,   /* U+37A1 */
  0xBDC1,   /* U+37A2 */
  0xBDC1,   /* U+37A3 */
  0xA971,   /* U+37A4 */
  0x25DE,   /* U+37A5 */
  0x4CE2,   /* U+37A6 */
  0x4A1A,   /* U+37A7 */
  0xBBCF,   /* U+37A8 */
  0x5C19,   /* U+37A9 */
  0x6EA7,   /* U+37AA */
  0x554E,   /* U+37AB */
  0x7B63,   /* U+37AC */
  0x2FE5,   /* U+37AD */
  0xBDC1,   /* U+37AE */
  0x5182,   /* U+37AF */
  0x9F73,   /* U+37B0 */
  0x2DCB,   /* U+37B1 */
  0xAB98,   /* U+37B2 */
  0x34C5,   /* U+37B3 */
  0x29D1,   /* U+37B4 */
  0xBDC1,   /* U+37B5 */
  0x6C22,   /* U+37B6 */
  0x4928,   /* U+37B7 */
  0x8A75,   /* U+37B8 */
  0x5883,   /* U+37B9 */
  0xBCB6,   /* U+37BA */
  0x445E,   /* U+37BB */
  0x292B,   /* U+37BC */
  0xA105,   /* U+37BD */
  0x6F3B,   /* U+37BE */
  0x2A48,   /* U+37BF */
  0x604D,   /* U+37C0 */
  0x1D17,   /* U+37C1 */
  0x6D70,   /* U+37C2 */
  0x884C,   /* U+37C3 */
  0x9B3E,   /* U+37C4 */
  0xA426,   /* U+37C5 */
  0x47F1,   /* U+37C6 */
  0x2F5A,   /* U+37C7 */
  0x7C7A,   /* U+37C8 */
  0x5CFD,   /* U+37C9 */
  0x3B69,   /* U+37CA */
  0x35F7,   /* U+37CB */
  0x6880,   /* U+37CC */
  0x5CA9,   /* U+37CD */
  0x921E,   /* U+37CE */
  0x434C,   /* U+37CF */
  0x689E,   /* U+37D0 */
  0x23B3,   /* U+37D1 */
  0x7E7D,   /* U+37D2 */
  0x7730,   /* U+37D3 */
  0x434D,   /* U+37D4 */
  0xBDC1,   /* U+37D5 */
  0x6486,   /* U+37D6 */
  0xBDC1,   /* U+37D7 */
  0x8F20,   /* U+37D8 */
  0xB1BD,   /* U+37D9 */
  0x773F,   /* U+37DA */
  0xB125,   /* U+37DB */
  0x6A7B,   /* U+37DC */
  0x7347,   /* U+37DD */
  0xB38C,   /* U+37DE */
  0x9B7B,   /* U+37DF */
  0x3DA0,   /* U+37E0 */
  0xBDC1,   /* U+37E1 */
  0x7740,   /* U+37E2 */
  0xBDC1,   /* U+37E3 */
  0x6576,   /* U+37E4 */
  0xBDC1,   /* U+37E5 */
  0xB079,   /* U+37E6 */
  0x3768,   /* U+37E7 */
  0x35A2,   /* U+37E8 */
  0x6C02,   /* U+37E9 */
  0x93A6,   /* U+37EA */
  0x7DDB,   /* U+37EB */
  0x8976,   /* U+37EC */
  0x6C03,   /* U+37ED */
  0x9090,   /* U+37EE */
  0xBDC1,   /* U+37EF */
  0x6C76,   /* U+37F0 */
  0xA53A,   /* U+37F1 */
  0x5686,   /* U+37F2 */
  0x5F74,   /* U+37F3 */
  0x59E8,   /* U+37F4 */
  0x3DA3,   /* U+37F5 */
  0xAF22,   /* U+37F6 */
  0x2FD0,   /* U+37F7 */
  0xBDC1,   /* U+37F8 */
  0x5D07,   /* U+37F9 */
  0x64A5,   /* U+37FA */
  0x7998,   /* U+37FB */
  0x1D75,   /* U+37FC */
  0x2284,   /* U+37FD */
  0xAB2D,   /* U+37FE */
  0x68A6,   /* U+37FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3700 */
  0x0020,   /* U+3701 */
  0x0020,   /* U+3702 */
  0x0020,   /* U+3703 */
  0x0020,   /* U+3704 */
  0x0020,   /* U+3705 */
  0x0020,   /* U+3706 */
  0x0020,   /* U+3707 */
  0x0020,   /* U+3708 */
  0x0020,   /* U+3709 */
  0x0020,   /* U+370A */
  0x0020,   /* U+370B */
  0x0020,   /* U+370C */
  0x0020,   /* U+370D */
  0x0020,   /* U+370E */
  0x0020,   /* U+370F */
  0x0020,   /* U+3710 */
  0x0020,   /* U+3711 */
  0x0020,   /* U+3712 */
  0x0020,   /* U+3713 */
  0x0020,   /* U+3714 */
  0x0020,   /* U+3715 */
  0x0020,   /* U+3716 */
  0x0020,   /* U+3717 */
  0x0020,   /* U+3718 */
  0x0020,   /* U+3719 */
  0x0020,   /* U+371A */
  0x0020,   /* U+371B */
  0x0020,   /* U+371C */
  0x0020,   /* U+371D */
  0x0020,   /* U+371E */
  0x0020,   /* U+371F */
  0x0020,   /* U+3720 */
  0x0020,   /* U+3721 */
  0x0020,   /* U+3722 */
  0x0020,   /* U+3723 */
  0x0020,   /* U+3724 */
  0x0020,   /* U+3725 */
  0x0020,   /* U+3726 */
  0x0020,   /* U+3727 */
  0x0020,   /* U+3728 */
  0x0020,   /* U+3729 */
  0x0020,   /* U+372A */
  0x0020,   /* U+372B */
  0x0020,   /* U+372C */
  0x0020,   /* U+372D */
  0x0020,   /* U+372E */
  0x0020,   /* U+372F */
  0x0020,   /* U+3730 */
  0x0020,   /* U+3731 */
  0x0020,   /* U+3732 */
  0x0020,   /* U+3733 */
  0x0020,   /* U+3734 */
  0x0020,   /* U+3735 */
  0x0020,   /* U+3736 */
  0x0020,   /* U+3737 */
  0x0020,   /* U+3738 */
  0x0020,   /* U+3739 */
  0x0020,   /* U+373A */
  0x0020,   /* U+373B */
  0x0020,   /* U+373C */
  0x0020,   /* U+373D */
  0x0020,   /* U+373E */
  0x0020,   /* U+373F */
  0x0020,   /* U+3740 */
  0x0020,   /* U+3741 */
  0x0020,   /* U+3742 */
  0x0020,   /* U+3743 */
  0x0020,   /* U+3744 */
  0x0020,   /* U+3745 */
  0x0020,   /* U+3746 */
  0x0020,   /* U+3747 */
  0x0020,   /* U+3748 */
  0x0020,   /* U+3749 */
  0x0020,   /* U+374A */
  0x0020,   /* U+374B */
  0x0020,   /* U+374C */
  0x0020,   /* U+374D */
  0x0020,   /* U+374E */
  0x0020,   /* U+374F */
  0x0020,   /* U+3750 */
  0x0020,   /* U+3751 */
  0x0020,   /* U+3752 */
  0x0020,   /* U+3753 */
  0x0020,   /* U+3754 */
  0x0020,   /* U+3755 */
  0x0020,   /* U+3756 */
  0x0020,   /* U+3757 */
  0x0020,   /* U+3758 */
  0x0020,   /* U+3759 */
  0x0020,   /* U+375A */
  0x0020,   /* U+375B */
  0x0020,   /* U+375C */
  0x0020,   /* U+375D */
  0x0020,   /* U+375E */
  0x0020,   /* U+375F */
  0x0020,   /* U+3760 */
  0x0020,   /* U+3761 */
  0x0020,   /* U+3762 */
  0x0020,   /* U+3763 */
  0x0020,   /* U+3764 */
  0x0020,   /* U+3765 */
  0x0020,   /* U+3766 */
  0x0020,   /* U+3767 */
  0x0020,   /* U+3768 */
  0x0020,   /* U+3769 */
  0x0020,   /* U+376A */
  0x0020,   /* U+376B */
  0x0020,   /* U+376C */
  0x0020,   /* U+376D */
  0x0020,   /* U+376E */
  0x0020,   /* U+376F */
  0x0020,   /* U+3770 */
  0x0020,   /* U+3771 */
  0x0020,   /* U+3772 */
  0x0020,   /* U+3773 */
  0x0020,   /* U+3774 */
  0x0020,   /* U+3775 */
  0x0020,   /* U+3776 */
  0x0020,   /* U+3777 */
  0x0020,   /* U+3778 */
  0x0020,   /* U+3779 */
  0x0020,   /* U+377A */
  0x0020,   /* U+377B */
  0x0020,   /* U+377C */
  0x0020,   /* U+377D */
  0x0020,   /* U+377E */
  0x0020,   /* U+377F */
  0x0020,   /* U+3780 */
  0x0020,   /* U+3781 */
  0x0020,   /* U+3782 */
  0x0020,   /* U+3783 */
  0x0020,   /* U+3784 */
  0x0020,   /* U+3785 */
  0x0020,   /* U+3786 */
  0x0020,   /* U+3787 */
  0x0020,   /* U+3788 */
  0x0020,   /* U+3789 */
  0x0020,   /* U+378A */
  0x0020,   /* U+378B */
  0x0020,   /* U+378C */
  0x0020,   /* U+378D */
  0x0020,   /* U+378E */
  0x0020,   /* U+378F */
  0x0020,   /* U+3790 */
  0x0020,   /* U+3791 */
  0x0020,   /* U+3792 */
  0x0020,   /* U+3793 */
  0x0020,   /* U+3794 */
  0x0020,   /* U+3795 */
  0x0020,   /* U+3796 */
  0x0020,   /* U+3797 */
  0x0020,   /* U+3798 */
  0x0020,   /* U+3799 */
  0x0020,   /* U+379A */
  0x0020,   /* U+379B */
  0x0020,   /* U+379C */
  0x0020,   /* U+379D */
  0x0020,   /* U+379E */
  0x0020,   /* U+379F */
  0x0020,   /* U+37A0 */
  0x0020,   /* U+37A1 */
  0x0020,   /* U+37A2 */
  0x0020,   /* U+37A3 */
  0x0020,   /* U+37A4 */
  0x0020,   /* U+37A5 */
  0x0020,   /* U+37A6 */
  0x0020,   /* U+37A7 */
  0x0020,   /* U+37A8 */
  0x0020,   /* U+37A9 */
  0x0020,   /* U+37AA */
  0x0020,   /* U+37AB */
  0x0020,   /* U+37AC */
  0x0020,   /* U+37AD */
  0x0020,   /* U+37AE */
  0x0020,   /* U+37AF */
  0x0020,   /* U+37B0 */
  0x0020,   /* U+37B1 */
  0x0020,   /* U+37B2 */
  0x0020,   /* U+37B3 */
  0x0020,   /* U+37B4 */
  0x0020,   /* U+37B5 */
  0x0020,   /* U+37B6 */
  0x0020,   /* U+37B7 */
  0x0020,   /* U+37B8 */
  0x0020,   /* U+37B9 */
  0x0020,   /* U+37BA */
  0x0020,   /* U+37BB */
  0x0020,   /* U+37BC */
  0x0020,   /* U+37BD */
  0x0020,   /* U+37BE */
  0x0020,   /* U+37BF */
  0x0020,   /* U+37C0 */
  0x0020,   /* U+37C1 */
  0x0020,   /* U+37C2 */
  0x0020,   /* U+37C3 */
  0x0020,   /* U+37C4 */
  0x0020,   /* U+37C5 */
  0x0020,   /* U+37C6 */
  0x0020,   /* U+37C7 */
  0x0020,   /* U+37C8 */
  0x0020,   /* U+37C9 */
  0x0020,   /* U+37CA */
  0x0020,   /* U+37CB */
  0x0020,   /* U+37CC */
  0x0020,   /* U+37CD */
  0x0020,   /* U+37CE */
  0x0020,   /* U+37CF */
  0x0020,   /* U+37D0 */
  0x0020,   /* U+37D1 */
  0x0020,   /* U+37D2 */
  0x0020,   /* U+37D3 */
  0x0020,   /* U+37D4 */
  0x0020,   /* U+37D5 */
  0x0020,   /* U+37D6 */
  0x0020,   /* U+37D7 */
  0x0020,   /* U+37D8 */
  0x0020,   /* U+37D9 */
  0x0020,   /* U+37DA */
  0x0020,   /* U+37DB */
  0x0020,   /* U+37DC */
  0x0020,   /* U+37DD */
  0x0020,   /* U+37DE */
  0x0020,   /* U+37DF */
  0x0020,   /* U+37E0 */
  0x0020,   /* U+37E1 */
  0x0020,   /* U+37E2 */
  0x0020,   /* U+37E3 */
  0x0020,   /* U+37E4 */
  0x0020,   /* U+37E5 */
  0x0020,   /* U+37E6 */
  0x0020,   /* U+37E7 */
  0x0020,   /* U+37E8 */
  0x0020,   /* U+37E9 */
  0x0020,   /* U+37EA */
  0x0020,   /* U+37EB */
  0x0020,   /* U+37EC */
  0x0020,   /* U+37ED */
  0x0020,   /* U+37EE */
  0x0020,   /* U+37EF */
  0x0020,   /* U+37F0 */
  0x0020,   /* U+37F1 */
  0x0020,   /* U+37F2 */
  0x0020,   /* U+37F3 */
  0x0020,   /* U+37F4 */
  0x0020,   /* U+37F5 */
  0x0020,   /* U+37F6 */
  0x0020,   /* U+37F7 */
  0x0020,   /* U+37F8 */
  0x0020,   /* U+37F9 */
  0x0020,   /* U+37FA */
  0x0020,   /* U+37FB */
  0x0020,   /* U+37FC */
  0x0020,   /* U+37FD */
  0x0020,   /* U+37FE */
  0x0020,   /* U+37FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3700 */
  0x0002,   /* U+3701 */
  0x0002,   /* U+3702 */
  0x0002,   /* U+3703 */
  0x0002,   /* U+3704 */
  0x0002,   /* U+3705 */
  0x0002,   /* U+3706 */
  0x0002,   /* U+3707 */
  0x0002,   /* U+3708 */
  0x0002,   /* U+3709 */
  0x0002,   /* U+370A */
  0x0002,   /* U+370B */
  0x0002,   /* U+370C */
  0x0002,   /* U+370D */
  0x0002,   /* U+370E */
  0x0002,   /* U+370F */
  0x0002,   /* U+3710 */
  0x0002,   /* U+3711 */
  0x0002,   /* U+3712 */
  0x0002,   /* U+3713 */
  0x0002,   /* U+3714 */
  0x0002,   /* U+3715 */
  0x0002,   /* U+3716 */
  0x0002,   /* U+3717 */
  0x0002,   /* U+3718 */
  0x0002,   /* U+3719 */
  0x0002,   /* U+371A */
  0x0002,   /* U+371B */
  0x0002,   /* U+371C */
  0x0002,   /* U+371D */
  0x0002,   /* U+371E */
  0x0002,   /* U+371F */
  0x0002,   /* U+3720 */
  0x0002,   /* U+3721 */
  0x0002,   /* U+3722 */
  0x0002,   /* U+3723 */
  0x0002,   /* U+3724 */
  0x0002,   /* U+3725 */
  0x0002,   /* U+3726 */
  0x0002,   /* U+3727 */
  0x0002,   /* U+3728 */
  0x0002,   /* U+3729 */
  0x0002,   /* U+372A */
  0x0002,   /* U+372B */
  0x0002,   /* U+372C */
  0x0002,   /* U+372D */
  0x0002,   /* U+372E */
  0x0002,   /* U+372F */
  0x0002,   /* U+3730 */
  0x0002,   /* U+3731 */
  0x0002,   /* U+3732 */
  0x0002,   /* U+3733 */
  0x0002,   /* U+3734 */
  0x0002,   /* U+3735 */
  0x0002,   /* U+3736 */
  0x0002,   /* U+3737 */
  0x0002,   /* U+3738 */
  0x0002,   /* U+3739 */
  0x0002,   /* U+373A */
  0x0002,   /* U+373B */
  0x0002,   /* U+373C */
  0x0002,   /* U+373D */
  0x0002,   /* U+373E */
  0x0002,   /* U+373F */
  0x0002,   /* U+3740 */
  0x0002,   /* U+3741 */
  0x0002,   /* U+3742 */
  0x0002,   /* U+3743 */
  0x0002,   /* U+3744 */
  0x0002,   /* U+3745 */
  0x0002,   /* U+3746 */
  0x0002,   /* U+3747 */
  0x0002,   /* U+3748 */
  0x0002,   /* U+3749 */
  0x0002,   /* U+374A */
  0x0002,   /* U+374B */
  0x0002,   /* U+374C */
  0x0002,   /* U+374D */
  0x0002,   /* U+374E */
  0x0002,   /* U+374F */
  0x0002,   /* U+3750 */
  0x0002,   /* U+3751 */
  0x0002,   /* U+3752 */
  0x0002,   /* U+3753 */
  0x0002,   /* U+3754 */
  0x0002,   /* U+3755 */
  0x0002,   /* U+3756 */
  0x0002,   /* U+3757 */
  0x0002,   /* U+3758 */
  0x0002,   /* U+3759 */
  0x0002,   /* U+375A */
  0x0002,   /* U+375B */
  0x0002,   /* U+375C */
  0x0002,   /* U+375D */
  0x0002,   /* U+375E */
  0x0002,   /* U+375F */
  0x0002,   /* U+3760 */
  0x0002,   /* U+3761 */
  0x0002,   /* U+3762 */
  0x0002,   /* U+3763 */
  0x0002,   /* U+3764 */
  0x0002,   /* U+3765 */
  0x0002,   /* U+3766 */
  0x0002,   /* U+3767 */
  0x0002,   /* U+3768 */
  0x0002,   /* U+3769 */
  0x0002,   /* U+376A */
  0x0002,   /* U+376B */
  0x0002,   /* U+376C */
  0x0002,   /* U+376D */
  0x0002,   /* U+376E */
  0x0002,   /* U+376F */
  0x0002,   /* U+3770 */
  0x0002,   /* U+3771 */
  0x0002,   /* U+3772 */
  0x0002,   /* U+3773 */
  0x0002,   /* U+3774 */
  0x0002,   /* U+3775 */
  0x0002,   /* U+3776 */
  0x0002,   /* U+3777 */
  0x0002,   /* U+3778 */
  0x0002,   /* U+3779 */
  0x0002,   /* U+377A */
  0x0002,   /* U+377B */
  0x0002,   /* U+377C */
  0x0002,   /* U+377D */
  0x0002,   /* U+377E */
  0x0002,   /* U+377F */
  0x0002,   /* U+3780 */
  0x0002,   /* U+3781 */
  0x0002,   /* U+3782 */
  0x0002,   /* U+3783 */
  0x0002,   /* U+3784 */
  0x0002,   /* U+3785 */
  0x0002,   /* U+3786 */
  0x0002,   /* U+3787 */
  0x0002,   /* U+3788 */
  0x0002,   /* U+3789 */
  0x0002,   /* U+378A */
  0x0002,   /* U+378B */
  0x0002,   /* U+378C */
  0x0002,   /* U+378D */
  0x0002,   /* U+378E */
  0x0002,   /* U+378F */
  0x0002,   /* U+3790 */
  0x0002,   /* U+3791 */
  0x0002,   /* U+3792 */
  0x0002,   /* U+3793 */
  0x0002,   /* U+3794 */
  0x0002,   /* U+3795 */
  0x0002,   /* U+3796 */
  0x0002,   /* U+3797 */
  0x0002,   /* U+3798 */
  0x0002,   /* U+3799 */
  0x0002,   /* U+379A */
  0x0002,   /* U+379B */
  0x0002,   /* U+379C */
  0x0002,   /* U+379D */
  0x0002,   /* U+379E */
  0x0002,   /* U+379F */
  0x0002,   /* U+37A0 */
  0x0002,   /* U+37A1 */
  0x0002,   /* U+37A2 */
  0x0002,   /* U+37A3 */
  0x0002,   /* U+37A4 */
  0x0002,   /* U+37A5 */
  0x0002,   /* U+37A6 */
  0x0002,   /* U+37A7 */
  0x0002,   /* U+37A8 */
  0x0002,   /* U+37A9 */
  0x0002,   /* U+37AA */
  0x0002,   /* U+37AB */
  0x0002,   /* U+37AC */
  0x0002,   /* U+37AD */
  0x0002,   /* U+37AE */
  0x0002,   /* U+37AF */
  0x0002,   /* U+37B0 */
  0x0002,   /* U+37B1 */
  0x0002,   /* U+37B2 */
  0x0002,   /* U+37B3 */
  0x0002,   /* U+37B4 */
  0x0002,   /* U+37B5 */
  0x0002,   /* U+37B6 */
  0x0002,   /* U+37B7 */
  0x0002,   /* U+37B8 */
  0x0002,   /* U+37B9 */
  0x0002,   /* U+37BA */
  0x0002,   /* U+37BB */
  0x0002,   /* U+37BC */
  0x0002,   /* U+37BD */
  0x0002,   /* U+37BE */
  0x0002,   /* U+37BF */
  0x0002,   /* U+37C0 */
  0x0002,   /* U+37C1 */
  0x0002,   /* U+37C2 */
  0x0002,   /* U+37C3 */
  0x0002,   /* U+37C4 */
  0x0002,   /* U+37C5 */
  0x0002,   /* U+37C6 */
  0x0002,   /* U+37C7 */
  0x0002,   /* U+37C8 */
  0x0002,   /* U+37C9 */
  0x0002,   /* U+37CA */
  0x0002,   /* U+37CB */
  0x0002,   /* U+37CC */
  0x0002,   /* U+37CD */
  0x0002,   /* U+37CE */
  0x0002,   /* U+37CF */
  0x0002,   /* U+37D0 */
  0x0002,   /* U+37D1 */
  0x0002,   /* U+37D2 */
  0x0002,   /* U+37D3 */
  0x0002,   /* U+37D4 */
  0x0002,   /* U+37D5 */
  0x0002,   /* U+37D6 */
  0x0002,   /* U+37D7 */
  0x0002,   /* U+37D8 */
  0x0002,   /* U+37D9 */
  0x0002,   /* U+37DA */
  0x0002,   /* U+37DB */
  0x0002,   /* U+37DC */
  0x0002,   /* U+37DD */
  0x0002,   /* U+37DE */
  0x0002,   /* U+37DF */
  0x0002,   /* U+37E0 */
  0x0002,   /* U+37E1 */
  0x0002,   /* U+37E2 */
  0x0002,   /* U+37E3 */
  0x0002,   /* U+37E4 */
  0x0002,   /* U+37E5 */
  0x0002,   /* U+37E6 */
  0x0002,   /* U+37E7 */
  0x0002,   /* U+37E8 */
  0x0002,   /* U+37E9 */
  0x0002,   /* U+37EA */
  0x0002,   /* U+37EB */
  0x0002,   /* U+37EC */
  0x0002,   /* U+37ED */
  0x0002,   /* U+37EE */
  0x0002,   /* U+37EF */
  0x0002,   /* U+37F0 */
  0x0002,   /* U+37F1 */
  0x0002,   /* U+37F2 */
  0x0002,   /* U+37F3 */
  0x0002,   /* U+37F4 */
  0x0002,   /* U+37F5 */
  0x0002,   /* U+37F6 */
  0x0002,   /* U+37F7 */
  0x0002,   /* U+37F8 */
  0x0002,   /* U+37F9 */
  0x0002,   /* U+37FA */
  0x0002,   /* U+37FB */
  0x0002,   /* U+37FC */
  0x0002,   /* U+37FD */
  0x0002,   /* U+37FE */
  0x0002,   /* U+37FF */

  /* Primary weight 2 for each character. */
  0xB700,   /* U+3700 */
  0xB701,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0xB714,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0xB71F,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0xB722,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0xB72C,   /* U+372C */
  0xB72D,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0xB746,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0xB752,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0xB75C,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0xB768,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0xB76C,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0xB773,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0xB777,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0xB78D,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0xB79D,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0xB7A2,   /* U+37A2 */
  0xB7A3,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0xB7AE,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0xB7B5,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0xB7D5,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0xB7D7,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0xB7E1,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0xB7E3,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0xB7E5,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0xB7EF,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0xB7F8,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */
};

uint16_t zh_han_p038[] = {
  /* Number of CEs for each character. */
  1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 
  2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 
  2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 1, 
  1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x3147,   /* U+3800 */
  0xBDC1,   /* U+3801 */
  0x1D76,   /* U+3802 */
  0xBDC1,   /* U+3803 */
  0x9835,   /* U+3804 */
  0x3BBD,   /* U+3805 */
  0x3051,   /* U+3806 */
  0x5461,   /* U+3807 */
  0x80E4,   /* U+3808 */
  0x901E,   /* U+3809 */
  0x7CFD,   /* U+380A */
  0x3791,   /* U+380B */
  0x76EF,   /* U+380C */
  0x4C98,   /* U+380D */
  0x4C99,   /* U+380E */
  0x4801,   /* U+380F */
  0x512E,   /* U+3810 */
  0xBD48,   /* U+3811 */
  0x2286,   /* U+3812 */
  0x69FD,   /* U+3813 */
  0x1E74,   /* U+3814 */
  0x9471,   /* U+3815 */
  0xA772,   /* U+3816 */
  0x1DC0,   /* U+3817 */
  0xADB1,   /* U+3818 */
  0x4449,   /* U+3819 */
  0x3607,   /* U+381A */
  0x95F2,   /* U+381B */
  0x6FC8,   /* U+381C */
  0x2E9D,   /* U+381D */
  0xBDC1,   /* U+381E */
  0x5E91,   /* U+381F */
  0x650F,   /* U+3820 */
  0x703A,   /* U+3821 */
  0x4851,   /* U+3822 */
  0x5FD7,   /* U+3823 */
  0xBDC1,   /* U+3824 */
  0x6666,   /* U+3825 */
  0x3A93,   /* U+3826 */
  0x6ADF,   /* U+3827 */
  0xAEB3,   /* U+3828 */
  0xBDC1,   /* U+3829 */
  0x5549,   /* U+382A */
  0xBDC1,   /* U+382B */
  0xBDC1,   /* U+382C */
  0xB358,   /* U+382D */
  0x739E,   /* U+382E */
  0xA744,   /* U+382F */
  0xBDC1,   /* U+3830 */
  0x4D4A,   /* U+3831 */
  0x209F,   /* U+3832 */
  0xBDC1,   /* U+3833 */
  0x7F40,   /* U+3834 */
  0x490D,   /* U+3835 */
  0x3890,   /* U+3836 */
  0x3E36,   /* U+3837 */
  0x5994,   /* U+3838 */
  0x5232,   /* U+3839 */
  0x8245,   /* U+383A */
  0xBDC1,   /* U+383B */
  0x8848,   /* U+383C */
  0x8FEC,   /* U+383D */
  0xAEC5,   /* U+383E */
  0xBB60,   /* U+383F */
  0x20DE,   /* U+3840 */
  0x59C1,   /* U+3841 */
  0x5F2B,   /* U+3842 */
  0x4915,   /* U+3843 */
  0xA155,   /* U+3844 */
  0x71CA,   /* U+3845 */
  0xBDC1,   /* U+3846 */
  0xB47C,   /* U+3847 */
  0x9567,   /* U+3848 */
  0x9A08,   /* U+3849 */
  0x7890,   /* U+384A */
  0xA59E,   /* U+384B */
  0x690F,   /* U+384C */
  0xBDC1,   /* U+384D */
  0xBDC1,   /* U+384E */
  0x8757,   /* U+384F */
  0xBDC1,   /* U+3850 */
  0x7A21,   /* U+3851 */
  0xBAC7,   /* U+3852 */
  0x5B07,   /* U+3853 */
  0x96DC,   /* U+3854 */
  0xAA41,   /* U+3855 */
  0x2C89,   /* U+3856 */
  0x8E01,   /* U+3857 */
  0x605C,   /* U+3858 */
  0x2082,   /* U+3859 */
  0x3F79,   /* U+385A */
  0x688E,   /* U+385B */
  0x9D4A,   /* U+385C */
  0x3ACB,   /* U+385D */
  0x64A6,   /* U+385E */
  0xB16C,   /* U+385F */
  0xB610,   /* U+3860 */
  0x2BA2,   /* U+3861 */
  0x685A,   /* U+3862 */
  0x642C,   /* U+3863 */
  0xBDC1,   /* U+3864 */
  0xAA26,   /* U+3865 */
  0x7555,   /* U+3866 */
  0xB619,   /* U+3867 */
  0x4EE9,   /* U+3868 */
  0x6681,   /* U+3869 */
  0x704D,   /* U+386A */
  0xA838,   /* U+386B */
  0xBDC1,   /* U+386C */
  0x4D71,   /* U+386D */
  0x4CAA,   /* U+386E */
  0xB2F0,   /* U+386F */
  0xAD6E,   /* U+3870 */
  0x5429,   /* U+3871 */
  0x4881,   /* U+3872 */
  0xB6CE,   /* U+3873 */
  0x5B73,   /* U+3874 */
  0x62AB,   /* U+3875 */
  0xB6D5,   /* U+3876 */
  0x2011,   /* U+3877 */
  0xB2B8,   /* U+3878 */
  0x5480,   /* U+3879 */
  0x3088,   /* U+387A */
  0x619F,   /* U+387B */
  0xA7E0,   /* U+387C */
  0xB433,   /* U+387D */
  0x9AAD,   /* U+387E */
  0x2A4E,   /* U+387F */
  0x2DAB,   /* U+3880 */
  0x2A15,   /* U+3881 */
  0xA30C,   /* U+3882 */
  0x5CAA,   /* U+3883 */
  0x34D9,   /* U+3884 */
  0x6487,   /* U+3885 */
  0x26C2,   /* U+3886 */
  0xBDC1,   /* U+3887 */
  0x9131,   /* U+3888 */
  0x2638,   /* U+3889 */
  0x1C79,   /* U+388A */
  0x2A20,   /* U+388B */
  0xBDC1,   /* U+388C */
  0xAAE0,   /* U+388D */
  0xB48D,   /* U+388E */
  0x9058,   /* U+388F */
  0xBDC1,   /* U+3890 */
  0x9135,   /* U+3891 */
  0x2645,   /* U+3892 */
  0xA53F,   /* U+3893 */
  0xBC5F,   /* U+3894 */
  0xBDC1,   /* U+3895 */
  0x727F,   /* U+3896 */
  0x7A91,   /* U+3897 */
  0x606E,   /* U+3898 */
  0x7B33,   /* U+3899 */
  0x6546,   /* U+389A */
  0xA3BD,   /* U+389B */
  0x581E,   /* U+389C */
  0x8997,   /* U+389D */
  0xA901,   /* U+389E */
  0x26A6,   /* U+389F */
  0x53D0,   /* U+38A0 */
  0x5028,   /* U+38A1 */
  0xBDC1,   /* U+38A2 */
  0x53AC,   /* U+38A3 */
  0xBDC1,   /* U+38A4 */
  0x3488,   /* U+38A5 */
  0xBDC1,   /* U+38A6 */
  0x55F0,   /* U+38A7 */
  0x4395,   /* U+38A8 */
  0x325E,   /* U+38A9 */
  0xBDC1,   /* U+38AA */
  0xBDC1,   /* U+38AB */
  0x45CE,   /* U+38AC */
  0xBDC1,   /* U+38AD */
  0x29D6,   /* U+38AE */
  0x332D,   /* U+38AF */
  0x20E0,   /* U+38B0 */
  0xBDC1,   /* U+38B1 */
  0xA199,   /* U+38B2 */
  0x64F6,   /* U+38B3 */
  0xBDC1,   /* U+38B4 */
  0x9C9F,   /* U+38B5 */
  0x20EB,   /* U+38B6 */
  0xBDC1,   /* U+38B7 */
  0x20F7,   /* U+38B8 */
  0xBDC1,   /* U+38B9 */
  0x9A09,   /* U+38BA */
  0x80C7,   /* U+38BB */
  0x22D2,   /* U+38BC */
  0x381A,   /* U+38BD */
  0x5606,   /* U+38BE */
  0xBDC1,   /* U+38BF */
  0xB584,   /* U+38C0 */
  0x1FDD,   /* U+38C1 */
  0x377B,   /* U+38C2 */
  0xAD9F,   /* U+38C3 */
  0x7D3E,   /* U+38C4 */
  0xB12A,   /* U+38C5 */
  0x6AAC,   /* U+38C6 */
  0xA7C5,   /* U+38C7 */
  0x88DD,   /* U+38C8 */
  0xBDC1,   /* U+38C9 */
  0xBDC1,   /* U+38CA */
  0xBDC1,   /* U+38CB */
  0x831F,   /* U+38CC */
  0x8BED,   /* U+38CD */
  0x6D9E,   /* U+38CE */
  0x5399,   /* U+38CF */
  0x2214,   /* U+38D0 */
  0x7FAB,   /* U+38D1 */
  0x2602,   /* U+38D2 */
  0x254E,   /* U+38D3 */
  0x33FC,   /* U+38D4 */
  0xBDC1,   /* U+38D5 */
  0xBDC1,   /* U+38D6 */
  0xBDC1,   /* U+38D7 */
  0xBDC1,   /* U+38D8 */
  0x3201,   /* U+38D9 */
  0x9037,   /* U+38DA */
  0x8B7D,   /* U+38DB */
  0x9E46,   /* U+38DC */
  0x88ED,   /* U+38DD */
  0x3676,   /* U+38DE */
  0x989E,   /* U+38DF */
  0x8D3C,   /* U+38E0 */
  0xBDC1,   /* U+38E1 */
  0x8DED,   /* U+38E2 */
  0x8324,   /* U+38E3 */
  0x4F8E,   /* U+38E4 */
  0xB74D,   /* U+38E5 */
  0x939D,   /* U+38E6 */
  0xAA06,   /* U+38E7 */
  0xBDC1,   /* U+38E8 */
  0xBDC1,   /* U+38E9 */
  0x48C1,   /* U+38EA */
  0xB858,   /* U+38EB */
  0x782D,   /* U+38EC */
  0xBC24,   /* U+38ED */
  0xBDC1,   /* U+38EE */
  0x9D43,   /* U+38EF */
  0x9D4B,   /* U+38F0 */
  0xB1CF,   /* U+38F1 */
  0x93F5,   /* U+38F2 */
  0xBDC1,   /* U+38F3 */
  0xBDC1,   /* U+38F4 */
  0x8BAF,   /* U+38F5 */
  0xB32E,   /* U+38F6 */
  0x710A,   /* U+38F7 */
  0xBDC1,   /* U+38F8 */
  0xBDC1,   /* U+38F9 */
  0xBDC1,   /* U+38FA */
  0xA79F,   /* U+38FB */
  0x7F26,   /* U+38FC */
  0x8739,   /* U+38FD */
  0x2660,   /* U+38FE */
  0xBAEE,   /* U+38FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3800 */
  0x0020,   /* U+3801 */
  0x0020,   /* U+3802 */
  0x0020,   /* U+3803 */
  0x0020,   /* U+3804 */
  0x0020,   /* U+3805 */
  0x0020,   /* U+3806 */
  0x0020,   /* U+3807 */
  0x0020,   /* U+3808 */
  0x0020,   /* U+3809 */
  0x0020,   /* U+380A */
  0x0020,   /* U+380B */
  0x0020,   /* U+380C */
  0x0020,   /* U+380D */
  0x0020,   /* U+380E */
  0x0020,   /* U+380F */
  0x0020,   /* U+3810 */
  0x0020,   /* U+3811 */
  0x0020,   /* U+3812 */
  0x0020,   /* U+3813 */
  0x0020,   /* U+3814 */
  0x0020,   /* U+3815 */
  0x0020,   /* U+3816 */
  0x0020,   /* U+3817 */
  0x0020,   /* U+3818 */
  0x0020,   /* U+3819 */
  0x0020,   /* U+381A */
  0x0020,   /* U+381B */
  0x0020,   /* U+381C */
  0x0020,   /* U+381D */
  0x0020,   /* U+381E */
  0x0020,   /* U+381F */
  0x0020,   /* U+3820 */
  0x0020,   /* U+3821 */
  0x0020,   /* U+3822 */
  0x0020,   /* U+3823 */
  0x0020,   /* U+3824 */
  0x0020,   /* U+3825 */
  0x0020,   /* U+3826 */
  0x0020,   /* U+3827 */
  0x0020,   /* U+3828 */
  0x0020,   /* U+3829 */
  0x0020,   /* U+382A */
  0x0020,   /* U+382B */
  0x0020,   /* U+382C */
  0x0020,   /* U+382D */
  0x0020,   /* U+382E */
  0x0020,   /* U+382F */
  0x0020,   /* U+3830 */
  0x0020,   /* U+3831 */
  0x0020,   /* U+3832 */
  0x0020,   /* U+3833 */
  0x0020,   /* U+3834 */
  0x0020,   /* U+3835 */
  0x0020,   /* U+3836 */
  0x0020,   /* U+3837 */
  0x0020,   /* U+3838 */
  0x0020,   /* U+3839 */
  0x0020,   /* U+383A */
  0x0020,   /* U+383B */
  0x0020,   /* U+383C */
  0x0020,   /* U+383D */
  0x0020,   /* U+383E */
  0x0020,   /* U+383F */
  0x0020,   /* U+3840 */
  0x0020,   /* U+3841 */
  0x0020,   /* U+3842 */
  0x0020,   /* U+3843 */
  0x0020,   /* U+3844 */
  0x0020,   /* U+3845 */
  0x0020,   /* U+3846 */
  0x0020,   /* U+3847 */
  0x0020,   /* U+3848 */
  0x0020,   /* U+3849 */
  0x0020,   /* U+384A */
  0x0020,   /* U+384B */
  0x0020,   /* U+384C */
  0x0020,   /* U+384D */
  0x0020,   /* U+384E */
  0x0020,   /* U+384F */
  0x0020,   /* U+3850 */
  0x0020,   /* U+3851 */
  0x0020,   /* U+3852 */
  0x0020,   /* U+3853 */
  0x0020,   /* U+3854 */
  0x0020,   /* U+3855 */
  0x0020,   /* U+3856 */
  0x0020,   /* U+3857 */
  0x0020,   /* U+3858 */
  0x0020,   /* U+3859 */
  0x0020,   /* U+385A */
  0x0020,   /* U+385B */
  0x0020,   /* U+385C */
  0x0020,   /* U+385D */
  0x0020,   /* U+385E */
  0x0020,   /* U+385F */
  0x0020,   /* U+3860 */
  0x0020,   /* U+3861 */
  0x0020,   /* U+3862 */
  0x0020,   /* U+3863 */
  0x0020,   /* U+3864 */
  0x0020,   /* U+3865 */
  0x0020,   /* U+3866 */
  0x0020,   /* U+3867 */
  0x0020,   /* U+3868 */
  0x0020,   /* U+3869 */
  0x0020,   /* U+386A */
  0x0020,   /* U+386B */
  0x0020,   /* U+386C */
  0x0020,   /* U+386D */
  0x0020,   /* U+386E */
  0x0020,   /* U+386F */
  0x0020,   /* U+3870 */
  0x0020,   /* U+3871 */
  0x0020,   /* U+3872 */
  0x0020,   /* U+3873 */
  0x0020,   /* U+3874 */
  0x0020,   /* U+3875 */
  0x0020,   /* U+3876 */
  0x0020,   /* U+3877 */
  0x0020,   /* U+3878 */
  0x0020,   /* U+3879 */
  0x0020,   /* U+387A */
  0x0020,   /* U+387B */
  0x0020,   /* U+387C */
  0x0020,   /* U+387D */
  0x0020,   /* U+387E */
  0x0020,   /* U+387F */
  0x0020,   /* U+3880 */
  0x0020,   /* U+3881 */
  0x0020,   /* U+3882 */
  0x0020,   /* U+3883 */
  0x0020,   /* U+3884 */
  0x0020,   /* U+3885 */
  0x0020,   /* U+3886 */
  0x0020,   /* U+3887 */
  0x0020,   /* U+3888 */
  0x0020,   /* U+3889 */
  0x0020,   /* U+388A */
  0x0020,   /* U+388B */
  0x0020,   /* U+388C */
  0x0020,   /* U+388D */
  0x0020,   /* U+388E */
  0x0020,   /* U+388F */
  0x0020,   /* U+3890 */
  0x0020,   /* U+3891 */
  0x0020,   /* U+3892 */
  0x0020,   /* U+3893 */
  0x0020,   /* U+3894 */
  0x0020,   /* U+3895 */
  0x0020,   /* U+3896 */
  0x0020,   /* U+3897 */
  0x0020,   /* U+3898 */
  0x0020,   /* U+3899 */
  0x0020,   /* U+389A */
  0x0020,   /* U+389B */
  0x0020,   /* U+389C */
  0x0020,   /* U+389D */
  0x0020,   /* U+389E */
  0x0020,   /* U+389F */
  0x0020,   /* U+38A0 */
  0x0020,   /* U+38A1 */
  0x0020,   /* U+38A2 */
  0x0020,   /* U+38A3 */
  0x0020,   /* U+38A4 */
  0x0020,   /* U+38A5 */
  0x0020,   /* U+38A6 */
  0x0020,   /* U+38A7 */
  0x0020,   /* U+38A8 */
  0x0020,   /* U+38A9 */
  0x0020,   /* U+38AA */
  0x0020,   /* U+38AB */
  0x0020,   /* U+38AC */
  0x0020,   /* U+38AD */
  0x0020,   /* U+38AE */
  0x0020,   /* U+38AF */
  0x0020,   /* U+38B0 */
  0x0020,   /* U+38B1 */
  0x0020,   /* U+38B2 */
  0x0020,   /* U+38B3 */
  0x0020,   /* U+38B4 */
  0x0020,   /* U+38B5 */
  0x0020,   /* U+38B6 */
  0x0020,   /* U+38B7 */
  0x0020,   /* U+38B8 */
  0x0020,   /* U+38B9 */
  0x0020,   /* U+38BA */
  0x0020,   /* U+38BB */
  0x0020,   /* U+38BC */
  0x0020,   /* U+38BD */
  0x0020,   /* U+38BE */
  0x0020,   /* U+38BF */
  0x0020,   /* U+38C0 */
  0x0020,   /* U+38C1 */
  0x0020,   /* U+38C2 */
  0x0020,   /* U+38C3 */
  0x0020,   /* U+38C4 */
  0x0020,   /* U+38C5 */
  0x0020,   /* U+38C6 */
  0x0020,   /* U+38C7 */
  0x0020,   /* U+38C8 */
  0x0020,   /* U+38C9 */
  0x0020,   /* U+38CA */
  0x0020,   /* U+38CB */
  0x0020,   /* U+38CC */
  0x0020,   /* U+38CD */
  0x0020,   /* U+38CE */
  0x0020,   /* U+38CF */
  0x0020,   /* U+38D0 */
  0x0020,   /* U+38D1 */
  0x0020,   /* U+38D2 */
  0x0020,   /* U+38D3 */
  0x0020,   /* U+38D4 */
  0x0020,   /* U+38D5 */
  0x0020,   /* U+38D6 */
  0x0020,   /* U+38D7 */
  0x0020,   /* U+38D8 */
  0x0020,   /* U+38D9 */
  0x0020,   /* U+38DA */
  0x0020,   /* U+38DB */
  0x0020,   /* U+38DC */
  0x0020,   /* U+38DD */
  0x0020,   /* U+38DE */
  0x0020,   /* U+38DF */
  0x0020,   /* U+38E0 */
  0x0020,   /* U+38E1 */
  0x0020,   /* U+38E2 */
  0x0020,   /* U+38E3 */
  0x0020,   /* U+38E4 */
  0x0020,   /* U+38E5 */
  0x0020,   /* U+38E6 */
  0x0020,   /* U+38E7 */
  0x0020,   /* U+38E8 */
  0x0020,   /* U+38E9 */
  0x0020,   /* U+38EA */
  0x0020,   /* U+38EB */
  0x0020,   /* U+38EC */
  0x0020,   /* U+38ED */
  0x0020,   /* U+38EE */
  0x0020,   /* U+38EF */
  0x0020,   /* U+38F0 */
  0x0020,   /* U+38F1 */
  0x0020,   /* U+38F2 */
  0x0020,   /* U+38F3 */
  0x0020,   /* U+38F4 */
  0x0020,   /* U+38F5 */
  0x0020,   /* U+38F6 */
  0x0020,   /* U+38F7 */
  0x0020,   /* U+38F8 */
  0x0020,   /* U+38F9 */
  0x0020,   /* U+38FA */
  0x0020,   /* U+38FB */
  0x0020,   /* U+38FC */
  0x0020,   /* U+38FD */
  0x0020,   /* U+38FE */
  0x0020,   /* U+38FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3800 */
  0x0002,   /* U+3801 */
  0x0002,   /* U+3802 */
  0x0002,   /* U+3803 */
  0x0002,   /* U+3804 */
  0x0002,   /* U+3805 */
  0x0002,   /* U+3806 */
  0x0002,   /* U+3807 */
  0x0002,   /* U+3808 */
  0x0002,   /* U+3809 */
  0x0002,   /* U+380A */
  0x0002,   /* U+380B */
  0x0002,   /* U+380C */
  0x0002,   /* U+380D */
  0x0002,   /* U+380E */
  0x0002,   /* U+380F */
  0x0002,   /* U+3810 */
  0x0002,   /* U+3811 */
  0x0002,   /* U+3812 */
  0x0002,   /* U+3813 */
  0x0002,   /* U+3814 */
  0x0002,   /* U+3815 */
  0x0002,   /* U+3816 */
  0x0002,   /* U+3817 */
  0x0002,   /* U+3818 */
  0x0002,   /* U+3819 */
  0x0002,   /* U+381A */
  0x0002,   /* U+381B */
  0x0002,   /* U+381C */
  0x0002,   /* U+381D */
  0x0002,   /* U+381E */
  0x0002,   /* U+381F */
  0x0002,   /* U+3820 */
  0x0002,   /* U+3821 */
  0x0002,   /* U+3822 */
  0x0002,   /* U+3823 */
  0x0002,   /* U+3824 */
  0x0002,   /* U+3825 */
  0x0002,   /* U+3826 */
  0x0002,   /* U+3827 */
  0x0002,   /* U+3828 */
  0x0002,   /* U+3829 */
  0x0002,   /* U+382A */
  0x0002,   /* U+382B */
  0x0002,   /* U+382C */
  0x0002,   /* U+382D */
  0x0002,   /* U+382E */
  0x0002,   /* U+382F */
  0x0002,   /* U+3830 */
  0x0002,   /* U+3831 */
  0x0002,   /* U+3832 */
  0x0002,   /* U+3833 */
  0x0002,   /* U+3834 */
  0x0002,   /* U+3835 */
  0x0002,   /* U+3836 */
  0x0002,   /* U+3837 */
  0x0002,   /* U+3838 */
  0x0002,   /* U+3839 */
  0x0002,   /* U+383A */
  0x0002,   /* U+383B */
  0x0002,   /* U+383C */
  0x0002,   /* U+383D */
  0x0002,   /* U+383E */
  0x0002,   /* U+383F */
  0x0002,   /* U+3840 */
  0x0002,   /* U+3841 */
  0x0002,   /* U+3842 */
  0x0002,   /* U+3843 */
  0x0002,   /* U+3844 */
  0x0002,   /* U+3845 */
  0x0002,   /* U+3846 */
  0x0002,   /* U+3847 */
  0x0002,   /* U+3848 */
  0x0002,   /* U+3849 */
  0x0002,   /* U+384A */
  0x0002,   /* U+384B */
  0x0002,   /* U+384C */
  0x0002,   /* U+384D */
  0x0002,   /* U+384E */
  0x0002,   /* U+384F */
  0x0002,   /* U+3850 */
  0x0002,   /* U+3851 */
  0x0002,   /* U+3852 */
  0x0002,   /* U+3853 */
  0x0002,   /* U+3854 */
  0x0002,   /* U+3855 */
  0x0002,   /* U+3856 */
  0x0002,   /* U+3857 */
  0x0002,   /* U+3858 */
  0x0002,   /* U+3859 */
  0x0002,   /* U+385A */
  0x0002,   /* U+385B */
  0x0002,   /* U+385C */
  0x0002,   /* U+385D */
  0x0002,   /* U+385E */
  0x0002,   /* U+385F */
  0x0002,   /* U+3860 */
  0x0002,   /* U+3861 */
  0x0002,   /* U+3862 */
  0x0002,   /* U+3863 */
  0x0002,   /* U+3864 */
  0x0002,   /* U+3865 */
  0x0002,   /* U+3866 */
  0x0002,   /* U+3867 */
  0x0002,   /* U+3868 */
  0x0002,   /* U+3869 */
  0x0002,   /* U+386A */
  0x0002,   /* U+386B */
  0x0002,   /* U+386C */
  0x0002,   /* U+386D */
  0x0002,   /* U+386E */
  0x0002,   /* U+386F */
  0x0002,   /* U+3870 */
  0x0002,   /* U+3871 */
  0x0002,   /* U+3872 */
  0x0002,   /* U+3873 */
  0x0002,   /* U+3874 */
  0x0002,   /* U+3875 */
  0x0002,   /* U+3876 */
  0x0002,   /* U+3877 */
  0x0002,   /* U+3878 */
  0x0002,   /* U+3879 */
  0x0002,   /* U+387A */
  0x0002,   /* U+387B */
  0x0002,   /* U+387C */
  0x0002,   /* U+387D */
  0x0002,   /* U+387E */
  0x0002,   /* U+387F */
  0x0002,   /* U+3880 */
  0x0002,   /* U+3881 */
  0x0002,   /* U+3882 */
  0x0002,   /* U+3883 */
  0x0002,   /* U+3884 */
  0x0002,   /* U+3885 */
  0x0002,   /* U+3886 */
  0x0002,   /* U+3887 */
  0x0002,   /* U+3888 */
  0x0002,   /* U+3889 */
  0x0002,   /* U+388A */
  0x0002,   /* U+388B */
  0x0002,   /* U+388C */
  0x0002,   /* U+388D */
  0x0002,   /* U+388E */
  0x0002,   /* U+388F */
  0x0002,   /* U+3890 */
  0x0002,   /* U+3891 */
  0x0002,   /* U+3892 */
  0x0002,   /* U+3893 */
  0x0002,   /* U+3894 */
  0x0002,   /* U+3895 */
  0x0002,   /* U+3896 */
  0x0002,   /* U+3897 */
  0x0002,   /* U+3898 */
  0x0002,   /* U+3899 */
  0x0002,   /* U+389A */
  0x0002,   /* U+389B */
  0x0002,   /* U+389C */
  0x0002,   /* U+389D */
  0x0002,   /* U+389E */
  0x0002,   /* U+389F */
  0x0002,   /* U+38A0 */
  0x0002,   /* U+38A1 */
  0x0002,   /* U+38A2 */
  0x0002,   /* U+38A3 */
  0x0002,   /* U+38A4 */
  0x0002,   /* U+38A5 */
  0x0002,   /* U+38A6 */
  0x0002,   /* U+38A7 */
  0x0002,   /* U+38A8 */
  0x0002,   /* U+38A9 */
  0x0002,   /* U+38AA */
  0x0002,   /* U+38AB */
  0x0002,   /* U+38AC */
  0x0002,   /* U+38AD */
  0x0002,   /* U+38AE */
  0x0002,   /* U+38AF */
  0x0002,   /* U+38B0 */
  0x0002,   /* U+38B1 */
  0x0002,   /* U+38B2 */
  0x0002,   /* U+38B3 */
  0x0002,   /* U+38B4 */
  0x0002,   /* U+38B5 */
  0x0002,   /* U+38B6 */
  0x0002,   /* U+38B7 */
  0x0002,   /* U+38B8 */
  0x0002,   /* U+38B9 */
  0x0002,   /* U+38BA */
  0x0002,   /* U+38BB */
  0x0002,   /* U+38BC */
  0x0002,   /* U+38BD */
  0x0002,   /* U+38BE */
  0x0002,   /* U+38BF */
  0x0002,   /* U+38C0 */
  0x0002,   /* U+38C1 */
  0x0002,   /* U+38C2 */
  0x0002,   /* U+38C3 */
  0x0002,   /* U+38C4 */
  0x0002,   /* U+38C5 */
  0x0002,   /* U+38C6 */
  0x0002,   /* U+38C7 */
  0x0002,   /* U+38C8 */
  0x0002,   /* U+38C9 */
  0x0002,   /* U+38CA */
  0x0002,   /* U+38CB */
  0x0002,   /* U+38CC */
  0x0002,   /* U+38CD */
  0x0002,   /* U+38CE */
  0x0002,   /* U+38CF */
  0x0002,   /* U+38D0 */
  0x0002,   /* U+38D1 */
  0x0002,   /* U+38D2 */
  0x0002,   /* U+38D3 */
  0x0002,   /* U+38D4 */
  0x0002,   /* U+38D5 */
  0x0002,   /* U+38D6 */
  0x0002,   /* U+38D7 */
  0x0002,   /* U+38D8 */
  0x0002,   /* U+38D9 */
  0x0002,   /* U+38DA */
  0x0002,   /* U+38DB */
  0x0002,   /* U+38DC */
  0x0002,   /* U+38DD */
  0x0002,   /* U+38DE */
  0x0002,   /* U+38DF */
  0x0002,   /* U+38E0 */
  0x0002,   /* U+38E1 */
  0x0002,   /* U+38E2 */
  0x0002,   /* U+38E3 */
  0x0002,   /* U+38E4 */
  0x0002,   /* U+38E5 */
  0x0002,   /* U+38E6 */
  0x0002,   /* U+38E7 */
  0x0002,   /* U+38E8 */
  0x0002,   /* U+38E9 */
  0x0002,   /* U+38EA */
  0x0002,   /* U+38EB */
  0x0002,   /* U+38EC */
  0x0002,   /* U+38ED */
  0x0002,   /* U+38EE */
  0x0002,   /* U+38EF */
  0x0002,   /* U+38F0 */
  0x0002,   /* U+38F1 */
  0x0002,   /* U+38F2 */
  0x0002,   /* U+38F3 */
  0x0002,   /* U+38F4 */
  0x0002,   /* U+38F5 */
  0x0002,   /* U+38F6 */
  0x0002,   /* U+38F7 */
  0x0002,   /* U+38F8 */
  0x0002,   /* U+38F9 */
  0x0002,   /* U+38FA */
  0x0002,   /* U+38FB */
  0x0002,   /* U+38FC */
  0x0002,   /* U+38FD */
  0x0002,   /* U+38FE */
  0x0002,   /* U+38FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0xB801,   /* U+3801 */
  0x0000,   /* U+3802 */
  0xB803,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0xB81E,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0xB824,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0xB829,   /* U+3829 */
  0x0000,   /* U+382A */
  0xB82B,   /* U+382B */
  0xB82C,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0xB830,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0xB833,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0xB83B,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0xB846,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0xB84D,   /* U+384D */
  0xB84E,   /* U+384E */
  0x0000,   /* U+384F */
  0xB850,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0xB864,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0xB86C,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0xB887,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0xB88C,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0xB890,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0xB895,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0xB8A2,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0xB8A4,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0xB8A6,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0xB8AA,   /* U+38AA */
  0xB8AB,   /* U+38AB */
  0x0000,   /* U+38AC */
  0xB8AD,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0xB8B1,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0xB8B4,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0xB8B7,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0xB8B9,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0xB8BF,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0xB8C9,   /* U+38C9 */
  0xB8CA,   /* U+38CA */
  0xB8CB,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0xB8D5,   /* U+38D5 */
  0xB8D6,   /* U+38D6 */
  0xB8D7,   /* U+38D7 */
  0xB8D8,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0xB8E1,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0xB8E8,   /* U+38E8 */
  0xB8E9,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0xB8EE,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0xB8F3,   /* U+38F3 */
  0xB8F4,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0xB8F8,   /* U+38F8 */
  0xB8F9,   /* U+38F9 */
  0xB8FA,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */
};

uint16_t zh_han_p039[] = {
  /* Number of CEs for each character. */
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 
  2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+3900 */
  0x6B5C,   /* U+3901 */
  0x4C47,   /* U+3902 */
  0x3925,   /* U+3903 */
  0x735D,   /* U+3904 */
  0x1C8E,   /* U+3905 */
  0x38E2,   /* U+3906 */
  0x1D95,   /* U+3907 */
  0x7B66,   /* U+3908 */
  0x7872,   /* U+3909 */
  0x9C49,   /* U+390A */
  0x39DA,   /* U+390B */
  0x3D0B,   /* U+390C */
  0x7A17,   /* U+390D */
  0x3E10,   /* U+390E */
  0x8FEF,   /* U+390F */
  0x26A9,   /* U+3910 */
  0xAC6E,   /* U+3911 */
  0x3DAD,   /* U+3912 */
  0x201B,   /* U+3913 */
  0x3C32,   /* U+3914 */
  0x2BDB,   /* U+3915 */
  0xB9B5,   /* U+3916 */
  0xBDC1,   /* U+3917 */
  0xB8E1,   /* U+3918 */
  0xBDC1,   /* U+3919 */
  0x4402,   /* U+391A */
  0x70CE,   /* U+391B */
  0x5651,   /* U+391C */
  0x2AA9,   /* U+391D */
  0x2667,   /* U+391E */
  0x5925,   /* U+391F */
  0x61CD,   /* U+3920 */
  0x5F2C,   /* U+3921 */
  0xADD2,   /* U+3922 */
  0xBDC1,   /* U+3923 */
  0xACCB,   /* U+3924 */
  0x42FF,   /* U+3925 */
  0x5F2D,   /* U+3926 */
  0x464B,   /* U+3927 */
  0x3F40,   /* U+3928 */
  0x58A2,   /* U+3929 */
  0xAF69,   /* U+392A */
  0x3186,   /* U+392B */
  0x4A24,   /* U+392C */
  0xBDC1,   /* U+392D */
  0x4165,   /* U+392E */
  0x53D8,   /* U+392F */
  0xBDAE,   /* U+3930 */
  0x3C3F,   /* U+3931 */
  0x7AC0,   /* U+3932 */
  0x1FAA,   /* U+3933 */
  0x2852,   /* U+3934 */
  0x2D6E,   /* U+3935 */
  0x6882,   /* U+3936 */
  0x431F,   /* U+3937 */
  0x98A4,   /* U+3938 */
  0x7C7C,   /* U+3939 */
  0x4977,   /* U+393A */
  0xBDC1,   /* U+393B */
  0xBDC1,   /* U+393C */
  0x2B1C,   /* U+393D */
  0x818D,   /* U+393E */
  0xA257,   /* U+393F */
  0xB68A,   /* U+3940 */
  0x318D,   /* U+3941 */
  0x8D9D,   /* U+3942 */
  0x69D0,   /* U+3943 */
  0x62C8,   /* U+3944 */
  0x8697,   /* U+3945 */
  0x9160,   /* U+3946 */
  0x2517,   /* U+3947 */
  0x33AA,   /* U+3948 */
  0x2857,   /* U+3949 */
  0x73AB,   /* U+394A */
  0xA65F,   /* U+394B */
  0x54DD,   /* U+394C */
  0x4D4D,   /* U+394D */
  0x5BD8,   /* U+394E */
  0x8ED9,   /* U+394F */
  0xAF70,   /* U+3950 */
  0xBDC1,   /* U+3951 */
  0x24E0,   /* U+3952 */
  0x76D1,   /* U+3953 */
  0xADEA,   /* U+3954 */
  0x6056,   /* U+3955 */
  0x2DD9,   /* U+3956 */
  0xBDC1,   /* U+3957 */
  0xBDC1,   /* U+3958 */
  0xBDC1,   /* U+3959 */
  0xACF1,   /* U+395A */
  0x4C72,   /* U+395B */
  0x94B0,   /* U+395C */
  0x6AD1,   /* U+395D */
  0x8A84,   /* U+395E */
  0x9CB6,   /* U+395F */
  0x9F2B,   /* U+3960 */
  0x2A60,   /* U+3961 */
  0x7C96,   /* U+3962 */
  0x4A46,   /* U+3963 */
  0xBDC1,   /* U+3964 */
  0xACF2,   /* U+3965 */
  0x7ACA,   /* U+3966 */
  0x880E,   /* U+3967 */
  0x87FC,   /* U+3968 */
  0x369E,   /* U+3969 */
  0x649A,   /* U+396A */
  0xBDC1,   /* U+396B */
  0x72E1,   /* U+396C */
  0x8C1F,   /* U+396D */
  0xB8F9,   /* U+396E */
  0xA9DD,   /* U+396F */
  0x81BE,   /* U+3970 */
  0x3981,   /* U+3971 */
  0x2889,   /* U+3972 */
  0xAF23,   /* U+3973 */
  0xA6F4,   /* U+3974 */
  0x4AEA,   /* U+3975 */
  0x81FF,   /* U+3976 */
  0xA5EC,   /* U+3977 */
  0x6C3A,   /* U+3978 */
  0x3A33,   /* U+3979 */
  0x44EB,   /* U+397A */
  0xBDC1,   /* U+397B */
  0xAA15,   /* U+397C */
  0x25CC,   /* U+397D */
  0x6FB8,   /* U+397E */
  0x1DBC,   /* U+397F */
  0x3AAF,   /* U+3980 */
  0x606F,   /* U+3981 */
  0x27AD,   /* U+3982 */
  0x2731,   /* U+3983 */
  0x6790,   /* U+3984 */
  0x3385,   /* U+3985 */
  0x46C8,   /* U+3986 */
  0x659A,   /* U+3987 */
  0xBDC1,   /* U+3988 */
  0xA891,   /* U+3989 */
  0x4802,   /* U+398A */
  0xB25A,   /* U+398B */
  0x46D5,   /* U+398C */
  0x3792,   /* U+398D */
  0x4B4C,   /* U+398E */
  0x8AE0,   /* U+398F */
  0x6FBB,   /* U+3990 */
  0x9AE1,   /* U+3991 */
  0x5E6D,   /* U+3992 */
  0x9AE2,   /* U+3993 */
  0xA3BE,   /* U+3994 */
  0x6429,   /* U+3995 */
  0x69D5,   /* U+3996 */
  0x5287,   /* U+3997 */
  0x4BFF,   /* U+3998 */
  0xBDC1,   /* U+3999 */
  0x21F6,   /* U+399A */
  0xADB4,   /* U+399B */
  0x4B58,   /* U+399C */
  0x6BAC,   /* U+399D */
  0x2B4B,   /* U+399E */
  0x67DB,   /* U+399F */
  0xBDC1,   /* U+39A0 */
  0x5D6D,   /* U+39A1 */
  0x5202,   /* U+39A2 */
  0x94EE,   /* U+39A3 */
  0xA902,   /* U+39A4 */
  0xA050,   /* U+39A5 */
  0x98F7,   /* U+39A6 */
  0x253D,   /* U+39A7 */
  0x5C47,   /* U+39A8 */
  0xA9F4,   /* U+39A9 */
  0x9D9B,   /* U+39AA */
  0xB0B5,   /* U+39AB */
  0x6742,   /* U+39AC */
  0x6342,   /* U+39AD */
  0x791B,   /* U+39AE */
  0x4B22,   /* U+39AF */
  0x4E87,   /* U+39B0 */
  0x95B9,   /* U+39B1 */
  0xBDC1,   /* U+39B2 */
  0xBDC1,   /* U+39B3 */
  0x3E3F,   /* U+39B4 */
  0xB926,   /* U+39B5 */
  0x3399,   /* U+39B6 */
  0xAB77,   /* U+39B7 */
  0x4CFB,   /* U+39B8 */
  0xA43E,   /* U+39B9 */
  0x8078,   /* U+39BA */
  0x983A,   /* U+39BB */
  0x87E1,   /* U+39BC */
  0xAE68,   /* U+39BD */
  0xA698,   /* U+39BE */
  0x795D,   /* U+39BF */
  0x4C48,   /* U+39C0 */
  0x7D97,   /* U+39C1 */
  0x8EA5,   /* U+39C2 */
  0x867C,   /* U+39C3 */
  0x795B,   /* U+39C4 */
  0x6D8C,   /* U+39C5 */
  0x5268,   /* U+39C6 */
  0x68EB,   /* U+39C7 */
  0xA9C7,   /* U+39C8 */
  0x3CE7,   /* U+39C9 */
  0x75D3,   /* U+39CA */
  0xA081,   /* U+39CB */
  0x68FA,   /* U+39CC */
  0x3933,   /* U+39CD */
  0xA1E7,   /* U+39CE */
  0x3D7B,   /* U+39CF */
  0x8910,   /* U+39D0 */
  0x499A,   /* U+39D1 */
  0xADCD,   /* U+39D2 */
  0x4076,   /* U+39D3 */
  0x40C6,   /* U+39D4 */
  0x63D4,   /* U+39D5 */
  0x3741,   /* U+39D6 */
  0xBBD6,   /* U+39D7 */
  0xBBFA,   /* U+39D8 */
  0x20E4,   /* U+39D9 */
  0x926F,   /* U+39DA */
  0xBDC1,   /* U+39DB */
  0x61BF,   /* U+39DC */
  0xBDC1,   /* U+39DD */
  0xBDC1,   /* U+39DE */
  0x59CF,   /* U+39DF */
  0xBDC1,   /* U+39E0 */
  0x4300,   /* U+39E1 */
  0xA93C,   /* U+39E2 */
  0xB922,   /* U+39E3 */
  0x2AF5,   /* U+39E4 */
  0x9A5B,   /* U+39E5 */
  0xA09B,   /* U+39E6 */
  0xBDC1,   /* U+39E7 */
  0x7C6F,   /* U+39E8 */
  0x7364,   /* U+39E9 */
  0x41BE,   /* U+39EA */
  0x37EE,   /* U+39EB */
  0x3F43,   /* U+39EC */
  0x7BE8,   /* U+39ED */
  0x46AB,   /* U+39EE */
  0x5D2A,   /* U+39EF */
  0x5F2E,   /* U+39F0 */
  0x28E0,   /* U+39F1 */
  0x8171,   /* U+39F2 */
  0xBB59,   /* U+39F3 */
  0x95BC,   /* U+39F4 */
  0x7647,   /* U+39F5 */
  0x58EE,   /* U+39F6 */
  0x91A7,   /* U+39F7 */
  0x738B,   /* U+39F8 */
  0x8D9E,   /* U+39F9 */
  0x8B89,   /* U+39FA */
  0xBB05,   /* U+39FB */
  0x2290,   /* U+39FC */
  0x405F,   /* U+39FD */
  0x46B4,   /* U+39FE */
  0xBDC1,   /* U+39FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3900 */
  0x0020,   /* U+3901 */
  0x0020,   /* U+3902 */
  0x0020,   /* U+3903 */
  0x0020,   /* U+3904 */
  0x0020,   /* U+3905 */
  0x0020,   /* U+3906 */
  0x0020,   /* U+3907 */
  0x0020,   /* U+3908 */
  0x0020,   /* U+3909 */
  0x0020,   /* U+390A */
  0x0020,   /* U+390B */
  0x0020,   /* U+390C */
  0x0020,   /* U+390D */
  0x0020,   /* U+390E */
  0x0020,   /* U+390F */
  0x0020,   /* U+3910 */
  0x0020,   /* U+3911 */
  0x0020,   /* U+3912 */
  0x0020,   /* U+3913 */
  0x0020,   /* U+3914 */
  0x0020,   /* U+3915 */
  0x0020,   /* U+3916 */
  0x0020,   /* U+3917 */
  0x0020,   /* U+3918 */
  0x0020,   /* U+3919 */
  0x0020,   /* U+391A */
  0x0020,   /* U+391B */
  0x0020,   /* U+391C */
  0x0020,   /* U+391D */
  0x0020,   /* U+391E */
  0x0020,   /* U+391F */
  0x0020,   /* U+3920 */
  0x0020,   /* U+3921 */
  0x0020,   /* U+3922 */
  0x0020,   /* U+3923 */
  0x0020,   /* U+3924 */
  0x0020,   /* U+3925 */
  0x0020,   /* U+3926 */
  0x0020,   /* U+3927 */
  0x0020,   /* U+3928 */
  0x0020,   /* U+3929 */
  0x0020,   /* U+392A */
  0x0020,   /* U+392B */
  0x0020,   /* U+392C */
  0x0020,   /* U+392D */
  0x0020,   /* U+392E */
  0x0020,   /* U+392F */
  0x0020,   /* U+3930 */
  0x0020,   /* U+3931 */
  0x0020,   /* U+3932 */
  0x0020,   /* U+3933 */
  0x0020,   /* U+3934 */
  0x0020,   /* U+3935 */
  0x0020,   /* U+3936 */
  0x0020,   /* U+3937 */
  0x0020,   /* U+3938 */
  0x0020,   /* U+3939 */
  0x0020,   /* U+393A */
  0x0020,   /* U+393B */
  0x0020,   /* U+393C */
  0x0020,   /* U+393D */
  0x0020,   /* U+393E */
  0x0020,   /* U+393F */
  0x0020,   /* U+3940 */
  0x0020,   /* U+3941 */
  0x0020,   /* U+3942 */
  0x0020,   /* U+3943 */
  0x0020,   /* U+3944 */
  0x0020,   /* U+3945 */
  0x0020,   /* U+3946 */
  0x0020,   /* U+3947 */
  0x0020,   /* U+3948 */
  0x0020,   /* U+3949 */
  0x0020,   /* U+394A */
  0x0020,   /* U+394B */
  0x0020,   /* U+394C */
  0x0020,   /* U+394D */
  0x0020,   /* U+394E */
  0x0020,   /* U+394F */
  0x0020,   /* U+3950 */
  0x0020,   /* U+3951 */
  0x0020,   /* U+3952 */
  0x0020,   /* U+3953 */
  0x0020,   /* U+3954 */
  0x0020,   /* U+3955 */
  0x0020,   /* U+3956 */
  0x0020,   /* U+3957 */
  0x0020,   /* U+3958 */
  0x0020,   /* U+3959 */
  0x0020,   /* U+395A */
  0x0020,   /* U+395B */
  0x0020,   /* U+395C */
  0x0020,   /* U+395D */
  0x0020,   /* U+395E */
  0x0020,   /* U+395F */
  0x0020,   /* U+3960 */
  0x0020,   /* U+3961 */
  0x0020,   /* U+3962 */
  0x0020,   /* U+3963 */
  0x0020,   /* U+3964 */
  0x0020,   /* U+3965 */
  0x0020,   /* U+3966 */
  0x0020,   /* U+3967 */
  0x0020,   /* U+3968 */
  0x0020,   /* U+3969 */
  0x0020,   /* U+396A */
  0x0020,   /* U+396B */
  0x0020,   /* U+396C */
  0x0020,   /* U+396D */
  0x0020,   /* U+396E */
  0x0020,   /* U+396F */
  0x0020,   /* U+3970 */
  0x0020,   /* U+3971 */
  0x0020,   /* U+3972 */
  0x0020,   /* U+3973 */
  0x0020,   /* U+3974 */
  0x0020,   /* U+3975 */
  0x0020,   /* U+3976 */
  0x0020,   /* U+3977 */
  0x0020,   /* U+3978 */
  0x0020,   /* U+3979 */
  0x0020,   /* U+397A */
  0x0020,   /* U+397B */
  0x0020,   /* U+397C */
  0x0020,   /* U+397D */
  0x0020,   /* U+397E */
  0x0020,   /* U+397F */
  0x0020,   /* U+3980 */
  0x0020,   /* U+3981 */
  0x0020,   /* U+3982 */
  0x0020,   /* U+3983 */
  0x0020,   /* U+3984 */
  0x0020,   /* U+3985 */
  0x0020,   /* U+3986 */
  0x0020,   /* U+3987 */
  0x0020,   /* U+3988 */
  0x0020,   /* U+3989 */
  0x0020,   /* U+398A */
  0x0020,   /* U+398B */
  0x0020,   /* U+398C */
  0x0020,   /* U+398D */
  0x0020,   /* U+398E */
  0x0020,   /* U+398F */
  0x0020,   /* U+3990 */
  0x0020,   /* U+3991 */
  0x0020,   /* U+3992 */
  0x0020,   /* U+3993 */
  0x0020,   /* U+3994 */
  0x0020,   /* U+3995 */
  0x0020,   /* U+3996 */
  0x0020,   /* U+3997 */
  0x0020,   /* U+3998 */
  0x0020,   /* U+3999 */
  0x0020,   /* U+399A */
  0x0020,   /* U+399B */
  0x0020,   /* U+399C */
  0x0020,   /* U+399D */
  0x0020,   /* U+399E */
  0x0020,   /* U+399F */
  0x0020,   /* U+39A0 */
  0x0020,   /* U+39A1 */
  0x0020,   /* U+39A2 */
  0x0020,   /* U+39A3 */
  0x0020,   /* U+39A4 */
  0x0020,   /* U+39A5 */
  0x0020,   /* U+39A6 */
  0x0020,   /* U+39A7 */
  0x0020,   /* U+39A8 */
  0x0020,   /* U+39A9 */
  0x0020,   /* U+39AA */
  0x0020,   /* U+39AB */
  0x0020,   /* U+39AC */
  0x0020,   /* U+39AD */
  0x0020,   /* U+39AE */
  0x0020,   /* U+39AF */
  0x0020,   /* U+39B0 */
  0x0020,   /* U+39B1 */
  0x0020,   /* U+39B2 */
  0x0020,   /* U+39B3 */
  0x0020,   /* U+39B4 */
  0x0020,   /* U+39B5 */
  0x0020,   /* U+39B6 */
  0x0020,   /* U+39B7 */
  0x0020,   /* U+39B8 */
  0x0020,   /* U+39B9 */
  0x0020,   /* U+39BA */
  0x0020,   /* U+39BB */
  0x0020,   /* U+39BC */
  0x0020,   /* U+39BD */
  0x0020,   /* U+39BE */
  0x0020,   /* U+39BF */
  0x0020,   /* U+39C0 */
  0x0020,   /* U+39C1 */
  0x0020,   /* U+39C2 */
  0x0020,   /* U+39C3 */
  0x0020,   /* U+39C4 */
  0x0020,   /* U+39C5 */
  0x0020,   /* U+39C6 */
  0x0020,   /* U+39C7 */
  0x0020,   /* U+39C8 */
  0x0020,   /* U+39C9 */
  0x0020,   /* U+39CA */
  0x0020,   /* U+39CB */
  0x0020,   /* U+39CC */
  0x0020,   /* U+39CD */
  0x0020,   /* U+39CE */
  0x0020,   /* U+39CF */
  0x0020,   /* U+39D0 */
  0x0020,   /* U+39D1 */
  0x0020,   /* U+39D2 */
  0x0020,   /* U+39D3 */
  0x0020,   /* U+39D4 */
  0x0020,   /* U+39D5 */
  0x0020,   /* U+39D6 */
  0x0020,   /* U+39D7 */
  0x0020,   /* U+39D8 */
  0x0020,   /* U+39D9 */
  0x0020,   /* U+39DA */
  0x0020,   /* U+39DB */
  0x0020,   /* U+39DC */
  0x0020,   /* U+39DD */
  0x0020,   /* U+39DE */
  0x0020,   /* U+39DF */
  0x0020,   /* U+39E0 */
  0x0020,   /* U+39E1 */
  0x0020,   /* U+39E2 */
  0x0020,   /* U+39E3 */
  0x0020,   /* U+39E4 */
  0x0020,   /* U+39E5 */
  0x0020,   /* U+39E6 */
  0x0020,   /* U+39E7 */
  0x0020,   /* U+39E8 */
  0x0020,   /* U+39E9 */
  0x0020,   /* U+39EA */
  0x0020,   /* U+39EB */
  0x0020,   /* U+39EC */
  0x0020,   /* U+39ED */
  0x0020,   /* U+39EE */
  0x0020,   /* U+39EF */
  0x0020,   /* U+39F0 */
  0x0020,   /* U+39F1 */
  0x0020,   /* U+39F2 */
  0x0020,   /* U+39F3 */
  0x0020,   /* U+39F4 */
  0x0020,   /* U+39F5 */
  0x0020,   /* U+39F6 */
  0x0020,   /* U+39F7 */
  0x0020,   /* U+39F8 */
  0x0020,   /* U+39F9 */
  0x0020,   /* U+39FA */
  0x0020,   /* U+39FB */
  0x0020,   /* U+39FC */
  0x0020,   /* U+39FD */
  0x0020,   /* U+39FE */
  0x0020,   /* U+39FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3900 */
  0x0002,   /* U+3901 */
  0x0002,   /* U+3902 */
  0x0002,   /* U+3903 */
  0x0002,   /* U+3904 */
  0x0002,   /* U+3905 */
  0x0002,   /* U+3906 */
  0x0002,   /* U+3907 */
  0x0002,   /* U+3908 */
  0x0002,   /* U+3909 */
  0x0002,   /* U+390A */
  0x0002,   /* U+390B */
  0x0002,   /* U+390C */
  0x0002,   /* U+390D */
  0x0002,   /* U+390E */
  0x0002,   /* U+390F */
  0x0002,   /* U+3910 */
  0x0002,   /* U+3911 */
  0x0002,   /* U+3912 */
  0x0002,   /* U+3913 */
  0x0002,   /* U+3914 */
  0x0002,   /* U+3915 */
  0x0002,   /* U+3916 */
  0x0002,   /* U+3917 */
  0x0002,   /* U+3918 */
  0x0002,   /* U+3919 */
  0x0002,   /* U+391A */
  0x0002,   /* U+391B */
  0x0002,   /* U+391C */
  0x0002,   /* U+391D */
  0x0002,   /* U+391E */
  0x0002,   /* U+391F */
  0x0002,   /* U+3920 */
  0x0002,   /* U+3921 */
  0x0002,   /* U+3922 */
  0x0002,   /* U+3923 */
  0x0002,   /* U+3924 */
  0x0002,   /* U+3925 */
  0x0002,   /* U+3926 */
  0x0002,   /* U+3927 */
  0x0002,   /* U+3928 */
  0x0002,   /* U+3929 */
  0x0002,   /* U+392A */
  0x0002,   /* U+392B */
  0x0002,   /* U+392C */
  0x0002,   /* U+392D */
  0x0002,   /* U+392E */
  0x0002,   /* U+392F */
  0x0002,   /* U+3930 */
  0x0002,   /* U+3931 */
  0x0002,   /* U+3932 */
  0x0002,   /* U+3933 */
  0x0002,   /* U+3934 */
  0x0002,   /* U+3935 */
  0x0002,   /* U+3936 */
  0x0002,   /* U+3937 */
  0x0002,   /* U+3938 */
  0x0002,   /* U+3939 */
  0x0002,   /* U+393A */
  0x0002,   /* U+393B */
  0x0002,   /* U+393C */
  0x0002,   /* U+393D */
  0x0002,   /* U+393E */
  0x0002,   /* U+393F */
  0x0002,   /* U+3940 */
  0x0002,   /* U+3941 */
  0x0002,   /* U+3942 */
  0x0002,   /* U+3943 */
  0x0002,   /* U+3944 */
  0x0002,   /* U+3945 */
  0x0002,   /* U+3946 */
  0x0002,   /* U+3947 */
  0x0002,   /* U+3948 */
  0x0002,   /* U+3949 */
  0x0002,   /* U+394A */
  0x0002,   /* U+394B */
  0x0002,   /* U+394C */
  0x0002,   /* U+394D */
  0x0002,   /* U+394E */
  0x0002,   /* U+394F */
  0x0002,   /* U+3950 */
  0x0002,   /* U+3951 */
  0x0002,   /* U+3952 */
  0x0002,   /* U+3953 */
  0x0002,   /* U+3954 */
  0x0002,   /* U+3955 */
  0x0002,   /* U+3956 */
  0x0002,   /* U+3957 */
  0x0002,   /* U+3958 */
  0x0002,   /* U+3959 */
  0x0002,   /* U+395A */
  0x0002,   /* U+395B */
  0x0002,   /* U+395C */
  0x0002,   /* U+395D */
  0x0002,   /* U+395E */
  0x0002,   /* U+395F */
  0x0002,   /* U+3960 */
  0x0002,   /* U+3961 */
  0x0002,   /* U+3962 */
  0x0002,   /* U+3963 */
  0x0002,   /* U+3964 */
  0x0002,   /* U+3965 */
  0x0002,   /* U+3966 */
  0x0002,   /* U+3967 */
  0x0002,   /* U+3968 */
  0x0002,   /* U+3969 */
  0x0002,   /* U+396A */
  0x0002,   /* U+396B */
  0x0002,   /* U+396C */
  0x0002,   /* U+396D */
  0x0002,   /* U+396E */
  0x0002,   /* U+396F */
  0x0002,   /* U+3970 */
  0x0002,   /* U+3971 */
  0x0002,   /* U+3972 */
  0x0002,   /* U+3973 */
  0x0002,   /* U+3974 */
  0x0002,   /* U+3975 */
  0x0002,   /* U+3976 */
  0x0002,   /* U+3977 */
  0x0002,   /* U+3978 */
  0x0002,   /* U+3979 */
  0x0002,   /* U+397A */
  0x0002,   /* U+397B */
  0x0002,   /* U+397C */
  0x0002,   /* U+397D */
  0x0002,   /* U+397E */
  0x0002,   /* U+397F */
  0x0002,   /* U+3980 */
  0x0002,   /* U+3981 */
  0x0002,   /* U+3982 */
  0x0002,   /* U+3983 */
  0x0002,   /* U+3984 */
  0x0002,   /* U+3985 */
  0x0002,   /* U+3986 */
  0x0002,   /* U+3987 */
  0x0002,   /* U+3988 */
  0x0002,   /* U+3989 */
  0x0002,   /* U+398A */
  0x0002,   /* U+398B */
  0x0002,   /* U+398C */
  0x0002,   /* U+398D */
  0x0002,   /* U+398E */
  0x0002,   /* U+398F */
  0x0002,   /* U+3990 */
  0x0002,   /* U+3991 */
  0x0002,   /* U+3992 */
  0x0002,   /* U+3993 */
  0x0002,   /* U+3994 */
  0x0002,   /* U+3995 */
  0x0002,   /* U+3996 */
  0x0002,   /* U+3997 */
  0x0002,   /* U+3998 */
  0x0002,   /* U+3999 */
  0x0002,   /* U+399A */
  0x0002,   /* U+399B */
  0x0002,   /* U+399C */
  0x0002,   /* U+399D */
  0x0002,   /* U+399E */
  0x0002,   /* U+399F */
  0x0002,   /* U+39A0 */
  0x0002,   /* U+39A1 */
  0x0002,   /* U+39A2 */
  0x0002,   /* U+39A3 */
  0x0002,   /* U+39A4 */
  0x0002,   /* U+39A5 */
  0x0002,   /* U+39A6 */
  0x0002,   /* U+39A7 */
  0x0002,   /* U+39A8 */
  0x0002,   /* U+39A9 */
  0x0002,   /* U+39AA */
  0x0002,   /* U+39AB */
  0x0002,   /* U+39AC */
  0x0002,   /* U+39AD */
  0x0002,   /* U+39AE */
  0x0002,   /* U+39AF */
  0x0002,   /* U+39B0 */
  0x0002,   /* U+39B1 */
  0x0002,   /* U+39B2 */
  0x0002,   /* U+39B3 */
  0x0002,   /* U+39B4 */
  0x0002,   /* U+39B5 */
  0x0002,   /* U+39B6 */
  0x0002,   /* U+39B7 */
  0x0002,   /* U+39B8 */
  0x0002,   /* U+39B9 */
  0x0002,   /* U+39BA */
  0x0002,   /* U+39BB */
  0x0002,   /* U+39BC */
  0x0002,   /* U+39BD */
  0x0002,   /* U+39BE */
  0x0002,   /* U+39BF */
  0x0002,   /* U+39C0 */
  0x0002,   /* U+39C1 */
  0x0002,   /* U+39C2 */
  0x0002,   /* U+39C3 */
  0x0002,   /* U+39C4 */
  0x0002,   /* U+39C5 */
  0x0002,   /* U+39C6 */
  0x0002,   /* U+39C7 */
  0x0002,   /* U+39C8 */
  0x0002,   /* U+39C9 */
  0x0002,   /* U+39CA */
  0x0002,   /* U+39CB */
  0x0002,   /* U+39CC */
  0x0002,   /* U+39CD */
  0x0002,   /* U+39CE */
  0x0002,   /* U+39CF */
  0x0002,   /* U+39D0 */
  0x0002,   /* U+39D1 */
  0x0002,   /* U+39D2 */
  0x0002,   /* U+39D3 */
  0x0002,   /* U+39D4 */
  0x0002,   /* U+39D5 */
  0x0002,   /* U+39D6 */
  0x0002,   /* U+39D7 */
  0x0002,   /* U+39D8 */
  0x0002,   /* U+39D9 */
  0x0002,   /* U+39DA */
  0x0002,   /* U+39DB */
  0x0002,   /* U+39DC */
  0x0002,   /* U+39DD */
  0x0002,   /* U+39DE */
  0x0002,   /* U+39DF */
  0x0002,   /* U+39E0 */
  0x0002,   /* U+39E1 */
  0x0002,   /* U+39E2 */
  0x0002,   /* U+39E3 */
  0x0002,   /* U+39E4 */
  0x0002,   /* U+39E5 */
  0x0002,   /* U+39E6 */
  0x0002,   /* U+39E7 */
  0x0002,   /* U+39E8 */
  0x0002,   /* U+39E9 */
  0x0002,   /* U+39EA */
  0x0002,   /* U+39EB */
  0x0002,   /* U+39EC */
  0x0002,   /* U+39ED */
  0x0002,   /* U+39EE */
  0x0002,   /* U+39EF */
  0x0002,   /* U+39F0 */
  0x0002,   /* U+39F1 */
  0x0002,   /* U+39F2 */
  0x0002,   /* U+39F3 */
  0x0002,   /* U+39F4 */
  0x0002,   /* U+39F5 */
  0x0002,   /* U+39F6 */
  0x0002,   /* U+39F7 */
  0x0002,   /* U+39F8 */
  0x0002,   /* U+39F9 */
  0x0002,   /* U+39FA */
  0x0002,   /* U+39FB */
  0x0002,   /* U+39FC */
  0x0002,   /* U+39FD */
  0x0002,   /* U+39FE */
  0x0002,   /* U+39FF */

  /* Primary weight 2 for each character. */
  0xB900,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0xB917,   /* U+3917 */
  0x0000,   /* U+3918 */
  0xB919,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0xB923,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0xB92D,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0xB93B,   /* U+393B */
  0xB93C,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0xB951,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0xB957,   /* U+3957 */
  0xB958,   /* U+3958 */
  0xB959,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0xB964,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0xB96B,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0xB97B,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0xB988,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0xB999,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0xB9A0,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0xB9B2,   /* U+39B2 */
  0xB9B3,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0xB9DB,   /* U+39DB */
  0x0000,   /* U+39DC */
  0xB9DD,   /* U+39DD */
  0xB9DE,   /* U+39DE */
  0x0000,   /* U+39DF */
  0xB9E0,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0xB9E7,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0xB9FF,   /* U+39FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */
};

uint16_t zh_han_p03A[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  2, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 

  /* Primary weight 1 for each character. */
  0x2339,   /* U+3A00 */
  0xB74F,   /* U+3A01 */
  0x3471,   /* U+3A02 */
  0x35E5,   /* U+3A03 */
  0xB899,   /* U+3A04 */
  0x6F22,   /* U+3A05 */
  0x6264,   /* U+3A06 */
  0x75F2,   /* U+3A07 */
  0x4CF4,   /* U+3A08 */
  0x6C04,   /* U+3A09 */
  0x9448,   /* U+3A0A */
  0x2842,   /* U+3A0B */
  0x3FAE,   /* U+3A0C */
  0x1EE1,   /* U+3A0D */
  0x8039,   /* U+3A0E */
  0x8C36,   /* U+3A0F */
  0x2468,   /* U+3A10 */
  0xBC26,   /* U+3A11 */
  0x5A74,   /* U+3A12 */
  0x5D02,   /* U+3A13 */
  0x43B2,   /* U+3A14 */
  0xAA9E,   /* U+3A15 */
  0xB773,   /* U+3A16 */
  0x51B7,   /* U+3A17 */
  0x9E60,   /* U+3A18 */
  0x9CBE,   /* U+3A19 */
  0xA16D,   /* U+3A1A */
  0x830A,   /* U+3A1B */
  0x7937,   /* U+3A1C */
  0x9C83,   /* U+3A1D */
  0x89D0,   /* U+3A1E */
  0x42DE,   /* U+3A1F */
  0x6B04,   /* U+3A20 */
  0x4ACD,   /* U+3A21 */
  0x7417,   /* U+3A22 */
  0xBDC1,   /* U+3A23 */
  0x4A47,   /* U+3A24 */
  0x6E03,   /* U+3A25 */
  0x8919,   /* U+3A26 */
  0x2025,   /* U+3A27 */
  0x2B0B,   /* U+3A28 */
  0x51C5,   /* U+3A29 */
  0x498D,   /* U+3A2A */
  0x5C6C,   /* U+3A2B */
  0xBDC1,   /* U+3A2C */
  0x47B5,   /* U+3A2D */
  0x34B3,   /* U+3A2E */
  0x4B47,   /* U+3A2F */
  0x423C,   /* U+3A30 */
  0xA4ED,   /* U+3A31 */
  0x25CD,   /* U+3A32 */
  0x41DC,   /* U+3A33 */
  0x4FA5,   /* U+3A34 */
  0x4F32,   /* U+3A35 */
  0x3148,   /* U+3A36 */
  0x52EC,   /* U+3A37 */
  0x67C0,   /* U+3A38 */
  0x4A53,   /* U+3A39 */
  0x6B73,   /* U+3A3A */
  0x2521,   /* U+3A3B */
  0x66B6,   /* U+3A3C */
  0x74B4,   /* U+3A3D */
  0xA48C,   /* U+3A3E */
  0x5589,   /* U+3A3F */
  0x558A,   /* U+3A40 */
  0x7E53,   /* U+3A41 */
  0xBDC1,   /* U+3A42 */
  0x78EC,   /* U+3A43 */
  0x82AB,   /* U+3A44 */
  0xBDC1,   /* U+3A45 */
  0x5463,   /* U+3A46 */
  0x4B4D,   /* U+3A47 */
  0xB05D,   /* U+3A48 */
  0x2FAD,   /* U+3A49 */
  0xA03D,   /* U+3A4A */
  0x9BE3,   /* U+3A4B */
  0x39B7,   /* U+3A4C */
  0x25D3,   /* U+3A4D */
  0xA5F7,   /* U+3A4E */
  0xBDC1,   /* U+3A4F */
  0x31A1,   /* U+3A50 */
  0xBDC1,   /* U+3A51 */
  0x7B35,   /* U+3A52 */
  0x4A0A,   /* U+3A53 */
  0x9199,   /* U+3A54 */
  0xBDC1,   /* U+3A55 */
  0x79F8,   /* U+3A56 */
  0x983D,   /* U+3A57 */
  0x6F82,   /* U+3A58 */
  0x814C,   /* U+3A59 */
  0x6A05,   /* U+3A5A */
  0x9110,   /* U+3A5B */
  0x5C77,   /* U+3A5C */
  0x444A,   /* U+3A5D */
  0x2DC1,   /* U+3A5E */
  0xB30A,   /* U+3A5F */
  0x1D60,   /* U+3A60 */
  0x673B,   /* U+3A61 */
  0x6BD7,   /* U+3A62 */
  0xBDC1,   /* U+3A63 */
  0x3B27,   /* U+3A64 */
  0xBDC1,   /* U+3A65 */
  0x9CE8,   /* U+3A66 */
  0x2412,   /* U+3A67 */
  0x4A8D,   /* U+3A68 */
  0x7BC0,   /* U+3A69 */
  0x9CE9,   /* U+3A6A */
  0xBDC1,   /* U+3A6B */
  0xBDC1,   /* U+3A6C */
  0x241D,   /* U+3A6D */
  0x7952,   /* U+3A6E */
  0x75FD,   /* U+3A6F */
  0x5104,   /* U+3A70 */
  0x56DA,   /* U+3A71 */
  0x5B3C,   /* U+3A72 */
  0x8925,   /* U+3A73 */
  0x551B,   /* U+3A74 */
  0x37C9,   /* U+3A75 */
  0x70BD,   /* U+3A76 */
  0x7910,   /* U+3A77 */
  0x33E8,   /* U+3A78 */
  0x33E9,   /* U+3A79 */
  0xBDC1,   /* U+3A7A */
  0x76CB,   /* U+3A7B */
  0xB641,   /* U+3A7C */
  0x7744,   /* U+3A7D */
  0xBAA3,   /* U+3A7E */
  0x5963,   /* U+3A7F */
  0xACBA,   /* U+3A80 */
  0x7B10,   /* U+3A81 */
  0x5968,   /* U+3A82 */
  0x44B9,   /* U+3A83 */
  0x3B57,   /* U+3A84 */
  0xBDC1,   /* U+3A85 */
  0x3247,   /* U+3A86 */
  0x9AB9,   /* U+3A87 */
  0x41F1,   /* U+3A88 */
  0x44C7,   /* U+3A89 */
  0x7E86,   /* U+3A8A */
  0x43A7,   /* U+3A8B */
  0x903B,   /* U+3A8C */
  0x23BD,   /* U+3A8D */
  0x8306,   /* U+3A8E */
  0x20B7,   /* U+3A8F */
  0x6581,   /* U+3A90 */
  0xA5DC,   /* U+3A91 */
  0x6F4E,   /* U+3A92 */
  0x2C2E,   /* U+3A93 */
  0x818F,   /* U+3A94 */
  0x336B,   /* U+3A95 */
  0x6582,   /* U+3A96 */
  0x906B,   /* U+3A97 */
  0x60B4,   /* U+3A98 */
  0x588B,   /* U+3A99 */
  0x8190,   /* U+3A9A */
  0xB553,   /* U+3A9B */
  0x2C31,   /* U+3A9C */
  0x60D8,   /* U+3A9D */
  0x691F,   /* U+3A9E */
  0xBDC1,   /* U+3A9F */
  0x78E6,   /* U+3AA0 */
  0x57A0,   /* U+3AA1 */
  0x83C0,   /* U+3AA2 */
  0x9BD6,   /* U+3AA3 */
  0x215C,   /* U+3AA4 */
  0xB25B,   /* U+3AA5 */
  0xAA1C,   /* U+3AA6 */
  0x97C6,   /* U+3AA7 */
  0x833F,   /* U+3AA8 */
  0x89F3,   /* U+3AA9 */
  0x812C,   /* U+3AAA */
  0x80D7,   /* U+3AAB */
  0x2D1E,   /* U+3AAC */
  0x6517,   /* U+3AAD */
  0x6325,   /* U+3AAE */
  0x262E,   /* U+3AAF */
  0xBDC1,   /* U+3AB0 */
  0x48EE,   /* U+3AB1 */
  0xBDC1,   /* U+3AB2 */
  0xBDC1,   /* U+3AB3 */
  0x4E25,   /* U+3AB4 */
  0x1EC0,   /* U+3AB5 */
  0x46EE,   /* U+3AB6 */
  0x34CE,   /* U+3AB7 */
  0xBDC1,   /* U+3AB8 */
  0x64CF,   /* U+3AB9 */
  0x54BD,   /* U+3ABA */
  0x5628,   /* U+3ABB */
  0x5885,   /* U+3ABC */
  0x8B0D,   /* U+3ABD */
  0x6751,   /* U+3ABE */
  0xB47E,   /* U+3ABF */
  0x3411,   /* U+3AC0 */
  0x35BE,   /* U+3AC1 */
  0xB9EE,   /* U+3AC2 */
  0xA2FF,   /* U+3AC3 */
  0x72D8,   /* U+3AC4 */
  0x2637,   /* U+3AC5 */
  0xBDC1,   /* U+3AC6 */
  0xBDC1,   /* U+3AC7 */
  0xBDC1,   /* U+3AC8 */
  0xBDC1,   /* U+3AC9 */
  0xA75D,   /* U+3ACA */
  0xBDC1,   /* U+3ACB */
  0xBDC1,   /* U+3ACC */
  0xABFA,   /* U+3ACD */
  0x49C8,   /* U+3ACE */
  0xA544,   /* U+3ACF */
  0xA520,   /* U+3AD0 */
  0xB6C9,   /* U+3AD1 */
  0x3F3D,   /* U+3AD2 */
  0x77D1,   /* U+3AD3 */
  0x3EAA,   /* U+3AD4 */
  0xBDC1,   /* U+3AD5 */
  0xBDC1,   /* U+3AD6 */
  0x4682,   /* U+3AD7 */
  0x6AEB,   /* U+3AD8 */
  0x3B4A,   /* U+3AD9 */
  0x46A6,   /* U+3ADA */
  0x4161,   /* U+3ADB */
  0x8C8D,   /* U+3ADC */
  0x31E2,   /* U+3ADD */
  0xBDC1,   /* U+3ADE */
  0xA299,   /* U+3ADF */
  0xBDC1,   /* U+3AE0 */
  0xBDC1,   /* U+3AE1 */
  0x7D98,   /* U+3AE2 */
  0xBDC1,   /* U+3AE3 */
  0x27C1,   /* U+3AE4 */
  0x6C72,   /* U+3AE5 */
  0x8D41,   /* U+3AE6 */
  0x1F69,   /* U+3AE7 */
  0x1CD5,   /* U+3AE8 */
  0xBDC1,   /* U+3AE9 */
  0xBDC1,   /* U+3AEA */
  0x9A61,   /* U+3AEB */
  0xBDC1,   /* U+3AEC */
  0xBDC1,   /* U+3AED */
  0xBDC1,   /* U+3AEE */
  0x6910,   /* U+3AEF */
  0x5CE4,   /* U+3AF0 */
  0x6E70,   /* U+3AF1 */
  0x1FCC,   /* U+3AF2 */
  0x28AE,   /* U+3AF3 */
  0xBDC1,   /* U+3AF4 */
  0x3955,   /* U+3AF5 */
  0xB8D5,   /* U+3AF6 */
  0x4BBC,   /* U+3AF7 */
  0x515B,   /* U+3AF8 */
  0x8758,   /* U+3AF9 */
  0xBDC1,   /* U+3AFA */
  0x5B41,   /* U+3AFB */
  0x33AD,   /* U+3AFC */
  0x6583,   /* U+3AFD */
  0xBDC1,   /* U+3AFE */
  0xBDC1,   /* U+3AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3A00 */
  0x0020,   /* U+3A01 */
  0x0020,   /* U+3A02 */
  0x0020,   /* U+3A03 */
  0x0020,   /* U+3A04 */
  0x0020,   /* U+3A05 */
  0x0020,   /* U+3A06 */
  0x0020,   /* U+3A07 */
  0x0020,   /* U+3A08 */
  0x0020,   /* U+3A09 */
  0x0020,   /* U+3A0A */
  0x0020,   /* U+3A0B */
  0x0020,   /* U+3A0C */
  0x0020,   /* U+3A0D */
  0x0020,   /* U+3A0E */
  0x0020,   /* U+3A0F */
  0x0020,   /* U+3A10 */
  0x0020,   /* U+3A11 */
  0x0020,   /* U+3A12 */
  0x0020,   /* U+3A13 */
  0x0020,   /* U+3A14 */
  0x0020,   /* U+3A15 */
  0x0020,   /* U+3A16 */
  0x0020,   /* U+3A17 */
  0x0020,   /* U+3A18 */
  0x0020,   /* U+3A19 */
  0x0020,   /* U+3A1A */
  0x0020,   /* U+3A1B */
  0x0020,   /* U+3A1C */
  0x0020,   /* U+3A1D */
  0x0020,   /* U+3A1E */
  0x0020,   /* U+3A1F */
  0x0020,   /* U+3A20 */
  0x0020,   /* U+3A21 */
  0x0020,   /* U+3A22 */
  0x0020,   /* U+3A23 */
  0x0020,   /* U+3A24 */
  0x0020,   /* U+3A25 */
  0x0020,   /* U+3A26 */
  0x0020,   /* U+3A27 */
  0x0020,   /* U+3A28 */
  0x0020,   /* U+3A29 */
  0x0020,   /* U+3A2A */
  0x0020,   /* U+3A2B */
  0x0020,   /* U+3A2C */
  0x0020,   /* U+3A2D */
  0x0020,   /* U+3A2E */
  0x0020,   /* U+3A2F */
  0x0020,   /* U+3A30 */
  0x0020,   /* U+3A31 */
  0x0020,   /* U+3A32 */
  0x0020,   /* U+3A33 */
  0x0020,   /* U+3A34 */
  0x0020,   /* U+3A35 */
  0x0020,   /* U+3A36 */
  0x0020,   /* U+3A37 */
  0x0020,   /* U+3A38 */
  0x0020,   /* U+3A39 */
  0x0020,   /* U+3A3A */
  0x0020,   /* U+3A3B */
  0x0020,   /* U+3A3C */
  0x0020,   /* U+3A3D */
  0x0020,   /* U+3A3E */
  0x0020,   /* U+3A3F */
  0x0020,   /* U+3A40 */
  0x0020,   /* U+3A41 */
  0x0020,   /* U+3A42 */
  0x0020,   /* U+3A43 */
  0x0020,   /* U+3A44 */
  0x0020,   /* U+3A45 */
  0x0020,   /* U+3A46 */
  0x0020,   /* U+3A47 */
  0x0020,   /* U+3A48 */
  0x0020,   /* U+3A49 */
  0x0020,   /* U+3A4A */
  0x0020,   /* U+3A4B */
  0x0020,   /* U+3A4C */
  0x0020,   /* U+3A4D */
  0x0020,   /* U+3A4E */
  0x0020,   /* U+3A4F */
  0x0020,   /* U+3A50 */
  0x0020,   /* U+3A51 */
  0x0020,   /* U+3A52 */
  0x0020,   /* U+3A53 */
  0x0020,   /* U+3A54 */
  0x0020,   /* U+3A55 */
  0x0020,   /* U+3A56 */
  0x0020,   /* U+3A57 */
  0x0020,   /* U+3A58 */
  0x0020,   /* U+3A59 */
  0x0020,   /* U+3A5A */
  0x0020,   /* U+3A5B */
  0x0020,   /* U+3A5C */
  0x0020,   /* U+3A5D */
  0x0020,   /* U+3A5E */
  0x0020,   /* U+3A5F */
  0x0020,   /* U+3A60 */
  0x0020,   /* U+3A61 */
  0x0020,   /* U+3A62 */
  0x0020,   /* U+3A63 */
  0x0020,   /* U+3A64 */
  0x0020,   /* U+3A65 */
  0x0020,   /* U+3A66 */
  0x0020,   /* U+3A67 */
  0x0020,   /* U+3A68 */
  0x0020,   /* U+3A69 */
  0x0020,   /* U+3A6A */
  0x0020,   /* U+3A6B */
  0x0020,   /* U+3A6C */
  0x0020,   /* U+3A6D */
  0x0020,   /* U+3A6E */
  0x0020,   /* U+3A6F */
  0x0020,   /* U+3A70 */
  0x0020,   /* U+3A71 */
  0x0020,   /* U+3A72 */
  0x0020,   /* U+3A73 */
  0x0020,   /* U+3A74 */
  0x0020,   /* U+3A75 */
  0x0020,   /* U+3A76 */
  0x0020,   /* U+3A77 */
  0x0020,   /* U+3A78 */
  0x0020,   /* U+3A79 */
  0x0020,   /* U+3A7A */
  0x0020,   /* U+3A7B */
  0x0020,   /* U+3A7C */
  0x0020,   /* U+3A7D */
  0x0020,   /* U+3A7E */
  0x0020,   /* U+3A7F */
  0x0020,   /* U+3A80 */
  0x0020,   /* U+3A81 */
  0x0020,   /* U+3A82 */
  0x0020,   /* U+3A83 */
  0x0020,   /* U+3A84 */
  0x0020,   /* U+3A85 */
  0x0020,   /* U+3A86 */
  0x0020,   /* U+3A87 */
  0x0020,   /* U+3A88 */
  0x0020,   /* U+3A89 */
  0x0020,   /* U+3A8A */
  0x0020,   /* U+3A8B */
  0x0020,   /* U+3A8C */
  0x0020,   /* U+3A8D */
  0x0020,   /* U+3A8E */
  0x0020,   /* U+3A8F */
  0x0020,   /* U+3A90 */
  0x0020,   /* U+3A91 */
  0x0020,   /* U+3A92 */
  0x0020,   /* U+3A93 */
  0x0020,   /* U+3A94 */
  0x0020,   /* U+3A95 */
  0x0020,   /* U+3A96 */
  0x0020,   /* U+3A97 */
  0x0020,   /* U+3A98 */
  0x0020,   /* U+3A99 */
  0x0020,   /* U+3A9A */
  0x0020,   /* U+3A9B */
  0x0020,   /* U+3A9C */
  0x0020,   /* U+3A9D */
  0x0020,   /* U+3A9E */
  0x0020,   /* U+3A9F */
  0x0020,   /* U+3AA0 */
  0x0020,   /* U+3AA1 */
  0x0020,   /* U+3AA2 */
  0x0020,   /* U+3AA3 */
  0x0020,   /* U+3AA4 */
  0x0020,   /* U+3AA5 */
  0x0020,   /* U+3AA6 */
  0x0020,   /* U+3AA7 */
  0x0020,   /* U+3AA8 */
  0x0020,   /* U+3AA9 */
  0x0020,   /* U+3AAA */
  0x0020,   /* U+3AAB */
  0x0020,   /* U+3AAC */
  0x0020,   /* U+3AAD */
  0x0020,   /* U+3AAE */
  0x0020,   /* U+3AAF */
  0x0020,   /* U+3AB0 */
  0x0020,   /* U+3AB1 */
  0x0020,   /* U+3AB2 */
  0x0020,   /* U+3AB3 */
  0x0020,   /* U+3AB4 */
  0x0020,   /* U+3AB5 */
  0x0020,   /* U+3AB6 */
  0x0020,   /* U+3AB7 */
  0x0020,   /* U+3AB8 */
  0x0020,   /* U+3AB9 */
  0x0020,   /* U+3ABA */
  0x0020,   /* U+3ABB */
  0x0020,   /* U+3ABC */
  0x0020,   /* U+3ABD */
  0x0020,   /* U+3ABE */
  0x0020,   /* U+3ABF */
  0x0020,   /* U+3AC0 */
  0x0020,   /* U+3AC1 */
  0x0020,   /* U+3AC2 */
  0x0020,   /* U+3AC3 */
  0x0020,   /* U+3AC4 */
  0x0020,   /* U+3AC5 */
  0x0020,   /* U+3AC6 */
  0x0020,   /* U+3AC7 */
  0x0020,   /* U+3AC8 */
  0x0020,   /* U+3AC9 */
  0x0020,   /* U+3ACA */
  0x0020,   /* U+3ACB */
  0x0020,   /* U+3ACC */
  0x0020,   /* U+3ACD */
  0x0020,   /* U+3ACE */
  0x0020,   /* U+3ACF */
  0x0020,   /* U+3AD0 */
  0x0020,   /* U+3AD1 */
  0x0020,   /* U+3AD2 */
  0x0020,   /* U+3AD3 */
  0x0020,   /* U+3AD4 */
  0x0020,   /* U+3AD5 */
  0x0020,   /* U+3AD6 */
  0x0020,   /* U+3AD7 */
  0x0020,   /* U+3AD8 */
  0x0020,   /* U+3AD9 */
  0x0020,   /* U+3ADA */
  0x0020,   /* U+3ADB */
  0x0020,   /* U+3ADC */
  0x0020,   /* U+3ADD */
  0x0020,   /* U+3ADE */
  0x0020,   /* U+3ADF */
  0x0020,   /* U+3AE0 */
  0x0020,   /* U+3AE1 */
  0x0020,   /* U+3AE2 */
  0x0020,   /* U+3AE3 */
  0x0020,   /* U+3AE4 */
  0x0020,   /* U+3AE5 */
  0x0020,   /* U+3AE6 */
  0x0020,   /* U+3AE7 */
  0x0020,   /* U+3AE8 */
  0x0020,   /* U+3AE9 */
  0x0020,   /* U+3AEA */
  0x0020,   /* U+3AEB */
  0x0020,   /* U+3AEC */
  0x0020,   /* U+3AED */
  0x0020,   /* U+3AEE */
  0x0020,   /* U+3AEF */
  0x0020,   /* U+3AF0 */
  0x0020,   /* U+3AF1 */
  0x0020,   /* U+3AF2 */
  0x0020,   /* U+3AF3 */
  0x0020,   /* U+3AF4 */
  0x0020,   /* U+3AF5 */
  0x0020,   /* U+3AF6 */
  0x0020,   /* U+3AF7 */
  0x0020,   /* U+3AF8 */
  0x0020,   /* U+3AF9 */
  0x0020,   /* U+3AFA */
  0x0020,   /* U+3AFB */
  0x0020,   /* U+3AFC */
  0x0020,   /* U+3AFD */
  0x0020,   /* U+3AFE */
  0x0020,   /* U+3AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3A00 */
  0x0002,   /* U+3A01 */
  0x0002,   /* U+3A02 */
  0x0002,   /* U+3A03 */
  0x0002,   /* U+3A04 */
  0x0002,   /* U+3A05 */
  0x0002,   /* U+3A06 */
  0x0002,   /* U+3A07 */
  0x0002,   /* U+3A08 */
  0x0002,   /* U+3A09 */
  0x0002,   /* U+3A0A */
  0x0002,   /* U+3A0B */
  0x0002,   /* U+3A0C */
  0x0002,   /* U+3A0D */
  0x0002,   /* U+3A0E */
  0x0002,   /* U+3A0F */
  0x0002,   /* U+3A10 */
  0x0002,   /* U+3A11 */
  0x0002,   /* U+3A12 */
  0x0002,   /* U+3A13 */
  0x0002,   /* U+3A14 */
  0x0002,   /* U+3A15 */
  0x0002,   /* U+3A16 */
  0x0002,   /* U+3A17 */
  0x0002,   /* U+3A18 */
  0x0002,   /* U+3A19 */
  0x0002,   /* U+3A1A */
  0x0002,   /* U+3A1B */
  0x0002,   /* U+3A1C */
  0x0002,   /* U+3A1D */
  0x0002,   /* U+3A1E */
  0x0002,   /* U+3A1F */
  0x0002,   /* U+3A20 */
  0x0002,   /* U+3A21 */
  0x0002,   /* U+3A22 */
  0x0002,   /* U+3A23 */
  0x0002,   /* U+3A24 */
  0x0002,   /* U+3A25 */
  0x0002,   /* U+3A26 */
  0x0002,   /* U+3A27 */
  0x0002,   /* U+3A28 */
  0x0002,   /* U+3A29 */
  0x0002,   /* U+3A2A */
  0x0002,   /* U+3A2B */
  0x0002,   /* U+3A2C */
  0x0002,   /* U+3A2D */
  0x0002,   /* U+3A2E */
  0x0002,   /* U+3A2F */
  0x0002,   /* U+3A30 */
  0x0002,   /* U+3A31 */
  0x0002,   /* U+3A32 */
  0x0002,   /* U+3A33 */
  0x0002,   /* U+3A34 */
  0x0002,   /* U+3A35 */
  0x0002,   /* U+3A36 */
  0x0002,   /* U+3A37 */
  0x0002,   /* U+3A38 */
  0x0002,   /* U+3A39 */
  0x0002,   /* U+3A3A */
  0x0002,   /* U+3A3B */
  0x0002,   /* U+3A3C */
  0x0002,   /* U+3A3D */
  0x0002,   /* U+3A3E */
  0x0002,   /* U+3A3F */
  0x0002,   /* U+3A40 */
  0x0002,   /* U+3A41 */
  0x0002,   /* U+3A42 */
  0x0002,   /* U+3A43 */
  0x0002,   /* U+3A44 */
  0x0002,   /* U+3A45 */
  0x0002,   /* U+3A46 */
  0x0002,   /* U+3A47 */
  0x0002,   /* U+3A48 */
  0x0002,   /* U+3A49 */
  0x0002,   /* U+3A4A */
  0x0002,   /* U+3A4B */
  0x0002,   /* U+3A4C */
  0x0002,   /* U+3A4D */
  0x0002,   /* U+3A4E */
  0x0002,   /* U+3A4F */
  0x0002,   /* U+3A50 */
  0x0002,   /* U+3A51 */
  0x0002,   /* U+3A52 */
  0x0002,   /* U+3A53 */
  0x0002,   /* U+3A54 */
  0x0002,   /* U+3A55 */
  0x0002,   /* U+3A56 */
  0x0002,   /* U+3A57 */
  0x0002,   /* U+3A58 */
  0x0002,   /* U+3A59 */
  0x0002,   /* U+3A5A */
  0x0002,   /* U+3A5B */
  0x0002,   /* U+3A5C */
  0x0002,   /* U+3A5D */
  0x0002,   /* U+3A5E */
  0x0002,   /* U+3A5F */
  0x0002,   /* U+3A60 */
  0x0002,   /* U+3A61 */
  0x0002,   /* U+3A62 */
  0x0002,   /* U+3A63 */
  0x0002,   /* U+3A64 */
  0x0002,   /* U+3A65 */
  0x0002,   /* U+3A66 */
  0x0002,   /* U+3A67 */
  0x0002,   /* U+3A68 */
  0x0002,   /* U+3A69 */
  0x0002,   /* U+3A6A */
  0x0002,   /* U+3A6B */
  0x0002,   /* U+3A6C */
  0x0002,   /* U+3A6D */
  0x0002,   /* U+3A6E */
  0x0002,   /* U+3A6F */
  0x0002,   /* U+3A70 */
  0x0002,   /* U+3A71 */
  0x0002,   /* U+3A72 */
  0x0002,   /* U+3A73 */
  0x0002,   /* U+3A74 */
  0x0002,   /* U+3A75 */
  0x0002,   /* U+3A76 */
  0x0002,   /* U+3A77 */
  0x0002,   /* U+3A78 */
  0x0002,   /* U+3A79 */
  0x0002,   /* U+3A7A */
  0x0002,   /* U+3A7B */
  0x0002,   /* U+3A7C */
  0x0002,   /* U+3A7D */
  0x0002,   /* U+3A7E */
  0x0002,   /* U+3A7F */
  0x0002,   /* U+3A80 */
  0x0002,   /* U+3A81 */
  0x0002,   /* U+3A82 */
  0x0002,   /* U+3A83 */
  0x0002,   /* U+3A84 */
  0x0002,   /* U+3A85 */
  0x0002,   /* U+3A86 */
  0x0002,   /* U+3A87 */
  0x0002,   /* U+3A88 */
  0x0002,   /* U+3A89 */
  0x0002,   /* U+3A8A */
  0x0002,   /* U+3A8B */
  0x0002,   /* U+3A8C */
  0x0002,   /* U+3A8D */
  0x0002,   /* U+3A8E */
  0x0002,   /* U+3A8F */
  0x0002,   /* U+3A90 */
  0x0002,   /* U+3A91 */
  0x0002,   /* U+3A92 */
  0x0002,   /* U+3A93 */
  0x0002,   /* U+3A94 */
  0x0002,   /* U+3A95 */
  0x0002,   /* U+3A96 */
  0x0002,   /* U+3A97 */
  0x0002,   /* U+3A98 */
  0x0002,   /* U+3A99 */
  0x0002,   /* U+3A9A */
  0x0002,   /* U+3A9B */
  0x0002,   /* U+3A9C */
  0x0002,   /* U+3A9D */
  0x0002,   /* U+3A9E */
  0x0002,   /* U+3A9F */
  0x0002,   /* U+3AA0 */
  0x0002,   /* U+3AA1 */
  0x0002,   /* U+3AA2 */
  0x0002,   /* U+3AA3 */
  0x0002,   /* U+3AA4 */
  0x0002,   /* U+3AA5 */
  0x0002,   /* U+3AA6 */
  0x0002,   /* U+3AA7 */
  0x0002,   /* U+3AA8 */
  0x0002,   /* U+3AA9 */
  0x0002,   /* U+3AAA */
  0x0002,   /* U+3AAB */
  0x0002,   /* U+3AAC */
  0x0002,   /* U+3AAD */
  0x0002,   /* U+3AAE */
  0x0002,   /* U+3AAF */
  0x0002,   /* U+3AB0 */
  0x0002,   /* U+3AB1 */
  0x0002,   /* U+3AB2 */
  0x0002,   /* U+3AB3 */
  0x0002,   /* U+3AB4 */
  0x0002,   /* U+3AB5 */
  0x0002,   /* U+3AB6 */
  0x0002,   /* U+3AB7 */
  0x0002,   /* U+3AB8 */
  0x0002,   /* U+3AB9 */
  0x0002,   /* U+3ABA */
  0x0002,   /* U+3ABB */
  0x0002,   /* U+3ABC */
  0x0002,   /* U+3ABD */
  0x0002,   /* U+3ABE */
  0x0002,   /* U+3ABF */
  0x0002,   /* U+3AC0 */
  0x0002,   /* U+3AC1 */
  0x0002,   /* U+3AC2 */
  0x0002,   /* U+3AC3 */
  0x0002,   /* U+3AC4 */
  0x0002,   /* U+3AC5 */
  0x0002,   /* U+3AC6 */
  0x0002,   /* U+3AC7 */
  0x0002,   /* U+3AC8 */
  0x0002,   /* U+3AC9 */
  0x0002,   /* U+3ACA */
  0x0002,   /* U+3ACB */
  0x0002,   /* U+3ACC */
  0x0002,   /* U+3ACD */
  0x0002,   /* U+3ACE */
  0x0002,   /* U+3ACF */
  0x0002,   /* U+3AD0 */
  0x0002,   /* U+3AD1 */
  0x0002,   /* U+3AD2 */
  0x0002,   /* U+3AD3 */
  0x0002,   /* U+3AD4 */
  0x0002,   /* U+3AD5 */
  0x0002,   /* U+3AD6 */
  0x0002,   /* U+3AD7 */
  0x0002,   /* U+3AD8 */
  0x0002,   /* U+3AD9 */
  0x0002,   /* U+3ADA */
  0x0002,   /* U+3ADB */
  0x0002,   /* U+3ADC */
  0x0002,   /* U+3ADD */
  0x0002,   /* U+3ADE */
  0x0002,   /* U+3ADF */
  0x0002,   /* U+3AE0 */
  0x0002,   /* U+3AE1 */
  0x0002,   /* U+3AE2 */
  0x0002,   /* U+3AE3 */
  0x0002,   /* U+3AE4 */
  0x0002,   /* U+3AE5 */
  0x0002,   /* U+3AE6 */
  0x0002,   /* U+3AE7 */
  0x0002,   /* U+3AE8 */
  0x0002,   /* U+3AE9 */
  0x0002,   /* U+3AEA */
  0x0002,   /* U+3AEB */
  0x0002,   /* U+3AEC */
  0x0002,   /* U+3AED */
  0x0002,   /* U+3AEE */
  0x0002,   /* U+3AEF */
  0x0002,   /* U+3AF0 */
  0x0002,   /* U+3AF1 */
  0x0002,   /* U+3AF2 */
  0x0002,   /* U+3AF3 */
  0x0002,   /* U+3AF4 */
  0x0002,   /* U+3AF5 */
  0x0002,   /* U+3AF6 */
  0x0002,   /* U+3AF7 */
  0x0002,   /* U+3AF8 */
  0x0002,   /* U+3AF9 */
  0x0002,   /* U+3AFA */
  0x0002,   /* U+3AFB */
  0x0002,   /* U+3AFC */
  0x0002,   /* U+3AFD */
  0x0002,   /* U+3AFE */
  0x0002,   /* U+3AFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0xBA23,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0xBA2C,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0xBA42,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0xBA45,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0xBA4F,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0xBA51,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0xBA55,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0xBA63,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0xBA65,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0xBA6B,   /* U+3A6B */
  0xBA6C,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0xBA7A,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0xBA85,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0xBA9F,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0xBAB0,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0xBAB2,   /* U+3AB2 */
  0xBAB3,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0xBAB8,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0xBAC6,   /* U+3AC6 */
  0xBAC7,   /* U+3AC7 */
  0xBAC8,   /* U+3AC8 */
  0xBAC9,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0xBACB,   /* U+3ACB */
  0xBACC,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0xBAD5,   /* U+3AD5 */
  0xBAD6,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0xBADE,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0xBAE0,   /* U+3AE0 */
  0xBAE1,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0xBAE3,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0xBAE9,   /* U+3AE9 */
  0xBAEA,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0xBAEC,   /* U+3AEC */
  0xBAED,   /* U+3AED */
  0xBAEE,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0xBAF4,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0xBAFA,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0xBAFE,   /* U+3AFE */
  0xBAFF,   /* U+3AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */
};

uint16_t zh_han_p03B[] = {
  /* Number of CEs for each character. */
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 
  2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 
  2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+3B00 */
  0xBDC1,   /* U+3B01 */
  0xAD08,   /* U+3B02 */
  0x8BF5,   /* U+3B03 */
  0x2764,   /* U+3B04 */
  0x6849,   /* U+3B05 */
  0x6C39,   /* U+3B06 */
  0x48EF,   /* U+3B07 */
  0x950D,   /* U+3B08 */
  0x71A8,   /* U+3B09 */
  0x48F0,   /* U+3B0A */
  0x4659,   /* U+3B0B */
  0x539F,   /* U+3B0C */
  0x23DE,   /* U+3B0D */
  0x9A76,   /* U+3B0E */
  0x5F83,   /* U+3B0F */
  0x52ED,   /* U+3B10 */
  0xBDC1,   /* U+3B11 */
  0x68A8,   /* U+3B12 */
  0x753A,   /* U+3B13 */
  0x4440,   /* U+3B14 */
  0xA449,   /* U+3B15 */
  0xBDC1,   /* U+3B16 */
  0x9AEB,   /* U+3B17 */
  0x89F4,   /* U+3B18 */
  0x9472,   /* U+3B19 */
  0x286B,   /* U+3B1A */
  0x97C7,   /* U+3B1B */
  0x52FF,   /* U+3B1C */
  0x25F8,   /* U+3B1D */
  0x4543,   /* U+3B1E */
  0x39F4,   /* U+3B1F */
  0x82B7,   /* U+3B20 */
  0x630E,   /* U+3B21 */
  0xBDC1,   /* U+3B22 */
  0x360D,   /* U+3B23 */
  0x7703,   /* U+3B24 */
  0x76BC,   /* U+3B25 */
  0xAFDF,   /* U+3B26 */
  0x2413,   /* U+3B27 */
  0xBDC1,   /* U+3B28 */
  0x4A95,   /* U+3B29 */
  0x33DD,   /* U+3B2A */
  0xA3DF,   /* U+3B2B */
  0x55BF,   /* U+3B2C */
  0x5141,   /* U+3B2D */
  0x6E86,   /* U+3B2E */
  0x621F,   /* U+3B2F */
  0xACB5,   /* U+3B30 */
  0x8E71,   /* U+3B31 */
  0x8E9B,   /* U+3B32 */
  0x967A,   /* U+3B33 */
  0x4624,   /* U+3B34 */
  0x9C1B,   /* U+3B35 */
  0x446B,   /* U+3B36 */
  0xBDC1,   /* U+3B37 */
  0x8F0F,   /* U+3B38 */
  0xB5C6,   /* U+3B39 */
  0xBDC1,   /* U+3B3A */
  0x4924,   /* U+3B3B */
  0x3C74,   /* U+3B3C */
  0xBDC1,   /* U+3B3D */
  0xBDC1,   /* U+3B3E */
  0x9179,   /* U+3B3F */
  0xBDC1,   /* U+3B40 */
  0x7F70,   /* U+3B41 */
  0x50AC,   /* U+3B42 */
  0xBDC1,   /* U+3B43 */
  0x9DEF,   /* U+3B44 */
  0xBDC1,   /* U+3B45 */
  0xBDC1,   /* U+3B46 */
  0xAF63,   /* U+3B47 */
  0x564C,   /* U+3B48 */
  0x47EF,   /* U+3B49 */
  0xBDC1,   /* U+3B4A */
  0x1EF8,   /* U+3B4B */
  0x6D3D,   /* U+3B4C */
  0xBDC1,   /* U+3B4D */
  0x3D80,   /* U+3B4E */
  0x942F,   /* U+3B4F */
  0xBDC1,   /* U+3B50 */
  0x699A,   /* U+3B51 */
  0x88B9,   /* U+3B52 */
  0x220D,   /* U+3B53 */
  0x64F9,   /* U+3B54 */
  0x7CD7,   /* U+3B55 */
  0xBDC1,   /* U+3B56 */
  0xBDC1,   /* U+3B57 */
  0x3E43,   /* U+3B58 */
  0xB47F,   /* U+3B59 */
  0x661D,   /* U+3B5A */
  0x726E,   /* U+3B5B */
  0x7F95,   /* U+3B5C */
  0x7C7D,   /* U+3B5D */
  0x61CF,   /* U+3B5E */
  0x3F45,   /* U+3B5F */
  0x9A62,   /* U+3B60 */
  0x98A6,   /* U+3B61 */
  0x9DC3,   /* U+3B62 */
  0xBDC1,   /* U+3B63 */
  0x7026,   /* U+3B64 */
  0xBDC1,   /* U+3B65 */
  0xBDC1,   /* U+3B66 */
  0xBDC1,   /* U+3B67 */
  0x9CB2,   /* U+3B68 */
  0x61D9,   /* U+3B69 */
  0x3B04,   /* U+3B6A */
  0x2F3A,   /* U+3B6B */
  0xBB07,   /* U+3B6C */
  0x1DF0,   /* U+3B6D */
  0xBDAF,   /* U+3B6E */
  0xB488,   /* U+3B6F */
  0xBD19,   /* U+3B70 */
  0x44D2,   /* U+3B71 */
  0x4C66,   /* U+3B72 */
  0xBDC1,   /* U+3B73 */
  0x4E93,   /* U+3B74 */
  0xBDC1,   /* U+3B75 */
  0xBDC1,   /* U+3B76 */
  0xBDC1,   /* U+3B77 */
  0x90BA,   /* U+3B78 */
  0x9A14,   /* U+3B79 */
  0xA326,   /* U+3B7A */
  0x8CDE,   /* U+3B7B */
  0x8B8F,   /* U+3B7C */
  0x3250,   /* U+3B7D */
  0x567B,   /* U+3B7E */
  0x1D45,   /* U+3B7F */
  0x435B,   /* U+3B80 */
  0x9C25,   /* U+3B81 */
  0x54E5,   /* U+3B82 */
  0x93AA,   /* U+3B83 */
  0x1EEE,   /* U+3B84 */
  0xBA8E,   /* U+3B85 */
  0x7072,   /* U+3B86 */
  0x8EFF,   /* U+3B87 */
  0x6E3E,   /* U+3B88 */
  0xBDC1,   /* U+3B89 */
  0xBDC1,   /* U+3B8A */
  0xAC4B,   /* U+3B8B */
  0x6B3C,   /* U+3B8C */
  0xBDC1,   /* U+3B8D */
  0xBDC1,   /* U+3B8E */
  0x6E42,   /* U+3B8F */
  0x8509,   /* U+3B90 */
  0x261C,   /* U+3B91 */
  0xA264,   /* U+3B92 */
  0x3EB0,   /* U+3B93 */
  0x2AFB,   /* U+3B94 */
  0x8095,   /* U+3B95 */
  0x4E39,   /* U+3B96 */
  0x7B26,   /* U+3B97 */
  0x68CD,   /* U+3B98 */
  0x377E,   /* U+3B99 */
  0x5F77,   /* U+3B9A */
  0x29EC,   /* U+3B9B */
  0xB14D,   /* U+3B9C */
  0x44ED,   /* U+3B9D */
  0x51C8,   /* U+3B9E */
  0x6FF4,   /* U+3B9F */
  0xBDC1,   /* U+3BA0 */
  0x411A,   /* U+3BA1 */
  0x465A,   /* U+3BA2 */
  0x3CF4,   /* U+3BA3 */
  0xBDC1,   /* U+3BA4 */
  0x2026,   /* U+3BA5 */
  0x8B25,   /* U+3BA6 */
  0x961F,   /* U+3BA7 */
  0x4D73,   /* U+3BA8 */
  0x979E,   /* U+3BA9 */
  0x7C0A,   /* U+3BAA */
  0x44FC,   /* U+3BAB */
  0x957C,   /* U+3BAC */
  0x9A20,   /* U+3BAD */
  0x51D9,   /* U+3BAE */
  0x4AD2,   /* U+3BAF */
  0x7461,   /* U+3BB0 */
  0x846A,   /* U+3BB1 */
  0x2B0C,   /* U+3BB2 */
  0xB588,   /* U+3BB3 */
  0xBDC1,   /* U+3BB4 */
  0xB327,   /* U+3BB5 */
  0x882D,   /* U+3BB6 */
  0x4BD7,   /* U+3BB7 */
  0x8932,   /* U+3BB8 */
  0xB6FF,   /* U+3BB9 */
  0x2018,   /* U+3BBA */
  0xBDC1,   /* U+3BBB */
  0xBDC1,   /* U+3BBC */
  0xBDC1,   /* U+3BBD */
  0x5CDD,   /* U+3BBE */
  0x215D,   /* U+3BBF */
  0xA0B8,   /* U+3BC0 */
  0x7352,   /* U+3BC1 */
  0x3019,   /* U+3BC2 */
  0xBDC1,   /* U+3BC3 */
  0xB667,   /* U+3BC4 */
  0x7466,   /* U+3BC5 */
  0x2737,   /* U+3BC6 */
  0x215E,   /* U+3BC7 */
  0x89E9,   /* U+3BC8 */
  0x4B4E,   /* U+3BC9 */
  0x456B,   /* U+3BCA */
  0x53EA,   /* U+3BCB */
  0x2C53,   /* U+3BCC */
  0x502B,   /* U+3BCD */
  0x6F2D,   /* U+3BCE */
  0x4037,   /* U+3BCF */
  0x3942,   /* U+3BD0 */
  0xBDC1,   /* U+3BD1 */
  0xBDC1,   /* U+3BD2 */
  0x8BB0,   /* U+3BD3 */
  0x2EFE,   /* U+3BD4 */
  0x97CA,   /* U+3BD5 */
  0x3198,   /* U+3BD6 */
  0x9A2F,   /* U+3BD7 */
  0x5A0E,   /* U+3BD8 */
  0xB4A5,   /* U+3BD9 */
  0x8B62,   /* U+3BDA */
  0x472D,   /* U+3BDB */
  0x2EFF,   /* U+3BDC */
  0x65BE,   /* U+3BDD */
  0x561B,   /* U+3BDE */
  0x65BF,   /* U+3BDF */
  0x799F,   /* U+3BE0 */
  0x732B,   /* U+3BE1 */
  0xB598,   /* U+3BE2 */
  0xBDC1,   /* U+3BE3 */
  0x5F9B,   /* U+3BE4 */
  0x2591,   /* U+3BE5 */
  0x7788,   /* U+3BE6 */
  0xBDC1,   /* U+3BE7 */
  0xBDC1,   /* U+3BE8 */
  0x8E72,   /* U+3BE9 */
  0x630F,   /* U+3BEA */
  0x7D4F,   /* U+3BEB */
  0x60BC,   /* U+3BEC */
  0x654A,   /* U+3BED */
  0x870B,   /* U+3BEE */
  0x3F66,   /* U+3BEF */
  0xB4AD,   /* U+3BF0 */
  0x72FD,   /* U+3BF1 */
  0x5307,   /* U+3BF2 */
  0x7BAC,   /* U+3BF3 */
  0xBDC1,   /* U+3BF4 */
  0xBDC1,   /* U+3BF5 */
  0xBC42,   /* U+3BF6 */
  0x7692,   /* U+3BF7 */
  0x52B7,   /* U+3BF8 */
  0x228C,   /* U+3BF9 */
  0x4FCB,   /* U+3BFA */
  0x424B,   /* U+3BFB */
  0xBDC1,   /* U+3BFC */
  0xBDC1,   /* U+3BFD */
  0xB178,   /* U+3BFE */
  0x6208,   /* U+3BFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3B00 */
  0x0020,   /* U+3B01 */
  0x0020,   /* U+3B02 */
  0x0020,   /* U+3B03 */
  0x0020,   /* U+3B04 */
  0x0020,   /* U+3B05 */
  0x0020,   /* U+3B06 */
  0x0020,   /* U+3B07 */
  0x0020,   /* U+3B08 */
  0x0020,   /* U+3B09 */
  0x0020,   /* U+3B0A */
  0x0020,   /* U+3B0B */
  0x0020,   /* U+3B0C */
  0x0020,   /* U+3B0D */
  0x0020,   /* U+3B0E */
  0x0020,   /* U+3B0F */
  0x0020,   /* U+3B10 */
  0x0020,   /* U+3B11 */
  0x0020,   /* U+3B12 */
  0x0020,   /* U+3B13 */
  0x0020,   /* U+3B14 */
  0x0020,   /* U+3B15 */
  0x0020,   /* U+3B16 */
  0x0020,   /* U+3B17 */
  0x0020,   /* U+3B18 */
  0x0020,   /* U+3B19 */
  0x0020,   /* U+3B1A */
  0x0020,   /* U+3B1B */
  0x0020,   /* U+3B1C */
  0x0020,   /* U+3B1D */
  0x0020,   /* U+3B1E */
  0x0020,   /* U+3B1F */
  0x0020,   /* U+3B20 */
  0x0020,   /* U+3B21 */
  0x0020,   /* U+3B22 */
  0x0020,   /* U+3B23 */
  0x0020,   /* U+3B24 */
  0x0020,   /* U+3B25 */
  0x0020,   /* U+3B26 */
  0x0020,   /* U+3B27 */
  0x0020,   /* U+3B28 */
  0x0020,   /* U+3B29 */
  0x0020,   /* U+3B2A */
  0x0020,   /* U+3B2B */
  0x0020,   /* U+3B2C */
  0x0020,   /* U+3B2D */
  0x0020,   /* U+3B2E */
  0x0020,   /* U+3B2F */
  0x0020,   /* U+3B30 */
  0x0020,   /* U+3B31 */
  0x0020,   /* U+3B32 */
  0x0020,   /* U+3B33 */
  0x0020,   /* U+3B34 */
  0x0020,   /* U+3B35 */
  0x0020,   /* U+3B36 */
  0x0020,   /* U+3B37 */
  0x0020,   /* U+3B38 */
  0x0020,   /* U+3B39 */
  0x0020,   /* U+3B3A */
  0x0020,   /* U+3B3B */
  0x0020,   /* U+3B3C */
  0x0020,   /* U+3B3D */
  0x0020,   /* U+3B3E */
  0x0020,   /* U+3B3F */
  0x0020,   /* U+3B40 */
  0x0020,   /* U+3B41 */
  0x0020,   /* U+3B42 */
  0x0020,   /* U+3B43 */
  0x0020,   /* U+3B44 */
  0x0020,   /* U+3B45 */
  0x0020,   /* U+3B46 */
  0x0020,   /* U+3B47 */
  0x0020,   /* U+3B48 */
  0x0020,   /* U+3B49 */
  0x0020,   /* U+3B4A */
  0x0020,   /* U+3B4B */
  0x0020,   /* U+3B4C */
  0x0020,   /* U+3B4D */
  0x0020,   /* U+3B4E */
  0x0020,   /* U+3B4F */
  0x0020,   /* U+3B50 */
  0x0020,   /* U+3B51 */
  0x0020,   /* U+3B52 */
  0x0020,   /* U+3B53 */
  0x0020,   /* U+3B54 */
  0x0020,   /* U+3B55 */
  0x0020,   /* U+3B56 */
  0x0020,   /* U+3B57 */
  0x0020,   /* U+3B58 */
  0x0020,   /* U+3B59 */
  0x0020,   /* U+3B5A */
  0x0020,   /* U+3B5B */
  0x0020,   /* U+3B5C */
  0x0020,   /* U+3B5D */
  0x0020,   /* U+3B5E */
  0x0020,   /* U+3B5F */
  0x0020,   /* U+3B60 */
  0x0020,   /* U+3B61 */
  0x0020,   /* U+3B62 */
  0x0020,   /* U+3B63 */
  0x0020,   /* U+3B64 */
  0x0020,   /* U+3B65 */
  0x0020,   /* U+3B66 */
  0x0020,   /* U+3B67 */
  0x0020,   /* U+3B68 */
  0x0020,   /* U+3B69 */
  0x0020,   /* U+3B6A */
  0x0020,   /* U+3B6B */
  0x0020,   /* U+3B6C */
  0x0020,   /* U+3B6D */
  0x0020,   /* U+3B6E */
  0x0020,   /* U+3B6F */
  0x0020,   /* U+3B70 */
  0x0020,   /* U+3B71 */
  0x0020,   /* U+3B72 */
  0x0020,   /* U+3B73 */
  0x0020,   /* U+3B74 */
  0x0020,   /* U+3B75 */
  0x0020,   /* U+3B76 */
  0x0020,   /* U+3B77 */
  0x0020,   /* U+3B78 */
  0x0020,   /* U+3B79 */
  0x0020,   /* U+3B7A */
  0x0020,   /* U+3B7B */
  0x0020,   /* U+3B7C */
  0x0020,   /* U+3B7D */
  0x0020,   /* U+3B7E */
  0x0020,   /* U+3B7F */
  0x0020,   /* U+3B80 */
  0x0020,   /* U+3B81 */
  0x0020,   /* U+3B82 */
  0x0020,   /* U+3B83 */
  0x0020,   /* U+3B84 */
  0x0020,   /* U+3B85 */
  0x0020,   /* U+3B86 */
  0x0020,   /* U+3B87 */
  0x0020,   /* U+3B88 */
  0x0020,   /* U+3B89 */
  0x0020,   /* U+3B8A */
  0x0020,   /* U+3B8B */
  0x0020,   /* U+3B8C */
  0x0020,   /* U+3B8D */
  0x0020,   /* U+3B8E */
  0x0020,   /* U+3B8F */
  0x0020,   /* U+3B90 */
  0x0020,   /* U+3B91 */
  0x0020,   /* U+3B92 */
  0x0020,   /* U+3B93 */
  0x0020,   /* U+3B94 */
  0x0020,   /* U+3B95 */
  0x0020,   /* U+3B96 */
  0x0020,   /* U+3B97 */
  0x0020,   /* U+3B98 */
  0x0020,   /* U+3B99 */
  0x0020,   /* U+3B9A */
  0x0020,   /* U+3B9B */
  0x0020,   /* U+3B9C */
  0x0020,   /* U+3B9D */
  0x0020,   /* U+3B9E */
  0x0020,   /* U+3B9F */
  0x0020,   /* U+3BA0 */
  0x0020,   /* U+3BA1 */
  0x0020,   /* U+3BA2 */
  0x0020,   /* U+3BA3 */
  0x0020,   /* U+3BA4 */
  0x0020,   /* U+3BA5 */
  0x0020,   /* U+3BA6 */
  0x0020,   /* U+3BA7 */
  0x0020,   /* U+3BA8 */
  0x0020,   /* U+3BA9 */
  0x0020,   /* U+3BAA */
  0x0020,   /* U+3BAB */
  0x0020,   /* U+3BAC */
  0x0020,   /* U+3BAD */
  0x0020,   /* U+3BAE */
  0x0020,   /* U+3BAF */
  0x0020,   /* U+3BB0 */
  0x0020,   /* U+3BB1 */
  0x0020,   /* U+3BB2 */
  0x0020,   /* U+3BB3 */
  0x0020,   /* U+3BB4 */
  0x0020,   /* U+3BB5 */
  0x0020,   /* U+3BB6 */
  0x0020,   /* U+3BB7 */
  0x0020,   /* U+3BB8 */
  0x0020,   /* U+3BB9 */
  0x0020,   /* U+3BBA */
  0x0020,   /* U+3BBB */
  0x0020,   /* U+3BBC */
  0x0020,   /* U+3BBD */
  0x0020,   /* U+3BBE */
  0x0020,   /* U+3BBF */
  0x0020,   /* U+3BC0 */
  0x0020,   /* U+3BC1 */
  0x0020,   /* U+3BC2 */
  0x0020,   /* U+3BC3 */
  0x0020,   /* U+3BC4 */
  0x0020,   /* U+3BC5 */
  0x0020,   /* U+3BC6 */
  0x0020,   /* U+3BC7 */
  0x0020,   /* U+3BC8 */
  0x0020,   /* U+3BC9 */
  0x0020,   /* U+3BCA */
  0x0020,   /* U+3BCB */
  0x0020,   /* U+3BCC */
  0x0020,   /* U+3BCD */
  0x0020,   /* U+3BCE */
  0x0020,   /* U+3BCF */
  0x0020,   /* U+3BD0 */
  0x0020,   /* U+3BD1 */
  0x0020,   /* U+3BD2 */
  0x0020,   /* U+3BD3 */
  0x0020,   /* U+3BD4 */
  0x0020,   /* U+3BD5 */
  0x0020,   /* U+3BD6 */
  0x0020,   /* U+3BD7 */
  0x0020,   /* U+3BD8 */
  0x0020,   /* U+3BD9 */
  0x0020,   /* U+3BDA */
  0x0020,   /* U+3BDB */
  0x0020,   /* U+3BDC */
  0x0020,   /* U+3BDD */
  0x0020,   /* U+3BDE */
  0x0020,   /* U+3BDF */
  0x0020,   /* U+3BE0 */
  0x0020,   /* U+3BE1 */
  0x0020,   /* U+3BE2 */
  0x0020,   /* U+3BE3 */
  0x0020,   /* U+3BE4 */
  0x0020,   /* U+3BE5 */
  0x0020,   /* U+3BE6 */
  0x0020,   /* U+3BE7 */
  0x0020,   /* U+3BE8 */
  0x0020,   /* U+3BE9 */
  0x0020,   /* U+3BEA */
  0x0020,   /* U+3BEB */
  0x0020,   /* U+3BEC */
  0x0020,   /* U+3BED */
  0x0020,   /* U+3BEE */
  0x0020,   /* U+3BEF */
  0x0020,   /* U+3BF0 */
  0x0020,   /* U+3BF1 */
  0x0020,   /* U+3BF2 */
  0x0020,   /* U+3BF3 */
  0x0020,   /* U+3BF4 */
  0x0020,   /* U+3BF5 */
  0x0020,   /* U+3BF6 */
  0x0020,   /* U+3BF7 */
  0x0020,   /* U+3BF8 */
  0x0020,   /* U+3BF9 */
  0x0020,   /* U+3BFA */
  0x0020,   /* U+3BFB */
  0x0020,   /* U+3BFC */
  0x0020,   /* U+3BFD */
  0x0020,   /* U+3BFE */
  0x0020,   /* U+3BFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3B00 */
  0x0002,   /* U+3B01 */
  0x0002,   /* U+3B02 */
  0x0002,   /* U+3B03 */
  0x0002,   /* U+3B04 */
  0x0002,   /* U+3B05 */
  0x0002,   /* U+3B06 */
  0x0002,   /* U+3B07 */
  0x0002,   /* U+3B08 */
  0x0002,   /* U+3B09 */
  0x0002,   /* U+3B0A */
  0x0002,   /* U+3B0B */
  0x0002,   /* U+3B0C */
  0x0002,   /* U+3B0D */
  0x0002,   /* U+3B0E */
  0x0002,   /* U+3B0F */
  0x0002,   /* U+3B10 */
  0x0002,   /* U+3B11 */
  0x0002,   /* U+3B12 */
  0x0002,   /* U+3B13 */
  0x0002,   /* U+3B14 */
  0x0002,   /* U+3B15 */
  0x0002,   /* U+3B16 */
  0x0002,   /* U+3B17 */
  0x0002,   /* U+3B18 */
  0x0002,   /* U+3B19 */
  0x0002,   /* U+3B1A */
  0x0002,   /* U+3B1B */
  0x0002,   /* U+3B1C */
  0x0002,   /* U+3B1D */
  0x0002,   /* U+3B1E */
  0x0002,   /* U+3B1F */
  0x0002,   /* U+3B20 */
  0x0002,   /* U+3B21 */
  0x0002,   /* U+3B22 */
  0x0002,   /* U+3B23 */
  0x0002,   /* U+3B24 */
  0x0002,   /* U+3B25 */
  0x0002,   /* U+3B26 */
  0x0002,   /* U+3B27 */
  0x0002,   /* U+3B28 */
  0x0002,   /* U+3B29 */
  0x0002,   /* U+3B2A */
  0x0002,   /* U+3B2B */
  0x0002,   /* U+3B2C */
  0x0002,   /* U+3B2D */
  0x0002,   /* U+3B2E */
  0x0002,   /* U+3B2F */
  0x0002,   /* U+3B30 */
  0x0002,   /* U+3B31 */
  0x0002,   /* U+3B32 */
  0x0002,   /* U+3B33 */
  0x0002,   /* U+3B34 */
  0x0002,   /* U+3B35 */
  0x0002,   /* U+3B36 */
  0x0002,   /* U+3B37 */
  0x0002,   /* U+3B38 */
  0x0002,   /* U+3B39 */
  0x0002,   /* U+3B3A */
  0x0002,   /* U+3B3B */
  0x0002,   /* U+3B3C */
  0x0002,   /* U+3B3D */
  0x0002,   /* U+3B3E */
  0x0002,   /* U+3B3F */
  0x0002,   /* U+3B40 */
  0x0002,   /* U+3B41 */
  0x0002,   /* U+3B42 */
  0x0002,   /* U+3B43 */
  0x0002,   /* U+3B44 */
  0x0002,   /* U+3B45 */
  0x0002,   /* U+3B46 */
  0x0002,   /* U+3B47 */
  0x0002,   /* U+3B48 */
  0x0002,   /* U+3B49 */
  0x0002,   /* U+3B4A */
  0x0002,   /* U+3B4B */
  0x0002,   /* U+3B4C */
  0x0002,   /* U+3B4D */
  0x0002,   /* U+3B4E */
  0x0002,   /* U+3B4F */
  0x0002,   /* U+3B50 */
  0x0002,   /* U+3B51 */
  0x0002,   /* U+3B52 */
  0x0002,   /* U+3B53 */
  0x0002,   /* U+3B54 */
  0x0002,   /* U+3B55 */
  0x0002,   /* U+3B56 */
  0x0002,   /* U+3B57 */
  0x0002,   /* U+3B58 */
  0x0002,   /* U+3B59 */
  0x0002,   /* U+3B5A */
  0x0002,   /* U+3B5B */
  0x0002,   /* U+3B5C */
  0x0002,   /* U+3B5D */
  0x0002,   /* U+3B5E */
  0x0002,   /* U+3B5F */
  0x0002,   /* U+3B60 */
  0x0002,   /* U+3B61 */
  0x0002,   /* U+3B62 */
  0x0002,   /* U+3B63 */
  0x0002,   /* U+3B64 */
  0x0002,   /* U+3B65 */
  0x0002,   /* U+3B66 */
  0x0002,   /* U+3B67 */
  0x0002,   /* U+3B68 */
  0x0002,   /* U+3B69 */
  0x0002,   /* U+3B6A */
  0x0002,   /* U+3B6B */
  0x0002,   /* U+3B6C */
  0x0002,   /* U+3B6D */
  0x0002,   /* U+3B6E */
  0x0002,   /* U+3B6F */
  0x0002,   /* U+3B70 */
  0x0002,   /* U+3B71 */
  0x0002,   /* U+3B72 */
  0x0002,   /* U+3B73 */
  0x0002,   /* U+3B74 */
  0x0002,   /* U+3B75 */
  0x0002,   /* U+3B76 */
  0x0002,   /* U+3B77 */
  0x0002,   /* U+3B78 */
  0x0002,   /* U+3B79 */
  0x0002,   /* U+3B7A */
  0x0002,   /* U+3B7B */
  0x0002,   /* U+3B7C */
  0x0002,   /* U+3B7D */
  0x0002,   /* U+3B7E */
  0x0002,   /* U+3B7F */
  0x0002,   /* U+3B80 */
  0x0002,   /* U+3B81 */
  0x0002,   /* U+3B82 */
  0x0002,   /* U+3B83 */
  0x0002,   /* U+3B84 */
  0x0002,   /* U+3B85 */
  0x0002,   /* U+3B86 */
  0x0002,   /* U+3B87 */
  0x0002,   /* U+3B88 */
  0x0002,   /* U+3B89 */
  0x0002,   /* U+3B8A */
  0x0002,   /* U+3B8B */
  0x0002,   /* U+3B8C */
  0x0002,   /* U+3B8D */
  0x0002,   /* U+3B8E */
  0x0002,   /* U+3B8F */
  0x0002,   /* U+3B90 */
  0x0002,   /* U+3B91 */
  0x0002,   /* U+3B92 */
  0x0002,   /* U+3B93 */
  0x0002,   /* U+3B94 */
  0x0002,   /* U+3B95 */
  0x0002,   /* U+3B96 */
  0x0002,   /* U+3B97 */
  0x0002,   /* U+3B98 */
  0x0002,   /* U+3B99 */
  0x0002,   /* U+3B9A */
  0x0002,   /* U+3B9B */
  0x0002,   /* U+3B9C */
  0x0002,   /* U+3B9D */
  0x0002,   /* U+3B9E */
  0x0002,   /* U+3B9F */
  0x0002,   /* U+3BA0 */
  0x0002,   /* U+3BA1 */
  0x0002,   /* U+3BA2 */
  0x0002,   /* U+3BA3 */
  0x0002,   /* U+3BA4 */
  0x0002,   /* U+3BA5 */
  0x0002,   /* U+3BA6 */
  0x0002,   /* U+3BA7 */
  0x0002,   /* U+3BA8 */
  0x0002,   /* U+3BA9 */
  0x0002,   /* U+3BAA */
  0x0002,   /* U+3BAB */
  0x0002,   /* U+3BAC */
  0x0002,   /* U+3BAD */
  0x0002,   /* U+3BAE */
  0x0002,   /* U+3BAF */
  0x0002,   /* U+3BB0 */
  0x0002,   /* U+3BB1 */
  0x0002,   /* U+3BB2 */
  0x0002,   /* U+3BB3 */
  0x0002,   /* U+3BB4 */
  0x0002,   /* U+3BB5 */
  0x0002,   /* U+3BB6 */
  0x0002,   /* U+3BB7 */
  0x0002,   /* U+3BB8 */
  0x0002,   /* U+3BB9 */
  0x0002,   /* U+3BBA */
  0x0002,   /* U+3BBB */
  0x0002,   /* U+3BBC */
  0x0002,   /* U+3BBD */
  0x0002,   /* U+3BBE */
  0x0002,   /* U+3BBF */
  0x0002,   /* U+3BC0 */
  0x0002,   /* U+3BC1 */
  0x0002,   /* U+3BC2 */
  0x0002,   /* U+3BC3 */
  0x0002,   /* U+3BC4 */
  0x0002,   /* U+3BC5 */
  0x0002,   /* U+3BC6 */
  0x0002,   /* U+3BC7 */
  0x0002,   /* U+3BC8 */
  0x0002,   /* U+3BC9 */
  0x0002,   /* U+3BCA */
  0x0002,   /* U+3BCB */
  0x0002,   /* U+3BCC */
  0x0002,   /* U+3BCD */
  0x0002,   /* U+3BCE */
  0x0002,   /* U+3BCF */
  0x0002,   /* U+3BD0 */
  0x0002,   /* U+3BD1 */
  0x0002,   /* U+3BD2 */
  0x0002,   /* U+3BD3 */
  0x0002,   /* U+3BD4 */
  0x0002,   /* U+3BD5 */
  0x0002,   /* U+3BD6 */
  0x0002,   /* U+3BD7 */
  0x0002,   /* U+3BD8 */
  0x0002,   /* U+3BD9 */
  0x0002,   /* U+3BDA */
  0x0002,   /* U+3BDB */
  0x0002,   /* U+3BDC */
  0x0002,   /* U+3BDD */
  0x0002,   /* U+3BDE */
  0x0002,   /* U+3BDF */
  0x0002,   /* U+3BE0 */
  0x0002,   /* U+3BE1 */
  0x0002,   /* U+3BE2 */
  0x0002,   /* U+3BE3 */
  0x0002,   /* U+3BE4 */
  0x0002,   /* U+3BE5 */
  0x0002,   /* U+3BE6 */
  0x0002,   /* U+3BE7 */
  0x0002,   /* U+3BE8 */
  0x0002,   /* U+3BE9 */
  0x0002,   /* U+3BEA */
  0x0002,   /* U+3BEB */
  0x0002,   /* U+3BEC */
  0x0002,   /* U+3BED */
  0x0002,   /* U+3BEE */
  0x0002,   /* U+3BEF */
  0x0002,   /* U+3BF0 */
  0x0002,   /* U+3BF1 */
  0x0002,   /* U+3BF2 */
  0x0002,   /* U+3BF3 */
  0x0002,   /* U+3BF4 */
  0x0002,   /* U+3BF5 */
  0x0002,   /* U+3BF6 */
  0x0002,   /* U+3BF7 */
  0x0002,   /* U+3BF8 */
  0x0002,   /* U+3BF9 */
  0x0002,   /* U+3BFA */
  0x0002,   /* U+3BFB */
  0x0002,   /* U+3BFC */
  0x0002,   /* U+3BFD */
  0x0002,   /* U+3BFE */
  0x0002,   /* U+3BFF */

  /* Primary weight 2 for each character. */
  0xBB00,   /* U+3B00 */
  0xBB01,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0xBB11,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0xBB16,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0xBB22,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0xBB28,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0xBB37,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0xBB3A,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0xBB3D,   /* U+3B3D */
  0xBB3E,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0xBB40,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0xBB43,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0xBB45,   /* U+3B45 */
  0xBB46,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0xBB4A,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0xBB4D,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0xBB50,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0xBB56,   /* U+3B56 */
  0xBB57,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0xBB63,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0xBB65,   /* U+3B65 */
  0xBB66,   /* U+3B66 */
  0xBB67,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0xBB73,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0xBB75,   /* U+3B75 */
  0xBB76,   /* U+3B76 */
  0xBB77,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0xBB89,   /* U+3B89 */
  0xBB8A,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0xBB8D,   /* U+3B8D */
  0xBB8E,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0xBBA0,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0xBBA4,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0xBBB4,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0xBBBB,   /* U+3BBB */
  0xBBBC,   /* U+3BBC */
  0xBBBD,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0xBBC3,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0xBBD1,   /* U+3BD1 */
  0xBBD2,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0xBBE3,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0xBBE7,   /* U+3BE7 */
  0xBBE8,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0xBBF4,   /* U+3BF4 */
  0xBBF5,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0xBBFC,   /* U+3BFC */
  0xBBFD,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */
};

uint16_t zh_han_p03C[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
  1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x5EA0,   /* U+3C00 */
  0x673C,   /* U+3C01 */
  0x84AC,   /* U+3C02 */
  0x6B4B,   /* U+3C03 */
  0x4FD2,   /* U+3C04 */
  0x322F,   /* U+3C05 */
  0x1FFD,   /* U+3C06 */
  0xBDC1,   /* U+3C07 */
  0x60C0,   /* U+3C08 */
  0xBDC1,   /* U+3C09 */
  0x9A49,   /* U+3C0A */
  0x756D,   /* U+3C0B */
  0x7E71,   /* U+3C0C */
  0x6445,   /* U+3C0D */
  0xBD52,   /* U+3C0E */
  0xBDC1,   /* U+3C0F */
  0x56D4,   /* U+3C10 */
  0x82F6,   /* U+3C11 */
  0xA0F3,   /* U+3C12 */
  0xBDC1,   /* U+3C13 */
  0x9D9E,   /* U+3C14 */
  0xBDC1,   /* U+3C15 */
  0x5C7D,   /* U+3C16 */
  0x77BC,   /* U+3C17 */
  0xA737,   /* U+3C18 */
  0x71C8,   /* U+3C19 */
  0x5EBF,   /* U+3C1A */
  0xAFF1,   /* U+3C1B */
  0xBDC1,   /* U+3C1C */
  0xA74A,   /* U+3C1D */
  0x2998,   /* U+3C1E */
  0x4D23,   /* U+3C1F */
  0x43F5,   /* U+3C20 */
  0x9D10,   /* U+3C21 */
  0x58EA,   /* U+3C22 */
  0xBB66,   /* U+3C23 */
  0x4499,   /* U+3C24 */
  0x98A0,   /* U+3C25 */
  0x7D99,   /* U+3C26 */
  0x42DA,   /* U+3C27 */
  0x990E,   /* U+3C28 */
  0x42DB,   /* U+3C29 */
  0x4177,   /* U+3C2A */
  0x26AD,   /* U+3C2B */
  0xA15F,   /* U+3C2C */
  0x9F21,   /* U+3C2D */
  0x84B7,   /* U+3C2E */
  0x5949,   /* U+3C2F */
  0x9915,   /* U+3C30 */
  0x8289,   /* U+3C31 */
  0xACA6,   /* U+3C32 */
  0xA235,   /* U+3C33 */
  0x7655,   /* U+3C34 */
  0xBCBF,   /* U+3C35 */
  0xAC45,   /* U+3C36 */
  0xBC01,   /* U+3C37 */
  0x60B5,   /* U+3C38 */
  0x99B8,   /* U+3C39 */
  0x9985,   /* U+3C3A */
  0xA766,   /* U+3C3B */
  0x8291,   /* U+3C3C */
  0xA3A2,   /* U+3C3D */
  0x5122,   /* U+3C3E */
  0x979F,   /* U+3C3F */
  0x2A2D,   /* U+3C40 */
  0x8649,   /* U+3C41 */
  0x57FA,   /* U+3C42 */
  0xA9E1,   /* U+3C43 */
  0x4563,   /* U+3C44 */
  0xA8B6,   /* U+3C45 */
  0x97DC,   /* U+3C46 */
  0x821B,   /* U+3C47 */
  0x5308,   /* U+3C48 */
  0xA614,   /* U+3C49 */
  0xABC2,   /* U+3C4A */
  0x7E72,   /* U+3C4B */
  0xA5AF,   /* U+3C4C */
  0x6686,   /* U+3C4D */
  0x5B27,   /* U+3C4E */
  0xB5FD,   /* U+3C4F */
  0xBDC1,   /* U+3C50 */
  0xBDC1,   /* U+3C51 */
  0xBDC1,   /* U+3C52 */
  0xBDC1,   /* U+3C53 */
  0x9C7D,   /* U+3C54 */
  0xBDC1,   /* U+3C55 */
  0x2EEB,   /* U+3C56 */
  0x9ED1,   /* U+3C57 */
  0x1D33,   /* U+3C58 */
  0x9EEF,   /* U+3C59 */
  0x2511,   /* U+3C5A */
  0x2C5C,   /* U+3C5B */
  0xB270,   /* U+3C5C */
  0xBDC1,   /* U+3C5D */
  0xA7E6,   /* U+3C5E */
  0x7400,   /* U+3C5F */
  0x596D,   /* U+3C60 */
  0x84E6,   /* U+3C61 */
  0x5CB3,   /* U+3C62 */
  0x9155,   /* U+3C63 */
  0x976F,   /* U+3C64 */
  0x62DA,   /* U+3C65 */
  0x76DC,   /* U+3C66 */
  0x95DD,   /* U+3C67 */
  0x60D4,   /* U+3C68 */
  0x3525,   /* U+3C69 */
  0x69D4,   /* U+3C6A */
  0x5C90,   /* U+3C6B */
  0x9455,   /* U+3C6C */
  0x35BA,   /* U+3C6D */
  0x59EA,   /* U+3C6E */
  0x1C6C,   /* U+3C6F */
  0xB0F0,   /* U+3C70 */
  0x4A54,   /* U+3C71 */
  0xA87E,   /* U+3C72 */
  0x6D05,   /* U+3C73 */
  0xBC11,   /* U+3C74 */
  0x3A48,   /* U+3C75 */
  0x73BF,   /* U+3C76 */
  0xBDC1,   /* U+3C77 */
  0x2183,   /* U+3C78 */
  0x5FED,   /* U+3C79 */
  0x651A,   /* U+3C7A */
  0x677B,   /* U+3C7B */
  0x42D7,   /* U+3C7C */
  0xB53E,   /* U+3C7D */
  0x3CC8,   /* U+3C7E */
  0x7E3B,   /* U+3C7F */
  0xB509,   /* U+3C80 */
  0x5912,   /* U+3C81 */
  0x2950,   /* U+3C82 */
  0x5456,   /* U+3C83 */
  0x5687,   /* U+3C84 */
  0x4D74,   /* U+3C85 */
  0x6303,   /* U+3C86 */
  0xBDC1,   /* U+3C87 */
  0x83BA,   /* U+3C88 */
  0x7E65,   /* U+3C89 */
  0x80D8,   /* U+3C8A */
  0x2D26,   /* U+3C8B */
  0x6F36,   /* U+3C8C */
  0xB62C,   /* U+3C8D */
  0x6492,   /* U+3C8E */
  0x72F9,   /* U+3C8F */
  0xBDC1,   /* U+3C90 */
  0xBDC1,   /* U+3C91 */
  0x1F67,   /* U+3C92 */
  0x7F97,   /* U+3C93 */
  0x99B1,   /* U+3C94 */
  0x5DF0,   /* U+3C95 */
  0x9BBC,   /* U+3C96 */
  0x3B05,   /* U+3C97 */
  0x7D28,   /* U+3C98 */
  0xBDC1,   /* U+3C99 */
  0x8259,   /* U+3C9A */
  0xB6F4,   /* U+3C9B */
  0x8C52,   /* U+3C9C */
  0x7FEB,   /* U+3C9D */
  0x898C,   /* U+3C9E */
  0xAAE5,   /* U+3C9F */
  0x68CE,   /* U+3CA0 */
  0x6E43,   /* U+3CA1 */
  0x221E,   /* U+3CA2 */
  0xBDC1,   /* U+3CA3 */
  0x8794,   /* U+3CA4 */
  0x8CEB,   /* U+3CA5 */
  0x43C2,   /* U+3CA6 */
  0x81E0,   /* U+3CA7 */
  0x7FAE,   /* U+3CA8 */
  0xBDC1,   /* U+3CA9 */
  0x31A9,   /* U+3CAA */
  0x7686,   /* U+3CAB */
  0x508C,   /* U+3CAC */
  0x8C9E,   /* U+3CAD */
  0xBDC1,   /* U+3CAE */
  0x7EAA,   /* U+3CAF */
  0x70F2,   /* U+3CB0 */
  0x6209,   /* U+3CB1 */
  0x33EC,   /* U+3CB2 */
  0x339B,   /* U+3CB3 */
  0xB86A,   /* U+3CB4 */
  0xBDC1,   /* U+3CB5 */
  0x6652,   /* U+3CB6 */
  0x30AD,   /* U+3CB7 */
  0x9714,   /* U+3CB8 */
  0x41B1,   /* U+3CB9 */
  0x4C38,   /* U+3CBA */
  0x6F99,   /* U+3CBB */
  0xA791,   /* U+3CBC */
  0x700A,   /* U+3CBD */
  0xAD70,   /* U+3CBE */
  0x935E,   /* U+3CBF */
  0x42C7,   /* U+3CC0 */
  0xB200,   /* U+3CC1 */
  0xA28B,   /* U+3CC2 */
  0x2EDB,   /* U+3CC3 */
  0x99F9,   /* U+3CC4 */
  0x50AE,   /* U+3CC5 */
  0x9064,   /* U+3CC6 */
  0x3C2D,   /* U+3CC7 */
  0x735F,   /* U+3CC8 */
  0xBDC1,   /* U+3CC9 */
  0xABA9,   /* U+3CCA */
  0x7C35,   /* U+3CCB */
  0xA1C9,   /* U+3CCC */
  0x2486,   /* U+3CCD */
  0x2207,   /* U+3CCE */
  0x85FD,   /* U+3CCF */
  0xB272,   /* U+3CD0 */
  0xA7CD,   /* U+3CD1 */
  0x2208,   /* U+3CD2 */
  0xBDC1,   /* U+3CD3 */
  0x35F0,   /* U+3CD4 */
  0x5C1C,   /* U+3CD5 */
  0xA652,   /* U+3CD6 */
  0x2695,   /* U+3CD7 */
  0x2AAA,   /* U+3CD8 */
  0xA09D,   /* U+3CD9 */
  0x9FAA,   /* U+3CDA */
  0xACCC,   /* U+3CDB */
  0x9EBF,   /* U+3CDC */
  0xBDC1,   /* U+3CDD */
  0xBDC1,   /* U+3CDE */
  0xBDC1,   /* U+3CDF */
  0x8B7F,   /* U+3CE0 */
  0x425D,   /* U+3CE1 */
  0xBDC1,   /* U+3CE2 */
  0xBDC1,   /* U+3CE3 */
  0xBDC1,   /* U+3CE4 */
  0x6489,   /* U+3CE5 */
  0x9D23,   /* U+3CE6 */
  0x2853,   /* U+3CE7 */
  0x4F10,   /* U+3CE8 */
  0x8C2E,   /* U+3CE9 */
  0x74A6,   /* U+3CEA */
  0xB115,   /* U+3CEB */
  0xA064,   /* U+3CEC */
  0x9A04,   /* U+3CED */
  0x7044,   /* U+3CEE */
  0xBDC1,   /* U+3CEF */
  0xBDC1,   /* U+3CF0 */
  0xBDC1,   /* U+3CF1 */
  0xBDC1,   /* U+3CF2 */
  0xBDC1,   /* U+3CF3 */
  0x6AF6,   /* U+3CF4 */
  0x4D51,   /* U+3CF5 */
  0x716B,   /* U+3CF6 */
  0x46B6,   /* U+3CF7 */
  0x47DF,   /* U+3CF8 */
  0x936E,   /* U+3CF9 */
  0xABF5,   /* U+3CFA */
  0xB1C0,   /* U+3CFB */
  0x211A,   /* U+3CFC */
  0x6AD0,   /* U+3CFD */
  0x79BC,   /* U+3CFE */
  0x9D2B,   /* U+3CFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3C00 */
  0x0020,   /* U+3C01 */
  0x0020,   /* U+3C02 */
  0x0020,   /* U+3C03 */
  0x0020,   /* U+3C04 */
  0x0020,   /* U+3C05 */
  0x0020,   /* U+3C06 */
  0x0020,   /* U+3C07 */
  0x0020,   /* U+3C08 */
  0x0020,   /* U+3C09 */
  0x0020,   /* U+3C0A */
  0x0020,   /* U+3C0B */
  0x0020,   /* U+3C0C */
  0x0020,   /* U+3C0D */
  0x0020,   /* U+3C0E */
  0x0020,   /* U+3C0F */
  0x0020,   /* U+3C10 */
  0x0020,   /* U+3C11 */
  0x0020,   /* U+3C12 */
  0x0020,   /* U+3C13 */
  0x0020,   /* U+3C14 */
  0x0020,   /* U+3C15 */
  0x0020,   /* U+3C16 */
  0x0020,   /* U+3C17 */
  0x0020,   /* U+3C18 */
  0x0020,   /* U+3C19 */
  0x0020,   /* U+3C1A */
  0x0020,   /* U+3C1B */
  0x0020,   /* U+3C1C */
  0x0020,   /* U+3C1D */
  0x0020,   /* U+3C1E */
  0x0020,   /* U+3C1F */
  0x0020,   /* U+3C20 */
  0x0020,   /* U+3C21 */
  0x0020,   /* U+3C22 */
  0x0020,   /* U+3C23 */
  0x0020,   /* U+3C24 */
  0x0020,   /* U+3C25 */
  0x0020,   /* U+3C26 */
  0x0020,   /* U+3C27 */
  0x0020,   /* U+3C28 */
  0x0020,   /* U+3C29 */
  0x0020,   /* U+3C2A */
  0x0020,   /* U+3C2B */
  0x0020,   /* U+3C2C */
  0x0020,   /* U+3C2D */
  0x0020,   /* U+3C2E */
  0x0020,   /* U+3C2F */
  0x0020,   /* U+3C30 */
  0x0020,   /* U+3C31 */
  0x0020,   /* U+3C32 */
  0x0020,   /* U+3C33 */
  0x0020,   /* U+3C34 */
  0x0020,   /* U+3C35 */
  0x0020,   /* U+3C36 */
  0x0020,   /* U+3C37 */
  0x0020,   /* U+3C38 */
  0x0020,   /* U+3C39 */
  0x0020,   /* U+3C3A */
  0x0020,   /* U+3C3B */
  0x0020,   /* U+3C3C */
  0x0020,   /* U+3C3D */
  0x0020,   /* U+3C3E */
  0x0020,   /* U+3C3F */
  0x0020,   /* U+3C40 */
  0x0020,   /* U+3C41 */
  0x0020,   /* U+3C42 */
  0x0020,   /* U+3C43 */
  0x0020,   /* U+3C44 */
  0x0020,   /* U+3C45 */
  0x0020,   /* U+3C46 */
  0x0020,   /* U+3C47 */
  0x0020,   /* U+3C48 */
  0x0020,   /* U+3C49 */
  0x0020,   /* U+3C4A */
  0x0020,   /* U+3C4B */
  0x0020,   /* U+3C4C */
  0x0020,   /* U+3C4D */
  0x0020,   /* U+3C4E */
  0x0020,   /* U+3C4F */
  0x0020,   /* U+3C50 */
  0x0020,   /* U+3C51 */
  0x0020,   /* U+3C52 */
  0x0020,   /* U+3C53 */
  0x0020,   /* U+3C54 */
  0x0020,   /* U+3C55 */
  0x0020,   /* U+3C56 */
  0x0020,   /* U+3C57 */
  0x0020,   /* U+3C58 */
  0x0020,   /* U+3C59 */
  0x0020,   /* U+3C5A */
  0x0020,   /* U+3C5B */
  0x0020,   /* U+3C5C */
  0x0020,   /* U+3C5D */
  0x0020,   /* U+3C5E */
  0x0020,   /* U+3C5F */
  0x0020,   /* U+3C60 */
  0x0020,   /* U+3C61 */
  0x0020,   /* U+3C62 */
  0x0020,   /* U+3C63 */
  0x0020,   /* U+3C64 */
  0x0020,   /* U+3C65 */
  0x0020,   /* U+3C66 */
  0x0020,   /* U+3C67 */
  0x0020,   /* U+3C68 */
  0x0020,   /* U+3C69 */
  0x0020,   /* U+3C6A */
  0x0020,   /* U+3C6B */
  0x0020,   /* U+3C6C */
  0x0020,   /* U+3C6D */
  0x0020,   /* U+3C6E */
  0x0020,   /* U+3C6F */
  0x0020,   /* U+3C70 */
  0x0020,   /* U+3C71 */
  0x0020,   /* U+3C72 */
  0x0020,   /* U+3C73 */
  0x0020,   /* U+3C74 */
  0x0020,   /* U+3C75 */
  0x0020,   /* U+3C76 */
  0x0020,   /* U+3C77 */
  0x0020,   /* U+3C78 */
  0x0020,   /* U+3C79 */
  0x0020,   /* U+3C7A */
  0x0020,   /* U+3C7B */
  0x0020,   /* U+3C7C */
  0x0020,   /* U+3C7D */
  0x0020,   /* U+3C7E */
  0x0020,   /* U+3C7F */
  0x0020,   /* U+3C80 */
  0x0020,   /* U+3C81 */
  0x0020,   /* U+3C82 */
  0x0020,   /* U+3C83 */
  0x0020,   /* U+3C84 */
  0x0020,   /* U+3C85 */
  0x0020,   /* U+3C86 */
  0x0020,   /* U+3C87 */
  0x0020,   /* U+3C88 */
  0x0020,   /* U+3C89 */
  0x0020,   /* U+3C8A */
  0x0020,   /* U+3C8B */
  0x0020,   /* U+3C8C */
  0x0020,   /* U+3C8D */
  0x0020,   /* U+3C8E */
  0x0020,   /* U+3C8F */
  0x0020,   /* U+3C90 */
  0x0020,   /* U+3C91 */
  0x0020,   /* U+3C92 */
  0x0020,   /* U+3C93 */
  0x0020,   /* U+3C94 */
  0x0020,   /* U+3C95 */
  0x0020,   /* U+3C96 */
  0x0020,   /* U+3C97 */
  0x0020,   /* U+3C98 */
  0x0020,   /* U+3C99 */
  0x0020,   /* U+3C9A */
  0x0020,   /* U+3C9B */
  0x0020,   /* U+3C9C */
  0x0020,   /* U+3C9D */
  0x0020,   /* U+3C9E */
  0x0020,   /* U+3C9F */
  0x0020,   /* U+3CA0 */
  0x0020,   /* U+3CA1 */
  0x0020,   /* U+3CA2 */
  0x0020,   /* U+3CA3 */
  0x0020,   /* U+3CA4 */
  0x0020,   /* U+3CA5 */
  0x0020,   /* U+3CA6 */
  0x0020,   /* U+3CA7 */
  0x0020,   /* U+3CA8 */
  0x0020,   /* U+3CA9 */
  0x0020,   /* U+3CAA */
  0x0020,   /* U+3CAB */
  0x0020,   /* U+3CAC */
  0x0020,   /* U+3CAD */
  0x0020,   /* U+3CAE */
  0x0020,   /* U+3CAF */
  0x0020,   /* U+3CB0 */
  0x0020,   /* U+3CB1 */
  0x0020,   /* U+3CB2 */
  0x0020,   /* U+3CB3 */
  0x0020,   /* U+3CB4 */
  0x0020,   /* U+3CB5 */
  0x0020,   /* U+3CB6 */
  0x0020,   /* U+3CB7 */
  0x0020,   /* U+3CB8 */
  0x0020,   /* U+3CB9 */
  0x0020,   /* U+3CBA */
  0x0020,   /* U+3CBB */
  0x0020,   /* U+3CBC */
  0x0020,   /* U+3CBD */
  0x0020,   /* U+3CBE */
  0x0020,   /* U+3CBF */
  0x0020,   /* U+3CC0 */
  0x0020,   /* U+3CC1 */
  0x0020,   /* U+3CC2 */
  0x0020,   /* U+3CC3 */
  0x0020,   /* U+3CC4 */
  0x0020,   /* U+3CC5 */
  0x0020,   /* U+3CC6 */
  0x0020,   /* U+3CC7 */
  0x0020,   /* U+3CC8 */
  0x0020,   /* U+3CC9 */
  0x0020,   /* U+3CCA */
  0x0020,   /* U+3CCB */
  0x0020,   /* U+3CCC */
  0x0020,   /* U+3CCD */
  0x0020,   /* U+3CCE */
  0x0020,   /* U+3CCF */
  0x0020,   /* U+3CD0 */
  0x0020,   /* U+3CD1 */
  0x0020,   /* U+3CD2 */
  0x0020,   /* U+3CD3 */
  0x0020,   /* U+3CD4 */
  0x0020,   /* U+3CD5 */
  0x0020,   /* U+3CD6 */
  0x0020,   /* U+3CD7 */
  0x0020,   /* U+3CD8 */
  0x0020,   /* U+3CD9 */
  0x0020,   /* U+3CDA */
  0x0020,   /* U+3CDB */
  0x0020,   /* U+3CDC */
  0x0020,   /* U+3CDD */
  0x0020,   /* U+3CDE */
  0x0020,   /* U+3CDF */
  0x0020,   /* U+3CE0 */
  0x0020,   /* U+3CE1 */
  0x0020,   /* U+3CE2 */
  0x0020,   /* U+3CE3 */
  0x0020,   /* U+3CE4 */
  0x0020,   /* U+3CE5 */
  0x0020,   /* U+3CE6 */
  0x0020,   /* U+3CE7 */
  0x0020,   /* U+3CE8 */
  0x0020,   /* U+3CE9 */
  0x0020,   /* U+3CEA */
  0x0020,   /* U+3CEB */
  0x0020,   /* U+3CEC */
  0x0020,   /* U+3CED */
  0x0020,   /* U+3CEE */
  0x0020,   /* U+3CEF */
  0x0020,   /* U+3CF0 */
  0x0020,   /* U+3CF1 */
  0x0020,   /* U+3CF2 */
  0x0020,   /* U+3CF3 */
  0x0020,   /* U+3CF4 */
  0x0020,   /* U+3CF5 */
  0x0020,   /* U+3CF6 */
  0x0020,   /* U+3CF7 */
  0x0020,   /* U+3CF8 */
  0x0020,   /* U+3CF9 */
  0x0020,   /* U+3CFA */
  0x0020,   /* U+3CFB */
  0x0020,   /* U+3CFC */
  0x0020,   /* U+3CFD */
  0x0020,   /* U+3CFE */
  0x0020,   /* U+3CFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3C00 */
  0x0002,   /* U+3C01 */
  0x0002,   /* U+3C02 */
  0x0002,   /* U+3C03 */
  0x0002,   /* U+3C04 */
  0x0002,   /* U+3C05 */
  0x0002,   /* U+3C06 */
  0x0002,   /* U+3C07 */
  0x0002,   /* U+3C08 */
  0x0002,   /* U+3C09 */
  0x0002,   /* U+3C0A */
  0x0002,   /* U+3C0B */
  0x0002,   /* U+3C0C */
  0x0002,   /* U+3C0D */
  0x0002,   /* U+3C0E */
  0x0002,   /* U+3C0F */
  0x0002,   /* U+3C10 */
  0x0002,   /* U+3C11 */
  0x0002,   /* U+3C12 */
  0x0002,   /* U+3C13 */
  0x0002,   /* U+3C14 */
  0x0002,   /* U+3C15 */
  0x0002,   /* U+3C16 */
  0x0002,   /* U+3C17 */
  0x0002,   /* U+3C18 */
  0x0002,   /* U+3C19 */
  0x0002,   /* U+3C1A */
  0x0002,   /* U+3C1B */
  0x0002,   /* U+3C1C */
  0x0002,   /* U+3C1D */
  0x0002,   /* U+3C1E */
  0x0002,   /* U+3C1F */
  0x0002,   /* U+3C20 */
  0x0002,   /* U+3C21 */
  0x0002,   /* U+3C22 */
  0x0002,   /* U+3C23 */
  0x0002,   /* U+3C24 */
  0x0002,   /* U+3C25 */
  0x0002,   /* U+3C26 */
  0x0002,   /* U+3C27 */
  0x0002,   /* U+3C28 */
  0x0002,   /* U+3C29 */
  0x0002,   /* U+3C2A */
  0x0002,   /* U+3C2B */
  0x0002,   /* U+3C2C */
  0x0002,   /* U+3C2D */
  0x0002,   /* U+3C2E */
  0x0002,   /* U+3C2F */
  0x0002,   /* U+3C30 */
  0x0002,   /* U+3C31 */
  0x0002,   /* U+3C32 */
  0x0002,   /* U+3C33 */
  0x0002,   /* U+3C34 */
  0x0002,   /* U+3C35 */
  0x0002,   /* U+3C36 */
  0x0002,   /* U+3C37 */
  0x0002,   /* U+3C38 */
  0x0002,   /* U+3C39 */
  0x0002,   /* U+3C3A */
  0x0002,   /* U+3C3B */
  0x0002,   /* U+3C3C */
  0x0002,   /* U+3C3D */
  0x0002,   /* U+3C3E */
  0x0002,   /* U+3C3F */
  0x0002,   /* U+3C40 */
  0x0002,   /* U+3C41 */
  0x0002,   /* U+3C42 */
  0x0002,   /* U+3C43 */
  0x0002,   /* U+3C44 */
  0x0002,   /* U+3C45 */
  0x0002,   /* U+3C46 */
  0x0002,   /* U+3C47 */
  0x0002,   /* U+3C48 */
  0x0002,   /* U+3C49 */
  0x0002,   /* U+3C4A */
  0x0002,   /* U+3C4B */
  0x0002,   /* U+3C4C */
  0x0002,   /* U+3C4D */
  0x0002,   /* U+3C4E */
  0x0002,   /* U+3C4F */
  0x0002,   /* U+3C50 */
  0x0002,   /* U+3C51 */
  0x0002,   /* U+3C52 */
  0x0002,   /* U+3C53 */
  0x0002,   /* U+3C54 */
  0x0002,   /* U+3C55 */
  0x0002,   /* U+3C56 */
  0x0002,   /* U+3C57 */
  0x0002,   /* U+3C58 */
  0x0002,   /* U+3C59 */
  0x0002,   /* U+3C5A */
  0x0002,   /* U+3C5B */
  0x0002,   /* U+3C5C */
  0x0002,   /* U+3C5D */
  0x0002,   /* U+3C5E */
  0x0002,   /* U+3C5F */
  0x0002,   /* U+3C60 */
  0x0002,   /* U+3C61 */
  0x0002,   /* U+3C62 */
  0x0002,   /* U+3C63 */
  0x0002,   /* U+3C64 */
  0x0002,   /* U+3C65 */
  0x0002,   /* U+3C66 */
  0x0002,   /* U+3C67 */
  0x0002,   /* U+3C68 */
  0x0002,   /* U+3C69 */
  0x0002,   /* U+3C6A */
  0x0002,   /* U+3C6B */
  0x0002,   /* U+3C6C */
  0x0002,   /* U+3C6D */
  0x0002,   /* U+3C6E */
  0x0002,   /* U+3C6F */
  0x0002,   /* U+3C70 */
  0x0002,   /* U+3C71 */
  0x0002,   /* U+3C72 */
  0x0002,   /* U+3C73 */
  0x0002,   /* U+3C74 */
  0x0002,   /* U+3C75 */
  0x0002,   /* U+3C76 */
  0x0002,   /* U+3C77 */
  0x0002,   /* U+3C78 */
  0x0002,   /* U+3C79 */
  0x0002,   /* U+3C7A */
  0x0002,   /* U+3C7B */
  0x0002,   /* U+3C7C */
  0x0002,   /* U+3C7D */
  0x0002,   /* U+3C7E */
  0x0002,   /* U+3C7F */
  0x0002,   /* U+3C80 */
  0x0002,   /* U+3C81 */
  0x0002,   /* U+3C82 */
  0x0002,   /* U+3C83 */
  0x0002,   /* U+3C84 */
  0x0002,   /* U+3C85 */
  0x0002,   /* U+3C86 */
  0x0002,   /* U+3C87 */
  0x0002,   /* U+3C88 */
  0x0002,   /* U+3C89 */
  0x0002,   /* U+3C8A */
  0x0002,   /* U+3C8B */
  0x0002,   /* U+3C8C */
  0x0002,   /* U+3C8D */
  0x0002,   /* U+3C8E */
  0x0002,   /* U+3C8F */
  0x0002,   /* U+3C90 */
  0x0002,   /* U+3C91 */
  0x0002,   /* U+3C92 */
  0x0002,   /* U+3C93 */
  0x0002,   /* U+3C94 */
  0x0002,   /* U+3C95 */
  0x0002,   /* U+3C96 */
  0x0002,   /* U+3C97 */
  0x0002,   /* U+3C98 */
  0x0002,   /* U+3C99 */
  0x0002,   /* U+3C9A */
  0x0002,   /* U+3C9B */
  0x0002,   /* U+3C9C */
  0x0002,   /* U+3C9D */
  0x0002,   /* U+3C9E */
  0x0002,   /* U+3C9F */
  0x0002,   /* U+3CA0 */
  0x0002,   /* U+3CA1 */
  0x0002,   /* U+3CA2 */
  0x0002,   /* U+3CA3 */
  0x0002,   /* U+3CA4 */
  0x0002,   /* U+3CA5 */
  0x0002,   /* U+3CA6 */
  0x0002,   /* U+3CA7 */
  0x0002,   /* U+3CA8 */
  0x0002,   /* U+3CA9 */
  0x0002,   /* U+3CAA */
  0x0002,   /* U+3CAB */
  0x0002,   /* U+3CAC */
  0x0002,   /* U+3CAD */
  0x0002,   /* U+3CAE */
  0x0002,   /* U+3CAF */
  0x0002,   /* U+3CB0 */
  0x0002,   /* U+3CB1 */
  0x0002,   /* U+3CB2 */
  0x0002,   /* U+3CB3 */
  0x0002,   /* U+3CB4 */
  0x0002,   /* U+3CB5 */
  0x0002,   /* U+3CB6 */
  0x0002,   /* U+3CB7 */
  0x0002,   /* U+3CB8 */
  0x0002,   /* U+3CB9 */
  0x0002,   /* U+3CBA */
  0x0002,   /* U+3CBB */
  0x0002,   /* U+3CBC */
  0x0002,   /* U+3CBD */
  0x0002,   /* U+3CBE */
  0x0002,   /* U+3CBF */
  0x0002,   /* U+3CC0 */
  0x0002,   /* U+3CC1 */
  0x0002,   /* U+3CC2 */
  0x0002,   /* U+3CC3 */
  0x0002,   /* U+3CC4 */
  0x0002,   /* U+3CC5 */
  0x0002,   /* U+3CC6 */
  0x0002,   /* U+3CC7 */
  0x0002,   /* U+3CC8 */
  0x0002,   /* U+3CC9 */
  0x0002,   /* U+3CCA */
  0x0002,   /* U+3CCB */
  0x0002,   /* U+3CCC */
  0x0002,   /* U+3CCD */
  0x0002,   /* U+3CCE */
  0x0002,   /* U+3CCF */
  0x0002,   /* U+3CD0 */
  0x0002,   /* U+3CD1 */
  0x0002,   /* U+3CD2 */
  0x0002,   /* U+3CD3 */
  0x0002,   /* U+3CD4 */
  0x0002,   /* U+3CD5 */
  0x0002,   /* U+3CD6 */
  0x0002,   /* U+3CD7 */
  0x0002,   /* U+3CD8 */
  0x0002,   /* U+3CD9 */
  0x0002,   /* U+3CDA */
  0x0002,   /* U+3CDB */
  0x0002,   /* U+3CDC */
  0x0002,   /* U+3CDD */
  0x0002,   /* U+3CDE */
  0x0002,   /* U+3CDF */
  0x0002,   /* U+3CE0 */
  0x0002,   /* U+3CE1 */
  0x0002,   /* U+3CE2 */
  0x0002,   /* U+3CE3 */
  0x0002,   /* U+3CE4 */
  0x0002,   /* U+3CE5 */
  0x0002,   /* U+3CE6 */
  0x0002,   /* U+3CE7 */
  0x0002,   /* U+3CE8 */
  0x0002,   /* U+3CE9 */
  0x0002,   /* U+3CEA */
  0x0002,   /* U+3CEB */
  0x0002,   /* U+3CEC */
  0x0002,   /* U+3CED */
  0x0002,   /* U+3CEE */
  0x0002,   /* U+3CEF */
  0x0002,   /* U+3CF0 */
  0x0002,   /* U+3CF1 */
  0x0002,   /* U+3CF2 */
  0x0002,   /* U+3CF3 */
  0x0002,   /* U+3CF4 */
  0x0002,   /* U+3CF5 */
  0x0002,   /* U+3CF6 */
  0x0002,   /* U+3CF7 */
  0x0002,   /* U+3CF8 */
  0x0002,   /* U+3CF9 */
  0x0002,   /* U+3CFA */
  0x0002,   /* U+3CFB */
  0x0002,   /* U+3CFC */
  0x0002,   /* U+3CFD */
  0x0002,   /* U+3CFE */
  0x0002,   /* U+3CFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0xBC07,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0xBC09,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0xBC0F,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0xBC13,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0xBC15,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0xBC1C,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0xBC50,   /* U+3C50 */
  0xBC51,   /* U+3C51 */
  0xBC52,   /* U+3C52 */
  0xBC53,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0xBC55,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0xBC5D,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0xBC77,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0xBC87,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0xBC90,   /* U+3C90 */
  0xBC91,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0xBC99,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0xBCA3,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0xBCA9,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0xBCAE,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0xBCB5,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0xBCC9,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0xBCD3,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0xBCDD,   /* U+3CDD */
  0xBCDE,   /* U+3CDE */
  0xBCDF,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0xBCE2,   /* U+3CE2 */
  0xBCE3,   /* U+3CE3 */
  0xBCE4,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0xBCEF,   /* U+3CEF */
  0xBCF0,   /* U+3CF0 */
  0xBCF1,   /* U+3CF1 */
  0xBCF2,   /* U+3CF2 */
  0xBCF3,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */
};

uint16_t zh_han_p03D[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 
  1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 
  1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 

  /* Primary weight 1 for each character. */
  0x38F4,   /* U+3D00 */
  0xA81A,   /* U+3D01 */
  0x8C32,   /* U+3D02 */
  0x5DF2,   /* U+3D03 */
  0xAB78,   /* U+3D04 */
  0xBDC1,   /* U+3D05 */
  0x52DA,   /* U+3D06 */
  0x840A,   /* U+3D07 */
  0xAA07,   /* U+3D08 */
  0x4CF5,   /* U+3D09 */
  0xBDC1,   /* U+3D0A */
  0x89BC,   /* U+3D0B */
  0xBDC1,   /* U+3D0C */
  0xBDC1,   /* U+3D0D */
  0x6E3B,   /* U+3D0E */
  0x9374,   /* U+3D0F */
  0x6B84,   /* U+3D10 */
  0x89C3,   /* U+3D11 */
  0xA83F,   /* U+3D12 */
  0x82A8,   /* U+3D13 */
  0x9771,   /* U+3D14 */
  0x4C79,   /* U+3D15 */
  0x6759,   /* U+3D16 */
  0xABB3,   /* U+3D17 */
  0x691A,   /* U+3D18 */
  0xB29F,   /* U+3D19 */
  0x8A85,   /* U+3D1A */
  0xB776,   /* U+3D1B */
  0x2217,   /* U+3D1C */
  0x5E45,   /* U+3D1D */
  0xBDC1,   /* U+3D1E */
  0xBDC1,   /* U+3D1F */
  0xBDC1,   /* U+3D20 */
  0xBDC1,   /* U+3D21 */
  0xBDC1,   /* U+3D22 */
  0xBDC1,   /* U+3D23 */
  0xBDC1,   /* U+3D24 */
  0x7A8A,   /* U+3D25 */
  0x4119,   /* U+3D26 */
  0x978E,   /* U+3D27 */
  0xB585,   /* U+3D28 */
  0xAB28,   /* U+3D29 */
  0x707B,   /* U+3D2A */
  0x573B,   /* U+3D2B */
  0x9D45,   /* U+3D2C */
  0xA53C,   /* U+3D2D */
  0x9D46,   /* U+3D2E */
  0xB658,   /* U+3D2F */
  0x6F31,   /* U+3D30 */
  0xBDC1,   /* U+3D31 */
  0x8863,   /* U+3D32 */
  0x6473,   /* U+3D33 */
  0x28B8,   /* U+3D34 */
  0x6B06,   /* U+3D35 */
  0x7E4A,   /* U+3D36 */
  0x3047,   /* U+3D37 */
  0x830B,   /* U+3D38 */
  0xBDC1,   /* U+3D39 */
  0xBDC1,   /* U+3D3A */
  0xBDC1,   /* U+3D3B */
  0x89DE,   /* U+3D3C */
  0x9D4F,   /* U+3D3D */
  0x23DF,   /* U+3D3E */
  0x3415,   /* U+3D3F */
  0xBCC6,   /* U+3D40 */
  0xBDC1,   /* U+3D41 */
  0x8768,   /* U+3D42 */
  0x83F5,   /* U+3D43 */
  0x43C4,   /* U+3D44 */
  0x8C3B,   /* U+3D45 */
  0x3DDF,   /* U+3D46 */
  0xBDC1,   /* U+3D47 */
  0xBDC1,   /* U+3D48 */
  0xBDC1,   /* U+3D49 */
  0x6E0F,   /* U+3D4A */
  0x6B15,   /* U+3D4B */
  0xA179,   /* U+3D4C */
  0x69D7,   /* U+3D4D */
  0x4FAE,   /* U+3D4E */
  0x2ECD,   /* U+3D4F */
  0x569E,   /* U+3D50 */
  0x4540,   /* U+3D51 */
  0x39B8,   /* U+3D52 */
  0x85AC,   /* U+3D53 */
  0x2846,   /* U+3D54 */
  0x84CA,   /* U+3D55 */
  0x71A3,   /* U+3D56 */
  0x75C0,   /* U+3D57 */
  0x685B,   /* U+3D58 */
  0xBDC1,   /* U+3D59 */
  0xBDC1,   /* U+3D5A */
  0xBDC1,   /* U+3D5B */
  0xBDC1,   /* U+3D5C */
  0xA8B9,   /* U+3D5D */
  0x2B3F,   /* U+3D5E */
  0xBDC1,   /* U+3D5F */
  0x5985,   /* U+3D60 */
  0x1F33,   /* U+3D61 */
  0x5D84,   /* U+3D62 */
  0x588F,   /* U+3D63 */
  0x82A0,   /* U+3D64 */
  0x2174,   /* U+3D65 */
  0x8A63,   /* U+3D66 */
  0x3E6F,   /* U+3D67 */
  0x74BF,   /* U+3D68 */
  0xA8BA,   /* U+3D69 */
  0x9A30,   /* U+3D6A */
  0x6FC1,   /* U+3D6B */
  0xAAB3,   /* U+3D6C */
  0xB99F,   /* U+3D6D */
  0x2D02,   /* U+3D6E */
  0x3AB3,   /* U+3D6F */
  0xA005,   /* U+3D70 */
  0x752B,   /* U+3D71 */
  0x96A5,   /* U+3D72 */
  0x6167,   /* U+3D73 */
  0x2572,   /* U+3D74 */
  0xBCAA,   /* U+3D75 */
  0xBD77,   /* U+3D76 */
  0x222C,   /* U+3D77 */
  0xA575,   /* U+3D78 */
  0x48A8,   /* U+3D79 */
  0x7278,   /* U+3D7A */
  0x9EDC,   /* U+3D7B */
  0xBDC1,   /* U+3D7C */
  0x5DCD,   /* U+3D7D */
  0x7BD7,   /* U+3D7E */
  0x9C6B,   /* U+3D7F */
  0x509B,   /* U+3D80 */
  0x429D,   /* U+3D81 */
  0xBDC1,   /* U+3D82 */
  0xBDC1,   /* U+3D83 */
  0xA2D9,   /* U+3D84 */
  0xA0F2,   /* U+3D85 */
  0xB94F,   /* U+3D86 */
  0x4592,   /* U+3D87 */
  0xAAC5,   /* U+3D88 */
  0x97F6,   /* U+3D89 */
  0xBDC1,   /* U+3D8A */
  0xBDC1,   /* U+3D8B */
  0x609F,   /* U+3D8C */
  0x9A8A,   /* U+3D8D */
  0x48B4,   /* U+3D8E */
  0xA96E,   /* U+3D8F */
  0xBDC1,   /* U+3D90 */
  0x60ED,   /* U+3D91 */
  0x8317,   /* U+3D92 */
  0x2576,   /* U+3D93 */
  0x2000,   /* U+3D94 */
  0x4F63,   /* U+3D95 */
  0x8785,   /* U+3D96 */
  0x390F,   /* U+3D97 */
  0x3322,   /* U+3D98 */
  0xBDC1,   /* U+3D99 */
  0x1E3B,   /* U+3D9A */
  0xAD60,   /* U+3D9B */
  0xBDC1,   /* U+3D9C */
  0xBDC1,   /* U+3D9D */
  0x6E99,   /* U+3D9E */
  0x5DE4,   /* U+3D9F */
  0xA92E,   /* U+3DA0 */
  0x2FE6,   /* U+3DA1 */
  0xBDC1,   /* U+3DA2 */
  0x26C1,   /* U+3DA3 */
  0x2814,   /* U+3DA4 */
  0x3D06,   /* U+3DA5 */
  0x52C7,   /* U+3DA6 */
  0x6F26,   /* U+3DA7 */
  0xBDC1,   /* U+3DA8 */
  0xBDC1,   /* U+3DA9 */
  0xBDC1,   /* U+3DAA */
  0x618C,   /* U+3DAB */
  0x6CD2,   /* U+3DAC */
  0xAC3A,   /* U+3DAD */
  0xBDC1,   /* U+3DAE */
  0x63EC,   /* U+3DAF */
  0x4346,   /* U+3DB0 */
  0xBDC1,   /* U+3DB1 */
  0xAB9B,   /* U+3DB2 */
  0x52D2,   /* U+3DB3 */
  0x2A19,   /* U+3DB4 */
  0x7F54,   /* U+3DB5 */
  0x7137,   /* U+3DB6 */
  0xBDC1,   /* U+3DB7 */
  0xBDC1,   /* U+3DB8 */
  0x4630,   /* U+3DB9 */
  0x8EFE,   /* U+3DBA */
  0xBDC1,   /* U+3DBB */
  0x1C57,   /* U+3DBC */
  0x407D,   /* U+3DBD */
  0x2244,   /* U+3DBE */
  0x23C0,   /* U+3DBF */
  0x7BEE,   /* U+3DC0 */
  0xBDC1,   /* U+3DC1 */
  0x8759,   /* U+3DC2 */
  0x2CC8,   /* U+3DC3 */
  0x49FF,   /* U+3DC4 */
  0x281B,   /* U+3DC5 */
  0x3C52,   /* U+3DC6 */
  0x49B0,   /* U+3DC7 */
  0x376D,   /* U+3DC8 */
  0x94B3,   /* U+3DC9 */
  0x3A10,   /* U+3DCA */
  0x8C53,   /* U+3DCB */
  0xBDC1,   /* U+3DCC */
  0x66D6,   /* U+3DCD */
  0x4538,   /* U+3DCE */
  0xAB86,   /* U+3DCF */
  0x4A02,   /* U+3DD0 */
  0xBDC1,   /* U+3DD1 */
  0xAD0C,   /* U+3DD2 */
  0xBC5C,   /* U+3DD3 */
  0xA3A5,   /* U+3DD4 */
  0x7CA1,   /* U+3DD5 */
  0xB442,   /* U+3DD6 */
  0x53E2,   /* U+3DD7 */
  0x8BF6,   /* U+3DD8 */
  0xBDC1,   /* U+3DD9 */
  0xBDC1,   /* U+3DDA */
  0xBDC1,   /* U+3DDB */
  0xBDC1,   /* U+3DDC */
  0xBDC1,   /* U+3DDD */
  0xBDC1,   /* U+3DDE */
  0x9167,   /* U+3DDF */
  0x6237,   /* U+3DE0 */
  0x53E8,   /* U+3DE1 */
  0xB2A2,   /* U+3DE2 */
  0x9E22,   /* U+3DE3 */
  0x47B7,   /* U+3DE4 */
  0xBDC1,   /* U+3DE5 */
  0x9FEA,   /* U+3DE6 */
  0xBDC1,   /* U+3DE7 */
  0xBDC1,   /* U+3DE8 */
  0xBDC1,   /* U+3DE9 */
  0x2EF4,   /* U+3DEA */
  0x7BBC,   /* U+3DEB */
  0x6D07,   /* U+3DEC */
  0xBDC1,   /* U+3DED */
  0xB171,   /* U+3DEE */
  0x206D,   /* U+3DEF */
  0x29B7,   /* U+3DF0 */
  0xBDC1,   /* U+3DF1 */
  0xBDC1,   /* U+3DF2 */
  0xA3C1,   /* U+3DF3 */
  0x3E70,   /* U+3DF4 */
  0x6D10,   /* U+3DF5 */
  0x1FF6,   /* U+3DF6 */
  0x55E9,   /* U+3DF7 */
  0x33CD,   /* U+3DF8 */
  0xB453,   /* U+3DF9 */
  0xBDC1,   /* U+3DFA */
  0x9658,   /* U+3DFB */
  0xA3C2,   /* U+3DFC */
  0xBDC1,   /* U+3DFD */
  0x56B8,   /* U+3DFE */
  0x99D4,   /* U+3DFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3D00 */
  0x0020,   /* U+3D01 */
  0x0020,   /* U+3D02 */
  0x0020,   /* U+3D03 */
  0x0020,   /* U+3D04 */
  0x0020,   /* U+3D05 */
  0x0020,   /* U+3D06 */
  0x0020,   /* U+3D07 */
  0x0020,   /* U+3D08 */
  0x0020,   /* U+3D09 */
  0x0020,   /* U+3D0A */
  0x0020,   /* U+3D0B */
  0x0020,   /* U+3D0C */
  0x0020,   /* U+3D0D */
  0x0020,   /* U+3D0E */
  0x0020,   /* U+3D0F */
  0x0020,   /* U+3D10 */
  0x0020,   /* U+3D11 */
  0x0020,   /* U+3D12 */
  0x0020,   /* U+3D13 */
  0x0020,   /* U+3D14 */
  0x0020,   /* U+3D15 */
  0x0020,   /* U+3D16 */
  0x0020,   /* U+3D17 */
  0x0020,   /* U+3D18 */
  0x0020,   /* U+3D19 */
  0x0020,   /* U+3D1A */
  0x0020,   /* U+3D1B */
  0x0020,   /* U+3D1C */
  0x0020,   /* U+3D1D */
  0x0020,   /* U+3D1E */
  0x0020,   /* U+3D1F */
  0x0020,   /* U+3D20 */
  0x0020,   /* U+3D21 */
  0x0020,   /* U+3D22 */
  0x0020,   /* U+3D23 */
  0x0020,   /* U+3D24 */
  0x0020,   /* U+3D25 */
  0x0020,   /* U+3D26 */
  0x0020,   /* U+3D27 */
  0x0020,   /* U+3D28 */
  0x0020,   /* U+3D29 */
  0x0020,   /* U+3D2A */
  0x0020,   /* U+3D2B */
  0x0020,   /* U+3D2C */
  0x0020,   /* U+3D2D */
  0x0020,   /* U+3D2E */
  0x0020,   /* U+3D2F */
  0x0020,   /* U+3D30 */
  0x0020,   /* U+3D31 */
  0x0020,   /* U+3D32 */
  0x0020,   /* U+3D33 */
  0x0020,   /* U+3D34 */
  0x0020,   /* U+3D35 */
  0x0020,   /* U+3D36 */
  0x0020,   /* U+3D37 */
  0x0020,   /* U+3D38 */
  0x0020,   /* U+3D39 */
  0x0020,   /* U+3D3A */
  0x0020,   /* U+3D3B */
  0x0020,   /* U+3D3C */
  0x0020,   /* U+3D3D */
  0x0020,   /* U+3D3E */
  0x0020,   /* U+3D3F */
  0x0020,   /* U+3D40 */
  0x0020,   /* U+3D41 */
  0x0020,   /* U+3D42 */
  0x0020,   /* U+3D43 */
  0x0020,   /* U+3D44 */
  0x0020,   /* U+3D45 */
  0x0020,   /* U+3D46 */
  0x0020,   /* U+3D47 */
  0x0020,   /* U+3D48 */
  0x0020,   /* U+3D49 */
  0x0020,   /* U+3D4A */
  0x0020,   /* U+3D4B */
  0x0020,   /* U+3D4C */
  0x0020,   /* U+3D4D */
  0x0020,   /* U+3D4E */
  0x0020,   /* U+3D4F */
  0x0020,   /* U+3D50 */
  0x0020,   /* U+3D51 */
  0x0020,   /* U+3D52 */
  0x0020,   /* U+3D53 */
  0x0020,   /* U+3D54 */
  0x0020,   /* U+3D55 */
  0x0020,   /* U+3D56 */
  0x0020,   /* U+3D57 */
  0x0020,   /* U+3D58 */
  0x0020,   /* U+3D59 */
  0x0020,   /* U+3D5A */
  0x0020,   /* U+3D5B */
  0x0020,   /* U+3D5C */
  0x0020,   /* U+3D5D */
  0x0020,   /* U+3D5E */
  0x0020,   /* U+3D5F */
  0x0020,   /* U+3D60 */
  0x0020,   /* U+3D61 */
  0x0020,   /* U+3D62 */
  0x0020,   /* U+3D63 */
  0x0020,   /* U+3D64 */
  0x0020,   /* U+3D65 */
  0x0020,   /* U+3D66 */
  0x0020,   /* U+3D67 */
  0x0020,   /* U+3D68 */
  0x0020,   /* U+3D69 */
  0x0020,   /* U+3D6A */
  0x0020,   /* U+3D6B */
  0x0020,   /* U+3D6C */
  0x0020,   /* U+3D6D */
  0x0020,   /* U+3D6E */
  0x0020,   /* U+3D6F */
  0x0020,   /* U+3D70 */
  0x0020,   /* U+3D71 */
  0x0020,   /* U+3D72 */
  0x0020,   /* U+3D73 */
  0x0020,   /* U+3D74 */
  0x0020,   /* U+3D75 */
  0x0020,   /* U+3D76 */
  0x0020,   /* U+3D77 */
  0x0020,   /* U+3D78 */
  0x0020,   /* U+3D79 */
  0x0020,   /* U+3D7A */
  0x0020,   /* U+3D7B */
  0x0020,   /* U+3D7C */
  0x0020,   /* U+3D7D */
  0x0020,   /* U+3D7E */
  0x0020,   /* U+3D7F */
  0x0020,   /* U+3D80 */
  0x0020,   /* U+3D81 */
  0x0020,   /* U+3D82 */
  0x0020,   /* U+3D83 */
  0x0020,   /* U+3D84 */
  0x0020,   /* U+3D85 */
  0x0020,   /* U+3D86 */
  0x0020,   /* U+3D87 */
  0x0020,   /* U+3D88 */
  0x0020,   /* U+3D89 */
  0x0020,   /* U+3D8A */
  0x0020,   /* U+3D8B */
  0x0020,   /* U+3D8C */
  0x0020,   /* U+3D8D */
  0x0020,   /* U+3D8E */
  0x0020,   /* U+3D8F */
  0x0020,   /* U+3D90 */
  0x0020,   /* U+3D91 */
  0x0020,   /* U+3D92 */
  0x0020,   /* U+3D93 */
  0x0020,   /* U+3D94 */
  0x0020,   /* U+3D95 */
  0x0020,   /* U+3D96 */
  0x0020,   /* U+3D97 */
  0x0020,   /* U+3D98 */
  0x0020,   /* U+3D99 */
  0x0020,   /* U+3D9A */
  0x0020,   /* U+3D9B */
  0x0020,   /* U+3D9C */
  0x0020,   /* U+3D9D */
  0x0020,   /* U+3D9E */
  0x0020,   /* U+3D9F */
  0x0020,   /* U+3DA0 */
  0x0020,   /* U+3DA1 */
  0x0020,   /* U+3DA2 */
  0x0020,   /* U+3DA3 */
  0x0020,   /* U+3DA4 */
  0x0020,   /* U+3DA5 */
  0x0020,   /* U+3DA6 */
  0x0020,   /* U+3DA7 */
  0x0020,   /* U+3DA8 */
  0x0020,   /* U+3DA9 */
  0x0020,   /* U+3DAA */
  0x0020,   /* U+3DAB */
  0x0020,   /* U+3DAC */
  0x0020,   /* U+3DAD */
  0x0020,   /* U+3DAE */
  0x0020,   /* U+3DAF */
  0x0020,   /* U+3DB0 */
  0x0020,   /* U+3DB1 */
  0x0020,   /* U+3DB2 */
  0x0020,   /* U+3DB3 */
  0x0020,   /* U+3DB4 */
  0x0020,   /* U+3DB5 */
  0x0020,   /* U+3DB6 */
  0x0020,   /* U+3DB7 */
  0x0020,   /* U+3DB8 */
  0x0020,   /* U+3DB9 */
  0x0020,   /* U+3DBA */
  0x0020,   /* U+3DBB */
  0x0020,   /* U+3DBC */
  0x0020,   /* U+3DBD */
  0x0020,   /* U+3DBE */
  0x0020,   /* U+3DBF */
  0x0020,   /* U+3DC0 */
  0x0020,   /* U+3DC1 */
  0x0020,   /* U+3DC2 */
  0x0020,   /* U+3DC3 */
  0x0020,   /* U+3DC4 */
  0x0020,   /* U+3DC5 */
  0x0020,   /* U+3DC6 */
  0x0020,   /* U+3DC7 */
  0x0020,   /* U+3DC8 */
  0x0020,   /* U+3DC9 */
  0x0020,   /* U+3DCA */
  0x0020,   /* U+3DCB */
  0x0020,   /* U+3DCC */
  0x0020,   /* U+3DCD */
  0x0020,   /* U+3DCE */
  0x0020,   /* U+3DCF */
  0x0020,   /* U+3DD0 */
  0x0020,   /* U+3DD1 */
  0x0020,   /* U+3DD2 */
  0x0020,   /* U+3DD3 */
  0x0020,   /* U+3DD4 */
  0x0020,   /* U+3DD5 */
  0x0020,   /* U+3DD6 */
  0x0020,   /* U+3DD7 */
  0x0020,   /* U+3DD8 */
  0x0020,   /* U+3DD9 */
  0x0020,   /* U+3DDA */
  0x0020,   /* U+3DDB */
  0x0020,   /* U+3DDC */
  0x0020,   /* U+3DDD */
  0x0020,   /* U+3DDE */
  0x0020,   /* U+3DDF */
  0x0020,   /* U+3DE0 */
  0x0020,   /* U+3DE1 */
  0x0020,   /* U+3DE2 */
  0x0020,   /* U+3DE3 */
  0x0020,   /* U+3DE4 */
  0x0020,   /* U+3DE5 */
  0x0020,   /* U+3DE6 */
  0x0020,   /* U+3DE7 */
  0x0020,   /* U+3DE8 */
  0x0020,   /* U+3DE9 */
  0x0020,   /* U+3DEA */
  0x0020,   /* U+3DEB */
  0x0020,   /* U+3DEC */
  0x0020,   /* U+3DED */
  0x0020,   /* U+3DEE */
  0x0020,   /* U+3DEF */
  0x0020,   /* U+3DF0 */
  0x0020,   /* U+3DF1 */
  0x0020,   /* U+3DF2 */
  0x0020,   /* U+3DF3 */
  0x0020,   /* U+3DF4 */
  0x0020,   /* U+3DF5 */
  0x0020,   /* U+3DF6 */
  0x0020,   /* U+3DF7 */
  0x0020,   /* U+3DF8 */
  0x0020,   /* U+3DF9 */
  0x0020,   /* U+3DFA */
  0x0020,   /* U+3DFB */
  0x0020,   /* U+3DFC */
  0x0020,   /* U+3DFD */
  0x0020,   /* U+3DFE */
  0x0020,   /* U+3DFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3D00 */
  0x0002,   /* U+3D01 */
  0x0002,   /* U+3D02 */
  0x0002,   /* U+3D03 */
  0x0002,   /* U+3D04 */
  0x0002,   /* U+3D05 */
  0x0002,   /* U+3D06 */
  0x0002,   /* U+3D07 */
  0x0002,   /* U+3D08 */
  0x0002,   /* U+3D09 */
  0x0002,   /* U+3D0A */
  0x0002,   /* U+3D0B */
  0x0002,   /* U+3D0C */
  0x0002,   /* U+3D0D */
  0x0002,   /* U+3D0E */
  0x0002,   /* U+3D0F */
  0x0002,   /* U+3D10 */
  0x0002,   /* U+3D11 */
  0x0002,   /* U+3D12 */
  0x0002,   /* U+3D13 */
  0x0002,   /* U+3D14 */
  0x0002,   /* U+3D15 */
  0x0002,   /* U+3D16 */
  0x0002,   /* U+3D17 */
  0x0002,   /* U+3D18 */
  0x0002,   /* U+3D19 */
  0x0002,   /* U+3D1A */
  0x0002,   /* U+3D1B */
  0x0002,   /* U+3D1C */
  0x0002,   /* U+3D1D */
  0x0002,   /* U+3D1E */
  0x0002,   /* U+3D1F */
  0x0002,   /* U+3D20 */
  0x0002,   /* U+3D21 */
  0x0002,   /* U+3D22 */
  0x0002,   /* U+3D23 */
  0x0002,   /* U+3D24 */
  0x0002,   /* U+3D25 */
  0x0002,   /* U+3D26 */
  0x0002,   /* U+3D27 */
  0x0002,   /* U+3D28 */
  0x0002,   /* U+3D29 */
  0x0002,   /* U+3D2A */
  0x0002,   /* U+3D2B */
  0x0002,   /* U+3D2C */
  0x0002,   /* U+3D2D */
  0x0002,   /* U+3D2E */
  0x0002,   /* U+3D2F */
  0x0002,   /* U+3D30 */
  0x0002,   /* U+3D31 */
  0x0002,   /* U+3D32 */
  0x0002,   /* U+3D33 */
  0x0002,   /* U+3D34 */
  0x0002,   /* U+3D35 */
  0x0002,   /* U+3D36 */
  0x0002,   /* U+3D37 */
  0x0002,   /* U+3D38 */
  0x0002,   /* U+3D39 */
  0x0002,   /* U+3D3A */
  0x0002,   /* U+3D3B */
  0x0002,   /* U+3D3C */
  0x0002,   /* U+3D3D */
  0x0002,   /* U+3D3E */
  0x0002,   /* U+3D3F */
  0x0002,   /* U+3D40 */
  0x0002,   /* U+3D41 */
  0x0002,   /* U+3D42 */
  0x0002,   /* U+3D43 */
  0x0002,   /* U+3D44 */
  0x0002,   /* U+3D45 */
  0x0002,   /* U+3D46 */
  0x0002,   /* U+3D47 */
  0x0002,   /* U+3D48 */
  0x0002,   /* U+3D49 */
  0x0002,   /* U+3D4A */
  0x0002,   /* U+3D4B */
  0x0002,   /* U+3D4C */
  0x0002,   /* U+3D4D */
  0x0002,   /* U+3D4E */
  0x0002,   /* U+3D4F */
  0x0002,   /* U+3D50 */
  0x0002,   /* U+3D51 */
  0x0002,   /* U+3D52 */
  0x0002,   /* U+3D53 */
  0x0002,   /* U+3D54 */
  0x0002,   /* U+3D55 */
  0x0002,   /* U+3D56 */
  0x0002,   /* U+3D57 */
  0x0002,   /* U+3D58 */
  0x0002,   /* U+3D59 */
  0x0002,   /* U+3D5A */
  0x0002,   /* U+3D5B */
  0x0002,   /* U+3D5C */
  0x0002,   /* U+3D5D */
  0x0002,   /* U+3D5E */
  0x0002,   /* U+3D5F */
  0x0002,   /* U+3D60 */
  0x0002,   /* U+3D61 */
  0x0002,   /* U+3D62 */
  0x0002,   /* U+3D63 */
  0x0002,   /* U+3D64 */
  0x0002,   /* U+3D65 */
  0x0002,   /* U+3D66 */
  0x0002,   /* U+3D67 */
  0x0002,   /* U+3D68 */
  0x0002,   /* U+3D69 */
  0x0002,   /* U+3D6A */
  0x0002,   /* U+3D6B */
  0x0002,   /* U+3D6C */
  0x0002,   /* U+3D6D */
  0x0002,   /* U+3D6E */
  0x0002,   /* U+3D6F */
  0x0002,   /* U+3D70 */
  0x0002,   /* U+3D71 */
  0x0002,   /* U+3D72 */
  0x0002,   /* U+3D73 */
  0x0002,   /* U+3D74 */
  0x0002,   /* U+3D75 */
  0x0002,   /* U+3D76 */
  0x0002,   /* U+3D77 */
  0x0002,   /* U+3D78 */
  0x0002,   /* U+3D79 */
  0x0002,   /* U+3D7A */
  0x0002,   /* U+3D7B */
  0x0002,   /* U+3D7C */
  0x0002,   /* U+3D7D */
  0x0002,   /* U+3D7E */
  0x0002,   /* U+3D7F */
  0x0002,   /* U+3D80 */
  0x0002,   /* U+3D81 */
  0x0002,   /* U+3D82 */
  0x0002,   /* U+3D83 */
  0x0002,   /* U+3D84 */
  0x0002,   /* U+3D85 */
  0x0002,   /* U+3D86 */
  0x0002,   /* U+3D87 */
  0x0002,   /* U+3D88 */
  0x0002,   /* U+3D89 */
  0x0002,   /* U+3D8A */
  0x0002,   /* U+3D8B */
  0x0002,   /* U+3D8C */
  0x0002,   /* U+3D8D */
  0x0002,   /* U+3D8E */
  0x0002,   /* U+3D8F */
  0x0002,   /* U+3D90 */
  0x0002,   /* U+3D91 */
  0x0002,   /* U+3D92 */
  0x0002,   /* U+3D93 */
  0x0002,   /* U+3D94 */
  0x0002,   /* U+3D95 */
  0x0002,   /* U+3D96 */
  0x0002,   /* U+3D97 */
  0x0002,   /* U+3D98 */
  0x0002,   /* U+3D99 */
  0x0002,   /* U+3D9A */
  0x0002,   /* U+3D9B */
  0x0002,   /* U+3D9C */
  0x0002,   /* U+3D9D */
  0x0002,   /* U+3D9E */
  0x0002,   /* U+3D9F */
  0x0002,   /* U+3DA0 */
  0x0002,   /* U+3DA1 */
  0x0002,   /* U+3DA2 */
  0x0002,   /* U+3DA3 */
  0x0002,   /* U+3DA4 */
  0x0002,   /* U+3DA5 */
  0x0002,   /* U+3DA6 */
  0x0002,   /* U+3DA7 */
  0x0002,   /* U+3DA8 */
  0x0002,   /* U+3DA9 */
  0x0002,   /* U+3DAA */
  0x0002,   /* U+3DAB */
  0x0002,   /* U+3DAC */
  0x0002,   /* U+3DAD */
  0x0002,   /* U+3DAE */
  0x0002,   /* U+3DAF */
  0x0002,   /* U+3DB0 */
  0x0002,   /* U+3DB1 */
  0x0002,   /* U+3DB2 */
  0x0002,   /* U+3DB3 */
  0x0002,   /* U+3DB4 */
  0x0002,   /* U+3DB5 */
  0x0002,   /* U+3DB6 */
  0x0002,   /* U+3DB7 */
  0x0002,   /* U+3DB8 */
  0x0002,   /* U+3DB9 */
  0x0002,   /* U+3DBA */
  0x0002,   /* U+3DBB */
  0x0002,   /* U+3DBC */
  0x0002,   /* U+3DBD */
  0x0002,   /* U+3DBE */
  0x0002,   /* U+3DBF */
  0x0002,   /* U+3DC0 */
  0x0002,   /* U+3DC1 */
  0x0002,   /* U+3DC2 */
  0x0002,   /* U+3DC3 */
  0x0002,   /* U+3DC4 */
  0x0002,   /* U+3DC5 */
  0x0002,   /* U+3DC6 */
  0x0002,   /* U+3DC7 */
  0x0002,   /* U+3DC8 */
  0x0002,   /* U+3DC9 */
  0x0002,   /* U+3DCA */
  0x0002,   /* U+3DCB */
  0x0002,   /* U+3DCC */
  0x0002,   /* U+3DCD */
  0x0002,   /* U+3DCE */
  0x0002,   /* U+3DCF */
  0x0002,   /* U+3DD0 */
  0x0002,   /* U+3DD1 */
  0x0002,   /* U+3DD2 */
  0x0002,   /* U+3DD3 */
  0x0002,   /* U+3DD4 */
  0x0002,   /* U+3DD5 */
  0x0002,   /* U+3DD6 */
  0x0002,   /* U+3DD7 */
  0x0002,   /* U+3DD8 */
  0x0002,   /* U+3DD9 */
  0x0002,   /* U+3DDA */
  0x0002,   /* U+3DDB */
  0x0002,   /* U+3DDC */
  0x0002,   /* U+3DDD */
  0x0002,   /* U+3DDE */
  0x0002,   /* U+3DDF */
  0x0002,   /* U+3DE0 */
  0x0002,   /* U+3DE1 */
  0x0002,   /* U+3DE2 */
  0x0002,   /* U+3DE3 */
  0x0002,   /* U+3DE4 */
  0x0002,   /* U+3DE5 */
  0x0002,   /* U+3DE6 */
  0x0002,   /* U+3DE7 */
  0x0002,   /* U+3DE8 */
  0x0002,   /* U+3DE9 */
  0x0002,   /* U+3DEA */
  0x0002,   /* U+3DEB */
  0x0002,   /* U+3DEC */
  0x0002,   /* U+3DED */
  0x0002,   /* U+3DEE */
  0x0002,   /* U+3DEF */
  0x0002,   /* U+3DF0 */
  0x0002,   /* U+3DF1 */
  0x0002,   /* U+3DF2 */
  0x0002,   /* U+3DF3 */
  0x0002,   /* U+3DF4 */
  0x0002,   /* U+3DF5 */
  0x0002,   /* U+3DF6 */
  0x0002,   /* U+3DF7 */
  0x0002,   /* U+3DF8 */
  0x0002,   /* U+3DF9 */
  0x0002,   /* U+3DFA */
  0x0002,   /* U+3DFB */
  0x0002,   /* U+3DFC */
  0x0002,   /* U+3DFD */
  0x0002,   /* U+3DFE */
  0x0002,   /* U+3DFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0xBD05,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0xBD0A,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0xBD0C,   /* U+3D0C */
  0xBD0D,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0xBD1E,   /* U+3D1E */
  0xBD1F,   /* U+3D1F */
  0xBD20,   /* U+3D20 */
  0xBD21,   /* U+3D21 */
  0xBD22,   /* U+3D22 */
  0xBD23,   /* U+3D23 */
  0xBD24,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0xBD31,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0xBD39,   /* U+3D39 */
  0xBD3A,   /* U+3D3A */
  0xBD3B,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0xBD41,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0xBD47,   /* U+3D47 */
  0xBD48,   /* U+3D48 */
  0xBD49,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0xBD59,   /* U+3D59 */
  0xBD5A,   /* U+3D5A */
  0xBD5B,   /* U+3D5B */
  0xBD5C,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0xBD5F,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0xBD7C,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0xBD82,   /* U+3D82 */
  0xBD83,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0xBD8A,   /* U+3D8A */
  0xBD8B,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0xBD90,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0xBD99,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0xBD9C,   /* U+3D9C */
  0xBD9D,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0xBDA2,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0xBDA8,   /* U+3DA8 */
  0xBDA9,   /* U+3DA9 */
  0xBDAA,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0xBDAE,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0xBDB1,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0xBDB7,   /* U+3DB7 */
  0xBDB8,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0xBDBB,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0xBDC1,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0xBDCC,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0xBDD1,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0xBDD9,   /* U+3DD9 */
  0xBDDA,   /* U+3DDA */
  0xBDDB,   /* U+3DDB */
  0xBDDC,   /* U+3DDC */
  0xBDDD,   /* U+3DDD */
  0xBDDE,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0xBDE5,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0xBDE7,   /* U+3DE7 */
  0xBDE8,   /* U+3DE8 */
  0xBDE9,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0xBDED,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0xBDF1,   /* U+3DF1 */
  0xBDF2,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0xBDFA,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0xBDFD,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */
};

uint16_t zh_han_p03E[] = {
  /* Number of CEs for each character. */
  1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 
  1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 
  1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x8C07,   /* U+3E00 */
  0x4386,   /* U+3E01 */
  0xBDC1,   /* U+3E02 */
  0x32EB,   /* U+3E03 */
  0x4DAE,   /* U+3E04 */
  0x5207,   /* U+3E05 */
  0xBDC1,   /* U+3E06 */
  0xBD08,   /* U+3E07 */
  0xBDC1,   /* U+3E08 */
  0x9D8F,   /* U+3E09 */
  0x5C10,   /* U+3E0A */
  0x38C2,   /* U+3E0B */
  0x4B75,   /* U+3E0C */
  0x9901,   /* U+3E0D */
  0x70B8,   /* U+3E0E */
  0x6AB5,   /* U+3E0F */
  0x7EB1,   /* U+3E10 */
  0x2EAF,   /* U+3E11 */
  0xA97C,   /* U+3E12 */
  0x6AED,   /* U+3E13 */
  0xBDC1,   /* U+3E14 */
  0x5694,   /* U+3E15 */
  0x7CD9,   /* U+3E16 */
  0x8FFD,   /* U+3E17 */
  0x9324,   /* U+3E18 */
  0xB45E,   /* U+3E19 */
  0x5EDA,   /* U+3E1A */
  0x83B4,   /* U+3E1B */
  0x5929,   /* U+3E1C */
  0x99A3,   /* U+3E1D */
  0xB46F,   /* U+3E1E */
  0xB642,   /* U+3E1F */
  0x8F40,   /* U+3E20 */
  0x86C7,   /* U+3E21 */
  0x1FE7,   /* U+3E22 */
  0xA616,   /* U+3E23 */
  0x7505,   /* U+3E24 */
  0x276F,   /* U+3E25 */
  0x4778,   /* U+3E26 */
  0x58E0,   /* U+3E27 */
  0x53FC,   /* U+3E28 */
  0x1CD1,   /* U+3E29 */
  0x2CE8,   /* U+3E2A */
  0x791E,   /* U+3E2B */
  0x1FBC,   /* U+3E2C */
  0x1DDE,   /* U+3E2D */
  0x3A03,   /* U+3E2E */
  0x5840,   /* U+3E2F */
  0x91E2,   /* U+3E30 */
  0x91E3,   /* U+3E31 */
  0xBD7A,   /* U+3E32 */
  0x62B5,   /* U+3E33 */
  0xBDC1,   /* U+3E34 */
  0x41C8,   /* U+3E35 */
  0xA251,   /* U+3E36 */
  0x8619,   /* U+3E37 */
  0x467D,   /* U+3E38 */
  0x61DA,   /* U+3E39 */
  0x825B,   /* U+3E3A */
  0x88C3,   /* U+3E3B */
  0xBDC1,   /* U+3E3C */
  0x1FCE,   /* U+3E3D */
  0x7F5A,   /* U+3E3E */
  0x3522,   /* U+3E3F */
  0x23C1,   /* U+3E40 */
  0x6100,   /* U+3E41 */
  0x796A,   /* U+3E42 */
  0x39AA,   /* U+3E43 */
  0x4D78,   /* U+3E44 */
  0xBC5D,   /* U+3E45 */
  0x49B9,   /* U+3E46 */
  0x44F0,   /* U+3E47 */
  0x5E4B,   /* U+3E48 */
  0xAF2E,   /* U+3E49 */
  0xAFC9,   /* U+3E4A */
  0x9ED2,   /* U+3E4B */
  0x2738,   /* U+3E4C */
  0x321D,   /* U+3E4D */
  0x5D7F,   /* U+3E4E */
  0x52B0,   /* U+3E4F */
  0x2ADF,   /* U+3E50 */
  0x88E0,   /* U+3E51 */
  0x76AD,   /* U+3E52 */
  0xA54A,   /* U+3E53 */
  0x5013,   /* U+3E54 */
  0x4870,   /* U+3E55 */
  0x4901,   /* U+3E56 */
  0x8D5E,   /* U+3E57 */
  0x807D,   /* U+3E58 */
  0x9598,   /* U+3E59 */
  0xAACF,   /* U+3E5A */
  0x7EFE,   /* U+3E5B */
  0xA97D,   /* U+3E5C */
  0x85F5,   /* U+3E5D */
  0xA977,   /* U+3E5E */
  0x5646,   /* U+3E5F */
  0x9183,   /* U+3E60 */
  0xA061,   /* U+3E61 */
  0x4DEA,   /* U+3E62 */
  0xB82E,   /* U+3E63 */
  0x7AB3,   /* U+3E64 */
  0xB9B8,   /* U+3E65 */
  0x332E,   /* U+3E66 */
  0xBDC1,   /* U+3E67 */
  0xAC70,   /* U+3E68 */
  0xBDC1,   /* U+3E69 */
  0xBDC1,   /* U+3E6A */
  0xA6BB,   /* U+3E6B */
  0x85CE,   /* U+3E6C */
  0xA7E8,   /* U+3E6D */
  0x6CD3,   /* U+3E6E */
  0xBDC1,   /* U+3E6F */
  0xBDC1,   /* U+3E70 */
  0x7E3C,   /* U+3E71 */
  0x9BB4,   /* U+3E72 */
  0x9641,   /* U+3E73 */
  0x3EB5,   /* U+3E74 */
  0xAADD,   /* U+3E75 */
  0x8F95,   /* U+3E76 */
  0x85D0,   /* U+3E77 */
  0x6F43,   /* U+3E78 */
  0x3EB8,   /* U+3E79 */
  0x8B8C,   /* U+3E7A */
  0x95AA,   /* U+3E7B */
  0x54E0,   /* U+3E7C */
  0x2721,   /* U+3E7D */
  0x7528,   /* U+3E7E */
  0xBB09,   /* U+3E7F */
  0x46B7,   /* U+3E80 */
  0x6EDD,   /* U+3E81 */
  0xA2AD,   /* U+3E82 */
  0x3F96,   /* U+3E83 */
  0xAD90,   /* U+3E84 */
  0x4657,   /* U+3E85 */
  0xBDC1,   /* U+3E86 */
  0x8864,   /* U+3E87 */
  0x29AD,   /* U+3E88 */
  0x47AC,   /* U+3E89 */
  0xA488,   /* U+3E8A */
  0x957B,   /* U+3E8B */
  0x9ACE,   /* U+3E8C */
  0x7565,   /* U+3E8D */
  0x7FB2,   /* U+3E8E */
  0x64AB,   /* U+3E8F */
  0x5D34,   /* U+3E90 */
  0x82E5,   /* U+3E91 */
  0x9BD9,   /* U+3E92 */
  0xB1D1,   /* U+3E93 */
  0x430F,   /* U+3E94 */
  0x38AB,   /* U+3E95 */
  0x4384,   /* U+3E96 */
  0x26B6,   /* U+3E97 */
  0xB39C,   /* U+3E98 */
  0xBDC1,   /* U+3E99 */
  0x8B71,   /* U+3E9A */
  0xB9F5,   /* U+3E9B */
  0x7140,   /* U+3E9C */
  0x43DC,   /* U+3E9D */
  0xAD3B,   /* U+3E9E */
  0xBB39,   /* U+3E9F */
  0xAC91,   /* U+3EA0 */
  0x5FDD,   /* U+3EA1 */
  0x4B6A,   /* U+3EA2 */
  0x980A,   /* U+3EA3 */
  0x99E6,   /* U+3EA4 */
  0x26F9,   /* U+3EA5 */
  0x60A0,   /* U+3EA6 */
  0xBDC1,   /* U+3EA7 */
  0x8846,   /* U+3EA8 */
  0x543F,   /* U+3EA9 */
  0x7673,   /* U+3EAA */
  0x7C63,   /* U+3EAB */
  0x3F3F,   /* U+3EAC */
  0xBBD4,   /* U+3EAD */
  0xACC0,   /* U+3EAE */
  0xBDC1,   /* U+3EAF */
  0xBDC1,   /* U+3EB0 */
  0x7F77,   /* U+3EB1 */
  0x7120,   /* U+3EB2 */
  0x6946,   /* U+3EB3 */
  0x1DDF,   /* U+3EB4 */
  0x5422,   /* U+3EB5 */
  0xBDC1,   /* U+3EB6 */
  0x9FAB,   /* U+3EB7 */
  0x75A5,   /* U+3EB8 */
  0x220E,   /* U+3EB9 */
  0x6903,   /* U+3EBA */
  0xBDC1,   /* U+3EBB */
  0xBDC1,   /* U+3EBC */
  0xBDC1,   /* U+3EBD */
  0xBDC1,   /* U+3EBE */
  0xA6D0,   /* U+3EBF */
  0xACDB,   /* U+3EC0 */
  0xBDC1,   /* U+3EC1 */
  0x75A6,   /* U+3EC2 */
  0x7CDD,   /* U+3EC3 */
  0x1F44,   /* U+3EC4 */
  0x4A2E,   /* U+3EC5 */
  0xBDC1,   /* U+3EC6 */
  0xBDC1,   /* U+3EC7 */
  0xBDC1,   /* U+3EC8 */
  0x2496,   /* U+3EC9 */
  0x6886,   /* U+3ECA */
  0x5B8E,   /* U+3ECB */
  0x90B6,   /* U+3ECC */
  0x9646,   /* U+3ECD */
  0x5F54,   /* U+3ECE */
  0x62CD,   /* U+3ECF */
  0xBDC1,   /* U+3ED0 */
  0x4D59,   /* U+3ED1 */
  0x5734,   /* U+3ED2 */
  0xBC8C,   /* U+3ED3 */
  0x369F,   /* U+3ED4 */
  0x567D,   /* U+3ED5 */
  0x300C,   /* U+3ED6 */
  0x1FDF,   /* U+3ED7 */
  0xBDC1,   /* U+3ED8 */
  0xBDC1,   /* U+3ED9 */
  0xBDC1,   /* U+3EDA */
  0xBDC1,   /* U+3EDB */
  0xBDC1,   /* U+3EDC */
  0x5B97,   /* U+3EDD */
  0x22E7,   /* U+3EDE */
  0x8A61,   /* U+3EDF */
  0x90C3,   /* U+3EE0 */
  0xA0D1,   /* U+3EE1 */
  0xBDC1,   /* U+3EE2 */
  0xBDC1,   /* U+3EE3 */
  0xBDC1,   /* U+3EE4 */
  0xBDC1,   /* U+3EE5 */
  0xBDC1,   /* U+3EE6 */
  0x36DB,   /* U+3EE7 */
  0xBDC1,   /* U+3EE8 */
  0xBDC1,   /* U+3EE9 */
  0x8A8F,   /* U+3EEA */
  0x2163,   /* U+3EEB */
  0x909B,   /* U+3EEC */
  0x820A,   /* U+3EED */
  0x254D,   /* U+3EEE */
  0x90D4,   /* U+3EEF */
  0x6B74,   /* U+3EF0 */
  0x5282,   /* U+3EF1 */
  0x6630,   /* U+3EF2 */
  0xBDC1,   /* U+3EF3 */
  0xBDC1,   /* U+3EF4 */
  0xB3A1,   /* U+3EF5 */
  0x20C3,   /* U+3EF6 */
  0x4CAE,   /* U+3EF7 */
  0xB21B,   /* U+3EF8 */
  0xA04B,   /* U+3EF9 */
  0x5FAF,   /* U+3EFA */
  0xBDC1,   /* U+3EFB */
  0xBDC1,   /* U+3EFC */
  0x8AA5,   /* U+3EFD */
  0xAB42,   /* U+3EFE */
  0x8726,   /* U+3EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3E00 */
  0x0020,   /* U+3E01 */
  0x0020,   /* U+3E02 */
  0x0020,   /* U+3E03 */
  0x0020,   /* U+3E04 */
  0x0020,   /* U+3E05 */
  0x0020,   /* U+3E06 */
  0x0020,   /* U+3E07 */
  0x0020,   /* U+3E08 */
  0x0020,   /* U+3E09 */
  0x0020,   /* U+3E0A */
  0x0020,   /* U+3E0B */
  0x0020,   /* U+3E0C */
  0x0020,   /* U+3E0D */
  0x0020,   /* U+3E0E */
  0x0020,   /* U+3E0F */
  0x0020,   /* U+3E10 */
  0x0020,   /* U+3E11 */
  0x0020,   /* U+3E12 */
  0x0020,   /* U+3E13 */
  0x0020,   /* U+3E14 */
  0x0020,   /* U+3E15 */
  0x0020,   /* U+3E16 */
  0x0020,   /* U+3E17 */
  0x0020,   /* U+3E18 */
  0x0020,   /* U+3E19 */
  0x0020,   /* U+3E1A */
  0x0020,   /* U+3E1B */
  0x0020,   /* U+3E1C */
  0x0020,   /* U+3E1D */
  0x0020,   /* U+3E1E */
  0x0020,   /* U+3E1F */
  0x0020,   /* U+3E20 */
  0x0020,   /* U+3E21 */
  0x0020,   /* U+3E22 */
  0x0020,   /* U+3E23 */
  0x0020,   /* U+3E24 */
  0x0020,   /* U+3E25 */
  0x0020,   /* U+3E26 */
  0x0020,   /* U+3E27 */
  0x0020,   /* U+3E28 */
  0x0020,   /* U+3E29 */
  0x0020,   /* U+3E2A */
  0x0020,   /* U+3E2B */
  0x0020,   /* U+3E2C */
  0x0020,   /* U+3E2D */
  0x0020,   /* U+3E2E */
  0x0020,   /* U+3E2F */
  0x0020,   /* U+3E30 */
  0x0020,   /* U+3E31 */
  0x0020,   /* U+3E32 */
  0x0020,   /* U+3E33 */
  0x0020,   /* U+3E34 */
  0x0020,   /* U+3E35 */
  0x0020,   /* U+3E36 */
  0x0020,   /* U+3E37 */
  0x0020,   /* U+3E38 */
  0x0020,   /* U+3E39 */
  0x0020,   /* U+3E3A */
  0x0020,   /* U+3E3B */
  0x0020,   /* U+3E3C */
  0x0020,   /* U+3E3D */
  0x0020,   /* U+3E3E */
  0x0020,   /* U+3E3F */
  0x0020,   /* U+3E40 */
  0x0020,   /* U+3E41 */
  0x0020,   /* U+3E42 */
  0x0020,   /* U+3E43 */
  0x0020,   /* U+3E44 */
  0x0020,   /* U+3E45 */
  0x0020,   /* U+3E46 */
  0x0020,   /* U+3E47 */
  0x0020,   /* U+3E48 */
  0x0020,   /* U+3E49 */
  0x0020,   /* U+3E4A */
  0x0020,   /* U+3E4B */
  0x0020,   /* U+3E4C */
  0x0020,   /* U+3E4D */
  0x0020,   /* U+3E4E */
  0x0020,   /* U+3E4F */
  0x0020,   /* U+3E50 */
  0x0020,   /* U+3E51 */
  0x0020,   /* U+3E52 */
  0x0020,   /* U+3E53 */
  0x0020,   /* U+3E54 */
  0x0020,   /* U+3E55 */
  0x0020,   /* U+3E56 */
  0x0020,   /* U+3E57 */
  0x0020,   /* U+3E58 */
  0x0020,   /* U+3E59 */
  0x0020,   /* U+3E5A */
  0x0020,   /* U+3E5B */
  0x0020,   /* U+3E5C */
  0x0020,   /* U+3E5D */
  0x0020,   /* U+3E5E */
  0x0020,   /* U+3E5F */
  0x0020,   /* U+3E60 */
  0x0020,   /* U+3E61 */
  0x0020,   /* U+3E62 */
  0x0020,   /* U+3E63 */
  0x0020,   /* U+3E64 */
  0x0020,   /* U+3E65 */
  0x0020,   /* U+3E66 */
  0x0020,   /* U+3E67 */
  0x0020,   /* U+3E68 */
  0x0020,   /* U+3E69 */
  0x0020,   /* U+3E6A */
  0x0020,   /* U+3E6B */
  0x0020,   /* U+3E6C */
  0x0020,   /* U+3E6D */
  0x0020,   /* U+3E6E */
  0x0020,   /* U+3E6F */
  0x0020,   /* U+3E70 */
  0x0020,   /* U+3E71 */
  0x0020,   /* U+3E72 */
  0x0020,   /* U+3E73 */
  0x0020,   /* U+3E74 */
  0x0020,   /* U+3E75 */
  0x0020,   /* U+3E76 */
  0x0020,   /* U+3E77 */
  0x0020,   /* U+3E78 */
  0x0020,   /* U+3E79 */
  0x0020,   /* U+3E7A */
  0x0020,   /* U+3E7B */
  0x0020,   /* U+3E7C */
  0x0020,   /* U+3E7D */
  0x0020,   /* U+3E7E */
  0x0020,   /* U+3E7F */
  0x0020,   /* U+3E80 */
  0x0020,   /* U+3E81 */
  0x0020,   /* U+3E82 */
  0x0020,   /* U+3E83 */
  0x0020,   /* U+3E84 */
  0x0020,   /* U+3E85 */
  0x0020,   /* U+3E86 */
  0x0020,   /* U+3E87 */
  0x0020,   /* U+3E88 */
  0x0020,   /* U+3E89 */
  0x0020,   /* U+3E8A */
  0x0020,   /* U+3E8B */
  0x0020,   /* U+3E8C */
  0x0020,   /* U+3E8D */
  0x0020,   /* U+3E8E */
  0x0020,   /* U+3E8F */
  0x0020,   /* U+3E90 */
  0x0020,   /* U+3E91 */
  0x0020,   /* U+3E92 */
  0x0020,   /* U+3E93 */
  0x0020,   /* U+3E94 */
  0x0020,   /* U+3E95 */
  0x0020,   /* U+3E96 */
  0x0020,   /* U+3E97 */
  0x0020,   /* U+3E98 */
  0x0020,   /* U+3E99 */
  0x0020,   /* U+3E9A */
  0x0020,   /* U+3E9B */
  0x0020,   /* U+3E9C */
  0x0020,   /* U+3E9D */
  0x0020,   /* U+3E9E */
  0x0020,   /* U+3E9F */
  0x0020,   /* U+3EA0 */
  0x0020,   /* U+3EA1 */
  0x0020,   /* U+3EA2 */
  0x0020,   /* U+3EA3 */
  0x0020,   /* U+3EA4 */
  0x0020,   /* U+3EA5 */
  0x0020,   /* U+3EA6 */
  0x0020,   /* U+3EA7 */
  0x0020,   /* U+3EA8 */
  0x0020,   /* U+3EA9 */
  0x0020,   /* U+3EAA */
  0x0020,   /* U+3EAB */
  0x0020,   /* U+3EAC */
  0x0020,   /* U+3EAD */
  0x0020,   /* U+3EAE */
  0x0020,   /* U+3EAF */
  0x0020,   /* U+3EB0 */
  0x0020,   /* U+3EB1 */
  0x0020,   /* U+3EB2 */
  0x0020,   /* U+3EB3 */
  0x0020,   /* U+3EB4 */
  0x0020,   /* U+3EB5 */
  0x0020,   /* U+3EB6 */
  0x0020,   /* U+3EB7 */
  0x0020,   /* U+3EB8 */
  0x0020,   /* U+3EB9 */
  0x0020,   /* U+3EBA */
  0x0020,   /* U+3EBB */
  0x0020,   /* U+3EBC */
  0x0020,   /* U+3EBD */
  0x0020,   /* U+3EBE */
  0x0020,   /* U+3EBF */
  0x0020,   /* U+3EC0 */
  0x0020,   /* U+3EC1 */
  0x0020,   /* U+3EC2 */
  0x0020,   /* U+3EC3 */
  0x0020,   /* U+3EC4 */
  0x0020,   /* U+3EC5 */
  0x0020,   /* U+3EC6 */
  0x0020,   /* U+3EC7 */
  0x0020,   /* U+3EC8 */
  0x0020,   /* U+3EC9 */
  0x0020,   /* U+3ECA */
  0x0020,   /* U+3ECB */
  0x0020,   /* U+3ECC */
  0x0020,   /* U+3ECD */
  0x0020,   /* U+3ECE */
  0x0020,   /* U+3ECF */
  0x0020,   /* U+3ED0 */
  0x0020,   /* U+3ED1 */
  0x0020,   /* U+3ED2 */
  0x0020,   /* U+3ED3 */
  0x0020,   /* U+3ED4 */
  0x0020,   /* U+3ED5 */
  0x0020,   /* U+3ED6 */
  0x0020,   /* U+3ED7 */
  0x0020,   /* U+3ED8 */
  0x0020,   /* U+3ED9 */
  0x0020,   /* U+3EDA */
  0x0020,   /* U+3EDB */
  0x0020,   /* U+3EDC */
  0x0020,   /* U+3EDD */
  0x0020,   /* U+3EDE */
  0x0020,   /* U+3EDF */
  0x0020,   /* U+3EE0 */
  0x0020,   /* U+3EE1 */
  0x0020,   /* U+3EE2 */
  0x0020,   /* U+3EE3 */
  0x0020,   /* U+3EE4 */
  0x0020,   /* U+3EE5 */
  0x0020,   /* U+3EE6 */
  0x0020,   /* U+3EE7 */
  0x0020,   /* U+3EE8 */
  0x0020,   /* U+3EE9 */
  0x0020,   /* U+3EEA */
  0x0020,   /* U+3EEB */
  0x0020,   /* U+3EEC */
  0x0020,   /* U+3EED */
  0x0020,   /* U+3EEE */
  0x0020,   /* U+3EEF */
  0x0020,   /* U+3EF0 */
  0x0020,   /* U+3EF1 */
  0x0020,   /* U+3EF2 */
  0x0020,   /* U+3EF3 */
  0x0020,   /* U+3EF4 */
  0x0020,   /* U+3EF5 */
  0x0020,   /* U+3EF6 */
  0x0020,   /* U+3EF7 */
  0x0020,   /* U+3EF8 */
  0x0020,   /* U+3EF9 */
  0x0020,   /* U+3EFA */
  0x0020,   /* U+3EFB */
  0x0020,   /* U+3EFC */
  0x0020,   /* U+3EFD */
  0x0020,   /* U+3EFE */
  0x0020,   /* U+3EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3E00 */
  0x0002,   /* U+3E01 */
  0x0002,   /* U+3E02 */
  0x0002,   /* U+3E03 */
  0x0002,   /* U+3E04 */
  0x0002,   /* U+3E05 */
  0x0002,   /* U+3E06 */
  0x0002,   /* U+3E07 */
  0x0002,   /* U+3E08 */
  0x0002,   /* U+3E09 */
  0x0002,   /* U+3E0A */
  0x0002,   /* U+3E0B */
  0x0002,   /* U+3E0C */
  0x0002,   /* U+3E0D */
  0x0002,   /* U+3E0E */
  0x0002,   /* U+3E0F */
  0x0002,   /* U+3E10 */
  0x0002,   /* U+3E11 */
  0x0002,   /* U+3E12 */
  0x0002,   /* U+3E13 */
  0x0002,   /* U+3E14 */
  0x0002,   /* U+3E15 */
  0x0002,   /* U+3E16 */
  0x0002,   /* U+3E17 */
  0x0002,   /* U+3E18 */
  0x0002,   /* U+3E19 */
  0x0002,   /* U+3E1A */
  0x0002,   /* U+3E1B */
  0x0002,   /* U+3E1C */
  0x0002,   /* U+3E1D */
  0x0002,   /* U+3E1E */
  0x0002,   /* U+3E1F */
  0x0002,   /* U+3E20 */
  0x0002,   /* U+3E21 */
  0x0002,   /* U+3E22 */
  0x0002,   /* U+3E23 */
  0x0002,   /* U+3E24 */
  0x0002,   /* U+3E25 */
  0x0002,   /* U+3E26 */
  0x0002,   /* U+3E27 */
  0x0002,   /* U+3E28 */
  0x0002,   /* U+3E29 */
  0x0002,   /* U+3E2A */
  0x0002,   /* U+3E2B */
  0x0002,   /* U+3E2C */
  0x0002,   /* U+3E2D */
  0x0002,   /* U+3E2E */
  0x0002,   /* U+3E2F */
  0x0002,   /* U+3E30 */
  0x0002,   /* U+3E31 */
  0x0002,   /* U+3E32 */
  0x0002,   /* U+3E33 */
  0x0002,   /* U+3E34 */
  0x0002,   /* U+3E35 */
  0x0002,   /* U+3E36 */
  0x0002,   /* U+3E37 */
  0x0002,   /* U+3E38 */
  0x0002,   /* U+3E39 */
  0x0002,   /* U+3E3A */
  0x0002,   /* U+3E3B */
  0x0002,   /* U+3E3C */
  0x0002,   /* U+3E3D */
  0x0002,   /* U+3E3E */
  0x0002,   /* U+3E3F */
  0x0002,   /* U+3E40 */
  0x0002,   /* U+3E41 */
  0x0002,   /* U+3E42 */
  0x0002,   /* U+3E43 */
  0x0002,   /* U+3E44 */
  0x0002,   /* U+3E45 */
  0x0002,   /* U+3E46 */
  0x0002,   /* U+3E47 */
  0x0002,   /* U+3E48 */
  0x0002,   /* U+3E49 */
  0x0002,   /* U+3E4A */
  0x0002,   /* U+3E4B */
  0x0002,   /* U+3E4C */
  0x0002,   /* U+3E4D */
  0x0002,   /* U+3E4E */
  0x0002,   /* U+3E4F */
  0x0002,   /* U+3E50 */
  0x0002,   /* U+3E51 */
  0x0002,   /* U+3E52 */
  0x0002,   /* U+3E53 */
  0x0002,   /* U+3E54 */
  0x0002,   /* U+3E55 */
  0x0002,   /* U+3E56 */
  0x0002,   /* U+3E57 */
  0x0002,   /* U+3E58 */
  0x0002,   /* U+3E59 */
  0x0002,   /* U+3E5A */
  0x0002,   /* U+3E5B */
  0x0002,   /* U+3E5C */
  0x0002,   /* U+3E5D */
  0x0002,   /* U+3E5E */
  0x0002,   /* U+3E5F */
  0x0002,   /* U+3E60 */
  0x0002,   /* U+3E61 */
  0x0002,   /* U+3E62 */
  0x0002,   /* U+3E63 */
  0x0002,   /* U+3E64 */
  0x0002,   /* U+3E65 */
  0x0002,   /* U+3E66 */
  0x0002,   /* U+3E67 */
  0x0002,   /* U+3E68 */
  0x0002,   /* U+3E69 */
  0x0002,   /* U+3E6A */
  0x0002,   /* U+3E6B */
  0x0002,   /* U+3E6C */
  0x0002,   /* U+3E6D */
  0x0002,   /* U+3E6E */
  0x0002,   /* U+3E6F */
  0x0002,   /* U+3E70 */
  0x0002,   /* U+3E71 */
  0x0002,   /* U+3E72 */
  0x0002,   /* U+3E73 */
  0x0002,   /* U+3E74 */
  0x0002,   /* U+3E75 */
  0x0002,   /* U+3E76 */
  0x0002,   /* U+3E77 */
  0x0002,   /* U+3E78 */
  0x0002,   /* U+3E79 */
  0x0002,   /* U+3E7A */
  0x0002,   /* U+3E7B */
  0x0002,   /* U+3E7C */
  0x0002,   /* U+3E7D */
  0x0002,   /* U+3E7E */
  0x0002,   /* U+3E7F */
  0x0002,   /* U+3E80 */
  0x0002,   /* U+3E81 */
  0x0002,   /* U+3E82 */
  0x0002,   /* U+3E83 */
  0x0002,   /* U+3E84 */
  0x0002,   /* U+3E85 */
  0x0002,   /* U+3E86 */
  0x0002,   /* U+3E87 */
  0x0002,   /* U+3E88 */
  0x0002,   /* U+3E89 */
  0x0002,   /* U+3E8A */
  0x0002,   /* U+3E8B */
  0x0002,   /* U+3E8C */
  0x0002,   /* U+3E8D */
  0x0002,   /* U+3E8E */
  0x0002,   /* U+3E8F */
  0x0002,   /* U+3E90 */
  0x0002,   /* U+3E91 */
  0x0002,   /* U+3E92 */
  0x0002,   /* U+3E93 */
  0x0002,   /* U+3E94 */
  0x0002,   /* U+3E95 */
  0x0002,   /* U+3E96 */
  0x0002,   /* U+3E97 */
  0x0002,   /* U+3E98 */
  0x0002,   /* U+3E99 */
  0x0002,   /* U+3E9A */
  0x0002,   /* U+3E9B */
  0x0002,   /* U+3E9C */
  0x0002,   /* U+3E9D */
  0x0002,   /* U+3E9E */
  0x0002,   /* U+3E9F */
  0x0002,   /* U+3EA0 */
  0x0002,   /* U+3EA1 */
  0x0002,   /* U+3EA2 */
  0x0002,   /* U+3EA3 */
  0x0002,   /* U+3EA4 */
  0x0002,   /* U+3EA5 */
  0x0002,   /* U+3EA6 */
  0x0002,   /* U+3EA7 */
  0x0002,   /* U+3EA8 */
  0x0002,   /* U+3EA9 */
  0x0002,   /* U+3EAA */
  0x0002,   /* U+3EAB */
  0x0002,   /* U+3EAC */
  0x0002,   /* U+3EAD */
  0x0002,   /* U+3EAE */
  0x0002,   /* U+3EAF */
  0x0002,   /* U+3EB0 */
  0x0002,   /* U+3EB1 */
  0x0002,   /* U+3EB2 */
  0x0002,   /* U+3EB3 */
  0x0002,   /* U+3EB4 */
  0x0002,   /* U+3EB5 */
  0x0002,   /* U+3EB6 */
  0x0002,   /* U+3EB7 */
  0x0002,   /* U+3EB8 */
  0x0002,   /* U+3EB9 */
  0x0002,   /* U+3EBA */
  0x0002,   /* U+3EBB */
  0x0002,   /* U+3EBC */
  0x0002,   /* U+3EBD */
  0x0002,   /* U+3EBE */
  0x0002,   /* U+3EBF */
  0x0002,   /* U+3EC0 */
  0x0002,   /* U+3EC1 */
  0x0002,   /* U+3EC2 */
  0x0002,   /* U+3EC3 */
  0x0002,   /* U+3EC4 */
  0x0002,   /* U+3EC5 */
  0x0002,   /* U+3EC6 */
  0x0002,   /* U+3EC7 */
  0x0002,   /* U+3EC8 */
  0x0002,   /* U+3EC9 */
  0x0002,   /* U+3ECA */
  0x0002,   /* U+3ECB */
  0x0002,   /* U+3ECC */
  0x0002,   /* U+3ECD */
  0x0002,   /* U+3ECE */
  0x0002,   /* U+3ECF */
  0x0002,   /* U+3ED0 */
  0x0002,   /* U+3ED1 */
  0x0002,   /* U+3ED2 */
  0x0002,   /* U+3ED3 */
  0x0002,   /* U+3ED4 */
  0x0002,   /* U+3ED5 */
  0x0002,   /* U+3ED6 */
  0x0002,   /* U+3ED7 */
  0x0002,   /* U+3ED8 */
  0x0002,   /* U+3ED9 */
  0x0002,   /* U+3EDA */
  0x0002,   /* U+3EDB */
  0x0002,   /* U+3EDC */
  0x0002,   /* U+3EDD */
  0x0002,   /* U+3EDE */
  0x0002,   /* U+3EDF */
  0x0002,   /* U+3EE0 */
  0x0002,   /* U+3EE1 */
  0x0002,   /* U+3EE2 */
  0x0002,   /* U+3EE3 */
  0x0002,   /* U+3EE4 */
  0x0002,   /* U+3EE5 */
  0x0002,   /* U+3EE6 */
  0x0002,   /* U+3EE7 */
  0x0002,   /* U+3EE8 */
  0x0002,   /* U+3EE9 */
  0x0002,   /* U+3EEA */
  0x0002,   /* U+3EEB */
  0x0002,   /* U+3EEC */
  0x0002,   /* U+3EED */
  0x0002,   /* U+3EEE */
  0x0002,   /* U+3EEF */
  0x0002,   /* U+3EF0 */
  0x0002,   /* U+3EF1 */
  0x0002,   /* U+3EF2 */
  0x0002,   /* U+3EF3 */
  0x0002,   /* U+3EF4 */
  0x0002,   /* U+3EF5 */
  0x0002,   /* U+3EF6 */
  0x0002,   /* U+3EF7 */
  0x0002,   /* U+3EF8 */
  0x0002,   /* U+3EF9 */
  0x0002,   /* U+3EFA */
  0x0002,   /* U+3EFB */
  0x0002,   /* U+3EFC */
  0x0002,   /* U+3EFD */
  0x0002,   /* U+3EFE */
  0x0002,   /* U+3EFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0xBE02,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0xBE06,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0xBE08,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0xBE14,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0xBE34,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0xBE3C,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0xBE67,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0xBE69,   /* U+3E69 */
  0xBE6A,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0xBE6F,   /* U+3E6F */
  0xBE70,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0xBE86,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0xBE99,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0xBEA7,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0xBEAF,   /* U+3EAF */
  0xBEB0,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0xBEB6,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0xBEBB,   /* U+3EBB */
  0xBEBC,   /* U+3EBC */
  0xBEBD,   /* U+3EBD */
  0xBEBE,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0xBEC1,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0xBEC6,   /* U+3EC6 */
  0xBEC7,   /* U+3EC7 */
  0xBEC8,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0xBED0,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0xBED8,   /* U+3ED8 */
  0xBED9,   /* U+3ED9 */
  0xBEDA,   /* U+3EDA */
  0xBEDB,   /* U+3EDB */
  0xBEDC,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0xBEE2,   /* U+3EE2 */
  0xBEE3,   /* U+3EE3 */
  0xBEE4,   /* U+3EE4 */
  0xBEE5,   /* U+3EE5 */
  0xBEE6,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0xBEE8,   /* U+3EE8 */
  0xBEE9,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0xBEF3,   /* U+3EF3 */
  0xBEF4,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0xBEFB,   /* U+3EFB */
  0xBEFC,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */
};

uint16_t zh_han_p03F[] = {
  /* Number of CEs for each character. */
  2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+3F00 */
  0xBDC1,   /* U+3F01 */
  0x3714,   /* U+3F02 */
  0xBDC1,   /* U+3F03 */
  0xBDC1,   /* U+3F04 */
  0xBDC1,   /* U+3F05 */
  0xBDC1,   /* U+3F06 */
  0x7C28,   /* U+3F07 */
  0x6719,   /* U+3F08 */
  0xB571,   /* U+3F09 */
  0x9186,   /* U+3F0A */
  0x3FD3,   /* U+3F0B */
  0xAD80,   /* U+3F0C */
  0x5DB6,   /* U+3F0D */
  0x23C2,   /* U+3F0E */
  0x6F14,   /* U+3F0F */
  0x74EF,   /* U+3F10 */
  0x60DE,   /* U+3F11 */
  0x8D20,   /* U+3F12 */
  0x6071,   /* U+3F13 */
  0x9515,   /* U+3F14 */
  0x30DD,   /* U+3F15 */
  0x603C,   /* U+3F16 */
  0x8F90,   /* U+3F17 */
  0x9270,   /* U+3F18 */
  0xB8E2,   /* U+3F19 */
  0x3D84,   /* U+3F1A */
  0x9E48,   /* U+3F1B */
  0x1D51,   /* U+3F1C */
  0x38EE,   /* U+3F1D */
  0x73E6,   /* U+3F1E */
  0x23B7,   /* U+3F1F */
  0x91E7,   /* U+3F20 */
  0x86D1,   /* U+3F21 */
  0xA6DB,   /* U+3F22 */
  0x23C3,   /* U+3F23 */
  0x7AC3,   /* U+3F24 */
  0x9068,   /* U+3F25 */
  0x3F48,   /* U+3F26 */
  0x9005,   /* U+3F27 */
  0x435C,   /* U+3F28 */
  0x2952,   /* U+3F29 */
  0x51BB,   /* U+3F2A */
  0x48F3,   /* U+3F2B */
  0x9E75,   /* U+3F2C */
  0x3306,   /* U+3F2D */
  0x2680,   /* U+3F2E */
  0x349A,   /* U+3F2F */
  0x745D,   /* U+3F30 */
  0x8098,   /* U+3F31 */
  0x61EC,   /* U+3F32 */
  0x850B,   /* U+3F33 */
  0x7221,   /* U+3F34 */
  0x3296,   /* U+3F35 */
  0xAD18,   /* U+3F36 */
  0x2C51,   /* U+3F37 */
  0x7FB5,   /* U+3F38 */
  0x57FB,   /* U+3F39 */
  0x8CF5,   /* U+3F3A */
  0x2E29,   /* U+3F3B */
  0x751F,   /* U+3F3C */
  0x2C9C,   /* U+3F3D */
  0x65C1,   /* U+3F3E */
  0x9029,   /* U+3F3F */
  0xB614,   /* U+3F40 */
  0x5FB1,   /* U+3F41 */
  0x8135,   /* U+3F42 */
  0x7281,   /* U+3F43 */
  0x8881,   /* U+3F44 */
  0xBDC1,   /* U+3F45 */
  0x30DE,   /* U+3F46 */
  0x4745,   /* U+3F47 */
  0xA8F2,   /* U+3F48 */
  0x9AFF,   /* U+3F49 */
  0x9DA2,   /* U+3F4A */
  0x671D,   /* U+3F4B */
  0x6406,   /* U+3F4C */
  0xBDC1,   /* U+3F4D */
  0x8C57,   /* U+3F4E */
  0x3D68,   /* U+3F4F */
  0xBDC1,   /* U+3F50 */
  0x8C70,   /* U+3F51 */
  0xBDC1,   /* U+3F52 */
  0xBDC1,   /* U+3F53 */
  0xBDC1,   /* U+3F54 */
  0xABD8,   /* U+3F55 */
  0x6E4F,   /* U+3F56 */
  0xBDC1,   /* U+3F57 */
  0x3D9E,   /* U+3F58 */
  0x5722,   /* U+3F59 */
  0x2A51,   /* U+3F5A */
  0x3F72,   /* U+3F5B */
  0x92E3,   /* U+3F5C */
  0x5F55,   /* U+3F5D */
  0x6380,   /* U+3F5E */
  0x61E0,   /* U+3F5F */
  0x9946,   /* U+3F60 */
  0x1F9D,   /* U+3F61 */
  0x1D0B,   /* U+3F62 */
  0xAE1C,   /* U+3F63 */
  0x54ED,   /* U+3F64 */
  0x8010,   /* U+3F65 */
  0xA17A,   /* U+3F66 */
  0xBB9D,   /* U+3F67 */
  0x2F46,   /* U+3F68 */
  0x2550,   /* U+3F69 */
  0xB237,   /* U+3F6A */
  0xAB43,   /* U+3F6B */
  0x3C94,   /* U+3F6C */
  0x80A8,   /* U+3F6D */
  0xBDC1,   /* U+3F6E */
  0x9853,   /* U+3F6F */
  0x8760,   /* U+3F70 */
  0x50AF,   /* U+3F71 */
  0x50B0,   /* U+3F72 */
  0x9F19,   /* U+3F73 */
  0xB3F4,   /* U+3F74 */
  0xBDC1,   /* U+3F75 */
  0xBDC1,   /* U+3F76 */
  0x87F2,   /* U+3F77 */
  0x28A2,   /* U+3F78 */
  0x38D6,   /* U+3F79 */
  0x4C55,   /* U+3F7A */
  0xB634,   /* U+3F7B */
  0xBDC1,   /* U+3F7C */
  0x405A,   /* U+3F7D */
  0x96D2,   /* U+3F7E */
  0xBDC1,   /* U+3F7F */
  0x7ABE,   /* U+3F80 */
  0x874B,   /* U+3F81 */
  0x42DC,   /* U+3F82 */
  0x91E8,   /* U+3F83 */
  0x351E,   /* U+3F84 */
  0xBBE1,   /* U+3F85 */
  0x7E9A,   /* U+3F86 */
  0x6D99,   /* U+3F87 */
  0x3C40,   /* U+3F88 */
  0x62BC,   /* U+3F89 */
  0x4C68,   /* U+3F8A */
  0x9EC6,   /* U+3F8B */
  0xA087,   /* U+3F8C */
  0x6E19,   /* U+3F8D */
  0xA1D5,   /* U+3F8E */
  0x5248,   /* U+3F8F */
  0x5F56,   /* U+3F90 */
  0x2F9E,   /* U+3F91 */
  0x8034,   /* U+3F92 */
  0xAED8,   /* U+3F93 */
  0x6626,   /* U+3F94 */
  0x849B,   /* U+3F95 */
  0x5EE7,   /* U+3F96 */
  0x6133,   /* U+3F97 */
  0x3EDC,   /* U+3F98 */
  0x9DFC,   /* U+3F99 */
  0x9C82,   /* U+3F9A */
  0x7B51,   /* U+3F9B */
  0x7AC8,   /* U+3F9C */
  0x285D,   /* U+3F9D */
  0xABFE,   /* U+3F9E */
  0x2499,   /* U+3F9F */
  0x5A38,   /* U+3FA0 */
  0x7E43,   /* U+3FA1 */
  0x1C9C,   /* U+3FA2 */
  0x7AFE,   /* U+3FA3 */
  0x79C6,   /* U+3FA4 */
  0x2BFD,   /* U+3FA5 */
  0x736C,   /* U+3FA6 */
  0x5B58,   /* U+3FA7 */
  0xA664,   /* U+3FA8 */
  0x40B9,   /* U+3FA9 */
  0x850C,   /* U+3FAA */
  0x74DB,   /* U+3FAB */
  0xBDC1,   /* U+3FAC */
  0xB8FD,   /* U+3FAD */
  0x4943,   /* U+3FAE */
  0x49C0,   /* U+3FAF */
  0x4714,   /* U+3FB0 */
  0x1FE9,   /* U+3FB1 */
  0xBDC1,   /* U+3FB2 */
  0xBDC1,   /* U+3FB3 */
  0xB257,   /* U+3FB4 */
  0x4D7A,   /* U+3FB5 */
  0x4039,   /* U+3FB6 */
  0x97BB,   /* U+3FB7 */
  0x3DE0,   /* U+3FB8 */
  0x268F,   /* U+3FB9 */
  0x67C5,   /* U+3FBA */
  0xB9F0,   /* U+3FBB */
  0x9158,   /* U+3FBC */
  0xBAB1,   /* U+3FBD */
  0x99CB,   /* U+3FBE */
  0x5CC5,   /* U+3FBF */
  0xBDC1,   /* U+3FC0 */
  0xBDC1,   /* U+3FC1 */
  0xBDC1,   /* U+3FC2 */
  0xB7D4,   /* U+3FC3 */
  0x1CAD,   /* U+3FC4 */
  0x9A7D,   /* U+3FC5 */
  0x4271,   /* U+3FC6 */
  0x983E,   /* U+3FC7 */
  0xBDC1,   /* U+3FC8 */
  0x915B,   /* U+3FC9 */
  0x253B,   /* U+3FCA */
  0x81E7,   /* U+3FCB */
  0x99DB,   /* U+3FCC */
  0x525F,   /* U+3FCD */
  0x3A51,   /* U+3FCE */
  0x7E90,   /* U+3FCF */
  0xBDC1,   /* U+3FD0 */
  0xA57D,   /* U+3FD1 */
  0x3153,   /* U+3FD2 */
  0x4E4D,   /* U+3FD3 */
  0x5DD7,   /* U+3FD4 */
  0xA2E2,   /* U+3FD5 */
  0x6520,   /* U+3FD6 */
  0x914E,   /* U+3FD7 */
  0xAAD2,   /* U+3FD8 */
  0x74CE,   /* U+3FD9 */
  0x677D,   /* U+3FDA */
  0x602F,   /* U+3FDB */
  0x22D1,   /* U+3FDC */
  0xBDC1,   /* U+3FDD */
  0x6904,   /* U+3FDE */
  0x1E50,   /* U+3FDF */
  0x498B,   /* U+3FE0 */
  0xBDC1,   /* U+3FE1 */
  0xA568,   /* U+3FE2 */
  0x44A2,   /* U+3FE3 */
  0x2D14,   /* U+3FE4 */
  0x4502,   /* U+3FE5 */
  0x7109,   /* U+3FE6 */
  0x2B53,   /* U+3FE7 */
  0x6001,   /* U+3FE8 */
  0x8D2D,   /* U+3FE9 */
  0x4883,   /* U+3FEA */
  0x20F3,   /* U+3FEB */
  0x1DE5,   /* U+3FEC */
  0x2855,   /* U+3FED */
  0xA482,   /* U+3FEE */
  0x2F9F,   /* U+3FEF */
  0x1D69,   /* U+3FF0 */
  0xA0E8,   /* U+3FF1 */
  0xBDC1,   /* U+3FF2 */
  0xBB89,   /* U+3FF3 */
  0x2F7A,   /* U+3FF4 */
  0x7ECB,   /* U+3FF5 */
  0x1EE4,   /* U+3FF6 */
  0x2F47,   /* U+3FF7 */
  0x930D,   /* U+3FF8 */
  0x8BC2,   /* U+3FF9 */
  0x1F37,   /* U+3FFA */
  0x3D0E,   /* U+3FFB */
  0xA29B,   /* U+3FFC */
  0x9739,   /* U+3FFD */
  0xB9C9,   /* U+3FFE */
  0xA206,   /* U+3FFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3F00 */
  0x0020,   /* U+3F01 */
  0x0020,   /* U+3F02 */
  0x0020,   /* U+3F03 */
  0x0020,   /* U+3F04 */
  0x0020,   /* U+3F05 */
  0x0020,   /* U+3F06 */
  0x0020,   /* U+3F07 */
  0x0020,   /* U+3F08 */
  0x0020,   /* U+3F09 */
  0x0020,   /* U+3F0A */
  0x0020,   /* U+3F0B */
  0x0020,   /* U+3F0C */
  0x0020,   /* U+3F0D */
  0x0020,   /* U+3F0E */
  0x0020,   /* U+3F0F */
  0x0020,   /* U+3F10 */
  0x0020,   /* U+3F11 */
  0x0020,   /* U+3F12 */
  0x0020,   /* U+3F13 */
  0x0020,   /* U+3F14 */
  0x0020,   /* U+3F15 */
  0x0020,   /* U+3F16 */
  0x0020,   /* U+3F17 */
  0x0020,   /* U+3F18 */
  0x0020,   /* U+3F19 */
  0x0020,   /* U+3F1A */
  0x0020,   /* U+3F1B */
  0x0020,   /* U+3F1C */
  0x0020,   /* U+3F1D */
  0x0020,   /* U+3F1E */
  0x0020,   /* U+3F1F */
  0x0020,   /* U+3F20 */
  0x0020,   /* U+3F21 */
  0x0020,   /* U+3F22 */
  0x0020,   /* U+3F23 */
  0x0020,   /* U+3F24 */
  0x0020,   /* U+3F25 */
  0x0020,   /* U+3F26 */
  0x0020,   /* U+3F27 */
  0x0020,   /* U+3F28 */
  0x0020,   /* U+3F29 */
  0x0020,   /* U+3F2A */
  0x0020,   /* U+3F2B */
  0x0020,   /* U+3F2C */
  0x0020,   /* U+3F2D */
  0x0020,   /* U+3F2E */
  0x0020,   /* U+3F2F */
  0x0020,   /* U+3F30 */
  0x0020,   /* U+3F31 */
  0x0020,   /* U+3F32 */
  0x0020,   /* U+3F33 */
  0x0020,   /* U+3F34 */
  0x0020,   /* U+3F35 */
  0x0020,   /* U+3F36 */
  0x0020,   /* U+3F37 */
  0x0020,   /* U+3F38 */
  0x0020,   /* U+3F39 */
  0x0020,   /* U+3F3A */
  0x0020,   /* U+3F3B */
  0x0020,   /* U+3F3C */
  0x0020,   /* U+3F3D */
  0x0020,   /* U+3F3E */
  0x0020,   /* U+3F3F */
  0x0020,   /* U+3F40 */
  0x0020,   /* U+3F41 */
  0x0020,   /* U+3F42 */
  0x0020,   /* U+3F43 */
  0x0020,   /* U+3F44 */
  0x0020,   /* U+3F45 */
  0x0020,   /* U+3F46 */
  0x0020,   /* U+3F47 */
  0x0020,   /* U+3F48 */
  0x0020,   /* U+3F49 */
  0x0020,   /* U+3F4A */
  0x0020,   /* U+3F4B */
  0x0020,   /* U+3F4C */
  0x0020,   /* U+3F4D */
  0x0020,   /* U+3F4E */
  0x0020,   /* U+3F4F */
  0x0020,   /* U+3F50 */
  0x0020,   /* U+3F51 */
  0x0020,   /* U+3F52 */
  0x0020,   /* U+3F53 */
  0x0020,   /* U+3F54 */
  0x0020,   /* U+3F55 */
  0x0020,   /* U+3F56 */
  0x0020,   /* U+3F57 */
  0x0020,   /* U+3F58 */
  0x0020,   /* U+3F59 */
  0x0020,   /* U+3F5A */
  0x0020,   /* U+3F5B */
  0x0020,   /* U+3F5C */
  0x0020,   /* U+3F5D */
  0x0020,   /* U+3F5E */
  0x0020,   /* U+3F5F */
  0x0020,   /* U+3F60 */
  0x0020,   /* U+3F61 */
  0x0020,   /* U+3F62 */
  0x0020,   /* U+3F63 */
  0x0020,   /* U+3F64 */
  0x0020,   /* U+3F65 */
  0x0020,   /* U+3F66 */
  0x0020,   /* U+3F67 */
  0x0020,   /* U+3F68 */
  0x0020,   /* U+3F69 */
  0x0020,   /* U+3F6A */
  0x0020,   /* U+3F6B */
  0x0020,   /* U+3F6C */
  0x0020,   /* U+3F6D */
  0x0020,   /* U+3F6E */
  0x0020,   /* U+3F6F */
  0x0020,   /* U+3F70 */
  0x0020,   /* U+3F71 */
  0x0020,   /* U+3F72 */
  0x0020,   /* U+3F73 */
  0x0020,   /* U+3F74 */
  0x0020,   /* U+3F75 */
  0x0020,   /* U+3F76 */
  0x0020,   /* U+3F77 */
  0x0020,   /* U+3F78 */
  0x0020,   /* U+3F79 */
  0x0020,   /* U+3F7A */
  0x0020,   /* U+3F7B */
  0x0020,   /* U+3F7C */
  0x0020,   /* U+3F7D */
  0x0020,   /* U+3F7E */
  0x0020,   /* U+3F7F */
  0x0020,   /* U+3F80 */
  0x0020,   /* U+3F81 */
  0x0020,   /* U+3F82 */
  0x0020,   /* U+3F83 */
  0x0020,   /* U+3F84 */
  0x0020,   /* U+3F85 */
  0x0020,   /* U+3F86 */
  0x0020,   /* U+3F87 */
  0x0020,   /* U+3F88 */
  0x0020,   /* U+3F89 */
  0x0020,   /* U+3F8A */
  0x0020,   /* U+3F8B */
  0x0020,   /* U+3F8C */
  0x0020,   /* U+3F8D */
  0x0020,   /* U+3F8E */
  0x0020,   /* U+3F8F */
  0x0020,   /* U+3F90 */
  0x0020,   /* U+3F91 */
  0x0020,   /* U+3F92 */
  0x0020,   /* U+3F93 */
  0x0020,   /* U+3F94 */
  0x0020,   /* U+3F95 */
  0x0020,   /* U+3F96 */
  0x0020,   /* U+3F97 */
  0x0020,   /* U+3F98 */
  0x0020,   /* U+3F99 */
  0x0020,   /* U+3F9A */
  0x0020,   /* U+3F9B */
  0x0020,   /* U+3F9C */
  0x0020,   /* U+3F9D */
  0x0020,   /* U+3F9E */
  0x0020,   /* U+3F9F */
  0x0020,   /* U+3FA0 */
  0x0020,   /* U+3FA1 */
  0x0020,   /* U+3FA2 */
  0x0020,   /* U+3FA3 */
  0x0020,   /* U+3FA4 */
  0x0020,   /* U+3FA5 */
  0x0020,   /* U+3FA6 */
  0x0020,   /* U+3FA7 */
  0x0020,   /* U+3FA8 */
  0x0020,   /* U+3FA9 */
  0x0020,   /* U+3FAA */
  0x0020,   /* U+3FAB */
  0x0020,   /* U+3FAC */
  0x0020,   /* U+3FAD */
  0x0020,   /* U+3FAE */
  0x0020,   /* U+3FAF */
  0x0020,   /* U+3FB0 */
  0x0020,   /* U+3FB1 */
  0x0020,   /* U+3FB2 */
  0x0020,   /* U+3FB3 */
  0x0020,   /* U+3FB4 */
  0x0020,   /* U+3FB5 */
  0x0020,   /* U+3FB6 */
  0x0020,   /* U+3FB7 */
  0x0020,   /* U+3FB8 */
  0x0020,   /* U+3FB9 */
  0x0020,   /* U+3FBA */
  0x0020,   /* U+3FBB */
  0x0020,   /* U+3FBC */
  0x0020,   /* U+3FBD */
  0x0020,   /* U+3FBE */
  0x0020,   /* U+3FBF */
  0x0020,   /* U+3FC0 */
  0x0020,   /* U+3FC1 */
  0x0020,   /* U+3FC2 */
  0x0020,   /* U+3FC3 */
  0x0020,   /* U+3FC4 */
  0x0020,   /* U+3FC5 */
  0x0020,   /* U+3FC6 */
  0x0020,   /* U+3FC7 */
  0x0020,   /* U+3FC8 */
  0x0020,   /* U+3FC9 */
  0x0020,   /* U+3FCA */
  0x0020,   /* U+3FCB */
  0x0020,   /* U+3FCC */
  0x0020,   /* U+3FCD */
  0x0020,   /* U+3FCE */
  0x0020,   /* U+3FCF */
  0x0020,   /* U+3FD0 */
  0x0020,   /* U+3FD1 */
  0x0020,   /* U+3FD2 */
  0x0020,   /* U+3FD3 */
  0x0020,   /* U+3FD4 */
  0x0020,   /* U+3FD5 */
  0x0020,   /* U+3FD6 */
  0x0020,   /* U+3FD7 */
  0x0020,   /* U+3FD8 */
  0x0020,   /* U+3FD9 */
  0x0020,   /* U+3FDA */
  0x0020,   /* U+3FDB */
  0x0020,   /* U+3FDC */
  0x0020,   /* U+3FDD */
  0x0020,   /* U+3FDE */
  0x0020,   /* U+3FDF */
  0x0020,   /* U+3FE0 */
  0x0020,   /* U+3FE1 */
  0x0020,   /* U+3FE2 */
  0x0020,   /* U+3FE3 */
  0x0020,   /* U+3FE4 */
  0x0020,   /* U+3FE5 */
  0x0020,   /* U+3FE6 */
  0x0020,   /* U+3FE7 */
  0x0020,   /* U+3FE8 */
  0x0020,   /* U+3FE9 */
  0x0020,   /* U+3FEA */
  0x0020,   /* U+3FEB */
  0x0020,   /* U+3FEC */
  0x0020,   /* U+3FED */
  0x0020,   /* U+3FEE */
  0x0020,   /* U+3FEF */
  0x0020,   /* U+3FF0 */
  0x0020,   /* U+3FF1 */
  0x0020,   /* U+3FF2 */
  0x0020,   /* U+3FF3 */
  0x0020,   /* U+3FF4 */
  0x0020,   /* U+3FF5 */
  0x0020,   /* U+3FF6 */
  0x0020,   /* U+3FF7 */
  0x0020,   /* U+3FF8 */
  0x0020,   /* U+3FF9 */
  0x0020,   /* U+3FFA */
  0x0020,   /* U+3FFB */
  0x0020,   /* U+3FFC */
  0x0020,   /* U+3FFD */
  0x0020,   /* U+3FFE */
  0x0020,   /* U+3FFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3F00 */
  0x0002,   /* U+3F01 */
  0x0002,   /* U+3F02 */
  0x0002,   /* U+3F03 */
  0x0002,   /* U+3F04 */
  0x0002,   /* U+3F05 */
  0x0002,   /* U+3F06 */
  0x0002,   /* U+3F07 */
  0x0002,   /* U+3F08 */
  0x0002,   /* U+3F09 */
  0x0002,   /* U+3F0A */
  0x0002,   /* U+3F0B */
  0x0002,   /* U+3F0C */
  0x0002,   /* U+3F0D */
  0x0002,   /* U+3F0E */
  0x0002,   /* U+3F0F */
  0x0002,   /* U+3F10 */
  0x0002,   /* U+3F11 */
  0x0002,   /* U+3F12 */
  0x0002,   /* U+3F13 */
  0x0002,   /* U+3F14 */
  0x0002,   /* U+3F15 */
  0x0002,   /* U+3F16 */
  0x0002,   /* U+3F17 */
  0x0002,   /* U+3F18 */
  0x0002,   /* U+3F19 */
  0x0002,   /* U+3F1A */
  0x0002,   /* U+3F1B */
  0x0002,   /* U+3F1C */
  0x0002,   /* U+3F1D */
  0x0002,   /* U+3F1E */
  0x0002,   /* U+3F1F */
  0x0002,   /* U+3F20 */
  0x0002,   /* U+3F21 */
  0x0002,   /* U+3F22 */
  0x0002,   /* U+3F23 */
  0x0002,   /* U+3F24 */
  0x0002,   /* U+3F25 */
  0x0002,   /* U+3F26 */
  0x0002,   /* U+3F27 */
  0x0002,   /* U+3F28 */
  0x0002,   /* U+3F29 */
  0x0002,   /* U+3F2A */
  0x0002,   /* U+3F2B */
  0x0002,   /* U+3F2C */
  0x0002,   /* U+3F2D */
  0x0002,   /* U+3F2E */
  0x0002,   /* U+3F2F */
  0x0002,   /* U+3F30 */
  0x0002,   /* U+3F31 */
  0x0002,   /* U+3F32 */
  0x0002,   /* U+3F33 */
  0x0002,   /* U+3F34 */
  0x0002,   /* U+3F35 */
  0x0002,   /* U+3F36 */
  0x0002,   /* U+3F37 */
  0x0002,   /* U+3F38 */
  0x0002,   /* U+3F39 */
  0x0002,   /* U+3F3A */
  0x0002,   /* U+3F3B */
  0x0002,   /* U+3F3C */
  0x0002,   /* U+3F3D */
  0x0002,   /* U+3F3E */
  0x0002,   /* U+3F3F */
  0x0002,   /* U+3F40 */
  0x0002,   /* U+3F41 */
  0x0002,   /* U+3F42 */
  0x0002,   /* U+3F43 */
  0x0002,   /* U+3F44 */
  0x0002,   /* U+3F45 */
  0x0002,   /* U+3F46 */
  0x0002,   /* U+3F47 */
  0x0002,   /* U+3F48 */
  0x0002,   /* U+3F49 */
  0x0002,   /* U+3F4A */
  0x0002,   /* U+3F4B */
  0x0002,   /* U+3F4C */
  0x0002,   /* U+3F4D */
  0x0002,   /* U+3F4E */
  0x0002,   /* U+3F4F */
  0x0002,   /* U+3F50 */
  0x0002,   /* U+3F51 */
  0x0002,   /* U+3F52 */
  0x0002,   /* U+3F53 */
  0x0002,   /* U+3F54 */
  0x0002,   /* U+3F55 */
  0x0002,   /* U+3F56 */
  0x0002,   /* U+3F57 */
  0x0002,   /* U+3F58 */
  0x0002,   /* U+3F59 */
  0x0002,   /* U+3F5A */
  0x0002,   /* U+3F5B */
  0x0002,   /* U+3F5C */
  0x0002,   /* U+3F5D */
  0x0002,   /* U+3F5E */
  0x0002,   /* U+3F5F */
  0x0002,   /* U+3F60 */
  0x0002,   /* U+3F61 */
  0x0002,   /* U+3F62 */
  0x0002,   /* U+3F63 */
  0x0002,   /* U+3F64 */
  0x0002,   /* U+3F65 */
  0x0002,   /* U+3F66 */
  0x0002,   /* U+3F67 */
  0x0002,   /* U+3F68 */
  0x0002,   /* U+3F69 */
  0x0002,   /* U+3F6A */
  0x0002,   /* U+3F6B */
  0x0002,   /* U+3F6C */
  0x0002,   /* U+3F6D */
  0x0002,   /* U+3F6E */
  0x0002,   /* U+3F6F */
  0x0002,   /* U+3F70 */
  0x0002,   /* U+3F71 */
  0x0002,   /* U+3F72 */
  0x0002,   /* U+3F73 */
  0x0002,   /* U+3F74 */
  0x0002,   /* U+3F75 */
  0x0002,   /* U+3F76 */
  0x0002,   /* U+3F77 */
  0x0002,   /* U+3F78 */
  0x0002,   /* U+3F79 */
  0x0002,   /* U+3F7A */
  0x0002,   /* U+3F7B */
  0x0002,   /* U+3F7C */
  0x0002,   /* U+3F7D */
  0x0002,   /* U+3F7E */
  0x0002,   /* U+3F7F */
  0x0002,   /* U+3F80 */
  0x0002,   /* U+3F81 */
  0x0002,   /* U+3F82 */
  0x0002,   /* U+3F83 */
  0x0002,   /* U+3F84 */
  0x0002,   /* U+3F85 */
  0x0002,   /* U+3F86 */
  0x0002,   /* U+3F87 */
  0x0002,   /* U+3F88 */
  0x0002,   /* U+3F89 */
  0x0002,   /* U+3F8A */
  0x0002,   /* U+3F8B */
  0x0002,   /* U+3F8C */
  0x0002,   /* U+3F8D */
  0x0002,   /* U+3F8E */
  0x0002,   /* U+3F8F */
  0x0002,   /* U+3F90 */
  0x0002,   /* U+3F91 */
  0x0002,   /* U+3F92 */
  0x0002,   /* U+3F93 */
  0x0002,   /* U+3F94 */
  0x0002,   /* U+3F95 */
  0x0002,   /* U+3F96 */
  0x0002,   /* U+3F97 */
  0x0002,   /* U+3F98 */
  0x0002,   /* U+3F99 */
  0x0002,   /* U+3F9A */
  0x0002,   /* U+3F9B */
  0x0002,   /* U+3F9C */
  0x0002,   /* U+3F9D */
  0x0002,   /* U+3F9E */
  0x0002,   /* U+3F9F */
  0x0002,   /* U+3FA0 */
  0x0002,   /* U+3FA1 */
  0x0002,   /* U+3FA2 */
  0x0002,   /* U+3FA3 */
  0x0002,   /* U+3FA4 */
  0x0002,   /* U+3FA5 */
  0x0002,   /* U+3FA6 */
  0x0002,   /* U+3FA7 */
  0x0002,   /* U+3FA8 */
  0x0002,   /* U+3FA9 */
  0x0002,   /* U+3FAA */
  0x0002,   /* U+3FAB */
  0x0002,   /* U+3FAC */
  0x0002,   /* U+3FAD */
  0x0002,   /* U+3FAE */
  0x0002,   /* U+3FAF */
  0x0002,   /* U+3FB0 */
  0x0002,   /* U+3FB1 */
  0x0002,   /* U+3FB2 */
  0x0002,   /* U+3FB3 */
  0x0002,   /* U+3FB4 */
  0x0002,   /* U+3FB5 */
  0x0002,   /* U+3FB6 */
  0x0002,   /* U+3FB7 */
  0x0002,   /* U+3FB8 */
  0x0002,   /* U+3FB9 */
  0x0002,   /* U+3FBA */
  0x0002,   /* U+3FBB */
  0x0002,   /* U+3FBC */
  0x0002,   /* U+3FBD */
  0x0002,   /* U+3FBE */
  0x0002,   /* U+3FBF */
  0x0002,   /* U+3FC0 */
  0x0002,   /* U+3FC1 */
  0x0002,   /* U+3FC2 */
  0x0002,   /* U+3FC3 */
  0x0002,   /* U+3FC4 */
  0x0002,   /* U+3FC5 */
  0x0002,   /* U+3FC6 */
  0x0002,   /* U+3FC7 */
  0x0002,   /* U+3FC8 */
  0x0002,   /* U+3FC9 */
  0x0002,   /* U+3FCA */
  0x0002,   /* U+3FCB */
  0x0002,   /* U+3FCC */
  0x0002,   /* U+3FCD */
  0x0002,   /* U+3FCE */
  0x0002,   /* U+3FCF */
  0x0002,   /* U+3FD0 */
  0x0002,   /* U+3FD1 */
  0x0002,   /* U+3FD2 */
  0x0002,   /* U+3FD3 */
  0x0002,   /* U+3FD4 */
  0x0002,   /* U+3FD5 */
  0x0002,   /* U+3FD6 */
  0x0002,   /* U+3FD7 */
  0x0002,   /* U+3FD8 */
  0x0002,   /* U+3FD9 */
  0x0002,   /* U+3FDA */
  0x0002,   /* U+3FDB */
  0x0002,   /* U+3FDC */
  0x0002,   /* U+3FDD */
  0x0002,   /* U+3FDE */
  0x0002,   /* U+3FDF */
  0x0002,   /* U+3FE0 */
  0x0002,   /* U+3FE1 */
  0x0002,   /* U+3FE2 */
  0x0002,   /* U+3FE3 */
  0x0002,   /* U+3FE4 */
  0x0002,   /* U+3FE5 */
  0x0002,   /* U+3FE6 */
  0x0002,   /* U+3FE7 */
  0x0002,   /* U+3FE8 */
  0x0002,   /* U+3FE9 */
  0x0002,   /* U+3FEA */
  0x0002,   /* U+3FEB */
  0x0002,   /* U+3FEC */
  0x0002,   /* U+3FED */
  0x0002,   /* U+3FEE */
  0x0002,   /* U+3FEF */
  0x0002,   /* U+3FF0 */
  0x0002,   /* U+3FF1 */
  0x0002,   /* U+3FF2 */
  0x0002,   /* U+3FF3 */
  0x0002,   /* U+3FF4 */
  0x0002,   /* U+3FF5 */
  0x0002,   /* U+3FF6 */
  0x0002,   /* U+3FF7 */
  0x0002,   /* U+3FF8 */
  0x0002,   /* U+3FF9 */
  0x0002,   /* U+3FFA */
  0x0002,   /* U+3FFB */
  0x0002,   /* U+3FFC */
  0x0002,   /* U+3FFD */
  0x0002,   /* U+3FFE */
  0x0002,   /* U+3FFF */

  /* Primary weight 2 for each character. */
  0xBF00,   /* U+3F00 */
  0xBF01,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0xBF03,   /* U+3F03 */
  0xBF04,   /* U+3F04 */
  0xBF05,   /* U+3F05 */
  0xBF06,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0xBF45,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0xBF4D,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0xBF50,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0xBF52,   /* U+3F52 */
  0xBF53,   /* U+3F53 */
  0xBF54,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0xBF57,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0xBF6E,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0xBF75,   /* U+3F75 */
  0xBF76,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0xBF7C,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0xBF7F,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0xBFAC,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0xBFB2,   /* U+3FB2 */
  0xBFB3,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0xBFC0,   /* U+3FC0 */
  0xBFC1,   /* U+3FC1 */
  0xBFC2,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0xBFC8,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0xBFD0,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0xBFDD,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0xBFE1,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0xBFF2,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */
};

uint16_t zh_han_p040[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x38EF,   /* U+4000 */
  0xAC81,   /* U+4001 */
  0x1CDA,   /* U+4002 */
  0x9133,   /* U+4003 */
  0x69EB,   /* U+4004 */
  0x8413,   /* U+4005 */
  0x52F0,   /* U+4006 */
  0x403F,   /* U+4007 */
  0x4D94,   /* U+4008 */
  0x7A66,   /* U+4009 */
  0x50FC,   /* U+400A */
  0xA2E3,   /* U+400B */
  0x9904,   /* U+400C */
  0x57E7,   /* U+400D */
  0x6B5A,   /* U+400E */
  0xA096,   /* U+400F */
  0x82C7,   /* U+4010 */
  0x95D1,   /* U+4011 */
  0x78BC,   /* U+4012 */
  0x48D1,   /* U+4013 */
  0x7F4E,   /* U+4014 */
  0xB572,   /* U+4015 */
  0x8E8E,   /* U+4016 */
  0x5655,   /* U+4017 */
  0x9CA3,   /* U+4018 */
  0x7813,   /* U+4019 */
  0x1D43,   /* U+401A */
  0x699B,   /* U+401B */
  0x400A,   /* U+401C */
  0xBDC1,   /* U+401D */
  0x8D3F,   /* U+401E */
  0x389A,   /* U+401F */
  0x556D,   /* U+4020 */
  0x2761,   /* U+4021 */
  0x880D,   /* U+4022 */
  0x20FD,   /* U+4023 */
  0x690A,   /* U+4024 */
  0x8823,   /* U+4025 */
  0x400F,   /* U+4026 */
  0x4625,   /* U+4027 */
  0x4826,   /* U+4028 */
  0x6758,   /* U+4029 */
  0x440B,   /* U+402A */
  0x4E30,   /* U+402B */
  0x7DD6,   /* U+402C */
  0x3CCB,   /* U+402D */
  0x491C,   /* U+402E */
  0x2469,   /* U+402F */
  0x401F,   /* U+4030 */
  0x3A7A,   /* U+4031 */
  0x6DA1,   /* U+4032 */
  0x1C95,   /* U+4033 */
  0xAAE1,   /* U+4034 */
  0x880F,   /* U+4035 */
  0x6134,   /* U+4036 */
  0x51BC,   /* U+4037 */
  0x2A63,   /* U+4038 */
  0x51BD,   /* U+4039 */
  0x2B09,   /* U+403A */
  0x75D2,   /* U+403B */
  0x2883,   /* U+403C */
  0xA2AE,   /* U+403D */
  0x3564,   /* U+403E */
  0x3284,   /* U+403F */
  0xBDC1,   /* U+4040 */
  0x6136,   /* U+4041 */
  0x9ACF,   /* U+4042 */
  0x224A,   /* U+4043 */
  0x9E76,   /* U+4044 */
  0x6A47,   /* U+4045 */
  0xA5E5,   /* U+4046 */
  0x6B07,   /* U+4047 */
  0x7837,   /* U+4048 */
  0x7838,   /* U+4049 */
  0x95E9,   /* U+404A */
  0x9D50,   /* U+404B */
  0xAE2F,   /* U+404C */
  0x789B,   /* U+404D */
  0x2962,   /* U+404E */
  0xA541,   /* U+404F */
  0xAA4F,   /* U+4050 */
  0xA448,   /* U+4051 */
  0x4C8E,   /* U+4052 */
  0xBC31,   /* U+4053 */
  0xA03A,   /* U+4054 */
  0x6C11,   /* U+4055 */
  0x6490,   /* U+4056 */
  0x578E,   /* U+4057 */
  0xA545,   /* U+4058 */
  0xA347,   /* U+4059 */
  0x8AE1,   /* U+405A */
  0x420A,   /* U+405B */
  0x4993,   /* U+405C */
  0xAAAE,   /* U+405D */
  0x850D,   /* U+405E */
  0x264C,   /* U+405F */
  0x6073,   /* U+4060 */
  0xBDC1,   /* U+4061 */
  0xA073,   /* U+4062 */
  0x2C57,   /* U+4063 */
  0x286E,   /* U+4064 */
  0x6FC2,   /* U+4065 */
  0x7DA1,   /* U+4066 */
  0x6B99,   /* U+4067 */
  0x4B54,   /* U+4068 */
  0xAD32,   /* U+4069 */
  0xB36C,   /* U+406A */
  0x473A,   /* U+406B */
  0x25FB,   /* U+406C */
  0x225E,   /* U+406D */
  0x794C,   /* U+406E */
  0x97E1,   /* U+406F */
  0x5031,   /* U+4070 */
  0x5938,   /* U+4071 */
  0x67D9,   /* U+4072 */
  0x68AB,   /* U+4073 */
  0xB372,   /* U+4074 */
  0x21F7,   /* U+4075 */
  0x4C0D,   /* U+4076 */
  0x56C1,   /* U+4077 */
  0x6E8B,   /* U+4078 */
  0x2195,   /* U+4079 */
  0x866A,   /* U+407A */
  0x883D,   /* U+407B */
  0x6D22,   /* U+407C */
  0x620D,   /* U+407D */
  0x6BDE,   /* U+407E */
  0x6D28,   /* U+407F */
  0x980F,   /* U+4080 */
  0x2701,   /* U+4081 */
  0x7D70,   /* U+4082 */
  0x5144,   /* U+4083 */
  0x4B82,   /* U+4084 */
  0x99F3,   /* U+4085 */
  0x9FA4,   /* U+4086 */
  0x7122,   /* U+4087 */
  0x9001,   /* U+4088 */
  0x4665,   /* U+4089 */
  0xAE6B,   /* U+408A */
  0xBDC1,   /* U+408B */
  0x2AC2,   /* U+408C */
  0x242A,   /* U+408D */
  0xBD0E,   /* U+408E */
  0x3333,   /* U+408F */
  0xBADB,   /* U+4090 */
  0x4BA8,   /* U+4091 */
  0x7894,   /* U+4092 */
  0xBDC1,   /* U+4093 */
  0x9E77,   /* U+4094 */
  0x4A57,   /* U+4095 */
  0x8582,   /* U+4096 */
  0x5964,   /* U+4097 */
  0xBDC1,   /* U+4098 */
  0x35CD,   /* U+4099 */
  0xA4CA,   /* U+409A */
  0xACCD,   /* U+409B */
  0x1EFA,   /* U+409C */
  0x519B,   /* U+409D */
  0xB4D4,   /* U+409E */
  0x4DF6,   /* U+409F */
  0x85D1,   /* U+40A0 */
  0x324C,   /* U+40A1 */
  0x346F,   /* U+40A2 */
  0x2D6C,   /* U+40A3 */
  0x3C41,   /* U+40A4 */
  0x6BFA,   /* U+40A5 */
  0xB501,   /* U+40A6 */
  0xB548,   /* U+40A7 */
  0xBDC1,   /* U+40A8 */
  0xA391,   /* U+40A9 */
  0x7A76,   /* U+40AA */
  0x43F7,   /* U+40AB */
  0x3F49,   /* U+40AC */
  0x7A1C,   /* U+40AD */
  0x66AA,   /* U+40AE */
  0x40CD,   /* U+40AF */
  0x5B92,   /* U+40B0 */
  0x80CA,   /* U+40B1 */
  0x3869,   /* U+40B2 */
  0x2F54,   /* U+40B3 */
  0xA2AF,   /* U+40B4 */
  0x3F18,   /* U+40B5 */
  0x51BE,   /* U+40B6 */
  0x40BA,   /* U+40B7 */
  0x428B,   /* U+40B8 */
  0x8B23,   /* U+40B9 */
  0x95C2,   /* U+40BA */
  0xB60A,   /* U+40BB */
  0x707C,   /* U+40BC */
  0x336E,   /* U+40BD */
  0x5BF3,   /* U+40BE */
  0x8B96,   /* U+40BF */
  0x2EF1,   /* U+40C0 */
  0xA1D9,   /* U+40C1 */
  0x423A,   /* U+40C2 */
  0xBDC1,   /* U+40C3 */
  0xBDC1,   /* U+40C4 */
  0x31F1,   /* U+40C5 */
  0xBDC1,   /* U+40C6 */
  0x6B3D,   /* U+40C7 */
  0x5166,   /* U+40C8 */
  0x6C12,   /* U+40C9 */
  0x553A,   /* U+40CA */
  0xAD1A,   /* U+40CB */
  0xB521,   /* U+40CC */
  0xB447,   /* U+40CD */
  0xB2CA,   /* U+40CE */
  0x9E23,   /* U+40CF */
  0xBDC1,   /* U+40D0 */
  0x1E92,   /* U+40D1 */
  0x4503,   /* U+40D2 */
  0x3FBC,   /* U+40D3 */
  0x4614,   /* U+40D4 */
  0x5D0D,   /* U+40D5 */
  0x96F2,   /* U+40D6 */
  0x2390,   /* U+40D7 */
  0x58FF,   /* U+40D8 */
  0x65C4,   /* U+40D9 */
  0x2E80,   /* U+40DA */
  0x607E,   /* U+40DB */
  0xA673,   /* U+40DC */
  0x7A96,   /* U+40DD */
  0x8707,   /* U+40DE */
  0xBDC1,   /* U+40DF */
  0xA0BA,   /* U+40E0 */
  0x528A,   /* U+40E1 */
  0x7B05,   /* U+40E2 */
  0x4A0D,   /* U+40E3 */
  0x8A05,   /* U+40E4 */
  0x2C8E,   /* U+40E5 */
  0x3631,   /* U+40E6 */
  0x6431,   /* U+40E7 */
  0xBDC1,   /* U+40E8 */
  0x6EC3,   /* U+40E9 */
  0x8C73,   /* U+40EA */
  0x307E,   /* U+40EB */
  0x9486,   /* U+40EC */
  0x3D4A,   /* U+40ED */
  0x2FB5,   /* U+40EE */
  0x5FC9,   /* U+40EF */
  0x24BC,   /* U+40F0 */
  0x9B05,   /* U+40F1 */
  0x72A4,   /* U+40F2 */
  0x5BB2,   /* U+40F3 */
  0xB954,   /* U+40F4 */
  0x703D,   /* U+40F5 */
  0x4856,   /* U+40F6 */
  0xAAD0,   /* U+40F7 */
  0x9B09,   /* U+40F8 */
  0x5C9F,   /* U+40F9 */
  0x6CAF,   /* U+40FA */
  0x1E40,   /* U+40FB */
  0xBDC1,   /* U+40FC */
  0x41C1,   /* U+40FD */
  0x20AB,   /* U+40FE */
  0x3AFA,   /* U+40FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4000 */
  0x0020,   /* U+4001 */
  0x0020,   /* U+4002 */
  0x0020,   /* U+4003 */
  0x0020,   /* U+4004 */
  0x0020,   /* U+4005 */
  0x0020,   /* U+4006 */
  0x0020,   /* U+4007 */
  0x0020,   /* U+4008 */
  0x0020,   /* U+4009 */
  0x0020,   /* U+400A */
  0x0020,   /* U+400B */
  0x0020,   /* U+400C */
  0x0020,   /* U+400D */
  0x0020,   /* U+400E */
  0x0020,   /* U+400F */
  0x0020,   /* U+4010 */
  0x0020,   /* U+4011 */
  0x0020,   /* U+4012 */
  0x0020,   /* U+4013 */
  0x0020,   /* U+4014 */
  0x0020,   /* U+4015 */
  0x0020,   /* U+4016 */
  0x0020,   /* U+4017 */
  0x0020,   /* U+4018 */
  0x0020,   /* U+4019 */
  0x0020,   /* U+401A */
  0x0020,   /* U+401B */
  0x0020,   /* U+401C */
  0x0020,   /* U+401D */
  0x0020,   /* U+401E */
  0x0020,   /* U+401F */
  0x0020,   /* U+4020 */
  0x0020,   /* U+4021 */
  0x0020,   /* U+4022 */
  0x0020,   /* U+4023 */
  0x0020,   /* U+4024 */
  0x0020,   /* U+4025 */
  0x0020,   /* U+4026 */
  0x0020,   /* U+4027 */
  0x0020,   /* U+4028 */
  0x0020,   /* U+4029 */
  0x0020,   /* U+402A */
  0x0020,   /* U+402B */
  0x0020,   /* U+402C */
  0x0020,   /* U+402D */
  0x0020,   /* U+402E */
  0x0020,   /* U+402F */
  0x0020,   /* U+4030 */
  0x0020,   /* U+4031 */
  0x0020,   /* U+4032 */
  0x0020,   /* U+4033 */
  0x0020,   /* U+4034 */
  0x0020,   /* U+4035 */
  0x0020,   /* U+4036 */
  0x0020,   /* U+4037 */
  0x0020,   /* U+4038 */
  0x0020,   /* U+4039 */
  0x0020,   /* U+403A */
  0x0020,   /* U+403B */
  0x0020,   /* U+403C */
  0x0020,   /* U+403D */
  0x0020,   /* U+403E */
  0x0020,   /* U+403F */
  0x0020,   /* U+4040 */
  0x0020,   /* U+4041 */
  0x0020,   /* U+4042 */
  0x0020,   /* U+4043 */
  0x0020,   /* U+4044 */
  0x0020,   /* U+4045 */
  0x0020,   /* U+4046 */
  0x0020,   /* U+4047 */
  0x0020,   /* U+4048 */
  0x0020,   /* U+4049 */
  0x0020,   /* U+404A */
  0x0020,   /* U+404B */
  0x0020,   /* U+404C */
  0x0020,   /* U+404D */
  0x0020,   /* U+404E */
  0x0020,   /* U+404F */
  0x0020,   /* U+4050 */
  0x0020,   /* U+4051 */
  0x0020,   /* U+4052 */
  0x0020,   /* U+4053 */
  0x0020,   /* U+4054 */
  0x0020,   /* U+4055 */
  0x0020,   /* U+4056 */
  0x0020,   /* U+4057 */
  0x0020,   /* U+4058 */
  0x0020,   /* U+4059 */
  0x0020,   /* U+405A */
  0x0020,   /* U+405B */
  0x0020,   /* U+405C */
  0x0020,   /* U+405D */
  0x0020,   /* U+405E */
  0x0020,   /* U+405F */
  0x0020,   /* U+4060 */
  0x0020,   /* U+4061 */
  0x0020,   /* U+4062 */
  0x0020,   /* U+4063 */
  0x0020,   /* U+4064 */
  0x0020,   /* U+4065 */
  0x0020,   /* U+4066 */
  0x0020,   /* U+4067 */
  0x0020,   /* U+4068 */
  0x0020,   /* U+4069 */
  0x0020,   /* U+406A */
  0x0020,   /* U+406B */
  0x0020,   /* U+406C */
  0x0020,   /* U+406D */
  0x0020,   /* U+406E */
  0x0020,   /* U+406F */
  0x0020,   /* U+4070 */
  0x0020,   /* U+4071 */
  0x0020,   /* U+4072 */
  0x0020,   /* U+4073 */
  0x0020,   /* U+4074 */
  0x0020,   /* U+4075 */
  0x0020,   /* U+4076 */
  0x0020,   /* U+4077 */
  0x0020,   /* U+4078 */
  0x0020,   /* U+4079 */
  0x0020,   /* U+407A */
  0x0020,   /* U+407B */
  0x0020,   /* U+407C */
  0x0020,   /* U+407D */
  0x0020,   /* U+407E */
  0x0020,   /* U+407F */
  0x0020,   /* U+4080 */
  0x0020,   /* U+4081 */
  0x0020,   /* U+4082 */
  0x0020,   /* U+4083 */
  0x0020,   /* U+4084 */
  0x0020,   /* U+4085 */
  0x0020,   /* U+4086 */
  0x0020,   /* U+4087 */
  0x0020,   /* U+4088 */
  0x0020,   /* U+4089 */
  0x0020,   /* U+408A */
  0x0020,   /* U+408B */
  0x0020,   /* U+408C */
  0x0020,   /* U+408D */
  0x0020,   /* U+408E */
  0x0020,   /* U+408F */
  0x0020,   /* U+4090 */
  0x0020,   /* U+4091 */
  0x0020,   /* U+4092 */
  0x0020,   /* U+4093 */
  0x0020,   /* U+4094 */
  0x0020,   /* U+4095 */
  0x0020,   /* U+4096 */
  0x0020,   /* U+4097 */
  0x0020,   /* U+4098 */
  0x0020,   /* U+4099 */
  0x0020,   /* U+409A */
  0x0020,   /* U+409B */
  0x0020,   /* U+409C */
  0x0020,   /* U+409D */
  0x0020,   /* U+409E */
  0x0020,   /* U+409F */
  0x0020,   /* U+40A0 */
  0x0020,   /* U+40A1 */
  0x0020,   /* U+40A2 */
  0x0020,   /* U+40A3 */
  0x0020,   /* U+40A4 */
  0x0020,   /* U+40A5 */
  0x0020,   /* U+40A6 */
  0x0020,   /* U+40A7 */
  0x0020,   /* U+40A8 */
  0x0020,   /* U+40A9 */
  0x0020,   /* U+40AA */
  0x0020,   /* U+40AB */
  0x0020,   /* U+40AC */
  0x0020,   /* U+40AD */
  0x0020,   /* U+40AE */
  0x0020,   /* U+40AF */
  0x0020,   /* U+40B0 */
  0x0020,   /* U+40B1 */
  0x0020,   /* U+40B2 */
  0x0020,   /* U+40B3 */
  0x0020,   /* U+40B4 */
  0x0020,   /* U+40B5 */
  0x0020,   /* U+40B6 */
  0x0020,   /* U+40B7 */
  0x0020,   /* U+40B8 */
  0x0020,   /* U+40B9 */
  0x0020,   /* U+40BA */
  0x0020,   /* U+40BB */
  0x0020,   /* U+40BC */
  0x0020,   /* U+40BD */
  0x0020,   /* U+40BE */
  0x0020,   /* U+40BF */
  0x0020,   /* U+40C0 */
  0x0020,   /* U+40C1 */
  0x0020,   /* U+40C2 */
  0x0020,   /* U+40C3 */
  0x0020,   /* U+40C4 */
  0x0020,   /* U+40C5 */
  0x0020,   /* U+40C6 */
  0x0020,   /* U+40C7 */
  0x0020,   /* U+40C8 */
  0x0020,   /* U+40C9 */
  0x0020,   /* U+40CA */
  0x0020,   /* U+40CB */
  0x0020,   /* U+40CC */
  0x0020,   /* U+40CD */
  0x0020,   /* U+40CE */
  0x0020,   /* U+40CF */
  0x0020,   /* U+40D0 */
  0x0020,   /* U+40D1 */
  0x0020,   /* U+40D2 */
  0x0020,   /* U+40D3 */
  0x0020,   /* U+40D4 */
  0x0020,   /* U+40D5 */
  0x0020,   /* U+40D6 */
  0x0020,   /* U+40D7 */
  0x0020,   /* U+40D8 */
  0x0020,   /* U+40D9 */
  0x0020,   /* U+40DA */
  0x0020,   /* U+40DB */
  0x0020,   /* U+40DC */
  0x0020,   /* U+40DD */
  0x0020,   /* U+40DE */
  0x0020,   /* U+40DF */
  0x0020,   /* U+40E0 */
  0x0020,   /* U+40E1 */
  0x0020,   /* U+40E2 */
  0x0020,   /* U+40E3 */
  0x0020,   /* U+40E4 */
  0x0020,   /* U+40E5 */
  0x0020,   /* U+40E6 */
  0x0020,   /* U+40E7 */
  0x0020,   /* U+40E8 */
  0x0020,   /* U+40E9 */
  0x0020,   /* U+40EA */
  0x0020,   /* U+40EB */
  0x0020,   /* U+40EC */
  0x0020,   /* U+40ED */
  0x0020,   /* U+40EE */
  0x0020,   /* U+40EF */
  0x0020,   /* U+40F0 */
  0x0020,   /* U+40F1 */
  0x0020,   /* U+40F2 */
  0x0020,   /* U+40F3 */
  0x0020,   /* U+40F4 */
  0x0020,   /* U+40F5 */
  0x0020,   /* U+40F6 */
  0x0020,   /* U+40F7 */
  0x0020,   /* U+40F8 */
  0x0020,   /* U+40F9 */
  0x0020,   /* U+40FA */
  0x0020,   /* U+40FB */
  0x0020,   /* U+40FC */
  0x0020,   /* U+40FD */
  0x0020,   /* U+40FE */
  0x0020,   /* U+40FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4000 */
  0x0002,   /* U+4001 */
  0x0002,   /* U+4002 */
  0x0002,   /* U+4003 */
  0x0002,   /* U+4004 */
  0x0002,   /* U+4005 */
  0x0002,   /* U+4006 */
  0x0002,   /* U+4007 */
  0x0002,   /* U+4008 */
  0x0002,   /* U+4009 */
  0x0002,   /* U+400A */
  0x0002,   /* U+400B */
  0x0002,   /* U+400C */
  0x0002,   /* U+400D */
  0x0002,   /* U+400E */
  0x0002,   /* U+400F */
  0x0002,   /* U+4010 */
  0x0002,   /* U+4011 */
  0x0002,   /* U+4012 */
  0x0002,   /* U+4013 */
  0x0002,   /* U+4014 */
  0x0002,   /* U+4015 */
  0x0002,   /* U+4016 */
  0x0002,   /* U+4017 */
  0x0002,   /* U+4018 */
  0x0002,   /* U+4019 */
  0x0002,   /* U+401A */
  0x0002,   /* U+401B */
  0x0002,   /* U+401C */
  0x0002,   /* U+401D */
  0x0002,   /* U+401E */
  0x0002,   /* U+401F */
  0x0002,   /* U+4020 */
  0x0002,   /* U+4021 */
  0x0002,   /* U+4022 */
  0x0002,   /* U+4023 */
  0x0002,   /* U+4024 */
  0x0002,   /* U+4025 */
  0x0002,   /* U+4026 */
  0x0002,   /* U+4027 */
  0x0002,   /* U+4028 */
  0x0002,   /* U+4029 */
  0x0002,   /* U+402A */
  0x0002,   /* U+402B */
  0x0002,   /* U+402C */
  0x0002,   /* U+402D */
  0x0002,   /* U+402E */
  0x0002,   /* U+402F */
  0x0002,   /* U+4030 */
  0x0002,   /* U+4031 */
  0x0002,   /* U+4032 */
  0x0002,   /* U+4033 */
  0x0002,   /* U+4034 */
  0x0002,   /* U+4035 */
  0x0002,   /* U+4036 */
  0x0002,   /* U+4037 */
  0x0002,   /* U+4038 */
  0x0002,   /* U+4039 */
  0x0002,   /* U+403A */
  0x0002,   /* U+403B */
  0x0002,   /* U+403C */
  0x0002,   /* U+403D */
  0x0002,   /* U+403E */
  0x0002,   /* U+403F */
  0x0002,   /* U+4040 */
  0x0002,   /* U+4041 */
  0x0002,   /* U+4042 */
  0x0002,   /* U+4043 */
  0x0002,   /* U+4044 */
  0x0002,   /* U+4045 */
  0x0002,   /* U+4046 */
  0x0002,   /* U+4047 */
  0x0002,   /* U+4048 */
  0x0002,   /* U+4049 */
  0x0002,   /* U+404A */
  0x0002,   /* U+404B */
  0x0002,   /* U+404C */
  0x0002,   /* U+404D */
  0x0002,   /* U+404E */
  0x0002,   /* U+404F */
  0x0002,   /* U+4050 */
  0x0002,   /* U+4051 */
  0x0002,   /* U+4052 */
  0x0002,   /* U+4053 */
  0x0002,   /* U+4054 */
  0x0002,   /* U+4055 */
  0x0002,   /* U+4056 */
  0x0002,   /* U+4057 */
  0x0002,   /* U+4058 */
  0x0002,   /* U+4059 */
  0x0002,   /* U+405A */
  0x0002,   /* U+405B */
  0x0002,   /* U+405C */
  0x0002,   /* U+405D */
  0x0002,   /* U+405E */
  0x0002,   /* U+405F */
  0x0002,   /* U+4060 */
  0x0002,   /* U+4061 */
  0x0002,   /* U+4062 */
  0x0002,   /* U+4063 */
  0x0002,   /* U+4064 */
  0x0002,   /* U+4065 */
  0x0002,   /* U+4066 */
  0x0002,   /* U+4067 */
  0x0002,   /* U+4068 */
  0x0002,   /* U+4069 */
  0x0002,   /* U+406A */
  0x0002,   /* U+406B */
  0x0002,   /* U+406C */
  0x0002,   /* U+406D */
  0x0002,   /* U+406E */
  0x0002,   /* U+406F */
  0x0002,   /* U+4070 */
  0x0002,   /* U+4071 */
  0x0002,   /* U+4072 */
  0x0002,   /* U+4073 */
  0x0002,   /* U+4074 */
  0x0002,   /* U+4075 */
  0x0002,   /* U+4076 */
  0x0002,   /* U+4077 */
  0x0002,   /* U+4078 */
  0x0002,   /* U+4079 */
  0x0002,   /* U+407A */
  0x0002,   /* U+407B */
  0x0002,   /* U+407C */
  0x0002,   /* U+407D */
  0x0002,   /* U+407E */
  0x0002,   /* U+407F */
  0x0002,   /* U+4080 */
  0x0002,   /* U+4081 */
  0x0002,   /* U+4082 */
  0x0002,   /* U+4083 */
  0x0002,   /* U+4084 */
  0x0002,   /* U+4085 */
  0x0002,   /* U+4086 */
  0x0002,   /* U+4087 */
  0x0002,   /* U+4088 */
  0x0002,   /* U+4089 */
  0x0002,   /* U+408A */
  0x0002,   /* U+408B */
  0x0002,   /* U+408C */
  0x0002,   /* U+408D */
  0x0002,   /* U+408E */
  0x0002,   /* U+408F */
  0x0002,   /* U+4090 */
  0x0002,   /* U+4091 */
  0x0002,   /* U+4092 */
  0x0002,   /* U+4093 */
  0x0002,   /* U+4094 */
  0x0002,   /* U+4095 */
  0x0002,   /* U+4096 */
  0x0002,   /* U+4097 */
  0x0002,   /* U+4098 */
  0x0002,   /* U+4099 */
  0x0002,   /* U+409A */
  0x0002,   /* U+409B */
  0x0002,   /* U+409C */
  0x0002,   /* U+409D */
  0x0002,   /* U+409E */
  0x0002,   /* U+409F */
  0x0002,   /* U+40A0 */
  0x0002,   /* U+40A1 */
  0x0002,   /* U+40A2 */
  0x0002,   /* U+40A3 */
  0x0002,   /* U+40A4 */
  0x0002,   /* U+40A5 */
  0x0002,   /* U+40A6 */
  0x0002,   /* U+40A7 */
  0x0002,   /* U+40A8 */
  0x0002,   /* U+40A9 */
  0x0002,   /* U+40AA */
  0x0002,   /* U+40AB */
  0x0002,   /* U+40AC */
  0x0002,   /* U+40AD */
  0x0002,   /* U+40AE */
  0x0002,   /* U+40AF */
  0x0002,   /* U+40B0 */
  0x0002,   /* U+40B1 */
  0x0002,   /* U+40B2 */
  0x0002,   /* U+40B3 */
  0x0002,   /* U+40B4 */
  0x0002,   /* U+40B5 */
  0x0002,   /* U+40B6 */
  0x0002,   /* U+40B7 */
  0x0002,   /* U+40B8 */
  0x0002,   /* U+40B9 */
  0x0002,   /* U+40BA */
  0x0002,   /* U+40BB */
  0x0002,   /* U+40BC */
  0x0002,   /* U+40BD */
  0x0002,   /* U+40BE */
  0x0002,   /* U+40BF */
  0x0002,   /* U+40C0 */
  0x0002,   /* U+40C1 */
  0x0002,   /* U+40C2 */
  0x0002,   /* U+40C3 */
  0x0002,   /* U+40C4 */
  0x0002,   /* U+40C5 */
  0x0002,   /* U+40C6 */
  0x0002,   /* U+40C7 */
  0x0002,   /* U+40C8 */
  0x0002,   /* U+40C9 */
  0x0002,   /* U+40CA */
  0x0002,   /* U+40CB */
  0x0002,   /* U+40CC */
  0x0002,   /* U+40CD */
  0x0002,   /* U+40CE */
  0x0002,   /* U+40CF */
  0x0002,   /* U+40D0 */
  0x0002,   /* U+40D1 */
  0x0002,   /* U+40D2 */
  0x0002,   /* U+40D3 */
  0x0002,   /* U+40D4 */
  0x0002,   /* U+40D5 */
  0x0002,   /* U+40D6 */
  0x0002,   /* U+40D7 */
  0x0002,   /* U+40D8 */
  0x0002,   /* U+40D9 */
  0x0002,   /* U+40DA */
  0x0002,   /* U+40DB */
  0x0002,   /* U+40DC */
  0x0002,   /* U+40DD */
  0x0002,   /* U+40DE */
  0x0002,   /* U+40DF */
  0x0002,   /* U+40E0 */
  0x0002,   /* U+40E1 */
  0x0002,   /* U+40E2 */
  0x0002,   /* U+40E3 */
  0x0002,   /* U+40E4 */
  0x0002,   /* U+40E5 */
  0x0002,   /* U+40E6 */
  0x0002,   /* U+40E7 */
  0x0002,   /* U+40E8 */
  0x0002,   /* U+40E9 */
  0x0002,   /* U+40EA */
  0x0002,   /* U+40EB */
  0x0002,   /* U+40EC */
  0x0002,   /* U+40ED */
  0x0002,   /* U+40EE */
  0x0002,   /* U+40EF */
  0x0002,   /* U+40F0 */
  0x0002,   /* U+40F1 */
  0x0002,   /* U+40F2 */
  0x0002,   /* U+40F3 */
  0x0002,   /* U+40F4 */
  0x0002,   /* U+40F5 */
  0x0002,   /* U+40F6 */
  0x0002,   /* U+40F7 */
  0x0002,   /* U+40F8 */
  0x0002,   /* U+40F9 */
  0x0002,   /* U+40FA */
  0x0002,   /* U+40FB */
  0x0002,   /* U+40FC */
  0x0002,   /* U+40FD */
  0x0002,   /* U+40FE */
  0x0002,   /* U+40FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0xC01D,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0xC040,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0xC061,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0xC08B,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0xC093,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0xC098,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0xC0A8,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0xC0C3,   /* U+40C3 */
  0xC0C4,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0xC0C6,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0xC0D0,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0xC0DF,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0xC0E8,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0xC0FC,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */
};

uint16_t zh_han_p041[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 

  /* Primary weight 1 for each character. */
  0x4B29,   /* U+4100 */
  0xA808,   /* U+4101 */
  0x63EE,   /* U+4102 */
  0xBDC1,   /* U+4103 */
  0xA94A,   /* U+4104 */
  0x5603,   /* U+4105 */
  0x4B0F,   /* U+4106 */
  0x2953,   /* U+4107 */
  0x34E6,   /* U+4108 */
  0x3707,   /* U+4109 */
  0xBDC1,   /* U+410A */
  0xA335,   /* U+410B */
  0xBAAA,   /* U+410C */
  0xB2C8,   /* U+410D */
  0x77E9,   /* U+410E */
  0xAD11,   /* U+410F */
  0x7E24,   /* U+4110 */
  0x4B12,   /* U+4111 */
  0x707D,   /* U+4112 */
  0x4945,   /* U+4113 */
  0x553B,   /* U+4114 */
  0x8419,   /* U+4115 */
  0xBDC1,   /* U+4116 */
  0xBDC1,   /* U+4117 */
  0x73BC,   /* U+4118 */
  0x6C67,   /* U+4119 */
  0x2593,   /* U+411A */
  0x64B4,   /* U+411B */
  0x5E79,   /* U+411C */
  0x2C7F,   /* U+411D */
  0xBDC1,   /* U+411E */
  0x2EC6,   /* U+411F */
  0x834E,   /* U+4120 */
  0x305A,   /* U+4121 */
  0x77A6,   /* U+4122 */
  0xBDC1,   /* U+4123 */
  0x5C12,   /* U+4124 */
  0x634C,   /* U+4125 */
  0x6188,   /* U+4126 */
  0x7F74,   /* U+4127 */
  0xACC4,   /* U+4128 */
  0xA7D2,   /* U+4129 */
  0x3353,   /* U+412A */
  0x77D5,   /* U+412B */
  0xA6A5,   /* U+412C */
  0x6FD7,   /* U+412D */
  0x3AFB,   /* U+412E */
  0x4F0B,   /* U+412F */
  0xA1ED,   /* U+4130 */
  0x3918,   /* U+4131 */
  0x80C5,   /* U+4132 */
  0x99AA,   /* U+4133 */
  0xBDC1,   /* U+4134 */
  0xBDC1,   /* U+4135 */
  0x20FE,   /* U+4136 */
  0x8599,   /* U+4137 */
  0x761D,   /* U+4138 */
  0x6FDC,   /* U+4139 */
  0xB75C,   /* U+413A */
  0x8D73,   /* U+413B */
  0x8EDB,   /* U+413C */
  0x8EDC,   /* U+413D */
  0x8071,   /* U+413E */
  0xA81F,   /* U+413F */
  0x61DD,   /* U+4140 */
  0x1D24,   /* U+4141 */
  0x44D8,   /* U+4142 */
  0x7BEF,   /* U+4143 */
  0x5F58,   /* U+4144 */
  0x4181,   /* U+4145 */
  0xBC07,   /* U+4146 */
  0x89BE,   /* U+4147 */
  0xAF6B,   /* U+4148 */
  0xA230,   /* U+4149 */
  0x2639,   /* U+414A */
  0x92F9,   /* U+414B */
  0x55CF,   /* U+414C */
  0x8FC7,   /* U+414D */
  0xAC49,   /* U+414E */
  0x4A3A,   /* U+414F */
  0x4F1F,   /* U+4150 */
  0x80B2,   /* U+4151 */
  0x688C,   /* U+4152 */
  0x5531,   /* U+4153 */
  0xBB8B,   /* U+4154 */
  0x54A8,   /* U+4155 */
  0x1CE3,   /* U+4156 */
  0x8A8D,   /* U+4157 */
  0x5BE0,   /* U+4158 */
  0x4AED,   /* U+4159 */
  0x7E17,   /* U+415A */
  0x2786,   /* U+415B */
  0x36D1,   /* U+415C */
  0x5915,   /* U+415D */
  0x6F07,   /* U+415E */
  0x2535,   /* U+415F */
  0x8E0D,   /* U+4160 */
  0x9F87,   /* U+4161 */
  0x545F,   /* U+4162 */
  0x4946,   /* U+4163 */
  0x7843,   /* U+4164 */
  0x51DB,   /* U+4165 */
  0x68D2,   /* U+4166 */
  0xA26C,   /* U+4167 */
  0xBDC1,   /* U+4168 */
  0xB702,   /* U+4169 */
  0x913A,   /* U+416A */
  0xBDC1,   /* U+416B */
  0x1CA8,   /* U+416C */
  0x72E3,   /* U+416D */
  0x257A,   /* U+416E */
  0x8CF7,   /* U+416F */
  0x37E0,   /* U+4170 */
  0x4AF3,   /* U+4171 */
  0x7782,   /* U+4172 */
  0x2BA4,   /* U+4173 */
  0x8B2D,   /* U+4174 */
  0xBB23,   /* U+4175 */
  0x7170,   /* U+4176 */
  0x90DB,   /* U+4177 */
  0x8474,   /* U+4178 */
  0x64D3,   /* U+4179 */
  0x2258,   /* U+417A */
  0x5E7A,   /* U+417B */
  0x6817,   /* U+417C */
  0x9DD9,   /* U+417D */
  0x25E9,   /* U+417E */
  0x4959,   /* U+417F */
  0x6990,   /* U+4180 */
  0x3DC6,   /* U+4181 */
  0x6091,   /* U+4182 */
  0x3177,   /* U+4183 */
  0xB373,   /* U+4184 */
  0xBBB5,   /* U+4185 */
  0xBDC1,   /* U+4186 */
  0xBDC1,   /* U+4187 */
  0xB80D,   /* U+4188 */
  0x1E37,   /* U+4189 */
  0x2F13,   /* U+418A */
  0x7C57,   /* U+418B */
  0xBDC1,   /* U+418C */
  0x644C,   /* U+418D */
  0x99EB,   /* U+418E */
  0x39D1,   /* U+418F */
  0x42A9,   /* U+4190 */
  0x292A,   /* U+4191 */
  0x5445,   /* U+4192 */
  0x374D,   /* U+4193 */
  0x2AAB,   /* U+4194 */
  0xAFAB,   /* U+4195 */
  0x45DF,   /* U+4196 */
  0xA531,   /* U+4197 */
  0xA1CF,   /* U+4198 */
  0xA4D0,   /* U+4199 */
  0x9003,   /* U+419A */
  0xB2C1,   /* U+419B */
  0xAC83,   /* U+419C */
  0xA10F,   /* U+419D */
  0xA535,   /* U+419E */
  0x58AA,   /* U+419F */
  0x48E1,   /* U+41A0 */
  0x5CBB,   /* U+41A1 */
  0xAFBF,   /* U+41A2 */
  0x28B4,   /* U+41A3 */
  0xBDC1,   /* U+41A4 */
  0xBDC1,   /* U+41A5 */
  0x84C2,   /* U+41A6 */
  0xBDC1,   /* U+41A7 */
  0x70E3,   /* U+41A8 */
  0x6C60,   /* U+41A9 */
  0x45B0,   /* U+41AA */
  0x2C7C,   /* U+41AB */
  0xB05F,   /* U+41AC */
  0xA03F,   /* U+41AD */
  0x52FB,   /* U+41AE */
  0xBB2D,   /* U+41AF */
  0xACAE,   /* U+41B0 */
  0x8C40,   /* U+41B1 */
  0x5801,   /* U+41B2 */
  0x7C17,   /* U+41B3 */
  0xBDC1,   /* U+41B4 */
  0x2974,   /* U+41B5 */
  0x541A,   /* U+41B6 */
  0xA11F,   /* U+41B7 */
  0xB5DE,   /* U+41B8 */
  0x2AC3,   /* U+41B9 */
  0x7284,   /* U+41BA */
  0x7A99,   /* U+41BB */
  0xBDC1,   /* U+41BC */
  0x7D58,   /* U+41BD */
  0x5C40,   /* U+41BE */
  0xA8F3,   /* U+41BF */
  0x7FD3,   /* U+41C0 */
  0x8891,   /* U+41C1 */
  0x78B0,   /* U+41C2 */
  0x88B3,   /* U+41C3 */
  0xBDC1,   /* U+41C4 */
  0x384F,   /* U+41C5 */
  0xBDC1,   /* U+41C6 */
  0x69E2,   /* U+41C7 */
  0x4822,   /* U+41C8 */
  0xBDC1,   /* U+41C9 */
  0xBDC1,   /* U+41CA */
  0x4306,   /* U+41CB */
  0x7A88,   /* U+41CC */
  0x2BF7,   /* U+41CD */
  0x7E4E,   /* U+41CE */
  0x35FB,   /* U+41CF */
  0x5F7A,   /* U+41D0 */
  0x1E2A,   /* U+41D1 */
  0x525A,   /* U+41D2 */
  0x9F57,   /* U+41D3 */
  0x6773,   /* U+41D4 */
  0xBDC1,   /* U+41D5 */
  0xB04F,   /* U+41D6 */
  0xB836,   /* U+41D7 */
  0x479B,   /* U+41D8 */
  0xA9CC,   /* U+41D9 */
  0xBDC1,   /* U+41DA */
  0xB6E6,   /* U+41DB */
  0x7961,   /* U+41DC */
  0xBDC1,   /* U+41DD */
  0x3D1B,   /* U+41DE */
  0x4F90,   /* U+41DF */
  0xB9D0,   /* U+41E0 */
  0xB9D1,   /* U+41E1 */
  0x5990,   /* U+41E2 */
  0x7068,   /* U+41E3 */
  0x80C8,   /* U+41E4 */
  0xB1C2,   /* U+41E5 */
  0x1D4B,   /* U+41E6 */
  0xB77C,   /* U+41E7 */
  0x3F60,   /* U+41E8 */
  0xA844,   /* U+41E9 */
  0x29A8,   /* U+41EA */
  0x4BC1,   /* U+41EB */
  0xB931,   /* U+41EC */
  0x5D32,   /* U+41ED */
  0x7F5C,   /* U+41EE */
  0x7F9F,   /* U+41EF */
  0xB5C5,   /* U+41F0 */
  0x6DFE,   /* U+41F1 */
  0x25C2,   /* U+41F2 */
  0xBDC1,   /* U+41F3 */
  0xBDC1,   /* U+41F4 */
  0xA6F8,   /* U+41F5 */
  0x5689,   /* U+41F6 */
  0x22BF,   /* U+41F7 */
  0x295D,   /* U+41F8 */
  0x573D,   /* U+41F9 */
  0x34EB,   /* U+41FA */
  0x9459,   /* U+41FB */
  0xA868,   /* U+41FC */
  0xB490,   /* U+41FD */
  0xA2B8,   /* U+41FE */
  0xBDC1,   /* U+41FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4100 */
  0x0020,   /* U+4101 */
  0x0020,   /* U+4102 */
  0x0020,   /* U+4103 */
  0x0020,   /* U+4104 */
  0x0020,   /* U+4105 */
  0x0020,   /* U+4106 */
  0x0020,   /* U+4107 */
  0x0020,   /* U+4108 */
  0x0020,   /* U+4109 */
  0x0020,   /* U+410A */
  0x0020,   /* U+410B */
  0x0020,   /* U+410C */
  0x0020,   /* U+410D */
  0x0020,   /* U+410E */
  0x0020,   /* U+410F */
  0x0020,   /* U+4110 */
  0x0020,   /* U+4111 */
  0x0020,   /* U+4112 */
  0x0020,   /* U+4113 */
  0x0020,   /* U+4114 */
  0x0020,   /* U+4115 */
  0x0020,   /* U+4116 */
  0x0020,   /* U+4117 */
  0x0020,   /* U+4118 */
  0x0020,   /* U+4119 */
  0x0020,   /* U+411A */
  0x0020,   /* U+411B */
  0x0020,   /* U+411C */
  0x0020,   /* U+411D */
  0x0020,   /* U+411E */
  0x0020,   /* U+411F */
  0x0020,   /* U+4120 */
  0x0020,   /* U+4121 */
  0x0020,   /* U+4122 */
  0x0020,   /* U+4123 */
  0x0020,   /* U+4124 */
  0x0020,   /* U+4125 */
  0x0020,   /* U+4126 */
  0x0020,   /* U+4127 */
  0x0020,   /* U+4128 */
  0x0020,   /* U+4129 */
  0x0020,   /* U+412A */
  0x0020,   /* U+412B */
  0x0020,   /* U+412C */
  0x0020,   /* U+412D */
  0x0020,   /* U+412E */
  0x0020,   /* U+412F */
  0x0020,   /* U+4130 */
  0x0020,   /* U+4131 */
  0x0020,   /* U+4132 */
  0x0020,   /* U+4133 */
  0x0020,   /* U+4134 */
  0x0020,   /* U+4135 */
  0x0020,   /* U+4136 */
  0x0020,   /* U+4137 */
  0x0020,   /* U+4138 */
  0x0020,   /* U+4139 */
  0x0020,   /* U+413A */
  0x0020,   /* U+413B */
  0x0020,   /* U+413C */
  0x0020,   /* U+413D */
  0x0020,   /* U+413E */
  0x0020,   /* U+413F */
  0x0020,   /* U+4140 */
  0x0020,   /* U+4141 */
  0x0020,   /* U+4142 */
  0x0020,   /* U+4143 */
  0x0020,   /* U+4144 */
  0x0020,   /* U+4145 */
  0x0020,   /* U+4146 */
  0x0020,   /* U+4147 */
  0x0020,   /* U+4148 */
  0x0020,   /* U+4149 */
  0x0020,   /* U+414A */
  0x0020,   /* U+414B */
  0x0020,   /* U+414C */
  0x0020,   /* U+414D */
  0x0020,   /* U+414E */
  0x0020,   /* U+414F */
  0x0020,   /* U+4150 */
  0x0020,   /* U+4151 */
  0x0020,   /* U+4152 */
  0x0020,   /* U+4153 */
  0x0020,   /* U+4154 */
  0x0020,   /* U+4155 */
  0x0020,   /* U+4156 */
  0x0020,   /* U+4157 */
  0x0020,   /* U+4158 */
  0x0020,   /* U+4159 */
  0x0020,   /* U+415A */
  0x0020,   /* U+415B */
  0x0020,   /* U+415C */
  0x0020,   /* U+415D */
  0x0020,   /* U+415E */
  0x0020,   /* U+415F */
  0x0020,   /* U+4160 */
  0x0020,   /* U+4161 */
  0x0020,   /* U+4162 */
  0x0020,   /* U+4163 */
  0x0020,   /* U+4164 */
  0x0020,   /* U+4165 */
  0x0020,   /* U+4166 */
  0x0020,   /* U+4167 */
  0x0020,   /* U+4168 */
  0x0020,   /* U+4169 */
  0x0020,   /* U+416A */
  0x0020,   /* U+416B */
  0x0020,   /* U+416C */
  0x0020,   /* U+416D */
  0x0020,   /* U+416E */
  0x0020,   /* U+416F */
  0x0020,   /* U+4170 */
  0x0020,   /* U+4171 */
  0x0020,   /* U+4172 */
  0x0020,   /* U+4173 */
  0x0020,   /* U+4174 */
  0x0020,   /* U+4175 */
  0x0020,   /* U+4176 */
  0x0020,   /* U+4177 */
  0x0020,   /* U+4178 */
  0x0020,   /* U+4179 */
  0x0020,   /* U+417A */
  0x0020,   /* U+417B */
  0x0020,   /* U+417C */
  0x0020,   /* U+417D */
  0x0020,   /* U+417E */
  0x0020,   /* U+417F */
  0x0020,   /* U+4180 */
  0x0020,   /* U+4181 */
  0x0020,   /* U+4182 */
  0x0020,   /* U+4183 */
  0x0020,   /* U+4184 */
  0x0020,   /* U+4185 */
  0x0020,   /* U+4186 */
  0x0020,   /* U+4187 */
  0x0020,   /* U+4188 */
  0x0020,   /* U+4189 */
  0x0020,   /* U+418A */
  0x0020,   /* U+418B */
  0x0020,   /* U+418C */
  0x0020,   /* U+418D */
  0x0020,   /* U+418E */
  0x0020,   /* U+418F */
  0x0020,   /* U+4190 */
  0x0020,   /* U+4191 */
  0x0020,   /* U+4192 */
  0x0020,   /* U+4193 */
  0x0020,   /* U+4194 */
  0x0020,   /* U+4195 */
  0x0020,   /* U+4196 */
  0x0020,   /* U+4197 */
  0x0020,   /* U+4198 */
  0x0020,   /* U+4199 */
  0x0020,   /* U+419A */
  0x0020,   /* U+419B */
  0x0020,   /* U+419C */
  0x0020,   /* U+419D */
  0x0020,   /* U+419E */
  0x0020,   /* U+419F */
  0x0020,   /* U+41A0 */
  0x0020,   /* U+41A1 */
  0x0020,   /* U+41A2 */
  0x0020,   /* U+41A3 */
  0x0020,   /* U+41A4 */
  0x0020,   /* U+41A5 */
  0x0020,   /* U+41A6 */
  0x0020,   /* U+41A7 */
  0x0020,   /* U+41A8 */
  0x0020,   /* U+41A9 */
  0x0020,   /* U+41AA */
  0x0020,   /* U+41AB */
  0x0020,   /* U+41AC */
  0x0020,   /* U+41AD */
  0x0020,   /* U+41AE */
  0x0020,   /* U+41AF */
  0x0020,   /* U+41B0 */
  0x0020,   /* U+41B1 */
  0x0020,   /* U+41B2 */
  0x0020,   /* U+41B3 */
  0x0020,   /* U+41B4 */
  0x0020,   /* U+41B5 */
  0x0020,   /* U+41B6 */
  0x0020,   /* U+41B7 */
  0x0020,   /* U+41B8 */
  0x0020,   /* U+41B9 */
  0x0020,   /* U+41BA */
  0x0020,   /* U+41BB */
  0x0020,   /* U+41BC */
  0x0020,   /* U+41BD */
  0x0020,   /* U+41BE */
  0x0020,   /* U+41BF */
  0x0020,   /* U+41C0 */
  0x0020,   /* U+41C1 */
  0x0020,   /* U+41C2 */
  0x0020,   /* U+41C3 */
  0x0020,   /* U+41C4 */
  0x0020,   /* U+41C5 */
  0x0020,   /* U+41C6 */
  0x0020,   /* U+41C7 */
  0x0020,   /* U+41C8 */
  0x0020,   /* U+41C9 */
  0x0020,   /* U+41CA */
  0x0020,   /* U+41CB */
  0x0020,   /* U+41CC */
  0x0020,   /* U+41CD */
  0x0020,   /* U+41CE */
  0x0020,   /* U+41CF */
  0x0020,   /* U+41D0 */
  0x0020,   /* U+41D1 */
  0x0020,   /* U+41D2 */
  0x0020,   /* U+41D3 */
  0x0020,   /* U+41D4 */
  0x0020,   /* U+41D5 */
  0x0020,   /* U+41D6 */
  0x0020,   /* U+41D7 */
  0x0020,   /* U+41D8 */
  0x0020,   /* U+41D9 */
  0x0020,   /* U+41DA */
  0x0020,   /* U+41DB */
  0x0020,   /* U+41DC */
  0x0020,   /* U+41DD */
  0x0020,   /* U+41DE */
  0x0020,   /* U+41DF */
  0x0020,   /* U+41E0 */
  0x0020,   /* U+41E1 */
  0x0020,   /* U+41E2 */
  0x0020,   /* U+41E3 */
  0x0020,   /* U+41E4 */
  0x0020,   /* U+41E5 */
  0x0020,   /* U+41E6 */
  0x0020,   /* U+41E7 */
  0x0020,   /* U+41E8 */
  0x0020,   /* U+41E9 */
  0x0020,   /* U+41EA */
  0x0020,   /* U+41EB */
  0x0020,   /* U+41EC */
  0x0020,   /* U+41ED */
  0x0020,   /* U+41EE */
  0x0020,   /* U+41EF */
  0x0020,   /* U+41F0 */
  0x0020,   /* U+41F1 */
  0x0020,   /* U+41F2 */
  0x0020,   /* U+41F3 */
  0x0020,   /* U+41F4 */
  0x0020,   /* U+41F5 */
  0x0020,   /* U+41F6 */
  0x0020,   /* U+41F7 */
  0x0020,   /* U+41F8 */
  0x0020,   /* U+41F9 */
  0x0020,   /* U+41FA */
  0x0020,   /* U+41FB */
  0x0020,   /* U+41FC */
  0x0020,   /* U+41FD */
  0x0020,   /* U+41FE */
  0x0020,   /* U+41FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4100 */
  0x0002,   /* U+4101 */
  0x0002,   /* U+4102 */
  0x0002,   /* U+4103 */
  0x0002,   /* U+4104 */
  0x0002,   /* U+4105 */
  0x0002,   /* U+4106 */
  0x0002,   /* U+4107 */
  0x0002,   /* U+4108 */
  0x0002,   /* U+4109 */
  0x0002,   /* U+410A */
  0x0002,   /* U+410B */
  0x0002,   /* U+410C */
  0x0002,   /* U+410D */
  0x0002,   /* U+410E */
  0x0002,   /* U+410F */
  0x0002,   /* U+4110 */
  0x0002,   /* U+4111 */
  0x0002,   /* U+4112 */
  0x0002,   /* U+4113 */
  0x0002,   /* U+4114 */
  0x0002,   /* U+4115 */
  0x0002,   /* U+4116 */
  0x0002,   /* U+4117 */
  0x0002,   /* U+4118 */
  0x0002,   /* U+4119 */
  0x0002,   /* U+411A */
  0x0002,   /* U+411B */
  0x0002,   /* U+411C */
  0x0002,   /* U+411D */
  0x0002,   /* U+411E */
  0x0002,   /* U+411F */
  0x0002,   /* U+4120 */
  0x0002,   /* U+4121 */
  0x0002,   /* U+4122 */
  0x0002,   /* U+4123 */
  0x0002,   /* U+4124 */
  0x0002,   /* U+4125 */
  0x0002,   /* U+4126 */
  0x0002,   /* U+4127 */
  0x0002,   /* U+4128 */
  0x0002,   /* U+4129 */
  0x0002,   /* U+412A */
  0x0002,   /* U+412B */
  0x0002,   /* U+412C */
  0x0002,   /* U+412D */
  0x0002,   /* U+412E */
  0x0002,   /* U+412F */
  0x0002,   /* U+4130 */
  0x0002,   /* U+4131 */
  0x0002,   /* U+4132 */
  0x0002,   /* U+4133 */
  0x0002,   /* U+4134 */
  0x0002,   /* U+4135 */
  0x0002,   /* U+4136 */
  0x0002,   /* U+4137 */
  0x0002,   /* U+4138 */
  0x0002,   /* U+4139 */
  0x0002,   /* U+413A */
  0x0002,   /* U+413B */
  0x0002,   /* U+413C */
  0x0002,   /* U+413D */
  0x0002,   /* U+413E */
  0x0002,   /* U+413F */
  0x0002,   /* U+4140 */
  0x0002,   /* U+4141 */
  0x0002,   /* U+4142 */
  0x0002,   /* U+4143 */
  0x0002,   /* U+4144 */
  0x0002,   /* U+4145 */
  0x0002,   /* U+4146 */
  0x0002,   /* U+4147 */
  0x0002,   /* U+4148 */
  0x0002,   /* U+4149 */
  0x0002,   /* U+414A */
  0x0002,   /* U+414B */
  0x0002,   /* U+414C */
  0x0002,   /* U+414D */
  0x0002,   /* U+414E */
  0x0002,   /* U+414F */
  0x0002,   /* U+4150 */
  0x0002,   /* U+4151 */
  0x0002,   /* U+4152 */
  0x0002,   /* U+4153 */
  0x0002,   /* U+4154 */
  0x0002,   /* U+4155 */
  0x0002,   /* U+4156 */
  0x0002,   /* U+4157 */
  0x0002,   /* U+4158 */
  0x0002,   /* U+4159 */
  0x0002,   /* U+415A */
  0x0002,   /* U+415B */
  0x0002,   /* U+415C */
  0x0002,   /* U+415D */
  0x0002,   /* U+415E */
  0x0002,   /* U+415F */
  0x0002,   /* U+4160 */
  0x0002,   /* U+4161 */
  0x0002,   /* U+4162 */
  0x0002,   /* U+4163 */
  0x0002,   /* U+4164 */
  0x0002,   /* U+4165 */
  0x0002,   /* U+4166 */
  0x0002,   /* U+4167 */
  0x0002,   /* U+4168 */
  0x0002,   /* U+4169 */
  0x0002,   /* U+416A */
  0x0002,   /* U+416B */
  0x0002,   /* U+416C */
  0x0002,   /* U+416D */
  0x0002,   /* U+416E */
  0x0002,   /* U+416F */
  0x0002,   /* U+4170 */
  0x0002,   /* U+4171 */
  0x0002,   /* U+4172 */
  0x0002,   /* U+4173 */
  0x0002,   /* U+4174 */
  0x0002,   /* U+4175 */
  0x0002,   /* U+4176 */
  0x0002,   /* U+4177 */
  0x0002,   /* U+4178 */
  0x0002,   /* U+4179 */
  0x0002,   /* U+417A */
  0x0002,   /* U+417B */
  0x0002,   /* U+417C */
  0x0002,   /* U+417D */
  0x0002,   /* U+417E */
  0x0002,   /* U+417F */
  0x0002,   /* U+4180 */
  0x0002,   /* U+4181 */
  0x0002,   /* U+4182 */
  0x0002,   /* U+4183 */
  0x0002,   /* U+4184 */
  0x0002,   /* U+4185 */
  0x0002,   /* U+4186 */
  0x0002,   /* U+4187 */
  0x0002,   /* U+4188 */
  0x0002,   /* U+4189 */
  0x0002,   /* U+418A */
  0x0002,   /* U+418B */
  0x0002,   /* U+418C */
  0x0002,   /* U+418D */
  0x0002,   /* U+418E */
  0x0002,   /* U+418F */
  0x0002,   /* U+4190 */
  0x0002,   /* U+4191 */
  0x0002,   /* U+4192 */
  0x0002,   /* U+4193 */
  0x0002,   /* U+4194 */
  0x0002,   /* U+4195 */
  0x0002,   /* U+4196 */
  0x0002,   /* U+4197 */
  0x0002,   /* U+4198 */
  0x0002,   /* U+4199 */
  0x0002,   /* U+419A */
  0x0002,   /* U+419B */
  0x0002,   /* U+419C */
  0x0002,   /* U+419D */
  0x0002,   /* U+419E */
  0x0002,   /* U+419F */
  0x0002,   /* U+41A0 */
  0x0002,   /* U+41A1 */
  0x0002,   /* U+41A2 */
  0x0002,   /* U+41A3 */
  0x0002,   /* U+41A4 */
  0x0002,   /* U+41A5 */
  0x0002,   /* U+41A6 */
  0x0002,   /* U+41A7 */
  0x0002,   /* U+41A8 */
  0x0002,   /* U+41A9 */
  0x0002,   /* U+41AA */
  0x0002,   /* U+41AB */
  0x0002,   /* U+41AC */
  0x0002,   /* U+41AD */
  0x0002,   /* U+41AE */
  0x0002,   /* U+41AF */
  0x0002,   /* U+41B0 */
  0x0002,   /* U+41B1 */
  0x0002,   /* U+41B2 */
  0x0002,   /* U+41B3 */
  0x0002,   /* U+41B4 */
  0x0002,   /* U+41B5 */
  0x0002,   /* U+41B6 */
  0x0002,   /* U+41B7 */
  0x0002,   /* U+41B8 */
  0x0002,   /* U+41B9 */
  0x0002,   /* U+41BA */
  0x0002,   /* U+41BB */
  0x0002,   /* U+41BC */
  0x0002,   /* U+41BD */
  0x0002,   /* U+41BE */
  0x0002,   /* U+41BF */
  0x0002,   /* U+41C0 */
  0x0002,   /* U+41C1 */
  0x0002,   /* U+41C2 */
  0x0002,   /* U+41C3 */
  0x0002,   /* U+41C4 */
  0x0002,   /* U+41C5 */
  0x0002,   /* U+41C6 */
  0x0002,   /* U+41C7 */
  0x0002,   /* U+41C8 */
  0x0002,   /* U+41C9 */
  0x0002,   /* U+41CA */
  0x0002,   /* U+41CB */
  0x0002,   /* U+41CC */
  0x0002,   /* U+41CD */
  0x0002,   /* U+41CE */
  0x0002,   /* U+41CF */
  0x0002,   /* U+41D0 */
  0x0002,   /* U+41D1 */
  0x0002,   /* U+41D2 */
  0x0002,   /* U+41D3 */
  0x0002,   /* U+41D4 */
  0x0002,   /* U+41D5 */
  0x0002,   /* U+41D6 */
  0x0002,   /* U+41D7 */
  0x0002,   /* U+41D8 */
  0x0002,   /* U+41D9 */
  0x0002,   /* U+41DA */
  0x0002,   /* U+41DB */
  0x0002,   /* U+41DC */
  0x0002,   /* U+41DD */
  0x0002,   /* U+41DE */
  0x0002,   /* U+41DF */
  0x0002,   /* U+41E0 */
  0x0002,   /* U+41E1 */
  0x0002,   /* U+41E2 */
  0x0002,   /* U+41E3 */
  0x0002,   /* U+41E4 */
  0x0002,   /* U+41E5 */
  0x0002,   /* U+41E6 */
  0x0002,   /* U+41E7 */
  0x0002,   /* U+41E8 */
  0x0002,   /* U+41E9 */
  0x0002,   /* U+41EA */
  0x0002,   /* U+41EB */
  0x0002,   /* U+41EC */
  0x0002,   /* U+41ED */
  0x0002,   /* U+41EE */
  0x0002,   /* U+41EF */
  0x0002,   /* U+41F0 */
  0x0002,   /* U+41F1 */
  0x0002,   /* U+41F2 */
  0x0002,   /* U+41F3 */
  0x0002,   /* U+41F4 */
  0x0002,   /* U+41F5 */
  0x0002,   /* U+41F6 */
  0x0002,   /* U+41F7 */
  0x0002,   /* U+41F8 */
  0x0002,   /* U+41F9 */
  0x0002,   /* U+41FA */
  0x0002,   /* U+41FB */
  0x0002,   /* U+41FC */
  0x0002,   /* U+41FD */
  0x0002,   /* U+41FE */
  0x0002,   /* U+41FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0xC103,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0xC10A,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0xC116,   /* U+4116 */
  0xC117,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0xC11E,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0xC123,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0xC134,   /* U+4134 */
  0xC135,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0xC168,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0xC16B,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0xC186,   /* U+4186 */
  0xC187,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0xC18C,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0xC1A4,   /* U+41A4 */
  0xC1A5,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0xC1A7,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0xC1B4,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0xC1BC,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0xC1C4,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0xC1C6,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0xC1C9,   /* U+41C9 */
  0xC1CA,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0xC1D5,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0xC1DA,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0xC1DD,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0xC1F3,   /* U+41F3 */
  0xC1F4,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0xC1FF,   /* U+41FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */
};

uint16_t zh_han_p042[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 
  1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x8167,   /* U+4200 */
  0x66DA,   /* U+4201 */
  0x75BD,   /* U+4202 */
  0xB42A,   /* U+4203 */
  0x4363,   /* U+4204 */
  0xAE30,   /* U+4205 */
  0x3015,   /* U+4206 */
  0xB448,   /* U+4207 */
  0x3972,   /* U+4208 */
  0x8298,   /* U+4209 */
  0x62F4,   /* U+420A */
  0x8BA0,   /* U+420B */
  0x7CF5,   /* U+420C */
  0x6891,   /* U+420D */
  0xA5FB,   /* U+420E */
  0x1F32,   /* U+420F */
  0x420B,   /* U+4210 */
  0x40A2,   /* U+4211 */
  0x6E7B,   /* U+4212 */
  0x3E67,   /* U+4213 */
  0xBDC1,   /* U+4214 */
  0x85AD,   /* U+4215 */
  0x586B,   /* U+4216 */
  0x8B2E,   /* U+4217 */
  0x2D7D,   /* U+4218 */
  0xB904,   /* U+4219 */
  0x8BFE,   /* U+421A */
  0x59EF,   /* U+421B */
  0x7B77,   /* U+421C */
  0x9F4C,   /* U+421D */
  0x356A,   /* U+421E */
  0x25D4,   /* U+421F */
  0x48C3,   /* U+4220 */
  0x2DF1,   /* U+4221 */
  0x8154,   /* U+4222 */
  0xB611,   /* U+4223 */
  0x7943,   /* U+4224 */
  0x5283,   /* U+4225 */
  0xBC3A,   /* U+4226 */
  0x9467,   /* U+4227 */
  0xBDC1,   /* U+4228 */
  0xBDC1,   /* U+4229 */
  0x98DC,   /* U+422A */
  0x6E13,   /* U+422B */
  0x7689,   /* U+422C */
  0x8958,   /* U+422D */
  0x55A1,   /* U+422E */
  0xB52B,   /* U+422F */
  0x83A9,   /* U+4230 */
  0x8D57,   /* U+4231 */
  0x1E96,   /* U+4232 */
  0x8BB3,   /* U+4233 */
  0x79A4,   /* U+4234 */
  0x9581,   /* U+4235 */
  0x7FBB,   /* U+4236 */
  0x676C,   /* U+4237 */
  0x473B,   /* U+4238 */
  0x897F,   /* U+4239 */
  0xB845,   /* U+423A */
  0x768F,   /* U+423B */
  0x6BD6,   /* U+423C */
  0x528B,   /* U+423D */
  0x83AB,   /* U+423E */
  0x6B1F,   /* U+423F */
  0x877B,   /* U+4240 */
  0x6311,   /* U+4241 */
  0x5DC7,   /* U+4242 */
  0x5032,   /* U+4243 */
  0x5E1D,   /* U+4244 */
  0xB7E9,   /* U+4245 */
  0x3357,   /* U+4246 */
  0xBDC1,   /* U+4247 */
  0x817D,   /* U+4248 */
  0x3FF5,   /* U+4249 */
  0x390B,   /* U+424A */
  0x69B3,   /* U+424B */
  0x8AB3,   /* U+424C */
  0x4F4E,   /* U+424D */
  0x8D0B,   /* U+424E */
  0x9D91,   /* U+424F */
  0x5989,   /* U+4250 */
  0x9662,   /* U+4251 */
  0x38BA,   /* U+4252 */
  0x6774,   /* U+4253 */
  0x2508,   /* U+4254 */
  0x25FE,   /* U+4255 */
  0x6316,   /* U+4256 */
  0xA67A,   /* U+4257 */
  0x2E2D,   /* U+4258 */
  0xB047,   /* U+4259 */
  0x6A14,   /* U+425A */
  0xAE8C,   /* U+425B */
  0xB803,   /* U+425C */
  0xA77B,   /* U+425D */
  0x3080,   /* U+425E */
  0x4B6B,   /* U+425F */
  0x9413,   /* U+4260 */
  0x8C7B,   /* U+4261 */
  0x8225,   /* U+4262 */
  0x9D84,   /* U+4263 */
  0x8983,   /* U+4264 */
  0x8923,   /* U+4265 */
  0x7909,   /* U+4266 */
  0x63C5,   /* U+4267 */
  0xA910,   /* U+4268 */
  0xBDC1,   /* U+4269 */
  0x5E07,   /* U+426A */
  0x5EAF,   /* U+426B */
  0x39CE,   /* U+426C */
  0x6210,   /* U+426D */
  0x629A,   /* U+426E */
  0x9B0A,   /* U+426F */
  0x9C77,   /* U+4270 */
  0x7211,   /* U+4271 */
  0x6AB6,   /* U+4272 */
  0x99EF,   /* U+4273 */
  0x7EE0,   /* U+4274 */
  0xBA60,   /* U+4275 */
  0x87C7,   /* U+4276 */
  0xA2F1,   /* U+4277 */
  0x2239,   /* U+4278 */
  0x6351,   /* U+4279 */
  0x45E1,   /* U+427A */
  0x7734,   /* U+427B */
  0x61A2,   /* U+427C */
  0x1EAD,   /* U+427D */
  0x2108,   /* U+427E */
  0x46F9,   /* U+427F */
  0x46FA,   /* U+4280 */
  0xBDC1,   /* U+4281 */
  0x25C4,   /* U+4282 */
  0x736B,   /* U+4283 */
  0x7BFA,   /* U+4284 */
  0x6C5A,   /* U+4285 */
  0x5458,   /* U+4286 */
  0x249E,   /* U+4287 */
  0x6963,   /* U+4288 */
  0x8175,   /* U+4289 */
  0x94BB,   /* U+428A */
  0xBDC1,   /* U+428B */
  0xBDC1,   /* U+428C */
  0x5E69,   /* U+428D */
  0x7E19,   /* U+428E */
  0xBDC1,   /* U+428F */
  0x4AD3,   /* U+4290 */
  0x9B5F,   /* U+4291 */
  0xBDC1,   /* U+4292 */
  0x8653,   /* U+4293 */
  0xAAAF,   /* U+4294 */
  0xBDC1,   /* U+4295 */
  0x6E7C,   /* U+4296 */
  0x494D,   /* U+4297 */
  0x5464,   /* U+4298 */
  0xA271,   /* U+4299 */
  0xBDC1,   /* U+429A */
  0x812D,   /* U+429B */
  0x9112,   /* U+429C */
  0x9D79,   /* U+429D */
  0xB4AE,   /* U+429E */
  0x69C7,   /* U+429F */
  0x98E7,   /* U+42A0 */
  0x681E,   /* U+42A1 */
  0xBDC1,   /* U+42A2 */
  0x4960,   /* U+42A3 */
  0x8C74,   /* U+42A4 */
  0x9C6C,   /* U+42A5 */
  0xA61E,   /* U+42A6 */
  0x2197,   /* U+42A7 */
  0x6706,   /* U+42A8 */
  0x38BB,   /* U+42A9 */
  0x5FE1,   /* U+42AA */
  0x2ED7,   /* U+42AB */
  0x2C24,   /* U+42AC */
  0x317B,   /* U+42AD */
  0x3232,   /* U+42AE */
  0x5A67,   /* U+42AF */
  0x2BB8,   /* U+42B0 */
  0x99F0,   /* U+42B1 */
  0x2776,   /* U+42B2 */
  0x6ABF,   /* U+42B3 */
  0x79AD,   /* U+42B4 */
  0x7C69,   /* U+42B5 */
  0xB573,   /* U+42B6 */
  0xBDC1,   /* U+42B7 */
  0xBDC1,   /* U+42B8 */
  0xBDC1,   /* U+42B9 */
  0x479D,   /* U+42BA */
  0x3D17,   /* U+42BB */
  0x2A1B,   /* U+42BC */
  0x40CB,   /* U+42BD */
  0x6D9A,   /* U+42BE */
  0x23B9,   /* U+42BF */
  0x4823,   /* U+42C0 */
  0x3ED3,   /* U+42C1 */
  0xA4D1,   /* U+42C2 */
  0x690B,   /* U+42C3 */
  0x936A,   /* U+42C4 */
  0xBDC1,   /* U+42C5 */
  0xBDC1,   /* U+42C6 */
  0xBDC1,   /* U+42C7 */
  0x8036,   /* U+42C8 */
  0xA0E4,   /* U+42C9 */
  0xB5BD,   /* U+42CA */
  0x6BFF,   /* U+42CB */
  0x5022,   /* U+42CC */
  0xBDC1,   /* U+42CD */
  0xB38E,   /* U+42CE */
  0xBD7E,   /* U+42CF */
  0xAFB5,   /* U+42D0 */
  0x61DE,   /* U+42D1 */
  0xBDC1,   /* U+42D2 */
  0xB8F3,   /* U+42D3 */
  0x2109,   /* U+42D4 */
  0x7F5E,   /* U+42D5 */
  0xAE0A,   /* U+42D6 */
  0xBDC1,   /* U+42D7 */
  0x2D30,   /* U+42D8 */
  0x381B,   /* U+42D9 */
  0xA845,   /* U+42DA */
  0x6AD4,   /* U+42DB */
  0x7BC9,   /* U+42DC */
  0xBDC1,   /* U+42DD */
  0x9375,   /* U+42DE */
  0x4D68,   /* U+42DF */
  0x246C,   /* U+42E0 */
  0xBDC1,   /* U+42E1 */
  0x229F,   /* U+42E2 */
  0x38A5,   /* U+42E3 */
  0xAFC6,   /* U+42E4 */
  0x5E50,   /* U+42E5 */
  0x38A6,   /* U+42E6 */
  0x7D39,   /* U+42E7 */
  0x3C12,   /* U+42E8 */
  0x3800,   /* U+42E9 */
  0x36F4,   /* U+42EA */
  0xB5D3,   /* U+42EB */
  0x8E98,   /* U+42EC */
  0xAE32,   /* U+42ED */
  0x52F1,   /* U+42EE */
  0x77EF,   /* U+42EF */
  0x54F5,   /* U+42F0 */
  0x5BE4,   /* U+42F1 */
  0x2845,   /* U+42F2 */
  0x1FAE,   /* U+42F3 */
  0x7131,   /* U+42F4 */
  0xA89B,   /* U+42F5 */
  0x9F8A,   /* U+42F6 */
  0x6D4B,   /* U+42F7 */
  0xA17B,   /* U+42F8 */
  0x3BC0,   /* U+42F9 */
  0xBDC1,   /* U+42FA */
  0x70D2,   /* U+42FB */
  0x8F85,   /* U+42FC */
  0x205D,   /* U+42FD */
  0xB2A6,   /* U+42FE */
  0x93BC,   /* U+42FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4200 */
  0x0020,   /* U+4201 */
  0x0020,   /* U+4202 */
  0x0020,   /* U+4203 */
  0x0020,   /* U+4204 */
  0x0020,   /* U+4205 */
  0x0020,   /* U+4206 */
  0x0020,   /* U+4207 */
  0x0020,   /* U+4208 */
  0x0020,   /* U+4209 */
  0x0020,   /* U+420A */
  0x0020,   /* U+420B */
  0x0020,   /* U+420C */
  0x0020,   /* U+420D */
  0x0020,   /* U+420E */
  0x0020,   /* U+420F */
  0x0020,   /* U+4210 */
  0x0020,   /* U+4211 */
  0x0020,   /* U+4212 */
  0x0020,   /* U+4213 */
  0x0020,   /* U+4214 */
  0x0020,   /* U+4215 */
  0x0020,   /* U+4216 */
  0x0020,   /* U+4217 */
  0x0020,   /* U+4218 */
  0x0020,   /* U+4219 */
  0x0020,   /* U+421A */
  0x0020,   /* U+421B */
  0x0020,   /* U+421C */
  0x0020,   /* U+421D */
  0x0020,   /* U+421E */
  0x0020,   /* U+421F */
  0x0020,   /* U+4220 */
  0x0020,   /* U+4221 */
  0x0020,   /* U+4222 */
  0x0020,   /* U+4223 */
  0x0020,   /* U+4224 */
  0x0020,   /* U+4225 */
  0x0020,   /* U+4226 */
  0x0020,   /* U+4227 */
  0x0020,   /* U+4228 */
  0x0020,   /* U+4229 */
  0x0020,   /* U+422A */
  0x0020,   /* U+422B */
  0x0020,   /* U+422C */
  0x0020,   /* U+422D */
  0x0020,   /* U+422E */
  0x0020,   /* U+422F */
  0x0020,   /* U+4230 */
  0x0020,   /* U+4231 */
  0x0020,   /* U+4232 */
  0x0020,   /* U+4233 */
  0x0020,   /* U+4234 */
  0x0020,   /* U+4235 */
  0x0020,   /* U+4236 */
  0x0020,   /* U+4237 */
  0x0020,   /* U+4238 */
  0x0020,   /* U+4239 */
  0x0020,   /* U+423A */
  0x0020,   /* U+423B */
  0x0020,   /* U+423C */
  0x0020,   /* U+423D */
  0x0020,   /* U+423E */
  0x0020,   /* U+423F */
  0x0020,   /* U+4240 */
  0x0020,   /* U+4241 */
  0x0020,   /* U+4242 */
  0x0020,   /* U+4243 */
  0x0020,   /* U+4244 */
  0x0020,   /* U+4245 */
  0x0020,   /* U+4246 */
  0x0020,   /* U+4247 */
  0x0020,   /* U+4248 */
  0x0020,   /* U+4249 */
  0x0020,   /* U+424A */
  0x0020,   /* U+424B */
  0x0020,   /* U+424C */
  0x0020,   /* U+424D */
  0x0020,   /* U+424E */
  0x0020,   /* U+424F */
  0x0020,   /* U+4250 */
  0x0020,   /* U+4251 */
  0x0020,   /* U+4252 */
  0x0020,   /* U+4253 */
  0x0020,   /* U+4254 */
  0x0020,   /* U+4255 */
  0x0020,   /* U+4256 */
  0x0020,   /* U+4257 */
  0x0020,   /* U+4258 */
  0x0020,   /* U+4259 */
  0x0020,   /* U+425A */
  0x0020,   /* U+425B */
  0x0020,   /* U+425C */
  0x0020,   /* U+425D */
  0x0020,   /* U+425E */
  0x0020,   /* U+425F */
  0x0020,   /* U+4260 */
  0x0020,   /* U+4261 */
  0x0020,   /* U+4262 */
  0x0020,   /* U+4263 */
  0x0020,   /* U+4264 */
  0x0020,   /* U+4265 */
  0x0020,   /* U+4266 */
  0x0020,   /* U+4267 */
  0x0020,   /* U+4268 */
  0x0020,   /* U+4269 */
  0x0020,   /* U+426A */
  0x0020,   /* U+426B */
  0x0020,   /* U+426C */
  0x0020,   /* U+426D */
  0x0020,   /* U+426E */
  0x0020,   /* U+426F */
  0x0020,   /* U+4270 */
  0x0020,   /* U+4271 */
  0x0020,   /* U+4272 */
  0x0020,   /* U+4273 */
  0x0020,   /* U+4274 */
  0x0020,   /* U+4275 */
  0x0020,   /* U+4276 */
  0x0020,   /* U+4277 */
  0x0020,   /* U+4278 */
  0x0020,   /* U+4279 */
  0x0020,   /* U+427A */
  0x0020,   /* U+427B */
  0x0020,   /* U+427C */
  0x0020,   /* U+427D */
  0x0020,   /* U+427E */
  0x0020,   /* U+427F */
  0x0020,   /* U+4280 */
  0x0020,   /* U+4281 */
  0x0020,   /* U+4282 */
  0x0020,   /* U+4283 */
  0x0020,   /* U+4284 */
  0x0020,   /* U+4285 */
  0x0020,   /* U+4286 */
  0x0020,   /* U+4287 */
  0x0020,   /* U+4288 */
  0x0020,   /* U+4289 */
  0x0020,   /* U+428A */
  0x0020,   /* U+428B */
  0x0020,   /* U+428C */
  0x0020,   /* U+428D */
  0x0020,   /* U+428E */
  0x0020,   /* U+428F */
  0x0020,   /* U+4290 */
  0x0020,   /* U+4291 */
  0x0020,   /* U+4292 */
  0x0020,   /* U+4293 */
  0x0020,   /* U+4294 */
  0x0020,   /* U+4295 */
  0x0020,   /* U+4296 */
  0x0020,   /* U+4297 */
  0x0020,   /* U+4298 */
  0x0020,   /* U+4299 */
  0x0020,   /* U+429A */
  0x0020,   /* U+429B */
  0x0020,   /* U+429C */
  0x0020,   /* U+429D */
  0x0020,   /* U+429E */
  0x0020,   /* U+429F */
  0x0020,   /* U+42A0 */
  0x0020,   /* U+42A1 */
  0x0020,   /* U+42A2 */
  0x0020,   /* U+42A3 */
  0x0020,   /* U+42A4 */
  0x0020,   /* U+42A5 */
  0x0020,   /* U+42A6 */
  0x0020,   /* U+42A7 */
  0x0020,   /* U+42A8 */
  0x0020,   /* U+42A9 */
  0x0020,   /* U+42AA */
  0x0020,   /* U+42AB */
  0x0020,   /* U+42AC */
  0x0020,   /* U+42AD */
  0x0020,   /* U+42AE */
  0x0020,   /* U+42AF */
  0x0020,   /* U+42B0 */
  0x0020,   /* U+42B1 */
  0x0020,   /* U+42B2 */
  0x0020,   /* U+42B3 */
  0x0020,   /* U+42B4 */
  0x0020,   /* U+42B5 */
  0x0020,   /* U+42B6 */
  0x0020,   /* U+42B7 */
  0x0020,   /* U+42B8 */
  0x0020,   /* U+42B9 */
  0x0020,   /* U+42BA */
  0x0020,   /* U+42BB */
  0x0020,   /* U+42BC */
  0x0020,   /* U+42BD */
  0x0020,   /* U+42BE */
  0x0020,   /* U+42BF */
  0x0020,   /* U+42C0 */
  0x0020,   /* U+42C1 */
  0x0020,   /* U+42C2 */
  0x0020,   /* U+42C3 */
  0x0020,   /* U+42C4 */
  0x0020,   /* U+42C5 */
  0x0020,   /* U+42C6 */
  0x0020,   /* U+42C7 */
  0x0020,   /* U+42C8 */
  0x0020,   /* U+42C9 */
  0x0020,   /* U+42CA */
  0x0020,   /* U+42CB */
  0x0020,   /* U+42CC */
  0x0020,   /* U+42CD */
  0x0020,   /* U+42CE */
  0x0020,   /* U+42CF */
  0x0020,   /* U+42D0 */
  0x0020,   /* U+42D1 */
  0x0020,   /* U+42D2 */
  0x0020,   /* U+42D3 */
  0x0020,   /* U+42D4 */
  0x0020,   /* U+42D5 */
  0x0020,   /* U+42D6 */
  0x0020,   /* U+42D7 */
  0x0020,   /* U+42D8 */
  0x0020,   /* U+42D9 */
  0x0020,   /* U+42DA */
  0x0020,   /* U+42DB */
  0x0020,   /* U+42DC */
  0x0020,   /* U+42DD */
  0x0020,   /* U+42DE */
  0x0020,   /* U+42DF */
  0x0020,   /* U+42E0 */
  0x0020,   /* U+42E1 */
  0x0020,   /* U+42E2 */
  0x0020,   /* U+42E3 */
  0x0020,   /* U+42E4 */
  0x0020,   /* U+42E5 */
  0x0020,   /* U+42E6 */
  0x0020,   /* U+42E7 */
  0x0020,   /* U+42E8 */
  0x0020,   /* U+42E9 */
  0x0020,   /* U+42EA */
  0x0020,   /* U+42EB */
  0x0020,   /* U+42EC */
  0x0020,   /* U+42ED */
  0x0020,   /* U+42EE */
  0x0020,   /* U+42EF */
  0x0020,   /* U+42F0 */
  0x0020,   /* U+42F1 */
  0x0020,   /* U+42F2 */
  0x0020,   /* U+42F3 */
  0x0020,   /* U+42F4 */
  0x0020,   /* U+42F5 */
  0x0020,   /* U+42F6 */
  0x0020,   /* U+42F7 */
  0x0020,   /* U+42F8 */
  0x0020,   /* U+42F9 */
  0x0020,   /* U+42FA */
  0x0020,   /* U+42FB */
  0x0020,   /* U+42FC */
  0x0020,   /* U+42FD */
  0x0020,   /* U+42FE */
  0x0020,   /* U+42FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4200 */
  0x0002,   /* U+4201 */
  0x0002,   /* U+4202 */
  0x0002,   /* U+4203 */
  0x0002,   /* U+4204 */
  0x0002,   /* U+4205 */
  0x0002,   /* U+4206 */
  0x0002,   /* U+4207 */
  0x0002,   /* U+4208 */
  0x0002,   /* U+4209 */
  0x0002,   /* U+420A */
  0x0002,   /* U+420B */
  0x0002,   /* U+420C */
  0x0002,   /* U+420D */
  0x0002,   /* U+420E */
  0x0002,   /* U+420F */
  0x0002,   /* U+4210 */
  0x0002,   /* U+4211 */
  0x0002,   /* U+4212 */
  0x0002,   /* U+4213 */
  0x0002,   /* U+4214 */
  0x0002,   /* U+4215 */
  0x0002,   /* U+4216 */
  0x0002,   /* U+4217 */
  0x0002,   /* U+4218 */
  0x0002,   /* U+4219 */
  0x0002,   /* U+421A */
  0x0002,   /* U+421B */
  0x0002,   /* U+421C */
  0x0002,   /* U+421D */
  0x0002,   /* U+421E */
  0x0002,   /* U+421F */
  0x0002,   /* U+4220 */
  0x0002,   /* U+4221 */
  0x0002,   /* U+4222 */
  0x0002,   /* U+4223 */
  0x0002,   /* U+4224 */
  0x0002,   /* U+4225 */
  0x0002,   /* U+4226 */
  0x0002,   /* U+4227 */
  0x0002,   /* U+4228 */
  0x0002,   /* U+4229 */
  0x0002,   /* U+422A */
  0x0002,   /* U+422B */
  0x0002,   /* U+422C */
  0x0002,   /* U+422D */
  0x0002,   /* U+422E */
  0x0002,   /* U+422F */
  0x0002,   /* U+4230 */
  0x0002,   /* U+4231 */
  0x0002,   /* U+4232 */
  0x0002,   /* U+4233 */
  0x0002,   /* U+4234 */
  0x0002,   /* U+4235 */
  0x0002,   /* U+4236 */
  0x0002,   /* U+4237 */
  0x0002,   /* U+4238 */
  0x0002,   /* U+4239 */
  0x0002,   /* U+423A */
  0x0002,   /* U+423B */
  0x0002,   /* U+423C */
  0x0002,   /* U+423D */
  0x0002,   /* U+423E */
  0x0002,   /* U+423F */
  0x0002,   /* U+4240 */
  0x0002,   /* U+4241 */
  0x0002,   /* U+4242 */
  0x0002,   /* U+4243 */
  0x0002,   /* U+4244 */
  0x0002,   /* U+4245 */
  0x0002,   /* U+4246 */
  0x0002,   /* U+4247 */
  0x0002,   /* U+4248 */
  0x0002,   /* U+4249 */
  0x0002,   /* U+424A */
  0x0002,   /* U+424B */
  0x0002,   /* U+424C */
  0x0002,   /* U+424D */
  0x0002,   /* U+424E */
  0x0002,   /* U+424F */
  0x0002,   /* U+4250 */
  0x0002,   /* U+4251 */
  0x0002,   /* U+4252 */
  0x0002,   /* U+4253 */
  0x0002,   /* U+4254 */
  0x0002,   /* U+4255 */
  0x0002,   /* U+4256 */
  0x0002,   /* U+4257 */
  0x0002,   /* U+4258 */
  0x0002,   /* U+4259 */
  0x0002,   /* U+425A */
  0x0002,   /* U+425B */
  0x0002,   /* U+425C */
  0x0002,   /* U+425D */
  0x0002,   /* U+425E */
  0x0002,   /* U+425F */
  0x0002,   /* U+4260 */
  0x0002,   /* U+4261 */
  0x0002,   /* U+4262 */
  0x0002,   /* U+4263 */
  0x0002,   /* U+4264 */
  0x0002,   /* U+4265 */
  0x0002,   /* U+4266 */
  0x0002,   /* U+4267 */
  0x0002,   /* U+4268 */
  0x0002,   /* U+4269 */
  0x0002,   /* U+426A */
  0x0002,   /* U+426B */
  0x0002,   /* U+426C */
  0x0002,   /* U+426D */
  0x0002,   /* U+426E */
  0x0002,   /* U+426F */
  0x0002,   /* U+4270 */
  0x0002,   /* U+4271 */
  0x0002,   /* U+4272 */
  0x0002,   /* U+4273 */
  0x0002,   /* U+4274 */
  0x0002,   /* U+4275 */
  0x0002,   /* U+4276 */
  0x0002,   /* U+4277 */
  0x0002,   /* U+4278 */
  0x0002,   /* U+4279 */
  0x0002,   /* U+427A */
  0x0002,   /* U+427B */
  0x0002,   /* U+427C */
  0x0002,   /* U+427D */
  0x0002,   /* U+427E */
  0x0002,   /* U+427F */
  0x0002,   /* U+4280 */
  0x0002,   /* U+4281 */
  0x0002,   /* U+4282 */
  0x0002,   /* U+4283 */
  0x0002,   /* U+4284 */
  0x0002,   /* U+4285 */
  0x0002,   /* U+4286 */
  0x0002,   /* U+4287 */
  0x0002,   /* U+4288 */
  0x0002,   /* U+4289 */
  0x0002,   /* U+428A */
  0x0002,   /* U+428B */
  0x0002,   /* U+428C */
  0x0002,   /* U+428D */
  0x0002,   /* U+428E */
  0x0002,   /* U+428F */
  0x0002,   /* U+4290 */
  0x0002,   /* U+4291 */
  0x0002,   /* U+4292 */
  0x0002,   /* U+4293 */
  0x0002,   /* U+4294 */
  0x0002,   /* U+4295 */
  0x0002,   /* U+4296 */
  0x0002,   /* U+4297 */
  0x0002,   /* U+4298 */
  0x0002,   /* U+4299 */
  0x0002,   /* U+429A */
  0x0002,   /* U+429B */
  0x0002,   /* U+429C */
  0x0002,   /* U+429D */
  0x0002,   /* U+429E */
  0x0002,   /* U+429F */
  0x0002,   /* U+42A0 */
  0x0002,   /* U+42A1 */
  0x0002,   /* U+42A2 */
  0x0002,   /* U+42A3 */
  0x0002,   /* U+42A4 */
  0x0002,   /* U+42A5 */
  0x0002,   /* U+42A6 */
  0x0002,   /* U+42A7 */
  0x0002,   /* U+42A8 */
  0x0002,   /* U+42A9 */
  0x0002,   /* U+42AA */
  0x0002,   /* U+42AB */
  0x0002,   /* U+42AC */
  0x0002,   /* U+42AD */
  0x0002,   /* U+42AE */
  0x0002,   /* U+42AF */
  0x0002,   /* U+42B0 */
  0x0002,   /* U+42B1 */
  0x0002,   /* U+42B2 */
  0x0002,   /* U+42B3 */
  0x0002,   /* U+42B4 */
  0x0002,   /* U+42B5 */
  0x0002,   /* U+42B6 */
  0x0002,   /* U+42B7 */
  0x0002,   /* U+42B8 */
  0x0002,   /* U+42B9 */
  0x0002,   /* U+42BA */
  0x0002,   /* U+42BB */
  0x0002,   /* U+42BC */
  0x0002,   /* U+42BD */
  0x0002,   /* U+42BE */
  0x0002,   /* U+42BF */
  0x0002,   /* U+42C0 */
  0x0002,   /* U+42C1 */
  0x0002,   /* U+42C2 */
  0x0002,   /* U+42C3 */
  0x0002,   /* U+42C4 */
  0x0002,   /* U+42C5 */
  0x0002,   /* U+42C6 */
  0x0002,   /* U+42C7 */
  0x0002,   /* U+42C8 */
  0x0002,   /* U+42C9 */
  0x0002,   /* U+42CA */
  0x0002,   /* U+42CB */
  0x0002,   /* U+42CC */
  0x0002,   /* U+42CD */
  0x0002,   /* U+42CE */
  0x0002,   /* U+42CF */
  0x0002,   /* U+42D0 */
  0x0002,   /* U+42D1 */
  0x0002,   /* U+42D2 */
  0x0002,   /* U+42D3 */
  0x0002,   /* U+42D4 */
  0x0002,   /* U+42D5 */
  0x0002,   /* U+42D6 */
  0x0002,   /* U+42D7 */
  0x0002,   /* U+42D8 */
  0x0002,   /* U+42D9 */
  0x0002,   /* U+42DA */
  0x0002,   /* U+42DB */
  0x0002,   /* U+42DC */
  0x0002,   /* U+42DD */
  0x0002,   /* U+42DE */
  0x0002,   /* U+42DF */
  0x0002,   /* U+42E0 */
  0x0002,   /* U+42E1 */
  0x0002,   /* U+42E2 */
  0x0002,   /* U+42E3 */
  0x0002,   /* U+42E4 */
  0x0002,   /* U+42E5 */
  0x0002,   /* U+42E6 */
  0x0002,   /* U+42E7 */
  0x0002,   /* U+42E8 */
  0x0002,   /* U+42E9 */
  0x0002,   /* U+42EA */
  0x0002,   /* U+42EB */
  0x0002,   /* U+42EC */
  0x0002,   /* U+42ED */
  0x0002,   /* U+42EE */
  0x0002,   /* U+42EF */
  0x0002,   /* U+42F0 */
  0x0002,   /* U+42F1 */
  0x0002,   /* U+42F2 */
  0x0002,   /* U+42F3 */
  0x0002,   /* U+42F4 */
  0x0002,   /* U+42F5 */
  0x0002,   /* U+42F6 */
  0x0002,   /* U+42F7 */
  0x0002,   /* U+42F8 */
  0x0002,   /* U+42F9 */
  0x0002,   /* U+42FA */
  0x0002,   /* U+42FB */
  0x0002,   /* U+42FC */
  0x0002,   /* U+42FD */
  0x0002,   /* U+42FE */
  0x0002,   /* U+42FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0xC214,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0xC228,   /* U+4228 */
  0xC229,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0xC247,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0xC269,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0xC281,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0xC28B,   /* U+428B */
  0xC28C,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0xC28F,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0xC292,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0xC295,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0xC29A,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0xC2A2,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0xC2B7,   /* U+42B7 */
  0xC2B8,   /* U+42B8 */
  0xC2B9,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0xC2C5,   /* U+42C5 */
  0xC2C6,   /* U+42C6 */
  0xC2C7,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0xC2CD,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0xC2D2,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0xC2D7,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0xC2DD,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0xC2E1,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0xC2FA,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */
};

uint16_t zh_han_p043[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 

  /* Primary weight 1 for each character. */
  0x586C,   /* U+4300 */
  0xA4B5,   /* U+4301 */
  0x7231,   /* U+4302 */
  0x9BE5,   /* U+4303 */
  0x3EE2,   /* U+4304 */
  0x8CFF,   /* U+4305 */
  0x420F,   /* U+4306 */
  0x4A75,   /* U+4307 */
  0x8B63,   /* U+4308 */
  0xBDC1,   /* U+4309 */
  0xA503,   /* U+430A */
  0x2F81,   /* U+430B */
  0x785C,   /* U+430C */
  0x52B6,   /* U+430D */
  0x66BA,   /* U+430E */
  0x6B20,   /* U+430F */
  0x6B21,   /* U+4310 */
  0x4ECF,   /* U+4311 */
  0x65D0,   /* U+4312 */
  0x38B6,   /* U+4313 */
  0x7209,   /* U+4314 */
  0x6A98,   /* U+4315 */
  0x5209,   /* U+4316 */
  0x3C20,   /* U+4317 */
  0x22D5,   /* U+4318 */
  0x4994,   /* U+4319 */
  0x8995,   /* U+431A */
  0xA50F,   /* U+431B */
  0x70A7,   /* U+431C */
  0x528F,   /* U+431D */
  0x60C1,   /* U+431E */
  0x2421,   /* U+431F */
  0x4EE3,   /* U+4320 */
  0x8E47,   /* U+4321 */
  0x631A,   /* U+4322 */
  0xBD0C,   /* U+4323 */
  0x856F,   /* U+4324 */
  0xA9F6,   /* U+4325 */
  0x317C,   /* U+4326 */
  0x2B55,   /* U+4327 */
  0x24BE,   /* U+4328 */
  0x6BE3,   /* U+4329 */
  0xA36B,   /* U+432A */
  0x5C81,   /* U+432B */
  0x2AEB,   /* U+432C */
  0x50A7,   /* U+432D */
  0x87C6,   /* U+432E */
  0x7DBB,   /* U+432F */
  0x70C1,   /* U+4330 */
  0x677E,   /* U+4331 */
  0xBDC1,   /* U+4332 */
  0x8577,   /* U+4333 */
  0x6781,   /* U+4334 */
  0xB984,   /* U+4335 */
  0xBDC1,   /* U+4336 */
  0x2B08,   /* U+4337 */
  0x55FC,   /* U+4338 */
  0x53DB,   /* U+4339 */
  0x381C,   /* U+433A */
  0xA847,   /* U+433B */
  0x80CE,   /* U+433C */
  0x24EA,   /* U+433D */
  0x7F21,   /* U+433E */
  0x3BC1,   /* U+433F */
  0x5C31,   /* U+4340 */
  0x8AB9,   /* U+4341 */
  0xACD1,   /* U+4342 */
  0xABEE,   /* U+4343 */
  0x32E0,   /* U+4344 */
  0x62D1,   /* U+4345 */
  0xB9D5,   /* U+4346 */
  0x8B8D,   /* U+4347 */
  0x75AC,   /* U+4348 */
  0xB2F8,   /* U+4349 */
  0x5076,   /* U+434A */
  0x2CC0,   /* U+434B */
  0x24A3,   /* U+434C */
  0x5958,   /* U+434D */
  0x2F2A,   /* U+434E */
  0xBDC1,   /* U+434F */
  0x437C,   /* U+4350 */
  0x437D,   /* U+4351 */
  0x6D5B,   /* U+4352 */
  0x4793,   /* U+4353 */
  0x3F0B,   /* U+4354 */
  0x31E5,   /* U+4355 */
  0x3B70,   /* U+4356 */
  0xA0A1,   /* U+4357 */
  0x6A7E,   /* U+4358 */
  0x695B,   /* U+4359 */
  0x5CE5,   /* U+435A */
  0x4067,   /* U+435B */
  0xB444,   /* U+435C */
  0x8B97,   /* U+435D */
  0xAE34,   /* U+435E */
  0xBC75,   /* U+435F */
  0x5E7F,   /* U+4360 */
  0x65C6,   /* U+4361 */
  0x965E,   /* U+4362 */
  0x5D8D,   /* U+4363 */
  0x4D07,   /* U+4364 */
  0x6007,   /* U+4365 */
  0x5EC6,   /* U+4366 */
  0xBDC1,   /* U+4367 */
  0x75DF,   /* U+4368 */
  0xA466,   /* U+4369 */
  0x927C,   /* U+436A */
  0x91F1,   /* U+436B */
  0x7394,   /* U+436C */
  0xBDC1,   /* U+436D */
  0xB43D,   /* U+436E */
  0x41D4,   /* U+436F */
  0xBDC1,   /* U+4370 */
  0x9F6F,   /* U+4371 */
  0x6E1D,   /* U+4372 */
  0x7E57,   /* U+4373 */
  0x9462,   /* U+4374 */
  0xB5D4,   /* U+4375 */
  0x345F,   /* U+4376 */
  0x946B,   /* U+4377 */
  0x23FC,   /* U+4378 */
  0xBDC1,   /* U+4379 */
  0x4902,   /* U+437A */
  0xA0C1,   /* U+437B */
  0xB10D,   /* U+437C */
  0x6016,   /* U+437D */
  0xA312,   /* U+437E */
  0x492B,   /* U+437F */
  0xA110,   /* U+4380 */
  0x46FB,   /* U+4381 */
  0x1F45,   /* U+4382 */
  0x7EC4,   /* U+4383 */
  0x9BBF,   /* U+4384 */
  0x7620,   /* U+4385 */
  0x61A3,   /* U+4386 */
  0xB8A4,   /* U+4387 */
  0xA848,   /* U+4388 */
  0x9FD1,   /* U+4389 */
  0x675D,   /* U+438A */
  0x5833,   /* U+438B */
  0x2BFF,   /* U+438C */
  0xBDC1,   /* U+438D */
  0x6E08,   /* U+438E */
  0x4364,   /* U+438F */
  0x281E,   /* U+4390 */
  0x65A3,   /* U+4391 */
  0xB364,   /* U+4392 */
  0x8BA1,   /* U+4393 */
  0x3B23,   /* U+4394 */
  0x45B7,   /* U+4395 */
  0xB231,   /* U+4396 */
  0x7A69,   /* U+4397 */
  0x8A12,   /* U+4398 */
  0x755A,   /* U+4399 */
  0x4130,   /* U+439A */
  0xBDC1,   /* U+439B */
  0x4ABE,   /* U+439C */
  0x2B91,   /* U+439D */
  0xBDC1,   /* U+439E */
  0x37F1,   /* U+439F */
  0x37F2,   /* U+43A0 */
  0x8090,   /* U+43A1 */
  0x77D8,   /* U+43A2 */
  0x88C8,   /* U+43A3 */
  0x54EF,   /* U+43A4 */
  0xBDC1,   /* U+43A5 */
  0xA341,   /* U+43A6 */
  0x1F09,   /* U+43A7 */
  0xA5F4,   /* U+43A8 */
  0xBB96,   /* U+43A9 */
  0x6F08,   /* U+43AA */
  0x2CA9,   /* U+43AB */
  0x1E30,   /* U+43AC */
  0x2580,   /* U+43AD */
  0x8E79,   /* U+43AE */
  0x43DE,   /* U+43AF */
  0xBD8B,   /* U+43B0 */
  0x1E39,   /* U+43B1 */
  0xB46A,   /* U+43B2 */
  0x9279,   /* U+43B3 */
  0x3EB7,   /* U+43B4 */
  0x210A,   /* U+43B5 */
  0x3834,   /* U+43B6 */
  0xB9DB,   /* U+43B7 */
  0x96E8,   /* U+43B8 */
  0x9532,   /* U+43B9 */
  0xB7AC,   /* U+43BA */
  0xB8FF,   /* U+43BB */
  0x65A4,   /* U+43BC */
  0x9536,   /* U+43BD */
  0x4240,   /* U+43BE */
  0x7CAD,   /* U+43BF */
  0x5BA1,   /* U+43C0 */
  0xB0F3,   /* U+43C1 */
  0x897C,   /* U+43C2 */
  0x6B43,   /* U+43C3 */
  0x3258,   /* U+43C4 */
  0x785D,   /* U+43C5 */
  0x2597,   /* U+43C6 */
  0x753B,   /* U+43C7 */
  0x6092,   /* U+43C8 */
  0x8570,   /* U+43C9 */
  0x6453,   /* U+43CA */
  0x89D6,   /* U+43CB */
  0x7800,   /* U+43CC */
  0xAF60,   /* U+43CD */
  0x3AA3,   /* U+43CE */
  0x9F14,   /* U+43CF */
  0x5650,   /* U+43D0 */
  0x326F,   /* U+43D1 */
  0x7502,   /* U+43D2 */
  0x40F7,   /* U+43D3 */
  0x7121,   /* U+43D4 */
  0x7F4F,   /* U+43D5 */
  0xB56E,   /* U+43D6 */
  0x3CE9,   /* U+43D7 */
  0x74A5,   /* U+43D8 */
  0x8C8C,   /* U+43D9 */
  0x2816,   /* U+43DA */
  0x2D0B,   /* U+43DB */
  0x4497,   /* U+43DC */
  0xBA18,   /* U+43DD */
  0x6CD5,   /* U+43DE */
  0x22B8,   /* U+43DF */
  0x7816,   /* U+43E0 */
  0x8612,   /* U+43E1 */
  0x20AD,   /* U+43E2 */
  0x5658,   /* U+43E3 */
  0x88BC,   /* U+43E4 */
  0xBDC1,   /* U+43E5 */
  0x407B,   /* U+43E6 */
  0x6DF2,   /* U+43E7 */
  0x49FC,   /* U+43E8 */
  0x974C,   /* U+43E9 */
  0x3833,   /* U+43EA */
  0x9EC4,   /* U+43EB */
  0x6D40,   /* U+43EC */
  0xBDC1,   /* U+43ED */
  0x9825,   /* U+43EE */
  0xB760,   /* U+43EF */
  0x80E1,   /* U+43F0 */
  0x54E1,   /* U+43F1 */
  0x33A3,   /* U+43F2 */
  0xB4DA,   /* U+43F3 */
  0x83D1,   /* U+43F4 */
  0x6A43,   /* U+43F5 */
  0x210B,   /* U+43F6 */
  0x43AB,   /* U+43F7 */
  0xACE2,   /* U+43F8 */
  0x9AC2,   /* U+43F9 */
  0x72C8,   /* U+43FA */
  0x6F30,   /* U+43FB */
  0x2519,   /* U+43FC */
  0x249A,   /* U+43FD */
  0xBDC1,   /* U+43FE */
  0x77E7,   /* U+43FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4300 */
  0x0020,   /* U+4301 */
  0x0020,   /* U+4302 */
  0x0020,   /* U+4303 */
  0x0020,   /* U+4304 */
  0x0020,   /* U+4305 */
  0x0020,   /* U+4306 */
  0x0020,   /* U+4307 */
  0x0020,   /* U+4308 */
  0x0020,   /* U+4309 */
  0x0020,   /* U+430A */
  0x0020,   /* U+430B */
  0x0020,   /* U+430C */
  0x0020,   /* U+430D */
  0x0020,   /* U+430E */
  0x0020,   /* U+430F */
  0x0020,   /* U+4310 */
  0x0020,   /* U+4311 */
  0x0020,   /* U+4312 */
  0x0020,   /* U+4313 */
  0x0020,   /* U+4314 */
  0x0020,   /* U+4315 */
  0x0020,   /* U+4316 */
  0x0020,   /* U+4317 */
  0x0020,   /* U+4318 */
  0x0020,   /* U+4319 */
  0x0020,   /* U+431A */
  0x0020,   /* U+431B */
  0x0020,   /* U+431C */
  0x0020,   /* U+431D */
  0x0020,   /* U+431E */
  0x0020,   /* U+431F */
  0x0020,   /* U+4320 */
  0x0020,   /* U+4321 */
  0x0020,   /* U+4322 */
  0x0020,   /* U+4323 */
  0x0020,   /* U+4324 */
  0x0020,   /* U+4325 */
  0x0020,   /* U+4326 */
  0x0020,   /* U+4327 */
  0x0020,   /* U+4328 */
  0x0020,   /* U+4329 */
  0x0020,   /* U+432A */
  0x0020,   /* U+432B */
  0x0020,   /* U+432C */
  0x0020,   /* U+432D */
  0x0020,   /* U+432E */
  0x0020,   /* U+432F */
  0x0020,   /* U+4330 */
  0x0020,   /* U+4331 */
  0x0020,   /* U+4332 */
  0x0020,   /* U+4333 */
  0x0020,   /* U+4334 */
  0x0020,   /* U+4335 */
  0x0020,   /* U+4336 */
  0x0020,   /* U+4337 */
  0x0020,   /* U+4338 */
  0x0020,   /* U+4339 */
  0x0020,   /* U+433A */
  0x0020,   /* U+433B */
  0x0020,   /* U+433C */
  0x0020,   /* U+433D */
  0x0020,   /* U+433E */
  0x0020,   /* U+433F */
  0x0020,   /* U+4340 */
  0x0020,   /* U+4341 */
  0x0020,   /* U+4342 */
  0x0020,   /* U+4343 */
  0x0020,   /* U+4344 */
  0x0020,   /* U+4345 */
  0x0020,   /* U+4346 */
  0x0020,   /* U+4347 */
  0x0020,   /* U+4348 */
  0x0020,   /* U+4349 */
  0x0020,   /* U+434A */
  0x0020,   /* U+434B */
  0x0020,   /* U+434C */
  0x0020,   /* U+434D */
  0x0020,   /* U+434E */
  0x0020,   /* U+434F */
  0x0020,   /* U+4350 */
  0x0020,   /* U+4351 */
  0x0020,   /* U+4352 */
  0x0020,   /* U+4353 */
  0x0020,   /* U+4354 */
  0x0020,   /* U+4355 */
  0x0020,   /* U+4356 */
  0x0020,   /* U+4357 */
  0x0020,   /* U+4358 */
  0x0020,   /* U+4359 */
  0x0020,   /* U+435A */
  0x0020,   /* U+435B */
  0x0020,   /* U+435C */
  0x0020,   /* U+435D */
  0x0020,   /* U+435E */
  0x0020,   /* U+435F */
  0x0020,   /* U+4360 */
  0x0020,   /* U+4361 */
  0x0020,   /* U+4362 */
  0x0020,   /* U+4363 */
  0x0020,   /* U+4364 */
  0x0020,   /* U+4365 */
  0x0020,   /* U+4366 */
  0x0020,   /* U+4367 */
  0x0020,   /* U+4368 */
  0x0020,   /* U+4369 */
  0x0020,   /* U+436A */
  0x0020,   /* U+436B */
  0x0020,   /* U+436C */
  0x0020,   /* U+436D */
  0x0020,   /* U+436E */
  0x0020,   /* U+436F */
  0x0020,   /* U+4370 */
  0x0020,   /* U+4371 */
  0x0020,   /* U+4372 */
  0x0020,   /* U+4373 */
  0x0020,   /* U+4374 */
  0x0020,   /* U+4375 */
  0x0020,   /* U+4376 */
  0x0020,   /* U+4377 */
  0x0020,   /* U+4378 */
  0x0020,   /* U+4379 */
  0x0020,   /* U+437A */
  0x0020,   /* U+437B */
  0x0020,   /* U+437C */
  0x0020,   /* U+437D */
  0x0020,   /* U+437E */
  0x0020,   /* U+437F */
  0x0020,   /* U+4380 */
  0x0020,   /* U+4381 */
  0x0020,   /* U+4382 */
  0x0020,   /* U+4383 */
  0x0020,   /* U+4384 */
  0x0020,   /* U+4385 */
  0x0020,   /* U+4386 */
  0x0020,   /* U+4387 */
  0x0020,   /* U+4388 */
  0x0020,   /* U+4389 */
  0x0020,   /* U+438A */
  0x0020,   /* U+438B */
  0x0020,   /* U+438C */
  0x0020,   /* U+438D */
  0x0020,   /* U+438E */
  0x0020,   /* U+438F */
  0x0020,   /* U+4390 */
  0x0020,   /* U+4391 */
  0x0020,   /* U+4392 */
  0x0020,   /* U+4393 */
  0x0020,   /* U+4394 */
  0x0020,   /* U+4395 */
  0x0020,   /* U+4396 */
  0x0020,   /* U+4397 */
  0x0020,   /* U+4398 */
  0x0020,   /* U+4399 */
  0x0020,   /* U+439A */
  0x0020,   /* U+439B */
  0x0020,   /* U+439C */
  0x0020,   /* U+439D */
  0x0020,   /* U+439E */
  0x0020,   /* U+439F */
  0x0020,   /* U+43A0 */
  0x0020,   /* U+43A1 */
  0x0020,   /* U+43A2 */
  0x0020,   /* U+43A3 */
  0x0020,   /* U+43A4 */
  0x0020,   /* U+43A5 */
  0x0020,   /* U+43A6 */
  0x0020,   /* U+43A7 */
  0x0020,   /* U+43A8 */
  0x0020,   /* U+43A9 */
  0x0020,   /* U+43AA */
  0x0020,   /* U+43AB */
  0x0020,   /* U+43AC */
  0x0020,   /* U+43AD */
  0x0020,   /* U+43AE */
  0x0020,   /* U+43AF */
  0x0020,   /* U+43B0 */
  0x0020,   /* U+43B1 */
  0x0020,   /* U+43B2 */
  0x0020,   /* U+43B3 */
  0x0020,   /* U+43B4 */
  0x0020,   /* U+43B5 */
  0x0020,   /* U+43B6 */
  0x0020,   /* U+43B7 */
  0x0020,   /* U+43B8 */
  0x0020,   /* U+43B9 */
  0x0020,   /* U+43BA */
  0x0020,   /* U+43BB */
  0x0020,   /* U+43BC */
  0x0020,   /* U+43BD */
  0x0020,   /* U+43BE */
  0x0020,   /* U+43BF */
  0x0020,   /* U+43C0 */
  0x0020,   /* U+43C1 */
  0x0020,   /* U+43C2 */
  0x0020,   /* U+43C3 */
  0x0020,   /* U+43C4 */
  0x0020,   /* U+43C5 */
  0x0020,   /* U+43C6 */
  0x0020,   /* U+43C7 */
  0x0020,   /* U+43C8 */
  0x0020,   /* U+43C9 */
  0x0020,   /* U+43CA */
  0x0020,   /* U+43CB */
  0x0020,   /* U+43CC */
  0x0020,   /* U+43CD */
  0x0020,   /* U+43CE */
  0x0020,   /* U+43CF */
  0x0020,   /* U+43D0 */
  0x0020,   /* U+43D1 */
  0x0020,   /* U+43D2 */
  0x0020,   /* U+43D3 */
  0x0020,   /* U+43D4 */
  0x0020,   /* U+43D5 */
  0x0020,   /* U+43D6 */
  0x0020,   /* U+43D7 */
  0x0020,   /* U+43D8 */
  0x0020,   /* U+43D9 */
  0x0020,   /* U+43DA */
  0x0020,   /* U+43DB */
  0x0020,   /* U+43DC */
  0x0020,   /* U+43DD */
  0x0020,   /* U+43DE */
  0x0020,   /* U+43DF */
  0x0020,   /* U+43E0 */
  0x0020,   /* U+43E1 */
  0x0020,   /* U+43E2 */
  0x0020,   /* U+43E3 */
  0x0020,   /* U+43E4 */
  0x0020,   /* U+43E5 */
  0x0020,   /* U+43E6 */
  0x0020,   /* U+43E7 */
  0x0020,   /* U+43E8 */
  0x0020,   /* U+43E9 */
  0x0020,   /* U+43EA */
  0x0020,   /* U+43EB */
  0x0020,   /* U+43EC */
  0x0020,   /* U+43ED */
  0x0020,   /* U+43EE */
  0x0020,   /* U+43EF */
  0x0020,   /* U+43F0 */
  0x0020,   /* U+43F1 */
  0x0020,   /* U+43F2 */
  0x0020,   /* U+43F3 */
  0x0020,   /* U+43F4 */
  0x0020,   /* U+43F5 */
  0x0020,   /* U+43F6 */
  0x0020,   /* U+43F7 */
  0x0020,   /* U+43F8 */
  0x0020,   /* U+43F9 */
  0x0020,   /* U+43FA */
  0x0020,   /* U+43FB */
  0x0020,   /* U+43FC */
  0x0020,   /* U+43FD */
  0x0020,   /* U+43FE */
  0x0020,   /* U+43FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4300 */
  0x0002,   /* U+4301 */
  0x0002,   /* U+4302 */
  0x0002,   /* U+4303 */
  0x0002,   /* U+4304 */
  0x0002,   /* U+4305 */
  0x0002,   /* U+4306 */
  0x0002,   /* U+4307 */
  0x0002,   /* U+4308 */
  0x0002,   /* U+4309 */
  0x0002,   /* U+430A */
  0x0002,   /* U+430B */
  0x0002,   /* U+430C */
  0x0002,   /* U+430D */
  0x0002,   /* U+430E */
  0x0002,   /* U+430F */
  0x0002,   /* U+4310 */
  0x0002,   /* U+4311 */
  0x0002,   /* U+4312 */
  0x0002,   /* U+4313 */
  0x0002,   /* U+4314 */
  0x0002,   /* U+4315 */
  0x0002,   /* U+4316 */
  0x0002,   /* U+4317 */
  0x0002,   /* U+4318 */
  0x0002,   /* U+4319 */
  0x0002,   /* U+431A */
  0x0002,   /* U+431B */
  0x0002,   /* U+431C */
  0x0002,   /* U+431D */
  0x0002,   /* U+431E */
  0x0002,   /* U+431F */
  0x0002,   /* U+4320 */
  0x0002,   /* U+4321 */
  0x0002,   /* U+4322 */
  0x0002,   /* U+4323 */
  0x0002,   /* U+4324 */
  0x0002,   /* U+4325 */
  0x0002,   /* U+4326 */
  0x0002,   /* U+4327 */
  0x0002,   /* U+4328 */
  0x0002,   /* U+4329 */
  0x0002,   /* U+432A */
  0x0002,   /* U+432B */
  0x0002,   /* U+432C */
  0x0002,   /* U+432D */
  0x0002,   /* U+432E */
  0x0002,   /* U+432F */
  0x0002,   /* U+4330 */
  0x0002,   /* U+4331 */
  0x0002,   /* U+4332 */
  0x0002,   /* U+4333 */
  0x0002,   /* U+4334 */
  0x0002,   /* U+4335 */
  0x0002,   /* U+4336 */
  0x0002,   /* U+4337 */
  0x0002,   /* U+4338 */
  0x0002,   /* U+4339 */
  0x0002,   /* U+433A */
  0x0002,   /* U+433B */
  0x0002,   /* U+433C */
  0x0002,   /* U+433D */
  0x0002,   /* U+433E */
  0x0002,   /* U+433F */
  0x0002,   /* U+4340 */
  0x0002,   /* U+4341 */
  0x0002,   /* U+4342 */
  0x0002,   /* U+4343 */
  0x0002,   /* U+4344 */
  0x0002,   /* U+4345 */
  0x0002,   /* U+4346 */
  0x0002,   /* U+4347 */
  0x0002,   /* U+4348 */
  0x0002,   /* U+4349 */
  0x0002,   /* U+434A */
  0x0002,   /* U+434B */
  0x0002,   /* U+434C */
  0x0002,   /* U+434D */
  0x0002,   /* U+434E */
  0x0002,   /* U+434F */
  0x0002,   /* U+4350 */
  0x0002,   /* U+4351 */
  0x0002,   /* U+4352 */
  0x0002,   /* U+4353 */
  0x0002,   /* U+4354 */
  0x0002,   /* U+4355 */
  0x0002,   /* U+4356 */
  0x0002,   /* U+4357 */
  0x0002,   /* U+4358 */
  0x0002,   /* U+4359 */
  0x0002,   /* U+435A */
  0x0002,   /* U+435B */
  0x0002,   /* U+435C */
  0x0002,   /* U+435D */
  0x0002,   /* U+435E */
  0x0002,   /* U+435F */
  0x0002,   /* U+4360 */
  0x0002,   /* U+4361 */
  0x0002,   /* U+4362 */
  0x0002,   /* U+4363 */
  0x0002,   /* U+4364 */
  0x0002,   /* U+4365 */
  0x0002,   /* U+4366 */
  0x0002,   /* U+4367 */
  0x0002,   /* U+4368 */
  0x0002,   /* U+4369 */
  0x0002,   /* U+436A */
  0x0002,   /* U+436B */
  0x0002,   /* U+436C */
  0x0002,   /* U+436D */
  0x0002,   /* U+436E */
  0x0002,   /* U+436F */
  0x0002,   /* U+4370 */
  0x0002,   /* U+4371 */
  0x0002,   /* U+4372 */
  0x0002,   /* U+4373 */
  0x0002,   /* U+4374 */
  0x0002,   /* U+4375 */
  0x0002,   /* U+4376 */
  0x0002,   /* U+4377 */
  0x0002,   /* U+4378 */
  0x0002,   /* U+4379 */
  0x0002,   /* U+437A */
  0x0002,   /* U+437B */
  0x0002,   /* U+437C */
  0x0002,   /* U+437D */
  0x0002,   /* U+437E */
  0x0002,   /* U+437F */
  0x0002,   /* U+4380 */
  0x0002,   /* U+4381 */
  0x0002,   /* U+4382 */
  0x0002,   /* U+4383 */
  0x0002,   /* U+4384 */
  0x0002,   /* U+4385 */
  0x0002,   /* U+4386 */
  0x0002,   /* U+4387 */
  0x0002,   /* U+4388 */
  0x0002,   /* U+4389 */
  0x0002,   /* U+438A */
  0x0002,   /* U+438B */
  0x0002,   /* U+438C */
  0x0002,   /* U+438D */
  0x0002,   /* U+438E */
  0x0002,   /* U+438F */
  0x0002,   /* U+4390 */
  0x0002,   /* U+4391 */
  0x0002,   /* U+4392 */
  0x0002,   /* U+4393 */
  0x0002,   /* U+4394 */
  0x0002,   /* U+4395 */
  0x0002,   /* U+4396 */
  0x0002,   /* U+4397 */
  0x0002,   /* U+4398 */
  0x0002,   /* U+4399 */
  0x0002,   /* U+439A */
  0x0002,   /* U+439B */
  0x0002,   /* U+439C */
  0x0002,   /* U+439D */
  0x0002,   /* U+439E */
  0x0002,   /* U+439F */
  0x0002,   /* U+43A0 */
  0x0002,   /* U+43A1 */
  0x0002,   /* U+43A2 */
  0x0002,   /* U+43A3 */
  0x0002,   /* U+43A4 */
  0x0002,   /* U+43A5 */
  0x0002,   /* U+43A6 */
  0x0002,   /* U+43A7 */
  0x0002,   /* U+43A8 */
  0x0002,   /* U+43A9 */
  0x0002,   /* U+43AA */
  0x0002,   /* U+43AB */
  0x0002,   /* U+43AC */
  0x0002,   /* U+43AD */
  0x0002,   /* U+43AE */
  0x0002,   /* U+43AF */
  0x0002,   /* U+43B0 */
  0x0002,   /* U+43B1 */
  0x0002,   /* U+43B2 */
  0x0002,   /* U+43B3 */
  0x0002,   /* U+43B4 */
  0x0002,   /* U+43B5 */
  0x0002,   /* U+43B6 */
  0x0002,   /* U+43B7 */
  0x0002,   /* U+43B8 */
  0x0002,   /* U+43B9 */
  0x0002,   /* U+43BA */
  0x0002,   /* U+43BB */
  0x0002,   /* U+43BC */
  0x0002,   /* U+43BD */
  0x0002,   /* U+43BE */
  0x0002,   /* U+43BF */
  0x0002,   /* U+43C0 */
  0x0002,   /* U+43C1 */
  0x0002,   /* U+43C2 */
  0x0002,   /* U+43C3 */
  0x0002,   /* U+43C4 */
  0x0002,   /* U+43C5 */
  0x0002,   /* U+43C6 */
  0x0002,   /* U+43C7 */
  0x0002,   /* U+43C8 */
  0x0002,   /* U+43C9 */
  0x0002,   /* U+43CA */
  0x0002,   /* U+43CB */
  0x0002,   /* U+43CC */
  0x0002,   /* U+43CD */
  0x0002,   /* U+43CE */
  0x0002,   /* U+43CF */
  0x0002,   /* U+43D0 */
  0x0002,   /* U+43D1 */
  0x0002,   /* U+43D2 */
  0x0002,   /* U+43D3 */
  0x0002,   /* U+43D4 */
  0x0002,   /* U+43D5 */
  0x0002,   /* U+43D6 */
  0x0002,   /* U+43D7 */
  0x0002,   /* U+43D8 */
  0x0002,   /* U+43D9 */
  0x0002,   /* U+43DA */
  0x0002,   /* U+43DB */
  0x0002,   /* U+43DC */
  0x0002,   /* U+43DD */
  0x0002,   /* U+43DE */
  0x0002,   /* U+43DF */
  0x0002,   /* U+43E0 */
  0x0002,   /* U+43E1 */
  0x0002,   /* U+43E2 */
  0x0002,   /* U+43E3 */
  0x0002,   /* U+43E4 */
  0x0002,   /* U+43E5 */
  0x0002,   /* U+43E6 */
  0x0002,   /* U+43E7 */
  0x0002,   /* U+43E8 */
  0x0002,   /* U+43E9 */
  0x0002,   /* U+43EA */
  0x0002,   /* U+43EB */
  0x0002,   /* U+43EC */
  0x0002,   /* U+43ED */
  0x0002,   /* U+43EE */
  0x0002,   /* U+43EF */
  0x0002,   /* U+43F0 */
  0x0002,   /* U+43F1 */
  0x0002,   /* U+43F2 */
  0x0002,   /* U+43F3 */
  0x0002,   /* U+43F4 */
  0x0002,   /* U+43F5 */
  0x0002,   /* U+43F6 */
  0x0002,   /* U+43F7 */
  0x0002,   /* U+43F8 */
  0x0002,   /* U+43F9 */
  0x0002,   /* U+43FA */
  0x0002,   /* U+43FB */
  0x0002,   /* U+43FC */
  0x0002,   /* U+43FD */
  0x0002,   /* U+43FE */
  0x0002,   /* U+43FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0xC309,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0xC332,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0xC336,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0xC34F,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0xC367,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0xC36D,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0xC370,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0xC379,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0xC38D,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0xC39B,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0xC39E,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0xC3A5,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0xC3E5,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0xC3ED,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0xC3FE,   /* U+43FE */
  0x0000,   /* U+43FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */
};

uint16_t zh_han_p044[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x4D5C,   /* U+4400 */
  0xBB11,   /* U+4401 */
  0x6589,   /* U+4402 */
  0x5737,   /* U+4403 */
  0x9ACC,   /* U+4404 */
  0x977B,   /* U+4405 */
  0x24E5,   /* U+4406 */
  0x9557,   /* U+4407 */
  0xB693,   /* U+4408 */
  0xBC0E,   /* U+4409 */
  0x5B0B,   /* U+440A */
  0x2DDC,   /* U+440B */
  0x8EE0,   /* U+440C */
  0x2C00,   /* U+440D */
  0x31F2,   /* U+440E */
  0x2D13,   /* U+440F */
  0x7C3F,   /* U+4410 */
  0xB491,   /* U+4411 */
  0xB252,   /* U+4412 */
  0x800E,   /* U+4413 */
  0x2307,   /* U+4414 */
  0x4C87,   /* U+4415 */
  0x9792,   /* U+4416 */
  0xB937,   /* U+4417 */
  0x568A,   /* U+4418 */
  0x3E5A,   /* U+4419 */
  0x4BCC,   /* U+441A */
  0x2F78,   /* U+441B */
  0x288C,   /* U+441C */
  0x8B4C,   /* U+441D */
  0x80F8,   /* U+441E */
  0x9B60,   /* U+441F */
  0x4982,   /* U+4420 */
  0x778B,   /* U+4421 */
  0xB9EC,   /* U+4422 */
  0x8ADF,   /* U+4423 */
  0x2681,   /* U+4424 */
  0x9591,   /* U+4425 */
  0x5864,   /* U+4426 */
  0x5836,   /* U+4427 */
  0x4034,   /* U+4428 */
  0x3CD3,   /* U+4429 */
  0x3905,   /* U+442A */
  0x2DF5,   /* U+442B */
  0x2590,   /* U+442C */
  0xB7BF,   /* U+442D */
  0x2739,   /* U+442E */
  0x5D81,   /* U+442F */
  0x9ED6,   /* U+4430 */
  0xB307,   /* U+4431 */
  0xB4A1,   /* U+4432 */
  0xAD25,   /* U+4433 */
  0x420C,   /* U+4434 */
  0x3F2B,   /* U+4435 */
  0xB10A,   /* U+4436 */
  0x3054,   /* U+4437 */
  0x4B55,   /* U+4438 */
  0x8959,   /* U+4439 */
  0x8CB9,   /* U+443A */
  0x3FEE,   /* U+443B */
  0x98E0,   /* U+443C */
  0x6819,   /* U+443D */
  0x3688,   /* U+443E */
  0x1DC3,   /* U+443F */
  0x74C1,   /* U+4440 */
  0x96FB,   /* U+4441 */
  0x1C84,   /* U+4442 */
  0x6A15,   /* U+4443 */
  0x74C8,   /* U+4444 */
  0x6A16,   /* U+4445 */
  0xA47C,   /* U+4446 */
  0xB804,   /* U+4447 */
  0x2422,   /* U+4448 */
  0xAACC,   /* U+4449 */
  0x9416,   /* U+444A */
  0x7EEB,   /* U+444B */
  0x5C52,   /* U+444C */
  0xA281,   /* U+444D */
  0x2756,   /* U+444E */
  0x7E02,   /* U+444F */
  0xB54C,   /* U+4450 */
  0x7694,   /* U+4451 */
  0xBDC1,   /* U+4452 */
  0x8BF7,   /* U+4453 */
  0x39A3,   /* U+4454 */
  0x8716,   /* U+4455 */
  0xBDC1,   /* U+4456 */
  0x311A,   /* U+4457 */
  0x2F48,   /* U+4458 */
  0x8C30,   /* U+4459 */
  0x8EAD,   /* U+445A */
  0x2A22,   /* U+445B */
  0x8BAB,   /* U+445C */
  0x4E67,   /* U+445D */
  0x8816,   /* U+445E */
  0x496C,   /* U+445F */
  0x618B,   /* U+4460 */
  0xBDC1,   /* U+4461 */
  0xBDC1,   /* U+4462 */
  0x287C,   /* U+4463 */
  0x52D5,   /* U+4464 */
  0x3752,   /* U+4465 */
  0x3F75,   /* U+4466 */
  0x3B84,   /* U+4467 */
  0x36CD,   /* U+4468 */
  0xBDC1,   /* U+4469 */
  0x376F,   /* U+446A */
  0x2040,   /* U+446B */
  0x8D48,   /* U+446C */
  0x3286,   /* U+446D */
  0xBDC1,   /* U+446E */
  0x328E,   /* U+446F */
  0x24A0,   /* U+4470 */
  0x9303,   /* U+4471 */
  0xB44B,   /* U+4472 */
  0x66DC,   /* U+4473 */
  0x7776,   /* U+4474 */
  0x6DAF,   /* U+4475 */
  0x799B,   /* U+4476 */
  0xBDC1,   /* U+4477 */
  0xBC37,   /* U+4478 */
  0x8953,   /* U+4479 */
  0xBDC1,   /* U+447A */
  0xAC11,   /* U+447B */
  0xB8B5,   /* U+447C */
  0x8BB6,   /* U+447D */
  0xBDC1,   /* U+447E */
  0x8A08,   /* U+447F */
  0x24AE,   /* U+4480 */
  0x9842,   /* U+4481 */
  0x5033,   /* U+4482 */
  0x25A7,   /* U+4483 */
  0x3C8D,   /* U+4484 */
  0x8DBE,   /* U+4485 */
  0x2876,   /* U+4486 */
  0x3C96,   /* U+4487 */
  0x39C4,   /* U+4488 */
  0x96AB,   /* U+4489 */
  0x973C,   /* U+448A */
  0xA469,   /* U+448B */
  0x6C7F,   /* U+448C */
  0x72EE,   /* U+448D */
  0x68AD,   /* U+448E */
  0x8241,   /* U+448F */
  0x6A34,   /* U+4490 */
  0x259F,   /* U+4491 */
  0x8F1A,   /* U+4492 */
  0x577B,   /* U+4493 */
  0x1E65,   /* U+4494 */
  0x9C34,   /* U+4495 */
  0x9DF4,   /* U+4496 */
  0x7818,   /* U+4497 */
  0xBDC1,   /* U+4498 */
  0xBDC1,   /* U+4499 */
  0x83BD,   /* U+449A */
  0x48DB,   /* U+449B */
  0x7113,   /* U+449C */
  0x9C1D,   /* U+449D */
  0x28A7,   /* U+449E */
  0x303B,   /* U+449F */
  0x3A6E,   /* U+44A0 */
  0xA9CD,   /* U+44A1 */
  0x1D44,   /* U+44A2 */
  0x7EC2,   /* U+44A3 */
  0x7F85,   /* U+44A4 */
  0x6809,   /* U+44A5 */
  0x38F8,   /* U+44A6 */
  0x7CE5,   /* U+44A7 */
  0x85D4,   /* U+44A8 */
  0x44DB,   /* U+44A9 */
  0x2212,   /* U+44AA */
  0x3004,   /* U+44AB */
  0x6CE9,   /* U+44AC */
  0x31BB,   /* U+44AD */
  0xBDC1,   /* U+44AE */
  0xBDC1,   /* U+44AF */
  0x5A24,   /* U+44B0 */
  0xBDC1,   /* U+44B1 */
  0x266C,   /* U+44B2 */
  0x36A1,   /* U+44B3 */
  0xAC4A,   /* U+44B4 */
  0x4470,   /* U+44B5 */
  0xBDC1,   /* U+44B6 */
  0x4082,   /* U+44B7 */
  0xA112,   /* U+44B8 */
  0x5DF5,   /* U+44B9 */
  0x52A2,   /* U+44BA */
  0x77E8,   /* U+44BB */
  0x7CEC,   /* U+44BC */
  0x9377,   /* U+44BD */
  0xA662,   /* U+44BE */
  0x6148,   /* U+44BF */
  0xBDC1,   /* U+44C0 */
  0xBDC1,   /* U+44C1 */
  0xA2B9,   /* U+44C2 */
  0xA86C,   /* U+44C3 */
  0xA99E,   /* U+44C4 */
  0x7762,   /* U+44C5 */
  0xB492,   /* U+44C6 */
  0x98C0,   /* U+44C7 */
  0xA86D,   /* U+44C8 */
  0xA5A5,   /* U+44C9 */
  0x9650,   /* U+44CA */
  0xB65D,   /* U+44CB */
  0xB795,   /* U+44CC */
  0x4380,   /* U+44CD */
  0x2D34,   /* U+44CE */
  0x3B14,   /* U+44CF */
  0x2CF9,   /* U+44D0 */
  0x75B9,   /* U+44D1 */
  0x59D1,   /* U+44D2 */
  0x2B32,   /* U+44D3 */
  0xBDC1,   /* U+44D4 */
  0x922A,   /* U+44D5 */
  0x7C06,   /* U+44D6 */
  0x2DE7,   /* U+44D7 */
  0x3DBC,   /* U+44D8 */
  0x59BB,   /* U+44D9 */
  0x7CF7,   /* U+44DA */
  0x7CF8,   /* U+44DB */
  0xB660,   /* U+44DC */
  0x6A5E,   /* U+44DD */
  0x5F87,   /* U+44DE */
  0xB8AD,   /* U+44DF */
  0x8BA5,   /* U+44E0 */
  0xB661,   /* U+44E1 */
  0x406A,   /* U+44E2 */
  0x6123,   /* U+44E3 */
  0x46CC,   /* U+44E4 */
  0x5B9B,   /* U+44E5 */
  0x32E8,   /* U+44E6 */
  0x2DBA,   /* U+44E7 */
  0xAA54,   /* U+44E8 */
  0xBDC1,   /* U+44E9 */
  0xBDC1,   /* U+44EA */
  0x7778,   /* U+44EB */
  0xBDC1,   /* U+44EC */
  0x266E,   /* U+44ED */
  0x6931,   /* U+44EE */
  0x352E,   /* U+44EF */
  0xA962,   /* U+44F0 */
  0x2690,   /* U+44F1 */
  0x80D1,   /* U+44F2 */
  0x4571,   /* U+44F3 */
  0x809F,   /* U+44F4 */
  0x3B1C,   /* U+44F5 */
  0x5BFC,   /* U+44F6 */
  0x9E79,   /* U+44F7 */
  0x4EC0,   /* U+44F8 */
  0xA89C,   /* U+44F9 */
  0x698D,   /* U+44FA */
  0xBDC1,   /* U+44FB */
  0x6895,   /* U+44FC */
  0x4D97,   /* U+44FD */
  0x8B01,   /* U+44FE */
  0x43D6,   /* U+44FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4400 */
  0x0020,   /* U+4401 */
  0x0020,   /* U+4402 */
  0x0020,   /* U+4403 */
  0x0020,   /* U+4404 */
  0x0020,   /* U+4405 */
  0x0020,   /* U+4406 */
  0x0020,   /* U+4407 */
  0x0020,   /* U+4408 */
  0x0020,   /* U+4409 */
  0x0020,   /* U+440A */
  0x0020,   /* U+440B */
  0x0020,   /* U+440C */
  0x0020,   /* U+440D */
  0x0020,   /* U+440E */
  0x0020,   /* U+440F */
  0x0020,   /* U+4410 */
  0x0020,   /* U+4411 */
  0x0020,   /* U+4412 */
  0x0020,   /* U+4413 */
  0x0020,   /* U+4414 */
  0x0020,   /* U+4415 */
  0x0020,   /* U+4416 */
  0x0020,   /* U+4417 */
  0x0020,   /* U+4418 */
  0x0020,   /* U+4419 */
  0x0020,   /* U+441A */
  0x0020,   /* U+441B */
  0x0020,   /* U+441C */
  0x0020,   /* U+441D */
  0x0020,   /* U+441E */
  0x0020,   /* U+441F */
  0x0020,   /* U+4420 */
  0x0020,   /* U+4421 */
  0x0020,   /* U+4422 */
  0x0020,   /* U+4423 */
  0x0020,   /* U+4424 */
  0x0020,   /* U+4425 */
  0x0020,   /* U+4426 */
  0x0020,   /* U+4427 */
  0x0020,   /* U+4428 */
  0x0020,   /* U+4429 */
  0x0020,   /* U+442A */
  0x0020,   /* U+442B */
  0x0020,   /* U+442C */
  0x0020,   /* U+442D */
  0x0020,   /* U+442E */
  0x0020,   /* U+442F */
  0x0020,   /* U+4430 */
  0x0020,   /* U+4431 */
  0x0020,   /* U+4432 */
  0x0020,   /* U+4433 */
  0x0020,   /* U+4434 */
  0x0020,   /* U+4435 */
  0x0020,   /* U+4436 */
  0x0020,   /* U+4437 */
  0x0020,   /* U+4438 */
  0x0020,   /* U+4439 */
  0x0020,   /* U+443A */
  0x0020,   /* U+443B */
  0x0020,   /* U+443C */
  0x0020,   /* U+443D */
  0x0020,   /* U+443E */
  0x0020,   /* U+443F */
  0x0020,   /* U+4440 */
  0x0020,   /* U+4441 */
  0x0020,   /* U+4442 */
  0x0020,   /* U+4443 */
  0x0020,   /* U+4444 */
  0x0020,   /* U+4445 */
  0x0020,   /* U+4446 */
  0x0020,   /* U+4447 */
  0x0020,   /* U+4448 */
  0x0020,   /* U+4449 */
  0x0020,   /* U+444A */
  0x0020,   /* U+444B */
  0x0020,   /* U+444C */
  0x0020,   /* U+444D */
  0x0020,   /* U+444E */
  0x0020,   /* U+444F */
  0x0020,   /* U+4450 */
  0x0020,   /* U+4451 */
  0x0020,   /* U+4452 */
  0x0020,   /* U+4453 */
  0x0020,   /* U+4454 */
  0x0020,   /* U+4455 */
  0x0020,   /* U+4456 */
  0x0020,   /* U+4457 */
  0x0020,   /* U+4458 */
  0x0020,   /* U+4459 */
  0x0020,   /* U+445A */
  0x0020,   /* U+445B */
  0x0020,   /* U+445C */
  0x0020,   /* U+445D */
  0x0020,   /* U+445E */
  0x0020,   /* U+445F */
  0x0020,   /* U+4460 */
  0x0020,   /* U+4461 */
  0x0020,   /* U+4462 */
  0x0020,   /* U+4463 */
  0x0020,   /* U+4464 */
  0x0020,   /* U+4465 */
  0x0020,   /* U+4466 */
  0x0020,   /* U+4467 */
  0x0020,   /* U+4468 */
  0x0020,   /* U+4469 */
  0x0020,   /* U+446A */
  0x0020,   /* U+446B */
  0x0020,   /* U+446C */
  0x0020,   /* U+446D */
  0x0020,   /* U+446E */
  0x0020,   /* U+446F */
  0x0020,   /* U+4470 */
  0x0020,   /* U+4471 */
  0x0020,   /* U+4472 */
  0x0020,   /* U+4473 */
  0x0020,   /* U+4474 */
  0x0020,   /* U+4475 */
  0x0020,   /* U+4476 */
  0x0020,   /* U+4477 */
  0x0020,   /* U+4478 */
  0x0020,   /* U+4479 */
  0x0020,   /* U+447A */
  0x0020,   /* U+447B */
  0x0020,   /* U+447C */
  0x0020,   /* U+447D */
  0x0020,   /* U+447E */
  0x0020,   /* U+447F */
  0x0020,   /* U+4480 */
  0x0020,   /* U+4481 */
  0x0020,   /* U+4482 */
  0x0020,   /* U+4483 */
  0x0020,   /* U+4484 */
  0x0020,   /* U+4485 */
  0x0020,   /* U+4486 */
  0x0020,   /* U+4487 */
  0x0020,   /* U+4488 */
  0x0020,   /* U+4489 */
  0x0020,   /* U+448A */
  0x0020,   /* U+448B */
  0x0020,   /* U+448C */
  0x0020,   /* U+448D */
  0x0020,   /* U+448E */
  0x0020,   /* U+448F */
  0x0020,   /* U+4490 */
  0x0020,   /* U+4491 */
  0x0020,   /* U+4492 */
  0x0020,   /* U+4493 */
  0x0020,   /* U+4494 */
  0x0020,   /* U+4495 */
  0x0020,   /* U+4496 */
  0x0020,   /* U+4497 */
  0x0020,   /* U+4498 */
  0x0020,   /* U+4499 */
  0x0020,   /* U+449A */
  0x0020,   /* U+449B */
  0x0020,   /* U+449C */
  0x0020,   /* U+449D */
  0x0020,   /* U+449E */
  0x0020,   /* U+449F */
  0x0020,   /* U+44A0 */
  0x0020,   /* U+44A1 */
  0x0020,   /* U+44A2 */
  0x0020,   /* U+44A3 */
  0x0020,   /* U+44A4 */
  0x0020,   /* U+44A5 */
  0x0020,   /* U+44A6 */
  0x0020,   /* U+44A7 */
  0x0020,   /* U+44A8 */
  0x0020,   /* U+44A9 */
  0x0020,   /* U+44AA */
  0x0020,   /* U+44AB */
  0x0020,   /* U+44AC */
  0x0020,   /* U+44AD */
  0x0020,   /* U+44AE */
  0x0020,   /* U+44AF */
  0x0020,   /* U+44B0 */
  0x0020,   /* U+44B1 */
  0x0020,   /* U+44B2 */
  0x0020,   /* U+44B3 */
  0x0020,   /* U+44B4 */
  0x0020,   /* U+44B5 */
  0x0020,   /* U+44B6 */
  0x0020,   /* U+44B7 */
  0x0020,   /* U+44B8 */
  0x0020,   /* U+44B9 */
  0x0020,   /* U+44BA */
  0x0020,   /* U+44BB */
  0x0020,   /* U+44BC */
  0x0020,   /* U+44BD */
  0x0020,   /* U+44BE */
  0x0020,   /* U+44BF */
  0x0020,   /* U+44C0 */
  0x0020,   /* U+44C1 */
  0x0020,   /* U+44C2 */
  0x0020,   /* U+44C3 */
  0x0020,   /* U+44C4 */
  0x0020,   /* U+44C5 */
  0x0020,   /* U+44C6 */
  0x0020,   /* U+44C7 */
  0x0020,   /* U+44C8 */
  0x0020,   /* U+44C9 */
  0x0020,   /* U+44CA */
  0x0020,   /* U+44CB */
  0x0020,   /* U+44CC */
  0x0020,   /* U+44CD */
  0x0020,   /* U+44CE */
  0x0020,   /* U+44CF */
  0x0020,   /* U+44D0 */
  0x0020,   /* U+44D1 */
  0x0020,   /* U+44D2 */
  0x0020,   /* U+44D3 */
  0x0020,   /* U+44D4 */
  0x0020,   /* U+44D5 */
  0x0020,   /* U+44D6 */
  0x0020,   /* U+44D7 */
  0x0020,   /* U+44D8 */
  0x0020,   /* U+44D9 */
  0x0020,   /* U+44DA */
  0x0020,   /* U+44DB */
  0x0020,   /* U+44DC */
  0x0020,   /* U+44DD */
  0x0020,   /* U+44DE */
  0x0020,   /* U+44DF */
  0x0020,   /* U+44E0 */
  0x0020,   /* U+44E1 */
  0x0020,   /* U+44E2 */
  0x0020,   /* U+44E3 */
  0x0020,   /* U+44E4 */
  0x0020,   /* U+44E5 */
  0x0020,   /* U+44E6 */
  0x0020,   /* U+44E7 */
  0x0020,   /* U+44E8 */
  0x0020,   /* U+44E9 */
  0x0020,   /* U+44EA */
  0x0020,   /* U+44EB */
  0x0020,   /* U+44EC */
  0x0020,   /* U+44ED */
  0x0020,   /* U+44EE */
  0x0020,   /* U+44EF */
  0x0020,   /* U+44F0 */
  0x0020,   /* U+44F1 */
  0x0020,   /* U+44F2 */
  0x0020,   /* U+44F3 */
  0x0020,   /* U+44F4 */
  0x0020,   /* U+44F5 */
  0x0020,   /* U+44F6 */
  0x0020,   /* U+44F7 */
  0x0020,   /* U+44F8 */
  0x0020,   /* U+44F9 */
  0x0020,   /* U+44FA */
  0x0020,   /* U+44FB */
  0x0020,   /* U+44FC */
  0x0020,   /* U+44FD */
  0x0020,   /* U+44FE */
  0x0020,   /* U+44FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4400 */
  0x0002,   /* U+4401 */
  0x0002,   /* U+4402 */
  0x0002,   /* U+4403 */
  0x0002,   /* U+4404 */
  0x0002,   /* U+4405 */
  0x0002,   /* U+4406 */
  0x0002,   /* U+4407 */
  0x0002,   /* U+4408 */
  0x0002,   /* U+4409 */
  0x0002,   /* U+440A */
  0x0002,   /* U+440B */
  0x0002,   /* U+440C */
  0x0002,   /* U+440D */
  0x0002,   /* U+440E */
  0x0002,   /* U+440F */
  0x0002,   /* U+4410 */
  0x0002,   /* U+4411 */
  0x0002,   /* U+4412 */
  0x0002,   /* U+4413 */
  0x0002,   /* U+4414 */
  0x0002,   /* U+4415 */
  0x0002,   /* U+4416 */
  0x0002,   /* U+4417 */
  0x0002,   /* U+4418 */
  0x0002,   /* U+4419 */
  0x0002,   /* U+441A */
  0x0002,   /* U+441B */
  0x0002,   /* U+441C */
  0x0002,   /* U+441D */
  0x0002,   /* U+441E */
  0x0002,   /* U+441F */
  0x0002,   /* U+4420 */
  0x0002,   /* U+4421 */
  0x0002,   /* U+4422 */
  0x0002,   /* U+4423 */
  0x0002,   /* U+4424 */
  0x0002,   /* U+4425 */
  0x0002,   /* U+4426 */
  0x0002,   /* U+4427 */
  0x0002,   /* U+4428 */
  0x0002,   /* U+4429 */
  0x0002,   /* U+442A */
  0x0002,   /* U+442B */
  0x0002,   /* U+442C */
  0x0002,   /* U+442D */
  0x0002,   /* U+442E */
  0x0002,   /* U+442F */
  0x0002,   /* U+4430 */
  0x0002,   /* U+4431 */
  0x0002,   /* U+4432 */
  0x0002,   /* U+4433 */
  0x0002,   /* U+4434 */
  0x0002,   /* U+4435 */
  0x0002,   /* U+4436 */
  0x0002,   /* U+4437 */
  0x0002,   /* U+4438 */
  0x0002,   /* U+4439 */
  0x0002,   /* U+443A */
  0x0002,   /* U+443B */
  0x0002,   /* U+443C */
  0x0002,   /* U+443D */
  0x0002,   /* U+443E */
  0x0002,   /* U+443F */
  0x0002,   /* U+4440 */
  0x0002,   /* U+4441 */
  0x0002,   /* U+4442 */
  0x0002,   /* U+4443 */
  0x0002,   /* U+4444 */
  0x0002,   /* U+4445 */
  0x0002,   /* U+4446 */
  0x0002,   /* U+4447 */
  0x0002,   /* U+4448 */
  0x0002,   /* U+4449 */
  0x0002,   /* U+444A */
  0x0002,   /* U+444B */
  0x0002,   /* U+444C */
  0x0002,   /* U+444D */
  0x0002,   /* U+444E */
  0x0002,   /* U+444F */
  0x0002,   /* U+4450 */
  0x0002,   /* U+4451 */
  0x0002,   /* U+4452 */
  0x0002,   /* U+4453 */
  0x0002,   /* U+4454 */
  0x0002,   /* U+4455 */
  0x0002,   /* U+4456 */
  0x0002,   /* U+4457 */
  0x0002,   /* U+4458 */
  0x0002,   /* U+4459 */
  0x0002,   /* U+445A */
  0x0002,   /* U+445B */
  0x0002,   /* U+445C */
  0x0002,   /* U+445D */
  0x0002,   /* U+445E */
  0x0002,   /* U+445F */
  0x0002,   /* U+4460 */
  0x0002,   /* U+4461 */
  0x0002,   /* U+4462 */
  0x0002,   /* U+4463 */
  0x0002,   /* U+4464 */
  0x0002,   /* U+4465 */
  0x0002,   /* U+4466 */
  0x0002,   /* U+4467 */
  0x0002,   /* U+4468 */
  0x0002,   /* U+4469 */
  0x0002,   /* U+446A */
  0x0002,   /* U+446B */
  0x0002,   /* U+446C */
  0x0002,   /* U+446D */
  0x0002,   /* U+446E */
  0x0002,   /* U+446F */
  0x0002,   /* U+4470 */
  0x0002,   /* U+4471 */
  0x0002,   /* U+4472 */
  0x0002,   /* U+4473 */
  0x0002,   /* U+4474 */
  0x0002,   /* U+4475 */
  0x0002,   /* U+4476 */
  0x0002,   /* U+4477 */
  0x0002,   /* U+4478 */
  0x0002,   /* U+4479 */
  0x0002,   /* U+447A */
  0x0002,   /* U+447B */
  0x0002,   /* U+447C */
  0x0002,   /* U+447D */
  0x0002,   /* U+447E */
  0x0002,   /* U+447F */
  0x0002,   /* U+4480 */
  0x0002,   /* U+4481 */
  0x0002,   /* U+4482 */
  0x0002,   /* U+4483 */
  0x0002,   /* U+4484 */
  0x0002,   /* U+4485 */
  0x0002,   /* U+4486 */
  0x0002,   /* U+4487 */
  0x0002,   /* U+4488 */
  0x0002,   /* U+4489 */
  0x0002,   /* U+448A */
  0x0002,   /* U+448B */
  0x0002,   /* U+448C */
  0x0002,   /* U+448D */
  0x0002,   /* U+448E */
  0x0002,   /* U+448F */
  0x0002,   /* U+4490 */
  0x0002,   /* U+4491 */
  0x0002,   /* U+4492 */
  0x0002,   /* U+4493 */
  0x0002,   /* U+4494 */
  0x0002,   /* U+4495 */
  0x0002,   /* U+4496 */
  0x0002,   /* U+4497 */
  0x0002,   /* U+4498 */
  0x0002,   /* U+4499 */
  0x0002,   /* U+449A */
  0x0002,   /* U+449B */
  0x0002,   /* U+449C */
  0x0002,   /* U+449D */
  0x0002,   /* U+449E */
  0x0002,   /* U+449F */
  0x0002,   /* U+44A0 */
  0x0002,   /* U+44A1 */
  0x0002,   /* U+44A2 */
  0x0002,   /* U+44A3 */
  0x0002,   /* U+44A4 */
  0x0002,   /* U+44A5 */
  0x0002,   /* U+44A6 */
  0x0002,   /* U+44A7 */
  0x0002,   /* U+44A8 */
  0x0002,   /* U+44A9 */
  0x0002,   /* U+44AA */
  0x0002,   /* U+44AB */
  0x0002,   /* U+44AC */
  0x0002,   /* U+44AD */
  0x0002,   /* U+44AE */
  0x0002,   /* U+44AF */
  0x0002,   /* U+44B0 */
  0x0002,   /* U+44B1 */
  0x0002,   /* U+44B2 */
  0x0002,   /* U+44B3 */
  0x0002,   /* U+44B4 */
  0x0002,   /* U+44B5 */
  0x0002,   /* U+44B6 */
  0x0002,   /* U+44B7 */
  0x0002,   /* U+44B8 */
  0x0002,   /* U+44B9 */
  0x0002,   /* U+44BA */
  0x0002,   /* U+44BB */
  0x0002,   /* U+44BC */
  0x0002,   /* U+44BD */
  0x0002,   /* U+44BE */
  0x0002,   /* U+44BF */
  0x0002,   /* U+44C0 */
  0x0002,   /* U+44C1 */
  0x0002,   /* U+44C2 */
  0x0002,   /* U+44C3 */
  0x0002,   /* U+44C4 */
  0x0002,   /* U+44C5 */
  0x0002,   /* U+44C6 */
  0x0002,   /* U+44C7 */
  0x0002,   /* U+44C8 */
  0x0002,   /* U+44C9 */
  0x0002,   /* U+44CA */
  0x0002,   /* U+44CB */
  0x0002,   /* U+44CC */
  0x0002,   /* U+44CD */
  0x0002,   /* U+44CE */
  0x0002,   /* U+44CF */
  0x0002,   /* U+44D0 */
  0x0002,   /* U+44D1 */
  0x0002,   /* U+44D2 */
  0x0002,   /* U+44D3 */
  0x0002,   /* U+44D4 */
  0x0002,   /* U+44D5 */
  0x0002,   /* U+44D6 */
  0x0002,   /* U+44D7 */
  0x0002,   /* U+44D8 */
  0x0002,   /* U+44D9 */
  0x0002,   /* U+44DA */
  0x0002,   /* U+44DB */
  0x0002,   /* U+44DC */
  0x0002,   /* U+44DD */
  0x0002,   /* U+44DE */
  0x0002,   /* U+44DF */
  0x0002,   /* U+44E0 */
  0x0002,   /* U+44E1 */
  0x0002,   /* U+44E2 */
  0x0002,   /* U+44E3 */
  0x0002,   /* U+44E4 */
  0x0002,   /* U+44E5 */
  0x0002,   /* U+44E6 */
  0x0002,   /* U+44E7 */
  0x0002,   /* U+44E8 */
  0x0002,   /* U+44E9 */
  0x0002,   /* U+44EA */
  0x0002,   /* U+44EB */
  0x0002,   /* U+44EC */
  0x0002,   /* U+44ED */
  0x0002,   /* U+44EE */
  0x0002,   /* U+44EF */
  0x0002,   /* U+44F0 */
  0x0002,   /* U+44F1 */
  0x0002,   /* U+44F2 */
  0x0002,   /* U+44F3 */
  0x0002,   /* U+44F4 */
  0x0002,   /* U+44F5 */
  0x0002,   /* U+44F6 */
  0x0002,   /* U+44F7 */
  0x0002,   /* U+44F8 */
  0x0002,   /* U+44F9 */
  0x0002,   /* U+44FA */
  0x0002,   /* U+44FB */
  0x0002,   /* U+44FC */
  0x0002,   /* U+44FD */
  0x0002,   /* U+44FE */
  0x0002,   /* U+44FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0xC452,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0xC456,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0xC461,   /* U+4461 */
  0xC462,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0xC469,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0xC46E,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0xC477,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0xC47A,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0xC47E,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0xC498,   /* U+4498 */
  0xC499,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0xC4AE,   /* U+44AE */
  0xC4AF,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0xC4B1,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0xC4B6,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0xC4C0,   /* U+44C0 */
  0xC4C1,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0xC4D4,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0xC4E9,   /* U+44E9 */
  0xC4EA,   /* U+44EA */
  0x0000,   /* U+44EB */
  0xC4EC,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0xC4FB,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */
};

uint16_t zh_han_p045[] = {
  /* Number of CEs for each character. */
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+4500 */
  0x5FA0,   /* U+4501 */
  0xBBF2,   /* U+4502 */
  0xBCF6,   /* U+4503 */
  0xA504,   /* U+4504 */
  0x3E29,   /* U+4505 */
  0x5E80,   /* U+4506 */
  0x77F5,   /* U+4507 */
  0x3F65,   /* U+4508 */
  0x5FA1,   /* U+4509 */
  0x2322,   /* U+450A */
  0x8B02,   /* U+450B */
  0xBDC1,   /* U+450C */
  0xBDC1,   /* U+450D */
  0x8A09,   /* U+450E */
  0x2B78,   /* U+450F */
  0x4ED1,   /* U+4510 */
  0x9CE1,   /* U+4511 */
  0x1FFA,   /* U+4512 */
  0x9F90,   /* U+4513 */
  0x53B2,   /* U+4514 */
  0x7690,   /* U+4515 */
  0x6312,   /* U+4516 */
  0x9B50,   /* U+4517 */
  0xBDB8,   /* U+4518 */
  0x337A,   /* U+4519 */
  0x2D06,   /* U+451A */
  0x7BBF,   /* U+451B */
  0x6E67,   /* U+451C */
  0xB2E2,   /* U+451D */
  0x665C,   /* U+451E */
  0xA724,   /* U+451F */
  0x83C2,   /* U+4520 */
  0xAD3D,   /* U+4521 */
  0x4809,   /* U+4522 */
  0x5E89,   /* U+4523 */
  0x7245,   /* U+4524 */
  0xBDC1,   /* U+4525 */
  0xBDC1,   /* U+4526 */
  0x5E8A,   /* U+4527 */
  0xBDC1,   /* U+4528 */
  0xBDC1,   /* U+4529 */
  0x87DB,   /* U+452A */
  0xBDC1,   /* U+452B */
  0xA8D6,   /* U+452C */
  0x710C,   /* U+452D */
  0x8886,   /* U+452E */
  0x59AC,   /* U+452F */
  0x3C97,   /* U+4530 */
  0xA67B,   /* U+4531 */
  0x31B2,   /* U+4532 */
  0x7EAE,   /* U+4533 */
  0x25DA,   /* U+4534 */
  0xBDC1,   /* U+4535 */
  0x8E2E,   /* U+4536 */
  0x7B3F,   /* U+4537 */
  0x228D,   /* U+4538 */
  0x8AB6,   /* U+4539 */
  0x940C,   /* U+453A */
  0x3634,   /* U+453B */
  0x8223,   /* U+453C */
  0x1CC2,   /* U+453D */
  0x7861,   /* U+453E */
  0xBD6A,   /* U+453F */
  0x5A11,   /* U+4540 */
  0x398E,   /* U+4541 */
  0xBDC1,   /* U+4542 */
  0xAA2E,   /* U+4543 */
  0xBDC1,   /* U+4544 */
  0x81DA,   /* U+4545 */
  0x34FC,   /* U+4546 */
  0x4A9A,   /* U+4547 */
  0x9D93,   /* U+4548 */
  0xB1F0,   /* U+4549 */
  0x8C7C,   /* U+454A */
  0x8D10,   /* U+454B */
  0xB805,   /* U+454C */
  0xA8F7,   /* U+454D */
  0x3BE2,   /* U+454E */
  0x371B,   /* U+454F */
  0xBDC1,   /* U+4550 */
  0x5755,   /* U+4551 */
  0x4E1B,   /* U+4552 */
  0x2654,   /* U+4553 */
  0x9A4B,   /* U+4554 */
  0x6864,   /* U+4555 */
  0xBDC1,   /* U+4556 */
  0x21AA,   /* U+4557 */
  0x6322,   /* U+4558 */
  0x5212,   /* U+4559 */
  0x5AF1,   /* U+455A */
  0x4E4E,   /* U+455B */
  0xBDC1,   /* U+455C */
  0x291F,   /* U+455D */
  0x5CF0,   /* U+455E */
  0x9E39,   /* U+455F */
  0x39CF,   /* U+4560 */
  0x660E,   /* U+4561 */
  0xB2B0,   /* U+4562 */
  0x4522,   /* U+4563 */
  0x4C22,   /* U+4564 */
  0x6F8E,   /* U+4565 */
  0xAAD4,   /* U+4566 */
  0x9C78,   /* U+4567 */
  0x8DCE,   /* U+4568 */
  0x5D3F,   /* U+4569 */
  0xB1F6,   /* U+456A */
  0x5AB3,   /* U+456B */
  0xBDC1,   /* U+456C */
  0x7957,   /* U+456D */
  0x551C,   /* U+456E */
  0x7523,   /* U+456F */
  0x38CA,   /* U+4570 */
  0x9061,   /* U+4571 */
  0x6276,   /* U+4572 */
  0x6AB8,   /* U+4573 */
  0xBB53,   /* U+4574 */
  0x9CF9,   /* U+4575 */
  0x47D1,   /* U+4576 */
  0x6AB9,   /* U+4577 */
  0x5176,   /* U+4578 */
  0xB0D3,   /* U+4579 */
  0x2E39,   /* U+457A */
  0x6036,   /* U+457B */
  0x7EB3,   /* U+457C */
  0xB983,   /* U+457D */
  0xA9BF,   /* U+457E */
  0x43F0,   /* U+457F */
  0xBDC1,   /* U+4580 */
  0xA930,   /* U+4581 */
  0x6697,   /* U+4582 */
  0xB004,   /* U+4583 */
  0x7EB5,   /* U+4584 */
  0x6354,   /* U+4585 */
  0x701F,   /* U+4586 */
  0xAEBF,   /* U+4587 */
  0x71AE,   /* U+4588 */
  0xBDC1,   /* U+4589 */
  0xA80A,   /* U+458A */
  0x71B0,   /* U+458B */
  0xA80B,   /* U+458C */
  0x7924,   /* U+458D */
  0x993F,   /* U+458E */
  0x2BC0,   /* U+458F */
  0xA997,   /* U+4590 */
  0x6AFC,   /* U+4591 */
  0x9794,   /* U+4592 */
  0x6E0A,   /* U+4593 */
  0x57C6,   /* U+4594 */
  0xBCF2,   /* U+4595 */
  0x9951,   /* U+4596 */
  0xA2C4,   /* U+4597 */
  0x90DC,   /* U+4598 */
  0x8DE2,   /* U+4599 */
  0x962A,   /* U+459A */
  0x8B39,   /* U+459B */
  0xA9B8,   /* U+459C */
  0x2AD6,   /* U+459D */
  0xB8D0,   /* U+459E */
  0x689D,   /* U+459F */
  0xAF05,   /* U+45A0 */
  0x719E,   /* U+45A1 */
  0x6B91,   /* U+45A2 */
  0xB185,   /* U+45A3 */
  0x92F1,   /* U+45A4 */
  0x5E3E,   /* U+45A5 */
  0x7CE7,   /* U+45A6 */
  0x6DFA,   /* U+45A7 */
  0x859B,   /* U+45A8 */
  0x2110,   /* U+45A9 */
  0xBB74,   /* U+45AA */
  0x1EFE,   /* U+45AB */
  0xBDC1,   /* U+45AC */
  0x560B,   /* U+45AD */
  0x9B59,   /* U+45AE */
  0x5A94,   /* U+45AF */
  0x7275,   /* U+45B0 */
  0x5A25,   /* U+45B1 */
  0xA16B,   /* U+45B2 */
  0xB2C4,   /* U+45B3 */
  0xA4DB,   /* U+45B4 */
  0x5B0C,   /* U+45B5 */
  0x49BB,   /* U+45B6 */
  0x9795,   /* U+45B7 */
  0x370D,   /* U+45B8 */
  0xA444,   /* U+45B9 */
  0x8F29,   /* U+45BA */
  0xAC07,   /* U+45BB */
  0x568B,   /* U+45BC */
  0x5E55,   /* U+45BD */
  0xBDC1,   /* U+45BE */
  0x5E6A,   /* U+45BF */
  0x290C,   /* U+45C0 */
  0x4D7F,   /* U+45C1 */
  0x476C,   /* U+45C2 */
  0xB399,   /* U+45C3 */
  0x3C14,   /* U+45C4 */
  0x27AB,   /* U+45C5 */
  0x4100,   /* U+45C6 */
  0x54F6,   /* U+45C7 */
  0x69F3,   /* U+45C8 */
  0x2789,   /* U+45C9 */
  0x8CB6,   /* U+45CA */
  0x6D4C,   /* U+45CB */
  0x9E2E,   /* U+45CC */
  0x5EEF,   /* U+45CD */
  0xA273,   /* U+45CE */
  0x8955,   /* U+45CF */
  0x8560,   /* U+45D0 */
  0xA89D,   /* U+45D1 */
  0x2360,   /* U+45D2 */
  0x2DF6,   /* U+45D3 */
  0x466A,   /* U+45D4 */
  0x9304,   /* U+45D5 */
  0x32A1,   /* U+45D6 */
  0x4BF9,   /* U+45D7 */
  0x3E71,   /* U+45D8 */
  0x436D,   /* U+45D9 */
  0x23FD,   /* U+45DA */
  0x9ED9,   /* U+45DB */
  0x63A7,   /* U+45DC */
  0x2524,   /* U+45DD */
  0x2525,   /* U+45DE */
  0xA8D7,   /* U+45DF */
  0xA077,   /* U+45E0 */
  0xA2D1,   /* U+45E1 */
  0xB18F,   /* U+45E2 */
  0x43DF,   /* U+45E3 */
  0xAB60,   /* U+45E4 */
  0xBC44,   /* U+45E5 */
  0xBDC1,   /* U+45E6 */
  0x5803,   /* U+45E7 */
  0xAD3F,   /* U+45E8 */
  0x76FE,   /* U+45E9 */
  0xB4E5,   /* U+45EA */
  0x6798,   /* U+45EB */
  0xBDC1,   /* U+45EC */
  0xBDC1,   /* U+45ED */
  0x87DC,   /* U+45EE */
  0x530F,   /* U+45EF */
  0x412A,   /* U+45F0 */
  0x7695,   /* U+45F1 */
  0x628F,   /* U+45F2 */
  0xBDC1,   /* U+45F3 */
  0x8FAF,   /* U+45F4 */
  0x501A,   /* U+45F5 */
  0x5BAD,   /* U+45F6 */
  0xA8F8,   /* U+45F7 */
  0xAB48,   /* U+45F8 */
  0x2DC4,   /* U+45F9 */
  0xA35F,   /* U+45FA */
  0x520F,   /* U+45FB */
  0xA146,   /* U+45FC */
  0x94F1,   /* U+45FD */
  0x9A8C,   /* U+45FE */
  0x70F7,   /* U+45FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4500 */
  0x0020,   /* U+4501 */
  0x0020,   /* U+4502 */
  0x0020,   /* U+4503 */
  0x0020,   /* U+4504 */
  0x0020,   /* U+4505 */
  0x0020,   /* U+4506 */
  0x0020,   /* U+4507 */
  0x0020,   /* U+4508 */
  0x0020,   /* U+4509 */
  0x0020,   /* U+450A */
  0x0020,   /* U+450B */
  0x0020,   /* U+450C */
  0x0020,   /* U+450D */
  0x0020,   /* U+450E */
  0x0020,   /* U+450F */
  0x0020,   /* U+4510 */
  0x0020,   /* U+4511 */
  0x0020,   /* U+4512 */
  0x0020,   /* U+4513 */
  0x0020,   /* U+4514 */
  0x0020,   /* U+4515 */
  0x0020,   /* U+4516 */
  0x0020,   /* U+4517 */
  0x0020,   /* U+4518 */
  0x0020,   /* U+4519 */
  0x0020,   /* U+451A */
  0x0020,   /* U+451B */
  0x0020,   /* U+451C */
  0x0020,   /* U+451D */
  0x0020,   /* U+451E */
  0x0020,   /* U+451F */
  0x0020,   /* U+4520 */
  0x0020,   /* U+4521 */
  0x0020,   /* U+4522 */
  0x0020,   /* U+4523 */
  0x0020,   /* U+4524 */
  0x0020,   /* U+4525 */
  0x0020,   /* U+4526 */
  0x0020,   /* U+4527 */
  0x0020,   /* U+4528 */
  0x0020,   /* U+4529 */
  0x0020,   /* U+452A */
  0x0020,   /* U+452B */
  0x0020,   /* U+452C */
  0x0020,   /* U+452D */
  0x0020,   /* U+452E */
  0x0020,   /* U+452F */
  0x0020,   /* U+4530 */
  0x0020,   /* U+4531 */
  0x0020,   /* U+4532 */
  0x0020,   /* U+4533 */
  0x0020,   /* U+4534 */
  0x0020,   /* U+4535 */
  0x0020,   /* U+4536 */
  0x0020,   /* U+4537 */
  0x0020,   /* U+4538 */
  0x0020,   /* U+4539 */
  0x0020,   /* U+453A */
  0x0020,   /* U+453B */
  0x0020,   /* U+453C */
  0x0020,   /* U+453D */
  0x0020,   /* U+453E */
  0x0020,   /* U+453F */
  0x0020,   /* U+4540 */
  0x0020,   /* U+4541 */
  0x0020,   /* U+4542 */
  0x0020,   /* U+4543 */
  0x0020,   /* U+4544 */
  0x0020,   /* U+4545 */
  0x0020,   /* U+4546 */
  0x0020,   /* U+4547 */
  0x0020,   /* U+4548 */
  0x0020,   /* U+4549 */
  0x0020,   /* U+454A */
  0x0020,   /* U+454B */
  0x0020,   /* U+454C */
  0x0020,   /* U+454D */
  0x0020,   /* U+454E */
  0x0020,   /* U+454F */
  0x0020,   /* U+4550 */
  0x0020,   /* U+4551 */
  0x0020,   /* U+4552 */
  0x0020,   /* U+4553 */
  0x0020,   /* U+4554 */
  0x0020,   /* U+4555 */
  0x0020,   /* U+4556 */
  0x0020,   /* U+4557 */
  0x0020,   /* U+4558 */
  0x0020,   /* U+4559 */
  0x0020,   /* U+455A */
  0x0020,   /* U+455B */
  0x0020,   /* U+455C */
  0x0020,   /* U+455D */
  0x0020,   /* U+455E */
  0x0020,   /* U+455F */
  0x0020,   /* U+4560 */
  0x0020,   /* U+4561 */
  0x0020,   /* U+4562 */
  0x0020,   /* U+4563 */
  0x0020,   /* U+4564 */
  0x0020,   /* U+4565 */
  0x0020,   /* U+4566 */
  0x0020,   /* U+4567 */
  0x0020,   /* U+4568 */
  0x0020,   /* U+4569 */
  0x0020,   /* U+456A */
  0x0020,   /* U+456B */
  0x0020,   /* U+456C */
  0x0020,   /* U+456D */
  0x0020,   /* U+456E */
  0x0020,   /* U+456F */
  0x0020,   /* U+4570 */
  0x0020,   /* U+4571 */
  0x0020,   /* U+4572 */
  0x0020,   /* U+4573 */
  0x0020,   /* U+4574 */
  0x0020,   /* U+4575 */
  0x0020,   /* U+4576 */
  0x0020,   /* U+4577 */
  0x0020,   /* U+4578 */
  0x0020,   /* U+4579 */
  0x0020,   /* U+457A */
  0x0020,   /* U+457B */
  0x0020,   /* U+457C */
  0x0020,   /* U+457D */
  0x0020,   /* U+457E */
  0x0020,   /* U+457F */
  0x0020,   /* U+4580 */
  0x0020,   /* U+4581 */
  0x0020,   /* U+4582 */
  0x0020,   /* U+4583 */
  0x0020,   /* U+4584 */
  0x0020,   /* U+4585 */
  0x0020,   /* U+4586 */
  0x0020,   /* U+4587 */
  0x0020,   /* U+4588 */
  0x0020,   /* U+4589 */
  0x0020,   /* U+458A */
  0x0020,   /* U+458B */
  0x0020,   /* U+458C */
  0x0020,   /* U+458D */
  0x0020,   /* U+458E */
  0x0020,   /* U+458F */
  0x0020,   /* U+4590 */
  0x0020,   /* U+4591 */
  0x0020,   /* U+4592 */
  0x0020,   /* U+4593 */
  0x0020,   /* U+4594 */
  0x0020,   /* U+4595 */
  0x0020,   /* U+4596 */
  0x0020,   /* U+4597 */
  0x0020,   /* U+4598 */
  0x0020,   /* U+4599 */
  0x0020,   /* U+459A */
  0x0020,   /* U+459B */
  0x0020,   /* U+459C */
  0x0020,   /* U+459D */
  0x0020,   /* U+459E */
  0x0020,   /* U+459F */
  0x0020,   /* U+45A0 */
  0x0020,   /* U+45A1 */
  0x0020,   /* U+45A2 */
  0x0020,   /* U+45A3 */
  0x0020,   /* U+45A4 */
  0x0020,   /* U+45A5 */
  0x0020,   /* U+45A6 */
  0x0020,   /* U+45A7 */
  0x0020,   /* U+45A8 */
  0x0020,   /* U+45A9 */
  0x0020,   /* U+45AA */
  0x0020,   /* U+45AB */
  0x0020,   /* U+45AC */
  0x0020,   /* U+45AD */
  0x0020,   /* U+45AE */
  0x0020,   /* U+45AF */
  0x0020,   /* U+45B0 */
  0x0020,   /* U+45B1 */
  0x0020,   /* U+45B2 */
  0x0020,   /* U+45B3 */
  0x0020,   /* U+45B4 */
  0x0020,   /* U+45B5 */
  0x0020,   /* U+45B6 */
  0x0020,   /* U+45B7 */
  0x0020,   /* U+45B8 */
  0x0020,   /* U+45B9 */
  0x0020,   /* U+45BA */
  0x0020,   /* U+45BB */
  0x0020,   /* U+45BC */
  0x0020,   /* U+45BD */
  0x0020,   /* U+45BE */
  0x0020,   /* U+45BF */
  0x0020,   /* U+45C0 */
  0x0020,   /* U+45C1 */
  0x0020,   /* U+45C2 */
  0x0020,   /* U+45C3 */
  0x0020,   /* U+45C4 */
  0x0020,   /* U+45C5 */
  0x0020,   /* U+45C6 */
  0x0020,   /* U+45C7 */
  0x0020,   /* U+45C8 */
  0x0020,   /* U+45C9 */
  0x0020,   /* U+45CA */
  0x0020,   /* U+45CB */
  0x0020,   /* U+45CC */
  0x0020,   /* U+45CD */
  0x0020,   /* U+45CE */
  0x0020,   /* U+45CF */
  0x0020,   /* U+45D0 */
  0x0020,   /* U+45D1 */
  0x0020,   /* U+45D2 */
  0x0020,   /* U+45D3 */
  0x0020,   /* U+45D4 */
  0x0020,   /* U+45D5 */
  0x0020,   /* U+45D6 */
  0x0020,   /* U+45D7 */
  0x0020,   /* U+45D8 */
  0x0020,   /* U+45D9 */
  0x0020,   /* U+45DA */
  0x0020,   /* U+45DB */
  0x0020,   /* U+45DC */
  0x0020,   /* U+45DD */
  0x0020,   /* U+45DE */
  0x0020,   /* U+45DF */
  0x0020,   /* U+45E0 */
  0x0020,   /* U+45E1 */
  0x0020,   /* U+45E2 */
  0x0020,   /* U+45E3 */
  0x0020,   /* U+45E4 */
  0x0020,   /* U+45E5 */
  0x0020,   /* U+45E6 */
  0x0020,   /* U+45E7 */
  0x0020,   /* U+45E8 */
  0x0020,   /* U+45E9 */
  0x0020,   /* U+45EA */
  0x0020,   /* U+45EB */
  0x0020,   /* U+45EC */
  0x0020,   /* U+45ED */
  0x0020,   /* U+45EE */
  0x0020,   /* U+45EF */
  0x0020,   /* U+45F0 */
  0x0020,   /* U+45F1 */
  0x0020,   /* U+45F2 */
  0x0020,   /* U+45F3 */
  0x0020,   /* U+45F4 */
  0x0020,   /* U+45F5 */
  0x0020,   /* U+45F6 */
  0x0020,   /* U+45F7 */
  0x0020,   /* U+45F8 */
  0x0020,   /* U+45F9 */
  0x0020,   /* U+45FA */
  0x0020,   /* U+45FB */
  0x0020,   /* U+45FC */
  0x0020,   /* U+45FD */
  0x0020,   /* U+45FE */
  0x0020,   /* U+45FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4500 */
  0x0002,   /* U+4501 */
  0x0002,   /* U+4502 */
  0x0002,   /* U+4503 */
  0x0002,   /* U+4504 */
  0x0002,   /* U+4505 */
  0x0002,   /* U+4506 */
  0x0002,   /* U+4507 */
  0x0002,   /* U+4508 */
  0x0002,   /* U+4509 */
  0x0002,   /* U+450A */
  0x0002,   /* U+450B */
  0x0002,   /* U+450C */
  0x0002,   /* U+450D */
  0x0002,   /* U+450E */
  0x0002,   /* U+450F */
  0x0002,   /* U+4510 */
  0x0002,   /* U+4511 */
  0x0002,   /* U+4512 */
  0x0002,   /* U+4513 */
  0x0002,   /* U+4514 */
  0x0002,   /* U+4515 */
  0x0002,   /* U+4516 */
  0x0002,   /* U+4517 */
  0x0002,   /* U+4518 */
  0x0002,   /* U+4519 */
  0x0002,   /* U+451A */
  0x0002,   /* U+451B */
  0x0002,   /* U+451C */
  0x0002,   /* U+451D */
  0x0002,   /* U+451E */
  0x0002,   /* U+451F */
  0x0002,   /* U+4520 */
  0x0002,   /* U+4521 */
  0x0002,   /* U+4522 */
  0x0002,   /* U+4523 */
  0x0002,   /* U+4524 */
  0x0002,   /* U+4525 */
  0x0002,   /* U+4526 */
  0x0002,   /* U+4527 */
  0x0002,   /* U+4528 */
  0x0002,   /* U+4529 */
  0x0002,   /* U+452A */
  0x0002,   /* U+452B */
  0x0002,   /* U+452C */
  0x0002,   /* U+452D */
  0x0002,   /* U+452E */
  0x0002,   /* U+452F */
  0x0002,   /* U+4530 */
  0x0002,   /* U+4531 */
  0x0002,   /* U+4532 */
  0x0002,   /* U+4533 */
  0x0002,   /* U+4534 */
  0x0002,   /* U+4535 */
  0x0002,   /* U+4536 */
  0x0002,   /* U+4537 */
  0x0002,   /* U+4538 */
  0x0002,   /* U+4539 */
  0x0002,   /* U+453A */
  0x0002,   /* U+453B */
  0x0002,   /* U+453C */
  0x0002,   /* U+453D */
  0x0002,   /* U+453E */
  0x0002,   /* U+453F */
  0x0002,   /* U+4540 */
  0x0002,   /* U+4541 */
  0x0002,   /* U+4542 */
  0x0002,   /* U+4543 */
  0x0002,   /* U+4544 */
  0x0002,   /* U+4545 */
  0x0002,   /* U+4546 */
  0x0002,   /* U+4547 */
  0x0002,   /* U+4548 */
  0x0002,   /* U+4549 */
  0x0002,   /* U+454A */
  0x0002,   /* U+454B */
  0x0002,   /* U+454C */
  0x0002,   /* U+454D */
  0x0002,   /* U+454E */
  0x0002,   /* U+454F */
  0x0002,   /* U+4550 */
  0x0002,   /* U+4551 */
  0x0002,   /* U+4552 */
  0x0002,   /* U+4553 */
  0x0002,   /* U+4554 */
  0x0002,   /* U+4555 */
  0x0002,   /* U+4556 */
  0x0002,   /* U+4557 */
  0x0002,   /* U+4558 */
  0x0002,   /* U+4559 */
  0x0002,   /* U+455A */
  0x0002,   /* U+455B */
  0x0002,   /* U+455C */
  0x0002,   /* U+455D */
  0x0002,   /* U+455E */
  0x0002,   /* U+455F */
  0x0002,   /* U+4560 */
  0x0002,   /* U+4561 */
  0x0002,   /* U+4562 */
  0x0002,   /* U+4563 */
  0x0002,   /* U+4564 */
  0x0002,   /* U+4565 */
  0x0002,   /* U+4566 */
  0x0002,   /* U+4567 */
  0x0002,   /* U+4568 */
  0x0002,   /* U+4569 */
  0x0002,   /* U+456A */
  0x0002,   /* U+456B */
  0x0002,   /* U+456C */
  0x0002,   /* U+456D */
  0x0002,   /* U+456E */
  0x0002,   /* U+456F */
  0x0002,   /* U+4570 */
  0x0002,   /* U+4571 */
  0x0002,   /* U+4572 */
  0x0002,   /* U+4573 */
  0x0002,   /* U+4574 */
  0x0002,   /* U+4575 */
  0x0002,   /* U+4576 */
  0x0002,   /* U+4577 */
  0x0002,   /* U+4578 */
  0x0002,   /* U+4579 */
  0x0002,   /* U+457A */
  0x0002,   /* U+457B */
  0x0002,   /* U+457C */
  0x0002,   /* U+457D */
  0x0002,   /* U+457E */
  0x0002,   /* U+457F */
  0x0002,   /* U+4580 */
  0x0002,   /* U+4581 */
  0x0002,   /* U+4582 */
  0x0002,   /* U+4583 */
  0x0002,   /* U+4584 */
  0x0002,   /* U+4585 */
  0x0002,   /* U+4586 */
  0x0002,   /* U+4587 */
  0x0002,   /* U+4588 */
  0x0002,   /* U+4589 */
  0x0002,   /* U+458A */
  0x0002,   /* U+458B */
  0x0002,   /* U+458C */
  0x0002,   /* U+458D */
  0x0002,   /* U+458E */
  0x0002,   /* U+458F */
  0x0002,   /* U+4590 */
  0x0002,   /* U+4591 */
  0x0002,   /* U+4592 */
  0x0002,   /* U+4593 */
  0x0002,   /* U+4594 */
  0x0002,   /* U+4595 */
  0x0002,   /* U+4596 */
  0x0002,   /* U+4597 */
  0x0002,   /* U+4598 */
  0x0002,   /* U+4599 */
  0x0002,   /* U+459A */
  0x0002,   /* U+459B */
  0x0002,   /* U+459C */
  0x0002,   /* U+459D */
  0x0002,   /* U+459E */
  0x0002,   /* U+459F */
  0x0002,   /* U+45A0 */
  0x0002,   /* U+45A1 */
  0x0002,   /* U+45A2 */
  0x0002,   /* U+45A3 */
  0x0002,   /* U+45A4 */
  0x0002,   /* U+45A5 */
  0x0002,   /* U+45A6 */
  0x0002,   /* U+45A7 */
  0x0002,   /* U+45A8 */
  0x0002,   /* U+45A9 */
  0x0002,   /* U+45AA */
  0x0002,   /* U+45AB */
  0x0002,   /* U+45AC */
  0x0002,   /* U+45AD */
  0x0002,   /* U+45AE */
  0x0002,   /* U+45AF */
  0x0002,   /* U+45B0 */
  0x0002,   /* U+45B1 */
  0x0002,   /* U+45B2 */
  0x0002,   /* U+45B3 */
  0x0002,   /* U+45B4 */
  0x0002,   /* U+45B5 */
  0x0002,   /* U+45B6 */
  0x0002,   /* U+45B7 */
  0x0002,   /* U+45B8 */
  0x0002,   /* U+45B9 */
  0x0002,   /* U+45BA */
  0x0002,   /* U+45BB */
  0x0002,   /* U+45BC */
  0x0002,   /* U+45BD */
  0x0002,   /* U+45BE */
  0x0002,   /* U+45BF */
  0x0002,   /* U+45C0 */
  0x0002,   /* U+45C1 */
  0x0002,   /* U+45C2 */
  0x0002,   /* U+45C3 */
  0x0002,   /* U+45C4 */
  0x0002,   /* U+45C5 */
  0x0002,   /* U+45C6 */
  0x0002,   /* U+45C7 */
  0x0002,   /* U+45C8 */
  0x0002,   /* U+45C9 */
  0x0002,   /* U+45CA */
  0x0002,   /* U+45CB */
  0x0002,   /* U+45CC */
  0x0002,   /* U+45CD */
  0x0002,   /* U+45CE */
  0x0002,   /* U+45CF */
  0x0002,   /* U+45D0 */
  0x0002,   /* U+45D1 */
  0x0002,   /* U+45D2 */
  0x0002,   /* U+45D3 */
  0x0002,   /* U+45D4 */
  0x0002,   /* U+45D5 */
  0x0002,   /* U+45D6 */
  0x0002,   /* U+45D7 */
  0x0002,   /* U+45D8 */
  0x0002,   /* U+45D9 */
  0x0002,   /* U+45DA */
  0x0002,   /* U+45DB */
  0x0002,   /* U+45DC */
  0x0002,   /* U+45DD */
  0x0002,   /* U+45DE */
  0x0002,   /* U+45DF */
  0x0002,   /* U+45E0 */
  0x0002,   /* U+45E1 */
  0x0002,   /* U+45E2 */
  0x0002,   /* U+45E3 */
  0x0002,   /* U+45E4 */
  0x0002,   /* U+45E5 */
  0x0002,   /* U+45E6 */
  0x0002,   /* U+45E7 */
  0x0002,   /* U+45E8 */
  0x0002,   /* U+45E9 */
  0x0002,   /* U+45EA */
  0x0002,   /* U+45EB */
  0x0002,   /* U+45EC */
  0x0002,   /* U+45ED */
  0x0002,   /* U+45EE */
  0x0002,   /* U+45EF */
  0x0002,   /* U+45F0 */
  0x0002,   /* U+45F1 */
  0x0002,   /* U+45F2 */
  0x0002,   /* U+45F3 */
  0x0002,   /* U+45F4 */
  0x0002,   /* U+45F5 */
  0x0002,   /* U+45F6 */
  0x0002,   /* U+45F7 */
  0x0002,   /* U+45F8 */
  0x0002,   /* U+45F9 */
  0x0002,   /* U+45FA */
  0x0002,   /* U+45FB */
  0x0002,   /* U+45FC */
  0x0002,   /* U+45FD */
  0x0002,   /* U+45FE */
  0x0002,   /* U+45FF */

  /* Primary weight 2 for each character. */
  0xC500,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0xC50C,   /* U+450C */
  0xC50D,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0xC525,   /* U+4525 */
  0xC526,   /* U+4526 */
  0x0000,   /* U+4527 */
  0xC528,   /* U+4528 */
  0xC529,   /* U+4529 */
  0x0000,   /* U+452A */
  0xC52B,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0xC535,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0xC542,   /* U+4542 */
  0x0000,   /* U+4543 */
  0xC544,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0xC550,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0xC556,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0xC55C,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0xC56C,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0xC580,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0xC589,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0xC5AC,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0xC5BE,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0xC5E6,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0xC5EC,   /* U+45EC */
  0xC5ED,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0xC5F3,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */
};

uint16_t zh_han_p046[] = {
  /* Number of CEs for each character. */
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 
  1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x3CA0,   /* U+4600 */
  0x3E84,   /* U+4601 */
  0xBDC1,   /* U+4602 */
  0x6D2C,   /* U+4603 */
  0xBA03,   /* U+4604 */
  0x6E22,   /* U+4605 */
  0x9A91,   /* U+4606 */
  0x9548,   /* U+4607 */
  0x6019,   /* U+4608 */
  0x252D,   /* U+4609 */
  0x6BE8,   /* U+460A */
  0x4EFA,   /* U+460B */
  0x6FCE,   /* U+460C */
  0x26A4,   /* U+460D */
  0x92BC,   /* U+460E */
  0x9FAE,   /* U+460F */
  0x71A0,   /* U+4610 */
  0x67F0,   /* U+4611 */
  0xBD1A,   /* U+4612 */
  0x57DD,   /* U+4613 */
  0x5762,   /* U+4614 */
  0x4409,   /* U+4615 */
  0xBDC1,   /* U+4616 */
  0xBDC1,   /* U+4617 */
  0xAE5D,   /* U+4618 */
  0x94F2,   /* U+4619 */
  0xB95B,   /* U+461A */
  0xBDC1,   /* U+461B */
  0xBDC1,   /* U+461C */
  0xA7F0,   /* U+461D */
  0xBDC1,   /* U+461E */
  0x3334,   /* U+461F */
  0x3B74,   /* U+4620 */
  0x20B3,   /* U+4621 */
  0xB993,   /* U+4622 */
  0xBBE6,   /* U+4623 */
  0x8753,   /* U+4624 */
  0x9941,   /* U+4625 */
  0x6F4D,   /* U+4626 */
  0xBDC1,   /* U+4627 */
  0x50CF,   /* U+4628 */
  0xA16C,   /* U+4629 */
  0x2AB4,   /* U+462A */
  0x716E,   /* U+462B */
  0x7FA3,   /* U+462C */
  0xB781,   /* U+462D */
  0x819B,   /* U+462E */
  0xBDC1,   /* U+462F */
  0x82DE,   /* U+4630 */
  0xAE22,   /* U+4631 */
  0xBDC1,   /* U+4632 */
  0x5280,   /* U+4633 */
  0xBDC1,   /* U+4634 */
  0x65A8,   /* U+4635 */
  0x432B,   /* U+4636 */
  0x22A1,   /* U+4637 */
  0xA888,   /* U+4638 */
  0xBD42,   /* U+4639 */
  0xB39A,   /* U+463A */
  0xAE39,   /* U+463B */
  0x9305,   /* U+463C */
  0x6F5C,   /* U+463D */
  0x4101,   /* U+463E */
  0x5697,   /* U+463F */
  0x205B,   /* U+4640 */
  0x251E,   /* U+4641 */
  0xBDC1,   /* U+4642 */
  0x36DE,   /* U+4643 */
  0x784A,   /* U+4644 */
  0xA4B7,   /* U+4645 */
  0x5AE2,   /* U+4646 */
  0x8087,   /* U+4647 */
  0x466B,   /* U+4648 */
  0xA17C,   /* U+4649 */
  0x9D62,   /* U+464A */
  0xBDC1,   /* U+464B */
  0x5AE3,   /* U+464C */
  0xBDC1,   /* U+464D */
  0x9CD9,   /* U+464E */
  0x23FE,   /* U+464F */
  0x58C2,   /* U+4650 */
  0x2EC4,   /* U+4651 */
  0xA002,   /* U+4652 */
  0x1E5E,   /* U+4653 */
  0x720A,   /* U+4654 */
  0xBC67,   /* U+4655 */
  0xBDC1,   /* U+4656 */
  0x8E7A,   /* U+4657 */
  0x2BCD,   /* U+4658 */
  0x29FE,   /* U+4659 */
  0x7035,   /* U+465A */
  0x4128,   /* U+465B */
  0x3AB4,   /* U+465C */
  0x9D7B,   /* U+465D */
  0x31B3,   /* U+465E */
  0x940D,   /* U+465F */
  0x56C6,   /* U+4660 */
  0x5AED,   /* U+4661 */
  0xB23C,   /* U+4662 */
  0x813B,   /* U+4663 */
  0x36B3,   /* U+4664 */
  0x631B,   /* U+4665 */
  0x6A27,   /* U+4666 */
  0xBDC1,   /* U+4667 */
  0x42C3,   /* U+4668 */
  0x6A28,   /* U+4669 */
  0x644D,   /* U+466A */
  0xBDC1,   /* U+466B */
  0xAB18,   /* U+466C */
  0xBDC1,   /* U+466D */
  0x4136,   /* U+466E */
  0x2E92,   /* U+466F */
  0x5ECD,   /* U+4670 */
  0x355C,   /* U+4671 */
  0xBDC1,   /* U+4672 */
  0x2241,   /* U+4673 */
  0xBDC1,   /* U+4674 */
  0x977E,   /* U+4675 */
  0xBDC1,   /* U+4676 */
  0x3187,   /* U+4677 */
  0x3188,   /* U+4678 */
  0x9AC3,   /* U+4679 */
  0x6055,   /* U+467A */
  0xBDC1,   /* U+467B */
  0x83D3,   /* U+467C */
  0x9CB9,   /* U+467D */
  0x854B,   /* U+467E */
  0x94B6,   /* U+467F */
  0xBDC1,   /* U+4680 */
  0xBDC1,   /* U+4681 */
  0x453D,   /* U+4682 */
  0xAC0D,   /* U+4683 */
  0x65B3,   /* U+4684 */
  0x5BFD,   /* U+4685 */
  0xAAF0,   /* U+4686 */
  0x8511,   /* U+4687 */
  0x561E,   /* U+4688 */
  0x7859,   /* U+4689 */
  0x4F47,   /* U+468A */
  0xB090,   /* U+468B */
  0xBDC1,   /* U+468C */
  0x7862,   /* U+468D */
  0xBDC1,   /* U+468E */
  0x6294,   /* U+468F */
  0x4CCD,   /* U+4690 */
  0x67DD,   /* U+4691 */
  0x2C91,   /* U+4692 */
  0x7001,   /* U+4693 */
  0x2300,   /* U+4694 */
  0x603D,   /* U+4695 */
  0x6356,   /* U+4696 */
  0x3D8E,   /* U+4697 */
  0x295E,   /* U+4698 */
  0xA038,   /* U+4699 */
  0x9A73,   /* U+469A */
  0x4718,   /* U+469B */
  0x208A,   /* U+469C */
  0xBCC9,   /* U+469D */
  0x2FDF,   /* U+469E */
  0x2FE0,   /* U+469F */
  0x4AF4,   /* U+46A0 */
  0x814D,   /* U+46A1 */
  0x286F,   /* U+46A2 */
  0x8E20,   /* U+46A3 */
  0xBDC1,   /* U+46A4 */
  0x71EB,   /* U+46A5 */
  0xB7EC,   /* U+46A6 */
  0x63B5,   /* U+46A7 */
  0x39C9,   /* U+46A8 */
  0x50FF,   /* U+46A9 */
  0x40ED,   /* U+46AA */
  0x984A,   /* U+46AB */
  0x6252,   /* U+46AC */
  0xA05D,   /* U+46AD */
  0x7F78,   /* U+46AE */
  0x8D90,   /* U+46AF */
  0x748C,   /* U+46B0 */
  0x9DF6,   /* U+46B1 */
  0x8327,   /* U+46B2 */
  0xB766,   /* U+46B3 */
  0x927E,   /* U+46B4 */
  0x9069,   /* U+46B5 */
  0x8E93,   /* U+46B6 */
  0xA65B,   /* U+46B7 */
  0x9D30,   /* U+46B8 */
  0x748E,   /* U+46B9 */
  0xA4D3,   /* U+46BA */
  0xA4D4,   /* U+46BB */
  0x71A1,   /* U+46BC */
  0x446D,   /* U+46BD */
  0x70D0,   /* U+46BE */
  0xAA08,   /* U+46BF */
  0x38D7,   /* U+46C0 */
  0x6E5B,   /* U+46C1 */
  0xA4AC,   /* U+46C2 */
  0x9326,   /* U+46C3 */
  0xAF57,   /* U+46C4 */
  0x9948,   /* U+46C5 */
  0xB8F8,   /* U+46C6 */
  0xAF58,   /* U+46C7 */
  0x8634,   /* U+46C8 */
  0x6B85,   /* U+46C9 */
  0x977F,   /* U+46CA */
  0x4D61,   /* U+46CB */
  0x8D78,   /* U+46CC */
  0x39AC,   /* U+46CD */
  0xA114,   /* U+46CE */
  0x6F51,   /* U+46CF */
  0x2D73,   /* U+46D0 */
  0x6AFD,   /* U+46D1 */
  0x221A,   /* U+46D2 */
  0xBDC1,   /* U+46D3 */
  0x6DCE,   /* U+46D4 */
  0xAE24,   /* U+46D5 */
  0x3782,   /* U+46D6 */
  0xB6FB,   /* U+46D7 */
  0x7F1E,   /* U+46D8 */
  0x9FE2,   /* U+46D9 */
  0x66B1,   /* U+46DA */
  0x4A4C,   /* U+46DB */
  0xA1AE,   /* U+46DC */
  0x6EBB,   /* U+46DD */
  0x43C8,   /* U+46DE */
  0x4E3F,   /* U+46DF */
  0x34EF,   /* U+46E0 */
  0x4835,   /* U+46E1 */
  0x9097,   /* U+46E2 */
  0x758D,   /* U+46E3 */
  0x2E75,   /* U+46E4 */
  0x97A9,   /* U+46E5 */
  0x8935,   /* U+46E6 */
  0x6A8E,   /* U+46E7 */
  0x9E02,   /* U+46E8 */
  0x96F4,   /* U+46E9 */
  0x7C0F,   /* U+46EA */
  0xB3CE,   /* U+46EB */
  0x8D7E,   /* U+46EC */
  0x9E7A,   /* U+46ED */
  0x5466,   /* U+46EE */
  0x5598,   /* U+46EF */
  0x4AF5,   /* U+46F0 */
  0x8E19,   /* U+46F1 */
  0x6813,   /* U+46F2 */
  0xA3B3,   /* U+46F3 */
  0x4BE7,   /* U+46F4 */
  0x86A6,   /* U+46F5 */
  0x5DC3,   /* U+46F6 */
  0x9309,   /* U+46F7 */
  0x2869,   /* U+46F8 */
  0x2552,   /* U+46F9 */
  0x525B,   /* U+46FA */
  0xAC8F,   /* U+46FB */
  0x4A08,   /* U+46FC */
  0xB2AB,   /* U+46FD */
  0x8A0F,   /* U+46FE */
  0x3E76,   /* U+46FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4600 */
  0x0020,   /* U+4601 */
  0x0020,   /* U+4602 */
  0x0020,   /* U+4603 */
  0x0020,   /* U+4604 */
  0x0020,   /* U+4605 */
  0x0020,   /* U+4606 */
  0x0020,   /* U+4607 */
  0x0020,   /* U+4608 */
  0x0020,   /* U+4609 */
  0x0020,   /* U+460A */
  0x0020,   /* U+460B */
  0x0020,   /* U+460C */
  0x0020,   /* U+460D */
  0x0020,   /* U+460E */
  0x0020,   /* U+460F */
  0x0020,   /* U+4610 */
  0x0020,   /* U+4611 */
  0x0020,   /* U+4612 */
  0x0020,   /* U+4613 */
  0x0020,   /* U+4614 */
  0x0020,   /* U+4615 */
  0x0020,   /* U+4616 */
  0x0020,   /* U+4617 */
  0x0020,   /* U+4618 */
  0x0020,   /* U+4619 */
  0x0020,   /* U+461A */
  0x0020,   /* U+461B */
  0x0020,   /* U+461C */
  0x0020,   /* U+461D */
  0x0020,   /* U+461E */
  0x0020,   /* U+461F */
  0x0020,   /* U+4620 */
  0x0020,   /* U+4621 */
  0x0020,   /* U+4622 */
  0x0020,   /* U+4623 */
  0x0020,   /* U+4624 */
  0x0020,   /* U+4625 */
  0x0020,   /* U+4626 */
  0x0020,   /* U+4627 */
  0x0020,   /* U+4628 */
  0x0020,   /* U+4629 */
  0x0020,   /* U+462A */
  0x0020,   /* U+462B */
  0x0020,   /* U+462C */
  0x0020,   /* U+462D */
  0x0020,   /* U+462E */
  0x0020,   /* U+462F */
  0x0020,   /* U+4630 */
  0x0020,   /* U+4631 */
  0x0020,   /* U+4632 */
  0x0020,   /* U+4633 */
  0x0020,   /* U+4634 */
  0x0020,   /* U+4635 */
  0x0020,   /* U+4636 */
  0x0020,   /* U+4637 */
  0x0020,   /* U+4638 */
  0x0020,   /* U+4639 */
  0x0020,   /* U+463A */
  0x0020,   /* U+463B */
  0x0020,   /* U+463C */
  0x0020,   /* U+463D */
  0x0020,   /* U+463E */
  0x0020,   /* U+463F */
  0x0020,   /* U+4640 */
  0x0020,   /* U+4641 */
  0x0020,   /* U+4642 */
  0x0020,   /* U+4643 */
  0x0020,   /* U+4644 */
  0x0020,   /* U+4645 */
  0x0020,   /* U+4646 */
  0x0020,   /* U+4647 */
  0x0020,   /* U+4648 */
  0x0020,   /* U+4649 */
  0x0020,   /* U+464A */
  0x0020,   /* U+464B */
  0x0020,   /* U+464C */
  0x0020,   /* U+464D */
  0x0020,   /* U+464E */
  0x0020,   /* U+464F */
  0x0020,   /* U+4650 */
  0x0020,   /* U+4651 */
  0x0020,   /* U+4652 */
  0x0020,   /* U+4653 */
  0x0020,   /* U+4654 */
  0x0020,   /* U+4655 */
  0x0020,   /* U+4656 */
  0x0020,   /* U+4657 */
  0x0020,   /* U+4658 */
  0x0020,   /* U+4659 */
  0x0020,   /* U+465A */
  0x0020,   /* U+465B */
  0x0020,   /* U+465C */
  0x0020,   /* U+465D */
  0x0020,   /* U+465E */
  0x0020,   /* U+465F */
  0x0020,   /* U+4660 */
  0x0020,   /* U+4661 */
  0x0020,   /* U+4662 */
  0x0020,   /* U+4663 */
  0x0020,   /* U+4664 */
  0x0020,   /* U+4665 */
  0x0020,   /* U+4666 */
  0x0020,   /* U+4667 */
  0x0020,   /* U+4668 */
  0x0020,   /* U+4669 */
  0x0020,   /* U+466A */
  0x0020,   /* U+466B */
  0x0020,   /* U+466C */
  0x0020,   /* U+466D */
  0x0020,   /* U+466E */
  0x0020,   /* U+466F */
  0x0020,   /* U+4670 */
  0x0020,   /* U+4671 */
  0x0020,   /* U+4672 */
  0x0020,   /* U+4673 */
  0x0020,   /* U+4674 */
  0x0020,   /* U+4675 */
  0x0020,   /* U+4676 */
  0x0020,   /* U+4677 */
  0x0020,   /* U+4678 */
  0x0020,   /* U+4679 */
  0x0020,   /* U+467A */
  0x0020,   /* U+467B */
  0x0020,   /* U+467C */
  0x0020,   /* U+467D */
  0x0020,   /* U+467E */
  0x0020,   /* U+467F */
  0x0020,   /* U+4680 */
  0x0020,   /* U+4681 */
  0x0020,   /* U+4682 */
  0x0020,   /* U+4683 */
  0x0020,   /* U+4684 */
  0x0020,   /* U+4685 */
  0x0020,   /* U+4686 */
  0x0020,   /* U+4687 */
  0x0020,   /* U+4688 */
  0x0020,   /* U+4689 */
  0x0020,   /* U+468A */
  0x0020,   /* U+468B */
  0x0020,   /* U+468C */
  0x0020,   /* U+468D */
  0x0020,   /* U+468E */
  0x0020,   /* U+468F */
  0x0020,   /* U+4690 */
  0x0020,   /* U+4691 */
  0x0020,   /* U+4692 */
  0x0020,   /* U+4693 */
  0x0020,   /* U+4694 */
  0x0020,   /* U+4695 */
  0x0020,   /* U+4696 */
  0x0020,   /* U+4697 */
  0x0020,   /* U+4698 */
  0x0020,   /* U+4699 */
  0x0020,   /* U+469A */
  0x0020,   /* U+469B */
  0x0020,   /* U+469C */
  0x0020,   /* U+469D */
  0x0020,   /* U+469E */
  0x0020,   /* U+469F */
  0x0020,   /* U+46A0 */
  0x0020,   /* U+46A1 */
  0x0020,   /* U+46A2 */
  0x0020,   /* U+46A3 */
  0x0020,   /* U+46A4 */
  0x0020,   /* U+46A5 */
  0x0020,   /* U+46A6 */
  0x0020,   /* U+46A7 */
  0x0020,   /* U+46A8 */
  0x0020,   /* U+46A9 */
  0x0020,   /* U+46AA */
  0x0020,   /* U+46AB */
  0x0020,   /* U+46AC */
  0x0020,   /* U+46AD */
  0x0020,   /* U+46AE */
  0x0020,   /* U+46AF */
  0x0020,   /* U+46B0 */
  0x0020,   /* U+46B1 */
  0x0020,   /* U+46B2 */
  0x0020,   /* U+46B3 */
  0x0020,   /* U+46B4 */
  0x0020,   /* U+46B5 */
  0x0020,   /* U+46B6 */
  0x0020,   /* U+46B7 */
  0x0020,   /* U+46B8 */
  0x0020,   /* U+46B9 */
  0x0020,   /* U+46BA */
  0x0020,   /* U+46BB */
  0x0020,   /* U+46BC */
  0x0020,   /* U+46BD */
  0x0020,   /* U+46BE */
  0x0020,   /* U+46BF */
  0x0020,   /* U+46C0 */
  0x0020,   /* U+46C1 */
  0x0020,   /* U+46C2 */
  0x0020,   /* U+46C3 */
  0x0020,   /* U+46C4 */
  0x0020,   /* U+46C5 */
  0x0020,   /* U+46C6 */
  0x0020,   /* U+46C7 */
  0x0020,   /* U+46C8 */
  0x0020,   /* U+46C9 */
  0x0020,   /* U+46CA */
  0x0020,   /* U+46CB */
  0x0020,   /* U+46CC */
  0x0020,   /* U+46CD */
  0x0020,   /* U+46CE */
  0x0020,   /* U+46CF */
  0x0020,   /* U+46D0 */
  0x0020,   /* U+46D1 */
  0x0020,   /* U+46D2 */
  0x0020,   /* U+46D3 */
  0x0020,   /* U+46D4 */
  0x0020,   /* U+46D5 */
  0x0020,   /* U+46D6 */
  0x0020,   /* U+46D7 */
  0x0020,   /* U+46D8 */
  0x0020,   /* U+46D9 */
  0x0020,   /* U+46DA */
  0x0020,   /* U+46DB */
  0x0020,   /* U+46DC */
  0x0020,   /* U+46DD */
  0x0020,   /* U+46DE */
  0x0020,   /* U+46DF */
  0x0020,   /* U+46E0 */
  0x0020,   /* U+46E1 */
  0x0020,   /* U+46E2 */
  0x0020,   /* U+46E3 */
  0x0020,   /* U+46E4 */
  0x0020,   /* U+46E5 */
  0x0020,   /* U+46E6 */
  0x0020,   /* U+46E7 */
  0x0020,   /* U+46E8 */
  0x0020,   /* U+46E9 */
  0x0020,   /* U+46EA */
  0x0020,   /* U+46EB */
  0x0020,   /* U+46EC */
  0x0020,   /* U+46ED */
  0x0020,   /* U+46EE */
  0x0020,   /* U+46EF */
  0x0020,   /* U+46F0 */
  0x0020,   /* U+46F1 */
  0x0020,   /* U+46F2 */
  0x0020,   /* U+46F3 */
  0x0020,   /* U+46F4 */
  0x0020,   /* U+46F5 */
  0x0020,   /* U+46F6 */
  0x0020,   /* U+46F7 */
  0x0020,   /* U+46F8 */
  0x0020,   /* U+46F9 */
  0x0020,   /* U+46FA */
  0x0020,   /* U+46FB */
  0x0020,   /* U+46FC */
  0x0020,   /* U+46FD */
  0x0020,   /* U+46FE */
  0x0020,   /* U+46FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4600 */
  0x0002,   /* U+4601 */
  0x0002,   /* U+4602 */
  0x0002,   /* U+4603 */
  0x0002,   /* U+4604 */
  0x0002,   /* U+4605 */
  0x0002,   /* U+4606 */
  0x0002,   /* U+4607 */
  0x0002,   /* U+4608 */
  0x0002,   /* U+4609 */
  0x0002,   /* U+460A */
  0x0002,   /* U+460B */
  0x0002,   /* U+460C */
  0x0002,   /* U+460D */
  0x0002,   /* U+460E */
  0x0002,   /* U+460F */
  0x0002,   /* U+4610 */
  0x0002,   /* U+4611 */
  0x0002,   /* U+4612 */
  0x0002,   /* U+4613 */
  0x0002,   /* U+4614 */
  0x0002,   /* U+4615 */
  0x0002,   /* U+4616 */
  0x0002,   /* U+4617 */
  0x0002,   /* U+4618 */
  0x0002,   /* U+4619 */
  0x0002,   /* U+461A */
  0x0002,   /* U+461B */
  0x0002,   /* U+461C */
  0x0002,   /* U+461D */
  0x0002,   /* U+461E */
  0x0002,   /* U+461F */
  0x0002,   /* U+4620 */
  0x0002,   /* U+4621 */
  0x0002,   /* U+4622 */
  0x0002,   /* U+4623 */
  0x0002,   /* U+4624 */
  0x0002,   /* U+4625 */
  0x0002,   /* U+4626 */
  0x0002,   /* U+4627 */
  0x0002,   /* U+4628 */
  0x0002,   /* U+4629 */
  0x0002,   /* U+462A */
  0x0002,   /* U+462B */
  0x0002,   /* U+462C */
  0x0002,   /* U+462D */
  0x0002,   /* U+462E */
  0x0002,   /* U+462F */
  0x0002,   /* U+4630 */
  0x0002,   /* U+4631 */
  0x0002,   /* U+4632 */
  0x0002,   /* U+4633 */
  0x0002,   /* U+4634 */
  0x0002,   /* U+4635 */
  0x0002,   /* U+4636 */
  0x0002,   /* U+4637 */
  0x0002,   /* U+4638 */
  0x0002,   /* U+4639 */
  0x0002,   /* U+463A */
  0x0002,   /* U+463B */
  0x0002,   /* U+463C */
  0x0002,   /* U+463D */
  0x0002,   /* U+463E */
  0x0002,   /* U+463F */
  0x0002,   /* U+4640 */
  0x0002,   /* U+4641 */
  0x0002,   /* U+4642 */
  0x0002,   /* U+4643 */
  0x0002,   /* U+4644 */
  0x0002,   /* U+4645 */
  0x0002,   /* U+4646 */
  0x0002,   /* U+4647 */
  0x0002,   /* U+4648 */
  0x0002,   /* U+4649 */
  0x0002,   /* U+464A */
  0x0002,   /* U+464B */
  0x0002,   /* U+464C */
  0x0002,   /* U+464D */
  0x0002,   /* U+464E */
  0x0002,   /* U+464F */
  0x0002,   /* U+4650 */
  0x0002,   /* U+4651 */
  0x0002,   /* U+4652 */
  0x0002,   /* U+4653 */
  0x0002,   /* U+4654 */
  0x0002,   /* U+4655 */
  0x0002,   /* U+4656 */
  0x0002,   /* U+4657 */
  0x0002,   /* U+4658 */
  0x0002,   /* U+4659 */
  0x0002,   /* U+465A */
  0x0002,   /* U+465B */
  0x0002,   /* U+465C */
  0x0002,   /* U+465D */
  0x0002,   /* U+465E */
  0x0002,   /* U+465F */
  0x0002,   /* U+4660 */
  0x0002,   /* U+4661 */
  0x0002,   /* U+4662 */
  0x0002,   /* U+4663 */
  0x0002,   /* U+4664 */
  0x0002,   /* U+4665 */
  0x0002,   /* U+4666 */
  0x0002,   /* U+4667 */
  0x0002,   /* U+4668 */
  0x0002,   /* U+4669 */
  0x0002,   /* U+466A */
  0x0002,   /* U+466B */
  0x0002,   /* U+466C */
  0x0002,   /* U+466D */
  0x0002,   /* U+466E */
  0x0002,   /* U+466F */
  0x0002,   /* U+4670 */
  0x0002,   /* U+4671 */
  0x0002,   /* U+4672 */
  0x0002,   /* U+4673 */
  0x0002,   /* U+4674 */
  0x0002,   /* U+4675 */
  0x0002,   /* U+4676 */
  0x0002,   /* U+4677 */
  0x0002,   /* U+4678 */
  0x0002,   /* U+4679 */
  0x0002,   /* U+467A */
  0x0002,   /* U+467B */
  0x0002,   /* U+467C */
  0x0002,   /* U+467D */
  0x0002,   /* U+467E */
  0x0002,   /* U+467F */
  0x0002,   /* U+4680 */
  0x0002,   /* U+4681 */
  0x0002,   /* U+4682 */
  0x0002,   /* U+4683 */
  0x0002,   /* U+4684 */
  0x0002,   /* U+4685 */
  0x0002,   /* U+4686 */
  0x0002,   /* U+4687 */
  0x0002,   /* U+4688 */
  0x0002,   /* U+4689 */
  0x0002,   /* U+468A */
  0x0002,   /* U+468B */
  0x0002,   /* U+468C */
  0x0002,   /* U+468D */
  0x0002,   /* U+468E */
  0x0002,   /* U+468F */
  0x0002,   /* U+4690 */
  0x0002,   /* U+4691 */
  0x0002,   /* U+4692 */
  0x0002,   /* U+4693 */
  0x0002,   /* U+4694 */
  0x0002,   /* U+4695 */
  0x0002,   /* U+4696 */
  0x0002,   /* U+4697 */
  0x0002,   /* U+4698 */
  0x0002,   /* U+4699 */
  0x0002,   /* U+469A */
  0x0002,   /* U+469B */
  0x0002,   /* U+469C */
  0x0002,   /* U+469D */
  0x0002,   /* U+469E */
  0x0002,   /* U+469F */
  0x0002,   /* U+46A0 */
  0x0002,   /* U+46A1 */
  0x0002,   /* U+46A2 */
  0x0002,   /* U+46A3 */
  0x0002,   /* U+46A4 */
  0x0002,   /* U+46A5 */
  0x0002,   /* U+46A6 */
  0x0002,   /* U+46A7 */
  0x0002,   /* U+46A8 */
  0x0002,   /* U+46A9 */
  0x0002,   /* U+46AA */
  0x0002,   /* U+46AB */
  0x0002,   /* U+46AC */
  0x0002,   /* U+46AD */
  0x0002,   /* U+46AE */
  0x0002,   /* U+46AF */
  0x0002,   /* U+46B0 */
  0x0002,   /* U+46B1 */
  0x0002,   /* U+46B2 */
  0x0002,   /* U+46B3 */
  0x0002,   /* U+46B4 */
  0x0002,   /* U+46B5 */
  0x0002,   /* U+46B6 */
  0x0002,   /* U+46B7 */
  0x0002,   /* U+46B8 */
  0x0002,   /* U+46B9 */
  0x0002,   /* U+46BA */
  0x0002,   /* U+46BB */
  0x0002,   /* U+46BC */
  0x0002,   /* U+46BD */
  0x0002,   /* U+46BE */
  0x0002,   /* U+46BF */
  0x0002,   /* U+46C0 */
  0x0002,   /* U+46C1 */
  0x0002,   /* U+46C2 */
  0x0002,   /* U+46C3 */
  0x0002,   /* U+46C4 */
  0x0002,   /* U+46C5 */
  0x0002,   /* U+46C6 */
  0x0002,   /* U+46C7 */
  0x0002,   /* U+46C8 */
  0x0002,   /* U+46C9 */
  0x0002,   /* U+46CA */
  0x0002,   /* U+46CB */
  0x0002,   /* U+46CC */
  0x0002,   /* U+46CD */
  0x0002,   /* U+46CE */
  0x0002,   /* U+46CF */
  0x0002,   /* U+46D0 */
  0x0002,   /* U+46D1 */
  0x0002,   /* U+46D2 */
  0x0002,   /* U+46D3 */
  0x0002,   /* U+46D4 */
  0x0002,   /* U+46D5 */
  0x0002,   /* U+46D6 */
  0x0002,   /* U+46D7 */
  0x0002,   /* U+46D8 */
  0x0002,   /* U+46D9 */
  0x0002,   /* U+46DA */
  0x0002,   /* U+46DB */
  0x0002,   /* U+46DC */
  0x0002,   /* U+46DD */
  0x0002,   /* U+46DE */
  0x0002,   /* U+46DF */
  0x0002,   /* U+46E0 */
  0x0002,   /* U+46E1 */
  0x0002,   /* U+46E2 */
  0x0002,   /* U+46E3 */
  0x0002,   /* U+46E4 */
  0x0002,   /* U+46E5 */
  0x0002,   /* U+46E6 */
  0x0002,   /* U+46E7 */
  0x0002,   /* U+46E8 */
  0x0002,   /* U+46E9 */
  0x0002,   /* U+46EA */
  0x0002,   /* U+46EB */
  0x0002,   /* U+46EC */
  0x0002,   /* U+46ED */
  0x0002,   /* U+46EE */
  0x0002,   /* U+46EF */
  0x0002,   /* U+46F0 */
  0x0002,   /* U+46F1 */
  0x0002,   /* U+46F2 */
  0x0002,   /* U+46F3 */
  0x0002,   /* U+46F4 */
  0x0002,   /* U+46F5 */
  0x0002,   /* U+46F6 */
  0x0002,   /* U+46F7 */
  0x0002,   /* U+46F8 */
  0x0002,   /* U+46F9 */
  0x0002,   /* U+46FA */
  0x0002,   /* U+46FB */
  0x0002,   /* U+46FC */
  0x0002,   /* U+46FD */
  0x0002,   /* U+46FE */
  0x0002,   /* U+46FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0xC602,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0xC616,   /* U+4616 */
  0xC617,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0xC61B,   /* U+461B */
  0xC61C,   /* U+461C */
  0x0000,   /* U+461D */
  0xC61E,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0xC627,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0xC62F,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0xC632,   /* U+4632 */
  0x0000,   /* U+4633 */
  0xC634,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0xC642,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0xC64B,   /* U+464B */
  0x0000,   /* U+464C */
  0xC64D,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0xC656,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0xC667,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0xC66B,   /* U+466B */
  0x0000,   /* U+466C */
  0xC66D,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0xC672,   /* U+4672 */
  0x0000,   /* U+4673 */
  0xC674,   /* U+4674 */
  0x0000,   /* U+4675 */
  0xC676,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0xC67B,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0xC680,   /* U+4680 */
  0xC681,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0xC68C,   /* U+468C */
  0x0000,   /* U+468D */
  0xC68E,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0xC6A4,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0xC6D3,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */
};

uint16_t zh_han_p047[] = {
  /* Number of CEs for each character. */
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 

  /* Primary weight 1 for each character. */
  0x6EED,   /* U+4700 */
  0x98E9,   /* U+4701 */
  0xBDC1,   /* U+4702 */
  0x35E1,   /* U+4703 */
  0x2A04,   /* U+4704 */
  0x940E,   /* U+4705 */
  0xB4B9,   /* U+4706 */
  0x424C,   /* U+4707 */
  0x27F8,   /* U+4708 */
  0x29C1,   /* U+4709 */
  0xB174,   /* U+470A */
  0x4A9C,   /* U+470B */
  0x667B,   /* U+470C */
  0x617A,   /* U+470D */
  0x5D1C,   /* U+470E */
  0x91CF,   /* U+470F */
  0x49D7,   /* U+4710 */
  0x9709,   /* U+4711 */
  0x1DC6,   /* U+4712 */
  0x8428,   /* U+4713 */
  0x8A66,   /* U+4714 */
  0x67FF,   /* U+4715 */
  0x8CBE,   /* U+4716 */
  0x9E0D,   /* U+4717 */
  0x5378,   /* U+4718 */
  0x1D01,   /* U+4719 */
  0x8BD5,   /* U+471A */
  0x26FF,   /* U+471B */
  0x94F6,   /* U+471C */
  0x9123,   /* U+471D */
  0x4DC7,   /* U+471E */
  0x28CC,   /* U+471F */
  0x2879,   /* U+4720 */
  0xAEA2,   /* U+4721 */
  0x9A96,   /* U+4722 */
  0x9DC8,   /* U+4723 */
  0xBDC1,   /* U+4724 */
  0xBDC1,   /* U+4725 */
  0xBDC1,   /* U+4726 */
  0x6EEE,   /* U+4727 */
  0xBDC1,   /* U+4728 */
  0xA3EB,   /* U+4729 */
  0x7C74,   /* U+472A */
  0x4FFC,   /* U+472B */
  0x8916,   /* U+472C */
  0x5738,   /* U+472D */
  0x6153,   /* U+472E */
  0x54FA,   /* U+472F */
  0xBDC1,   /* U+4730 */
  0x6843,   /* U+4731 */
  0x6214,   /* U+4732 */
  0xBDC1,   /* U+4733 */
  0x2BF0,   /* U+4734 */
  0x2A29,   /* U+4735 */
  0x9B4B,   /* U+4736 */
  0x7B01,   /* U+4737 */
  0x698A,   /* U+4738 */
  0x876A,   /* U+4739 */
  0x2694,   /* U+473A */
  0x2A34,   /* U+473B */
  0x3FF9,   /* U+473C */
  0xAD34,   /* U+473D */
  0xA965,   /* U+473E */
  0xBDC1,   /* U+473F */
  0x63AC,   /* U+4740 */
  0x5D17,   /* U+4741 */
  0x877C,   /* U+4742 */
  0xB4BF,   /* U+4743 */
  0x87CA,   /* U+4744 */
  0x49AC,   /* U+4745 */
  0xBDC1,   /* U+4746 */
  0xBDC1,   /* U+4747 */
  0x3774,   /* U+4748 */
  0xBDC1,   /* U+4749 */
  0x829C,   /* U+474A */
  0xBC78,   /* U+474B */
  0x56A8,   /* U+474C */
  0x574C,   /* U+474D */
  0x90FD,   /* U+474E */
  0x64BC,   /* U+474F */
  0x9414,   /* U+4750 */
  0x2ACB,   /* U+4751 */
  0xBA04,   /* U+4752 */
  0x6215,   /* U+4753 */
  0xBDC1,   /* U+4754 */
  0xB4C6,   /* U+4755 */
  0xB428,   /* U+4756 */
  0xBDC1,   /* U+4757 */
  0xA82B,   /* U+4758 */
  0x2B7F,   /* U+4759 */
  0x6F52,   /* U+475A */
  0x2386,   /* U+475B */
  0x8A2A,   /* U+475C */
  0xA76E,   /* U+475D */
  0x4480,   /* U+475E */
  0xA242,   /* U+475F */
  0x48AC,   /* U+4760 */
  0x685F,   /* U+4761 */
  0x6860,   /* U+4762 */
  0x7D5E,   /* U+4763 */
  0x5D3D,   /* U+4764 */
  0x4450,   /* U+4765 */
  0xB84A,   /* U+4766 */
  0x6C01,   /* U+4767 */
  0x9A11,   /* U+4768 */
  0xB582,   /* U+4769 */
  0x871A,   /* U+476A */
  0xBD81,   /* U+476B */
  0xB9DE,   /* U+476C */
  0x3FA8,   /* U+476D */
  0xA0AD,   /* U+476E */
  0xA84E,   /* U+476F */
  0xB797,   /* U+4770 */
  0x9CC4,   /* U+4771 */
  0x52E9,   /* U+4772 */
  0x251F,   /* U+4773 */
  0xBDC1,   /* U+4774 */
  0x24A4,   /* U+4775 */
  0x610A,   /* U+4776 */
  0xB668,   /* U+4777 */
  0x4D8E,   /* U+4778 */
  0x930A,   /* U+4779 */
  0x4124,   /* U+477A */
  0x54B3,   /* U+477B */
  0x53A9,   /* U+477C */
  0x1CA9,   /* U+477D */
  0x3C7C,   /* U+477E */
  0x420D,   /* U+477F */
  0x4695,   /* U+4780 */
  0xA3C4,   /* U+4781 */
  0x80A2,   /* U+4782 */
  0xB7D7,   /* U+4783 */
  0x2293,   /* U+4784 */
  0xA725,   /* U+4785 */
  0x8B34,   /* U+4786 */
  0x33D8,   /* U+4787 */
  0x421F,   /* U+4788 */
  0x852C,   /* U+4789 */
  0xA1BD,   /* U+478A */
  0x28F1,   /* U+478B */
  0x83F4,   /* U+478C */
  0x7BA9,   /* U+478D */
  0xBDC1,   /* U+478E */
  0xBDC1,   /* U+478F */
  0x2D17,   /* U+4790 */
  0x45EF,   /* U+4791 */
  0x349B,   /* U+4792 */
  0x290D,   /* U+4793 */
  0x9463,   /* U+4794 */
  0x8059,   /* U+4795 */
  0x8715,   /* U+4796 */
  0x24C7,   /* U+4797 */
  0x4C60,   /* U+4798 */
  0xB0BE,   /* U+4799 */
  0x774B,   /* U+479A */
  0xA25E,   /* U+479B */
  0x3C4C,   /* U+479C */
  0xAE0F,   /* U+479D */
  0x3B9B,   /* U+479E */
  0x7626,   /* U+479F */
  0xB653,   /* U+47A0 */
  0x8C93,   /* U+47A1 */
  0xBD82,   /* U+47A2 */
  0x2843,   /* U+47A3 */
  0x7D32,   /* U+47A4 */
  0xAC8A,   /* U+47A5 */
  0x44F5,   /* U+47A6 */
  0x468F,   /* U+47A7 */
  0x41DA,   /* U+47A8 */
  0x3783,   /* U+47A9 */
  0x5046,   /* U+47AA */
  0xB05B,   /* U+47AB */
  0x9079,   /* U+47AC */
  0x2F1A,   /* U+47AD */
  0x9099,   /* U+47AE */
  0x3C6F,   /* U+47AF */
  0xBD88,   /* U+47B0 */
  0x4719,   /* U+47B1 */
  0xBDC1,   /* U+47B2 */
  0x23F1,   /* U+47B3 */
  0xB417,   /* U+47B4 */
  0x56FB,   /* U+47B5 */
  0x8CCA,   /* U+47B6 */
  0x56AA,   /* U+47B7 */
  0x3C7D,   /* U+47B8 */
  0x4955,   /* U+47B9 */
  0x2CDD,   /* U+47BA */
  0xAB90,   /* U+47BB */
  0x2CC9,   /* U+47BC */
  0x8B35,   /* U+47BD */
  0x2A00,   /* U+47BE */
  0x78F8,   /* U+47BF */
  0x24CC,   /* U+47C0 */
  0x9C2F,   /* U+47C1 */
  0x6823,   /* U+47C2 */
  0x250A,   /* U+47C3 */
  0x7863,   /* U+47C4 */
  0x4FCF,   /* U+47C5 */
  0x219A,   /* U+47C6 */
  0x4C19,   /* U+47C7 */
  0xB6B8,   /* U+47C8 */
  0xB979,   /* U+47C9 */
  0x7D5F,   /* U+47CA */
  0xB37B,   /* U+47CB */
  0x4CD5,   /* U+47CC */
  0x21DB,   /* U+47CD */
  0xBDC1,   /* U+47CE */
  0x601D,   /* U+47CF */
  0x6027,   /* U+47D0 */
  0xAFF7,   /* U+47D1 */
  0x7E07,   /* U+47D2 */
  0x28F9,   /* U+47D3 */
  0x3C3E,   /* U+47D4 */
  0x266B,   /* U+47D5 */
  0x8D31,   /* U+47D6 */
  0x8629,   /* U+47D7 */
  0x441C,   /* U+47D8 */
  0x7AC6,   /* U+47D9 */
  0x774D,   /* U+47DA */
  0x23C9,   /* U+47DB */
  0x6DFC,   /* U+47DC */
  0x9076,   /* U+47DD */
  0x2B8E,   /* U+47DE */
  0x2E6C,   /* U+47DF */
  0xAFC2,   /* U+47E0 */
  0xB654,   /* U+47E1 */
  0x28B5,   /* U+47E2 */
  0x2BF9,   /* U+47E3 */
  0x2125,   /* U+47E4 */
  0x69E7,   /* U+47E5 */
  0x1E0E,   /* U+47E6 */
  0x8EB2,   /* U+47E7 */
  0x6C08,   /* U+47E8 */
  0x61B6,   /* U+47E9 */
  0x3ABA,   /* U+47EA */
  0x2906,   /* U+47EB */
  0x7CC2,   /* U+47EC */
  0x8F25,   /* U+47ED */
  0x3BA9,   /* U+47EE */
  0x5B59,   /* U+47EF */
  0x4F2D,   /* U+47F0 */
  0xBDC1,   /* U+47F1 */
  0xBDC1,   /* U+47F2 */
  0xBDC1,   /* U+47F3 */
  0xB58C,   /* U+47F4 */
  0x7CAB,   /* U+47F5 */
  0xBDB6,   /* U+47F6 */
  0x2A78,   /* U+47F7 */
  0x5AA0,   /* U+47F8 */
  0x61ED,   /* U+47F9 */
  0x1FED,   /* U+47FA */
  0x358D,   /* U+47FB */
  0x969B,   /* U+47FC */
  0xBDC1,   /* U+47FD */
  0xBB28,   /* U+47FE */
  0x65B8,   /* U+47FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4700 */
  0x0020,   /* U+4701 */
  0x0020,   /* U+4702 */
  0x0020,   /* U+4703 */
  0x0020,   /* U+4704 */
  0x0020,   /* U+4705 */
  0x0020,   /* U+4706 */
  0x0020,   /* U+4707 */
  0x0020,   /* U+4708 */
  0x0020,   /* U+4709 */
  0x0020,   /* U+470A */
  0x0020,   /* U+470B */
  0x0020,   /* U+470C */
  0x0020,   /* U+470D */
  0x0020,   /* U+470E */
  0x0020,   /* U+470F */
  0x0020,   /* U+4710 */
  0x0020,   /* U+4711 */
  0x0020,   /* U+4712 */
  0x0020,   /* U+4713 */
  0x0020,   /* U+4714 */
  0x0020,   /* U+4715 */
  0x0020,   /* U+4716 */
  0x0020,   /* U+4717 */
  0x0020,   /* U+4718 */
  0x0020,   /* U+4719 */
  0x0020,   /* U+471A */
  0x0020,   /* U+471B */
  0x0020,   /* U+471C */
  0x0020,   /* U+471D */
  0x0020,   /* U+471E */
  0x0020,   /* U+471F */
  0x0020,   /* U+4720 */
  0x0020,   /* U+4721 */
  0x0020,   /* U+4722 */
  0x0020,   /* U+4723 */
  0x0020,   /* U+4724 */
  0x0020,   /* U+4725 */
  0x0020,   /* U+4726 */
  0x0020,   /* U+4727 */
  0x0020,   /* U+4728 */
  0x0020,   /* U+4729 */
  0x0020,   /* U+472A */
  0x0020,   /* U+472B */
  0x0020,   /* U+472C */
  0x0020,   /* U+472D */
  0x0020,   /* U+472E */
  0x0020,   /* U+472F */
  0x0020,   /* U+4730 */
  0x0020,   /* U+4731 */
  0x0020,   /* U+4732 */
  0x0020,   /* U+4733 */
  0x0020,   /* U+4734 */
  0x0020,   /* U+4735 */
  0x0020,   /* U+4736 */
  0x0020,   /* U+4737 */
  0x0020,   /* U+4738 */
  0x0020,   /* U+4739 */
  0x0020,   /* U+473A */
  0x0020,   /* U+473B */
  0x0020,   /* U+473C */
  0x0020,   /* U+473D */
  0x0020,   /* U+473E */
  0x0020,   /* U+473F */
  0x0020,   /* U+4740 */
  0x0020,   /* U+4741 */
  0x0020,   /* U+4742 */
  0x0020,   /* U+4743 */
  0x0020,   /* U+4744 */
  0x0020,   /* U+4745 */
  0x0020,   /* U+4746 */
  0x0020,   /* U+4747 */
  0x0020,   /* U+4748 */
  0x0020,   /* U+4749 */
  0x0020,   /* U+474A */
  0x0020,   /* U+474B */
  0x0020,   /* U+474C */
  0x0020,   /* U+474D */
  0x0020,   /* U+474E */
  0x0020,   /* U+474F */
  0x0020,   /* U+4750 */
  0x0020,   /* U+4751 */
  0x0020,   /* U+4752 */
  0x0020,   /* U+4753 */
  0x0020,   /* U+4754 */
  0x0020,   /* U+4755 */
  0x0020,   /* U+4756 */
  0x0020,   /* U+4757 */
  0x0020,   /* U+4758 */
  0x0020,   /* U+4759 */
  0x0020,   /* U+475A */
  0x0020,   /* U+475B */
  0x0020,   /* U+475C */
  0x0020,   /* U+475D */
  0x0020,   /* U+475E */
  0x0020,   /* U+475F */
  0x0020,   /* U+4760 */
  0x0020,   /* U+4761 */
  0x0020,   /* U+4762 */
  0x0020,   /* U+4763 */
  0x0020,   /* U+4764 */
  0x0020,   /* U+4765 */
  0x0020,   /* U+4766 */
  0x0020,   /* U+4767 */
  0x0020,   /* U+4768 */
  0x0020,   /* U+4769 */
  0x0020,   /* U+476A */
  0x0020,   /* U+476B */
  0x0020,   /* U+476C */
  0x0020,   /* U+476D */
  0x0020,   /* U+476E */
  0x0020,   /* U+476F */
  0x0020,   /* U+4770 */
  0x0020,   /* U+4771 */
  0x0020,   /* U+4772 */
  0x0020,   /* U+4773 */
  0x0020,   /* U+4774 */
  0x0020,   /* U+4775 */
  0x0020,   /* U+4776 */
  0x0020,   /* U+4777 */
  0x0020,   /* U+4778 */
  0x0020,   /* U+4779 */
  0x0020,   /* U+477A */
  0x0020,   /* U+477B */
  0x0020,   /* U+477C */
  0x0020,   /* U+477D */
  0x0020,   /* U+477E */
  0x0020,   /* U+477F */
  0x0020,   /* U+4780 */
  0x0020,   /* U+4781 */
  0x0020,   /* U+4782 */
  0x0020,   /* U+4783 */
  0x0020,   /* U+4784 */
  0x0020,   /* U+4785 */
  0x0020,   /* U+4786 */
  0x0020,   /* U+4787 */
  0x0020,   /* U+4788 */
  0x0020,   /* U+4789 */
  0x0020,   /* U+478A */
  0x0020,   /* U+478B */
  0x0020,   /* U+478C */
  0x0020,   /* U+478D */
  0x0020,   /* U+478E */
  0x0020,   /* U+478F */
  0x0020,   /* U+4790 */
  0x0020,   /* U+4791 */
  0x0020,   /* U+4792 */
  0x0020,   /* U+4793 */
  0x0020,   /* U+4794 */
  0x0020,   /* U+4795 */
  0x0020,   /* U+4796 */
  0x0020,   /* U+4797 */
  0x0020,   /* U+4798 */
  0x0020,   /* U+4799 */
  0x0020,   /* U+479A */
  0x0020,   /* U+479B */
  0x0020,   /* U+479C */
  0x0020,   /* U+479D */
  0x0020,   /* U+479E */
  0x0020,   /* U+479F */
  0x0020,   /* U+47A0 */
  0x0020,   /* U+47A1 */
  0x0020,   /* U+47A2 */
  0x0020,   /* U+47A3 */
  0x0020,   /* U+47A4 */
  0x0020,   /* U+47A5 */
  0x0020,   /* U+47A6 */
  0x0020,   /* U+47A7 */
  0x0020,   /* U+47A8 */
  0x0020,   /* U+47A9 */
  0x0020,   /* U+47AA */
  0x0020,   /* U+47AB */
  0x0020,   /* U+47AC */
  0x0020,   /* U+47AD */
  0x0020,   /* U+47AE */
  0x0020,   /* U+47AF */
  0x0020,   /* U+47B0 */
  0x0020,   /* U+47B1 */
  0x0020,   /* U+47B2 */
  0x0020,   /* U+47B3 */
  0x0020,   /* U+47B4 */
  0x0020,   /* U+47B5 */
  0x0020,   /* U+47B6 */
  0x0020,   /* U+47B7 */
  0x0020,   /* U+47B8 */
  0x0020,   /* U+47B9 */
  0x0020,   /* U+47BA */
  0x0020,   /* U+47BB */
  0x0020,   /* U+47BC */
  0x0020,   /* U+47BD */
  0x0020,   /* U+47BE */
  0x0020,   /* U+47BF */
  0x0020,   /* U+47C0 */
  0x0020,   /* U+47C1 */
  0x0020,   /* U+47C2 */
  0x0020,   /* U+47C3 */
  0x0020,   /* U+47C4 */
  0x0020,   /* U+47C5 */
  0x0020,   /* U+47C6 */
  0x0020,   /* U+47C7 */
  0x0020,   /* U+47C8 */
  0x0020,   /* U+47C9 */
  0x0020,   /* U+47CA */
  0x0020,   /* U+47CB */
  0x0020,   /* U+47CC */
  0x0020,   /* U+47CD */
  0x0020,   /* U+47CE */
  0x0020,   /* U+47CF */
  0x0020,   /* U+47D0 */
  0x0020,   /* U+47D1 */
  0x0020,   /* U+47D2 */
  0x0020,   /* U+47D3 */
  0x0020,   /* U+47D4 */
  0x0020,   /* U+47D5 */
  0x0020,   /* U+47D6 */
  0x0020,   /* U+47D7 */
  0x0020,   /* U+47D8 */
  0x0020,   /* U+47D9 */
  0x0020,   /* U+47DA */
  0x0020,   /* U+47DB */
  0x0020,   /* U+47DC */
  0x0020,   /* U+47DD */
  0x0020,   /* U+47DE */
  0x0020,   /* U+47DF */
  0x0020,   /* U+47E0 */
  0x0020,   /* U+47E1 */
  0x0020,   /* U+47E2 */
  0x0020,   /* U+47E3 */
  0x0020,   /* U+47E4 */
  0x0020,   /* U+47E5 */
  0x0020,   /* U+47E6 */
  0x0020,   /* U+47E7 */
  0x0020,   /* U+47E8 */
  0x0020,   /* U+47E9 */
  0x0020,   /* U+47EA */
  0x0020,   /* U+47EB */
  0x0020,   /* U+47EC */
  0x0020,   /* U+47ED */
  0x0020,   /* U+47EE */
  0x0020,   /* U+47EF */
  0x0020,   /* U+47F0 */
  0x0020,   /* U+47F1 */
  0x0020,   /* U+47F2 */
  0x0020,   /* U+47F3 */
  0x0020,   /* U+47F4 */
  0x0020,   /* U+47F5 */
  0x0020,   /* U+47F6 */
  0x0020,   /* U+47F7 */
  0x0020,   /* U+47F8 */
  0x0020,   /* U+47F9 */
  0x0020,   /* U+47FA */
  0x0020,   /* U+47FB */
  0x0020,   /* U+47FC */
  0x0020,   /* U+47FD */
  0x0020,   /* U+47FE */
  0x0020,   /* U+47FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4700 */
  0x0002,   /* U+4701 */
  0x0002,   /* U+4702 */
  0x0002,   /* U+4703 */
  0x0002,   /* U+4704 */
  0x0002,   /* U+4705 */
  0x0002,   /* U+4706 */
  0x0002,   /* U+4707 */
  0x0002,   /* U+4708 */
  0x0002,   /* U+4709 */
  0x0002,   /* U+470A */
  0x0002,   /* U+470B */
  0x0002,   /* U+470C */
  0x0002,   /* U+470D */
  0x0002,   /* U+470E */
  0x0002,   /* U+470F */
  0x0002,   /* U+4710 */
  0x0002,   /* U+4711 */
  0x0002,   /* U+4712 */
  0x0002,   /* U+4713 */
  0x0002,   /* U+4714 */
  0x0002,   /* U+4715 */
  0x0002,   /* U+4716 */
  0x0002,   /* U+4717 */
  0x0002,   /* U+4718 */
  0x0002,   /* U+4719 */
  0x0002,   /* U+471A */
  0x0002,   /* U+471B */
  0x0002,   /* U+471C */
  0x0002,   /* U+471D */
  0x0002,   /* U+471E */
  0x0002,   /* U+471F */
  0x0002,   /* U+4720 */
  0x0002,   /* U+4721 */
  0x0002,   /* U+4722 */
  0x0002,   /* U+4723 */
  0x0002,   /* U+4724 */
  0x0002,   /* U+4725 */
  0x0002,   /* U+4726 */
  0x0002,   /* U+4727 */
  0x0002,   /* U+4728 */
  0x0002,   /* U+4729 */
  0x0002,   /* U+472A */
  0x0002,   /* U+472B */
  0x0002,   /* U+472C */
  0x0002,   /* U+472D */
  0x0002,   /* U+472E */
  0x0002,   /* U+472F */
  0x0002,   /* U+4730 */
  0x0002,   /* U+4731 */
  0x0002,   /* U+4732 */
  0x0002,   /* U+4733 */
  0x0002,   /* U+4734 */
  0x0002,   /* U+4735 */
  0x0002,   /* U+4736 */
  0x0002,   /* U+4737 */
  0x0002,   /* U+4738 */
  0x0002,   /* U+4739 */
  0x0002,   /* U+473A */
  0x0002,   /* U+473B */
  0x0002,   /* U+473C */
  0x0002,   /* U+473D */
  0x0002,   /* U+473E */
  0x0002,   /* U+473F */
  0x0002,   /* U+4740 */
  0x0002,   /* U+4741 */
  0x0002,   /* U+4742 */
  0x0002,   /* U+4743 */
  0x0002,   /* U+4744 */
  0x0002,   /* U+4745 */
  0x0002,   /* U+4746 */
  0x0002,   /* U+4747 */
  0x0002,   /* U+4748 */
  0x0002,   /* U+4749 */
  0x0002,   /* U+474A */
  0x0002,   /* U+474B */
  0x0002,   /* U+474C */
  0x0002,   /* U+474D */
  0x0002,   /* U+474E */
  0x0002,   /* U+474F */
  0x0002,   /* U+4750 */
  0x0002,   /* U+4751 */
  0x0002,   /* U+4752 */
  0x0002,   /* U+4753 */
  0x0002,   /* U+4754 */
  0x0002,   /* U+4755 */
  0x0002,   /* U+4756 */
  0x0002,   /* U+4757 */
  0x0002,   /* U+4758 */
  0x0002,   /* U+4759 */
  0x0002,   /* U+475A */
  0x0002,   /* U+475B */
  0x0002,   /* U+475C */
  0x0002,   /* U+475D */
  0x0002,   /* U+475E */
  0x0002,   /* U+475F */
  0x0002,   /* U+4760 */
  0x0002,   /* U+4761 */
  0x0002,   /* U+4762 */
  0x0002,   /* U+4763 */
  0x0002,   /* U+4764 */
  0x0002,   /* U+4765 */
  0x0002,   /* U+4766 */
  0x0002,   /* U+4767 */
  0x0002,   /* U+4768 */
  0x0002,   /* U+4769 */
  0x0002,   /* U+476A */
  0x0002,   /* U+476B */
  0x0002,   /* U+476C */
  0x0002,   /* U+476D */
  0x0002,   /* U+476E */
  0x0002,   /* U+476F */
  0x0002,   /* U+4770 */
  0x0002,   /* U+4771 */
  0x0002,   /* U+4772 */
  0x0002,   /* U+4773 */
  0x0002,   /* U+4774 */
  0x0002,   /* U+4775 */
  0x0002,   /* U+4776 */
  0x0002,   /* U+4777 */
  0x0002,   /* U+4778 */
  0x0002,   /* U+4779 */
  0x0002,   /* U+477A */
  0x0002,   /* U+477B */
  0x0002,   /* U+477C */
  0x0002,   /* U+477D */
  0x0002,   /* U+477E */
  0x0002,   /* U+477F */
  0x0002,   /* U+4780 */
  0x0002,   /* U+4781 */
  0x0002,   /* U+4782 */
  0x0002,   /* U+4783 */
  0x0002,   /* U+4784 */
  0x0002,   /* U+4785 */
  0x0002,   /* U+4786 */
  0x0002,   /* U+4787 */
  0x0002,   /* U+4788 */
  0x0002,   /* U+4789 */
  0x0002,   /* U+478A */
  0x0002,   /* U+478B */
  0x0002,   /* U+478C */
  0x0002,   /* U+478D */
  0x0002,   /* U+478E */
  0x0002,   /* U+478F */
  0x0002,   /* U+4790 */
  0x0002,   /* U+4791 */
  0x0002,   /* U+4792 */
  0x0002,   /* U+4793 */
  0x0002,   /* U+4794 */
  0x0002,   /* U+4795 */
  0x0002,   /* U+4796 */
  0x0002,   /* U+4797 */
  0x0002,   /* U+4798 */
  0x0002,   /* U+4799 */
  0x0002,   /* U+479A */
  0x0002,   /* U+479B */
  0x0002,   /* U+479C */
  0x0002,   /* U+479D */
  0x0002,   /* U+479E */
  0x0002,   /* U+479F */
  0x0002,   /* U+47A0 */
  0x0002,   /* U+47A1 */
  0x0002,   /* U+47A2 */
  0x0002,   /* U+47A3 */
  0x0002,   /* U+47A4 */
  0x0002,   /* U+47A5 */
  0x0002,   /* U+47A6 */
  0x0002,   /* U+47A7 */
  0x0002,   /* U+47A8 */
  0x0002,   /* U+47A9 */
  0x0002,   /* U+47AA */
  0x0002,   /* U+47AB */
  0x0002,   /* U+47AC */
  0x0002,   /* U+47AD */
  0x0002,   /* U+47AE */
  0x0002,   /* U+47AF */
  0x0002,   /* U+47B0 */
  0x0002,   /* U+47B1 */
  0x0002,   /* U+47B2 */
  0x0002,   /* U+47B3 */
  0x0002,   /* U+47B4 */
  0x0002,   /* U+47B5 */
  0x0002,   /* U+47B6 */
  0x0002,   /* U+47B7 */
  0x0002,   /* U+47B8 */
  0x0002,   /* U+47B9 */
  0x0002,   /* U+47BA */
  0x0002,   /* U+47BB */
  0x0002,   /* U+47BC */
  0x0002,   /* U+47BD */
  0x0002,   /* U+47BE */
  0x0002,   /* U+47BF */
  0x0002,   /* U+47C0 */
  0x0002,   /* U+47C1 */
  0x0002,   /* U+47C2 */
  0x0002,   /* U+47C3 */
  0x0002,   /* U+47C4 */
  0x0002,   /* U+47C5 */
  0x0002,   /* U+47C6 */
  0x0002,   /* U+47C7 */
  0x0002,   /* U+47C8 */
  0x0002,   /* U+47C9 */
  0x0002,   /* U+47CA */
  0x0002,   /* U+47CB */
  0x0002,   /* U+47CC */
  0x0002,   /* U+47CD */
  0x0002,   /* U+47CE */
  0x0002,   /* U+47CF */
  0x0002,   /* U+47D0 */
  0x0002,   /* U+47D1 */
  0x0002,   /* U+47D2 */
  0x0002,   /* U+47D3 */
  0x0002,   /* U+47D4 */
  0x0002,   /* U+47D5 */
  0x0002,   /* U+47D6 */
  0x0002,   /* U+47D7 */
  0x0002,   /* U+47D8 */
  0x0002,   /* U+47D9 */
  0x0002,   /* U+47DA */
  0x0002,   /* U+47DB */
  0x0002,   /* U+47DC */
  0x0002,   /* U+47DD */
  0x0002,   /* U+47DE */
  0x0002,   /* U+47DF */
  0x0002,   /* U+47E0 */
  0x0002,   /* U+47E1 */
  0x0002,   /* U+47E2 */
  0x0002,   /* U+47E3 */
  0x0002,   /* U+47E4 */
  0x0002,   /* U+47E5 */
  0x0002,   /* U+47E6 */
  0x0002,   /* U+47E7 */
  0x0002,   /* U+47E8 */
  0x0002,   /* U+47E9 */
  0x0002,   /* U+47EA */
  0x0002,   /* U+47EB */
  0x0002,   /* U+47EC */
  0x0002,   /* U+47ED */
  0x0002,   /* U+47EE */
  0x0002,   /* U+47EF */
  0x0002,   /* U+47F0 */
  0x0002,   /* U+47F1 */
  0x0002,   /* U+47F2 */
  0x0002,   /* U+47F3 */
  0x0002,   /* U+47F4 */
  0x0002,   /* U+47F5 */
  0x0002,   /* U+47F6 */
  0x0002,   /* U+47F7 */
  0x0002,   /* U+47F8 */
  0x0002,   /* U+47F9 */
  0x0002,   /* U+47FA */
  0x0002,   /* U+47FB */
  0x0002,   /* U+47FC */
  0x0002,   /* U+47FD */
  0x0002,   /* U+47FE */
  0x0002,   /* U+47FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0xC702,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0xC724,   /* U+4724 */
  0xC725,   /* U+4725 */
  0xC726,   /* U+4726 */
  0x0000,   /* U+4727 */
  0xC728,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0xC730,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0xC733,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0xC73F,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0xC746,   /* U+4746 */
  0xC747,   /* U+4747 */
  0x0000,   /* U+4748 */
  0xC749,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0xC754,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0xC757,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0xC774,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0xC78E,   /* U+478E */
  0xC78F,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0xC7B2,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0xC7CE,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0xC7F1,   /* U+47F1 */
  0xC7F2,   /* U+47F2 */
  0xC7F3,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0xC7FD,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */
};

uint16_t zh_han_p048[] = {
  /* Number of CEs for each character. */
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 
  1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x8CCB,   /* U+4800 */
  0xBDC1,   /* U+4801 */
  0x2BA6,   /* U+4802 */
  0x6125,   /* U+4803 */
  0x8EEF,   /* U+4804 */
  0x5B38,   /* U+4805 */
  0x27B0,   /* U+4806 */
  0x56AB,   /* U+4807 */
  0x90D8,   /* U+4808 */
  0x48FD,   /* U+4809 */
  0x39B9,   /* U+480A */
  0x216B,   /* U+480B */
  0xBDC1,   /* U+480C */
  0x9922,   /* U+480D */
  0x95F1,   /* U+480E */
  0x4D9D,   /* U+480F */
  0x7DA2,   /* U+4810 */
  0x5AC4,   /* U+4811 */
  0x4737,   /* U+4812 */
  0x7C49,   /* U+4813 */
  0x8AA3,   /* U+4814 */
  0x24CB,   /* U+4815 */
  0xBDC1,   /* U+4816 */
  0x7CC4,   /* U+4817 */
  0x74C3,   /* U+4818 */
  0x72E6,   /* U+4819 */
  0x9285,   /* U+481A */
  0xA50B,   /* U+481B */
  0x7FC5,   /* U+481C */
  0xA13C,   /* U+481D */
  0x2E85,   /* U+481E */
  0x33D9,   /* U+481F */
  0x2A97,   /* U+4820 */
  0x2F4A,   /* U+4821 */
  0x6A62,   /* U+4822 */
  0xA093,   /* U+4823 */
  0x36B4,   /* U+4824 */
  0x22CA,   /* U+4825 */
  0xB4E6,   /* U+4826 */
  0x2BB6,   /* U+4827 */
  0x276E,   /* U+4828 */
  0x4223,   /* U+4829 */
  0x35C8,   /* U+482A */
  0xBCAC,   /* U+482B */
  0x31D5,   /* U+482C */
  0x5BF1,   /* U+482D */
  0x8DD0,   /* U+482E */
  0xAFF8,   /* U+482F */
  0x7E08,   /* U+4830 */
  0xB986,   /* U+4831 */
  0x62DF,   /* U+4832 */
  0x2884,   /* U+4833 */
  0xB551,   /* U+4834 */
  0x3C5B,   /* U+4835 */
  0x840C,   /* U+4836 */
  0x8F44,   /* U+4837 */
  0x59B9,   /* U+4838 */
  0x1C68,   /* U+4839 */
  0xBDC1,   /* U+483A */
  0x7C10,   /* U+483B */
  0x8776,   /* U+483C */
  0x42EC,   /* U+483D */
  0x8316,   /* U+483E */
  0x929F,   /* U+483F */
  0xB37C,   /* U+4840 */
  0x647D,   /* U+4841 */
  0x5407,   /* U+4842 */
  0x5F39,   /* U+4843 */
  0xBDC1,   /* U+4844 */
  0x2CD1,   /* U+4845 */
  0x7F9A,   /* U+4846 */
  0xAFB8,   /* U+4847 */
  0x5672,   /* U+4848 */
  0x580D,   /* U+4849 */
  0x38D8,   /* U+484A */
  0x774F,   /* U+484B */
  0x45F4,   /* U+484C */
  0x3B8C,   /* U+484D */
  0x6501,   /* U+484E */
  0x45FF,   /* U+484F */
  0x91F9,   /* U+4850 */
  0x6C09,   /* U+4851 */
  0x8EB3,   /* U+4852 */
  0x5613,   /* U+4853 */
  0x77EA,   /* U+4854 */
  0xB5F4,   /* U+4855 */
  0x7BCB,   /* U+4856 */
  0x3F4E,   /* U+4857 */
  0x8EBD,   /* U+4858 */
  0x5CC4,   /* U+4859 */
  0x692C,   /* U+485A */
  0xAA18,   /* U+485B */
  0x65BA,   /* U+485C */
  0xAEE8,   /* U+485D */
  0x54FD,   /* U+485E */
  0x74BB,   /* U+485F */
  0xBDC1,   /* U+4860 */
  0x9CDB,   /* U+4861 */
  0x2228,   /* U+4862 */
  0x4AC2,   /* U+4863 */
  0xB944,   /* U+4864 */
  0x7FC8,   /* U+4865 */
  0x81AC,   /* U+4866 */
  0x9628,   /* U+4867 */
  0x2672,   /* U+4868 */
  0x5901,   /* U+4869 */
  0x834C,   /* U+486A */
  0x73CD,   /* U+486B */
  0x6861,   /* U+486C */
  0x9EE3,   /* U+486D */
  0xBDC1,   /* U+486E */
  0x2E06,   /* U+486F */
  0x5905,   /* U+4870 */
  0xBA38,   /* U+4871 */
  0x26EF,   /* U+4872 */
  0x888B,   /* U+4873 */
  0x2ACC,   /* U+4874 */
  0x8ABB,   /* U+4875 */
  0x1FFF,   /* U+4876 */
  0x57A6,   /* U+4877 */
  0xBDC1,   /* U+4878 */
  0xB812,   /* U+4879 */
  0x94FC,   /* U+487A */
  0x6C1C,   /* U+487B */
  0x6332,   /* U+487C */
  0xBD03,   /* U+487D */
  0x70C7,   /* U+487E */
  0x6357,   /* U+487F */
  0x7821,   /* U+4880 */
  0xAFBA,   /* U+4881 */
  0xBDC1,   /* U+4882 */
  0xA89F,   /* U+4883 */
  0x987F,   /* U+4884 */
  0x28BB,   /* U+4885 */
  0xBDC1,   /* U+4886 */
  0x7FF3,   /* U+4887 */
  0x28CB,   /* U+4888 */
  0x7149,   /* U+4889 */
  0xABD9,   /* U+488A */
  0x4D1E,   /* U+488B */
  0x23A9,   /* U+488C */
  0x3938,   /* U+488D */
  0xBDC1,   /* U+488E */
  0xBDC1,   /* U+488F */
  0x2E5E,   /* U+4890 */
  0x324A,   /* U+4891 */
  0x5070,   /* U+4892 */
  0xACDE,   /* U+4893 */
  0x44CE,   /* U+4894 */
  0x9FB9,   /* U+4895 */
  0xADDE,   /* U+4896 */
  0x7CDF,   /* U+4897 */
  0xBDC1,   /* U+4898 */
  0x1E6C,   /* U+4899 */
  0x3EBB,   /* U+489A */
  0x53DC,   /* U+489B */
  0xBDC1,   /* U+489C */
  0xA23A,   /* U+489D */
  0x875C,   /* U+489E */
  0xABFF,   /* U+489F */
  0x892F,   /* U+48A0 */
  0xA5E8,   /* U+48A1 */
  0x2579,   /* U+48A2 */
  0xA4F4,   /* U+48A3 */
  0x876B,   /* U+48A4 */
  0xA2BE,   /* U+48A5 */
  0x87A1,   /* U+48A6 */
  0x61A8,   /* U+48A7 */
  0x2DF7,   /* U+48A8 */
  0xAE4D,   /* U+48A9 */
  0x23FF,   /* U+48AA */
  0x8A64,   /* U+48AB */
  0xBDC1,   /* U+48AC */
  0xA3C6,   /* U+48AD */
  0x5DFE,   /* U+48AE */
  0x6250,   /* U+48AF */
  0x8DE3,   /* U+48B0 */
  0x3545,   /* U+48B1 */
  0xAFF9,   /* U+48B2 */
  0x4CE4,   /* U+48B3 */
  0xBDC1,   /* U+48B4 */
  0xB025,   /* U+48B5 */
  0xBDC1,   /* U+48B6 */
  0xBDC1,   /* U+48B7 */
  0x5485,   /* U+48B8 */
  0x5528,   /* U+48B9 */
  0x2B7D,   /* U+48BA */
  0x28A4,   /* U+48BB */
  0x3F0E,   /* U+48BC */
  0x9B86,   /* U+48BD */
  0x9A5D,   /* U+48BE */
  0x1CD4,   /* U+48BF */
  0x41C3,   /* U+48C0 */
  0xAD7B,   /* U+48C1 */
  0x5DB5,   /* U+48C2 */
  0xBDC1,   /* U+48C3 */
  0x90B0,   /* U+48C4 */
  0x28AA,   /* U+48C5 */
  0x9E4F,   /* U+48C6 */
  0x7C84,   /* U+48C7 */
  0x441E,   /* U+48C8 */
  0xBDC1,   /* U+48C9 */
  0x30EC,   /* U+48CA */
  0x24E3,   /* U+48CB */
  0x324F,   /* U+48CC */
  0xA31A,   /* U+48CD */
  0xBB78,   /* U+48CE */
  0xBDC1,   /* U+48CF */
  0xAA45,   /* U+48D0 */
  0x26C9,   /* U+48D1 */
  0xBDC1,   /* U+48D2 */
  0x5E59,   /* U+48D3 */
  0x8B24,   /* U+48D4 */
  0x67A8,   /* U+48D5 */
  0x67AD,   /* U+48D6 */
  0xBDC1,   /* U+48D7 */
  0x8CF2,   /* U+48D8 */
  0x7351,   /* U+48D9 */
  0x64AE,   /* U+48DA */
  0x76EE,   /* U+48DB */
  0x2F45,   /* U+48DC */
  0x90D9,   /* U+48DD */
  0x379E,   /* U+48DE */
  0x2522,   /* U+48DF */
  0x51EA,   /* U+48E0 */
  0xA71B,   /* U+48E1 */
  0x4CC0,   /* U+48E2 */
  0x30F7,   /* U+48E3 */
  0x56E7,   /* U+48E4 */
  0x20AE,   /* U+48E5 */
  0x5DED,   /* U+48E6 */
  0xA80F,   /* U+48E7 */
  0x2CF0,   /* U+48E8 */
  0x2CF3,   /* U+48E9 */
  0x7621,   /* U+48EA */
  0x5E3F,   /* U+48EB */
  0xB0ED,   /* U+48EC */
  0x8C1C,   /* U+48ED */
  0x7627,   /* U+48EE */
  0x2E60,   /* U+48EF */
  0x557F,   /* U+48F0 */
  0x9FE5,   /* U+48F1 */
  0x38FE,   /* U+48F2 */
  0xBDC1,   /* U+48F3 */
  0x9FE6,   /* U+48F4 */
  0x3839,   /* U+48F5 */
  0x4B14,   /* U+48F6 */
  0xB93A,   /* U+48F7 */
  0x7EC8,   /* U+48F8 */
  0x385D,   /* U+48F9 */
  0x55D3,   /* U+48FA */
  0x432E,   /* U+48FB */
  0x610C,   /* U+48FC */
  0xB669,   /* U+48FD */
  0x6B19,   /* U+48FE */
  0xACAD,   /* U+48FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4800 */
  0x0020,   /* U+4801 */
  0x0020,   /* U+4802 */
  0x0020,   /* U+4803 */
  0x0020,   /* U+4804 */
  0x0020,   /* U+4805 */
  0x0020,   /* U+4806 */
  0x0020,   /* U+4807 */
  0x0020,   /* U+4808 */
  0x0020,   /* U+4809 */
  0x0020,   /* U+480A */
  0x0020,   /* U+480B */
  0x0020,   /* U+480C */
  0x0020,   /* U+480D */
  0x0020,   /* U+480E */
  0x0020,   /* U+480F */
  0x0020,   /* U+4810 */
  0x0020,   /* U+4811 */
  0x0020,   /* U+4812 */
  0x0020,   /* U+4813 */
  0x0020,   /* U+4814 */
  0x0020,   /* U+4815 */
  0x0020,   /* U+4816 */
  0x0020,   /* U+4817 */
  0x0020,   /* U+4818 */
  0x0020,   /* U+4819 */
  0x0020,   /* U+481A */
  0x0020,   /* U+481B */
  0x0020,   /* U+481C */
  0x0020,   /* U+481D */
  0x0020,   /* U+481E */
  0x0020,   /* U+481F */
  0x0020,   /* U+4820 */
  0x0020,   /* U+4821 */
  0x0020,   /* U+4822 */
  0x0020,   /* U+4823 */
  0x0020,   /* U+4824 */
  0x0020,   /* U+4825 */
  0x0020,   /* U+4826 */
  0x0020,   /* U+4827 */
  0x0020,   /* U+4828 */
  0x0020,   /* U+4829 */
  0x0020,   /* U+482A */
  0x0020,   /* U+482B */
  0x0020,   /* U+482C */
  0x0020,   /* U+482D */
  0x0020,   /* U+482E */
  0x0020,   /* U+482F */
  0x0020,   /* U+4830 */
  0x0020,   /* U+4831 */
  0x0020,   /* U+4832 */
  0x0020,   /* U+4833 */
  0x0020,   /* U+4834 */
  0x0020,   /* U+4835 */
  0x0020,   /* U+4836 */
  0x0020,   /* U+4837 */
  0x0020,   /* U+4838 */
  0x0020,   /* U+4839 */
  0x0020,   /* U+483A */
  0x0020,   /* U+483B */
  0x0020,   /* U+483C */
  0x0020,   /* U+483D */
  0x0020,   /* U+483E */
  0x0020,   /* U+483F */
  0x0020,   /* U+4840 */
  0x0020,   /* U+4841 */
  0x0020,   /* U+4842 */
  0x0020,   /* U+4843 */
  0x0020,   /* U+4844 */
  0x0020,   /* U+4845 */
  0x0020,   /* U+4846 */
  0x0020,   /* U+4847 */
  0x0020,   /* U+4848 */
  0x0020,   /* U+4849 */
  0x0020,   /* U+484A */
  0x0020,   /* U+484B */
  0x0020,   /* U+484C */
  0x0020,   /* U+484D */
  0x0020,   /* U+484E */
  0x0020,   /* U+484F */
  0x0020,   /* U+4850 */
  0x0020,   /* U+4851 */
  0x0020,   /* U+4852 */
  0x0020,   /* U+4853 */
  0x0020,   /* U+4854 */
  0x0020,   /* U+4855 */
  0x0020,   /* U+4856 */
  0x0020,   /* U+4857 */
  0x0020,   /* U+4858 */
  0x0020,   /* U+4859 */
  0x0020,   /* U+485A */
  0x0020,   /* U+485B */
  0x0020,   /* U+485C */
  0x0020,   /* U+485D */
  0x0020,   /* U+485E */
  0x0020,   /* U+485F */
  0x0020,   /* U+4860 */
  0x0020,   /* U+4861 */
  0x0020,   /* U+4862 */
  0x0020,   /* U+4863 */
  0x0020,   /* U+4864 */
  0x0020,   /* U+4865 */
  0x0020,   /* U+4866 */
  0x0020,   /* U+4867 */
  0x0020,   /* U+4868 */
  0x0020,   /* U+4869 */
  0x0020,   /* U+486A */
  0x0020,   /* U+486B */
  0x0020,   /* U+486C */
  0x0020,   /* U+486D */
  0x0020,   /* U+486E */
  0x0020,   /* U+486F */
  0x0020,   /* U+4870 */
  0x0020,   /* U+4871 */
  0x0020,   /* U+4872 */
  0x0020,   /* U+4873 */
  0x0020,   /* U+4874 */
  0x0020,   /* U+4875 */
  0x0020,   /* U+4876 */
  0x0020,   /* U+4877 */
  0x0020,   /* U+4878 */
  0x0020,   /* U+4879 */
  0x0020,   /* U+487A */
  0x0020,   /* U+487B */
  0x0020,   /* U+487C */
  0x0020,   /* U+487D */
  0x0020,   /* U+487E */
  0x0020,   /* U+487F */
  0x0020,   /* U+4880 */
  0x0020,   /* U+4881 */
  0x0020,   /* U+4882 */
  0x0020,   /* U+4883 */
  0x0020,   /* U+4884 */
  0x0020,   /* U+4885 */
  0x0020,   /* U+4886 */
  0x0020,   /* U+4887 */
  0x0020,   /* U+4888 */
  0x0020,   /* U+4889 */
  0x0020,   /* U+488A */
  0x0020,   /* U+488B */
  0x0020,   /* U+488C */
  0x0020,   /* U+488D */
  0x0020,   /* U+488E */
  0x0020,   /* U+488F */
  0x0020,   /* U+4890 */
  0x0020,   /* U+4891 */
  0x0020,   /* U+4892 */
  0x0020,   /* U+4893 */
  0x0020,   /* U+4894 */
  0x0020,   /* U+4895 */
  0x0020,   /* U+4896 */
  0x0020,   /* U+4897 */
  0x0020,   /* U+4898 */
  0x0020,   /* U+4899 */
  0x0020,   /* U+489A */
  0x0020,   /* U+489B */
  0x0020,   /* U+489C */
  0x0020,   /* U+489D */
  0x0020,   /* U+489E */
  0x0020,   /* U+489F */
  0x0020,   /* U+48A0 */
  0x0020,   /* U+48A1 */
  0x0020,   /* U+48A2 */
  0x0020,   /* U+48A3 */
  0x0020,   /* U+48A4 */
  0x0020,   /* U+48A5 */
  0x0020,   /* U+48A6 */
  0x0020,   /* U+48A7 */
  0x0020,   /* U+48A8 */
  0x0020,   /* U+48A9 */
  0x0020,   /* U+48AA */
  0x0020,   /* U+48AB */
  0x0020,   /* U+48AC */
  0x0020,   /* U+48AD */
  0x0020,   /* U+48AE */
  0x0020,   /* U+48AF */
  0x0020,   /* U+48B0 */
  0x0020,   /* U+48B1 */
  0x0020,   /* U+48B2 */
  0x0020,   /* U+48B3 */
  0x0020,   /* U+48B4 */
  0x0020,   /* U+48B5 */
  0x0020,   /* U+48B6 */
  0x0020,   /* U+48B7 */
  0x0020,   /* U+48B8 */
  0x0020,   /* U+48B9 */
  0x0020,   /* U+48BA */
  0x0020,   /* U+48BB */
  0x0020,   /* U+48BC */
  0x0020,   /* U+48BD */
  0x0020,   /* U+48BE */
  0x0020,   /* U+48BF */
  0x0020,   /* U+48C0 */
  0x0020,   /* U+48C1 */
  0x0020,   /* U+48C2 */
  0x0020,   /* U+48C3 */
  0x0020,   /* U+48C4 */
  0x0020,   /* U+48C5 */
  0x0020,   /* U+48C6 */
  0x0020,   /* U+48C7 */
  0x0020,   /* U+48C8 */
  0x0020,   /* U+48C9 */
  0x0020,   /* U+48CA */
  0x0020,   /* U+48CB */
  0x0020,   /* U+48CC */
  0x0020,   /* U+48CD */
  0x0020,   /* U+48CE */
  0x0020,   /* U+48CF */
  0x0020,   /* U+48D0 */
  0x0020,   /* U+48D1 */
  0x0020,   /* U+48D2 */
  0x0020,   /* U+48D3 */
  0x0020,   /* U+48D4 */
  0x0020,   /* U+48D5 */
  0x0020,   /* U+48D6 */
  0x0020,   /* U+48D7 */
  0x0020,   /* U+48D8 */
  0x0020,   /* U+48D9 */
  0x0020,   /* U+48DA */
  0x0020,   /* U+48DB */
  0x0020,   /* U+48DC */
  0x0020,   /* U+48DD */
  0x0020,   /* U+48DE */
  0x0020,   /* U+48DF */
  0x0020,   /* U+48E0 */
  0x0020,   /* U+48E1 */
  0x0020,   /* U+48E2 */
  0x0020,   /* U+48E3 */
  0x0020,   /* U+48E4 */
  0x0020,   /* U+48E5 */
  0x0020,   /* U+48E6 */
  0x0020,   /* U+48E7 */
  0x0020,   /* U+48E8 */
  0x0020,   /* U+48E9 */
  0x0020,   /* U+48EA */
  0x0020,   /* U+48EB */
  0x0020,   /* U+48EC */
  0x0020,   /* U+48ED */
  0x0020,   /* U+48EE */
  0x0020,   /* U+48EF */
  0x0020,   /* U+48F0 */
  0x0020,   /* U+48F1 */
  0x0020,   /* U+48F2 */
  0x0020,   /* U+48F3 */
  0x0020,   /* U+48F4 */
  0x0020,   /* U+48F5 */
  0x0020,   /* U+48F6 */
  0x0020,   /* U+48F7 */
  0x0020,   /* U+48F8 */
  0x0020,   /* U+48F9 */
  0x0020,   /* U+48FA */
  0x0020,   /* U+48FB */
  0x0020,   /* U+48FC */
  0x0020,   /* U+48FD */
  0x0020,   /* U+48FE */
  0x0020,   /* U+48FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4800 */
  0x0002,   /* U+4801 */
  0x0002,   /* U+4802 */
  0x0002,   /* U+4803 */
  0x0002,   /* U+4804 */
  0x0002,   /* U+4805 */
  0x0002,   /* U+4806 */
  0x0002,   /* U+4807 */
  0x0002,   /* U+4808 */
  0x0002,   /* U+4809 */
  0x0002,   /* U+480A */
  0x0002,   /* U+480B */
  0x0002,   /* U+480C */
  0x0002,   /* U+480D */
  0x0002,   /* U+480E */
  0x0002,   /* U+480F */
  0x0002,   /* U+4810 */
  0x0002,   /* U+4811 */
  0x0002,   /* U+4812 */
  0x0002,   /* U+4813 */
  0x0002,   /* U+4814 */
  0x0002,   /* U+4815 */
  0x0002,   /* U+4816 */
  0x0002,   /* U+4817 */
  0x0002,   /* U+4818 */
  0x0002,   /* U+4819 */
  0x0002,   /* U+481A */
  0x0002,   /* U+481B */
  0x0002,   /* U+481C */
  0x0002,   /* U+481D */
  0x0002,   /* U+481E */
  0x0002,   /* U+481F */
  0x0002,   /* U+4820 */
  0x0002,   /* U+4821 */
  0x0002,   /* U+4822 */
  0x0002,   /* U+4823 */
  0x0002,   /* U+4824 */
  0x0002,   /* U+4825 */
  0x0002,   /* U+4826 */
  0x0002,   /* U+4827 */
  0x0002,   /* U+4828 */
  0x0002,   /* U+4829 */
  0x0002,   /* U+482A */
  0x0002,   /* U+482B */
  0x0002,   /* U+482C */
  0x0002,   /* U+482D */
  0x0002,   /* U+482E */
  0x0002,   /* U+482F */
  0x0002,   /* U+4830 */
  0x0002,   /* U+4831 */
  0x0002,   /* U+4832 */
  0x0002,   /* U+4833 */
  0x0002,   /* U+4834 */
  0x0002,   /* U+4835 */
  0x0002,   /* U+4836 */
  0x0002,   /* U+4837 */
  0x0002,   /* U+4838 */
  0x0002,   /* U+4839 */
  0x0002,   /* U+483A */
  0x0002,   /* U+483B */
  0x0002,   /* U+483C */
  0x0002,   /* U+483D */
  0x0002,   /* U+483E */
  0x0002,   /* U+483F */
  0x0002,   /* U+4840 */
  0x0002,   /* U+4841 */
  0x0002,   /* U+4842 */
  0x0002,   /* U+4843 */
  0x0002,   /* U+4844 */
  0x0002,   /* U+4845 */
  0x0002,   /* U+4846 */
  0x0002,   /* U+4847 */
  0x0002,   /* U+4848 */
  0x0002,   /* U+4849 */
  0x0002,   /* U+484A */
  0x0002,   /* U+484B */
  0x0002,   /* U+484C */
  0x0002,   /* U+484D */
  0x0002,   /* U+484E */
  0x0002,   /* U+484F */
  0x0002,   /* U+4850 */
  0x0002,   /* U+4851 */
  0x0002,   /* U+4852 */
  0x0002,   /* U+4853 */
  0x0002,   /* U+4854 */
  0x0002,   /* U+4855 */
  0x0002,   /* U+4856 */
  0x0002,   /* U+4857 */
  0x0002,   /* U+4858 */
  0x0002,   /* U+4859 */
  0x0002,   /* U+485A */
  0x0002,   /* U+485B */
  0x0002,   /* U+485C */
  0x0002,   /* U+485D */
  0x0002,   /* U+485E */
  0x0002,   /* U+485F */
  0x0002,   /* U+4860 */
  0x0002,   /* U+4861 */
  0x0002,   /* U+4862 */
  0x0002,   /* U+4863 */
  0x0002,   /* U+4864 */
  0x0002,   /* U+4865 */
  0x0002,   /* U+4866 */
  0x0002,   /* U+4867 */
  0x0002,   /* U+4868 */
  0x0002,   /* U+4869 */
  0x0002,   /* U+486A */
  0x0002,   /* U+486B */
  0x0002,   /* U+486C */
  0x0002,   /* U+486D */
  0x0002,   /* U+486E */
  0x0002,   /* U+486F */
  0x0002,   /* U+4870 */
  0x0002,   /* U+4871 */
  0x0002,   /* U+4872 */
  0x0002,   /* U+4873 */
  0x0002,   /* U+4874 */
  0x0002,   /* U+4875 */
  0x0002,   /* U+4876 */
  0x0002,   /* U+4877 */
  0x0002,   /* U+4878 */
  0x0002,   /* U+4879 */
  0x0002,   /* U+487A */
  0x0002,   /* U+487B */
  0x0002,   /* U+487C */
  0x0002,   /* U+487D */
  0x0002,   /* U+487E */
  0x0002,   /* U+487F */
  0x0002,   /* U+4880 */
  0x0002,   /* U+4881 */
  0x0002,   /* U+4882 */
  0x0002,   /* U+4883 */
  0x0002,   /* U+4884 */
  0x0002,   /* U+4885 */
  0x0002,   /* U+4886 */
  0x0002,   /* U+4887 */
  0x0002,   /* U+4888 */
  0x0002,   /* U+4889 */
  0x0002,   /* U+488A */
  0x0002,   /* U+488B */
  0x0002,   /* U+488C */
  0x0002,   /* U+488D */
  0x0002,   /* U+488E */
  0x0002,   /* U+488F */
  0x0002,   /* U+4890 */
  0x0002,   /* U+4891 */
  0x0002,   /* U+4892 */
  0x0002,   /* U+4893 */
  0x0002,   /* U+4894 */
  0x0002,   /* U+4895 */
  0x0002,   /* U+4896 */
  0x0002,   /* U+4897 */
  0x0002,   /* U+4898 */
  0x0002,   /* U+4899 */
  0x0002,   /* U+489A */
  0x0002,   /* U+489B */
  0x0002,   /* U+489C */
  0x0002,   /* U+489D */
  0x0002,   /* U+489E */
  0x0002,   /* U+489F */
  0x0002,   /* U+48A0 */
  0x0002,   /* U+48A1 */
  0x0002,   /* U+48A2 */
  0x0002,   /* U+48A3 */
  0x0002,   /* U+48A4 */
  0x0002,   /* U+48A5 */
  0x0002,   /* U+48A6 */
  0x0002,   /* U+48A7 */
  0x0002,   /* U+48A8 */
  0x0002,   /* U+48A9 */
  0x0002,   /* U+48AA */
  0x0002,   /* U+48AB */
  0x0002,   /* U+48AC */
  0x0002,   /* U+48AD */
  0x0002,   /* U+48AE */
  0x0002,   /* U+48AF */
  0x0002,   /* U+48B0 */
  0x0002,   /* U+48B1 */
  0x0002,   /* U+48B2 */
  0x0002,   /* U+48B3 */
  0x0002,   /* U+48B4 */
  0x0002,   /* U+48B5 */
  0x0002,   /* U+48B6 */
  0x0002,   /* U+48B7 */
  0x0002,   /* U+48B8 */
  0x0002,   /* U+48B9 */
  0x0002,   /* U+48BA */
  0x0002,   /* U+48BB */
  0x0002,   /* U+48BC */
  0x0002,   /* U+48BD */
  0x0002,   /* U+48BE */
  0x0002,   /* U+48BF */
  0x0002,   /* U+48C0 */
  0x0002,   /* U+48C1 */
  0x0002,   /* U+48C2 */
  0x0002,   /* U+48C3 */
  0x0002,   /* U+48C4 */
  0x0002,   /* U+48C5 */
  0x0002,   /* U+48C6 */
  0x0002,   /* U+48C7 */
  0x0002,   /* U+48C8 */
  0x0002,   /* U+48C9 */
  0x0002,   /* U+48CA */
  0x0002,   /* U+48CB */
  0x0002,   /* U+48CC */
  0x0002,   /* U+48CD */
  0x0002,   /* U+48CE */
  0x0002,   /* U+48CF */
  0x0002,   /* U+48D0 */
  0x0002,   /* U+48D1 */
  0x0002,   /* U+48D2 */
  0x0002,   /* U+48D3 */
  0x0002,   /* U+48D4 */
  0x0002,   /* U+48D5 */
  0x0002,   /* U+48D6 */
  0x0002,   /* U+48D7 */
  0x0002,   /* U+48D8 */
  0x0002,   /* U+48D9 */
  0x0002,   /* U+48DA */
  0x0002,   /* U+48DB */
  0x0002,   /* U+48DC */
  0x0002,   /* U+48DD */
  0x0002,   /* U+48DE */
  0x0002,   /* U+48DF */
  0x0002,   /* U+48E0 */
  0x0002,   /* U+48E1 */
  0x0002,   /* U+48E2 */
  0x0002,   /* U+48E3 */
  0x0002,   /* U+48E4 */
  0x0002,   /* U+48E5 */
  0x0002,   /* U+48E6 */
  0x0002,   /* U+48E7 */
  0x0002,   /* U+48E8 */
  0x0002,   /* U+48E9 */
  0x0002,   /* U+48EA */
  0x0002,   /* U+48EB */
  0x0002,   /* U+48EC */
  0x0002,   /* U+48ED */
  0x0002,   /* U+48EE */
  0x0002,   /* U+48EF */
  0x0002,   /* U+48F0 */
  0x0002,   /* U+48F1 */
  0x0002,   /* U+48F2 */
  0x0002,   /* U+48F3 */
  0x0002,   /* U+48F4 */
  0x0002,   /* U+48F5 */
  0x0002,   /* U+48F6 */
  0x0002,   /* U+48F7 */
  0x0002,   /* U+48F8 */
  0x0002,   /* U+48F9 */
  0x0002,   /* U+48FA */
  0x0002,   /* U+48FB */
  0x0002,   /* U+48FC */
  0x0002,   /* U+48FD */
  0x0002,   /* U+48FE */
  0x0002,   /* U+48FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0xC801,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0xC80C,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0xC816,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0xC83A,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0xC844,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0xC860,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0xC86E,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0xC878,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0xC882,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0xC886,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0xC88E,   /* U+488E */
  0xC88F,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0xC898,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0xC89C,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0xC8AC,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0xC8B4,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0xC8B6,   /* U+48B6 */
  0xC8B7,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0xC8C3,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0xC8C9,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0xC8CF,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0xC8D2,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0xC8D7,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0xC8F3,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */
};

uint16_t zh_han_p049[] = {
  /* Number of CEs for each character. */
  2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 2, 
  2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 

  /* Primary weight 1 for each character. */
  0xBDC1,   /* U+4900 */
  0x25E8,   /* U+4901 */
  0x696F,   /* U+4902 */
  0xA966,   /* U+4903 */
  0x6B79,   /* U+4904 */
  0x90DD,   /* U+4905 */
  0x5AA5,   /* U+4906 */
  0xBDC1,   /* U+4907 */
  0xBDC1,   /* U+4908 */
  0x6B25,   /* U+4909 */
  0x7FC9,   /* U+490A */
  0xAE72,   /* U+490B */
  0x79D9,   /* U+490C */
  0x6A9E,   /* U+490D */
  0x5513,   /* U+490E */
  0x749F,   /* U+490F */
  0x52BC,   /* U+4910 */
  0x9395,   /* U+4911 */
  0x4DB9,   /* U+4912 */
  0x6A2F,   /* U+4913 */
  0x4FE4,   /* U+4914 */
  0xA124,   /* U+4915 */
  0x1F8C,   /* U+4916 */
  0x3D52,   /* U+4917 */
  0x275C,   /* U+4918 */
  0x6043,   /* U+4919 */
  0x5EE6,   /* U+491A */
  0x7C86,   /* U+491B */
  0x364D,   /* U+491C */
  0xAB09,   /* U+491D */
  0xB056,   /* U+491E */
  0x28B7,   /* U+491F */
  0xB6F7,   /* U+4920 */
  0x7EC9,   /* U+4921 */
  0xBDC1,   /* U+4922 */
  0x66B2,   /* U+4923 */
  0x5774,   /* U+4924 */
  0x41DD,   /* U+4925 */
  0xAFCD,   /* U+4926 */
  0x4A5B,   /* U+4927 */
  0x74B8,   /* U+4928 */
  0x2647,   /* U+4929 */
  0x36A9,   /* U+492A */
  0x26DD,   /* U+492B */
  0x826C,   /* U+492C */
  0x8655,   /* U+492D */
  0x8420,   /* U+492E */
  0x9E5D,   /* U+492F */
  0xAAB1,   /* U+4930 */
  0x8656,   /* U+4931 */
  0x2A84,   /* U+4932 */
  0xA609,   /* U+4933 */
  0x436E,   /* U+4934 */
  0x39BE,   /* U+4935 */
  0xA60A,   /* U+4936 */
  0xA352,   /* U+4937 */
  0xBD13,   /* U+4938 */
  0x895F,   /* U+4939 */
  0x528C,   /* U+493A */
  0x36E2,   /* U+493B */
  0x9AF7,   /* U+493C */
  0x40E9,   /* U+493D */
  0x8D5F,   /* U+493E */
  0x7AE4,   /* U+493F */
  0x2747,   /* U+4940 */
  0x4375,   /* U+4941 */
  0x6A63,   /* U+4942 */
  0xAFE0,   /* U+4943 */
  0x2E86,   /* U+4944 */
  0x79A8,   /* U+4945 */
  0x52BB,   /* U+4946 */
  0x8352,   /* U+4947 */
  0x6D88,   /* U+4948 */
  0xAEF0,   /* U+4949 */
  0xBDC1,   /* U+494A */
  0x73A2,   /* U+494B */
  0xB618,   /* U+494C */
  0xB807,   /* U+494D */
  0x2D07,   /* U+494E */
  0xADB7,   /* U+494F */
  0x6D57,   /* U+4950 */
  0x933F,   /* U+4951 */
  0x505A,   /* U+4952 */
  0x7709,   /* U+4953 */
  0x8A19,   /* U+4954 */
  0x754E,   /* U+4955 */
  0x8ECB,   /* U+4956 */
  0x5A12,   /* U+4957 */
  0x2E8B,   /* U+4958 */
  0x8AC0,   /* U+4959 */
  0xBDC1,   /* U+495A */
  0x5173,   /* U+495B */
  0x4FDE,   /* U+495C */
  0x1D8C,   /* U+495D */
  0x5108,   /* U+495E */
  0xA62C,   /* U+495F */
  0xBDC1,   /* U+4960 */
  0xA62D,   /* U+4961 */
  0x644F,   /* U+4962 */
  0xB17B,   /* U+4963 */
  0x1F38,   /* U+4964 */
  0x60A4,   /* U+4965 */
  0xBDC1,   /* U+4966 */
  0x48B9,   /* U+4967 */
  0x666B,   /* U+4968 */
  0x9422,   /* U+4969 */
  0x9A92,   /* U+496A */
  0x8F66,   /* U+496B */
  0x2430,   /* U+496C */
  0xB61C,   /* U+496D */
  0xB97D,   /* U+496E */
  0x1FA8,   /* U+496F */
  0x6A37,   /* U+4970 */
  0x9D0A,   /* U+4971 */
  0x7213,   /* U+4972 */
  0xABCC,   /* U+4973 */
  0xBDC1,   /* U+4974 */
  0x9C45,   /* U+4975 */
  0x6032,   /* U+4976 */
  0xB298,   /* U+4977 */
  0x6AC0,   /* U+4978 */
  0xBDC1,   /* U+4979 */
  0xA5A4,   /* U+497A */
  0xBDC1,   /* U+497B */
  0xBDC1,   /* U+497C */
  0x75E7,   /* U+497D */
  0x9D02,   /* U+497E */
  0xBDC1,   /* U+497F */
  0xBDC1,   /* U+4980 */
  0xBDC1,   /* U+4981 */
  0x8353,   /* U+4982 */
  0xBAE9,   /* U+4983 */
  0xBDC1,   /* U+4984 */
  0x8358,   /* U+4985 */
  0x56F6,   /* U+4986 */
  0x4D56,   /* U+4987 */
  0x5164,   /* U+4988 */
  0xBDC1,   /* U+4989 */
  0x702D,   /* U+498A */
  0x1D8A,   /* U+498B */
  0x2BF1,   /* U+498C */
  0x96D9,   /* U+498D */
  0x40FC,   /* U+498E */
  0x9D3E,   /* U+498F */
  0x8FC9,   /* U+4990 */
  0xA115,   /* U+4991 */
  0x310F,   /* U+4992 */
  0xB326,   /* U+4993 */
  0x8C95,   /* U+4994 */
  0x739B,   /* U+4995 */
  0x9CCB,   /* U+4996 */
  0x9FF2,   /* U+4997 */
  0x9ADF,   /* U+4998 */
  0x88D6,   /* U+4999 */
  0x59CC,   /* U+499A */
  0xB60E,   /* U+499B */
  0x9656,   /* U+499C */
  0x4B03,   /* U+499D */
  0x80E6,   /* U+499E */
  0x955D,   /* U+499F */
  0x3513,   /* U+49A0 */
  0x48A6,   /* U+49A1 */
  0x5B5F,   /* U+49A2 */
  0x3C87,   /* U+49A3 */
  0x2C39,   /* U+49A4 */
  0x9A38,   /* U+49A5 */
  0x7B3C,   /* U+49A6 */
  0x7AAA,   /* U+49A7 */
  0x5C32,   /* U+49A8 */
  0xBDC1,   /* U+49A9 */
  0xA243,   /* U+49AA */
  0xAA66,   /* U+49AB */
  0x7E6A,   /* U+49AC */
  0x43FB,   /* U+49AD */
  0x2D18,   /* U+49AE */
  0xB7F1,   /* U+49AF */
  0xBDC1,   /* U+49B0 */
  0x9491,   /* U+49B1 */
  0xA2E4,   /* U+49B2 */
  0x9B99,   /* U+49B3 */
  0xA913,   /* U+49B4 */
  0x6F92,   /* U+49B5 */
  0xB60F,   /* U+49B6 */
  0x2C36,   /* U+49B7 */
  0xBDC1,   /* U+49B8 */
  0x8580,   /* U+49B9 */
  0x33FD,   /* U+49BA */
  0xBBD0,   /* U+49BB */
  0x5649,   /* U+49BC */
  0x9F9B,   /* U+49BD */
  0xAF0E,   /* U+49BE */
  0xBDC1,   /* U+49BF */
  0xBDC1,   /* U+49C0 */
  0x9F78,   /* U+49C1 */
  0x3157,   /* U+49C2 */
  0x8EA3,   /* U+49C3 */
  0x3E97,   /* U+49C4 */
  0xA6C3,   /* U+49C5 */
  0x45E6,   /* U+49C6 */
  0xA653,   /* U+49C7 */
  0xBDC1,   /* U+49C8 */
  0x5EE4,   /* U+49C9 */
  0x5970,   /* U+49CA */
  0x9A6A,   /* U+49CB */
  0x8A45,   /* U+49CC */
  0x98AA,   /* U+49CD */
  0xA0A4,   /* U+49CE */
  0xBDC1,   /* U+49CF */
  0xBDC1,   /* U+49D0 */
  0x31EC,   /* U+49D1 */
  0x5BD7,   /* U+49D2 */
  0xB89E,   /* U+49D3 */
  0x7010,   /* U+49D4 */
  0x294A,   /* U+49D5 */
  0x4F95,   /* U+49D6 */
  0x2128,   /* U+49D7 */
  0xBA42,   /* U+49D8 */
  0x62E2,   /* U+49D9 */
  0x4477,   /* U+49DA */
  0x1F08,   /* U+49DB */
  0x8CE8,   /* U+49DC */
  0x29B1,   /* U+49DD */
  0x67BE,   /* U+49DE */
  0x9AD8,   /* U+49DF */
  0x87B2,   /* U+49E0 */
  0xAB30,   /* U+49E1 */
  0x7CFA,   /* U+49E2 */
  0xBDC1,   /* U+49E3 */
  0x7685,   /* U+49E4 */
  0x4A67,   /* U+49E5 */
  0x9401,   /* U+49E6 */
  0xA776,   /* U+49E7 */
  0xA60B,   /* U+49E8 */
  0xBDC1,   /* U+49E9 */
  0x2871,   /* U+49EA */
  0x444D,   /* U+49EB */
  0x22F6,   /* U+49EC */
  0xBDC1,   /* U+49ED */
  0x9B01,   /* U+49EE */
  0x26FC,   /* U+49EF */
  0x4AFC,   /* U+49F0 */
  0xBDC1,   /* U+49F1 */
  0x43AF,   /* U+49F2 */
  0x2D70,   /* U+49F3 */
  0xB656,   /* U+49F4 */
  0x775B,   /* U+49F5 */
  0x5A95,   /* U+49F6 */
  0x800F,   /* U+49F7 */
  0xBDC1,   /* U+49F8 */
  0xAA4A,   /* U+49F9 */
  0x9E9E,   /* U+49FA */
  0xBDC1,   /* U+49FB */
  0x4726,   /* U+49FC */
  0x2ED1,   /* U+49FD */
  0xBDC1,   /* U+49FE */
  0x7E63,   /* U+49FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4900 */
  0x0020,   /* U+4901 */
  0x0020,   /* U+4902 */
  0x0020,   /* U+4903 */
  0x0020,   /* U+4904 */
  0x0020,   /* U+4905 */
  0x0020,   /* U+4906 */
  0x0020,   /* U+4907 */
  0x0020,   /* U+4908 */
  0x0020,   /* U+4909 */
  0x0020,   /* U+490A */
  0x0020,   /* U+490B */
  0x0020,   /* U+490C */
  0x0020,   /* U+490D */
  0x0020,   /* U+490E */
  0x0020,   /* U+490F */
  0x0020,   /* U+4910 */
  0x0020,   /* U+4911 */
  0x0020,   /* U+4912 */
  0x0020,   /* U+4913 */
  0x0020,   /* U+4914 */
  0x0020,   /* U+4915 */
  0x0020,   /* U+4916 */
  0x0020,   /* U+4917 */
  0x0020,   /* U+4918 */
  0x0020,   /* U+4919 */
  0x0020,   /* U+491A */
  0x0020,   /* U+491B */
  0x0020,   /* U+491C */
  0x0020,   /* U+491D */
  0x0020,   /* U+491E */
  0x0020,   /* U+491F */
  0x0020,   /* U+4920 */
  0x0020,   /* U+4921 */
  0x0020,   /* U+4922 */
  0x0020,   /* U+4923 */
  0x0020,   /* U+4924 */
  0x0020,   /* U+4925 */
  0x0020,   /* U+4926 */
  0x0020,   /* U+4927 */
  0x0020,   /* U+4928 */
  0x0020,   /* U+4929 */
  0x0020,   /* U+492A */
  0x0020,   /* U+492B */
  0x0020,   /* U+492C */
  0x0020,   /* U+492D */
  0x0020,   /* U+492E */
  0x0020,   /* U+492F */
  0x0020,   /* U+4930 */
  0x0020,   /* U+4931 */
  0x0020,   /* U+4932 */
  0x0020,   /* U+4933 */
  0x0020,   /* U+4934 */
  0x0020,   /* U+4935 */
  0x0020,   /* U+4936 */
  0x0020,   /* U+4937 */
  0x0020,   /* U+4938 */
  0x0020,   /* U+4939 */
  0x0020,   /* U+493A */
  0x0020,   /* U+493B */
  0x0020,   /* U+493C */
  0x0020,   /* U+493D */
  0x0020,   /* U+493E */
  0x0020,   /* U+493F */
  0x0020,   /* U+4940 */
  0x0020,   /* U+4941 */
  0x0020,   /* U+4942 */
  0x0020,   /* U+4943 */
  0x0020,   /* U+4944 */
  0x0020,   /* U+4945 */
  0x0020,   /* U+4946 */
  0x0020,   /* U+4947 */
  0x0020,   /* U+4948 */
  0x0020,   /* U+4949 */
  0x0020,   /* U+494A */
  0x0020,   /* U+494B */
  0x0020,   /* U+494C */
  0x0020,   /* U+494D */
  0x0020,   /* U+494E */
  0x0020,   /* U+494F */
  0x0020,   /* U+4950 */
  0x0020,   /* U+4951 */
  0x0020,   /* U+4952 */
  0x0020,   /* U+4953 */
  0x0020,   /* U+4954 */
  0x0020,   /* U+4955 */
  0x0020,   /* U+4956 */
  0x0020,   /* U+4957 */
  0x0020,   /* U+4958 */
  0x0020,   /* U+4959 */
  0x0020,   /* U+495A */
  0x0020,   /* U+495B */
  0x0020,   /* U+495C */
  0x0020,   /* U+495D */
  0x0020,   /* U+495E */
  0x0020,   /* U+495F */
  0x0020,   /* U+4960 */
  0x0020,   /* U+4961 */
  0x0020,   /* U+4962 */
  0x0020,   /* U+4963 */
  0x0020,   /* U+4964 */
  0x0020,   /* U+4965 */
  0x0020,   /* U+4966 */
  0x0020,   /* U+4967 */
  0x0020,   /* U+4968 */
  0x0020,   /* U+4969 */
  0x0020,   /* U+496A */
  0x0020,   /* U+496B */
  0x0020,   /* U+496C */
  0x0020,   /* U+496D */
  0x0020,   /* U+496E */
  0x0020,   /* U+496F */
  0x0020,   /* U+4970 */
  0x0020,   /* U+4971 */
  0x0020,   /* U+4972 */
  0x0020,   /* U+4973 */
  0x0020,   /* U+4974 */
  0x0020,   /* U+4975 */
  0x0020,   /* U+4976 */
  0x0020,   /* U+4977 */
  0x0020,   /* U+4978 */
  0x0020,   /* U+4979 */
  0x0020,   /* U+497A */
  0x0020,   /* U+497B */
  0x0020,   /* U+497C */
  0x0020,   /* U+497D */
  0x0020,   /* U+497E */
  0x0020,   /* U+497F */
  0x0020,   /* U+4980 */
  0x0020,   /* U+4981 */
  0x0020,   /* U+4982 */
  0x0020,   /* U+4983 */
  0x0020,   /* U+4984 */
  0x0020,   /* U+4985 */
  0x0020,   /* U+4986 */
  0x0020,   /* U+4987 */
  0x0020,   /* U+4988 */
  0x0020,   /* U+4989 */
  0x0020,   /* U+498A */
  0x0020,   /* U+498B */
  0x0020,   /* U+498C */
  0x0020,   /* U+498D */
  0x0020,   /* U+498E */
  0x0020,   /* U+498F */
  0x0020,   /* U+4990 */
  0x0020,   /* U+4991 */
  0x0020,   /* U+4992 */
  0x0020,   /* U+4993 */
  0x0020,   /* U+4994 */
  0x0020,   /* U+4995 */
  0x0020,   /* U+4996 */
  0x0020,   /* U+4997 */
  0x0020,   /* U+4998 */
  0x0020,   /* U+4999 */
  0x0020,   /* U+499A */
  0x0020,   /* U+499B */
  0x0020,   /* U+499C */
  0x0020,   /* U+499D */
  0x0020,   /* U+499E */
  0x0020,   /* U+499F */
  0x0020,   /* U+49A0 */
  0x0020,   /* U+49A1 */
  0x0020,   /* U+49A2 */
  0x0020,   /* U+49A3 */
  0x0020,   /* U+49A4 */
  0x0020,   /* U+49A5 */
  0x0020,   /* U+49A6 */
  0x0020,   /* U+49A7 */
  0x0020,   /* U+49A8 */
  0x0020,   /* U+49A9 */
  0x0020,   /* U+49AA */
  0x0020,   /* U+49AB */
  0x0020,   /* U+49AC */
  0x0020,   /* U+49AD */
  0x0020,   /* U+49AE */
  0x0020,   /* U+49AF */
  0x0020,   /* U+49B0 */
  0x0020,   /* U+49B1 */
  0x0020,   /* U+49B2 */
  0x0020,   /* U+49B3 */
  0x0020,   /* U+49B4 */
  0x0020,   /* U+49B5 */
  0x0020,   /* U+49B6 */
  0x0020,   /* U+49B7 */
  0x0020,   /* U+49B8 */
  0x0020,   /* U+49B9 */
  0x0020,   /* U+49BA */
  0x0020,   /* U+49BB */
  0x0020,   /* U+49BC */
  0x0020,   /* U+49BD */
  0x0020,   /* U+49BE */
  0x0020,   /* U+49BF */
  0x0020,   /* U+49C0 */
  0x0020,   /* U+49C1 */
  0x0020,   /* U+49C2 */
  0x0020,   /* U+49C3 */
  0x0020,   /* U+49C4 */
  0x0020,   /* U+49C5 */
  0x0020,   /* U+49C6 */
  0x0020,   /* U+49C7 */
  0x0020,   /* U+49C8 */
  0x0020,   /* U+49C9 */
  0x0020,   /* U+49CA */
  0x0020,   /* U+49CB */
  0x0020,   /* U+49CC */
  0x0020,   /* U+49CD */
  0x0020,   /* U+49CE */
  0x0020,   /* U+49CF */
  0x0020,   /* U+49D0 */
  0x0020,   /* U+49D1 */
  0x0020,   /* U+49D2 */
  0x0020,   /* U+49D3 */
  0x0020,   /* U+49D4 */
  0x0020,   /* U+49D5 */
  0x0020,   /* U+49D6 */
  0x0020,   /* U+49D7 */
  0x0020,   /* U+49D8 */
  0x0020,   /* U+49D9 */
  0x0020,   /* U+49DA */
  0x0020,   /* U+49DB */
  0x0020,   /* U+49DC */
  0x0020,   /* U+49DD */
  0x0020,   /* U+49DE */
  0x0020,   /* U+49DF */
  0x0020,   /* U+49E0 */
  0x0020,   /* U+49E1 */
  0x0020,   /* U+49E2 */
  0x0020,   /* U+49E3 */
  0x0020,   /* U+49E4 */
  0x0020,   /* U+49E5 */
  0x0020,   /* U+49E6 */
  0x0020,   /* U+49E7 */
  0x0020,   /* U+49E8 */
  0x0020,   /* U+49E9 */
  0x0020,   /* U+49EA */
  0x0020,   /* U+49EB */
  0x0020,   /* U+49EC */
  0x0020,   /* U+49ED */
  0x0020,   /* U+49EE */
  0x0020,   /* U+49EF */
  0x0020,   /* U+49F0 */
  0x0020,   /* U+49F1 */
  0x0020,   /* U+49F2 */
  0x0020,   /* U+49F3 */
  0x0020,   /* U+49F4 */
  0x0020,   /* U+49F5 */
  0x0020,   /* U+49F6 */
  0x0020,   /* U+49F7 */
  0x0020,   /* U+49F8 */
  0x0020,   /* U+49F9 */
  0x0020,   /* U+49FA */
  0x0020,   /* U+49FB */
  0x0020,   /* U+49FC */
  0x0020,   /* U+49FD */
  0x0020,   /* U+49FE */
  0x0020,   /* U+49FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4900 */
  0x0002,   /* U+4901 */
  0x0002,   /* U+4902 */
  0x0002,   /* U+4903 */
  0x0002,   /* U+4904 */
  0x0002,   /* U+4905 */
  0x0002,   /* U+4906 */
  0x0002,   /* U+4907 */
  0x0002,   /* U+4908 */
  0x0002,   /* U+4909 */
  0x0002,   /* U+490A */
  0x0002,   /* U+490B */
  0x0002,   /* U+490C */
  0x0002,   /* U+490D */
  0x0002,   /* U+490E */
  0x0002,   /* U+490F */
  0x0002,   /* U+4910 */
  0x0002,   /* U+4911 */
  0x0002,   /* U+4912 */
  0x0002,   /* U+4913 */
  0x0002,   /* U+4914 */
  0x0002,   /* U+4915 */
  0x0002,   /* U+4916 */
  0x0002,   /* U+4917 */
  0x0002,   /* U+4918 */
  0x0002,   /* U+4919 */
  0x0002,   /* U+491A */
  0x0002,   /* U+491B */
  0x0002,   /* U+491C */
  0x0002,   /* U+491D */
  0x0002,   /* U+491E */
  0x0002,   /* U+491F */
  0x0002,   /* U+4920 */
  0x0002,   /* U+4921 */
  0x0002,   /* U+4922 */
  0x0002,   /* U+4923 */
  0x0002,   /* U+4924 */
  0x0002,   /* U+4925 */
  0x0002,   /* U+4926 */
  0x0002,   /* U+4927 */
  0x0002,   /* U+4928 */
  0x0002,   /* U+4929 */
  0x0002,   /* U+492A */
  0x0002,   /* U+492B */
  0x0002,   /* U+492C */
  0x0002,   /* U+492D */
  0x0002,   /* U+492E */
  0x0002,   /* U+492F */
  0x0002,   /* U+4930 */
  0x0002,   /* U+4931 */
  0x0002,   /* U+4932 */
  0x0002,   /* U+4933 */
  0x0002,   /* U+4934 */
  0x0002,   /* U+4935 */
  0x0002,   /* U+4936 */
  0x0002,   /* U+4937 */
  0x0002,   /* U+4938 */
  0x0002,   /* U+4939 */
  0x0002,   /* U+493A */
  0x0002,   /* U+493B */
  0x0002,   /* U+493C */
  0x0002,   /* U+493D */
  0x0002,   /* U+493E */
  0x0002,   /* U+493F */
  0x0002,   /* U+4940 */
  0x0002,   /* U+4941 */
  0x0002,   /* U+4942 */
  0x0002,   /* U+4943 */
  0x0002,   /* U+4944 */
  0x0002,   /* U+4945 */
  0x0002,   /* U+4946 */
  0x0002,   /* U+4947 */
  0x0002,   /* U+4948 */
  0x0002,   /* U+4949 */
  0x0002,   /* U+494A */
  0x0002,   /* U+494B */
  0x0002,   /* U+494C */
  0x0002,   /* U+494D */
  0x0002,   /* U+494E */
  0x0002,   /* U+494F */
  0x0002,   /* U+4950 */
  0x0002,   /* U+4951 */
  0x0002,   /* U+4952 */
  0x0002,   /* U+4953 */
  0x0002,   /* U+4954 */
  0x0002,   /* U+4955 */
  0x0002,   /* U+4956 */
  0x0002,   /* U+4957 */
  0x0002,   /* U+4958 */
  0x0002,   /* U+4959 */
  0x0002,   /* U+495A */
  0x0002,   /* U+495B */
  0x0002,   /* U+495C */
  0x0002,   /* U+495D */
  0x0002,   /* U+495E */
  0x0002,   /* U+495F */
  0x0002,   /* U+4960 */
  0x0002,   /* U+4961 */
  0x0002,   /* U+4962 */
  0x0002,   /* U+4963 */
  0x0002,   /* U+4964 */
  0x0002,   /* U+4965 */
  0x0002,   /* U+4966 */
  0x0002,   /* U+4967 */
  0x0002,   /* U+4968 */
  0x0002,   /* U+4969 */
  0x0002,   /* U+496A */
  0x0002,   /* U+496B */
  0x0002,   /* U+496C */
  0x0002,   /* U+496D */
  0x0002,   /* U+496E */
  0x0002,   /* U+496F */
  0x0002,   /* U+4970 */
  0x0002,   /* U+4971 */
  0x0002,   /* U+4972 */
  0x0002,   /* U+4973 */
  0x0002,   /* U+4974 */
  0x0002,   /* U+4975 */
  0x0002,   /* U+4976 */
  0x0002,   /* U+4977 */
  0x0002,   /* U+4978 */
  0x0002,   /* U+4979 */
  0x0002,   /* U+497A */
  0x0002,   /* U+497B */
  0x0002,   /* U+497C */
  0x0002,   /* U+497D */
  0x0002,   /* U+497E */
  0x0002,   /* U+497F */
  0x0002,   /* U+4980 */
  0x0002,   /* U+4981 */
  0x0002,   /* U+4982 */
  0x0002,   /* U+4983 */
  0x0002,   /* U+4984 */
  0x0002,   /* U+4985 */
  0x0002,   /* U+4986 */
  0x0002,   /* U+4987 */
  0x0002,   /* U+4988 */
  0x0002,   /* U+4989 */
  0x0002,   /* U+498A */
  0x0002,   /* U+498B */
  0x0002,   /* U+498C */
  0x0002,   /* U+498D */
  0x0002,   /* U+498E */
  0x0002,   /* U+498F */
  0x0002,   /* U+4990 */
  0x0002,   /* U+4991 */
  0x0002,   /* U+4992 */
  0x0002,   /* U+4993 */
  0x0002,   /* U+4994 */
  0x0002,   /* U+4995 */
  0x0002,   /* U+4996 */
  0x0002,   /* U+4997 */
  0x0002,   /* U+4998 */
  0x0002,   /* U+4999 */
  0x0002,   /* U+499A */
  0x0002,   /* U+499B */
  0x0002,   /* U+499C */
  0x0002,   /* U+499D */
  0x0002,   /* U+499E */
  0x0002,   /* U+499F */
  0x0002,   /* U+49A0 */
  0x0002,   /* U+49A1 */
  0x0002,   /* U+49A2 */
  0x0002,   /* U+49A3 */
  0x0002,   /* U+49A4 */
  0x0002,   /* U+49A5 */
  0x0002,   /* U+49A6 */
  0x0002,   /* U+49A7 */
  0x0002,   /* U+49A8 */
  0x0002,   /* U+49A9 */
  0x0002,   /* U+49AA */
  0x0002,   /* U+49AB */
  0x0002,   /* U+49AC */
  0x0002,   /* U+49AD */
  0x0002,   /* U+49AE */
  0x0002,   /* U+49AF */
  0x0002,   /* U+49B0 */
  0x0002,   /* U+49B1 */
  0x0002,   /* U+49B2 */
  0x0002,   /* U+49B3 */
  0x0002,   /* U+49B4 */
  0x0002,   /* U+49B5 */
  0x0002,   /* U+49B6 */
  0x0002,   /* U+49B7 */
  0x0002,   /* U+49B8 */
  0x0002,   /* U+49B9 */
  0x0002,   /* U+49BA */
  0x0002,   /* U+49BB */
  0x0002,   /* U+49BC */
  0x0002,   /* U+49BD */
  0x0002,   /* U+49BE */
  0x0002,   /* U+49BF */
  0x0002,   /* U+49C0 */
  0x0002,   /* U+49C1 */
  0x0002,   /* U+49C2 */
  0x0002,   /* U+49C3 */
  0x0002,   /* U+49C4 */
  0x0002,   /* U+49C5 */
  0x0002,   /* U+49C6 */
  0x0002,   /* U+49C7 */
  0x0002,   /* U+49C8 */
  0x0002,   /* U+49C9 */
  0x0002,   /* U+49CA */
  0x0002,   /* U+49CB */
  0x0002,   /* U+49CC */
  0x0002,   /* U+49CD */
  0x0002,   /* U+49CE */
  0x0002,   /* U+49CF */
  0x0002,   /* U+49D0 */
  0x0002,   /* U+49D1 */
  0x0002,   /* U+49D2 */
  0x0002,   /* U+49D3 */
  0x0002,   /* U+49D4 */
  0x0002,   /* U+49D5 */
  0x0002,   /* U+49D6 */
  0x0002,   /* U+49D7 */
  0x0002,   /* U+49D8 */
  0x0002,   /* U+49D9 */
  0x0002,   /* U+49DA */
  0x0002,   /* U+49DB */
  0x0002,   /* U+49DC */
  0x0002,   /* U+49DD */
  0x0002,   /* U+49DE */
  0x0002,   /* U+49DF */
  0x0002,   /* U+49E0 */
  0x0002,   /* U+49E1 */
  0x0002,   /* U+49E2 */
  0x0002,   /* U+49E3 */
  0x0002,   /* U+49E4 */
  0x0002,   /* U+49E5 */
  0x0002,   /* U+49E6 */
  0x0002,   /* U+49E7 */
  0x0002,   /* U+49E8 */
  0x0002,   /* U+49E9 */
  0x0002,   /* U+49EA */
  0x0002,   /* U+49EB */
  0x0002,   /* U+49EC */
  0x0002,   /* U+49ED */
  0x0002,   /* U+49EE */
  0x0002,   /* U+49EF */
  0x0002,   /* U+49F0 */
  0x0002,   /* U+49F1 */
  0x0002,   /* U+49F2 */
  0x0002,   /* U+49F3 */
  0x0002,   /* U+49F4 */
  0x0002,   /* U+49F5 */
  0x0002,   /* U+49F6 */
  0x0002,   /* U+49F7 */
  0x0002,   /* U+49F8 */
  0x0002,   /* U+49F9 */
  0x0002,   /* U+49FA */
  0x0002,   /* U+49FB */
  0x0002,   /* U+49FC */
  0x0002,   /* U+49FD */
  0x0002,   /* U+49FE */
  0x0002,   /* U+49FF */

  /* Primary weight 2 for each character. */
  0xC900,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0xC907,   /* U+4907 */
  0xC908,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0xC922,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0xC94A,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0xC95A,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0xC960,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0xC966,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0xC974,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0xC979,   /* U+4979 */
  0x0000,   /* U+497A */
  0xC97B,   /* U+497B */
  0xC97C,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0xC97F,   /* U+497F */
  0xC980,   /* U+4980 */
  0xC981,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0xC984,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0xC989,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0xC9A9,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0xC9B0,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0xC9B8,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0xC9BF,   /* U+49BF */
  0xC9C0,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0xC9C8,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0xC9CF,   /* U+49CF */
  0xC9D0,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0xC9E3,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0xC9E9,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0xC9ED,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0xC9F1,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0xC9F8,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0xC9FB,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0xC9FE,   /* U+49FE */
  0x0000,   /* U+49FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */
};

uint16_t zh_han_p04A[] = {
  /* Number of CEs for each character. */
  1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 

  /* Primary weight 1 for each character. */
  0x3220,   /* U+4A00 */
  0x96FE,   /* U+4A01 */
  0x7C4C,   /* U+4A02 */
  0xBDC1,   /* U+4A03 */
  0xA3DA,   /* U+4A04 */
  0x617F,   /* U+4A05 */
  0x209B,   /* U+4A06 */
  0xBDC1,   /* U+4A07 */
  0x2302,   /* U+4A08 */
  0xBDC1,   /* U+4A09 */
  0xAEF7,   /* U+4A0A */
  0x71B1,   /* U+4A0B */
  0x1F2C,   /* U+4A0C */
  0xAAE3,   /* U+4A0D */
  0x4609,   /* U+4A0E */
  0x2D7B,   /* U+4A0F */
  0x789C,   /* U+4A10 */
  0x8E0F,   /* U+4A11 */
  0xAE3C,   /* U+4A12 */
  0x5D7D,   /* U+4A13 */
  0x1F31,   /* U+4A14 */
  0xBDC1,   /* U+4A15 */
  0x4D84,   /* U+4A16 */
  0x3BC7,   /* U+4A17 */
  0x9AE8,   /* U+4A18 */
  0x25E7,   /* U+4A19 */
  0x46D8,   /* U+4A1A */
  0x8219,   /* U+4A1B */
  0x204D,   /* U+4A1C */
  0x7B8F,   /* U+4A1D */
  0xADB2,   /* U+4A1E */
  0x925F,   /* U+4A1F */
  0x1C83,   /* U+4A20 */
  0x4371,   /* U+4A21 */
  0x30BD,   /* U+4A22 */
  0x3E78,   /* U+4A23 */
  0x3225,   /* U+4A24 */
  0x4B65,   /* U+4A25 */
  0x72D0,   /* U+4A26 */
  0xBDC1,   /* U+4A27 */
  0xBA94,   /* U+4A28 */
  0x6317,   /* U+4A29 */
  0x67DC,   /* U+4A2A */
  0x67FD,   /* U+4A2B */
  0x609C,   /* U+4A2C */
  0x9C02,   /* U+4A2D */
  0xA0FD,   /* U+4A2E */
  0xB59E,   /* U+4A2F */
  0x763A,   /* U+4A30 */
  0x3CA1,   /* U+4A31 */
  0x7164,   /* U+4A32 */
  0x9907,   /* U+4A33 */
  0x361D,   /* U+4A34 */
  0x30CD,   /* U+4A35 */
  0xB067,   /* U+4A36 */
  0x9B0F,   /* U+4A37 */
  0xA9FB,   /* U+4A38 */
  0x86FC,   /* U+4A39 */
  0x3620,   /* U+4A3A */
  0x207A,   /* U+4A3B */
  0x47CD,   /* U+4A3C */
  0x397E,   /* U+4A3D */
  0x39A8,   /* U+4A3E */
  0xB0C2,   /* U+4A3F */
  0x1FF3,   /* U+4A40 */
  0x3967,   /* U+4A41 */
  0x99BF,   /* U+4A42 */
  0x8647,   /* U+4A43 */
  0x6B71,   /* U+4A44 */
  0xB365,   /* U+4A45 */
  0xB366,   /* U+4A46 */
  0xB328,   /* U+4A47 */
  0x4A7C,   /* U+4A48 */
  0x3C1B,   /* U+4A49 */
  0x9313,   /* U+4A4A */
  0x6CB9,   /* U+4A4B */
  0x7A6E,   /* U+4A4C */
  0x619C,   /* U+4A4D */
  0xBDC1,   /* U+4A4E */
  0x6BE9,   /* U+4A4F */
  0x46C1,   /* U+4A50 */
  0x4602,   /* U+4A51 */
  0xACFE,   /* U+4A52 */
  0x7767,   /* U+4A53 */
  0x36D6,   /* U+4A54 */
  0x1D47,   /* U+4A55 */
  0xBDC1,   /* U+4A56 */
  0x1E2B,   /* U+4A57 */
  0x3292,   /* U+4A58 */
  0xA0B6,   /* U+4A59 */
  0x329B,   /* U+4A5A */
  0x2152,   /* U+4A5B */
  0xB900,   /* U+4A5C */
  0x7310,   /* U+4A5D */
  0x8F5C,   /* U+4A5E */
  0xA711,   /* U+4A5F */
  0xBDC1,   /* U+4A60 */
  0x4E48,   /* U+4A61 */
  0xB7DA,   /* U+4A62 */
  0x90DE,   /* U+4A63 */
  0x9CDD,   /* U+4A64 */
  0x30B2,   /* U+4A65 */
  0x8F34,   /* U+4A66 */
  0x9D75,   /* U+4A67 */
  0x27E2,   /* U+4A68 */
  0xAF5C,   /* U+4A69 */
  0x4107,   /* U+4A6A */
  0x6127,   /* U+4A6B */
  0x2061,   /* U+4A6C */
  0xBDC1,   /* U+4A6D */
  0x65DA,   /* U+4A6E */
  0x4CCA,   /* U+4A6F */
  0xA0C2,   /* U+4A70 */
  0x877F,   /* U+4A71 */
  0x3517,   /* U+4A72 */
  0x8962,   /* U+4A73 */
  0x4747,   /* U+4A74 */
  0xB094,   /* U+4A75 */
  0x2751,   /* U+4A76 */
  0x1EEB,   /* U+4A77 */
  0x7FD1,   /* U+4A78 */
  0x371F,   /* U+4A79 */
  0x9584,   /* U+4A7A */
  0x1E34,   /* U+4A7B */
  0x3AB6,   /* U+4A7C */
  0xACAF,   /* U+4A7D */
  0xB4E7,   /* U+4A7E */
  0x3A2B,   /* U+4A7F */
  0x4108,   /* U+4A80 */
  0x2472,   /* U+4A81 */
  0x3E87,   /* U+4A82 */
  0x3638,   /* U+4A83 */
  0x496D,   /* U+4A84 */
  0x3552,   /* U+4A85 */
  0x8E49,   /* U+4A86 */
  0x2432,   /* U+4A87 */
  0x79AB,   /* U+4A88 */
  0x621D,   /* U+4A89 */
  0x6463,   /* U+4A8A */
  0x9503,   /* U+4A8B */
  0xB3B7,   /* U+4A8C */
  0x5C62,   /* U+4A8D */
  0x8A5B,   /* U+4A8E */
  0x6E0D,   /* U+4A8F */
  0x2153,   /* U+4A90 */
  0x9203,   /* U+4A91 */
  0xB9ED,   /* U+4A92 */
  0x3386,   /* U+4A93 */
  0x246F,   /* U+4A94 */
  0x5507,   /* U+4A95 */
  0x7636,   /* U+4A96 */
  0x996A,   /* U+4A97 */
  0x948A,   /* U+4A98 */
  0x7638,   /* U+4A99 */
  0x2F87,   /* U+4A9A */
  0x3889,   /* U+4A9B */
  0x26BE,   /* U+4A9C */
  0x47D2,   /* U+4A9D */
  0xB0C3,   /* U+4A9E */
  0xBDC1,   /* U+4A9F */
  0xBDC1,   /* U+4AA0 */
  0xBDC1,   /* U+4AA1 */
  0xBDC1,   /* U+4AA2 */
  0xBDC1,   /* U+4AA3 */
  0x38C9,   /* U+4AA4 */
  0x9DA7,   /* U+4AA5 */
  0x4603,   /* U+4AA6 */
  0x29E9,   /* U+4AA7 */
  0x1F2D,   /* U+4AA8 */
  0xA9A0,   /* U+4AA9 */
  0xBDC1,   /* U+4AAA */
  0x5341,   /* U+4AAB */
  0x2400,   /* U+4AAC */
  0x80A7,   /* U+4AAD */
  0x2B6F,   /* U+4AAE */
  0xAA6E,   /* U+4AAF */
  0xA684,   /* U+4AB0 */
  0x3CDE,   /* U+4AB1 */
  0x5B0D,   /* U+4AB2 */
  0xB058,   /* U+4AB3 */
  0xB556,   /* U+4AB4 */
  0xA20C,   /* U+4AB5 */
  0x54B0,   /* U+4AB6 */
  0x4692,   /* U+4AB7 */
  0x6C15,   /* U+4AB8 */
  0x1E4A,   /* U+4AB9 */
  0x3E63,   /* U+4ABA */
  0x2222,   /* U+4ABB */
  0xBAE3,   /* U+4ABC */
  0x447A,   /* U+4ABD */
  0xB557,   /* U+4ABE */
  0x8510,   /* U+4ABF */
  0x3EA4,   /* U+4AC0 */
  0x216C,   /* U+4AC1 */
  0x36AE,   /* U+4AC2 */
  0x2D05,   /* U+4AC3 */
  0x2C2A,   /* U+4AC4 */
  0x8193,   /* U+4AC5 */
  0x2971,   /* U+4AC6 */
  0x7EA8,   /* U+4AC7 */
  0x28D8,   /* U+4AC8 */
  0x6935,   /* U+4AC9 */
  0x7357,   /* U+4ACA */
  0x93C7,   /* U+4ACB */
  0x749A,   /* U+4ACC */
  0x3C1D,   /* U+4ACD */
  0xBAE6,   /* U+4ACE */
  0x7700,   /* U+4ACF */
  0x624C,   /* U+4AD0 */
  0xA677,   /* U+4AD1 */
  0x69C8,   /* U+4AD2 */
  0x965F,   /* U+4AD3 */
  0x7864,   /* U+4AD4 */
  0x33DB,   /* U+4AD5 */
  0x28DC,   /* U+4AD6 */
  0x996B,   /* U+4AD7 */
  0x4517,   /* U+4AD8 */
  0x81AE,   /* U+4AD9 */
  0x4092,   /* U+4ADA */
  0x4673,   /* U+4ADB */
  0x1D61,   /* U+4ADC */
  0x3C21,   /* U+4ADD */
  0x7A47,   /* U+4ADE */
  0x4AFB,   /* U+4ADF */
  0x7430,   /* U+4AE0 */
  0xA2DD,   /* U+4AE1 */
  0x888C,   /* U+4AE2 */
  0x9847,   /* U+4AE3 */
  0x6C6D,   /* U+4AE4 */
  0x5AC8,   /* U+4AE5 */
  0x3E81,   /* U+4AE6 */
  0xBDC1,   /* U+4AE7 */
  0x1DC7,   /* U+4AE8 */
  0x8187,   /* U+4AE9 */
  0x87E0,   /* U+4AEA */
  0x64C3,   /* U+4AEB */
  0xB563,   /* U+4AEC */
  0x4AA6,   /* U+4AED */
  0x2700,   /* U+4AEE */
  0xBDC1,   /* U+4AEF */
  0x6298,   /* U+4AF0 */
  0x6DD2,   /* U+4AF1 */
  0x43EE,   /* U+4AF2 */
  0x3554,   /* U+4AF3 */
  0x5316,   /* U+4AF4 */
  0x6B53,   /* U+4AF5 */
  0x38CE,   /* U+4AF6 */
  0x37D1,   /* U+4AF7 */
  0x27EE,   /* U+4AF8 */
  0x4604,   /* U+4AF9 */
  0x460A,   /* U+4AFA */
  0xAE27,   /* U+4AFB */
  0xA119,   /* U+4AFC */
  0x72FC,   /* U+4AFD */
  0x2088,   /* U+4AFE */
  0x27F6,   /* U+4AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4A00 */
  0x0020,   /* U+4A01 */
  0x0020,   /* U+4A02 */
  0x0020,   /* U+4A03 */
  0x0020,   /* U+4A04 */
  0x0020,   /* U+4A05 */
  0x0020,   /* U+4A06 */
  0x0020,   /* U+4A07 */
  0x0020,   /* U+4A08 */
  0x0020,   /* U+4A09 */
  0x0020,   /* U+4A0A */
  0x0020,   /* U+4A0B */
  0x0020,   /* U+4A0C */
  0x0020,   /* U+4A0D */
  0x0020,   /* U+4A0E */
  0x0020,   /* U+4A0F */
  0x0020,   /* U+4A10 */
  0x0020,   /* U+4A11 */
  0x0020,   /* U+4A12 */
  0x0020,   /* U+4A13 */
  0x0020,   /* U+4A14 */
  0x0020,   /* U+4A15 */
  0x0020,   /* U+4A16 */
  0x0020,   /* U+4A17 */
  0x0020,   /* U+4A18 */
  0x0020,   /* U+4A19 */
  0x0020,   /* U+4A1A */
  0x0020,   /* U+4A1B */
  0x0020,   /* U+4A1C */
  0x0020,   /* U+4A1D */
  0x0020,   /* U+4A1E */
  0x0020,   /* U+4A1F */
  0x0020,   /* U+4A20 */
  0x0020,   /* U+4A21 */
  0x0020,   /* U+4A22 */
  0x0020,   /* U+4A23 */
  0x0020,   /* U+4A24 */
  0x0020,   /* U+4A25 */
  0x0020,   /* U+4A26 */
  0x0020,   /* U+4A27 */
  0x0020,   /* U+4A28 */
  0x0020,   /* U+4A29 */
  0x0020,   /* U+4A2A */
  0x0020,   /* U+4A2B */
  0x0020,   /* U+4A2C */
  0x0020,   /* U+4A2D */
  0x0020,   /* U+4A2E */
  0x0020,   /* U+4A2F */
  0x0020,   /* U+4A30 */
  0x0020,   /* U+4A31 */
  0x0020,   /* U+4A32 */
  0x0020,   /* U+4A33 */
  0x0020,   /* U+4A34 */
  0x0020,   /* U+4A35 */
  0x0020,   /* U+4A36 */
  0x0020,   /* U+4A37 */
  0x0020,   /* U+4A38 */
  0x0020,   /* U+4A39 */
  0x0020,   /* U+4A3A */
  0x0020,   /* U+4A3B */
  0x0020,   /* U+4A3C */
  0x0020,   /* U+4A3D */
  0x0020,   /* U+4A3E */
  0x0020,   /* U+4A3F */
  0x0020,   /* U+4A40 */
  0x0020,   /* U+4A41 */
  0x0020,   /* U+4A42 */
  0x0020,   /* U+4A43 */
  0x0020,   /* U+4A44 */
  0x0020,   /* U+4A45 */
  0x0020,   /* U+4A46 */
  0x0020,   /* U+4A47 */
  0x0020,   /* U+4A48 */
  0x0020,   /* U+4A49 */
  0x0020,   /* U+4A4A */
  0x0020,   /* U+4A4B */
  0x0020,   /* U+4A4C */
  0x0020,   /* U+4A4D */
  0x0020,   /* U+4A4E */
  0x0020,   /* U+4A4F */
  0x0020,   /* U+4A50 */
  0x0020,   /* U+4A51 */
  0x0020,   /* U+4A52 */
  0x0020,   /* U+4A53 */
  0x0020,   /* U+4A54 */
  0x0020,   /* U+4A55 */
  0x0020,   /* U+4A56 */
  0x0020,   /* U+4A57 */
  0x0020,   /* U+4A58 */
  0x0020,   /* U+4A59 */
  0x0020,   /* U+4A5A */
  0x0020,   /* U+4A5B */
  0x0020,   /* U+4A5C */
  0x0020,   /* U+4A5D */
  0x0020,   /* U+4A5E */
  0x0020,   /* U+4A5F */
  0x0020,   /* U+4A60 */
  0x0020,   /* U+4A61 */
  0x0020,   /* U+4A62 */
  0x0020,   /* U+4A63 */
  0x0020,   /* U+4A64 */
  0x0020,   /* U+4A65 */
  0x0020,   /* U+4A66 */
  0x0020,   /* U+4A67 */
  0x0020,   /* U+4A68 */
  0x0020,   /* U+4A69 */
  0x0020,   /* U+4A6A */
  0x0020,   /* U+4A6B */
  0x0020,   /* U+4A6C */
  0x0020,   /* U+4A6D */
  0x0020,   /* U+4A6E */
  0x0020,   /* U+4A6F */
  0x0020,   /* U+4A70 */
  0x0020,   /* U+4A71 */
  0x0020,   /* U+4A72 */
  0x0020,   /* U+4A73 */
  0x0020,   /* U+4A74 */
  0x0020,   /* U+4A75 */
  0x0020,   /* U+4A76 */
  0x0020,   /* U+4A77 */
  0x0020,   /* U+4A78 */
  0x0020,   /* U+4A79 */
  0x0020,   /* U+4A7A */
  0x0020,   /* U+4A7B */
  0x0020,   /* U+4A7C */
  0x0020,   /* U+4A7D */
  0x0020,   /* U+4A7E */
  0x0020,   /* U+4A7F */
  0x0020,   /* U+4A80 */
  0x0020,   /* U+4A81 */
  0x0020,   /* U+4A82 */
  0x0020,   /* U+4A83 */
  0x0020,   /* U+4A84 */
  0x0020,   /* U+4A85 */
  0x0020,   /* U+4A86 */
  0x0020,   /* U+4A87 */
  0x0020,   /* U+4A88 */
  0x0020,   /* U+4A89 */
  0x0020,   /* U+4A8A */
  0x0020,   /* U+4A8B */
  0x0020,   /* U+4A8C */
  0x0020,   /* U+4A8D */
  0x0020,   /* U+4A8E */
  0x0020,   /* U+4A8F */
  0x0020,   /* U+4A90 */
  0x0020,   /* U+4A91 */
  0x0020,   /* U+4A92 */
  0x0020,   /* U+4A93 */
  0x0020,   /* U+4A94 */
  0x0020,   /* U+4A95 */
  0x0020,   /* U+4A96 */
  0x0020,   /* U+4A97 */
  0x0020,   /* U+4A98 */
  0x0020,   /* U+4A99 */
  0x0020,   /* U+4A9A */
  0x0020,   /* U+4A9B */
  0x0020,   /* U+4A9C */
  0x0020,   /* U+4A9D */
  0x0020,   /* U+4A9E */
  0x0020,   /* U+4A9F */
  0x0020,   /* U+4AA0 */
  0x0020,   /* U+4AA1 */
  0x0020,   /* U+4AA2 */
  0x0020,   /* U+4AA3 */
  0x0020,   /* U+4AA4 */
  0x0020,   /* U+4AA5 */
  0x0020,   /* U+4AA6 */
  0x0020,   /* U+4AA7 */
  0x0020,   /* U+4AA8 */
  0x0020,   /* U+4AA9 */
  0x0020,   /* U+4AAA */
  0x0020,   /* U+4AAB */
  0x0020,   /* U+4AAC */
  0x0020,   /* U+4AAD */
  0x0020,   /* U+4AAE */
  0x0020,   /* U+4AAF */
  0x0020,   /* U+4AB0 */
  0x0020,   /* U+4AB1 */
  0x0020,   /* U+4AB2 */
  0x0020,   /* U+4AB3 */
  0x0020,   /* U+4AB4 */
  0x0020,   /* U+4AB5 */
  0x0020,   /* U+4AB6 */
  0x0020,   /* U+4AB7 */
  0x0020,   /* U+4AB8 */
  0x0020,   /* U+4AB9 */
  0x0020,   /* U+4ABA */
  0x0020,   /* U+4ABB */
  0x0020,   /* U+4ABC */
  0x0020,   /* U+4ABD */
  0x0020,   /* U+4ABE */
  0x0020,   /* U+4ABF */
  0x0020,   /* U+4AC0 */
  0x0020,   /* U+4AC1 */
  0x0020,   /* U+4AC2 */
  0x0020,   /* U+4AC3 */
  0x0020,   /* U+4AC4 */
  0x0020,   /* U+4AC5 */
  0x0020,   /* U+4AC6 */
  0x0020,   /* U+4AC7 */
  0x0020,   /* U+4AC8 */
  0x0020,   /* U+4AC9 */
  0x0020,   /* U+4ACA */
  0x0020,   /* U+4ACB */
  0x0020,   /* U+4ACC */
  0x0020,   /* U+4ACD */
  0x0020,   /* U+4ACE */
  0x0020,   /* U+4ACF */
  0x0020,   /* U+4AD0 */
  0x0020,   /* U+4AD1 */
  0x0020,   /* U+4AD2 */
  0x0020,   /* U+4AD3 */
  0x0020,   /* U+4AD4 */
  0x0020,   /* U+4AD5 */
  0x0020,   /* U+4AD6 */
  0x0020,   /* U+4AD7 */
  0x0020,   /* U+4AD8 */
  0x0020,   /* U+4AD9 */
  0x0020,   /* U+4ADA */
  0x0020,   /* U+4ADB */
  0x0020,   /* U+4ADC */
  0x0020,   /* U+4ADD */
  0x0020,   /* U+4ADE */
  0x0020,   /* U+4ADF */
  0x0020,   /* U+4AE0 */
  0x0020,   /* U+4AE1 */
  0x0020,   /* U+4AE2 */
  0x0020,   /* U+4AE3 */
  0x0020,   /* U+4AE4 */
  0x0020,   /* U+4AE5 */
  0x0020,   /* U+4AE6 */
  0x0020,   /* U+4AE7 */
  0x0020,   /* U+4AE8 */
  0x0020,   /* U+4AE9 */
  0x0020,   /* U+4AEA */
  0x0020,   /* U+4AEB */
  0x0020,   /* U+4AEC */
  0x0020,   /* U+4AED */
  0x0020,   /* U+4AEE */
  0x0020,   /* U+4AEF */
  0x0020,   /* U+4AF0 */
  0x0020,   /* U+4AF1 */
  0x0020,   /* U+4AF2 */
  0x0020,   /* U+4AF3 */
  0x0020,   /* U+4AF4 */
  0x0020,   /* U+4AF5 */
  0x0020,   /* U+4AF6 */
  0x0020,   /* U+4AF7 */
  0x0020,   /* U+4AF8 */
  0x0020,   /* U+4AF9 */
  0x0020,   /* U+4AFA */
  0x0020,   /* U+4AFB */
  0x0020,   /* U+4AFC */
  0x0020,   /* U+4AFD */
  0x0020,   /* U+4AFE */
  0x0020,   /* U+4AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4A00 */
  0x0002,   /* U+4A01 */
  0x0002,   /* U+4A02 */
  0x0002,   /* U+4A03 */
  0x0002,   /* U+4A04 */
  0x0002,   /* U+4A05 */
  0x0002,   /* U+4A06 */
  0x0002,   /* U+4A07 */
  0x0002,   /* U+4A08 */
  0x0002,   /* U+4A09 */
  0x0002,   /* U+4A0A */
  0x0002,   /* U+4A0B */
  0x0002,   /* U+4A0C */
  0x0002,   /* U+4A0D */
  0x0002,   /* U+4A0E */
  0x0002,   /* U+4A0F */
  0x0002,   /* U+4A10 */
  0x0002,   /* U+4A11 */
  0x0002,   /* U+4A12 */
  0x0002,   /* U+4A13 */
  0x0002,   /* U+4A14 */
  0x0002,   /* U+4A15 */
  0x0002,   /* U+4A16 */
  0x0002,   /* U+4A17 */
  0x0002,   /* U+4A18 */
  0x0002,   /* U+4A19 */
  0x0002,   /* U+4A1A */
  0x0002,   /* U+4A1B */
  0x0002,   /* U+4A1C */
  0x0002,   /* U+4A1D */
  0x0002,   /* U+4A1E */
  0x0002,   /* U+4A1F */
  0x0002,   /* U+4A20 */
  0x0002,   /* U+4A21 */
  0x0002,   /* U+4A22 */
  0x0002,   /* U+4A23 */
  0x0002,   /* U+4A24 */
  0x0002,   /* U+4A25 */
  0x0002,   /* U+4A26 */
  0x0002,   /* U+4A27 */
  0x0002,   /* U+4A28 */
  0x0002,   /* U+4A29 */
  0x0002,   /* U+4A2A */
  0x0002,   /* U+4A2B */
  0x0002,   /* U+4A2C */
  0x0002,   /* U+4A2D */
  0x0002,   /* U+4A2E */
  0x0002,   /* U+4A2F */
  0x0002,   /* U+4A30 */
  0x0002,   /* U+4A31 */
  0x0002,   /* U+4A32 */
  0x0002,   /* U+4A33 */
  0x0002,   /* U+4A34 */
  0x0002,   /* U+4A35 */
  0x0002,   /* U+4A36 */
  0x0002,   /* U+4A37 */
  0x0002,   /* U+4A38 */
  0x0002,   /* U+4A39 */
  0x0002,   /* U+4A3A */
  0x0002,   /* U+4A3B */
  0x0002,   /* U+4A3C */
  0x0002,   /* U+4A3D */
  0x0002,   /* U+4A3E */
  0x0002,   /* U+4A3F */
  0x0002,   /* U+4A40 */
  0x0002,   /* U+4A41 */
  0x0002,   /* U+4A42 */
  0x0002,   /* U+4A43 */
  0x0002,   /* U+4A44 */
  0x0002,   /* U+4A45 */
  0x0002,   /* U+4A46 */
  0x0002,   /* U+4A47 */
  0x0002,   /* U+4A48 */
  0x0002,   /* U+4A49 */
  0x0002,   /* U+4A4A */
  0x0002,   /* U+4A4B */
  0x0002,   /* U+4A4C */
  0x0002,   /* U+4A4D */
  0x0002,   /* U+4A4E */
  0x0002,   /* U+4A4F */
  0x0002,   /* U+4A50 */
  0x0002,   /* U+4A51 */
  0x0002,   /* U+4A52 */
  0x0002,   /* U+4A53 */
  0x0002,   /* U+4A54 */
  0x0002,   /* U+4A55 */
  0x0002,   /* U+4A56 */
  0x0002,   /* U+4A57 */
  0x0002,   /* U+4A58 */
  0x0002,   /* U+4A59 */
  0x0002,   /* U+4A5A */
  0x0002,   /* U+4A5B */
  0x0002,   /* U+4A5C */
  0x0002,   /* U+4A5D */
  0x0002,   /* U+4A5E */
  0x0002,   /* U+4A5F */
  0x0002,   /* U+4A60 */
  0x0002,   /* U+4A61 */
  0x0002,   /* U+4A62 */
  0x0002,   /* U+4A63 */
  0x0002,   /* U+4A64 */
  0x0002,   /* U+4A65 */
  0x0002,   /* U+4A66 */
  0x0002,   /* U+4A67 */
  0x0002,   /* U+4A68 */
  0x0002,   /* U+4A69 */
  0x0002,   /* U+4A6A */
  0x0002,   /* U+4A6B */
  0x0002,   /* U+4A6C */
  0x0002,   /* U+4A6D */
  0x0002,   /* U+4A6E */
  0x0002,   /* U+4A6F */
  0x0002,   /* U+4A70 */
  0x0002,   /* U+4A71 */
  0x0002,   /* U+4A72 */
  0x0002,   /* U+4A73 */
  0x0002,   /* U+4A74 */
  0x0002,   /* U+4A75 */
  0x0002,   /* U+4A76 */
  0x0002,   /* U+4A77 */
  0x0002,   /* U+4A78 */
  0x0002,   /* U+4A79 */
  0x0002,   /* U+4A7A */
  0x0002,   /* U+4A7B */
  0x0002,   /* U+4A7C */
  0x0002,   /* U+4A7D */
  0x0002,   /* U+4A7E */
  0x0002,   /* U+4A7F */
  0x0002,   /* U+4A80 */
  0x0002,   /* U+4A81 */
  0x0002,   /* U+4A82 */
  0x0002,   /* U+4A83 */
  0x0002,   /* U+4A84 */
  0x0002,   /* U+4A85 */
  0x0002,   /* U+4A86 */
  0x0002,   /* U+4A87 */
  0x0002,   /* U+4A88 */
  0x0002,   /* U+4A89 */
  0x0002,   /* U+4A8A */
  0x0002,   /* U+4A8B */
  0x0002,   /* U+4A8C */
  0x0002,   /* U+4A8D */
  0x0002,   /* U+4A8E */
  0x0002,   /* U+4A8F */
  0x0002,   /* U+4A90 */
  0x0002,   /* U+4A91 */
  0x0002,   /* U+4A92 */
  0x0002,   /* U+4A93 */
  0x0002,   /* U+4A94 */
  0x0002,   /* U+4A95 */
  0x0002,   /* U+4A96 */
  0x0002,   /* U+4A97 */
  0x0002,   /* U+4A98 */
  0x0002,   /* U+4A99 */
  0x0002,   /* U+4A9A */
  0x0002,   /* U+4A9B */
  0x0002,   /* U+4A9C */
  0x0002,   /* U+4A9D */
  0x0002,   /* U+4A9E */
  0x0002,   /* U+4A9F */
  0x0002,   /* U+4AA0 */
  0x0002,   /* U+4AA1 */
  0x0002,   /* U+4AA2 */
  0x0002,   /* U+4AA3 */
  0x0002,   /* U+4AA4 */
  0x0002,   /* U+4AA5 */
  0x0002,   /* U+4AA6 */
  0x0002,   /* U+4AA7 */
  0x0002,   /* U+4AA8 */
  0x0002,   /* U+4AA9 */
  0x0002,   /* U+4AAA */
  0x0002,   /* U+4AAB */
  0x0002,   /* U+4AAC */
  0x0002,   /* U+4AAD */
  0x0002,   /* U+4AAE */
  0x0002,   /* U+4AAF */
  0x0002,   /* U+4AB0 */
  0x0002,   /* U+4AB1 */
  0x0002,   /* U+4AB2 */
  0x0002,   /* U+4AB3 */
  0x0002,   /* U+4AB4 */
  0x0002,   /* U+4AB5 */
  0x0002,   /* U+4AB6 */
  0x0002,   /* U+4AB7 */
  0x0002,   /* U+4AB8 */
  0x0002,   /* U+4AB9 */
  0x0002,   /* U+4ABA */
  0x0002,   /* U+4ABB */
  0x0002,   /* U+4ABC */
  0x0002,   /* U+4ABD */
  0x0002,   /* U+4ABE */
  0x0002,   /* U+4ABF */
  0x0002,   /* U+4AC0 */
  0x0002,   /* U+4AC1 */
  0x0002,   /* U+4AC2 */
  0x0002,   /* U+4AC3 */
  0x0002,   /* U+4AC4 */
  0x0002,   /* U+4AC5 */
  0x0002,   /* U+4AC6 */
  0x0002,   /* U+4AC7 */
  0x0002,   /* U+4AC8 */
  0x0002,   /* U+4AC9 */
  0x0002,   /* U+4ACA */
  0x0002,   /* U+4ACB */
  0x0002,   /* U+4ACC */
  0x0002,   /* U+4ACD */
  0x0002,   /* U+4ACE */
  0x0002,   /* U+4ACF */
  0x0002,   /* U+4AD0 */
  0x0002,   /* U+4AD1 */
  0x0002,   /* U+4AD2 */
  0x0002,   /* U+4AD3 */
  0x0002,   /* U+4AD4 */
  0x0002,   /* U+4AD5 */
  0x0002,   /* U+4AD6 */
  0x0002,   /* U+4AD7 */
  0x0002,   /* U+4AD8 */
  0x0002,   /* U+4AD9 */
  0x0002,   /* U+4ADA */
  0x0002,   /* U+4ADB */
  0x0002,   /* U+4ADC */
  0x0002,   /* U+4ADD */
  0x0002,   /* U+4ADE */
  0x0002,   /* U+4ADF */
  0x0002,   /* U+4AE0 */
  0x0002,   /* U+4AE1 */
  0x0002,   /* U+4AE2 */
  0x0002,   /* U+4AE3 */
  0x0002,   /* U+4AE4 */
  0x0002,   /* U+4AE5 */
  0x0002,   /* U+4AE6 */
  0x0002,   /* U+4AE7 */
  0x0002,   /* U+4AE8 */
  0x0002,   /* U+4AE9 */
  0x0002,   /* U+4AEA */
  0x0002,   /* U+4AEB */
  0x0002,   /* U+4AEC */
  0x0002,   /* U+4AED */
  0x0002,   /* U+4AEE */
  0x0002,   /* U+4AEF */
  0x0002,   /* U+4AF0 */
  0x0002,   /* U+4AF1 */
  0x0002,   /* U+4AF2 */
  0x0002,   /* U+4AF3 */
  0x0002,   /* U+4AF4 */
  0x0002,   /* U+4AF5 */
  0x0002,   /* U+4AF6 */
  0x0002,   /* U+4AF7 */
  0x0002,   /* U+4AF8 */
  0x0002,   /* U+4AF9 */
  0x0002,   /* U+4AFA */
  0x0002,   /* U+4AFB */
  0x0002,   /* U+4AFC */
  0x0002,   /* U+4AFD */
  0x0002,   /* U+4AFE */
  0x0002,   /* U+4AFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4A00 */
  0x0000,   /* U+4A01 */
  0x0000,   /* U+4A02 */
  0xCA03,   /* U+4A03 */
  0x0000,   /* U+4A04 */
  0x0000,   /* U+4A05 */
  0x0000,   /* U+4A06 */
  0xCA07,   /* U+4A07 */
  0x0000,   /* U+4A08 */
  0xCA09,   /* U+4A09 */
  0x0000,   /* U+4A0A */
  0x0000,   /* U+4A0B */
  0x0000,   /* U+4A0C */
  0x0000,   /* U+4A0D */
  0x0000,   /* U+4A0E */
  0x0000,   /* U+4A0F */
  0x0000,   /* U+4A10 */
  0x0000,   /* U+4A11 */
  0x0000,   /* U+4A12 */
  0x0000,   /* U+4A13 */
  0x0000,   /* U+4A14 */
  0xCA15,   /* U+4A15 */
  0x0000,   /* U+4A16 */
  0x0000,   /* U+4A17 */
  0x0000,   /* U+4A18 */
  0x0000,   /* U+4A19 */
  0x0000,   /* U+4A1A */
  0x0000,   /* U+4A1B */
  0x0000,   /* U+4A1C */
  0x0000,   /* U+4A1D */
  0x0000,   /* U+4A1E */
  0x0000,   /* U+4A1F */
  0x0000,   /* U+4A20 */
  0x0000,   /* U+4A21 */
  0x0000,   /* U+4A22 */
  0x0000,   /* U+4A23 */
  0x0000,   /* U+4A24 */
  0x0000,   /* U+4A25 */
  0x0000,   /* U+4A26 */
  0xCA27,   /* U+4A27 */
  0x0000,   /* U+4A28 */
  0x0000,   /* U+4A29 */
  0x0000,   /* U+4A2A */
  0x0000,   /* U+4A2B */
  0x0000,   /* U+4A2C */
  0x0000,   /* U+4A2D */
  0x0000,   /* U+4A2E */
  0x0000,   /* U+4A2F */
  0x0000,   /* U+4A30 */
  0x0000,   /* U+4A31 */
  0x0000,   /* U+4A32 */
  0x0000,   /* U+4A33 */
  0x0000,   /* U+4A34 */
  0x0000,   /* U+4A35 */
  0x0000,   /* U+4A36 */
  0x0000,   /* U+4A37 */
  0x0000,   /* U+4A38 */
  0x0000,   /* U+4A39 */
  0x0000,   /* U+4A3A */
  0x0000,   /* U+4A3B */
  0x0000,   /* U+4A3C */
  0x0000,   /* U+4A3D */
  0x0000,   /* U+4A3E */
  0x0000,   /* U+4A3F */
  0x0000,   /* U+4A40 */
  0x0000,   /* U+4A41 */
  0x0000,   /* U+4A42 */
  0x0000,   /* U+4A43 */
  0x0000,   /* U+4A44 */
  0x0000,   /* U+4A45 */
  0x0000,   /* U+4A46 */
  0x0000,   /* U+4A47 */
  0x0000,   /* U+4A48 */
  0x0000,   /* U+4A49 */
  0x0000,   /* U+4A4A */
  0x0000,   /* U+4A4B */
  0x0000,   /* U+4A4C */
  0x0000,   /* U+4A4D */
  0xCA4E,   /* U+4A4E */
  0x0000,   /* U+4A4F */
  0x0000,   /* U+4A50 */
  0x0000,   /* U+4A51 */
  0x0000,   /* U+4A52 */
  0x0000,   /* U+4A53 */
  0x0000,   /* U+4A54 */
  0x0000,   /* U+4A55 */
  0xCA56,   /* U+4A56 */
  0x0000,   /* U+4A57 */
  0x0000,   /* U+4A58 */
  0x0000,   /* U+4A59 */
  0x0000,   /* U+4A5A */
  0x0000,   /* U+4A5B */
  0x0000,   /* U+4A5C */
  0x0000,   /* U+4A5D */
  0x0000,   /* U+4A5E */
  0x0000,   /* U+4A5F */
  0xCA60,   /* U+4A60 */
  0x0000,   /* U+4A61 */
  0x0000,   /* U+4A62 */
  0x0000,   /* U+4A63 */
  0x0000,   /* U+4A64 */
  0x0000,   /* U+4A65 */
  0x0000,   /* U+4A66 */
  0x0000,   /* U+4A67 */
  0x0000,   /* U+4A68 */
  0x0000,   /* U+4A69 */
  0x0000,   /* U+4A6A */
  0x0000,   /* U+4A6B */
  0x0000,   /* U+4A6C */
  0xCA6D,   /* U+4A6D */
  0x0000,   /* U+4A6E */
  0x0000,   /* U+4A6F */
  0x0000,   /* U+4A70 */
  0x0000,   /* U+4A71 */
  0x0000,   /* U+4A72 */
  0x0000,   /* U+4A73 */
  0x0000,   /* U+4A74 */
  0x0000,   /* U+4A75 */
  0x0000,   /* U+4A76 */
  0x0000,   /* U+4A77 */
  0x0000,   /* U+4A78 */
  0x0000,   /* U+4A79 */
  0x0000,   /* U+4A7A */
  0x0000,   /* U+4A7B */
  0x0000,   /* U+4A7C */
  0x0000,   /* U+4A7D */
  0x0000,   /* U+4A7E */
  0x0000,   /* U+4A7F */
  0x0000,   /* U+4A80 */
  0x0000,   /* U+4A81 */
  0x0000,   /* U+4A82 */
  0x0000,   /* U+4A83 */
  0x0000,   /* U+4A84 */
  0x0000,   /* U+4A85 */
  0x0000,   /* U+4A86 */
  0x0000,   /* U+4A87 */
  0x0000,   /* U+4A88 */
  0x0000,   /* U+4A89 */
  0x0000,   /* U+4A8A */
  0x0000,   /* U+4A8B */
  0x0000,   /* U+4A8C */
  0x0000,   /* U+4A8D */
  0x0000,   /* U+4A8E */
  0x0000,   /* U+4A8F */
  0x0000,   /* U+4A90 */
  0x0000,   /* U+4A91 */
  0x0000,   /* U+4A92 */
  0x0000,   /* U+4A93 */
  0x0000,   /* U+4A94 */
  0x0000,   /* U+4A95 */
  0x0000,   /* U+4A96 */
  0x0000,   /* U+4A97 */
  0x0000,   /* U+4A98 */
  0x0000,   /* U+4A99 */
  0x0000,   /* U+4A9A */
  0x0000,   /* U+4A9B */
  0x0000,   /* U+4A9C */
  0x0000,   /* U+4A9D */
  0x0000,   /* U+4A9E */
  0xCA9F,   /* U+4A9F */
  0xCAA0,   /* U+4AA0 */
  0xCAA1,   /* U+4AA1 */
  0xCAA2,   /* U+4AA2 */
  0xCAA3,   /* U+4AA3 */
  0x0000,   /* U+4AA4 */
  0x0000,   /* U+4AA5 */
  0x0000,   /* U+4AA6 */
  0x0000,   /* U+4AA7 */
  0x0000,   /* U+4AA8 */
  0x0000,   /* U+4AA9 */
  0xCAAA,   /* U+4AAA */
  0x0000,   /* U+4AAB */
  0x0000,   /* U+4AAC */
  0x0000,   /* U+4AAD */
  0x0000,   /* U+4AAE */
  0x0000,   /* U+4AAF */
  0x0000,   /* U+4AB0 */
  0x0000,   /* U+4AB1 */
  0x0000,   /* U+4AB2 */
  0x0000,   /* U+4AB3 */
  0x0000,   /* U+4AB4 */
  0x0000,   /* U+4AB5 */
  0x0000,   /* U+4AB6 */
  0x0000,   /* U+4AB7 */
  0x0000,   /* U+4AB8 */
  0x0000,   /* U+4AB9 */
  0x0000,   /* U+4ABA */
  0x0000,   /* U+4ABB */
  0x0000,   /* U+4ABC */
  0x0000,   /* U+4ABD */
  0x0000,   /* U+4ABE */
  0x0000,   /* U+4ABF */
  0x0000,   /* U+4AC0 */
  0x0000,   /* U+4AC1 */
  0x0000,   /* U+4AC2 */
  0x0000,   /* U+4AC3 */
  0x0000,   /* U+4AC4 */
  0x0000,   /* U+4AC5 */
  0x0000,   /* U+4AC6 */
  0x0000,   /* U+4AC7 */
  0x0000,   /* U+4AC8 */
  0x0000,   /* U+4AC9 */
  0x0000,   /* U+4ACA */
  0x0000,   /* U+4ACB */
  0x0000,   /* U+4ACC */
  0x0000,   /* U+4ACD */
  0x0000,   /* U+4ACE */
  0x0000,   /* U+4ACF */
  0x0000,   /* U+4AD0 */
  0x0000,   /* U+4AD1 */
  0x0000,   /* U+4AD2 */
  0x0000,   /* U+4AD3 */
  0x0000,   /* U+4AD4 */
  0x0000,   /* U+4AD5 */
  0x0000,   /* U+4AD6 */
  0x0000,   /* U+4AD7 */
  0x0000,   /* U+4AD8 */
  0x0000,   /* U+4AD9 */
  0x0000,   /* U+4ADA */
  0x0000,   /* U+4ADB */
  0x0000,   /* U+4ADC */
  0x0000,   /* U+4ADD */
  0x0000,   /* U+4ADE */
  0x0000,   /* U+4ADF */
  0x0000,   /* U+4AE0 */
  0x0000,   /* U+4AE1 */
  0x0000,   /* U+4AE2 */
  0x0000,   /* U+4AE3 */
  0x0000,   /* U+4AE4 */
  0x0000,   /* U+4AE5 */
  0x0000,   /* U+4AE6 */
  0xCAE7,   /* U+4AE7 */
  0x0000,   /* U+4AE8 */
  0x0000,   /* U+4AE9 */
  0x0000,   /* U+4AEA */
  0x0000,   /* U+4AEB */
  0x0000,   /* U+4AEC */
  0x0000,   /* U+4AED */
  0x0000,   /* U+4AEE */
  0xCAEF,   /* U+4AEF */
  0x0000,   /* U+4AF0 */
  0x0000,   /* U+4AF1 */
  0x0000,   /* U+4AF2 */
  0x0000,   /* U+4AF3 */
  0x0000,   /* U+4AF4 */
  0x0000,   /* U+4AF5 */
  0x0000,   /* U+4AF6 */
  0x0000,   /* U+4AF7 */
  0x0000,   /* U+4AF8 */
  0x0000,   /* U+4AF9 */
  0x0000,   /* U+4AFA */
  0x0000,   /* U+4AFB */
  0x0000,   /* U+4AFC */
  0x0000,   /* U+4AFD */
  0x0000,   /* U+4AFE */
  0x0000,   /* U+4AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4A00 */
  0x0000,   /* U+4A01 */
  0x0000,   /* U+4A02 */
  0x0000,   /* U+4A03 */
  0x0000,   /* U+4A04 */
  0x0000,   /* U+4A05 */
  0x0000,   /* U+4A06 */
  0x0000,   /* U+4A07 */
  0x0000,   /* U+4A08 */
  0x0000,   /* U+4A09 */
  0x0000,   /* U+4A0A */
  0x0000,   /* U+4A0B */
  0x0000,   /* U+4A0C */
  0x0000,   /* U+4A0D */
  0x0000,   /* U+4A0E */
  0x0000,   /* U+4A0F */
  0x0000,   /* U+4A10 */
  0x0000,   /* U+4A11 */
  0x0000,   /* U+4A12 */
  0x0000,   /* U+4A13 */
  0x0000,   /* U+4A14 */
  0x0000,   /* U+4A15 */
  0x0000,   /* U+4A16 */
  0x0000,   /* U+4A17 */
  0x0000,   /* U+4A18 */
  0x0000,   /* U+4A19 */
  0x0000,   /* U+4A1A */
  0x0000,   /* U+4A1B */
  0x0000,   /* U+4A1C */
  0x0000,   /* U+4A1D */
  0x0000,   /* U+4A1E */
  0x0000,   /* U+4A1F */
  0x0000,   /* U+4A20 */
  0x0000,   /* U+4A21 */
  0x0000,   /* U+4A22 */
  0x0000,   /* U+4A23 */
  0x0000,   /* U+4A24 */
  0x0000,   /* U+4A25 */
  0x0000,   /* U+4A26 */
  0x0000,   /* U+4A27 */
  0x0000,   /* U+4A28 */
  0x0000,   /* U+4A29 */
  0x0000,   /* U+4A2A */
  0x0000,   /* U+4A2B */
  0x0000,   /* U+4A2C */
  0x0000,   /* U+4A2D */
  0x0000,   /* U+4A2E */
  0x0000,   /* U+4A2F */
  0x0000,   /* U+4A30 */
  0x0000,   /* U+4A31 */
  0x0000,   /* U+4A32 */
  0x0000,   /* U+4A33 */
  0x0000,   /* U+4A34 */
  0x0000,   /* U+4A35 */
  0x0000,   /* U+4A36 */
  0x0000,   /* U+4A37 */
  0x0000,   /* U+4A38 */
  0x0000,   /* U+4A39 */
  0x0000,   /* U+4A3A */
  0x0000,   /* U+4A3B */
  0x0000,   /* U+4A3C */
  0x0000,   /* U+4A3D */
  0x0000,   /* U+4A3E */
  0x0000,   /* U+4A3F */
  0x0000,   /* U+4A40 */
  0x0000,   /* U+4A41 */
  0x0000,   /* U+4A42 */
  0x0000,   /* U+4A43 */
  0x0000,   /* U+4A44 */
  0x0000,   /* U+4A45 */
  0x0000,   /* U+4A46 */
  0x0000,   /* U+4A47 */
  0x0000,   /* U+4A48 */
  0x0000,   /* U+4A49 */
  0x0000,   /* U+4A4A */
  0x0000,   /* U+4A4B */
  0x0000,   /* U+4A4C */
  0x0000,   /* U+4A4D */
  0x0000,   /* U+4A4E */
  0x0000,   /* U+4A4F */
  0x0000,   /* U+4A50 */
  0x0000,   /* U+4A51 */
  0x0000,   /* U+4A52 */
  0x0000,   /* U+4A53 */
  0x0000,   /* U+4A54 */
  0x0000,   /* U+4A55 */
  0x0000,   /* U+4A56 */
  0x0000,   /* U+4A57 */
  0x0000,   /* U+4A58 */
  0x0000,   /* U+4A59 */
  0x0000,   /* U+4A5A */
  0x0000,   /* U+4A5B */
  0x0000,   /* U+4A5C */
  0x0000,   /* U+4A5D */
  0x0000,   /* U+4A5E */
  0x0000,   /* U+4A5F */
  0x0000,   /* U+4A60 */
  0x0000,   /* U+4A61 */
  0x0000,   /* U+4A62 */
  0x0000,   /* U+4A63 */
  0x0000,   /* U+4A64 */
  0x0000,   /* U+4A65 */
  0x0000,   /* U+4A66 */
  0x0000,   /* U+4A67 */
  0x0000,   /* U+4A68 */
  0x0000,   /* U+4A69 */
  0x0000,   /* U+4A6A */
  0x0000,   /* U+4A6B */
  0x0000,   /* U+4A6C */
  0x0000,   /* U+4A6D */
  0x0000,   /* U+4A6E */
  0x0000,   /* U+4A6F */
  0x0000,   /* U+4A70 */
  0x0000,   /* U+4A71 */
  0x0000,   /* U+4A72 */
  0x0000,   /* U+4A73 */
  0x0000,   /* U+4A74 */
  0x0000,   /* U+4A75 */
  0x0000,   /* U+4A76 */
  0x0000,   /* U+4A77 */
  0x0000,   /* U+4A78 */
  0x0000,   /* U+4A79 */
  0x0000,   /* U+4A7A */
  0x0000,   /* U+4A7B */
  0x0000,   /* U+4A7C */
  0x0000,   /* U+4A7D */
  0x0000,   /* U+4A7E */
  0x0000,   /* U+4A7F */
  0x0000,   /* U+4A80 */
  0x0000,   /* U+4A81 */
  0x0000,   /* U+4A82 */
  0x0000,   /* U+4A83 */
  0x0000,   /* U+4A84 */
  0x0000,   /* U+4A85 */
  0x0000,   /* U+4A86 */
  0x0000,   /* U+4A87 */
  0x0000,   /* U+4A88 */
  0x0000,   /* U+4A89 */
  0x0000,   /* U+4A8A */
  0x0000,   /* U+4A8B */
  0x0000,   /* U+4A8C */
  0x0000,   /* U+4A8D */
  0x0000,   /* U+4A8E */
  0x0000,   /* U+4A8F */
  0x0000,   /* U+4A90 */
  0x0000,   /* U+4A91 */
  0x0000,   /* U+4A92 */
  0x0000,   /* U+4A93 */
  0x0000,   /* U+4A94 */
  0x0000,   /* U+4A95 */
  0x0000,   /* U+4A96 */
  0x0000,   /* U+4A97 */
  0x0000,   /* U+4A98 */
  0x0000,   /* U+4A99 */
  0x0000,   /* U+4A9A */
  0x0000,   /* U+4A9B */
  0x0000,   /* U+4A9C */
  0x0000,   /* U+4A9D */
  0x0000,   /* U+4A9E */
  0x0000,   /* U+4A9F */
  0x0000,   /* U+4AA0 */
  0x0000,   /* U+4AA1 */
  0x0000,   /* U+4AA2 */
  0x0000,   /* U+4AA3 */
  0x0000,   /* U+4AA4 */
  0x00