/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebAnimation.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DOMPromiseProxy.h"
#include "DocumentInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAnimationEffect.h"
#include "JSAnimationFrameRatePreset.h"
#include "JSAnimationTimeline.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSTimelineRangeOffset.h"
#include "JSWebAnimation.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(WebAnimation::PlayState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("idle"),
        MAKE_STATIC_STRING_IMPL("running"),
        MAKE_STATIC_STRING_IMPL("paused"),
        MAKE_STATIC_STRING_IMPL("finished"),
    };
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Idle) == 0, "WebAnimation::PlayState::Idle is not 0 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Running) == 1, "WebAnimation::PlayState::Running is not 1 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Paused) == 2, "WebAnimation::PlayState::Paused is not 2 as expected");
    static_assert(static_cast<size_t>(WebAnimation::PlayState::Finished) == 3, "WebAnimation::PlayState::Finished is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, WebAnimation::PlayState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<WebAnimation::PlayState> parseEnumerationFromString<WebAnimation::PlayState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, WebAnimation::PlayState>, 4> mappings {
        std::pair<ComparableASCIILiteral, WebAnimation::PlayState> { "finished"_s, WebAnimation::PlayState::Finished },
        std::pair<ComparableASCIILiteral, WebAnimation::PlayState> { "idle"_s, WebAnimation::PlayState::Idle },
        std::pair<ComparableASCIILiteral, WebAnimation::PlayState> { "paused"_s, WebAnimation::PlayState::Paused },
        std::pair<ComparableASCIILiteral, WebAnimation::PlayState> { "running"_s, WebAnimation::PlayState::Running },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<WebAnimation::PlayState> parseEnumeration<WebAnimation::PlayState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<WebAnimation::PlayState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<WebAnimation::PlayState>()
{
    return "\"idle\", \"running\", \"paused\", \"finished\""_s;
}

String convertEnumerationToString(WebAnimation::ReplaceState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("active"),
        MAKE_STATIC_STRING_IMPL("removed"),
        MAKE_STATIC_STRING_IMPL("persisted"),
    };
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Active) == 0, "WebAnimation::ReplaceState::Active is not 0 as expected");
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Removed) == 1, "WebAnimation::ReplaceState::Removed is not 1 as expected");
    static_assert(static_cast<size_t>(WebAnimation::ReplaceState::Persisted) == 2, "WebAnimation::ReplaceState::Persisted is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, WebAnimation::ReplaceState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<WebAnimation::ReplaceState> parseEnumerationFromString<WebAnimation::ReplaceState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, WebAnimation::ReplaceState>, 3> mappings {
        std::pair<ComparableASCIILiteral, WebAnimation::ReplaceState> { "active"_s, WebAnimation::ReplaceState::Active },
        std::pair<ComparableASCIILiteral, WebAnimation::ReplaceState> { "persisted"_s, WebAnimation::ReplaceState::Persisted },
        std::pair<ComparableASCIILiteral, WebAnimation::ReplaceState> { "removed"_s, WebAnimation::ReplaceState::Removed },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<WebAnimation::ReplaceState> parseEnumeration<WebAnimation::ReplaceState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<WebAnimation::ReplaceState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<WebAnimation::ReplaceState>()
{
    return "\"active\", \"removed\", \"persisted\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_cancel);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_finish);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_play);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_pause);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_updatePlaybackRate);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_reverse);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_persist);
static JSC_DECLARE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_commitStyles);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_id);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_id);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_effect);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_effect);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_timeline);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_timeline);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_startTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_startTime);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_currentTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_rangeStart);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_rangeStart);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_rangeEnd);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_rangeEnd);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_playbackRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_playbackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_overallProgress);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_frameRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_frameRate);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_playState);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_replaceState);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_pending);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_onfinish);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_onfinish);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_onremove);
static JSC_DECLARE_CUSTOM_SETTER(setJSWebAnimation_onremove);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_ready);
static JSC_DECLARE_CUSTOM_GETTER(jsWebAnimation_finished);

class JSWebAnimationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebAnimationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebAnimationPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebAnimationPrototype>(vm)) JSWebAnimationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebAnimationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebAnimationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebAnimationPrototype, JSWebAnimationPrototype::Base);

using JSWebAnimationDOMConstructor = JSDOMConstructor<JSWebAnimation>;

template<> JSC::EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebAnimationDOMConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSWebAnimation(lexicalGlobalObject, *callFrame);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebAnimationDOMConstructorConstruct, JSWebAnimationDOMConstructor::construct);

template<> const ClassInfo JSWebAnimationDOMConstructor::s_info = { "Animation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimationDOMConstructor) };

template<> JSValue JSWebAnimationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWebAnimationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Animation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebAnimation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 27> JSWebAnimationPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimationConstructor, 0 } },
    HashTableValue { "id"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_id, setJSWebAnimation_id } },
    HashTableValue { "effect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_effect, setJSWebAnimation_effect } },
    HashTableValue { "timeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_timeline, setJSWebAnimation_timeline } },
    HashTableValue { "startTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_startTime, setJSWebAnimation_startTime } },
    HashTableValue { "currentTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_currentTime, setJSWebAnimation_currentTime } },
    HashTableValue { "rangeStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_rangeStart, setJSWebAnimation_rangeStart } },
    HashTableValue { "rangeEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_rangeEnd, setJSWebAnimation_rangeEnd } },
    HashTableValue { "playbackRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_playbackRate, setJSWebAnimation_playbackRate } },
    HashTableValue { "overallProgress"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_overallProgress, 0 } },
    HashTableValue { "frameRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_frameRate, setJSWebAnimation_frameRate } },
    HashTableValue { "playState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_playState, 0 } },
    HashTableValue { "replaceState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_replaceState, 0 } },
    HashTableValue { "pending"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_pending, 0 } },
    HashTableValue { "onfinish"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_onfinish, setJSWebAnimation_onfinish } },
    HashTableValue { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_oncancel, setJSWebAnimation_oncancel } },
    HashTableValue { "onremove"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_onremove, setJSWebAnimation_onremove } },
    HashTableValue { "ready"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_ready, 0 } },
    HashTableValue { "finished"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebAnimation_finished, 0 } },
    HashTableValue { "cancel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_cancel, 0 } },
    HashTableValue { "finish"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_finish, 0 } },
    HashTableValue { "play"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_play, 0 } },
    HashTableValue { "pause"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_pause, 0 } },
    HashTableValue { "updatePlaybackRate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_updatePlaybackRate, 1 } },
    HashTableValue { "reverse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_reverse, 0 } },
    HashTableValue { "persist"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_persist, 0 } },
    HashTableValue { "commitStyles"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebAnimationPrototypeFunction_commitStyles, 0 } },
};

const ClassInfo JSWebAnimationPrototype::s_info = { "Animation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimationPrototype) };

void JSWebAnimationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebAnimation::info(), JSWebAnimationPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "rangeStart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "rangeEnd"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsOverallProgressPropertyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overallProgress"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCustomFrameRateEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "frameRate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebAnimation::s_info = { "Animation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebAnimation) };

JSWebAnimation::JSWebAnimation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebAnimation>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<WebAnimation> JSWebAnimation::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, WebAnimation>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWebAnimation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebAnimationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebAnimationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebAnimation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebAnimation>(vm, globalObject);
}

JSValue JSWebAnimation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebAnimationDOMConstructor, DOMConstructorID::WebAnimation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebAnimationPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebAnimation::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebAnimation_idGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_idSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setId(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_idSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_effectGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<AnimationEffect>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsEffect())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_effect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_effectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_effectSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<AnimationEffect>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Animation"_s, "effect"_s, "AnimationEffect"_s); });
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsEffect(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_effect, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_effectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_timelineGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<AnimationTimeline>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsTimeline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_timeline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_timelineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_timelineSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<AnimationTimeline>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Animation"_s, "timeline"_s, "AnimationTimeline"_s); });
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsTimeline(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_timeline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_timelineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_startTimeGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsStartTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_startTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_startTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_startTimeSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsStartTime(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_startTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_startTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsCurrentTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_currentTimeSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsCurrentTime(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_currentTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_rangeStartGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDictionary<TimelineRangeOffset>, IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>, IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsRangeStart())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_rangeStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_rangeStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_rangeStartSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDictionary<TimelineRangeOffset>, IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>, IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsRangeStart(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_rangeStart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_rangeStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_rangeEndGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDictionary<TimelineRangeOffset>, IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>, IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsRangeEnd())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_rangeEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_rangeEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_rangeEndSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDictionary<TimelineRangeOffset>, IDLInterface<CSSNumericValue>, IDLInterface<CSSKeywordValue>, IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsRangeEnd(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_rangeEnd, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_rangeEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_playbackRateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.playbackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_playbackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_playbackRateSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackRate(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_playbackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_overallProgressGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.overallProgress())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_overallProgress, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_overallProgressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebAnimation_frameRateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLUnsignedLong, IDLEnumeration<AnimationFrameRatePreset>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bindingsFrameRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_frameRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_frameRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_frameRateSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLUnsignedLong, IDLEnumeration<AnimationFrameRatePreset>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBindingsFrameRate(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_frameRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_frameRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_playStateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebAnimation::PlayState>>(lexicalGlobalObject, throwScope, impl.bindingsPlayState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_playState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_playStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebAnimation_replaceStateGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebAnimation::ReplaceState>>(lexicalGlobalObject, throwScope, impl.bindingsReplaceState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_replaceState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_replaceStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebAnimation_pendingGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bindingsPending())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_pending, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_pendingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebAnimation_onfinishGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().finishEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_onfinish, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_onfinishGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_onfinishSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().finishEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_onfinish, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_onfinishSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_onremoveGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().removeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_onremove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_onremoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWebAnimation_onremoveSetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().removeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWebAnimation_onremove, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::set<setJSWebAnimation_onremoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsWebAnimation_readyGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<WebAnimation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.bindingsReady(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_ready, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_readyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebAnimation_finishedGetter(JSGlobalObject& lexicalGlobalObject, JSWebAnimation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<WebAnimation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.bindingsFinished(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebAnimation_finished, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebAnimation>::get<jsWebAnimation_finishedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_cancelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.cancel(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_cancel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_cancelBody>(*lexicalGlobalObject, *callFrame, "cancel");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_finishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.finish(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_finish, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_finishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_playBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindingsPlay(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_play, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_playBody>(*lexicalGlobalObject, *callFrame, "play");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_pauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindingsPause(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_pause, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_pauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_updatePlaybackRateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto playbackRateConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (playbackRateConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.updatePlaybackRate(playbackRateConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_updatePlaybackRate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_updatePlaybackRateBody>(*lexicalGlobalObject, *callFrame, "updatePlaybackRate");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_reverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bindingsReverse(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_reverse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_reverseBody>(*lexicalGlobalObject, *callFrame, "reverse");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_persistBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.persist(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_persist, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_persistBody>(*lexicalGlobalObject, *callFrame, "persist");
}

static inline JSC::EncodedJSValue jsWebAnimationPrototypeFunction_commitStylesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebAnimation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.commitStyles(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebAnimationPrototypeFunction_commitStyles, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebAnimation>::call<jsWebAnimationPrototypeFunction_commitStylesBody>(*lexicalGlobalObject, *callFrame, "commitStyles");
}

JSC::GCClient::IsoSubspace* JSWebAnimation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebAnimation, UseCustomHeapCellType::No>(vm, "JSWebAnimation"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebAnimation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebAnimation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebAnimation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebAnimation = std::forward<decltype(space)>(space); }
    );
}

void JSWebAnimation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebAnimation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebAnimationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWebAnimation = jsCast<JSWebAnimation*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsWebAnimation->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebAnimationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebAnimation = static_cast<JSWebAnimation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebAnimation->protectedWrapped().ptr(), jsWebAnimation);
}

WebAnimation* JSWebAnimation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebAnimation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
