/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSRedEyeReduction.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RedEyeReduction enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("never"),
        MAKE_STATIC_STRING_IMPL("always"),
        MAKE_STATIC_STRING_IMPL("controllable"),
    };
    static_assert(static_cast<size_t>(RedEyeReduction::Never) == 0, "RedEyeReduction::Never is not 0 as expected");
    static_assert(static_cast<size_t>(RedEyeReduction::Always) == 1, "RedEyeReduction::Always is not 1 as expected");
    static_assert(static_cast<size_t>(RedEyeReduction::Controllable) == 2, "RedEyeReduction::Controllable is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RedEyeReduction enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RedEyeReduction> parseEnumerationFromString<RedEyeReduction>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, RedEyeReduction>, 3> mappings {
        std::pair<ComparableASCIILiteral, RedEyeReduction> { "always"_s, RedEyeReduction::Always },
        std::pair<ComparableASCIILiteral, RedEyeReduction> { "controllable"_s, RedEyeReduction::Controllable },
        std::pair<ComparableASCIILiteral, RedEyeReduction> { "never"_s, RedEyeReduction::Never },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RedEyeReduction> parseEnumeration<RedEyeReduction>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RedEyeReduction>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<RedEyeReduction>()
{
    return "\"never\", \"always\", \"controllable\""_s;
}

} // namespace WebCore


#endif // ENABLE(MEDIA_STREAM)
