/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIsLoggedIn.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(IsLoggedIn enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("logged-out"),
        MAKE_STATIC_STRING_IMPL("logged-in"),
    };
    static_assert(static_cast<size_t>(IsLoggedIn::LoggedOut) == 0, "IsLoggedIn::LoggedOut is not 0 as expected");
    static_assert(static_cast<size_t>(IsLoggedIn::LoggedIn) == 1, "IsLoggedIn::LoggedIn is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, IsLoggedIn enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<IsLoggedIn> parseEnumerationFromString<IsLoggedIn>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, IsLoggedIn>, 2> mappings {
        std::pair<ComparableASCIILiteral, IsLoggedIn> { "logged-in"_s, IsLoggedIn::LoggedIn },
        std::pair<ComparableASCIILiteral, IsLoggedIn> { "logged-out"_s, IsLoggedIn::LoggedOut },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<IsLoggedIn> parseEnumeration<IsLoggedIn>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<IsLoggedIn>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<IsLoggedIn>()
{
    return "\"logged-out\", \"logged-in\""_s;
}

} // namespace WebCore

