// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// RevokeAdminTokensReader is a Reader for the RevokeAdminTokens structure.
type RevokeAdminTokensReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RevokeAdminTokensReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRevokeAdminTokensOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRevokeAdminTokensDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRevokeAdminTokensOK creates a RevokeAdminTokensOK with default headers values
func NewRevokeAdminTokensOK() *RevokeAdminTokensOK {
	return &RevokeAdminTokensOK{}
}

/*
RevokeAdminTokensOK describes a response with status code 200, with default header values.

A successful response.
*/
type RevokeAdminTokensOK struct {
	Payload models.HashicorpCloudVault20201125RevokeAdminTokensResponse
}

// IsSuccess returns true when this revoke admin tokens o k response has a 2xx status code
func (o *RevokeAdminTokensOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this revoke admin tokens o k response has a 3xx status code
func (o *RevokeAdminTokensOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke admin tokens o k response has a 4xx status code
func (o *RevokeAdminTokensOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke admin tokens o k response has a 5xx status code
func (o *RevokeAdminTokensOK) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke admin tokens o k response a status code equal to that given
func (o *RevokeAdminTokensOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the revoke admin tokens o k response
func (o *RevokeAdminTokensOK) Code() int {
	return 200
}

func (o *RevokeAdminTokensOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/revoke-admin-tokens][%d] revokeAdminTokensOK  %+v", 200, o.Payload)
}

func (o *RevokeAdminTokensOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/revoke-admin-tokens][%d] revokeAdminTokensOK  %+v", 200, o.Payload)
}

func (o *RevokeAdminTokensOK) GetPayload() models.HashicorpCloudVault20201125RevokeAdminTokensResponse {
	return o.Payload
}

func (o *RevokeAdminTokensOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeAdminTokensDefault creates a RevokeAdminTokensDefault with default headers values
func NewRevokeAdminTokensDefault(code int) *RevokeAdminTokensDefault {
	return &RevokeAdminTokensDefault{
		_statusCode: code,
	}
}

/*
RevokeAdminTokensDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type RevokeAdminTokensDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this revoke admin tokens default response has a 2xx status code
func (o *RevokeAdminTokensDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this revoke admin tokens default response has a 3xx status code
func (o *RevokeAdminTokensDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this revoke admin tokens default response has a 4xx status code
func (o *RevokeAdminTokensDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this revoke admin tokens default response has a 5xx status code
func (o *RevokeAdminTokensDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this revoke admin tokens default response a status code equal to that given
func (o *RevokeAdminTokensDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the revoke admin tokens default response
func (o *RevokeAdminTokensDefault) Code() int {
	return o._statusCode
}

func (o *RevokeAdminTokensDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/revoke-admin-tokens][%d] RevokeAdminTokens default  %+v", o._statusCode, o.Payload)
}

func (o *RevokeAdminTokensDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/revoke-admin-tokens][%d] RevokeAdminTokens default  %+v", o._statusCode, o.Payload)
}

func (o *RevokeAdminTokensDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *RevokeAdminTokensDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
