// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewAddPluginParams creates a new AddPluginParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddPluginParams() *AddPluginParams {
	return &AddPluginParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddPluginParamsWithTimeout creates a new AddPluginParams object
// with the ability to set a timeout on a request.
func NewAddPluginParamsWithTimeout(timeout time.Duration) *AddPluginParams {
	return &AddPluginParams{
		timeout: timeout,
	}
}

// NewAddPluginParamsWithContext creates a new AddPluginParams object
// with the ability to set a context for a request.
func NewAddPluginParamsWithContext(ctx context.Context) *AddPluginParams {
	return &AddPluginParams{
		Context: ctx,
	}
}

// NewAddPluginParamsWithHTTPClient creates a new AddPluginParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddPluginParamsWithHTTPClient(client *http.Client) *AddPluginParams {
	return &AddPluginParams{
		HTTPClient: client,
	}
}

/*
AddPluginParams contains all the parameters to send to the API endpoint

	for the add plugin operation.

	Typically these are written to a http.Request.
*/
type AddPluginParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125AddPluginRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add plugin params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPluginParams) WithDefaults() *AddPluginParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add plugin params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPluginParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add plugin params
func (o *AddPluginParams) WithTimeout(timeout time.Duration) *AddPluginParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add plugin params
func (o *AddPluginParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add plugin params
func (o *AddPluginParams) WithContext(ctx context.Context) *AddPluginParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add plugin params
func (o *AddPluginParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add plugin params
func (o *AddPluginParams) WithHTTPClient(client *http.Client) *AddPluginParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add plugin params
func (o *AddPluginParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the add plugin params
func (o *AddPluginParams) WithBody(body *models.HashicorpCloudVault20201125AddPluginRequest) *AddPluginParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the add plugin params
func (o *AddPluginParams) SetBody(body *models.HashicorpCloudVault20201125AddPluginRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the add plugin params
func (o *AddPluginParams) WithClusterID(clusterID string) *AddPluginParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the add plugin params
func (o *AddPluginParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the add plugin params
func (o *AddPluginParams) WithLocationOrganizationID(locationOrganizationID string) *AddPluginParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the add plugin params
func (o *AddPluginParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the add plugin params
func (o *AddPluginParams) WithLocationProjectID(locationProjectID string) *AddPluginParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the add plugin params
func (o *AddPluginParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *AddPluginParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
