//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapRange.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/range3f.h"
#include "pxr/base/gf/range3d.h"

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/copy_const_reference.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/return_arg.hpp"

#include <string>

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

static const int _dimension = 3;

static string _Repr(GfRange3f const &self) {
    return TF_PY_REPR_PREFIX + "Range3f(" +
        TfPyRepr(self.GetMin()) + ", " + TfPyRepr(self.GetMax()) + ")";
}

static GfRange3f __truediv__(const GfRange3f &self, double value)
{
    return self / value;
}

static GfRange3f& __itruediv__(GfRange3f &self, double value)
{
    return self /= value;
}

static size_t __hash__(GfRange3f const &r) { return TfHash{}(r); }

} // anonymous namespace 

void wrapRange3f()
{    
    object getMin = make_function(&GfRange3f::GetMin,
                                  return_value_policy<return_by_value>());

    object getMax = make_function(&GfRange3f::GetMax,
                                  return_value_policy<return_by_value>());

    class_<GfRange3f> cls("Range3f", init<>());
    cls
        .def(init<GfRange3f>())
        .def(init<const GfVec3f &, const GfVec3f &>())

        .def(init<GfRange3d>())
        
        .def(TfTypePythonClass())

        .def_readonly("dimension", _dimension)
        
        .add_property("min", getMin, &GfRange3f::SetMin)
        .add_property("max", getMax, &GfRange3f::SetMax)

        .def("GetMin", getMin)
        .def("GetMax", getMax)

        .def("GetSize", &GfRange3f::GetSize)
        .def("GetMidpoint", &GfRange3f::GetMidpoint)
    
        .def("SetMin", &GfRange3f::SetMin)
        .def("SetMax", &GfRange3f::SetMax)
    
        .def("IsEmpty", &GfRange3f::IsEmpty)
    
        .def("SetEmpty", &GfRange3f::SetEmpty)

        .def("Contains", (bool (GfRange3f::*)(const GfVec3f &) const)
             &GfRange3f::Contains)
        .def("Contains", (bool (GfRange3f::*)(const GfRange3f &) const)
             &GfRange3f::Contains)
    
        .def("GetUnion", &GfRange3f::GetUnion)
        .staticmethod("GetUnion")
    
        .def("UnionWith", (const GfRange3f & (GfRange3f::*)(const GfVec3f &))
             &GfRange3f::UnionWith, return_self<>())
        .def("UnionWith", (const GfRange3f & (GfRange3f::*)(const GfRange3f &))
             &GfRange3f::UnionWith, return_self<>())
    
        .def("GetIntersection", &GfRange3f::GetIntersection)
        .staticmethod("GetIntersection")
    
        .def("IntersectWith", (const GfRange3f & (GfRange3f::*)(const GfRange3f &))
             &GfRange3f::IntersectWith, return_self<>())
    
        .def("GetDistanceSquared", &GfRange3f::GetDistanceSquared)
    
        .def(str(self))
        .def(self += self)
        .def(self -= self)
        .def(self *= double())
        .def(self /= double())
        .def(self + self)
        .def(self - self)
        .def(double() * self)
        .def(self * double())
        .def(self / double())
        .def(self == GfRange3d())
        .def(self != GfRange3d())
        .def(self == self)
        .def(self != self)
        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

        .def("GetCorner", &GfRange3f::GetCorner)
        .def("GetOctant", &GfRange3f::GetOctant)
        .def_readonly("unitCube", &GfRange3f::UnitCube)
        
        ;
    to_python_converter<std::vector<GfRange3f>,
        TfPySequenceToPython<std::vector<GfRange3f> > >();

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__);
    }
    if (!PyObject_HasAttrString(cls.ptr(), "__itruediv__")) {
        // __itruediv__ not added by .def( self /= double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division". This is also a workaround for a 
        // bug in the current version of pxr_boost::python that incorrectly wraps
        // in-place division with __idiv__ when building with python 3.
        cls.def("__itruediv__", __itruediv__, return_self<>());
    }

}
