/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_PERSONALIZATION_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_PERSONALIZATION_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_personalization_manager_v1 The treeland_personalization_manager_v1 protocol
 * @section page_ifaces_treeland_personalization_manager_v1 Interfaces
 * - @subpage page_iface_treeland_personalization_manager_v1 - personalization manager
 * - @subpage page_iface_treeland_personalization_wallpaper_context_v1 - client custom wallpaper context
 * - @subpage page_iface_treeland_personalization_cursor_context_v1 - client custom cursor context
 * - @subpage page_iface_treeland_personalization_window_context_v1 - client custom window context
 * - @subpage page_iface_treeland_personalization_font_context_v1 - treeland window global font settings
 * - @subpage page_iface_treeland_personalization_appearance_context_v1 - treeland window global appearance settings
 * @section page_copyright_treeland_personalization_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_personalization_appearance_context_v1;
struct treeland_personalization_cursor_context_v1;
struct treeland_personalization_font_context_v1;
struct treeland_personalization_manager_v1;
struct treeland_personalization_wallpaper_context_v1;
struct treeland_personalization_window_context_v1;
struct wl_surface;

#ifndef TREELAND_PERSONALIZATION_MANAGER_V1_INTERFACE
#define TREELAND_PERSONALIZATION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_manager_v1 treeland_personalization_manager_v1
 * @section page_iface_treeland_personalization_manager_v1_desc Description
 *
 * This interface allows a client to customized display effects.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_manager_v1_api API
 * See @ref iface_treeland_personalization_manager_v1.
 */
/**
 * @defgroup iface_treeland_personalization_manager_v1 The treeland_personalization_manager_v1 interface
 *
 * This interface allows a client to customized display effects.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_manager_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_wallpaper_context_v1 treeland_personalization_wallpaper_context_v1
 * @section page_iface_treeland_personalization_wallpaper_context_v1_desc Description
 *
 * This interface allows a client personalization wallpaper.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_wallpaper_context_v1_api API
 * See @ref iface_treeland_personalization_wallpaper_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_wallpaper_context_v1 The treeland_personalization_wallpaper_context_v1 interface
 *
 * This interface allows a client personalization wallpaper.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_wallpaper_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_cursor_context_v1 treeland_personalization_cursor_context_v1
 * @section page_iface_treeland_personalization_cursor_context_v1_desc Description
 *
 * This interface allows a client personalization cursor.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_cursor_context_v1_api API
 * See @ref iface_treeland_personalization_cursor_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_cursor_context_v1 The treeland_personalization_cursor_context_v1 interface
 *
 * This interface allows a client personalization cursor.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_cursor_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_window_context_v1 treeland_personalization_window_context_v1
 * @section page_iface_treeland_personalization_window_context_v1_desc Description
 *
 * This interface allows a client personalization window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_window_context_v1_api API
 * See @ref iface_treeland_personalization_window_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_window_context_v1 The treeland_personalization_window_context_v1 interface
 *
 * This interface allows a client personalization window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_window_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_font_context_v1 treeland_personalization_font_context_v1
 * @section page_iface_treeland_personalization_font_context_v1_desc Description
 *
 * This interface allows set treeland window global font settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_font_context_v1_api API
 * See @ref iface_treeland_personalization_font_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_font_context_v1 The treeland_personalization_font_context_v1 interface
 *
 * This interface allows set treeland window global font settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_font_context_v1_interface;
#endif
#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_INTERFACE
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_personalization_appearance_context_v1 treeland_personalization_appearance_context_v1
 * @section page_iface_treeland_personalization_appearance_context_v1_desc Description
 *
 * This interface allows set treeland window global appearance settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_personalization_appearance_context_v1_api API
 * See @ref iface_treeland_personalization_appearance_context_v1.
 */
/**
 * @defgroup iface_treeland_personalization_appearance_context_v1 The treeland_personalization_appearance_context_v1 interface
 *
 * This interface allows set treeland window global appearance settings.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_personalization_appearance_context_v1_interface;
#endif

/**
 * @ingroup iface_treeland_personalization_manager_v1
 * @struct treeland_personalization_manager_v1_interface
 */
struct treeland_personalization_manager_v1_interface {
	/**
	 * get personalization window context
	 *
	 * set window background, shadow based on context
	 */
	void (*get_window_context)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id,
				   struct wl_resource *surface);
	/**
	 * custom wallpaper context
	 *
	 * custom user wallpaper
	 */
	void (*get_wallpaper_context)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t id);
	/**
	 * custom wallpaper context
	 *
	 * custom user cursor
	 */
	void (*get_cursor_context)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id);
	/**
	 * custom treeland and window global font context
	 *
	 * custom treeland and window global font context
	 */
	void (*get_font_context)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id);
	/**
	 * custom treeland window global settings context
	 *
	 * custom user treeland window appearance global
	 */
	void (*get_appearance_context)(struct wl_client *client,
				       struct wl_resource *resource,
				       uint32_t id);
};


/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WINDOW_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_WALLPAPER_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_CURSOR_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_FONT_CONTEXT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_manager_v1
 */
#define TREELAND_PERSONALIZATION_MANAGER_V1_GET_APPEARANCE_CONTEXT_SINCE_VERSION 1

#ifndef TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * xdg desktop portal supported keys
 */
enum treeland_personalization_wallpaper_context_v1_options {
	/**
	 * whether to show a preview of the picture
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_PREVIEW = 1,
	/**
	 * configure screen background
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_BACKGROUND = 2,
	/**
	 * configure screen wallpaper
	 */
	TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_LOCKSCREEN = 4,
};
#endif /* TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM */

#ifndef TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM_IS_VALID
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * Validate a treeland_personalization_wallpaper_context_v1 options value.
 *
 * @return true on success, false on error.
 * @ref treeland_personalization_wallpaper_context_v1_options
 */
static inline bool
treeland_personalization_wallpaper_context_v1_options_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_PREVIEW:
		return version >= 1;
	case TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_BACKGROUND:
		return version >= 1;
	case TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_LOCKSCREEN:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_OPTIONS_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * @struct treeland_personalization_wallpaper_context_v1_interface
 */
struct treeland_personalization_wallpaper_context_v1_interface {
	/**
	 * set the current user's wallpaper fd
	 *
	 * 
	 * @param fd wallpaper file fd
	 * @param metadata file related metadata information
	 */
	void (*set_fd)(struct wl_client *client,
		       struct wl_resource *resource,
		       int32_t fd,
		       const char *metadata);
	/**
	 * identifier for the application window
	 *
	 * 
	 * @param identifier Identifier for the application window
	 */
	void (*set_identifier)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *identifier);
	/**
	 * configure xdg desktop portal options
	 *
	 * 
	 * @param output system output name
	 */
	void (*set_output)(struct wl_client *client,
			   struct wl_resource *resource,
			   const char *output);
	/**
	 * configure xdg desktop portal options
	 *
	 * 
	 * @param options xdg desktop portal options
	 */
	void (*set_on)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t options);
	/**
	 * Set whether the current wallpaper is dark
	 *
	 * 
	 * @param isdark is dark
	 */
	void (*set_isdark)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t isdark);
	/**
	 * commit configuration
	 *
	 * 
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * get user save meta data
	 *
	 * get the current user's wallpaper
	 */
	void (*get_metadata)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_METADATA 0

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_METADATA_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_FD_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_IDENTIFIER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ON_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_SET_ISDARK_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_GET_METADATA_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 */
#define TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_wallpaper_context_v1
 * Sends an metadata event to the client owning the resource.
 * @param resource_ The client's resource
 * @param metadata user meta data
 */
static inline void
treeland_personalization_wallpaper_context_v1_send_metadata(struct wl_resource *resource_, const char *metadata)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_WALLPAPER_CONTEXT_V1_METADATA, metadata);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 * @struct treeland_personalization_cursor_context_v1_interface
 */
struct treeland_personalization_cursor_context_v1_interface {
	/**
	 * set system cursor theme
	 *
	 * 
	 * @param name cursor theme name
	 */
	void (*set_theme)(struct wl_client *client,
			  struct wl_resource *resource,
			  const char *name);
	/**
	 * get system cursor theme
	 *
	 * 
	 */
	void (*get_theme)(struct wl_client *client,
			  struct wl_resource *resource);
	/**
	 * set system cursor size
	 *
	 * 
	 * @param size cursor size
	 */
	void (*set_size)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t size);
	/**
	 * get system cursor size
	 *
	 * 
	 */
	void (*get_size)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * commit configure
	 *
	 * if only one commit fails validation, the commit will fail
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_VERFITY 0
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_THEME 1
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SIZE 2

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_VERFITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_GET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 */
#define TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 * Sends an verfity event to the client owning the resource.
 * @param resource_ The client's resource
 * @param success check whether the configuration is successful
 */
static inline void
treeland_personalization_cursor_context_v1_send_verfity(struct wl_resource *resource_, int32_t success)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_VERFITY, success);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 * Sends an theme event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name cursor theme name
 */
static inline void
treeland_personalization_cursor_context_v1_send_theme(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_THEME, name);
}

/**
 * @ingroup iface_treeland_personalization_cursor_context_v1
 * Sends an size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param size cursor size
 */
static inline void
treeland_personalization_cursor_context_v1_send_size(struct wl_resource *resource_, uint32_t size)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_CURSOR_CONTEXT_V1_SIZE, size);
}

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * window blend mode
 *
 * Window blend mode defines how compositor composite window's surface over other
 * surfaces.
 */
enum treeland_personalization_window_context_v1_blend_mode {
	/**
	 * Normal blend mode, just composite over background with alpha channel
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_TRANSPARENT = 0,
	/**
	 * Composite window over wallpaper
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_WALLPAPER = 1,
	/**
	 * Blur the content of the window background
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_BLUR = 2,
};
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM */

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM_IS_VALID
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * Validate a treeland_personalization_window_context_v1 blend_mode value.
 *
 * @return true on success, false on error.
 * @ref treeland_personalization_window_context_v1_blend_mode
 */
static inline bool
treeland_personalization_window_context_v1_blend_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_TRANSPARENT:
		return version >= 1;
	case TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_WALLPAPER:
		return version >= 1;
	case TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_BLUR:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_BLEND_MODE_ENUM_IS_VALID */

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * window enable mode
 *
 * Set window enable mode
 */
enum treeland_personalization_window_context_v1_enable_mode {
	/**
	 * force enable titlebar
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENABLE = 0,
	/**
	 * force disable titlebar
	 */
	TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_DISABLE = 1,
};
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM */

#ifndef TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM_IS_VALID
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * Validate a treeland_personalization_window_context_v1 enable_mode value.
 *
 * @return true on success, false on error.
 * @ref treeland_personalization_window_context_v1_enable_mode
 */
static inline bool
treeland_personalization_window_context_v1_enable_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENABLE:
		return version >= 1;
	case TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_DISABLE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_ENABLE_MODE_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_personalization_window_context_v1
 * @struct treeland_personalization_window_context_v1_interface
 */
struct treeland_personalization_window_context_v1_interface {
	/**
	 * set window background blend mode
	 *
	 * Set window background blend mode
	 */
	void (*set_blend_mode)(struct wl_client *client,
			       struct wl_resource *resource,
			       int32_t mode);
	/**
	 * set window round corner radius
	 *
	 * This request will set window round corner radius, invoking
	 * this request means user want to manage window round corner
	 * radius by itself. If not invoked, window round corner radius
	 * will be decided by compositor.
	 */
	void (*set_round_corner_radius)(struct wl_client *client,
					struct wl_resource *resource,
					int32_t radius);
	/**
	 * set window shadow
	 *
	 * Set window shadow's radius, offset and color, invoking this
	 * request indicates that client want to manage the window shadow
	 * by itself. If not invoked, window shadow will be decided by the
	 * compositor
	 */
	void (*set_shadow)(struct wl_client *client,
			   struct wl_resource *resource,
			   int32_t radius,
			   int32_t offset_x,
			   int32_t offset_y,
			   int32_t r,
			   int32_t g,
			   int32_t b,
			   int32_t a);
	/**
	 * set window border
	 *
	 * Set window border width and color
	 */
	void (*set_border)(struct wl_client *client,
			   struct wl_resource *resource,
			   int32_t width,
			   int32_t r,
			   int32_t g,
			   int32_t b,
			   int32_t a);
	/**
	 * set if system titlebar is enabled
	 *
	 * Set if system titlebar is enabled
	 */
	void (*set_titlebar)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t mode);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BLEND_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_SHADOW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_BORDER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_SET_TITLEBAR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_window_context_v1
 */
#define TREELAND_PERSONALIZATION_WINDOW_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 * @struct treeland_personalization_font_context_v1_interface
 */
struct treeland_personalization_font_context_v1_interface {
	/**
	 * set system font size
	 *
	 * Set the system font size
	 * @param size font size
	 */
	void (*set_font_size)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t size);
	/**
	 * get system font size
	 *
	 * Get the system font size
	 */
	void (*get_font_size)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * set system font
	 *
	 * Set the system font
	 * @param font_name font name
	 */
	void (*set_font)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *font_name);
	/**
	 * get system font
	 *
	 * Get the system font
	 */
	void (*get_font)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * set system monospace font
	 *
	 * Set the system monospace font
	 * @param font_name monospace font name
	 */
	void (*set_monospace_font)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *font_name);
	/**
	 * get system monospace font
	 *
	 * Get the system monospace font
	 */
	void (*get_monospace_font)(struct wl_client *client,
				   struct wl_resource *resource);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT 0
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_MONOSPACE_FONT 1
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SIZE 2

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_SET_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_GET_MONOSPACE_FONT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_font_context_v1
 */
#define TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 * Sends an font event to the client owning the resource.
 * @param resource_ The client's resource
 * @param font_name font name
 */
static inline void
treeland_personalization_font_context_v1_send_font(struct wl_resource *resource_, const char *font_name)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT, font_name);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 * Sends an monospace_font event to the client owning the resource.
 * @param resource_ The client's resource
 * @param font_name monospace font name
 */
static inline void
treeland_personalization_font_context_v1_send_monospace_font(struct wl_resource *resource_, const char *font_name)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_MONOSPACE_FONT, font_name);
}

/**
 * @ingroup iface_treeland_personalization_font_context_v1
 * Sends an font_size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param font_size font size
 */
static inline void
treeland_personalization_font_context_v1_send_font_size(struct wl_resource *resource_, uint32_t font_size)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_FONT_CONTEXT_V1_FONT_SIZE, font_size);
}

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * window theme type
 */
enum treeland_personalization_appearance_context_v1_theme_type {
	/**
	 * window auto theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_AUTO = 1,
	/**
	 * window light theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_LIGHT = 2,
	/**
	 * window dark theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_DARK = 4,
};
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM */

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM_IS_VALID
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Validate a treeland_personalization_appearance_context_v1 theme_type value.
 *
 * @return true on success, false on error.
 * @ref treeland_personalization_appearance_context_v1_theme_type
 */
static inline bool
treeland_personalization_appearance_context_v1_theme_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_AUTO:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_LIGHT:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_DARK:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_THEME_TYPE_ENUM_IS_VALID */

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM
enum treeland_personalization_appearance_context_v1_error {
	/**
	 * Wrong round corner radius
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ROUND_CORNER_RADIUS = 0,
	/**
	 * Wrong icon theme
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ICON_THEME = 1,
	/**
	 * Wrong active color
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ACTIVE_COLOR = 2,
	/**
	 * Wrong window opacity
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_OPACITY = 4,
	/**
	 * Wrong theme type
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_THEME_TYPE = 8,
	/**
	 * Wrong window titlebar height
	 */
	TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_TITLEBAR_HEIGHT = 16,
};
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM */

#ifndef TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM_IS_VALID
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Validate a treeland_personalization_appearance_context_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_personalization_appearance_context_v1_error
 */
static inline bool
treeland_personalization_appearance_context_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ROUND_CORNER_RADIUS:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ICON_THEME:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_ACTIVE_COLOR:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_OPACITY:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_THEME_TYPE:
		return version >= 1;
	case TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_INVALID_WINDOW_TITLEBAR_HEIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * @struct treeland_personalization_appearance_context_v1_interface
 */
struct treeland_personalization_appearance_context_v1_interface {
	/**
	 * set window round corner radius
	 *
	 * Set window round corner radius
	 */
	void (*set_round_corner_radius)(struct wl_client *client,
					struct wl_resource *resource,
					int32_t radius);
	/**
	 * get window round corner radius
	 *
	 * Get window round corner radius
	 */
	void (*get_round_corner_radius)(struct wl_client *client,
					struct wl_resource *resource);
	/**
	 * set system icon theme
	 *
	 * Set the system icon theme
	 * @param theme icon theme
	 */
	void (*set_icon_theme)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *theme);
	/**
	 * get system icon theme
	 *
	 * Get the system icon theme
	 */
	void (*get_icon_theme)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * set system active color
	 *
	 * Set the system active color
	 * @param color rgb
	 */
	void (*set_active_color)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *color);
	/**
	 * get system active color
	 *
	 * Get the system active color
	 */
	void (*get_active_color)(struct wl_client *client,
				 struct wl_resource *resource);
	/**
	 * set window window opacity
	 *
	 * Set the window window opacity
	 * @param opacity opacity
	 */
	void (*set_window_opacity)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t opacity);
	/**
	 * get window window opacity
	 *
	 * Get the window window opacity
	 */
	void (*get_window_opacity)(struct wl_client *client,
				   struct wl_resource *resource);
	/**
	 * set window theme type
	 *
	 * Set the window theme.
	 * @param type window theme type
	 */
	void (*set_window_theme_type)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t type);
	/**
	 * get window theme type
	 *
	 * Get the window theme type
	 */
	void (*get_window_theme_type)(struct wl_client *client,
				      struct wl_resource *resource);
	/**
	 * set window titlebar height
	 *
	 * Set the window titlebar height
	 * @param height window titlebar height
	 */
	void (*set_window_titlebar_height)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t height);
	/**
	 * get window titlebar height
	 *
	 * Get the window titlebar height
	 */
	void (*get_window_titlebar_height)(struct wl_client *client,
					   struct wl_resource *resource);
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ROUND_CORNER_RADIUS 0
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ICON_THEME 1
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ACTIVE_COLOR 2
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_OPACITY 3
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_THEME_TYPE 4
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_TITLEBAR_HEIGHT 5

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ROUND_CORNER_RADIUS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ICON_THEME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_ACTIVE_COLOR_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_THEME_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_SET_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_GET_WINDOW_TITLEBAR_HEIGHT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 */
#define TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an round_corner_radius event to the client owning the resource.
 * @param resource_ The client's resource
 * @param radius round corner radius
 */
static inline void
treeland_personalization_appearance_context_v1_send_round_corner_radius(struct wl_resource *resource_, int32_t radius)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ROUND_CORNER_RADIUS, radius);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an icon_theme event to the client owning the resource.
 * @param resource_ The client's resource
 * @param theme_name icon theme name
 */
static inline void
treeland_personalization_appearance_context_v1_send_icon_theme(struct wl_resource *resource_, const char *theme_name)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ICON_THEME, theme_name);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an active_color event to the client owning the resource.
 * @param resource_ The client's resource
 * @param active_color active color
 */
static inline void
treeland_personalization_appearance_context_v1_send_active_color(struct wl_resource *resource_, const char *active_color)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_ACTIVE_COLOR, active_color);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an window_opacity event to the client owning the resource.
 * @param resource_ The client's resource
 * @param opacity window opacity
 */
static inline void
treeland_personalization_appearance_context_v1_send_window_opacity(struct wl_resource *resource_, uint32_t opacity)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_OPACITY, opacity);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an window_theme_type event to the client owning the resource.
 * @param resource_ The client's resource
 * @param type window theme type
 */
static inline void
treeland_personalization_appearance_context_v1_send_window_theme_type(struct wl_resource *resource_, uint32_t type)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_THEME_TYPE, type);
}

/**
 * @ingroup iface_treeland_personalization_appearance_context_v1
 * Sends an window_titlebar_height event to the client owning the resource.
 * @param resource_ The client's resource
 * @param height window titlebar height
 */
static inline void
treeland_personalization_appearance_context_v1_send_window_titlebar_height(struct wl_resource *resource_, uint32_t height)
{
	wl_resource_post_event(resource_, TREELAND_PERSONALIZATION_APPEARANCE_CONTEXT_V1_WINDOW_TITLEBAR_HEIGHT, height);
}

#ifdef  __cplusplus
}
#endif

#endif
