/* AppConsole.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppConsole.vala, do not modify */

/*
 * AppConsole.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <errno.h>

#define AppName "Timeshift"
#define AppShortName "timeshift"
#define CONSTANTS_VERSION "25.12.2"
#define AppVersion CONSTANTS_VERSION
#define AppAuthor "Tony George"
#define AppAuthorEmail "teejeetech@gmail.com"
#define GETTEXT_PACKAGE ""
#define LOCALE_DIR "/usr/share/locale"
#define TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT 60
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;

#define TYPE_APP_CONSOLE (app_console_get_type ())
#define APP_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_CONSOLE, AppConsole))
#define APP_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_CONSOLE, AppConsoleClass))
#define IS_APP_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_CONSOLE))
#define IS_APP_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_CONSOLE))
#define APP_CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_CONSOLE, AppConsoleClass))

typedef struct _AppConsole AppConsole;
typedef struct _AppConsoleClass AppConsoleClass;
typedef struct _AppConsolePrivate AppConsolePrivate;
enum  {
	APP_CONSOLE_0_PROPERTY,
	APP_CONSOLE_NUM_PROPERTIES
};
static GParamSpec* app_console_properties[APP_CONSOLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
typedef struct _DevicePrivate DevicePrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _MountEntryPrivate MountEntryPrivate;

#define TYPE_TIMEOUT_COUNTER (timeout_counter_get_type ())
#define TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounter))
#define TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))
#define IS_TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMEOUT_COUNTER))
#define IS_TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMEOUT_COUNTER))
#define TIMEOUT_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))

typedef struct _TimeoutCounter TimeoutCounter;
typedef struct _TimeoutCounterClass TimeoutCounterClass;

struct _AppConsole {
	GObject parent_instance;
	AppConsolePrivate * priv;
	gint snapshot_list_start_index;
};

struct _AppConsoleClass {
	GObjectClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _MountEntry {
	GObject parent_instance;
	MountEntryPrivate * priv;
	Device* device;
	gchar* mount_point;
	gchar* mount_options;
};

struct _MountEntryClass {
	GObjectClass parent_class;
};

VALA_EXTERN Main* App;
Main* App = NULL;
static gpointer app_console_parent_class = NULL;
VALA_EXTERN gboolean tee_jee_logging_LOG_TIMESTAMP;
VALA_EXTERN gboolean tee_jee_logging_LOG_ENABLE;
VALA_EXTERN gboolean tee_jee_logging_LOG_DEBUG;
VALA_EXTERN gboolean tee_jee_logging_LOG_COMMANDS;

VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
void exit (gint exit_code);
VALA_EXTERN GType app_console_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppConsole, g_object_unref)
static gint app_console_main (gchar** args,
                       gint args_length1);
static void app_console_set_locale (void);
static gchar* app_console_help_message (void);
static gchar* app_console_version_message (void);
VALA_EXTERN void main_setup_env (void);
VALA_EXTERN void tee_jee_process_helper_init_tmp (void);
VALA_EXTERN void app_console_check_if_admin (void);
VALA_EXTERN Main* main_new (gchar** args,
                gint args_length1,
                gboolean gui_mode);
VALA_EXTERN Main* main_construct (GType object_type,
                      gchar** args,
                      gint args_length1,
                      gboolean gui_mode);
static void app_console_parse_arguments (gchar** args,
                                  gint args_length1);
VALA_EXTERN void main_initialize (Main* self);
VALA_EXTERN AppConsole* app_console_new (void);
VALA_EXTERN AppConsole* app_console_construct (GType object_type);
VALA_EXTERN gboolean app_console_start_application (AppConsole* self);
VALA_EXTERN void main_exit_app (Main* self,
                    gint exit_code);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gboolean tee_jee_system_user_is_admin (void);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN void main_validate_cmd_tags (Main* self);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gboolean main_live_system (Main* self);
static gboolean app_console_create_snapshot (AppConsole* self,
                                      gboolean ondemand);
static gboolean app_console_restore_snapshot (AppConsole* self);
VALA_EXTERN gboolean app_console_delete_snapshot (AppConsole* self);
VALA_EXTERN gboolean app_console_delete_all_snapshots (AppConsole* self);
VALA_EXTERN void snapshot_repo_print_status (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_has_snapshots (SnapshotRepo* self);
static void app_console_list_snapshots (AppConsole* self,
                                 gboolean paginate,
                                 gint page_size);
static GeeArrayList* app_console_list_all_devices (AppConsole* self);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN gchar* snapshot_get_taglist_short (Snapshot* self);
static void app_console_print_grid (AppConsole* self,
                             gchar** grid,
                             gint grid_length1,
                             gint grid_length2,
                             gboolean* right_align,
                             gint right_align_length1,
                             gboolean has_header);
static void app_console_list_devices (AppConsole* self,
                               GeeArrayList* device_list);
VALA_EXTERN gchar* device_get_device_name_with_parent (Device* self);
VALA_EXTERN gchar* device_get_size (Device* self);
VALA_EXTERN GeeArrayList* device_get_block_devices_using_lsblk (const gchar* dev_name);
VALA_EXTERN gboolean device_has_linux_filesystem (Device* self);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
static GeeArrayList* app_console_list_grub_devices (AppConsole* self,
                                             gboolean print_to_console);
VALA_EXTERN gchar* device_get_short_name_with_alias (Device* self);
static void app_console_select_snapshot_device (AppConsole* self,
                                         gboolean prompt_if_empty);
VALA_EXTERN gboolean main_create_snapshot (Main* self,
                               gboolean is_ondemand,
                               GtkWindow* parent_win);
static void app_console_select_snapshot_for_restore (AppConsole* self);
static void app_console_init_mounts (AppConsole* self);
static void app_console_map_devices (AppConsole* self);
static void app_console_select_grub_device (AppConsole* self);
static void app_console_confirm_restore (AppConsole* self);
VALA_EXTERN gboolean main_mount_target_devices (Main* self,
                                    GtkWindow* parent_win);
VALA_EXTERN gboolean main_restore_snapshot (Main* self,
                                GtkWindow* parent_win);
static Device* app_console_read_stdin_device (AppConsole* self,
                                       GeeArrayList* device_list,
                                       const gchar* device_default);
VALA_EXTERN gboolean main_check_device_for_backup (Main* self,
                                       Device* dev,
                                       gboolean unlock);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_device (Device* dev,
                                             GtkWindow* parent_win,
                                             gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_device (GType object_type,
                                                   Device* dev,
                                                   GtkWindow* parent_win,
                                                   gboolean btrfs_repo);
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
static Snapshot* app_console_select_snapshot (AppConsole* self);
static Snapshot* app_console_read_stdin_snapshot (AppConsole* self);
static void app_console_select_snapshot_for_deletion (AppConsole* self);
VALA_EXTERN void main_init_mount_list (Main* self);
VALA_EXTERN void main_set_dst_root (Main* self,
                        Device* value);
VALA_EXTERN Device* main_get_dst_root (Main* self);
VALA_EXTERN Device* device_get_device_by_name (const gchar* file_name);
static Device* app_console_read_stdin_device_mounts (AppConsole* self,
                                              GeeArrayList* device_list,
                                              MountEntry* mnt);
static gboolean app_console_read_stdin_grub_install (AppConsole* self,
                                              gboolean reinstall_default);
VALA_EXTERN void main_get_restore_messages (Main* self,
                                gboolean formatted,
                                gchar** msg_devices,
                                gchar** msg_reboot,
                                gchar** msg_disclaimer);
static gboolean app_console_read_stdin_restore_confirm (AppConsole* self);
VALA_EXTERN GType timeout_counter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeoutCounter, g_object_unref)
VALA_EXTERN TimeoutCounter* timeout_counter_new (void);
VALA_EXTERN TimeoutCounter* timeout_counter_construct (GType object_type);
VALA_EXTERN void timeout_counter_exit_on_timeout (TimeoutCounter* self,
                                      gint seconds_to_wait);
VALA_EXTERN void timeout_counter_stop (TimeoutCounter* self);
static Device* app_console_get_device_from_index (AppConsole* self,
                                           GeeArrayList* device_list,
                                           const gchar* index_string);
VALA_EXTERN gboolean snapshot_remove (Snapshot* self,
                          gboolean wait);
static void app_console_finalize (GObject * obj);
static GType app_console_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gint
app_console_main (gchar** args,
                  gint args_length1)
{
	Main* _tmp14_;
	Main* _tmp15_;
	AppConsole* console = NULL;
	AppConsole* _tmp16_;
	gboolean ok = FALSE;
	AppConsole* _tmp17_;
	gint _tmp18_ = 0;
	Main* _tmp19_;
	gint _tmp20_ = 0;
	gint result;
	app_console_set_locale ();
	tee_jee_logging_LOG_TIMESTAMP = FALSE;
	if (args_length1 > 1) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GQuark _tmp4_ = 0U;
		static GQuark _tmp3_label0 = 0;
		static GQuark _tmp3_label1 = 0;
		static GQuark _tmp3_label2 = 0;
		_tmp0_ = args[1];
		_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
		_tmp2_ = _tmp1_;
		_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
		g_free (_tmp2_);
		if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("--help")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("-h"))))) {
			switch (0) {
				default:
				{
					FILE* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp5_ = stdout;
					_tmp6_ = app_console_help_message ();
					_tmp7_ = _tmp6_;
					fprintf (_tmp5_, "%s", _tmp7_);
					_g_free0 (_tmp7_);
					result = 0;
					return result;
				}
			}
		} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("--version")))) {
			switch (0) {
				default:
				{
					FILE* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = stdout;
					_tmp9_ = app_console_version_message ();
					_tmp10_ = _tmp9_;
					fprintf (_tmp8_, "%s", _tmp10_);
					_g_free0 (_tmp10_);
					result = 0;
					return result;
				}
			}
		}
	} else {
		if (args_length1 == 1) {
			FILE* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = stdout;
			_tmp12_ = app_console_help_message ();
			_tmp13_ = _tmp12_;
			fprintf (_tmp11_, "%s", _tmp13_);
			_g_free0 (_tmp13_);
			result = 0;
			return result;
		}
	}
	main_setup_env ();
	tee_jee_logging_LOG_ENABLE = FALSE;
	tee_jee_process_helper_init_tmp ();
	tee_jee_logging_LOG_ENABLE = TRUE;
	app_console_check_if_admin ();
	_tmp14_ = main_new (args, args_length1, FALSE);
	_g_object_unref0 (App);
	App = _tmp14_;
	app_console_parse_arguments (args, (gint) args_length1);
	_tmp15_ = App;
	main_initialize (_tmp15_);
	_tmp16_ = app_console_new ();
	console = _tmp16_;
	_tmp17_ = console;
	ok = app_console_start_application (_tmp17_);
	if (ok) {
		_tmp18_ = 0;
	} else {
		_tmp18_ = 1;
	}
	_tmp19_ = App;
	main_exit_app (_tmp19_, _tmp18_);
	if (ok) {
		_tmp20_ = 0;
	} else {
		_tmp20_ = 1;
	}
	result = _tmp20_;
	_g_object_unref0 (console);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return app_console_main (argv, argc);
}

static void
app_console_set_locale (void)
{
	tee_jee_logging_log_debug ("setting locale...");
	setlocale (LC_MESSAGES, "timeshift");
	textdomain (GETTEXT_PACKAGE);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "utf-8");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
}

void
app_console_check_if_admin (void)
{
	if (!tee_jee_system_user_is_admin ()) {
		tee_jee_logging_log_msg (_ ("Application needs admin access."), FALSE);
		tee_jee_logging_log_msg (_ ("Please run the application as admin (using 'sudo' or 'su')"), FALSE);
		exit (1);
	}
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
app_console_parse_arguments (gchar** args,
                             gint args_length1)
{
	tee_jee_logging_log_debug ("AppConsole: parse_arguments()");
	{
		gint k = 0;
		k = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				GQuark _tmp6_ = 0U;
				static GQuark _tmp5_label0 = 0;
				static GQuark _tmp5_label1 = 0;
				static GQuark _tmp5_label2 = 0;
				static GQuark _tmp5_label3 = 0;
				static GQuark _tmp5_label4 = 0;
				static GQuark _tmp5_label5 = 0;
				static GQuark _tmp5_label6 = 0;
				static GQuark _tmp5_label7 = 0;
				static GQuark _tmp5_label8 = 0;
				static GQuark _tmp5_label9 = 0;
				static GQuark _tmp5_label10 = 0;
				static GQuark _tmp5_label11 = 0;
				static GQuark _tmp5_label12 = 0;
				static GQuark _tmp5_label13 = 0;
				static GQuark _tmp5_label14 = 0;
				static GQuark _tmp5_label15 = 0;
				static GQuark _tmp5_label16 = 0;
				static GQuark _tmp5_label17 = 0;
				static GQuark _tmp5_label18 = 0;
				static GQuark _tmp5_label19 = 0;
				static GQuark _tmp5_label20 = 0;
				static GQuark _tmp5_label21 = 0;
				static GQuark _tmp5_label22 = 0;
				static GQuark _tmp5_label23 = 0;
				static GQuark _tmp5_label24 = 0;
				static GQuark _tmp5_label25 = 0;
				static GQuark _tmp5_label26 = 0;
				static GQuark _tmp5_label27 = 0;
				static GQuark _tmp5_label28 = 0;
				static GQuark _tmp5_label29 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = k;
					k = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(k < args_length1)) {
					break;
				}
				_tmp2_ = args[k];
				_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
				_tmp4_ = _tmp3_;
				_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
				g_free (_tmp4_);
				if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("--check")))) {
					switch (0) {
						default:
						{
							Main* _tmp7_;
							gchar* _tmp8_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp7_ = App;
							_tmp8_ = g_strdup ("backup");
							_g_free0 (_tmp7_->app_mode);
							_tmp7_->app_mode = _tmp8_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("--delete")))) {
					switch (0) {
						default:
						{
							Main* _tmp9_;
							gchar* _tmp10_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp9_ = App;
							_tmp10_ = g_strdup ("delete");
							_g_free0 (_tmp9_->app_mode);
							_tmp9_->app_mode = _tmp10_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("--delete-all")))) {
					switch (0) {
						default:
						{
							Main* _tmp11_;
							gchar* _tmp12_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp11_ = App;
							_tmp12_ = g_strdup ("delete-all");
							_g_free0 (_tmp11_->app_mode);
							_tmp11_->app_mode = _tmp12_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("--restore")))) {
					switch (0) {
						default:
						{
							Main* _tmp13_;
							Main* _tmp14_;
							gchar* _tmp15_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp13_ = App;
							_tmp13_->mirror_system = FALSE;
							_tmp14_ = App;
							_tmp15_ = g_strdup ("restore");
							_g_free0 (_tmp14_->app_mode);
							_tmp14_->app_mode = _tmp15_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("--clone")))) {
					switch (0) {
						default:
						{
							Main* _tmp16_;
							Main* _tmp17_;
							gchar* _tmp18_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp16_ = App;
							_tmp16_->mirror_system = TRUE;
							_tmp17_ = App;
							_tmp18_ = g_strdup ("restore");
							_g_free0 (_tmp17_->app_mode);
							_tmp17_->app_mode = _tmp18_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("--create")))) {
					switch (0) {
						default:
						{
							Main* _tmp19_;
							gchar* _tmp20_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							_tmp19_ = App;
							_tmp20_ = g_strdup ("ondemand");
							_g_free0 (_tmp19_->app_mode);
							_tmp19_->app_mode = _tmp20_;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("--comment")))) || (_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("--comments"))))) {
					switch (0) {
						default:
						{
							Main* _tmp21_;
							gint _tmp22_;
							const gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp21_ = App;
							k = k + 1;
							_tmp22_ = k;
							_tmp23_ = args[_tmp22_];
							_tmp24_ = g_strdup (_tmp23_);
							_g_free0 (_tmp21_->cmd_comments);
							_tmp21_->cmd_comments = _tmp24_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label8) ? _tmp5_label8 : (_tmp5_label8 = g_quark_from_static_string ("--skip-grub")))) {
					switch (0) {
						default:
						{
							Main* _tmp25_;
							_tmp25_ = App;
							_tmp25_->cmd_skip_grub = TRUE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label9) ? _tmp5_label9 : (_tmp5_label9 = g_quark_from_static_string ("--verbose")))) {
					switch (0) {
						default:
						{
							Main* _tmp26_;
							_tmp26_ = App;
							_tmp26_->cmd_verbose = TRUE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label10) ? _tmp5_label10 : (_tmp5_label10 = g_quark_from_static_string ("--quiet")))) {
					switch (0) {
						default:
						{
							Main* _tmp27_;
							_tmp27_ = App;
							_tmp27_->cmd_verbose = FALSE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label11) ? _tmp5_label11 : (_tmp5_label11 = g_quark_from_static_string ("--scripted")))) {
					switch (0) {
						default:
						{
							Main* _tmp28_;
							Main* _tmp29_;
							_tmp28_ = App;
							_tmp28_->cmd_scripted = TRUE;
							_tmp29_ = App;
							_tmp29_->cmd_confirm = TRUE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label12) ? _tmp5_label12 : (_tmp5_label12 = g_quark_from_static_string ("--yes")))) {
					switch (0) {
						default:
						{
							Main* _tmp30_;
							_tmp30_ = App;
							_tmp30_->cmd_confirm = TRUE;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label13) ? _tmp5_label13 : (_tmp5_label13 = g_quark_from_static_string ("--grub")))) || (_tmp6_ == ((0 != _tmp5_label14) ? _tmp5_label14 : (_tmp5_label14 = g_quark_from_static_string ("--grub-device"))))) {
					switch (0) {
						default:
						{
							Main* _tmp31_;
							Main* _tmp32_;
							gint _tmp33_;
							const gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp31_ = App;
							_tmp31_->reinstall_grub2 = TRUE;
							_tmp32_ = App;
							k = k + 1;
							_tmp33_ = k;
							_tmp34_ = args[_tmp33_];
							_tmp35_ = g_strdup (_tmp34_);
							_g_free0 (_tmp32_->cmd_grub_device);
							_tmp32_->cmd_grub_device = _tmp35_;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label15) ? _tmp5_label15 : (_tmp5_label15 = g_quark_from_static_string ("--target")))) || (_tmp6_ == ((0 != _tmp5_label16) ? _tmp5_label16 : (_tmp5_label16 = g_quark_from_static_string ("--target-device"))))) {
					switch (0) {
						default:
						{
							Main* _tmp36_;
							gint _tmp37_;
							const gchar* _tmp38_;
							gchar* _tmp39_;
							_tmp36_ = App;
							k = k + 1;
							_tmp37_ = k;
							_tmp38_ = args[_tmp37_];
							_tmp39_ = g_strdup (_tmp38_);
							_g_free0 (_tmp36_->cmd_target_device);
							_tmp36_->cmd_target_device = _tmp39_;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label17) ? _tmp5_label17 : (_tmp5_label17 = g_quark_from_static_string ("--backup-device")))) || (_tmp6_ == ((0 != _tmp5_label18) ? _tmp5_label18 : (_tmp5_label18 = g_quark_from_static_string ("--snapshot-device"))))) {
					switch (0) {
						default:
						{
							Main* _tmp40_;
							gint _tmp41_;
							const gchar* _tmp42_;
							gchar* _tmp43_;
							_tmp40_ = App;
							k = k + 1;
							_tmp41_ = k;
							_tmp42_ = args[_tmp41_];
							_tmp43_ = g_strdup (_tmp42_);
							_g_free0 (_tmp40_->cmd_backup_device);
							_tmp40_->cmd_backup_device = _tmp43_;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label19) ? _tmp5_label19 : (_tmp5_label19 = g_quark_from_static_string ("--snapshot")))) || (_tmp6_ == ((0 != _tmp5_label20) ? _tmp5_label20 : (_tmp5_label20 = g_quark_from_static_string ("--snapshot-name"))))) {
					switch (0) {
						default:
						{
							Main* _tmp44_;
							gint _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp44_ = App;
							k = k + 1;
							_tmp45_ = k;
							_tmp46_ = args[_tmp45_];
							_tmp47_ = g_strdup (_tmp46_);
							_g_free0 (_tmp44_->cmd_snapshot);
							_tmp44_->cmd_snapshot = _tmp47_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label21) ? _tmp5_label21 : (_tmp5_label21 = g_quark_from_static_string ("--tags")))) {
					switch (0) {
						default:
						{
							Main* _tmp48_;
							gint _tmp49_;
							const gchar* _tmp50_;
							gchar* _tmp51_;
							Main* _tmp52_;
							_tmp48_ = App;
							k = k + 1;
							_tmp49_ = k;
							_tmp50_ = args[_tmp49_];
							_tmp51_ = g_strdup (_tmp50_);
							_g_free0 (_tmp48_->cmd_tags);
							_tmp48_->cmd_tags = _tmp51_;
							_tmp52_ = App;
							main_validate_cmd_tags (_tmp52_);
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label22) ? _tmp5_label22 : (_tmp5_label22 = g_quark_from_static_string ("--debug")))) {
					switch (0) {
						default:
						{
							tee_jee_logging_LOG_COMMANDS = TRUE;
							tee_jee_logging_LOG_DEBUG = TRUE;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label23) ? _tmp5_label23 : (_tmp5_label23 = g_quark_from_static_string ("--list")))) || (_tmp6_ == ((0 != _tmp5_label24) ? _tmp5_label24 : (_tmp5_label24 = g_quark_from_static_string ("--list-snapshots"))))) {
					switch (0) {
						default:
						{
							Main* _tmp53_;
							gchar* _tmp54_;
							_tmp53_ = App;
							_tmp54_ = g_strdup ("list-snapshots");
							_g_free0 (_tmp53_->app_mode);
							_tmp53_->app_mode = _tmp54_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label25) ? _tmp5_label25 : (_tmp5_label25 = g_quark_from_static_string ("--list-devices")))) {
					switch (0) {
						default:
						{
							Main* _tmp55_;
							gchar* _tmp56_;
							_tmp55_ = App;
							_tmp56_ = g_strdup ("list-devices");
							_g_free0 (_tmp55_->app_mode);
							_tmp55_->app_mode = _tmp56_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							tee_jee_logging_LOG_DEBUG = FALSE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label26) ? _tmp5_label26 : (_tmp5_label26 = g_quark_from_static_string ("--btrfs")))) {
					switch (0) {
						default:
						{
							Main* _tmp57_;
							Main* _tmp58_;
							gboolean _tmp59_;
							gboolean* _tmp60_;
							_tmp57_ = App;
							_tmp57_->btrfs_mode = TRUE;
							_tmp58_ = App;
							_tmp59_ = TRUE;
							_tmp60_ = __bool_dup0 (&_tmp59_);
							_g_free0 (_tmp58_->cmd_btrfs_mode);
							_tmp58_->cmd_btrfs_mode = _tmp60_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label27) ? _tmp5_label27 : (_tmp5_label27 = g_quark_from_static_string ("--rsync")))) {
					switch (0) {
						default:
						{
							Main* _tmp61_;
							Main* _tmp62_;
							gboolean _tmp63_;
							gboolean* _tmp64_;
							_tmp61_ = App;
							_tmp61_->btrfs_mode = FALSE;
							_tmp62_ = App;
							_tmp63_ = FALSE;
							_tmp64_ = __bool_dup0 (&_tmp63_);
							_g_free0 (_tmp62_->cmd_btrfs_mode);
							_tmp62_->cmd_btrfs_mode = _tmp64_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label28) ? _tmp5_label28 : (_tmp5_label28 = g_quark_from_static_string ("--backup")))) {
					switch (0) {
						default:
						{
							Main* _tmp65_;
							tee_jee_logging_log_error ("Option --backup has been replaced by option --check", FALSE, FALSE);
							tee_jee_logging_log_error ("Run 'timeshift --help' to list all available options", FALSE, FALSE);
							_tmp65_ = App;
							main_exit_app (_tmp65_, 1);
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label29) ? _tmp5_label29 : (_tmp5_label29 = g_quark_from_static_string ("--backup-now")))) {
					switch (0) {
						default:
						{
							Main* _tmp66_;
							tee_jee_logging_log_error ("Option --backup-now has been replaced by option --create", FALSE, FALSE);
							tee_jee_logging_log_error ("Run 'timeshift --help' to list all available options", FALSE, FALSE);
							_tmp66_ = App;
							main_exit_app (_tmp66_, 1);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							Main* _tmp72_;
							tee_jee_logging_LOG_TIMESTAMP = FALSE;
							_tmp67_ = args[k];
							_tmp68_ = g_strdup_printf ("%s: %s", _ ("Invalid command line arguments"), _tmp67_);
							_tmp69_ = _tmp68_;
							tee_jee_logging_log_error (_tmp69_, TRUE, FALSE);
							_g_free0 (_tmp69_);
							_tmp70_ = app_console_help_message ();
							_tmp71_ = _tmp70_;
							tee_jee_logging_log_msg (_tmp71_, FALSE);
							_g_free0 (_tmp71_);
							_tmp72_ = App;
							main_exit_app (_tmp72_, 1);
							break;
						}
					}
				}
			}
		}
	}
}

gboolean
app_console_start_application (AppConsole* self)
{
	gboolean is_success = FALSE;
	Main* _tmp0_;
	Main* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	static GQuark _tmp9_label1 = 0;
	static GQuark _tmp9_label2 = 0;
	static GQuark _tmp9_label3 = 0;
	static GQuark _tmp9_label4 = 0;
	static GQuark _tmp9_label5 = 0;
	static GQuark _tmp9_label6 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("AppConsole: start_application()");
	is_success = TRUE;
	_tmp0_ = App;
	if (main_live_system (_tmp0_)) {
		Main* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GQuark _tmp5_ = 0U;
		static GQuark _tmp4_label0 = 0;
		static GQuark _tmp4_label1 = 0;
		_tmp1_ = App;
		_tmp2_ = _tmp1_->app_mode;
		_tmp3_ = _tmp2_;
		_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
		if ((_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("backup")))) || (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("ondemand"))))) {
			switch (0) {
				default:
				{
					tee_jee_logging_log_error (_ ("Snapshots cannot be created in Live CD mode"), FALSE, FALSE);
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp6_ = App;
	_tmp7_ = _tmp6_->app_mode;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("backup")))) {
		switch (0) {
			default:
			{
				is_success = app_console_create_snapshot (self, FALSE);
				result = is_success;
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("restore")))) {
		switch (0) {
			default:
			{
				is_success = app_console_restore_snapshot (self);
				result = is_success;
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("delete")))) {
		switch (0) {
			default:
			{
				is_success = app_console_delete_snapshot (self);
				result = is_success;
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("delete-all")))) {
		switch (0) {
			default:
			{
				is_success = app_console_delete_all_snapshots (self);
				result = is_success;
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("ondemand")))) {
		switch (0) {
			default:
			{
				is_success = app_console_create_snapshot (self, TRUE);
				result = is_success;
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("list-snapshots")))) {
		switch (0) {
			default:
			{
				Main* _tmp11_;
				SnapshotRepo* _tmp12_;
				Main* _tmp13_;
				SnapshotRepo* _tmp14_;
				tee_jee_logging_LOG_ENABLE = TRUE;
				_tmp11_ = App;
				_tmp12_ = _tmp11_->repo;
				snapshot_repo_print_status (_tmp12_);
				_tmp13_ = App;
				_tmp14_ = _tmp13_->repo;
				if (snapshot_repo_has_snapshots (_tmp14_)) {
					app_console_list_snapshots (self, FALSE, 20);
					tee_jee_logging_log_msg ("", FALSE);
					result = TRUE;
					return result;
				} else {
					tee_jee_logging_log_msg (_ ("No snapshots found"), FALSE);
					result = FALSE;
					return result;
				}
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("list-devices")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GeeArrayList* _tmp19_;
				GeeArrayList* _tmp20_;
				tee_jee_logging_LOG_ENABLE = TRUE;
				_tmp15_ = g_strconcat ("\n", _ ("Devices with Linux file systems"), NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp16_, ":\n", NULL);
				_tmp18_ = _tmp17_;
				tee_jee_logging_log_msg (_tmp18_, FALSE);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_tmp19_ = app_console_list_all_devices (self);
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp20_);
				tee_jee_logging_log_msg ("", FALSE);
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	}
}

static gchar*
app_console_version_message (void)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%s %s\n", AppName, AppVersion);
	msg = _tmp0_;
	result = msg;
	return result;
}

static gchar*
app_console_help_message (void)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	const gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	const gchar* _tmp125_;
	gchar* _tmp126_;
	const gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	const gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	const gchar* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	const gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	const gchar* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	gchar* _tmp153_;
	gchar* _tmp154_;
	const gchar* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	const gchar* _tmp161_;
	gchar* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	const gchar* _tmp167_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	const gchar* _tmp173_;
	gchar* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	gchar* _tmp177_;
	gchar* _tmp178_;
	const gchar* _tmp179_;
	gchar* _tmp180_;
	gchar* _tmp181_;
	gchar* _tmp182_;
	gchar* _tmp183_;
	gchar* _tmp184_;
	const gchar* _tmp185_;
	gchar* _tmp186_;
	gchar* _tmp187_;
	gchar* _tmp188_;
	gchar* _tmp189_;
	gchar* _tmp190_;
	const gchar* _tmp191_;
	gchar* _tmp192_;
	const gchar* _tmp193_;
	gchar* _tmp194_;
	gchar* _tmp195_;
	gchar* _tmp196_;
	const gchar* _tmp197_;
	gchar* _tmp198_;
	const gchar* _tmp199_;
	gchar* _tmp200_;
	const gchar* _tmp201_;
	gchar* _tmp202_;
	const gchar* _tmp203_;
	gchar* _tmp204_;
	const gchar* _tmp205_;
	gchar* _tmp206_;
	const gchar* _tmp207_;
	gchar* _tmp208_;
	const gchar* _tmp209_;
	gchar* _tmp210_;
	const gchar* _tmp211_;
	gchar* _tmp212_;
	const gchar* _tmp213_;
	gchar* _tmp214_;
	const gchar* _tmp215_;
	gchar* _tmp216_;
	gchar* _tmp217_;
	gchar* _tmp218_;
	const gchar* _tmp219_;
	gchar* _tmp220_;
	const gchar* _tmp221_;
	gchar* _tmp222_;
	const gchar* _tmp223_;
	gchar* _tmp224_;
	const gchar* _tmp225_;
	gchar* _tmp226_;
	const gchar* _tmp227_;
	gchar* _tmp228_;
	const gchar* _tmp229_;
	gchar* _tmp230_;
	const gchar* _tmp231_;
	gchar* _tmp232_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("\n%s v%s by Tony George (%s)\n", AppName, AppVersion, AppAuthorEmail);
	msg = _tmp0_;
	_tmp1_ = msg;
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp2_;
	_tmp3_ = msg;
	_tmp4_ = g_strconcat (_tmp3_, "Syntax:\n", NULL);
	_g_free0 (msg);
	msg = _tmp4_;
	_tmp5_ = msg;
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp6_;
	_tmp7_ = msg;
	_tmp8_ = g_strconcat (_tmp7_, "  timeshift --check\n", NULL);
	_g_free0 (msg);
	msg = _tmp8_;
	_tmp9_ = msg;
	_tmp10_ = g_strconcat (_tmp9_, "  timeshift --create [OPTIONS]\n", NULL);
	_g_free0 (msg);
	msg = _tmp10_;
	_tmp11_ = msg;
	_tmp12_ = g_strconcat (_tmp11_, "  timeshift --restore [OPTIONS]\n", NULL);
	_g_free0 (msg);
	msg = _tmp12_;
	_tmp13_ = msg;
	_tmp14_ = g_strconcat (_tmp13_, "  timeshift --delete-[all] [OPTIONS]\n", NULL);
	_g_free0 (msg);
	msg = _tmp14_;
	_tmp15_ = msg;
	_tmp16_ = g_strconcat (_tmp15_, "  timeshift --list-{snapshots|devices} [OPTIONS]\n", NULL);
	_g_free0 (msg);
	msg = _tmp16_;
	_tmp17_ = msg;
	_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp18_;
	_tmp19_ = msg;
	_tmp20_ = g_strconcat (_ ("Options"), ":\n", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
	_g_free0 (msg);
	msg = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp23_ = msg;
	_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp24_;
	_tmp25_ = msg;
	_tmp26_ = g_strconcat (_ ("List"), ":\n", NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
	_g_free0 (msg);
	msg = _tmp28_;
	_g_free0 (_tmp27_);
	_tmp29_ = msg;
	_tmp30_ = g_strconcat ("  --list[-snapshots]         ", _ ("List snapshots"), NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
	_g_free0 (msg);
	msg = _tmp34_;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp35_ = msg;
	_tmp36_ = g_strconcat ("  --list-devices             ", _ ("List devices"), NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
	_g_free0 (msg);
	msg = _tmp40_;
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_tmp41_ = msg;
	_tmp42_ = g_strconcat (_tmp41_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp42_;
	_tmp43_ = msg;
	_tmp44_ = g_strconcat (_ ("Backup"), ":\n", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp43_, _tmp45_, NULL);
	_g_free0 (msg);
	msg = _tmp46_;
	_g_free0 (_tmp45_);
	_tmp47_ = msg;
	_tmp48_ = g_strconcat ("  --check                    ", _ ("Create snapshot if scheduled"), NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strconcat (_tmp49_, "\n", NULL);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp47_, _tmp51_, NULL);
	_g_free0 (msg);
	msg = _tmp52_;
	_g_free0 (_tmp51_);
	_g_free0 (_tmp49_);
	_tmp53_ = msg;
	_tmp54_ = g_strconcat ("  --create                   ", _ ("Create snapshot (even if not scheduled)"), NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, "\n", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat (_tmp53_, _tmp57_, NULL);
	_g_free0 (msg);
	msg = _tmp58_;
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	_tmp59_ = msg;
	_tmp60_ = g_strconcat ("  --comments <string>        ", _ ("Set snapshot description"), NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = g_strconcat (_tmp61_, "\n", NULL);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_strconcat (_tmp59_, _tmp63_, NULL);
	_g_free0 (msg);
	msg = _tmp64_;
	_g_free0 (_tmp63_);
	_g_free0 (_tmp61_);
	_tmp65_ = msg;
	_tmp66_ = g_strconcat ("  --tags {O,B,H,D,W,M}       ", _ ("Add tags to snapshot (default: O)"), NULL);
	_tmp67_ = _tmp66_;
	_tmp68_ = g_strconcat (_tmp67_, "\n", NULL);
	_tmp69_ = _tmp68_;
	_tmp70_ = g_strconcat (_tmp65_, _tmp69_, NULL);
	_g_free0 (msg);
	msg = _tmp70_;
	_g_free0 (_tmp69_);
	_g_free0 (_tmp67_);
	_tmp71_ = msg;
	_tmp72_ = g_strconcat (_tmp71_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp72_;
	_tmp73_ = msg;
	_tmp74_ = g_strconcat (_ ("Restore"), ":\n", NULL);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat (_tmp73_, _tmp75_, NULL);
	_g_free0 (msg);
	msg = _tmp76_;
	_g_free0 (_tmp75_);
	_tmp77_ = msg;
	_tmp78_ = g_strconcat ("  --restore                  ", _ ("Restore snapshot"), NULL);
	_tmp79_ = _tmp78_;
	_tmp80_ = g_strconcat (_tmp79_, "\n", NULL);
	_tmp81_ = _tmp80_;
	_tmp82_ = g_strconcat (_tmp77_, _tmp81_, NULL);
	_g_free0 (msg);
	msg = _tmp82_;
	_g_free0 (_tmp81_);
	_g_free0 (_tmp79_);
	_tmp83_ = msg;
	_tmp84_ = g_strconcat ("  --snapshot <name>          ", _ ("Specify snapshot to restore"), NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = g_strconcat (_tmp85_, "\n", NULL);
	_tmp87_ = _tmp86_;
	_tmp88_ = g_strconcat (_tmp83_, _tmp87_, NULL);
	_g_free0 (msg);
	msg = _tmp88_;
	_g_free0 (_tmp87_);
	_g_free0 (_tmp85_);
	_tmp89_ = msg;
	_tmp90_ = g_strconcat ("  --target[-device] <device> ", _ ("Specify target device"), NULL);
	_tmp91_ = _tmp90_;
	_tmp92_ = g_strconcat (_tmp91_, "\n", NULL);
	_tmp93_ = _tmp92_;
	_tmp94_ = g_strconcat (_tmp89_, _tmp93_, NULL);
	_g_free0 (msg);
	msg = _tmp94_;
	_g_free0 (_tmp93_);
	_g_free0 (_tmp91_);
	_tmp95_ = msg;
	_tmp96_ = g_strconcat ("  --grub[-device] <device>   ", _ ("Specify device for installing GRUB2 bootloader"), NULL);
	_tmp97_ = _tmp96_;
	_tmp98_ = g_strconcat (_tmp97_, "\n", NULL);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp95_, _tmp99_, NULL);
	_g_free0 (msg);
	msg = _tmp100_;
	_g_free0 (_tmp99_);
	_g_free0 (_tmp97_);
	_tmp101_ = msg;
	_tmp102_ = g_strconcat ("  --skip-grub                ", _ ("Skip GRUB2 reinstall"), NULL);
	_tmp103_ = _tmp102_;
	_tmp104_ = g_strconcat (_tmp103_, "\n", NULL);
	_tmp105_ = _tmp104_;
	_tmp106_ = g_strconcat (_tmp101_, _tmp105_, NULL);
	_g_free0 (msg);
	msg = _tmp106_;
	_g_free0 (_tmp105_);
	_g_free0 (_tmp103_);
	_tmp107_ = msg;
	_tmp108_ = g_strconcat (_tmp107_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp108_;
	_tmp109_ = msg;
	_tmp110_ = g_strconcat (_ ("Delete"), ":\n", NULL);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_strconcat (_tmp109_, _tmp111_, NULL);
	_g_free0 (msg);
	msg = _tmp112_;
	_g_free0 (_tmp111_);
	_tmp113_ = msg;
	_tmp114_ = g_strconcat ("  --delete                   ", _ ("Delete snapshot"), NULL);
	_tmp115_ = _tmp114_;
	_tmp116_ = g_strconcat (_tmp115_, "\n", NULL);
	_tmp117_ = _tmp116_;
	_tmp118_ = g_strconcat (_tmp113_, _tmp117_, NULL);
	_g_free0 (msg);
	msg = _tmp118_;
	_g_free0 (_tmp117_);
	_g_free0 (_tmp115_);
	_tmp119_ = msg;
	_tmp120_ = g_strconcat ("  --delete-all               ", _ ("Delete all snapshots"), NULL);
	_tmp121_ = _tmp120_;
	_tmp122_ = g_strconcat (_tmp121_, "\n", NULL);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat (_tmp119_, _tmp123_, NULL);
	_g_free0 (msg);
	msg = _tmp124_;
	_g_free0 (_tmp123_);
	_g_free0 (_tmp121_);
	_tmp125_ = msg;
	_tmp126_ = g_strconcat (_tmp125_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp126_;
	_tmp127_ = msg;
	_tmp128_ = g_strconcat (_ ("Global"), ":\n", NULL);
	_tmp129_ = _tmp128_;
	_tmp130_ = g_strconcat (_tmp127_, _tmp129_, NULL);
	_g_free0 (msg);
	msg = _tmp130_;
	_g_free0 (_tmp129_);
	_tmp131_ = msg;
	_tmp132_ = g_strconcat ("  --snapshot-device <device> ", _ ("Specify backup device (default: config)"), NULL);
	_tmp133_ = _tmp132_;
	_tmp134_ = g_strconcat (_tmp133_, "\n", NULL);
	_tmp135_ = _tmp134_;
	_tmp136_ = g_strconcat (_tmp131_, _tmp135_, NULL);
	_g_free0 (msg);
	msg = _tmp136_;
	_g_free0 (_tmp135_);
	_g_free0 (_tmp133_);
	_tmp137_ = msg;
	_tmp138_ = g_strconcat ("  --yes                      ", _ ("Answer YES to all confirmation prompts"), NULL);
	_tmp139_ = _tmp138_;
	_tmp140_ = g_strconcat (_tmp139_, "\n", NULL);
	_tmp141_ = _tmp140_;
	_tmp142_ = g_strconcat (_tmp137_, _tmp141_, NULL);
	_g_free0 (msg);
	msg = _tmp142_;
	_g_free0 (_tmp141_);
	_g_free0 (_tmp139_);
	_tmp143_ = msg;
	_tmp144_ = g_strconcat ("  --btrfs                    ", _ ("Switch to BTRFS mode (default: config)"), NULL);
	_tmp145_ = _tmp144_;
	_tmp146_ = g_strconcat (_tmp145_, "\n", NULL);
	_tmp147_ = _tmp146_;
	_tmp148_ = g_strconcat (_tmp143_, _tmp147_, NULL);
	_g_free0 (msg);
	msg = _tmp148_;
	_g_free0 (_tmp147_);
	_g_free0 (_tmp145_);
	_tmp149_ = msg;
	_tmp150_ = g_strconcat ("  --rsync                    ", _ ("Switch to RSYNC mode (default: config)"), NULL);
	_tmp151_ = _tmp150_;
	_tmp152_ = g_strconcat (_tmp151_, "\n", NULL);
	_tmp153_ = _tmp152_;
	_tmp154_ = g_strconcat (_tmp149_, _tmp153_, NULL);
	_g_free0 (msg);
	msg = _tmp154_;
	_g_free0 (_tmp153_);
	_g_free0 (_tmp151_);
	_tmp155_ = msg;
	_tmp156_ = g_strconcat ("  --debug                    ", _ ("Show additional debug messages"), NULL);
	_tmp157_ = _tmp156_;
	_tmp158_ = g_strconcat (_tmp157_, "\n", NULL);
	_tmp159_ = _tmp158_;
	_tmp160_ = g_strconcat (_tmp155_, _tmp159_, NULL);
	_g_free0 (msg);
	msg = _tmp160_;
	_g_free0 (_tmp159_);
	_g_free0 (_tmp157_);
	_tmp161_ = msg;
	_tmp162_ = g_strconcat ("  --verbose                  ", _ ("Show rsync output (default)"), NULL);
	_tmp163_ = _tmp162_;
	_tmp164_ = g_strconcat (_tmp163_, "\n", NULL);
	_tmp165_ = _tmp164_;
	_tmp166_ = g_strconcat (_tmp161_, _tmp165_, NULL);
	_g_free0 (msg);
	msg = _tmp166_;
	_g_free0 (_tmp165_);
	_g_free0 (_tmp163_);
	_tmp167_ = msg;
	_tmp168_ = g_strconcat ("  --quiet                    ", _ ("Hide rsync output"), NULL);
	_tmp169_ = _tmp168_;
	_tmp170_ = g_strconcat (_tmp169_, "\n", NULL);
	_tmp171_ = _tmp170_;
	_tmp172_ = g_strconcat (_tmp167_, _tmp171_, NULL);
	_g_free0 (msg);
	msg = _tmp172_;
	_g_free0 (_tmp171_);
	_g_free0 (_tmp169_);
	_tmp173_ = msg;
	_tmp174_ = g_strconcat ("  --scripted                 ", _ ("Run in non-interactive mode"), NULL);
	_tmp175_ = _tmp174_;
	_tmp176_ = g_strconcat (_tmp175_, "\n", NULL);
	_tmp177_ = _tmp176_;
	_tmp178_ = g_strconcat (_tmp173_, _tmp177_, NULL);
	_g_free0 (msg);
	msg = _tmp178_;
	_g_free0 (_tmp177_);
	_g_free0 (_tmp175_);
	_tmp179_ = msg;
	_tmp180_ = g_strconcat ("  --help                     ", _ ("Show all options"), NULL);
	_tmp181_ = _tmp180_;
	_tmp182_ = g_strconcat (_tmp181_, "\n", NULL);
	_tmp183_ = _tmp182_;
	_tmp184_ = g_strconcat (_tmp179_, _tmp183_, NULL);
	_g_free0 (msg);
	msg = _tmp184_;
	_g_free0 (_tmp183_);
	_g_free0 (_tmp181_);
	_tmp185_ = msg;
	_tmp186_ = g_strconcat ("  --version                  ", _ ("Print version number"), NULL);
	_tmp187_ = _tmp186_;
	_tmp188_ = g_strconcat (_tmp187_, "\n", NULL);
	_tmp189_ = _tmp188_;
	_tmp190_ = g_strconcat (_tmp185_, _tmp189_, NULL);
	_g_free0 (msg);
	msg = _tmp190_;
	_g_free0 (_tmp189_);
	_g_free0 (_tmp187_);
	_tmp191_ = msg;
	_tmp192_ = g_strconcat (_tmp191_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp192_;
	_tmp193_ = msg;
	_tmp194_ = g_strconcat (_ ("Examples"), ":\n", NULL);
	_tmp195_ = _tmp194_;
	_tmp196_ = g_strconcat (_tmp193_, _tmp195_, NULL);
	_g_free0 (msg);
	msg = _tmp196_;
	_g_free0 (_tmp195_);
	_tmp197_ = msg;
	_tmp198_ = g_strconcat (_tmp197_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp198_;
	_tmp199_ = msg;
	_tmp200_ = g_strconcat (_tmp199_, "timeshift --list\n", NULL);
	_g_free0 (msg);
	msg = _tmp200_;
	_tmp201_ = msg;
	_tmp202_ = g_strconcat (_tmp201_, "timeshift --list --snapshot-device /dev/sda1\n", NULL);
	_g_free0 (msg);
	msg = _tmp202_;
	_tmp203_ = msg;
	_tmp204_ = g_strconcat (_tmp203_, "timeshift --create --comments \"after update\" --tags D\n", NULL);
	_g_free0 (msg);
	msg = _tmp204_;
	_tmp205_ = msg;
	_tmp206_ = g_strconcat (_tmp205_, "timeshift --restore \n", NULL);
	_g_free0 (msg);
	msg = _tmp206_;
	_tmp207_ = msg;
	_tmp208_ = g_strconcat (_tmp207_, "timeshift --restore --snapshot '2014-10-12_16-29-08' --target /dev/sda" \
"1\n", NULL);
	_g_free0 (msg);
	msg = _tmp208_;
	_tmp209_ = msg;
	_tmp210_ = g_strconcat (_tmp209_, "timeshift --delete  --snapshot '2014-10-12_16-29-08'\n", NULL);
	_g_free0 (msg);
	msg = _tmp210_;
	_tmp211_ = msg;
	_tmp212_ = g_strconcat (_tmp211_, "timeshift --delete-all \n", NULL);
	_g_free0 (msg);
	msg = _tmp212_;
	_tmp213_ = msg;
	_tmp214_ = g_strconcat (_tmp213_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp214_;
	_tmp215_ = msg;
	_tmp216_ = g_strconcat (_ ("Notes"), ":\n", NULL);
	_tmp217_ = _tmp216_;
	_tmp218_ = g_strconcat (_tmp215_, _tmp217_, NULL);
	_g_free0 (msg);
	msg = _tmp218_;
	_g_free0 (_tmp217_);
	_tmp219_ = msg;
	_tmp220_ = g_strconcat (_tmp219_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp220_;
	_tmp221_ = msg;
	_tmp222_ = g_strconcat (_tmp221_, "  1) --create will always create a new snapshot\n", NULL);
	_g_free0 (msg);
	msg = _tmp222_;
	_tmp223_ = msg;
	_tmp224_ = g_strconcat (_tmp223_, "  2) --check will create a snapshot only if a scheduled snapshot is du" \
"e\n", NULL);
	_g_free0 (msg);
	msg = _tmp224_;
	_tmp225_ = msg;
	_tmp226_ = g_strconcat (_tmp225_, "  3) Use --restore without other options to select options interactive" \
"ly\n", NULL);
	_g_free0 (msg);
	msg = _tmp226_;
	_tmp227_ = msg;
	_tmp228_ = g_strconcat (_tmp227_, "  4) UUID can be specified instead of device name\n", NULL);
	_g_free0 (msg);
	msg = _tmp228_;
	_tmp229_ = msg;
	_tmp230_ = g_strconcat (_tmp229_, "  5) Default values will be loaded from app config if options are not " \
"specified\n", NULL);
	_g_free0 (msg);
	msg = _tmp230_;
	_tmp231_ = msg;
	_tmp232_ = g_strconcat (_tmp231_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp232_;
	result = msg;
	return result;
}

static void
app_console_list_snapshots (AppConsole* self,
                            gboolean paginate,
                            gint page_size)
{
	gint count = 0;
	gchar** grid = NULL;
	gchar** _tmp10_;
	gint grid_length1;
	gint grid_length2;
	gboolean* right_align = NULL;
	gboolean* _tmp11_;
	gint right_align_length1;
	gint _right_align_size_;
	gint row = 0;
	gint col = 0;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
	gint _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gint _tmp21__length2;
	gint _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	gint _tmp25_;
	gchar* _tmp26_;
	gint _tmp27_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gint _tmp65__length2;
	gboolean* _tmp66_;
	gint _tmp66__length1;
	g_return_if_fail (self != NULL);
	count = 0;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Main* _tmp2_;
				SnapshotRepo* _tmp3_;
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gboolean _tmp7_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = index;
					index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = App;
				_tmp3_ = _tmp2_->repo;
				_tmp4_ = _tmp3_->snapshots;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(index < _tmp6_)) {
					break;
				}
				if (!paginate) {
					_tmp7_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (index >= self->snapshot_list_start_index) {
						_tmp8_ = index < (self->snapshot_list_start_index + page_size);
					} else {
						_tmp8_ = FALSE;
					}
					_tmp7_ = _tmp8_;
				}
				if (_tmp7_) {
					gint _tmp9_;
					_tmp9_ = count;
					count = _tmp9_ + 1;
				}
			}
		}
	}
	_tmp10_ = g_new0 (gchar*, ((count + 1) * 5) + 1);
	grid = _tmp10_;
	grid_length1 = count + 1;
	grid_length2 = 5;
	_tmp11_ = g_new0 (gboolean, 5);
	_tmp11_[0] = FALSE;
	_tmp11_[1] = FALSE;
	_tmp11_[2] = FALSE;
	_tmp11_[3] = FALSE;
	_tmp11_[4] = FALSE;
	right_align = _tmp11_;
	right_align_length1 = 5;
	_right_align_size_ = right_align_length1;
	row = 0;
	col = -1;
	_tmp12_ = grid;
	_tmp12__length1 = grid_length1;
	_tmp12__length2 = grid_length2;
	col = col + 1;
	_tmp13_ = col;
	_tmp14_ = g_strdup (_ ("Num"));
	_g_free0 (_tmp12_[(row * _tmp12__length2) + _tmp13_]);
	_tmp12_[(row * _tmp12__length2) + _tmp13_] = _tmp14_;
	_tmp15_ = grid;
	_tmp15__length1 = grid_length1;
	_tmp15__length2 = grid_length2;
	col = col + 1;
	_tmp16_ = col;
	_tmp17_ = g_strdup ("");
	_g_free0 (_tmp15_[(row * _tmp15__length2) + _tmp16_]);
	_tmp15_[(row * _tmp15__length2) + _tmp16_] = _tmp17_;
	_tmp18_ = grid;
	_tmp18__length1 = grid_length1;
	_tmp18__length2 = grid_length2;
	col = col + 1;
	_tmp19_ = col;
	_tmp20_ = g_strdup (_ ("Name"));
	_g_free0 (_tmp18_[(row * _tmp18__length2) + _tmp19_]);
	_tmp18_[(row * _tmp18__length2) + _tmp19_] = _tmp20_;
	_tmp21_ = grid;
	_tmp21__length1 = grid_length1;
	_tmp21__length2 = grid_length2;
	col = col + 1;
	_tmp22_ = col;
	_tmp23_ = g_strdup (_ ("Tags"));
	_g_free0 (_tmp21_[(row * _tmp21__length2) + _tmp22_]);
	_tmp21_[(row * _tmp21__length2) + _tmp22_] = _tmp23_;
	_tmp24_ = grid;
	_tmp24__length1 = grid_length1;
	_tmp24__length2 = grid_length2;
	col = col + 1;
	_tmp25_ = col;
	_tmp26_ = g_strdup (_ ("Description"));
	_g_free0 (_tmp24_[(row * _tmp24__length2) + _tmp25_]);
	_tmp24_[(row * _tmp24__length2) + _tmp25_] = _tmp26_;
	_tmp27_ = row;
	row = _tmp27_ + 1;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				Main* _tmp30_;
				SnapshotRepo* _tmp31_;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				Snapshot* bak = NULL;
				Main* _tmp35_;
				SnapshotRepo* _tmp36_;
				GeeArrayList* _tmp37_;
				gpointer _tmp38_;
				gboolean _tmp39_ = FALSE;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = index;
					index = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = App;
				_tmp31_ = _tmp30_->repo;
				_tmp32_ = _tmp31_->snapshots;
				_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				if (!(index < _tmp34_)) {
					break;
				}
				_tmp35_ = App;
				_tmp36_ = _tmp35_->repo;
				_tmp37_ = _tmp36_->snapshots;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, index);
				bak = (Snapshot*) _tmp38_;
				if (!paginate) {
					_tmp39_ = TRUE;
				} else {
					gboolean _tmp40_ = FALSE;
					if (index >= self->snapshot_list_start_index) {
						_tmp40_ = index < (self->snapshot_list_start_index + page_size);
					} else {
						_tmp40_ = FALSE;
					}
					_tmp39_ = _tmp40_;
				}
				if (_tmp39_) {
					gchar** _tmp41_;
					gint _tmp41__length1;
					gint _tmp41__length2;
					gint _tmp42_;
					gchar* _tmp43_;
					gchar** _tmp44_;
					gint _tmp44__length1;
					gint _tmp44__length2;
					gint _tmp45_;
					gchar* _tmp46_;
					gchar** _tmp47_;
					gint _tmp47__length1;
					gint _tmp47__length2;
					gint _tmp48_;
					Snapshot* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					gchar** _tmp52_;
					gint _tmp52__length1;
					gint _tmp52__length2;
					gint _tmp53_;
					Snapshot* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar** _tmp59_;
					gint _tmp59__length1;
					gint _tmp59__length2;
					gint _tmp60_;
					Snapshot* _tmp61_;
					const gchar* _tmp62_;
					gchar* _tmp63_;
					gint _tmp64_;
					col = -1;
					_tmp41_ = grid;
					_tmp41__length1 = grid_length1;
					_tmp41__length2 = grid_length2;
					col = col + 1;
					_tmp42_ = col;
					_tmp43_ = g_strdup_printf ("%d", index);
					_g_free0 (_tmp41_[(row * _tmp41__length2) + _tmp42_]);
					_tmp41_[(row * _tmp41__length2) + _tmp42_] = _tmp43_;
					_tmp44_ = grid;
					_tmp44__length1 = grid_length1;
					_tmp44__length2 = grid_length2;
					col = col + 1;
					_tmp45_ = col;
					_tmp46_ = g_strdup (">");
					_g_free0 (_tmp44_[(row * _tmp44__length2) + _tmp45_]);
					_tmp44_[(row * _tmp44__length2) + _tmp45_] = _tmp46_;
					_tmp47_ = grid;
					_tmp47__length1 = grid_length1;
					_tmp47__length2 = grid_length2;
					col = col + 1;
					_tmp48_ = col;
					_tmp49_ = bak;
					_tmp50_ = _tmp49_->name;
					_tmp51_ = g_strdup_printf ("%s", _tmp50_);
					_g_free0 (_tmp47_[(row * _tmp47__length2) + _tmp48_]);
					_tmp47_[(row * _tmp47__length2) + _tmp48_] = _tmp51_;
					_tmp52_ = grid;
					_tmp52__length1 = grid_length1;
					_tmp52__length2 = grid_length2;
					col = col + 1;
					_tmp53_ = col;
					_tmp54_ = bak;
					_tmp55_ = snapshot_get_taglist_short (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = _tmp56_;
					_tmp58_ = g_strdup_printf ("%s", _tmp57_);
					_g_free0 (_tmp52_[(row * _tmp52__length2) + _tmp53_]);
					_tmp52_[(row * _tmp52__length2) + _tmp53_] = _tmp58_;
					_g_free0 (_tmp57_);
					_tmp59_ = grid;
					_tmp59__length1 = grid_length1;
					_tmp59__length2 = grid_length2;
					col = col + 1;
					_tmp60_ = col;
					_tmp61_ = bak;
					_tmp62_ = _tmp61_->description;
					_tmp63_ = g_strdup_printf ("%s", _tmp62_);
					_g_free0 (_tmp59_[(row * _tmp59__length2) + _tmp60_]);
					_tmp59_[(row * _tmp59__length2) + _tmp60_] = _tmp63_;
					_tmp64_ = row;
					row = _tmp64_ + 1;
				}
				_g_object_unref0 (bak);
			}
		}
	}
	_tmp65_ = grid;
	_tmp65__length1 = grid_length1;
	_tmp65__length2 = grid_length2;
	_tmp66_ = right_align;
	_tmp66__length1 = right_align_length1;
	app_console_print_grid (self, _tmp65_, (gint) _tmp65__length1, (gint) _tmp65__length2, _tmp66_, (gint) _tmp66__length1, TRUE);
	right_align = (g_free (right_align), NULL);
	grid = (_vala_array_free (grid, grid_length1 * grid_length2, (GDestroyNotify) g_free), NULL);
}

static void
app_console_list_devices (AppConsole* self,
                          GeeArrayList* device_list)
{
	gchar** grid = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint grid_length1;
	gint grid_length2;
	gboolean* right_align = NULL;
	gboolean* _tmp3_;
	gint right_align_length1;
	gint _right_align_size_;
	gint row = 0;
	gint col = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint _tmp19__length2;
	gint _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gint _tmp65__length2;
	gboolean* _tmp66_;
	gint _tmp66__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_list != NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) device_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar*, ((_tmp1_ + 1) * 6) + 1);
	grid = _tmp2_;
	grid_length1 = _tmp1_ + 1;
	grid_length2 = 6;
	_tmp3_ = g_new0 (gboolean, 6);
	_tmp3_[0] = FALSE;
	_tmp3_[1] = FALSE;
	_tmp3_[2] = FALSE;
	_tmp3_[3] = TRUE;
	_tmp3_[4] = TRUE;
	_tmp3_[5] = FALSE;
	right_align = _tmp3_;
	right_align_length1 = 6;
	_right_align_size_ = right_align_length1;
	row = 0;
	col = -1;
	_tmp4_ = grid;
	_tmp4__length1 = grid_length1;
	_tmp4__length2 = grid_length2;
	col = col + 1;
	_tmp5_ = col;
	_tmp6_ = g_strdup (_ ("Num"));
	_g_free0 (_tmp4_[(row * _tmp4__length2) + _tmp5_]);
	_tmp4_[(row * _tmp4__length2) + _tmp5_] = _tmp6_;
	_tmp7_ = grid;
	_tmp7__length1 = grid_length1;
	_tmp7__length2 = grid_length2;
	col = col + 1;
	_tmp8_ = col;
	_tmp9_ = g_strdup ("");
	_g_free0 (_tmp7_[(row * _tmp7__length2) + _tmp8_]);
	_tmp7_[(row * _tmp7__length2) + _tmp8_] = _tmp9_;
	_tmp10_ = grid;
	_tmp10__length1 = grid_length1;
	_tmp10__length2 = grid_length2;
	col = col + 1;
	_tmp11_ = col;
	_tmp12_ = g_strdup (_ ("Device"));
	_g_free0 (_tmp10_[(row * _tmp10__length2) + _tmp11_]);
	_tmp10_[(row * _tmp10__length2) + _tmp11_] = _tmp12_;
	_tmp13_ = grid;
	_tmp13__length1 = grid_length1;
	_tmp13__length2 = grid_length2;
	col = col + 1;
	_tmp14_ = col;
	_tmp15_ = g_strdup (_ ("Size"));
	_g_free0 (_tmp13_[(row * _tmp13__length2) + _tmp14_]);
	_tmp13_[(row * _tmp13__length2) + _tmp14_] = _tmp15_;
	_tmp16_ = grid;
	_tmp16__length1 = grid_length1;
	_tmp16__length2 = grid_length2;
	col = col + 1;
	_tmp17_ = col;
	_tmp18_ = g_strdup (_ ("Type"));
	_g_free0 (_tmp16_[(row * _tmp16__length2) + _tmp17_]);
	_tmp16_[(row * _tmp16__length2) + _tmp17_] = _tmp18_;
	_tmp19_ = grid;
	_tmp19__length1 = grid_length1;
	_tmp19__length2 = grid_length2;
	col = col + 1;
	_tmp20_ = col;
	_tmp21_ = g_strdup (_ ("Label"));
	_g_free0 (_tmp19_[(row * _tmp19__length2) + _tmp20_]);
	_tmp19_[(row * _tmp19__length2) + _tmp20_] = _tmp21_;
	_tmp22_ = row;
	row = _tmp22_ + 1;
	{
		GeeArrayList* _pi_list = NULL;
		gint _pi_size = 0;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _pi_index = 0;
		_pi_list = device_list;
		_tmp23_ = _pi_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_pi_size = _tmp25_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			Device* pi = NULL;
			GeeArrayList* _tmp28_;
			gpointer _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			gint _tmp30__length2;
			gint _tmp31_;
			gchar* _tmp32_;
			gchar** _tmp33_;
			gint _tmp33__length1;
			gint _tmp33__length2;
			gint _tmp34_;
			gchar* _tmp35_;
			gchar** _tmp36_;
			gint _tmp36__length1;
			gint _tmp36__length2;
			gint _tmp37_;
			Device* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			Device* _tmp44_;
			gchar** _tmp51_;
			gint _tmp51__length1;
			gint _tmp51__length2;
			gint _tmp52_;
			gchar* _tmp53_;
			gchar** _tmp54_;
			gint _tmp54__length1;
			gint _tmp54__length2;
			gint _tmp55_;
			Device* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar** _tmp59_;
			gint _tmp59__length1;
			gint _tmp59__length2;
			gint _tmp60_;
			Device* _tmp61_;
			const gchar* _tmp62_;
			gchar* _tmp63_;
			gint _tmp64_;
			_pi_index = _pi_index + 1;
			_tmp26_ = _pi_index;
			_tmp27_ = _pi_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _pi_list;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _pi_index);
			pi = (Device*) _tmp29_;
			col = -1;
			_tmp30_ = grid;
			_tmp30__length1 = grid_length1;
			_tmp30__length2 = grid_length2;
			col = col + 1;
			_tmp31_ = col;
			_tmp32_ = g_strdup_printf ("%d", row - 1);
			_g_free0 (_tmp30_[(row * _tmp30__length2) + _tmp31_]);
			_tmp30_[(row * _tmp30__length2) + _tmp31_] = _tmp32_;
			_tmp33_ = grid;
			_tmp33__length1 = grid_length1;
			_tmp33__length2 = grid_length2;
			col = col + 1;
			_tmp34_ = col;
			_tmp35_ = g_strdup (">");
			_g_free0 (_tmp33_[(row * _tmp33__length2) + _tmp34_]);
			_tmp33_[(row * _tmp33__length2) + _tmp34_] = _tmp35_;
			_tmp36_ = grid;
			_tmp36__length1 = grid_length1;
			_tmp36__length2 = grid_length2;
			col = col + 1;
			_tmp37_ = col;
			_tmp38_ = pi;
			_tmp39_ = device_get_device_name_with_parent (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("%s", _tmp41_);
			_g_free0 (_tmp36_[(row * _tmp36__length2) + _tmp37_]);
			_tmp36_[(row * _tmp36__length2) + _tmp37_] = _tmp42_;
			_g_free0 (_tmp41_);
			_tmp44_ = pi;
			if (_tmp44_->size_bytes > ((guint64) 0)) {
				Device* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp45_ = pi;
				_tmp46_ = device_get_size (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf ("%s", _tmp48_);
				_g_free0 (_tmp43_);
				_tmp43_ = _tmp49_;
				_g_free0 (_tmp48_);
			} else {
				gchar* _tmp50_;
				_tmp50_ = g_strdup ("?? GB");
				_g_free0 (_tmp43_);
				_tmp43_ = _tmp50_;
			}
			_tmp51_ = grid;
			_tmp51__length1 = grid_length1;
			_tmp51__length2 = grid_length2;
			col = col + 1;
			_tmp52_ = col;
			_tmp53_ = g_strdup_printf ("%s", _tmp43_);
			_g_free0 (_tmp51_[(row * _tmp51__length2) + _tmp52_]);
			_tmp51_[(row * _tmp51__length2) + _tmp52_] = _tmp53_;
			_tmp54_ = grid;
			_tmp54__length1 = grid_length1;
			_tmp54__length2 = grid_length2;
			col = col + 1;
			_tmp55_ = col;
			_tmp56_ = pi;
			_tmp57_ = _tmp56_->fstype;
			_tmp58_ = g_strdup_printf ("%s", _tmp57_);
			_g_free0 (_tmp54_[(row * _tmp54__length2) + _tmp55_]);
			_tmp54_[(row * _tmp54__length2) + _tmp55_] = _tmp58_;
			_tmp59_ = grid;
			_tmp59__length1 = grid_length1;
			_tmp59__length2 = grid_length2;
			col = col + 1;
			_tmp60_ = col;
			_tmp61_ = pi;
			_tmp62_ = _tmp61_->label;
			_tmp63_ = g_strdup_printf ("%s", _tmp62_);
			_g_free0 (_tmp59_[(row * _tmp59__length2) + _tmp60_]);
			_tmp59_[(row * _tmp59__length2) + _tmp60_] = _tmp63_;
			_tmp64_ = row;
			row = _tmp64_ + 1;
			_g_free0 (_tmp43_);
			_g_object_unref0 (pi);
		}
	}
	_tmp65_ = grid;
	_tmp65__length1 = grid_length1;
	_tmp65__length2 = grid_length2;
	_tmp66_ = right_align;
	_tmp66__length1 = right_align_length1;
	app_console_print_grid (self, _tmp65_, (gint) _tmp65__length1, (gint) _tmp65__length2, _tmp66_, (gint) _tmp66__length1, TRUE);
	right_align = (g_free (right_align), NULL);
	grid = (_vala_array_free (grid, grid_length1 * grid_length2, (GDestroyNotify) g_free), NULL);
}

static GeeArrayList*
app_console_list_all_devices (AppConsole* self)
{
	GeeArrayList* device_list = NULL;
	GeeArrayList* _tmp0_;
	gchar** grid = NULL;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** _tmp15_;
	gint grid_length1;
	gint grid_length2;
	gboolean* right_align = NULL;
	gboolean* _tmp16_;
	gint right_align_length1;
	gint _right_align_size_;
	gint row = 0;
	gint col = 0;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	gint _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint _tmp23__length2;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gint _tmp26__length2;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint _tmp29__length2;
	gint _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint _tmp32__length2;
	gint _tmp33_;
	gchar* _tmp34_;
	gint _tmp35_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	gint _tmp76__length2;
	gboolean* _tmp77_;
	gint _tmp77__length1;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	device_list = _tmp0_;
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp1_;
		gint _dev_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dev_index = 0;
		_tmp1_ = device_get_block_devices_using_lsblk ("");
		_dev_list = _tmp1_;
		_tmp2_ = _dev_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dev_size = _tmp4_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Device* dev = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			Device* _tmp9_;
			_dev_index = _dev_index + 1;
			_tmp5_ = _dev_index;
			_tmp6_ = _dev_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _dev_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _dev_index);
			dev = (Device*) _tmp8_;
			_tmp9_ = dev;
			if (device_has_linux_filesystem (_tmp9_)) {
				GeeArrayList* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = device_list;
				_tmp11_ = dev;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_list);
	}
	_tmp12_ = device_list;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (gchar*, ((_tmp14_ + 1) * 6) + 1);
	grid = _tmp15_;
	grid_length1 = _tmp14_ + 1;
	grid_length2 = 6;
	_tmp16_ = g_new0 (gboolean, 6);
	_tmp16_[0] = FALSE;
	_tmp16_[1] = FALSE;
	_tmp16_[2] = FALSE;
	_tmp16_[3] = TRUE;
	_tmp16_[4] = TRUE;
	_tmp16_[5] = FALSE;
	right_align = _tmp16_;
	right_align_length1 = 6;
	_right_align_size_ = right_align_length1;
	row = 0;
	col = -1;
	_tmp17_ = grid;
	_tmp17__length1 = grid_length1;
	_tmp17__length2 = grid_length2;
	col = col + 1;
	_tmp18_ = col;
	_tmp19_ = g_strdup (_ ("Num"));
	_g_free0 (_tmp17_[(row * _tmp17__length2) + _tmp18_]);
	_tmp17_[(row * _tmp17__length2) + _tmp18_] = _tmp19_;
	_tmp20_ = grid;
	_tmp20__length1 = grid_length1;
	_tmp20__length2 = grid_length2;
	col = col + 1;
	_tmp21_ = col;
	_tmp22_ = g_strdup ("");
	_g_free0 (_tmp20_[(row * _tmp20__length2) + _tmp21_]);
	_tmp20_[(row * _tmp20__length2) + _tmp21_] = _tmp22_;
	_tmp23_ = grid;
	_tmp23__length1 = grid_length1;
	_tmp23__length2 = grid_length2;
	col = col + 1;
	_tmp24_ = col;
	_tmp25_ = g_strdup (_ ("Device"));
	_g_free0 (_tmp23_[(row * _tmp23__length2) + _tmp24_]);
	_tmp23_[(row * _tmp23__length2) + _tmp24_] = _tmp25_;
	_tmp26_ = grid;
	_tmp26__length1 = grid_length1;
	_tmp26__length2 = grid_length2;
	col = col + 1;
	_tmp27_ = col;
	_tmp28_ = g_strdup (_ ("Size"));
	_g_free0 (_tmp26_[(row * _tmp26__length2) + _tmp27_]);
	_tmp26_[(row * _tmp26__length2) + _tmp27_] = _tmp28_;
	_tmp29_ = grid;
	_tmp29__length1 = grid_length1;
	_tmp29__length2 = grid_length2;
	col = col + 1;
	_tmp30_ = col;
	_tmp31_ = g_strdup (_ ("Type"));
	_g_free0 (_tmp29_[(row * _tmp29__length2) + _tmp30_]);
	_tmp29_[(row * _tmp29__length2) + _tmp30_] = _tmp31_;
	_tmp32_ = grid;
	_tmp32__length1 = grid_length1;
	_tmp32__length2 = grid_length2;
	col = col + 1;
	_tmp33_ = col;
	_tmp34_ = g_strdup (_ ("Label"));
	_g_free0 (_tmp32_[(row * _tmp32__length2) + _tmp33_]);
	_tmp32_[(row * _tmp32__length2) + _tmp33_] = _tmp34_;
	_tmp35_ = row;
	row = _tmp35_ + 1;
	{
		GeeArrayList* _pi_list = NULL;
		GeeArrayList* _tmp36_;
		gint _pi_size = 0;
		GeeArrayList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _pi_index = 0;
		_tmp36_ = device_list;
		_pi_list = _tmp36_;
		_tmp37_ = _pi_list;
		_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_pi_size = _tmp39_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			Device* pi = NULL;
			GeeArrayList* _tmp42_;
			gpointer _tmp43_;
			gchar** _tmp44_;
			gint _tmp44__length1;
			gint _tmp44__length2;
			gint _tmp45_;
			gchar* _tmp46_;
			gchar** _tmp47_;
			gint _tmp47__length1;
			gint _tmp47__length2;
			gint _tmp48_;
			gchar* _tmp49_;
			gchar** _tmp50_;
			gint _tmp50__length1;
			gint _tmp50__length2;
			gint _tmp51_;
			Device* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			Device* _tmp58_;
			gchar** _tmp62_;
			gint _tmp62__length1;
			gint _tmp62__length2;
			gint _tmp63_;
			gchar* _tmp64_;
			gchar** _tmp65_;
			gint _tmp65__length1;
			gint _tmp65__length2;
			gint _tmp66_;
			Device* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar** _tmp70_;
			gint _tmp70__length1;
			gint _tmp70__length2;
			gint _tmp71_;
			Device* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gint _tmp75_;
			_pi_index = _pi_index + 1;
			_tmp40_ = _pi_index;
			_tmp41_ = _pi_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _pi_list;
			_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _pi_index);
			pi = (Device*) _tmp43_;
			col = -1;
			_tmp44_ = grid;
			_tmp44__length1 = grid_length1;
			_tmp44__length2 = grid_length2;
			col = col + 1;
			_tmp45_ = col;
			_tmp46_ = g_strdup_printf ("%d", row - 1);
			_g_free0 (_tmp44_[(row * _tmp44__length2) + _tmp45_]);
			_tmp44_[(row * _tmp44__length2) + _tmp45_] = _tmp46_;
			_tmp47_ = grid;
			_tmp47__length1 = grid_length1;
			_tmp47__length2 = grid_length2;
			col = col + 1;
			_tmp48_ = col;
			_tmp49_ = g_strdup (">");
			_g_free0 (_tmp47_[(row * _tmp47__length2) + _tmp48_]);
			_tmp47_[(row * _tmp47__length2) + _tmp48_] = _tmp49_;
			_tmp50_ = grid;
			_tmp50__length1 = grid_length1;
			_tmp50__length2 = grid_length2;
			col = col + 1;
			_tmp51_ = col;
			_tmp52_ = pi;
			_tmp53_ = device_get_device_name_with_parent (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strdup_printf ("%s", _tmp55_);
			_g_free0 (_tmp50_[(row * _tmp50__length2) + _tmp51_]);
			_tmp50_[(row * _tmp50__length2) + _tmp51_] = _tmp56_;
			_g_free0 (_tmp55_);
			_tmp58_ = pi;
			if (_tmp58_->size_bytes > ((guint64) 0)) {
				Device* _tmp59_;
				gchar* _tmp60_;
				_tmp59_ = pi;
				_tmp60_ = tee_jee_file_system_format_file_size (_tmp59_->size_bytes, FALSE, "", TRUE, 1);
				_g_free0 (_tmp57_);
				_tmp57_ = _tmp60_;
			} else {
				gchar* _tmp61_;
				_tmp61_ = g_strdup ("?? GB");
				_g_free0 (_tmp57_);
				_tmp57_ = _tmp61_;
			}
			_tmp62_ = grid;
			_tmp62__length1 = grid_length1;
			_tmp62__length2 = grid_length2;
			col = col + 1;
			_tmp63_ = col;
			_tmp64_ = g_strdup_printf ("%s", _tmp57_);
			_g_free0 (_tmp62_[(row * _tmp62__length2) + _tmp63_]);
			_tmp62_[(row * _tmp62__length2) + _tmp63_] = _tmp64_;
			_tmp65_ = grid;
			_tmp65__length1 = grid_length1;
			_tmp65__length2 = grid_length2;
			col = col + 1;
			_tmp66_ = col;
			_tmp67_ = pi;
			_tmp68_ = _tmp67_->fstype;
			_tmp69_ = g_strdup_printf ("%s", _tmp68_);
			_g_free0 (_tmp65_[(row * _tmp65__length2) + _tmp66_]);
			_tmp65_[(row * _tmp65__length2) + _tmp66_] = _tmp69_;
			_tmp70_ = grid;
			_tmp70__length1 = grid_length1;
			_tmp70__length2 = grid_length2;
			col = col + 1;
			_tmp71_ = col;
			_tmp72_ = pi;
			_tmp73_ = _tmp72_->label;
			_tmp74_ = g_strdup_printf ("%s", _tmp73_);
			_g_free0 (_tmp70_[(row * _tmp70__length2) + _tmp71_]);
			_tmp70_[(row * _tmp70__length2) + _tmp71_] = _tmp74_;
			_tmp75_ = row;
			row = _tmp75_ + 1;
			_g_free0 (_tmp57_);
			_g_object_unref0 (pi);
		}
	}
	_tmp76_ = grid;
	_tmp76__length1 = grid_length1;
	_tmp76__length2 = grid_length2;
	_tmp77_ = right_align;
	_tmp77__length1 = right_align_length1;
	app_console_print_grid (self, _tmp76_, (gint) _tmp76__length1, (gint) _tmp76__length2, _tmp77_, (gint) _tmp77__length1, TRUE);
	result = device_list;
	right_align = (g_free (right_align), NULL);
	grid = (_vala_array_free (grid, grid_length1 * grid_length2, (GDestroyNotify) g_free), NULL);
	return result;
}

static GeeArrayList*
app_console_list_grub_devices (AppConsole* self,
                               gboolean print_to_console)
{
	GeeArrayList* grub_device_list = NULL;
	GeeArrayList* _tmp0_;
	gchar** grid = NULL;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar** _tmp21_;
	gint grid_length1;
	gint grid_length2;
	gboolean* right_align = NULL;
	gboolean* _tmp22_;
	gint right_align_length1;
	gint _right_align_size_;
	gint row = 0;
	gint col = 0;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint _tmp23__length2;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gint _tmp26__length2;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint _tmp29__length2;
	gint _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint _tmp32__length2;
	gint _tmp33_;
	gchar* _tmp34_;
	gint _tmp35_;
	gchar* desc = NULL;
	gchar* _tmp36_;
	gchar** _tmp114_;
	gint _tmp114__length1;
	gint _tmp114__length2;
	gboolean* _tmp115_;
	gint _tmp115__length1;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	grub_device_list = _tmp0_;
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp1_;
		gint _dev_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dev_index = 0;
		_tmp1_ = device_get_block_devices_using_lsblk ("");
		_dev_list = _tmp1_;
		_tmp2_ = _dev_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dev_size = _tmp4_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Device* dev = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			Device* _tmp9_;
			const gchar* _tmp10_;
			_dev_index = _dev_index + 1;
			_tmp5_ = _dev_index;
			_tmp6_ = _dev_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _dev_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _dev_index);
			dev = (Device*) _tmp8_;
			_tmp9_ = dev;
			_tmp10_ = _tmp9_->type;
			if (g_strcmp0 (_tmp10_, "disk") == 0) {
				GeeArrayList* _tmp11_;
				Device* _tmp12_;
				_tmp11_ = grub_device_list;
				_tmp12_ = dev;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			} else {
				Device* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = dev;
				_tmp14_ = _tmp13_->type;
				if (g_strcmp0 (_tmp14_, "part") == 0) {
					Device* _tmp15_;
					_tmp15_ = dev;
					if (device_has_linux_filesystem (_tmp15_)) {
						GeeArrayList* _tmp16_;
						Device* _tmp17_;
						_tmp16_ = grub_device_list;
						_tmp17_ = dev;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					}
				}
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_list);
	}
	_tmp18_ = grub_device_list;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_new0 (gchar*, ((_tmp20_ + 1) * 4) + 1);
	grid = _tmp21_;
	grid_length1 = _tmp20_ + 1;
	grid_length2 = 4;
	_tmp22_ = g_new0 (gboolean, 4);
	_tmp22_[0] = FALSE;
	_tmp22_[1] = FALSE;
	_tmp22_[2] = FALSE;
	_tmp22_[3] = FALSE;
	right_align = _tmp22_;
	right_align_length1 = 4;
	_right_align_size_ = right_align_length1;
	row = 0;
	col = -1;
	_tmp23_ = grid;
	_tmp23__length1 = grid_length1;
	_tmp23__length2 = grid_length2;
	col = col + 1;
	_tmp24_ = col;
	_tmp25_ = g_strdup (_ ("Num"));
	_g_free0 (_tmp23_[(row * _tmp23__length2) + _tmp24_]);
	_tmp23_[(row * _tmp23__length2) + _tmp24_] = _tmp25_;
	_tmp26_ = grid;
	_tmp26__length1 = grid_length1;
	_tmp26__length2 = grid_length2;
	col = col + 1;
	_tmp27_ = col;
	_tmp28_ = g_strdup ("");
	_g_free0 (_tmp26_[(row * _tmp26__length2) + _tmp27_]);
	_tmp26_[(row * _tmp26__length2) + _tmp27_] = _tmp28_;
	_tmp29_ = grid;
	_tmp29__length1 = grid_length1;
	_tmp29__length2 = grid_length2;
	col = col + 1;
	_tmp30_ = col;
	_tmp31_ = g_strdup (_ ("Device"));
	_g_free0 (_tmp29_[(row * _tmp29__length2) + _tmp30_]);
	_tmp29_[(row * _tmp29__length2) + _tmp30_] = _tmp31_;
	_tmp32_ = grid;
	_tmp32__length1 = grid_length1;
	_tmp32__length2 = grid_length2;
	col = col + 1;
	_tmp33_ = col;
	_tmp34_ = g_strdup (_ ("Description"));
	_g_free0 (_tmp32_[(row * _tmp32__length2) + _tmp33_]);
	_tmp32_[(row * _tmp32__length2) + _tmp33_] = _tmp34_;
	_tmp35_ = row;
	row = _tmp35_ + 1;
	_tmp36_ = g_strdup ("");
	desc = _tmp36_;
	{
		GeeArrayList* _pi_list = NULL;
		GeeArrayList* _tmp37_;
		gint _pi_size = 0;
		GeeArrayList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _pi_index = 0;
		_tmp37_ = grub_device_list;
		_pi_list = _tmp37_;
		_tmp38_ = _pi_list;
		_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_pi_size = _tmp40_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			Device* pi = NULL;
			GeeArrayList* _tmp43_;
			gpointer _tmp44_;
			gchar** _tmp45_;
			gint _tmp45__length1;
			gint _tmp45__length2;
			gint _tmp46_;
			gchar* _tmp47_;
			gchar** _tmp48_;
			gint _tmp48__length1;
			gint _tmp48__length2;
			gint _tmp49_;
			gchar* _tmp50_;
			gchar** _tmp51_;
			gint _tmp51__length1;
			gint _tmp51__length2;
			gint _tmp52_;
			Device* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			Device* _tmp58_;
			const gchar* _tmp59_;
			gchar** _tmp109_;
			gint _tmp109__length1;
			gint _tmp109__length2;
			gint _tmp110_;
			const gchar* _tmp111_;
			gchar* _tmp112_;
			gint _tmp113_;
			_pi_index = _pi_index + 1;
			_tmp41_ = _pi_index;
			_tmp42_ = _pi_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _pi_list;
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _pi_index);
			pi = (Device*) _tmp44_;
			col = -1;
			_tmp45_ = grid;
			_tmp45__length1 = grid_length1;
			_tmp45__length2 = grid_length2;
			col = col + 1;
			_tmp46_ = col;
			_tmp47_ = g_strdup_printf ("%d", row - 1);
			_g_free0 (_tmp45_[(row * _tmp45__length2) + _tmp46_]);
			_tmp45_[(row * _tmp45__length2) + _tmp46_] = _tmp47_;
			_tmp48_ = grid;
			_tmp48__length1 = grid_length1;
			_tmp48__length2 = grid_length2;
			col = col + 1;
			_tmp49_ = col;
			_tmp50_ = g_strdup (">");
			_g_free0 (_tmp48_[(row * _tmp48__length2) + _tmp49_]);
			_tmp48_[(row * _tmp48__length2) + _tmp49_] = _tmp50_;
			_tmp51_ = grid;
			_tmp51__length1 = grid_length1;
			_tmp51__length2 = grid_length2;
			col = col + 1;
			_tmp52_ = col;
			_tmp53_ = pi;
			_tmp54_ = device_get_short_name_with_alias (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%s", _tmp56_);
			_g_free0 (_tmp51_[(row * _tmp51__length2) + _tmp52_]);
			_tmp51_[(row * _tmp51__length2) + _tmp52_] = _tmp57_;
			_g_free0 (_tmp56_);
			_tmp58_ = pi;
			_tmp59_ = _tmp58_->type;
			if (g_strcmp0 (_tmp59_, "disk") == 0) {
				gchar* _tmp60_ = NULL;
				gboolean _tmp61_ = FALSE;
				Device* _tmp62_;
				const gchar* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				gchar* _tmp80_;
				_tmp62_ = pi;
				_tmp63_ = _tmp62_->vendor;
				_tmp64_ = strlen (_tmp63_);
				_tmp65_ = _tmp64_;
				if (_tmp65_ > 0) {
					_tmp61_ = TRUE;
				} else {
					Device* _tmp66_;
					const gchar* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp66_ = pi;
					_tmp67_ = _tmp66_->model;
					_tmp68_ = strlen (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp61_ = _tmp69_ > 0;
				}
				if (_tmp61_) {
					Device* _tmp70_;
					const gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					Device* _tmp74_;
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					_tmp70_ = pi;
					_tmp71_ = _tmp70_->vendor;
					_tmp72_ = g_strconcat (_tmp71_, " ", NULL);
					_tmp73_ = _tmp72_;
					_tmp74_ = pi;
					_tmp75_ = _tmp74_->model;
					_tmp76_ = g_strconcat (_tmp73_, _tmp75_, NULL);
					_tmp77_ = _tmp76_;
					_tmp78_ = g_strconcat (_tmp77_, " [MBR]", NULL);
					_g_free0 (_tmp60_);
					_tmp60_ = _tmp78_;
					_g_free0 (_tmp77_);
					_g_free0 (_tmp73_);
				} else {
					gchar* _tmp79_;
					_tmp79_ = g_strdup ("");
					_g_free0 (_tmp60_);
					_tmp60_ = _tmp79_;
				}
				_tmp80_ = g_strdup_printf ("%s", _tmp60_);
				_g_free0 (desc);
				desc = _tmp80_;
				_g_free0 (_tmp60_);
			} else {
				Device* _tmp81_;
				const gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_ = NULL;
				Device* _tmp85_;
				const gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_ = NULL;
				Device* _tmp97_;
				const gchar* _tmp98_;
				gint _tmp99_;
				gint _tmp100_;
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				_tmp81_ = pi;
				_tmp82_ = _tmp81_->fstype;
				_tmp83_ = g_strdup_printf ("%5s, ", _tmp82_);
				_g_free0 (desc);
				desc = _tmp83_;
				_tmp85_ = pi;
				if (_tmp85_->size_bytes > ((guint64) 0)) {
					Device* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					_tmp86_ = pi;
					_tmp87_ = device_get_size (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = _tmp88_;
					_tmp90_ = g_strdup_printf ("%s GB", _tmp89_);
					_g_free0 (_tmp84_);
					_tmp84_ = _tmp90_;
					_g_free0 (_tmp89_);
				} else {
					gchar* _tmp91_;
					_tmp91_ = g_strdup ("?? GB");
					_g_free0 (_tmp84_);
					_tmp84_ = _tmp91_;
				}
				_tmp92_ = desc;
				_tmp93_ = g_strdup_printf ("%10s", _tmp84_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_strconcat (_tmp92_, _tmp94_, NULL);
				_g_free0 (desc);
				desc = _tmp95_;
				_g_free0 (_tmp94_);
				_tmp97_ = pi;
				_tmp98_ = _tmp97_->label;
				_tmp99_ = strlen (_tmp98_);
				_tmp100_ = _tmp99_;
				if (_tmp100_ > 0) {
					Device* _tmp101_;
					const gchar* _tmp102_;
					gchar* _tmp103_;
					_tmp101_ = pi;
					_tmp102_ = _tmp101_->label;
					_tmp103_ = g_strconcat (", ", _tmp102_, NULL);
					_g_free0 (_tmp96_);
					_tmp96_ = _tmp103_;
				} else {
					gchar* _tmp104_;
					_tmp104_ = g_strdup ("");
					_g_free0 (_tmp96_);
					_tmp96_ = _tmp104_;
				}
				_tmp105_ = desc;
				_tmp106_ = g_strdup_printf ("%s", _tmp96_);
				_tmp107_ = _tmp106_;
				_tmp108_ = g_strconcat (_tmp105_, _tmp107_, NULL);
				_g_free0 (desc);
				desc = _tmp108_;
				_g_free0 (_tmp107_);
				_g_free0 (_tmp96_);
				_g_free0 (_tmp84_);
			}
			_tmp109_ = grid;
			_tmp109__length1 = grid_length1;
			_tmp109__length2 = grid_length2;
			col = col + 1;
			_tmp110_ = col;
			_tmp111_ = desc;
			_tmp112_ = g_strdup_printf ("%s", _tmp111_);
			_g_free0 (_tmp109_[(row * _tmp109__length2) + _tmp110_]);
			_tmp109_[(row * _tmp109__length2) + _tmp110_] = _tmp112_;
			_tmp113_ = row;
			row = _tmp113_ + 1;
			_g_object_unref0 (pi);
		}
	}
	_tmp114_ = grid;
	_tmp114__length1 = grid_length1;
	_tmp114__length2 = grid_length2;
	_tmp115_ = right_align;
	_tmp115__length1 = right_align_length1;
	app_console_print_grid (self, _tmp114_, (gint) _tmp114__length1, (gint) _tmp114__length2, _tmp115_, (gint) _tmp115__length1, TRUE);
	result = grub_device_list;
	_g_free0 (desc);
	right_align = (g_free (right_align), NULL);
	grid = (_vala_array_free (grid, grid_length1 * grid_length2, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
app_console_print_grid (AppConsole* self,
                        gchar** grid,
                        gint grid_length1,
                        gint grid_length2,
                        gboolean* right_align,
                        gint right_align_length1,
                        gboolean has_header)
{
	gint* col_width = NULL;
	gint _tmp0_;
	gint* _tmp1_;
	gint col_width_length1;
	gint _col_width_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = grid_length2;
	_tmp1_ = g_new0 (gint, _tmp0_);
	col_width = _tmp1_;
	col_width_length1 = _tmp0_;
	_col_width_size_ = col_width_length1;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = col;
					col = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = grid_length2;
				if (!(col < _tmp4_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							const gchar* _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint* _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = row;
								row = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = grid_length1;
							if (!(row < _tmp7_)) {
								break;
							}
							_tmp8_ = grid[(row * grid_length2) + col];
							_tmp9_ = strlen (_tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = col_width;
							_tmp11__length1 = col_width_length1;
							_tmp12_ = _tmp11_[col];
							if (_tmp10_ > _tmp12_) {
								gint* _tmp13_;
								gint _tmp13__length1;
								const gchar* _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								_tmp13_ = col_width;
								_tmp13__length1 = col_width_length1;
								_tmp14_ = grid[(row * grid_length2) + col];
								_tmp15_ = strlen (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp13_[col] = _tmp16_;
							}
						}
					}
				}
			}
		}
	}
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_;
				FILE* _tmp40_;
				gboolean _tmp41_ = FALSE;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = row;
					row = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = grid_length1;
				if (!(row < _tmp19_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gint _tmp22_;
							const gchar* _tmp23_ = NULL;
							gboolean _tmp24_;
							gchar* fmt = NULL;
							gchar* _tmp25_;
							gchar* _tmp26_;
							gint* _tmp27_;
							gint _tmp27__length1;
							gint _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							FILE* _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = col;
								col = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = grid_length2;
							if (!(col < _tmp22_)) {
								break;
							}
							_tmp24_ = right_align[col];
							if (_tmp24_) {
								_tmp23_ = "+";
							} else {
								_tmp23_ = "-";
							}
							_tmp25_ = g_strconcat ("%", _tmp23_, NULL);
							_tmp26_ = _tmp25_;
							_tmp27_ = col_width;
							_tmp27__length1 = col_width_length1;
							_tmp28_ = _tmp27_[col];
							_tmp29_ = g_strdup_printf ("%i", _tmp28_);
							_tmp30_ = _tmp29_;
							_tmp31_ = g_strconcat (_tmp26_, _tmp30_, NULL);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_strconcat (_tmp32_, "s  ", NULL);
							_tmp34_ = _tmp33_;
							_g_free0 (_tmp32_);
							_g_free0 (_tmp30_);
							_g_free0 (_tmp26_);
							fmt = _tmp34_;
							_tmp35_ = stdout;
							_tmp36_ = fmt;
							_tmp37_ = grid[(row * grid_length2) + col];
							_tmp38_ = g_strdup_printf (_tmp36_, _tmp37_);
							_tmp39_ = _tmp38_;
							fprintf (_tmp35_, "%s", _tmp39_);
							_g_free0 (_tmp39_);
							_g_free0 (fmt);
						}
					}
				}
				_tmp40_ = stdout;
				fprintf (_tmp40_, "\n");
				if (has_header) {
					_tmp41_ = row == 0;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					FILE* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					FILE* _tmp45_;
					_tmp42_ = stdout;
					_tmp43_ = g_strnfill ((gsize) 78, '-');
					_tmp44_ = _tmp43_;
					fprintf (_tmp42_, "%s", _tmp44_);
					_g_free0 (_tmp44_);
					_tmp45_ = stdout;
					fprintf (_tmp45_, "\n");
				}
			}
		}
	}
	col_width = (g_free (col_width), NULL);
}

static gboolean
app_console_create_snapshot (AppConsole* self,
                             gboolean ondemand)
{
	Main* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	app_console_select_snapshot_device (self, FALSE);
	_tmp0_ = App;
	result = main_create_snapshot (_tmp0_, ondemand, NULL);
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static gboolean
app_console_restore_snapshot (AppConsole* self)
{
	Main* _tmp0_;
	Main* _tmp14_;
	gboolean ok = FALSE;
	Main* _tmp15_;
	Main* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	app_console_select_snapshot_device (self, TRUE);
	app_console_select_snapshot_for_restore (self);
	_tmp0_ = App;
	if (!_tmp0_->cmd_scripted) {
		FILE* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		FILE* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		FILE* _tmp9_;
		FILE* _tmp10_;
		FILE* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "\n\n");
		_tmp2_ = g_strnfill ((gsize) 78, '*');
		_tmp3_ = _tmp2_;
		tee_jee_logging_log_msg (_tmp3_, FALSE);
		_g_free0 (_tmp3_);
		_tmp4_ = stdout;
		_tmp5_ = g_strconcat (_ ("To restore with default options, press the ENTER key for all prompts!"), "\n", NULL);
		_tmp6_ = _tmp5_;
		fprintf (_tmp4_, "%s", _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = g_strnfill ((gsize) 78, '*');
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_msg (_tmp8_, FALSE);
		_g_free0 (_tmp8_);
		_tmp9_ = stdout;
		fprintf (_tmp9_, "%s", _ ("\nPress ENTER to continue..."));
		_tmp10_ = stdout;
		fflush (_tmp10_);
		_tmp11_ = stdin;
		_tmp12_ = g_file_stream_read_line (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
	}
	app_console_init_mounts (self);
	_tmp14_ = App;
	if (!_tmp14_->btrfs_mode) {
		app_console_map_devices (self);
		app_console_select_grub_device (self);
	}
	app_console_confirm_restore (self);
	_tmp15_ = App;
	ok = main_mount_target_devices (_tmp15_, NULL);
	if (!ok) {
		result = FALSE;
		return result;
	}
	_tmp16_ = App;
	result = main_restore_snapshot (_tmp16_, NULL);
	return result;
}

static void
app_console_select_snapshot_device (AppConsole* self,
                                    gboolean prompt_if_empty)
{
	Main* _tmp0_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp1_;
	gboolean _tmp14_ = FALSE;
	Main* _tmp15_;
	SnapshotRepo* _tmp16_;
	Device* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (_tmp0_->mirror_system) {
		return;
	}
	_tmp1_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp1_;
	{
		GeeArrayList* _pi_list = NULL;
		Main* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _pi_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _pi_index = 0;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->partitions;
		_pi_list = _tmp3_;
		_tmp4_ = _pi_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_pi_size = _tmp6_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Device* pi = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			Device* _tmp11_;
			_pi_index = _pi_index + 1;
			_tmp7_ = _pi_index;
			_tmp8_ = _pi_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pi_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _pi_index);
			pi = (Device*) _tmp10_;
			_tmp11_ = pi;
			if (device_has_linux_filesystem (_tmp11_)) {
				GeeArrayList* _tmp12_;
				Device* _tmp13_;
				_tmp12_ = list;
				_tmp13_ = pi;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			}
			_g_object_unref0 (pi);
		}
	}
	_tmp15_ = App;
	_tmp16_ = _tmp15_->repo;
	_tmp17_ = _tmp16_->device;
	if (_tmp17_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		if (prompt_if_empty) {
			Main* _tmp19_;
			SnapshotRepo* _tmp20_;
			GeeArrayList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp19_ = App;
			_tmp20_ = _tmp19_->repo;
			_tmp21_ = _tmp20_->snapshots;
			_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp18_ = _tmp23_ == 0;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp14_ = _tmp18_;
	}
	if (_tmp14_) {
		Main* _tmp24_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		GeeArrayList* _tmp46_;
		Device* dev = NULL;
		gint attempts = 0;
		Device* _tmp61_;
		Main* _tmp63_;
		Device* _tmp64_;
		Main* _tmp65_;
		SnapshotRepo* _tmp66_;
		Main* _tmp67_;
		SnapshotRepo* _tmp68_;
		tee_jee_logging_log_msg ("", FALSE);
		_tmp24_ = App;
		if (_tmp24_->cmd_scripted) {
			Main* _tmp25_;
			SnapshotRepo* _tmp26_;
			Device* _tmp27_;
			Main* _tmp43_;
			_tmp25_ = App;
			_tmp26_ = _tmp25_->repo;
			_tmp27_ = _tmp26_->device;
			if (_tmp27_ == NULL) {
				Main* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp28_ = App;
				_tmp29_ = _tmp28_->backup_uuid;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ == 0) {
					gchar* status_message = NULL;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					tee_jee_logging_log_debug ("device is null");
					_tmp32_ = g_strdup (_ ("Snapshot device not selected"));
					status_message = _tmp32_;
					_tmp33_ = status_message;
					tee_jee_logging_log_msg (_tmp33_, FALSE);
					_g_free0 (status_message);
				} else {
					gchar* status_message = NULL;
					gchar* _tmp34_;
					gchar* status_details = NULL;
					Main* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp34_ = g_strdup (_ ("Snapshot device not available"));
					status_message = _tmp34_;
					_tmp35_ = App;
					_tmp36_ = _tmp35_->backup_uuid;
					_tmp37_ = g_strdup_printf (": UUID='%s'", _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strconcat (_ ("Device not found"), _tmp38_, NULL);
					_tmp40_ = _tmp39_;
					_g_free0 (_tmp38_);
					status_details = _tmp40_;
					_tmp41_ = status_message;
					tee_jee_logging_log_msg (_tmp41_, FALSE);
					_tmp42_ = status_details;
					tee_jee_logging_log_msg (_tmp42_, FALSE);
					_g_free0 (status_details);
					_g_free0 (status_message);
				}
			}
			_tmp43_ = App;
			main_exit_app (_tmp43_, 1);
		}
		_tmp44_ = g_strconcat (_ ("Select backup device"), ":\n", NULL);
		_tmp45_ = _tmp44_;
		tee_jee_logging_log_msg (_tmp45_, FALSE);
		_g_free0 (_tmp45_);
		_tmp46_ = list;
		app_console_list_devices (self, _tmp46_);
		tee_jee_logging_log_msg ("", FALSE);
		dev = NULL;
		attempts = 0;
		while (TRUE) {
			Device* _tmp47_;
			gint _tmp48_;
			FILE* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			FILE* _tmp54_;
			GeeArrayList* _tmp55_;
			Device* _tmp56_;
			gboolean _tmp57_ = FALSE;
			Main* _tmp58_;
			_tmp47_ = dev;
			if (!(_tmp47_ == NULL)) {
				break;
			}
			_tmp48_ = attempts;
			attempts = _tmp48_ + 1;
			if (attempts > 3) {
				break;
			}
			_tmp49_ = stdout;
			_tmp50_ = g_strconcat ("", _ ("Enter device name or number (a=Abort)"), NULL);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp51_, ": ", NULL);
			_tmp53_ = _tmp52_;
			fprintf (_tmp49_, "%s", _tmp53_);
			_g_free0 (_tmp53_);
			_g_free0 (_tmp51_);
			_tmp54_ = stdout;
			fflush (_tmp54_);
			_tmp55_ = list;
			_tmp56_ = app_console_read_stdin_device (self, _tmp55_, "");
			_g_object_unref0 (dev);
			dev = _tmp56_;
			_tmp58_ = App;
			if (_tmp58_->btrfs_mode) {
				Main* _tmp59_;
				Device* _tmp60_;
				_tmp59_ = App;
				_tmp60_ = dev;
				_tmp57_ = !main_check_device_for_backup (_tmp59_, _tmp60_, TRUE);
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				tee_jee_logging_log_error (_ ("Selected snapshot device is not a system disk"), FALSE, FALSE);
				tee_jee_logging_log_error (_ ("Select BTRFS system disk with root subvolume (@)"), FALSE, FALSE);
				_g_object_unref0 (dev);
				dev = NULL;
			}
		}
		tee_jee_logging_log_msg ("", FALSE);
		_tmp61_ = dev;
		if (_tmp61_ == NULL) {
			Main* _tmp62_;
			tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
			tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
			_tmp62_ = App;
			main_exit_app (_tmp62_, 1);
		}
		_tmp63_ = App;
		_tmp64_ = dev;
		_tmp65_ = App;
		_tmp66_ = snapshot_repo_new_from_device (_tmp64_, NULL, _tmp65_->btrfs_mode);
		_g_object_unref0 (_tmp63_->repo);
		_tmp63_->repo = _tmp66_;
		_tmp67_ = App;
		_tmp68_ = _tmp67_->repo;
		if (!snapshot_repo_available (_tmp68_)) {
			Main* _tmp69_;
			_tmp69_ = App;
			main_exit_app (_tmp69_, 1);
		}
		_g_object_unref0 (dev);
	}
	_g_object_unref0 (list);
}

static Snapshot*
app_console_select_snapshot (AppConsole* self)
{
	Snapshot* selected_snapshot = NULL;
	Main* _tmp0_;
	Main* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Snapshot* _tmp25_;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	selected_snapshot = NULL;
	tee_jee_logging_log_debug ("AppConsole: select_snapshot()");
	_tmp0_ = App;
	if (_tmp0_->mirror_system) {
		result = NULL;
		_g_object_unref0 (selected_snapshot);
		return result;
	}
	_tmp1_ = App;
	_tmp2_ = _tmp1_->cmd_snapshot;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gboolean found = FALSE;
		found = FALSE;
		{
			GeeArrayList* _bak_list = NULL;
			Main* _tmp5_;
			SnapshotRepo* _tmp6_;
			GeeArrayList* _tmp7_;
			gint _bak_size = 0;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _bak_index = 0;
			_tmp5_ = App;
			_tmp6_ = _tmp5_->repo;
			_tmp7_ = _tmp6_->snapshots;
			_bak_list = _tmp7_;
			_tmp8_ = _bak_list;
			_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_bak_size = _tmp10_;
			_bak_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				Snapshot* bak = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				Snapshot* _tmp15_;
				const gchar* _tmp16_;
				Main* _tmp17_;
				const gchar* _tmp18_;
				_bak_index = _bak_index + 1;
				_tmp11_ = _bak_index;
				_tmp12_ = _bak_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _bak_list;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _bak_index);
				bak = (Snapshot*) _tmp14_;
				_tmp15_ = bak;
				_tmp16_ = _tmp15_->name;
				_tmp17_ = App;
				_tmp18_ = _tmp17_->cmd_snapshot;
				if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
					result = bak;
					_g_object_unref0 (selected_snapshot);
					return result;
				}
				_g_object_unref0 (bak);
			}
		}
		if (!found) {
			Main* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp19_ = App;
			_tmp20_ = _tmp19_->cmd_snapshot;
			_tmp21_ = g_strdup_printf (": '%s'", _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_ ("Could not find snapshot"), _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			tee_jee_logging_log_error (_tmp24_, FALSE, FALSE);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			result = NULL;
			_g_object_unref0 (selected_snapshot);
			return result;
		}
	}
	_tmp25_ = selected_snapshot;
	if (_tmp25_ == NULL) {
		Main* _tmp26_;
		SnapshotRepo* _tmp27_;
		Main* _tmp37_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gint attempts = 0;
		Snapshot* _tmp48_;
		_tmp26_ = App;
		_tmp27_ = _tmp26_->repo;
		if (!snapshot_repo_has_snapshots (_tmp27_)) {
			Main* _tmp28_;
			SnapshotRepo* _tmp29_;
			Device* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			Main* _tmp36_;
			_tmp28_ = App;
			_tmp29_ = _tmp28_->repo;
			_tmp30_ = _tmp29_->device;
			_tmp31_ = _tmp30_->device;
			_tmp32_ = g_strdup_printf (": '%s'", _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_ ("No snapshots found on device"), _tmp33_, NULL);
			_tmp35_ = _tmp34_;
			tee_jee_logging_log_error (_tmp35_, FALSE, FALSE);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = App;
			main_exit_app (_tmp36_, 0);
			result = NULL;
			_g_object_unref0 (selected_snapshot);
			return result;
		}
		_tmp37_ = App;
		if (_tmp37_->cmd_scripted) {
			Main* _tmp38_;
			tee_jee_logging_log_error ("No snapshots selected. Use --snapshot to specify snapshots", FALSE, FALSE);
			_tmp38_ = App;
			main_exit_app (_tmp38_, 1);
			result = NULL;
			_g_object_unref0 (selected_snapshot);
			return result;
		}
		tee_jee_logging_log_msg ("", FALSE);
		_tmp39_ = g_strconcat (_ ("Select snapshot"), ":\n", NULL);
		_tmp40_ = _tmp39_;
		tee_jee_logging_log_msg (_tmp40_, FALSE);
		_g_free0 (_tmp40_);
		app_console_list_snapshots (self, TRUE, 20);
		tee_jee_logging_log_msg ("", FALSE);
		attempts = 0;
		while (TRUE) {
			Snapshot* _tmp41_;
			gint _tmp42_;
			FILE* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			FILE* _tmp46_;
			Snapshot* _tmp47_;
			_tmp41_ = selected_snapshot;
			if (!(_tmp41_ == NULL)) {
				break;
			}
			_tmp42_ = attempts;
			attempts = _tmp42_ + 1;
			if (attempts > 3) {
				break;
			}
			_tmp43_ = stdout;
			_tmp44_ = g_strconcat (_ ("Enter snapshot number (a=Abort, p=Previous, n=Next)"), ": ", NULL);
			_tmp45_ = _tmp44_;
			fprintf (_tmp43_, "%s", _tmp45_);
			_g_free0 (_tmp45_);
			_tmp46_ = stdout;
			fflush (_tmp46_);
			_tmp47_ = app_console_read_stdin_snapshot (self);
			_g_object_unref0 (selected_snapshot);
			selected_snapshot = _tmp47_;
		}
		tee_jee_logging_log_msg ("", FALSE);
		_tmp48_ = selected_snapshot;
		if (_tmp48_ == NULL) {
			Main* _tmp49_;
			tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
			tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
			_tmp49_ = App;
			main_exit_app (_tmp49_, 0);
		}
	}
	result = selected_snapshot;
	return result;
}

static void
app_console_select_snapshot_for_restore (AppConsole* self)
{
	Main* _tmp0_;
	Snapshot* _tmp1_;
	Main* _tmp2_;
	Snapshot* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = app_console_select_snapshot (self);
	_g_object_unref0 (_tmp0_->snapshot_to_restore);
	_tmp0_->snapshot_to_restore = _tmp1_;
	_tmp2_ = App;
	_tmp3_ = _tmp2_->snapshot_to_restore;
	if (_tmp3_ == NULL) {
		Main* _tmp4_;
		tee_jee_logging_log_error ("Snapshot not selected", FALSE, FALSE);
		_tmp4_ = App;
		main_exit_app (_tmp4_, 1);
	}
}

static void
app_console_select_snapshot_for_deletion (AppConsole* self)
{
	Main* _tmp0_;
	Snapshot* _tmp1_;
	Main* _tmp2_;
	Snapshot* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = app_console_select_snapshot (self);
	_g_object_unref0 (_tmp0_->snapshot_to_delete);
	_tmp0_->snapshot_to_delete = _tmp1_;
	_tmp2_ = App;
	_tmp3_ = _tmp2_->snapshot_to_delete;
	if (_tmp3_ == NULL) {
		Main* _tmp4_;
		tee_jee_logging_log_error ("Snapshot not selected", FALSE, FALSE);
		_tmp4_ = App;
		main_exit_app (_tmp4_, 1);
	}
}

static void
app_console_init_mounts (AppConsole* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("AppConsole: init_mounts()");
	_tmp0_ = App;
	main_init_mount_list (_tmp0_);
	{
		gint i = 0;
		Main* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = App;
		_tmp2_ = _tmp1_->mount_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		i = _tmp4_ - 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				MountEntry* entry = NULL;
				Main* _tmp7_;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				MountEntry* _tmp10_;
				Device* _tmp11_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ - 1;
				}
				_tmp5_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp7_ = App;
				_tmp8_ = _tmp7_->mount_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, i);
				entry = (MountEntry*) _tmp9_;
				_tmp10_ = entry;
				_tmp11_ = _tmp10_->device;
				if (_tmp11_ == NULL) {
					Main* _tmp12_;
					GeeArrayList* _tmp13_;
					MountEntry* _tmp14_;
					_tmp12_ = App;
					_tmp13_ = _tmp12_->mount_list;
					_tmp14_ = entry;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				}
				_g_object_unref0 (entry);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
app_console_map_devices (AppConsole* self)
{
	Main* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("AppConsole: map_devices()");
	_tmp0_ = App;
	_tmp1_ = _tmp0_->cmd_target_device;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gboolean found = FALSE;
		found = FALSE;
		{
			GeeArrayList* _pi_list = NULL;
			Main* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _pi_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _pi_index = 0;
			_tmp4_ = App;
			_tmp5_ = _tmp4_->partitions;
			_pi_list = _tmp5_;
			_tmp6_ = _pi_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_pi_size = _tmp8_;
			_pi_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				Device* pi = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				Device* _tmp13_;
				gboolean _tmp14_ = FALSE;
				Device* _tmp15_;
				const gchar* _tmp16_;
				Main* _tmp17_;
				const gchar* _tmp18_;
				_pi_index = _pi_index + 1;
				_tmp9_ = _pi_index;
				_tmp10_ = _pi_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _pi_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _pi_index);
				pi = (Device*) _tmp12_;
				_tmp13_ = pi;
				if (!device_has_linux_filesystem (_tmp13_)) {
					_g_object_unref0 (pi);
					continue;
				}
				_tmp15_ = pi;
				_tmp16_ = _tmp15_->device;
				_tmp17_ = App;
				_tmp18_ = _tmp17_->cmd_target_device;
				if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
					_tmp14_ = TRUE;
				} else {
					Device* _tmp19_;
					const gchar* _tmp20_;
					Main* _tmp21_;
					const gchar* _tmp22_;
					_tmp19_ = pi;
					_tmp20_ = _tmp19_->uuid;
					_tmp21_ = App;
					_tmp22_ = _tmp21_->cmd_target_device;
					_tmp14_ = g_strcmp0 (_tmp20_, _tmp22_) == 0;
				}
				if (_tmp14_) {
					Main* _tmp23_;
					Device* _tmp24_;
					_tmp23_ = App;
					_tmp24_ = pi;
					main_set_dst_root (_tmp23_, _tmp24_);
					found = TRUE;
					_g_object_unref0 (pi);
					break;
				} else {
					{
						GeeArrayList* _symlink_list = NULL;
						Device* _tmp25_;
						GeeArrayList* _tmp26_;
						gint _symlink_size = 0;
						GeeArrayList* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						gint _symlink_index = 0;
						_tmp25_ = pi;
						_tmp26_ = _tmp25_->symlinks;
						_symlink_list = _tmp26_;
						_tmp27_ = _symlink_list;
						_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
						_tmp29_ = _tmp28_;
						_symlink_size = _tmp29_;
						_symlink_index = -1;
						while (TRUE) {
							gint _tmp30_;
							gint _tmp31_;
							gchar* symlink = NULL;
							GeeArrayList* _tmp32_;
							gpointer _tmp33_;
							const gchar* _tmp34_;
							Main* _tmp35_;
							const gchar* _tmp36_;
							_symlink_index = _symlink_index + 1;
							_tmp30_ = _symlink_index;
							_tmp31_ = _symlink_size;
							if (!(_tmp30_ < _tmp31_)) {
								break;
							}
							_tmp32_ = _symlink_list;
							_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _symlink_index);
							symlink = (gchar*) _tmp33_;
							_tmp34_ = symlink;
							_tmp35_ = App;
							_tmp36_ = _tmp35_->cmd_target_device;
							if (g_strcmp0 (_tmp34_, _tmp36_) == 0) {
								Main* _tmp37_;
								Device* _tmp38_;
								_tmp37_ = App;
								_tmp38_ = pi;
								main_set_dst_root (_tmp37_, _tmp38_);
								found = TRUE;
								_g_free0 (symlink);
								break;
							}
							_g_free0 (symlink);
						}
					}
					if (found) {
						_g_object_unref0 (pi);
						break;
					}
				}
				_g_object_unref0 (pi);
			}
		}
		if (!found) {
			Main* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			Main* _tmp45_;
			_tmp39_ = App;
			_tmp40_ = _tmp39_->cmd_target_device;
			_tmp41_ = g_strdup_printf (": '%s'", _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_ ("Could not find device"), _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			tee_jee_logging_log_error (_tmp44_, FALSE, FALSE);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_tmp45_ = App;
			main_exit_app (_tmp45_, 1);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				Main* _tmp48_;
				GeeArrayList* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				MountEntry* mnt = NULL;
				Main* _tmp52_;
				GeeArrayList* _tmp53_;
				gpointer _tmp54_;
				Device* dev = NULL;
				gchar* default_device = NULL;
				gchar* _tmp55_;
				MountEntry* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_ = FALSE;
				Main* _tmp62_;
				Device* _tmp63_;
				Device* _tmp64_;
				Main* _tmp74_;
				Main* _tmp99_;
				Device* _tmp107_;
				Device* _tmp135_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = App;
				_tmp49_ = _tmp48_->mount_list;
				_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
				_tmp51_ = _tmp50_;
				if (!(i < _tmp51_)) {
					break;
				}
				_tmp52_ = App;
				_tmp53_ = _tmp52_->mount_list;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, i);
				mnt = (MountEntry*) _tmp54_;
				dev = NULL;
				_tmp55_ = g_strdup ("");
				default_device = _tmp55_;
				_tmp56_ = mnt;
				_tmp57_ = _tmp56_->mount_point;
				_tmp58_ = g_strdup_printf ("selecting: %s", _tmp57_);
				_tmp59_ = _tmp58_;
				tee_jee_logging_log_debug (_tmp59_);
				_g_free0 (_tmp59_);
				_tmp62_ = App;
				_tmp63_ = main_get_dst_root (_tmp62_);
				_tmp64_ = _tmp63_;
				if (_tmp64_ != NULL) {
					Main* _tmp65_;
					Device* _tmp66_;
					_tmp65_ = App;
					_tmp66_ = _tmp65_->sys_root;
					_tmp61_ = _tmp66_ != NULL;
				} else {
					_tmp61_ = FALSE;
				}
				if (_tmp61_) {
					Main* _tmp67_;
					Device* _tmp68_;
					Device* _tmp69_;
					const gchar* _tmp70_;
					Main* _tmp71_;
					Device* _tmp72_;
					const gchar* _tmp73_;
					_tmp67_ = App;
					_tmp68_ = main_get_dst_root (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = _tmp69_->uuid;
					_tmp71_ = App;
					_tmp72_ = _tmp71_->sys_root;
					_tmp73_ = _tmp72_->uuid;
					_tmp60_ = g_strcmp0 (_tmp70_, _tmp73_) == 0;
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					_g_free0 (default_device);
					_g_object_unref0 (dev);
					_g_object_unref0 (mnt);
					break;
				}
				_tmp74_ = App;
				if (_tmp74_->mirror_system) {
					const gchar* _tmp75_ = NULL;
					Main* _tmp76_;
					Device* _tmp77_;
					Device* _tmp78_;
					gchar* _tmp83_;
					_tmp76_ = App;
					_tmp77_ = main_get_dst_root (_tmp76_);
					_tmp78_ = _tmp77_;
					if (_tmp78_ != NULL) {
						Main* _tmp79_;
						Device* _tmp80_;
						Device* _tmp81_;
						const gchar* _tmp82_;
						_tmp79_ = App;
						_tmp80_ = main_get_dst_root (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = _tmp81_->device;
						_tmp75_ = _tmp82_;
					} else {
						_tmp75_ = "";
					}
					_tmp83_ = g_strdup (_tmp75_);
					_g_free0 (default_device);
					default_device = _tmp83_;
				} else {
					MountEntry* _tmp84_;
					Device* _tmp85_;
					_tmp84_ = mnt;
					_tmp85_ = _tmp84_->device;
					if (_tmp85_ != NULL) {
						MountEntry* _tmp86_;
						Device* _tmp87_;
						const gchar* _tmp88_;
						gchar* _tmp89_;
						_tmp86_ = mnt;
						_tmp87_ = _tmp86_->device;
						_tmp88_ = _tmp87_->device;
						_tmp89_ = g_strdup (_tmp88_);
						_g_free0 (default_device);
						default_device = _tmp89_;
					} else {
						const gchar* _tmp90_ = NULL;
						Main* _tmp91_;
						Device* _tmp92_;
						Device* _tmp93_;
						gchar* _tmp98_;
						_tmp91_ = App;
						_tmp92_ = main_get_dst_root (_tmp91_);
						_tmp93_ = _tmp92_;
						if (_tmp93_ != NULL) {
							Main* _tmp94_;
							Device* _tmp95_;
							Device* _tmp96_;
							const gchar* _tmp97_;
							_tmp94_ = App;
							_tmp95_ = main_get_dst_root (_tmp94_);
							_tmp96_ = _tmp95_;
							_tmp97_ = _tmp96_->device;
							_tmp90_ = _tmp97_;
						} else {
							_tmp90_ = "";
						}
						_tmp98_ = g_strdup (_tmp90_);
						_g_free0 (default_device);
						default_device = _tmp98_;
					}
				}
				_tmp99_ = App;
				if (_tmp99_->cmd_scripted) {
					const gchar* _tmp100_;
					Device* _tmp101_;
					Device* _tmp102_;
					_tmp100_ = default_device;
					_tmp101_ = device_get_device_by_name (_tmp100_);
					_g_object_unref0 (dev);
					dev = _tmp101_;
					_tmp102_ = dev;
					if (_tmp102_ == NULL) {
						const gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						Main* _tmp106_;
						_tmp103_ = default_device;
						_tmp104_ = g_strdup_printf ("Failed to get device by name %s", _tmp103_);
						_tmp105_ = _tmp104_;
						tee_jee_logging_log_error (_tmp105_, FALSE, FALSE);
						_g_free0 (_tmp105_);
						_tmp106_ = App;
						main_exit_app (_tmp106_, 1);
					}
				}
				_tmp107_ = dev;
				if (_tmp107_ == NULL) {
					MountEntry* _tmp108_;
					const gchar* _tmp109_;
					const gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					GeeArrayList* device_list = NULL;
					GeeArrayList* _tmp115_;
					gint attempts = 0;
					Device* _tmp133_;
					tee_jee_logging_log_msg ("", FALSE);
					_tmp108_ = mnt;
					_tmp109_ = _tmp108_->mount_point;
					_tmp110_ = default_device;
					_tmp111_ = g_strdup_printf (_ ("Select '%s' device (default = %s)"), _tmp109_, _tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = g_strconcat (_tmp112_, ":\n", NULL);
					_tmp114_ = _tmp113_;
					tee_jee_logging_log_msg (_tmp114_, FALSE);
					_g_free0 (_tmp114_);
					_g_free0 (_tmp112_);
					_tmp115_ = app_console_list_all_devices (self);
					device_list = _tmp115_;
					tee_jee_logging_log_msg ("", FALSE);
					attempts = 0;
					while (TRUE) {
						Device* _tmp116_;
						gint _tmp117_;
						FILE* _tmp118_;
						const gchar* _tmp119_;
						gchar* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						FILE* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						FILE* _tmp129_;
						GeeArrayList* _tmp130_;
						MountEntry* _tmp131_;
						Device* _tmp132_;
						_tmp116_ = dev;
						if (!(_tmp116_ == NULL)) {
							break;
						}
						_tmp117_ = attempts;
						attempts = _tmp117_ + 1;
						if (attempts > 3) {
							break;
						}
						_tmp118_ = stdout;
						_tmp119_ = default_device;
						_tmp120_ = g_strdup_printf (_ ("[ENTER = Default (%s), r = Root device, a = Abort]"), _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = g_strconcat ("", _tmp121_, NULL);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_strconcat (_tmp123_, "\n\n", NULL);
						_tmp125_ = _tmp124_;
						fprintf (_tmp118_, "%s", _tmp125_);
						_g_free0 (_tmp125_);
						_g_free0 (_tmp123_);
						_g_free0 (_tmp121_);
						_tmp126_ = stdout;
						_tmp127_ = g_strconcat (_ ("Enter device name or number"), ": ", NULL);
						_tmp128_ = _tmp127_;
						fprintf (_tmp126_, "%s", _tmp128_);
						_g_free0 (_tmp128_);
						_tmp129_ = stdout;
						fflush (_tmp129_);
						_tmp130_ = device_list;
						_tmp131_ = mnt;
						_tmp132_ = app_console_read_stdin_device_mounts (self, _tmp130_, _tmp131_);
						_g_object_unref0 (dev);
						dev = _tmp132_;
					}
					tee_jee_logging_log_msg ("", FALSE);
					_tmp133_ = dev;
					if (_tmp133_ == NULL) {
						Main* _tmp134_;
						tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
						tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
						_tmp134_ = App;
						main_exit_app (_tmp134_, 0);
					}
					_g_object_unref0 (device_list);
				}
				_tmp135_ = dev;
				if (_tmp135_ != NULL) {
					Device* _tmp136_;
					const gchar* _tmp137_;
					gchar* _tmp138_;
					gchar* _tmp139_;
					MountEntry* _tmp140_;
					Device* _tmp141_;
					Device* _tmp142_;
					gchar* _tmp143_;
					gchar* _tmp144_;
					gboolean _tmp145_ = FALSE;
					gboolean _tmp146_ = FALSE;
					MountEntry* _tmp147_;
					const gchar* _tmp148_;
					gchar* _tmp171_;
					gchar* _tmp172_;
					_tmp136_ = dev;
					_tmp137_ = _tmp136_->uuid;
					_tmp138_ = g_strdup_printf ("selected: %s", _tmp137_);
					_tmp139_ = _tmp138_;
					tee_jee_logging_log_debug (_tmp139_);
					_g_free0 (_tmp139_);
					_tmp140_ = mnt;
					_tmp141_ = dev;
					_tmp142_ = _g_object_ref0 (_tmp141_);
					_g_object_unref0 (_tmp140_->device);
					_tmp140_->device = _tmp142_;
					_tmp143_ = g_strnfill ((gsize) 78, '*');
					_tmp144_ = _tmp143_;
					tee_jee_logging_log_msg (_tmp144_, FALSE);
					_g_free0 (_tmp144_);
					_tmp147_ = mnt;
					_tmp148_ = _tmp147_->mount_point;
					if (g_strcmp0 (_tmp148_, "/") != 0) {
						Main* _tmp149_;
						Device* _tmp150_;
						Device* _tmp151_;
						_tmp149_ = App;
						_tmp150_ = main_get_dst_root (_tmp149_);
						_tmp151_ = _tmp150_;
						_tmp146_ = _tmp151_ != NULL;
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						Device* _tmp152_;
						const gchar* _tmp153_;
						Main* _tmp154_;
						Device* _tmp155_;
						Device* _tmp156_;
						const gchar* _tmp157_;
						_tmp152_ = dev;
						_tmp153_ = _tmp152_->device;
						_tmp154_ = App;
						_tmp155_ = main_get_dst_root (_tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = _tmp156_->device;
						_tmp145_ = g_strcmp0 (_tmp153_, _tmp157_) == 0;
					} else {
						_tmp145_ = FALSE;
					}
					if (_tmp145_) {
						MountEntry* _tmp158_;
						const gchar* _tmp159_;
						gchar* _tmp160_;
						gchar* _tmp161_;
						_tmp158_ = mnt;
						_tmp159_ = _tmp158_->mount_point;
						_tmp160_ = g_strdup_printf (_ ("'%s' will be on root device"), _tmp159_);
						_tmp161_ = _tmp160_;
						tee_jee_logging_log_msg (_tmp161_, TRUE);
						_g_free0 (_tmp161_);
					} else {
						MountEntry* _tmp162_;
						const gchar* _tmp163_;
						MountEntry* _tmp164_;
						Device* _tmp165_;
						gchar* _tmp166_;
						gchar* _tmp167_;
						gchar* _tmp168_;
						gchar* _tmp169_;
						gchar* _tmp170_;
						_tmp162_ = mnt;
						_tmp163_ = _tmp162_->mount_point;
						_tmp164_ = mnt;
						_tmp165_ = _tmp164_->device;
						_tmp166_ = device_get_short_name_with_alias (_tmp165_);
						_tmp167_ = _tmp166_;
						_tmp168_ = _tmp167_;
						_tmp169_ = g_strdup_printf (_ ("'%s' will be on '%s'"), _tmp163_, _tmp168_);
						_tmp170_ = _tmp169_;
						tee_jee_logging_log_msg (_tmp170_, TRUE);
						_g_free0 (_tmp170_);
						_g_free0 (_tmp168_);
					}
					_tmp171_ = g_strnfill ((gsize) 78, '*');
					_tmp172_ = _tmp171_;
					tee_jee_logging_log_msg (_tmp172_, FALSE);
					_g_free0 (_tmp172_);
				}
				_g_free0 (default_device);
				_g_object_unref0 (dev);
				_g_object_unref0 (mnt);
			}
		}
	}
}

static void
app_console_select_grub_device (AppConsole* self)
{
	gchar* grub_device_default = NULL;
	Main* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean grub_reinstall_default = FALSE;
	Main* _tmp3_;
	Main* _tmp4_;
	Main* _tmp5_;
	gchar* _tmp6_;
	Main* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Main* _tmp63_;
	gboolean _tmp87_ = FALSE;
	Main* _tmp88_;
	gboolean _tmp148_ = FALSE;
	Main* _tmp149_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = _tmp0_->grub_device;
	_tmp2_ = g_strdup (_tmp1_);
	grub_device_default = _tmp2_;
	_tmp3_ = App;
	grub_reinstall_default = _tmp3_->reinstall_grub2;
	_tmp4_ = App;
	_tmp4_->reinstall_grub2 = FALSE;
	_tmp5_ = App;
	_tmp6_ = g_strdup ("");
	_g_free0 (_tmp5_->grub_device);
	_tmp5_->grub_device = _tmp6_;
	_tmp7_ = App;
	_tmp8_ = _tmp7_->cmd_grub_device;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		gboolean found = FALSE;
		GeeArrayList* device_list = NULL;
		GeeArrayList* _tmp11_;
		tee_jee_logging_log_debug ("Grub device is specified as command argument");
		found = FALSE;
		_tmp11_ = app_console_list_grub_devices (self, FALSE);
		device_list = _tmp11_;
		{
			GeeArrayList* _dev_list = NULL;
			GeeArrayList* _tmp12_;
			gint _dev_size = 0;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _dev_index = 0;
			_tmp12_ = device_list;
			_dev_list = _tmp12_;
			_tmp13_ = _dev_list;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_dev_size = _tmp15_;
			_dev_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				Device* dev = NULL;
				GeeArrayList* _tmp18_;
				gpointer _tmp19_;
				gboolean _tmp20_ = FALSE;
				Device* _tmp21_;
				const gchar* _tmp22_;
				Main* _tmp23_;
				const gchar* _tmp24_;
				_dev_index = _dev_index + 1;
				_tmp16_ = _dev_index;
				_tmp17_ = _dev_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _dev_list;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _dev_index);
				dev = (Device*) _tmp19_;
				_tmp21_ = dev;
				_tmp22_ = _tmp21_->device;
				_tmp23_ = App;
				_tmp24_ = _tmp23_->cmd_grub_device;
				if (g_strcmp0 (_tmp22_, _tmp24_) == 0) {
					_tmp20_ = TRUE;
				} else {
					gboolean _tmp25_ = FALSE;
					Device* _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp26_ = dev;
					_tmp27_ = _tmp26_->uuid;
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					if (_tmp29_ > 0) {
						Device* _tmp30_;
						const gchar* _tmp31_;
						Main* _tmp32_;
						const gchar* _tmp33_;
						_tmp30_ = dev;
						_tmp31_ = _tmp30_->uuid;
						_tmp32_ = App;
						_tmp33_ = _tmp32_->cmd_grub_device;
						_tmp25_ = g_strcmp0 (_tmp31_, _tmp33_) == 0;
					} else {
						_tmp25_ = FALSE;
					}
					_tmp20_ = _tmp25_;
				}
				if (_tmp20_) {
					Main* _tmp34_;
					Device* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp34_ = App;
					_tmp35_ = dev;
					_tmp36_ = _tmp35_->device;
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (_tmp34_->grub_device);
					_tmp34_->grub_device = _tmp37_;
					found = TRUE;
					_g_object_unref0 (dev);
					break;
				} else {
					Device* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = dev;
					_tmp39_ = _tmp38_->type;
					if (g_strcmp0 (_tmp39_, "part") == 0) {
						{
							GeeArrayList* _symlink_list = NULL;
							Device* _tmp40_;
							GeeArrayList* _tmp41_;
							gint _symlink_size = 0;
							GeeArrayList* _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gint _symlink_index = 0;
							_tmp40_ = dev;
							_tmp41_ = _tmp40_->symlinks;
							_symlink_list = _tmp41_;
							_tmp42_ = _symlink_list;
							_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
							_tmp44_ = _tmp43_;
							_symlink_size = _tmp44_;
							_symlink_index = -1;
							while (TRUE) {
								gint _tmp45_;
								gint _tmp46_;
								gchar* symlink = NULL;
								GeeArrayList* _tmp47_;
								gpointer _tmp48_;
								const gchar* _tmp49_;
								Main* _tmp50_;
								const gchar* _tmp51_;
								_symlink_index = _symlink_index + 1;
								_tmp45_ = _symlink_index;
								_tmp46_ = _symlink_size;
								if (!(_tmp45_ < _tmp46_)) {
									break;
								}
								_tmp47_ = _symlink_list;
								_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _symlink_index);
								symlink = (gchar*) _tmp48_;
								_tmp49_ = symlink;
								_tmp50_ = App;
								_tmp51_ = _tmp50_->cmd_grub_device;
								if (g_strcmp0 (_tmp49_, _tmp51_) == 0) {
									Main* _tmp52_;
									Device* _tmp53_;
									const gchar* _tmp54_;
									gchar* _tmp55_;
									_tmp52_ = App;
									_tmp53_ = dev;
									_tmp54_ = _tmp53_->device;
									_tmp55_ = g_strdup (_tmp54_);
									_g_free0 (_tmp52_->grub_device);
									_tmp52_->grub_device = _tmp55_;
									found = TRUE;
									_g_free0 (symlink);
									break;
								}
								_g_free0 (symlink);
							}
						}
						if (found) {
							_g_object_unref0 (dev);
							break;
						}
					}
				}
				_g_object_unref0 (dev);
			}
		}
		if (!found) {
			Main* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			Main* _tmp62_;
			_tmp56_ = App;
			_tmp57_ = _tmp56_->cmd_grub_device;
			_tmp58_ = g_strdup_printf (": '%s'", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_ ("Could not find device"), _tmp59_, NULL);
			_tmp61_ = _tmp60_;
			tee_jee_logging_log_error (_tmp61_, FALSE, FALSE);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp59_);
			_tmp62_ = App;
			main_exit_app (_tmp62_, 1);
			_g_object_unref0 (device_list);
			_g_free0 (grub_device_default);
			return;
		}
		_g_object_unref0 (device_list);
	}
	_tmp63_ = App;
	if (_tmp63_->mirror_system) {
		Main* _tmp64_;
		_tmp64_ = App;
		_tmp64_->reinstall_grub2 = TRUE;
	} else {
		gboolean _tmp65_ = FALSE;
		Main* _tmp66_;
		_tmp66_ = App;
		if (_tmp66_->cmd_skip_grub == FALSE) {
			Main* _tmp67_;
			_tmp67_ = App;
			_tmp65_ = _tmp67_->reinstall_grub2 == FALSE;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			Main* _tmp68_;
			tee_jee_logging_log_msg ("", FALSE);
			_tmp68_ = App;
			if (_tmp68_->cmd_scripted) {
				Main* _tmp69_;
				_tmp69_ = App;
				_tmp69_->reinstall_grub2 = grub_reinstall_default;
			} else {
				Main* _tmp70_;
				_tmp70_ = App;
				if (_tmp70_->cmd_confirm) {
					Main* _tmp71_;
					_tmp71_ = App;
					_tmp71_->reinstall_grub2 = TRUE;
				} else {
					gint attempts = 0;
					gboolean _tmp83_ = FALSE;
					Main* _tmp84_;
					attempts = 0;
					while (TRUE) {
						gboolean _tmp72_ = FALSE;
						Main* _tmp73_;
						gint _tmp75_;
						const gchar* _tmp76_ = NULL;
						FILE* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						FILE* _tmp82_;
						_tmp73_ = App;
						if (_tmp73_->cmd_skip_grub == FALSE) {
							Main* _tmp74_;
							_tmp74_ = App;
							_tmp72_ = _tmp74_->reinstall_grub2 == FALSE;
						} else {
							_tmp72_ = FALSE;
						}
						if (!_tmp72_) {
							break;
						}
						_tmp75_ = attempts;
						attempts = _tmp75_ + 1;
						if (attempts > 3) {
							break;
						}
						if (grub_reinstall_default) {
							_tmp76_ = " (recommended)";
						} else {
							_tmp76_ = "";
						}
						_tmp77_ = stdout;
						_tmp78_ = g_strconcat (_ ("Re-install GRUB2 bootloader?"), _tmp76_, NULL);
						_tmp79_ = _tmp78_;
						_tmp80_ = g_strconcat (_tmp79_, " (y/n): ", NULL);
						_tmp81_ = _tmp80_;
						fprintf (_tmp77_, "%s", _tmp81_);
						_g_free0 (_tmp81_);
						_g_free0 (_tmp79_);
						_tmp82_ = stdout;
						fflush (_tmp82_);
						app_console_read_stdin_grub_install (self, grub_reinstall_default);
					}
					_tmp84_ = App;
					if (_tmp84_->cmd_skip_grub == FALSE) {
						Main* _tmp85_;
						_tmp85_ = App;
						_tmp83_ = _tmp85_->reinstall_grub2 == FALSE;
					} else {
						_tmp83_ = FALSE;
					}
					if (_tmp83_) {
						Main* _tmp86_;
						tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
						tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
						_tmp86_ = App;
						main_exit_app (_tmp86_, 0);
					}
				}
			}
		}
	}
	_tmp88_ = App;
	if (_tmp88_->reinstall_grub2) {
		Main* _tmp89_;
		const gchar* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		_tmp89_ = App;
		_tmp90_ = _tmp89_->grub_device;
		_tmp91_ = strlen (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp87_ = _tmp92_ == 0;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		gchar* _tmp93_;
		gchar* _tmp94_;
		GeeArrayList* device_list = NULL;
		GeeArrayList* _tmp95_;
		Device* dev = NULL;
		Main* _tmp96_;
		Device* _tmp143_;
		tee_jee_logging_log_msg ("", FALSE);
		_tmp93_ = g_strconcat (_ ("Select GRUB device"), ":\n", NULL);
		_tmp94_ = _tmp93_;
		tee_jee_logging_log_msg (_tmp94_, FALSE);
		_g_free0 (_tmp94_);
		_tmp95_ = app_console_list_grub_devices (self, TRUE);
		device_list = _tmp95_;
		tee_jee_logging_log_msg ("", FALSE);
		dev = NULL;
		_tmp96_ = App;
		if (_tmp96_->cmd_scripted) {
			const gchar* _tmp97_;
			Device* _tmp98_;
			Device* _tmp99_;
			_tmp97_ = grub_device_default;
			_tmp98_ = device_get_device_by_name (_tmp97_);
			_g_object_unref0 (dev);
			dev = _tmp98_;
			_tmp99_ = dev;
			if (_tmp99_ == NULL) {
				const gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
				Main* _tmp103_;
				_tmp100_ = grub_device_default;
				_tmp101_ = g_strdup_printf ("Failed to get grub device by name %s", _tmp100_);
				_tmp102_ = _tmp101_;
				tee_jee_logging_log_error (_tmp102_, FALSE, FALSE);
				_g_free0 (_tmp102_);
				_tmp103_ = App;
				main_exit_app (_tmp103_, 1);
			}
		} else {
			gint attempts = 0;
			Device* _tmp141_;
			attempts = 0;
			while (TRUE) {
				Main* _tmp104_;
				const gchar* _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
				const gchar* _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				FILE* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				FILE* _tmp123_;
				GeeArrayList* list = NULL;
				GeeArrayList* _tmp124_;
				GeeArrayList* _tmp137_;
				const gchar* _tmp138_;
				Device* _tmp139_;
				Device* _tmp140_;
				_tmp104_ = App;
				_tmp105_ = _tmp104_->grub_device;
				_tmp106_ = strlen (_tmp105_);
				_tmp107_ = _tmp106_;
				if (!(_tmp107_ == 0)) {
					break;
				}
				_tmp108_ = attempts;
				attempts = _tmp108_ + 1;
				if (attempts > 3) {
					break;
				}
				_tmp109_ = grub_device_default;
				_tmp110_ = strlen (_tmp109_);
				_tmp111_ = _tmp110_;
				if (_tmp111_ > 0) {
					FILE* _tmp112_;
					const gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					_tmp112_ = stdout;
					_tmp113_ = grub_device_default;
					_tmp114_ = g_strdup_printf (_ ("[ENTER = Default (%s), a = Abort]"), _tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = g_strconcat ("", _tmp115_, NULL);
					_tmp117_ = _tmp116_;
					_tmp118_ = g_strconcat (_tmp117_, "\n\n", NULL);
					_tmp119_ = _tmp118_;
					fprintf (_tmp112_, "%s", _tmp119_);
					_g_free0 (_tmp119_);
					_g_free0 (_tmp117_);
					_g_free0 (_tmp115_);
				}
				_tmp120_ = stdout;
				_tmp121_ = g_strconcat (_ ("Enter device name or number (a=Abort)"), ": ", NULL);
				_tmp122_ = _tmp121_;
				fprintf (_tmp120_, "%s", _tmp122_);
				_g_free0 (_tmp122_);
				_tmp123_ = stdout;
				fflush (_tmp123_);
				_tmp124_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				list = _tmp124_;
				{
					GeeArrayList* _pi_list = NULL;
					Main* _tmp125_;
					GeeArrayList* _tmp126_;
					gint _pi_size = 0;
					GeeArrayList* _tmp127_;
					gint _tmp128_;
					gint _tmp129_;
					gint _pi_index = 0;
					_tmp125_ = App;
					_tmp126_ = _tmp125_->partitions;
					_pi_list = _tmp126_;
					_tmp127_ = _pi_list;
					_tmp128_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp127_);
					_tmp129_ = _tmp128_;
					_pi_size = _tmp129_;
					_pi_index = -1;
					while (TRUE) {
						gint _tmp130_;
						gint _tmp131_;
						Device* pi = NULL;
						GeeArrayList* _tmp132_;
						gpointer _tmp133_;
						Device* _tmp134_;
						_pi_index = _pi_index + 1;
						_tmp130_ = _pi_index;
						_tmp131_ = _pi_size;
						if (!(_tmp130_ < _tmp131_)) {
							break;
						}
						_tmp132_ = _pi_list;
						_tmp133_ = gee_abstract_list_get ((GeeAbstractList*) _tmp132_, _pi_index);
						pi = (Device*) _tmp133_;
						_tmp134_ = pi;
						if (device_has_linux_filesystem (_tmp134_)) {
							GeeArrayList* _tmp135_;
							Device* _tmp136_;
							_tmp135_ = list;
							_tmp136_ = pi;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp135_, _tmp136_);
						}
						_g_object_unref0 (pi);
					}
				}
				_tmp137_ = device_list;
				_tmp138_ = grub_device_default;
				_tmp139_ = app_console_read_stdin_device (self, _tmp137_, _tmp138_);
				_g_object_unref0 (dev);
				dev = _tmp139_;
				_tmp140_ = dev;
				if (_tmp140_ != NULL) {
					_g_object_unref0 (list);
					break;
				}
				_g_object_unref0 (list);
			}
			_tmp141_ = dev;
			if (_tmp141_ == NULL) {
				Main* _tmp142_;
				tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
				tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
				_tmp142_ = App;
				main_exit_app (_tmp142_, 0);
			}
		}
		_tmp143_ = dev;
		if (_tmp143_ != NULL) {
			Main* _tmp144_;
			Device* _tmp145_;
			const gchar* _tmp146_;
			gchar* _tmp147_;
			_tmp144_ = App;
			_tmp145_ = dev;
			_tmp146_ = _tmp145_->device;
			_tmp147_ = g_strdup (_tmp146_);
			_g_free0 (_tmp144_->grub_device);
			_tmp144_->grub_device = _tmp147_;
		}
		tee_jee_logging_log_msg ("", FALSE);
		_g_object_unref0 (dev);
		_g_object_unref0 (device_list);
	}
	_tmp149_ = App;
	if (_tmp149_->reinstall_grub2) {
		Main* _tmp150_;
		const gchar* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		_tmp150_ = App;
		_tmp151_ = _tmp150_->grub_device;
		_tmp152_ = strlen (_tmp151_);
		_tmp153_ = _tmp152_;
		_tmp148_ = _tmp153_ > 0;
	} else {
		_tmp148_ = FALSE;
	}
	if (_tmp148_) {
		gchar* _tmp154_;
		gchar* _tmp155_;
		Main* _tmp156_;
		const gchar* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		gchar* _tmp161_;
		gchar* _tmp162_;
		gchar* _tmp163_;
		_tmp154_ = g_strnfill ((gsize) 78, '*');
		_tmp155_ = _tmp154_;
		tee_jee_logging_log_msg (_tmp155_, FALSE);
		_g_free0 (_tmp155_);
		_tmp156_ = App;
		_tmp157_ = _tmp156_->grub_device;
		_tmp158_ = g_strdup_printf (": %s", _tmp157_);
		_tmp159_ = _tmp158_;
		_tmp160_ = g_strconcat (_ ("GRUB Device"), _tmp159_, NULL);
		_tmp161_ = _tmp160_;
		tee_jee_logging_log_msg (_tmp161_, FALSE);
		_g_free0 (_tmp161_);
		_g_free0 (_tmp159_);
		_tmp162_ = g_strnfill ((gsize) 78, '*');
		_tmp163_ = _tmp162_;
		tee_jee_logging_log_msg (_tmp163_, FALSE);
		_g_free0 (_tmp163_);
	} else {
		gchar* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		_tmp164_ = g_strnfill ((gsize) 78, '*');
		_tmp165_ = _tmp164_;
		tee_jee_logging_log_msg (_tmp165_, FALSE);
		_g_free0 (_tmp165_);
		tee_jee_logging_log_msg (_ ("GRUB will NOT be reinstalled"), FALSE);
		_tmp166_ = g_strnfill ((gsize) 78, '*');
		_tmp167_ = _tmp166_;
		tee_jee_logging_log_msg (_tmp167_, FALSE);
		_g_free0 (_tmp167_);
	}
	_g_free0 (grub_device_default);
}

static void
app_console_confirm_restore (AppConsole* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (_tmp0_->cmd_confirm == FALSE) {
		gchar* msg_devices = NULL;
		gchar* _tmp1_;
		gchar* msg_reboot = NULL;
		gchar* _tmp2_;
		gchar* msg_disclaimer = NULL;
		gchar* _tmp3_;
		Main* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gint attempts = 0;
		Main* _tmp12_;
		_tmp1_ = g_strdup ("");
		msg_devices = _tmp1_;
		_tmp2_ = g_strdup ("");
		msg_reboot = _tmp2_;
		_tmp3_ = g_strdup ("");
		msg_disclaimer = _tmp3_;
		_tmp4_ = App;
		main_get_restore_messages (_tmp4_, FALSE, &_tmp5_, &_tmp6_, &_tmp7_);
		_g_free0 (msg_devices);
		msg_devices = _tmp5_;
		_g_free0 (msg_reboot);
		msg_reboot = _tmp6_;
		_g_free0 (msg_disclaimer);
		msg_disclaimer = _tmp7_;
		attempts = 0;
		while (TRUE) {
			Main* _tmp8_;
			gint _tmp9_;
			FILE* _tmp10_;
			FILE* _tmp11_;
			_tmp8_ = App;
			if (!(_tmp8_->cmd_confirm == FALSE)) {
				break;
			}
			_tmp9_ = attempts;
			attempts = _tmp9_ + 1;
			if (attempts > 3) {
				break;
			}
			_tmp10_ = stdout;
			fprintf (_tmp10_, "%s", _ ("Continue with restore? (y/n): "));
			_tmp11_ = stdout;
			fflush (_tmp11_);
			app_console_read_stdin_restore_confirm (self);
		}
		_tmp12_ = App;
		if (_tmp12_->cmd_confirm == FALSE) {
			Main* _tmp13_;
			tee_jee_logging_log_error (_ ("Failed to get input from user in 3 attempts"), FALSE, FALSE);
			tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
			_tmp13_ = App;
			main_exit_app (_tmp13_, 0);
		}
		_g_free0 (msg_disclaimer);
		_g_free0 (msg_reboot);
		_g_free0 (msg_devices);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static Device*
app_console_read_stdin_device (AppConsole* self,
                               GeeArrayList* device_list,
                               const gchar* device_default)
{
	TimeoutCounter* counter = NULL;
	TimeoutCounter* _tmp0_;
	TimeoutCounter* _tmp1_;
	gchar* line = NULL;
	FILE* _tmp2_;
	gchar* _tmp3_;
	TimeoutCounter* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp10_;
	Device* selected_device = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_list != NULL, NULL);
	g_return_val_if_fail (device_default != NULL, NULL);
	_tmp0_ = timeout_counter_new ();
	counter = _tmp0_;
	_tmp1_ = counter;
	timeout_counter_exit_on_timeout (_tmp1_, TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT);
	_tmp2_ = stdin;
	_tmp3_ = g_file_stream_read_line (_tmp2_);
	line = _tmp3_;
	_tmp4_ = counter;
	timeout_counter_stop (_tmp4_);
	_tmp6_ = line;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = line;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp5_);
	_g_free0 (line);
	line = _tmp10_;
	selected_device = NULL;
	_tmp11_ = line;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "a") == 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		Main* _tmp15_;
		tee_jee_logging_log_msg (_ ("Aborted."), FALSE);
		_tmp15_ = App;
		main_exit_app (_tmp15_, 0);
	} else {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_tmp19_ = line;
		if (_tmp19_ == NULL) {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp20_ = line;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ == 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp23_ = line;
			_tmp24_ = g_utf8_strdown (_tmp23_, (gssize) -1);
			_tmp25_ = _tmp24_;
			_tmp17_ = g_strcmp0 (_tmp25_, "c") == 0;
			_g_free0 (_tmp25_);
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp26_ = line;
			_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) -1);
			_tmp28_ = _tmp27_;
			_tmp16_ = g_strcmp0 (_tmp28_, "d") == 0;
			_g_free0 (_tmp28_);
		}
		if (_tmp16_) {
			gint _tmp29_;
			gint _tmp30_;
			_tmp29_ = strlen (device_default);
			_tmp30_ = _tmp29_;
			if (_tmp30_ > 0) {
				Device* _tmp31_;
				_tmp31_ = device_get_device_by_name (device_default);
				_g_object_unref0 (selected_device);
				selected_device = _tmp31_;
			} else {
				tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
			}
		} else {
			const gchar* _tmp32_;
			_tmp32_ = line;
			if (string_contains (_tmp32_, "/")) {
				const gchar* _tmp33_;
				Device* _tmp34_;
				Device* _tmp35_;
				_tmp33_ = line;
				_tmp34_ = device_get_device_by_name (_tmp33_);
				_g_object_unref0 (selected_device);
				selected_device = _tmp34_;
				_tmp35_ = selected_device;
				if (_tmp35_ == NULL) {
					tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
				}
			} else {
				const gchar* _tmp36_;
				Device* _tmp37_;
				Device* _tmp38_;
				_tmp36_ = line;
				_tmp37_ = app_console_get_device_from_index (self, device_list, _tmp36_);
				_g_object_unref0 (selected_device);
				selected_device = _tmp37_;
				_tmp38_ = selected_device;
				if (_tmp38_ == NULL) {
					tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
				}
			}
		}
	}
	result = selected_device;
	_g_free0 (_tmp5_);
	_g_free0 (line);
	_g_object_unref0 (counter);
	return result;
}

static Device*
app_console_read_stdin_device_mounts (AppConsole* self,
                                      GeeArrayList* device_list,
                                      MountEntry* mnt)
{
	TimeoutCounter* counter = NULL;
	TimeoutCounter* _tmp0_;
	TimeoutCounter* _tmp1_;
	gchar* line = NULL;
	FILE* _tmp2_;
	gchar* _tmp3_;
	TimeoutCounter* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp10_;
	Device* selected_device = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_list != NULL, NULL);
	g_return_val_if_fail (mnt != NULL, NULL);
	_tmp0_ = timeout_counter_new ();
	counter = _tmp0_;
	_tmp1_ = counter;
	timeout_counter_exit_on_timeout (_tmp1_, TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT);
	_tmp2_ = stdin;
	_tmp3_ = g_file_stream_read_line (_tmp2_);
	line = _tmp3_;
	_tmp4_ = counter;
	timeout_counter_stop (_tmp4_);
	_tmp6_ = line;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = line;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp5_);
	_g_free0 (line);
	line = _tmp10_;
	selected_device = NULL;
	_tmp14_ = line;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp15_ = line;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == 0;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = line;
		_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
		_tmp20_ = _tmp19_;
		_tmp12_ = g_strcmp0 (_tmp20_, "c") == 0;
		_g_free0 (_tmp20_);
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = line;
		_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
		_tmp23_ = _tmp22_;
		_tmp11_ = g_strcmp0 (_tmp23_, "d") == 0;
		_g_free0 (_tmp23_);
	}
	if (_tmp11_) {
		Main* _tmp24_;
		_tmp24_ = App;
		if (_tmp24_->mirror_system) {
			Main* _tmp25_;
			Device* _tmp26_;
			Device* _tmp27_;
			Device* _tmp28_;
			_tmp25_ = App;
			_tmp26_ = main_get_dst_root (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _g_object_ref0 (_tmp27_);
			result = _tmp28_;
			_g_object_unref0 (selected_device);
			_g_free0 (_tmp5_);
			_g_free0 (line);
			_g_object_unref0 (counter);
			return result;
		} else {
			Device* _tmp29_;
			Device* _tmp30_;
			_tmp29_ = mnt->device;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			result = _tmp30_;
			_g_object_unref0 (selected_device);
			_g_free0 (_tmp5_);
			_g_free0 (line);
			_g_object_unref0 (counter);
			return result;
		}
	} else {
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gboolean _tmp34_;
		_tmp31_ = line;
		_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) -1);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strcmp0 (_tmp33_, "a") == 0;
		_g_free0 (_tmp33_);
		if (_tmp34_) {
			Main* _tmp35_;
			tee_jee_logging_log_msg ("Aborted.", FALSE);
			_tmp35_ = App;
			main_exit_app (_tmp35_, 0);
		} else {
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gboolean _tmp40_;
			_tmp37_ = line;
			_tmp38_ = g_utf8_strdown (_tmp37_, (gssize) -1);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strcmp0 (_tmp39_, "n") == 0;
			_g_free0 (_tmp39_);
			if (_tmp40_) {
				_tmp36_ = TRUE;
			} else {
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp41_ = line;
				_tmp42_ = g_utf8_strdown (_tmp41_, (gssize) -1);
				_tmp43_ = _tmp42_;
				_tmp36_ = g_strcmp0 (_tmp43_, "r") == 0;
				_g_free0 (_tmp43_);
			}
			if (_tmp36_) {
				Main* _tmp44_;
				Device* _tmp45_;
				Device* _tmp46_;
				Device* _tmp47_;
				_tmp44_ = App;
				_tmp45_ = main_get_dst_root (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = _g_object_ref0 (_tmp46_);
				result = _tmp47_;
				_g_object_unref0 (selected_device);
				_g_free0 (_tmp5_);
				_g_free0 (line);
				_g_object_unref0 (counter);
				return result;
			} else {
				const gchar* _tmp48_;
				_tmp48_ = line;
				if (string_contains (_tmp48_, "/")) {
					const gchar* _tmp49_;
					Device* _tmp50_;
					Device* _tmp51_;
					_tmp49_ = line;
					_tmp50_ = device_get_device_by_name (_tmp49_);
					_g_object_unref0 (selected_device);
					selected_device = _tmp50_;
					_tmp51_ = selected_device;
					if (_tmp51_ == NULL) {
						tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
					}
				} else {
					const gchar* _tmp52_;
					Device* _tmp53_;
					Device* _tmp54_;
					_tmp52_ = line;
					_tmp53_ = app_console_get_device_from_index (self, device_list, _tmp52_);
					_g_object_unref0 (selected_device);
					selected_device = _tmp53_;
					_tmp54_ = selected_device;
					if (_tmp54_ == NULL) {
						tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
					}
				}
			}
		}
	}
	result = selected_device;
	_g_free0 (_tmp5_);
	_g_free0 (line);
	_g_object_unref0 (counter);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static Device*
app_console_get_device_from_index (AppConsole* self,
                                   GeeArrayList* device_list,
                                   const gchar* index_string)
{
	gint64 index = 0LL;
	gint64 _tmp0_ = 0LL;
	gboolean _tmp1_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_list != NULL, NULL);
	g_return_val_if_fail (index_string != NULL, NULL);
	_tmp1_ = int64_try_parse (index_string, &_tmp0_, NULL, (guint) 0);
	index = _tmp0_;
	if (_tmp1_) {
		gint i = 0;
		i = -1;
		{
			GeeArrayList* _pi_list = NULL;
			gint _pi_size = 0;
			GeeArrayList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _pi_index = 0;
			_pi_list = device_list;
			_tmp2_ = _pi_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_pi_size = _tmp4_;
			_pi_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				Device* pi = NULL;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				gint _tmp9_;
				gint64 _tmp10_;
				_pi_index = _pi_index + 1;
				_tmp5_ = _pi_index;
				_tmp6_ = _pi_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _pi_list;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _pi_index);
				pi = (Device*) _tmp8_;
				i = i + 1;
				_tmp9_ = i;
				_tmp10_ = index;
				if (((gint64) _tmp9_) == _tmp10_) {
					result = pi;
					return result;
				}
				_g_object_unref0 (pi);
			}
		}
	}
	result = NULL;
	return result;
}

static Snapshot*
app_console_read_stdin_snapshot (AppConsole* self)
{
	TimeoutCounter* counter = NULL;
	TimeoutCounter* _tmp0_;
	TimeoutCounter* _tmp1_;
	gchar* line = NULL;
	FILE* _tmp2_;
	gchar* _tmp3_;
	TimeoutCounter* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp10_;
	Snapshot* selected_snapshot = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = timeout_counter_new ();
	counter = _tmp0_;
	_tmp1_ = counter;
	timeout_counter_exit_on_timeout (_tmp1_, TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT);
	_tmp2_ = stdin;
	_tmp3_ = g_file_stream_read_line (_tmp2_);
	line = _tmp3_;
	_tmp4_ = counter;
	timeout_counter_stop (_tmp4_);
	_tmp6_ = line;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = line;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp5_);
	_g_free0 (line);
	line = _tmp10_;
	selected_snapshot = NULL;
	_tmp11_ = line;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "a") == 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		Main* _tmp15_;
		tee_jee_logging_log_msg ("Aborted.", FALSE);
		_tmp15_ = App;
		main_exit_app (_tmp15_, 0);
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp16_ = line;
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strcmp0 (_tmp18_, "p") == 0;
		_g_free0 (_tmp18_);
		if (_tmp19_) {
			self->snapshot_list_start_index = self->snapshot_list_start_index - 10;
			if (self->snapshot_list_start_index < 0) {
				self->snapshot_list_start_index = 0;
			}
			tee_jee_logging_log_msg ("", FALSE);
			app_console_list_snapshots (self, TRUE, 20);
			tee_jee_logging_log_msg ("", FALSE);
		} else {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			_tmp20_ = line;
			_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strcmp0 (_tmp22_, "n") == 0;
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				Main* _tmp24_;
				SnapshotRepo* _tmp25_;
				GeeArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp24_ = App;
				_tmp25_ = _tmp24_->repo;
				_tmp26_ = _tmp25_->snapshots;
				_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				if ((self->snapshot_list_start_index + 10) < _tmp28_) {
					self->snapshot_list_start_index = self->snapshot_list_start_index + 10;
				}
				tee_jee_logging_log_msg ("", FALSE);
				app_console_list_snapshots (self, TRUE, 20);
				tee_jee_logging_log_msg ("", FALSE);
			} else {
				gboolean _tmp29_ = FALSE;
				const gchar* _tmp30_;
				_tmp30_ = line;
				if (string_contains (_tmp30_, "_")) {
					_tmp29_ = TRUE;
				} else {
					const gchar* _tmp31_;
					_tmp31_ = line;
					_tmp29_ = string_contains (_tmp31_, "-");
				}
				if (_tmp29_) {
					tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
				} else {
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
					_tmp33_ = line;
					if (_tmp33_ == NULL) {
						_tmp32_ = TRUE;
					} else {
						const gchar* _tmp34_;
						gint _tmp35_;
						gint _tmp36_;
						_tmp34_ = line;
						_tmp35_ = strlen (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp32_ = _tmp36_ == 0;
					}
					if (_tmp32_) {
						tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
					} else {
						gint64 index = 0LL;
						const gchar* _tmp37_;
						gint64 _tmp38_ = 0LL;
						gboolean _tmp39_;
						_tmp37_ = line;
						_tmp39_ = int64_try_parse (_tmp37_, &_tmp38_, NULL, (guint) 0);
						index = _tmp38_;
						if (_tmp39_) {
							Main* _tmp40_;
							SnapshotRepo* _tmp41_;
							GeeArrayList* _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							_tmp40_ = App;
							_tmp41_ = _tmp40_->repo;
							_tmp42_ = _tmp41_->snapshots;
							_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
							_tmp44_ = _tmp43_;
							if (index < ((gint64) _tmp44_)) {
								Main* _tmp45_;
								SnapshotRepo* _tmp46_;
								GeeArrayList* _tmp47_;
								gpointer _tmp48_;
								_tmp45_ = App;
								_tmp46_ = _tmp45_->repo;
								_tmp47_ = _tmp46_->snapshots;
								_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, (gint) index);
								_g_object_unref0 (selected_snapshot);
								selected_snapshot = (Snapshot*) _tmp48_;
							} else {
								tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
							}
						} else {
							tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
						}
					}
				}
			}
		}
	}
	result = selected_snapshot;
	_g_free0 (_tmp5_);
	_g_free0 (line);
	_g_object_unref0 (counter);
	return result;
}

static gboolean
app_console_read_stdin_grub_install (AppConsole* self,
                                     gboolean reinstall_default)
{
	TimeoutCounter* counter = NULL;
	TimeoutCounter* _tmp0_;
	TimeoutCounter* _tmp1_;
	gchar* line = NULL;
	FILE* _tmp2_;
	gchar* _tmp3_;
	TimeoutCounter* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = timeout_counter_new ();
	counter = _tmp0_;
	_tmp1_ = counter;
	timeout_counter_exit_on_timeout (_tmp1_, TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT);
	_tmp2_ = stdin;
	_tmp3_ = g_file_stream_read_line (_tmp2_);
	line = _tmp3_;
	_tmp4_ = counter;
	timeout_counter_stop (_tmp4_);
	_tmp6_ = line;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = line;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = line;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp5_);
	_g_free0 (line);
	line = _tmp11_;
	_tmp13_ = line;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = line;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ == 0;
	}
	if (_tmp12_) {
		Main* _tmp17_;
		Main* _tmp18_;
		_tmp17_ = App;
		_tmp17_->reinstall_grub2 = reinstall_default;
		_tmp18_ = App;
		_tmp18_->cmd_skip_grub = !reinstall_default;
		result = TRUE;
		_g_free0 (_tmp5_);
		_g_free0 (line);
		_g_object_unref0 (counter);
		return result;
	} else {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = line;
		_tmp20_ = g_utf8_strdown (_tmp19_, (gssize) -1);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strcmp0 (_tmp21_, "a") == 0;
		_g_free0 (_tmp21_);
		if (_tmp22_) {
			Main* _tmp23_;
			tee_jee_logging_log_msg ("Aborted.", FALSE);
			_tmp23_ = App;
			main_exit_app (_tmp23_, 0);
			result = TRUE;
			_g_free0 (_tmp5_);
			_g_free0 (line);
			_g_object_unref0 (counter);
			return result;
		} else {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp27_;
			_tmp24_ = line;
			_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) -1);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strcmp0 (_tmp26_, "y") == 0;
			_g_free0 (_tmp26_);
			if (_tmp27_) {
				Main* _tmp28_;
				Main* _tmp29_;
				_tmp28_ = App;
				_tmp28_->cmd_skip_grub = FALSE;
				_tmp29_ = App;
				_tmp29_->reinstall_grub2 = TRUE;
				result = TRUE;
				_g_free0 (_tmp5_);
				_g_free0 (line);
				_g_object_unref0 (counter);
				return result;
			} else {
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				_tmp30_ = line;
				_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) -1);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (_tmp32_, "n") == 0;
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					Main* _tmp34_;
					Main* _tmp35_;
					_tmp34_ = App;
					_tmp34_->cmd_skip_grub = TRUE;
					_tmp35_ = App;
					_tmp35_->reinstall_grub2 = FALSE;
					result = TRUE;
					_g_free0 (_tmp5_);
					_g_free0 (line);
					_g_object_unref0 (counter);
					return result;
				} else {
					gboolean _tmp36_ = FALSE;
					const gchar* _tmp37_;
					_tmp37_ = line;
					if (_tmp37_ == NULL) {
						_tmp36_ = TRUE;
					} else {
						const gchar* _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
						_tmp38_ = line;
						_tmp39_ = strlen (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp36_ = _tmp40_ == 0;
					}
					if (_tmp36_) {
						tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
						result = FALSE;
						_g_free0 (_tmp5_);
						_g_free0 (line);
						_g_object_unref0 (counter);
						return result;
					} else {
						tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
						result = FALSE;
						_g_free0 (_tmp5_);
						_g_free0 (line);
						_g_object_unref0 (counter);
						return result;
					}
				}
			}
		}
	}
}

static gboolean
app_console_read_stdin_restore_confirm (AppConsole* self)
{
	TimeoutCounter* counter = NULL;
	TimeoutCounter* _tmp0_;
	TimeoutCounter* _tmp1_;
	gchar* line = NULL;
	FILE* _tmp2_;
	gchar* _tmp3_;
	TimeoutCounter* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = timeout_counter_new ();
	counter = _tmp0_;
	_tmp1_ = counter;
	timeout_counter_exit_on_timeout (_tmp1_, TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT);
	_tmp2_ = stdin;
	_tmp3_ = g_file_stream_read_line (_tmp2_);
	line = _tmp3_;
	_tmp4_ = counter;
	timeout_counter_stop (_tmp4_);
	_tmp6_ = line;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = line;
		_tmp8_ = string_strip (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp5_);
	_g_free0 (line);
	line = _tmp10_;
	_tmp12_ = line;
	_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp14_, "a") == 0;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = line;
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		_tmp11_ = g_strcmp0 (_tmp18_, "n") == 0;
		_g_free0 (_tmp18_);
	}
	if (_tmp11_) {
		Main* _tmp19_;
		tee_jee_logging_log_msg ("Aborted.", FALSE);
		_tmp19_ = App;
		main_exit_app (_tmp19_, 0);
		result = TRUE;
		_g_free0 (_tmp5_);
		_g_free0 (line);
		_g_object_unref0 (counter);
		return result;
	} else {
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_;
		_tmp21_ = line;
		if (_tmp21_ == NULL) {
			_tmp20_ = TRUE;
		} else {
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp22_ = line;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ == 0;
		}
		if (_tmp20_) {
			tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
			result = FALSE;
			_g_free0 (_tmp5_);
			_g_free0 (line);
			_g_object_unref0 (counter);
			return result;
		} else {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp25_ = line;
			_tmp26_ = g_utf8_strdown (_tmp25_, (gssize) -1);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strcmp0 (_tmp27_, "y") == 0;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				Main* _tmp29_;
				_tmp29_ = App;
				_tmp29_->cmd_confirm = TRUE;
				result = TRUE;
				_g_free0 (_tmp5_);
				_g_free0 (line);
				_g_object_unref0 (counter);
				return result;
			} else {
				gboolean _tmp30_ = FALSE;
				const gchar* _tmp31_;
				_tmp31_ = line;
				if (_tmp31_ == NULL) {
					_tmp30_ = TRUE;
				} else {
					const gchar* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					_tmp32_ = line;
					_tmp33_ = strlen (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp30_ = _tmp34_ == 0;
				}
				if (_tmp30_) {
					tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
					result = FALSE;
					_g_free0 (_tmp5_);
					_g_free0 (line);
					_g_object_unref0 (counter);
					return result;
				} else {
					tee_jee_logging_log_error ("Invalid input", FALSE, FALSE);
					result = FALSE;
					_g_free0 (_tmp5_);
					_g_free0 (line);
					_g_object_unref0 (counter);
					return result;
				}
			}
		}
	}
}

gboolean
app_console_delete_snapshot (AppConsole* self)
{
	Main* _tmp0_;
	Snapshot* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	app_console_select_snapshot_device (self, TRUE);
	app_console_select_snapshot_for_deletion (self);
	_tmp0_ = App;
	_tmp1_ = _tmp0_->snapshot_to_delete;
	if (_tmp1_ != NULL) {
		Main* _tmp2_;
		Snapshot* _tmp3_;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->snapshot_to_delete;
		snapshot_remove (_tmp3_, TRUE);
	}
	result = TRUE;
	return result;
}

gboolean
app_console_delete_all_snapshots (AppConsole* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	app_console_select_snapshot_device (self, TRUE);
	{
		GeeArrayList* _snap_list = NULL;
		Main* _tmp0_;
		SnapshotRepo* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _snap_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _snap_index = 0;
		_tmp0_ = App;
		_tmp1_ = _tmp0_->repo;
		_tmp2_ = _tmp1_->snapshots;
		_snap_list = _tmp2_;
		_tmp3_ = _snap_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_snap_size = _tmp5_;
		_snap_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			Snapshot* snap = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			Snapshot* _tmp10_;
			_snap_index = _snap_index + 1;
			_tmp6_ = _snap_index;
			_tmp7_ = _snap_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _snap_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _snap_index);
			snap = (Snapshot*) _tmp9_;
			_tmp10_ = snap;
			snapshot_remove (_tmp10_, TRUE);
			_g_object_unref0 (snap);
		}
	}
	result = TRUE;
	return result;
}

AppConsole*
app_console_construct (GType object_type)
{
	AppConsole * self = NULL;
	self = (AppConsole*) g_object_new (object_type, NULL);
	return self;
}

AppConsole*
app_console_new (void)
{
	return app_console_construct (TYPE_APP_CONSOLE);
}

static void
app_console_class_init (AppConsoleClass * klass,
                        gpointer klass_data)
{
	app_console_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = app_console_finalize;
}

static void
app_console_instance_init (AppConsole * self,
                           gpointer klass)
{
	self->snapshot_list_start_index = 0;
}

static void
app_console_finalize (GObject * obj)
{
	AppConsole * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_CONSOLE, AppConsole);
	G_OBJECT_CLASS (app_console_parent_class)->finalize (obj);
}

static GType
app_console_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppConsoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_console_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppConsole), 0, (GInstanceInitFunc) app_console_instance_init, NULL };
	GType app_console_type_id;
	app_console_type_id = g_type_register_static (G_TYPE_OBJECT, "AppConsole", &g_define_type_info, 0);
	return app_console_type_id;
}

GType
app_console_get_type (void)
{
	static volatile gsize app_console_type_id__once = 0;
	if (g_once_init_enter (&app_console_type_id__once)) {
		GType app_console_type_id;
		app_console_type_id = app_console_get_type_once ();
		g_once_init_leave (&app_console_type_id__once, app_console_type_id);
	}
	return app_console_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

