/* TeeJee.Logging.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.Logging.vala, do not modify */

/*
 * TeeJee.Logging.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN GDataOutputStream* tee_jee_logging_dos_log;
GDataOutputStream* tee_jee_logging_dos_log = NULL;
VALA_EXTERN gchar* tee_jee_logging_err_log;
gchar* tee_jee_logging_err_log = NULL;
VALA_EXTERN gboolean tee_jee_logging_LOG_ENABLE;
gboolean tee_jee_logging_LOG_ENABLE = TRUE;
VALA_EXTERN gboolean tee_jee_logging_LOG_TIMESTAMP;
gboolean tee_jee_logging_LOG_TIMESTAMP = FALSE;
VALA_EXTERN gboolean tee_jee_logging_LOG_COLORS;
gboolean tee_jee_logging_LOG_COLORS = TRUE;
VALA_EXTERN gboolean tee_jee_logging_LOG_DEBUG;
gboolean tee_jee_logging_LOG_DEBUG = FALSE;
VALA_EXTERN gboolean tee_jee_logging_LOG_COMMANDS;
gboolean tee_jee_logging_LOG_COMMANDS = FALSE;

VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gchar* tee_jee_misc_timestamp (gboolean show_millis);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN void tee_jee_logging_log_to_file (const gchar* message,
                                  gboolean highlight);

void
tee_jee_logging_log_msg (const gchar* message,
                         gboolean highlight)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	FILE* _tmp19_;
	const gchar* _tmp20_;
	FILE* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (message != NULL);
	if (!tee_jee_logging_LOG_ENABLE) {
		return;
	}
	_tmp0_ = g_strdup ("");
	msg = _tmp0_;
	if (highlight) {
		_tmp1_ = tee_jee_logging_LOG_COLORS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = msg;
		_tmp3_ = g_strconcat (_tmp2_, "\033[1;38;5;34m", NULL);
		_g_free0 (msg);
		msg = _tmp3_;
	}
	if (tee_jee_logging_LOG_TIMESTAMP) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp4_ = msg;
		_tmp5_ = tee_jee_misc_timestamp (TRUE);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("[", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "] ", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp4_, _tmp10_, NULL);
		_g_free0 (msg);
		msg = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	_tmp12_ = msg;
	_tmp13_ = g_strconcat (_tmp12_, message, NULL);
	_g_free0 (msg);
	msg = _tmp13_;
	if (highlight) {
		_tmp14_ = tee_jee_logging_LOG_COLORS;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = msg;
		_tmp16_ = g_strconcat (_tmp15_, "\033[0m", NULL);
		_g_free0 (msg);
		msg = _tmp16_;
	}
	_tmp17_ = msg;
	_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp18_;
	_tmp19_ = stdout;
	_tmp20_ = msg;
	fprintf (_tmp19_, "%s", _tmp20_);
	_tmp21_ = stdout;
	fflush (_tmp21_);
	{
		GDataOutputStream* _tmp22_;
		_tmp22_ = tee_jee_logging_dos_log;
		if (_tmp22_ != NULL) {
			GDataOutputStream* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp23_ = tee_jee_logging_dos_log;
			_tmp24_ = tee_jee_misc_timestamp (FALSE);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("[%s] %s\n", _tmp25_, message);
			_tmp27_ = _tmp26_;
			g_data_output_stream_put_string (_tmp23_, _tmp27_, NULL, &_inner_error0_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = stdout;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		fprintf (_tmp28_, "%s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (msg);
}

void
tee_jee_logging_log_error (const gchar* message,
                           gboolean highlight,
                           gboolean is_warning)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gchar* prefix = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	FILE* _tmp26_;
	const gchar* _tmp27_;
	FILE* _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (message != NULL);
	if (!tee_jee_logging_LOG_ENABLE) {
		return;
	}
	_tmp0_ = g_strdup ("");
	msg = _tmp0_;
	if (highlight) {
		_tmp1_ = tee_jee_logging_LOG_COLORS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = msg;
		_tmp3_ = g_strconcat (_tmp2_, "\033[1;38;5;160m", NULL);
		_g_free0 (msg);
		msg = _tmp3_;
	}
	if (tee_jee_logging_LOG_TIMESTAMP) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp4_ = msg;
		_tmp5_ = tee_jee_misc_timestamp (TRUE);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("[", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "] ", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp4_, _tmp10_, NULL);
		_g_free0 (msg);
		msg = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	if (is_warning) {
		_tmp12_ = "W";
	} else {
		_tmp12_ = "E";
	}
	_tmp13_ = g_strdup (_tmp12_);
	prefix = _tmp13_;
	_tmp14_ = msg;
	_tmp15_ = prefix;
	_tmp16_ = g_strconcat (_tmp15_, ": ", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, message, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
	_g_free0 (msg);
	msg = _tmp20_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	if (highlight) {
		_tmp21_ = tee_jee_logging_LOG_COLORS;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = msg;
		_tmp23_ = g_strconcat (_tmp22_, "\033[0m", NULL);
		_g_free0 (msg);
		msg = _tmp23_;
	}
	_tmp24_ = msg;
	_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
	_g_free0 (msg);
	msg = _tmp25_;
	_tmp26_ = stdout;
	_tmp27_ = msg;
	fprintf (_tmp26_, "%s", _tmp27_);
	_tmp28_ = stdout;
	fflush (_tmp28_);
	{
		gchar* str = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GDataOutputStream* _tmp34_;
		const gchar* _tmp37_;
		_tmp29_ = tee_jee_misc_timestamp (FALSE);
		_tmp30_ = _tmp29_;
		_tmp31_ = prefix;
		_tmp32_ = g_strdup_printf ("[%s] %s: %s\n", _tmp30_, _tmp31_, message);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp30_);
		str = _tmp33_;
		_tmp34_ = tee_jee_logging_dos_log;
		if (_tmp34_ != NULL) {
			GDataOutputStream* _tmp35_;
			const gchar* _tmp36_;
			_tmp35_ = tee_jee_logging_dos_log;
			_tmp36_ = str;
			g_data_output_stream_put_string (_tmp35_, _tmp36_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (str);
				goto __catch0_g_error;
			}
		}
		_tmp37_ = tee_jee_logging_err_log;
		if (_tmp37_ != NULL) {
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp38_ = tee_jee_logging_err_log;
			_tmp39_ = g_strdup_printf ("%s\n", message);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
			_g_free0 (tee_jee_logging_err_log);
			tee_jee_logging_err_log = _tmp41_;
			_g_free0 (_tmp40_);
		}
		_g_free0 (str);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = stdout;
		_tmp43_ = e;
		_tmp44_ = _tmp43_->message;
		fprintf (_tmp42_, "%s", _tmp44_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (prefix);
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (prefix);
	_g_free0 (msg);
}

void
tee_jee_logging_log_debug (const gchar* message)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (message != NULL);
	if (!tee_jee_logging_LOG_ENABLE) {
		return;
	}
	if (tee_jee_logging_LOG_DEBUG) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strconcat ("D: ", message, NULL);
		_tmp1_ = _tmp0_;
		tee_jee_logging_log_msg (_tmp1_, FALSE);
		_g_free0 (_tmp1_);
	}
	{
		GDataOutputStream* _tmp2_;
		_tmp2_ = tee_jee_logging_dos_log;
		if (_tmp2_ != NULL) {
			GDataOutputStream* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = tee_jee_logging_dos_log;
			_tmp4_ = tee_jee_misc_timestamp (FALSE);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("[%s] %s\n", _tmp5_, message);
			_tmp7_ = _tmp6_;
			g_data_output_stream_put_string (_tmp3_, _tmp7_, NULL, &_inner_error0_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "%s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
tee_jee_logging_log_to_file (const gchar* message,
                             gboolean highlight)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (message != NULL);
	{
		GDataOutputStream* _tmp0_;
		_tmp0_ = tee_jee_logging_dos_log;
		if (_tmp0_ != NULL) {
			GDataOutputStream* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp1_ = tee_jee_logging_dos_log;
			_tmp2_ = tee_jee_misc_timestamp (FALSE);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("[%s] %s\n", _tmp3_, message);
			_tmp5_ = _tmp4_;
			g_data_output_stream_put_string (_tmp1_, _tmp5_, NULL, &_inner_error0_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = stdout;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

