const char metrics_psutils_psutils_linux_lua[] =
"local fio = require('fio')\n"
"local string = require('string')\n"
"local ffi = require('ffi')\n"
"\n"
"local get_nprocs_conf = function() end\n"
"if jit.os == 'Linux' then\n"
"    ffi.cdef[[\n"
"        int get_nprocs_conf(void);\n"
"    ]]\n"
"    get_nprocs_conf = ffi.C.get_nprocs_conf\n"
"end\n"
"\n"
"local function get_cpu_time()\n"
"    local stat_file_path = '/proc/stat'\n"
"    local cpu_stat_file = fio.open(stat_file_path, 'O_RDONLY')\n"
"    if cpu_stat_file == nil then\n"
"        return nil\n"
"    end\n"
"\n"
"    local stats_raw = cpu_stat_file:read(512)\n"
"    cpu_stat_file:close()\n"
"    if #stats_raw == 0 then\n"
"        return nil\n"
"    end\n"
"\n"
"    local stats = string.split(stats_raw, '\\n')\n"
"    local cpu_times = string.split(stats[1])\n"
"\n"
"    local sum = 0\n"
"    for i, cpu_time in ipairs(cpu_times) do\n"
"        if i > 1 then\n"
"            sum = sum + tonumber(cpu_time)\n"
"        end\n"
"    end\n"
"\n"
"    return sum\n"
"end\n"
"\n"
"local function parse_process_stat(path)\n"
"    local stat = fio.open(path, 'O_RDONLY')\n"
"    if stat == nil then\n"
"        print('stat open error')\n"
"        return nil\n"
"    end\n"
"\n"
"    local s = stat:read(512)\n"
"    stat:close()\n"
"\n"
"    local stats = string.split(s)\n"
"    return {\n"
"        pid = tonumber(stats[1]),\n"
"        comm = stats[2]:gsub('[()]', ''), -- strip spaces\n"
"        utime = tonumber(stats[14]),\n"
"        stime = tonumber(stats[15]),\n"
"    }\n"
"end\n"
"\n"
"local function get_process_cpu_time()\n"
"    local task_path = '/proc/self/task'\n"
"    local threads = fio.listdir(task_path)\n"
"    local thread_time = {}\n"
"    for i, thread_pid in ipairs(threads) do\n"
"        thread_time[i] = parse_process_stat(task_path .. '/' .. thread_pid .. '/stat')\n"
"    end\n"
"\n"
"    return thread_time\n"
"end\n"
"\n"
"return {\n"
"    get_cpu_time = get_cpu_time,\n"
"    get_process_cpu_time = get_process_cpu_time,\n"
"    get_cpu_count = get_nprocs_conf,\n"
"}\n"
""
;
