const char sysprof_lua[] =
"local bufread = require \"utils.bufread\"\n"
"local sysprof = require \"sysprof.parse\"\n"
"local symtab = require \"utils.symtab\"\n"
"local misc = require \"sysprof.collapse\"\n"
"\n"
"local stdout, stderr = io.stdout, io.stderr\n"
"local match, gmatch = string.match, string.gmatch\n"
"\n"
"local split_by_vmstate = false\n"
"\n"
"-- Program options.\n"
"local opt_map = {}\n"
"\n"
"function opt_map.help()\n"
"  stdout:write [[\n"
"luajit-parse-sysprof - parser of the profile collected\n"
"                       with LuaJIT's sysprof.\n"
"\n"
"SYNOPSIS\n"
"\n"
"luajit-parse-sysprof [options] sysprof.bin\n"
"\n"
"Supported options are:\n"
"\n"
"  --help                            Show this help and exit\n"
"  --split                           Split callchains by vmstate\n"
"]]\n"
"  os.exit(0)\n"
"end\n"
"\n"
"function opt_map.split()\n"
"  split_by_vmstate = true\n"
"end\n"
"\n"
"-- Print error and exit with error status.\n"
"local function opterror(...)\n"
"  stderr:write(\"luajit-parse-sysprof.lua: ERROR: \", ...)\n"
"  stderr:write(\"\\n\")\n"
"  os.exit(1)\n"
"end\n"
"\n"
"-- Parse single option.\n"
"local function parseopt(opt, args)\n"
"  local opt_current = #opt == 1 and \"-\"..opt or \"--\"..opt\n"
"  local f = opt_map[opt]\n"
"  if not f then\n"
"    opterror(\"unrecognized option `\", opt_current, \"'. Try `--help'.\\n\")\n"
"  end\n"
"  f(args)\n"
"end\n"
"\n"
"-- Parse arguments.\n"
"local function parseargs(args)\n"
"  -- Process all option arguments.\n"
"  args.argn = 1\n"
"  repeat\n"
"    local a = args[args.argn]\n"
"    if not a then\n"
"      break\n"
"    end\n"
"    local lopt, opt = match(a, \"^%-(%-\?)(.+)\")\n"
"    if not opt then\n"
"      break\n"
"    end\n"
"    args.argn = args.argn + 1\n"
"    if lopt == \"\" then\n"
"      -- Loop through short options.\n"
"      for o in gmatch(opt, \".\") do\n"
"        parseopt(o, args)\n"
"      end\n"
"    else\n"
"      -- Long option.\n"
"      parseopt(opt, args)\n"
"    end\n"
"  until false\n"
"\n"
"  -- Check for proper number of arguments.\n"
"  local nargs = #args - args.argn + 1\n"
"  if nargs ~= 1 then\n"
"    opt_map.help()\n"
"  end\n"
"\n"
"  -- Translate a single input file.\n"
"  -- TODO: Handle multiple files\?\n"
"  return args[args.argn]\n"
"end\n"
"\n"
"local function traverse_calltree(node, prefix)\n"
"  if node.is_leaf then\n"
"    print(prefix..' '..node.count)\n"
"  end\n"
"\n"
"  local sep_prefix = #prefix == 0 and prefix or prefix..';'\n"
"\n"
"  for name,child in pairs(node.children) do\n"
"    traverse_calltree(child, sep_prefix..name)\n"
"  end\n"
"end\n"
"\n"
"local function dump(inputfile)\n"
"  local reader = bufread.new(inputfile)\n"
"\n"
"  local symbols = symtab.parse(reader)\n"
"\n"
"  local events = sysprof.parse(reader, symbols)\n"
"  local calltree = misc.collapse(events, symbols, split_by_vmstate)\n"
"\n"
"  traverse_calltree(calltree, '')\n"
"\n"
"  os.exit(0)\n"
"end\n"
"\n"
"-- FIXME: this script should be application-independent.\n"
"local args = {...}\n"
"if #args == 1 and args[1] == \"sysprof\" then\n"
"  return dump\n"
"else\n"
"  dump(parseargs(args))\n"
"end\n"
""
;
