/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-FileCopyrightText: 2011-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "notifications.h"
#include <adwaita.h>
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NOTIFICATIONS_PLUG_0_PROPERTY,
	NOTIFICATIONS_PLUG_NUM_PROPERTIES
};
static GParamSpec* notifications_plug_properties[NOTIFICATIONS_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NotificationsPlugSearchData NotificationsPlugSearchData;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _NotificationsPlugPrivate {
	AdwToolbarView* placeholder_view;
	GtkStack* stack;
	WidgetsMainView* main_view;
};

struct _NotificationsPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NotificationsPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
};

static gint NotificationsPlug_private_offset;
static gpointer notifications_plug_parent_class = NULL;
GSettings* notifications_plug_notify_settings = NULL;

static GtkWidget* notifications_plug_real_get_widget (SwitchboardPlug* base);
static void notifications_plug_real_shown (SwitchboardPlug* base);
static void notifications_plug_real_hidden (SwitchboardPlug* base);
static void notifications_plug_real_search_callback (SwitchboardPlug* base,
                                              const gchar* location);
static void notifications_plug_real_search_data_free (gpointer _data);
static void notifications_plug_real_search (SwitchboardPlug* base,
                                     const gchar* search,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean notifications_plug_real_search_co (NotificationsPlugSearchData* _data_);
static void notifications_plug_finalize (GObject * obj);
static GType notifications_plug_get_type_once (void);

static inline gpointer
notifications_plug_get_instance_private (NotificationsPlug* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsPlug_private_offset);
}

NotificationsPlug*
notifications_plug_construct (GType object_type)
{
	NotificationsPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "notifications", NULL);
	self = (NotificationsPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_PERSONAL, "code-name", "io.elementary.settings.notifications", "display-name", _ ("Notifications"), "description", _ ("Configure notification bubbles, sounds, and notification center"), "icon", "preferences-system-notifications", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

NotificationsPlug*
notifications_plug_new (void)
{
	return notifications_plug_construct (TYPE_NOTIFICATIONS_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
notifications_plug_real_get_widget (SwitchboardPlug* base)
{
	NotificationsPlug * self;
	GtkStack* _tmp0_;
	WidgetsMainView* _tmp3_;
	GranitePlaceholder* alert_view = NULL;
	gchar* _tmp4_;
	GThemedIcon* _tmp5_;
	GranitePlaceholder* _tmp6_ = NULL;
	GranitePlaceholder* _tmp7_;
	GtkWidget* _tmp8_;
	AdwToolbarView* _tmp9_ = NULL;
	AdwToolbarView* _tmp10_;
	AdwHeaderBar* _tmp11_;
	AdwHeaderBar* _tmp12_;
	GtkStack* _tmp13_ = NULL;
	GtkStack* _tmp14_;
	WidgetsMainView* _tmp15_;
	GtkStack* _tmp16_;
	AdwToolbarView* _tmp17_;
	GtkStack* _tmp18_;
	GtkWidget* _tmp19_;
	GtkWidget* result;
	self = (NotificationsPlug*) base;
	_tmp0_ = self->priv->stack;
	if (_tmp0_ != NULL) {
		GtkStack* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = widgets_main_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp3_;
	_tmp4_ = g_strdup (_ ("Notifications preferences are for configuring which apps make use of n" \
"otifications, for changing how an app's notifications appear, and for " \
"setting when you do not want to be disturbed by notifications."));
	_tmp5_ = (GThemedIcon*) g_themed_icon_new ("dialog-information");
	_tmp6_ = granite_placeholder_new (_ ("Apps with configurable notifications will appear here once installed."));
	granite_placeholder_set_description (_tmp6_, _tmp4_);
	_g_free0 (_tmp4_);
	granite_placeholder_set_icon (_tmp6_, (GIcon*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	alert_view = _tmp6_;
	_tmp7_ = alert_view;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->placeholder_view);
	self->priv->placeholder_view = _tmp9_;
	_tmp10_ = self->priv->placeholder_view;
	_tmp11_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	adw_toolbar_view_add_top_bar (_tmp10_, (GtkWidget*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_vhomogeneous (_tmp13_, FALSE);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp13_;
	_tmp14_ = self->priv->stack;
	_tmp15_ = self->priv->main_view;
	gtk_stack_add_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->stack;
	_tmp17_ = self->priv->placeholder_view;
	gtk_stack_add_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->stack;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (alert_view);
	return result;
}

static void
notifications_plug_real_shown (SwitchboardPlug* base)
{
	NotificationsPlug * self;
	BackendNotifyManager* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (NotificationsPlug*) base;
	_tmp0_ = backend_notify_manager_get_default ();
	_tmp1_ = backend_notify_manager_get_apps (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GtkStack* _tmp5_;
		WidgetsMainView* _tmp6_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->main_view;
		gtk_stack_set_visible_child (_tmp5_, (GtkWidget*) _tmp6_);
	} else {
		GtkStack* _tmp7_;
		AdwToolbarView* _tmp8_;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->placeholder_view;
		gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
	}
}

static void
notifications_plug_real_hidden (SwitchboardPlug* base)
{
	NotificationsPlug * self;
	self = (NotificationsPlug*) base;
}

static void
notifications_plug_real_search_callback (SwitchboardPlug* base,
                                         const gchar* location)
{
	NotificationsPlug * self;
	self = (NotificationsPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
notifications_plug_real_search_data_free (gpointer _data)
{
	NotificationsPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (NotificationsPlugSearchData, _data_);
}

static void
notifications_plug_real_search (SwitchboardPlug* base,
                                const gchar* search,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	NotificationsPlug * self;
	NotificationsPlugSearchData* _data_;
	NotificationsPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (NotificationsPlug*) base;
	_data_ = g_slice_new0 (NotificationsPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, notifications_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	notifications_plug_real_search_co (_data_);
}

static GeeTreeMap*
notifications_plug_search_finish (SwitchboardPlug* base,
                                  GAsyncResult* _res_)
{
	GeeTreeMap* result;
	NotificationsPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
notifications_plug_real_search_co (NotificationsPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Do Not Disturb"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("Notifications Center"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Sound"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "");
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Bubbles"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, "");
	_g_free0 (_data_->_tmp18_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
notifications_plug_class_init (NotificationsPlugClass * klass,
                               gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	notifications_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) notifications_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) notifications_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) notifications_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) notifications_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) notifications_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) notifications_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = notifications_plug_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "io.elementary.notifications", TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		g_debug ("Plug.vala:29: Using io.elementary.notifications server");
		_tmp4_ = g_settings_new ("io.elementary.notifications");
		_g_object_unref0 (notifications_plug_notify_settings);
		notifications_plug_notify_settings = _tmp4_;
	} else {
		GSettings* _tmp5_;
		g_debug ("Plug.vala:32: Using notifications in gala");
		_tmp5_ = g_settings_new ("org.pantheon.desktop.gala.notifications");
		_g_object_unref0 (notifications_plug_notify_settings);
		notifications_plug_notify_settings = _tmp5_;
	}
}

static void
notifications_plug_instance_init (NotificationsPlug * self,
                                  gpointer klass)
{
	self->priv = notifications_plug_get_instance_private (self);
}

static void
notifications_plug_finalize (GObject * obj)
{
	NotificationsPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATIONS_PLUG, NotificationsPlug);
	_g_object_unref0 (self->priv->placeholder_view);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->main_view);
	G_OBJECT_CLASS (notifications_plug_parent_class)->finalize (obj);
}

static GType
notifications_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsPlug), 0, (GInstanceInitFunc) notifications_plug_instance_init, NULL };
	GType notifications_plug_type_id;
	notifications_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "NotificationsPlug", &g_define_type_info, 0);
	NotificationsPlug_private_offset = g_type_add_instance_private (notifications_plug_type_id, sizeof (NotificationsPlugPrivate));
	return notifications_plug_type_id;
}

GType
notifications_plug_get_type (void)
{
	static volatile gsize notifications_plug_type_id__once = 0;
	if (g_once_init_enter (&notifications_plug_type_id__once)) {
		GType notifications_plug_type_id;
		notifications_plug_type_id = notifications_plug_get_type_once ();
		g_once_init_leave (&notifications_plug_type_id__once, notifications_plug_type_id);
	}
	return notifications_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	NotificationsPlug* plug = NULL;
	NotificationsPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:88: Activating Notifications plug");
	_tmp0_ = notifications_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

