/* Page.c generated by valac 0.56.17, the Vala compiler
 * generated from Page.vala, do not modify */

/*
 * Copyright 2015-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 *              xapantu
 */

#include "network.h"
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <switchboard.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib-object.h>

#define NETWORK_UNKNOWN_STR _ ("Unknown")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_PAGE_0_PROPERTY,
	NETWORK_WIDGETS_PAGE_STATE_PROPERTY,
	NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY,
	NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY,
	NETWORK_WIDGETS_PAGE_NUM_PROPERTIES
};
static GParamSpec* network_widgets_page_properties[NETWORK_WIDGETS_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkWidgetsPagePrivate {
	NMDeviceState _state;
	NMDevice* _device;
	gboolean _connection_editor_available;
	gboolean switch_updating;
};

static gint NetworkWidgetsPage_private_offset;
static gpointer network_widgets_page_parent_class = NULL;

static void network_widgets_page_real_update_status (NetworkWidgetsPage* self);
static void network_widgets_page_real_update (NetworkWidgetsPage* self);
static void network_widgets_page_real_update_name (NetworkWidgetsPage* self,
                                            gint count);
static void network_widgets_page_real_update_switch (NetworkWidgetsPage* self);
static void network_widgets_page_real_control_switch_activated (NetworkWidgetsPage* self);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void network_widgets_page_get_uuid (NetworkWidgetsPage* self);
static void network_widgets_page_set_connection_editor_available (NetworkWidgetsPage* self,
                                                           gboolean value);
static GObject * network_widgets_page_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _network_widgets_page_control_switch_activated_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _network_widgets_page_update_network_widgets_info_box_info_changed (NetworkWidgetsInfoBox* _sender,
                                                                         gpointer self);
static void _network_widgets_page____lambda9_ (NetworkWidgetsPage* self);
static void __network_widgets_page____lambda9__nm_device_state_changed (NMDevice* _sender,
                                                                 guint new_state,
                                                                 guint old_state,
                                                                 guint reason,
                                                                 gpointer self);
static void network_widgets_page_finalize (GObject * obj);
static GType network_widgets_page_get_type_once (void);
static void _vala_network_widgets_page_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_network_widgets_page_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
network_widgets_page_get_instance_private (NetworkWidgetsPage* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsPage_private_offset);
}

static void
network_widgets_page_real_update_status (NetworkWidgetsPage* self)
{
	NMDevice* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	NMDevice* _tmp3_;
	NMDeviceState _tmp4_;
	NMDeviceState _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = self->priv->_device;
	_tmp1_ = nm_device_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case NM_DEVICE_STATE_ACTIVATED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
			break;
		}
		case NM_DEVICE_STATE_FAILED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR);
			break;
		}
		default:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING);
			break;
		}
	}
	_tmp3_ = self->priv->_device;
	_tmp4_ = nm_device_get_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = network_utils_state_to_string (_tmp5_);
	_tmp7_ = _tmp6_;
	switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp7_);
	_g_free0 (_tmp7_);
}

void
network_widgets_page_update_status (NetworkWidgetsPage* self)
{
	NetworkWidgetsPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_PAGE_GET_CLASS (self);
	if (_klass_->update_status) {
		_klass_->update_status (self);
	}
}

static void
network_widgets_page_real_update (NetworkWidgetsPage* self)
{
	NetworkWidgetsInfoBox* _tmp0_;
	_tmp0_ = self->info_box;
	if (_tmp0_ != NULL) {
		gchar* sent_bytes = NULL;
		gchar* received_bytes = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		NetworkWidgetsInfoBox* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		network_widgets_page_get_activity_information (self, &_tmp1_, &_tmp2_);
		_g_free0 (sent_bytes);
		sent_bytes = _tmp1_;
		_g_free0 (received_bytes);
		received_bytes = _tmp2_;
		_tmp3_ = self->info_box;
		_tmp4_ = sent_bytes;
		_tmp5_ = received_bytes;
		network_widgets_info_box_update_activity (_tmp3_, _tmp4_, _tmp5_);
		_g_free0 (received_bytes);
		_g_free0 (sent_bytes);
	}
	network_widgets_page_update_switch (self);
}

void
network_widgets_page_update (NetworkWidgetsPage* self)
{
	NetworkWidgetsPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_PAGE_GET_CLASS (self);
	if (_klass_->update) {
		_klass_->update (self);
	}
}

static void
network_widgets_page_real_update_name (NetworkWidgetsPage* self,
                                       gint count)
{
	NMDevice* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = self->priv->_device;
	_tmp1_ = nm_device_get_description (_tmp0_);
	_tmp2_ = g_strdup_printf (_ ("Unknown type: %s "), _tmp1_);
	_tmp3_ = _tmp2_;
	switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp3_);
	_g_free0 (_tmp3_);
}

void
network_widgets_page_update_name (NetworkWidgetsPage* self,
                                  gint count)
{
	NetworkWidgetsPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_PAGE_GET_CLASS (self);
	if (_klass_->update_name) {
		_klass_->update_name (self, count);
	}
}

static void
network_widgets_page_real_update_switch (NetworkWidgetsPage* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	NMDevice* _tmp2_;
	NMDeviceState _tmp3_;
	NMDeviceState _tmp4_;
	_tmp0_ = switchboard_settings_page_get_activatable ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	self->priv->switch_updating = TRUE;
	_tmp2_ = self->priv->_device;
	_tmp3_ = nm_device_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	switch (_tmp4_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_UNAVAILABLE:
		case NM_DEVICE_STATE_FAILED:
		{
			GtkSwitch* _tmp5_;
			GtkSwitch* _tmp6_;
			GtkSwitch* _tmp7_;
			GtkSwitch* _tmp8_;
			_tmp5_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp6_ = _tmp5_;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
			_tmp7_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp8_ = _tmp7_;
			gtk_switch_set_active (_tmp8_, FALSE);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		case NM_DEVICE_STATE_DEACTIVATING:
		{
			GtkSwitch* _tmp9_;
			GtkSwitch* _tmp10_;
			GtkSwitch* _tmp11_;
			GtkSwitch* _tmp12_;
			_tmp9_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp10_ = _tmp9_;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
			_tmp11_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp12_ = _tmp11_;
			gtk_switch_set_active (_tmp12_, FALSE);
			self->priv->switch_updating = FALSE;
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			GtkSwitch* _tmp13_;
			GtkSwitch* _tmp14_;
			GtkSwitch* _tmp15_;
			GtkSwitch* _tmp16_;
			_tmp13_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp14_ = _tmp13_;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
			_tmp15_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp16_ = _tmp15_;
			gtk_switch_set_active (_tmp16_, TRUE);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			GtkSwitch* _tmp17_;
			GtkSwitch* _tmp18_;
			GtkSwitch* _tmp19_;
			GtkSwitch* _tmp20_;
			_tmp17_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp18_ = _tmp17_;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, TRUE);
			_tmp19_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp20_ = _tmp19_;
			gtk_switch_set_active (_tmp20_, TRUE);
			self->priv->switch_updating = FALSE;
			break;
		}
		default:
		{
			break;
		}
	}
}

void
network_widgets_page_update_switch (NetworkWidgetsPage* self)
{
	NetworkWidgetsPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_PAGE_GET_CLASS (self);
	if (_klass_->update_switch) {
		_klass_->update_switch (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
network_widgets_page_real_control_switch_activated (NetworkWidgetsPage* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	if (self->priv->switch_updating) {
		return;
	}
	_tmp1_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		NMDevice* _tmp5_;
		_tmp5_ = self->priv->_device;
		_tmp0_ = nm_device_get_state (_tmp5_) == NM_DEVICE_STATE_ACTIVATED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			NMDevice* _tmp6_;
			_tmp6_ = self->priv->_device;
			nm_device_disconnect (_tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GtkSwitch* _tmp7_;
			GtkSwitch* _tmp8_;
			GraniteMessageDialog* message_dialog = NULL;
			GtkRoot* _tmp9_;
			GtkWindow* _tmp10_;
			GraniteMessageDialog* _tmp11_ = NULL;
			GraniteMessageDialog* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			GraniteMessageDialog* _tmp15_;
			GraniteMessageDialog* _tmp16_;
			GraniteMessageDialog* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
			_tmp8_ = _tmp7_;
			gtk_switch_set_active (_tmp8_, TRUE);
			_tmp9_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_window_get_type (), GtkWindow));
			_tmp11_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Failed To Disconnect"), _ ("Unable to disconnect from the currently connected network"), "network-error", GTK_BUTTONS_CLOSE);
			gtk_window_set_modal ((GtkWindow*) _tmp11_, TRUE);
			gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp10_);
			_g_object_unref0 (_tmp10_);
			g_object_ref_sink (_tmp11_);
			message_dialog = _tmp11_;
			_tmp12_ = message_dialog;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			granite_message_dialog_show_error_details (_tmp12_, _tmp14_);
			_tmp15_ = message_dialog;
			gtk_window_present ((GtkWindow*) _tmp15_);
			_tmp16_ = message_dialog;
			_tmp17_ = message_dialog;
			g_signal_connect_object ((GtkDialog*) _tmp16_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp17_, 0);
			_g_object_unref0 (message_dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		gboolean _tmp18_ = FALSE;
		GtkSwitch* _tmp19_;
		GtkSwitch* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = gtk_switch_get_active (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			NMDevice* _tmp23_;
			_tmp23_ = self->priv->_device;
			_tmp18_ = nm_device_get_state (_tmp23_) == NM_DEVICE_STATE_DISCONNECTED;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			NMConnection* connection = NULL;
			NMConnection* _tmp24_;
			GPtrArray* remote_array = NULL;
			NMDevice* _tmp25_;
			GPtrArray* _tmp26_;
			GPtrArray* _tmp27_;
			gboolean _tmp28_ = FALSE;
			GPtrArray* _tmp29_;
			_tmp24_ = nm_simple_connection_new ();
			connection = _tmp24_;
			_tmp25_ = self->priv->_device;
			_tmp26_ = nm_device_get_available_connections (_tmp25_);
			_tmp27_ = _g_ptr_array_ref0 (_tmp26_);
			remote_array = _tmp27_;
			_tmp29_ = remote_array;
			if (_tmp29_ != NULL) {
				GPtrArray* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				_tmp30_ = remote_array;
				_tmp31_ = vala_g_ptr_array_get_length (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp28_ = _tmp32_ > 0;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				NMConnection* _tmp33_;
				GPtrArray* _tmp34_;
				gconstpointer _tmp35_;
				const gchar* _tmp36_;
				NetworkNetworkManager* network_manager = NULL;
				NetworkNetworkManager* _tmp37_;
				NetworkNetworkManager* _tmp38_;
				NMClient* _tmp39_;
				NMClient* _tmp40_;
				NMConnection* _tmp41_;
				NMDevice* _tmp42_;
				_tmp33_ = connection;
				_tmp34_ = remote_array;
				_tmp35_ = g_ptr_array_index (_tmp34_, (guint) 0);
				_tmp36_ = nm_connection_get_path ((NMConnection*) ((NMRemoteConnection*) _tmp35_));
				nm_connection_set_path (_tmp33_, _tmp36_);
				_tmp37_ = network_network_manager_get_default ();
				network_manager = _tmp37_;
				_tmp38_ = network_manager;
				_tmp39_ = network_network_manager_get_client (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = connection;
				_tmp42_ = self->priv->_device;
				nm_client_activate_connection_async (_tmp40_, _tmp41_, _tmp42_, NULL, NULL, NULL, NULL);
			}
			_g_ptr_array_unref0 (remote_array);
			_g_object_unref0 (connection);
		}
	}
}

void
network_widgets_page_control_switch_activated (NetworkWidgetsPage* self)
{
	NetworkWidgetsPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_WIDGETS_PAGE_GET_CLASS (self);
	if (_klass_->control_switch_activated) {
		_klass_->control_switch_activated (self);
	}
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

void
network_widgets_page_get_activity_information (NetworkWidgetsPage* self,
                                               gchar** sent_bytes,
                                               gchar** received_bytes)
{
	gchar* _vala_sent_bytes = NULL;
	gchar* _vala_received_bytes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* iface = NULL;
	NMDevice* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* tx_bytes_path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* rx_bytes_path = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (NETWORK_UNKNOWN_STR);
	_g_free0 (_vala_sent_bytes);
	_vala_sent_bytes = _tmp0_;
	_tmp1_ = g_strdup (NETWORK_UNKNOWN_STR);
	_g_free0 (_vala_received_bytes);
	_vala_received_bytes = _tmp1_;
	_tmp2_ = self->priv->_device;
	_tmp3_ = nm_device_get_ip_iface (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	iface = _tmp4_;
	_tmp5_ = iface;
	if (_tmp5_ == NULL) {
		_g_free0 (iface);
		if (sent_bytes) {
			*sent_bytes = _vala_sent_bytes;
		} else {
			_g_free0 (_vala_sent_bytes);
		}
		if (received_bytes) {
			*received_bytes = _vala_received_bytes;
		} else {
			_g_free0 (_vala_received_bytes);
		}
		return;
	}
	_tmp6_ = iface;
	_tmp7_ = g_build_filename (G_DIR_SEPARATOR_S, "sys", "class", "net", _tmp6_, "statistics", "tx_bytes", NULL);
	tx_bytes_path = _tmp7_;
	_tmp8_ = iface;
	_tmp9_ = g_build_filename (G_DIR_SEPARATOR_S, "sys", "class", "net", _tmp8_, "statistics", "rx_bytes", NULL);
	rx_bytes_path = _tmp9_;
	_tmp11_ = tx_bytes_path;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_query_exists (_tmp13_, NULL);
	_g_object_unref0 (_tmp13_);
	if (_tmp14_) {
		const gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = rx_bytes_path;
		_tmp16_ = g_file_new_for_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp10_ = g_file_query_exists (_tmp17_, NULL);
		_g_object_unref0 (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (!_tmp10_) {
		_g_free0 (rx_bytes_path);
		_g_free0 (tx_bytes_path);
		_g_free0 (iface);
		if (sent_bytes) {
			*sent_bytes = _vala_sent_bytes;
		} else {
			_g_free0 (_vala_sent_bytes);
		}
		if (received_bytes) {
			*received_bytes = _vala_received_bytes;
		} else {
			_g_free0 (_vala_received_bytes);
		}
		return;
	}
	{
		gchar* tx_bytes = NULL;
		gchar* rx_bytes = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp18_ = tx_bytes_path;
		g_file_get_contents (_tmp18_, &_tmp19_, NULL, &_inner_error0_);
		_g_free0 (tx_bytes);
		tx_bytes = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (rx_bytes);
			_g_free0 (tx_bytes);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (rx_bytes_path);
			_g_free0 (tx_bytes_path);
			_g_free0 (iface);
			_g_free0 (_vala_sent_bytes);
			_g_free0 (_vala_received_bytes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp20_ = rx_bytes_path;
		g_file_get_contents (_tmp20_, &_tmp21_, NULL, &_inner_error0_);
		_g_free0 (rx_bytes);
		rx_bytes = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (rx_bytes);
			_g_free0 (tx_bytes);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (rx_bytes_path);
			_g_free0 (tx_bytes_path);
			_g_free0 (iface);
			_g_free0 (_vala_sent_bytes);
			_g_free0 (_vala_received_bytes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp22_ = tx_bytes;
		_tmp23_ = g_format_size_full (uint64_parse (_tmp22_, (guint) 0), G_FORMAT_SIZE_DEFAULT);
		_g_free0 (_vala_sent_bytes);
		_vala_sent_bytes = _tmp23_;
		_tmp24_ = rx_bytes;
		_tmp25_ = g_format_size_full (uint64_parse (_tmp24_, (guint) 0), G_FORMAT_SIZE_DEFAULT);
		_g_free0 (_vala_received_bytes);
		_vala_received_bytes = _tmp25_;
		_g_free0 (rx_bytes);
		_g_free0 (tx_bytes);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_critical ("Page.vala:192: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (rx_bytes_path);
		_g_free0 (tx_bytes_path);
		_g_free0 (iface);
		_g_free0 (_vala_sent_bytes);
		_g_free0 (_vala_received_bytes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (rx_bytes_path);
	_g_free0 (tx_bytes_path);
	_g_free0 (iface);
	if (sent_bytes) {
		*sent_bytes = _vala_sent_bytes;
	} else {
		_g_free0 (_vala_sent_bytes);
	}
	if (received_bytes) {
		*received_bytes = _vala_received_bytes;
	} else {
		_g_free0 (_vala_received_bytes);
	}
}

static void
network_widgets_page_get_uuid (NetworkWidgetsPage* self)
{
	NMActiveConnection* active_connection = NULL;
	NMDevice* _tmp0_;
	NMActiveConnection* _tmp1_;
	NMActiveConnection* _tmp2_;
	NMActiveConnection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = nm_device_get_active_connection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	active_connection = _tmp2_;
	_tmp3_ = active_connection;
	if (_tmp3_ != NULL) {
		NMActiveConnection* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = active_connection;
		_tmp5_ = nm_active_connection_get_uuid (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->uuid);
		self->uuid = _tmp6_;
	} else {
		GPtrArray* available_connections = NULL;
		NMDevice* _tmp7_;
		GPtrArray* _tmp8_;
		GPtrArray* _tmp9_;
		GPtrArray* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp7_ = self->priv->_device;
		_tmp8_ = nm_device_get_available_connections (_tmp7_);
		_tmp9_ = _g_ptr_array_ref0 (_tmp8_);
		available_connections = _tmp9_;
		_tmp10_ = available_connections;
		_tmp11_ = vala_g_ptr_array_get_length (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			GPtrArray* _tmp13_;
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp13_ = available_connections;
			_tmp14_ = g_ptr_array_index (_tmp13_, (guint) 0);
			_tmp15_ = nm_connection_get_uuid ((NMConnection*) ((NMRemoteConnection*) _tmp14_));
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (self->uuid);
			self->uuid = _tmp16_;
		} else {
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("");
			_g_free0 (self->uuid);
			self->uuid = _tmp17_;
		}
		_g_ptr_array_unref0 (available_connections);
	}
	_g_object_unref0 (active_connection);
}

void
network_widgets_page_edit_connections (NetworkWidgetsPage* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GAppInfo* appinfo = NULL;
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
		_tmp0_ = g_app_info_create_from_commandline ("nm-connection-editor", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		appinfo = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = appinfo;
		g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Page.vala:217: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
network_widgets_page_open_advanced_settings (NetworkWidgetsPage* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GAppInfo* appinfo = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		_tmp0_ = self->uuid;
		_tmp1_ = g_strdup_printf ("nm-connection-editor --edit=%s", _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_app_info_create_from_commandline (_tmp2_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		appinfo = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = appinfo;
		g_app_info_launch (_tmp5_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("Page.vala:229: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

NetworkWidgetsPage*
network_widgets_page_construct (GType object_type)
{
	NetworkWidgetsPage * self = NULL;
	self = (NetworkWidgetsPage*) switchboard_settings_page_construct (object_type);
	return self;
}

NMDeviceState
network_widgets_page_get_state (NetworkWidgetsPage* self)
{
	NMDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
network_widgets_page_set_state (NetworkWidgetsPage* self,
                                NMDeviceState value)
{
	NMDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_page_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_STATE_PROPERTY]);
	}
}

NMDevice*
network_widgets_page_get_device (NetworkWidgetsPage* self)
{
	NMDevice* result;
	NMDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
network_widgets_page_set_device (NetworkWidgetsPage* self,
                                 NMDevice* value)
{
	NMDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_page_get_device (self);
	if (old_value != value) {
		NMDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY]);
	}
}

gboolean
network_widgets_page_get_connection_editor_available (NetworkWidgetsPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_connection_editor_available;
	return result;
}

static void
network_widgets_page_set_connection_editor_available (NetworkWidgetsPage* self,
                                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_page_get_connection_editor_available (self);
	if (old_value != value) {
		self->priv->_connection_editor_available = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY]);
	}
}

static void
_network_widgets_page_control_switch_activated_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	network_widgets_page_control_switch_activated ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page_update_network_widgets_info_box_info_changed (NetworkWidgetsInfoBox* _sender,
                                                                    gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page____lambda9_ (NetworkWidgetsPage* self)
{
	network_widgets_page_update_status (self);
	network_widgets_page_get_uuid (self);
}

static void
__network_widgets_page____lambda9__nm_device_state_changed (NMDevice* _sender,
                                                            guint new_state,
                                                            guint old_state,
                                                            guint reason,
                                                            gpointer self)
{
	_network_widgets_page____lambda9_ ((NetworkWidgetsPage*) self);
}

static GObject *
network_widgets_page_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsPage * self;
	NMDevice* _tmp0_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	NMDevice* _tmp10_;
	parent_class = G_OBJECT_CLASS (network_widgets_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_PAGE, NetworkWidgetsPage);
	_tmp0_ = self->priv->_device;
	if (_tmp0_ != NULL) {
		NMDevice* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_device;
		_tmp2_ = network_utils_type_to_string (nm_device_get_device_type (_tmp1_));
		_tmp3_ = _tmp2_;
		switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = switchboard_settings_page_get_title ((SwitchboardSettingsPage*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == NULL) {
			switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _ ("Unknown Device"));
		}
	}
	_tmp6_ = switchboard_settings_page_get_activatable ((SwitchboardSettingsPage*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkSwitch* _tmp8_;
		GtkSwitch* _tmp9_;
		_tmp8_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp9_ = _tmp8_;
		g_signal_connect_object ((GObject*) _tmp9_, "notify::active", (GCallback) _network_widgets_page_control_switch_activated_g_object_notify, self, 0);
	}
	_tmp10_ = self->priv->_device;
	if (_tmp10_ != NULL) {
		NMDevice* _tmp11_;
		NetworkWidgetsInfoBox* _tmp12_ = NULL;
		NetworkWidgetsInfoBox* _tmp13_;
		NMDevice* _tmp14_;
		_tmp11_ = self->priv->_device;
		_tmp12_ = network_widgets_info_box_new_from_device (_tmp11_);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp12_, TRUE);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->info_box);
		self->info_box = _tmp12_;
		_tmp13_ = self->info_box;
		g_signal_connect_object (_tmp13_, "info-changed", (GCallback) _network_widgets_page_update_network_widgets_info_box_info_changed, self, 0);
		network_widgets_page_get_uuid (self);
		_tmp14_ = self->priv->_device;
		g_signal_connect_object (_tmp14_, "state-changed", (GCallback) __network_widgets_page____lambda9__nm_device_state_changed, self, G_CONNECT_AFTER);
		network_widgets_page_update_status (self);
	}
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	return obj;
}

static void
network_widgets_page_class_init (NetworkWidgetsPageClass * klass,
                                 gpointer klass_data)
{
	network_widgets_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsPage_private_offset);
	((NetworkWidgetsPageClass *) klass)->update_status = (void (*) (NetworkWidgetsPage*)) network_widgets_page_real_update_status;
	((NetworkWidgetsPageClass *) klass)->update = (void (*) (NetworkWidgetsPage*)) network_widgets_page_real_update;
	((NetworkWidgetsPageClass *) klass)->update_name = (void (*) (NetworkWidgetsPage*, gint)) network_widgets_page_real_update_name;
	((NetworkWidgetsPageClass *) klass)->update_switch = (void (*) (NetworkWidgetsPage*)) network_widgets_page_real_update_switch;
	((NetworkWidgetsPageClass *) klass)->control_switch_activated = (void (*) (NetworkWidgetsPage*)) network_widgets_page_real_control_switch_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_PAGE_STATE_PROPERTY, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", nm_device_state_get_type (), NM_DEVICE_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", nm_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY, network_widgets_page_properties[NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY] = g_param_spec_boolean ("connection-editor-available", "connection-editor-available", "connection-editor-available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_widgets_page_instance_init (NetworkWidgetsPage * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = network_widgets_page_get_instance_private (self);
	self->priv->_state = NM_DEVICE_STATE_DISCONNECTED;
	self->priv->_connection_editor_available = FALSE;
	_tmp0_ = g_strdup ("");
	self->uuid = _tmp0_;
	self->priv->switch_updating = FALSE;
}

static void
network_widgets_page_finalize (GObject * obj)
{
	NetworkWidgetsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_PAGE, NetworkWidgetsPage);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->info_box);
	_g_free0 (self->uuid);
	G_OBJECT_CLASS (network_widgets_page_parent_class)->finalize (obj);
}

static GType
network_widgets_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsPage), 0, (GInstanceInitFunc) network_widgets_page_instance_init, NULL };
	GType network_widgets_page_type_id;
	network_widgets_page_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "NetworkWidgetsPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	NetworkWidgetsPage_private_offset = g_type_add_instance_private (network_widgets_page_type_id, sizeof (NetworkWidgetsPagePrivate));
	return network_widgets_page_type_id;
}

GType
network_widgets_page_get_type (void)
{
	static volatile gsize network_widgets_page_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_page_type_id__once)) {
		GType network_widgets_page_type_id;
		network_widgets_page_type_id = network_widgets_page_get_type_once ();
		g_once_init_leave (&network_widgets_page_type_id__once, network_widgets_page_type_id);
	}
	return network_widgets_page_type_id__once;
}

static void
_vala_network_widgets_page_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	NetworkWidgetsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_PAGE, NetworkWidgetsPage);
	switch (property_id) {
		case NETWORK_WIDGETS_PAGE_STATE_PROPERTY:
		g_value_set_enum (value, network_widgets_page_get_state (self));
		break;
		case NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY:
		g_value_set_object (value, network_widgets_page_get_device (self));
		break;
		case NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, network_widgets_page_get_connection_editor_available (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_page_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	NetworkWidgetsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_PAGE, NetworkWidgetsPage);
	switch (property_id) {
		case NETWORK_WIDGETS_PAGE_STATE_PROPERTY:
		network_widgets_page_set_state (self, g_value_get_enum (value));
		break;
		case NETWORK_WIDGETS_PAGE_DEVICE_PROPERTY:
		network_widgets_page_set_device (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_PAGE_CONNECTION_EDITOR_AVAILABLE_PROPERTY:
		network_widgets_page_set_connection_editor_available (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

