/* VirtualMonitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VirtualMonitor.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "display.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_VIRTUAL_MONITOR_0_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_X_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_ID_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_IS_MIRROR_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_MONITOR_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_NUM_PROPERTIES
};
static GParamSpec* display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
enum  {
	DISPLAY_VIRTUAL_MONITOR_SCALE_0_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY,
	DISPLAY_VIRTUAL_MONITOR_SCALE_NUM_PROPERTIES
};
static GParamSpec* display_virtual_monitor_scale_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	DISPLAY_VIRTUAL_MONITOR_MODES_CHANGED_SIGNAL,
	DISPLAY_VIRTUAL_MONITOR_NUM_SIGNALS
};
static guint display_virtual_monitor_signals[DISPLAY_VIRTUAL_MONITOR_NUM_SIGNALS] = {0};

struct _DisplayVirtualMonitorPrivate {
	gint _x;
	gint _y;
	gint _current_x;
	gint _current_y;
	GtkSingleSelection* _available_scales;
	DisplayTransform _transform;
	gboolean _primary;
	GeeLinkedList* _monitors;
	gboolean _is_active;
	GListStore* available_scales_store;
};

struct _Block1Data {
	int _ref_count_;
	DisplayVirtualMonitor* self;
	DisplayMonitorMode* current_mode;
};

struct _DisplayVirtualMonitorScalePrivate {
	gdouble _scale;
	gchar* _string_representation;
};

static gint DisplayVirtualMonitor_private_offset;
static gpointer display_virtual_monitor_parent_class = NULL;
static gint DisplayVirtualMonitorScale_private_offset;
static gpointer display_virtual_monitor_scale_parent_class = NULL;

static void display_virtual_monitor_update_available_scales (DisplayVirtualMonitor* self);
static void _vala_array_add1 (DisplayVirtualMonitorScale** * array,
                       gint* length,
                       gint* size,
                       DisplayVirtualMonitorScale* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda4_ (Block1Data* _data1_,
                      DisplayMonitor* _monitor);
static gboolean ____lambda4__gee_forall_func (gpointer g,
                                       gpointer self);
static void display_virtual_monitor_scale_finalize (GObject * obj);
static GType display_virtual_monitor_scale_get_type_once (void);
static void _vala_display_virtual_monitor_scale_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_display_virtual_monitor_scale_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static GObject * display_virtual_monitor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void display_virtual_monitor_finalize (GObject * obj);
static GType display_virtual_monitor_get_type_once (void);
static void _vala_display_virtual_monitor_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_display_virtual_monitor_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_virtual_monitor_get_instance_private (DisplayVirtualMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayVirtualMonitor_private_offset);
}

const gchar*
display_virtual_monitor_get_display_name (DisplayVirtualMonitor* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = display_virtual_monitor_get_is_mirror (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = _ ("Mirrored Display");
		return result;
	} else {
		DisplayMonitor* _tmp2_;
		DisplayMonitor* _tmp3_;
		DisplayMonitor* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = display_virtual_monitor_get_monitor (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = display_monitor_get_display_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
		result = _tmp7_;
		return result;
	}
}

void
display_virtual_monitor_get_current_mode_size (DisplayVirtualMonitor* self,
                                               gint* width,
                                               gint* height)
{
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_active;
	if (!_tmp0_) {
		{
			GeeLinkedList* _mode_list = NULL;
			DisplayMonitor* _tmp1_;
			DisplayMonitor* _tmp2_;
			DisplayMonitor* _tmp3_;
			GeeLinkedList* _tmp4_;
			GeeLinkedList* _tmp5_;
			GeeLinkedList* _tmp6_;
			gint _mode_size = 0;
			GeeLinkedList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _mode_index = 0;
			_tmp1_ = display_virtual_monitor_get_monitor (self);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp4_ = display_monitor_get_modes (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp3_);
			_mode_list = _tmp6_;
			_tmp7_ = _mode_list;
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_mode_size = _tmp9_;
			_mode_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				DisplayMonitorMode* mode = NULL;
				GeeLinkedList* _tmp12_;
				gpointer _tmp13_;
				DisplayMonitorMode* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_mode_index = _mode_index + 1;
				_tmp10_ = _mode_index;
				_tmp11_ = _mode_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _mode_list;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _mode_index);
				mode = (DisplayMonitorMode*) _tmp13_;
				_tmp14_ = mode;
				_tmp15_ = display_monitor_mode_get_is_preferred (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					DisplayMonitorMode* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					DisplayMonitorMode* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					_tmp17_ = mode;
					_tmp18_ = display_monitor_mode_get_width (_tmp17_);
					_tmp19_ = _tmp18_;
					_vala_width = _tmp19_;
					_tmp20_ = mode;
					_tmp21_ = display_monitor_mode_get_height (_tmp20_);
					_tmp22_ = _tmp21_;
					_vala_height = _tmp22_;
					_g_object_unref0 (mode);
					if (width) {
						*width = _vala_width;
					}
					if (height) {
						*height = _vala_height;
					}
					return;
				}
				_g_object_unref0 (mode);
			}
		}
		_vala_width = 1280;
		_vala_height = 720;
	} else {
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp23_ = display_virtual_monitor_get_is_mirror (self);
		_tmp24_ = _tmp23_;
		if (_tmp24_) {
			DisplayMonitorMode* current_mode = NULL;
			GeeLinkedList* _tmp25_;
			gpointer _tmp26_;
			DisplayMonitor* _tmp27_;
			DisplayMonitorMode* _tmp28_;
			DisplayMonitorMode* _tmp29_;
			DisplayMonitorMode* _tmp30_;
			DisplayMonitorMode* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			DisplayMonitorMode* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			_tmp25_ = self->priv->_monitors;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
			_tmp27_ = (DisplayMonitor*) _tmp26_;
			_tmp28_ = display_monitor_get_current_mode (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_g_object_unref0 (_tmp27_);
			current_mode = _tmp30_;
			_tmp31_ = current_mode;
			_tmp32_ = display_monitor_mode_get_width (_tmp31_);
			_tmp33_ = _tmp32_;
			_vala_width = _tmp33_;
			_tmp34_ = current_mode;
			_tmp35_ = display_monitor_mode_get_height (_tmp34_);
			_tmp36_ = _tmp35_;
			_vala_height = _tmp36_;
			_g_object_unref0 (current_mode);
		} else {
			DisplayMonitorMode* current_mode = NULL;
			DisplayMonitor* _tmp37_;
			DisplayMonitor* _tmp38_;
			DisplayMonitor* _tmp39_;
			DisplayMonitorMode* _tmp40_;
			DisplayMonitorMode* _tmp41_;
			DisplayMonitorMode* _tmp42_;
			DisplayMonitorMode* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			DisplayMonitorMode* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			_tmp37_ = display_virtual_monitor_get_monitor (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp40_ = display_monitor_get_current_mode (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _tmp41_;
			_g_object_unref0 (_tmp39_);
			current_mode = _tmp42_;
			_tmp43_ = current_mode;
			_tmp44_ = display_monitor_mode_get_width (_tmp43_);
			_tmp45_ = _tmp44_;
			_vala_width = _tmp45_;
			_tmp46_ = current_mode;
			_tmp47_ = display_monitor_mode_get_height (_tmp46_);
			_tmp48_ = _tmp47_;
			_vala_height = _tmp48_;
			_g_object_unref0 (current_mode);
		}
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeLinkedList*
display_virtual_monitor_get_available_modes (DisplayVirtualMonitor* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = display_virtual_monitor_get_is_mirror (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		_tmp2_ = self->priv->_monitors;
		_tmp3_ = display_utils_get_common_monitor_modes (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		DisplayMonitor* _tmp4_;
		DisplayMonitor* _tmp5_;
		DisplayMonitor* _tmp6_;
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _tmp8_;
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		_tmp4_ = display_virtual_monitor_get_monitor (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = display_monitor_get_modes (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp6_);
		result = _tmp10_;
		return result;
	}
}

static void
_vala_array_add1 (DisplayVirtualMonitorScale** * array,
                  gint* length,
                  gint* size,
                  DisplayVirtualMonitorScale* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DisplayVirtualMonitorScale*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
display_virtual_monitor_update_available_scales (DisplayVirtualMonitor* self)
{
	DisplayVirtualMonitorScale** scales = NULL;
	DisplayVirtualMonitorScale** _tmp0_;
	gint scales_length1;
	gint _scales_size_;
	GListStore* _tmp19_;
	GListStore* _tmp20_;
	DisplayVirtualMonitorScale** _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (DisplayVirtualMonitorScale*, 0 + 1);
	scales = _tmp0_;
	scales_length1 = 0;
	_scales_size_ = scales_length1;
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _mode_index = 0;
		_tmp1_ = display_virtual_monitor_get_available_modes (self);
		_mode_list = _tmp1_;
		_tmp2_ = _mode_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_mode_size = _tmp4_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			DisplayMonitorMode* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			DisplayMonitorMode* _tmp16_;
			gdouble* _tmp17_;
			gint _tmp17__length1;
			_mode_index = _mode_index + 1;
			_tmp5_ = _mode_index;
			_tmp6_ = _mode_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _mode_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp8_;
			_tmp10_ = mode;
			_tmp11_ = display_monitor_mode_get_is_current (_tmp10_);
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				DisplayMonitorMode* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = mode;
				_tmp14_ = display_monitor_mode_get_is_preferred (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = !_tmp15_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_g_object_unref0 (mode);
				continue;
			}
			_tmp16_ = mode;
			_tmp17_ = _tmp16_->supported_scales;
			_tmp17__length1 = _tmp16_->supported_scales_length1;
			{
				gdouble* scale_collection = NULL;
				gint scale_collection_length1 = 0;
				gint _scale_collection_size_ = 0;
				gint scale_it = 0;
				scale_collection = _tmp17_;
				scale_collection_length1 = _tmp17__length1;
				for (scale_it = 0; scale_it < scale_collection_length1; scale_it = scale_it + 1) {
					gdouble scale = 0.0;
					scale = scale_collection[scale_it];
					{
						DisplayVirtualMonitorScale* _tmp18_;
						_tmp18_ = display_virtual_monitor_scale_new (scale);
						_vala_array_add1 (&scales, &scales_length1, &_scales_size_, _tmp18_);
					}
				}
			}
			_g_object_unref0 (mode);
			break;
		}
		_g_object_unref0 (_mode_list);
	}
	_tmp19_ = self->priv->available_scales_store;
	_tmp20_ = self->priv->available_scales_store;
	_tmp21_ = scales;
	_tmp21__length1 = scales_length1;
	g_list_store_splice (_tmp19_, (guint) 0, g_list_model_get_n_items ((GListModel*) _tmp20_), _tmp21_, (guint) _tmp21__length1);
	scales = (_vala_array_free (scales, scales_length1, (GDestroyNotify) g_object_unref), NULL);
}

DisplayMonitorMode*
display_virtual_monitor_get_mode_for_resolution (DisplayVirtualMonitor* self,
                                                 gint width,
                                                 gint height)
{
	DisplayMonitorMode* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mode_index = 0;
		_tmp0_ = display_virtual_monitor_get_available_modes (self);
		_mode_list = _tmp0_;
		_tmp1_ = _mode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mode_size = _tmp3_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			DisplayMonitorMode* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_mode_index = _mode_index + 1;
			_tmp4_ = _mode_index;
			_tmp5_ = _mode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp7_;
			_tmp9_ = mode;
			_tmp10_ = display_monitor_mode_get_width (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == width) {
				DisplayMonitorMode* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = mode;
				_tmp13_ = display_monitor_mode_get_height (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ == height;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = mode;
				_g_object_unref0 (_mode_list);
				return result;
			}
			_g_object_unref0 (mode);
		}
		_g_object_unref0 (_mode_list);
	}
	result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DisplayVirtualMonitor* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->current_mode);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda4_ (Block1Data* _data1_,
             DisplayMonitor* _monitor)
{
	DisplayVirtualMonitor* self;
	gboolean mode_found = FALSE;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (_monitor != NULL, FALSE);
	mode_found = FALSE;
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _mode_index = 0;
		_tmp0_ = display_monitor_get_modes (_monitor);
		_tmp1_ = _tmp0_;
		_mode_list = _tmp1_;
		_tmp2_ = _mode_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_mode_size = _tmp4_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp10_ = FALSE;
			DisplayMonitorMode* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_mode_index = _mode_index + 1;
			_tmp5_ = _mode_index;
			_tmp6_ = _mode_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _mode_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp8_;
			if (mode_found) {
				DisplayMonitorMode* _tmp9_;
				_tmp9_ = mode;
				display_monitor_mode_set_is_current (_tmp9_, FALSE);
				_g_object_unref0 (mode);
				continue;
			}
			_tmp11_ = mode;
			_tmp12_ = display_monitor_mode_get_width (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = display_monitor_mode_get_width (_data1_->current_mode);
			_tmp15_ = _tmp14_;
			if (_tmp13_ == _tmp15_) {
				DisplayMonitorMode* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				_tmp16_ = mode;
				_tmp17_ = display_monitor_mode_get_height (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = display_monitor_mode_get_height (_data1_->current_mode);
				_tmp20_ = _tmp19_;
				_tmp10_ = _tmp18_ == _tmp20_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				DisplayMonitorMode* _tmp21_;
				mode_found = TRUE;
				_tmp21_ = mode;
				display_monitor_mode_set_is_current (_tmp21_, TRUE);
			} else {
				DisplayMonitorMode* _tmp22_;
				_tmp22_ = mode;
				display_monitor_mode_set_is_current (_tmp22_, FALSE);
			}
			_g_object_unref0 (mode);
		}
	}
	result = TRUE;
	_g_object_unref0 (_monitor);
	return result;
}

static gboolean
____lambda4__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda4_ (self, (DisplayMonitor*) g);
	return result;
}

void
display_virtual_monitor_set_current_mode (DisplayVirtualMonitor* self,
                                          DisplayMonitorMode* current_mode)
{
	Block1Data* _data1_;
	DisplayMonitorMode* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_mode != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (current_mode);
	_g_object_unref0 (_data1_->current_mode);
	_data1_->current_mode = _tmp0_;
	_tmp1_ = display_virtual_monitor_get_is_mirror (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GeeLinkedList* _tmp3_;
		_tmp3_ = self->priv->_monitors;
		gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp3_, ____lambda4__gee_forall_func, _data1_);
	} else {
		{
			GeeLinkedList* _mode_list = NULL;
			DisplayMonitor* _tmp4_;
			DisplayMonitor* _tmp5_;
			DisplayMonitor* _tmp6_;
			GeeLinkedList* _tmp7_;
			GeeLinkedList* _tmp8_;
			GeeLinkedList* _tmp9_;
			gint _mode_size = 0;
			GeeLinkedList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _mode_index = 0;
			_tmp4_ = display_virtual_monitor_get_monitor (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = display_monitor_get_modes (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp6_);
			_mode_list = _tmp9_;
			_tmp10_ = _mode_list;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_mode_size = _tmp12_;
			_mode_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				DisplayMonitorMode* mode = NULL;
				GeeLinkedList* _tmp15_;
				gpointer _tmp16_;
				DisplayMonitorMode* _tmp17_;
				DisplayMonitorMode* _tmp18_;
				_mode_index = _mode_index + 1;
				_tmp13_ = _mode_index;
				_tmp14_ = _mode_size;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = _mode_list;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _mode_index);
				mode = (DisplayMonitorMode*) _tmp16_;
				_tmp17_ = mode;
				_tmp18_ = mode;
				display_monitor_mode_set_is_current (_tmp17_, _tmp18_ == _data1_->current_mode);
				_g_object_unref0 (mode);
			}
		}
	}
	_tmp19_ = display_monitor_mode_get_preferred_scale (_data1_->current_mode);
	_tmp20_ = _tmp19_;
	display_virtual_monitor_set_scale (self, _tmp20_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

gchar*
display_virtual_monitor_generate_id_from_monitors (MutterReadMonitorInfo* infos,
                                                   gint infos_length1)
{
	guint val = 0U;
	gchar* _tmp5_;
	gchar* result;
	val = (guint) 0;
	{
		MutterReadMonitorInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = infos;
		info_collection_length1 = infos_length1;
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
			MutterReadMonitorInfo _tmp0_;
			MutterReadMonitorInfo _tmp1_ = {0};
			MutterReadMonitorInfo info = {0};
			_tmp0_ = info_collection[info_it];
			mutter_read_monitor_info_copy (&_tmp0_, &_tmp1_);
			info = _tmp1_;
			{
				MutterReadMonitorInfo _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				_tmp2_ = info;
				_tmp3_ = mutter_read_monitor_info_get_hash (&_tmp2_);
				_tmp4_ = _tmp3_;
				val += _tmp4_;
				mutter_read_monitor_info_destroy (&info);
			}
		}
	}
	_tmp5_ = g_strdup_printf ("%u", val);
	result = _tmp5_;
	return result;
}

DisplayVirtualMonitor*
display_virtual_monitor_construct (GType object_type)
{
	DisplayVirtualMonitor * self = NULL;
	self = (DisplayVirtualMonitor*) g_object_new (object_type, NULL);
	return self;
}

DisplayVirtualMonitor*
display_virtual_monitor_new (void)
{
	return display_virtual_monitor_construct (DISPLAY_TYPE_VIRTUAL_MONITOR);
}

gint
display_virtual_monitor_get_x (DisplayVirtualMonitor* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_x;
	return result;
}

void
display_virtual_monitor_set_x (DisplayVirtualMonitor* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_x (self);
	if (old_value != value) {
		self->priv->_x = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_X_PROPERTY]);
	}
}

gint
display_virtual_monitor_get_y (DisplayVirtualMonitor* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_y;
	return result;
}

void
display_virtual_monitor_set_y (DisplayVirtualMonitor* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_y (self);
	if (old_value != value) {
		self->priv->_y = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY]);
	}
}

gint
display_virtual_monitor_get_current_x (DisplayVirtualMonitor* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_x;
	return result;
}

void
display_virtual_monitor_set_current_x (DisplayVirtualMonitor* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_current_x (self);
	if (old_value != value) {
		self->priv->_current_x = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY]);
	}
}

gint
display_virtual_monitor_get_current_y (DisplayVirtualMonitor* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_y;
	return result;
}

void
display_virtual_monitor_set_current_y (DisplayVirtualMonitor* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_current_y (self);
	if (old_value != value) {
		self->priv->_current_y = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY]);
	}
}

GtkSingleSelection*
display_virtual_monitor_get_available_scales (DisplayVirtualMonitor* self)
{
	GtkSingleSelection* result;
	GtkSingleSelection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_scales;
	result = _tmp0_;
	return result;
}

static void
display_virtual_monitor_set_available_scales (DisplayVirtualMonitor* self,
                                              GtkSingleSelection* value)
{
	GtkSingleSelection* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_available_scales (self);
	if (old_value != value) {
		GtkSingleSelection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_available_scales);
		self->priv->_available_scales = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY]);
	}
}

DisplayTransform
display_virtual_monitor_get_transform (DisplayVirtualMonitor* self)
{
	DisplayTransform result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_transform;
	return result;
}

void
display_virtual_monitor_set_transform (DisplayVirtualMonitor* self,
                                       DisplayTransform value)
{
	DisplayTransform old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_transform (self);
	if (old_value != value) {
		self->priv->_transform = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY]);
	}
}

gboolean
display_virtual_monitor_get_primary (DisplayVirtualMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_primary;
	return result;
}

void
display_virtual_monitor_set_primary (DisplayVirtualMonitor* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_primary (self);
	if (old_value != value) {
		self->priv->_primary = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY]);
	}
}

GeeLinkedList*
display_virtual_monitor_get_monitors (DisplayVirtualMonitor* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitors;
	result = _tmp0_;
	return result;
}

static void
display_virtual_monitor_set_monitors (DisplayVirtualMonitor* self,
                                      GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_monitors (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitors);
		self->priv->_monitors = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY]);
	}
}

gdouble
display_virtual_monitor_get_scale (DisplayVirtualMonitor* self)
{
	gdouble result;
	GtkSingleSelection* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_available_scales;
	_tmp1_ = gtk_single_selection_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = display_virtual_monitor_scale_get_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale));
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

void
display_virtual_monitor_set_scale (DisplayVirtualMonitor* self,
                                   gdouble value)
{
	g_return_if_fail (self != NULL);
	display_virtual_monitor_update_available_scales (self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkSingleSelection* _tmp2_;
				GtkSingleSelection* _tmp3_;
				GObject* _tmp4_;
				DisplayVirtualMonitorScale* _tmp5_;
				gdouble _tmp6_;
				gdouble _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_available_scales;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->_available_scales;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale);
				_tmp6_ = display_virtual_monitor_scale_get_scale (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = value == _tmp7_;
				_g_object_unref0 (_tmp5_);
				if (_tmp8_) {
					GtkSingleSelection* _tmp9_;
					_tmp9_ = self->priv->_available_scales;
					gtk_single_selection_set_selected (_tmp9_, (guint) i);
					return;
				}
			}
		}
	}
	g_critical ("VirtualMonitor.vala:58: Unsupported scale %f for current mode", value);
	g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY]);
}

gchar*
display_virtual_monitor_get_id (DisplayVirtualMonitor* self)
{
	gchar* result;
	guint val = 0U;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	val = (guint) 0;
	{
		GeeLinkedList* _monitor_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _monitor_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _monitor_index = 0;
		_tmp0_ = self->priv->_monitors;
		_monitor_list = _tmp0_;
		_tmp1_ = _monitor_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_monitor_size = _tmp3_;
		_monitor_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitor* monitor = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitor* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			_monitor_index = _monitor_index + 1;
			_tmp4_ = _monitor_index;
			_tmp5_ = _monitor_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _monitor_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _monitor_index);
			monitor = (DisplayMonitor*) _tmp7_;
			_tmp8_ = monitor;
			_tmp9_ = display_monitor_get_hash (_tmp8_);
			_tmp10_ = _tmp9_;
			val += _tmp10_;
			_g_object_unref0 (monitor);
		}
	}
	_tmp11_ = g_strdup_printf ("%u", val);
	result = _tmp11_;
	return result;
}

gboolean
display_virtual_monitor_get_is_mirror (DisplayVirtualMonitor* self)
{
	gboolean result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_monitors;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 1;
	return result;
}

gboolean
display_virtual_monitor_get_is_active (DisplayVirtualMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_active;
	return result;
}

void
display_virtual_monitor_set_is_active (DisplayVirtualMonitor* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_get_is_active (self);
	if (old_value != value) {
		self->priv->_is_active = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY]);
	}
}

DisplayMonitor*
display_virtual_monitor_get_monitor (DisplayVirtualMonitor* self)
{
	DisplayMonitor* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeLinkedList* _tmp2_;
	gpointer _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = display_virtual_monitor_get_is_mirror (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_critical ("VirtualMonitor.vala:92: Do not use Display.VirtualMonitor.monitor in a" \
" mirror context!");
	}
	_tmp2_ = self->priv->_monitors;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, 0);
	result = (DisplayMonitor*) _tmp3_;
	return result;
}

static inline gpointer
display_virtual_monitor_scale_get_instance_private (DisplayVirtualMonitorScale* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayVirtualMonitorScale_private_offset);
}

DisplayVirtualMonitorScale*
display_virtual_monitor_scale_construct (GType object_type,
                                         gdouble scale)
{
	DisplayVirtualMonitorScale * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup_printf ("%d %%", (gint) round (scale * 100));
	_tmp1_ = _tmp0_;
	self = (DisplayVirtualMonitorScale*) g_object_new (object_type, "scale", scale, "string-representation", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	return self;
}

DisplayVirtualMonitorScale*
display_virtual_monitor_scale_new (gdouble scale)
{
	return display_virtual_monitor_scale_construct (DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, scale);
}

gdouble
display_virtual_monitor_scale_get_scale (DisplayVirtualMonitorScale* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_scale;
	return result;
}

static void
display_virtual_monitor_scale_set_scale (DisplayVirtualMonitorScale* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_scale_get_scale (self);
	if (old_value != value) {
		self->priv->_scale = value;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_scale_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY]);
	}
}

const gchar*
display_virtual_monitor_scale_get_string_representation (DisplayVirtualMonitorScale* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_string_representation;
	result = _tmp0_;
	return result;
}

static void
display_virtual_monitor_scale_set_string_representation (DisplayVirtualMonitorScale* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_virtual_monitor_scale_get_string_representation (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_string_representation);
		self->priv->_string_representation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_virtual_monitor_scale_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY]);
	}
}

static void
display_virtual_monitor_scale_class_init (DisplayVirtualMonitorScaleClass * klass,
                                          gpointer klass_data)
{
	display_virtual_monitor_scale_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayVirtualMonitorScale_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_virtual_monitor_scale_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_virtual_monitor_scale_set_property;
	G_OBJECT_CLASS (klass)->finalize = display_virtual_monitor_scale_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY, display_virtual_monitor_scale_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY] = g_param_spec_double ("scale", "scale", "scale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY, display_virtual_monitor_scale_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY] = g_param_spec_string ("string-representation", "string-representation", "string-representation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
display_virtual_monitor_scale_instance_init (DisplayVirtualMonitorScale * self,
                                             gpointer klass)
{
	self->priv = display_virtual_monitor_scale_get_instance_private (self);
}

static void
display_virtual_monitor_scale_finalize (GObject * obj)
{
	DisplayVirtualMonitorScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale);
	_g_free0 (self->priv->_string_representation);
	G_OBJECT_CLASS (display_virtual_monitor_scale_parent_class)->finalize (obj);
}

static GType
display_virtual_monitor_scale_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayVirtualMonitorScaleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_virtual_monitor_scale_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayVirtualMonitorScale), 0, (GInstanceInitFunc) display_virtual_monitor_scale_instance_init, NULL };
	GType display_virtual_monitor_scale_type_id;
	display_virtual_monitor_scale_type_id = g_type_register_static (G_TYPE_OBJECT, "DisplayVirtualMonitorScale", &g_define_type_info, 0);
	DisplayVirtualMonitorScale_private_offset = g_type_add_instance_private (display_virtual_monitor_scale_type_id, sizeof (DisplayVirtualMonitorScalePrivate));
	return display_virtual_monitor_scale_type_id;
}

GType
display_virtual_monitor_scale_get_type (void)
{
	static volatile gsize display_virtual_monitor_scale_type_id__once = 0;
	if (g_once_init_enter (&display_virtual_monitor_scale_type_id__once)) {
		GType display_virtual_monitor_scale_type_id;
		display_virtual_monitor_scale_type_id = display_virtual_monitor_scale_get_type_once ();
		g_once_init_leave (&display_virtual_monitor_scale_type_id__once, display_virtual_monitor_scale_type_id);
	}
	return display_virtual_monitor_scale_type_id__once;
}

static void
_vala_display_virtual_monitor_scale_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	DisplayVirtualMonitorScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale);
	switch (property_id) {
		case DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY:
		g_value_set_double (value, display_virtual_monitor_scale_get_scale (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY:
		g_value_set_string (value, display_virtual_monitor_scale_get_string_representation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_virtual_monitor_scale_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	DisplayVirtualMonitorScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE, DisplayVirtualMonitorScale);
	switch (property_id) {
		case DISPLAY_VIRTUAL_MONITOR_SCALE_SCALE_PROPERTY:
		display_virtual_monitor_scale_set_scale (self, g_value_get_double (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_SCALE_STRING_REPRESENTATION_PROPERTY:
		display_virtual_monitor_scale_set_string_representation (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
display_virtual_monitor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayVirtualMonitor * self;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GListStore* _tmp2_;
	GListStore* _tmp3_;
	GListModel* _tmp4_;
	GtkSingleSelection* _tmp5_;
	GtkSingleSelection* _tmp6_;
	parent_class = G_OBJECT_CLASS (display_virtual_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_VIRTUAL_MONITOR, DisplayVirtualMonitor);
	_tmp0_ = gee_linked_list_new (DISPLAY_TYPE_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	display_virtual_monitor_set_monitors (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_list_store_new (DISPLAY_VIRTUAL_MONITOR_TYPE_SCALE);
	_g_object_unref0 (self->priv->available_scales_store);
	self->priv->available_scales_store = _tmp2_;
	_tmp3_ = self->priv->available_scales_store;
	_tmp4_ = _g_object_ref0 ((GListModel*) _tmp3_);
	_tmp5_ = gtk_single_selection_new (_tmp4_);
	_tmp6_ = _tmp5_;
	display_virtual_monitor_set_available_scales (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	return obj;
}

static void
display_virtual_monitor_class_init (DisplayVirtualMonitorClass * klass,
                                    gpointer klass_data)
{
	display_virtual_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayVirtualMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_virtual_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_virtual_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = display_virtual_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_virtual_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_X_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_X_PROPERTY] = g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY] = g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY] = g_param_spec_int ("current-x", "current-x", "current-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY] = g_param_spec_int ("current-y", "current-y", "current-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY] = g_param_spec_object ("available-scales", "available-scales", "available-scales", gtk_single_selection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY] = g_param_spec_enum ("transform", "transform", "transform", TYPE_DISPLAY_TRANSFORM, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY] = g_param_spec_boolean ("primary", "primary", "primary", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY] = g_param_spec_object ("monitors", "monitors", "monitors", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY] = g_param_spec_double ("scale", "scale", "scale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_ID_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_IS_MIRROR_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_IS_MIRROR_PROPERTY] = g_param_spec_boolean ("is-mirror", "is-mirror", "is-mirror", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY] = g_param_spec_boolean ("is-active", "is-active", "is-active", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_VIRTUAL_MONITOR_MONITOR_PROPERTY, display_virtual_monitor_properties[DISPLAY_VIRTUAL_MONITOR_MONITOR_PROPERTY] = g_param_spec_object ("monitor", "monitor", "monitor", DISPLAY_TYPE_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	display_virtual_monitor_signals[DISPLAY_VIRTUAL_MONITOR_MODES_CHANGED_SIGNAL] = g_signal_new ("modes-changed", DISPLAY_TYPE_VIRTUAL_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
display_virtual_monitor_instance_init (DisplayVirtualMonitor * self,
                                       gpointer klass)
{
	self->priv = display_virtual_monitor_get_instance_private (self);
	self->priv->_is_active = TRUE;
}

static void
display_virtual_monitor_finalize (GObject * obj)
{
	DisplayVirtualMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_VIRTUAL_MONITOR, DisplayVirtualMonitor);
	_g_object_unref0 (self->priv->_available_scales);
	_g_object_unref0 (self->priv->_monitors);
	_g_object_unref0 (self->priv->available_scales_store);
	G_OBJECT_CLASS (display_virtual_monitor_parent_class)->finalize (obj);
}

static GType
display_virtual_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayVirtualMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_virtual_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayVirtualMonitor), 0, (GInstanceInitFunc) display_virtual_monitor_instance_init, NULL };
	GType display_virtual_monitor_type_id;
	display_virtual_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DisplayVirtualMonitor", &g_define_type_info, 0);
	DisplayVirtualMonitor_private_offset = g_type_add_instance_private (display_virtual_monitor_type_id, sizeof (DisplayVirtualMonitorPrivate));
	return display_virtual_monitor_type_id;
}

GType
display_virtual_monitor_get_type (void)
{
	static volatile gsize display_virtual_monitor_type_id__once = 0;
	if (g_once_init_enter (&display_virtual_monitor_type_id__once)) {
		GType display_virtual_monitor_type_id;
		display_virtual_monitor_type_id = display_virtual_monitor_get_type_once ();
		g_once_init_leave (&display_virtual_monitor_type_id__once, display_virtual_monitor_type_id);
	}
	return display_virtual_monitor_type_id__once;
}

static void
_vala_display_virtual_monitor_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	DisplayVirtualMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_VIRTUAL_MONITOR, DisplayVirtualMonitor);
	switch (property_id) {
		case DISPLAY_VIRTUAL_MONITOR_X_PROPERTY:
		g_value_set_int (value, display_virtual_monitor_get_x (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY:
		g_value_set_int (value, display_virtual_monitor_get_y (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY:
		g_value_set_int (value, display_virtual_monitor_get_current_x (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY:
		g_value_set_int (value, display_virtual_monitor_get_current_y (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY:
		g_value_set_object (value, display_virtual_monitor_get_available_scales (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY:
		g_value_set_enum (value, display_virtual_monitor_get_transform (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY:
		g_value_set_boolean (value, display_virtual_monitor_get_primary (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY:
		g_value_set_object (value, display_virtual_monitor_get_monitors (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY:
		g_value_set_double (value, display_virtual_monitor_get_scale (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_ID_PROPERTY:
		g_value_take_string (value, display_virtual_monitor_get_id (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_IS_MIRROR_PROPERTY:
		g_value_set_boolean (value, display_virtual_monitor_get_is_mirror (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY:
		g_value_set_boolean (value, display_virtual_monitor_get_is_active (self));
		break;
		case DISPLAY_VIRTUAL_MONITOR_MONITOR_PROPERTY:
		g_value_take_object (value, display_virtual_monitor_get_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_virtual_monitor_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	DisplayVirtualMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_VIRTUAL_MONITOR, DisplayVirtualMonitor);
	switch (property_id) {
		case DISPLAY_VIRTUAL_MONITOR_X_PROPERTY:
		display_virtual_monitor_set_x (self, g_value_get_int (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_Y_PROPERTY:
		display_virtual_monitor_set_y (self, g_value_get_int (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_CURRENT_X_PROPERTY:
		display_virtual_monitor_set_current_x (self, g_value_get_int (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_CURRENT_Y_PROPERTY:
		display_virtual_monitor_set_current_y (self, g_value_get_int (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_AVAILABLE_SCALES_PROPERTY:
		display_virtual_monitor_set_available_scales (self, g_value_get_object (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_TRANSFORM_PROPERTY:
		display_virtual_monitor_set_transform (self, g_value_get_enum (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_PRIMARY_PROPERTY:
		display_virtual_monitor_set_primary (self, g_value_get_boolean (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_MONITORS_PROPERTY:
		display_virtual_monitor_set_monitors (self, g_value_get_object (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_SCALE_PROPERTY:
		display_virtual_monitor_set_scale (self, g_value_get_double (value));
		break;
		case DISPLAY_VIRTUAL_MONITOR_IS_ACTIVE_PROPERTY:
		display_virtual_monitor_set_is_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

