/* raw-gamepad.c generated by valac 0.56.18, the Vala compiler
 * generated from raw-gamepad.vala, do not modify */

/*
 * Copyright 2016 Megh Parikh
 *
 * This file is part of LibGamepad.
 *
 * LibGamepad is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LibGamepad is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gudev/gudev.h>
#include <libevdev/libevdev.h>
#include <linux/input.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;

#define LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD (lib_gamepad_linux_raw_gamepad_get_type ())
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepad))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepadClass))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD))
#define LIB_GAMEPAD_IS_LINUX_RAW_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD))
#define LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepadClass))

typedef struct _LibGamepadLinuxRawGamepad LibGamepadLinuxRawGamepad;
typedef struct _LibGamepadLinuxRawGamepadClass LibGamepadLinuxRawGamepadClass;
typedef struct _LibGamepadLinuxRawGamepadPrivate LibGamepadLinuxRawGamepadPrivate;
enum  {
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_0_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_IDENTIFIER_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NAME_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GUID_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_AXES_NUMBER_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_BUTTONS_NUMBER_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_DPADS_NUMBER_PROPERTY,
	LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NUM_PROPERTIES
};
static GParamSpec* lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _libevdev_free0(var) ((var == NULL) ? NULL : (var = (libevdev_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _LibGamepadLinuxRawGamepad {
	GObject parent_instance;
	LibGamepadLinuxRawGamepadPrivate * priv;
};

struct _LibGamepadLinuxRawGamepadClass {
	GObjectClass parent_class;
};

struct _LibGamepadLinuxRawGamepadPrivate {
	gint fd;
	GUdevClient* gudev_client;
	guint* event_source_id;
	struct libevdev* dev;
	guint8 key_map[KEY_MAX];
	guint8 abs_map[ABS_MAX];
	struct input_absinfo abs_info[ABS_MAX];
	gchar* _identifier;
	gchar* _name;
	gchar* _guid;
	guint8 _axes_number;
	guint8 _buttons_number;
	gint _dpads_number;
};

static gint LibGamepadLinuxRawGamepad_private_offset;
static gpointer lib_gamepad_linux_raw_gamepad_parent_class = NULL;
static LibGamepadRawGamepadIface * lib_gamepad_linux_raw_gamepad_lib_gamepad_raw_gamepad_parent_iface = NULL;

VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN GType lib_gamepad_linux_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadLinuxRawGamepad, g_object_unref)
static void lib_gamepad_linux_raw_gamepad_remove_event_source (LibGamepadLinuxRawGamepad* self);
VALA_EXTERN LibGamepadLinuxRawGamepad* lib_gamepad_linux_raw_gamepad_new (const gchar* file_name,
                                                              GError** error);
VALA_EXTERN LibGamepadLinuxRawGamepad* lib_gamepad_linux_raw_gamepad_construct (GType object_type,
                                                                    const gchar* file_name,
                                                                    GError** error);
static void lib_gamepad_linux_raw_gamepad_handle_gudev_event (LibGamepadLinuxRawGamepad* self,
                                                       const gchar* action,
                                                       GUdevDevice* gudev_dev);
static void _lib_gamepad_linux_raw_gamepad_handle_gudev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                                             const gchar* action,
                                                                             GUdevDevice* device,
                                                                             gpointer self);
VALA_EXTERN gchar* lib_gamepad_linux_guid_helpers_from_dev (struct libevdev* dev);
static gboolean lib_gamepad_linux_raw_gamepad_poll_events (LibGamepadLinuxRawGamepad* self);
static gboolean _lib_gamepad_linux_raw_gamepad_poll_events_gio_func (GIOChannel* source,
                                                              GIOCondition condition,
                                                              gpointer self);
static guint* _uint_dup (guint* self);
static struct input_absinfo* _abs_info_dup (struct input_absinfo* self);
static void lib_gamepad_linux_raw_gamepad_handle_evdev_event (LibGamepadLinuxRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_identifier (LibGamepadRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_name (LibGamepadRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_guid (LibGamepadRawGamepad* self);
VALA_EXTERN guint8 lib_gamepad_raw_gamepad_get_axes_number (LibGamepadRawGamepad* self);
VALA_EXTERN guint8 lib_gamepad_raw_gamepad_get_buttons_number (LibGamepadRawGamepad* self);
VALA_EXTERN guint8 lib_gamepad_raw_gamepad_get_dpads_number (LibGamepadRawGamepad* self);
static void lib_gamepad_linux_raw_gamepad_finalize (GObject * obj);
static GType lib_gamepad_linux_raw_gamepad_get_type_once (void);
static void _vala_lib_gamepad_linux_raw_gamepad_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
lib_gamepad_linux_raw_gamepad_get_instance_private (LibGamepadLinuxRawGamepad* self)
{
	return G_STRUCT_MEMBER_P (self, LibGamepadLinuxRawGamepad_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 189 "raw-gamepad.c"
}

static void
_lib_gamepad_linux_raw_gamepad_handle_gudev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                                        const gchar* action,
                                                                        GUdevDevice* device,
                                                                        gpointer self)
{
#line 80 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	lib_gamepad_linux_raw_gamepad_handle_gudev_event ((LibGamepadLinuxRawGamepad*) self, action, device);
#line 200 "raw-gamepad.c"
}

static gboolean
_lib_gamepad_linux_raw_gamepad_poll_events_gio_func (GIOChannel* source,
                                                     GIOCondition condition,
                                                     gpointer self)
{
	gboolean result;
	result = lib_gamepad_linux_raw_gamepad_poll_events ((LibGamepadLinuxRawGamepad*) self);
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 212 "raw-gamepad.c"
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	dup = g_new0 (guint, 1);
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	memcpy (dup, self, sizeof (guint));
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return dup;
#line 225 "raw-gamepad.c"
}

static gpointer
__uint_dup0 (gpointer self)
{
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return self ? _uint_dup (self) : NULL;
#line 233 "raw-gamepad.c"
}

static struct input_absinfo*
_abs_info_dup (struct input_absinfo* self)
{
	struct input_absinfo* dup;
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	dup = g_new0 (struct input_absinfo, 1);
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	memcpy (dup, self, sizeof (struct input_absinfo));
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return dup;
#line 246 "raw-gamepad.c"
}

static gpointer
__abs_info_dup0 (gpointer self)
{
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return self ? _abs_info_dup (self) : NULL;
#line 254 "raw-gamepad.c"
}

LibGamepadLinuxRawGamepad*
lib_gamepad_linux_raw_gamepad_construct (GType object_type,
                                         const gchar* file_name,
                                         GError** error)
{
	LibGamepadLinuxRawGamepad * self = NULL;
	gchar* _tmp0_;
	struct libevdev* _tmp8_;
	struct libevdev* _tmp9_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GUdevClient* _tmp20_;
	GUdevClient* _tmp21_;
	struct libevdev* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	struct libevdev* _tmp26_;
	gchar* _tmp27_;
	GIOChannel* channel = NULL;
	GIOChannel* _tmp28_;
	GIOChannel* _tmp29_;
	guint _tmp30_;
	guint* _tmp31_;
	GError* _inner_error0_ = NULL;
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_val_if_fail (file_name != NULL, NULL);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) g_object_new (object_type, NULL);
#line 68 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = g_strdup (file_name);
#line 68 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_identifier);
#line 68 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_identifier = _tmp0_;
#line 69 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->fd = open (file_name, O_RDONLY | O_NONBLOCK, (mode_t) 0);
#line 71 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (self->priv->fd < 0) {
#line 298 "raw-gamepad.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp1_ = string_to_string (file_name);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp2_ = strerror (errno);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp3_ = string_to_string (_tmp2_);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp4_ = g_strconcat ("Unable to open file ", _tmp1_, ": ", _tmp3_, NULL);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp5_ = _tmp4_;
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp6_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp5_);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp7_ = _tmp6_;
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_g_free0 (_tmp5_);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_inner_error0_ = _tmp7_;
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		if (_inner_error0_->domain == G_FILE_ERROR) {
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_propagate_error (error, _inner_error0_);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_g_object_unref0 (self);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			return NULL;
#line 332 "raw-gamepad.c"
		} else {
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_clear_error (&_inner_error0_);
#line 72 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			return NULL;
#line 340 "raw-gamepad.c"
		}
	}
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp8_ = libevdev_new ();
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_libevdev_free0 (self->priv->dev);
#line 74 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->dev = _tmp8_;
#line 75 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp9_ = self->priv->dev;
#line 75 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (libevdev_set_fd (_tmp9_, self->priv->fd) < 0) {
#line 353 "raw-gamepad.c"
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GError* _tmp15_;
		GError* _tmp16_;
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp10_ = string_to_string (file_name);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp11_ = strerror (errno);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp12_ = string_to_string (_tmp11_);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp13_ = g_strconcat ("Evdev is unable to open ", _tmp10_, ": ", _tmp12_, NULL);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp14_ = _tmp13_;
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp15_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp14_);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp16_ = _tmp15_;
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_g_free0 (_tmp14_);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_inner_error0_ = _tmp16_;
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		if (_inner_error0_->domain == G_FILE_ERROR) {
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_propagate_error (error, _inner_error0_);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_g_object_unref0 (self);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			return NULL;
#line 387 "raw-gamepad.c"
		} else {
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			g_clear_error (&_inner_error0_);
#line 76 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			return NULL;
#line 395 "raw-gamepad.c"
		}
	}
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp17_ = g_strdup ("input");
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp18_ = g_new0 (gchar*, 1 + 1);
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp18_[0] = _tmp17_;
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp19_ = _tmp18_;
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp19__length1 = 1;
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp20_ = g_udev_client_new (_tmp19_);
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_object_unref0 (self->priv->gudev_client);
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->gudev_client = _tmp20_;
#line 79 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
#line 80 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp21_ = self->priv->gudev_client;
#line 80 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_signal_connect_object (_tmp21_, "uevent", (GCallback) _lib_gamepad_linux_raw_gamepad_handle_gudev_event_g_udev_client_uevent, self, 0);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp22_ = self->priv->dev;
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp23_ = libevdev_get_name (_tmp22_);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp24_ = _tmp23_;
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_name);
#line 82 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_name = _tmp25_;
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp26_ = self->priv->dev;
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp27_ = lib_gamepad_linux_guid_helpers_from_dev (_tmp26_);
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_guid);
#line 83 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_guid = _tmp27_;
#line 86 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp28_ = g_io_channel_unix_new (self->priv->fd);
#line 86 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	channel = _tmp28_;
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp29_ = channel;
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp30_ = g_io_add_watch (_tmp29_, G_IO_IN, _lib_gamepad_linux_raw_gamepad_poll_events_gio_func, self);
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp31_ = __uint_dup0 (&_tmp30_);
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->event_source_id);
#line 87 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->event_source_id = _tmp31_;
#line 454 "raw-gamepad.c"
	{
		gint i = 0;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		i = BTN_JOYSTICK;
#line 459 "raw-gamepad.c"
		{
			gboolean _tmp32_ = FALSE;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_tmp32_ = TRUE;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			while (TRUE) {
#line 466 "raw-gamepad.c"
				struct libevdev* _tmp34_;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!_tmp32_) {
#line 470 "raw-gamepad.c"
					gint _tmp33_;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp33_ = i;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					i = _tmp33_ + 1;
#line 476 "raw-gamepad.c"
				}
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp32_ = FALSE;
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!(i < KEY_MAX)) {
#line 90 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					break;
#line 484 "raw-gamepad.c"
				}
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp34_ = self->priv->dev;
#line 91 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (libevdev_has_event_code (_tmp34_, (guint) EV_KEY, (guint) i)) {
#line 490 "raw-gamepad.c"
					guint8 _tmp35_;
#line 92 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->key_map[i - BTN_MISC] = self->priv->_buttons_number;
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp35_ = self->priv->_buttons_number;
#line 93 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->_buttons_number = _tmp35_ + 1;
#line 498 "raw-gamepad.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		i = BTN_MISC;
#line 507 "raw-gamepad.c"
		{
			gboolean _tmp36_ = FALSE;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_tmp36_ = TRUE;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			while (TRUE) {
#line 514 "raw-gamepad.c"
				struct libevdev* _tmp38_;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!_tmp36_) {
#line 518 "raw-gamepad.c"
					gint _tmp37_;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp37_ = i;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					i = _tmp37_ + 1;
#line 524 "raw-gamepad.c"
				}
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp36_ = FALSE;
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!(i < BTN_JOYSTICK)) {
#line 96 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					break;
#line 532 "raw-gamepad.c"
				}
#line 97 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp38_ = self->priv->dev;
#line 97 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (libevdev_has_event_code (_tmp38_, (guint) EV_KEY, (guint) i)) {
#line 538 "raw-gamepad.c"
					guint8 _tmp39_;
#line 98 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->key_map[i - BTN_MISC] = self->priv->_buttons_number;
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp39_ = self->priv->_buttons_number;
#line 99 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->_buttons_number = _tmp39_ + 1;
#line 546 "raw-gamepad.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		i = 0;
#line 555 "raw-gamepad.c"
		{
			gboolean _tmp40_ = FALSE;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_tmp40_ = TRUE;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			while (TRUE) {
#line 562 "raw-gamepad.c"
				struct libevdev* _tmp42_;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!_tmp40_) {
#line 566 "raw-gamepad.c"
					gint _tmp41_;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp41_ = i;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					i = _tmp41_ + 1;
#line 572 "raw-gamepad.c"
				}
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp40_ = FALSE;
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!(i < ABS_MAX)) {
#line 105 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					break;
#line 580 "raw-gamepad.c"
				}
#line 107 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (i == ABS_HAT0X) {
#line 108 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					i = ABS_HAT3Y;
#line 109 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					continue;
#line 588 "raw-gamepad.c"
				}
#line 111 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp42_ = self->priv->dev;
#line 111 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (libevdev_has_event_code (_tmp42_, (guint) EV_ABS, (guint) i)) {
#line 594 "raw-gamepad.c"
					struct input_absinfo* absinfo = NULL;
					struct libevdev* _tmp43_;
					struct input_absinfo* _tmp44_;
					struct input_absinfo* _tmp45_;
					guint8 _tmp46_;
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp43_ = self->priv->dev;
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp44_ = __abs_info_dup0 (libevdev_get_abs_info (_tmp43_, (guint) i));
#line 112 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					absinfo = _tmp44_;
#line 113 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->abs_map[i] = self->priv->_axes_number;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp45_ = absinfo;
#line 114 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->abs_info[self->priv->_axes_number] = *_tmp45_;
#line 115 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp46_ = self->priv->_axes_number;
#line 115 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->_axes_number = _tmp46_ + 1;
#line 111 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_g_free0 (absinfo);
#line 618 "raw-gamepad.c"
				}
			}
		}
	}
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_io_channel_unref0 (channel);
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return self;
#line 627 "raw-gamepad.c"
}

LibGamepadLinuxRawGamepad*
lib_gamepad_linux_raw_gamepad_new (const gchar* file_name,
                                   GError** error)
{
#line 67 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return lib_gamepad_linux_raw_gamepad_construct (LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, file_name, error);
#line 636 "raw-gamepad.c"
}

static gboolean
lib_gamepad_linux_raw_gamepad_poll_events (LibGamepadLinuxRawGamepad* self)
{
	gboolean result;
#line 125 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	while (TRUE) {
#line 647 "raw-gamepad.c"
		struct libevdev* _tmp0_;
#line 126 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp0_ = self->priv->dev;
#line 126 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		if (!(libevdev_has_event_pending (_tmp0_) > 0)) {
#line 126 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			break;
#line 655 "raw-gamepad.c"
		}
#line 127 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		lib_gamepad_linux_raw_gamepad_handle_evdev_event (self);
#line 659 "raw-gamepad.c"
	}
#line 129 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = TRUE;
#line 129 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 665 "raw-gamepad.c"
}

static void
lib_gamepad_linux_raw_gamepad_handle_evdev_event (LibGamepadLinuxRawGamepad* self)
{
	gint rc = 0;
	struct input_event ev = {0};
	struct libevdev* _tmp0_;
	struct input_event _tmp1_ = {0};
	gint _tmp2_;
#line 132 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_if_fail (self != NULL);
#line 135 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = self->priv->dev;
#line 135 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp2_ = libevdev_next_event (_tmp0_, (guint) LIBEVDEV_READ_FLAG_NORMAL, &_tmp1_);
#line 135 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	ev = _tmp1_;
#line 135 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	rc = _tmp2_;
#line 136 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (rc == 0) {
#line 688 "raw-gamepad.c"
		gint code = 0;
		struct input_event _tmp3_;
		struct input_event _tmp4_;
#line 137 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp3_ = ev;
#line 137 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		code = (gint) _tmp3_.code;
#line 138 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp4_ = ev;
#line 138 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		switch (_tmp4_.type) {
#line 138 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			case EV_KEY:
#line 702 "raw-gamepad.c"
			{
#line 140 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (code >= BTN_MISC) {
#line 706 "raw-gamepad.c"
					guint8 _tmp5_;
					struct input_event _tmp6_;
#line 141 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp5_ = self->priv->key_map[code - BTN_MISC];
#line 141 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp6_ = ev;
#line 141 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					g_signal_emit_by_name ((LibGamepadRawGamepad*) self, "button-event", (gint) _tmp5_, (gboolean) _tmp6_.value);
#line 715 "raw-gamepad.c"
				}
#line 143 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				break;
#line 719 "raw-gamepad.c"
			}
#line 138 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			case EV_ABS:
#line 723 "raw-gamepad.c"
			{
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				switch (code) {
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT0X:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT0Y:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT1X:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT1Y:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT2X:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT2Y:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT3X:
#line 145 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					case ABS_HAT3Y:
#line 743 "raw-gamepad.c"
					{
						struct input_event _tmp7_;
#line 154 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						code -= ABS_HAT0X;
#line 155 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						_tmp7_ = ev;
#line 155 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						g_signal_emit_by_name ((LibGamepadRawGamepad*) self, "dpad-event", code / 2, code % 2, (gint) _tmp7_.value);
#line 156 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						break;
#line 754 "raw-gamepad.c"
					}
					default:
					{
						guint8 axis = 0U;
						guint8 _tmp8_;
						struct input_event _tmp9_;
						struct input_absinfo _tmp10_;
#line 158 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						_tmp8_ = self->priv->abs_map[code];
#line 158 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						axis = _tmp8_;
#line 159 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						_tmp9_ = ev;
#line 159 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						_tmp10_ = self->priv->abs_info[axis];
#line 159 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						g_signal_emit_by_name ((LibGamepadRawGamepad*) self, "axis-event", (gint) axis, ((gdouble) _tmp9_.value) / _tmp10_.maximum);
#line 160 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						break;
#line 774 "raw-gamepad.c"
					}
				}
#line 162 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				break;
#line 779 "raw-gamepad.c"
			}
			default:
#line 138 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			break;
#line 784 "raw-gamepad.c"
		}
	}
}

static void
lib_gamepad_linux_raw_gamepad_handle_gudev_event (LibGamepadLinuxRawGamepad* self,
                                                  const gchar* action,
                                                  GUdevDevice* gudev_dev)
{
	gboolean _tmp0_ = FALSE;
#line 167 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_if_fail (self != NULL);
#line 167 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_if_fail (action != NULL);
#line 167 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_if_fail (gudev_dev != NULL);
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (g_strcmp0 (action, "remove") == 0) {
#line 803 "raw-gamepad.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp1_ = g_udev_device_get_device_file (gudev_dev);
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp2_ = lib_gamepad_raw_gamepad_get_identifier ((LibGamepadRawGamepad*) self);
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp3_ = _tmp2_;
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp0_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
#line 815 "raw-gamepad.c"
	} else {
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		_tmp0_ = FALSE;
#line 819 "raw-gamepad.c"
	}
#line 168 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (_tmp0_) {
#line 169 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		lib_gamepad_linux_raw_gamepad_remove_event_source (self);
#line 170 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_signal_emit_by_name ((LibGamepadRawGamepad*) self, "unplugged");
#line 827 "raw-gamepad.c"
	}
}

static void
lib_gamepad_linux_raw_gamepad_remove_event_source (LibGamepadLinuxRawGamepad* self)
{
	guint* _tmp0_;
	guint* _tmp1_;
#line 174 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_return_if_fail (self != NULL);
#line 175 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = self->priv->event_source_id;
#line 175 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (_tmp0_ == NULL) {
#line 176 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		return;
#line 844 "raw-gamepad.c"
	}
#line 178 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp1_ = self->priv->event_source_id;
#line 178 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_source_remove (*_tmp1_);
#line 179 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->event_source_id);
#line 179 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->event_source_id = NULL;
#line 854 "raw-gamepad.c"
}

static const gchar*
lib_gamepad_linux_raw_gamepad_real_get_identifier (LibGamepadRawGamepad* base)
{
	const gchar* result;
	LibGamepadLinuxRawGamepad* self;
	const gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = self->priv->_identifier;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 871 "raw-gamepad.c"
}

static const gchar*
lib_gamepad_linux_raw_gamepad_real_get_name (LibGamepadRawGamepad* base)
{
	const gchar* result;
	LibGamepadLinuxRawGamepad* self;
	const gchar* _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = self->priv->_name;
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 888 "raw-gamepad.c"
}

static const gchar*
lib_gamepad_linux_raw_gamepad_real_get_guid (LibGamepadRawGamepad* base)
{
	const gchar* result;
	LibGamepadLinuxRawGamepad* self;
	const gchar* _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 37 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_tmp0_ = self->priv->_guid;
#line 37 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 905 "raw-gamepad.c"
}

static guint8
lib_gamepad_linux_raw_gamepad_real_get_axes_number (LibGamepadRawGamepad* base)
{
	guint8 result;
	LibGamepadLinuxRawGamepad* self;
#line 40 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 40 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = self->priv->_axes_number;
#line 40 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 919 "raw-gamepad.c"
}

static guint8
lib_gamepad_linux_raw_gamepad_real_get_buttons_number (LibGamepadRawGamepad* base)
{
	guint8 result;
	LibGamepadLinuxRawGamepad* self;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = self->priv->_buttons_number;
#line 43 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 933 "raw-gamepad.c"
}

static guint8
lib_gamepad_linux_raw_gamepad_real_get_dpads_number (LibGamepadRawGamepad* base)
{
	guint8 result;
	LibGamepadLinuxRawGamepad* self;
#line 47 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = (LibGamepadLinuxRawGamepad*) base;
#line 48 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	if (self->priv->_dpads_number != -1) {
#line 49 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		result = (guint8) self->priv->_dpads_number;
#line 49 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		return result;
#line 949 "raw-gamepad.c"
	}
#line 51 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_dpads_number = 0;
#line 953 "raw-gamepad.c"
	{
		gint i = 0;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		i = ABS_HAT0X;
#line 958 "raw-gamepad.c"
		{
			gboolean _tmp0_ = FALSE;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			_tmp0_ = TRUE;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
			while (TRUE) {
#line 965 "raw-gamepad.c"
				gboolean _tmp1_ = FALSE;
				struct libevdev* _tmp2_;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!_tmp0_) {
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					i += 2;
#line 972 "raw-gamepad.c"
				}
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp0_ = FALSE;
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (!(i <= ABS_HAT3Y)) {
#line 52 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					break;
#line 980 "raw-gamepad.c"
				}
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				_tmp2_ = self->priv->dev;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (libevdev_has_event_code (_tmp2_, (guint) EV_ABS, (guint) i)) {
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp1_ = TRUE;
#line 988 "raw-gamepad.c"
				} else {
					struct libevdev* _tmp3_;
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp3_ = self->priv->dev;
#line 54 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp1_ = libevdev_has_event_code (_tmp3_, (guint) EV_ABS, (guint) (i + 1));
#line 995 "raw-gamepad.c"
				}
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
				if (_tmp1_) {
#line 999 "raw-gamepad.c"
					struct input_absinfo* absinfo = NULL;
					struct libevdev* _tmp4_;
					struct input_absinfo* _tmp5_;
					struct input_absinfo* _tmp6_;
					gint _tmp7_;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp4_ = self->priv->dev;
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp5_ = __abs_info_dup0 (libevdev_get_abs_info (_tmp4_, (guint) i));
#line 55 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					absinfo = _tmp5_;
#line 56 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp6_ = absinfo;
#line 56 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					if (_tmp6_ == NULL) {
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						_g_free0 (absinfo);
#line 57 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
						continue;
#line 1019 "raw-gamepad.c"
					}
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_tmp7_ = self->priv->_dpads_number;
#line 59 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					self->priv->_dpads_number = _tmp7_ + 1;
#line 53 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
					_g_free0 (absinfo);
#line 1027 "raw-gamepad.c"
				}
			}
		}
	}
#line 63 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	result = (guint8) self->priv->_dpads_number;
#line 63 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	return result;
#line 1036 "raw-gamepad.c"
}

static void
lib_gamepad_linux_raw_gamepad_class_init (LibGamepadLinuxRawGamepadClass * klass,
                                          gpointer klass_data)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	lib_gamepad_linux_raw_gamepad_parent_class = g_type_class_peek_parent (klass);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_type_class_adjust_private_offset (klass, &LibGamepadLinuxRawGamepad_private_offset);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_lib_gamepad_linux_raw_gamepad_get_property;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	G_OBJECT_CLASS (klass)->finalize = lib_gamepad_linux_raw_gamepad_finalize;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_IDENTIFIER_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_IDENTIFIER_PROPERTY] = g_param_spec_string ("identifier", "identifier", "identifier", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NAME_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GUID_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GUID_PROPERTY] = g_param_spec_string ("guid", "guid", "guid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_AXES_NUMBER_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_AXES_NUMBER_PROPERTY] = g_param_spec_uchar ("axes-number", "axes-number", "axes-number", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_BUTTONS_NUMBER_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_BUTTONS_NUMBER_PROPERTY] = g_param_spec_uchar ("buttons-number", "buttons-number", "buttons-number", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIB_GAMEPAD_LINUX_RAW_GAMEPAD_DPADS_NUMBER_PROPERTY, lib_gamepad_linux_raw_gamepad_properties[LIB_GAMEPAD_LINUX_RAW_GAMEPAD_DPADS_NUMBER_PROPERTY] = g_param_spec_uchar ("dpads-number", "dpads-number", "dpads-number", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 1063 "raw-gamepad.c"
}

static void
lib_gamepad_linux_raw_gamepad_lib_gamepad_raw_gamepad_interface_init (LibGamepadRawGamepadIface * iface,
                                                                      gpointer iface_data)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	lib_gamepad_linux_raw_gamepad_lib_gamepad_raw_gamepad_parent_iface = g_type_interface_peek_parent (iface);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_identifier = lib_gamepad_linux_raw_gamepad_real_get_identifier;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_name = lib_gamepad_linux_raw_gamepad_real_get_name;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_guid = lib_gamepad_linux_raw_gamepad_real_get_guid;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_axes_number = lib_gamepad_linux_raw_gamepad_real_get_axes_number;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_buttons_number = lib_gamepad_linux_raw_gamepad_real_get_buttons_number;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	iface->get_dpads_number = lib_gamepad_linux_raw_gamepad_real_get_dpads_number;
#line 1084 "raw-gamepad.c"
}

static void
lib_gamepad_linux_raw_gamepad_instance_init (LibGamepadLinuxRawGamepad * self,
                                             gpointer klass)
{
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv = lib_gamepad_linux_raw_gamepad_get_instance_private (self);
#line 39 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_axes_number = (guint8) 0;
#line 42 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_buttons_number = (guint8) 0;
#line 45 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self->priv->_dpads_number = -1;
#line 1099 "raw-gamepad.c"
}

static void
lib_gamepad_linux_raw_gamepad_finalize (GObject * obj)
{
	LibGamepadLinuxRawGamepad * self;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepad);
#line 121 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	close (self->priv->fd);
#line 122 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	lib_gamepad_linux_raw_gamepad_remove_event_source (self);
#line 22 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_object_unref0 (self->priv->gudev_client);
#line 23 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->event_source_id);
#line 24 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_libevdev_free0 (self->priv->dev);
#line 30 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_identifier);
#line 33 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_name);
#line 36 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	_g_free0 (self->priv->_guid);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	G_OBJECT_CLASS (lib_gamepad_linux_raw_gamepad_parent_class)->finalize (obj);
#line 1126 "raw-gamepad.c"
}

static GType
lib_gamepad_linux_raw_gamepad_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibGamepadLinuxRawGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gamepad_linux_raw_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGamepadLinuxRawGamepad), 0, (GInstanceInitFunc) lib_gamepad_linux_raw_gamepad_instance_init, NULL };
	static const GInterfaceInfo lib_gamepad_raw_gamepad_info = { (GInterfaceInitFunc) lib_gamepad_linux_raw_gamepad_lib_gamepad_raw_gamepad_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType lib_gamepad_linux_raw_gamepad_type_id;
	lib_gamepad_linux_raw_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "LibGamepadLinuxRawGamepad", &g_define_type_info, 0);
	g_type_add_interface_static (lib_gamepad_linux_raw_gamepad_type_id, LIB_GAMEPAD_TYPE_RAW_GAMEPAD, &lib_gamepad_raw_gamepad_info);
	LibGamepadLinuxRawGamepad_private_offset = g_type_add_instance_private (lib_gamepad_linux_raw_gamepad_type_id, sizeof (LibGamepadLinuxRawGamepadPrivate));
	return lib_gamepad_linux_raw_gamepad_type_id;
}

GType
lib_gamepad_linux_raw_gamepad_get_type (void)
{
	static volatile gsize lib_gamepad_linux_raw_gamepad_type_id__once = 0;
	if (g_once_init_enter (&lib_gamepad_linux_raw_gamepad_type_id__once)) {
		GType lib_gamepad_linux_raw_gamepad_type_id;
		lib_gamepad_linux_raw_gamepad_type_id = lib_gamepad_linux_raw_gamepad_get_type_once ();
		g_once_init_leave (&lib_gamepad_linux_raw_gamepad_type_id__once, lib_gamepad_linux_raw_gamepad_type_id);
	}
	return lib_gamepad_linux_raw_gamepad_type_id__once;
}

static void
_vala_lib_gamepad_linux_raw_gamepad_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	LibGamepadLinuxRawGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIB_GAMEPAD_TYPE_LINUX_RAW_GAMEPAD, LibGamepadLinuxRawGamepad);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
	switch (property_id) {
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_IDENTIFIER_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_string (value, lib_gamepad_raw_gamepad_get_identifier ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_NAME_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_string (value, lib_gamepad_raw_gamepad_get_name ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_GUID_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_string (value, lib_gamepad_raw_gamepad_get_guid ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_AXES_NUMBER_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_uchar (value, lib_gamepad_raw_gamepad_get_axes_number ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_BUTTONS_NUMBER_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_uchar (value, lib_gamepad_raw_gamepad_get_buttons_number ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		case LIB_GAMEPAD_LINUX_RAW_GAMEPAD_DPADS_NUMBER_PROPERTY:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		g_value_set_uchar (value, lib_gamepad_raw_gamepad_get_dpads_number ((LibGamepadRawGamepad*) self));
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 1199 "raw-gamepad.c"
		default:
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../Spice-up-1.9.1/src/Services/libgamepad/drivers/linux/raw-gamepad.vala"
		break;
#line 1205 "raw-gamepad.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

