/* VersionTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VersionTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_VERSION_TABLE (version_table_get_type ())
#define VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VERSION_TABLE, VersionTable))
#define VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VERSION_TABLE, VersionTableClass))
#define IS_VERSION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VERSION_TABLE))
#define IS_VERSION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VERSION_TABLE))
#define VERSION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VERSION_TABLE, VersionTableClass))

typedef struct _VersionTable VersionTable;
typedef struct _VersionTableClass VersionTableClass;
typedef struct _VersionTablePrivate VersionTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _VersionTable {
	DatabaseTable parent_instance;
	VersionTablePrivate * priv;
};

struct _VersionTableClass {
	DatabaseTableClass parent_class;
};

static gpointer version_table_parent_class = NULL;
static VersionTable* version_table_instance;
static VersionTable* version_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType version_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VersionTable, database_table_unref)
static VersionTable* version_table_new (void);
static VersionTable* version_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN VersionTable* version_table_get_instance (void);
VALA_EXTERN gint version_table_get_version (VersionTable* self,
                                gchar** app_version);
VALA_EXTERN void version_table_set_version (VersionTable* self,
                                gint version,
                                const gchar* app_version,
                                const gchar* user_data);
VALA_EXTERN void version_table_update_version (VersionTable* self,
                                   gint version,
                                   const gchar* app_version);
static void version_table_finalize (DatabaseTable * obj);
static GType version_table_get_type_once (void);

static VersionTable*
version_table_construct (GType object_type)
{
	VersionTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (VersionTable*) database_table_construct (object_type);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create version table", res);
	}
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "VersionTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static VersionTable*
version_table_new (void)
{
	return version_table_construct (TYPE_VERSION_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

VersionTable*
version_table_get_instance (void)
{
	VersionTable* _tmp0_;
	VersionTable* _tmp2_;
	VersionTable* _tmp3_;
	VersionTable* result;
	_tmp0_ = version_table_instance;
	if (_tmp0_ == NULL) {
		VersionTable* _tmp1_;
		_tmp1_ = version_table_new ();
		_database_table_unref0 (version_table_instance);
		version_table_instance = _tmp1_;
	}
	_tmp2_ = version_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gint
version_table_get_version (VersionTable* self,
                           gchar** app_version)
{
	gchar* _vala_app_version = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_;
	gint result;
	g_return_val_if_fail (IS_VERSION_TABLE (self), 0);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT schema_version, app_version FROM VersionTable ORDER BY schema_v" \
"ersion DESC LIMIT 1", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_ROW) {
		if (res != SQLITE_DONE) {
			database_table_fatal ("get_version", res);
		}
		_g_free0 (_vala_app_version);
		_vala_app_version = NULL;
		result = -1;
		_sqlite3_finalize0 (stmt);
		if (app_version) {
			*app_version = _vala_app_version;
		} else {
			_g_free0 (_vala_app_version);
		}
		return result;
	}
	_tmp4_ = stmt;
	_tmp5_ = (const gchar*) sqlite3_column_text (_tmp4_, 1);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_app_version);
	_vala_app_version = _tmp6_;
	_tmp7_ = stmt;
	result = sqlite3_column_int (_tmp7_, 0);
	_sqlite3_finalize0 (stmt);
	if (app_version) {
		*app_version = _vala_app_version;
	} else {
		_g_free0 (_vala_app_version);
	}
	return result;
}

void
version_table_set_version (VersionTable* self,
                           gint version,
                           const gchar* app_version,
                           const gchar* user_data)
{
	sqlite3_stmt* stmt = NULL;
	gchar* bitbucket = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint res = 0;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	gchar* _tmp10_;
	GDestroyNotify _tmp11_;
	sqlite3_stmt* _tmp12_;
	gchar* _tmp13_;
	GDestroyNotify _tmp14_;
	sqlite3_stmt* _tmp15_;
	g_return_if_fail (IS_VERSION_TABLE (self));
	g_return_if_fail (app_version != NULL);
	_tmp1_ = version_table_get_version (self, &_tmp0_);
	_g_free0 (bitbucket);
	bitbucket = _tmp0_;
	if (_tmp1_ != -1) {
		gint res = 0;
		sqlite3* _tmp2_;
		sqlite3_stmt* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp2_ = database_table_db;
		_tmp4_ = sqlite3_prepare_v2 (_tmp2_, "UPDATE VersionTable SET schema_version=?, app_version=?, user_data=?", -1, &_tmp3_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp3_;
		res = _tmp4_;
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	} else {
		gint res = 0;
		sqlite3* _tmp5_;
		sqlite3_stmt* _tmp6_ = NULL;
		gint _tmp7_;
		_tmp5_ = database_table_db;
		_tmp7_ = sqlite3_prepare_v2 (_tmp5_, "INSERT INTO VersionTable (schema_version, app_version, user_data) VALU" \
"ES (?,?, ?)", -1, &_tmp6_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp6_;
		res = _tmp7_;
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	}
	_tmp8_ = stmt;
	res = sqlite3_bind_int (_tmp8_, 1, version);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	_tmp10_ = g_strdup (app_version);
	_tmp11_ = g_free;
	res = sqlite3_bind_text (_tmp9_, 2, _tmp10_, -1, _tmp11_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp12_ = stmt;
	_tmp13_ = g_strdup (user_data);
	_tmp14_ = g_free;
	res = sqlite3_bind_text (_tmp12_, 3, _tmp13_, -1, _tmp14_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp15_ = stmt;
	res = sqlite3_step (_tmp15_);
	if (res != SQLITE_DONE) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = g_strdup_printf ("set_version %d %s %s", version, app_version, user_data);
		_tmp17_ = _tmp16_;
		database_table_fatal (_tmp17_, res);
		_g_free0 (_tmp17_);
	}
	_g_free0 (bitbucket);
	_sqlite3_finalize0 (stmt);
}

void
version_table_update_version (VersionTable* self,
                              gint version,
                              const gchar* app_version)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	g_return_if_fail (IS_VERSION_TABLE (self));
	g_return_if_fail (app_version != NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE VersionTable SET schema_version=?, app_version=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_bind_int (_tmp3_, 1, version);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	_tmp5_ = g_strdup (app_version);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp4_, 2, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = g_strdup_printf ("update_version %d", version);
		_tmp9_ = _tmp8_;
		database_table_fatal (_tmp9_, res);
		_g_free0 (_tmp9_);
	}
	_sqlite3_finalize0 (stmt);
}

static void
version_table_class_init (VersionTableClass * klass,
                          gpointer klass_data)
{
	version_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = version_table_finalize;
}

static void
version_table_instance_init (VersionTable * self,
                             gpointer klass)
{
}

static void
version_table_finalize (DatabaseTable * obj)
{
	VersionTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VERSION_TABLE, VersionTable);
	DATABASE_TABLE_CLASS (version_table_parent_class)->finalize (obj);
}

static GType
version_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VersionTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) version_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VersionTable), 0, (GInstanceInitFunc) version_table_instance_init, NULL };
	GType version_table_type_id;
	version_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VersionTable", &g_define_type_info, 0);
	return version_table_type_id;
}

GType
version_table_get_type (void)
{
	static volatile gsize version_table_type_id__once = 0;
	if (g_once_init_enter (&version_table_type_id__once)) {
		GType version_table_type_id;
		version_table_type_id = version_table_get_type_once ();
		g_once_init_leave (&version_table_type_id__once, version_table_type_id);
	}
	return version_table_type_id__once;
}

