/* ThumbnailCache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ThumbnailCache.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
#define THUMBNAIL_CACHE_DEFAULT_QUALITY JPEG_QUALITY_HIGH
#define THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE (512 * 1024)
#define THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES ((gulong) ((40 * 1024) * 1024))
#define THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES ((gulong) ((30 * 1024) * 1024))
#define THUMBNAIL_CACHE_MAX_LARGE_CACHED_BYTES ((gulong) ((15 * 1024) * 1024))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
typedef struct _ThumbnailsPrivate ThumbnailsPrivate;
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 512,
	THUMBNAIL_CACHE_SIZE_LARGE = 512,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecThumbnails ParamSpecThumbnails;

#define TYPE_THUMBNAIL_CACHE (thumbnail_cache_get_type ())
#define THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCache))
#define THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))
#define IS_THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_CACHE))
#define IS_THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_CACHE))
#define THUMBNAIL_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))

typedef struct _ThumbnailCache ThumbnailCache;
typedef struct _ThumbnailCacheClass ThumbnailCacheClass;
typedef struct _ThumbnailCachePrivate ThumbnailCachePrivate;
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define THUMBNAIL_CACHE_TYPE_IMAGE_DATA (thumbnail_cache_image_data_get_type ())
#define THUMBNAIL_CACHE_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData))
#define THUMBNAIL_CACHE_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))

typedef struct _ThumbnailCacheImageData ThumbnailCacheImageData;
typedef struct _ThumbnailCacheImageDataClass ThumbnailCacheImageDataClass;
enum  {
	THUMBNAIL_CACHE_0_PROPERTY,
	THUMBNAIL_CACHE_NUM_PROPERTIES
};
static GParamSpec* thumbnail_cache_properties[THUMBNAIL_CACHE_NUM_PROPERTIES];

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*OneShotCallback) (gpointer user_data);
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer user_data);
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB (thumbnail_cache_async_fetch_job_get_type ())
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))

typedef struct _ThumbnailCacheAsyncFetchJob ThumbnailCacheAsyncFetchJob;
typedef struct _ThumbnailCacheAsyncFetchJobClass ThumbnailCacheAsyncFetchJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _ThumbnailCacheAsyncFetchJobPrivate ThumbnailCacheAsyncFetchJobPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _ThumbnailCacheImageDataPrivate ThumbnailCacheImageDataPrivate;
#define _thumbnail_cache_image_data_unref0(var) ((var == NULL) ? NULL : (var = (thumbnail_cache_image_data_unref (var), NULL)))

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_PHOTO_FORMAT_ERROR (photo_format_error_get_type ())
typedef struct _ThumbnailCacheParamSpecImageData ThumbnailCacheParamSpecImageData;
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Thumbnails {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailsPrivate * priv;
};

struct _ThumbnailsClass {
	GTypeClass parent_class;
	void (*finalize) (Thumbnails *self);
};

struct _ThumbnailsPrivate {
	GeeHashMap* map;
};

struct _ParamSpecThumbnails {
	GParamSpec parent_instance;
};

struct _ThumbnailCache {
	GObject parent_instance;
	ThumbnailCachePrivate * priv;
};

struct _ThumbnailCacheClass {
	GObjectClass parent_class;
};

struct _ThumbnailCachePrivate {
	GFile* cache_dir;
	ThumbnailCacheSize size;
	gulong max_cached_bytes;
	GdkInterpType interp;
	JpegQuality quality;
	GeeHashMap* cache_map;
	GeeArrayList* cache_lru;
	gulong cached_bytes;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _ThumbnailCacheAsyncFetchJob {
	BackgroundJob parent_instance;
	ThumbnailCacheAsyncFetchJobPrivate * priv;
	ThumbnailCache* cache;
	gchar* thumbnail_name;
	ThumbnailSource* source;
	PhotoFileFormat source_format;
	Dimensions dim;
	GdkInterpType interp;
	ThumbnailCacheAsyncFetchCallback callback;
	gpointer callback_target;
	GdkPixbuf* unscaled;
	GdkPixbuf* scaled;
	GError* err;
	gboolean fetched;
	gboolean replace;
};

struct _ThumbnailCacheAsyncFetchJobClass {
	BackgroundJobClass parent_class;
};

struct _ThumbnailCacheImageData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailCacheImageDataPrivate * priv;
	GdkPixbuf* pixbuf;
	gulong bytes;
};

struct _ThumbnailCacheImageDataClass {
	GTypeClass parent_class;
	void (*finalize) (ThumbnailCacheImageData *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()

struct _ThumbnailCacheParamSpecImageData {
	GParamSpec parent_instance;
};

static gint Thumbnails_private_offset;
static gpointer thumbnails_parent_class = NULL;
static gint ThumbnailCache_private_offset;
static gpointer thumbnail_cache_parent_class = NULL;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES;
static gint thumbnail_cache_ALL_SIZES_length1;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES = NULL;
static gint thumbnail_cache_ALL_SIZES_length1 = 0;
static gint _thumbnail_cache_ALL_SIZES_size_ = 0;
static Workers* thumbnail_cache_fetch_workers;
static Workers* thumbnail_cache_fetch_workers = NULL;
static ThumbnailCache* thumbnail_cache_big;
static ThumbnailCache* thumbnail_cache_big = NULL;
static ThumbnailCache* thumbnail_cache_medium;
static ThumbnailCache* thumbnail_cache_medium = NULL;
static ThumbnailCache* thumbnail_cache_large;
static ThumbnailCache* thumbnail_cache_large = NULL;
static OneShotScheduler* thumbnail_cache_debug_scheduler;
static OneShotScheduler* thumbnail_cache_debug_scheduler = NULL;
static gint thumbnail_cache_cycle_fetched_thumbnails;
static gint thumbnail_cache_cycle_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_fetched_thumbnails;
static gint thumbnail_cache_cycle_async_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_resized_thumbnails;
static gint thumbnail_cache_cycle_async_resized_thumbnails = 0;
static gint thumbnail_cache_cycle_overflow_thumbnails;
static gint thumbnail_cache_cycle_overflow_thumbnails = 0;
static gulong thumbnail_cache_cycle_dropped_bytes;
static gulong thumbnail_cache_cycle_dropped_bytes = (gulong) 0;
static gpointer thumbnail_cache_image_data_parent_class = NULL;
static gpointer thumbnail_cache_async_fetch_job_parent_class = NULL;

VALA_EXTERN gpointer thumbnails_ref (gpointer instance);
VALA_EXTERN void thumbnails_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_thumbnails (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_thumbnails (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_thumbnails (const GValue* value);
VALA_EXTERN GType thumbnails_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnails, thumbnails_unref)
VALA_EXTERN GType thumbnail_cache_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Thumbnails* thumbnails_new (void);
VALA_EXTERN Thumbnails* thumbnails_construct (GType object_type);
VALA_EXTERN void thumbnails_set (Thumbnails* self,
                     ThumbnailCacheSize size,
                     GdkPixbuf* pixbuf);
VALA_EXTERN void thumbnails_remove (Thumbnails* self,
                        ThumbnailCacheSize size);
VALA_EXTERN GdkPixbuf* thumbnails_get (Thumbnails* self,
                           ThumbnailCacheSize size);
static void thumbnails_finalize (Thumbnails * obj);
static GType thumbnails_get_type_once (void);
VALA_EXTERN GType thumbnail_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailCache, g_object_unref)
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
static gpointer thumbnail_cache_image_data_ref (gpointer instance);
static void thumbnail_cache_image_data_unref (gpointer instance);
static GParamSpec* thumbnail_cache_param_spec_image_data (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED ;
static void thumbnail_cache_value_set_image_data (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static void thumbnail_cache_value_take_image_data (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static gpointer thumbnail_cache_value_get_image_data (const GValue* value) G_GNUC_UNUSED ;
static GType thumbnail_cache_image_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailCacheImageData, thumbnail_cache_image_data_unref)
VALA_EXTERN gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN void thumbnail_cache_size_get_scaling (ThumbnailCacheSize self,
                                       Scaling* result);
VALA_EXTERN void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
VALA_EXTERN ThumbnailCacheSize thumbnail_cache_size_get_best_size (gint scale);
VALA_EXTERN gdouble application_get_scale (void);
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN gpointer one_shot_scheduler_ref (gpointer instance);
VALA_EXTERN void one_shot_scheduler_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_one_shot_scheduler (const GValue* value);
VALA_EXTERN GType one_shot_scheduler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OneShotScheduler, one_shot_scheduler_unref)
static ThumbnailCache* thumbnail_cache_new (ThumbnailCacheSize size,
                                     gulong max_cached_bytes,
                                     GdkInterpType interp,
                                     JpegQuality quality);
static ThumbnailCache* thumbnail_cache_construct (GType object_type,
                                           ThumbnailCacheSize size,
                                           gulong max_cached_bytes,
                                           GdkInterpType interp,
                                           JpegQuality quality);
VALA_EXTERN GFile* app_dirs_get_cache_subdir (const gchar* name,
                                  const gchar* subname);
VALA_EXTERN void thumbnail_cache_init (void);
static void thumbnail_cache_report_cycle (void);
static void _thumbnail_cache_report_cycle_one_shot_callback (gpointer self);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          gpointer callback_target);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                gpointer callback_target);
VALA_EXTERN guint workers_threads_per_cpu (gint per,
                               gint max);
VALA_EXTERN Workers* workers_new (guint max_threads,
                      gboolean exclusive);
VALA_EXTERN Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
VALA_EXTERN void thumbnail_cache_terminate (void);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN void thumbnail_cache_import_from_source (ThumbnailSource* source,
                                         gboolean force,
                                         GError** error);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
static void _thumbnail_cache_import_from_source (ThumbnailCache* self,
                                          ThumbnailSource* source,
                                          gboolean force,
                                          GError** error);
VALA_EXTERN void thumbnail_cache_import_thumbnails (ThumbnailSource* source,
                                        Thumbnails* thumbnails,
                                        gboolean force,
                                        GError** error);
static void _thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                        ThumbnailSource* source,
                                        GdkPixbuf* scaled,
                                        gboolean force,
                                        GError** error);
VALA_EXTERN void thumbnail_cache_duplicate (ThumbnailSource* src_source,
                                ThumbnailSource* dest_source);
static void _thumbnail_cache_duplicate (ThumbnailCache* self,
                                 ThumbnailSource* src_source,
                                 ThumbnailSource* dest_source);
VALA_EXTERN void thumbnail_cache_remove (ThumbnailSource* source);
static void _thumbnail_cache_remove (ThumbnailCache* self,
                              ThumbnailSource* source);
static ThumbnailCache* thumbnail_cache_get_best_cache (gint scale);
static ThumbnailCache* thumbnail_cache_get_cache_for (ThumbnailCacheSize size);
VALA_EXTERN GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static GdkPixbuf* _thumbnail_cache_fetch (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GError** error);
VALA_EXTERN void thumbnail_cache_fetch_async (ThumbnailSource* source,
                                  gint scale,
                                  ThumbnailCacheAsyncFetchCallback callback,
                                  gpointer callback_target,
                                  GCancellable* cancellable);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
static void _thumbnail_cache_fetch_async (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   PhotoFileFormat format,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   ThumbnailCacheAsyncFetchCallback callback,
                                   gpointer callback_target,
                                   GCancellable* cancellable);
VALA_EXTERN PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable);
VALA_EXTERN void thumbnail_cache_replace (ThumbnailSource* source,
                              ThumbnailCacheSize size,
                              GdkPixbuf* replacement,
                              GError** error);
static void _thumbnail_cache_replace (ThumbnailCache* self,
                               ThumbnailSource* source,
                               GdkPixbuf* original,
                               GError** error);
VALA_EXTERN gboolean thumbnail_cache_exists (ThumbnailSource* source);
static gboolean _thumbnail_cache_exists (ThumbnailCache* self,
                                  ThumbnailSource* source);
VALA_EXTERN GType rotation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void thumbnail_cache_rotate (ThumbnailSource* source,
                             Rotation rotation,
                             GError** error);
VALA_EXTERN GdkPixbuf* rotation_perform (Rotation self,
                             GdkPixbuf* pixbuf);
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                         PhotoFileReader* reader,
                                         Orientation orientation,
                                         Dimensions* original_dim,
                                         GError** error);
VALA_EXTERN void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
VALA_EXTERN GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
VALA_EXTERN GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                               GdkPixbuf* preview_frame);
VALA_EXTERN GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static void thumbnail_cache_schedule_debug (void);
static GdkPixbuf* thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                              const gchar* thumbnail_name);
VALA_EXTERN gchar* data_source_get_source_id (DataSource* self);
static GdkPixbuf* thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat format,
                                        GError** error);
static void thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                      const gchar* thumbnail_name,
                                      GdkPixbuf* thumbnail);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
VALA_EXTERN gboolean dimensions_equals (Dimensions *self,
                            Dimensions* dim);
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                                                  const gchar* thumbnail_name,
                                                                  ThumbnailSource* source,
                                                                  GdkPixbuf* prefetched,
                                                                  Dimensions* dim,
                                                                  GdkInterpType interp,
                                                                  ThumbnailCacheAsyncFetchCallback callback,
                                                                  gpointer callback_target,
                                                                  GCancellable* cancellable);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_construct (GType object_type,
                                                                        ThumbnailCache* cache,
                                                                        const gchar* thumbnail_name,
                                                                        ThumbnailSource* source,
                                                                        GdkPixbuf* prefetched,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        ThumbnailCacheAsyncFetchCallback callback,
                                                                        gpointer callback_target,
                                                                        GCancellable* cancellable);
static GType thumbnail_cache_async_fetch_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailCacheAsyncFetchJob, background_job_unref)
static void thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job);
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
static GFile* thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                               ThumbnailSource* source);
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
static void thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                     GFile* file,
                                     GdkPixbuf* pixbuf,
                                     ThumbnailSource* source,
                                     GError** error);
VALA_EXTERN gboolean dimensions_approx_scaled (Dimensions *self,
                                   gint scale,
                                   gint fudge);
static GFile* thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                        const gchar* thumbnail_name,
                                        PhotoFileFormat thumbnail_format);
VALA_EXTERN gchar* thumbnail_source_get_representative_id (ThumbnailSource* self);
static gboolean thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                             const gchar* thumbnail_name);
VALA_EXTERN GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
VALA_EXTERN PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
VALA_EXTERN gchar* photo_file_format_get_default_basename (PhotoFileFormat self,
                                               const gchar* name);
static ThumbnailCacheImageData* thumbnail_cache_image_data_new (GdkPixbuf* pixbuf);
static ThumbnailCacheImageData* thumbnail_cache_image_data_construct (GType object_type,
                                                               GdkPixbuf* pixbuf);
VALA_EXTERN GType photo_file_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileWriter, photo_file_adapter_unref)
VALA_EXTERN GQuark photo_format_error_quark (void);
VALA_EXTERN GType photo_format_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self,
                                                  const gchar* filepath,
                                                  GError** error);
VALA_EXTERN void photo_file_writer_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error);
static void thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj);
static GType thumbnail_cache_image_data_get_type_once (void);
VALA_EXTERN BackgroundJobJobPriority background_job_get_priority (BackgroundJob* self);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
static void _thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                           gpointer self);
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static BackgroundJobJobPriority thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base);
static void thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base);
VALA_EXTERN gboolean background_job_is_cancelled (BackgroundJob* self);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self,
                                                         GError** error);
VALA_EXTERN gint dimensions_major_axis (Dimensions *self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                              gint scale,
                                              GError** error);
static void thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj);
static GType thumbnail_cache_async_fetch_job_get_type_once (void);
static void thumbnail_cache_finalize (GObject * obj);
static GType thumbnail_cache_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
thumbnails_get_instance_private (Thumbnails* self)
{
	return G_STRUCT_MEMBER_P (self, Thumbnails_private_offset);
}

Thumbnails*
thumbnails_construct (GType object_type)
{
	Thumbnails* self = NULL;
	self = (Thumbnails*) g_type_create_instance (object_type);
	return self;
}

Thumbnails*
thumbnails_new (void)
{
	return thumbnails_construct (TYPE_THUMBNAILS);
}

void
thumbnails_set (Thumbnails* self,
                ThumbnailCacheSize size,
                GdkPixbuf* pixbuf)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_THUMBNAILS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	_tmp0_ = self->priv->map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size), pixbuf);
}

void
thumbnails_remove (Thumbnails* self,
                   ThumbnailCacheSize size)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_THUMBNAILS (self));
	_tmp0_ = self->priv->map;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size), NULL);
}

GdkPixbuf*
thumbnails_get (Thumbnails* self,
                ThumbnailCacheSize size)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_THUMBNAILS (self), NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) size));
	result = (GdkPixbuf*) _tmp1_;
	return result;
}

static void
value_thumbnails_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_thumbnails_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		thumbnails_unref (value->data[0].v_pointer);
	}
}

static void
value_thumbnails_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = thumbnails_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_thumbnails_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_thumbnails_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Thumbnails * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = thumbnails_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_thumbnails_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Thumbnails ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = thumbnails_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_thumbnails (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecThumbnails* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THUMBNAILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_thumbnails (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_thumbnails (GValue* value,
                      gpointer v_object)
{
	Thumbnails * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		thumbnails_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnails_unref (old);
	}
}

void
value_take_thumbnails (GValue* value,
                       gpointer v_object)
{
	Thumbnails * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnails_unref (old);
	}
}

static void
thumbnails_class_init (ThumbnailsClass * klass,
                       gpointer klass_data)
{
	thumbnails_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailsClass *) klass)->finalize = thumbnails_finalize;
	g_type_class_adjust_private_offset (klass, &Thumbnails_private_offset);
}

static void
thumbnails_instance_init (Thumbnails * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = thumbnails_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (THUMBNAIL_CACHE_TYPE_SIZE, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
	self->ref_count = 1;
}

static void
thumbnails_finalize (Thumbnails * obj)
{
	Thumbnails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAILS, Thumbnails);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->map);
}

static GType
thumbnails_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_thumbnails_init, value_thumbnails_free_value, value_thumbnails_copy_value, value_thumbnails_peek_pointer, "p", value_thumbnails_collect_value, "p", value_thumbnails_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnails_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnails), 0, (GInstanceInitFunc) thumbnails_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType thumbnails_type_id;
	thumbnails_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Thumbnails", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Thumbnails_private_offset = g_type_add_instance_private (thumbnails_type_id, sizeof (ThumbnailsPrivate));
	return thumbnails_type_id;
}

GType
thumbnails_get_type (void)
{
	static volatile gsize thumbnails_type_id__once = 0;
	if (g_once_init_enter (&thumbnails_type_id__once)) {
		GType thumbnails_type_id;
		thumbnails_type_id = thumbnails_get_type_once ();
		g_once_init_leave (&thumbnails_type_id__once, thumbnails_type_id);
	}
	return thumbnails_type_id__once;
}

gpointer
thumbnails_ref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
thumbnails_unref (gpointer instance)
{
	Thumbnails * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THUMBNAILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
thumbnail_cache_get_instance_private (ThumbnailCache* self)
{
	return G_STRUCT_MEMBER_P (self, ThumbnailCache_private_offset);
}

gint
thumbnail_cache_size_get_scale (ThumbnailCacheSize self)
{
	gint result;
	result = (gint) self;
	return result;
}

void
thumbnail_cache_size_get_scaling (ThumbnailCacheSize self,
                                  Scaling* result)
{
	Scaling _tmp0_ = {0};
	scaling_for_best_fit (thumbnail_cache_size_get_scale (self), TRUE, &_tmp0_);
	*result = _tmp0_;
	return;
}

ThumbnailCacheSize
thumbnail_cache_size_get_best_size (gint scale)
{
	gdouble real_scale = 0.0;
	ThumbnailCacheSize result;
	real_scale = application_get_scale () * scale;
	if (real_scale <= ((gdouble) thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM))) {
		result = THUMBNAIL_CACHE_SIZE_MEDIUM;
		return result;
	}
	if (real_scale <= ((gdouble) thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG))) {
		result = THUMBNAIL_CACHE_SIZE_BIG;
		return result;
	}
	result = THUMBNAIL_CACHE_SIZE_LARGE;
	return result;
}

static GType
thumbnail_cache_size_get_type_once (void)
{
	static const GEnumValue values[] = {{THUMBNAIL_CACHE_SIZE_LARGEST, "THUMBNAIL_CACHE_SIZE_LARGEST", "largest"}, {THUMBNAIL_CACHE_SIZE_LARGE, "THUMBNAIL_CACHE_SIZE_LARGE", "large"}, {THUMBNAIL_CACHE_SIZE_BIG, "THUMBNAIL_CACHE_SIZE_BIG", "big"}, {THUMBNAIL_CACHE_SIZE_MEDIUM, "THUMBNAIL_CACHE_SIZE_MEDIUM", "medium"}, {THUMBNAIL_CACHE_SIZE_SMALLEST, "THUMBNAIL_CACHE_SIZE_SMALLEST", "smallest"}, {0, NULL, NULL}};
	GType thumbnail_cache_size_type_id;
	thumbnail_cache_size_type_id = g_enum_register_static ("ThumbnailCacheSize", values);
	return thumbnail_cache_size_type_id;
}

GType
thumbnail_cache_size_get_type (void)
{
	static volatile gsize thumbnail_cache_size_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_size_type_id__once)) {
		GType thumbnail_cache_size_type_id;
		thumbnail_cache_size_type_id = thumbnail_cache_size_get_type_once ();
		g_once_init_leave (&thumbnail_cache_size_type_id__once, thumbnail_cache_size_type_id);
	}
	return thumbnail_cache_size_type_id__once;
}

static ThumbnailCache*
thumbnail_cache_construct (GType object_type,
                           ThumbnailCacheSize size,
                           gulong max_cached_bytes,
                           GdkInterpType interp,
                           JpegQuality quality)
{
	ThumbnailCache * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	self = (ThumbnailCache*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup_printf ("thumbs%d", thumbnail_cache_size_get_scale (size));
	_tmp1_ = _tmp0_;
	_tmp2_ = app_dirs_get_cache_subdir ("thumbs", _tmp1_);
	_g_object_unref0 (self->priv->cache_dir);
	self->priv->cache_dir = _tmp2_;
	_g_free0 (_tmp1_);
	self->priv->size = size;
	self->priv->max_cached_bytes = max_cached_bytes;
	self->priv->interp = interp;
	self->priv->quality = quality;
	return self;
}

static ThumbnailCache*
thumbnail_cache_new (ThumbnailCacheSize size,
                     gulong max_cached_bytes,
                     GdkInterpType interp,
                     JpegQuality quality)
{
	return thumbnail_cache_construct (TYPE_THUMBNAIL_CACHE, size, max_cached_bytes, interp, quality);
}

static void
_thumbnail_cache_report_cycle_one_shot_callback (gpointer self)
{
	thumbnail_cache_report_cycle ();
}

void
thumbnail_cache_init (void)
{
	OneShotScheduler* _tmp0_;
	Workers* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
	ThumbnailCache* _tmp4_;
	_tmp0_ = one_shot_scheduler_new ("ThumbnailCache cycle reporter", _thumbnail_cache_report_cycle_one_shot_callback, NULL);
	_one_shot_scheduler_unref0 (thumbnail_cache_debug_scheduler);
	thumbnail_cache_debug_scheduler = _tmp0_;
	_tmp1_ = workers_new (workers_threads_per_cpu (1, -1), TRUE);
	_workers_unref0 (thumbnail_cache_fetch_workers);
	thumbnail_cache_fetch_workers = _tmp1_;
	_tmp2_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_BIG, THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
	_g_object_unref0 (thumbnail_cache_big);
	thumbnail_cache_big = _tmp2_;
	_tmp3_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_MEDIUM, THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
	_g_object_unref0 (thumbnail_cache_medium);
	thumbnail_cache_medium = _tmp3_;
	_tmp4_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_LARGE, THUMBNAIL_CACHE_MAX_LARGE_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
	_g_object_unref0 (thumbnail_cache_large);
	thumbnail_cache_large = _tmp4_;
}

void
thumbnail_cache_terminate (void)
{
}

void
thumbnail_cache_import_from_source (ThumbnailSource* source,
                                    gboolean force,
                                    GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ThumbnailCache* _tmp2_;
	ThumbnailCache* _tmp3_;
	ThumbnailCache* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	g_debug ("ThumbnailCache.vala:224: import from source: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = thumbnail_cache_big;
	_thumbnail_cache_import_from_source (_tmp2_, source, force, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = thumbnail_cache_medium;
	_thumbnail_cache_import_from_source (_tmp3_, source, force, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = thumbnail_cache_large;
	_thumbnail_cache_import_from_source (_tmp4_, source, force, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
thumbnail_cache_import_thumbnails (ThumbnailSource* source,
                                   Thumbnails* thumbnails,
                                   gboolean force,
                                   GError** error)
{
	ThumbnailCache* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	ThumbnailCache* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	ThumbnailCache* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
	_tmp0_ = thumbnail_cache_big;
	_tmp1_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_BIG);
	_tmp2_ = _tmp1_;
	_thumbnail_cache_import_thumbnail (_tmp0_, source, _tmp2_, force, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = thumbnail_cache_medium;
	_tmp4_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_MEDIUM);
	_tmp5_ = _tmp4_;
	_thumbnail_cache_import_thumbnail (_tmp3_, source, _tmp5_, force, &_inner_error0_);
	_g_object_unref0 (_tmp5_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp6_ = thumbnail_cache_large;
	_tmp7_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_LARGE);
	_tmp8_ = _tmp7_;
	_thumbnail_cache_import_thumbnail (_tmp6_, source, _tmp8_, force, &_inner_error0_);
	_g_object_unref0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
thumbnail_cache_duplicate (ThumbnailSource* src_source,
                           ThumbnailSource* dest_source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	ThumbnailCache* _tmp2_;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
	_tmp0_ = thumbnail_cache_big;
	_thumbnail_cache_duplicate (_tmp0_, src_source, dest_source);
	_tmp1_ = thumbnail_cache_medium;
	_thumbnail_cache_duplicate (_tmp1_, src_source, dest_source);
	_tmp2_ = thumbnail_cache_large;
	_thumbnail_cache_duplicate (_tmp2_, src_source, dest_source);
}

void
thumbnail_cache_remove (ThumbnailSource* source)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	ThumbnailCache* _tmp2_;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp0_ = thumbnail_cache_big;
	_thumbnail_cache_remove (_tmp0_, source);
	_tmp1_ = thumbnail_cache_medium;
	_thumbnail_cache_remove (_tmp1_, source);
	_tmp2_ = thumbnail_cache_large;
	_thumbnail_cache_remove (_tmp2_, source);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ThumbnailCache*
thumbnail_cache_get_best_cache (gint scale)
{
	ThumbnailCacheSize size = 0;
	ThumbnailCache* result;
	size = thumbnail_cache_size_get_best_size (scale);
	if (size == THUMBNAIL_CACHE_SIZE_LARGE) {
		ThumbnailCache* _tmp0_;
		ThumbnailCache* _tmp1_;
		_tmp0_ = thumbnail_cache_large;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		if (size == THUMBNAIL_CACHE_SIZE_BIG) {
			ThumbnailCache* _tmp2_;
			ThumbnailCache* _tmp3_;
			_tmp2_ = thumbnail_cache_big;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		} else {
			ThumbnailCache* _tmp4_;
			ThumbnailCache* _tmp5_;
			_vala_assert (size == THUMBNAIL_CACHE_SIZE_MEDIUM, "size == Size.MEDIUM");
			_tmp4_ = thumbnail_cache_medium;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
	}
}

static ThumbnailCache*
thumbnail_cache_get_cache_for (ThumbnailCacheSize size)
{
	ThumbnailCache* result;
	switch (size) {
		case THUMBNAIL_CACHE_SIZE_LARGE:
		{
			ThumbnailCache* _tmp0_;
			ThumbnailCache* _tmp1_;
			_tmp0_ = thumbnail_cache_large;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case THUMBNAIL_CACHE_SIZE_BIG:
		{
			ThumbnailCache* _tmp2_;
			ThumbnailCache* _tmp3_;
			_tmp2_ = thumbnail_cache_big;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case THUMBNAIL_CACHE_SIZE_MEDIUM:
		{
			ThumbnailCache* _tmp4_;
			ThumbnailCache* _tmp5_;
			_tmp4_ = thumbnail_cache_medium;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_error ("ThumbnailCache.vala:274: Unknown thumbnail size %d", thumbnail_cache_size_get_scale (size));
		}
	}
}

GdkPixbuf*
thumbnail_cache_fetch (ThumbnailSource* source,
                       gint scale,
                       GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	ThumbnailCache* _tmp1_;
	ThumbnailCache* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
	_tmp1_ = thumbnail_cache_get_best_cache (scale);
	_tmp2_ = _tmp1_;
	_tmp3_ = _thumbnail_cache_fetch (_tmp2_, source, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp0_);
	return result;
}

void
thumbnail_cache_fetch_async (ThumbnailSource* source,
                             gint scale,
                             ThumbnailCacheAsyncFetchCallback callback,
                             gpointer callback_target,
                             GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
	_tmp1_ = _tmp0_;
	dimensions_init (&_tmp2_, 0, 0);
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, THUMBNAIL_CACHE_DEFAULT_INTERP, callback, callback_target, cancellable);
	_g_object_unref0 (_tmp1_);
}

void
thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                    gint scale,
                                    Dimensions* dim,
                                    GdkInterpType interp,
                                    ThumbnailCacheAsyncFetchCallback callback,
                                    gpointer callback_target,
                                    GCancellable* cancellable)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	Dimensions _tmp2_;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail (dim != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = thumbnail_cache_get_best_cache (scale);
	_tmp1_ = _tmp0_;
	_tmp2_ = *dim;
	_thumbnail_cache_fetch_async (_tmp1_, source, thumbnail_source_get_preferred_thumbnail_format (source), &_tmp2_, interp, callback, callback_target, cancellable);
	_g_object_unref0 (_tmp1_);
}

void
thumbnail_cache_replace (ThumbnailSource* source,
                         ThumbnailCacheSize size,
                         GdkPixbuf* replacement,
                         GError** error)
{
	ThumbnailCache* _tmp0_;
	ThumbnailCache* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (replacement, gdk_pixbuf_get_type ()));
	_tmp0_ = thumbnail_cache_get_cache_for (size);
	_tmp1_ = _tmp0_;
	_thumbnail_cache_replace (_tmp1_, source, replacement, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gboolean
thumbnail_cache_exists (ThumbnailSource* source)
{
	gboolean _tmp0_ = FALSE;
	ThumbnailCache* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
	_tmp1_ = thumbnail_cache_big;
	if (_thumbnail_cache_exists (_tmp1_, source)) {
		ThumbnailCache* _tmp2_;
		_tmp2_ = thumbnail_cache_medium;
		_tmp0_ = _thumbnail_cache_exists (_tmp2_, source);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
thumbnail_cache_rotate (ThumbnailSource* source,
                        Rotation rotation,
                        GError** error)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp0_ = thumbnail_cache_ALL_SIZES;
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp0_;
		size_collection_length1 = _tmp0__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				GdkPixbuf* thumbnail = NULL;
				GdkPixbuf* _tmp1_;
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				GdkPixbuf* _tmp4_;
				_tmp1_ = thumbnail_cache_fetch (source, (gint) size, &_inner_error0_);
				thumbnail = _tmp1_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				_tmp2_ = thumbnail;
				_tmp3_ = rotation_perform (rotation, _tmp2_);
				_g_object_unref0 (thumbnail);
				thumbnail = _tmp3_;
				_tmp4_ = thumbnail;
				thumbnail_cache_replace (source, size, _tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (thumbnail);
					return;
				}
				_g_object_unref0 (thumbnail);
			}
		}
	}
}

void
thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                    PhotoFileReader* reader,
                                    Orientation orientation,
                                    Dimensions* original_dim,
                                    GError** error)
{
	ThumbnailCacheSize max_size = 0;
	Dimensions dim = {0};
	Scaling _tmp0_ = {0};
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	GdkPixbuf* largest_thumbnail = NULL;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	Dimensions largest_thumb_dimensions = {0};
	GdkPixbuf* _tmp13_;
	Dimensions _tmp14_ = {0};
	ThumbnailCacheSize* _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
	g_return_if_fail (IS_PHOTO_FILE_READER (reader));
	g_return_if_fail (original_dim != NULL);
	max_size = THUMBNAIL_CACHE_SIZE_BIG * 2;
	thumbnail_cache_size_get_scaling (max_size, &_tmp0_);
	_tmp1_ = *original_dim;
	scaling_get_scaled_dimensions (&_tmp0_, &_tmp1_, &_tmp2_);
	dim = _tmp2_;
	largest_thumbnail = NULL;
	{
		GdkPixbuf* _tmp3_ = NULL;
		Dimensions _tmp4_;
		Dimensions _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		_tmp4_ = *original_dim;
		_tmp5_ = dim;
		_tmp6_ = photo_file_reader_scaled_read (reader, &_tmp4_, &_tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (largest_thumbnail);
		largest_thumbnail = _tmp7_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = photo_file_reader_unscaled_read (reader, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (largest_thumbnail);
		largest_thumbnail = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (largest_thumbnail);
		return;
	}
	_tmp11_ = largest_thumbnail;
	_tmp12_ = orientation_rotate_pixbuf (orientation, _tmp11_);
	_g_object_unref0 (largest_thumbnail);
	largest_thumbnail = _tmp12_;
	_tmp13_ = largest_thumbnail;
	dimensions_for_pixbuf (_tmp13_, &_tmp14_);
	largest_thumb_dimensions = _tmp14_;
	_tmp15_ = thumbnail_cache_ALL_SIZES;
	_tmp15__length1 = thumbnail_cache_ALL_SIZES_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp15_;
		size_collection_length1 = _tmp15__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				Scaling _tmp16_ = {0};
				Dimensions _tmp17_;
				Dimensions _tmp18_ = {0};
				GdkPixbuf* _tmp19_;
				Dimensions _tmp20_;
				Dimensions _tmp21_;
				GdkPixbuf* _tmp22_;
				GdkPixbuf* _tmp23_;
				thumbnail_cache_size_get_scaling (size, &_tmp16_);
				_tmp17_ = largest_thumb_dimensions;
				scaling_get_scaled_dimensions (&_tmp16_, &_tmp17_, &_tmp18_);
				dim = _tmp18_;
				_tmp19_ = largest_thumbnail;
				_tmp20_ = dim;
				_tmp21_ = dim;
				_tmp22_ = gdk_pixbuf_scale_simple (_tmp19_, _tmp20_.width, _tmp21_.height, GDK_INTERP_HYPER);
				_tmp23_ = _tmp22_;
				thumbnails_set (thumbnails, size, _tmp23_);
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	_g_object_unref0 (largest_thumbnail);
}

void
thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                          GdkPixbuf* preview_frame)
{
	ThumbnailCacheSize* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (preview_frame, gdk_pixbuf_get_type ()));
	_tmp0_ = thumbnail_cache_ALL_SIZES;
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp0_;
		size_collection_length1 = _tmp0__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			ThumbnailCacheSize size = 0;
			size = size_collection[size_it];
			{
				Scaling current_scaling = {0};
				Scaling _tmp1_ = {0};
				GdkPixbuf* current_thumbnail = NULL;
				GdkPixbuf* _tmp2_;
				GdkPixbuf* _tmp3_;
				thumbnail_cache_size_get_scaling (size, &_tmp1_);
				current_scaling = _tmp1_;
				_tmp2_ = scaling_perform_on_pixbuf (&current_scaling, preview_frame, GDK_INTERP_HYPER, TRUE);
				current_thumbnail = _tmp2_;
				_tmp3_ = current_thumbnail;
				thumbnails_set (thumbnails, size, _tmp3_);
				_g_object_unref0 (current_thumbnail);
			}
		}
	}
}

static void
thumbnail_cache_schedule_debug (void)
{
}

static void
thumbnail_cache_report_cycle (void)
{
}

static GdkPixbuf*
_thumbnail_cache_fetch (ThumbnailCache* self,
                        ThumbnailSource* source,
                        GError** error)
{
	GdkPixbuf* pixbuf = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GdkPixbuf* _tmp14_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pixbuf = _tmp3_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp6_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp7_ = _tmp6_;
	_tmp8_ = thumbnail_cache_read_pixbuf (self, _tmp7_, thumbnail_source_get_preferred_thumbnail_format (source), &_inner_error0_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp5_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		return NULL;
	}
	_tmp10_ = _tmp5_;
	_tmp5_ = NULL;
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp10_;
	_tmp11_ = thumbnail_cache_cycle_fetched_thumbnails;
	thumbnail_cache_cycle_fetched_thumbnails = _tmp11_ + 1;
	thumbnail_cache_schedule_debug ();
	_tmp12_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp13_ = _tmp12_;
	_tmp14_ = pixbuf;
	thumbnail_cache_store_in_memory (self, _tmp13_, _tmp14_);
	_g_free0 (_tmp13_);
	result = pixbuf;
	_g_object_unref0 (_tmp5_);
	return result;
}

static void
_thumbnail_cache_fetch_async (ThumbnailCache* self,
                              ThumbnailSource* source,
                              PhotoFileFormat format,
                              Dimensions* dim,
                              GdkInterpType interp,
                              ThumbnailCacheAsyncFetchCallback callback,
                              gpointer callback_target,
                              GCancellable* cancellable)
{
	gchar* thumbnail_name = NULL;
	gchar* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkPixbuf* _tmp4_;
	Workers* _tmp12_;
	const gchar* _tmp13_;
	GdkPixbuf* _tmp14_;
	Dimensions _tmp15_;
	ThumbnailCacheAsyncFetchJob* _tmp16_;
	ThumbnailCacheAsyncFetchJob* _tmp17_;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail (dim != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	thumbnail_name = _tmp0_;
	_tmp1_ = thumbnail_name;
	_tmp2_ = thumbnail_cache_fetch_from_memory (self, _tmp1_);
	pixbuf = _tmp2_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		if (!dimensions_has_area (dim)) {
			_tmp5_ = TRUE;
		} else {
			GdkPixbuf* _tmp6_;
			Dimensions _tmp7_ = {0};
			Dimensions _tmp8_;
			_tmp6_ = pixbuf;
			dimensions_for_pixbuf (_tmp6_, &_tmp7_);
			_tmp8_ = *dim;
			_tmp5_ = dimensions_equals (&_tmp7_, &_tmp8_);
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		Dimensions _tmp11_;
		_tmp9_ = pixbuf;
		_tmp10_ = pixbuf;
		_tmp11_ = *dim;
		callback (_tmp9_, _tmp10_, &_tmp11_, interp, NULL, callback_target);
		_g_object_unref0 (pixbuf);
		_g_free0 (thumbnail_name);
		return;
	}
	_tmp12_ = thumbnail_cache_fetch_workers;
	_tmp13_ = thumbnail_name;
	_tmp14_ = pixbuf;
	_tmp15_ = *dim;
	_tmp16_ = thumbnail_cache_async_fetch_job_new (self, _tmp13_, source, _tmp14_, &_tmp15_, interp, callback, callback_target, cancellable);
	_tmp17_ = _tmp16_;
	workers_enqueue (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_BACKGROUND_JOB, BackgroundJob));
	_background_job_unref0 (_tmp17_);
	_g_object_unref0 (pixbuf);
	_g_free0 (thumbnail_name);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job)
{
	ThumbnailCacheAsyncFetchJob* job = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ThumbnailCacheAsyncFetchJob* _tmp2_;
	ThumbnailCacheAsyncFetchJob* _tmp14_;
	GdkPixbuf* _tmp15_;
	ThumbnailCacheAsyncFetchJob* _tmp25_;
	ThumbnailCacheAsyncFetchCallback _tmp26_;
	gpointer _tmp26__target;
	ThumbnailCacheAsyncFetchJob* _tmp27_;
	GdkPixbuf* _tmp28_;
	ThumbnailCacheAsyncFetchJob* _tmp29_;
	GdkPixbuf* _tmp30_;
	ThumbnailCacheAsyncFetchJob* _tmp31_;
	Dimensions _tmp32_;
	ThumbnailCacheAsyncFetchJob* _tmp33_;
	ThumbnailCacheAsyncFetchJob* _tmp34_;
	GError* _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_BACKGROUND_JOB (background_job));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (background_job, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob));
	job = _tmp0_;
	_tmp2_ = job;
	if (_tmp2_->replace) {
		ThumbnailCacheAsyncFetchJob* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = job;
		_tmp4_ = _tmp3_->unscaled;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			ThumbnailCacheAsyncFetchJob* _tmp5_;
			ThumbnailSource* _tmp6_;
			ThumbnailCacheAsyncFetchJob* _tmp7_;
			ThumbnailCache* _tmp8_;
			ThumbnailCacheAsyncFetchJob* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp5_ = job;
			_tmp6_ = _tmp5_->source;
			_tmp7_ = job;
			_tmp8_ = _tmp7_->cache;
			_tmp9_ = job;
			_tmp10_ = _tmp9_->unscaled;
			thumbnail_cache_replace (_tmp6_, _tmp8_->priv->size, _tmp10_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp11_;
			GError* _tmp12_;
			GError* _tmp13_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = job;
			_tmp12_ = err;
			_tmp13_ = _g_error_copy0 (_tmp12_);
			_g_error_free0 (_tmp11_->err);
			_tmp11_->err = _tmp13_;
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_background_job_unref0 (job);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = job;
	_tmp15_ = _tmp14_->unscaled;
	if (_tmp15_ != NULL) {
		ThumbnailCacheAsyncFetchJob* _tmp16_;
		_tmp16_ = job;
		if (_tmp16_->fetched) {
			ThumbnailCacheAsyncFetchJob* _tmp17_;
			ThumbnailCache* _tmp18_;
			ThumbnailCacheAsyncFetchJob* _tmp19_;
			const gchar* _tmp20_;
			ThumbnailCacheAsyncFetchJob* _tmp21_;
			GdkPixbuf* _tmp22_;
			gint _tmp23_;
			_tmp17_ = job;
			_tmp18_ = _tmp17_->cache;
			_tmp19_ = job;
			_tmp20_ = _tmp19_->thumbnail_name;
			_tmp21_ = job;
			_tmp22_ = _tmp21_->unscaled;
			thumbnail_cache_store_in_memory (_tmp18_, _tmp20_, _tmp22_);
			_tmp23_ = thumbnail_cache_cycle_async_fetched_thumbnails;
			thumbnail_cache_cycle_async_fetched_thumbnails = _tmp23_ + 1;
			thumbnail_cache_schedule_debug ();
		} else {
			gint _tmp24_;
			_tmp24_ = thumbnail_cache_cycle_async_resized_thumbnails;
			thumbnail_cache_cycle_async_resized_thumbnails = _tmp24_ + 1;
			thumbnail_cache_schedule_debug ();
		}
	}
	_tmp25_ = job;
	_tmp26_ = _tmp25_->callback;
	_tmp26__target = _tmp25_->callback_target;
	_tmp27_ = job;
	_tmp28_ = _tmp27_->scaled;
	_tmp29_ = job;
	_tmp30_ = _tmp29_->unscaled;
	_tmp31_ = job;
	_tmp32_ = _tmp31_->dim;
	_tmp33_ = job;
	_tmp34_ = job;
	_tmp35_ = _tmp34_->err;
	_tmp26_ (_tmp28_, _tmp30_, &_tmp32_, _tmp33_->interp, _tmp35_, _tmp26__target);
	_background_job_unref0 (job);
}

static void
_thumbnail_cache_import_from_source (ThumbnailCache* self,
                                     ThumbnailSource* source,
                                     gboolean force,
                                     GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_;
	Scaling _tmp4_ = {0};
	GdkPixbuf* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	if (!force) {
		if (_thumbnail_cache_exists (self, source)) {
			_g_object_unref0 (file);
			return;
		}
	} else {
		_thumbnail_cache_remove (self, source);
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	photo = _tmp1_;
	_tmp3_ = photo;
	scaling_for_best_fit (thumbnail_cache_size_get_scale (self->priv->size), TRUE, &_tmp4_);
	_tmp5_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp4_, &_inner_error0_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (photo);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = file;
	thumbnail_cache_save_thumbnail (self, _tmp6_, _tmp2_, source, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (photo);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (photo);
	_g_object_unref0 (file);
}

static void
_thumbnail_cache_import_thumbnail (ThumbnailCache* self,
                                   ThumbnailSource* source,
                                   GdkPixbuf* scaled,
                                   gboolean force,
                                   GError** error)
{
	Dimensions _tmp0_ = {0};
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail ((scaled == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (scaled, gdk_pixbuf_get_type ()));
	_vala_assert (scaled != NULL, "scaled != null");
	dimensions_for_pixbuf (scaled, &_tmp0_);
	_vala_assert (dimensions_approx_scaled (&_tmp0_, thumbnail_cache_size_get_scale (self->priv->size), 1), "Dimensions.for_pixbuf(scaled).approx_scaled(size.get_scale())");
	if (!force) {
		if (_thumbnail_cache_exists (self, source)) {
			return;
		}
	} else {
		_thumbnail_cache_remove (self, source);
	}
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, source);
	_tmp2_ = _tmp1_;
	thumbnail_cache_save_thumbnail (self, _tmp2_, scaled, source, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_thumbnail_cache_duplicate (ThumbnailCache* self,
                            ThumbnailSource* src_source,
                            ThumbnailSource* dest_source)
{
	GFile* src_file = NULL;
	GFile* _tmp0_;
	GFile* dest_file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean success = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, src_source);
	src_file = _tmp0_;
	_tmp1_ = thumbnail_source_get_representative_id (dest_source);
	_tmp2_ = _tmp1_;
	_tmp3_ = thumbnail_cache_get_cached_file (self, _tmp2_, thumbnail_source_get_preferred_thumbnail_format (src_source));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	dest_file = _tmp4_;
	success = FALSE;
	{
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = src_file;
		_tmp6_ = dest_file;
		g_file_copy (_tmp5_, _tmp6_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_debug ("ThumbnailCache.vala:518: Failed to duplicate thumbnail: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest_file);
		_g_object_unref0 (src_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (success) {
		_g_object_unref0 (dest_file);
		_g_object_unref0 (src_file);
		return;
	}
	{
		_thumbnail_cache_import_from_source (self, dest_source, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_thumbnail_cache_import_from_source (self, src_source, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_debug ("ThumbnailCache.vala:529: Failed to duplicate thumbnail: %s", _tmp10_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest_file);
		_g_object_unref0 (src_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dest_file);
	_g_object_unref0 (src_file);
}

static void
_thumbnail_cache_replace (ThumbnailCache* self,
                          ThumbnailSource* source,
                          GdkPixbuf* original,
                          GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* scaled = NULL;
	GdkPixbuf* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (original, gdk_pixbuf_get_type ()));
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp2_ = _tmp1_;
	thumbnail_cache_remove_from_memory (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = scale_pixbuf (original, thumbnail_cache_size_get_scale (self->priv->size), self->priv->interp, TRUE);
	scaled = _tmp3_;
	thumbnail_cache_save_thumbnail (self, file, scaled, source, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (scaled);
		_g_object_unref0 (file);
		return;
	}
	_tmp4_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp5_ = _tmp4_;
	thumbnail_cache_store_in_memory (self, _tmp5_, scaled);
	_g_free0 (_tmp5_);
	_g_object_unref0 (scaled);
	_g_object_unref0 (file);
}

static void
_thumbnail_cache_remove (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	file = _tmp0_;
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	_tmp2_ = _tmp1_;
	thumbnail_cache_remove_from_memory (self, _tmp2_);
	_g_free0 (_tmp2_);
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static gboolean
_thumbnail_cache_exists (ThumbnailCache* self,
                         ThumbnailSource* source)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
	_tmp0_ = thumbnail_cache_get_source_cached_file (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static GdkPixbuf*
thumbnail_cache_read_pixbuf (ThumbnailCache* self,
                             const gchar* thumbnail_name,
                             PhotoFileFormat format,
                             GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileReader* _tmp5_;
	PhotoFileReader* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp1_ = thumbnail_cache_get_cached_file (self, thumbnail_name, format);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = photo_file_format_create_reader (format, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = photo_file_reader_unscaled_read (_tmp6_, &_inner_error0_);
	_tmp8_ = _tmp7_;
	_photo_file_adapter_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp9_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GFile*
thumbnail_cache_get_source_cached_file (ThumbnailCache* self,
                                        ThumbnailSource* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
	_tmp0_ = thumbnail_source_get_representative_id (source);
	_tmp1_ = _tmp0_;
	_tmp2_ = thumbnail_cache_get_cached_file (self, _tmp1_, thumbnail_source_get_preferred_thumbnail_format (source));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
thumbnail_cache_get_cached_file (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 PhotoFileFormat thumbnail_format)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp0_ = self->priv->cache_dir;
	_tmp1_ = photo_file_format_get_default_basename (thumbnail_format, thumbnail_name);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static GdkPixbuf*
thumbnail_cache_fetch_from_memory (ThumbnailCache* self,
                                   const gchar* thumbnail_name)
{
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	ThumbnailCacheImageData* _tmp3_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	_tmp0_ = self->priv->cache_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name);
	data = (ThumbnailCacheImageData*) _tmp1_;
	_tmp3_ = data;
	if (_tmp3_ != NULL) {
		ThumbnailCacheImageData* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = data;
		_tmp5_ = _tmp4_->pixbuf;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	result = _tmp6_;
	_thumbnail_cache_image_data_unref0 (data);
	return result;
}

static void
thumbnail_cache_store_in_memory (ThumbnailCache* self,
                                 const gchar* thumbnail_name,
                                 GdkPixbuf* thumbnail)
{
	ThumbnailCacheImageData* data = NULL;
	ThumbnailCacheImageData* _tmp0_;
	ThumbnailCacheImageData* _tmp1_;
	GeeHashMap* _tmp2_;
	ThumbnailCacheImageData* _tmp3_;
	GeeArrayList* _tmp4_;
	ThumbnailCacheImageData* _tmp5_;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (thumbnail_name != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (thumbnail, gdk_pixbuf_get_type ()));
	if (self->priv->max_cached_bytes <= ((gulong) 0)) {
		return;
	}
	thumbnail_cache_remove_from_memory (self, thumbnail_name);
	_tmp0_ = thumbnail_cache_image_data_new (thumbnail);
	data = _tmp0_;
	_tmp1_ = data;
	if (_tmp1_->bytes > ((gulong) THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE)) {
		g_debug ("ThumbnailCache.vala:603: Persistent thumbnail [%s] too large to cache " \
"in memory", thumbnail_name);
		_thumbnail_cache_image_data_unref0 (data);
		return;
	}
	_tmp2_ = self->priv->cache_map;
	_tmp3_ = data;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name, _tmp3_);
	_tmp4_ = self->priv->cache_lru;
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, thumbnail_name);
	_tmp5_ = data;
	self->priv->cached_bytes = self->priv->cached_bytes + _tmp5_->bytes;
	while (TRUE) {
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint index = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* victim_name = NULL;
		GeeArrayList* _tmp12_;
		gpointer _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_;
		gchar* _tmp16_;
		GeeHashMap* _tmp17_;
		const gchar* _tmp18_;
		gpointer _tmp19_;
		gint _tmp20_;
		gboolean removed = FALSE;
		GeeHashMap* _tmp21_;
		const gchar* _tmp22_;
		ThumbnailCacheImageData* _tmp23_;
		ThumbnailCacheImageData* _tmp24_;
		if (!(self->priv->cached_bytes > self->priv->max_cached_bytes)) {
			break;
		}
		_tmp6_ = self->priv->cache_lru;
		_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp8_ = _tmp7_;
		_vala_assert (_tmp8_ > 0, "cache_lru.size > 0");
		_tmp9_ = self->priv->cache_lru;
		_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp11_ = _tmp10_;
		index = _tmp11_ - 1;
		_tmp12_ = self->priv->cache_lru;
		_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
		victim_name = (gchar*) _tmp13_;
		_tmp14_ = self->priv->cache_lru;
		_tmp15_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
		_tmp16_ = (gchar*) _tmp15_;
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->cache_map;
		_tmp18_ = victim_name;
		_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
		_thumbnail_cache_image_data_unref0 (data);
		data = (ThumbnailCacheImageData*) _tmp19_;
		_tmp20_ = thumbnail_cache_cycle_overflow_thumbnails;
		thumbnail_cache_cycle_overflow_thumbnails = _tmp20_ + 1;
		thumbnail_cache_schedule_debug ();
		_tmp21_ = self->priv->cache_map;
		_tmp22_ = victim_name;
		removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_, NULL);
		_vala_assert (removed, "removed");
		_tmp23_ = data;
		_vala_assert (_tmp23_->bytes <= self->priv->cached_bytes, "data.bytes <= cached_bytes");
		_tmp24_ = data;
		self->priv->cached_bytes = self->priv->cached_bytes - _tmp24_->bytes;
		_g_free0 (victim_name);
	}
	_thumbnail_cache_image_data_unref0 (data);
}

static gboolean
thumbnail_cache_remove_from_memory (ThumbnailCache* self,
                                    const gchar* thumbnail_name)
{
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ThumbnailCacheImageData* _tmp2_;
	ThumbnailCacheImageData* _tmp3_;
	ThumbnailCacheImageData* _tmp4_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp5_;
	GeeArrayList* _tmp6_;
	gboolean result;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
	g_return_val_if_fail (thumbnail_name != NULL, FALSE);
	_tmp0_ = self->priv->cache_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name);
	data = (ThumbnailCacheImageData*) _tmp1_;
	_tmp2_ = data;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_thumbnail_cache_image_data_unref0 (data);
		return result;
	}
	_tmp3_ = data;
	_vala_assert (self->priv->cached_bytes >= _tmp3_->bytes, "cached_bytes >= data.bytes");
	_tmp4_ = data;
	self->priv->cached_bytes = self->priv->cached_bytes - _tmp4_->bytes;
	_tmp5_ = self->priv->cache_map;
	removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), thumbnail_name, NULL);
	_vala_assert (removed, "removed");
	_tmp6_ = self->priv->cache_lru;
	removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), thumbnail_name);
	_vala_assert (removed, "removed");
	result = TRUE;
	_thumbnail_cache_image_data_unref0 (data);
	return result;
}

static void
thumbnail_cache_save_thumbnail (ThumbnailCache* self,
                                GFile* file,
                                GdkPixbuf* pixbuf,
                                ThumbnailSource* source,
                                GError** error)
{
	PhotoFileWriter* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileWriter* _tmp3_;
	PhotoFileWriter* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_format_create_writer (thumbnail_source_get_preferred_thumbnail_format (source), _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	photo_file_writer_write (_tmp0_, pixbuf, THUMBNAIL_CACHE_DEFAULT_QUALITY, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp0_);
		return;
	}
	_photo_file_adapter_unref0 (_tmp0_);
}

static ThumbnailCacheImageData*
thumbnail_cache_image_data_construct (GType object_type,
                                      GdkPixbuf* pixbuf)
{
	ThumbnailCacheImageData* self = NULL;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	self = (ThumbnailCacheImageData*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->pixbuf);
	self->pixbuf = _tmp0_;
	self->bytes = ((gulong) gdk_pixbuf_get_rowstride (pixbuf)) * ((gulong) gdk_pixbuf_get_height (pixbuf));
	return self;
}

static ThumbnailCacheImageData*
thumbnail_cache_image_data_new (GdkPixbuf* pixbuf)
{
	return thumbnail_cache_image_data_construct (THUMBNAIL_CACHE_TYPE_IMAGE_DATA, pixbuf);
}

static void
thumbnail_cache_value_image_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
thumbnail_cache_value_image_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		thumbnail_cache_image_data_unref (value->data[0].v_pointer);
	}
}

static void
thumbnail_cache_value_image_data_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = thumbnail_cache_image_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
thumbnail_cache_value_image_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
thumbnail_cache_value_image_data_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ThumbnailCacheImageData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = thumbnail_cache_image_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
thumbnail_cache_value_image_data_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	ThumbnailCacheImageData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = thumbnail_cache_image_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
thumbnail_cache_param_spec_image_data (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ThumbnailCacheParamSpecImageData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
thumbnail_cache_value_get_image_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
	return value->data[0].v_pointer;
}

static void
thumbnail_cache_value_set_image_data (GValue* value,
                                      gpointer v_object)
{
	ThumbnailCacheImageData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		thumbnail_cache_image_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnail_cache_image_data_unref (old);
	}
}

static void
thumbnail_cache_value_take_image_data (GValue* value,
                                       gpointer v_object)
{
	ThumbnailCacheImageData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		thumbnail_cache_image_data_unref (old);
	}
}

static void
thumbnail_cache_image_data_class_init (ThumbnailCacheImageDataClass * klass,
                                       gpointer klass_data)
{
	thumbnail_cache_image_data_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailCacheImageDataClass *) klass)->finalize = thumbnail_cache_image_data_finalize;
}

static void
thumbnail_cache_image_data_instance_init (ThumbnailCacheImageData * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
thumbnail_cache_image_data_finalize (ThumbnailCacheImageData * obj)
{
	ThumbnailCacheImageData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData);
	g_signal_handlers_destroy (self);
	thumbnail_cache_cycle_dropped_bytes = thumbnail_cache_cycle_dropped_bytes + self->bytes;
	thumbnail_cache_schedule_debug ();
	_g_object_unref0 (self->pixbuf);
}

static GType
thumbnail_cache_image_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { thumbnail_cache_value_image_data_init, thumbnail_cache_value_image_data_free_value, thumbnail_cache_value_image_data_copy_value, thumbnail_cache_value_image_data_peek_pointer, "p", thumbnail_cache_value_image_data_collect_value, "p", thumbnail_cache_value_image_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheImageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_image_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheImageData), 0, (GInstanceInitFunc) thumbnail_cache_image_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType thumbnail_cache_image_data_type_id;
	thumbnail_cache_image_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThumbnailCacheImageData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return thumbnail_cache_image_data_type_id;
}

static GType
thumbnail_cache_image_data_get_type (void)
{
	static volatile gsize thumbnail_cache_image_data_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_image_data_type_id__once)) {
		GType thumbnail_cache_image_data_type_id;
		thumbnail_cache_image_data_type_id = thumbnail_cache_image_data_get_type_once ();
		g_once_init_leave (&thumbnail_cache_image_data_type_id__once, thumbnail_cache_image_data_type_id);
	}
	return thumbnail_cache_image_data_type_id__once;
}

static gpointer
thumbnail_cache_image_data_ref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
thumbnail_cache_image_data_unref (gpointer instance)
{
	ThumbnailCacheImageData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job,
                                                                      gpointer self)
{
	thumbnail_cache_async_fetch_completion_callback (job);
}

static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_construct (GType object_type,
                                           ThumbnailCache* cache,
                                           const gchar* thumbnail_name,
                                           ThumbnailSource* source,
                                           GdkPixbuf* prefetched,
                                           Dimensions* dim,
                                           GdkInterpType interp,
                                           ThumbnailCacheAsyncFetchCallback callback,
                                           gpointer callback_target,
                                           GCancellable* cancellable)
{
	ThumbnailCacheAsyncFetchJob* self = NULL;
	ThumbnailCache* _tmp0_;
	gchar* _tmp1_;
	ThumbnailSource* _tmp2_;
	GdkPixbuf* _tmp3_;
	Dimensions _tmp4_;
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (cache), NULL);
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
	g_return_val_if_fail ((prefetched == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (prefetched, gdk_pixbuf_get_type ()), NULL);
	g_return_val_if_fail (dim != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (ThumbnailCacheAsyncFetchJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (cache, G_TYPE_OBJECT, GObject), _thumbnail_cache_async_fetch_completion_callback_completion_callback, NULL, cancellable, NULL, NULL, NULL);
	_tmp0_ = _g_object_ref0 (cache);
	_g_object_unref0 (self->cache);
	self->cache = _tmp0_;
	_tmp1_ = g_strdup (thumbnail_name);
	_g_free0 (self->thumbnail_name);
	self->thumbnail_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (source);
	_g_object_unref0 (self->source);
	self->source = _tmp2_;
	self->source_format = thumbnail_source_get_preferred_thumbnail_format (source);
	_tmp3_ = _g_object_ref0 (prefetched);
	_g_object_unref0 (self->unscaled);
	self->unscaled = _tmp3_;
	_tmp4_ = *dim;
	self->dim = _tmp4_;
	self->interp = interp;
	self->callback = callback;
	self->callback_target = callback_target;
	return self;
}

static ThumbnailCacheAsyncFetchJob*
thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache,
                                     const gchar* thumbnail_name,
                                     ThumbnailSource* source,
                                     GdkPixbuf* prefetched,
                                     Dimensions* dim,
                                     GdkInterpType interp,
                                     ThumbnailCacheAsyncFetchCallback callback,
                                     gpointer callback_target,
                                     GCancellable* cancellable)
{
	return thumbnail_cache_async_fetch_job_construct (THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, cache, thumbnail_name, source, prefetched, dim, interp, callback, callback_target, cancellable);
}

static BackgroundJobJobPriority
thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	BackgroundJobJobPriority result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
	switch (self->interp) {
		case GDK_INTERP_NEAREST:
		case GDK_INTERP_TILES:
		{
			result = BACKGROUND_JOB_JOB_PRIORITY_HIGH;
			return result;
		}
		default:
		case GDK_INTERP_BILINEAR:
		case GDK_INTERP_HYPER:
		{
			result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
			return result;
		}
	}
}

static void
thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base)
{
	ThumbnailCacheAsyncFetchJob * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp12_;
		_tmp0_ = self->unscaled;
		if (_tmp0_ == NULL) {
			GdkPixbuf* _tmp1_ = NULL;
			ThumbnailCache* _tmp2_;
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			_tmp2_ = self->cache;
			_tmp3_ = self->thumbnail_name;
			_tmp4_ = thumbnail_cache_read_pixbuf (_tmp2_, _tmp3_, self->source_format, &_inner_error0_);
			_tmp1_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->unscaled);
			self->unscaled = _tmp5_;
			self->fetched = TRUE;
			_g_object_unref0 (_tmp1_);
		}
		if (background_job_is_cancelled (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BACKGROUND_JOB, BackgroundJob))) {
			return;
		}
		if (dimensions_has_area (&self->dim)) {
			GdkPixbuf* _tmp7_;
			Dimensions _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp7_ = self->unscaled;
			_tmp8_ = self->dim;
			_tmp9_ = resize_pixbuf (_tmp7_, &_tmp8_, self->interp);
			_g_object_unref0 (_tmp6_);
			_tmp6_ = _tmp9_;
		} else {
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			_tmp10_ = self->unscaled;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (_tmp6_);
			_tmp6_ = _tmp11_;
		}
		_tmp12_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->scaled);
		self->scaled = _tmp12_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		if (_tmp13_->domain == G_FILE_ERROR) {
			{
				thumbnail_cache_async_fetch_job_generate_thumbnail (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* generr = NULL;
				GError* _tmp14_;
				GError* _tmp15_;
				generr = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = generr;
				_tmp15_ = _g_error_copy0 (_tmp14_);
				_g_error_free0 (err);
				err = _tmp15_;
				_g_error_free0 (generr);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			GError* _tmp16_;
			GError* _tmp17_;
			_tmp16_ = err;
			_tmp17_ = _g_error_copy0 (_tmp16_);
			_g_error_free0 (self->err);
			self->err = _tmp17_;
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self,
                                                    GError** error)
{
	Photo* photo = NULL;
	ThumbnailSource* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	GdkPixbuf* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB (self));
	_tmp0_ = self->source;
	_tmp1_ = _g_object_ref0 (IS_PHOTO (_tmp0_) ? ((Photo*) _tmp0_) : NULL);
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ != NULL) {
		GdkPixbuf* _tmp3_ = NULL;
		Photo* _tmp4_;
		Scaling _tmp5_ = {0};
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		_tmp4_ = photo;
		scaling_for_best_fit (dimensions_major_axis (&self->dim), TRUE, &_tmp5_);
		_tmp6_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (photo);
			return;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->unscaled);
		self->unscaled = _tmp7_;
		_g_object_unref0 (_tmp3_);
	} else {
		Video* video = NULL;
		ThumbnailSource* _tmp8_;
		Video* _tmp9_;
		Video* _tmp10_;
		_tmp8_ = self->source;
		_tmp9_ = _g_object_ref0 (IS_VIDEO (_tmp8_) ? ((Video*) _tmp8_) : NULL);
		video = _tmp9_;
		_tmp10_ = video;
		if (_tmp10_ != NULL) {
			GdkPixbuf* _tmp11_ = NULL;
			Video* _tmp12_;
			Dimensions _tmp13_;
			GdkPixbuf* _tmp14_;
			GdkPixbuf* _tmp15_;
			_tmp12_ = video;
			_tmp13_ = self->dim;
			_tmp14_ = thumbnail_source_create_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp13_.width, &_inner_error0_);
			_tmp11_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (video);
				_g_object_unref0 (photo);
				return;
			}
			_tmp15_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (self->unscaled);
			self->unscaled = _tmp15_;
			_g_object_unref0 (_tmp11_);
		}
		_g_object_unref0 (video);
	}
	_tmp16_ = self->unscaled;
	if (_tmp16_ != NULL) {
		GdkPixbuf* _tmp17_;
		Dimensions _tmp18_;
		GdkPixbuf* _tmp19_;
		_tmp17_ = self->unscaled;
		_tmp18_ = self->dim;
		_tmp19_ = resize_pixbuf (_tmp17_, &_tmp18_, self->interp);
		_g_object_unref0 (self->scaled);
		self->scaled = _tmp19_;
		self->replace = TRUE;
	}
	_g_object_unref0 (photo);
}

static void
thumbnail_cache_async_fetch_job_class_init (ThumbnailCacheAsyncFetchJobClass * klass,
                                            gpointer klass_data)
{
	thumbnail_cache_async_fetch_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = thumbnail_cache_async_fetch_job_finalize;
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*) (BackgroundJob*)) thumbnail_cache_async_fetch_job_real_get_priority;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) thumbnail_cache_async_fetch_job_real_execute;
}

static void
thumbnail_cache_async_fetch_job_instance_init (ThumbnailCacheAsyncFetchJob * self,
                                               gpointer klass)
{
	self->scaled = NULL;
	self->err = NULL;
	self->fetched = FALSE;
	self->replace = FALSE;
}

static void
thumbnail_cache_async_fetch_job_finalize (BackgroundJob * obj)
{
	ThumbnailCacheAsyncFetchJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
	_g_object_unref0 (self->cache);
	_g_free0 (self->thumbnail_name);
	_g_object_unref0 (self->source);
	_g_object_unref0 (self->unscaled);
	_g_object_unref0 (self->scaled);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (thumbnail_cache_async_fetch_job_parent_class)->finalize (obj);
}

static GType
thumbnail_cache_async_fetch_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheAsyncFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_async_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheAsyncFetchJob), 0, (GInstanceInitFunc) thumbnail_cache_async_fetch_job_instance_init, NULL };
	GType thumbnail_cache_async_fetch_job_type_id;
	thumbnail_cache_async_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ThumbnailCacheAsyncFetchJob", &g_define_type_info, 0);
	return thumbnail_cache_async_fetch_job_type_id;
}

static GType
thumbnail_cache_async_fetch_job_get_type (void)
{
	static volatile gsize thumbnail_cache_async_fetch_job_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_async_fetch_job_type_id__once)) {
		GType thumbnail_cache_async_fetch_job_type_id;
		thumbnail_cache_async_fetch_job_type_id = thumbnail_cache_async_fetch_job_get_type_once ();
		g_once_init_leave (&thumbnail_cache_async_fetch_job_type_id__once, thumbnail_cache_async_fetch_job_type_id);
	}
	return thumbnail_cache_async_fetch_job_type_id__once;
}

static void
thumbnail_cache_class_init (ThumbnailCacheClass * klass,
                            gpointer klass_data)
{
	ThumbnailCacheSize* _tmp0_;
	thumbnail_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ThumbnailCache_private_offset);
	G_OBJECT_CLASS (klass)->finalize = thumbnail_cache_finalize;
	_tmp0_ = g_new0 (ThumbnailCacheSize, 3);
	_tmp0_[0] = THUMBNAIL_CACHE_SIZE_LARGE;
	_tmp0_[1] = THUMBNAIL_CACHE_SIZE_BIG;
	_tmp0_[2] = THUMBNAIL_CACHE_SIZE_MEDIUM;
	thumbnail_cache_ALL_SIZES = _tmp0_;
	thumbnail_cache_ALL_SIZES_length1 = 3;
	_thumbnail_cache_ALL_SIZES_size_ = thumbnail_cache_ALL_SIZES_length1;
}

static void
thumbnail_cache_instance_init (ThumbnailCache * self,
                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = thumbnail_cache_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, (GBoxedCopyFunc) thumbnail_cache_image_data_ref, (GDestroyNotify) thumbnail_cache_image_data_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cache_map = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->cache_lru = _tmp1_;
	self->priv->cached_bytes = (gulong) 0;
}

static void
thumbnail_cache_finalize (GObject * obj)
{
	ThumbnailCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
	_g_object_unref0 (self->priv->cache_dir);
	_g_object_unref0 (self->priv->cache_map);
	_g_object_unref0 (self->priv->cache_lru);
	G_OBJECT_CLASS (thumbnail_cache_parent_class)->finalize (obj);
}

static GType
thumbnail_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCache), 0, (GInstanceInitFunc) thumbnail_cache_instance_init, NULL };
	GType thumbnail_cache_type_id;
	thumbnail_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "ThumbnailCache", &g_define_type_info, 0);
	ThumbnailCache_private_offset = g_type_add_instance_private (thumbnail_cache_type_id, sizeof (ThumbnailCachePrivate));
	return thumbnail_cache_type_id;
}

GType
thumbnail_cache_get_type (void)
{
	static volatile gsize thumbnail_cache_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_cache_type_id__once)) {
		GType thumbnail_cache_type_id;
		thumbnail_cache_type_id = thumbnail_cache_get_type_once ();
		g_once_init_leave (&thumbnail_cache_type_id__once, thumbnail_cache_type_id);
	}
	return thumbnail_cache_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

