/* pkcs11-certificate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from pkcs11-certificate.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "seahorse-pkcs11.h"
#include <glib-object.h>
#include <gck/gck.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gcr/gcr-base.h>
#include <p11-kit/pkcs11.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_PKCS11_CERTIFICATE_0_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_ACTIONS_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_DELETABLE_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_ICON_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_LABEL_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_SUBJECT_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_MARKUP_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_ISSUER_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_EXPIRY_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_NUM_PROPERTIES
};
static GParamSpec* seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_NUM_PROPERTIES];
#define _gck_attributes_unref0(var) ((var == NULL) ? NULL : (var = (gck_attributes_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GckBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckBuilder_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _SeahorsePkcs11CertificatePrivate {
	GWeakRef _token;
	GckAttributes* _attributes;
	GckAttribute* _der;
	GWeakRef _private_key;
	GIcon* _icon;
	SeahorseFlags _flags;
};

static gint SeahorsePkcs11Certificate_private_offset;
static gpointer seahorse_pkcs11_certificate_parent_class = NULL;
static guint8* seahorse_pkcs11_certificate_EMPTY;
static gint seahorse_pkcs11_certificate_EMPTY_length1;
static guint8* seahorse_pkcs11_certificate_EMPTY = NULL;
static gint seahorse_pkcs11_certificate_EMPTY_length1 = 0;
static gint _seahorse_pkcs11_certificate_EMPTY_size_ = 0;
static GcrComparableIface * seahorse_pkcs11_certificate_gcr_comparable_parent_iface = NULL;
static GcrCertificateIface * seahorse_pkcs11_certificate_gcr_certificate_parent_iface = NULL;
static GckObjectCacheIface * seahorse_pkcs11_certificate_gck_object_cache_parent_iface = NULL;
static SeahorseDeletableIface * seahorse_pkcs11_certificate_seahorse_deletable_parent_iface = NULL;
static SeahorseExportableIface * seahorse_pkcs11_certificate_seahorse_exportable_parent_iface = NULL;
static SeahorseViewableIface * seahorse_pkcs11_certificate_seahorse_viewable_parent_iface = NULL;

static void seahorse_pkcs11_certificate_real_dispose (GObject* base);
static GtkWindow* seahorse_pkcs11_certificate_real_create_viewer (SeahorseViewable* base,
                                                           GtkWindow* parent);
static SeahorseDeleter* seahorse_pkcs11_certificate_real_create_deleter (SeahorseDeletable* base);
static GList* seahorse_pkcs11_certificate_real_create_exporters (SeahorseExportable* base,
                                                          SeahorseExporterType type);
static void seahorse_pkcs11_certificate_real_fill (GckObjectCache* base,
                                            GckAttributes* attributes);
static void _vala_GckBuilder_free (GckBuilder* self);
static guint8* seahorse_pkcs11_certificate_real_get_der_data (GcrCertificate* base,
                                                       gsize* result_length1);
static gint seahorse_pkcs11_certificate_real_compare (GcrComparable* base,
                                               GcrComparable* other);
static SeahorseFlags seahorse_pkcs11_certificate_calc_is_personal_and_trusted (SeahorsePkcs11Certificate* self);
static void seahorse_pkcs11_certificate_ensure_flags (SeahorsePkcs11Certificate* self);
static GObject * seahorse_pkcs11_certificate_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _seahorse_pkcs11_certificate___lambda10_ (SeahorsePkcs11Certificate* self,
                                               GParamSpec* pspec);
static void __seahorse_pkcs11_certificate___lambda10__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void seahorse_pkcs11_certificate_finalize (GObject * obj);
static GType seahorse_pkcs11_certificate_get_type_once (void);
static void _vala_seahorse_pkcs11_certificate_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_seahorse_pkcs11_certificate_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_pkcs11_certificate_get_instance_private (SeahorsePkcs11Certificate* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorsePkcs11Certificate_private_offset);
}

static void
seahorse_pkcs11_certificate_real_dispose (GObject* base)
{
	SeahorsePkcs11Certificate * self;
	self = (SeahorsePkcs11Certificate*) base;
	seahorse_pkcs11_certificate_set_partner (self, NULL);
	G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gck_object_get_type (), GckObject));
}

static GtkWindow*
seahorse_pkcs11_certificate_real_create_viewer (SeahorseViewable* base,
                                                GtkWindow* parent)
{
	SeahorsePkcs11Certificate * self;
	SeahorsePkcs11Properties* viewer = NULL;
	SeahorsePkcs11Properties* _tmp0_;
	GtkWindow* result;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = seahorse_pkcs11_properties_new ((GckObject*) self, parent);
	g_object_ref_sink (_tmp0_);
	viewer = _tmp0_;
	gtk_widget_show ((GtkWidget*) viewer);
	result = (GtkWindow*) viewer;
	return result;
}

static SeahorseDeleter*
seahorse_pkcs11_certificate_real_create_deleter (SeahorseDeletable* base)
{
	SeahorsePkcs11Certificate * self;
	SeahorseDeleter* deleter = NULL;
	SeahorsePkcs11PrivateKey* key = NULL;
	SeahorsePkcs11PrivateKey* _tmp0_;
	SeahorsePkcs11PrivateKey* _tmp1_;
	SeahorsePkcs11PrivateKey* _tmp2_;
	SeahorseDeleter* result;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = seahorse_pkcs11_certificate_get_partner (self);
	_tmp1_ = _tmp0_;
	key = _tmp1_;
	_tmp2_ = key;
	if (_tmp2_ == NULL) {
		SeahorsePkcs11Deleter* _tmp3_;
		_tmp3_ = seahorse_pkcs11_deleter_new ((GckObject*) self);
		_g_object_unref0 (deleter);
		deleter = (SeahorseDeleter*) _tmp3_;
	} else {
		SeahorsePkcs11PrivateKey* _tmp4_;
		SeahorseDeleter* _tmp5_;
		SeahorseDeleter* _tmp6_;
		_tmp4_ = key;
		_tmp5_ = seahorse_deletable_create_deleter ((SeahorseDeletable*) _tmp4_);
		_g_object_unref0 (deleter);
		deleter = _tmp5_;
		_tmp6_ = deleter;
		if (!seahorse_deleter_add_object (_tmp6_, (GObject*) self)) {
			g_return_val_if_reached (NULL);
		}
	}
	result = deleter;
	_g_object_unref0 (key);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
seahorse_pkcs11_certificate_real_create_exporters (SeahorseExportable* base,
                                                   SeahorseExporterType type)
{
	SeahorsePkcs11Certificate * self;
	GList* exporters = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* result;
	self = (SeahorsePkcs11Certificate*) base;
	exporters = NULL;
	_tmp0_ = seahorse_exportable_get_exportable ((SeahorseExportable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		SeahorseCertificateDerExporter* exporter = NULL;
		SeahorseCertificateDerExporter* _tmp2_;
		SeahorseCertificateDerExporter* _tmp3_;
		SeahorseExporter* _tmp4_;
		_tmp2_ = seahorse_certificate_der_exporter_new ((GcrCertificate*) self);
		exporter = _tmp2_;
		_tmp3_ = exporter;
		_tmp4_ = _g_object_ref0 ((SeahorseExporter*) _tmp3_);
		exporters = g_list_append (exporters, _tmp4_);
		_g_object_unref0 (exporter);
	}
	result = exporters;
	return result;
}

static void
_vala_GckBuilder_free (GckBuilder* self)
{
	g_boxed_free (gck_builder_get_type (), self);
}

static void
seahorse_pkcs11_certificate_real_fill (GckObjectCache* base,
                                       GckAttributes* attributes)
{
	SeahorsePkcs11Certificate * self;
	GckBuilder* builder = NULL;
	GckBuilder* _tmp0_;
	GckAttributes* _tmp1_;
	GckBuilder* _tmp4_;
	GckBuilder* _tmp5_;
	GckAttributes* _tmp6_;
	self = (SeahorsePkcs11Certificate*) base;
	g_return_if_fail (attributes != NULL);
	_tmp0_ = gck_builder_new (GCK_BUILDER_NONE);
	builder = _tmp0_;
	_tmp1_ = self->priv->_attributes;
	if (_tmp1_ != NULL) {
		GckBuilder* _tmp2_;
		GckAttributes* _tmp3_;
		_tmp2_ = builder;
		_tmp3_ = self->priv->_attributes;
		gck_builder_add_all (_tmp2_, _tmp3_);
	}
	_tmp4_ = builder;
	gck_builder_set_all (_tmp4_, attributes);
	_tmp5_ = builder;
	_tmp6_ = gck_builder_steal (_tmp5_);
	_gck_attributes_unref0 (self->priv->_attributes);
	self->priv->_attributes = _tmp6_;
	g_object_notify ((GObject*) self, "attributes");
	__vala_GckBuilder_free0 (builder);
}

static guint8*
seahorse_pkcs11_certificate_real_get_der_data (GcrCertificate* base,
                                               gsize* result_length1)
{
	SeahorsePkcs11Certificate * self;
	GckAttribute* _tmp0_;
	GckAttribute* _tmp3_;
	gsize _tmp4_ = 0;
	guint8* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* result;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_der;
	if (_tmp0_ == NULL) {
		guint8* _tmp1_;
		gint _tmp1__length1;
		guint8* _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = seahorse_pkcs11_certificate_EMPTY;
		_tmp1__length1 = seahorse_pkcs11_certificate_EMPTY_length1;
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _tmp1__length1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->_der;
	_tmp5_ = gck_attribute_get_data (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gint
seahorse_pkcs11_certificate_real_compare (GcrComparable* base,
                                          GcrComparable* other)
{
	SeahorsePkcs11Certificate * self;
	guint8* data1 = NULL;
	gsize _tmp0_ = 0;
	guint8* _tmp1_;
	gint data1_length1;
	gint _data1_size_;
	guint8* data2 = NULL;
	gsize _tmp2_ = 0;
	guint8* _tmp3_;
	gint data2_length1;
	gint _data2_size_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint result;
	self = (SeahorsePkcs11Certificate*) base;
	if (other == NULL) {
		result = -1;
		return result;
	}
	_tmp1_ = gcr_certificate_get_der_data ((GcrCertificate*) self, &_tmp0_);
	data1 = _tmp1_;
	data1_length1 = _tmp0_;
	_data1_size_ = data1_length1;
	_tmp3_ = gcr_certificate_get_der_data (G_TYPE_CHECK_INSTANCE_CAST (other, gcr_certificate_get_type (), GcrCertificate), &_tmp2_);
	data2 = _tmp3_;
	data2_length1 = _tmp2_;
	_data2_size_ = data2_length1;
	_tmp4_ = data1;
	_tmp4__length1 = data1_length1;
	_tmp5_ = data2;
	_tmp5__length1 = data2_length1;
	result = gcr_comparable_memcmp (_tmp4_, (gsize) _tmp4__length1, _tmp5_, (gsize) _tmp5__length1);
	return result;
}

static SeahorseFlags
seahorse_pkcs11_certificate_calc_is_personal_and_trusted (SeahorsePkcs11Certificate* self)
{
	gulong category = 0UL;
	gboolean is_ca = FALSE;
	GObject* _tmp0_;
	GObject* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GckAttributes* _tmp4_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	category = (gulong) 0;
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = SEAHORSE_FLAG_PERSONAL | SEAHORSE_FLAG_TRUSTED;
		return result;
	}
	_tmp4_ = self->priv->_attributes;
	if (_tmp4_ != NULL) {
		GckAttributes* _tmp5_;
		gulong _tmp6_ = 0UL;
		gboolean _tmp7_;
		_tmp5_ = self->priv->_attributes;
		_tmp7_ = gck_attributes_find_ulong (_tmp5_, CKA_CERTIFICATE_CATEGORY, &_tmp6_);
		category = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		if (category == ((gulong) 2)) {
			result = 0;
			return result;
		} else {
			if (category == ((gulong) 1)) {
				result = SEAHORSE_FLAG_PERSONAL;
				return result;
			}
		}
	}
	_tmp9_ = gcr_certificate_get_basic_constraints ((GcrCertificate*) self, &_tmp8_, NULL);
	is_ca = _tmp8_;
	if (_tmp9_) {
		gint _tmp10_ = 0;
		if (is_ca) {
			_tmp10_ = 0;
		} else {
			_tmp10_ = (gint) SEAHORSE_FLAG_PERSONAL;
		}
		result = _tmp10_;
		return result;
	}
	result = SEAHORSE_FLAG_PERSONAL;
	return result;
}

static void
seahorse_pkcs11_certificate_ensure_flags (SeahorsePkcs11Certificate* self)
{
	g_return_if_fail (self != NULL);
	if (((guint) self->priv->_flags) == G_MAXUINT) {
		self->priv->_flags = SEAHORSE_FLAG_EXPORTABLE | seahorse_pkcs11_certificate_calc_is_personal_and_trusted (self);
	}
}

SeahorsePkcs11Certificate*
seahorse_pkcs11_certificate_construct (GType object_type)
{
	SeahorsePkcs11Certificate * self = NULL;
	self = (SeahorsePkcs11Certificate*) g_object_new (object_type, NULL);
	return self;
}

SeahorsePkcs11Certificate*
seahorse_pkcs11_certificate_new (void)
{
	return seahorse_pkcs11_certificate_construct (SEAHORSE_PKCS11_TYPE_CERTIFICATE);
}

SeahorsePkcs11Token*
seahorse_pkcs11_certificate_get_place (SeahorsePkcs11Certificate* self)
{
	SeahorsePkcs11Token* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_token);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	return result;
}

void
seahorse_pkcs11_certificate_set_place (SeahorsePkcs11Certificate* self,
                                       SeahorsePkcs11Token* value)
{
	g_return_if_fail (self != NULL);
	g_weak_ref_set (&self->priv->_token, (GObject*) value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY]);
}

SeahorseFlags
seahorse_pkcs11_certificate_get_object_flags (SeahorsePkcs11Certificate* self)
{
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	seahorse_pkcs11_certificate_ensure_flags (self);
	result = self->priv->_flags;
	return result;
}

GtkActionGroup*
seahorse_pkcs11_certificate_get_actions (SeahorsePkcs11Certificate* self)
{
	GtkActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}

SeahorsePkcs11PrivateKey*
seahorse_pkcs11_certificate_get_partner (SeahorsePkcs11Certificate* self)
{
	SeahorsePkcs11PrivateKey* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey);
	return result;
}

void
seahorse_pkcs11_certificate_set_partner (SeahorsePkcs11Certificate* self,
                                         SeahorsePkcs11PrivateKey* value)
{
	g_return_if_fail (self != NULL);
	g_weak_ref_set (&self->priv->_private_key, (GObject*) value);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = NULL;
	g_object_notify ((GObject*) self, "partner");
	g_object_notify ((GObject*) self, "icon");
	g_object_notify ((GObject*) self, "description");
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY]);
}

static gpointer
_gck_attributes_ref0 (gpointer self)
{
	return self ? gck_attributes_ref (self) : NULL;
}

static GckAttributes*
seahorse_pkcs11_certificate_real_get_attributes (GckObjectCache* base)
{
	GckAttributes* result;
	SeahorsePkcs11Certificate* self;
	GckAttributes* _tmp0_;
	GckAttributes* _tmp1_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_attributes;
	_tmp1_ = _gck_attributes_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
seahorse_pkcs11_certificate_real_set_attributes (GckObjectCache* base,
                                                 GckAttributes* value)
{
	SeahorsePkcs11Certificate* self;
	GckAttributes* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = _gck_attributes_ref0 (value);
	_gck_attributes_unref0 (self->priv->_attributes);
	self->priv->_attributes = _tmp0_;
	g_object_notify ((GObject*) self, "attributes");
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY]);
}

static gboolean
seahorse_pkcs11_certificate_real_get_deletable (SeahorseDeletable* base)
{
	gboolean result;
	SeahorsePkcs11Certificate* self;
	SeahorsePkcs11Token* token = NULL;
	SeahorsePkcs11Token* _tmp0_;
	SeahorsePkcs11Token* _tmp1_;
	SeahorsePkcs11Token* _tmp2_;
	SeahorsePkcs11Token* _tmp3_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = seahorse_pkcs11_certificate_get_place (self);
	_tmp1_ = _tmp0_;
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp3_ = token;
	result = seahorse_pkcs11_token_is_deletable (_tmp3_, (GckObject*) self);
	_g_object_unref0 (token);
	return result;
}

static gboolean
seahorse_pkcs11_certificate_real_get_exportable (SeahorseExportable* base)
{
	gboolean result;
	SeahorsePkcs11Certificate* self;
	GckAttribute* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_der;
	result = _tmp0_ != NULL;
	return result;
}

static GIcon*
seahorse_pkcs11_certificate_real_get_icon (GcrCertificate* base)
{
	GIcon* result;
	SeahorsePkcs11Certificate* self;
	GIcon* _tmp0_;
	GThemedIcon* icon = NULL;
	GThemedIcon* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	gboolean _tmp6_;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_icon;
	if (_tmp0_ != NULL) {
		GIcon* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = self->priv->_icon;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_CERTIFICATE);
	icon = _tmp3_;
	_tmp4_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		GThemedIcon* eicon = NULL;
		GThemedIcon* _tmp7_;
		GEmblem* emblem = NULL;
		GThemedIcon* _tmp8_;
		GEmblem* _tmp9_;
		GThemedIcon* _tmp10_;
		GEmblem* _tmp11_;
		GEmblemedIcon* _tmp12_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_KEY);
		eicon = _tmp7_;
		_tmp8_ = eicon;
		_tmp9_ = g_emblem_new ((GIcon*) _tmp8_);
		emblem = _tmp9_;
		_tmp10_ = icon;
		_tmp11_ = emblem;
		_tmp12_ = (GEmblemedIcon*) g_emblemed_icon_new ((GIcon*) _tmp10_, _tmp11_);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = (GIcon*) _tmp12_;
		_g_object_unref0 (emblem);
		_g_object_unref0 (eicon);
	} else {
		GThemedIcon* _tmp13_;
		GIcon* _tmp14_;
		_tmp13_ = icon;
		_tmp14_ = _g_object_ref0 ((GIcon*) _tmp13_);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp14_;
	}
	_tmp15_ = self->priv->_icon;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	_g_object_unref0 (icon);
	return result;
}

static gchar*
seahorse_pkcs11_certificate_real_get_description (GcrCertificate* base)
{
	gchar* result;
	SeahorsePkcs11Certificate* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	gboolean _tmp2_;
	self = (SeahorsePkcs11Certificate*) base;
	seahorse_pkcs11_certificate_ensure_flags (self);
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Personal certificate and key"));
		result = _tmp3_;
		return result;
	}
	if ((self->priv->_flags & SEAHORSE_FLAG_PERSONAL) == SEAHORSE_FLAG_PERSONAL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Personal certificate"));
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Certificate"));
		result = _tmp5_;
		return result;
	}
}

static gchar*
seahorse_pkcs11_certificate_real_get_label (GcrCertificate* base)
{
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_subject_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}

static gchar*
seahorse_pkcs11_certificate_real_get_subject (GcrCertificate* base)
{
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_subject_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}

static gchar*
seahorse_pkcs11_certificate_real_get_markup (GcrCertificate* base)
{
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_markup_text ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}

static gchar*
seahorse_pkcs11_certificate_real_get_issuer (GcrCertificate* base)
{
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_issuer_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}

static void
seahorse_pkcs11_certificate_real_get_expiry (GcrCertificate* base,
                                             GDate * result)
{
	SeahorsePkcs11Certificate* self;
	GDate* _tmp0_;
	GDate* _tmp1_;
	GDate _tmp2_;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_expiry_date ((GcrCertificate*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *_tmp1_;
	_g_free0 (_tmp1_);
	*result = _tmp2_;
	return;
}

static void
_seahorse_pkcs11_certificate___lambda10_ (SeahorsePkcs11Certificate* self,
                                          GParamSpec* pspec)
{
	const gchar* _tmp0_;
	GckAttributes* _tmp1_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec->name;
	if (g_strcmp0 (_tmp0_, "attributes") != 0) {
		return;
	}
	_tmp1_ = self->priv->_attributes;
	if (_tmp1_ != NULL) {
		GckAttributes* _tmp2_;
		GckAttribute* _tmp3_;
		_tmp2_ = self->priv->_attributes;
		_tmp3_ = gck_attributes_find (_tmp2_, CKA_VALUE);
		self->priv->_der = _tmp3_;
	}
	g_object_notify ((GObject*) self, "label");
	g_object_notify ((GObject*) self, "markup");
	g_object_notify ((GObject*) self, "subject");
	g_object_notify ((GObject*) self, "issuer");
	g_object_notify ((GObject*) self, "expiry");
}

static void
__seahorse_pkcs11_certificate___lambda10__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_seahorse_pkcs11_certificate___lambda10_ ((SeahorsePkcs11Certificate*) self, pspec);
}

static GObject *
seahorse_pkcs11_certificate_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Certificate * self;
	GckAttributes* _tmp0_;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	self->priv->_flags = (SeahorseFlags) G_MAXUINT;
	self->priv->_der = NULL;
	g_weak_ref_clear (&self->priv->_private_key);
	g_weak_ref_init (&self->priv->_private_key, NULL);
	g_weak_ref_clear (&self->priv->_token);
	g_weak_ref_init (&self->priv->_token, NULL);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __seahorse_pkcs11_certificate___lambda10__g_object_notify, self, 0);
	_tmp0_ = self->priv->_attributes;
	if (_tmp0_ != NULL) {
		GckAttributes* _tmp1_;
		GckAttribute* _tmp2_;
		_tmp1_ = self->priv->_attributes;
		_tmp2_ = gck_attributes_find (_tmp1_, CKA_VALUE);
		self->priv->_der = _tmp2_;
	}
	return obj;
}

static void
seahorse_pkcs11_certificate_class_init (SeahorsePkcs11CertificateClass * klass,
                                        gpointer klass_data)
{
	guint8* _tmp0_;
	seahorse_pkcs11_certificate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorsePkcs11Certificate_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_pkcs11_certificate_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_certificate_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_certificate_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_certificate_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_certificate_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY] = g_param_spec_object ("place", "place", "place", SEAHORSE_PKCS11_TYPE_TOKEN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS_PROPERTY] = g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ACTIONS_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", gtk_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY] = g_param_spec_object ("partner", "partner", "partner", SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY] = g_param_spec_boxed ("attributes", "attributes", "attributes", gck_attributes_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_DELETABLE_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_DELETABLE_PROPERTY] = g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE_PROPERTY] = g_param_spec_boolean ("exportable", "exportable", "exportable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ICON_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_LABEL_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_SUBJECT_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_SUBJECT_PROPERTY] = g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_MARKUP_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_MARKUP_PROPERTY] = g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ISSUER_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_ISSUER_PROPERTY] = g_param_spec_string ("issuer", "issuer", "issuer", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_EXPIRY_PROPERTY, seahorse_pkcs11_certificate_properties[SEAHORSE_PKCS11_CERTIFICATE_EXPIRY_PROPERTY] = g_param_spec_boxed ("expiry", "expiry", "expiry", G_TYPE_DATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_new0 (guint8, 0);
	seahorse_pkcs11_certificate_EMPTY = _tmp0_;
	seahorse_pkcs11_certificate_EMPTY_length1 = 0;
	_seahorse_pkcs11_certificate_EMPTY_size_ = seahorse_pkcs11_certificate_EMPTY_length1;
}

static void
seahorse_pkcs11_certificate_gcr_comparable_interface_init (GcrComparableIface * iface,
                                                           gpointer iface_data)
{
	seahorse_pkcs11_certificate_gcr_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare = (gint (*) (GcrComparable*, GcrComparable*)) seahorse_pkcs11_certificate_real_compare;
}

static void
seahorse_pkcs11_certificate_gcr_certificate_interface_init (GcrCertificateIface * iface,
                                                            gpointer iface_data)
{
	seahorse_pkcs11_certificate_gcr_certificate_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_der_data = (guint8* (*) (GcrCertificate*, gsize*)) seahorse_pkcs11_certificate_real_get_der_data;
}

static void
seahorse_pkcs11_certificate_gck_object_cache_interface_init (GckObjectCacheIface * iface,
                                                             gpointer iface_data)
{
	seahorse_pkcs11_certificate_gck_object_cache_parent_iface = g_type_interface_peek_parent (iface);
	iface->fill = (void (*) (GckObjectCache*, GckAttributes*)) seahorse_pkcs11_certificate_real_fill;
}

static void
seahorse_pkcs11_certificate_seahorse_deletable_interface_init (SeahorseDeletableIface * iface,
                                                               gpointer iface_data)
{
	seahorse_pkcs11_certificate_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*) (SeahorseDeletable*)) seahorse_pkcs11_certificate_real_create_deleter;
	iface->get_deletable = seahorse_pkcs11_certificate_real_get_deletable;
}

static void
seahorse_pkcs11_certificate_seahorse_exportable_interface_init (SeahorseExportableIface * iface,
                                                                gpointer iface_data)
{
	seahorse_pkcs11_certificate_seahorse_exportable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_exporters = (GList* (*) (SeahorseExportable*, SeahorseExporterType)) seahorse_pkcs11_certificate_real_create_exporters;
	iface->get_exportable = seahorse_pkcs11_certificate_real_get_exportable;
}

static void
seahorse_pkcs11_certificate_seahorse_viewable_interface_init (SeahorseViewableIface * iface,
                                                              gpointer iface_data)
{
	seahorse_pkcs11_certificate_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*) (SeahorseViewable*, GtkWindow*)) seahorse_pkcs11_certificate_real_create_viewer;
}

static void
seahorse_pkcs11_certificate_instance_init (SeahorsePkcs11Certificate * self,
                                           gpointer klass)
{
	self->priv = seahorse_pkcs11_certificate_get_instance_private (self);
}

static void
seahorse_pkcs11_certificate_finalize (GObject * obj)
{
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	g_weak_ref_clear (&self->priv->_token);
	_gck_attributes_unref0 (self->priv->_attributes);
	g_weak_ref_clear (&self->priv->_private_key);
	_g_object_unref0 (self->priv->_icon);
	G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_certificate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11CertificateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_certificate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Certificate), 0, (GInstanceInitFunc) seahorse_pkcs11_certificate_instance_init, NULL };
	static const GInterfaceInfo gcr_comparable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gcr_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gcr_certificate_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gcr_certificate_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gck_object_cache_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gck_object_cache_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_exportable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_exportable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_pkcs11_certificate_type_id;
	seahorse_pkcs11_certificate_type_id = g_type_register_static (gck_object_get_type (), "SeahorsePkcs11Certificate", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gcr_comparable_get_type (), &gcr_comparable_info);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gcr_certificate_get_type (), &gcr_certificate_info);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gck_object_cache_get_type (), &gck_object_cache_info);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_EXPORTABLE, &seahorse_exportable_info);
	g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
	SeahorsePkcs11Certificate_private_offset = g_type_add_instance_private (seahorse_pkcs11_certificate_type_id, sizeof (SeahorsePkcs11CertificatePrivate));
	return seahorse_pkcs11_certificate_type_id;
}

GType
seahorse_pkcs11_certificate_get_type (void)
{
	static volatile gsize seahorse_pkcs11_certificate_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_certificate_type_id__once)) {
		GType seahorse_pkcs11_certificate_type_id;
		seahorse_pkcs11_certificate_type_id = seahorse_pkcs11_certificate_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_certificate_type_id__once, seahorse_pkcs11_certificate_type_id);
	}
	return seahorse_pkcs11_certificate_type_id__once;
}

static void
_vala_seahorse_pkcs11_certificate_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	switch (property_id) {
		case SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY:
		g_value_take_object (value, seahorse_pkcs11_certificate_get_place (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS_PROPERTY:
		g_value_set_flags (value, seahorse_pkcs11_certificate_get_object_flags (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ACTIONS_PROPERTY:
		g_value_set_object (value, seahorse_pkcs11_certificate_get_actions (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY:
		g_value_take_object (value, seahorse_pkcs11_certificate_get_partner (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY:
		g_value_take_boxed (value, seahorse_pkcs11_certificate_real_get_attributes ((GckObjectCache*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_DELETABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_exportable_get_exportable ((SeahorseExportable*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ICON_PROPERTY:
		g_value_take_object (value, seahorse_pkcs11_certificate_real_get_icon ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION_PROPERTY:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_description ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_LABEL_PROPERTY:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_label ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_SUBJECT_PROPERTY:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_subject ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_MARKUP_PROPERTY:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_markup ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ISSUER_PROPERTY:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_issuer ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_EXPIRY_PROPERTY:
		{
			GDate boxed;
			seahorse_pkcs11_certificate_real_get_expiry ((GcrCertificate*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_pkcs11_certificate_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	switch (property_id) {
		case SEAHORSE_PKCS11_CERTIFICATE_PLACE_PROPERTY:
		seahorse_pkcs11_certificate_set_place (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_PARTNER_PROPERTY:
		seahorse_pkcs11_certificate_set_partner (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES_PROPERTY:
		seahorse_pkcs11_certificate_real_set_attributes ((GckObjectCache*) self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

