/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_winreg.h"
#include "bin/default/librpc/gen_ndr/ndr_winreg_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* winreg - dcerpc server boilerplate generated by pidl */
static NTSTATUS winreg__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINREG_BIND
	return DCESRV_INTERFACE_WINREG_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void winreg__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINREG_UNBIND
	DCESRV_INTERFACE_WINREG_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS winreg__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_winreg.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_winreg.calls[opnum].struct_size, "struct %s", ndr_table_winreg.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_winreg.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS winreg__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* winreg_OpenHKCR */
		struct winreg_OpenHKCR *r2 = (struct winreg_OpenHKCR *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCR, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKCR(p, r2);
		break;
	}
	case 1: { /* winreg_OpenHKCU */
		struct winreg_OpenHKCU *r2 = (struct winreg_OpenHKCU *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCU, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKCU(p, r2);
		break;
	}
	case 2: { /* winreg_OpenHKLM */
		struct winreg_OpenHKLM *r2 = (struct winreg_OpenHKLM *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKLM, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKLM(p, r2);
		break;
	}
	case 3: { /* winreg_OpenHKPD */
		struct winreg_OpenHKPD *r2 = (struct winreg_OpenHKPD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPD, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKPD(p, r2);
		break;
	}
	case 4: { /* winreg_OpenHKU */
		struct winreg_OpenHKU *r2 = (struct winreg_OpenHKU *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKU, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKU(p, r2);
		break;
	}
	case 5: { /* winreg_CloseKey */
		struct winreg_CloseKey *r2 = (struct winreg_CloseKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CloseKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _winreg_CloseKey(p, r2);
		break;
	}
	case 6: { /* winreg_CreateKey */
		struct winreg_CreateKey *r2 = (struct winreg_CreateKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CreateKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.action_taken = r2->in.action_taken;
		r2->out.new_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.new_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_CreateKey(p, r2);
		break;
	}
	case 7: { /* winreg_DeleteKey */
		struct winreg_DeleteKey *r2 = (struct winreg_DeleteKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_DeleteKey(p, r2);
		break;
	}
	case 8: { /* winreg_DeleteValue */
		struct winreg_DeleteValue *r2 = (struct winreg_DeleteValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteValue, NDR_IN, r2);
		}
		r2->out.result = _winreg_DeleteValue(p, r2);
		break;
	}
	case 9: { /* winreg_EnumKey */
		struct winreg_EnumKey *r2 = (struct winreg_EnumKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.name = r2->in.name;
		r2->out.keyclass = r2->in.keyclass;
		r2->out.last_changed_time = r2->in.last_changed_time;
		r2->out.result = _winreg_EnumKey(p, r2);
		break;
	}
	case 10: { /* winreg_EnumValue */
		struct winreg_EnumValue *r2 = (struct winreg_EnumValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumValue, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.name = r2->in.name;
		r2->out.type = r2->in.type;
		r2->out.value = r2->in.value;
		r2->out.size = r2->in.size;
		r2->out.length = r2->in.length;
		r2->out.result = _winreg_EnumValue(p, r2);
		break;
	}
	case 11: { /* winreg_FlushKey */
		struct winreg_FlushKey *r2 = (struct winreg_FlushKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_FlushKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_FlushKey(p, r2);
		break;
	}
	case 12: { /* winreg_GetKeySecurity */
		struct winreg_GetKeySecurity *r2 = (struct winreg_GetKeySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetKeySecurity, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sd = r2->in.sd;
		r2->out.result = _winreg_GetKeySecurity(p, r2);
		break;
	}
	case 13: { /* winreg_LoadKey */
		struct winreg_LoadKey *r2 = (struct winreg_LoadKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_LoadKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_LoadKey(p, r2);
		break;
	}
	case 14: { /* winreg_NotifyChangeKeyValue */
		struct winreg_NotifyChangeKeyValue *r2 = (struct winreg_NotifyChangeKeyValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_NotifyChangeKeyValue, NDR_IN, r2);
		}
		r2->out.result = _winreg_NotifyChangeKeyValue(p, r2);
		break;
	}
	case 15: { /* winreg_OpenKey */
		struct winreg_OpenKey *r2 = (struct winreg_OpenKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenKey(p, r2);
		break;
	}
	case 16: { /* winreg_QueryInfoKey */
		struct winreg_QueryInfoKey *r2 = (struct winreg_QueryInfoKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryInfoKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.classname = r2->in.classname;
		r2->out.num_subkeys = talloc_zero(r2, uint32_t);
		if (r2->out.num_subkeys == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.max_subkeylen = talloc_zero(r2, uint32_t);
		if (r2->out.max_subkeylen == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.max_classlen = talloc_zero(r2, uint32_t);
		if (r2->out.max_classlen == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.num_values = talloc_zero(r2, uint32_t);
		if (r2->out.num_values == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.max_valnamelen = talloc_zero(r2, uint32_t);
		if (r2->out.max_valnamelen == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.max_valbufsize = talloc_zero(r2, uint32_t);
		if (r2->out.max_valbufsize == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.secdescsize = talloc_zero(r2, uint32_t);
		if (r2->out.secdescsize == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.last_changed_time = talloc_zero(r2, NTTIME);
		if (r2->out.last_changed_time == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_QueryInfoKey(p, r2);
		break;
	}
	case 17: { /* winreg_QueryValue */
		struct winreg_QueryValue *r2 = (struct winreg_QueryValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryValue, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = r2->in.type;
		r2->out.data = r2->in.data;
		r2->out.data_size = r2->in.data_size;
		r2->out.data_length = r2->in.data_length;
		r2->out.result = _winreg_QueryValue(p, r2);
		break;
	}
	case 18: { /* winreg_ReplaceKey */
		struct winreg_ReplaceKey *r2 = (struct winreg_ReplaceKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_ReplaceKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_ReplaceKey(p, r2);
		break;
	}
	case 19: { /* winreg_RestoreKey */
		struct winreg_RestoreKey *r2 = (struct winreg_RestoreKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_RestoreKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_RestoreKey(p, r2);
		break;
	}
	case 20: { /* winreg_SaveKey */
		struct winreg_SaveKey *r2 = (struct winreg_SaveKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_SaveKey(p, r2);
		break;
	}
	case 21: { /* winreg_SetKeySecurity */
		struct winreg_SetKeySecurity *r2 = (struct winreg_SetKeySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetKeySecurity, NDR_IN, r2);
		}
		r2->out.result = _winreg_SetKeySecurity(p, r2);
		break;
	}
	case 22: { /* winreg_SetValue */
		struct winreg_SetValue *r2 = (struct winreg_SetValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetValue, NDR_IN, r2);
		}
		r2->out.result = _winreg_SetValue(p, r2);
		break;
	}
	case 23: { /* winreg_UnLoadKey */
		struct winreg_UnLoadKey *r2 = (struct winreg_UnLoadKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_UnLoadKey, NDR_IN, r2);
		}
		r2->out.result = _winreg_UnLoadKey(p, r2);
		break;
	}
	case 24: { /* winreg_InitiateSystemShutdown */
		struct winreg_InitiateSystemShutdown *r2 = (struct winreg_InitiateSystemShutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdown, NDR_IN, r2);
		}
		r2->out.result = _winreg_InitiateSystemShutdown(p, r2);
		break;
	}
	case 25: { /* winreg_AbortSystemShutdown */
		struct winreg_AbortSystemShutdown *r2 = (struct winreg_AbortSystemShutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_AbortSystemShutdown, NDR_IN, r2);
		}
		r2->out.result = _winreg_AbortSystemShutdown(p, r2);
		break;
	}
	case 26: { /* winreg_GetVersion */
		struct winreg_GetVersion *r2 = (struct winreg_GetVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetVersion, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.version = talloc_zero(r2, uint32_t);
		if (r2->out.version == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_GetVersion(p, r2);
		break;
	}
	case 27: { /* winreg_OpenHKCC */
		struct winreg_OpenHKCC *r2 = (struct winreg_OpenHKCC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKCC(p, r2);
		break;
	}
	case 28: { /* winreg_OpenHKDD */
		struct winreg_OpenHKDD *r2 = (struct winreg_OpenHKDD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKDD, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKDD(p, r2);
		break;
	}
	case 29: { /* winreg_QueryMultipleValues */
		struct winreg_QueryMultipleValues *r2 = (struct winreg_QueryMultipleValues *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = r2->in.buffer;
		r2->out.buffer_size = r2->in.buffer_size;
		r2->out.values_out = talloc_zero_array(r2, struct QueryMultipleValue, r2->in.num_values);
		if (r2->out.values_out == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_QueryMultipleValues(p, r2);
		break;
	}
	case 30: { /* winreg_InitiateSystemShutdownEx */
		struct winreg_InitiateSystemShutdownEx *r2 = (struct winreg_InitiateSystemShutdownEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdownEx, NDR_IN, r2);
		}
		r2->out.result = _winreg_InitiateSystemShutdownEx(p, r2);
		break;
	}
	case 31: { /* winreg_SaveKeyEx */
		struct winreg_SaveKeyEx *r2 = (struct winreg_SaveKeyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKeyEx, NDR_IN, r2);
		}
		r2->out.result = _winreg_SaveKeyEx(p, r2);
		break;
	}
	case 32: { /* winreg_OpenHKPT */
		struct winreg_OpenHKPT *r2 = (struct winreg_OpenHKPT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPT, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKPT(p, r2);
		break;
	}
	case 33: { /* winreg_OpenHKPN */
		struct winreg_OpenHKPN *r2 = (struct winreg_OpenHKPN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPN, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_OpenHKPN(p, r2);
		break;
	}
	case 34: { /* winreg_QueryMultipleValues2 */
		struct winreg_QueryMultipleValues2 *r2 = (struct winreg_QueryMultipleValues2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = r2->in.buffer;
		r2->out.values_out = talloc_zero_array(r2, struct QueryMultipleValue, r2->in.num_values);
		if (r2->out.values_out == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winreg_QueryMultipleValues2(p, r2);
		break;
	}
	case 35: { /* winreg_DeleteKeyEx */
		struct winreg_DeleteKeyEx *r2 = (struct winreg_DeleteKeyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKeyEx, NDR_IN, r2);
		}
		r2->out.result = _winreg_DeleteKeyEx(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS winreg__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return winreg__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS winreg__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* winreg_OpenHKCR */
		struct winreg_OpenHKCR *r2 = (struct winreg_OpenHKCR *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCR replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCR, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKCR\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* winreg_OpenHKCU */
		struct winreg_OpenHKCU *r2 = (struct winreg_OpenHKCU *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCU replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCU, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKCU\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* winreg_OpenHKLM */
		struct winreg_OpenHKLM *r2 = (struct winreg_OpenHKLM *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKLM replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKLM, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKLM\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* winreg_OpenHKPD */
		struct winreg_OpenHKPD *r2 = (struct winreg_OpenHKPD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKPD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* winreg_OpenHKU */
		struct winreg_OpenHKU *r2 = (struct winreg_OpenHKU *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKU replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKU, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKU\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* winreg_CloseKey */
		struct winreg_CloseKey *r2 = (struct winreg_CloseKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CloseKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CloseKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_CloseKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* winreg_CreateKey */
		struct winreg_CreateKey *r2 = (struct winreg_CreateKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CreateKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CreateKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_CreateKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* winreg_DeleteKey */
		struct winreg_DeleteKey *r2 = (struct winreg_DeleteKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_DeleteKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* winreg_DeleteValue */
		struct winreg_DeleteValue *r2 = (struct winreg_DeleteValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_DeleteValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* winreg_EnumKey */
		struct winreg_EnumKey *r2 = (struct winreg_EnumKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_EnumKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* winreg_EnumValue */
		struct winreg_EnumValue *r2 = (struct winreg_EnumValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_EnumValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* winreg_FlushKey */
		struct winreg_FlushKey *r2 = (struct winreg_FlushKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_FlushKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_FlushKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_FlushKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* winreg_GetKeySecurity */
		struct winreg_GetKeySecurity *r2 = (struct winreg_GetKeySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetKeySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetKeySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_GetKeySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* winreg_LoadKey */
		struct winreg_LoadKey *r2 = (struct winreg_LoadKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_LoadKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_LoadKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_LoadKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* winreg_NotifyChangeKeyValue */
		struct winreg_NotifyChangeKeyValue *r2 = (struct winreg_NotifyChangeKeyValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_NotifyChangeKeyValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_NotifyChangeKeyValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_NotifyChangeKeyValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* winreg_OpenKey */
		struct winreg_OpenKey *r2 = (struct winreg_OpenKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* winreg_QueryInfoKey */
		struct winreg_QueryInfoKey *r2 = (struct winreg_QueryInfoKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryInfoKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryInfoKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_QueryInfoKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* winreg_QueryValue */
		struct winreg_QueryValue *r2 = (struct winreg_QueryValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_QueryValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* winreg_ReplaceKey */
		struct winreg_ReplaceKey *r2 = (struct winreg_ReplaceKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_ReplaceKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_ReplaceKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_ReplaceKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* winreg_RestoreKey */
		struct winreg_RestoreKey *r2 = (struct winreg_RestoreKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_RestoreKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_RestoreKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_RestoreKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* winreg_SaveKey */
		struct winreg_SaveKey *r2 = (struct winreg_SaveKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_SaveKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* winreg_SetKeySecurity */
		struct winreg_SetKeySecurity *r2 = (struct winreg_SetKeySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetKeySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetKeySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_SetKeySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* winreg_SetValue */
		struct winreg_SetValue *r2 = (struct winreg_SetValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_SetValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* winreg_UnLoadKey */
		struct winreg_UnLoadKey *r2 = (struct winreg_UnLoadKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_UnLoadKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_UnLoadKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_UnLoadKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* winreg_InitiateSystemShutdown */
		struct winreg_InitiateSystemShutdown *r2 = (struct winreg_InitiateSystemShutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_InitiateSystemShutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* winreg_AbortSystemShutdown */
		struct winreg_AbortSystemShutdown *r2 = (struct winreg_AbortSystemShutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_AbortSystemShutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_AbortSystemShutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_AbortSystemShutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* winreg_GetVersion */
		struct winreg_GetVersion *r2 = (struct winreg_GetVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_GetVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* winreg_OpenHKCC */
		struct winreg_OpenHKCC *r2 = (struct winreg_OpenHKCC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKCC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* winreg_OpenHKDD */
		struct winreg_OpenHKDD *r2 = (struct winreg_OpenHKDD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKDD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKDD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKDD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* winreg_QueryMultipleValues */
		struct winreg_QueryMultipleValues *r2 = (struct winreg_QueryMultipleValues *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_QueryMultipleValues\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* winreg_InitiateSystemShutdownEx */
		struct winreg_InitiateSystemShutdownEx *r2 = (struct winreg_InitiateSystemShutdownEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdownEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdownEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_InitiateSystemShutdownEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* winreg_SaveKeyEx */
		struct winreg_SaveKeyEx *r2 = (struct winreg_SaveKeyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKeyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKeyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_SaveKeyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* winreg_OpenHKPT */
		struct winreg_OpenHKPT *r2 = (struct winreg_OpenHKPT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKPT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* winreg_OpenHKPN */
		struct winreg_OpenHKPN *r2 = (struct winreg_OpenHKPN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_OpenHKPN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* winreg_QueryMultipleValues2 */
		struct winreg_QueryMultipleValues2 *r2 = (struct winreg_QueryMultipleValues2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_QueryMultipleValues2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* winreg_DeleteKeyEx */
		struct winreg_DeleteKeyEx *r2 = (struct winreg_DeleteKeyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteKeyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKeyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winreg_DeleteKeyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS winreg__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_winreg.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS winreg__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return winreg__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_winreg_interface = {
	.name      = "winreg",
	.syntax_id = {{0x338cd001,0x2244,0x31f1,{0xaa,0xaa},{0x90,0x00,0x38,0x00,0x10,0x03}},1.0},
	.bind      = winreg__op_bind,
	.unbind    = winreg__op_unbind,
	.ndr_pull  = winreg__op_ndr_pull,
	.dispatch  = winreg__op_dispatch,
	.reply     = winreg__op_reply,
	.ndr_push  = winreg__op_ndr_push,
	.local     = winreg__op_local,
#ifdef DCESRV_INTERFACE_WINREG_FLAGS
	.flags     = DCESRV_INTERFACE_WINREG_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS winreg__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_WINREG_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_WINREG_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_winreg.endpoints->count;i++) {
		const char *name = ndr_table_winreg.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_winreg_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS winreg__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool winreg__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_winreg_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_winreg_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_winreg_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool winreg__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_winreg_interface.name, name)==0) {
		memcpy(iface, &dcesrv_winreg_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server winreg_ep_server = {
	/* fill in our name */
	.name = "winreg",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_WINREG_INIT_SERVER
	.init_server = DCESRV_INTERFACE_WINREG_INIT_SERVER,
#else
	.init_server = winreg__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_WINREG_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_WINREG_SHUTDOWN_SERVER,
#else
	.shutdown_server = winreg__op_shutdown_server,
#endif
	.interface_by_uuid = winreg__op_interface_by_uuid,
	.interface_by_name = winreg__op_interface_by_name
};

const struct dcesrv_endpoint_server *winreg_get_ep_server(void)
{
	return &winreg_ep_server;
}
