/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Plan200Response {
    /// the routing query
    #[serde(rename = "requestParameters")]
    pub request_parameters: std::collections::HashMap<String, String>,
    /// debug statistics
    #[serde(rename = "debugOutput")]
    pub debug_output: std::collections::HashMap<String, i32>,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// Direct trips by `WALK`, `BIKE`, `CAR`, etc. without time-dependency. The starting time (`arriveBy=false`) / arrival time (`arriveBy=true`) is always the queried `time` parameter (set to \\\"now\\\" if not set). But all `direct` connections are meant to be independent of absolute times. 
    #[serde(rename = "direct")]
    pub direct: Vec<models::Itinerary>,
    /// list of itineraries
    #[serde(rename = "itineraries")]
    pub itineraries: Vec<models::Itinerary>,
    /// Use the cursor to get the previous page of results. Insert the cursor into the request and post it to get the previous page. The previous page is a set of itineraries departing BEFORE the first itinerary in the result for a depart after search. When using the default sort order the previous set of itineraries is inserted before the current result. 
    #[serde(rename = "previousPageCursor")]
    pub previous_page_cursor: String,
    /// Use the cursor to get the next page of results. Insert the cursor into the request and post it to get the next page. The next page is a set of itineraries departing AFTER the last itinerary in this result. 
    #[serde(rename = "nextPageCursor")]
    pub next_page_cursor: String,
}

impl Plan200Response {
    pub fn new(request_parameters: std::collections::HashMap<String, String>, debug_output: std::collections::HashMap<String, i32>, from: models::Place, to: models::Place, direct: Vec<models::Itinerary>, itineraries: Vec<models::Itinerary>, previous_page_cursor: String, next_page_cursor: String) -> Plan200Response {
        Plan200Response {
            request_parameters,
            debug_output,
            from: Box::new(from),
            to: Box::new(to),
            direct,
            itineraries,
            previous_page_cursor,
            next_page_cursor,
        }
    }
}

