/* score.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from score.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgnome-games-support.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_SCORES_SCORE_0_PROPERTY,
	GAMES_SCORES_SCORE_SCORE_PROPERTY,
	GAMES_SCORES_SCORE_TIME_PROPERTY,
	GAMES_SCORES_SCORE_USER_PROPERTY,
	GAMES_SCORES_SCORE_NUM_PROPERTIES
};
static GParamSpec* games_scores_score_properties[GAMES_SCORES_SCORE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GamesScoresScorePrivate {
	glong _score;
	gint64 _time;
	gchar* _user;
};

static gint GamesScoresScore_private_offset;
static gpointer games_scores_score_parent_class = NULL;

VALA_EXTERN gint games_scores_score_score_greater_sorter (GamesScoresScore* a,
                                              GamesScoresScore* b);
VALA_EXTERN gint games_scores_score_score_less_sorter (GamesScoresScore* a,
                                           GamesScoresScore* b);
static void games_scores_score_finalize (GObject * obj);
static GType games_scores_score_get_type_once (void);
static void _vala_games_scores_score_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_games_scores_score_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
games_scores_score_get_instance_private (GamesScoresScore* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresScore_private_offset);
}

/**
     * Creates a new Score.
     *
     * If ``time`` is set to 0, it will be set to the current time.
     *
     * If ``user`` is null, it will automatically be set to the
     * current user's real name.
     *
     */
GamesScoresScore*
games_scores_score_construct (GType object_type,
                              glong score,
                              gint64 time,
                              const gchar* user)
{
	GamesScoresScore * self = NULL;
	self = (GamesScoresScore*) g_object_new (object_type, "score", score, "time", time, "user", user, NULL);
	return self;
}

GamesScoresScore*
games_scores_score_new (glong score,
                        gint64 time,
                        const gchar* user)
{
	return games_scores_score_construct (GAMES_SCORES_TYPE_SCORE, score, time, user);
}

/**
     * Returns true if the scores are equal.
     *
     * Every field in both of the scores must be equal for this to return true.
     *
     */
gboolean
games_scores_score_equals (GamesScoresScore* a,
                           GamesScoresScore* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	glong _tmp2_;
	glong _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp2_ = a->priv->_score;
	_tmp3_ = b->priv->_score;
	if (_tmp2_ == _tmp3_) {
		gint64 _tmp4_;
		gint64 _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		_tmp4_ = games_scores_score_get_time (a);
		_tmp5_ = _tmp4_;
		_tmp6_ = games_scores_score_get_time (b);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp5_ == _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = games_scores_score_get_user (a);
		_tmp9_ = _tmp8_;
		_tmp10_ = games_scores_score_get_user (b);
		_tmp11_ = _tmp10_;
		_tmp0_ = g_strcmp0 (_tmp9_, _tmp11_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gint
games_scores_score_score_greater_sorter (GamesScoresScore* a,
                                         GamesScoresScore* b)
{
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->priv->_score;
	_tmp1_ = b->priv->_score;
	_tmp2_ = a->priv->_score;
	_tmp3_ = b->priv->_score;
	result = ((gint) (_tmp0_ < _tmp1_)) - ((gint) (_tmp2_ > _tmp3_));
	return result;
}

gint
games_scores_score_score_less_sorter (GamesScoresScore* a,
                                      GamesScoresScore* b)
{
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->priv->_score;
	_tmp1_ = b->priv->_score;
	_tmp2_ = a->priv->_score;
	_tmp3_ = b->priv->_score;
	result = ((gint) (_tmp0_ > _tmp1_)) - ((gint) (_tmp2_ < _tmp3_));
	return result;
}

glong
games_scores_score_get_score (GamesScoresScore* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_score;
	return result;
}

void
games_scores_score_set_score (GamesScoresScore* self,
                              glong value)
{
	glong old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_score_get_score (self);
	if (old_value != value) {
		self->priv->_score = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_score_properties[GAMES_SCORES_SCORE_SCORE_PROPERTY]);
	}
}

gint64
games_scores_score_get_time (GamesScoresScore* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_time;
	return result;
}

void
games_scores_score_set_time (GamesScoresScore* self,
                             gint64 value)
{
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	if (value == ((gint64) 0)) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = g_date_time_new_now_local ();
		_tmp2_ = _tmp1_;
		_tmp0_ = g_date_time_to_unix (_tmp2_);
		_g_date_time_unref0 (_tmp2_);
	} else {
		_tmp0_ = value;
	}
	self->priv->_time = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, games_scores_score_properties[GAMES_SCORES_SCORE_TIME_PROPERTY]);
}

const gchar*
games_scores_score_get_user (GamesScoresScore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

void
games_scores_score_set_user (GamesScoresScore* self,
                             const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = g_get_real_name ();
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = value;
	}
	_tmp2_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_user);
	self->priv->_user = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, games_scores_score_properties[GAMES_SCORES_SCORE_USER_PROPERTY]);
}

static void
games_scores_score_class_init (GamesScoresScoreClass * klass,
                               gpointer klass_data)
{
	games_scores_score_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresScore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_score_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_score_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_scores_score_finalize;
	/**
	     * The amount of points or time that a user has achieved.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_SCORE_SCORE_PROPERTY, games_scores_score_properties[GAMES_SCORES_SCORE_SCORE_PROPERTY] = g_param_spec_long ("score", "score", "score", G_MINLONG, G_MAXLONG, 0L, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Although the scores dialog does not currently display the time a
	     * score was achieved, it did in the past and it might again in the future.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_SCORE_TIME_PROPERTY, games_scores_score_properties[GAMES_SCORES_SCORE_TIME_PROPERTY] = g_param_spec_int64 ("time", "time", "time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The player who achieved the score.
	     *
	     * If ``user`` is set to null, it will automatically be set to the current User's real name.
	     *
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_SCORE_USER_PROPERTY, games_scores_score_properties[GAMES_SCORES_SCORE_USER_PROPERTY] = g_param_spec_string ("user", "user", "user", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_scores_score_instance_init (GamesScoresScore * self,
                                  gpointer klass)
{
	self->priv = games_scores_score_get_instance_private (self);
}

static void
games_scores_score_finalize (GObject * obj)
{
	GamesScoresScore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_SCORE, GamesScoresScore);
	_g_free0 (self->priv->_user);
	G_OBJECT_CLASS (games_scores_score_parent_class)->finalize (obj);
}

/**
 * An object used for storing a score and some data about it.
 * This is usually only used inside of libgnome-games-support.
 *
 */
static GType
games_scores_score_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresScoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_score_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresScore), 0, (GInstanceInitFunc) games_scores_score_instance_init, NULL };
	GType games_scores_score_type_id;
	games_scores_score_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesScoresScore", &g_define_type_info, 0);
	GamesScoresScore_private_offset = g_type_add_instance_private (games_scores_score_type_id, sizeof (GamesScoresScorePrivate));
	return games_scores_score_type_id;
}

GType
games_scores_score_get_type (void)
{
	static volatile gsize games_scores_score_type_id__once = 0;
	if (g_once_init_enter (&games_scores_score_type_id__once)) {
		GType games_scores_score_type_id;
		games_scores_score_type_id = games_scores_score_get_type_once ();
		g_once_init_leave (&games_scores_score_type_id__once, games_scores_score_type_id);
	}
	return games_scores_score_type_id__once;
}

static void
_vala_games_scores_score_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GamesScoresScore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_SCORE, GamesScoresScore);
	switch (property_id) {
		case GAMES_SCORES_SCORE_SCORE_PROPERTY:
		g_value_set_long (value, games_scores_score_get_score (self));
		break;
		case GAMES_SCORES_SCORE_TIME_PROPERTY:
		g_value_set_int64 (value, games_scores_score_get_time (self));
		break;
		case GAMES_SCORES_SCORE_USER_PROPERTY:
		g_value_set_string (value, games_scores_score_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_scores_score_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GamesScoresScore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_SCORE, GamesScoresScore);
	switch (property_id) {
		case GAMES_SCORES_SCORE_SCORE_PROPERTY:
		games_scores_score_set_score (self, g_value_get_long (value));
		break;
		case GAMES_SCORES_SCORE_TIME_PROPERTY:
		games_scores_score_set_time (self, g_value_get_int64 (value));
		break;
		case GAMES_SCORES_SCORE_USER_PROPERTY:
		games_scores_score_set_user (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

