// services/network/public/mojom/udp_socket.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/udp_socket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/udp_socket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/udp_socket.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "services/network/public/mojom/ip_address.mojom-blink.h"
#include "services/network/public/mojom/ip_endpoint.mojom-blink.h"
#include "services/network/public/mojom/optional_bool.mojom-blink-forward.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class UDPSocketProxy;

template <typename ImplRefTraits>
class UDPSocketStub;

class UDPSocketRequestValidator;
class UDPSocketResponseValidator;


class BLINK_PLATFORM_EXPORT UDPSocket
    : public UDPSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UDPSocketInterfaceBase;
  using Proxy_ = UDPSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = UDPSocketStub<ImplRefTraits>;

  using RequestValidator_ = UDPSocketRequestValidator;
  using ResponseValidator_ = UDPSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindMinVersion = 0,
    kConnectMinVersion = 0,
    kSetBroadcastMinVersion = 0,
    kSetSendBufferSizeMinVersion = 0,
    kSetReceiveBufferSizeMinVersion = 0,
    kJoinGroupMinVersion = 0,
    kLeaveGroupMinVersion = 0,
    kReceiveMoreMinVersion = 0,
    kReceiveMoreWithBufferSizeMinVersion = 0,
    kSendToMinVersion = 0,
    kSendMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Bind_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBroadcast_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSendBufferSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetReceiveBufferSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JoinGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LeaveGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceiveMore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceiveMoreWithBufferSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Send_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UDPSocket() = default;


  using BindCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  
  virtual void Bind(const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, BindCallback callback) = 0;


  using ConnectCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  
  virtual void Connect(const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, ConnectCallback callback) = 0;


  using SetBroadcastCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void SetBroadcast(bool broadcast, SetBroadcastCallback callback) = 0;


  using SetSendBufferSizeCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) = 0;


  using SetReceiveBufferSizeCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) = 0;


  using JoinGroupCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) = 0;


  using LeaveGroupCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) = 0;

  
  virtual void ReceiveMore(uint32_t num_additional_datagrams) = 0;

  
  virtual void ReceiveMoreWithBufferSize(uint32_t num_additional_datagrams, uint32_t buffer_size) = 0;


  using SendToCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void SendTo(const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendToCallback callback) = 0;


  using SendCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void Send(::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendCallback callback) = 0;

  
  virtual void Close() = 0;
};

class UDPSocketListenerProxy;

template <typename ImplRefTraits>
class UDPSocketListenerStub;

class UDPSocketListenerRequestValidator;


class BLINK_PLATFORM_EXPORT UDPSocketListener
    : public UDPSocketListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UDPSocketListenerInterfaceBase;
  using Proxy_ = UDPSocketListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UDPSocketListenerStub<ImplRefTraits>;

  using RequestValidator_ = UDPSocketListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UDPSocketListener() = default;

  
  virtual void OnReceived(int32_t result, const std::optional<::net::IPEndPoint>& src_addr, std::optional<::base::span<const ::uint8_t>> data) = 0;
};



class BLINK_PLATFORM_EXPORT UDPSocketProxy
    : public UDPSocket {
 public:
  using InterfaceType = UDPSocket;

  explicit UDPSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Bind(const ::net::IPEndPoint& local_addr, UDPSocketOptionsPtr socket_options, BindCallback callback) final;
  
  void Connect(const ::net::IPEndPoint& remote_addr, UDPSocketOptionsPtr socket_options, ConnectCallback callback) final;
  
  void SetBroadcast(bool broadcast, SetBroadcastCallback callback) final;
  
  void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) final;
  
  void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) final;
  
  void JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) final;
  
  void LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) final;
  
  void ReceiveMore(uint32_t num_additional_datagrams) final;
  
  void ReceiveMoreWithBufferSize(uint32_t num_additional_datagrams, uint32_t buffer_size) final;
  
  void SendTo(const ::net::IPEndPoint& dest_addr, ::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendToCallback callback) final;
  
  void Send(::base::span<const ::uint8_t> data, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, SendCallback callback) final;
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT UDPSocketListenerProxy
    : public UDPSocketListener {
 public:
  using InterfaceType = UDPSocketListener;

  explicit UDPSocketListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReceived(int32_t result, const std::optional<::net::IPEndPoint>& src_addr, std::optional<::base::span<const ::uint8_t>> data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT UDPSocketStubDispatch {
 public:
  static bool Accept(UDPSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UDPSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UDPSocket>>
class UDPSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UDPSocketStub() = default;
  ~UDPSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UDPSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UDPSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT UDPSocketListenerStubDispatch {
 public:
  static bool Accept(UDPSocketListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UDPSocketListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UDPSocketListener>>
class UDPSocketListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UDPSocketListenerStub() = default;
  ~UDPSocketListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UDPSocketListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UDPSocketListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT UDPSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT UDPSocketListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT UDPSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT UDPSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UDPSocketOptions, T>::value>;
  using DataView = UDPSocketOptionsDataView;
  using Data_ = internal::UDPSocketOptions_Data;

  template <typename... Args>
  static UDPSocketOptionsPtr New(Args&&... args) {
    return UDPSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UDPSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<UDPSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UDPSocketOptions>::Convert(*this);
  }


  UDPSocketOptions();

  UDPSocketOptions(
      bool allow_address_reuse,
      bool allow_broadcast,
      bool allow_address_sharing_for_multicast,
      uint32_t multicast_interface,
      uint32_t multicast_time_to_live,
      bool multicast_loopback_mode,
      int32_t send_buffer_size,
      int32_t receive_buffer_size,
      ::network::mojom::blink::OptionalBool ipv6_only);


  ~UDPSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UDPSocketOptionsPtr>
  UDPSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UDPSocketOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UDPSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UDPSocketOptions_UnserializedMessageContext<
            UserType, UDPSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UDPSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UDPSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UDPSocketOptions_UnserializedMessageContext<
            UserType, UDPSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UDPSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_address_reuse;
  
  bool allow_broadcast;
  
  bool allow_address_sharing_for_multicast;
  
  uint32_t multicast_interface;
  
  uint32_t multicast_time_to_live;
  
  bool multicast_loopback_mode;
  
  int32_t send_buffer_size;
  
  int32_t receive_buffer_size;
  
  ::network::mojom::blink::OptionalBool ipv6_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UDPSocketOptionsPtr UDPSocketOptions::Clone() const {
  return New(
      mojo::Clone(allow_address_reuse),
      mojo::Clone(allow_broadcast),
      mojo::Clone(allow_address_sharing_for_multicast),
      mojo::Clone(multicast_interface),
      mojo::Clone(multicast_time_to_live),
      mojo::Clone(multicast_loopback_mode),
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(ipv6_only)
  );
}

template <typename T, UDPSocketOptions::EnableIfSame<T>*>
bool UDPSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_address_reuse, other_struct.allow_address_reuse))
    return false;
  if (!mojo::Equals(this->allow_broadcast, other_struct.allow_broadcast))
    return false;
  if (!mojo::Equals(this->allow_address_sharing_for_multicast, other_struct.allow_address_sharing_for_multicast))
    return false;
  if (!mojo::Equals(this->multicast_interface, other_struct.multicast_interface))
    return false;
  if (!mojo::Equals(this->multicast_time_to_live, other_struct.multicast_time_to_live))
    return false;
  if (!mojo::Equals(this->multicast_loopback_mode, other_struct.multicast_loopback_mode))
    return false;
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->ipv6_only, other_struct.ipv6_only))
    return false;
  return true;
}

template <typename T, UDPSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_address_reuse < rhs.allow_address_reuse)
    return true;
  if (rhs.allow_address_reuse < lhs.allow_address_reuse)
    return false;
  if (lhs.allow_broadcast < rhs.allow_broadcast)
    return true;
  if (rhs.allow_broadcast < lhs.allow_broadcast)
    return false;
  if (lhs.allow_address_sharing_for_multicast < rhs.allow_address_sharing_for_multicast)
    return true;
  if (rhs.allow_address_sharing_for_multicast < lhs.allow_address_sharing_for_multicast)
    return false;
  if (lhs.multicast_interface < rhs.multicast_interface)
    return true;
  if (rhs.multicast_interface < lhs.multicast_interface)
    return false;
  if (lhs.multicast_time_to_live < rhs.multicast_time_to_live)
    return true;
  if (rhs.multicast_time_to_live < lhs.multicast_time_to_live)
    return false;
  if (lhs.multicast_loopback_mode < rhs.multicast_loopback_mode)
    return true;
  if (rhs.multicast_loopback_mode < lhs.multicast_loopback_mode)
    return false;
  if (lhs.send_buffer_size < rhs.send_buffer_size)
    return true;
  if (rhs.send_buffer_size < lhs.send_buffer_size)
    return false;
  if (lhs.receive_buffer_size < rhs.receive_buffer_size)
    return true;
  if (rhs.receive_buffer_size < lhs.receive_buffer_size)
    return false;
  if (lhs.ipv6_only < rhs.ipv6_only)
    return true;
  if (rhs.ipv6_only < lhs.ipv6_only)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::UDPSocketOptions::DataView,
                                         ::network::mojom::blink::UDPSocketOptionsPtr> {
  static bool IsNull(const ::network::mojom::blink::UDPSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::UDPSocketOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::UDPSocketOptions::allow_address_reuse) allow_address_reuse(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->allow_address_reuse;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::allow_broadcast) allow_broadcast(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->allow_broadcast;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::allow_address_sharing_for_multicast) allow_address_sharing_for_multicast(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->allow_address_sharing_for_multicast;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::multicast_interface) multicast_interface(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->multicast_interface;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::multicast_time_to_live) multicast_time_to_live(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->multicast_time_to_live;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::multicast_loopback_mode) multicast_loopback_mode(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->multicast_loopback_mode;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::send_buffer_size) send_buffer_size(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::network::mojom::blink::UDPSocketOptions::ipv6_only) ipv6_only(
      const ::network::mojom::blink::UDPSocketOptionsPtr& input) {
    return input->ipv6_only;
  }

  static bool Read(::network::mojom::blink::UDPSocketOptions::DataView input, ::network::mojom::blink::UDPSocketOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_UDP_SOCKET_MOJOM_BLINK_H_