// qtwebengine/common/plugin.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/common/plugin.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/common/plugin.mojom-params-data.h"
#include "qtwebengine/common/plugin.mojom-shared-message-ids.h"

#include "qtwebengine/common/plugin.mojom-import-headers.h"
#include "qtwebengine/common/plugin.mojom-test-utils.h"
#include "content/public/common/webplugininfo_param_traits.h"


namespace qtwebengine::mojom {
PluginInfo::PluginInfo()
    : status(),
      plugin(),
      actual_mime_type(),
      group_identifier(),
      group_name() {}

PluginInfo::PluginInfo(
    PluginStatus status_in,
    const ::content::WebPluginInfo& plugin_in,
    const std::string& actual_mime_type_in,
    const std::string& group_identifier_in,
    const ::std::u16string& group_name_in)
    : status(std::move(status_in)),
      plugin(std::move(plugin_in)),
      actual_mime_type(std::move(actual_mime_type_in)),
      group_identifier(std::move(group_identifier_in)),
      group_name(std::move(group_name_in)) {}

PluginInfo::~PluginInfo() = default;

void PluginInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PluginStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plugin"), this->plugin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::content::WebPluginInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actual_mime_type"), this->actual_mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_identifier"), this->group_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_name"), this->group_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PluginParam::PluginParam()
    : name(),
      value() {}

PluginParam::PluginParam(
    const ::std::u16string& name_in,
    const ::std::u16string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

PluginParam::~PluginParam() = default;

void PluginParam::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginParam::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PluginHost::Name_[] = "qtwebengine.mojom.PluginHost";

PluginHost::IPCStableHashFunction PluginHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PluginHost>(message.name())) {
    case messages::PluginHost::kOpenPDF: {
      return &PluginHost::OpenPDF_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PluginHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PluginHost>(message.name())) {
      case messages::PluginHost::kOpenPDF:
            return "Receive qtwebengine::mojom::PluginHost::OpenPDF";
    }
  } else {
    switch (static_cast<messages::PluginHost>(message.name())) {
      case messages::PluginHost::kOpenPDF:
            return "Receive reply qtwebengine::mojom::PluginHost::OpenPDF";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PluginHost::OpenPDF_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::PluginHost::OpenPDF");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PluginHostProxy::PluginHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PluginHostProxy::OpenPDF(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PluginHost::OpenPDF", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginHost::kOpenPDF), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PluginHost_OpenPDF_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PluginHost.OpenPDF request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginHost::Name_);
  message.set_method_name("OpenPDF");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PluginHostStubDispatch::Accept(
    PluginHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PluginHost>(message->header()->name)) {
    case messages::PluginHost::kOpenPDF: {
      DCHECK(message->is_serialized());
      internal::PluginHost_OpenPDF_Params_Data* params =
          reinterpret_cast<internal::PluginHost_OpenPDF_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PluginHost.0
      bool success = true;
      ::GURL p_url{};
      PluginHost_OpenPDF_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PluginHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPDF(        
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool PluginHostStubDispatch::AcceptWithResponder(
    PluginHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PluginHost>(message->header()->name)) {
    case messages::PluginHost::kOpenPDF: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPluginHostValidationInfo[] = {
    {base::to_underlying(messages::PluginHost::kOpenPDF),
     { &internal::PluginHost_OpenPDF_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PluginHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::PluginHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPluginHostValidationInfo);
}

const char PluginAuthHost::Name_[] = "qtwebengine.mojom.PluginAuthHost";

PluginAuthHost::IPCStableHashFunction PluginAuthHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PluginAuthHost>(message.name())) {
    case messages::PluginAuthHost::kBlockedUnauthorizedPlugin: {
      return &PluginAuthHost::BlockedUnauthorizedPlugin_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PluginAuthHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PluginAuthHost>(message.name())) {
      case messages::PluginAuthHost::kBlockedUnauthorizedPlugin:
            return "Receive qtwebengine::mojom::PluginAuthHost::BlockedUnauthorizedPlugin";
    }
  } else {
    switch (static_cast<messages::PluginAuthHost>(message.name())) {
      case messages::PluginAuthHost::kBlockedUnauthorizedPlugin:
            return "Receive reply qtwebengine::mojom::PluginAuthHost::BlockedUnauthorizedPlugin";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PluginAuthHost::BlockedUnauthorizedPlugin_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::PluginAuthHost::BlockedUnauthorizedPlugin");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PluginAuthHostProxy::PluginAuthHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PluginAuthHostProxy::BlockedUnauthorizedPlugin(
    const ::std::u16string& in_name, const std::string& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PluginAuthHost::BlockedUnauthorizedPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginAuthHost::kBlockedUnauthorizedPlugin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PluginAuthHost.BlockedUnauthorizedPlugin request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id, group_id_fragment);
  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in PluginAuthHost.BlockedUnauthorizedPlugin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginAuthHost::Name_);
  message.set_method_name("BlockedUnauthorizedPlugin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PluginAuthHostStubDispatch::Accept(
    PluginAuthHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PluginAuthHost>(message->header()->name)) {
    case messages::PluginAuthHost::kBlockedUnauthorizedPlugin: {
      DCHECK(message->is_serialized());
      internal::PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data* params =
          reinterpret_cast<internal::PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PluginAuthHost.0
      bool success = true;
      ::std::u16string p_name{};
      std::string p_group_id{};
      PluginAuthHost_BlockedUnauthorizedPlugin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PluginAuthHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockedUnauthorizedPlugin(        
        std::move(p_name), 
        std::move(p_group_id));
      return true;
    }
  }
  return false;
}

// static
bool PluginAuthHostStubDispatch::AcceptWithResponder(
    PluginAuthHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PluginAuthHost>(message->header()->name)) {
    case messages::PluginAuthHost::kBlockedUnauthorizedPlugin: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPluginAuthHostValidationInfo[] = {
    {base::to_underlying(messages::PluginAuthHost::kBlockedUnauthorizedPlugin),
     { &internal::PluginAuthHost_BlockedUnauthorizedPlugin_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PluginAuthHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::PluginAuthHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPluginAuthHostValidationInfo);
}

const char PluginInfoHost::Name_[] = "qtwebengine.mojom.PluginInfoHost";

PluginInfoHost::IPCStableHashFunction PluginInfoHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PluginInfoHost>(message.name())) {
    case messages::PluginInfoHost::kGetPluginInfo: {
      return &PluginInfoHost::GetPluginInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PluginInfoHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PluginInfoHost>(message.name())) {
      case messages::PluginInfoHost::kGetPluginInfo:
            return "Receive qtwebengine::mojom::PluginInfoHost::GetPluginInfo";
    }
  } else {
    switch (static_cast<messages::PluginInfoHost>(message.name())) {
      case messages::PluginInfoHost::kGetPluginInfo:
            return "Receive reply qtwebengine::mojom::PluginInfoHost::GetPluginInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PluginInfoHost::GetPluginInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::PluginInfoHost::GetPluginInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool PluginInfoHost::GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, PluginInfoPtr* out_plugin_info) {
  NOTREACHED();
}
class PluginInfoHost_GetPluginInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PluginInfoHost_GetPluginInfo_HandleSyncResponse(
      bool* result, PluginInfoPtr* out_plugin_info)
      : result_(result), out_plugin_info_(out_plugin_info) {
    DCHECK(!*result_);
  }

  PluginInfoHost_GetPluginInfo_HandleSyncResponse(const PluginInfoHost_GetPluginInfo_HandleSyncResponse&) = delete;
  PluginInfoHost_GetPluginInfo_HandleSyncResponse& operator=(const PluginInfoHost_GetPluginInfo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PluginInfoPtr* out_plugin_info_;};

class PluginInfoHost_GetPluginInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PluginInfoHost_GetPluginInfo_ForwardToCallback(
      PluginInfoHost::GetPluginInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PluginInfoHost_GetPluginInfo_ForwardToCallback(const PluginInfoHost_GetPluginInfo_ForwardToCallback&) = delete;
  PluginInfoHost_GetPluginInfo_ForwardToCallback& operator=(const PluginInfoHost_GetPluginInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PluginInfoHost::GetPluginInfoCallback callback_;
};

PluginInfoHostProxy::PluginInfoHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool PluginInfoHostProxy::GetPluginInfo(
    const ::GURL& param_url, const ::url::Origin& param_origin, const std::string& param_mime_type, PluginInfoPtr* out_param_plugin_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call qtwebengine::mojom::PluginInfoHost::GetPluginInfo (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), param_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), param_mime_type,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "PluginInfoHost::GetPluginInfo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginInfoHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PluginInfoHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PluginInfoHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PluginInfoHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PluginInfoHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginInfoHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginInfoHost_GetPluginInfo_HandleSyncResponse(
          &result, out_param_plugin_info));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PluginInfoHost::GetPluginInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), out_param_plugin_info,
                        "<value of type PluginInfoPtr>");
   });
#endif
  return result;
}

void PluginInfoHostProxy::GetPluginInfo(
    const ::GURL& in_url, const ::url::Origin& in_origin, const std::string& in_mime_type, GetPluginInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::PluginInfoHost::GetPluginInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginInfoHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PluginInfoHost_GetPluginInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PluginInfoHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PluginInfoHost.GetPluginInfo request");
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type, mime_type_fragment);
  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in PluginInfoHost.GetPluginInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginInfoHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginInfoHost_GetPluginInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PluginInfoHost_GetPluginInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PluginInfoHost::GetPluginInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PluginInfoHost_GetPluginInfo_ProxyToResponder> proxy(
        new PluginInfoHost_GetPluginInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PluginInfoHost_GetPluginInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PluginInfoHost_GetPluginInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PluginInfoHost_GetPluginInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PluginInfoHost::GetPluginInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PluginInfoPtr in_plugin_info);
};

bool PluginInfoHost_GetPluginInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PluginInfoHost.0
  bool success = true;
  PluginInfoPtr p_plugin_info{};
  PluginInfoHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginInfoHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_plugin_info));
  return true;
}

void PluginInfoHost_GetPluginInfo_ProxyToResponder::Run(
    PluginInfoPtr in_plugin_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply qtwebengine::mojom::PluginInfoHost::GetPluginInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugin_info"), in_plugin_info,
                        "<value of type PluginInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginInfoHost::kGetPluginInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->plugin_info)::BaseType> plugin_info_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::PluginInfoDataView>(
      in_plugin_info, plugin_info_fragment);
  params->plugin_info.Set(
      plugin_info_fragment.is_null() ? nullptr : plugin_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->plugin_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plugin_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginInfoHost::Name_);
  message.set_method_name("GetPluginInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PluginInfoHost_GetPluginInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for PluginInfoHost.0
  bool success = true;
  PluginInfoPtr p_plugin_info{};
  PluginInfoHost_GetPluginInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPluginInfo(&p_plugin_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginInfoHost::Name_, 0, true);
    return false;
  }
  *out_plugin_info_ = std::move(p_plugin_info);
  *result_ = true;
  return true;
}

// static
bool PluginInfoHostStubDispatch::Accept(
    PluginInfoHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PluginInfoHost>(message->header()->name)) {
    case messages::PluginInfoHost::kGetPluginInfo: {
      break;
    }
  }
  return false;
}

// static
bool PluginInfoHostStubDispatch::AcceptWithResponder(
    PluginInfoHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PluginInfoHost>(message->header()->name)) {
    case messages::PluginInfoHost::kGetPluginInfo: {
      internal::PluginInfoHost_GetPluginInfo_Params_Data* params =
          reinterpret_cast<
              internal::PluginInfoHost_GetPluginInfo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PluginInfoHost.0
      bool success = true;
      ::GURL p_url{};
      ::url::Origin p_origin{};
      std::string p_mime_type{};
      PluginInfoHost_GetPluginInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PluginInfoHost::Name_, 0, false);
        return false;
      }
      PluginInfoHost::GetPluginInfoCallback callback =
          PluginInfoHost_GetPluginInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPluginInfo(        
        std::move(p_url), 
        std::move(p_origin), 
        std::move(p_mime_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPluginInfoHostValidationInfo[] = {
    {base::to_underlying(messages::PluginInfoHost::kGetPluginInfo),
     { &internal::PluginInfoHost_GetPluginInfo_Params_Data::Validate,
      &internal::PluginInfoHost_GetPluginInfo_ResponseParams_Data::Validate}},
};

bool PluginInfoHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::PluginInfoHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPluginInfoHostValidationInfo);
}

bool PluginInfoHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::PluginInfoHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPluginInfoHostValidationInfo);

}


}  // qtwebengine::mojom


namespace mojo {


// static
bool StructTraits<::qtwebengine::mojom::PluginInfo::DataView, ::qtwebengine::mojom::PluginInfoPtr>::Read(
    ::qtwebengine::mojom::PluginInfo::DataView input,
    ::qtwebengine::mojom::PluginInfoPtr* output) {
  bool success = true;
  ::qtwebengine::mojom::PluginInfoPtr result(::qtwebengine::mojom::PluginInfo::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadPlugin(&result->plugin))
        success = false;
      if (success && !input.ReadActualMimeType(&result->actual_mime_type))
        success = false;
      if (success && !input.ReadGroupIdentifier(&result->group_identifier))
        success = false;
      if (success && !input.ReadGroupName(&result->group_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::qtwebengine::mojom::PluginParam::DataView, ::qtwebengine::mojom::PluginParamPtr>::Read(
    ::qtwebengine::mojom::PluginParam::DataView input,
    ::qtwebengine::mojom::PluginParamPtr* output) {
  bool success = true;
  ::qtwebengine::mojom::PluginParamPtr result(::qtwebengine::mojom::PluginParam::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebengine::mojom {


void PluginHostInterceptorForTesting::OpenPDF(const ::GURL& url) {
  GetForwardingInterface()->OpenPDF(
    std::move(url)
    );
}
PluginHostAsyncWaiter::PluginHostAsyncWaiter(
    PluginHost* proxy) : proxy_(proxy) {}

PluginHostAsyncWaiter::~PluginHostAsyncWaiter() = default;




void PluginAuthHostInterceptorForTesting::BlockedUnauthorizedPlugin(const ::std::u16string& name, const std::string& group_id) {
  GetForwardingInterface()->BlockedUnauthorizedPlugin(
    std::move(name)
    , 
    std::move(group_id)
    );
}
PluginAuthHostAsyncWaiter::PluginAuthHostAsyncWaiter(
    PluginAuthHost* proxy) : proxy_(proxy) {}

PluginAuthHostAsyncWaiter::~PluginAuthHostAsyncWaiter() = default;




void PluginInfoHostInterceptorForTesting::GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, GetPluginInfoCallback callback) {
  GetForwardingInterface()->GetPluginInfo(
    std::move(url)
    , 
    std::move(origin)
    , 
    std::move(mime_type)
    , std::move(callback));
}
PluginInfoHostAsyncWaiter::PluginInfoHostAsyncWaiter(
    PluginInfoHost* proxy) : proxy_(proxy) {}

PluginInfoHostAsyncWaiter::~PluginInfoHostAsyncWaiter() = default;

void PluginInfoHostAsyncWaiter::GetPluginInfo(
    const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, PluginInfoPtr* out_plugin_info) {
  base::RunLoop loop;
  proxy_->GetPluginInfo(
      std::move(url),
      std::move(origin),
      std::move(mime_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             PluginInfoPtr* out_plugin_info
,
             PluginInfoPtr plugin_info) {*out_plugin_info = std::move(plugin_info);
            loop->Quit();
          },
          &loop,
          out_plugin_info));
  loop.Run();
}

PluginInfoPtr PluginInfoHostAsyncWaiter::GetPluginInfo(
    const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type) {
  PluginInfoPtr async_wait_result;
  GetPluginInfo(std::move(url),std::move(origin),std::move(mime_type),&async_wait_result);
  return async_wait_result;
}






}  // qtwebengine::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif