// gpu/ipc/common/gpu_preferences.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/message_pump_type.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"







namespace gpu::mojom {
class GpuPreferencesDataView;



}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::GpuPreferencesDataView> {
  using Data = ::gpu::mojom::internal::GpuPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class VulkanImplementationName : int32_t {
  
  kNone = 0,
  
  kNative = 1,
  
  kForcedNative = 2,
  
  kSwiftshader = 3,
  
  kLast = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VulkanImplementationName value);
inline bool IsKnownEnumValue(VulkanImplementationName value) {
  return internal::VulkanImplementationName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebGPUAdapterName : int32_t {
  
  kDefault = 0,
  
  kD3D11 = 1,
  
  kOpenGLES = 2,
  
  kSwiftShader = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WebGPUAdapterName value);
inline bool IsKnownEnumValue(WebGPUAdapterName value) {
  return internal::WebGPUAdapterName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebGPUPowerPreference : int32_t {
  
  kNone = 0,
  
  kDefaultLowPower = 1,
  
  kDefaultHighPerformance = 2,
  
  kForceLowPower = 3,
  
  kForceHighPerformance = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, WebGPUPowerPreference value);
inline bool IsKnownEnumValue(WebGPUPowerPreference value) {
  return internal::WebGPUPowerPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GrContextType : int32_t {
  
  kNone = 0,
  
  kGL = 1,
  
  kVulkan = 2,
  
  kGraphiteDawn = 3,
  
  kGraphiteMetal = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, GrContextType value);
inline bool IsKnownEnumValue(GrContextType value) {
  return internal::GrContextType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DawnBackendValidationLevel : int32_t {
  
  kDisabled = 0,
  
  kPartial = 1,
  
  kFull = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DawnBackendValidationLevel value);
inline bool IsKnownEnumValue(DawnBackendValidationLevel value) {
  return internal::DawnBackendValidationLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GpuPreferencesDataView {
 public:
  GpuPreferencesDataView() = default;

  GpuPreferencesDataView(
      internal::GpuPreferences_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool disable_accelerated_video_decode() const {
    return data_->disable_accelerated_video_decode;
  }
  bool disable_accelerated_video_encode() const {
    return data_->disable_accelerated_video_encode;
  }
  bool gpu_startup_dialog() const {
    return data_->gpu_startup_dialog;
  }
  bool disable_gpu_watchdog() const {
    return data_->disable_gpu_watchdog;
  }
  bool gpu_sandbox_start_early() const {
    return data_->gpu_sandbox_start_early;
  }
  bool enable_low_latency_dxva() const {
    return data_->enable_low_latency_dxva;
  }
  bool enable_zero_copy_dxgi_video() const {
    return data_->enable_zero_copy_dxgi_video;
  }
  bool enable_nv12_dxgi_video() const {
    return data_->enable_nv12_dxgi_video;
  }
  bool disable_software_rasterizer() const {
    return data_->disable_software_rasterizer;
  }
  bool log_gpu_control_list_decisions() const {
    return data_->log_gpu_control_list_decisions;
  }
  bool compile_shader_always_succeeds() const {
    return data_->compile_shader_always_succeeds;
  }
  bool disable_gl_error_limit() const {
    return data_->disable_gl_error_limit;
  }
  bool disable_glsl_translator() const {
    return data_->disable_glsl_translator;
  }
  bool disable_shader_name_hashing() const {
    return data_->disable_shader_name_hashing;
  }
  bool enable_gpu_command_logging() const {
    return data_->enable_gpu_command_logging;
  }
  bool enable_gpu_debugging() const {
    return data_->enable_gpu_debugging;
  }
  bool enable_gpu_service_logging_gpu() const {
    return data_->enable_gpu_service_logging_gpu;
  }
  bool enable_gpu_driver_debug_logging() const {
    return data_->enable_gpu_driver_debug_logging;
  }
  bool disable_gpu_program_cache() const {
    return data_->disable_gpu_program_cache;
  }
  bool enforce_gl_minimums() const {
    return data_->enforce_gl_minimums;
  }
  uint32_t force_gpu_mem_available_bytes() const {
    return data_->force_gpu_mem_available_bytes;
  }
  uint32_t force_gpu_mem_discardable_limit_bytes() const {
    return data_->force_gpu_mem_discardable_limit_bytes;
  }
  uint32_t force_max_texture_size() const {
    return data_->force_max_texture_size;
  }
  uint32_t gpu_program_cache_size() const {
    return data_->gpu_program_cache_size;
  }
  bool disable_gpu_shader_disk_cache() const {
    return data_->disable_gpu_shader_disk_cache;
  }
  bool enable_threaded_texture_mailboxes() const {
    return data_->enable_threaded_texture_mailboxes;
  }
  bool gl_shader_interm_output() const {
    return data_->gl_shader_interm_output;
  }
  bool enable_android_surface_control() const {
    return data_->enable_android_surface_control;
  }
  bool enable_gpu_service_logging() const {
    return data_->enable_gpu_service_logging;
  }
  bool enable_gpu_service_tracing() const {
    return data_->enable_gpu_service_tracing;
  }
  bool use_passthrough_cmd_decoder() const {
    return data_->use_passthrough_cmd_decoder;
  }
  bool ignore_gpu_blocklist() const {
    return data_->ignore_gpu_blocklist;
  }
  bool watchdog_starts_backgrounded() const {
    return data_->watchdog_starts_backgrounded;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGrContextType(UserType* output) const {
    auto data_value = data_->gr_context_type;
    return mojo::internal::Deserialize<::gpu::mojom::GrContextType>(
        data_value, output);
  }
  GrContextType gr_context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::GrContextType>(data_->gr_context_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseVulkan(UserType* output) const {
    auto data_value = data_->use_vulkan;
    return mojo::internal::Deserialize<::gpu::mojom::VulkanImplementationName>(
        data_value, output);
  }
  VulkanImplementationName use_vulkan() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VulkanImplementationName>(data_->use_vulkan));
  }
  bool enable_vulkan_protected_memory() const {
    return data_->enable_vulkan_protected_memory;
  }
  bool disable_vulkan_surface() const {
    return data_->disable_vulkan_surface;
  }
  bool disable_vulkan_fallback_to_gl_for_testing() const {
    return data_->disable_vulkan_fallback_to_gl_for_testing;
  }
  uint32_t vulkan_heap_memory_limit() const {
    return data_->vulkan_heap_memory_limit;
  }
  uint32_t vulkan_sync_cpu_memory_limit() const {
    return data_->vulkan_sync_cpu_memory_limit;
  }
  bool enable_gpu_benchmarking_extension() const {
    return data_->enable_gpu_benchmarking_extension;
  }
  bool enable_webgpu() const {
    return data_->enable_webgpu;
  }
  bool enable_unsafe_webgpu() const {
    return data_->enable_unsafe_webgpu;
  }
  bool enable_webgpu_developer_features() const {
    return data_->enable_webgpu_developer_features;
  }
  bool enable_webgpu_experimental_features() const {
    return data_->enable_webgpu_experimental_features;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseWebgpuAdapter(UserType* output) const {
    auto data_value = data_->use_webgpu_adapter;
    return mojo::internal::Deserialize<::gpu::mojom::WebGPUAdapterName>(
        data_value, output);
  }
  WebGPUAdapterName use_webgpu_adapter() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::WebGPUAdapterName>(data_->use_webgpu_adapter));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseWebgpuPowerPreference(UserType* output) const {
    auto data_value = data_->use_webgpu_power_preference;
    return mojo::internal::Deserialize<::gpu::mojom::WebGPUPowerPreference>(
        data_value, output);
  }
  WebGPUPowerPreference use_webgpu_power_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::WebGPUPowerPreference>(data_->use_webgpu_power_preference));
  }
  bool force_webgpu_compat() const {
    return data_->force_webgpu_compat;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEnableDawnBackendValidation(UserType* output) const {
    auto data_value = data_->enable_dawn_backend_validation;
    return mojo::internal::Deserialize<::gpu::mojom::DawnBackendValidationLevel>(
        data_value, output);
  }
  DawnBackendValidationLevel enable_dawn_backend_validation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::DawnBackendValidationLevel>(data_->enable_dawn_backend_validation));
  }
  inline void GetEnabledDawnFeaturesListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledDawnFeaturesList(UserType* output) {
    
    auto* pointer = data_->enabled_dawn_features_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetDisabledDawnFeaturesListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledDawnFeaturesList(UserType* output) {
    
    auto* pointer = data_->disabled_dawn_features_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool enable_perf_data_collection() const {
    return data_->enable_perf_data_collection;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMessagePumpType(UserType* output) const {
    auto data_value = data_->message_pump_type;
    return mojo::internal::Deserialize<::mojo_base::mojom::MessagePumpType>(
        data_value, output);
  }
  ::mojo_base::mojom::MessagePumpType message_pump_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::MessagePumpType>(data_->message_pump_type));
  }
  bool enable_native_gpu_memory_buffers() const {
    return data_->enable_native_gpu_memory_buffers;
  }
  bool force_separate_egl_display_for_webgl_testing() const {
    return data_->force_separate_egl_display_for_webgl_testing;
  }
 private:
  internal::GpuPreferences_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

namespace std {

template <>
struct hash<::gpu::mojom::VulkanImplementationName>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::VulkanImplementationName> {};

template <>
struct hash<::gpu::mojom::WebGPUAdapterName>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::WebGPUAdapterName> {};

template <>
struct hash<::gpu::mojom::WebGPUPowerPreference>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::WebGPUPowerPreference> {};

template <>
struct hash<::gpu::mojom::GrContextType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::GrContextType> {};

template <>
struct hash<::gpu::mojom::DawnBackendValidationLevel>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::DawnBackendValidationLevel> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VulkanImplementationName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::VulkanImplementationName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::VulkanImplementationName>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::WebGPUAdapterName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::WebGPUAdapterName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::WebGPUAdapterName>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::WebGPUPowerPreference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::WebGPUPowerPreference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::WebGPUPowerPreference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GrContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::GrContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::GrContextType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DawnBackendValidationLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::DawnBackendValidationLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::DawnBackendValidationLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuPreferencesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuPreferencesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuPreferences_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->disable_accelerated_video_decode = Traits::disable_accelerated_video_decode(input);
    fragment->disable_accelerated_video_encode = Traits::disable_accelerated_video_encode(input);
    fragment->gpu_startup_dialog = Traits::gpu_startup_dialog(input);
    fragment->disable_gpu_watchdog = Traits::disable_gpu_watchdog(input);
    fragment->gpu_sandbox_start_early = Traits::gpu_sandbox_start_early(input);
    fragment->enable_low_latency_dxva = Traits::enable_low_latency_dxva(input);
    fragment->enable_zero_copy_dxgi_video = Traits::enable_zero_copy_dxgi_video(input);
    fragment->enable_nv12_dxgi_video = Traits::enable_nv12_dxgi_video(input);
    fragment->disable_software_rasterizer = Traits::disable_software_rasterizer(input);
    fragment->log_gpu_control_list_decisions = Traits::log_gpu_control_list_decisions(input);
    fragment->compile_shader_always_succeeds = Traits::compile_shader_always_succeeds(input);
    fragment->disable_gl_error_limit = Traits::disable_gl_error_limit(input);
    fragment->disable_glsl_translator = Traits::disable_glsl_translator(input);
    fragment->disable_shader_name_hashing = Traits::disable_shader_name_hashing(input);
    fragment->enable_gpu_command_logging = Traits::enable_gpu_command_logging(input);
    fragment->enable_gpu_debugging = Traits::enable_gpu_debugging(input);
    fragment->enable_gpu_service_logging_gpu = Traits::enable_gpu_service_logging_gpu(input);
    fragment->enable_gpu_driver_debug_logging = Traits::enable_gpu_driver_debug_logging(input);
    fragment->disable_gpu_program_cache = Traits::disable_gpu_program_cache(input);
    fragment->enforce_gl_minimums = Traits::enforce_gl_minimums(input);
    fragment->force_gpu_mem_available_bytes = Traits::force_gpu_mem_available_bytes(input);
    fragment->force_gpu_mem_discardable_limit_bytes = Traits::force_gpu_mem_discardable_limit_bytes(input);
    fragment->force_max_texture_size = Traits::force_max_texture_size(input);
    fragment->gpu_program_cache_size = Traits::gpu_program_cache_size(input);
    fragment->disable_gpu_shader_disk_cache = Traits::disable_gpu_shader_disk_cache(input);
    fragment->enable_threaded_texture_mailboxes = Traits::enable_threaded_texture_mailboxes(input);
    fragment->gl_shader_interm_output = Traits::gl_shader_interm_output(input);
    fragment->enable_android_surface_control = Traits::enable_android_surface_control(input);
    fragment->enable_gpu_service_logging = Traits::enable_gpu_service_logging(input);
    fragment->enable_gpu_service_tracing = Traits::enable_gpu_service_tracing(input);
    fragment->use_passthrough_cmd_decoder = Traits::use_passthrough_cmd_decoder(input);
    fragment->ignore_gpu_blocklist = Traits::ignore_gpu_blocklist(input);
    fragment->watchdog_starts_backgrounded = Traits::watchdog_starts_backgrounded(input);
    mojo::internal::Serialize<::gpu::mojom::GrContextType>(
        Traits::gr_context_type(input), &fragment->gr_context_type);
    mojo::internal::Serialize<::gpu::mojom::VulkanImplementationName>(
        Traits::use_vulkan(input), &fragment->use_vulkan);
    fragment->enable_vulkan_protected_memory = Traits::enable_vulkan_protected_memory(input);
    fragment->disable_vulkan_surface = Traits::disable_vulkan_surface(input);
    fragment->disable_vulkan_fallback_to_gl_for_testing = Traits::disable_vulkan_fallback_to_gl_for_testing(input);
    fragment->vulkan_heap_memory_limit = Traits::vulkan_heap_memory_limit(input);
    fragment->vulkan_sync_cpu_memory_limit = Traits::vulkan_sync_cpu_memory_limit(input);
    fragment->enable_gpu_benchmarking_extension = Traits::enable_gpu_benchmarking_extension(input);
    fragment->enable_webgpu = Traits::enable_webgpu(input);
    fragment->enable_unsafe_webgpu = Traits::enable_unsafe_webgpu(input);
    fragment->enable_webgpu_developer_features = Traits::enable_webgpu_developer_features(input);
    fragment->enable_webgpu_experimental_features = Traits::enable_webgpu_experimental_features(input);
    mojo::internal::Serialize<::gpu::mojom::WebGPUAdapterName>(
        Traits::use_webgpu_adapter(input), &fragment->use_webgpu_adapter);
    mojo::internal::Serialize<::gpu::mojom::WebGPUPowerPreference>(
        Traits::use_webgpu_power_preference(input), &fragment->use_webgpu_power_preference);
    fragment->force_webgpu_compat = Traits::force_webgpu_compat(input);
    mojo::internal::Serialize<::gpu::mojom::DawnBackendValidationLevel>(
        Traits::enable_dawn_backend_validation(input), &fragment->enable_dawn_backend_validation);
    decltype(Traits::enabled_dawn_features_list(input)) in_enabled_dawn_features_list = Traits::enabled_dawn_features_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_dawn_features_list)::BaseType>
        enabled_dawn_features_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enabled_dawn_features_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_enabled_dawn_features_list, enabled_dawn_features_list_fragment, &enabled_dawn_features_list_validate_params);
    fragment->enabled_dawn_features_list.Set(
        enabled_dawn_features_list_fragment.is_null() ? nullptr : enabled_dawn_features_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->enabled_dawn_features_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_dawn_features_list in GpuPreferences struct");
    decltype(Traits::disabled_dawn_features_list(input)) in_disabled_dawn_features_list = Traits::disabled_dawn_features_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disabled_dawn_features_list)::BaseType>
        disabled_dawn_features_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& disabled_dawn_features_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_disabled_dawn_features_list, disabled_dawn_features_list_fragment, &disabled_dawn_features_list_validate_params);
    fragment->disabled_dawn_features_list.Set(
        disabled_dawn_features_list_fragment.is_null() ? nullptr : disabled_dawn_features_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->disabled_dawn_features_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null disabled_dawn_features_list in GpuPreferences struct");
    fragment->enable_perf_data_collection = Traits::enable_perf_data_collection(input);
    mojo::internal::Serialize<::mojo_base::mojom::MessagePumpType>(
        Traits::message_pump_type(input), &fragment->message_pump_type);
    fragment->enable_native_gpu_memory_buffers = Traits::enable_native_gpu_memory_buffers(input);
    fragment->force_separate_egl_display_for_webgl_testing = Traits::force_separate_egl_display_for_webgl_testing(input);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuPreferences_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuPreferencesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void GpuPreferencesDataView::GetEnabledDawnFeaturesListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->enabled_dawn_features_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void GpuPreferencesDataView::GetDisabledDawnFeaturesListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->disabled_dawn_features_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gpu::mojom::VulkanImplementationName> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::VulkanImplementationName value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gpu::mojom::WebGPUAdapterName> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::WebGPUAdapterName value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gpu::mojom::WebGPUPowerPreference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::WebGPUPowerPreference value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gpu::mojom::GrContextType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::GrContextType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gpu::mojom::DawnBackendValidationLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::DawnBackendValidationLevel value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_SHARED_H_