// ui/display/mojom/screen_infos.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/screen_infos.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_infos.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_infos.mojom-forward.h"  // IWYU pragma: export
#include "ui/display/mojom/screen_info.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "ui/display/mojom/screen_infos_mojom_traits.h"




namespace display::mojom {








class  ScreenInfos {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScreenInfos, T>::value>;
  using DataView = ScreenInfosDataView;
  using Data_ = internal::ScreenInfos_Data;

  template <typename... Args>
  static ScreenInfosPtr New(Args&&... args) {
    return ScreenInfosPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScreenInfosPtr From(const U& u) {
    return mojo::TypeConverter<ScreenInfosPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScreenInfos>::Convert(*this);
  }


  ScreenInfos();

  ScreenInfos(
      std::vector<::display::ScreenInfo> screen_infos,
      int64_t current_display_id,
      const ::gfx::Size& system_cursor_size);


  ~ScreenInfos();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScreenInfosPtr>
  ScreenInfosPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScreenInfos::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScreenInfos::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScreenInfos_UnserializedMessageContext<
            UserType, ScreenInfos::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScreenInfos::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScreenInfos::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScreenInfos_UnserializedMessageContext<
            UserType, ScreenInfos::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScreenInfos::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::display::ScreenInfo> screen_infos;
  
  int64_t current_display_id;
  
  ::gfx::Size system_cursor_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScreenInfos::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScreenInfosPtr ScreenInfos::Clone() const {
  return New(
      mojo::Clone(screen_infos),
      mojo::Clone(current_display_id),
      mojo::Clone(system_cursor_size)
  );
}

template <typename T, ScreenInfos::EnableIfSame<T>*>
bool ScreenInfos::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_infos, other_struct.screen_infos))
    return false;
  if (!mojo::Equals(this->current_display_id, other_struct.current_display_id))
    return false;
  if (!mojo::Equals(this->system_cursor_size, other_struct.system_cursor_size))
    return false;
  return true;
}

template <typename T, ScreenInfos::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.screen_infos < rhs.screen_infos)
    return true;
  if (rhs.screen_infos < lhs.screen_infos)
    return false;
  if (lhs.current_display_id < rhs.current_display_id)
    return true;
  if (rhs.current_display_id < lhs.current_display_id)
    return false;
  if (lhs.system_cursor_size < rhs.system_cursor_size)
    return true;
  if (rhs.system_cursor_size < lhs.system_cursor_size)
    return false;
  return false;
}


}  // display::mojom

namespace mojo {


template <>
struct  StructTraits<::display::mojom::ScreenInfos::DataView,
                                         ::display::mojom::ScreenInfosPtr> {
  static bool IsNull(const ::display::mojom::ScreenInfosPtr& input) { return !input; }
  static void SetToNull(::display::mojom::ScreenInfosPtr* output) { output->reset(); }

  static const decltype(::display::mojom::ScreenInfos::screen_infos)& screen_infos(
      const ::display::mojom::ScreenInfosPtr& input) {
    return input->screen_infos;
  }

  static decltype(::display::mojom::ScreenInfos::current_display_id) current_display_id(
      const ::display::mojom::ScreenInfosPtr& input) {
    return input->current_display_id;
  }

  static const decltype(::display::mojom::ScreenInfos::system_cursor_size)& system_cursor_size(
      const ::display::mojom::ScreenInfosPtr& input) {
    return input->system_cursor_size;
  }

  static bool Read(::display::mojom::ScreenInfos::DataView input, ::display::mojom::ScreenInfosPtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFOS_MOJOM_H_