// third_party/blink/public/mojom/script_source_location.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCRIPT_SOURCE_LOCATION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCRIPT_SOURCE_LOCATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/script_source_location.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/script_source_location.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/script_source_location.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT ScriptSourceLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptSourceLocation, T>::value>;
  using DataView = ScriptSourceLocationDataView;
  using Data_ = internal::ScriptSourceLocation_Data;

  template <typename... Args>
  static ScriptSourceLocationPtr New(Args&&... args) {
    return ScriptSourceLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptSourceLocationPtr From(const U& u) {
    return mojo::TypeConverter<ScriptSourceLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptSourceLocation>::Convert(*this);
  }


  ScriptSourceLocation();

  ScriptSourceLocation(
      const ::GURL& url,
      const std::string& function_name,
      uint64_t line_number,
      uint64_t column_number);


  ~ScriptSourceLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptSourceLocationPtr>
  ScriptSourceLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptSourceLocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptSourceLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptSourceLocation_UnserializedMessageContext<
            UserType, ScriptSourceLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScriptSourceLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScriptSourceLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptSourceLocation_UnserializedMessageContext<
            UserType, ScriptSourceLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptSourceLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::string function_name;
  
  uint64_t line_number;
  
  uint64_t column_number;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptSourceLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScriptSourceLocationPtr ScriptSourceLocation::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(function_name),
      mojo::Clone(line_number),
      mojo::Clone(column_number)
  );
}

template <typename T, ScriptSourceLocation::EnableIfSame<T>*>
bool ScriptSourceLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->function_name, other_struct.function_name))
    return false;
  if (!mojo::Equals(this->line_number, other_struct.line_number))
    return false;
  if (!mojo::Equals(this->column_number, other_struct.column_number))
    return false;
  return true;
}

template <typename T, ScriptSourceLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.function_name < rhs.function_name)
    return true;
  if (rhs.function_name < lhs.function_name)
    return false;
  if (lhs.line_number < rhs.line_number)
    return true;
  if (rhs.line_number < lhs.line_number)
    return false;
  if (lhs.column_number < rhs.column_number)
    return true;
  if (rhs.column_number < lhs.column_number)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ScriptSourceLocation::DataView,
                                         ::blink::mojom::ScriptSourceLocationPtr> {
  static bool IsNull(const ::blink::mojom::ScriptSourceLocationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ScriptSourceLocationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ScriptSourceLocation::url)& url(
      const ::blink::mojom::ScriptSourceLocationPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::ScriptSourceLocation::function_name)& function_name(
      const ::blink::mojom::ScriptSourceLocationPtr& input) {
    return input->function_name;
  }

  static decltype(::blink::mojom::ScriptSourceLocation::line_number) line_number(
      const ::blink::mojom::ScriptSourceLocationPtr& input) {
    return input->line_number;
  }

  static decltype(::blink::mojom::ScriptSourceLocation::column_number) column_number(
      const ::blink::mojom::ScriptSourceLocationPtr& input) {
    return input->column_number;
  }

  static bool Read(::blink::mojom::ScriptSourceLocation::DataView input, ::blink::mojom::ScriptSourceLocationPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCRIPT_SOURCE_LOCATION_MOJOM_H_