// third_party/blink/public/mojom/digital_goods/digital_goods.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-params-data.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-import-headers.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-test-utils.h"


namespace payments::mojom {
const char DigitalGoods::Name_[] = "payments.mojom.DigitalGoods";

DigitalGoods::IPCStableHashFunction DigitalGoods::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DigitalGoods>(message.name())) {
    case messages::DigitalGoods::kGetDetails: {
      return &DigitalGoods::GetDetails_Sym::IPCStableHash;
    }
    case messages::DigitalGoods::kListPurchases: {
      return &DigitalGoods::ListPurchases_Sym::IPCStableHash;
    }
    case messages::DigitalGoods::kListPurchaseHistory: {
      return &DigitalGoods::ListPurchaseHistory_Sym::IPCStableHash;
    }
    case messages::DigitalGoods::kConsume: {
      return &DigitalGoods::Consume_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DigitalGoods::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DigitalGoods>(message.name())) {
      case messages::DigitalGoods::kGetDetails:
            return "Receive payments::mojom::DigitalGoods::GetDetails";
      case messages::DigitalGoods::kListPurchases:
            return "Receive payments::mojom::DigitalGoods::ListPurchases";
      case messages::DigitalGoods::kListPurchaseHistory:
            return "Receive payments::mojom::DigitalGoods::ListPurchaseHistory";
      case messages::DigitalGoods::kConsume:
            return "Receive payments::mojom::DigitalGoods::Consume";
    }
  } else {
    switch (static_cast<messages::DigitalGoods>(message.name())) {
      case messages::DigitalGoods::kGetDetails:
            return "Receive reply payments::mojom::DigitalGoods::GetDetails";
      case messages::DigitalGoods::kListPurchases:
            return "Receive reply payments::mojom::DigitalGoods::ListPurchases";
      case messages::DigitalGoods::kListPurchaseHistory:
            return "Receive reply payments::mojom::DigitalGoods::ListPurchaseHistory";
      case messages::DigitalGoods::kConsume:
            return "Receive reply payments::mojom::DigitalGoods::Consume";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DigitalGoods::GetDetails_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::DigitalGoods::GetDetails");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DigitalGoods::ListPurchases_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::DigitalGoods::ListPurchases");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DigitalGoods::ListPurchaseHistory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::DigitalGoods::ListPurchaseHistory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DigitalGoods::Consume_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::DigitalGoods::Consume");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DigitalGoods_GetDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_GetDetails_ForwardToCallback(
      DigitalGoods::GetDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalGoods_GetDetails_ForwardToCallback(const DigitalGoods_GetDetails_ForwardToCallback&) = delete;
  DigitalGoods_GetDetails_ForwardToCallback& operator=(const DigitalGoods_GetDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::GetDetailsCallback callback_;
};

class DigitalGoods_ListPurchases_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_ListPurchases_ForwardToCallback(
      DigitalGoods::ListPurchasesCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalGoods_ListPurchases_ForwardToCallback(const DigitalGoods_ListPurchases_ForwardToCallback&) = delete;
  DigitalGoods_ListPurchases_ForwardToCallback& operator=(const DigitalGoods_ListPurchases_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::ListPurchasesCallback callback_;
};

class DigitalGoods_ListPurchaseHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_ListPurchaseHistory_ForwardToCallback(
      DigitalGoods::ListPurchaseHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalGoods_ListPurchaseHistory_ForwardToCallback(const DigitalGoods_ListPurchaseHistory_ForwardToCallback&) = delete;
  DigitalGoods_ListPurchaseHistory_ForwardToCallback& operator=(const DigitalGoods_ListPurchaseHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::ListPurchaseHistoryCallback callback_;
};

class DigitalGoods_Consume_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_Consume_ForwardToCallback(
      DigitalGoods::ConsumeCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalGoods_Consume_ForwardToCallback(const DigitalGoods_Consume_ForwardToCallback&) = delete;
  DigitalGoods_Consume_ForwardToCallback& operator=(const DigitalGoods_Consume_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::ConsumeCallback callback_;
};

DigitalGoodsProxy::DigitalGoodsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsProxy::GetDetails(
    const std::vector<std::string>& in_item_ids, GetDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::DigitalGoods::GetDetails", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_ids"), in_item_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kGetDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_GetDetails_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item_ids)::BaseType>
      item_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& item_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_item_ids, item_ids_fragment, &item_ids_validate_params);
  params->item_ids.Set(
      item_ids_fragment.is_null() ? nullptr : item_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_ids in DigitalGoods.GetDetails request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_GetDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DigitalGoodsProxy::ListPurchases(
    ListPurchasesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::DigitalGoods::ListPurchases");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kListPurchases), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchases_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchases");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_ListPurchases_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DigitalGoodsProxy::ListPurchaseHistory(
    ListPurchaseHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send payments::mojom::DigitalGoods::ListPurchaseHistory");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kListPurchaseHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchaseHistory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchaseHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_ListPurchaseHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DigitalGoodsProxy::Consume(
    const std::string& in_purchase_token, ConsumeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::DigitalGoods::Consume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purchase_token"), in_purchase_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kConsume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_Consume_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->purchase_token)::BaseType> purchase_token_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_purchase_token, purchase_token_fragment);
  params->purchase_token.Set(
      purchase_token_fragment.is_null() ? nullptr : purchase_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_token in DigitalGoods.Consume request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Consume");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_Consume_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DigitalGoods_GetDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalGoods::GetDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalGoods_GetDetails_ProxyToResponder> proxy(
        new DigitalGoods_GetDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalGoods_GetDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_GetDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalGoods_GetDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::GetDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::ItemDetailsPtr> in_item_details_list);
};

bool DigitalGoods_GetDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalGoods_GetDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_GetDetails_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DigitalGoods.0
  bool success = true;
  ::payments::mojom::BillingResponseCode p_code{};
  std::vector<::payments::mojom::ItemDetailsPtr> p_item_details_list{};
  DigitalGoods_GetDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadItemDetailsList(&p_item_details_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_item_details_list));
  return true;
}

void DigitalGoods_GetDetails_ProxyToResponder::Run(
    ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::ItemDetailsPtr> in_item_details_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::DigitalGoods::GetDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::payments::mojom::BillingResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_details_list"), in_item_details_list,
                        "<value of type std::vector<::payments::mojom::ItemDetailsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kGetDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_GetDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->item_details_list)::BaseType>
      item_details_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& item_details_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::ItemDetailsDataView>>(
      in_item_details_list, item_details_list_fragment, &item_details_list_validate_params);
  params->item_details_list.Set(
      item_details_list_fragment.is_null() ? nullptr : item_details_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_details_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_details_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_ListPurchases_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalGoods::ListPurchasesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalGoods_ListPurchases_ProxyToResponder> proxy(
        new DigitalGoods_ListPurchases_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalGoods_ListPurchases_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_ListPurchases_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalGoods_ListPurchases_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::ListPurchasesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::PurchaseReferencePtr> in_purchase_reference_list);
};

bool DigitalGoods_ListPurchases_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalGoods_ListPurchases_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_ListPurchases_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DigitalGoods.1
  bool success = true;
  ::payments::mojom::BillingResponseCode p_code{};
  std::vector<::payments::mojom::PurchaseReferencePtr> p_purchase_reference_list{};
  DigitalGoods_ListPurchases_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadPurchaseReferenceList(&p_purchase_reference_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_purchase_reference_list));
  return true;
}

void DigitalGoods_ListPurchases_ProxyToResponder::Run(
    ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::PurchaseReferencePtr> in_purchase_reference_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::DigitalGoods::ListPurchases", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::payments::mojom::BillingResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purchase_reference_list"), in_purchase_reference_list,
                        "<value of type std::vector<::payments::mojom::PurchaseReferencePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kListPurchases), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchases_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->purchase_reference_list)::BaseType>
      purchase_reference_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& purchase_reference_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PurchaseReferenceDataView>>(
      in_purchase_reference_list, purchase_reference_list_fragment, &purchase_reference_list_validate_params);
  params->purchase_reference_list.Set(
      purchase_reference_list_fragment.is_null() ? nullptr : purchase_reference_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_reference_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_reference_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchases");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_ListPurchaseHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalGoods::ListPurchaseHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalGoods_ListPurchaseHistory_ProxyToResponder> proxy(
        new DigitalGoods_ListPurchaseHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalGoods_ListPurchaseHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_ListPurchaseHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalGoods_ListPurchaseHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::ListPurchaseHistoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::PurchaseReferencePtr> in_purchase_reference_list);
};

bool DigitalGoods_ListPurchaseHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalGoods_ListPurchaseHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_ListPurchaseHistory_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DigitalGoods.2
  bool success = true;
  ::payments::mojom::BillingResponseCode p_code{};
  std::vector<::payments::mojom::PurchaseReferencePtr> p_purchase_reference_list{};
  DigitalGoods_ListPurchaseHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadPurchaseReferenceList(&p_purchase_reference_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_purchase_reference_list));
  return true;
}

void DigitalGoods_ListPurchaseHistory_ProxyToResponder::Run(
    ::payments::mojom::BillingResponseCode in_code, std::vector<::payments::mojom::PurchaseReferencePtr> in_purchase_reference_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::DigitalGoods::ListPurchaseHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::payments::mojom::BillingResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purchase_reference_list"), in_purchase_reference_list,
                        "<value of type std::vector<::payments::mojom::PurchaseReferencePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kListPurchaseHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchaseHistory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->purchase_reference_list)::BaseType>
      purchase_reference_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& purchase_reference_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PurchaseReferenceDataView>>(
      in_purchase_reference_list, purchase_reference_list_fragment, &purchase_reference_list_validate_params);
  params->purchase_reference_list.Set(
      purchase_reference_list_fragment.is_null() ? nullptr : purchase_reference_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_reference_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_reference_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchaseHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_Consume_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalGoods::ConsumeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalGoods_Consume_ProxyToResponder> proxy(
        new DigitalGoods_Consume_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalGoods_Consume_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_Consume_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalGoods_Consume_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::ConsumeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::payments::mojom::BillingResponseCode in_code);
};

bool DigitalGoods_Consume_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalGoods_Consume_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_Consume_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DigitalGoods.3
  bool success = true;
  ::payments::mojom::BillingResponseCode p_code{};
  DigitalGoods_Consume_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code));
  return true;
}

void DigitalGoods_Consume_ProxyToResponder::Run(
    ::payments::mojom::BillingResponseCode in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::DigitalGoods::Consume", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::payments::mojom::BillingResponseCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoods::kConsume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_Consume_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Consume");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsStubDispatch::Accept(
    DigitalGoods* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DigitalGoods>(message->header()->name)) {
    case messages::DigitalGoods::kGetDetails: {
      break;
    }
    case messages::DigitalGoods::kListPurchases: {
      break;
    }
    case messages::DigitalGoods::kListPurchaseHistory: {
      break;
    }
    case messages::DigitalGoods::kConsume: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsStubDispatch::AcceptWithResponder(
    DigitalGoods* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DigitalGoods>(message->header()->name)) {
    case messages::DigitalGoods::kGetDetails: {
      internal::DigitalGoods_GetDetails_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_GetDetails_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DigitalGoods.0
      bool success = true;
      std::vector<std::string> p_item_ids{};
      DigitalGoods_GetDetails_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItemIds(&p_item_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 0, false);
        return false;
      }
      DigitalGoods::GetDetailsCallback callback =
          DigitalGoods_GetDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDetails(        
        std::move(p_item_ids), std::move(callback));
      return true;
    }
    case messages::DigitalGoods::kListPurchases: {
      internal::DigitalGoods_ListPurchases_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_ListPurchases_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DigitalGoods.1
      bool success = true;
      DigitalGoods_ListPurchases_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 1, false);
        return false;
      }
      DigitalGoods::ListPurchasesCallback callback =
          DigitalGoods_ListPurchases_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListPurchases(std::move(callback));
      return true;
    }
    case messages::DigitalGoods::kListPurchaseHistory: {
      internal::DigitalGoods_ListPurchaseHistory_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_ListPurchaseHistory_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DigitalGoods.2
      bool success = true;
      DigitalGoods_ListPurchaseHistory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 2, false);
        return false;
      }
      DigitalGoods::ListPurchaseHistoryCallback callback =
          DigitalGoods_ListPurchaseHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListPurchaseHistory(std::move(callback));
      return true;
    }
    case messages::DigitalGoods::kConsume: {
      internal::DigitalGoods_Consume_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_Consume_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DigitalGoods.3
      bool success = true;
      std::string p_purchase_token{};
      DigitalGoods_Consume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPurchaseToken(&p_purchase_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 3, false);
        return false;
      }
      DigitalGoods::ConsumeCallback callback =
          DigitalGoods_Consume_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Consume(        
        std::move(p_purchase_token), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDigitalGoodsValidationInfo[] = {
    { &internal::DigitalGoods_GetDetails_Params_Data::Validate,
     &internal::DigitalGoods_GetDetails_ResponseParams_Data::Validate},
    { &internal::DigitalGoods_ListPurchases_Params_Data::Validate,
     &internal::DigitalGoods_ListPurchases_ResponseParams_Data::Validate},
    { &internal::DigitalGoods_ListPurchaseHistory_Params_Data::Validate,
     &internal::DigitalGoods_ListPurchaseHistory_ResponseParams_Data::Validate},
    { &internal::DigitalGoods_Consume_Params_Data::Validate,
     &internal::DigitalGoods_Consume_ResponseParams_Data::Validate},
};

bool DigitalGoodsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::DigitalGoods::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsValidationInfo);
}

bool DigitalGoodsResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::DigitalGoods::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsValidationInfo);
}
const char DigitalGoodsFactory::Name_[] = "payments.mojom.DigitalGoodsFactory";

DigitalGoodsFactory::IPCStableHashFunction DigitalGoodsFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DigitalGoodsFactory>(message.name())) {
    case messages::DigitalGoodsFactory::kCreateDigitalGoods: {
      return &DigitalGoodsFactory::CreateDigitalGoods_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DigitalGoodsFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DigitalGoodsFactory>(message.name())) {
      case messages::DigitalGoodsFactory::kCreateDigitalGoods:
            return "Receive payments::mojom::DigitalGoodsFactory::CreateDigitalGoods";
    }
  } else {
    switch (static_cast<messages::DigitalGoodsFactory>(message.name())) {
      case messages::DigitalGoodsFactory::kCreateDigitalGoods:
            return "Receive reply payments::mojom::DigitalGoodsFactory::CreateDigitalGoods";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DigitalGoodsFactory::CreateDigitalGoods_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoods");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(const DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback&) = delete;
  DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback& operator=(const DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoodsFactory::CreateDigitalGoodsCallback callback_;
};

DigitalGoodsFactoryProxy::DigitalGoodsFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsFactoryProxy::CreateDigitalGoods(
    const std::string& in_payment_method, CreateDigitalGoodsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send payments::mojom::DigitalGoodsFactory::CreateDigitalGoods", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payment_method"), in_payment_method,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoodsFactory::kCreateDigitalGoods), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->payment_method)::BaseType> payment_method_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_payment_method, payment_method_fragment);
  params->payment_method.Set(
      payment_method_fragment.is_null() ? nullptr : payment_method_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->payment_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_method in DigitalGoodsFactory.CreateDigitalGoods request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DigitalGoodsFactory::CreateDigitalGoodsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder> proxy(
        new DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoodsFactory::CreateDigitalGoodsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::payments::mojom::CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods);
};

bool DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DigitalGoodsFactory.0
  bool success = true;
  ::payments::mojom::CreateDigitalGoodsResponseCode p_code{};
  ::mojo::PendingRemote<DigitalGoods> p_digital_goods{};
  DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success) {
    p_digital_goods =
        input_data_view.TakeDigitalGoods<decltype(p_digital_goods)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoodsFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_digital_goods));
  return true;
}

void DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run(
    ::payments::mojom::CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply payments::mojom::DigitalGoodsFactory::CreateDigitalGoods", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::payments::mojom::CreateDigitalGoodsResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("digital_goods"), in_digital_goods,
                        "<value of type ::mojo::PendingRemote<DigitalGoods>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DigitalGoodsFactory::kCreateDigitalGoods), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::CreateDigitalGoodsResponseCode>(
      in_code, &params->code);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::DigitalGoodsInterfaceBase>>(
      in_digital_goods, &params->digital_goods, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsFactoryStubDispatch::Accept(
    DigitalGoodsFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DigitalGoodsFactory>(message->header()->name)) {
    case messages::DigitalGoodsFactory::kCreateDigitalGoods: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsFactoryStubDispatch::AcceptWithResponder(
    DigitalGoodsFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DigitalGoodsFactory>(message->header()->name)) {
    case messages::DigitalGoodsFactory::kCreateDigitalGoods: {
      internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DigitalGoodsFactory.0
      bool success = true;
      std::string p_payment_method{};
      DigitalGoodsFactory_CreateDigitalGoods_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPaymentMethod(&p_payment_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoodsFactory::Name_, 0, false);
        return false;
      }
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback =
          DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDigitalGoods(        
        std::move(p_payment_method), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDigitalGoodsFactoryValidationInfo[] = {
    { &internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data::Validate,
     &internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::Validate},
};

bool DigitalGoodsFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}

bool DigitalGoodsFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}


}  // payments::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace payments::mojom {


void DigitalGoodsInterceptorForTesting::GetDetails(const std::vector<std::string>& item_ids, GetDetailsCallback callback) {
  GetForwardingInterface()->GetDetails(
    std::move(item_ids)
    , std::move(callback));
}
void DigitalGoodsInterceptorForTesting::ListPurchases(ListPurchasesCallback callback) {
  GetForwardingInterface()->ListPurchases(std::move(callback));
}
void DigitalGoodsInterceptorForTesting::ListPurchaseHistory(ListPurchaseHistoryCallback callback) {
  GetForwardingInterface()->ListPurchaseHistory(std::move(callback));
}
void DigitalGoodsInterceptorForTesting::Consume(const std::string& purchase_token, ConsumeCallback callback) {
  GetForwardingInterface()->Consume(
    std::move(purchase_token)
    , std::move(callback));
}
DigitalGoodsAsyncWaiter::DigitalGoodsAsyncWaiter(
    DigitalGoods* proxy) : proxy_(proxy) {}

DigitalGoodsAsyncWaiter::~DigitalGoodsAsyncWaiter() = default;

void DigitalGoodsAsyncWaiter::GetDetails(
    const std::vector<std::string>& item_ids, ::payments::mojom::BillingResponseCode* out_code, std::vector<::payments::mojom::ItemDetailsPtr>* out_item_details_list) {
  base::RunLoop loop;
  proxy_->GetDetails(
      std::move(item_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::payments::mojom::BillingResponseCode* out_code
,
             std::vector<::payments::mojom::ItemDetailsPtr>* out_item_details_list
,
             ::payments::mojom::BillingResponseCode code,
             std::vector<::payments::mojom::ItemDetailsPtr> item_details_list) {*out_code = std::move(code);*out_item_details_list = std::move(item_details_list);
            loop->Quit();
          },
          &loop,
          out_code,
          out_item_details_list));
  loop.Run();
}



void DigitalGoodsAsyncWaiter::ListPurchases(
    ::payments::mojom::BillingResponseCode* out_code, std::vector<::payments::mojom::PurchaseReferencePtr>* out_purchase_reference_list) {
  base::RunLoop loop;
  proxy_->ListPurchases(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::payments::mojom::BillingResponseCode* out_code
,
             std::vector<::payments::mojom::PurchaseReferencePtr>* out_purchase_reference_list
,
             ::payments::mojom::BillingResponseCode code,
             std::vector<::payments::mojom::PurchaseReferencePtr> purchase_reference_list) {*out_code = std::move(code);*out_purchase_reference_list = std::move(purchase_reference_list);
            loop->Quit();
          },
          &loop,
          out_code,
          out_purchase_reference_list));
  loop.Run();
}



void DigitalGoodsAsyncWaiter::ListPurchaseHistory(
    ::payments::mojom::BillingResponseCode* out_code, std::vector<::payments::mojom::PurchaseReferencePtr>* out_purchase_reference_list) {
  base::RunLoop loop;
  proxy_->ListPurchaseHistory(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::payments::mojom::BillingResponseCode* out_code
,
             std::vector<::payments::mojom::PurchaseReferencePtr>* out_purchase_reference_list
,
             ::payments::mojom::BillingResponseCode code,
             std::vector<::payments::mojom::PurchaseReferencePtr> purchase_reference_list) {*out_code = std::move(code);*out_purchase_reference_list = std::move(purchase_reference_list);
            loop->Quit();
          },
          &loop,
          out_code,
          out_purchase_reference_list));
  loop.Run();
}



void DigitalGoodsAsyncWaiter::Consume(
    const std::string& purchase_token, ::payments::mojom::BillingResponseCode* out_code) {
  base::RunLoop loop;
  proxy_->Consume(
      std::move(purchase_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::payments::mojom::BillingResponseCode* out_code
,
             ::payments::mojom::BillingResponseCode code) {*out_code = std::move(code);
            loop->Quit();
          },
          &loop,
          out_code));
  loop.Run();
}

::payments::mojom::BillingResponseCode DigitalGoodsAsyncWaiter::Consume(
    const std::string& purchase_token) {
  ::payments::mojom::BillingResponseCode async_wait_result;
  Consume(std::move(purchase_token),&async_wait_result);
  return async_wait_result;
}




void DigitalGoodsFactoryInterceptorForTesting::CreateDigitalGoods(const std::string& payment_method, CreateDigitalGoodsCallback callback) {
  GetForwardingInterface()->CreateDigitalGoods(
    std::move(payment_method)
    , std::move(callback));
}
DigitalGoodsFactoryAsyncWaiter::DigitalGoodsFactoryAsyncWaiter(
    DigitalGoodsFactory* proxy) : proxy_(proxy) {}

DigitalGoodsFactoryAsyncWaiter::~DigitalGoodsFactoryAsyncWaiter() = default;

void DigitalGoodsFactoryAsyncWaiter::CreateDigitalGoods(
    const std::string& payment_method, ::payments::mojom::CreateDigitalGoodsResponseCode* out_code, ::mojo::PendingRemote<DigitalGoods>* out_digital_goods) {
  base::RunLoop loop;
  proxy_->CreateDigitalGoods(
      std::move(payment_method),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::payments::mojom::CreateDigitalGoodsResponseCode* out_code
,
             ::mojo::PendingRemote<DigitalGoods>* out_digital_goods
,
             ::payments::mojom::CreateDigitalGoodsResponseCode code,
             ::mojo::PendingRemote<DigitalGoods> digital_goods) {*out_code = std::move(code);*out_digital_goods = std::move(digital_goods);
            loop->Quit();
          },
          &loop,
          out_code,
          out_digital_goods));
  loop.Run();
}








}  // payments::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif