// services/viz/public/mojom/compositing/animation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/animation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/animation.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/animation.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/animation.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/animation.mojom-test-utils.h"


namespace viz::mojom {
CubicBezierTimingFunction::CubicBezierTimingFunction()
    : x1(),
      y1(),
      x2(),
      y2() {}

CubicBezierTimingFunction::CubicBezierTimingFunction(
    double x1_in,
    double y1_in,
    double x2_in,
    double y2_in)
    : x1(std::move(x1_in)),
      y1(std::move(y1_in)),
      x2(std::move(x2_in)),
      y2(std::move(y2_in)) {}

CubicBezierTimingFunction::~CubicBezierTimingFunction() = default;
size_t CubicBezierTimingFunction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->x1);
  seed = mojo::internal::Hash(seed, this->y1);
  seed = mojo::internal::Hash(seed, this->x2);
  seed = mojo::internal::Hash(seed, this->y2);
  return seed;
}

void CubicBezierTimingFunction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x1"), this->x1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y1"), this->y1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x2"), this->x2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y2"), this->y2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CubicBezierTimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StepsTimingFunction::StepsTimingFunction()
    : num_steps(),
      step_position() {}

StepsTimingFunction::StepsTimingFunction(
    uint32_t num_steps_in,
    TimingStepPosition step_position_in)
    : num_steps(std::move(num_steps_in)),
      step_position(std::move(step_position_in)) {}

StepsTimingFunction::~StepsTimingFunction() = default;
size_t StepsTimingFunction::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->num_steps);
  seed = mojo::internal::Hash(seed, this->step_position);
  return seed;
}

void StepsTimingFunction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_steps"), this->num_steps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "step_position"), this->step_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingStepPosition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StepsTimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinearEasingPoint::LinearEasingPoint()
    : in(),
      out() {}

LinearEasingPoint::LinearEasingPoint(
    double in_in,
    double out_in)
    : in(std::move(in_in)),
      out(std::move(out_in)) {}

LinearEasingPoint::~LinearEasingPoint() = default;
size_t LinearEasingPoint::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->in);
  seed = mojo::internal::Hash(seed, this->out);
  return seed;
}

void LinearEasingPoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in"), this->in,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "out"), this->out,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinearEasingPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AxisAngle::AxisAngle()
    : axis(),
      angle() {}

AxisAngle::AxisAngle(
    const ::gfx::Vector3dF& axis_in,
    float angle_in)
    : axis(std::move(axis_in)),
      angle(std::move(angle_in)) {}

AxisAngle::~AxisAngle() = default;

void AxisAngle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector3dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angle"), this->angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AxisAngle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationKeyframe::AnimationKeyframe()
    : value(),
      start_time(),
      timing_function() {}

AnimationKeyframe::AnimationKeyframe(
    AnimationKeyframeValuePtr value_in,
    ::base::TimeDelta start_time_in,
    TimingFunctionPtr timing_function_in)
    : value(std::move(value_in)),
      start_time(std::move(start_time_in)),
      timing_function(std::move(timing_function_in)) {}

AnimationKeyframe::~AnimationKeyframe() = default;

void AnimationKeyframe::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationKeyframeValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_function"), this->timing_function,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingFunctionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationKeyframe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationKeyframeModel::AnimationKeyframeModel()
    : id(),
      group_id(),
      target_property_type(),
      element_id(),
      timing_function(),
      keyframes(),
      scaled_duration(),
      direction(),
      fill_mode(),
      playback_rate(),
      iterations(),
      iteration_start(),
      time_offset() {}

AnimationKeyframeModel::AnimationKeyframeModel(
    int32_t id_in,
    int32_t group_id_in,
    int32_t target_property_type_in,
    ::cc::ElementId element_id_in,
    TimingFunctionPtr timing_function_in,
    std::vector<AnimationKeyframePtr> keyframes_in,
    double scaled_duration_in,
    AnimationDirection direction_in,
    AnimationFillMode fill_mode_in,
    double playback_rate_in,
    double iterations_in,
    double iteration_start_in,
    ::base::TimeDelta time_offset_in)
    : id(std::move(id_in)),
      group_id(std::move(group_id_in)),
      target_property_type(std::move(target_property_type_in)),
      element_id(std::move(element_id_in)),
      timing_function(std::move(timing_function_in)),
      keyframes(std::move(keyframes_in)),
      scaled_duration(std::move(scaled_duration_in)),
      direction(std::move(direction_in)),
      fill_mode(std::move(fill_mode_in)),
      playback_rate(std::move(playback_rate_in)),
      iterations(std::move(iterations_in)),
      iteration_start(std::move(iteration_start_in)),
      time_offset(std::move(time_offset_in)) {}

AnimationKeyframeModel::~AnimationKeyframeModel() = default;

void AnimationKeyframeModel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_property_type"), this->target_property_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_function"), this->timing_function,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TimingFunctionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyframes"), this->keyframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AnimationKeyframePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scaled_duration"), this->scaled_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_mode"), this->fill_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnimationFillMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_rate"), this->playback_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iterations"), this->iterations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iteration_start"), this->iteration_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_offset"), this->time_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationKeyframeModel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Animation::Animation()
    : id(),
      element_id(),
      keyframe_models() {}

Animation::Animation(
    int32_t id_in,
    ::cc::ElementId element_id_in,
    std::vector<AnimationKeyframeModelPtr> keyframe_models_in)
    : id(std::move(id_in)),
      element_id(std::move(element_id_in)),
      keyframe_models(std::move(keyframe_models_in)) {}

Animation::~Animation() = default;

void Animation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::ElementId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyframe_models"), this->keyframe_models,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AnimationKeyframeModelPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Animation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnimationTimeline::AnimationTimeline()
    : id(),
      new_animations(),
      removed_animations() {}

AnimationTimeline::AnimationTimeline(
    int32_t id_in,
    std::vector<AnimationPtr> new_animations_in,
    std::vector<int32_t> removed_animations_in)
    : id(std::move(id_in)),
      new_animations(std::move(new_animations_in)),
      removed_animations(std::move(removed_animations_in)) {}

AnimationTimeline::~AnimationTimeline() = default;

void AnimationTimeline::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_animations"), this->new_animations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AnimationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "removed_animations"), this->removed_animations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnimationTimeline::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TimingFunction::TimingFunction() : tag_(Tag::kCubicBezier) {
  data_.cubic_bezier = new CubicBezierTimingFunctionPtr;
}

TimingFunction::~TimingFunction() {
  DestroyActive();
}


void TimingFunction::set_cubic_bezier(
    CubicBezierTimingFunctionPtr cubic_bezier) {
  if (tag_ == Tag::kCubicBezier) {
    *(data_.cubic_bezier) = std::move(cubic_bezier);
  } else {
    DestroyActive();
    tag_ = Tag::kCubicBezier;
    data_.cubic_bezier = new CubicBezierTimingFunctionPtr(
        std::move(cubic_bezier));
  }
}
void TimingFunction::set_steps(
    StepsTimingFunctionPtr steps) {
  if (tag_ == Tag::kSteps) {
    *(data_.steps) = std::move(steps);
  } else {
    DestroyActive();
    tag_ = Tag::kSteps;
    data_.steps = new StepsTimingFunctionPtr(
        std::move(steps));
  }
}
void TimingFunction::set_linear(
    std::vector<LinearEasingPointPtr> linear) {
  if (tag_ == Tag::kLinear) {
    *(data_.linear) = std::move(linear);
  } else {
    DestroyActive();
    tag_ = Tag::kLinear;
    data_.linear = new std::vector<LinearEasingPointPtr>(
        std::move(linear));
  }
}

void TimingFunction::DestroyActive() {
  switch (tag_) {

    case Tag::kCubicBezier:

      delete data_.cubic_bezier;
      break;
    case Tag::kSteps:

      delete data_.steps;
      break;
    case Tag::kLinear:

      delete data_.linear;
      break;
  }
}

bool TimingFunction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
TransformOperation::TransformOperation() : tag_(Tag::kIdentity) {
  data_.identity = bool();
}

TransformOperation::~TransformOperation() {
  DestroyActive();
}


void TransformOperation::set_identity(
    bool identity) {
  if (tag_ != Tag::kIdentity) {
    DestroyActive();
    tag_ = Tag::kIdentity;
  }
  data_.identity = identity;
}
void TransformOperation::set_perspective_depth(
    float perspective_depth) {
  if (tag_ != Tag::kPerspectiveDepth) {
    DestroyActive();
    tag_ = Tag::kPerspectiveDepth;
  }
  data_.perspective_depth = perspective_depth;
}
void TransformOperation::set_skew(
    const ::gfx::Vector2dF& skew) {
  if (tag_ == Tag::kSkew) {
    *(data_.skew) = std::move(skew);
  } else {
    DestroyActive();
    tag_ = Tag::kSkew;
    data_.skew = new ::gfx::Vector2dF(
        std::move(skew));
  }
}
void TransformOperation::set_scale(
    const ::gfx::Vector3dF& scale) {
  if (tag_ == Tag::kScale) {
    *(data_.scale) = std::move(scale);
  } else {
    DestroyActive();
    tag_ = Tag::kScale;
    data_.scale = new ::gfx::Vector3dF(
        std::move(scale));
  }
}
void TransformOperation::set_translate(
    const ::gfx::Vector3dF& translate) {
  if (tag_ == Tag::kTranslate) {
    *(data_.translate) = std::move(translate);
  } else {
    DestroyActive();
    tag_ = Tag::kTranslate;
    data_.translate = new ::gfx::Vector3dF(
        std::move(translate));
  }
}
void TransformOperation::set_rotate(
    AxisAnglePtr rotate) {
  if (tag_ == Tag::kRotate) {
    *(data_.rotate) = std::move(rotate);
  } else {
    DestroyActive();
    tag_ = Tag::kRotate;
    data_.rotate = new AxisAnglePtr(
        std::move(rotate));
  }
}
void TransformOperation::set_matrix(
    const ::gfx::Transform& matrix) {
  if (tag_ == Tag::kMatrix) {
    *(data_.matrix) = std::move(matrix);
  } else {
    DestroyActive();
    tag_ = Tag::kMatrix;
    data_.matrix = new ::gfx::Transform(
        std::move(matrix));
  }
}

void TransformOperation::DestroyActive() {
  switch (tag_) {

    case Tag::kIdentity:

      break;
    case Tag::kPerspectiveDepth:

      break;
    case Tag::kSkew:

      delete data_.skew;
      break;
    case Tag::kScale:

      delete data_.scale;
      break;
    case Tag::kTranslate:

      delete data_.translate;
      break;
    case Tag::kRotate:

      delete data_.rotate;
      break;
    case Tag::kMatrix:

      delete data_.matrix;
      break;
  }
}

bool TransformOperation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AnimationKeyframeValue::AnimationKeyframeValue() : tag_(Tag::kScalar) {
  data_.scalar = float();
}

AnimationKeyframeValue::~AnimationKeyframeValue() {
  DestroyActive();
}


void AnimationKeyframeValue::set_scalar(
    float scalar) {
  if (tag_ != Tag::kScalar) {
    DestroyActive();
    tag_ = Tag::kScalar;
  }
  data_.scalar = scalar;
}
void AnimationKeyframeValue::set_color(
    ::SkColor color) {
  if (tag_ == Tag::kColor) {
    *(data_.color) = std::move(color);
  } else {
    DestroyActive();
    tag_ = Tag::kColor;
    data_.color = new ::SkColor(
        std::move(color));
  }
}
void AnimationKeyframeValue::set_size(
    const ::gfx::SizeF& size) {
  if (tag_ == Tag::kSize) {
    *(data_.size) = std::move(size);
  } else {
    DestroyActive();
    tag_ = Tag::kSize;
    data_.size = new ::gfx::SizeF(
        std::move(size));
  }
}
void AnimationKeyframeValue::set_rect(
    const ::gfx::Rect& rect) {
  if (tag_ == Tag::kRect) {
    *(data_.rect) = std::move(rect);
  } else {
    DestroyActive();
    tag_ = Tag::kRect;
    data_.rect = new ::gfx::Rect(
        std::move(rect));
  }
}
void AnimationKeyframeValue::set_transform(
    std::vector<TransformOperationPtr> transform) {
  if (tag_ == Tag::kTransform) {
    *(data_.transform) = std::move(transform);
  } else {
    DestroyActive();
    tag_ = Tag::kTransform;
    data_.transform = new std::vector<TransformOperationPtr>(
        std::move(transform));
  }
}

void AnimationKeyframeValue::DestroyActive() {
  switch (tag_) {

    case Tag::kScalar:

      break;
    case Tag::kColor:

      delete data_.color;
      break;
    case Tag::kSize:

      delete data_.size;
      break;
    case Tag::kRect:

      delete data_.rect;
      break;
    case Tag::kTransform:

      delete data_.transform;
      break;
  }
}

bool AnimationKeyframeValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::CubicBezierTimingFunction::DataView, ::viz::mojom::CubicBezierTimingFunctionPtr>::Read(
    ::viz::mojom::CubicBezierTimingFunction::DataView input,
    ::viz::mojom::CubicBezierTimingFunctionPtr* output) {
  bool success = true;
  ::viz::mojom::CubicBezierTimingFunctionPtr result(::viz::mojom::CubicBezierTimingFunction::New());
  
      if (success)
        result->x1 = input.x1();
      if (success)
        result->y1 = input.y1();
      if (success)
        result->x2 = input.x2();
      if (success)
        result->y2 = input.y2();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::StepsTimingFunction::DataView, ::viz::mojom::StepsTimingFunctionPtr>::Read(
    ::viz::mojom::StepsTimingFunction::DataView input,
    ::viz::mojom::StepsTimingFunctionPtr* output) {
  bool success = true;
  ::viz::mojom::StepsTimingFunctionPtr result(::viz::mojom::StepsTimingFunction::New());
  
      if (success)
        result->num_steps = input.num_steps();
      if (success && !input.ReadStepPosition(&result->step_position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::LinearEasingPoint::DataView, ::viz::mojom::LinearEasingPointPtr>::Read(
    ::viz::mojom::LinearEasingPoint::DataView input,
    ::viz::mojom::LinearEasingPointPtr* output) {
  bool success = true;
  ::viz::mojom::LinearEasingPointPtr result(::viz::mojom::LinearEasingPoint::New());
  
      if (success)
        result->in = input.in();
      if (success)
        result->out = input.out();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AxisAngle::DataView, ::viz::mojom::AxisAnglePtr>::Read(
    ::viz::mojom::AxisAngle::DataView input,
    ::viz::mojom::AxisAnglePtr* output) {
  bool success = true;
  ::viz::mojom::AxisAnglePtr result(::viz::mojom::AxisAngle::New());
  
      if (success && !input.ReadAxis(&result->axis))
        success = false;
      if (success)
        result->angle = input.angle();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AnimationKeyframe::DataView, ::viz::mojom::AnimationKeyframePtr>::Read(
    ::viz::mojom::AnimationKeyframe::DataView input,
    ::viz::mojom::AnimationKeyframePtr* output) {
  bool success = true;
  ::viz::mojom::AnimationKeyframePtr result(::viz::mojom::AnimationKeyframe::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success && !input.ReadTimingFunction(&result->timing_function))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AnimationKeyframeModel::DataView, ::viz::mojom::AnimationKeyframeModelPtr>::Read(
    ::viz::mojom::AnimationKeyframeModel::DataView input,
    ::viz::mojom::AnimationKeyframeModelPtr* output) {
  bool success = true;
  ::viz::mojom::AnimationKeyframeModelPtr result(::viz::mojom::AnimationKeyframeModel::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->group_id = input.group_id();
      if (success)
        result->target_property_type = input.target_property_type();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadTimingFunction(&result->timing_function))
        success = false;
      if (success && !input.ReadKeyframes(&result->keyframes))
        success = false;
      if (success)
        result->scaled_duration = input.scaled_duration();
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success && !input.ReadFillMode(&result->fill_mode))
        success = false;
      if (success)
        result->playback_rate = input.playback_rate();
      if (success)
        result->iterations = input.iterations();
      if (success)
        result->iteration_start = input.iteration_start();
      if (success && !input.ReadTimeOffset(&result->time_offset))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::Animation::DataView, ::viz::mojom::AnimationPtr>::Read(
    ::viz::mojom::Animation::DataView input,
    ::viz::mojom::AnimationPtr* output) {
  bool success = true;
  ::viz::mojom::AnimationPtr result(::viz::mojom::Animation::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadKeyframeModels(&result->keyframe_models))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::AnimationTimeline::DataView, ::viz::mojom::AnimationTimelinePtr>::Read(
    ::viz::mojom::AnimationTimeline::DataView input,
    ::viz::mojom::AnimationTimelinePtr* output) {
  bool success = true;
  ::viz::mojom::AnimationTimelinePtr result(::viz::mojom::AnimationTimeline::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadNewAnimations(&result->new_animations))
        success = false;
      if (success && !input.ReadRemovedAnimations(&result->removed_animations))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::TimingFunction::DataView, ::viz::mojom::TimingFunctionPtr>::Read(
    ::viz::mojom::TimingFunction::DataView input,
    ::viz::mojom::TimingFunctionPtr* output) {
  using UnionType = ::viz::mojom::TimingFunction;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCubicBezier: {
      ::viz::mojom::CubicBezierTimingFunctionPtr result_cubic_bezier;
      if (!input.ReadCubicBezier(&result_cubic_bezier))
        return false;

      *output = UnionType::NewCubicBezier(
          std::move(result_cubic_bezier));
      break;
    }
    case Tag::kSteps: {
      ::viz::mojom::StepsTimingFunctionPtr result_steps;
      if (!input.ReadSteps(&result_steps))
        return false;

      *output = UnionType::NewSteps(
          std::move(result_steps));
      break;
    }
    case Tag::kLinear: {
      std::vector<::viz::mojom::LinearEasingPointPtr> result_linear;
      if (!input.ReadLinear(&result_linear))
        return false;

      *output = UnionType::NewLinear(
          std::move(result_linear));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::viz::mojom::TransformOperation::DataView, ::viz::mojom::TransformOperationPtr>::Read(
    ::viz::mojom::TransformOperation::DataView input,
    ::viz::mojom::TransformOperationPtr* output) {
  using UnionType = ::viz::mojom::TransformOperation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIdentity: {
      *output = UnionType::NewIdentity(input.identity());
      break;
    }
    case Tag::kPerspectiveDepth: {
      *output = UnionType::NewPerspectiveDepth(input.perspective_depth());
      break;
    }
    case Tag::kSkew: {
      ::gfx::Vector2dF result_skew;
      if (!input.ReadSkew(&result_skew))
        return false;

      *output = UnionType::NewSkew(
          std::move(result_skew));
      break;
    }
    case Tag::kScale: {
      ::gfx::Vector3dF result_scale;
      if (!input.ReadScale(&result_scale))
        return false;

      *output = UnionType::NewScale(
          std::move(result_scale));
      break;
    }
    case Tag::kTranslate: {
      ::gfx::Vector3dF result_translate;
      if (!input.ReadTranslate(&result_translate))
        return false;

      *output = UnionType::NewTranslate(
          std::move(result_translate));
      break;
    }
    case Tag::kRotate: {
      ::viz::mojom::AxisAnglePtr result_rotate;
      if (!input.ReadRotate(&result_rotate))
        return false;

      *output = UnionType::NewRotate(
          std::move(result_rotate));
      break;
    }
    case Tag::kMatrix: {
      ::gfx::Transform result_matrix;
      if (!input.ReadMatrix(&result_matrix))
        return false;

      *output = UnionType::NewMatrix(
          std::move(result_matrix));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::viz::mojom::AnimationKeyframeValue::DataView, ::viz::mojom::AnimationKeyframeValuePtr>::Read(
    ::viz::mojom::AnimationKeyframeValue::DataView input,
    ::viz::mojom::AnimationKeyframeValuePtr* output) {
  using UnionType = ::viz::mojom::AnimationKeyframeValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kScalar: {
      *output = UnionType::NewScalar(input.scalar());
      break;
    }
    case Tag::kColor: {
      ::SkColor result_color;
      if (!input.ReadColor(&result_color))
        return false;

      *output = UnionType::NewColor(
          std::move(result_color));
      break;
    }
    case Tag::kSize: {
      ::gfx::SizeF result_size;
      if (!input.ReadSize(&result_size))
        return false;

      *output = UnionType::NewSize(
          std::move(result_size));
      break;
    }
    case Tag::kRect: {
      ::gfx::Rect result_rect;
      if (!input.ReadRect(&result_rect))
        return false;

      *output = UnionType::NewRect(
          std::move(result_rect));
      break;
    }
    case Tag::kTransform: {
      std::vector<::viz::mojom::TransformOperationPtr> result_transform;
      if (!input.ReadTransform(&result_transform))
        return false;

      *output = UnionType::NewTransform(
          std::move(result_transform));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif