// services/network/public/mojom/sri_message_signature.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/sri_message_signature.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/sri_message_signature.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {










class  SRIMessageSignatureComponent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatureComponent, T>::value>;
  using DataView = SRIMessageSignatureComponentDataView;
  using Data_ = internal::SRIMessageSignatureComponent_Data;
  using Parameter = SRIMessageSignatureComponent_Parameter;

  template <typename... Args>
  static SRIMessageSignatureComponentPtr New(Args&&... args) {
    return SRIMessageSignatureComponentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignatureComponentPtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignatureComponentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatureComponent>::Convert(*this);
  }


  SRIMessageSignatureComponent();

  SRIMessageSignatureComponent(
      const std::string& name,
      std::vector<SRIMessageSignatureComponent::Parameter> params);


  ~SRIMessageSignatureComponent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignatureComponentPtr>
  SRIMessageSignatureComponentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatureComponent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatureComponent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatureComponent_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatureComponent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatureComponent_UnserializedMessageContext<
            UserType, SRIMessageSignatureComponent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatureComponent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::vector<SRIMessageSignatureComponent::Parameter> params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SRIMessageSignature {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignature, T>::value>;
  using DataView = SRIMessageSignatureDataView;
  using Data_ = internal::SRIMessageSignature_Data;

  template <typename... Args>
  static SRIMessageSignaturePtr New(Args&&... args) {
    return SRIMessageSignaturePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignaturePtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignaturePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignature>::Convert(*this);
  }


  SRIMessageSignature();

  SRIMessageSignature(
      const std::string& label,
      std::vector<uint8_t> signature,
      std::vector<SRIMessageSignatureComponentPtr> components,
      std::optional<int64_t> created,
      std::optional<int64_t> expires,
      const std::optional<std::string>& keyid,
      const std::optional<std::string>& nonce,
      const std::optional<std::string>& tag,
      const std::string& serialized_signature_params);

SRIMessageSignature(const SRIMessageSignature&) = delete;
SRIMessageSignature& operator=(const SRIMessageSignature&) = delete;

  ~SRIMessageSignature();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignaturePtr>
  SRIMessageSignaturePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignature::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignature::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignature_UnserializedMessageContext<
            UserType, SRIMessageSignature::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignature::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignature::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignature_UnserializedMessageContext<
            UserType, SRIMessageSignature::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignature::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string label;
  
  std::vector<uint8_t> signature;
  
  std::vector<SRIMessageSignatureComponentPtr> components;
  
  std::optional<int64_t> created;
  
  std::optional<int64_t> expires;
  
  std::optional<std::string> keyid;
  
  std::optional<std::string> nonce;
  
  std::optional<std::string> tag;
  
  std::string serialized_signature_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignature::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SRIMessageSignatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SRIMessageSignatures, T>::value>;
  using DataView = SRIMessageSignaturesDataView;
  using Data_ = internal::SRIMessageSignatures_Data;

  template <typename... Args>
  static SRIMessageSignaturesPtr New(Args&&... args) {
    return SRIMessageSignaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SRIMessageSignaturesPtr From(const U& u) {
    return mojo::TypeConverter<SRIMessageSignaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SRIMessageSignatures>::Convert(*this);
  }


  SRIMessageSignatures();

  SRIMessageSignatures(
      std::vector<SRIMessageSignaturePtr> signatures,
      std::vector<SRIMessageSignatureError> errors);

SRIMessageSignatures(const SRIMessageSignatures&) = delete;
SRIMessageSignatures& operator=(const SRIMessageSignatures&) = delete;

  ~SRIMessageSignatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SRIMessageSignaturesPtr>
  SRIMessageSignaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SRIMessageSignatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SRIMessageSignatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SRIMessageSignatures_UnserializedMessageContext<
            UserType, SRIMessageSignatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SRIMessageSignatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SRIMessageSignatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SRIMessageSignatures_UnserializedMessageContext<
            UserType, SRIMessageSignatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SRIMessageSignatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SRIMessageSignaturePtr> signatures;
  
  std::vector<SRIMessageSignatureError> errors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SRIMessageSignatureComponentPtr SRIMessageSignatureComponent::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(params)
  );
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>*>
bool SRIMessageSignatureComponent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, SRIMessageSignatureComponent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignaturePtr SRIMessageSignature::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(signature),
      mojo::Clone(components),
      mojo::Clone(created),
      mojo::Clone(expires),
      mojo::Clone(keyid),
      mojo::Clone(nonce),
      mojo::Clone(tag),
      mojo::Clone(serialized_signature_params)
  );
}

template <typename T, SRIMessageSignature::EnableIfSame<T>*>
bool SRIMessageSignature::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->components, other_struct.components))
    return false;
  if (!mojo::Equals(this->created, other_struct.created))
    return false;
  if (!mojo::Equals(this->expires, other_struct.expires))
    return false;
  if (!mojo::Equals(this->keyid, other_struct.keyid))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->serialized_signature_params, other_struct.serialized_signature_params))
    return false;
  return true;
}

template <typename T, SRIMessageSignature::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.components < rhs.components)
    return true;
  if (rhs.components < lhs.components)
    return false;
  if (lhs.created < rhs.created)
    return true;
  if (rhs.created < lhs.created)
    return false;
  if (lhs.expires < rhs.expires)
    return true;
  if (rhs.expires < lhs.expires)
    return false;
  if (lhs.keyid < rhs.keyid)
    return true;
  if (rhs.keyid < lhs.keyid)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.serialized_signature_params < rhs.serialized_signature_params)
    return true;
  if (rhs.serialized_signature_params < lhs.serialized_signature_params)
    return false;
  return false;
}
template <typename StructPtrType>
SRIMessageSignaturesPtr SRIMessageSignatures::Clone() const {
  return New(
      mojo::Clone(signatures),
      mojo::Clone(errors)
  );
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>*>
bool SRIMessageSignatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->signatures, other_struct.signatures))
    return false;
  if (!mojo::Equals(this->errors, other_struct.errors))
    return false;
  return true;
}

template <typename T, SRIMessageSignatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.signatures < rhs.signatures)
    return true;
  if (rhs.signatures < lhs.signatures)
    return false;
  if (lhs.errors < rhs.errors)
    return true;
  if (rhs.errors < lhs.errors)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SRIMessageSignatureComponent::DataView,
                                         ::network::mojom::SRIMessageSignatureComponentPtr> {
  static bool IsNull(const ::network::mojom::SRIMessageSignatureComponentPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SRIMessageSignatureComponentPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SRIMessageSignatureComponent::name)& name(
      const ::network::mojom::SRIMessageSignatureComponentPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::SRIMessageSignatureComponent::params)& params(
      const ::network::mojom::SRIMessageSignatureComponentPtr& input) {
    return input->params;
  }

  static bool Read(::network::mojom::SRIMessageSignatureComponent::DataView input, ::network::mojom::SRIMessageSignatureComponentPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SRIMessageSignature::DataView,
                                         ::network::mojom::SRIMessageSignaturePtr> {
  static bool IsNull(const ::network::mojom::SRIMessageSignaturePtr& input) { return !input; }
  static void SetToNull(::network::mojom::SRIMessageSignaturePtr* output) { output->reset(); }

  static const decltype(::network::mojom::SRIMessageSignature::label)& label(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->label;
  }

  static const decltype(::network::mojom::SRIMessageSignature::signature)& signature(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->signature;
  }

  static const decltype(::network::mojom::SRIMessageSignature::components)& components(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->components;
  }

  static decltype(::network::mojom::SRIMessageSignature::created) created(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->created;
  }

  static decltype(::network::mojom::SRIMessageSignature::expires) expires(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->expires;
  }

  static const decltype(::network::mojom::SRIMessageSignature::keyid)& keyid(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->keyid;
  }

  static const decltype(::network::mojom::SRIMessageSignature::nonce)& nonce(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->nonce;
  }

  static const decltype(::network::mojom::SRIMessageSignature::tag)& tag(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->tag;
  }

  static const decltype(::network::mojom::SRIMessageSignature::serialized_signature_params)& serialized_signature_params(
      const ::network::mojom::SRIMessageSignaturePtr& input) {
    return input->serialized_signature_params;
  }

  static bool Read(::network::mojom::SRIMessageSignature::DataView input, ::network::mojom::SRIMessageSignaturePtr* output);
};


template <>
struct  StructTraits<::network::mojom::SRIMessageSignatures::DataView,
                                         ::network::mojom::SRIMessageSignaturesPtr> {
  static bool IsNull(const ::network::mojom::SRIMessageSignaturesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SRIMessageSignaturesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SRIMessageSignatures::signatures)& signatures(
      const ::network::mojom::SRIMessageSignaturesPtr& input) {
    return input->signatures;
  }

  static const decltype(::network::mojom::SRIMessageSignatures::errors)& errors(
      const ::network::mojom::SRIMessageSignaturesPtr& input) {
    return input->errors;
  }

  static bool Read(::network::mojom::SRIMessageSignatures::DataView input, ::network::mojom::SRIMessageSignaturesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_H_