// services/network/public/mojom/network_isolation_key.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_isolation_key.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_isolation_key.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_isolation_key.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/schemeful_site.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {





class BLINK_PLATFORM_EXPORT EmptyNetworkIsolationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmptyNetworkIsolationKey, T>::value>;
  using DataView = EmptyNetworkIsolationKeyDataView;
  using Data_ = internal::EmptyNetworkIsolationKey_Data;

  template <typename... Args>
  static EmptyNetworkIsolationKeyPtr New(Args&&... args) {
    return EmptyNetworkIsolationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmptyNetworkIsolationKeyPtr From(const U& u) {
    return mojo::TypeConverter<EmptyNetworkIsolationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmptyNetworkIsolationKey>::Convert(*this);
  }


  EmptyNetworkIsolationKey();


  ~EmptyNetworkIsolationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmptyNetworkIsolationKeyPtr>
  EmptyNetworkIsolationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmptyNetworkIsolationKey::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmptyNetworkIsolationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmptyNetworkIsolationKey_UnserializedMessageContext<
            UserType, EmptyNetworkIsolationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EmptyNetworkIsolationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EmptyNetworkIsolationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmptyNetworkIsolationKey_UnserializedMessageContext<
            UserType, EmptyNetworkIsolationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmptyNetworkIsolationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT NetworkIsolationKey {
 public:
  using DataView = NetworkIsolationKeyDataView;
  using Data_ = internal::NetworkIsolationKey_Data;
  using Tag = Data_::NetworkIsolationKey_Tag;

  template <typename... Args>
  static NetworkIsolationKeyPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |empty|.
  static NetworkIsolationKeyPtr
  NewEmpty(
      EmptyNetworkIsolationKeyPtr value) {
    auto result = NetworkIsolationKeyPtr(std::in_place);
    result->set_empty(std::move(value));
    return result;
  }
  // Construct an instance holding |non_empty|.
  static NetworkIsolationKeyPtr
  NewNonEmpty(
      NonEmptyNetworkIsolationKeyPtr value) {
    auto result = NetworkIsolationKeyPtr(std::in_place);
    result->set_non_empty(std::move(value));
    return result;
  }

  template <typename U>
  static NetworkIsolationKeyPtr From(const U& u) {
    return mojo::TypeConverter<NetworkIsolationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkIsolationKey>::Convert(*this);
  }

  NetworkIsolationKey();
  ~NetworkIsolationKey();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  NetworkIsolationKey(const NetworkIsolationKey& other) = delete;
  NetworkIsolationKey& operator=(const NetworkIsolationKey& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NetworkIsolationKeyPtr>
  NetworkIsolationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkIsolationKey>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkIsolationKey>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_empty() const { return tag_ == Tag::kEmpty; }

  
  EmptyNetworkIsolationKeyPtr& get_empty() const {
    CHECK(tag_ == Tag::kEmpty);
    return *(data_.empty);
  }

  
  void set_empty(
      EmptyNetworkIsolationKeyPtr empty);
  
  bool is_non_empty() const { return tag_ == Tag::kNonEmpty; }

  
  NonEmptyNetworkIsolationKeyPtr& get_non_empty() const {
    CHECK(tag_ == Tag::kNonEmpty);
    return *(data_.non_empty);
  }

  
  void set_non_empty(
      NonEmptyNetworkIsolationKeyPtr non_empty);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkIsolationKey::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkIsolationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    EmptyNetworkIsolationKeyPtr* empty;
    NonEmptyNetworkIsolationKeyPtr* non_empty;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class BLINK_PLATFORM_EXPORT NonEmptyNetworkIsolationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NonEmptyNetworkIsolationKey, T>::value>;
  using DataView = NonEmptyNetworkIsolationKeyDataView;
  using Data_ = internal::NonEmptyNetworkIsolationKey_Data;

  template <typename... Args>
  static NonEmptyNetworkIsolationKeyPtr New(Args&&... args) {
    return NonEmptyNetworkIsolationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NonEmptyNetworkIsolationKeyPtr From(const U& u) {
    return mojo::TypeConverter<NonEmptyNetworkIsolationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NonEmptyNetworkIsolationKey>::Convert(*this);
  }


  NonEmptyNetworkIsolationKey();

  NonEmptyNetworkIsolationKey(
      const ::blink::BlinkSchemefulSite& top_frame_site,
      const ::blink::BlinkSchemefulSite& frame_site,
      const std::optional<::base::UnguessableToken>& nonce);


  ~NonEmptyNetworkIsolationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NonEmptyNetworkIsolationKeyPtr>
  NonEmptyNetworkIsolationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NonEmptyNetworkIsolationKey::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NonEmptyNetworkIsolationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NonEmptyNetworkIsolationKey_UnserializedMessageContext<
            UserType, NonEmptyNetworkIsolationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NonEmptyNetworkIsolationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NonEmptyNetworkIsolationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NonEmptyNetworkIsolationKey_UnserializedMessageContext<
            UserType, NonEmptyNetworkIsolationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NonEmptyNetworkIsolationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::BlinkSchemefulSite top_frame_site;
  
  ::blink::BlinkSchemefulSite frame_site;
  
  std::optional<::base::UnguessableToken> nonce;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
NetworkIsolationKeyPtr NetworkIsolationKey::Clone() const {
  switch (tag_) {
    case Tag::kEmpty:
      return NewEmpty(
          mojo::Clone(*data_.empty));
    case Tag::kNonEmpty:
      return NewNonEmpty(
          mojo::Clone(*data_.non_empty));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, NetworkIsolationKey>::value>::type*>
bool NetworkIsolationKey::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEmpty:
      return mojo::Equals(*(data_.empty), *(other.data_.empty));
    case Tag::kNonEmpty:
      return mojo::Equals(*(data_.non_empty), *(other.data_.non_empty));
  }

  return false;
}
template <typename StructPtrType>
EmptyNetworkIsolationKeyPtr EmptyNetworkIsolationKey::Clone() const {
  return New(
  );
}

template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>*>
bool EmptyNetworkIsolationKey::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EmptyNetworkIsolationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
NonEmptyNetworkIsolationKeyPtr NonEmptyNetworkIsolationKey::Clone() const {
  return New(
      mojo::Clone(top_frame_site),
      mojo::Clone(frame_site),
      mojo::Clone(nonce)
  );
}

template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>*>
bool NonEmptyNetworkIsolationKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_frame_site, other_struct.top_frame_site))
    return false;
  if (!mojo::Equals(this->frame_site, other_struct.frame_site))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  return true;
}

template <typename T, NonEmptyNetworkIsolationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_frame_site < rhs.top_frame_site)
    return true;
  if (rhs.top_frame_site < lhs.top_frame_site)
    return false;
  if (lhs.frame_site < rhs.frame_site)
    return true;
  if (rhs.frame_site < lhs.frame_site)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::EmptyNetworkIsolationKey::DataView,
                                         ::network::mojom::blink::EmptyNetworkIsolationKeyPtr> {
  static bool IsNull(const ::network::mojom::blink::EmptyNetworkIsolationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::EmptyNetworkIsolationKeyPtr* output) { output->reset(); }

  static bool Read(::network::mojom::blink::EmptyNetworkIsolationKey::DataView input, ::network::mojom::blink::EmptyNetworkIsolationKeyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::NonEmptyNetworkIsolationKey::DataView,
                                         ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr> {
  static bool IsNull(const ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::NonEmptyNetworkIsolationKey::top_frame_site)& top_frame_site(
      const ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr& input) {
    return input->top_frame_site;
  }

  static const decltype(::network::mojom::blink::NonEmptyNetworkIsolationKey::frame_site)& frame_site(
      const ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr& input) {
    return input->frame_site;
  }

  static const decltype(::network::mojom::blink::NonEmptyNetworkIsolationKey::nonce)& nonce(
      const ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr& input) {
    return input->nonce;
  }

  static bool Read(::network::mojom::blink::NonEmptyNetworkIsolationKey::DataView input, ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::NetworkIsolationKey::DataView,
                                        ::network::mojom::blink::NetworkIsolationKeyPtr> {
  static bool IsNull(const ::network::mojom::blink::NetworkIsolationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::NetworkIsolationKeyPtr* output) { output->reset(); }

  static ::network::mojom::blink::NetworkIsolationKey::Tag GetTag(const ::network::mojom::blink::NetworkIsolationKeyPtr& input) {
    return input->which();
  }

  static const ::network::mojom::blink::EmptyNetworkIsolationKeyPtr& empty(const ::network::mojom::blink::NetworkIsolationKeyPtr& input) {
    return input->get_empty();
  }

  static const ::network::mojom::blink::NonEmptyNetworkIsolationKeyPtr& non_empty(const ::network::mojom::blink::NetworkIsolationKeyPtr& input) {
    return input->get_non_empty();
  }

  static bool Read(::network::mojom::blink::NetworkIsolationKey::DataView input, ::network::mojom::blink::NetworkIsolationKeyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_BLINK_H_