// services/media_session/public/mojom/media_session.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/media_session/public/mojom/media_session.mojom-features.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/media_session.mojom-shared.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/media_session.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/media_session/public/cpp/media_session_mojom_traits.h"




namespace media_session::mojom {

class MediaSessionObserverProxy;

template <typename ImplRefTraits>
class MediaSessionObserverStub;

class MediaSessionObserverRequestValidator;


class MediaSessionObserver
    : public MediaSessionObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaSessionObserverInterfaceBase;
  using Proxy_ = MediaSessionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMediaSessionInfoChangedMinVersion = 0,
    kMediaSessionMetadataChangedMinVersion = 0,
    kMediaSessionActionsChangedMinVersion = 0,
    kMediaSessionImagesChangedMinVersion = 0,
    kMediaSessionPositionChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MediaSessionInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionMetadataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionActionsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionImagesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionPositionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaSessionObserver() = default;

  
  virtual void MediaSessionInfoChanged(MediaSessionInfoPtr info) = 0;

  
  virtual void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) = 0;

  
  virtual void MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) = 0;

  
  virtual void MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) = 0;

  
  virtual void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) = 0;
};

class MediaSessionProxy;

template <typename ImplRefTraits>
class MediaSessionStub;

class MediaSessionRequestValidator;
class MediaSessionResponseValidator;


class MediaSession
    : public MediaSessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 23;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaSessionInterfaceBase;
  using Proxy_ = MediaSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionRequestValidator;
  using ResponseValidator_ = MediaSessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMediaSessionInfoMinVersion = 0,
    kGetDebugInfoMinVersion = 0,
    kStartDuckingMinVersion = 0,
    kStopDuckingMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kAddObserverMinVersion = 0,
    kPreviousTrackMinVersion = 0,
    kNextTrackMinVersion = 0,
    kSeekMinVersion = 0,
    kStopMinVersion = 0,
    kSkipAdMinVersion = 0,
    kGetMediaImageBitmapMinVersion = 0,
    kSeekToMinVersion = 0,
    kScrubToMinVersion = 0,
    kEnterPictureInPictureMinVersion = 0,
    kExitPictureInPictureMinVersion = 0,
    kSetAudioSinkIdMinVersion = 0,
    kToggleMicrophoneMinVersion = 11,
    kToggleCameraMinVersion = 11,
    kHangUpMinVersion = 11,
    kRaiseMinVersion = 12,
    kSetMuteMinVersion = 13,
    kRequestMediaRemotingMinVersion = 16,
    kPreviousSlideMinVersion = 18,
    kNextSlideMinVersion = 18,
    kEnterAutoPictureInPictureMinVersion = 19,
    kGetVisibilityMinVersion = 23,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetMediaSessionInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDebugInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDucking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopDucking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Suspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviousTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NextTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Seek_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SkipAd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMediaImageBitmap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SeekTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrubTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAudioSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleMicrophone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleCamera_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HangUp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Raise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestMediaRemoting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviousSlide_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NextSlide_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterAutoPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using SuspendType = MediaSession_SuspendType;
  virtual ~MediaSession() = default;


  using GetMediaSessionInfoCallback = base::OnceCallback<void(MediaSessionInfoPtr)>;
  
  virtual void GetMediaSessionInfo(GetMediaSessionInfoCallback callback) = 0;


  using GetDebugInfoCallback = base::OnceCallback<void(MediaSessionDebugInfoPtr)>;
  
  virtual void GetDebugInfo(GetDebugInfoCallback callback) = 0;

  
  virtual void StartDucking() = 0;

  
  virtual void StopDucking() = 0;

  
  virtual void Suspend(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void Resume(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) = 0;

  
  virtual void PreviousTrack() = 0;

  
  virtual void NextTrack() = 0;

  
  virtual void Seek(::base::TimeDelta seek_time) = 0;

  
  virtual void Stop(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void SkipAd() = 0;


  using GetMediaImageBitmapCallback = base::OnceCallback<void(const ::SkBitmap&)>;
  
  virtual void GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) = 0;

  
  virtual void SeekTo(::base::TimeDelta seek_time) = 0;

  
  virtual void ScrubTo(::base::TimeDelta seek_time) = 0;

  
  virtual void EnterPictureInPicture() = 0;

  
  virtual void ExitPictureInPicture() = 0;

  
  virtual void SetAudioSinkId(const std::optional<std::string>& id) = 0;

  
  virtual void ToggleMicrophone() = 0;

  
  virtual void ToggleCamera() = 0;

  
  virtual void HangUp() = 0;

  
  virtual void Raise() = 0;

  
  virtual void SetMute(bool mute) = 0;

  
  virtual void RequestMediaRemoting() = 0;

  
  virtual void PreviousSlide() = 0;

  
  virtual void NextSlide() = 0;

  
  virtual void EnterAutoPictureInPicture() = 0;


  using GetVisibilityCallback = base::OnceCallback<void(bool)>;
  
  virtual void GetVisibility(GetVisibilityCallback callback) = 0;
};



class  MediaSessionObserverProxy
    : public MediaSessionObserver {
 public:
  using InterfaceType = MediaSessionObserver;

  explicit MediaSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MediaSessionInfoChanged(MediaSessionInfoPtr info) final;
  
  void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) final;
  
  void MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) final;
  
  void MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) final;
  
  void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaSessionProxy
    : public MediaSession {
 public:
  using InterfaceType = MediaSession;

  explicit MediaSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetMediaSessionInfo(GetMediaSessionInfoCallback callback) final;
  
  void GetDebugInfo(GetDebugInfoCallback callback) final;
  
  void StartDucking() final;
  
  void StopDucking() final;
  
  void Suspend(MediaSession::SuspendType suspend_type) final;
  
  void Resume(MediaSession::SuspendType suspend_type) final;
  
  void AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) final;
  
  void PreviousTrack() final;
  
  void NextTrack() final;
  
  void Seek(::base::TimeDelta seek_time) final;
  
  void Stop(MediaSession::SuspendType suspend_type) final;
  
  void SkipAd() final;
  
  void GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) final;
  
  void SeekTo(::base::TimeDelta seek_time) final;
  
  void ScrubTo(::base::TimeDelta seek_time) final;
  
  void EnterPictureInPicture() final;
  
  void ExitPictureInPicture() final;
  
  void SetAudioSinkId(const std::optional<std::string>& id) final;
  
  void ToggleMicrophone() final;
  
  void ToggleCamera() final;
  
  void HangUp() final;
  
  void Raise() final;
  
  void SetMute(bool mute) final;
  
  void RequestMediaRemoting() final;
  
  void PreviousSlide() final;
  
  void NextSlide() final;
  
  void EnterAutoPictureInPicture() final;
  
  void GetVisibility(GetVisibilityCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaSessionObserverStubDispatch {
 public:
  static bool Accept(MediaSessionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSessionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSessionObserver>>
class MediaSessionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionObserverStub() = default;
  ~MediaSessionObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaSessionStubDispatch {
 public:
  static bool Accept(MediaSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSession>>
class MediaSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionStub() = default;
  ~MediaSessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaSessionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaSessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class  MediaSessionDebugInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSessionDebugInfo, T>::value>;
  using DataView = MediaSessionDebugInfoDataView;
  using Data_ = internal::MediaSessionDebugInfo_Data;

  template <typename... Args>
  static MediaSessionDebugInfoPtr New(Args&&... args) {
    return MediaSessionDebugInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSessionDebugInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionDebugInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionDebugInfo>::Convert(*this);
  }


  MediaSessionDebugInfo();

  MediaSessionDebugInfo(
      const std::string& name,
      const std::string& owner,
      const std::string& state);


  ~MediaSessionDebugInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSessionDebugInfoPtr>
  MediaSessionDebugInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSessionDebugInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionDebugInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSessionDebugInfo_UnserializedMessageContext<
            UserType, MediaSessionDebugInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaSessionDebugInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaSessionDebugInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSessionDebugInfo_UnserializedMessageContext<
            UserType, MediaSessionDebugInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSessionDebugInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string owner;
  
  std::string state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  MediaImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaImage, T>::value>;
  using DataView = MediaImageDataView;
  using Data_ = internal::MediaImage_Data;

  template <typename... Args>
  static MediaImagePtr New(Args&&... args) {
    return MediaImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaImagePtr From(const U& u) {
    return mojo::TypeConverter<MediaImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaImage>::Convert(*this);
  }


  MediaImage();

  MediaImage(
      const ::GURL& src,
      const ::std::u16string& type,
      std::vector<::gfx::Size> sizes);


  ~MediaImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaImagePtr>
  MediaImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaImage_UnserializedMessageContext<
            UserType, MediaImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaImage_UnserializedMessageContext<
            UserType, MediaImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL src;
  
  ::std::u16string type;
  
  std::vector<::gfx::Size> sizes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ChapterInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChapterInformation, T>::value>;
  using DataView = ChapterInformationDataView;
  using Data_ = internal::ChapterInformation_Data;

  template <typename... Args>
  static ChapterInformationPtr New(Args&&... args) {
    return ChapterInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChapterInformationPtr From(const U& u) {
    return mojo::TypeConverter<ChapterInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChapterInformation>::Convert(*this);
  }


  ChapterInformation();

  ChapterInformation(
      const ::std::u16string& title,
      ::base::TimeDelta startTime,
      std::vector<::media_session::MediaImage> artwork);


  ~ChapterInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChapterInformationPtr>
  ChapterInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChapterInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChapterInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChapterInformation_UnserializedMessageContext<
            UserType, ChapterInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChapterInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChapterInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChapterInformation_UnserializedMessageContext<
            UserType, ChapterInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChapterInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  ::base::TimeDelta startTime;
  
  std::vector<::media_session::MediaImage> artwork;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChapterInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaMetadata, T>::value>;
  using DataView = MediaMetadataDataView;
  using Data_ = internal::MediaMetadata_Data;

  template <typename... Args>
  static MediaMetadataPtr New(Args&&... args) {
    return MediaMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaMetadataPtr From(const U& u) {
    return mojo::TypeConverter<MediaMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaMetadata>::Convert(*this);
  }


  MediaMetadata();

  MediaMetadata(
      const ::std::u16string& title,
      const ::std::u16string& artist,
      const ::std::u16string& album,
      const ::std::u16string& source_title);

  MediaMetadata(
      const ::std::u16string& title,
      const ::std::u16string& artist,
      const ::std::u16string& album,
      const ::std::u16string& source_title,
      std::optional<std::vector<::media_session::ChapterInformation>> chapters);


  ~MediaMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaMetadataPtr>
  MediaMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  ::std::u16string artist;
  
  ::std::u16string album;
  
  ::std::u16string source_title;
  
  std::optional<std::vector<::media_session::ChapterInformation>> chapters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaImageBitmap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaImageBitmap, T>::value>;
  using DataView = MediaImageBitmapDataView;
  using Data_ = internal::MediaImageBitmap_Data;

  template <typename... Args>
  static MediaImageBitmapPtr New(Args&&... args) {
    return MediaImageBitmapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaImageBitmapPtr From(const U& u) {
    return mojo::TypeConverter<MediaImageBitmapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaImageBitmap>::Convert(*this);
  }


  MediaImageBitmap();

  MediaImageBitmap(
      int32_t width,
      int32_t height,
      std::vector<uint8_t> pixel_data);

  MediaImageBitmap(
      int32_t width,
      int32_t height,
      std::vector<uint8_t> pixel_data,
      MediaImageBitmapColorType color_type);


  ~MediaImageBitmap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaImageBitmapPtr>
  MediaImageBitmapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaImageBitmap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaImageBitmap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaImageBitmap_UnserializedMessageContext<
            UserType, MediaImageBitmap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaImageBitmap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaImageBitmap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaImageBitmap_UnserializedMessageContext<
            UserType, MediaImageBitmap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaImageBitmap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t width;
  
  int32_t height;
  
  std::vector<uint8_t> pixel_data;
  
  MediaImageBitmapColorType color_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaPosition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaPosition, T>::value>;
  using DataView = MediaPositionDataView;
  using Data_ = internal::MediaPosition_Data;

  template <typename... Args>
  static MediaPositionPtr New(Args&&... args) {
    return MediaPositionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaPositionPtr From(const U& u) {
    return mojo::TypeConverter<MediaPositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaPosition>::Convert(*this);
  }


  MediaPosition();

  MediaPosition(
      double playback_rate,
      ::base::TimeDelta duration,
      ::base::TimeDelta position,
      ::base::TimeTicks last_updated_time);

  MediaPosition(
      double playback_rate,
      ::base::TimeDelta duration,
      ::base::TimeDelta position,
      ::base::TimeTicks last_updated_time,
      bool end_of_media);


  ~MediaPosition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaPositionPtr>
  MediaPositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaPosition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaPosition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaPosition_UnserializedMessageContext<
            UserType, MediaPosition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaPosition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaPosition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaPosition_UnserializedMessageContext<
            UserType, MediaPosition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaPosition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double playback_rate;
  
  ::base::TimeDelta duration;
  
  ::base::TimeDelta position;
  
  ::base::TimeTicks last_updated_time;
  
  bool end_of_media;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RemotePlaybackMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemotePlaybackMetadata, T>::value>;
  using DataView = RemotePlaybackMetadataDataView;
  using Data_ = internal::RemotePlaybackMetadata_Data;

  template <typename... Args>
  static RemotePlaybackMetadataPtr New(Args&&... args) {
    return RemotePlaybackMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemotePlaybackMetadataPtr From(const U& u) {
    return mojo::TypeConverter<RemotePlaybackMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemotePlaybackMetadata>::Convert(*this);
  }


  RemotePlaybackMetadata();

  RemotePlaybackMetadata(
      const std::string& video_codec,
      const std::string& audio_codec,
      bool remote_playback_disabled);

  RemotePlaybackMetadata(
      const std::string& video_codec,
      const std::string& audio_codec,
      bool remote_playback_disabled,
      bool remote_playback_started,
      const std::optional<std::string>& unused_field);

  RemotePlaybackMetadata(
      const std::string& video_codec,
      const std::string& audio_codec,
      bool remote_playback_disabled,
      bool remote_playback_started,
      const std::optional<std::string>& unused_field,
      bool is_encrypted_media);


  ~RemotePlaybackMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemotePlaybackMetadataPtr>
  RemotePlaybackMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemotePlaybackMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemotePlaybackMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemotePlaybackMetadata_UnserializedMessageContext<
            UserType, RemotePlaybackMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemotePlaybackMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemotePlaybackMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemotePlaybackMetadata_UnserializedMessageContext<
            UserType, RemotePlaybackMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemotePlaybackMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string video_codec;
  
  std::string audio_codec;
  
  bool remote_playback_disabled;
  
  bool remote_playback_started;
  
  std::optional<std::string> unused_field;
  
  bool is_encrypted_media;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemotePlaybackMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaSessionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSessionInfo, T>::value>;
  using DataView = MediaSessionInfoDataView;
  using Data_ = internal::MediaSessionInfo_Data;
  using SessionState = MediaSessionInfo_SessionState;

  template <typename... Args>
  static MediaSessionInfoPtr New(Args&&... args) {
    return MediaSessionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSessionInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionInfo>::Convert(*this);
  }


  MediaSessionInfo();

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted,
      bool has_presentation);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted,
      bool has_presentation,
      RemotePlaybackMetadataPtr remote_playback_metadata);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted,
      bool has_presentation,
      RemotePlaybackMetadataPtr remote_playback_metadata,
      bool hide_metadata);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted,
      bool has_presentation,
      RemotePlaybackMetadataPtr remote_playback_metadata,
      bool hide_metadata,
      bool ignore_for_active_session);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool deprecated_is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState deprecated_audio_video_state,
      const std::optional<std::string>& audio_sink_id,
      std::optional<std::vector<MediaAudioVideoState>> audio_video_states,
      MicrophoneState microphone_state,
      CameraState camera_state,
      bool muted,
      bool has_presentation,
      RemotePlaybackMetadataPtr remote_playback_metadata,
      bool hide_metadata,
      bool ignore_for_active_session,
      bool meets_visibility_threshold);

MediaSessionInfo(const MediaSessionInfo&) = delete;
MediaSessionInfo& operator=(const MediaSessionInfo&) = delete;

  ~MediaSessionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSessionInfoPtr>
  MediaSessionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSessionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSessionInfo_UnserializedMessageContext<
            UserType, MediaSessionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaSessionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaSessionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSessionInfo_UnserializedMessageContext<
            UserType, MediaSessionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSessionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  MediaSessionInfo::SessionState state;
  
  bool force_duck;
  
  MediaPlaybackState playback_state;
  
  bool is_controllable;
  
  bool prefer_stop_for_gain_focus_loss;
  
  bool deprecated_is_sensitive;
  
  MediaPictureInPictureState picture_in_picture_state;
  
  MediaAudioVideoState deprecated_audio_video_state;
  
  std::optional<std::string> audio_sink_id;
  
  std::optional<std::vector<MediaAudioVideoState>> audio_video_states;
  
  MicrophoneState microphone_state;
  
  CameraState camera_state;
  
  bool muted;
  
  bool has_presentation;
  
  RemotePlaybackMetadataPtr remote_playback_metadata;
  
  bool hide_metadata;
  
  bool ignore_for_active_session;
  
  bool meets_visibility_threshold;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
MediaImagePtr MediaImage::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(type),
      mojo::Clone(sizes)
  );
}

template <typename T, MediaImage::EnableIfSame<T>*>
bool MediaImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  return true;
}

template <typename T, MediaImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.sizes < rhs.sizes)
    return true;
  if (rhs.sizes < lhs.sizes)
    return false;
  return false;
}
template <typename StructPtrType>
ChapterInformationPtr ChapterInformation::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(startTime),
      mojo::Clone(artwork)
  );
}

template <typename T, ChapterInformation::EnableIfSame<T>*>
bool ChapterInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->startTime, other_struct.startTime))
    return false;
  if (!mojo::Equals(this->artwork, other_struct.artwork))
    return false;
  return true;
}

template <typename T, ChapterInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.startTime < rhs.startTime)
    return true;
  if (rhs.startTime < lhs.startTime)
    return false;
  if (lhs.artwork < rhs.artwork)
    return true;
  if (rhs.artwork < lhs.artwork)
    return false;
  return false;
}
template <typename StructPtrType>
MediaMetadataPtr MediaMetadata::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(artist),
      mojo::Clone(album),
      mojo::Clone(source_title),
      mojo::Clone(chapters)
  );
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool MediaMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->artist, other_struct.artist))
    return false;
  if (!mojo::Equals(this->album, other_struct.album))
    return false;
  if (!mojo::Equals(this->source_title, other_struct.source_title))
    return false;
  if (!mojo::Equals(this->chapters, other_struct.chapters))
    return false;
  return true;
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.artist < rhs.artist)
    return true;
  if (rhs.artist < lhs.artist)
    return false;
  if (lhs.album < rhs.album)
    return true;
  if (rhs.album < lhs.album)
    return false;
  if (lhs.source_title < rhs.source_title)
    return true;
  if (rhs.source_title < lhs.source_title)
    return false;
  if (lhs.chapters < rhs.chapters)
    return true;
  if (rhs.chapters < lhs.chapters)
    return false;
  return false;
}
template <typename StructPtrType>
MediaImageBitmapPtr MediaImageBitmap::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(pixel_data),
      mojo::Clone(color_type)
  );
}

template <typename T, MediaImageBitmap::EnableIfSame<T>*>
bool MediaImageBitmap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  if (!mojo::Equals(this->color_type, other_struct.color_type))
    return false;
  return true;
}

template <typename T, MediaImageBitmap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  if (lhs.color_type < rhs.color_type)
    return true;
  if (rhs.color_type < lhs.color_type)
    return false;
  return false;
}
template <typename StructPtrType>
MediaPositionPtr MediaPosition::Clone() const {
  return New(
      mojo::Clone(playback_rate),
      mojo::Clone(duration),
      mojo::Clone(position),
      mojo::Clone(last_updated_time),
      mojo::Clone(end_of_media)
  );
}

template <typename T, MediaPosition::EnableIfSame<T>*>
bool MediaPosition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->playback_rate, other_struct.playback_rate))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->last_updated_time, other_struct.last_updated_time))
    return false;
  if (!mojo::Equals(this->end_of_media, other_struct.end_of_media))
    return false;
  return true;
}

template <typename T, MediaPosition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.playback_rate < rhs.playback_rate)
    return true;
  if (rhs.playback_rate < lhs.playback_rate)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.last_updated_time < rhs.last_updated_time)
    return true;
  if (rhs.last_updated_time < lhs.last_updated_time)
    return false;
  if (lhs.end_of_media < rhs.end_of_media)
    return true;
  if (rhs.end_of_media < lhs.end_of_media)
    return false;
  return false;
}
template <typename StructPtrType>
RemotePlaybackMetadataPtr RemotePlaybackMetadata::Clone() const {
  return New(
      mojo::Clone(video_codec),
      mojo::Clone(audio_codec),
      mojo::Clone(remote_playback_disabled),
      mojo::Clone(remote_playback_started),
      mojo::Clone(unused_field),
      mojo::Clone(is_encrypted_media)
  );
}

template <typename T, RemotePlaybackMetadata::EnableIfSame<T>*>
bool RemotePlaybackMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->video_codec, other_struct.video_codec))
    return false;
  if (!mojo::Equals(this->audio_codec, other_struct.audio_codec))
    return false;
  if (!mojo::Equals(this->remote_playback_disabled, other_struct.remote_playback_disabled))
    return false;
  if (!mojo::Equals(this->remote_playback_started, other_struct.remote_playback_started))
    return false;
  if (!mojo::Equals(this->unused_field, other_struct.unused_field))
    return false;
  if (!mojo::Equals(this->is_encrypted_media, other_struct.is_encrypted_media))
    return false;
  return true;
}

template <typename T, RemotePlaybackMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.video_codec < rhs.video_codec)
    return true;
  if (rhs.video_codec < lhs.video_codec)
    return false;
  if (lhs.audio_codec < rhs.audio_codec)
    return true;
  if (rhs.audio_codec < lhs.audio_codec)
    return false;
  if (lhs.remote_playback_disabled < rhs.remote_playback_disabled)
    return true;
  if (rhs.remote_playback_disabled < lhs.remote_playback_disabled)
    return false;
  if (lhs.remote_playback_started < rhs.remote_playback_started)
    return true;
  if (rhs.remote_playback_started < lhs.remote_playback_started)
    return false;
  if (lhs.unused_field < rhs.unused_field)
    return true;
  if (rhs.unused_field < lhs.unused_field)
    return false;
  if (lhs.is_encrypted_media < rhs.is_encrypted_media)
    return true;
  if (rhs.is_encrypted_media < lhs.is_encrypted_media)
    return false;
  return false;
}
template <typename StructPtrType>
MediaSessionInfoPtr MediaSessionInfo::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(force_duck),
      mojo::Clone(playback_state),
      mojo::Clone(is_controllable),
      mojo::Clone(prefer_stop_for_gain_focus_loss),
      mojo::Clone(deprecated_is_sensitive),
      mojo::Clone(picture_in_picture_state),
      mojo::Clone(deprecated_audio_video_state),
      mojo::Clone(audio_sink_id),
      mojo::Clone(audio_video_states),
      mojo::Clone(microphone_state),
      mojo::Clone(camera_state),
      mojo::Clone(muted),
      mojo::Clone(has_presentation),
      mojo::Clone(remote_playback_metadata),
      mojo::Clone(hide_metadata),
      mojo::Clone(ignore_for_active_session),
      mojo::Clone(meets_visibility_threshold)
  );
}

template <typename T, MediaSessionInfo::EnableIfSame<T>*>
bool MediaSessionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->force_duck, other_struct.force_duck))
    return false;
  if (!mojo::Equals(this->playback_state, other_struct.playback_state))
    return false;
  if (!mojo::Equals(this->is_controllable, other_struct.is_controllable))
    return false;
  if (!mojo::Equals(this->prefer_stop_for_gain_focus_loss, other_struct.prefer_stop_for_gain_focus_loss))
    return false;
  if (!mojo::Equals(this->deprecated_is_sensitive, other_struct.deprecated_is_sensitive))
    return false;
  if (!mojo::Equals(this->picture_in_picture_state, other_struct.picture_in_picture_state))
    return false;
  if (!mojo::Equals(this->deprecated_audio_video_state, other_struct.deprecated_audio_video_state))
    return false;
  if (!mojo::Equals(this->audio_sink_id, other_struct.audio_sink_id))
    return false;
  if (!mojo::Equals(this->audio_video_states, other_struct.audio_video_states))
    return false;
  if (!mojo::Equals(this->microphone_state, other_struct.microphone_state))
    return false;
  if (!mojo::Equals(this->camera_state, other_struct.camera_state))
    return false;
  if (!mojo::Equals(this->muted, other_struct.muted))
    return false;
  if (!mojo::Equals(this->has_presentation, other_struct.has_presentation))
    return false;
  if (!mojo::Equals(this->remote_playback_metadata, other_struct.remote_playback_metadata))
    return false;
  if (!mojo::Equals(this->hide_metadata, other_struct.hide_metadata))
    return false;
  if (!mojo::Equals(this->ignore_for_active_session, other_struct.ignore_for_active_session))
    return false;
  if (!mojo::Equals(this->meets_visibility_threshold, other_struct.meets_visibility_threshold))
    return false;
  return true;
}

template <typename T, MediaSessionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.force_duck < rhs.force_duck)
    return true;
  if (rhs.force_duck < lhs.force_duck)
    return false;
  if (lhs.playback_state < rhs.playback_state)
    return true;
  if (rhs.playback_state < lhs.playback_state)
    return false;
  if (lhs.is_controllable < rhs.is_controllable)
    return true;
  if (rhs.is_controllable < lhs.is_controllable)
    return false;
  if (lhs.prefer_stop_for_gain_focus_loss < rhs.prefer_stop_for_gain_focus_loss)
    return true;
  if (rhs.prefer_stop_for_gain_focus_loss < lhs.prefer_stop_for_gain_focus_loss)
    return false;
  if (lhs.deprecated_is_sensitive < rhs.deprecated_is_sensitive)
    return true;
  if (rhs.deprecated_is_sensitive < lhs.deprecated_is_sensitive)
    return false;
  if (lhs.picture_in_picture_state < rhs.picture_in_picture_state)
    return true;
  if (rhs.picture_in_picture_state < lhs.picture_in_picture_state)
    return false;
  if (lhs.deprecated_audio_video_state < rhs.deprecated_audio_video_state)
    return true;
  if (rhs.deprecated_audio_video_state < lhs.deprecated_audio_video_state)
    return false;
  if (lhs.audio_sink_id < rhs.audio_sink_id)
    return true;
  if (rhs.audio_sink_id < lhs.audio_sink_id)
    return false;
  if (lhs.audio_video_states < rhs.audio_video_states)
    return true;
  if (rhs.audio_video_states < lhs.audio_video_states)
    return false;
  if (lhs.microphone_state < rhs.microphone_state)
    return true;
  if (rhs.microphone_state < lhs.microphone_state)
    return false;
  if (lhs.camera_state < rhs.camera_state)
    return true;
  if (rhs.camera_state < lhs.camera_state)
    return false;
  if (lhs.muted < rhs.muted)
    return true;
  if (rhs.muted < lhs.muted)
    return false;
  if (lhs.has_presentation < rhs.has_presentation)
    return true;
  if (rhs.has_presentation < lhs.has_presentation)
    return false;
  if (lhs.remote_playback_metadata < rhs.remote_playback_metadata)
    return true;
  if (rhs.remote_playback_metadata < lhs.remote_playback_metadata)
    return false;
  if (lhs.hide_metadata < rhs.hide_metadata)
    return true;
  if (rhs.hide_metadata < lhs.hide_metadata)
    return false;
  if (lhs.ignore_for_active_session < rhs.ignore_for_active_session)
    return true;
  if (rhs.ignore_for_active_session < lhs.ignore_for_active_session)
    return false;
  if (lhs.meets_visibility_threshold < rhs.meets_visibility_threshold)
    return true;
  if (rhs.meets_visibility_threshold < lhs.meets_visibility_threshold)
    return false;
  return false;
}
template <typename StructPtrType>
MediaSessionDebugInfoPtr MediaSessionDebugInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(owner),
      mojo::Clone(state)
  );
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>*>
bool MediaSessionDebugInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->owner, other_struct.owner))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.owner < rhs.owner)
    return true;
  if (rhs.owner < lhs.owner)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  return false;
}


}  // media_session::mojom

namespace mojo {


template <>
struct  StructTraits<::media_session::mojom::MediaImage::DataView,
                                         ::media_session::mojom::MediaImagePtr> {
  static bool IsNull(const ::media_session::mojom::MediaImagePtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaImagePtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaImage::src)& src(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->src;
  }

  static const decltype(::media_session::mojom::MediaImage::type)& type(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->type;
  }

  static const decltype(::media_session::mojom::MediaImage::sizes)& sizes(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->sizes;
  }

  static bool Read(::media_session::mojom::MediaImage::DataView input, ::media_session::mojom::MediaImagePtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::ChapterInformation::DataView,
                                         ::media_session::mojom::ChapterInformationPtr> {
  static bool IsNull(const ::media_session::mojom::ChapterInformationPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::ChapterInformationPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::ChapterInformation::title)& title(
      const ::media_session::mojom::ChapterInformationPtr& input) {
    return input->title;
  }

  static const decltype(::media_session::mojom::ChapterInformation::startTime)& startTime(
      const ::media_session::mojom::ChapterInformationPtr& input) {
    return input->startTime;
  }

  static const decltype(::media_session::mojom::ChapterInformation::artwork)& artwork(
      const ::media_session::mojom::ChapterInformationPtr& input) {
    return input->artwork;
  }

  static bool Read(::media_session::mojom::ChapterInformation::DataView input, ::media_session::mojom::ChapterInformationPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaMetadata::DataView,
                                         ::media_session::mojom::MediaMetadataPtr> {
  static bool IsNull(const ::media_session::mojom::MediaMetadataPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaMetadataPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaMetadata::title)& title(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->title;
  }

  static const decltype(::media_session::mojom::MediaMetadata::artist)& artist(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->artist;
  }

  static const decltype(::media_session::mojom::MediaMetadata::album)& album(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->album;
  }

  static const decltype(::media_session::mojom::MediaMetadata::source_title)& source_title(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->source_title;
  }

  static const decltype(::media_session::mojom::MediaMetadata::chapters)& chapters(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->chapters;
  }

  static bool Read(::media_session::mojom::MediaMetadata::DataView input, ::media_session::mojom::MediaMetadataPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaImageBitmap::DataView,
                                         ::media_session::mojom::MediaImageBitmapPtr> {
  static bool IsNull(const ::media_session::mojom::MediaImageBitmapPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaImageBitmapPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaImageBitmap::width) width(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->width;
  }

  static decltype(::media_session::mojom::MediaImageBitmap::height) height(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->height;
  }

  static const decltype(::media_session::mojom::MediaImageBitmap::pixel_data)& pixel_data(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->pixel_data;
  }

  static decltype(::media_session::mojom::MediaImageBitmap::color_type) color_type(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->color_type;
  }

  static bool Read(::media_session::mojom::MediaImageBitmap::DataView input, ::media_session::mojom::MediaImageBitmapPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaPosition::DataView,
                                         ::media_session::mojom::MediaPositionPtr> {
  static bool IsNull(const ::media_session::mojom::MediaPositionPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaPositionPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaPosition::playback_rate) playback_rate(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->playback_rate;
  }

  static const decltype(::media_session::mojom::MediaPosition::duration)& duration(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->duration;
  }

  static const decltype(::media_session::mojom::MediaPosition::position)& position(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->position;
  }

  static const decltype(::media_session::mojom::MediaPosition::last_updated_time)& last_updated_time(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->last_updated_time;
  }

  static decltype(::media_session::mojom::MediaPosition::end_of_media) end_of_media(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->end_of_media;
  }

  static bool Read(::media_session::mojom::MediaPosition::DataView input, ::media_session::mojom::MediaPositionPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::RemotePlaybackMetadata::DataView,
                                         ::media_session::mojom::RemotePlaybackMetadataPtr> {
  static bool IsNull(const ::media_session::mojom::RemotePlaybackMetadataPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::RemotePlaybackMetadataPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::RemotePlaybackMetadata::video_codec)& video_codec(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->video_codec;
  }

  static const decltype(::media_session::mojom::RemotePlaybackMetadata::audio_codec)& audio_codec(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->audio_codec;
  }

  static decltype(::media_session::mojom::RemotePlaybackMetadata::remote_playback_disabled) remote_playback_disabled(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->remote_playback_disabled;
  }

  static decltype(::media_session::mojom::RemotePlaybackMetadata::remote_playback_started) remote_playback_started(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->remote_playback_started;
  }

  static const decltype(::media_session::mojom::RemotePlaybackMetadata::unused_field)& unused_field(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->unused_field;
  }

  static decltype(::media_session::mojom::RemotePlaybackMetadata::is_encrypted_media) is_encrypted_media(
      const ::media_session::mojom::RemotePlaybackMetadataPtr& input) {
    return input->is_encrypted_media;
  }

  static bool Read(::media_session::mojom::RemotePlaybackMetadata::DataView input, ::media_session::mojom::RemotePlaybackMetadataPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaSessionInfo::DataView,
                                         ::media_session::mojom::MediaSessionInfoPtr> {
  static bool IsNull(const ::media_session::mojom::MediaSessionInfoPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaSessionInfoPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaSessionInfo::state) state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::force_duck) force_duck(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->force_duck;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::playback_state) playback_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->playback_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::is_controllable) is_controllable(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->is_controllable;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::prefer_stop_for_gain_focus_loss) prefer_stop_for_gain_focus_loss(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->prefer_stop_for_gain_focus_loss;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::deprecated_is_sensitive) deprecated_is_sensitive(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->deprecated_is_sensitive;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::picture_in_picture_state) picture_in_picture_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->picture_in_picture_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::deprecated_audio_video_state) deprecated_audio_video_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->deprecated_audio_video_state;
  }

  static const decltype(::media_session::mojom::MediaSessionInfo::audio_sink_id)& audio_sink_id(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->audio_sink_id;
  }

  static const decltype(::media_session::mojom::MediaSessionInfo::audio_video_states)& audio_video_states(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->audio_video_states;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::microphone_state) microphone_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->microphone_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::camera_state) camera_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->camera_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::muted) muted(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->muted;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::has_presentation) has_presentation(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->has_presentation;
  }

  static const decltype(::media_session::mojom::MediaSessionInfo::remote_playback_metadata)& remote_playback_metadata(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->remote_playback_metadata;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::hide_metadata) hide_metadata(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->hide_metadata;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::ignore_for_active_session) ignore_for_active_session(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->ignore_for_active_session;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::meets_visibility_threshold) meets_visibility_threshold(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->meets_visibility_threshold;
  }

  static bool Read(::media_session::mojom::MediaSessionInfo::DataView input, ::media_session::mojom::MediaSessionInfoPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaSessionDebugInfo::DataView,
                                         ::media_session::mojom::MediaSessionDebugInfoPtr> {
  static bool IsNull(const ::media_session::mojom::MediaSessionDebugInfoPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaSessionDebugInfoPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::name)& name(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->name;
  }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::owner)& owner(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->owner;
  }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::state)& state(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->state;
  }

  static bool Read(::media_session::mojom::MediaSessionDebugInfo::DataView input, ::media_session::mojom::MediaSessionDebugInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_