// services/device/public/mojom/sensor_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/sensor_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor_provider.mojom-params-data.h"
#include "services/device/public/mojom/sensor_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/sensor_provider.mojom-import-headers.h"
#include "services/device/public/mojom/sensor_provider.mojom-test-utils.h"


namespace device::mojom {
constexpr uint64_t SensorInitParams::kReadBufferSizeForTests;
SensorInitParams::SensorInitParams()
    : sensor(),
      client_receiver(),
      memory(),
      buffer_offset(),
      mode(),
      default_configuration(),
      maximum_frequency(),
      minimum_frequency() {}

SensorInitParams::SensorInitParams(
    ::mojo::PendingRemote<::device::mojom::Sensor> sensor_in,
    ::mojo::PendingReceiver<::device::mojom::SensorClient> client_receiver_in,
    ::base::ReadOnlySharedMemoryRegion memory_in,
    uint64_t buffer_offset_in,
    ::device::mojom::ReportingMode mode_in,
    const ::device::PlatformSensorConfiguration& default_configuration_in,
    double maximum_frequency_in,
    double minimum_frequency_in)
    : sensor(std::move(sensor_in)),
      client_receiver(std::move(client_receiver_in)),
      memory(std::move(memory_in)),
      buffer_offset(std::move(buffer_offset_in)),
      mode(std::move(mode_in)),
      default_configuration(std::move(default_configuration_in)),
      maximum_frequency(std::move(maximum_frequency_in)),
      minimum_frequency(std::move(minimum_frequency_in)) {}

SensorInitParams::~SensorInitParams() = default;

void SensorInitParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sensor"), this->sensor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::device::mojom::Sensor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::device::mojom::SensorClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory"), this->memory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ReadOnlySharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_offset"), this->buffer_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::ReportingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_configuration"), this->default_configuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::device::PlatformSensorConfiguration&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_frequency"), this->maximum_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum_frequency"), this->minimum_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SensorInitParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VirtualSensorMetadata::VirtualSensorMetadata()
    : available(true),
      maximum_frequency(),
      minimum_frequency(),
      reporting_mode() {}

VirtualSensorMetadata::VirtualSensorMetadata(
    bool available_in,
    std::optional<double> maximum_frequency_in,
    std::optional<double> minimum_frequency_in,
    std::optional<::device::mojom::ReportingMode> reporting_mode_in)
    : available(std::move(available_in)),
      maximum_frequency(std::move(maximum_frequency_in)),
      minimum_frequency(std::move(minimum_frequency_in)),
      reporting_mode(std::move(reporting_mode_in)) {}

VirtualSensorMetadata::~VirtualSensorMetadata() = default;

void VirtualSensorMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "available"), this->available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_frequency"), this->maximum_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum_frequency"), this->minimum_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_mode"), this->reporting_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::device::mojom::ReportingMode>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VirtualSensorMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VirtualSensorInformation::VirtualSensorInformation()
    : sampling_frequency() {}

VirtualSensorInformation::VirtualSensorInformation(
    double sampling_frequency_in)
    : sampling_frequency(std::move(sampling_frequency_in)) {}

VirtualSensorInformation::~VirtualSensorInformation() = default;
size_t VirtualSensorInformation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->sampling_frequency);
  return seed;
}

void VirtualSensorInformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampling_frequency"), this->sampling_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VirtualSensorInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetVirtualSensorInformationResult::GetVirtualSensorInformationResult() : tag_(Tag::kInfo) {
  data_.info = new VirtualSensorInformationPtr;
}

GetVirtualSensorInformationResult::~GetVirtualSensorInformationResult() {
  DestroyActive();
}


void GetVirtualSensorInformationResult::set_info(
    VirtualSensorInformationPtr info) {
  if (tag_ == Tag::kInfo) {
    *(data_.info) = std::move(info);
  } else {
    DestroyActive();
    tag_ = Tag::kInfo;
    data_.info = new VirtualSensorInformationPtr(
        std::move(info));
  }
}
void GetVirtualSensorInformationResult::set_error(
    GetVirtualSensorInformationError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}

void GetVirtualSensorInformationResult::DestroyActive() {
  switch (tag_) {

    case Tag::kInfo:

      delete data_.info;
      break;
    case Tag::kError:

      break;
  }
}
size_t GetVirtualSensorInformationResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kInfo:
      return mojo::internal::Hash(seed, *data_.info);
    case Tag::kError:
      return mojo::internal::Hash(seed, data_.error);
    default:
      NOTREACHED();
  }
}

bool GetVirtualSensorInformationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char SensorProvider::Name_[] = "device.mojom.SensorProvider";

SensorProvider::IPCStableHashFunction SensorProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SensorProvider>(message.name())) {
    case messages::SensorProvider::kGetSensor: {
      return &SensorProvider::GetSensor_Sym::IPCStableHash;
    }
    case messages::SensorProvider::kCreateVirtualSensor: {
      return &SensorProvider::CreateVirtualSensor_Sym::IPCStableHash;
    }
    case messages::SensorProvider::kUpdateVirtualSensor: {
      return &SensorProvider::UpdateVirtualSensor_Sym::IPCStableHash;
    }
    case messages::SensorProvider::kRemoveVirtualSensor: {
      return &SensorProvider::RemoveVirtualSensor_Sym::IPCStableHash;
    }
    case messages::SensorProvider::kGetVirtualSensorInformation: {
      return &SensorProvider::GetVirtualSensorInformation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SensorProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SensorProvider>(message.name())) {
      case messages::SensorProvider::kGetSensor:
            return "Receive device::mojom::SensorProvider::GetSensor";
      case messages::SensorProvider::kCreateVirtualSensor:
            return "Receive device::mojom::SensorProvider::CreateVirtualSensor";
      case messages::SensorProvider::kUpdateVirtualSensor:
            return "Receive device::mojom::SensorProvider::UpdateVirtualSensor";
      case messages::SensorProvider::kRemoveVirtualSensor:
            return "Receive device::mojom::SensorProvider::RemoveVirtualSensor";
      case messages::SensorProvider::kGetVirtualSensorInformation:
            return "Receive device::mojom::SensorProvider::GetVirtualSensorInformation";
    }
  } else {
    switch (static_cast<messages::SensorProvider>(message.name())) {
      case messages::SensorProvider::kGetSensor:
            return "Receive reply device::mojom::SensorProvider::GetSensor";
      case messages::SensorProvider::kCreateVirtualSensor:
            return "Receive reply device::mojom::SensorProvider::CreateVirtualSensor";
      case messages::SensorProvider::kUpdateVirtualSensor:
            return "Receive reply device::mojom::SensorProvider::UpdateVirtualSensor";
      case messages::SensorProvider::kRemoveVirtualSensor:
            return "Receive reply device::mojom::SensorProvider::RemoveVirtualSensor";
      case messages::SensorProvider::kGetVirtualSensorInformation:
            return "Receive reply device::mojom::SensorProvider::GetVirtualSensorInformation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SensorProvider::GetSensor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SensorProvider::GetSensor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SensorProvider::CreateVirtualSensor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SensorProvider::CreateVirtualSensor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SensorProvider::UpdateVirtualSensor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SensorProvider::UpdateVirtualSensor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SensorProvider::RemoveVirtualSensor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SensorProvider::RemoveVirtualSensor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SensorProvider::GetVirtualSensorInformation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::SensorProvider::GetVirtualSensorInformation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SensorProvider_GetSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_GetSensor_ForwardToCallback(
      SensorProvider::GetSensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  SensorProvider_GetSensor_ForwardToCallback(const SensorProvider_GetSensor_ForwardToCallback&) = delete;
  SensorProvider_GetSensor_ForwardToCallback& operator=(const SensorProvider_GetSensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::GetSensorCallback callback_;
};

class SensorProvider_CreateVirtualSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_CreateVirtualSensor_ForwardToCallback(
      SensorProvider::CreateVirtualSensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  SensorProvider_CreateVirtualSensor_ForwardToCallback(const SensorProvider_CreateVirtualSensor_ForwardToCallback&) = delete;
  SensorProvider_CreateVirtualSensor_ForwardToCallback& operator=(const SensorProvider_CreateVirtualSensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::CreateVirtualSensorCallback callback_;
};

class SensorProvider_UpdateVirtualSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_UpdateVirtualSensor_ForwardToCallback(
      SensorProvider::UpdateVirtualSensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  SensorProvider_UpdateVirtualSensor_ForwardToCallback(const SensorProvider_UpdateVirtualSensor_ForwardToCallback&) = delete;
  SensorProvider_UpdateVirtualSensor_ForwardToCallback& operator=(const SensorProvider_UpdateVirtualSensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::UpdateVirtualSensorCallback callback_;
};

class SensorProvider_RemoveVirtualSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_RemoveVirtualSensor_ForwardToCallback(
      SensorProvider::RemoveVirtualSensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  SensorProvider_RemoveVirtualSensor_ForwardToCallback(const SensorProvider_RemoveVirtualSensor_ForwardToCallback&) = delete;
  SensorProvider_RemoveVirtualSensor_ForwardToCallback& operator=(const SensorProvider_RemoveVirtualSensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::RemoveVirtualSensorCallback callback_;
};

class SensorProvider_GetVirtualSensorInformation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_GetVirtualSensorInformation_ForwardToCallback(
      SensorProvider::GetVirtualSensorInformationCallback callback
      ) : callback_(std::move(callback)) {
  }

  SensorProvider_GetVirtualSensorInformation_ForwardToCallback(const SensorProvider_GetVirtualSensorInformation_ForwardToCallback&) = delete;
  SensorProvider_GetVirtualSensorInformation_ForwardToCallback& operator=(const SensorProvider_GetVirtualSensorInformation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::GetVirtualSensorInformationCallback callback_;
};

SensorProviderProxy::SensorProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SensorProviderProxy::GetSensor(
    ::device::mojom::SensorType in_type, GetSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SensorProvider::GetSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::SensorType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kGetSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetSensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_GetSensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProviderProxy::CreateVirtualSensor(
    ::device::mojom::SensorType in_type, VirtualSensorMetadataPtr in_metadata, CreateVirtualSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SensorProvider::CreateVirtualSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::SensorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type VirtualSensorMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kCreateVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_CreateVirtualSensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::VirtualSensorMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in SensorProvider.CreateVirtualSensor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("CreateVirtualSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_CreateVirtualSensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProviderProxy::UpdateVirtualSensor(
    ::device::mojom::SensorType in_type, const ::device::SensorReading& in_reading, UpdateVirtualSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SensorProvider::UpdateVirtualSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::SensorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reading"), in_reading,
                        "<value of type const ::device::SensorReading&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kUpdateVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_UpdateVirtualSensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->reading)::BaseType> reading_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SensorReadingRawDataView>(
      in_reading, reading_fragment);
  params->reading.Set(
      reading_fragment.is_null() ? nullptr : reading_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reading.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reading in SensorProvider.UpdateVirtualSensor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("UpdateVirtualSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_UpdateVirtualSensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProviderProxy::RemoveVirtualSensor(
    ::device::mojom::SensorType in_type, RemoveVirtualSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SensorProvider::RemoveVirtualSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::SensorType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kRemoveVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_RemoveVirtualSensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("RemoveVirtualSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_RemoveVirtualSensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProviderProxy::GetVirtualSensorInformation(
    ::device::mojom::SensorType in_type, GetVirtualSensorInformationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::SensorProvider::GetVirtualSensorInformation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::SensorType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kGetVirtualSensorInformation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetVirtualSensorInformation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetVirtualSensorInformation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_GetVirtualSensorInformation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SensorProvider_GetSensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SensorProvider::GetSensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SensorProvider_GetSensor_ProxyToResponder> proxy(
        new SensorProvider_GetSensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SensorProvider_GetSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_GetSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SensorProvider_GetSensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::GetSensorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SensorCreationResult in_result, SensorInitParamsPtr in_init_params);
};

bool SensorProvider_GetSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SensorProvider_GetSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_GetSensor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SensorProvider.0
  bool success = true;
  SensorCreationResult p_result{};
  SensorInitParamsPtr p_init_params{};
  SensorProvider_GetSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInitParams(&p_init_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_init_params));
  return true;
}

void SensorProvider_GetSensor_ProxyToResponder::Run(
    SensorCreationResult in_result, SensorInitParamsPtr in_init_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SensorProvider::GetSensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SensorCreationResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("init_params"), in_init_params,
                        "<value of type SensorInitParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kGetSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetSensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorCreationResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->init_params)::BaseType> init_params_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SensorInitParamsDataView>(
      in_init_params, init_params_fragment);
  params->init_params.Set(
      init_params_fragment.is_null() ? nullptr : init_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SensorProvider_CreateVirtualSensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SensorProvider::CreateVirtualSensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SensorProvider_CreateVirtualSensor_ProxyToResponder> proxy(
        new SensorProvider_CreateVirtualSensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SensorProvider_CreateVirtualSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_CreateVirtualSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SensorProvider_CreateVirtualSensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::CreateVirtualSensorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateVirtualSensorResult in_result);
};

bool SensorProvider_CreateVirtualSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SensorProvider_CreateVirtualSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_CreateVirtualSensor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SensorProvider.1
  bool success = true;
  CreateVirtualSensorResult p_result{};
  SensorProvider_CreateVirtualSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SensorProvider_CreateVirtualSensor_ProxyToResponder::Run(
    CreateVirtualSensorResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SensorProvider::CreateVirtualSensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateVirtualSensorResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kCreateVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_CreateVirtualSensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::CreateVirtualSensorResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("CreateVirtualSensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SensorProvider_UpdateVirtualSensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SensorProvider::UpdateVirtualSensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SensorProvider_UpdateVirtualSensor_ProxyToResponder> proxy(
        new SensorProvider_UpdateVirtualSensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SensorProvider_UpdateVirtualSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_UpdateVirtualSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SensorProvider_UpdateVirtualSensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::UpdateVirtualSensorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      UpdateVirtualSensorResult in_result);
};

bool SensorProvider_UpdateVirtualSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SensorProvider_UpdateVirtualSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_UpdateVirtualSensor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SensorProvider.2
  bool success = true;
  UpdateVirtualSensorResult p_result{};
  SensorProvider_UpdateVirtualSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SensorProvider_UpdateVirtualSensor_ProxyToResponder::Run(
    UpdateVirtualSensorResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SensorProvider::UpdateVirtualSensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type UpdateVirtualSensorResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kUpdateVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_UpdateVirtualSensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::UpdateVirtualSensorResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("UpdateVirtualSensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SensorProvider_RemoveVirtualSensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SensorProvider::RemoveVirtualSensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SensorProvider_RemoveVirtualSensor_ProxyToResponder> proxy(
        new SensorProvider_RemoveVirtualSensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SensorProvider_RemoveVirtualSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_RemoveVirtualSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SensorProvider_RemoveVirtualSensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::RemoveVirtualSensorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool SensorProvider_RemoveVirtualSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SensorProvider_RemoveVirtualSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_RemoveVirtualSensor_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SensorProvider.3
  bool success = true;
  SensorProvider_RemoveVirtualSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SensorProvider_RemoveVirtualSensor_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::SensorProvider::RemoveVirtualSensor");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kRemoveVirtualSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_RemoveVirtualSensor_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("RemoveVirtualSensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SensorProvider_GetVirtualSensorInformation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SensorProvider::GetVirtualSensorInformationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SensorProvider_GetVirtualSensorInformation_ProxyToResponder> proxy(
        new SensorProvider_GetVirtualSensorInformation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SensorProvider_GetVirtualSensorInformation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_GetVirtualSensorInformation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SensorProvider_GetVirtualSensorInformation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::GetVirtualSensorInformationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetVirtualSensorInformationResultPtr in_result);
};

bool SensorProvider_GetVirtualSensorInformation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SensorProvider_GetVirtualSensorInformation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_GetVirtualSensorInformation_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for SensorProvider.4
  bool success = true;
  GetVirtualSensorInformationResultPtr p_result{};
  SensorProvider_GetVirtualSensorInformation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SensorProvider_GetVirtualSensorInformation_ProxyToResponder::Run(
    GetVirtualSensorInformationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::SensorProvider::GetVirtualSensorInformation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetVirtualSensorInformationResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorProvider::kGetVirtualSensorInformation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetVirtualSensorInformation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::GetVirtualSensorInformationResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetVirtualSensorInformation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SensorProviderStubDispatch::Accept(
    SensorProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SensorProvider>(message->header()->name)) {
    case messages::SensorProvider::kGetSensor: {
      break;
    }
    case messages::SensorProvider::kCreateVirtualSensor: {
      break;
    }
    case messages::SensorProvider::kUpdateVirtualSensor: {
      break;
    }
    case messages::SensorProvider::kRemoveVirtualSensor: {
      break;
    }
    case messages::SensorProvider::kGetVirtualSensorInformation: {
      break;
    }
  }
  return false;
}

// static
bool SensorProviderStubDispatch::AcceptWithResponder(
    SensorProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SensorProvider>(message->header()->name)) {
    case messages::SensorProvider::kGetSensor: {
      internal::SensorProvider_GetSensor_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_GetSensor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SensorProvider.0
      bool success = true;
      ::device::mojom::SensorType p_type{};
      SensorProvider_GetSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 0, false);
        return false;
      }
      SensorProvider::GetSensorCallback callback =
          SensorProvider_GetSensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSensor(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::SensorProvider::kCreateVirtualSensor: {
      internal::SensorProvider_CreateVirtualSensor_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_CreateVirtualSensor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SensorProvider.1
      bool success = true;
      ::device::mojom::SensorType p_type{};
      VirtualSensorMetadataPtr p_metadata{};
      SensorProvider_CreateVirtualSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 1, false);
        return false;
      }
      SensorProvider::CreateVirtualSensorCallback callback =
          SensorProvider_CreateVirtualSensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVirtualSensor(        
        std::move(p_type), 
        std::move(p_metadata), std::move(callback));
      return true;
    }
    case messages::SensorProvider::kUpdateVirtualSensor: {
      internal::SensorProvider_UpdateVirtualSensor_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_UpdateVirtualSensor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SensorProvider.2
      bool success = true;
      ::device::mojom::SensorType p_type{};
      ::device::SensorReading p_reading{};
      SensorProvider_UpdateVirtualSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadReading(&p_reading))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 2, false);
        return false;
      }
      SensorProvider::UpdateVirtualSensorCallback callback =
          SensorProvider_UpdateVirtualSensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVirtualSensor(        
        std::move(p_type), 
        std::move(p_reading), std::move(callback));
      return true;
    }
    case messages::SensorProvider::kRemoveVirtualSensor: {
      internal::SensorProvider_RemoveVirtualSensor_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_RemoveVirtualSensor_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SensorProvider.3
      bool success = true;
      ::device::mojom::SensorType p_type{};
      SensorProvider_RemoveVirtualSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 3, false);
        return false;
      }
      SensorProvider::RemoveVirtualSensorCallback callback =
          SensorProvider_RemoveVirtualSensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVirtualSensor(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::SensorProvider::kGetVirtualSensorInformation: {
      internal::SensorProvider_GetVirtualSensorInformation_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_GetVirtualSensorInformation_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for SensorProvider.4
      bool success = true;
      ::device::mojom::SensorType p_type{};
      SensorProvider_GetVirtualSensorInformation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 4, false);
        return false;
      }
      SensorProvider::GetVirtualSensorInformationCallback callback =
          SensorProvider_GetVirtualSensorInformation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVirtualSensorInformation(        
        std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSensorProviderValidationInfo[] = {
    { &internal::SensorProvider_GetSensor_Params_Data::Validate,
     &internal::SensorProvider_GetSensor_ResponseParams_Data::Validate},
    { &internal::SensorProvider_CreateVirtualSensor_Params_Data::Validate,
     &internal::SensorProvider_CreateVirtualSensor_ResponseParams_Data::Validate},
    { &internal::SensorProvider_UpdateVirtualSensor_Params_Data::Validate,
     &internal::SensorProvider_UpdateVirtualSensor_ResponseParams_Data::Validate},
    { &internal::SensorProvider_RemoveVirtualSensor_Params_Data::Validate,
     &internal::SensorProvider_RemoveVirtualSensor_ResponseParams_Data::Validate},
    { &internal::SensorProvider_GetVirtualSensorInformation_Params_Data::Validate,
     &internal::SensorProvider_GetVirtualSensorInformation_ResponseParams_Data::Validate},
};

bool SensorProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::SensorProvider::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSensorProviderValidationInfo);
}

bool SensorProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::SensorProvider::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kSensorProviderValidationInfo);
}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::SensorInitParams::DataView, ::device::mojom::SensorInitParamsPtr>::Read(
    ::device::mojom::SensorInitParams::DataView input,
    ::device::mojom::SensorInitParamsPtr* output) {
  bool success = true;
  ::device::mojom::SensorInitParamsPtr result(::device::mojom::SensorInitParams::New());
  
      if (success) {
        result->sensor =
            input.TakeSensor<decltype(result->sensor)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadMemory(&result->memory))
        success = false;
      if (success)
        result->buffer_offset = input.buffer_offset();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadDefaultConfiguration(&result->default_configuration))
        success = false;
      if (success)
        result->maximum_frequency = input.maximum_frequency();
      if (success)
        result->minimum_frequency = input.minimum_frequency();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VirtualSensorMetadata::DataView, ::device::mojom::VirtualSensorMetadataPtr>::Read(
    ::device::mojom::VirtualSensorMetadata::DataView input,
    ::device::mojom::VirtualSensorMetadataPtr* output) {
  bool success = true;
  ::device::mojom::VirtualSensorMetadataPtr result(::device::mojom::VirtualSensorMetadata::New());
  
      if (success)
        result->available = input.available();
      if (success) {
        result->maximum_frequency = input.maximum_frequency();
      }
      if (success) {
        result->minimum_frequency = input.minimum_frequency();
      }
      if (success && !input.ReadReportingMode(&result->reporting_mode)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VirtualSensorInformation::DataView, ::device::mojom::VirtualSensorInformationPtr>::Read(
    ::device::mojom::VirtualSensorInformation::DataView input,
    ::device::mojom::VirtualSensorInformationPtr* output) {
  bool success = true;
  ::device::mojom::VirtualSensorInformationPtr result(::device::mojom::VirtualSensorInformation::New());
  
      if (success)
        result->sampling_frequency = input.sampling_frequency();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::GetVirtualSensorInformationResult::DataView, ::device::mojom::GetVirtualSensorInformationResultPtr>::Read(
    ::device::mojom::GetVirtualSensorInformationResult::DataView input,
    ::device::mojom::GetVirtualSensorInformationResultPtr* output) {
  using UnionType = ::device::mojom::GetVirtualSensorInformationResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInfo: {
      ::device::mojom::VirtualSensorInformationPtr result_info;
      if (!input.ReadInfo(&result_info))
        return false;

      *output = UnionType::NewInfo(
          std::move(result_info));
      break;
    }
    case Tag::kError: {
      ::device::mojom::GetVirtualSensorInformationError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void SensorProviderInterceptorForTesting::GetSensor(::device::mojom::SensorType type, GetSensorCallback callback) {
  GetForwardingInterface()->GetSensor(
    std::move(type)
    , std::move(callback));
}
void SensorProviderInterceptorForTesting::CreateVirtualSensor(::device::mojom::SensorType type, VirtualSensorMetadataPtr metadata, CreateVirtualSensorCallback callback) {
  GetForwardingInterface()->CreateVirtualSensor(
    std::move(type)
    , 
    std::move(metadata)
    , std::move(callback));
}
void SensorProviderInterceptorForTesting::UpdateVirtualSensor(::device::mojom::SensorType type, const ::device::SensorReading& reading, UpdateVirtualSensorCallback callback) {
  GetForwardingInterface()->UpdateVirtualSensor(
    std::move(type)
    , 
    std::move(reading)
    , std::move(callback));
}
void SensorProviderInterceptorForTesting::RemoveVirtualSensor(::device::mojom::SensorType type, RemoveVirtualSensorCallback callback) {
  GetForwardingInterface()->RemoveVirtualSensor(
    std::move(type)
    , std::move(callback));
}
void SensorProviderInterceptorForTesting::GetVirtualSensorInformation(::device::mojom::SensorType type, GetVirtualSensorInformationCallback callback) {
  GetForwardingInterface()->GetVirtualSensorInformation(
    std::move(type)
    , std::move(callback));
}
SensorProviderAsyncWaiter::SensorProviderAsyncWaiter(
    SensorProvider* proxy) : proxy_(proxy) {}

SensorProviderAsyncWaiter::~SensorProviderAsyncWaiter() = default;

void SensorProviderAsyncWaiter::GetSensor(
    ::device::mojom::SensorType type, SensorCreationResult* out_result, SensorInitParamsPtr* out_init_params) {
  base::RunLoop loop;
  proxy_->GetSensor(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             SensorCreationResult* out_result
,
             SensorInitParamsPtr* out_init_params
,
             SensorCreationResult result,
             SensorInitParamsPtr init_params) {*out_result = std::move(result);*out_init_params = std::move(init_params);
            loop->Quit();
          },
          &loop,
          out_result,
          out_init_params));
  loop.Run();
}



void SensorProviderAsyncWaiter::CreateVirtualSensor(
    ::device::mojom::SensorType type, VirtualSensorMetadataPtr metadata, CreateVirtualSensorResult* out_result) {
  base::RunLoop loop;
  proxy_->CreateVirtualSensor(
      std::move(type),
      std::move(metadata),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateVirtualSensorResult* out_result
,
             CreateVirtualSensorResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateVirtualSensorResult SensorProviderAsyncWaiter::CreateVirtualSensor(
    ::device::mojom::SensorType type, VirtualSensorMetadataPtr metadata) {
  CreateVirtualSensorResult async_wait_result;
  CreateVirtualSensor(std::move(type),std::move(metadata),&async_wait_result);
  return async_wait_result;
}

void SensorProviderAsyncWaiter::UpdateVirtualSensor(
    ::device::mojom::SensorType type, const ::device::SensorReading& reading, UpdateVirtualSensorResult* out_result) {
  base::RunLoop loop;
  proxy_->UpdateVirtualSensor(
      std::move(type),
      std::move(reading),
      base::BindOnce(
          [](base::RunLoop* loop,
             UpdateVirtualSensorResult* out_result
,
             UpdateVirtualSensorResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

UpdateVirtualSensorResult SensorProviderAsyncWaiter::UpdateVirtualSensor(
    ::device::mojom::SensorType type, const ::device::SensorReading& reading) {
  UpdateVirtualSensorResult async_wait_result;
  UpdateVirtualSensor(std::move(type),std::move(reading),&async_wait_result);
  return async_wait_result;
}

void SensorProviderAsyncWaiter::RemoveVirtualSensor(
    ::device::mojom::SensorType type) {
  base::RunLoop loop;
  proxy_->RemoveVirtualSensor(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void SensorProviderAsyncWaiter::GetVirtualSensorInformation(
    ::device::mojom::SensorType type, GetVirtualSensorInformationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetVirtualSensorInformation(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetVirtualSensorInformationResultPtr* out_result
,
             GetVirtualSensorInformationResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetVirtualSensorInformationResultPtr SensorProviderAsyncWaiter::GetVirtualSensorInformation(
    ::device::mojom::SensorType type) {
  GetVirtualSensorInformationResultPtr async_wait_result;
  GetVirtualSensorInformation(std::move(type),&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif