// services/device/public/mojom/geoposition.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/geoposition.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace device::mojom {
class GeopositionDataView;

class GeopositionErrorDataView;

class GeopositionResultDataView;


}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::GeopositionDataView> {
  using Data = ::device::mojom::internal::Geoposition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GeopositionErrorDataView> {
  using Data = ::device::mojom::internal::GeopositionError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GeopositionResultDataView> {
  using Data = ::device::mojom::internal::GeopositionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class GeopositionErrorCode : int32_t {
  
  kPermissionDenied = 1,
  
  kPositionUnavailable = 2,
  
  kWifiDisabled = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, GeopositionErrorCode value);
inline bool IsKnownEnumValue(GeopositionErrorCode value) {
  return internal::GeopositionErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GeopositionDataView {
 public:
  GeopositionDataView() = default;

  GeopositionDataView(
      internal::Geoposition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double latitude() const {
    return data_->latitude;
  }
  double longitude() const {
    return data_->longitude;
  }
  double altitude() const {
    return data_->altitude;
  }
  double accuracy() const {
    return data_->accuracy;
  }
  double altitude_accuracy() const {
    return data_->altitude_accuracy;
  }
  double heading() const {
    return data_->heading;
  }
  double speed() const {
    return data_->speed;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::Geoposition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeopositionErrorDataView {
 public:
  GeopositionErrorDataView() = default;

  GeopositionErrorDataView(
      internal::GeopositionError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::device::mojom::GeopositionErrorCode>(
        data_value, output);
  }
  GeopositionErrorCode error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GeopositionErrorCode>(data_->error_code));
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetErrorTechnicalDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorTechnical(UserType* output) {
    
    auto* pointer = data_->error_technical.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeopositionError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeopositionResultDataView {
 public:
  using Tag = internal::GeopositionResult_Data::GeopositionResult_Tag;

  GeopositionResultDataView() = default;

  GeopositionResultDataView(
      internal::GeopositionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_position() const { return data_->tag == Tag::kPosition; }
  inline void GetPositionDataView(
      GeopositionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) const {
    
    CHECK(is_position());
    return mojo::internal::Deserialize<::device::mojom::GeopositionDataView>(
        data_->data.f_position.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      GeopositionErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::GeopositionErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::GeopositionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::GeopositionErrorCode>
    : public mojo::internal::EnumHashImpl<::device::mojom::GeopositionErrorCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeopositionErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GeopositionErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GeopositionErrorCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeopositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeopositionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Geoposition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->latitude = Traits::latitude(input);
    fragment->longitude = Traits::longitude(input);
    fragment->altitude = Traits::altitude(input);
    fragment->accuracy = Traits::accuracy(input);
    fragment->altitude_accuracy = Traits::altitude_accuracy(input);
    fragment->heading = Traits::heading(input);
    fragment->speed = Traits::speed(input);
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in Geoposition struct");
  }

  static bool Deserialize(::device::mojom::internal::Geoposition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GeopositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeopositionErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeopositionErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GeopositionError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::GeopositionErrorCode>(
        Traits::error_code(input), &fragment->error_code);
    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_error_message, error_message_fragment);
    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->error_message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_message in GeopositionError struct");
    decltype(Traits::error_technical(input)) in_error_technical = Traits::error_technical(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_technical)::BaseType> error_technical_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_error_technical, error_technical_fragment);
    fragment->error_technical.Set(
        error_technical_fragment.is_null() ? nullptr : error_technical_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->error_technical.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_technical in GeopositionError struct");
  }

  static bool Deserialize(::device::mojom::internal::GeopositionError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GeopositionErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeopositionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::GeopositionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::GeopositionResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::GeopositionResultDataView::Tag::kPosition: {
        decltype(Traits::position(input))
            in_position = Traits::position(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_position)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::GeopositionDataView>(
            in_position, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null position in GeopositionResult union");
        fragment->data.f_position.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::GeopositionResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_error)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::GeopositionErrorDataView>(
            in_error, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null error in GeopositionResult union");
        fragment->data.f_error.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::GeopositionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GeopositionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void GeopositionDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void GeopositionErrorDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GeopositionErrorDataView::GetErrorTechnicalDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_technical.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GeopositionResultDataView::GetPositionDataView(
    GeopositionDataView* output) const {
  CHECK(is_position());
  *output = GeopositionDataView(data_->data.f_position.Get(), message_);
}
inline void GeopositionResultDataView::GetErrorDataView(
    GeopositionErrorDataView* output) const {
  CHECK(is_error());
  *output = GeopositionErrorDataView(data_->data.f_error.Get(), message_);
}


}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::GeopositionErrorCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GeopositionErrorCode value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_H_