// services/device/public/mojom/geolocation_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geolocation_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation_config.mojom-params-data.h"
#include "services/device/public/mojom/geolocation_config.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geolocation_config.mojom-import-headers.h"
#include "services/device/public/mojom/geolocation_config.mojom-test-utils.h"


namespace device::mojom {
const char GeolocationConfig::Name_[] = "device.mojom.GeolocationConfig";

GeolocationConfig::IPCStableHashFunction GeolocationConfig::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GeolocationConfig>(message.name())) {
    case messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured: {
      return &GeolocationConfig::IsHighAccuracyLocationBeingCaptured_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GeolocationConfig::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GeolocationConfig>(message.name())) {
      case messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured:
            return "Receive device::mojom::GeolocationConfig::IsHighAccuracyLocationBeingCaptured";
    }
  } else {
    switch (static_cast<messages::GeolocationConfig>(message.name())) {
      case messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured:
            return "Receive reply device::mojom::GeolocationConfig::IsHighAccuracyLocationBeingCaptured";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GeolocationConfig::IsHighAccuracyLocationBeingCaptured_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::GeolocationConfig::IsHighAccuracyLocationBeingCaptured");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback(
      GeolocationConfig::IsHighAccuracyLocationBeingCapturedCallback callback
      ) : callback_(std::move(callback)) {
  }

  GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback(const GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback&) = delete;
  GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback& operator=(const GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GeolocationConfig::IsHighAccuracyLocationBeingCapturedCallback callback_;
};

GeolocationConfigProxy::GeolocationConfigProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationConfigProxy::IsHighAccuracyLocationBeingCaptured(
    IsHighAccuracyLocationBeingCapturedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::GeolocationConfig::IsHighAccuracyLocationBeingCaptured");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationConfig::Name_);
  message.set_method_name("IsHighAccuracyLocationBeingCaptured");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GeolocationConfig::IsHighAccuracyLocationBeingCapturedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder> proxy(
        new GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GeolocationConfig::IsHighAccuracyLocationBeingCapturedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_high_accuracy);
};

bool GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GeolocationConfig.0
  bool success = true;
  bool p_high_accuracy{};
  GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_high_accuracy = input_data_view.high_accuracy();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GeolocationConfig::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_high_accuracy));
  return true;
}

void GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder::Run(
    bool in_high_accuracy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::GeolocationConfig::IsHighAccuracyLocationBeingCaptured", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("high_accuracy"), in_high_accuracy,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->high_accuracy = in_high_accuracy;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationConfig::Name_);
  message.set_method_name("IsHighAccuracyLocationBeingCaptured");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GeolocationConfigStubDispatch::Accept(
    GeolocationConfig* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GeolocationConfig>(message->header()->name)) {
    case messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured: {
      break;
    }
  }
  return false;
}

// static
bool GeolocationConfigStubDispatch::AcceptWithResponder(
    GeolocationConfig* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GeolocationConfig>(message->header()->name)) {
    case messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured: {
      internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_Params_Data* params =
          reinterpret_cast<
              internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GeolocationConfig.0
      bool success = true;
      GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationConfig::Name_, 0, false);
        return false;
      }
      GeolocationConfig::IsHighAccuracyLocationBeingCapturedCallback callback =
          GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsHighAccuracyLocationBeingCaptured(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGeolocationConfigValidationInfo[] = {
    {base::to_underlying(messages::GeolocationConfig::kIsHighAccuracyLocationBeingCaptured),
     { &internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_Params_Data::Validate,
      &internal::GeolocationConfig_IsHighAccuracyLocationBeingCaptured_ResponseParams_Data::Validate}},
};

bool GeolocationConfigRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GeolocationConfig::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGeolocationConfigValidationInfo);
}

bool GeolocationConfigResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GeolocationConfig::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGeolocationConfigValidationInfo);

}


}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void GeolocationConfigInterceptorForTesting::IsHighAccuracyLocationBeingCaptured(IsHighAccuracyLocationBeingCapturedCallback callback) {
  GetForwardingInterface()->IsHighAccuracyLocationBeingCaptured(std::move(callback));
}
GeolocationConfigAsyncWaiter::GeolocationConfigAsyncWaiter(
    GeolocationConfig* proxy) : proxy_(proxy) {}

GeolocationConfigAsyncWaiter::~GeolocationConfigAsyncWaiter() = default;

void GeolocationConfigAsyncWaiter::IsHighAccuracyLocationBeingCaptured(
    bool* out_high_accuracy) {
  base::RunLoop loop;
  proxy_->IsHighAccuracyLocationBeingCaptured(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_high_accuracy
,
             bool high_accuracy) {*out_high_accuracy = std::move(high_accuracy);
            loop->Quit();
          },
          &loop,
          out_high_accuracy));
  loop.Run();
}

bool GeolocationConfigAsyncWaiter::IsHighAccuracyLocationBeingCaptured(
    ) {
  bool async_wait_result;
  IsHighAccuracyLocationBeingCaptured(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif