// services/device/public/mojom/fingerprint.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/fingerprint.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/fingerprint.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* ScanResultToStringHelper(ScanResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScanResult::SUCCESS:
      return "SUCCESS";
    case ScanResult::PARTIAL:
      return "PARTIAL";
    case ScanResult::INSUFFICIENT:
      return "INSUFFICIENT";
    case ScanResult::SENSOR_DIRTY:
      return "SENSOR_DIRTY";
    case ScanResult::TOO_SLOW:
      return "TOO_SLOW";
    case ScanResult::TOO_FAST:
      return "TOO_FAST";
    case ScanResult::IMMOBILE:
      return "IMMOBILE";
    case ScanResult::NO_MATCH:
      return "NO_MATCH";
    default:
      return nullptr;
  }
}

std::string ScanResultToString(ScanResult value) {
  const char *str = ScanResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScanResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScanResult value) {
  return os << ScanResultToString(value);
}

NOINLINE static const char* FingerprintErrorToStringHelper(FingerprintError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FingerprintError::UNKNOWN:
      return "UNKNOWN";
    case FingerprintError::HW_UNAVAILABLE:
      return "HW_UNAVAILABLE";
    case FingerprintError::UNABLE_TO_PROCESS:
      return "UNABLE_TO_PROCESS";
    case FingerprintError::TIMEOUT:
      return "TIMEOUT";
    case FingerprintError::NO_SPACE:
      return "NO_SPACE";
    case FingerprintError::CANCELED:
      return "CANCELED";
    case FingerprintError::UNABLE_TO_REMOVE:
      return "UNABLE_TO_REMOVE";
    case FingerprintError::LOCKOUT:
      return "LOCKOUT";
    case FingerprintError::NO_TEMPLATES:
      return "NO_TEMPLATES";
    default:
      return nullptr;
  }
}

std::string FingerprintErrorToString(FingerprintError value) {
  const char *str = FingerprintErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FingerprintError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FingerprintError value) {
  return os << FingerprintErrorToString(value);
}

NOINLINE static const char* BiometricTypeToStringHelper(BiometricType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BiometricType::UNKNOWN:
      return "UNKNOWN";
    case BiometricType::FINGERPRINT:
      return "FINGERPRINT";
    default:
      return nullptr;
  }
}

std::string BiometricTypeToString(BiometricType value) {
  const char *str = BiometricTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BiometricType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BiometricType value) {
  return os << BiometricTypeToString(value);
}

NOINLINE static const char* BiometricsManagerStatusToStringHelper(BiometricsManagerStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BiometricsManagerStatus::UNKNOWN:
      return "UNKNOWN";
    case BiometricsManagerStatus::INITIALIZED:
      return "INITIALIZED";
    default:
      return nullptr;
  }
}

std::string BiometricsManagerStatusToString(BiometricsManagerStatus value) {
  const char *str = BiometricsManagerStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BiometricsManagerStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BiometricsManagerStatus value) {
  return os << BiometricsManagerStatusToString(value);
}

namespace internal {
// static
bool FingerprintMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FingerprintMessage_Data* object = static_cast<const FingerprintMessage_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FingerprintMessage_Tag::kFingerprintError: {


      if (!::device::mojom::internal::FingerprintError_Data
            ::Validate(object->data.f_fingerprint_error, validation_context))
        return false;
      return true;
    }
    case FingerprintMessage_Tag::kScanResult: {


      if (!::device::mojom::internal::ScanResult_Data
            ::Validate(object->data.f_scan_result, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FingerprintMessage");
      return false;
    }
  }
}


// static
bool FingerprintObserver_OnRestarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FingerprintObserver_OnRestarted_Params_Data* object =
      static_cast<const FingerprintObserver_OnRestarted_Params_Data*>(data);

  return true;
}

FingerprintObserver_OnRestarted_Params_Data::FingerprintObserver_OnRestarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FingerprintObserver_OnStatusChanged_Params_Data* object =
      static_cast<const FingerprintObserver_OnStatusChanged_Params_Data*>(data);


  if (!::device::mojom::internal::BiometricsManagerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FingerprintObserver_OnStatusChanged_Params_Data::FingerprintObserver_OnStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnEnrollScanDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FingerprintObserver_OnEnrollScanDone_Params_Data* object =
      static_cast<const FingerprintObserver_OnEnrollScanDone_Params_Data*>(data);


  if (!::device::mojom::internal::ScanResult_Data
        ::Validate(object->scan_result, validation_context))
    return false;

  return true;
}

FingerprintObserver_OnEnrollScanDone_Params_Data::FingerprintObserver_OnEnrollScanDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnAuthScanDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FingerprintObserver_OnAuthScanDone_Params_Data* object =
      static_cast<const FingerprintObserver_OnAuthScanDone_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->msg, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->msg, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matches, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  if (!mojo::internal::ValidateContainer(object->matches, validation_context,
                                         &matches_validate_params)) {
    return false;
  }

  return true;
}

FingerprintObserver_OnAuthScanDone_Params_Data::FingerprintObserver_OnAuthScanDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FingerprintObserver_OnSessionFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FingerprintObserver_OnSessionFailed_Params_Data* object =
      static_cast<const FingerprintObserver_OnSessionFailed_Params_Data*>(data);

  return true;
}

FingerprintObserver_OnSessionFailed_Params_Data::FingerprintObserver_OnSessionFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_GetRecordsForUser_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_GetRecordsForUser_Params_Data* object =
      static_cast<const Fingerprint_GetRecordsForUser_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_GetRecordsForUser_Params_Data::Fingerprint_GetRecordsForUser_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_GetRecordsForUser_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_GetRecordsForUser_ResponseParams_Data* object =
      static_cast<const Fingerprint_GetRecordsForUser_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->records, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& records_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->records, validation_context,
                                         &records_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_GetRecordsForUser_ResponseParams_Data::Fingerprint_GetRecordsForUser_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_StartEnrollSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_StartEnrollSession_Params_Data* object =
      static_cast<const Fingerprint_StartEnrollSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_id, validation_context,
                                         &user_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_StartEnrollSession_Params_Data::Fingerprint_StartEnrollSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_CancelCurrentEnrollSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_CancelCurrentEnrollSession_Params_Data* object =
      static_cast<const Fingerprint_CancelCurrentEnrollSession_Params_Data*>(data);

  return true;
}

Fingerprint_CancelCurrentEnrollSession_Params_Data::Fingerprint_CancelCurrentEnrollSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data* object =
      static_cast<const Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data*>(data);

  return true;
}

Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestRecordLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RequestRecordLabel_Params_Data* object =
      static_cast<const Fingerprint_RequestRecordLabel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& record_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RequestRecordLabel_Params_Data::Fingerprint_RequestRecordLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestRecordLabel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RequestRecordLabel_ResponseParams_Data* object =
      static_cast<const Fingerprint_RequestRecordLabel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RequestRecordLabel_ResponseParams_Data::Fingerprint_RequestRecordLabel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_SetRecordLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_SetRecordLabel_Params_Data* object =
      static_cast<const Fingerprint_SetRecordLabel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& record_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_label, validation_context,
                                         &new_label_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_SetRecordLabel_Params_Data::Fingerprint_SetRecordLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_SetRecordLabel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_SetRecordLabel_ResponseParams_Data* object =
      static_cast<const Fingerprint_SetRecordLabel_ResponseParams_Data*>(data);

  return true;
}

Fingerprint_SetRecordLabel_ResponseParams_Data::Fingerprint_SetRecordLabel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RemoveRecord_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RemoveRecord_Params_Data* object =
      static_cast<const Fingerprint_RemoveRecord_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->record_path, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& record_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->record_path, validation_context,
                                         &record_path_validate_params)) {
    return false;
  }

  return true;
}

Fingerprint_RemoveRecord_Params_Data::Fingerprint_RemoveRecord_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RemoveRecord_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RemoveRecord_ResponseParams_Data* object =
      static_cast<const Fingerprint_RemoveRecord_ResponseParams_Data*>(data);

  return true;
}

Fingerprint_RemoveRecord_ResponseParams_Data::Fingerprint_RemoveRecord_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_StartAuthSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_StartAuthSession_Params_Data* object =
      static_cast<const Fingerprint_StartAuthSession_Params_Data*>(data);

  return true;
}

Fingerprint_StartAuthSession_Params_Data::Fingerprint_StartAuthSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_EndCurrentAuthSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_EndCurrentAuthSession_Params_Data* object =
      static_cast<const Fingerprint_EndCurrentAuthSession_Params_Data*>(data);

  return true;
}

Fingerprint_EndCurrentAuthSession_Params_Data::Fingerprint_EndCurrentAuthSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_EndCurrentAuthSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_EndCurrentAuthSession_ResponseParams_Data* object =
      static_cast<const Fingerprint_EndCurrentAuthSession_ResponseParams_Data*>(data);

  return true;
}

Fingerprint_EndCurrentAuthSession_ResponseParams_Data::Fingerprint_EndCurrentAuthSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_DestroyAllRecords_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_DestroyAllRecords_Params_Data* object =
      static_cast<const Fingerprint_DestroyAllRecords_Params_Data*>(data);

  return true;
}

Fingerprint_DestroyAllRecords_Params_Data::Fingerprint_DestroyAllRecords_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_DestroyAllRecords_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_DestroyAllRecords_ResponseParams_Data* object =
      static_cast<const Fingerprint_DestroyAllRecords_ResponseParams_Data*>(data);

  return true;
}

Fingerprint_DestroyAllRecords_ResponseParams_Data::Fingerprint_DestroyAllRecords_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_AddFingerprintObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_AddFingerprintObserver_Params_Data* object =
      static_cast<const Fingerprint_AddFingerprintObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Fingerprint_AddFingerprintObserver_Params_Data::Fingerprint_AddFingerprintObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RequestType_Params_Data* object =
      static_cast<const Fingerprint_RequestType_Params_Data*>(data);

  return true;
}

Fingerprint_RequestType_Params_Data::Fingerprint_RequestType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Fingerprint_RequestType_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Fingerprint_RequestType_ResponseParams_Data* object =
      static_cast<const Fingerprint_RequestType_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::BiometricType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

Fingerprint_RequestType_ResponseParams_Data::Fingerprint_RequestType_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::ScanResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::ScanResult value) {
  return std::move(context).WriteString(::device::mojom::ScanResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::FingerprintError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::FingerprintError value) {
  return std::move(context).WriteString(::device::mojom::FingerprintErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BiometricType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BiometricType value) {
  return std::move(context).WriteString(::device::mojom::BiometricTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::BiometricsManagerStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::BiometricsManagerStatus value) {
  return std::move(context).WriteString(::device::mojom::BiometricsManagerStatusToString(value));
}

} // namespace perfetto