// services/data_decoder/public/mojom/structured_headers_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_STRUCTURED_HEADERS_PARSER_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_STRUCTURED_HEADERS_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-features.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-shared.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/structured_headers_parser.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/structured_headers.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_decoder::mojom {

class StructuredHeadersParserProxy;

template <typename ImplRefTraits>
class StructuredHeadersParserStub;

class StructuredHeadersParserRequestValidator;
class StructuredHeadersParserResponseValidator;


class StructuredHeadersParser
    : public StructuredHeadersParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StructuredHeadersParserInterfaceBase;
  using Proxy_ = StructuredHeadersParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = StructuredHeadersParserStub<ImplRefTraits>;

  using RequestValidator_ = StructuredHeadersParserRequestValidator;
  using ResponseValidator_ = StructuredHeadersParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseItemMinVersion = 0,
    kParseListMinVersion = 0,
    kParseDictionaryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ParseItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseDictionary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StructuredHeadersParser() = default;


  using ParseItemCallback = base::OnceCallback<void(std::optional<::net::structured_headers::ParameterizedItem>)>;
  
  virtual void ParseItem(const std::string& header, ParseItemCallback callback) = 0;


  using ParseListCallback = base::OnceCallback<void(std::optional<std::vector<::net::structured_headers::ParameterizedMember>>)>;
  
  virtual void ParseList(const std::string& header, ParseListCallback callback) = 0;


  using ParseDictionaryCallback = base::OnceCallback<void(std::optional<::net::structured_headers::Dictionary>)>;
  
  virtual void ParseDictionary(const std::string& header, ParseDictionaryCallback callback) = 0;
};



class  StructuredHeadersParserProxy
    : public StructuredHeadersParser {
 public:
  using InterfaceType = StructuredHeadersParser;

  explicit StructuredHeadersParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ParseItem(const std::string& header, ParseItemCallback callback) final;
  
  void ParseList(const std::string& header, ParseListCallback callback) final;
  
  void ParseDictionary(const std::string& header, ParseDictionaryCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  StructuredHeadersParserStubDispatch {
 public:
  static bool Accept(StructuredHeadersParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StructuredHeadersParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StructuredHeadersParser>>
class StructuredHeadersParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StructuredHeadersParserStub() = default;
  ~StructuredHeadersParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StructuredHeadersParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StructuredHeadersParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StructuredHeadersParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StructuredHeadersParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // data_decoder::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_STRUCTURED_HEADERS_PARSER_MOJOM_H_