// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/common/extensions/api/generated_schemas.h"

#include <algorithm>
#include <iterator>
#include <string_view>

#include "base/containers/fixed_flat_map.h"

namespace {
constexpr char kResourcesPrivate[] = R"R({"namespace":"resourcesPrivate","types":[{"id":"resourcesPrivate.Component","type":"string","enum":[{"name":"identity"},{"name":"pdf"}]}],"functions":[{"parameters":[{"name":"component","$ref":"resourcesPrivate.Component"}],"returns_async":{"name":"callback","parameters":[{"name":"result","type":"object","additionalProperties":{"type":"any"}}]},"name":"getStrings","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
constexpr char kTabs[] = R"R({"namespace":"tabs","types":[{"id":"tabs.Tab","type":"object","properties":{"id":{"type":"integer","minimum":0},"index":{"type":"integer","minimum":0},"windowId":{"type":"integer","minimum":0},"selected":{"type":"boolean"},"highlighted":{"type":"boolean"},"active":{"type":"boolean"},"pinned":{"type":"boolean"},"url":{"type":"string"},"title":{"type":"string","optional":true},"favIconUrl":{"type":"string","optional":true},"status":{"type":"string","optional":true},"incognito":{"type":"boolean"}}}],"properties":{"TAB_ID_NONE":{"value":-1,"type":"integer"}},"functions":[{"name":"update","type":"function","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true},{"type":"object","name":"updateProperties","properties":{"url":{"type":"string","optional":true},"active":{"type":"boolean","optional":true},"highlighted":{"type":"boolean","optional":true},"selected":{"deprecated":"Please use <em>highlighted</em>.","type":"boolean","optional":true},"pinned":{"type":"boolean","optional":true},"muted":{"type":"boolean","optional":true},"openerTabId":{"type":"integer","minimum":0,"optional":true},"autoDiscardable":{"type":"boolean","optional":true}}}],"returns_async":{"name":"callback","optional":true,"parameters":[{"name":"tab","$ref":"tabs.Tab","optional":true}]}}]})R";
constexpr char kWebrtcDesktopCapturePrivate[] = R"R({"namespace":"webrtcDesktopCapturePrivate","types":[{"id":"webrtcDesktopCapturePrivate.RequestInfo","properties":{"guestProcessId":{"name":"guestProcessId","type":"integer"},"guestRenderFrameId":{"name":"guestRenderFrameId","type":"integer"}},"type":"object"},{"id":"webrtcDesktopCapturePrivate.Options","properties":{"canRequestAudioTrack":{"name":"canRequestAudioTrack","type":"boolean"}},"type":"object"}],"functions":[{"parameters":[{"name":"request","$ref":"webrtcDesktopCapturePrivate.RequestInfo"}],"returns":{"name":"chooseDesktopMedia","type":"integer"},"returns_async":{"name":"callback","parameters":[{"name":"streamId","type":"string"},{"name":"options","$ref":"webrtcDesktopCapturePrivate.Options"}],"does_not_support_promises":"Synchronous return and callback crbug.com/1143032"},"name":"chooseDesktopMedia","type":"function"}],"properties":{},"events":[],"platforms":null,"deprecated":null})R";
}  // namespace

namespace extensions {
namespace api {

// static
bool QtWebEngineGeneratedSchemas::IsGenerated(std::string_view name) {
  return !Get(name).empty();
}

// static
std::string_view QtWebEngineGeneratedSchemas::Get(std::string_view name) {
  static constexpr auto kSchemas = base::MakeFixedFlatMap<std::string_view, std::string_view>({
    {"resourcesPrivate", kResourcesPrivate},
    {"tabs", kTabs},
    {"webrtcDesktopCapturePrivate", kWebrtcDesktopCapturePrivate},
  });
  auto it = kSchemas.find(name);
  return it != kSchemas.end() ? it->second : std::string_view();
}

}  // namespace api
}  // namespace extensions
