// media/mojo/mojom/speech_recognizer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognizer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognizer.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognizer.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognizer.mojom-blink-import-headers.h"
#include "media/mojo/mojom/speech_recognizer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
StartSpeechRecognitionRequestParams::StartSpeechRecognitionRequestParams()
    : session_receiver(),
      client(),
      language(),
      grammars(),
      recognition_context(),
      max_hypotheses(),
      continuous(),
      interim_results(),
      on_device(),
      allow_cloud_fallback(),
      audio_forwarder(),
      channel_count(),
      sample_rate() {}

StartSpeechRecognitionRequestParams::StartSpeechRecognitionRequestParams(
    ::mojo::PendingReceiver<SpeechRecognitionSession> session_receiver_in,
    ::mojo::PendingRemote<SpeechRecognitionSessionClient> client_in,
    const WTF::String& language_in,
    WTF::Vector<::media::mojom::blink::SpeechRecognitionGrammarPtr> grammars_in,
    ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context_in,
    uint32_t max_hypotheses_in,
    bool continuous_in,
    bool interim_results_in,
    bool on_device_in,
    bool allow_cloud_fallback_in,
    ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionAudioForwarder> audio_forwarder_in,
    int32_t channel_count_in,
    int32_t sample_rate_in)
    : session_receiver(std::move(session_receiver_in)),
      client(std::move(client_in)),
      language(std::move(language_in)),
      grammars(std::move(grammars_in)),
      recognition_context(std::move(recognition_context_in)),
      max_hypotheses(std::move(max_hypotheses_in)),
      continuous(std::move(continuous_in)),
      interim_results(std::move(interim_results_in)),
      on_device(std::move(on_device_in)),
      allow_cloud_fallback(std::move(allow_cloud_fallback_in)),
      audio_forwarder(std::move(audio_forwarder_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)) {}

StartSpeechRecognitionRequestParams::~StartSpeechRecognitionRequestParams() = default;

void StartSpeechRecognitionRequestParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_receiver"), this->session_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<SpeechRecognitionSession>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client"), this->client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<SpeechRecognitionSessionClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grammars"), this->grammars,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::media::mojom::blink::SpeechRecognitionGrammarPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recognition_context"), this->recognition_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_hypotheses"), this->max_hypotheses,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "continuous"), this->continuous,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interim_results"), this->interim_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_device"), this->on_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_cloud_fallback"), this->allow_cloud_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_forwarder"), this->audio_forwarder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionAudioForwarder>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StartSpeechRecognitionRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeechRecognizer::Name_[] = "media.mojom.SpeechRecognizer";

SpeechRecognizer::IPCStableHashFunction SpeechRecognizer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognizer>(message.name())) {
    case messages::SpeechRecognizer::kStart: {
      return &SpeechRecognizer::Start_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognizer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognizer>(message.name())) {
      case messages::SpeechRecognizer::kStart:
            return "Receive media::mojom::SpeechRecognizer::Start";
    }
  } else {
    switch (static_cast<messages::SpeechRecognizer>(message.name())) {
      case messages::SpeechRecognizer::kStart:
            return "Receive reply media::mojom::SpeechRecognizer::Start";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognizer::Start_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognizer::Start");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognizerProxy::SpeechRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognizerProxy::Start(
    StartSpeechRecognitionRequestParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognizer::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type StartSpeechRecognitionRequestParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognizer::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognizer_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StartSpeechRecognitionRequestParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SpeechRecognizer.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognizer::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognizerStubDispatch::Accept(
    SpeechRecognizer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognizer>(message->header()->name)) {
    case messages::SpeechRecognizer::kStart: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognizer_Start_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognizer_Start_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognizer.0
      bool success = true;
      StartSpeechRecognitionRequestParamsPtr p_params{};
      SpeechRecognizer_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognizerStubDispatch::AcceptWithResponder(
    SpeechRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognizer>(message->header()->name)) {
    case messages::SpeechRecognizer::kStart: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognizerValidationInfo[] = {
    {base::to_underlying(messages::SpeechRecognizer::kStart),
     { &internal::SpeechRecognizer_Start_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognizerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognizer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognizerValidationInfo);
}

const char OnDeviceSpeechRecognition::Name_[] = "media.mojom.OnDeviceSpeechRecognition";

OnDeviceSpeechRecognition::IPCStableHashFunction OnDeviceSpeechRecognition::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OnDeviceSpeechRecognition>(message.name())) {
    case messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable: {
      return &OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable_Sym::IPCStableHash;
    }
    case messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition: {
      return &OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OnDeviceSpeechRecognition::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OnDeviceSpeechRecognition>(message.name())) {
      case messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable:
            return "Receive media::mojom::OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable";
      case messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition:
            return "Receive media::mojom::OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition";
    }
  } else {
    switch (static_cast<messages::OnDeviceSpeechRecognition>(message.name())) {
      case messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable:
            return "Receive reply media::mojom::OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable";
      case messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition:
            return "Receive reply media::mojom::OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback(
      OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback(const OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback&) = delete;
  OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback& operator=(const OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailableCallback callback_;
};

class OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback(
      OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognitionCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback(const OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback&) = delete;
  OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback& operator=(const OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognitionCallback callback_;
};

OnDeviceSpeechRecognitionProxy::OnDeviceSpeechRecognitionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OnDeviceSpeechRecognitionProxy::OnDeviceWebSpeechAvailable(
    const WTF::String& in_language, OnDeviceWebSpeechAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_language, language_fragment);
  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->language.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in OnDeviceSpeechRecognition.OnDeviceWebSpeechAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceSpeechRecognition::Name_);
  message.set_method_name("OnDeviceWebSpeechAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceSpeechRecognitionProxy::InstallOnDeviceSpeechRecognition(
    const WTF::String& in_language, InstallOnDeviceSpeechRecognitionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("language"), in_language,
                        "<value of type const WTF::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->language)::BaseType> language_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_language, language_fragment);
  params->language.Set(
      language_fragment.is_null() ? nullptr : language_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->language.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in OnDeviceSpeechRecognition.InstallOnDeviceSpeechRecognition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceSpeechRecognition::Name_);
  message.set_method_name("InstallOnDeviceSpeechRecognition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder> proxy(
        new OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);
};

bool OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for OnDeviceSpeechRecognition.0
  bool success = true;
  bool p_available{};
  OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceSpeechRecognition::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_available));
  return true;
}

void OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceSpeechRecognition::Name_);
  message.set_method_name("OnDeviceWebSpeechAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognitionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder> proxy(
        new OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognitionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for OnDeviceSpeechRecognition.1
  bool success = true;
  bool p_success{};
  OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceSpeechRecognition::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognition", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceSpeechRecognition::Name_);
  message.set_method_name("InstallOnDeviceSpeechRecognition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OnDeviceSpeechRecognitionStubDispatch::Accept(
    OnDeviceSpeechRecognition* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OnDeviceSpeechRecognition>(message->header()->name)) {
    case messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable: {
      break;
    }
    case messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition: {
      break;
    }
  }
  return false;
}

// static
bool OnDeviceSpeechRecognitionStubDispatch::AcceptWithResponder(
    OnDeviceSpeechRecognition* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OnDeviceSpeechRecognition>(message->header()->name)) {
    case messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable: {
      internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for OnDeviceSpeechRecognition.0
      bool success = true;
      WTF::String p_language{};
      OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceSpeechRecognition::Name_, 0, false);
        return false;
      }
      OnDeviceSpeechRecognition::OnDeviceWebSpeechAvailableCallback callback =
          OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceWebSpeechAvailable(        
        std::move(p_language), std::move(callback));
      return true;
    }
    case messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition: {
      internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for OnDeviceSpeechRecognition.1
      bool success = true;
      WTF::String p_language{};
      OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLanguage(&p_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceSpeechRecognition::Name_, 1, false);
        return false;
      }
      OnDeviceSpeechRecognition::InstallOnDeviceSpeechRecognitionCallback callback =
          OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallOnDeviceSpeechRecognition(        
        std::move(p_language), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kOnDeviceSpeechRecognitionValidationInfo[] = {
    {base::to_underlying(messages::OnDeviceSpeechRecognition::kOnDeviceWebSpeechAvailable),
     { &internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_Params_Data::Validate,
      &internal::OnDeviceSpeechRecognition_OnDeviceWebSpeechAvailable_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::OnDeviceSpeechRecognition::kInstallOnDeviceSpeechRecognition),
     { &internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_Params_Data::Validate,
      &internal::OnDeviceSpeechRecognition_InstallOnDeviceSpeechRecognition_ResponseParams_Data::Validate}},
};

bool OnDeviceSpeechRecognitionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::OnDeviceSpeechRecognition::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kOnDeviceSpeechRecognitionValidationInfo);
}

bool OnDeviceSpeechRecognitionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::OnDeviceSpeechRecognition::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kOnDeviceSpeechRecognitionValidationInfo);

}
const char SpeechRecognitionSession::Name_[] = "media.mojom.SpeechRecognitionSession";

SpeechRecognitionSession::IPCStableHashFunction SpeechRecognitionSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionSession>(message.name())) {
    case messages::SpeechRecognitionSession::kAbort: {
      return &SpeechRecognitionSession::Abort_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSession::kStopCapture: {
      return &SpeechRecognitionSession::StopCapture_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSession::kUpdateRecognitionContext: {
      return &SpeechRecognitionSession::UpdateRecognitionContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionSession>(message.name())) {
      case messages::SpeechRecognitionSession::kAbort:
            return "Receive media::mojom::SpeechRecognitionSession::Abort";
      case messages::SpeechRecognitionSession::kStopCapture:
            return "Receive media::mojom::SpeechRecognitionSession::StopCapture";
      case messages::SpeechRecognitionSession::kUpdateRecognitionContext:
            return "Receive media::mojom::SpeechRecognitionSession::UpdateRecognitionContext";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionSession>(message.name())) {
      case messages::SpeechRecognitionSession::kAbort:
            return "Receive reply media::mojom::SpeechRecognitionSession::Abort";
      case messages::SpeechRecognitionSession::kStopCapture:
            return "Receive reply media::mojom::SpeechRecognitionSession::StopCapture";
      case messages::SpeechRecognitionSession::kUpdateRecognitionContext:
            return "Receive reply media::mojom::SpeechRecognitionSession::UpdateRecognitionContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionSession::Abort_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSession::Abort");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSession::StopCapture_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSession::StopCapture");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSession::UpdateRecognitionContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSession::UpdateRecognitionContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionSessionProxy::SpeechRecognitionSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSessionProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSession::Abort");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSession::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSession_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSession::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionProxy::StopCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSession::StopCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSession::kStopCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSession_StopCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSession::Name_);
  message.set_method_name("StopCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionProxy::UpdateRecognitionContext(
    ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr in_recognition_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionSession::UpdateRecognitionContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recognition_context"), in_recognition_context,
                        "<value of type ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSession::kUpdateRecognitionContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSession_UpdateRecognitionContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->recognition_context)::BaseType> recognition_context_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
      in_recognition_context, recognition_context_fragment);
  params->recognition_context.Set(
      recognition_context_fragment.is_null() ? nullptr : recognition_context_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->recognition_context.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null recognition_context in SpeechRecognitionSession.UpdateRecognitionContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSession::Name_);
  message.set_method_name("UpdateRecognitionContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionSessionStubDispatch::Accept(
    SpeechRecognitionSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionSession>(message->header()->name)) {
    case messages::SpeechRecognitionSession::kAbort: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSession_Abort_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSession_Abort_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSession.0
      bool success = true;
      SpeechRecognitionSession_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        );
      return true;
    }
    case messages::SpeechRecognitionSession::kStopCapture: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSession_StopCapture_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSession_StopCapture_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSession.1
      bool success = true;
      SpeechRecognitionSession_StopCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSession::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopCapture(        );
      return true;
    }
    case messages::SpeechRecognitionSession::kUpdateRecognitionContext: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSession_UpdateRecognitionContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSession_UpdateRecognitionContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSession.2
      bool success = true;
      ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr p_recognition_context{};
      SpeechRecognitionSession_UpdateRecognitionContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecognitionContext(&p_recognition_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSession::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRecognitionContext(        
        std::move(p_recognition_context));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSessionStubDispatch::AcceptWithResponder(
    SpeechRecognitionSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionSession>(message->header()->name)) {
    case messages::SpeechRecognitionSession::kAbort: {
      break;
    }
    case messages::SpeechRecognitionSession::kStopCapture: {
      break;
    }
    case messages::SpeechRecognitionSession::kUpdateRecognitionContext: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionSessionValidationInfo[] = {
    { &internal::SpeechRecognitionSession_Abort_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSession_StopCapture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSession_UpdateRecognitionContext_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionSessionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionSession::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechRecognitionSessionValidationInfo);
}

const char SpeechRecognitionSessionClient::Name_[] = "media.mojom.SpeechRecognitionSessionClient";

SpeechRecognitionSessionClient::IPCStableHashFunction SpeechRecognitionSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionSessionClient>(message.name())) {
    case messages::SpeechRecognitionSessionClient::kResultRetrieved: {
      return &SpeechRecognitionSessionClient::ResultRetrieved_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kErrorOccurred: {
      return &SpeechRecognitionSessionClient::ErrorOccurred_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kStarted: {
      return &SpeechRecognitionSessionClient::Started_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kAudioStarted: {
      return &SpeechRecognitionSessionClient::AudioStarted_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kSoundStarted: {
      return &SpeechRecognitionSessionClient::SoundStarted_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kSoundEnded: {
      return &SpeechRecognitionSessionClient::SoundEnded_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kAudioEnded: {
      return &SpeechRecognitionSessionClient::AudioEnded_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionSessionClient::kEnded: {
      return &SpeechRecognitionSessionClient::Ended_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionSessionClient>(message.name())) {
      case messages::SpeechRecognitionSessionClient::kResultRetrieved:
            return "Receive media::mojom::SpeechRecognitionSessionClient::ResultRetrieved";
      case messages::SpeechRecognitionSessionClient::kErrorOccurred:
            return "Receive media::mojom::SpeechRecognitionSessionClient::ErrorOccurred";
      case messages::SpeechRecognitionSessionClient::kStarted:
            return "Receive media::mojom::SpeechRecognitionSessionClient::Started";
      case messages::SpeechRecognitionSessionClient::kAudioStarted:
            return "Receive media::mojom::SpeechRecognitionSessionClient::AudioStarted";
      case messages::SpeechRecognitionSessionClient::kSoundStarted:
            return "Receive media::mojom::SpeechRecognitionSessionClient::SoundStarted";
      case messages::SpeechRecognitionSessionClient::kSoundEnded:
            return "Receive media::mojom::SpeechRecognitionSessionClient::SoundEnded";
      case messages::SpeechRecognitionSessionClient::kAudioEnded:
            return "Receive media::mojom::SpeechRecognitionSessionClient::AudioEnded";
      case messages::SpeechRecognitionSessionClient::kEnded:
            return "Receive media::mojom::SpeechRecognitionSessionClient::Ended";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionSessionClient>(message.name())) {
      case messages::SpeechRecognitionSessionClient::kResultRetrieved:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::ResultRetrieved";
      case messages::SpeechRecognitionSessionClient::kErrorOccurred:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::ErrorOccurred";
      case messages::SpeechRecognitionSessionClient::kStarted:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::Started";
      case messages::SpeechRecognitionSessionClient::kAudioStarted:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::AudioStarted";
      case messages::SpeechRecognitionSessionClient::kSoundStarted:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::SoundStarted";
      case messages::SpeechRecognitionSessionClient::kSoundEnded:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::SoundEnded";
      case messages::SpeechRecognitionSessionClient::kAudioEnded:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::AudioEnded";
      case messages::SpeechRecognitionSessionClient::kEnded:
            return "Receive reply media::mojom::SpeechRecognitionSessionClient::Ended";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionSessionClient::ResultRetrieved_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::ResultRetrieved");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::ErrorOccurred_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::ErrorOccurred");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::Started_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::Started");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::AudioStarted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::AudioStarted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::SoundStarted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::SoundStarted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::SoundEnded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::SoundEnded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::AudioEnded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::AudioEnded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionSessionClient::Ended_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::SpeechRecognitionSessionClient::Ended");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionSessionClientProxy::SpeechRecognitionSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSessionClientProxy::ResultRetrieved(
    WTF::Vector<::media::mojom::blink::WebSpeechRecognitionResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionSessionClient::ResultRetrieved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type WTF::Vector<::media::mojom::blink::WebSpeechRecognitionResultPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kResultRetrieved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::WebSpeechRecognitionResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in SpeechRecognitionSessionClient.ResultRetrieved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("ResultRetrieved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::ErrorOccurred(
    ::media::mojom::blink::SpeechRecognitionErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionSessionClient::ErrorOccurred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::media::mojom::blink::SpeechRecognitionErrorPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kErrorOccurred), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in SpeechRecognitionSessionClient.ErrorOccurred request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("ErrorOccurred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::Started(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::Started");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_Started_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("Started");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::AudioStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::AudioStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kAudioStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("AudioStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::SoundStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::SoundStarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kSoundStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("SoundStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::SoundEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::SoundEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kSoundEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("SoundEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::AudioEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::AudioEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kAudioEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("AudioEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionSessionClientProxy::Ended(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SpeechRecognitionSessionClient::Ended");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionSessionClient::kEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionSessionClient_Ended_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("Ended");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionSessionClientStubDispatch::Accept(
    SpeechRecognitionSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionSessionClient>(message->header()->name)) {
    case messages::SpeechRecognitionSessionClient::kResultRetrieved: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.0
      bool success = true;
      WTF::Vector<::media::mojom::blink::WebSpeechRecognitionResultPtr> p_results{};
      SpeechRecognitionSessionClient_ResultRetrieved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResults(&p_results))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResultRetrieved(        
        std::move(p_results));
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kErrorOccurred: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.1
      bool success = true;
      ::media::mojom::blink::SpeechRecognitionErrorPtr p_error{};
      SpeechRecognitionSessionClient_ErrorOccurred_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ErrorOccurred(        
        std::move(p_error));
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kStarted: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_Started_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_Started_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.2
      bool success = true;
      SpeechRecognitionSessionClient_Started_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Started(        );
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kAudioStarted: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.3
      bool success = true;
      SpeechRecognitionSessionClient_AudioStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioStarted(        );
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kSoundStarted: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.4
      bool success = true;
      SpeechRecognitionSessionClient_SoundStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SoundStarted(        );
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kSoundEnded: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.5
      bool success = true;
      SpeechRecognitionSessionClient_SoundEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SoundEnded(        );
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kAudioEnded: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.6
      bool success = true;
      SpeechRecognitionSessionClient_AudioEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioEnded(        );
      return true;
    }
    case messages::SpeechRecognitionSessionClient::kEnded: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_Ended_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_Ended_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SpeechRecognitionSessionClient.7
      bool success = true;
      SpeechRecognitionSessionClient_Ended_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ended(        );
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSessionClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionSessionClient>(message->header()->name)) {
    case messages::SpeechRecognitionSessionClient::kResultRetrieved: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kErrorOccurred: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kStarted: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kAudioStarted: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kSoundStarted: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kSoundEnded: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kAudioEnded: {
      break;
    }
    case messages::SpeechRecognitionSessionClient::kEnded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionSessionClientValidationInfo[] = {
    { &internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_Started_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionSessionClient_Ended_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::SpeechRecognitionSessionClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechRecognitionSessionClientValidationInfo);
}



}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::StartSpeechRecognitionRequestParams::DataView, ::media::mojom::blink::StartSpeechRecognitionRequestParamsPtr>::Read(
    ::media::mojom::blink::StartSpeechRecognitionRequestParams::DataView input,
    ::media::mojom::blink::StartSpeechRecognitionRequestParamsPtr* output) {
  bool success = true;
  ::media::mojom::blink::StartSpeechRecognitionRequestParamsPtr result(::media::mojom::blink::StartSpeechRecognitionRequestParams::New());
  
      if (success) {
        result->session_receiver =
            input.TakeSessionReceiver<decltype(result->session_receiver)>();
      }
      if (success) {
        result->client =
            input.TakeClient<decltype(result->client)>();
      }
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadGrammars(&result->grammars))
        success = false;
      if (success && !input.ReadRecognitionContext(&result->recognition_context))
        success = false;
      if (success)
        result->max_hypotheses = input.max_hypotheses();
      if (success)
        result->continuous = input.continuous();
      if (success)
        result->interim_results = input.interim_results();
      if (success)
        result->on_device = input.on_device();
      if (success)
        result->allow_cloud_fallback = input.allow_cloud_fallback();
      if (success) {
        result->audio_forwarder =
            input.TakeAudioForwarder<decltype(result->audio_forwarder)>();
      }
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void SpeechRecognizerInterceptorForTesting::Start(StartSpeechRecognitionRequestParamsPtr params) {
  GetForwardingInterface()->Start(
    std::move(params)
    );
}
SpeechRecognizerAsyncWaiter::SpeechRecognizerAsyncWaiter(
    SpeechRecognizer* proxy) : proxy_(proxy) {}

SpeechRecognizerAsyncWaiter::~SpeechRecognizerAsyncWaiter() = default;




void OnDeviceSpeechRecognitionInterceptorForTesting::OnDeviceWebSpeechAvailable(const WTF::String& language, OnDeviceWebSpeechAvailableCallback callback) {
  GetForwardingInterface()->OnDeviceWebSpeechAvailable(
    std::move(language)
    , std::move(callback));
}
void OnDeviceSpeechRecognitionInterceptorForTesting::InstallOnDeviceSpeechRecognition(const WTF::String& language, InstallOnDeviceSpeechRecognitionCallback callback) {
  GetForwardingInterface()->InstallOnDeviceSpeechRecognition(
    std::move(language)
    , std::move(callback));
}
OnDeviceSpeechRecognitionAsyncWaiter::OnDeviceSpeechRecognitionAsyncWaiter(
    OnDeviceSpeechRecognition* proxy) : proxy_(proxy) {}

OnDeviceSpeechRecognitionAsyncWaiter::~OnDeviceSpeechRecognitionAsyncWaiter() = default;

void OnDeviceSpeechRecognitionAsyncWaiter::OnDeviceWebSpeechAvailable(
    const WTF::String& language, bool* out_available) {
  base::RunLoop loop;
  proxy_->OnDeviceWebSpeechAvailable(
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_available
,
             bool available) {*out_available = std::move(available);
            loop->Quit();
          },
          &loop,
          out_available));
  loop.Run();
}

bool OnDeviceSpeechRecognitionAsyncWaiter::OnDeviceWebSpeechAvailable(
    const WTF::String& language) {
  bool async_wait_result;
  OnDeviceWebSpeechAvailable(std::move(language),&async_wait_result);
  return async_wait_result;
}

void OnDeviceSpeechRecognitionAsyncWaiter::InstallOnDeviceSpeechRecognition(
    const WTF::String& language, bool* out_success) {
  base::RunLoop loop;
  proxy_->InstallOnDeviceSpeechRecognition(
      std::move(language),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool OnDeviceSpeechRecognitionAsyncWaiter::InstallOnDeviceSpeechRecognition(
    const WTF::String& language) {
  bool async_wait_result;
  InstallOnDeviceSpeechRecognition(std::move(language),&async_wait_result);
  return async_wait_result;
}




void SpeechRecognitionSessionInterceptorForTesting::Abort() {
  GetForwardingInterface()->Abort();
}
void SpeechRecognitionSessionInterceptorForTesting::StopCapture() {
  GetForwardingInterface()->StopCapture();
}
void SpeechRecognitionSessionInterceptorForTesting::UpdateRecognitionContext(::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context) {
  GetForwardingInterface()->UpdateRecognitionContext(
    std::move(recognition_context)
    );
}
SpeechRecognitionSessionAsyncWaiter::SpeechRecognitionSessionAsyncWaiter(
    SpeechRecognitionSession* proxy) : proxy_(proxy) {}

SpeechRecognitionSessionAsyncWaiter::~SpeechRecognitionSessionAsyncWaiter() = default;




void SpeechRecognitionSessionClientInterceptorForTesting::ResultRetrieved(WTF::Vector<::media::mojom::blink::WebSpeechRecognitionResultPtr> results) {
  GetForwardingInterface()->ResultRetrieved(
    std::move(results)
    );
}
void SpeechRecognitionSessionClientInterceptorForTesting::ErrorOccurred(::media::mojom::blink::SpeechRecognitionErrorPtr error) {
  GetForwardingInterface()->ErrorOccurred(
    std::move(error)
    );
}
void SpeechRecognitionSessionClientInterceptorForTesting::Started() {
  GetForwardingInterface()->Started();
}
void SpeechRecognitionSessionClientInterceptorForTesting::AudioStarted() {
  GetForwardingInterface()->AudioStarted();
}
void SpeechRecognitionSessionClientInterceptorForTesting::SoundStarted() {
  GetForwardingInterface()->SoundStarted();
}
void SpeechRecognitionSessionClientInterceptorForTesting::SoundEnded() {
  GetForwardingInterface()->SoundEnded();
}
void SpeechRecognitionSessionClientInterceptorForTesting::AudioEnded() {
  GetForwardingInterface()->AudioEnded();
}
void SpeechRecognitionSessionClientInterceptorForTesting::Ended() {
  GetForwardingInterface()->Ended();
}
SpeechRecognitionSessionClientAsyncWaiter::SpeechRecognitionSessionClientAsyncWaiter(
    SpeechRecognitionSessionClient* proxy) : proxy_(proxy) {}

SpeechRecognitionSessionClientAsyncWaiter::~SpeechRecognitionSessionClientAsyncWaiter() = default;






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif