// media/capture/mojom/image_capture.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_H_
#define MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/image_capture.mojom-features.h"  // IWYU pragma: export
#include "media/capture/mojom/image_capture.mojom-shared.h"  // IWYU pragma: export
#include "media/capture/mojom/image_capture.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class ImageCaptureProxy;

template <typename ImplRefTraits>
class ImageCaptureStub;

class ImageCaptureRequestValidator;
class ImageCaptureResponseValidator;


class ImageCapture
    : public ImageCaptureInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImageCaptureInterfaceBase;
  using Proxy_ = ImageCaptureProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImageCaptureStub<ImplRefTraits>;

  using RequestValidator_ = ImageCaptureRequestValidator;
  using ResponseValidator_ = ImageCaptureResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPhotoStateMinVersion = 0,
    kSetPhotoOptionsMinVersion = 0,
    kTakePhotoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPhotoState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPhotoOptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakePhoto_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImageCapture() = default;


  using GetPhotoStateCallback = base::OnceCallback<void(PhotoStatePtr)>;
  
  virtual void GetPhotoState(const std::string& source_id, GetPhotoStateCallback callback) = 0;


  using SetPhotoOptionsCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetPhotoOptions(const std::string& source_id, PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) = 0;


  using TakePhotoCallback = base::OnceCallback<void(BlobPtr)>;
  
  virtual void TakePhoto(const std::string& source_id, TakePhotoCallback callback) = 0;
};



class  ImageCaptureProxy
    : public ImageCapture {
 public:
  using InterfaceType = ImageCapture;

  explicit ImageCaptureProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPhotoState(const std::string& source_id, GetPhotoStateCallback callback) final;
  
  void SetPhotoOptions(const std::string& source_id, PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) final;
  
  void TakePhoto(const std::string& source_id, TakePhotoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ImageCaptureStubDispatch {
 public:
  static bool Accept(ImageCapture* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImageCapture* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImageCapture>>
class ImageCaptureStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImageCaptureStub() = default;
  ~ImageCaptureStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageCaptureStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageCaptureStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ImageCaptureRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ImageCaptureResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Range {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Range, T>::value>;
  using DataView = RangeDataView;
  using Data_ = internal::Range_Data;

  template <typename... Args>
  static RangePtr New(Args&&... args) {
    return RangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RangePtr From(const U& u) {
    return mojo::TypeConverter<RangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Range>::Convert(*this);
  }


  Range();

  Range(
      double max,
      double min,
      double current,
      double step);


  ~Range();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RangePtr>
  RangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Range::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Range::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Range::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Range_UnserializedMessageContext<
            UserType, Range::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Range::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Range::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Range_UnserializedMessageContext<
            UserType, Range::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Range::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double max;
  
  double min;
  
  double current;
  
  double step;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Range::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Point2D {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Point2D, T>::value>;
  using DataView = Point2DDataView;
  using Data_ = internal::Point2D_Data;

  template <typename... Args>
  static Point2DPtr New(Args&&... args) {
    return Point2DPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Point2DPtr From(const U& u) {
    return mojo::TypeConverter<Point2DPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Point2D>::Convert(*this);
  }


  Point2D();

  Point2D(
      double x,
      double y);


  ~Point2D();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Point2DPtr>
  Point2DPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Point2D::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Point2D::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Point2D::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Point2D::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Point2D::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Point2D_UnserializedMessageContext<
            UserType, Point2D::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Point2D::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Point2D::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Point2D_UnserializedMessageContext<
            UserType, Point2D::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Point2D::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double x;
  
  double y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Point2D::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Point2D::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Point2D::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Point2D::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  PhotoState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PhotoState, T>::value>;
  using DataView = PhotoStateDataView;
  using Data_ = internal::PhotoState_Data;

  template <typename... Args>
  static PhotoStatePtr New(Args&&... args) {
    return PhotoStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PhotoStatePtr From(const U& u) {
    return mojo::TypeConverter<PhotoStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PhotoState>::Convert(*this);
  }


  PhotoState();

  PhotoState(
      std::vector<MeteringMode> supported_white_balance_modes,
      MeteringMode current_white_balance_mode,
      std::vector<MeteringMode> supported_exposure_modes,
      MeteringMode current_exposure_mode,
      std::vector<MeteringMode> supported_focus_modes,
      MeteringMode current_focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      RangePtr exposure_compensation,
      RangePtr exposure_time,
      RangePtr color_temperature,
      RangePtr iso,
      RangePtr brightness,
      RangePtr contrast,
      RangePtr saturation,
      RangePtr sharpness,
      RangePtr focus_distance,
      RangePtr pan,
      RangePtr tilt,
      RangePtr zoom,
      bool supports_torch,
      bool torch,
      RedEyeReduction red_eye_reduction,
      RangePtr height,
      RangePtr width,
      std::vector<FillLightMode> fill_light_mode);

  PhotoState(
      std::vector<MeteringMode> supported_white_balance_modes,
      MeteringMode current_white_balance_mode,
      std::vector<MeteringMode> supported_exposure_modes,
      MeteringMode current_exposure_mode,
      std::vector<MeteringMode> supported_focus_modes,
      MeteringMode current_focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      RangePtr exposure_compensation,
      RangePtr exposure_time,
      RangePtr color_temperature,
      RangePtr iso,
      RangePtr brightness,
      RangePtr contrast,
      RangePtr saturation,
      RangePtr sharpness,
      RangePtr focus_distance,
      RangePtr pan,
      RangePtr tilt,
      RangePtr zoom,
      bool supports_torch,
      bool torch,
      RedEyeReduction red_eye_reduction,
      RangePtr height,
      RangePtr width,
      std::vector<FillLightMode> fill_light_mode,
      std::optional<std::vector<BackgroundBlurMode>> supported_background_blur_modes,
      BackgroundBlurMode background_blur_mode);

  PhotoState(
      std::vector<MeteringMode> supported_white_balance_modes,
      MeteringMode current_white_balance_mode,
      std::vector<MeteringMode> supported_exposure_modes,
      MeteringMode current_exposure_mode,
      std::vector<MeteringMode> supported_focus_modes,
      MeteringMode current_focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      RangePtr exposure_compensation,
      RangePtr exposure_time,
      RangePtr color_temperature,
      RangePtr iso,
      RangePtr brightness,
      RangePtr contrast,
      RangePtr saturation,
      RangePtr sharpness,
      RangePtr focus_distance,
      RangePtr pan,
      RangePtr tilt,
      RangePtr zoom,
      bool supports_torch,
      bool torch,
      RedEyeReduction red_eye_reduction,
      RangePtr height,
      RangePtr width,
      std::vector<FillLightMode> fill_light_mode,
      std::optional<std::vector<BackgroundBlurMode>> supported_background_blur_modes,
      BackgroundBlurMode background_blur_mode,
      std::optional<std::vector<MeteringMode>> supported_face_framing_modes,
      MeteringMode current_face_framing_mode);

  PhotoState(
      std::vector<MeteringMode> supported_white_balance_modes,
      MeteringMode current_white_balance_mode,
      std::vector<MeteringMode> supported_exposure_modes,
      MeteringMode current_exposure_mode,
      std::vector<MeteringMode> supported_focus_modes,
      MeteringMode current_focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      RangePtr exposure_compensation,
      RangePtr exposure_time,
      RangePtr color_temperature,
      RangePtr iso,
      RangePtr brightness,
      RangePtr contrast,
      RangePtr saturation,
      RangePtr sharpness,
      RangePtr focus_distance,
      RangePtr pan,
      RangePtr tilt,
      RangePtr zoom,
      bool supports_torch,
      bool torch,
      RedEyeReduction red_eye_reduction,
      RangePtr height,
      RangePtr width,
      std::vector<FillLightMode> fill_light_mode,
      std::optional<std::vector<BackgroundBlurMode>> supported_background_blur_modes,
      BackgroundBlurMode background_blur_mode,
      std::optional<std::vector<MeteringMode>> supported_face_framing_modes,
      MeteringMode current_face_framing_mode,
      std::optional<std::vector<EyeGazeCorrectionMode>> supported_eye_gaze_correction_modes,
      EyeGazeCorrectionMode current_eye_gaze_correction_mode);

  PhotoState(
      std::vector<MeteringMode> supported_white_balance_modes,
      MeteringMode current_white_balance_mode,
      std::vector<MeteringMode> supported_exposure_modes,
      MeteringMode current_exposure_mode,
      std::vector<MeteringMode> supported_focus_modes,
      MeteringMode current_focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      RangePtr exposure_compensation,
      RangePtr exposure_time,
      RangePtr color_temperature,
      RangePtr iso,
      RangePtr brightness,
      RangePtr contrast,
      RangePtr saturation,
      RangePtr sharpness,
      RangePtr focus_distance,
      RangePtr pan,
      RangePtr tilt,
      RangePtr zoom,
      bool supports_torch,
      bool torch,
      RedEyeReduction red_eye_reduction,
      RangePtr height,
      RangePtr width,
      std::vector<FillLightMode> fill_light_mode,
      std::optional<std::vector<BackgroundBlurMode>> supported_background_blur_modes,
      BackgroundBlurMode background_blur_mode,
      std::optional<std::vector<MeteringMode>> supported_face_framing_modes,
      MeteringMode current_face_framing_mode,
      std::optional<std::vector<EyeGazeCorrectionMode>> supported_eye_gaze_correction_modes,
      EyeGazeCorrectionMode current_eye_gaze_correction_mode,
      std::optional<std::vector<bool>> supported_background_segmentation_mask_states,
      bool current_background_segmentation_mask_state);

PhotoState(const PhotoState&) = delete;
PhotoState& operator=(const PhotoState&) = delete;

  ~PhotoState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PhotoStatePtr>
  PhotoStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PhotoState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PhotoState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PhotoState_UnserializedMessageContext<
            UserType, PhotoState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PhotoState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PhotoState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PhotoState_UnserializedMessageContext<
            UserType, PhotoState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PhotoState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<MeteringMode> supported_white_balance_modes;
  
  MeteringMode current_white_balance_mode;
  
  std::vector<MeteringMode> supported_exposure_modes;
  
  MeteringMode current_exposure_mode;
  
  std::vector<MeteringMode> supported_focus_modes;
  
  MeteringMode current_focus_mode;
  
  std::vector<Point2DPtr> points_of_interest;
  
  RangePtr exposure_compensation;
  
  RangePtr exposure_time;
  
  RangePtr color_temperature;
  
  RangePtr iso;
  
  RangePtr brightness;
  
  RangePtr contrast;
  
  RangePtr saturation;
  
  RangePtr sharpness;
  
  RangePtr focus_distance;
  
  RangePtr pan;
  
  RangePtr tilt;
  
  RangePtr zoom;
  
  bool supports_torch;
  
  bool torch;
  
  RedEyeReduction red_eye_reduction;
  
  RangePtr height;
  
  RangePtr width;
  
  std::vector<FillLightMode> fill_light_mode;
  
  std::optional<std::vector<BackgroundBlurMode>> supported_background_blur_modes;
  
  BackgroundBlurMode background_blur_mode;
  
  std::optional<std::vector<MeteringMode>> supported_face_framing_modes;
  
  MeteringMode current_face_framing_mode;
  
  std::optional<std::vector<EyeGazeCorrectionMode>> supported_eye_gaze_correction_modes;
  
  EyeGazeCorrectionMode current_eye_gaze_correction_mode;
  
  std::optional<std::vector<bool>> supported_background_segmentation_mask_states;
  
  bool current_background_segmentation_mask_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PhotoState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PhotoSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PhotoSettings, T>::value>;
  using DataView = PhotoSettingsDataView;
  using Data_ = internal::PhotoSettings_Data;

  template <typename... Args>
  static PhotoSettingsPtr New(Args&&... args) {
    return PhotoSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PhotoSettingsPtr From(const U& u) {
    return mojo::TypeConverter<PhotoSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PhotoSettings>::Convert(*this);
  }


  PhotoSettings();

  PhotoSettings(
      bool has_white_balance_mode,
      MeteringMode white_balance_mode,
      bool has_exposure_mode,
      MeteringMode exposure_mode,
      bool has_focus_mode,
      MeteringMode focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      bool has_exposure_compensation,
      double exposure_compensation,
      bool has_exposure_time,
      double exposure_time,
      bool has_color_temperature,
      double color_temperature,
      bool has_iso,
      double iso,
      bool has_brightness,
      double brightness,
      bool has_contrast,
      double contrast,
      bool has_saturation,
      double saturation,
      bool has_sharpness,
      double sharpness,
      bool has_focus_distance,
      double focus_distance,
      bool has_pan,
      double pan,
      bool has_tilt,
      double tilt,
      bool has_zoom,
      double zoom,
      bool has_torch,
      bool torch,
      bool has_fill_light_mode,
      FillLightMode fill_light_mode,
      bool has_width,
      double width,
      bool has_height,
      double height,
      bool has_red_eye_reduction,
      bool red_eye_reduction);

  PhotoSettings(
      bool has_white_balance_mode,
      MeteringMode white_balance_mode,
      bool has_exposure_mode,
      MeteringMode exposure_mode,
      bool has_focus_mode,
      MeteringMode focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      bool has_exposure_compensation,
      double exposure_compensation,
      bool has_exposure_time,
      double exposure_time,
      bool has_color_temperature,
      double color_temperature,
      bool has_iso,
      double iso,
      bool has_brightness,
      double brightness,
      bool has_contrast,
      double contrast,
      bool has_saturation,
      double saturation,
      bool has_sharpness,
      double sharpness,
      bool has_focus_distance,
      double focus_distance,
      bool has_pan,
      double pan,
      bool has_tilt,
      double tilt,
      bool has_zoom,
      double zoom,
      bool has_torch,
      bool torch,
      bool has_fill_light_mode,
      FillLightMode fill_light_mode,
      bool has_width,
      double width,
      bool has_height,
      double height,
      bool has_red_eye_reduction,
      bool red_eye_reduction,
      bool has_background_blur_mode,
      BackgroundBlurMode background_blur_mode);

  PhotoSettings(
      bool has_white_balance_mode,
      MeteringMode white_balance_mode,
      bool has_exposure_mode,
      MeteringMode exposure_mode,
      bool has_focus_mode,
      MeteringMode focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      bool has_exposure_compensation,
      double exposure_compensation,
      bool has_exposure_time,
      double exposure_time,
      bool has_color_temperature,
      double color_temperature,
      bool has_iso,
      double iso,
      bool has_brightness,
      double brightness,
      bool has_contrast,
      double contrast,
      bool has_saturation,
      double saturation,
      bool has_sharpness,
      double sharpness,
      bool has_focus_distance,
      double focus_distance,
      bool has_pan,
      double pan,
      bool has_tilt,
      double tilt,
      bool has_zoom,
      double zoom,
      bool has_torch,
      bool torch,
      bool has_fill_light_mode,
      FillLightMode fill_light_mode,
      bool has_width,
      double width,
      bool has_height,
      double height,
      bool has_red_eye_reduction,
      bool red_eye_reduction,
      bool has_background_blur_mode,
      BackgroundBlurMode background_blur_mode,
      bool has_face_framing_mode,
      MeteringMode face_framing_mode);

  PhotoSettings(
      bool has_white_balance_mode,
      MeteringMode white_balance_mode,
      bool has_exposure_mode,
      MeteringMode exposure_mode,
      bool has_focus_mode,
      MeteringMode focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      bool has_exposure_compensation,
      double exposure_compensation,
      bool has_exposure_time,
      double exposure_time,
      bool has_color_temperature,
      double color_temperature,
      bool has_iso,
      double iso,
      bool has_brightness,
      double brightness,
      bool has_contrast,
      double contrast,
      bool has_saturation,
      double saturation,
      bool has_sharpness,
      double sharpness,
      bool has_focus_distance,
      double focus_distance,
      bool has_pan,
      double pan,
      bool has_tilt,
      double tilt,
      bool has_zoom,
      double zoom,
      bool has_torch,
      bool torch,
      bool has_fill_light_mode,
      FillLightMode fill_light_mode,
      bool has_width,
      double width,
      bool has_height,
      double height,
      bool has_red_eye_reduction,
      bool red_eye_reduction,
      bool has_background_blur_mode,
      BackgroundBlurMode background_blur_mode,
      bool has_face_framing_mode,
      MeteringMode face_framing_mode,
      std::optional<EyeGazeCorrectionMode> eye_gaze_correction_mode);

  PhotoSettings(
      bool has_white_balance_mode,
      MeteringMode white_balance_mode,
      bool has_exposure_mode,
      MeteringMode exposure_mode,
      bool has_focus_mode,
      MeteringMode focus_mode,
      std::vector<Point2DPtr> points_of_interest,
      bool has_exposure_compensation,
      double exposure_compensation,
      bool has_exposure_time,
      double exposure_time,
      bool has_color_temperature,
      double color_temperature,
      bool has_iso,
      double iso,
      bool has_brightness,
      double brightness,
      bool has_contrast,
      double contrast,
      bool has_saturation,
      double saturation,
      bool has_sharpness,
      double sharpness,
      bool has_focus_distance,
      double focus_distance,
      bool has_pan,
      double pan,
      bool has_tilt,
      double tilt,
      bool has_zoom,
      double zoom,
      bool has_torch,
      bool torch,
      bool has_fill_light_mode,
      FillLightMode fill_light_mode,
      bool has_width,
      double width,
      bool has_height,
      double height,
      bool has_red_eye_reduction,
      bool red_eye_reduction,
      bool has_background_blur_mode,
      BackgroundBlurMode background_blur_mode,
      bool has_face_framing_mode,
      MeteringMode face_framing_mode,
      std::optional<EyeGazeCorrectionMode> eye_gaze_correction_mode,
      std::optional<bool> background_segmentation_mask_state);

PhotoSettings(const PhotoSettings&) = delete;
PhotoSettings& operator=(const PhotoSettings&) = delete;

  ~PhotoSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PhotoSettingsPtr>
  PhotoSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PhotoSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PhotoSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PhotoSettings_UnserializedMessageContext<
            UserType, PhotoSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PhotoSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PhotoSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PhotoSettings_UnserializedMessageContext<
            UserType, PhotoSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PhotoSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_white_balance_mode;
  
  MeteringMode white_balance_mode;
  
  bool has_exposure_mode;
  
  MeteringMode exposure_mode;
  
  bool has_focus_mode;
  
  MeteringMode focus_mode;
  
  std::vector<Point2DPtr> points_of_interest;
  
  bool has_exposure_compensation;
  
  double exposure_compensation;
  
  bool has_exposure_time;
  
  double exposure_time;
  
  bool has_color_temperature;
  
  double color_temperature;
  
  bool has_iso;
  
  double iso;
  
  bool has_brightness;
  
  double brightness;
  
  bool has_contrast;
  
  double contrast;
  
  bool has_saturation;
  
  double saturation;
  
  bool has_sharpness;
  
  double sharpness;
  
  bool has_focus_distance;
  
  double focus_distance;
  
  bool has_pan;
  
  double pan;
  
  bool has_tilt;
  
  double tilt;
  
  bool has_zoom;
  
  double zoom;
  
  bool has_torch;
  
  bool torch;
  
  bool has_fill_light_mode;
  
  FillLightMode fill_light_mode;
  
  bool has_width;
  
  double width;
  
  bool has_height;
  
  double height;
  
  bool has_red_eye_reduction;
  
  bool red_eye_reduction;
  
  bool has_background_blur_mode;
  
  BackgroundBlurMode background_blur_mode;
  
  bool has_face_framing_mode;
  
  MeteringMode face_framing_mode;
  
  std::optional<EyeGazeCorrectionMode> eye_gaze_correction_mode;
  
  std::optional<bool> background_segmentation_mask_state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PhotoSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Blob {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Blob, T>::value>;
  using DataView = BlobDataView;
  using Data_ = internal::Blob_Data;

  template <typename... Args>
  static BlobPtr New(Args&&... args) {
    return BlobPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlobPtr From(const U& u) {
    return mojo::TypeConverter<BlobPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Blob>::Convert(*this);
  }


  Blob();

  Blob(
      const std::string& mime_type,
      std::vector<uint8_t> data);


  ~Blob();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlobPtr>
  BlobPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Blob::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Blob::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Blob::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Blob::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Blob::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Blob_UnserializedMessageContext<
            UserType, Blob::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Blob::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Blob::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Blob_UnserializedMessageContext<
            UserType, Blob::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Blob::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mime_type;
  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Blob::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Blob::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Blob::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Blob::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RangePtr Range::Clone() const {
  return New(
      mojo::Clone(max),
      mojo::Clone(min),
      mojo::Clone(current),
      mojo::Clone(step)
  );
}

template <typename T, Range::EnableIfSame<T>*>
bool Range::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max, other_struct.max))
    return false;
  if (!mojo::Equals(this->min, other_struct.min))
    return false;
  if (!mojo::Equals(this->current, other_struct.current))
    return false;
  if (!mojo::Equals(this->step, other_struct.step))
    return false;
  return true;
}

template <typename T, Range::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max < rhs.max)
    return true;
  if (rhs.max < lhs.max)
    return false;
  if (lhs.min < rhs.min)
    return true;
  if (rhs.min < lhs.min)
    return false;
  if (lhs.current < rhs.current)
    return true;
  if (rhs.current < lhs.current)
    return false;
  if (lhs.step < rhs.step)
    return true;
  if (rhs.step < lhs.step)
    return false;
  return false;
}
template <typename StructPtrType>
PhotoStatePtr PhotoState::Clone() const {
  return New(
      mojo::Clone(supported_white_balance_modes),
      mojo::Clone(current_white_balance_mode),
      mojo::Clone(supported_exposure_modes),
      mojo::Clone(current_exposure_mode),
      mojo::Clone(supported_focus_modes),
      mojo::Clone(current_focus_mode),
      mojo::Clone(points_of_interest),
      mojo::Clone(exposure_compensation),
      mojo::Clone(exposure_time),
      mojo::Clone(color_temperature),
      mojo::Clone(iso),
      mojo::Clone(brightness),
      mojo::Clone(contrast),
      mojo::Clone(saturation),
      mojo::Clone(sharpness),
      mojo::Clone(focus_distance),
      mojo::Clone(pan),
      mojo::Clone(tilt),
      mojo::Clone(zoom),
      mojo::Clone(supports_torch),
      mojo::Clone(torch),
      mojo::Clone(red_eye_reduction),
      mojo::Clone(height),
      mojo::Clone(width),
      mojo::Clone(fill_light_mode),
      mojo::Clone(supported_background_blur_modes),
      mojo::Clone(background_blur_mode),
      mojo::Clone(supported_face_framing_modes),
      mojo::Clone(current_face_framing_mode),
      mojo::Clone(supported_eye_gaze_correction_modes),
      mojo::Clone(current_eye_gaze_correction_mode),
      mojo::Clone(supported_background_segmentation_mask_states),
      mojo::Clone(current_background_segmentation_mask_state)
  );
}

template <typename T, PhotoState::EnableIfSame<T>*>
bool PhotoState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_white_balance_modes, other_struct.supported_white_balance_modes))
    return false;
  if (!mojo::Equals(this->current_white_balance_mode, other_struct.current_white_balance_mode))
    return false;
  if (!mojo::Equals(this->supported_exposure_modes, other_struct.supported_exposure_modes))
    return false;
  if (!mojo::Equals(this->current_exposure_mode, other_struct.current_exposure_mode))
    return false;
  if (!mojo::Equals(this->supported_focus_modes, other_struct.supported_focus_modes))
    return false;
  if (!mojo::Equals(this->current_focus_mode, other_struct.current_focus_mode))
    return false;
  if (!mojo::Equals(this->points_of_interest, other_struct.points_of_interest))
    return false;
  if (!mojo::Equals(this->exposure_compensation, other_struct.exposure_compensation))
    return false;
  if (!mojo::Equals(this->exposure_time, other_struct.exposure_time))
    return false;
  if (!mojo::Equals(this->color_temperature, other_struct.color_temperature))
    return false;
  if (!mojo::Equals(this->iso, other_struct.iso))
    return false;
  if (!mojo::Equals(this->brightness, other_struct.brightness))
    return false;
  if (!mojo::Equals(this->contrast, other_struct.contrast))
    return false;
  if (!mojo::Equals(this->saturation, other_struct.saturation))
    return false;
  if (!mojo::Equals(this->sharpness, other_struct.sharpness))
    return false;
  if (!mojo::Equals(this->focus_distance, other_struct.focus_distance))
    return false;
  if (!mojo::Equals(this->pan, other_struct.pan))
    return false;
  if (!mojo::Equals(this->tilt, other_struct.tilt))
    return false;
  if (!mojo::Equals(this->zoom, other_struct.zoom))
    return false;
  if (!mojo::Equals(this->supports_torch, other_struct.supports_torch))
    return false;
  if (!mojo::Equals(this->torch, other_struct.torch))
    return false;
  if (!mojo::Equals(this->red_eye_reduction, other_struct.red_eye_reduction))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->fill_light_mode, other_struct.fill_light_mode))
    return false;
  if (!mojo::Equals(this->supported_background_blur_modes, other_struct.supported_background_blur_modes))
    return false;
  if (!mojo::Equals(this->background_blur_mode, other_struct.background_blur_mode))
    return false;
  if (!mojo::Equals(this->supported_face_framing_modes, other_struct.supported_face_framing_modes))
    return false;
  if (!mojo::Equals(this->current_face_framing_mode, other_struct.current_face_framing_mode))
    return false;
  if (!mojo::Equals(this->supported_eye_gaze_correction_modes, other_struct.supported_eye_gaze_correction_modes))
    return false;
  if (!mojo::Equals(this->current_eye_gaze_correction_mode, other_struct.current_eye_gaze_correction_mode))
    return false;
  if (!mojo::Equals(this->supported_background_segmentation_mask_states, other_struct.supported_background_segmentation_mask_states))
    return false;
  if (!mojo::Equals(this->current_background_segmentation_mask_state, other_struct.current_background_segmentation_mask_state))
    return false;
  return true;
}

template <typename T, PhotoState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_white_balance_modes < rhs.supported_white_balance_modes)
    return true;
  if (rhs.supported_white_balance_modes < lhs.supported_white_balance_modes)
    return false;
  if (lhs.current_white_balance_mode < rhs.current_white_balance_mode)
    return true;
  if (rhs.current_white_balance_mode < lhs.current_white_balance_mode)
    return false;
  if (lhs.supported_exposure_modes < rhs.supported_exposure_modes)
    return true;
  if (rhs.supported_exposure_modes < lhs.supported_exposure_modes)
    return false;
  if (lhs.current_exposure_mode < rhs.current_exposure_mode)
    return true;
  if (rhs.current_exposure_mode < lhs.current_exposure_mode)
    return false;
  if (lhs.supported_focus_modes < rhs.supported_focus_modes)
    return true;
  if (rhs.supported_focus_modes < lhs.supported_focus_modes)
    return false;
  if (lhs.current_focus_mode < rhs.current_focus_mode)
    return true;
  if (rhs.current_focus_mode < lhs.current_focus_mode)
    return false;
  if (lhs.points_of_interest < rhs.points_of_interest)
    return true;
  if (rhs.points_of_interest < lhs.points_of_interest)
    return false;
  if (lhs.exposure_compensation < rhs.exposure_compensation)
    return true;
  if (rhs.exposure_compensation < lhs.exposure_compensation)
    return false;
  if (lhs.exposure_time < rhs.exposure_time)
    return true;
  if (rhs.exposure_time < lhs.exposure_time)
    return false;
  if (lhs.color_temperature < rhs.color_temperature)
    return true;
  if (rhs.color_temperature < lhs.color_temperature)
    return false;
  if (lhs.iso < rhs.iso)
    return true;
  if (rhs.iso < lhs.iso)
    return false;
  if (lhs.brightness < rhs.brightness)
    return true;
  if (rhs.brightness < lhs.brightness)
    return false;
  if (lhs.contrast < rhs.contrast)
    return true;
  if (rhs.contrast < lhs.contrast)
    return false;
  if (lhs.saturation < rhs.saturation)
    return true;
  if (rhs.saturation < lhs.saturation)
    return false;
  if (lhs.sharpness < rhs.sharpness)
    return true;
  if (rhs.sharpness < lhs.sharpness)
    return false;
  if (lhs.focus_distance < rhs.focus_distance)
    return true;
  if (rhs.focus_distance < lhs.focus_distance)
    return false;
  if (lhs.pan < rhs.pan)
    return true;
  if (rhs.pan < lhs.pan)
    return false;
  if (lhs.tilt < rhs.tilt)
    return true;
  if (rhs.tilt < lhs.tilt)
    return false;
  if (lhs.zoom < rhs.zoom)
    return true;
  if (rhs.zoom < lhs.zoom)
    return false;
  if (lhs.supports_torch < rhs.supports_torch)
    return true;
  if (rhs.supports_torch < lhs.supports_torch)
    return false;
  if (lhs.torch < rhs.torch)
    return true;
  if (rhs.torch < lhs.torch)
    return false;
  if (lhs.red_eye_reduction < rhs.red_eye_reduction)
    return true;
  if (rhs.red_eye_reduction < lhs.red_eye_reduction)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.fill_light_mode < rhs.fill_light_mode)
    return true;
  if (rhs.fill_light_mode < lhs.fill_light_mode)
    return false;
  if (lhs.supported_background_blur_modes < rhs.supported_background_blur_modes)
    return true;
  if (rhs.supported_background_blur_modes < lhs.supported_background_blur_modes)
    return false;
  if (lhs.background_blur_mode < rhs.background_blur_mode)
    return true;
  if (rhs.background_blur_mode < lhs.background_blur_mode)
    return false;
  if (lhs.supported_face_framing_modes < rhs.supported_face_framing_modes)
    return true;
  if (rhs.supported_face_framing_modes < lhs.supported_face_framing_modes)
    return false;
  if (lhs.current_face_framing_mode < rhs.current_face_framing_mode)
    return true;
  if (rhs.current_face_framing_mode < lhs.current_face_framing_mode)
    return false;
  if (lhs.supported_eye_gaze_correction_modes < rhs.supported_eye_gaze_correction_modes)
    return true;
  if (rhs.supported_eye_gaze_correction_modes < lhs.supported_eye_gaze_correction_modes)
    return false;
  if (lhs.current_eye_gaze_correction_mode < rhs.current_eye_gaze_correction_mode)
    return true;
  if (rhs.current_eye_gaze_correction_mode < lhs.current_eye_gaze_correction_mode)
    return false;
  if (lhs.supported_background_segmentation_mask_states < rhs.supported_background_segmentation_mask_states)
    return true;
  if (rhs.supported_background_segmentation_mask_states < lhs.supported_background_segmentation_mask_states)
    return false;
  if (lhs.current_background_segmentation_mask_state < rhs.current_background_segmentation_mask_state)
    return true;
  if (rhs.current_background_segmentation_mask_state < lhs.current_background_segmentation_mask_state)
    return false;
  return false;
}
template <typename StructPtrType>
Point2DPtr Point2D::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, Point2D::EnableIfSame<T>*>
bool Point2D::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, Point2D::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
PhotoSettingsPtr PhotoSettings::Clone() const {
  return New(
      mojo::Clone(has_white_balance_mode),
      mojo::Clone(white_balance_mode),
      mojo::Clone(has_exposure_mode),
      mojo::Clone(exposure_mode),
      mojo::Clone(has_focus_mode),
      mojo::Clone(focus_mode),
      mojo::Clone(points_of_interest),
      mojo::Clone(has_exposure_compensation),
      mojo::Clone(exposure_compensation),
      mojo::Clone(has_exposure_time),
      mojo::Clone(exposure_time),
      mojo::Clone(has_color_temperature),
      mojo::Clone(color_temperature),
      mojo::Clone(has_iso),
      mojo::Clone(iso),
      mojo::Clone(has_brightness),
      mojo::Clone(brightness),
      mojo::Clone(has_contrast),
      mojo::Clone(contrast),
      mojo::Clone(has_saturation),
      mojo::Clone(saturation),
      mojo::Clone(has_sharpness),
      mojo::Clone(sharpness),
      mojo::Clone(has_focus_distance),
      mojo::Clone(focus_distance),
      mojo::Clone(has_pan),
      mojo::Clone(pan),
      mojo::Clone(has_tilt),
      mojo::Clone(tilt),
      mojo::Clone(has_zoom),
      mojo::Clone(zoom),
      mojo::Clone(has_torch),
      mojo::Clone(torch),
      mojo::Clone(has_fill_light_mode),
      mojo::Clone(fill_light_mode),
      mojo::Clone(has_width),
      mojo::Clone(width),
      mojo::Clone(has_height),
      mojo::Clone(height),
      mojo::Clone(has_red_eye_reduction),
      mojo::Clone(red_eye_reduction),
      mojo::Clone(has_background_blur_mode),
      mojo::Clone(background_blur_mode),
      mojo::Clone(has_face_framing_mode),
      mojo::Clone(face_framing_mode),
      mojo::Clone(eye_gaze_correction_mode),
      mojo::Clone(background_segmentation_mask_state)
  );
}

template <typename T, PhotoSettings::EnableIfSame<T>*>
bool PhotoSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_white_balance_mode, other_struct.has_white_balance_mode))
    return false;
  if (!mojo::Equals(this->white_balance_mode, other_struct.white_balance_mode))
    return false;
  if (!mojo::Equals(this->has_exposure_mode, other_struct.has_exposure_mode))
    return false;
  if (!mojo::Equals(this->exposure_mode, other_struct.exposure_mode))
    return false;
  if (!mojo::Equals(this->has_focus_mode, other_struct.has_focus_mode))
    return false;
  if (!mojo::Equals(this->focus_mode, other_struct.focus_mode))
    return false;
  if (!mojo::Equals(this->points_of_interest, other_struct.points_of_interest))
    return false;
  if (!mojo::Equals(this->has_exposure_compensation, other_struct.has_exposure_compensation))
    return false;
  if (!mojo::Equals(this->exposure_compensation, other_struct.exposure_compensation))
    return false;
  if (!mojo::Equals(this->has_exposure_time, other_struct.has_exposure_time))
    return false;
  if (!mojo::Equals(this->exposure_time, other_struct.exposure_time))
    return false;
  if (!mojo::Equals(this->has_color_temperature, other_struct.has_color_temperature))
    return false;
  if (!mojo::Equals(this->color_temperature, other_struct.color_temperature))
    return false;
  if (!mojo::Equals(this->has_iso, other_struct.has_iso))
    return false;
  if (!mojo::Equals(this->iso, other_struct.iso))
    return false;
  if (!mojo::Equals(this->has_brightness, other_struct.has_brightness))
    return false;
  if (!mojo::Equals(this->brightness, other_struct.brightness))
    return false;
  if (!mojo::Equals(this->has_contrast, other_struct.has_contrast))
    return false;
  if (!mojo::Equals(this->contrast, other_struct.contrast))
    return false;
  if (!mojo::Equals(this->has_saturation, other_struct.has_saturation))
    return false;
  if (!mojo::Equals(this->saturation, other_struct.saturation))
    return false;
  if (!mojo::Equals(this->has_sharpness, other_struct.has_sharpness))
    return false;
  if (!mojo::Equals(this->sharpness, other_struct.sharpness))
    return false;
  if (!mojo::Equals(this->has_focus_distance, other_struct.has_focus_distance))
    return false;
  if (!mojo::Equals(this->focus_distance, other_struct.focus_distance))
    return false;
  if (!mojo::Equals(this->has_pan, other_struct.has_pan))
    return false;
  if (!mojo::Equals(this->pan, other_struct.pan))
    return false;
  if (!mojo::Equals(this->has_tilt, other_struct.has_tilt))
    return false;
  if (!mojo::Equals(this->tilt, other_struct.tilt))
    return false;
  if (!mojo::Equals(this->has_zoom, other_struct.has_zoom))
    return false;
  if (!mojo::Equals(this->zoom, other_struct.zoom))
    return false;
  if (!mojo::Equals(this->has_torch, other_struct.has_torch))
    return false;
  if (!mojo::Equals(this->torch, other_struct.torch))
    return false;
  if (!mojo::Equals(this->has_fill_light_mode, other_struct.has_fill_light_mode))
    return false;
  if (!mojo::Equals(this->fill_light_mode, other_struct.fill_light_mode))
    return false;
  if (!mojo::Equals(this->has_width, other_struct.has_width))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->has_height, other_struct.has_height))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->has_red_eye_reduction, other_struct.has_red_eye_reduction))
    return false;
  if (!mojo::Equals(this->red_eye_reduction, other_struct.red_eye_reduction))
    return false;
  if (!mojo::Equals(this->has_background_blur_mode, other_struct.has_background_blur_mode))
    return false;
  if (!mojo::Equals(this->background_blur_mode, other_struct.background_blur_mode))
    return false;
  if (!mojo::Equals(this->has_face_framing_mode, other_struct.has_face_framing_mode))
    return false;
  if (!mojo::Equals(this->face_framing_mode, other_struct.face_framing_mode))
    return false;
  if (!mojo::Equals(this->eye_gaze_correction_mode, other_struct.eye_gaze_correction_mode))
    return false;
  if (!mojo::Equals(this->background_segmentation_mask_state, other_struct.background_segmentation_mask_state))
    return false;
  return true;
}

template <typename T, PhotoSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_white_balance_mode < rhs.has_white_balance_mode)
    return true;
  if (rhs.has_white_balance_mode < lhs.has_white_balance_mode)
    return false;
  if (lhs.white_balance_mode < rhs.white_balance_mode)
    return true;
  if (rhs.white_balance_mode < lhs.white_balance_mode)
    return false;
  if (lhs.has_exposure_mode < rhs.has_exposure_mode)
    return true;
  if (rhs.has_exposure_mode < lhs.has_exposure_mode)
    return false;
  if (lhs.exposure_mode < rhs.exposure_mode)
    return true;
  if (rhs.exposure_mode < lhs.exposure_mode)
    return false;
  if (lhs.has_focus_mode < rhs.has_focus_mode)
    return true;
  if (rhs.has_focus_mode < lhs.has_focus_mode)
    return false;
  if (lhs.focus_mode < rhs.focus_mode)
    return true;
  if (rhs.focus_mode < lhs.focus_mode)
    return false;
  if (lhs.points_of_interest < rhs.points_of_interest)
    return true;
  if (rhs.points_of_interest < lhs.points_of_interest)
    return false;
  if (lhs.has_exposure_compensation < rhs.has_exposure_compensation)
    return true;
  if (rhs.has_exposure_compensation < lhs.has_exposure_compensation)
    return false;
  if (lhs.exposure_compensation < rhs.exposure_compensation)
    return true;
  if (rhs.exposure_compensation < lhs.exposure_compensation)
    return false;
  if (lhs.has_exposure_time < rhs.has_exposure_time)
    return true;
  if (rhs.has_exposure_time < lhs.has_exposure_time)
    return false;
  if (lhs.exposure_time < rhs.exposure_time)
    return true;
  if (rhs.exposure_time < lhs.exposure_time)
    return false;
  if (lhs.has_color_temperature < rhs.has_color_temperature)
    return true;
  if (rhs.has_color_temperature < lhs.has_color_temperature)
    return false;
  if (lhs.color_temperature < rhs.color_temperature)
    return true;
  if (rhs.color_temperature < lhs.color_temperature)
    return false;
  if (lhs.has_iso < rhs.has_iso)
    return true;
  if (rhs.has_iso < lhs.has_iso)
    return false;
  if (lhs.iso < rhs.iso)
    return true;
  if (rhs.iso < lhs.iso)
    return false;
  if (lhs.has_brightness < rhs.has_brightness)
    return true;
  if (rhs.has_brightness < lhs.has_brightness)
    return false;
  if (lhs.brightness < rhs.brightness)
    return true;
  if (rhs.brightness < lhs.brightness)
    return false;
  if (lhs.has_contrast < rhs.has_contrast)
    return true;
  if (rhs.has_contrast < lhs.has_contrast)
    return false;
  if (lhs.contrast < rhs.contrast)
    return true;
  if (rhs.contrast < lhs.contrast)
    return false;
  if (lhs.has_saturation < rhs.has_saturation)
    return true;
  if (rhs.has_saturation < lhs.has_saturation)
    return false;
  if (lhs.saturation < rhs.saturation)
    return true;
  if (rhs.saturation < lhs.saturation)
    return false;
  if (lhs.has_sharpness < rhs.has_sharpness)
    return true;
  if (rhs.has_sharpness < lhs.has_sharpness)
    return false;
  if (lhs.sharpness < rhs.sharpness)
    return true;
  if (rhs.sharpness < lhs.sharpness)
    return false;
  if (lhs.has_focus_distance < rhs.has_focus_distance)
    return true;
  if (rhs.has_focus_distance < lhs.has_focus_distance)
    return false;
  if (lhs.focus_distance < rhs.focus_distance)
    return true;
  if (rhs.focus_distance < lhs.focus_distance)
    return false;
  if (lhs.has_pan < rhs.has_pan)
    return true;
  if (rhs.has_pan < lhs.has_pan)
    return false;
  if (lhs.pan < rhs.pan)
    return true;
  if (rhs.pan < lhs.pan)
    return false;
  if (lhs.has_tilt < rhs.has_tilt)
    return true;
  if (rhs.has_tilt < lhs.has_tilt)
    return false;
  if (lhs.tilt < rhs.tilt)
    return true;
  if (rhs.tilt < lhs.tilt)
    return false;
  if (lhs.has_zoom < rhs.has_zoom)
    return true;
  if (rhs.has_zoom < lhs.has_zoom)
    return false;
  if (lhs.zoom < rhs.zoom)
    return true;
  if (rhs.zoom < lhs.zoom)
    return false;
  if (lhs.has_torch < rhs.has_torch)
    return true;
  if (rhs.has_torch < lhs.has_torch)
    return false;
  if (lhs.torch < rhs.torch)
    return true;
  if (rhs.torch < lhs.torch)
    return false;
  if (lhs.has_fill_light_mode < rhs.has_fill_light_mode)
    return true;
  if (rhs.has_fill_light_mode < lhs.has_fill_light_mode)
    return false;
  if (lhs.fill_light_mode < rhs.fill_light_mode)
    return true;
  if (rhs.fill_light_mode < lhs.fill_light_mode)
    return false;
  if (lhs.has_width < rhs.has_width)
    return true;
  if (rhs.has_width < lhs.has_width)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.has_height < rhs.has_height)
    return true;
  if (rhs.has_height < lhs.has_height)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.has_red_eye_reduction < rhs.has_red_eye_reduction)
    return true;
  if (rhs.has_red_eye_reduction < lhs.has_red_eye_reduction)
    return false;
  if (lhs.red_eye_reduction < rhs.red_eye_reduction)
    return true;
  if (rhs.red_eye_reduction < lhs.red_eye_reduction)
    return false;
  if (lhs.has_background_blur_mode < rhs.has_background_blur_mode)
    return true;
  if (rhs.has_background_blur_mode < lhs.has_background_blur_mode)
    return false;
  if (lhs.background_blur_mode < rhs.background_blur_mode)
    return true;
  if (rhs.background_blur_mode < lhs.background_blur_mode)
    return false;
  if (lhs.has_face_framing_mode < rhs.has_face_framing_mode)
    return true;
  if (rhs.has_face_framing_mode < lhs.has_face_framing_mode)
    return false;
  if (lhs.face_framing_mode < rhs.face_framing_mode)
    return true;
  if (rhs.face_framing_mode < lhs.face_framing_mode)
    return false;
  if (lhs.eye_gaze_correction_mode < rhs.eye_gaze_correction_mode)
    return true;
  if (rhs.eye_gaze_correction_mode < lhs.eye_gaze_correction_mode)
    return false;
  if (lhs.background_segmentation_mask_state < rhs.background_segmentation_mask_state)
    return true;
  if (rhs.background_segmentation_mask_state < lhs.background_segmentation_mask_state)
    return false;
  return false;
}
template <typename StructPtrType>
BlobPtr Blob::Clone() const {
  return New(
      mojo::Clone(mime_type),
      mojo::Clone(data)
  );
}

template <typename T, Blob::EnableIfSame<T>*>
bool Blob::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, Blob::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::Range::DataView,
                                         ::media::mojom::RangePtr> {
  static bool IsNull(const ::media::mojom::RangePtr& input) { return !input; }
  static void SetToNull(::media::mojom::RangePtr* output) { output->reset(); }

  static decltype(::media::mojom::Range::max) max(
      const ::media::mojom::RangePtr& input) {
    return input->max;
  }

  static decltype(::media::mojom::Range::min) min(
      const ::media::mojom::RangePtr& input) {
    return input->min;
  }

  static decltype(::media::mojom::Range::current) current(
      const ::media::mojom::RangePtr& input) {
    return input->current;
  }

  static decltype(::media::mojom::Range::step) step(
      const ::media::mojom::RangePtr& input) {
    return input->step;
  }

  static bool Read(::media::mojom::Range::DataView input, ::media::mojom::RangePtr* output);
};


template <>
struct  StructTraits<::media::mojom::PhotoState::DataView,
                                         ::media::mojom::PhotoStatePtr> {
  static bool IsNull(const ::media::mojom::PhotoStatePtr& input) { return !input; }
  static void SetToNull(::media::mojom::PhotoStatePtr* output) { output->reset(); }

  static const decltype(::media::mojom::PhotoState::supported_white_balance_modes)& supported_white_balance_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_white_balance_modes;
  }

  static decltype(::media::mojom::PhotoState::current_white_balance_mode) current_white_balance_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_white_balance_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_exposure_modes)& supported_exposure_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_exposure_modes;
  }

  static decltype(::media::mojom::PhotoState::current_exposure_mode) current_exposure_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_exposure_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_focus_modes)& supported_focus_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_focus_modes;
  }

  static decltype(::media::mojom::PhotoState::current_focus_mode) current_focus_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_focus_mode;
  }

  static const decltype(::media::mojom::PhotoState::points_of_interest)& points_of_interest(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->points_of_interest;
  }

  static const decltype(::media::mojom::PhotoState::exposure_compensation)& exposure_compensation(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->exposure_compensation;
  }

  static const decltype(::media::mojom::PhotoState::exposure_time)& exposure_time(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->exposure_time;
  }

  static const decltype(::media::mojom::PhotoState::color_temperature)& color_temperature(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->color_temperature;
  }

  static const decltype(::media::mojom::PhotoState::iso)& iso(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->iso;
  }

  static const decltype(::media::mojom::PhotoState::brightness)& brightness(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->brightness;
  }

  static const decltype(::media::mojom::PhotoState::contrast)& contrast(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->contrast;
  }

  static const decltype(::media::mojom::PhotoState::saturation)& saturation(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->saturation;
  }

  static const decltype(::media::mojom::PhotoState::sharpness)& sharpness(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->sharpness;
  }

  static const decltype(::media::mojom::PhotoState::focus_distance)& focus_distance(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->focus_distance;
  }

  static const decltype(::media::mojom::PhotoState::pan)& pan(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->pan;
  }

  static const decltype(::media::mojom::PhotoState::tilt)& tilt(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->tilt;
  }

  static const decltype(::media::mojom::PhotoState::zoom)& zoom(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->zoom;
  }

  static decltype(::media::mojom::PhotoState::supports_torch) supports_torch(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supports_torch;
  }

  static decltype(::media::mojom::PhotoState::torch) torch(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->torch;
  }

  static decltype(::media::mojom::PhotoState::red_eye_reduction) red_eye_reduction(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->red_eye_reduction;
  }

  static const decltype(::media::mojom::PhotoState::height)& height(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->height;
  }

  static const decltype(::media::mojom::PhotoState::width)& width(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->width;
  }

  static const decltype(::media::mojom::PhotoState::fill_light_mode)& fill_light_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->fill_light_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_background_blur_modes)& supported_background_blur_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_background_blur_modes;
  }

  static decltype(::media::mojom::PhotoState::background_blur_mode) background_blur_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->background_blur_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_face_framing_modes)& supported_face_framing_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_face_framing_modes;
  }

  static decltype(::media::mojom::PhotoState::current_face_framing_mode) current_face_framing_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_face_framing_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_eye_gaze_correction_modes)& supported_eye_gaze_correction_modes(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_eye_gaze_correction_modes;
  }

  static decltype(::media::mojom::PhotoState::current_eye_gaze_correction_mode) current_eye_gaze_correction_mode(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_eye_gaze_correction_mode;
  }

  static const decltype(::media::mojom::PhotoState::supported_background_segmentation_mask_states)& supported_background_segmentation_mask_states(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->supported_background_segmentation_mask_states;
  }

  static decltype(::media::mojom::PhotoState::current_background_segmentation_mask_state) current_background_segmentation_mask_state(
      const ::media::mojom::PhotoStatePtr& input) {
    return input->current_background_segmentation_mask_state;
  }

  static bool Read(::media::mojom::PhotoState::DataView input, ::media::mojom::PhotoStatePtr* output);
};


template <>
struct  StructTraits<::media::mojom::Point2D::DataView,
                                         ::media::mojom::Point2DPtr> {
  static bool IsNull(const ::media::mojom::Point2DPtr& input) { return !input; }
  static void SetToNull(::media::mojom::Point2DPtr* output) { output->reset(); }

  static decltype(::media::mojom::Point2D::x) x(
      const ::media::mojom::Point2DPtr& input) {
    return input->x;
  }

  static decltype(::media::mojom::Point2D::y) y(
      const ::media::mojom::Point2DPtr& input) {
    return input->y;
  }

  static bool Read(::media::mojom::Point2D::DataView input, ::media::mojom::Point2DPtr* output);
};


template <>
struct  StructTraits<::media::mojom::PhotoSettings::DataView,
                                         ::media::mojom::PhotoSettingsPtr> {
  static bool IsNull(const ::media::mojom::PhotoSettingsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::PhotoSettingsPtr* output) { output->reset(); }

  static decltype(::media::mojom::PhotoSettings::has_white_balance_mode) has_white_balance_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_white_balance_mode;
  }

  static decltype(::media::mojom::PhotoSettings::white_balance_mode) white_balance_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->white_balance_mode;
  }

  static decltype(::media::mojom::PhotoSettings::has_exposure_mode) has_exposure_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_exposure_mode;
  }

  static decltype(::media::mojom::PhotoSettings::exposure_mode) exposure_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->exposure_mode;
  }

  static decltype(::media::mojom::PhotoSettings::has_focus_mode) has_focus_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_focus_mode;
  }

  static decltype(::media::mojom::PhotoSettings::focus_mode) focus_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->focus_mode;
  }

  static const decltype(::media::mojom::PhotoSettings::points_of_interest)& points_of_interest(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->points_of_interest;
  }

  static decltype(::media::mojom::PhotoSettings::has_exposure_compensation) has_exposure_compensation(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_exposure_compensation;
  }

  static decltype(::media::mojom::PhotoSettings::exposure_compensation) exposure_compensation(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->exposure_compensation;
  }

  static decltype(::media::mojom::PhotoSettings::has_exposure_time) has_exposure_time(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_exposure_time;
  }

  static decltype(::media::mojom::PhotoSettings::exposure_time) exposure_time(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->exposure_time;
  }

  static decltype(::media::mojom::PhotoSettings::has_color_temperature) has_color_temperature(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_color_temperature;
  }

  static decltype(::media::mojom::PhotoSettings::color_temperature) color_temperature(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->color_temperature;
  }

  static decltype(::media::mojom::PhotoSettings::has_iso) has_iso(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_iso;
  }

  static decltype(::media::mojom::PhotoSettings::iso) iso(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->iso;
  }

  static decltype(::media::mojom::PhotoSettings::has_brightness) has_brightness(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_brightness;
  }

  static decltype(::media::mojom::PhotoSettings::brightness) brightness(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->brightness;
  }

  static decltype(::media::mojom::PhotoSettings::has_contrast) has_contrast(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_contrast;
  }

  static decltype(::media::mojom::PhotoSettings::contrast) contrast(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->contrast;
  }

  static decltype(::media::mojom::PhotoSettings::has_saturation) has_saturation(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_saturation;
  }

  static decltype(::media::mojom::PhotoSettings::saturation) saturation(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->saturation;
  }

  static decltype(::media::mojom::PhotoSettings::has_sharpness) has_sharpness(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_sharpness;
  }

  static decltype(::media::mojom::PhotoSettings::sharpness) sharpness(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->sharpness;
  }

  static decltype(::media::mojom::PhotoSettings::has_focus_distance) has_focus_distance(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_focus_distance;
  }

  static decltype(::media::mojom::PhotoSettings::focus_distance) focus_distance(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->focus_distance;
  }

  static decltype(::media::mojom::PhotoSettings::has_pan) has_pan(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_pan;
  }

  static decltype(::media::mojom::PhotoSettings::pan) pan(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->pan;
  }

  static decltype(::media::mojom::PhotoSettings::has_tilt) has_tilt(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_tilt;
  }

  static decltype(::media::mojom::PhotoSettings::tilt) tilt(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->tilt;
  }

  static decltype(::media::mojom::PhotoSettings::has_zoom) has_zoom(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_zoom;
  }

  static decltype(::media::mojom::PhotoSettings::zoom) zoom(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->zoom;
  }

  static decltype(::media::mojom::PhotoSettings::has_torch) has_torch(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_torch;
  }

  static decltype(::media::mojom::PhotoSettings::torch) torch(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->torch;
  }

  static decltype(::media::mojom::PhotoSettings::has_fill_light_mode) has_fill_light_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_fill_light_mode;
  }

  static decltype(::media::mojom::PhotoSettings::fill_light_mode) fill_light_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->fill_light_mode;
  }

  static decltype(::media::mojom::PhotoSettings::has_width) has_width(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_width;
  }

  static decltype(::media::mojom::PhotoSettings::width) width(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->width;
  }

  static decltype(::media::mojom::PhotoSettings::has_height) has_height(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_height;
  }

  static decltype(::media::mojom::PhotoSettings::height) height(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->height;
  }

  static decltype(::media::mojom::PhotoSettings::has_red_eye_reduction) has_red_eye_reduction(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_red_eye_reduction;
  }

  static decltype(::media::mojom::PhotoSettings::red_eye_reduction) red_eye_reduction(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->red_eye_reduction;
  }

  static decltype(::media::mojom::PhotoSettings::has_background_blur_mode) has_background_blur_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_background_blur_mode;
  }

  static decltype(::media::mojom::PhotoSettings::background_blur_mode) background_blur_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->background_blur_mode;
  }

  static decltype(::media::mojom::PhotoSettings::has_face_framing_mode) has_face_framing_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->has_face_framing_mode;
  }

  static decltype(::media::mojom::PhotoSettings::face_framing_mode) face_framing_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->face_framing_mode;
  }

  static decltype(::media::mojom::PhotoSettings::eye_gaze_correction_mode) eye_gaze_correction_mode(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->eye_gaze_correction_mode;
  }

  static decltype(::media::mojom::PhotoSettings::background_segmentation_mask_state) background_segmentation_mask_state(
      const ::media::mojom::PhotoSettingsPtr& input) {
    return input->background_segmentation_mask_state;
  }

  static bool Read(::media::mojom::PhotoSettings::DataView input, ::media::mojom::PhotoSettingsPtr* output);
};


template <>
struct  StructTraits<::media::mojom::Blob::DataView,
                                         ::media::mojom::BlobPtr> {
  static bool IsNull(const ::media::mojom::BlobPtr& input) { return !input; }
  static void SetToNull(::media::mojom::BlobPtr* output) { output->reset(); }

  static const decltype(::media::mojom::Blob::mime_type)& mime_type(
      const ::media::mojom::BlobPtr& input) {
    return input->mime_type;
  }

  static const decltype(::media::mojom::Blob::data)& data(
      const ::media::mojom::BlobPtr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::Blob::DataView input, ::media::mojom::BlobPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_H_