// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_
#define FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_

#include "flatbuffers/flatbuffers.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 24 &&
              FLATBUFFERS_VERSION_MINOR == 3 &&
              FLATBUFFERS_VERSION_REVISION == 25,
             "Non-compatible flatbuffers version included");

#include "components/url_pattern_index/flat/url_pattern_index_generated.h"

namespace extensions {
namespace declarative_net_request {
namespace flat {

struct QueryKeyValue;
struct QueryKeyValueBuilder;

struct UrlTransform;
struct UrlTransformBuilder;

struct UrlRuleMetadata;
struct UrlRuleMetadataBuilder;

struct EmbedderConditions;
struct EmbedderConditionsBuilder;

struct RegexFilterOptions;
struct RegexFilterOptionsBuilder;

struct ModifyHeaderInfo;
struct ModifyHeaderInfoBuilder;

struct HeaderCondition;
struct HeaderConditionBuilder;

struct RegexRule;
struct RegexRuleBuilder;

struct ExtensionIndexedRuleset;
struct ExtensionIndexedRulesetBuilder;

/// The type of an action. Corresponds to
/// extensions::api::declarative_net_request::RuleActionType.
enum ActionType : uint8_t {
  ActionType_block = 0,
  ActionType_allow = 1,
  ActionType_redirect = 2,
  ActionType_upgrade_scheme = 3,
  ActionType_modify_headers = 4,
  ActionType_allow_all_requests = 5,
  /// Number of actions. Must be the last entry.
  ActionType_count = 6,
  ActionType_MIN = ActionType_block,
  ActionType_MAX = ActionType_count
};

inline const ActionType (&EnumValuesActionType())[7] {
  static const ActionType values[] = {
    ActionType_block,
    ActionType_allow,
    ActionType_redirect,
    ActionType_upgrade_scheme,
    ActionType_modify_headers,
    ActionType_allow_all_requests,
    ActionType_count
  };
  return values;
}

inline const char * const *EnumNamesActionType() {
  static const char * const names[8] = {
    "block",
    "allow",
    "redirect",
    "upgrade_scheme",
    "modify_headers",
    "allow_all_requests",
    "count",
    nullptr
  };
  return names;
}

inline const char *EnumNameActionType(ActionType e) {
  if (::flatbuffers::IsOutRange(e, ActionType_block, ActionType_count)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesActionType()[index];
}

/// This provides a mapping from an index type to its index within
/// the |index_list| vector.
enum IndexType : uint8_t {
  /// Index for rules that are evaluated during the onBeforeRequest stage of a
  /// request, excluding allowAllRequests rules.
  IndexType_before_request_except_allow_all_requests = 0,
  /// Index for allowAllRequests rule. We have a separate index for these rules
  /// since they need to be evaluated separately when a navigation commits.
  IndexType_allow_all_requests = 1,
  IndexType_modify_headers = 2,
  /// Number of indices. Must be the last entry.
  IndexType_count = 3,
  IndexType_MIN = IndexType_before_request_except_allow_all_requests,
  IndexType_MAX = IndexType_count
};

inline const IndexType (&EnumValuesIndexType())[4] {
  static const IndexType values[] = {
    IndexType_before_request_except_allow_all_requests,
    IndexType_allow_all_requests,
    IndexType_modify_headers,
    IndexType_count
  };
  return values;
}

inline const char * const *EnumNamesIndexType() {
  static const char * const names[5] = {
    "before_request_except_allow_all_requests",
    "allow_all_requests",
    "modify_headers",
    "count",
    nullptr
  };
  return names;
}

inline const char *EnumNameIndexType(IndexType e) {
  if (::flatbuffers::IsOutRange(e, IndexType_before_request_except_allow_all_requests, IndexType_count)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesIndexType()[index];
}

/// The type of header operation for modifyHeaders rules. Corresponds to
/// extensions::api::declarative_net_request::HeaderOperation.
enum HeaderOperation : uint8_t {
  HeaderOperation_append = 0,
  HeaderOperation_set = 1,
  HeaderOperation_remove = 2,
  HeaderOperation_MIN = HeaderOperation_append,
  HeaderOperation_MAX = HeaderOperation_remove
};

inline const HeaderOperation (&EnumValuesHeaderOperation())[3] {
  static const HeaderOperation values[] = {
    HeaderOperation_append,
    HeaderOperation_set,
    HeaderOperation_remove
  };
  return values;
}

inline const char * const *EnumNamesHeaderOperation() {
  static const char * const names[4] = {
    "append",
    "set",
    "remove",
    nullptr
  };
  return names;
}

inline const char *EnumNameHeaderOperation(HeaderOperation e) {
  if (::flatbuffers::IsOutRange(e, HeaderOperation_append, HeaderOperation_remove)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesHeaderOperation()[index];
}

struct QueryKeyValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef QueryKeyValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6,
    VT_REPLACE_ONLY = 8
  };
  const ::flatbuffers::String *key() const {
    return GetPointer<const ::flatbuffers::String *>(VT_KEY);
  }
  const ::flatbuffers::String *value() const {
    return GetPointer<const ::flatbuffers::String *>(VT_VALUE);
  }
  bool replace_only() const {
    return GetField<uint8_t>(VT_REPLACE_ONLY, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffsetRequired(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffsetRequired(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           VerifyField<uint8_t>(verifier, VT_REPLACE_ONLY, 1) &&
           verifier.EndTable();
  }
};

struct QueryKeyValueBuilder {
  typedef QueryKeyValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_key(::flatbuffers::Offset<::flatbuffers::String> key) {
    fbb_.AddOffset(QueryKeyValue::VT_KEY, key);
  }
  void add_value(::flatbuffers::Offset<::flatbuffers::String> value) {
    fbb_.AddOffset(QueryKeyValue::VT_VALUE, value);
  }
  void add_replace_only(bool replace_only) {
    fbb_.AddElement<uint8_t>(QueryKeyValue::VT_REPLACE_ONLY, static_cast<uint8_t>(replace_only), 0);
  }
  explicit QueryKeyValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<QueryKeyValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<QueryKeyValue>(end);
    fbb_.Required(o, QueryKeyValue::VT_KEY);
    fbb_.Required(o, QueryKeyValue::VT_VALUE);
    return o;
  }
};

inline ::flatbuffers::Offset<QueryKeyValue> CreateQueryKeyValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> key = 0,
    ::flatbuffers::Offset<::flatbuffers::String> value = 0,
    bool replace_only = false) {
  QueryKeyValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  builder_.add_replace_only(replace_only);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<QueryKeyValue> CreateQueryKeyValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    const char *value = nullptr,
    bool replace_only = false) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return extensions::declarative_net_request::flat::CreateQueryKeyValue(
      _fbb,
      key__,
      value__,
      replace_only);
}

struct UrlTransform FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef UrlTransformBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_SCHEME = 4,
    VT_HOST = 6,
    VT_CLEAR_PORT = 8,
    VT_PORT = 10,
    VT_CLEAR_PATH = 12,
    VT_PATH = 14,
    VT_CLEAR_QUERY = 16,
    VT_QUERY = 18,
    VT_REMOVE_QUERY_PARAMS = 20,
    VT_ADD_OR_REPLACE_QUERY_PARAMS = 22,
    VT_CLEAR_FRAGMENT = 24,
    VT_FRAGMENT = 26,
    VT_USERNAME = 28,
    VT_PASSWORD = 30
  };
  const ::flatbuffers::String *scheme() const {
    return GetPointer<const ::flatbuffers::String *>(VT_SCHEME);
  }
  const ::flatbuffers::String *host() const {
    return GetPointer<const ::flatbuffers::String *>(VT_HOST);
  }
  bool clear_port() const {
    return GetField<uint8_t>(VT_CLEAR_PORT, 0) != 0;
  }
  const ::flatbuffers::String *port() const {
    return GetPointer<const ::flatbuffers::String *>(VT_PORT);
  }
  bool clear_path() const {
    return GetField<uint8_t>(VT_CLEAR_PATH, 0) != 0;
  }
  const ::flatbuffers::String *path() const {
    return GetPointer<const ::flatbuffers::String *>(VT_PATH);
  }
  bool clear_query() const {
    return GetField<uint8_t>(VT_CLEAR_QUERY, 0) != 0;
  }
  /// If valid, doesn't include the '?' separator.
  const ::flatbuffers::String *query() const {
    return GetPointer<const ::flatbuffers::String *>(VT_QUERY);
  }
  /// Query params to be removed. These are already sorted and escaped using
  /// base::EscapeQueryParamValue.
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *remove_query_params() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_REMOVE_QUERY_PARAMS);
  }
  /// Query params to be added/replaced. These are already escaped using
  /// base::EscapeQueryParamValue.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *add_or_replace_query_params() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *>(VT_ADD_OR_REPLACE_QUERY_PARAMS);
  }
  bool clear_fragment() const {
    return GetField<uint8_t>(VT_CLEAR_FRAGMENT, 0) != 0;
  }
  /// If valid, doesn't include the '#' separator.
  const ::flatbuffers::String *fragment() const {
    return GetPointer<const ::flatbuffers::String *>(VT_FRAGMENT);
  }
  const ::flatbuffers::String *username() const {
    return GetPointer<const ::flatbuffers::String *>(VT_USERNAME);
  }
  const ::flatbuffers::String *password() const {
    return GetPointer<const ::flatbuffers::String *>(VT_PASSWORD);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_SCHEME) &&
           verifier.VerifyString(scheme()) &&
           VerifyOffset(verifier, VT_HOST) &&
           verifier.VerifyString(host()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_PORT, 1) &&
           VerifyOffset(verifier, VT_PORT) &&
           verifier.VerifyString(port()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_PATH, 1) &&
           VerifyOffset(verifier, VT_PATH) &&
           verifier.VerifyString(path()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_QUERY, 1) &&
           VerifyOffset(verifier, VT_QUERY) &&
           verifier.VerifyString(query()) &&
           VerifyOffset(verifier, VT_REMOVE_QUERY_PARAMS) &&
           verifier.VerifyVector(remove_query_params()) &&
           verifier.VerifyVectorOfStrings(remove_query_params()) &&
           VerifyOffset(verifier, VT_ADD_OR_REPLACE_QUERY_PARAMS) &&
           verifier.VerifyVector(add_or_replace_query_params()) &&
           verifier.VerifyVectorOfTables(add_or_replace_query_params()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_FRAGMENT, 1) &&
           VerifyOffset(verifier, VT_FRAGMENT) &&
           verifier.VerifyString(fragment()) &&
           VerifyOffset(verifier, VT_USERNAME) &&
           verifier.VerifyString(username()) &&
           VerifyOffset(verifier, VT_PASSWORD) &&
           verifier.VerifyString(password()) &&
           verifier.EndTable();
  }
};

struct UrlTransformBuilder {
  typedef UrlTransform Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_scheme(::flatbuffers::Offset<::flatbuffers::String> scheme) {
    fbb_.AddOffset(UrlTransform::VT_SCHEME, scheme);
  }
  void add_host(::flatbuffers::Offset<::flatbuffers::String> host) {
    fbb_.AddOffset(UrlTransform::VT_HOST, host);
  }
  void add_clear_port(bool clear_port) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_PORT, static_cast<uint8_t>(clear_port), 0);
  }
  void add_port(::flatbuffers::Offset<::flatbuffers::String> port) {
    fbb_.AddOffset(UrlTransform::VT_PORT, port);
  }
  void add_clear_path(bool clear_path) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_PATH, static_cast<uint8_t>(clear_path), 0);
  }
  void add_path(::flatbuffers::Offset<::flatbuffers::String> path) {
    fbb_.AddOffset(UrlTransform::VT_PATH, path);
  }
  void add_clear_query(bool clear_query) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_QUERY, static_cast<uint8_t>(clear_query), 0);
  }
  void add_query(::flatbuffers::Offset<::flatbuffers::String> query) {
    fbb_.AddOffset(UrlTransform::VT_QUERY, query);
  }
  void add_remove_query_params(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> remove_query_params) {
    fbb_.AddOffset(UrlTransform::VT_REMOVE_QUERY_PARAMS, remove_query_params);
  }
  void add_add_or_replace_query_params(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>> add_or_replace_query_params) {
    fbb_.AddOffset(UrlTransform::VT_ADD_OR_REPLACE_QUERY_PARAMS, add_or_replace_query_params);
  }
  void add_clear_fragment(bool clear_fragment) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_FRAGMENT, static_cast<uint8_t>(clear_fragment), 0);
  }
  void add_fragment(::flatbuffers::Offset<::flatbuffers::String> fragment) {
    fbb_.AddOffset(UrlTransform::VT_FRAGMENT, fragment);
  }
  void add_username(::flatbuffers::Offset<::flatbuffers::String> username) {
    fbb_.AddOffset(UrlTransform::VT_USERNAME, username);
  }
  void add_password(::flatbuffers::Offset<::flatbuffers::String> password) {
    fbb_.AddOffset(UrlTransform::VT_PASSWORD, password);
  }
  explicit UrlTransformBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<UrlTransform> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<UrlTransform>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<UrlTransform> CreateUrlTransform(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> scheme = 0,
    ::flatbuffers::Offset<::flatbuffers::String> host = 0,
    bool clear_port = false,
    ::flatbuffers::Offset<::flatbuffers::String> port = 0,
    bool clear_path = false,
    ::flatbuffers::Offset<::flatbuffers::String> path = 0,
    bool clear_query = false,
    ::flatbuffers::Offset<::flatbuffers::String> query = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> remove_query_params = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>> add_or_replace_query_params = 0,
    bool clear_fragment = false,
    ::flatbuffers::Offset<::flatbuffers::String> fragment = 0,
    ::flatbuffers::Offset<::flatbuffers::String> username = 0,
    ::flatbuffers::Offset<::flatbuffers::String> password = 0) {
  UrlTransformBuilder builder_(_fbb);
  builder_.add_password(password);
  builder_.add_username(username);
  builder_.add_fragment(fragment);
  builder_.add_add_or_replace_query_params(add_or_replace_query_params);
  builder_.add_remove_query_params(remove_query_params);
  builder_.add_query(query);
  builder_.add_path(path);
  builder_.add_port(port);
  builder_.add_host(host);
  builder_.add_scheme(scheme);
  builder_.add_clear_fragment(clear_fragment);
  builder_.add_clear_query(clear_query);
  builder_.add_clear_path(clear_path);
  builder_.add_clear_port(clear_port);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<UrlTransform> CreateUrlTransformDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *scheme = nullptr,
    const char *host = nullptr,
    bool clear_port = false,
    const char *port = nullptr,
    bool clear_path = false,
    const char *path = nullptr,
    bool clear_query = false,
    const char *query = nullptr,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *remove_query_params = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *add_or_replace_query_params = nullptr,
    bool clear_fragment = false,
    const char *fragment = nullptr,
    const char *username = nullptr,
    const char *password = nullptr) {
  auto scheme__ = scheme ? _fbb.CreateString(scheme) : 0;
  auto host__ = host ? _fbb.CreateString(host) : 0;
  auto port__ = port ? _fbb.CreateString(port) : 0;
  auto path__ = path ? _fbb.CreateString(path) : 0;
  auto query__ = query ? _fbb.CreateString(query) : 0;
  auto remove_query_params__ = remove_query_params ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*remove_query_params) : 0;
  auto add_or_replace_query_params__ = add_or_replace_query_params ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>(*add_or_replace_query_params) : 0;
  auto fragment__ = fragment ? _fbb.CreateString(fragment) : 0;
  auto username__ = username ? _fbb.CreateString(username) : 0;
  auto password__ = password ? _fbb.CreateString(password) : 0;
  return extensions::declarative_net_request::flat::CreateUrlTransform(
      _fbb,
      scheme__,
      host__,
      clear_port,
      port__,
      clear_path,
      path__,
      clear_query,
      query__,
      remove_query_params__,
      add_or_replace_query_params__,
      clear_fragment,
      fragment__,
      username__,
      password__);
}

/// Additional extension related metadata for a url_pattern_index UrlRule.
struct UrlRuleMetadata FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef UrlRuleMetadataBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ID = 4,
    VT_ACTION = 6,
    VT_REDIRECT_URL = 8,
    VT_TRANSFORM = 10,
    VT_REQUEST_HEADERS = 12,
    VT_RESPONSE_HEADERS = 14
  };
  /// ID of the UrlRule for which this metadata is stored.
  uint32_t id() const {
    return GetField<uint32_t>(VT_ID, 0);
  }
  bool KeyCompareLessThan(const UrlRuleMetadata * const o) const {
    return id() < o->id();
  }
  int KeyCompareWithValue(uint32_t _id) const {
    return static_cast<int>(id() > _id) - static_cast<int>(id() < _id);
  }
  /// Action type for this rule.
  extensions::declarative_net_request::flat::ActionType action() const {
    return static_cast<extensions::declarative_net_request::flat::ActionType>(GetField<uint8_t>(VT_ACTION, 0));
  }
  /// Redirect url for this rule. Should represent a valid GURL. At most one of
  /// |redirect_url| and |transform| should be specified for redirect rules.
  const ::flatbuffers::String *redirect_url() const {
    return GetPointer<const ::flatbuffers::String *>(VT_REDIRECT_URL);
  }
  /// UrlTransform for this rule.
  const extensions::declarative_net_request::flat::UrlTransform *transform() const {
    return GetPointer<const extensions::declarative_net_request::flat::UrlTransform *>(VT_TRANSFORM);
  }
  /// A list of ModifyHeaderInfo, for both request and response headers. Valid
  /// for "modifyHeaders" rules.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *request_headers() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *>(VT_REQUEST_HEADERS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *response_headers() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *>(VT_RESPONSE_HEADERS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_ID, 4) &&
           VerifyField<uint8_t>(verifier, VT_ACTION, 1) &&
           VerifyOffset(verifier, VT_REDIRECT_URL) &&
           verifier.VerifyString(redirect_url()) &&
           VerifyOffset(verifier, VT_TRANSFORM) &&
           verifier.VerifyTable(transform()) &&
           VerifyOffset(verifier, VT_REQUEST_HEADERS) &&
           verifier.VerifyVector(request_headers()) &&
           verifier.VerifyVectorOfTables(request_headers()) &&
           VerifyOffset(verifier, VT_RESPONSE_HEADERS) &&
           verifier.VerifyVector(response_headers()) &&
           verifier.VerifyVectorOfTables(response_headers()) &&
           verifier.EndTable();
  }
};

struct UrlRuleMetadataBuilder {
  typedef UrlRuleMetadata Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_id(uint32_t id) {
    fbb_.AddElement<uint32_t>(UrlRuleMetadata::VT_ID, id, 0);
  }
  void add_action(extensions::declarative_net_request::flat::ActionType action) {
    fbb_.AddElement<uint8_t>(UrlRuleMetadata::VT_ACTION, static_cast<uint8_t>(action), 0);
  }
  void add_redirect_url(::flatbuffers::Offset<::flatbuffers::String> redirect_url) {
    fbb_.AddOffset(UrlRuleMetadata::VT_REDIRECT_URL, redirect_url);
  }
  void add_transform(::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform) {
    fbb_.AddOffset(UrlRuleMetadata::VT_TRANSFORM, transform);
  }
  void add_request_headers(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> request_headers) {
    fbb_.AddOffset(UrlRuleMetadata::VT_REQUEST_HEADERS, request_headers);
  }
  void add_response_headers(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> response_headers) {
    fbb_.AddOffset(UrlRuleMetadata::VT_RESPONSE_HEADERS, response_headers);
  }
  explicit UrlRuleMetadataBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<UrlRuleMetadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<UrlRuleMetadata>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<UrlRuleMetadata> CreateUrlRuleMetadata(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    uint32_t id = 0,
    extensions::declarative_net_request::flat::ActionType action = extensions::declarative_net_request::flat::ActionType_block,
    ::flatbuffers::Offset<::flatbuffers::String> redirect_url = 0,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> request_headers = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> response_headers = 0) {
  UrlRuleMetadataBuilder builder_(_fbb);
  builder_.add_response_headers(response_headers);
  builder_.add_request_headers(request_headers);
  builder_.add_transform(transform);
  builder_.add_redirect_url(redirect_url);
  builder_.add_id(id);
  builder_.add_action(action);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<UrlRuleMetadata> CreateUrlRuleMetadataDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    uint32_t id = 0,
    extensions::declarative_net_request::flat::ActionType action = extensions::declarative_net_request::flat::ActionType_block,
    const char *redirect_url = nullptr,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform = 0,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *request_headers = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *response_headers = nullptr) {
  auto redirect_url__ = redirect_url ? _fbb.CreateString(redirect_url) : 0;
  auto request_headers__ = request_headers ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>(*request_headers) : 0;
  auto response_headers__ = response_headers ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>(*response_headers) : 0;
  return extensions::declarative_net_request::flat::CreateUrlRuleMetadata(
      _fbb,
      id,
      action,
      redirect_url__,
      transform,
      request_headers__,
      response_headers__);
}

struct EmbedderConditions FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef EmbedderConditionsBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_TAB_IDS_INCLUDED = 4,
    VT_TAB_IDS_EXCLUDED = 6,
    VT_RESPONSE_HEADERS = 8,
    VT_EXCLUDED_RESPONSE_HEADERS = 10
  };
  /// Sorted list of tab IDs to include/exclude.
  const ::flatbuffers::Vector<int32_t> *tab_ids_included() const {
    return GetPointer<const ::flatbuffers::Vector<int32_t> *>(VT_TAB_IDS_INCLUDED);
  }
  const ::flatbuffers::Vector<int32_t> *tab_ids_excluded() const {
    return GetPointer<const ::flatbuffers::Vector<int32_t> *>(VT_TAB_IDS_EXCLUDED);
  }
  /// Headers to include/exclude. Note that `excluded_response_headers` will
  /// only match on header names.
  /// TODO(crbug.com/41482616): Consider relocating these header conditions as
  /// they apply to requests and what "embeds" the requests (such as the
  /// browser). One potentially suitable place would be a new table in the
  /// UrlPatternIndex for more complex conditions from requests and responses,
  /// especially if future components may reuse these conditions.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *response_headers() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *>(VT_RESPONSE_HEADERS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *excluded_response_headers() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *>(VT_EXCLUDED_RESPONSE_HEADERS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_TAB_IDS_INCLUDED) &&
           verifier.VerifyVector(tab_ids_included()) &&
           VerifyOffset(verifier, VT_TAB_IDS_EXCLUDED) &&
           verifier.VerifyVector(tab_ids_excluded()) &&
           VerifyOffset(verifier, VT_RESPONSE_HEADERS) &&
           verifier.VerifyVector(response_headers()) &&
           verifier.VerifyVectorOfTables(response_headers()) &&
           VerifyOffset(verifier, VT_EXCLUDED_RESPONSE_HEADERS) &&
           verifier.VerifyVector(excluded_response_headers()) &&
           verifier.VerifyVectorOfTables(excluded_response_headers()) &&
           verifier.EndTable();
  }
};

struct EmbedderConditionsBuilder {
  typedef EmbedderConditions Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_tab_ids_included(::flatbuffers::Offset<::flatbuffers::Vector<int32_t>> tab_ids_included) {
    fbb_.AddOffset(EmbedderConditions::VT_TAB_IDS_INCLUDED, tab_ids_included);
  }
  void add_tab_ids_excluded(::flatbuffers::Offset<::flatbuffers::Vector<int32_t>> tab_ids_excluded) {
    fbb_.AddOffset(EmbedderConditions::VT_TAB_IDS_EXCLUDED, tab_ids_excluded);
  }
  void add_response_headers(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>> response_headers) {
    fbb_.AddOffset(EmbedderConditions::VT_RESPONSE_HEADERS, response_headers);
  }
  void add_excluded_response_headers(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>> excluded_response_headers) {
    fbb_.AddOffset(EmbedderConditions::VT_EXCLUDED_RESPONSE_HEADERS, excluded_response_headers);
  }
  explicit EmbedderConditionsBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<EmbedderConditions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<EmbedderConditions>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<EmbedderConditions> CreateEmbedderConditions(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::Vector<int32_t>> tab_ids_included = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<int32_t>> tab_ids_excluded = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>> response_headers = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>> excluded_response_headers = 0) {
  EmbedderConditionsBuilder builder_(_fbb);
  builder_.add_excluded_response_headers(excluded_response_headers);
  builder_.add_response_headers(response_headers);
  builder_.add_tab_ids_excluded(tab_ids_excluded);
  builder_.add_tab_ids_included(tab_ids_included);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<EmbedderConditions> CreateEmbedderConditionsDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<int32_t> *tab_ids_included = nullptr,
    const std::vector<int32_t> *tab_ids_excluded = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *response_headers = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>> *excluded_response_headers = nullptr) {
  auto tab_ids_included__ = tab_ids_included ? _fbb.CreateVector<int32_t>(*tab_ids_included) : 0;
  auto tab_ids_excluded__ = tab_ids_excluded ? _fbb.CreateVector<int32_t>(*tab_ids_excluded) : 0;
  auto response_headers__ = response_headers ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>(*response_headers) : 0;
  auto excluded_response_headers__ = excluded_response_headers ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::HeaderCondition>>(*excluded_response_headers) : 0;
  return extensions::declarative_net_request::flat::CreateEmbedderConditions(
      _fbb,
      tab_ids_included__,
      tab_ids_excluded__,
      response_headers__,
      excluded_response_headers__);
}

/// Options for regex filters and substitutions for headers. Corresponds to
/// extensions::api::declarative_net_request::HeaderRegexOptions.
struct RegexFilterOptions FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef RegexFilterOptionsBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_MATCH_ALL = 4
  };
  /// Whether the regex should match all groups for the value. This is only
  /// relevant if a regex substitution is present and would thus need to be
  /// applied onto all matching groups. Equivalent to the "g" flag.
  /// Defaults to false.
  bool match_all() const {
    return GetField<uint8_t>(VT_MATCH_ALL, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_MATCH_ALL, 1) &&
           verifier.EndTable();
  }
};

struct RegexFilterOptionsBuilder {
  typedef RegexFilterOptions Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_match_all(bool match_all) {
    fbb_.AddElement<uint8_t>(RegexFilterOptions::VT_MATCH_ALL, static_cast<uint8_t>(match_all), 0);
  }
  explicit RegexFilterOptionsBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<RegexFilterOptions> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<RegexFilterOptions>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<RegexFilterOptions> CreateRegexFilterOptions(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    bool match_all = false) {
  RegexFilterOptionsBuilder builder_(_fbb);
  builder_.add_match_all(match_all);
  return builder_.Finish();
}

/// Describes the header to be modified and operation to be performed on it.
/// Corresponds to extensions::api::declarative_net_request::ModifyHeaderInfo.
struct ModifyHeaderInfo FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ModifyHeaderInfoBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_OPERATION = 4,
    VT_HEADER = 6,
    VT_VALUE = 8,
    VT_REGEX_FILTER = 10,
    VT_REGEX_SUBSTITUTION = 12,
    VT_REGEX_OPTIONS = 14
  };
  extensions::declarative_net_request::flat::HeaderOperation operation() const {
    return static_cast<extensions::declarative_net_request::flat::HeaderOperation>(GetField<uint8_t>(VT_OPERATION, 0));
  }
  /// The name the header to be modified. Since header names are
  /// case-insensitive, the header name is normalized by converting it to
  /// lowercase.
  const ::flatbuffers::String *header() const {
    return GetPointer<const ::flatbuffers::String *>(VT_HEADER);
  }
  /// The value of the header to be set/appended. Should be specified only if
  /// |operation| is append or set.
  const ::flatbuffers::String *value() const {
    return GetPointer<const ::flatbuffers::String *>(VT_VALUE);
  }
  /// A regular expression to match against the header value. This follows the
  /// RE2 syntax for consistency with the rest of the API.
  const ::flatbuffers::String *regex_filter() const {
    return GetPointer<const ::flatbuffers::String *>(VT_REGEX_FILTER);
  }
  /// Substitution pattern for the response header. `regexFilter` must be
  /// specified for this to be valid. Takes precedence over `value` and
  /// `operation` if specified and valid.
  const ::flatbuffers::String *regex_substitution() const {
    return GetPointer<const ::flatbuffers::String *>(VT_REGEX_SUBSTITUTION);
  }
  /// Options for the regex filter. If not specified, all options will be
  /// default.
  const extensions::declarative_net_request::flat::RegexFilterOptions *regex_options() const {
    return GetPointer<const extensions::declarative_net_request::flat::RegexFilterOptions *>(VT_REGEX_OPTIONS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_OPERATION, 1) &&
           VerifyOffset(verifier, VT_HEADER) &&
           verifier.VerifyString(header()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           VerifyOffset(verifier, VT_REGEX_FILTER) &&
           verifier.VerifyString(regex_filter()) &&
           VerifyOffset(verifier, VT_REGEX_SUBSTITUTION) &&
           verifier.VerifyString(regex_substitution()) &&
           VerifyOffset(verifier, VT_REGEX_OPTIONS) &&
           verifier.VerifyTable(regex_options()) &&
           verifier.EndTable();
  }
};

struct ModifyHeaderInfoBuilder {
  typedef ModifyHeaderInfo Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_operation(extensions::declarative_net_request::flat::HeaderOperation operation) {
    fbb_.AddElement<uint8_t>(ModifyHeaderInfo::VT_OPERATION, static_cast<uint8_t>(operation), 0);
  }
  void add_header(::flatbuffers::Offset<::flatbuffers::String> header) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_HEADER, header);
  }
  void add_value(::flatbuffers::Offset<::flatbuffers::String> value) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_VALUE, value);
  }
  void add_regex_filter(::flatbuffers::Offset<::flatbuffers::String> regex_filter) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_REGEX_FILTER, regex_filter);
  }
  void add_regex_substitution(::flatbuffers::Offset<::flatbuffers::String> regex_substitution) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_REGEX_SUBSTITUTION, regex_substitution);
  }
  void add_regex_options(::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexFilterOptions> regex_options) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_REGEX_OPTIONS, regex_options);
  }
  explicit ModifyHeaderInfoBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<ModifyHeaderInfo> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<ModifyHeaderInfo>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<ModifyHeaderInfo> CreateModifyHeaderInfo(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    extensions::declarative_net_request::flat::HeaderOperation operation = extensions::declarative_net_request::flat::HeaderOperation_append,
    ::flatbuffers::Offset<::flatbuffers::String> header = 0,
    ::flatbuffers::Offset<::flatbuffers::String> value = 0,
    ::flatbuffers::Offset<::flatbuffers::String> regex_filter = 0,
    ::flatbuffers::Offset<::flatbuffers::String> regex_substitution = 0,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexFilterOptions> regex_options = 0) {
  ModifyHeaderInfoBuilder builder_(_fbb);
  builder_.add_regex_options(regex_options);
  builder_.add_regex_substitution(regex_substitution);
  builder_.add_regex_filter(regex_filter);
  builder_.add_value(value);
  builder_.add_header(header);
  builder_.add_operation(operation);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<ModifyHeaderInfo> CreateModifyHeaderInfoDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    extensions::declarative_net_request::flat::HeaderOperation operation = extensions::declarative_net_request::flat::HeaderOperation_append,
    const char *header = nullptr,
    const char *value = nullptr,
    const char *regex_filter = nullptr,
    const char *regex_substitution = nullptr,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexFilterOptions> regex_options = 0) {
  auto header__ = header ? _fbb.CreateString(header) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  auto regex_filter__ = regex_filter ? _fbb.CreateString(regex_filter) : 0;
  auto regex_substitution__ = regex_substitution ? _fbb.CreateString(regex_substitution) : 0;
  return extensions::declarative_net_request::flat::CreateModifyHeaderInfo(
      _fbb,
      operation,
      header__,
      value__,
      regex_filter__,
      regex_substitution__,
      regex_options);
}

/// Describes the matching condition for a header, Corresponds to
/// extensions::api::declarative_net_request::HeaderInfo.
struct HeaderCondition FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef HeaderConditionBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_HEADER = 4,
    VT_VALUES = 6,
    VT_EXCLUDED_VALUES = 8
  };
  /// The name of the header to be matched on.
  const ::flatbuffers::String *header() const {
    return GetPointer<const ::flatbuffers::String *>(VT_HEADER);
  }
  /// Header values to include or exclude for matching, if non-empty. This is
  /// converted into lowercase.
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *values() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_VALUES);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *excluded_values() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_EXCLUDED_VALUES);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_HEADER) &&
           verifier.VerifyString(header()) &&
           VerifyOffset(verifier, VT_VALUES) &&
           verifier.VerifyVector(values()) &&
           verifier.VerifyVectorOfStrings(values()) &&
           VerifyOffset(verifier, VT_EXCLUDED_VALUES) &&
           verifier.VerifyVector(excluded_values()) &&
           verifier.VerifyVectorOfStrings(excluded_values()) &&
           verifier.EndTable();
  }
};

struct HeaderConditionBuilder {
  typedef HeaderCondition Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_header(::flatbuffers::Offset<::flatbuffers::String> header) {
    fbb_.AddOffset(HeaderCondition::VT_HEADER, header);
  }
  void add_values(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> values) {
    fbb_.AddOffset(HeaderCondition::VT_VALUES, values);
  }
  void add_excluded_values(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> excluded_values) {
    fbb_.AddOffset(HeaderCondition::VT_EXCLUDED_VALUES, excluded_values);
  }
  explicit HeaderConditionBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<HeaderCondition> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<HeaderCondition>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<HeaderCondition> CreateHeaderCondition(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> header = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> values = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> excluded_values = 0) {
  HeaderConditionBuilder builder_(_fbb);
  builder_.add_excluded_values(excluded_values);
  builder_.add_values(values);
  builder_.add_header(header);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<HeaderCondition> CreateHeaderConditionDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *header = nullptr,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *values = nullptr,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *excluded_values = nullptr) {
  auto header__ = header ? _fbb.CreateString(header) : 0;
  auto values__ = values ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*values) : 0;
  auto excluded_values__ = excluded_values ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*excluded_values) : 0;
  return extensions::declarative_net_request::flat::CreateHeaderCondition(
      _fbb,
      header__,
      values__,
      excluded_values__);
}

/// Completely represents a rule with a regex filter.
struct RegexRule FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef RegexRuleBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_URL_RULE = 4,
    VT_ACTION_TYPE = 6,
    VT_REGEX_SUBSTITUTION = 8
  };
  /// The underlying UrlRule.
  const url_pattern_index::flat::UrlRule *url_rule() const {
    return GetPointer<const url_pattern_index::flat::UrlRule *>(VT_URL_RULE);
  }
  /// The action to take.
  extensions::declarative_net_request::flat::ActionType action_type() const {
    return static_cast<extensions::declarative_net_request::flat::ActionType>(GetField<uint8_t>(VT_ACTION_TYPE, 0));
  }
  /// The regex substitution pattern for this rule if specified.
  const ::flatbuffers::String *regex_substitution() const {
    return GetPointer<const ::flatbuffers::String *>(VT_REGEX_SUBSTITUTION);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_URL_RULE) &&
           verifier.VerifyTable(url_rule()) &&
           VerifyField<uint8_t>(verifier, VT_ACTION_TYPE, 1) &&
           VerifyOffset(verifier, VT_REGEX_SUBSTITUTION) &&
           verifier.VerifyString(regex_substitution()) &&
           verifier.EndTable();
  }
};

struct RegexRuleBuilder {
  typedef RegexRule Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_url_rule(::flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule) {
    fbb_.AddOffset(RegexRule::VT_URL_RULE, url_rule);
  }
  void add_action_type(extensions::declarative_net_request::flat::ActionType action_type) {
    fbb_.AddElement<uint8_t>(RegexRule::VT_ACTION_TYPE, static_cast<uint8_t>(action_type), 0);
  }
  void add_regex_substitution(::flatbuffers::Offset<::flatbuffers::String> regex_substitution) {
    fbb_.AddOffset(RegexRule::VT_REGEX_SUBSTITUTION, regex_substitution);
  }
  explicit RegexRuleBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<RegexRule> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<RegexRule>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<RegexRule> CreateRegexRule(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule = 0,
    extensions::declarative_net_request::flat::ActionType action_type = extensions::declarative_net_request::flat::ActionType_block,
    ::flatbuffers::Offset<::flatbuffers::String> regex_substitution = 0) {
  RegexRuleBuilder builder_(_fbb);
  builder_.add_regex_substitution(regex_substitution);
  builder_.add_url_rule(url_rule);
  builder_.add_action_type(action_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<RegexRule> CreateRegexRuleDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule = 0,
    extensions::declarative_net_request::flat::ActionType action_type = extensions::declarative_net_request::flat::ActionType_block,
    const char *regex_substitution = nullptr) {
  auto regex_substitution__ = regex_substitution ? _fbb.CreateString(regex_substitution) : 0;
  return extensions::declarative_net_request::flat::CreateRegexRule(
      _fbb,
      url_rule,
      action_type,
      regex_substitution__);
}

/// The top-level data structure used to store extensions URL rules for the
/// Declarative Net Request API.
struct ExtensionIndexedRuleset FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ExtensionIndexedRulesetBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BEFORE_REQUEST_INDEX_LIST = 4,
    VT_HEADERS_RECEIVED_INDEX_LIST = 6,
    VT_BEFORE_REQUEST_REGEX_RULES = 8,
    VT_HEADERS_RECEIVED_REGEX_RULES = 10,
    VT_EXTENSION_METADATA = 12
  };
  /// Vector of UrlPatternIndex. This will consist of `IndexType_count` indices.
  /// This index list is for rules that can be matched before a request is
  /// initiated.
  const ::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *before_request_index_list() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *>(VT_BEFORE_REQUEST_INDEX_LIST);
  }
  /// An index list of `IndexType_count` indices for rules that are matched
  /// after response headers have been received from a request.
  const ::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *headers_received_index_list() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *>(VT_HEADERS_RECEIVED_INDEX_LIST);
  }
  /// Regex rules are not matched by UrlPatternIndex and so we don't build an
  /// index for them. This list is for rules that can be matched before a
  /// request is initiated.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *before_request_regex_rules() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *>(VT_BEFORE_REQUEST_REGEX_RULES);
  }
  /// List of regex rules that are matched after response headers have been
  /// received from a request.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *headers_received_regex_rules() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *>(VT_HEADERS_RECEIVED_REGEX_RULES);
  }
  /// Extension related metadata. Sorted by id, to support fast lookup.
  const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *extension_metadata() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *>(VT_EXTENSION_METADATA);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BEFORE_REQUEST_INDEX_LIST) &&
           verifier.VerifyVector(before_request_index_list()) &&
           verifier.VerifyVectorOfTables(before_request_index_list()) &&
           VerifyOffset(verifier, VT_HEADERS_RECEIVED_INDEX_LIST) &&
           verifier.VerifyVector(headers_received_index_list()) &&
           verifier.VerifyVectorOfTables(headers_received_index_list()) &&
           VerifyOffset(verifier, VT_BEFORE_REQUEST_REGEX_RULES) &&
           verifier.VerifyVector(before_request_regex_rules()) &&
           verifier.VerifyVectorOfTables(before_request_regex_rules()) &&
           VerifyOffset(verifier, VT_HEADERS_RECEIVED_REGEX_RULES) &&
           verifier.VerifyVector(headers_received_regex_rules()) &&
           verifier.VerifyVectorOfTables(headers_received_regex_rules()) &&
           VerifyOffset(verifier, VT_EXTENSION_METADATA) &&
           verifier.VerifyVector(extension_metadata()) &&
           verifier.VerifyVectorOfTables(extension_metadata()) &&
           verifier.EndTable();
  }
};

struct ExtensionIndexedRulesetBuilder {
  typedef ExtensionIndexedRuleset Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_before_request_index_list(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> before_request_index_list) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_BEFORE_REQUEST_INDEX_LIST, before_request_index_list);
  }
  void add_headers_received_index_list(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> headers_received_index_list) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_HEADERS_RECEIVED_INDEX_LIST, headers_received_index_list);
  }
  void add_before_request_regex_rules(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> before_request_regex_rules) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_BEFORE_REQUEST_REGEX_RULES, before_request_regex_rules);
  }
  void add_headers_received_regex_rules(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> headers_received_regex_rules) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_HEADERS_RECEIVED_REGEX_RULES, headers_received_regex_rules);
  }
  void add_extension_metadata(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>>> extension_metadata) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_EXTENSION_METADATA, extension_metadata);
  }
  explicit ExtensionIndexedRulesetBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<ExtensionIndexedRuleset> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<ExtensionIndexedRuleset>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<ExtensionIndexedRuleset> CreateExtensionIndexedRuleset(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> before_request_index_list = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> headers_received_index_list = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> before_request_regex_rules = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> headers_received_regex_rules = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>>> extension_metadata = 0) {
  ExtensionIndexedRulesetBuilder builder_(_fbb);
  builder_.add_extension_metadata(extension_metadata);
  builder_.add_headers_received_regex_rules(headers_received_regex_rules);
  builder_.add_before_request_regex_rules(before_request_regex_rules);
  builder_.add_headers_received_index_list(headers_received_index_list);
  builder_.add_before_request_index_list(before_request_index_list);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<ExtensionIndexedRuleset> CreateExtensionIndexedRulesetDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *before_request_index_list = nullptr,
    const std::vector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *headers_received_index_list = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *before_request_regex_rules = nullptr,
    const std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *headers_received_regex_rules = nullptr,
    std::vector<::flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *extension_metadata = nullptr) {
  auto before_request_index_list__ = before_request_index_list ? _fbb.CreateVector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>(*before_request_index_list) : 0;
  auto headers_received_index_list__ = headers_received_index_list ? _fbb.CreateVector<::flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>(*headers_received_index_list) : 0;
  auto before_request_regex_rules__ = before_request_regex_rules ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>(*before_request_regex_rules) : 0;
  auto headers_received_regex_rules__ = headers_received_regex_rules ? _fbb.CreateVector<::flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>(*headers_received_regex_rules) : 0;
  auto extension_metadata__ = extension_metadata ? _fbb.CreateVectorOfSortedTables<extensions::declarative_net_request::flat::UrlRuleMetadata>(extension_metadata) : 0;
  return extensions::declarative_net_request::flat::CreateExtensionIndexedRuleset(
      _fbb,
      before_request_index_list__,
      headers_received_index_list__,
      before_request_regex_rules__,
      headers_received_regex_rules__,
      extension_metadata__);
}

inline const extensions::declarative_net_request::flat::ExtensionIndexedRuleset *GetExtensionIndexedRuleset(const void *buf) {
  return ::flatbuffers::GetRoot<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(buf);
}

inline const extensions::declarative_net_request::flat::ExtensionIndexedRuleset *GetSizePrefixedExtensionIndexedRuleset(const void *buf) {
  return ::flatbuffers::GetSizePrefixedRoot<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(buf);
}

inline const char *ExtensionIndexedRulesetIdentifier() {
  return "EXTR";
}

inline bool ExtensionIndexedRulesetBufferHasIdentifier(const void *buf) {
  return ::flatbuffers::BufferHasIdentifier(
      buf, ExtensionIndexedRulesetIdentifier());
}

inline bool SizePrefixedExtensionIndexedRulesetBufferHasIdentifier(const void *buf) {
  return ::flatbuffers::BufferHasIdentifier(
      buf, ExtensionIndexedRulesetIdentifier(), true);
}

inline bool VerifyExtensionIndexedRulesetBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(ExtensionIndexedRulesetIdentifier());
}

inline bool VerifySizePrefixedExtensionIndexedRulesetBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(ExtensionIndexedRulesetIdentifier());
}

inline void FinishExtensionIndexedRulesetBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::ExtensionIndexedRuleset> root) {
  fbb.Finish(root, ExtensionIndexedRulesetIdentifier());
}

inline void FinishSizePrefixedExtensionIndexedRulesetBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<extensions::declarative_net_request::flat::ExtensionIndexedRuleset> root) {
  fbb.FinishSizePrefixed(root, ExtensionIndexedRulesetIdentifier());
}

}  // namespace flat
}  // namespace declarative_net_request
}  // namespace extensions

#endif  // FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_
