// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h"



#include "base/component_export.h"




namespace auction_worklet::mojom {
class BucketOffsetDataView;

class SignalBucketDataView;

class SignalValueDataView;

class AggregatableReportForEventContributionDataView;

class PrivateAggregationRequestDataView;

class ForEventSignalBucketDataView;
class ForEventSignalValueDataView;
class EventTypeDataView;
class AggregatableReportContributionDataView;


}  // auction_worklet::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BucketOffsetDataView> {
  using Data = ::auction_worklet::mojom::internal::BucketOffset_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::SignalBucketDataView> {
  using Data = ::auction_worklet::mojom::internal::SignalBucket_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::SignalValueDataView> {
  using Data = ::auction_worklet::mojom::internal::SignalValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AggregatableReportForEventContributionDataView> {
  using Data = ::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::PrivateAggregationRequestDataView> {
  using Data = ::auction_worklet::mojom::internal::PrivateAggregationRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ForEventSignalBucketDataView> {
  using Data = ::auction_worklet::mojom::internal::ForEventSignalBucket_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::ForEventSignalValueDataView> {
  using Data = ::auction_worklet::mojom::internal::ForEventSignalValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::EventTypeDataView> {
  using Data = ::auction_worklet::mojom::internal::EventType_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::AggregatableReportContributionDataView> {
  using Data = ::auction_worklet::mojom::internal::AggregatableReportContribution_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {


enum class BaseValue : int32_t {
  
  kWinningBid = 0,
  
  kHighestScoringOtherBid = 1,
  
  kScriptRunTime = 2,
  
  kSignalsFetchTime = 3,
  
  kBidRejectReason = 4,
  
  kParticipatingInterestGroupCount = 5,
  
  kAverageCodeFetchTime = 6,
  
  kPercentScriptsTimeout = 7,
  
  kPercentInterestGroupsCumulativeTimeout = 8,
  
  kCumulativeBuyerTime = 9,
  
  kRegularInterestGroupsUsed = 10,
  
  kPercentRegularInterestGroupQuotaUsed = 11,
  
  kNegativeInterestGroupsUsed = 12,
  
  kPercentNegativeInterestGroupQuotaUsed = 13,
  
  kInterestGroupStorageUsed = 14,
  
  kPercentInterestGroupStorageQuotaUsed = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, BaseValue value);
inline bool IsKnownEnumValue(BaseValue value) {
  return internal::BaseValue_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReservedEventType : int32_t {
  
  kReservedAlways = 0,
  
  kReservedWin = 1,
  
  kReservedLoss = 2,
  
  kReservedOnce = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReservedEventType value);
inline bool IsKnownEnumValue(ReservedEventType value) {
  return internal::ReservedEventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BucketOffsetDataView {
 public:
  BucketOffsetDataView() = default;

  BucketOffsetDataView(
      internal::BucketOffset_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  bool is_negative() const {
    return data_->is_negative;
  }
 private:
  internal::BucketOffset_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignalBucketDataView {
 public:
  SignalBucketDataView() = default;

  SignalBucketDataView(
      internal::SignalBucket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBaseValue(UserType* output) const {
    auto data_value = data_->base_value;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BaseValue>(
        data_value, output);
  }
  BaseValue base_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BaseValue>(data_->base_value));
  }
  double scale() const {
    return data_->scale;
  }
  inline void GetOffsetDataView(
      BucketOffsetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::auction_worklet::mojom::BucketOffsetDataView, UserType>(),
    "Attempting to read the optional `offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOffset` instead "
    "of `ReadOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->offset.Get();
    return mojo::internal::Deserialize<::auction_worklet::mojom::BucketOffsetDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignalBucket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignalValueDataView {
 public:
  SignalValueDataView() = default;

  SignalValueDataView(
      internal::SignalValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBaseValue(UserType* output) const {
    auto data_value = data_->base_value;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BaseValue>(
        data_value, output);
  }
  BaseValue base_value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BaseValue>(data_->base_value));
  }
  double scale() const {
    return data_->scale;
  }
  int32_t offset() const {
    return data_->offset;
  }
 private:
  internal::SignalValue_Data* data_ = nullptr;
};


class AggregatableReportForEventContributionDataView {
 public:
  AggregatableReportForEventContributionDataView() = default;

  AggregatableReportForEventContributionDataView(
      internal::AggregatableReportForEventContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ForEventSignalBucketDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = !data_->bucket.is_null() ? &data_->bucket : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ForEventSignalBucketDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ForEventSignalValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::ForEventSignalValueDataView>(
        pointer, output, message_);
  }
  std::optional<uint64_t> filtering_id() const {

    return data_->filtering_id_$flag
        ? std::make_optional(data_->filtering_id_$value)
        : std::nullopt;
  }
  inline void GetEventTypeDataView(
      EventTypeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventType(UserType* output) {
    
    auto* pointer = !data_->event_type.is_null() ? &data_->event_type : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::EventTypeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableReportForEventContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateAggregationRequestDataView {
 public:
  PrivateAggregationRequestDataView() = default;

  PrivateAggregationRequestDataView(
      internal::PrivateAggregationRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContributionDataView(
      AggregatableReportContributionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContribution(UserType* output) {
    
    auto* pointer = !data_->contribution.is_null() ? &data_->contribution : nullptr;
    return mojo::internal::Deserialize<::auction_worklet::mojom::AggregatableReportContributionDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAggregationMode(UserType* output) const {
    auto data_value = data_->aggregation_mode;
    return mojo::internal::Deserialize<::blink::mojom::AggregationServiceMode>(
        data_value, output);
  }
  ::blink::mojom::AggregationServiceMode aggregation_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AggregationServiceMode>(data_->aggregation_mode));
  }
  inline void GetDebugModeDetailsDataView(
      ::blink::mojom::DebugModeDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugModeDetails(UserType* output) {
    
    auto* pointer = data_->debug_mode_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::DebugModeDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrivateAggregationRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ForEventSignalBucketDataView {
 public:
  using Tag = internal::ForEventSignalBucket_Data::ForEventSignalBucket_Tag;

  ForEventSignalBucketDataView() = default;

  ForEventSignalBucketDataView(
      internal::ForEventSignalBucket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_id_bucket() const { return data_->tag == Tag::kIdBucket; }
  inline void GetIdBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadIdBucket(UserType* output) const {
    
    CHECK(is_id_bucket());
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        data_->data.f_id_bucket.Get(), output, message_);
  }
  bool is_signal_bucket() const { return data_->tag == Tag::kSignalBucket; }
  inline void GetSignalBucketDataView(
      SignalBucketDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSignalBucket(UserType* output) const {
    
    CHECK(is_signal_bucket());
    return mojo::internal::Deserialize<::auction_worklet::mojom::SignalBucketDataView>(
        data_->data.f_signal_bucket.Get(), output, message_);
  }

 private:
  internal::ForEventSignalBucket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ForEventSignalValueDataView {
 public:
  using Tag = internal::ForEventSignalValue_Data::ForEventSignalValue_Tag;

  ForEventSignalValueDataView() = default;

  ForEventSignalValueDataView(
      internal::ForEventSignalValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_int_value() const { return data_->tag == Tag::kIntValue; }
  int32_t int_value() const {
    CHECK(is_int_value());
    return data_->data.f_int_value;
  }
  bool is_signal_value() const { return data_->tag == Tag::kSignalValue; }
  inline void GetSignalValueDataView(
      SignalValueDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSignalValue(UserType* output) const {
    
    CHECK(is_signal_value());
    return mojo::internal::Deserialize<::auction_worklet::mojom::SignalValueDataView>(
        data_->data.f_signal_value.Get(), output, message_);
  }

 private:
  internal::ForEventSignalValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class EventTypeDataView {
 public:
  using Tag = internal::EventType_Data::EventType_Tag;

  EventTypeDataView() = default;

  EventTypeDataView(
      internal::EventType_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_reserved() const { return data_->tag == Tag::kReserved; }
  template <typename UserType>
  [[nodiscard]] bool ReadReserved(UserType* output) const {
    CHECK(is_reserved());
    return mojo::internal::Deserialize<::auction_worklet::mojom::ReservedEventType>(
        data_->data.f_reserved, output);
  }
  ReservedEventType reserved() const {
    CHECK(is_reserved());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedEventType>(data_->data.f_reserved));
  }
  bool is_non_reserved() const { return data_->tag == Tag::kNonReserved; }
  inline void GetNonReservedDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNonReserved(UserType* output) const {
    
    CHECK(is_non_reserved());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_non_reserved.Get(), output, message_);
  }

 private:
  internal::EventType_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AggregatableReportContributionDataView {
 public:
  using Tag = internal::AggregatableReportContribution_Data::AggregatableReportContribution_Tag;

  AggregatableReportContributionDataView() = default;

  AggregatableReportContributionDataView(
      internal::AggregatableReportContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_histogram_contribution() const { return data_->tag == Tag::kHistogramContribution; }
  inline void GetHistogramContributionDataView(
      ::blink::mojom::AggregatableReportHistogramContributionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHistogramContribution(UserType* output) const {
    
    CHECK(is_histogram_contribution());
    return mojo::internal::Deserialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
        data_->data.f_histogram_contribution.Get(), output, message_);
  }
  bool is_for_event_contribution() const { return data_->tag == Tag::kForEventContribution; }
  inline void GetForEventContributionDataView(
      AggregatableReportForEventContributionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadForEventContribution(UserType* output) const {
    
    CHECK(is_for_event_contribution());
    return mojo::internal::Deserialize<::auction_worklet::mojom::AggregatableReportForEventContributionDataView>(
        data_->data.f_for_event_contribution.Get(), output, message_);
  }

 private:
  internal::AggregatableReportContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // auction_worklet::mojom

namespace std {

template <>
struct hash<::auction_worklet::mojom::BaseValue>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::BaseValue> {};

template <>
struct hash<::auction_worklet::mojom::ReservedEventType>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::ReservedEventType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BaseValue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::BaseValue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::BaseValue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ReservedEventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::ReservedEventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReservedEventType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BucketOffsetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BucketOffsetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BucketOffset_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in BucketOffset struct");
    fragment->is_negative = Traits::is_negative(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BucketOffset_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BucketOffsetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::SignalBucketDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::SignalBucketDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::SignalBucket_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::auction_worklet::mojom::BaseValue>(
        Traits::base_value(input), &fragment->base_value);
    fragment->scale = Traits::scale(input);
    decltype(Traits::offset(input)) in_offset = Traits::offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset)::BaseType> offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::auction_worklet::mojom::BucketOffsetDataView>(
        in_offset, offset_fragment);
    fragment->offset.Set(
        offset_fragment.is_null() ? nullptr : offset_fragment.data());
  }

  static bool Deserialize(::auction_worklet::mojom::internal::SignalBucket_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::SignalBucketDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::SignalValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::SignalValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::SignalValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::auction_worklet::mojom::BaseValue>(
        Traits::base_value(input), &fragment->base_value);
    fragment->scale = Traits::scale(input);
    fragment->offset = Traits::offset(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::SignalValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::SignalValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::AggregatableReportForEventContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::AggregatableReportForEventContributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<decltype(fragment->bucket)>
        bucket_fragment(fragment.message());
    bucket_fragment.Claim(&fragment->bucket);
    mojo::internal::Serialize<::auction_worklet::mojom::ForEventSignalBucketDataView>(
        in_bucket, bucket_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bucket.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket in AggregatableReportForEventContribution struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<decltype(fragment->value)>
        value_fragment(fragment.message());
    value_fragment.Claim(&fragment->value);
    mojo::internal::Serialize<::auction_worklet::mojom::ForEventSignalValueDataView>(
        in_value, value_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AggregatableReportForEventContribution struct");
    fragment->filtering_id_$flag = Traits::filtering_id(input).has_value();
    if (Traits::filtering_id(input).has_value()) {
      fragment->filtering_id_$value = Traits::filtering_id(input).value();
    }
    decltype(Traits::event_type(input)) in_event_type = Traits::event_type(input);
    mojo::internal::MessageFragment<decltype(fragment->event_type)>
        event_type_fragment(fragment.message());
    event_type_fragment.Claim(&fragment->event_type);
    mojo::internal::Serialize<::auction_worklet::mojom::EventTypeDataView>(
        in_event_type, event_type_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_type in AggregatableReportForEventContribution struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::AggregatableReportForEventContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::AggregatableReportForEventContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::PrivateAggregationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::PrivateAggregationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::PrivateAggregationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::contribution(input)) in_contribution = Traits::contribution(input);
    mojo::internal::MessageFragment<decltype(fragment->contribution)>
        contribution_fragment(fragment.message());
    contribution_fragment.Claim(&fragment->contribution);
    mojo::internal::Serialize<::auction_worklet::mojom::AggregatableReportContributionDataView>(
        in_contribution, contribution_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->contribution.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contribution in PrivateAggregationRequest struct");
    mojo::internal::Serialize<::blink::mojom::AggregationServiceMode>(
        Traits::aggregation_mode(input), &fragment->aggregation_mode);
    decltype(Traits::debug_mode_details(input)) in_debug_mode_details = Traits::debug_mode_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_mode_details)::BaseType> debug_mode_details_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DebugModeDetailsDataView>(
        in_debug_mode_details, debug_mode_details_fragment);
    fragment->debug_mode_details.Set(
        debug_mode_details_fragment.is_null() ? nullptr : debug_mode_details_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->debug_mode_details.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_mode_details in PrivateAggregationRequest struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::PrivateAggregationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::PrivateAggregationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ForEventSignalBucketDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::ForEventSignalBucketDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::ForEventSignalBucket_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::auction_worklet::mojom::ForEventSignalBucketDataView::Tag::kIdBucket: {
        decltype(Traits::id_bucket(input))
            in_id_bucket = Traits::id_bucket(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_id_bucket)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
            in_id_bucket, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null id_bucket in ForEventSignalBucket union");
        fragment->data.f_id_bucket.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::auction_worklet::mojom::ForEventSignalBucketDataView::Tag::kSignalBucket: {
        decltype(Traits::signal_bucket(input))
            in_signal_bucket = Traits::signal_bucket(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_signal_bucket)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::auction_worklet::mojom::SignalBucketDataView>(
            in_signal_bucket, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null signal_bucket in ForEventSignalBucket union");
        fragment->data.f_signal_bucket.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ForEventSignalBucket_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ForEventSignalBucketDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ForEventSignalValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::ForEventSignalValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::ForEventSignalValue_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::auction_worklet::mojom::ForEventSignalValueDataView::Tag::kIntValue: {
        decltype(Traits::int_value(input))
            in_int_value = Traits::int_value(input);
        fragment->data.f_int_value = in_int_value;
        break;
      }
      case ::auction_worklet::mojom::ForEventSignalValueDataView::Tag::kSignalValue: {
        decltype(Traits::signal_value(input))
            in_signal_value = Traits::signal_value(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_signal_value)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::auction_worklet::mojom::SignalValueDataView>(
            in_signal_value, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null signal_value in ForEventSignalValue union");
        fragment->data.f_signal_value.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::ForEventSignalValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::ForEventSignalValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::EventTypeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::EventTypeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::EventType_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::auction_worklet::mojom::EventTypeDataView::Tag::kReserved: {
        decltype(Traits::reserved(input))
            in_reserved = Traits::reserved(input);
        mojo::internal::Serialize<::auction_worklet::mojom::ReservedEventType>(
            in_reserved, &fragment->data.f_reserved);
        break;
      }
      case ::auction_worklet::mojom::EventTypeDataView::Tag::kNonReserved: {
        decltype(Traits::non_reserved(input))
            in_non_reserved = Traits::non_reserved(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_non_reserved)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_non_reserved, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null non_reserved in EventType union");
        fragment->data.f_non_reserved.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::EventType_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::EventTypeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::AggregatableReportContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::auction_worklet::mojom::AggregatableReportContributionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::auction_worklet::mojom::internal::AggregatableReportContribution_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::auction_worklet::mojom::AggregatableReportContributionDataView::Tag::kHistogramContribution: {
        decltype(Traits::histogram_contribution(input))
            in_histogram_contribution = Traits::histogram_contribution(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_histogram_contribution)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::AggregatableReportHistogramContributionDataView>(
            in_histogram_contribution, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null histogram_contribution in AggregatableReportContribution union");
        fragment->data.f_histogram_contribution.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::auction_worklet::mojom::AggregatableReportContributionDataView::Tag::kForEventContribution: {
        decltype(Traits::for_event_contribution(input))
            in_for_event_contribution = Traits::for_event_contribution(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_for_event_contribution)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::auction_worklet::mojom::AggregatableReportForEventContributionDataView>(
            in_for_event_contribution, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null for_event_contribution in AggregatableReportContribution union");
        fragment->data.f_for_event_contribution.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::auction_worklet::mojom::internal::AggregatableReportContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::AggregatableReportContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void BucketOffsetDataView::GetValueDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}


inline void SignalBucketDataView::GetOffsetDataView(
    BucketOffsetDataView* output) {
  auto pointer = data_->offset.Get();
  *output = BucketOffsetDataView(pointer, message_);
}




inline void AggregatableReportForEventContributionDataView::GetBucketDataView(
    ForEventSignalBucketDataView* output) {
  auto pointer = &data_->bucket;
  *output = ForEventSignalBucketDataView(pointer, message_);
}
inline void AggregatableReportForEventContributionDataView::GetValueDataView(
    ForEventSignalValueDataView* output) {
  auto pointer = &data_->value;
  *output = ForEventSignalValueDataView(pointer, message_);
}
inline void AggregatableReportForEventContributionDataView::GetEventTypeDataView(
    EventTypeDataView* output) {
  auto pointer = &data_->event_type;
  *output = EventTypeDataView(pointer, message_);
}


inline void PrivateAggregationRequestDataView::GetContributionDataView(
    AggregatableReportContributionDataView* output) {
  auto pointer = &data_->contribution;
  *output = AggregatableReportContributionDataView(pointer, message_);
}
inline void PrivateAggregationRequestDataView::GetDebugModeDetailsDataView(
    ::blink::mojom::DebugModeDetailsDataView* output) {
  auto pointer = data_->debug_mode_details.Get();
  *output = ::blink::mojom::DebugModeDetailsDataView(pointer, message_);
}


inline void ForEventSignalBucketDataView::GetIdBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) const {
  CHECK(is_id_bucket());
  *output = ::mojo_base::mojom::Uint128DataView(data_->data.f_id_bucket.Get(), message_);
}
inline void ForEventSignalBucketDataView::GetSignalBucketDataView(
    SignalBucketDataView* output) const {
  CHECK(is_signal_bucket());
  *output = SignalBucketDataView(data_->data.f_signal_bucket.Get(), message_);
}

inline void ForEventSignalValueDataView::GetSignalValueDataView(
    SignalValueDataView* output) const {
  CHECK(is_signal_value());
  *output = SignalValueDataView(data_->data.f_signal_value.Get(), message_);
}

inline void EventTypeDataView::GetNonReservedDataView(
    mojo::StringDataView* output) const {
  CHECK(is_non_reserved());
  *output = mojo::StringDataView(data_->data.f_non_reserved.Get(), message_);
}

inline void AggregatableReportContributionDataView::GetHistogramContributionDataView(
    ::blink::mojom::AggregatableReportHistogramContributionDataView* output) const {
  CHECK(is_histogram_contribution());
  *output = ::blink::mojom::AggregatableReportHistogramContributionDataView(data_->data.f_histogram_contribution.Get(), message_);
}
inline void AggregatableReportContributionDataView::GetForEventContributionDataView(
    AggregatableReportForEventContributionDataView* output) const {
  CHECK(is_for_event_contribution());
  *output = AggregatableReportForEventContributionDataView(data_->data.f_for_event_contribution.Get(), message_);
}


}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::BaseValue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::BaseValue value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::ReservedEventType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::ReservedEventType value);
};

} // namespace perfetto

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_PRIVATE_AGGREGATION_REQUEST_MOJOM_SHARED_H_